<?php
/* categories.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include ("../application.inc.php");
require_login();
require_priv("admin");

$qid = new PGM_Sql;

$DOC_TITLE = "Categories_Management";
include ("header.php");

switch (nvl($mode)) {
	case "add" :
		print_add_category_form(nvl($id, 1));
		break;

	case "edit" :
		print_edit_category_form($id);
		break;

	case "del" :
		if (!($id == 1)) {
			delete_category($id);
			if ($SESSION["frames_used"]) { ?>
			<script language="JavaScript">
			<!--
			parent.categories.location.reload();
			// -->
			</script>
			<?php }
		}
		break;

	case "insert" :
		$errors = new Object;
		$errormsg = "";
		validate_category_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		validate_special_level($HTTP_POST_VARS["special_level"], &$errors, &$errormsg);
		validate_category_description($HTTP_POST_VARS["description"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			insert_category($id, $HTTP_POST_VARS);
			if ($SESSION["frames_used"]) { ?>
			<script language="JavaScript">
			<!--
			parent.categories.location.reload();
			// -->
			</script>
			<?php }
//			print_category_list();
		} else {
			/* set default values for the reset of the fields */
			$frm = $HTTP_POST_VARS;
			$frm["parent"] = array($HTTP_POST_VARS["parent"]);
			$frm["newmode"] = "insert";
			$frm["submit_caption"] = "Add_Subcategory";
			/* build the categories listbox options, preselect the selected item */
			$qid->begin();
			build_category_tree(&$qid, &$category_options, $frm["parent"]);
			$qid->commit();
			include ("$CFG->dirroot" . "/form_header.php");
			load_category_form_template($frm, $id, $category_options, $errors);
		}
		break;

	case "update" :
		$errors = new Object;
		$errormsg = "";
		validate_category_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		validate_special_level($HTTP_POST_VARS["special_level"], &$errors, &$errormsg);
		validate_category_description($HTTP_POST_VARS["description"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			update_category($id, $HTTP_POST_VARS);
			if ($SESSION["frames_used"]) { ?>
			<script language="JavaScript">
			<!--
			parent.categories.location.reload();
			// -->
			</script>
			<?php }
		} else {
			/* set default values for the reset of the fields */
			$frm = $HTTP_POST_VARS;
			$frm["parent"] = array($HTTP_POST_VARS["parent"]);
			$frm["newmode"] = "update";
			$frm["submit_caption"] = "Save_Changes";
			/* build the categories listbox options, preselect the selected item */
			$qid->begin();
			build_category_tree(&$qid, &$category_options, $frm["parent"]);
			$qid->commit();
			include ("$CFG->dirroot" . "/form_header.php");
			load_category_form_template($frm, $id, $category_options, $errors);
		}
		break;

	case "import" :
		print_import_categories_form();
		break;

	case "update_imp" :
		if ($HTTP_POST_FILES['userfile']['tmp_name'] == "none")
			print_import_categories_form();
		else
			import_categories($HTTP_POST_FILES);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_category_list();
		break;
}

include ("footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function load_category_form_template($frm, $id, $category_options, $errors) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$t = new Template();
	$t->set_file(array("page" => "templates/category_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"frm_newmode"		=> $frm["newmode"],
		"category_id"		=> $id,
		"category_options"	=> $category_options,
		"frm_name"		=> ov($frm["name"]),
		"errors_name"		=> errmsg($errors->category_name),
		"frm_special_level"	=> $frm["special_level"],
		"errors_special_level"	=> errmsg($errors->special_level),
		"frm_description"	=> ov($frm["description"]),
		"errors_description"	=> errmsg($errors->category_description),
		"frm_submit_caption"	=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
}

function print_add_category_form($id) {
/* print a blank category form so we can add a new category */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	/* set default values for the reset of the fields */
	$frm["parent"] = array($id);
	$frm["newmode"] = "insert";
	$frm["name"] = "";
	$frm["special_level"] = "";
	$frm["description"] = "";
	$frm["submit_caption"] = "Add_Subcategory";

	/* build the categories listbox options, preselect the selected item */
	$qid->begin();
	build_category_tree(&$qid, &$category_options, $frm["parent"]);
	$qid->commit();

	load_category_form_template($frm, $id, $category_options, $errors);
}

function print_edit_category_form($id) {
/* print a category form so we can edit the selected category */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	/* load up the information for the category */
	$qid->Query("
		SELECT name, special_level, description, parent_id
		FROM categories
		WHERE id = '$id'
	");
	$qid->next_record();
	$frm["name"] = $qid->f("name");
	$frm["special_level"] = $qid->f("special_level");
	$frm["description"] = $qid->f("description");
	$frm["parent_id"] = $qid->f("parent_id");

	/* set values for the form */
	$frm["parent"] = array($frm["parent_id"]);
	$frm["newmode"] = "update";
	$frm["submit_caption"] = "Save_Changes";

	/* build the categories listbox options, preselect the selected item */
	$qid->begin();
	build_category_tree(&$qid, &$category_options, $frm["parent"]);
	$qid->commit();

	load_category_form_template($frm, $id, $category_options, $errors);
}

function delete_category($id) {
/* delete the category specified by $id, and move all the products under
 * that category to the immediate parent.  this should be wrapped inside a
 * transaction, unfortunately MySQL currently does not support transactions. */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	$qid->begin();

	/* find the parent of this category */
	$qid->Query("
		SELECT cat.name, cat.parent_id, parent.name AS parent
		FROM categories cat, categories parent
		WHERE parent.id = cat.parent_id
			AND cat.id = '$id'
	");
	$qid->next_record();
	$cat->name = $qid->f("name");
	$cat->parent_id = $qid->f("parent_id");
	$cat->parent = $qid->f("parent");

	// delete products in this category that also belong
	// to the parent category, to avoid duplicates forbidden
	// by the primary key constraint
/* Nested queries aren't still supported by MySQL :(
 *	//$qid = db_query("
 *	$qid->Query("
 *		DELETE FROM products_categories WHERE ( product_id,category_id ) IN (
 *			SELECT * FROM products_categories pc WHERE category_id = '$id' AND
 *			EXISTS (
 *				SELECT * FROM products_categories
 *				WHERE product_id = pc.product_id
 *					AND category_id = '$cat->parent_id'
 *			)
 *		)
 *	");
 * a workaround in the following */
	$qid->Query("
		SELECT pc1.product_id
		FROM products_categories pc1 , products_categories pc2
		WHERE
			pc1.product_id = pc2.product_id
			AND pc1.category_id = '$cat->parent_id'
			AND pc2.category_id = '$id'
	");
	if (($numr = $qid->num_rows()) > 0) {
		$toberemoved = "";
		for ($i=0; $i<$numr-1; $i++) {
			$qid->next_record();
			$toberemoved .= "'" . $qid->f("product_id") . "', ";
		}
		$qid->next_record();
		$toberemoved .= "'" . $qid->f("product_id") . "'";
		$qid->Query("
			DELETE FROM products_categories
			WHERE category_id = '$id' AND product_id IN ($toberemoved)
		");
	}

	/* re-assign all the products in this category to the parent category */
	$qid->Query("
		UPDATE products_categories
		SET category_id = $cat->parent_id
		WHERE category_id = '$id'
	");

	/* re-assign all sub categories of this category to the parent category */
	$qid->Query("
		UPDATE categories
		SET parent_id = $cat->parent_id
		WHERE parent_id = '$id'
	");

	/* delete this category from the categories table */
	$qid->Query("DELETE FROM categories WHERE id = '$id'");

	/* delete this category from the categories_i18n table */
	$qid->Query("DELETE FROM categories_i18n WHERE category_id = '$id'");

	$qid->commit();

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/category_deleted.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"cat_name"	=> ov($cat->name),
		"cat_parent"	=> ov($cat->parent),
		"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
}

function insert_category($id, $frm) {
/* add a new subcategory under the parent $id.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid->lock("categories");
	$qid->Query("
		INSERT INTO categories (parent_id, name, special_level, description)
		VALUES ('$frm[parent]', '$frm[name]', '$frm[special_level]', '$frm[description]')
	");
	$qid->Query("SELECT id FROM categories ORDER BY id DESC");
	$qid->next_record();
	$inserted_category_id = $qid->f("id");
	$qid->unlock();

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/category_added.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	$t->set_var(array(
		"id"		=> $inserted_category_id,
		"frm_name"	=> ov($frm[name]),
		"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
}

function update_category($id, $frm) {
/* update the category $id with new values.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid->Query("
		UPDATE categories SET
			 parent_id = '$frm[parent]'
			,name = '$frm[name]'
			,special_level = '$frm[special_level]'
			,description = '$frm[description]'
		WHERE id = '$id'
	");

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/category_updated.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"id"		=> $id,
		"frm_name"	=> ov($frm[name]),
		"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
}

function print_category_list() {
/* read all the categories from the database and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $datachanged;
//	include ($CFG->globalerror);
	global $qid;

	if (!isset($page_number) || $datachanged) {
		$qid = new PGM_Sql;
		$qid->Query("
			SELECT cat.id, cat.name, cat.special_level, cat.description, parent.name AS parent
			FROM categories cat, categories parent
			WHERE parent.id = cat.parent_id AND cat.id > 1 ORDER BY cat.name
		");
		$SESSION["numr"] = $qid->num_rows();
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$qid->next_record();
			$SESSION["categories"][$i]["id"] = $qid->f("id");
			$SESSION["categories"][$i]["name"] = $qid->f("name");
			$SESSION["categories"][$i]["special_level"] = $qid->f("special_level");
			$SESSION["categories"][$i]["description"] = $qid->f("description");
			$SESSION["categories"][$i]["parent"] = $qid->f("parent");
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["categories_per_page"]) {
		$first = ($page_number-1)*$SESSION["categories_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["categories_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["categories_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["categories_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	$t = new Template();
	$t->set_file(array("page" => "templates/category_list.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_block("page", "pages_links_top", "pages_links_top_blck");
	$t->set_var("pages_links_top_blck", "");
	$t->set_block("page", "pages_links_bottom", "pages_links_bottom_blck");
	$t->set_var("pages_links_bottom_blck", "");
	if ($num_pages > 1) {
		include ("pages_links.php");
		$t->set_var("pages_links", $pages_links);
		$t->parse("pages_links_top_blck", "pages_links_top", true);
		$t->parse("pages_links_bottom_blck", "pages_links_bottom", true);
	}
	$t->set_block("page", "category_row", "category_rows");
	$t->set_var("category_rows", "");
	for ($i=$first; $i<=$last; $i++) {
		$t->set_var(array(
			"session_categories_name"		=> ov($SESSION["categories"][$i]["name"]),
			"session_categories_id"			=> $SESSION["categories"][$i]["id"],
			"session_categories_special_level"	=> $SESSION["categories"][$i]["special_level"],
			"session_categories_parent"		=> ov($SESSION["categories"][$i]["parent"]),
			"session_categories_description"	=> ovwbr($SESSION["categories"][$i]["description"])
		));
		$t->parse("category_rows", "category_row", true);
	}
	$t->pparse("out", "page");
}

function print_import_categories_form() {
/* print the import category form so we can add/update categories from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);

	/* set values for the form */
	$frm["submit_caption"] = "Import_Button_Label";
	$frm["newmode"] = "update_imp";

	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"frm_newmode"			=> $frm["newmode"],
		"session_max_file_size_import"	=> $SESSION["max_file_size_import"],
		"frm_submit_caption"		=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
}

function import_categories($HTTP_POST_FILES) {
/* Import categories from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->globalerror);
	$errors = new Object;
	global $qid;

	/* Let's open a transaction */
	$qid->begin();

	$fcontents = file ($HTTP_POST_FILES['userfile']['tmp_name']);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
//		$fldarr = split("\",\"",ereg_replace("^\"|\"..$|\".$","",$line));
		$fldarr = split("\t",ereg_replace("\n$","",$line));
		/* Empty parent = "Top" */
		if (strlen(trim($fldarr[0])) == 0)
			$fldarr[0] = "Top";
		/* dangerous characters quoting */
		for ($i=0; $i<4; $i++)
			$fldarr[$i] = addslashes($fldarr[$i]);

		/* Let's see if the parent category exists ... */
		$qid->Query("
			SELECT id FROM categories WHERE name = '$fldarr[0]'
		");
		if ($qid->num_rows() == 0) {
			/* ... if it doesn't exist let's return an error ... */
			echo $line_num . $Err_ImpCat . $fldarr[0] . "'.<br>";
		} else {
			/* ... otherwise let's save its ID ... */
			$qid->next_record();
			$cid = $qid->f("id");

			/* ... and let's see if the category already exists ... */
			$qid->Query("SELECT id FROM categories WHERE name = '$fldarr[1]'");
			if ($qid->num_rows() == 0) {
				/* ... if it doesn't exist let's create it ... */
				$qid->Query("
					INSERT INTO categories (parent_id, name, special_level, description)
					VALUES ('$cid', '$fldarr[1]', '$fldarr[2]', '$fldarr[3]')
				");
			} else {
				/* ... otherwise let's save its ID ... */
				$qid->next_record();
				$sid = $qid->f("id");
				/* ... and update ... */
				$qid->Query("
					UPDATE categories SET
						parent_id = '$cid'
						,special_level = '$fldarr[2]'
						,description = '$fldarr[3]'
					WHERE id = '$sid'
				");
			}
		}
	}

	/* Let's close the transaction */
	$qid->commit();
	
	/* The End */
	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";
	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_end.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var("backurl", $backurl);
	$t->pparse("out", "page");
}

?>
