<?
/* cart.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

class Cart {
	var $items;		/* array of items */
	var $subtotals;		/* array of subtotals */
	var $total;		/* total of the cart */
	var $weight;		// total weight of the cart
	var $delivery;		// delivery price, it depends on the weight
	var $grandtotal;	// $grandtotal = $total + $delivery

	function Cart() {
	/* object constructor */

		$this->init();
	}

	function init() {
	/* this function is called to initialize (and reset) a shopping cart */

		$this->items = array();
		$this->subtotals = array();
		$this->total = 0;
		$this->weight = 0;
		$this->delivery = 0;
		$this->grandtotal = 0;
	}

	function add(&$productid, $qty) {
	/* add an item to the shopping cart // no, it doesn't --> and update the total price */

		if (isset($productid)) {
			setdefault($this->items[$productid], 0);
			$this->items[$productid] += $qty;
		}
	}

	function set(&$productid, $qty) {
	/* set the quantity of a product in the cart to a specified value */

		if (isset($productid)) {
			$this->items[$productid] = (int) $qty;
		}
	}

	function remove(&$productid) {
	/* this function will remove a given product from the cart */

		if (isset($productid)) {
			unset($this->items[$productid]);
		}
	}

	function cleanup() {
	/* this function will clean up the cart, removing items with invalid product
	 * id's (non-numeric ones) and products with quantities less than 1 */

		foreach ($this->items as $productid => $qty) {
			if ($qty < 1) {
				unset($this->items[$productid]);
			}
		}
	}

	function itemcount() {
	/* returns the number of individual items in the shopping cart (note, this
	 * takes into account the quantities of the items as well) */

		$count = 0;
		foreach ($this->items as $productid => $qty) {
			$count += $qty;
		}

		return $count;
	}

	function get_productid_list() {
	/* return a comma delimited list of all the products in the cart, this will
	 * be used for queries, eg. SELECT id, price FROM products WHERE id IN ....
     */

		$productid_list = "";

		foreach ($this->items as $productid => $qty) {
			$productid_list .= ",'" . $productid . "'";
		}

		/* need to strip off the leading comma */
		return substr($productid_list, 1);
	}

	function recalc_total(&$qid) {
	/* recalculate the total for the shopping cart, we will also do some cleanup
	 * and remove invalid items from the cart.  we have to query the database to
	 * get the prices, so instead of making one query for each product in the
	 * basket, we will gather up all the ID's we are interested in and run one
	 * query to get all the products we care about (using $in_clause) */

		global $SESSION;

		$this->total = 0;
		$this->weight = 0;
		$this->delivery = 0;
		$this->grandtotal = 0;

		$in_clause = $this->get_productid_list();
		if (empty($in_clause)) {
			return;
		}

//		$qid = new DB_Sql;
//		$qid = db_query("
		$qid->Query("
			SELECT p.id, p.price, p.discount, p.discqty, p.weight, i.iva
			FROM products p, iva i
			WHERE p.iva_id = i.id AND p.id IN ($in_clause)
		");
//		$numr = db_num_rows($qid);
//		for ($i=0; $i<$numr; $i++) {
		while ($qid->next_record()) {
//			$product = db_fetch_object($qid, $i);
			if ($this->items[$qid->f("id")] >= $qid->f("discqty")) {
				$this->subtotals[$qid->f("id")] = $this->items[$qid->f("id")] * $qid->f("price") * (100 - $qid->f("discount")) / 100;
			} else {
				$this->subtotals[$qid->f("id")] = $this->items[$qid->f("id")] * $qid->f("price");
			}
			if ($SESSION["iva_used"]) {
				$this->subtotals[$qid->f("id")] *= (100 + $qid->f("iva")) / 100;
			}
			$this->total += $this->subtotals[$qid->f("id")];
			$this->weight += $this->items[$qid->f("id")] * $qid->f("weight");
		}
//		$qid->close();
		if ($SESSION["delivery_used"]) {
			if ($this->weight < 10) {
				$this->delivery = 15000;
			} else if (!($this->weight > 100)) {
				$this->delivery = 25000;
			} else {
				$this->delivery = 250 * $this->weight;
//				$this->delivery = 0;
// $this->delivery = 0 denotes a too much large weight... an "error" condition
// A better functional dependence between the total weight
// and the delivery price should be implemented;
// but this surely depends on the particular web shop specifications,
// hence this fragment of code should be customized by the person
// who installs PgMarket :)
			}
		} else { $this->delivery = 0; }
		$this->grandtotal = $this->total + $this->delivery;
	}
}

?>
