<?
/* cart_view.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the 
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");

if (isset($func)) {
	switch ($func) {
		case "remove" :
			$CART->remove($product_id);
			break;

		case "empty" :
			$CART->init();
			break;

		case "recalc" :
			update_qty($HTTP_POST_VARS);
			break;
	}

	$CART->cleanup();
	$CART->recalc_total();
}

$qid = get_cart_items();

$DOC_TITLE = "Shopping_Cart";
include("$CFG->dirroot"."/header.php");

$t = new Template();
$t->set_file(array("page" => "templates/shopping_cart.ihtml"));
require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
require($CFG->localedir . $SESSION["lang"] . "/global-shopping.inc.php");
require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
$t->set_var("wwwroot", $CFG->wwwroot);
$t->set_var("ME", $ME);

$t->set_block("page", "shopping_cart_empty", "shopping_cart_empty_blck");
$t->set_var("shopping_cart_empty_blck", "");
$t->set_block("page", "shopping_cart_notempty", "shopping_cart_notempty_blck");
$t->set_var("shopping_cart_notempty_blck", "");
if ($CART->itemcount() == 0)
	$t->parse("shopping_cart_empty_blck", "shopping_cart_empty", true);
else {
	$t->set_block("shopping_cart_notempty", "weight_used_th", "weight_used_th_blck");
	$t->set_var("weight_used_th_blck", "");
	if($SESSION["weight_used"]) {
		$t->parse("weight_used_th_blck", "weight_used_th", true);
	}
	$t->set_block("shopping_cart_notempty", "cart_row", "cart_rows");
		$t->set_block("cart_row", "image_exists", "image_exists_blck");
		$t->set_block("cart_row", "iva_used", "iva_used_blck");
		$t->set_block("cart_row", "weight_used", "weight_used_blck");
	$numr = db_num_rows($qid);
	$t->set_var("cart_rows", "");
	for ($i=0; $i<$numr; $i++) {
		$t->set_var("image_exists_blck", "");
		$t->set_var("iva_used_blck", "");
		$t->set_var("weight_used_blck", "");
		$prod = db_fetch_object($qid, $i);
		$qty = $CART->items[$prod->id];
		$t->set_var(array(
				"product_id"	=> $prod->id,
				"pname"		=> ov($prod->name),
				"price"		=> $prod->price,
				"fprice"	=> formatted_price($prod->price),
				"qty"		=> $qty,
				"subtotal"	=> $CART->subtotals[$prod->id],
				"fsubtotal"	=> formatted_price($CART->subtotals[$prod->id]),
				"colspan5"	=> 5,
				"colspan7"	=> 7
			));
		if (file_exists($CFG->productsdir.string_cleanup($prod->id).".thumb.jpg")) {
			$t->set_var(array(
					"imagefilename"	=> string_cleanup($prod->id),
					"thumbwidth"	=> $prod->thumbwidth,
					"thumbheight"	=> $prod->thumbheight
			));
			$t->parse("image_exists_blck", "image_exists", true);
		}
		if ($SESSION["iva_used"]) {
			$t->set_var("iva", $prod->iva);
			$t->parse("iva_used_blck", "iva_used", true);
		}
		if($SESSION["weight_used"]) {
			$t->set_var(array(
				"weight"	=> $prod->weight,
				"fweight"	=> formatted_weight($prod->weight),
				"colspan5"	=> $t->get_var(colspan5) + 1,
				"colspan7"	=> $t->get_var(colspan7) + 1
			));
			$t->parse("weight_used_blck", "weight_used", true);
		}
		$t->parse("cart_rows", "cart_row", true);
	}
	$t->set_block("shopping_cart_notempty", "delivery_used", "delivery_used_blck");
	$t->set_var("delivery_used_blck", "");
	if ($SESSION["delivery_used"]) {
		$t->set_var(array(
				"total"		=> $CART->total,
				"ftotal"	=> formatted_price($CART->total),
				"delivery"	=> $CART->delivery,
				"fdelivery"	=> formatted_price($CART->delivery)
		));
		$t->parse("delivery_used_blck", "delivery_used", true);
	}
	$t->set_var(array(
			"grandtotal"	=> $CART->grandtotal,
			"fgrandtotal"	=> formatted_price($CART->grandtotal)
	));
	$t->parse("shopping_cart_notempty_blck", "shopping_cart_notempty", true);
}
$t->pparse("out", "page");
//include("templates/shopping_cart.ihtml");

include("$CFG->dirroot"."/footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function update_qty(&$form) {
/* update the product quantities, we are expecting them in the HTTP_POST_VARS
 * variable because the form does a POST.  the quantities are in an array
 * called $qty[] and the corresponding product id's are in $product_id[] */

	global $SESSION, $CART;

	foreach ($form["product_id"] as $i => $productid) {
		$qty = $form["qty"][$i];
		$CART->set($productid, $qty);
	}
}

?>
