<?

/* orders.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();
require_priv("admin");

$DOC_TITLE = "Orders_Log_ca";
include("header.php");

switch (nvl($mode)) {
	case "details" :
		show_order_details($id);
		break;

	case "edit" :
		print_edit_order_form($id);
		break;

	case "delete" :
		delete_order($id);
		print_order_list();
		break;

	case "update" :
		update_order($HTTP_POST_VARS);
		print_order_list();
		break;

	default :
		print_order_list();
		break;
}

include("footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function show_order_details($id) {
/* loads up the details for an order and displays it */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number;
//	include ($CFG->globalerror);

	$qid_order = db_query("
	SELECT o.*, os.name AS state_name
	FROM ordersca o, orders_states os
	WHERE o.state_id = os.id AND o.id = '$id'
	");

	if ($CFG->dbms == "pgsql") {
		$qid_items = db_query("
		SELECT
			 oi.product_id
			,p.name
			,p.price AS curr_price
			,oi.price AS purchase_price
			,oi.iva AS purchase_iva
			,oi.weight AS purchase_weight
			,oi.qty
			,oi.price * oi.qty AS total
		FROM	order_items oi, products p
		WHERE	oi.product_id = p.id AND order_id = '$id'
		UNION
		SELECT
			 oi.product_id
			,'-' as name
			,0 as curr_price
			,oi.price AS purchase_price
			,oi.iva AS purchase_iva
			,oi.weight AS purchase_weight
			,oi.qty
			,oi.price * oi.qty AS total
		FROM order_items oi
		WHERE order_id = '$id' AND
			NOT EXISTS
			(
				SELECT
					id
				FROM products
				WHERE id = oi.product_id
			)
		");
	} else if ($CFG->dbms == "mysql") {
		$qid_items = db_query("
		SELECT
			 oi.product_id
			,p.name
			,p.price AS curr_price
			,oi.price AS purchase_price
			,oi.iva AS purchase_iva
			,oi.weight AS purchase_weight
			,oi.qty
			,oi.price * oi.qty AS total
		FROM	order_items oi LEFT JOIN products p ON (oi.product_id = p.id)
		WHERE	order_id = '$id'
		");
	}

	$order = db_fetch_object($qid_order, 0);

	$qid_user = db_query("
	SELECT usertype, fiscalcode, email
	FROM users
	WHERE username = '$order->username'
	");
	$user = db_fetch_object($qid_user, 0);

	$t = new Template();
	$t->set_file(array("page" => "templates/order_details.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
			"order_id"		=> ov($id),
			"page_number"		=> $page_number,
			"order_state_name"	=> $order->state_name,
			"order_date"		=> ov($order->date),
			"order_username"	=> $order->username,
			"order_amount"		=> $order->amount,
			"order_famount"		=> formatted_price($order->amount),
			"order_custinfo"	=> nl2br(ov($order->custinfo)),
			"user_fiscalcode"	=> $user->fiscalcode,
			"user_email"		=> $user->email,
			"order_notes"		=> nl2br(ov($order->notes)),
			"order_ournotes"	=> nl2br(ov($order->ournotes))
	));
	$t->set_block("page", "usertype_pf", "usertype_pf_blck");
	$t->set_var("usertype_pf_blck", "");
	$t->set_block("page", "usertype_az", "usertype_az_blck");
	$t->set_var("usertype_az_blck", "");
	if ($user->usertype == "pf")
		$t->parse("usertype_pf_blck", "usertype_pf", true);
	else
		$t->parse("usertype_az_blck", "usertype_az", true);
	$t->set_block("page", "weight_used_th", "weight_used_th_blck");
	$t->set_var("weight_used_th_blck", "");
	if($SESSION["weight_used"])
		$t->parse("weight_used_th_blck", "weight_used_th", true);
	$t->set_block("page", "iva_used_th", "iva_used_th_blck");
	$t->set_var("iva_used_th_blck", "");
	if($SESSION["iva_used"])
		$t->parse("iva_used_th_blck", "iva_used_th", true);
	$t->set_block("page", "item_row", "item_rows");
	$t->set_var("item_rows", "");
		$t->set_block("item_row", "weight_used_tr", "weight_used_tr_blck");
		$t->set_block("item_row", "iva_used_tr", "iva_used_tr_blck");
	$numr = db_num_rows($qid_items);
	for ($i=0; $i<$numr; $i++) {
		$t->set_var("weight_used_tr_blck", "");
		$t->set_var("iva_used_tr_blck", "");
		$prod = db_fetch_object($qid_items, $i);
		$t->set_var(array(
				"prod_product_id"	=> ov($prod->product_id),
				"prod_name"		=> ov($prod->name),
				"prod_curr_price"	=> $prod->curr_price,
				"prod_curr_fprice"	=> formatted_price($prod->curr_price),
				"prod_purchase_price"	=> $prod->purchase_price,
				"prod_purchase_fprice"	=> formatted_price($prod->purchase_price),
				"prod_qty"		=> $prod->qty,
				"prod_total"		=> $prod->total,
				"prod_ftotal"		=> formatted_price($prod->total)
		));
		if($SESSION["weight_used"]) {
			$t->set_var(array(
					"prod_purchase_weight"	=> $prod->purchase_weight,
					"prod_purchase_fweight"	=> formatted_weight($prod->purchase_weight)
			));
			$t->parse("weight_used_tr_blck", "weight_used_tr", true);
		}
		if ($SESSION["iva_used"]) {
			$t->set_var("prod_purchase_iva", $prod->purchase_iva);
			$t->parse("iva_used_tr_blck", "iva_used_tr", true);
		}
		$t->parse("item_rows", "item_row", true);
	}
	$t->set_block("page", "delivery_used", "delivery_used_blck");
	$t->set_var("delivery_used_blck", "");
	if ($SESSION["delivery_used"]) {
		$t->set_var(array(
				"order_delivery"	=> $order->delivery,
				"order_fdelivery"	=> formatted_price($order->delivery)
		));
		$t->parse("delivery_used_blck", "delivery_used", true);
	}
	$t->pparse("out", "page");
//	include("templates/order_details.ihtml");
}

function print_edit_order_form($id) {
// print an order form so we can edit the selected order

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number;
//	include ($CFG->globalerror);

	$qid_order = db_query("SELECT * FROM ordersca WHERE id = '$id'");
	$frm = db_fetch_array($qid_order, 0);
	$qid_orders_states = db_query("SELECT * FROM orders_states ORDER BY name");
	$frm["order_state"] = array();
	$numr = db_num_rows($qid_orders_states);
	$frm["num_orders_states"] = $numr;
	for ($i=0; $i<$numr; $i++) {
		$order_state = db_fetch_object($qid_orders_states, $i);
		$frm["order_state"][$i]["id"] = $order_state->id;
		$frm["order_state"][$i]["name"] = $order_state->name;
	}

	if ($CFG->dbms == "pgsql") {
		$qid_items = db_query("
		SELECT
			 oi.product_id
			,p.name
			,p.price AS curr_price
			,oi.price AS purchase_price
			,oi.iva AS purchase_iva
			,oi.weight AS purchase_weight
			,oi.qty
			,oi.price * oi.qty AS total
		FROM	order_items oi, products p
		WHERE	oi.product_id = p.id AND order_id = '$id'
		UNION
		SELECT
			 oi.product_id
			,'-' as name
			,0 as curr_price
			,oi.price AS purchase_price
			,oi.iva AS purchase_iva
			,oi.weight AS purchase_weight
			,oi.qty
			,oi.price * oi.qty AS total
		FROM order_items oi
		WHERE order_id = '$id' AND
			NOT EXISTS
			(
				SELECT
					id
				FROM products
				WHERE id = oi.product_id
			)
		");
	} else if ($CFG->dbms == "mysql") {
	$qid_items = db_query("
		SELECT
			 oi.product_id
			,p.name
			,p.price AS curr_price
			,oi.price AS purchase_price
			,oi.iva AS purchase_iva
			,oi.weight AS purchase_weight
			,oi.qty
			,oi.price * oi.qty AS total
		FROM	order_items oi LEFT JOIN products p ON (oi.product_id = p.id)
		WHERE	order_id = '$id'
		");
	}

	$qid_user = db_query("
	SELECT usertype, fiscalcode, email
	FROM users
	WHERE username = '$frm[username]'
	");

	$order = db_fetch_object($qid_order, 0);
	$user = db_fetch_object($qid_user, 0);

	$frm["newmode"] = "update";
	$frm["submit_caption"] = "Save_Changes";

	$t = new Template();
	$t->set_file(array("page" => "templates/order_form.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
			"page_number"		=> $page_number,
			"frm_newmode"		=> $frm["newmode"],
			"order_id"		=> ov($id),
			"frm_date"		=> ov($frm["date"]),
			"frm_username"		=> ov($frm["username"]),
			"frm_amount"		=> $frm["amount"],
			"frm_famount"		=> formatted_price($frm["amount"]),
			"order_custinfo"	=> $order->custinfo,
			"user_fiscalcode"	=> $user->fiscalcode,
			"user_email"		=> $user->email,
			"order_notes"		=> $frm["notes"],
			"order_ournotes"	=> $frm["ournotes"],
			"frm_submit_caption"	=> $t->get_var($frm["submit_caption"])
	));
	$t->set_block("page", "order_state_option", "order_state_options");
	$t->set_var("order_state_options", "");
	for ($i=0; $i<$frm["num_orders_states"]; $i++) {
		$t->set_var(array(
				"frm_order_state_id"		=> $frm["order_state"][$i]["id"],
				"frm_order_state_selected"	=> $frm["state_id"] == $frm["order_state"][$i]["id"] ? "selected" : "",
				"frm_order_state_name"		=> $frm["order_state"][$i]["name"]
		));
		$t->parse("order_state_options", "order_state_option", true);
	}
	$t->set_block("page", "usertype_pf", "usertype_pf_blck");
	$t->set_var("usertype_pf_blck", "");
	$t->set_block("page", "usertype_az", "usertype_az_blck");
	$t->set_var("usertype_az_blck", "");
	if ($user->usertype == "pf")
		$t->parse("usertype_pf_blck", "usertype_pf", true);
	else
		$t->parse("usertype_az_blck", "usertype_az", true);
	$t->set_block("page", "weight_used_th", "weight_used_th_blck");
	$t->set_var("weight_used_th_blck", "");
	if($SESSION["weight_used"])
		$t->parse("weight_used_th_blck", "weight_used_th", true);
	$t->set_block("page", "iva_used_th", "iva_used_th_blck");
	$t->set_var("iva_used_th_blck", "");
	if($SESSION["iva_used"])
		$t->parse("iva_used_th_blck", "iva_used_th", true);
	$t->set_block("page", "item_row", "item_rows");
	$t->set_var("item_rows", "");
		$t->set_block("item_row", "weight_used_tr", "weight_used_tr_blck");
		$t->set_block("item_row", "iva_used_tr", "iva_used_tr_blck");
	$numr = db_num_rows($qid_items);
	for ($i=0; $i<$numr; $i++) {
		$t->set_var("weight_used_tr_blck", "");
		$t->set_var("iva_used_tr_blck", "");
		$prod = db_fetch_object($qid_items, $i);
		$t->set_var(array(
				"prod_product_id"	=> ov($prod->product_id),
				"prod_name"		=> ov($prod->name),
				"prod_curr_price"	=> $prod->curr_price,
				"prod_curr_fprice"	=> formatted_price($prod->curr_price),
				"prod_purchase_price"	=> $prod->purchase_price,
				"prod_purchase_fprice"	=> formatted_price($prod->purchase_price),
				"prod_qty"		=> $prod->qty,
				"prod_total"		=> $prod->total,
				"prod_ftotal"		=> formatted_price($prod->total)
		));
		if($SESSION["weight_used"]) {
			$t->set_var(array(
					"prod_purchase_weight"	=> $prod->purchase_weight,
					"prod_purchase_fweight"	=> formatted_weight($prod->purchase_weight)
			));
			$t->parse("weight_used_tr_blck", "weight_used_tr", true);
		}
		if ($SESSION["iva_used"]) {
			$t->set_var("prod_purchase_iva", $prod->purchase_iva);
			$t->parse("iva_used_tr_blck", "iva_used_tr", true);
		}
		$t->parse("item_rows", "item_row", true);
	}
	$t->set_block("page", "delivery_used", "delivery_used_blck");
	$t->set_var("delivery_used_blck", "");
	if ($SESSION["delivery_used"]) {
		$t->set_var(array(
				"order_delivery"	=> $order->delivery,
				"order_fdelivery"	=> formatted_price($order->delivery)
		));
		$t->parse("delivery_used_blck", "delivery_used", true);
	}
	$t->pparse("out", "page");
//	include("templates/order_form.ihtml");
}

function delete_order($id) {
// cancella un ordine

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$qid = db_begin();
	$qid = db_query("DELETE FROM ordersca WHERE id = '$id'");
	$qid = db_query("DELETE FROM order_items WHERE order_id = '$id'");
	$qid = db_commit();

	$t = new Template();
	$t->set_file(array("page" => "templates/order_deleted.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	$t->set_var("order_id", ov($id));
	$t->pparse("out", "page");
//	include("templates/order_deleted.ihtml");
}

function update_order($frm) {
// update the order record in the database

	$qid = db_query("
	UPDATE ordersca SET
		 custinfo = '$frm[custinfo]'
		,notes = '$frm[notes]'
		,ournotes = '$frm[ournotes]'
		,state_id = '$frm[state_id]'
	WHERE id = '$frm[id]'
	");
}

function print_order_list() {
/* reads a list of orders from the database and displays them, we will use
 * a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number, $dbchanged;
//	include ($CFG->globalerror);

	if (!isset($page_number) || $dbchanged) {
		$qid = db_query("
		SELECT o.id, o.username, o.date, o.custinfo, o.amount, o.notes, os.name AS state_name
		FROM ordersca o, orders_states os
		WHERE o.state_id = os.id
		ORDER BY os.name, o.id ASC
  		");

		$SESSION["numr"] = db_num_rows($qid);
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$SESSION["ordersca"][$i] = db_fetch_array($qid, $i);
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["orders_per_page"]) {
		$first = ($page_number-1)*$SESSION["orders_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["orders_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["orders_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["orders_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	$t = new Template();
	$t->set_file(array("page" => "templates/orderca_list.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_block("page", "pages_links_top", "pages_links_top_blck");
	$t->set_var("pages_links_top_blck", "");
	$t->set_block("page", "pages_links_bottom", "pages_links_bottom_blck");
	$t->set_var("pages_links_bottom_blck", "");
	if ($num_pages > 1) {
		require("pages_links.php");
		$t->set_var("pages_links", $pages_links);
		$t->parse("pages_links_top_blck", "pages_links_top", true);
		$t->parse("pages_links_bottom_blck", "pages_links_bottom", true);
	}
	$t->set_block("page", "order_row", "order_rows");
	$t->set_var("brand_rows", "");
	for ($i=$first; $i<=$last; $i++) {
		$t->set_var(array(
				"page_number"			=> $page_number,
				"session_order_id"		=> ov($SESSION["ordersca"][$i]["id"]),
				"session_order_state_name"	=> ov($SESSION["ordersca"][$i]["state_name"]),
				"session_order_username"	=> ov($SESSION["ordersca"][$i]["username"]),
				"session_order_date"		=> ov($SESSION["ordersca"][$i]["date"]),
				"session_order_custinfo"	=> ovwbr($SESSION["ordersca"][$i]["custinfo"]),
				"session_order_amount"		=> $SESSION["ordersca"][$i]["amount"],
				"session_order_famount"		=> formatted_price($SESSION["ordersca"][$i]["amount"])
		));
		$t->parse("order_rows", "order_row", true);
	}
	$t->pparse("out", "page");
//	include("templates/orderca_list.ihtml");
}

?>
