<?
/* (c) 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */
/* with contribution for the script structure 
   from categories.php (c) 2000 Ying Zhang (ying@zippydesign.com) */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();
require_priv("admin");

$DOC_TITLE = "Orders_States_Management";
include("header.php");

switch (nvl($mode)) {
	case "add" :
		print_add_order_state_form();
		break;

	case "edit" :
		if (!($id == 0))
			print_edit_order_state_form($id);
		break;

	case "del" :
		if (!($id == 0))
			delete_order_state($id);
		break;

	case "insert" :
		$errors = new Object;
		$errormsg = "";
		validate_order_state_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		validate_order_state_description($HTTP_POST_VARS["description"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			insert_order_state($HTTP_POST_VARS);
		} else {
			/* set default values for the reset of the fields */
			$frm["newmode"] = "insert";
			$frm["name"] = $HTTP_POST_VARS["name"];
			$frm["description"] = $HTTP_POST_VARS["description"];
			$frm["submit_caption"] = "Add_Order_State";
			include("$CFG->dirroot"."/form_header.php");
			load_order_state_form_template($frm, $id, $errors);
		}
		break;

	case "update" :
		if ($id == 0)
			break;
		$errors = new Object;
		$errormsg = "";
		validate_order_state_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		validate_order_state_description($HTTP_POST_VARS["description"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			update_order_state($id, $HTTP_POST_VARS);
		} else {
			/* set default values for the reset of the fields */
			$frm["newmode"] = "update";
			$frm["name"] = $HTTP_POST_VARS["name"];
			$frm["description"] = $HTTP_POST_VARS["description"];
			$frm["submit_caption"] = "Save_Changes";
			include("$CFG->dirroot"."/form_header.php");
			load_order_state_form_template($frm, $id, $errors);
		}
		break;

	case "import" :
		print_import_orders_states_form();
		break;

	case "update_imp" :
		if ($userfile == 'none')
			print_import_orders_states_form();
		else
			import_orders_states($userfile);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_orders_states_list();
		break;
}

include("footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function load_order_state_form_template($frm, $id, $errors) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$t = new Template();
	$t->set_file(array("page" => "templates/order_state_form.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
			"frm_newmode"		=> $frm["newmode"],
			"order_id"		=> $id,
			"frm_name"		=> ov($frm["name"]),
			"errors_name"		=> errmsg($errors->order_state_name),
			"frm_description"	=> ov($frm["description"]),
			"errors_description"	=> errmsg($errors->order_state_description),
			"frm_submit_caption"	=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
//	include("templates/order_state_form.ihtml");
}

function print_add_order_state_form() {
/* print a blank order state form so we can add a new order state */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	/* set default values for the reset of the fields */
	$frm["newmode"] = "insert";
	$frm["name"] = "";
	$frm["description"] = "";
	$frm["submit_caption"] = "Add_Order_State";

	load_order_state_form_template($frm, $id, $errors);
}

function print_edit_order_state_form($id) {
/* print an order state form so we can edit the selected order state */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	/* load up the information for the order state */
	$qid = db_query("
	SELECT name, description
	FROM orders_states
	WHERE id = '$id'
	");
	$frm = db_fetch_array($qid, 0);

	/* set values for the form */
	$frm["newmode"] = "update";
	$frm["submit_caption"] = "Save_Changes";

	load_order_state_form_template($frm, $id, $errors);
}

function delete_order_state($id) {
// delete the order state specified by $id, and reset to 0
// the order state_id for all orders in this state

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	if ($id > 0) {
		$qid = db_begin();

		/* find out this order state name */
		$qid = db_query("
		SELECT name FROM orders_states
		WHERE id = '$id'
		");
		$frm = db_fetch_array($qid, 0);

		/* delete this order state */
		$qid = db_query("
		DELETE FROM orders_states
		WHERE id = '$id'
		");

		// reset to 0 the state_id for all orders in this state
		$qid = db_query("
		UPDATE ordersca SET state_id = 0 WHERE state_id = '$id'
		");
		$qid = db_query("
		UPDATE orderscc SET state_id = 0 WHERE state_id = '$id'
		");

		$qid = db_commit();

		if (empty($SESSION["goback"]["query_string"]))
			$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
		else
			$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";

		$t = new Template();
		$t->set_file(array("page" => "templates/order_state_deleted.ihtml"));
		require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
		require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
		$t->set_var(array(
				"frm_name"	=> ov($frm[name]),
				"backurl"	=> $backurl
		));
		$t->pparse("out", "page");
//		include("templates/order_state_deleted.ihtml");
	} else print_orders_states_list();
}

function insert_order_state($frm) {
/* add a new order state.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid = db_query("
	INSERT INTO orders_states (name, description)
	VALUES ('$frm[name]', '$frm[description]')
	");

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/order_state_added.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var(array(
			"frm_name"	=> ov($frm[name]),
			"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
//	include("templates/order_state_added.ihtml");
}

function update_order_state($id, $frm) {
/* update the order_state $id with new values.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid = db_query("
	UPDATE orders_states SET
		name = '$frm[name]'
		,description = '$frm[description]'
	WHERE id = '$id'
	");

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/order_state_updated.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var(array(
			"frm_name"	=> ov($frm[name]),
			"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
//	include("templates/order_state_updated.ihtml");
}

function print_orders_states_list() {
/* read all the order states from the database and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $dbchanged;
//	include ($CFG->globalerror);

	if (!isset($page_number) || $dbchanged) {
		$qid = db_query("
		SELECT id, name, description
		FROM orders_states
		WHERE id > 0
		ORDER BY name
		");

		$SESSION["numr"] = db_num_rows($qid);
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$SESSION["order_state"][$i] = db_fetch_array($qid, $i);
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["orders_states_per_page"]) {
		$first = ($page_number-1)*$SESSION["orders_states_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["orders_states_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["orders_states_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["orders_states_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	$t = new Template();
	$t->set_file(array("page" => "templates/order_state_list.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_block("page", "pages_links_top", "pages_links_top_blck");
	$t->set_var("pages_links_top_blck", "");
	$t->set_block("page", "pages_links_bottom", "pages_links_bottom_blck");
	$t->set_var("pages_links_bottom_blck", "");
	if ($num_pages > 1) {
		require("pages_links.php");
		$t->set_var("pages_links", $pages_links);
		$t->parse("pages_links_top_blck", "pages_links_top", true);
		$t->parse("pages_links_bottom_blck", "pages_links_bottom", true);
	}
	$t->set_block("page", "order_state_row", "order_state_rows");
	$t->set_var("order_state_rows", "");
	for ($i=$first; $i<=$last; $i++) {
		$t->set_var(array(
				"session_order_state_name"		=> ov($SESSION["order_state"][$i]["name"]),
				"session_order_state_id"		=> ov($SESSION["order_state"][$i]["id"]),
				"session_order_state_description"	=> ovwbr($SESSION["order_state"][$i]["description"])
		));
		$t->parse("order_state_rows", "order_state_row", true);
	}
	$t->pparse("out", "page");
//	include("templates/order_state_list.ihtml");
}

function print_import_orders_states_form() {
/* print the import order states form so we can add/update order states from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);

	/* set values for the form */
	$frm["submit_caption"] = "Import_Button_Label";
	$frm["newmode"] = "update_imp";

	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_form.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
			"frm_newmode"			=> $frm["newmode"],
			"session_max_file_size_import"	=> $SESSION["max_file_size_import"],
			"frm_submit_caption"		=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
//	include("templates/data_import_form.ihtml");
}

function import_orders_states($userfile) {
/* Import order states from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);
	$errors = new Object;

	$qid = db_begin();

	$fcontents = file ($userfile);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
//		$fldarr = split("\",\"",ereg_replace("^\"|\"..$|\".$","",$line));
		$fldarr = split("\t",ereg_replace("\n$","",$line));
		/* dangerous characters quoting */
		for ($i=0; $i<2; $i++)
			$fldarr[$i] = addslashes($fldarr[$i]);

		/* ... and let's see if the state already exists ... */
		$qid = db_query("
		SELECT id, name FROM orders_states WHERE name = '$fldarr[0]'
		");
		if (db_num_rows($qid) == 0) {
			/* ... if it doesn't exist let's create it ... */
			$qid = db_query("
			INSERT INTO orders_states (name, description)
			VALUES ('$fldarr[0]', '$fldarr[1]')
			");
		} else {
			/* ... otherwise let's save its ID ... */
			$arr = db_fetch_array($qid,0);
			$sid = $arr[0];
			/* ... and update ... */
			$qid = db_query("
			UPDATE orders_states SET
				description = '$fldarr[1]'
			WHERE id = '$sid'
			");
		}
	}

	/* Let's close the transaction */
	$qid = db_commit();

	/* The End */
	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";
	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_end.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var("backurl", $backurl);
	$t->pparse("out", "page");
//	include("templates/data_import_end.ihtml");

}

?>
