/*
	disabledb.sql

	Removes the db schema from a pgjobs-enabled database.
	Invoke through: pgjobs disabledb ...

	Project: pgjobs
	Author:  Zlatko Michailov
	Created: 19-Dec-2003
	Updated: 17-Jan-2004
	Updated: 18-Jan-2004
	Updated: 25-Jan-2004
	Updated: 13-May-2004
	Updated: 21-May-2004
	Updated: 24-May-2004

	This file is provided as is, with no warranty. Use at your own risk.

	Copyright (c) 2003-2004, Zlatko Michailov

*/



--------------------------------------------------------------------------------



------------------------------------------------
-- Triggerring
------------------------------------------------
drop view pgj_jobs_startup;
drop view pgj_jobs_up;

drop function pgj_startup();
drop function pgj_trigger_seconds();
drop function pgj_trigger_time();
drop function pgj_recompute_schedules();



------------------------------------------------
-- Schedule views and functions
------------------------------------------------
drop view pgj_schedules;

drop function pgj_make_schedule( char, smallint, smallint, smallint, smallint, smallint );
drop function pgj_create_update_schedule( text, text, boolean );
drop function pgj_create_schedule( text, text );
drop function pgj_update_schedule( text, text );
drop function pgj_drop_schedule( text, boolean );
drop function pgj_drop_schedule( text );
drop function pgj_drop_unused_schedules();
drop function pgj_schedule_trigger_time( timestamp, timestamp, char, smallint, smallint,
										smallint, smallint, smallint );
drop function pgj_schedule_trigger_timeDW( timestamp, char, smallint, smallint,
										smallint, smallint, smallint );
drop function pgj_schedule_trigger_timeI( timestamp, timestamp, smallint, smallint, smallint );
drop function pgj_interval_to_minutes( interval );
drop function pgj_interval_to_seconds( interval );
drop function pgj_schedule_to_interval( smallint, smallint,	smallint );



------------------------------------------------
-- Job views and functions
------------------------------------------------
drop view pgj_jobs;

drop function pgj_create_job( text, text, text, text );
drop function pgj_update_job( text, text, text, text );
drop function pgj_add_drop_job_schedule( text, text, boolean );
drop function pgj_add_job_schedule( text, text );
drop function pgj_drop_job_schedule( text, text );
drop function pgj_drop_job( text );
drop function pgj_create_startup_job( text, text );



------------------------------------------------
-- Tables and sequences
------------------------------------------------
drop table pgj_settings_;
drop table pgj_trigger_;

drop table pgj_job_schedule_;
drop table pgj_job_;
drop table pgj_schedule_;

drop sequence pgj_schedule__schid_seq;
drop sequence pgj_job__jobid_seq;


