package components.user;
import components.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.awt.*;
import pgclibrary.utilities.*;

/**
 *
 * @author  nestor
 */
public class UserPanel extends JTabbedPane {
    User user_object = null;
    
    JTextField name = new JTextField(20);
    JTextField validlimit = new JTextField(20);
    JTextField dbcreator = new JTextField(20);
    JTextField superuser = new JTextField(20);
    JTextField traceuser = new JTextField(20);
    
    JTextArea sql = new JTextArea();
    
    /** Creates a new instance of DatabasePanel */
    public UserPanel() {
        initPanel();
        setPreferredSize(this.getMinimumSize());
    }
    
    public void setUser(User _user_object){
        user_object = _user_object;
        refreshProperties();
    }
    
    private void initPanel(){
        setBorder(new EmptyBorder(10,10,10,10));
        insertDefaultTab();
    }
    
    public void refreshProperties(){
        refreshDefaultPanel();
    }
    
    private void insertDefaultTab() {
        name.setEditable(false);
        validlimit.setEditable(false);
        dbcreator.setEditable(false);
        superuser.setEditable(false);
        traceuser.setEditable(false);
        
        JSplitPane panel = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        panel.setOneTouchExpandable(true);
        panel.setResizeWeight(0.5);
        
        sql.setEditable(false);
        panel.setBottomComponent(new JScrollPane(sql));
        
        JPanel general_panel = new JPanel();
        general_panel.setLayout(new BoxLayout(general_panel, BoxLayout.Y_AXIS));
        general_panel.add(SUtilities.getHorPanel("User Name :", name));
        general_panel.add(SUtilities.getHorPanel("Valid Until :", validlimit));
        general_panel.add(SUtilities.getHorPanel("Is DB Creator :", dbcreator));
        general_panel.add(SUtilities.getHorPanel("Is Super User :", superuser));
        general_panel.add(SUtilities.getHorPanel("Is Trace User :", traceuser));

        
        panel.setTopComponent(SUtilities.centerComponent(general_panel));
        addTab("General", panel);
    }
    
    private void refreshDefaultPanel(){
        name.setText(user_object.getName());
        sql.setText(user_object.getInsertSQL());
        validlimit.setText(Utilities.formatDate(user_object.getValidLimit(), Utilities.FORMAT_DATETIME));
        dbcreator.setText(Utilities.formatBoolean(user_object.isDBCreateor()));
        superuser.setText(Utilities.formatBoolean(user_object.isSuperUser()));
        traceuser.setText(Utilities.formatBoolean(user_object.isTraceUser()));
        
        repaint();
    }
}


