/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.treeObjects;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import pgclibrary.objects.Database;
import pgclibrary.objects.User;
import pgclibrary.treeObjects.Element;
import pgclibrary.treeObjects.RootElement;
import pgclibrary.treeObjects.TreeInfo;

public class UserList
extends TreeInfo {
    public UserList(RootElement source) {
        super(source);
        this.setIcon("/images/user.png");
    }

    public void rebuildProperties() {
        this.removeAllProperties();
        try {
            PreparedStatement prep = this.getConnection().prepareStatement("SELECT * FROM PG_USER ORDER BY USENAME");
            ResultSet rs = prep.executeQuery();
            while (rs.next()) {
                this.addProperty(new Element(this, new User(this.getDatabase(), rs.getLong("USESYSID"))));
            }
            rs.close();
            prep.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Object getOID() {
        return this.toString();
    }

    public String toString() {
        return "Users";
    }

    public Database getDatabase() {
        return ((RootElement)this.getOwner()).getDatabase();
    }
}

