/*
 * dataSourceVector.java
 *
 * Created on 14 de septiembre de 2001, 11:16
 */

package pgclibrary.dataaccess;

import java.text.*;
import java.sql.*;
import java.util.*;

/** Implementa un origen de datos que se basa en una matriz (Vector de Vector).
 * \u00c9ste origen puede ser usado en cualquier tabla, gr\u00e1fico o consulta.
 *
 * Para comprender los m\u00e9todos vea dataSource
 * @author NMarsollier
 * @version
 */
public class dataSourceVector extends dataSource {
    SimpleDateFormat espFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
    
    private Vector data = new Vector();
    private int pos = 0;
    private Vector column_sizes = new Vector();
    
    public dataSourceVector() {
        goTop();
    }
    
    /** Cierra el objeto correctamente limpiando los datos.
     * @return Devuelve false si se ha llegado al ultimo registro.
     */
    public void close() {
        data = new Vector();
    }
    
    protected Vector getData(){
        return data;
    }
    
    /** Crea un nuevo origen de datos y como como informaci\u00f3n base al vector que se
     * pasa.
     * @param _data
     */
    public dataSourceVector(Vector _data){
        setVector(_data);
    }
    
    /** Devuelve la cantidad de filas que tiene.
     * @return
     */
    public int getRowCount(){
        return data.size();
    }
    
    public void setVector(Vector _data){
        if (_data != null){
            data = _data;
        }
        goTop();
    }
    
    public void goTop(){
        pos = 0;
        if(isFiltered()){
            pos = getRowBegin();
        }
        super.setRowNum(pos+1);
    }
    
    public boolean next(){
        boolean retorno = false;
        if (!eof()){
            pos ++;
            retorno = !eof();
            super.setRowNum(pos+1);
        }
        return retorno;
    }
    
    public boolean eof(){
        boolean retorno = false;
        retorno = data.size() < pos;
        if(!retorno && isFiltered()){
            retorno = getRowEnd() < pos;
        }
        return retorno;
    }
    
    public String getElementAt(int _col){
        String resultado = new String();
        
        Vector temp = (Vector) data.elementAt(pos);
        Object res = temp.elementAt(_col-1);
        
        if (res.getClass() == java.util.Date.class) {
            resultado = espFormat.format(res);
        } else {
            resultado = res.toString();
        }
        return resultado;
    }
    
    public int getColumnCount(){
        return getColumnNames().size();
    }
    
    public void removeElements(){
        data.removeAllElements();
    }
    public void addElement(Vector _element) {
        if(_element != null){
            int cols = getColumnCount();
            if(((cols > 0) && (_element.size() == cols))
            || (cols == 0)) {
                data.add(_element);
            }
        }
    }
    public void removeElementAt(int _elem) {
        data.removeElementAt(_elem);
    }
    
    public void addColumnSize(int _size){
        column_sizes.add(new Integer(_size));
    }
    
    public int getColumnSize(int _col) {
        int retorno = 0;
        
        if(_col <= getColumnCount()){
            if(_col <= column_sizes.size()){
                retorno =  ((Integer) column_sizes.get(_col-1)).intValue();
            } else {
                retorno = ((String) getColumnNames().get(_col)).length();
            };
        }
        
        return validateColumnSize(retorno);
    }
}
