/*
 * Decompiled with CFR 0.152.
 */
package components.view;

import components.view.ColumnPanel;
import components.view.DataPanel;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pgclibrary.objects.View;
import pgclibrary.utilities.SUtilities;

public class ViewPanel
extends JTabbedPane {
    View view_object = null;
    JTextField oid = new JTextField(20);
    JTextField name = new JTextField(20);
    JTextField owner = new JTextField(20);
    JTextArea description = new JTextArea(3, 20);
    DataPanel data_panel = new DataPanel();
    ColumnPanel column_panel = new ColumnPanel();
    JTextArea sql = new JTextArea();

    public ViewPanel() {
        this.initPanel();
        this.setPreferredSize(this.getMinimumSize());
    }

    public void setView(View _view_object) {
        this.view_object = _view_object;
        this.refreshProperties();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.insertDefaultTab();
        this.addTab("Columns", this.column_panel);
        this.addTab("Data", this.data_panel);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ViewPanel.this.refreshProperties();
            }
        });
    }

    public void refreshProperties() {
        switch (this.getSelectedIndex()) {
            case 0: {
                this.refreshDefaultPanel();
                break;
            }
            case 1: {
                this.column_panel.refresh(this.view_object);
                break;
            }
            case 2: {
                this.data_panel.refresh(this.view_object);
            }
        }
    }

    private void insertDefaultTab() {
        this.oid.setEditable(false);
        this.name.setEditable(false);
        this.owner.setEditable(false);
        this.description.setEditable(false);
        this.description.setBorder(this.owner.getBorder());
        this.description.setBackground(this.owner.getBackground());
        this.description.setLineWrap(true);
        JScrollPane dpane = new JScrollPane(this.description);
        dpane.setPreferredSize(this.description.getPreferredSize());
        JSplitPane panel = new JSplitPane(0);
        panel.setOneTouchExpandable(true);
        panel.setResizeWeight(0.5);
        this.sql.setEditable(false);
        this.sql.setLineWrap(true);
        panel.setBottomComponent(new JScrollPane(this.sql));
        JPanel general_panel = new JPanel();
        general_panel.setLayout(new BoxLayout(general_panel, 1));
        general_panel.add(SUtilities.getHorPanel("View ID :", this.oid));
        general_panel.add(SUtilities.getHorPanel("View Name :", this.name));
        general_panel.add(SUtilities.getHorPanel("View Owner :", this.owner));
        general_panel.add(SUtilities.getHorPanel("Description :", dpane));
        panel.setTopComponent(SUtilities.centerComponent(general_panel));
        this.addTab("General", panel);
    }

    private void refreshDefaultPanel() {
        this.oid.setText(String.valueOf(this.view_object.getOID()));
        this.name.setText(this.view_object.getName());
        this.owner.setText(this.view_object.getCreator().getName());
        this.sql.setText(this.view_object.getInsertSQL());
        this.description.setText(this.view_object.getDescription());
        this.repaint();
    }
}

