/*
 * DataPanelOrderDialog.java
 *
 * Created on 31 de julio de 2002, 17:22
 */

package components.table;
import components.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import pgclibrary.dataaccess.*;
import pgclibrary.objects.*;
import pgclibrary.utilities.*;

/**
 *
 * @author  nestor
 */
public class DataPanelOrderDialog extends JDialog{
    DataPanel table_panel = null;
    JList columns = new JList();
    JList columns1  = new JList();
    DataPanelOrderDialogListener listener = null;
    
    /** Creates a new instance of DataPanelOrderDialog */
    public DataPanelOrderDialog(DataPanel _table_panel) {
        super((Frame)null, "Change table order");
        table_panel = _table_panel;
        listener = new DataPanelOrderDialogListener(this);
        
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        
        addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent e) {
                close();
            }});
            
            getContentPane().add(getContents(), BorderLayout.CENTER);
            getContentPane().add(getButtons(), BorderLayout.SOUTH);
            
            setModal(true);
            pack();
    }
    
    private void initComponents(){
        DefaultListModel model = new DefaultListModel();
        DefaultListModel model1 = new DefaultListModel();
        
        for(int i=0; i<table_panel.getTable().getColumns().size(); i++){
            String name = ((TableColumn) table_panel.getTable().getColumns().get(i)).getName();
            if(table_panel.getOrderPos(name) > 0){
                model1.addElement(name);
            } else {
                model.addElement(name);
            }
        }
        
        columns.setModel(model);
        columns1.setModel(model1);
        
        columns.addMouseListener(new MouseAdapter(){
                public void mouseClicked(MouseEvent evt){
                    if(evt.getClickCount() == 2){
                        addSelection();
                    }
                }
            }
        );
        columns1.addMouseListener(new MouseAdapter(){
                public void mouseClicked(MouseEvent evt){
                    if(evt.getClickCount() == 2){
                        removeSelection();
                    }
                }
            }
        );
    }
    
    private Component getContents(){
        initComponents();
        
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
        panel.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, BoxLayout.Y_AXIS));
        panel1.add(new JLabel("Columns"));
        panel1.add(new JScrollPane(columns));
        panel1.setPreferredSize(new Dimension(200, 200));
        
        JToggleButton left = new JToggleButton(new ImageIcon("images/left.png"));
        left.setToolTipText("Removes selected orders");
        left.setActionCommand(listener.AC_REMSEL);
        left.addActionListener(listener);
        JButton right = new JButton(new ImageIcon("images/right.png"));
        right.setToolTipText("Add selected orders");
        right.setActionCommand(listener.AC_ADDSEL);
        right.addActionListener(listener);
        
        JPanel panel2 = new JPanel();
        panel2.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        panel2.setLayout(new BoxLayout(panel2, BoxLayout.Y_AXIS));
        panel2.add(SUtilities.resizeComponent(right));
        panel2.add(SUtilities.resizeComponent(left));
        
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, BoxLayout.Y_AXIS));
        panel3.add(new JLabel("Order by"));
        panel3.add(new JScrollPane(columns1));
        panel3.setPreferredSize(new Dimension(200, 200));
        
        panel.add(panel1);
        panel.add(panel2);
        panel.add(panel3);
        return panel;
    }
    
    private Component getButtons(){
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
        
        panel.add(Box.createHorizontalGlue());
        
        JButton okey = new JButton("Acept");
        okey.setActionCommand(DataPanelOrderDialogListener.AC_OKEY);
        okey.addActionListener(listener);
        panel.add(okey);
        
        panel.add(Box.createHorizontalStrut(5));
        
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand(DataPanelOrderDialogListener.AC_CANCEL);
        cancel.addActionListener(listener);
        panel.add(cancel);
        
        panel.add(Box.createHorizontalGlue());
        
        return panel;
    }
    
    public void addSelection(){
        Object[] elements = columns.getSelectedValues();
        for(int i=0; i<elements.length; i++){
            ((DefaultListModel ) columns.getModel()).removeElement(elements[i]);
            ((DefaultListModel ) columns1.getModel()).addElement(elements[i]);
        }
    }
    public void removeSelection(){
        Object[] elements = columns1.getSelectedValues();
        for(int i=0; i<elements.length; i++){
            ((DefaultListModel ) columns1.getModel()).removeElement(elements[i]);
            ((DefaultListModel ) columns.getModel()).addElement(elements[i]);
        }
    }
    
    protected void acept(){
        table_panel.clearOrder();
        for(int i= 0; i<columns1.getModel().getSize(); i++){
            table_panel.addOrder((String) columns1.getModel().getElementAt(i));
        }
        table_panel.refresh();
        close();
    }
    protected void close(){
        dispose();
    }
}


class DataPanelOrderDialogListener implements ActionListener {
    public static final String AC_OKEY = "okey";
    public static final String AC_CANCEL = "cancel";
    public static final String AC_ADDSEL = "add";
    public static final String AC_REMSEL = "remove";
    
    private DataPanelOrderDialog frame = null;
    
    /** Creates a new instance of PrincipalFrame_listener */
    public DataPanelOrderDialogListener(DataPanelOrderDialog _frame){
        frame = _frame;
    }
    
    public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
        if(actionEvent.getActionCommand().equals(AC_CANCEL)){
            frame.close();
        }
        if(actionEvent.getActionCommand().equals(AC_OKEY)){
            frame.acept();
        }
        if(actionEvent.getActionCommand().equals(AC_ADDSEL)){
            frame.addSelection();
        }
        if(actionEvent.getActionCommand().equals(AC_REMSEL)){
            frame.removeSelection();
        }
    }
}

