/*
 * SQLTableModel.java
 *
 * Created on 19 de julio de 2002, 13:15
 */

package components;
import javax.swing.table.*;
import pgclibrary.dataaccess.*;
import java.sql.*;
import javax.swing.event.*;
import java.awt.*;

/**
 *
 * @author  nestor
 */
public class SQLTableModel extends AbstractTableModel {
    private SQLTable table = null;
    private dataSource data = null;
    private int column_count = -1;
    
    public SQLTableModel(SQLTable _table) {
        table = _table;
    }
    
    public int getColumnCount() {
        int retorno = 0;
        if(isValid()) {
            retorno = data.getColumnCount() ;
            if ((column_count > 0) 
                    && (column_count <= retorno)){
                  retorno = column_count;
            }
        }
        return retorno;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex){
        return false;
    }
    
    public int getRowCount() {
        int retorno = 0;
        if(isValid()){
            retorno = data.getRowCount();
        }
        return retorno;
    }
    
    public Object getValueAt(int param, int param1) {
        Object retorno = new String();
        if(isValid()){
            data.moveToRecord(param+ 1);
            retorno = data.getElementAt(param1 + 1);
        }
        return retorno;
    }
    
    public String getColumnName(int column){
        String retorno = new String();
        if(isValid()){
            retorno = (String) data.getColumnNames().get(column);
        }
        return retorno;
    }
    
    //  ---- GET AND SET METHODS  ----
    public void showColumns(int _column){
        column_count = _column;
    }
    
    public void setDataSource(dataSource _data){
        if(data!= null){
            data.close();
        }
        data = _data;
        refresh();
    }
    
    private void refresh(){
        fireTableStructureChanged();
        fireTableDataChanged();
        if(data != null){
            FontMetrics fm = table.getFontMetrics(table.getFont());
            int size = fm.charWidth('O');
            for(int i=0; i<data.getColumnCount(); i++){
                TableColumn tmp = table.getColumnModel().getColumn(i);
                int col_size = data.getColumnSize(i+1);
                if(col_size > 30) {
                    col_size = 30;
                }
                tmp.setPreferredWidth(col_size * size);
            }
        }
    }
    
    public dataSource getDataSource(){
        return data;
    }
    
    private boolean isValid(){
        return data != null;
    }
}
