VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "msflxgrd.ocx"
Begin VB.Form frmGroups 
   Caption         =   "Groups"
   ClientHeight    =   3195
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5595
   Icon            =   "frmGroups.frx":0000
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   3195
   ScaleWidth      =   5595
   Begin VB.CommandButton cmdRefresh 
      Caption         =   "&Refresh"
      Height          =   330
      Left            =   45
      TabIndex        =   4
      ToolTipText     =   "Refresh the list of users"
      Top             =   2835
      Width           =   1170
   End
   Begin VB.CommandButton cmdDrop 
      Caption         =   "&Drop Group"
      Height          =   330
      Left            =   1305
      TabIndex        =   3
      ToolTipText     =   "Delete the selected user"
      Top             =   2835
      Width           =   1170
   End
   Begin VB.CommandButton cmdCreate 
      Caption         =   "&Create Group"
      Height          =   330
      Left            =   2565
      TabIndex        =   2
      ToolTipText     =   "Create a new user"
      Top             =   2835
      Width           =   1170
   End
   Begin VB.CommandButton cmdModify 
      Caption         =   "&Modify Group"
      Height          =   330
      Left            =   3825
      TabIndex        =   1
      ToolTipText     =   "Modify the selected user"
      Top             =   2835
      Width           =   1170
   End
   Begin MSFlexGridLib.MSFlexGrid grdGroups 
      Height          =   2430
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   5580
      _ExtentX        =   9843
      _ExtentY        =   4286
      _Version        =   393216
      Cols            =   3
      FixedRows       =   0
      FixedCols       =   0
      BackColorBkg    =   -2147483643
      AllowBigSelection=   0   'False
      FocusRect       =   0
      SelectionMode   =   1
      AllowUserResizing=   1
   End
End
Attribute VB_Name = "frmGroups"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' pgAdmin - PostgreSQL db Administration/Management for Win32
' Copyright (C) 1998 - 2000, Dave Page

' This program is free software; you can redistribute it and/or
' modify it under the terms of the GNU General Public License
' as published by the Free Software Foundation; either version 2
' of the License, or (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Option Explicit
Dim rsGroups As New Recordset

Private Sub Form_Unload(Cancel As Integer)
On Error Resume Next
  Set rsGroups = Nothing
End Sub

Public Sub cmdRefresh_Click()
On Error GoTo Err_Handler
Dim GroupInfo As String
Dim Users() As String
Dim X As Integer
Dim rsTemp As New Recordset
  StartMsg "Retrieving Group Information..."
  grdGroups.Clear
  grdGroups.Rows = 0
  grdGroups.ColAlignment(0) = 1
  grdGroups.ColAlignment(1) = 1
  grdGroups.ColAlignment(2) = 1
  grdGroups.AddItem "Group Name" & vbTab & "Group ID" & vbTab & "Members"
  If rsGroups.State <> adStateClosed Then rsGroups.Close
  LogMsg "Executing: SELECT * FROM pgadmin_groups ORDER BY group_name"
  rsGroups.Open "SELECT * FROM pgadmin_groups ORDER BY group_name", gConnection, adOpenDynamic
  While Not rsGroups.EOF
    GroupInfo = rsGroups!group_name & vbTab & rsGroups!group_id & vbTab
    If rsGroups!group_members <> "" Then
      Users = Split(Mid(rsGroups!group_members, 2, Len(rsGroups!group_members) - 2), ",")
      For X = 0 To UBound(Users)
        If rsTemp.State <> adStateClosed Then rsTemp.Close
        LogMsg "Executing: SELECT pg_get_userbyid('" & Users(X) & "') AS username"
        rsTemp.Open "SELECT pg_get_userbyid('" & Users(X) & "') AS username", gConnection, adOpenForwardOnly
        GroupInfo = GroupInfo & rsTemp!Username & ", "
      Next
    End If
    If Mid(GroupInfo, Len(GroupInfo) - 1, 2) = ", " Then GroupInfo = Mid(GroupInfo, 1, Len(GroupInfo) - 2)
    grdGroups.AddItem GroupInfo
    rsGroups.MoveNext
  Wend
  If rsGroups.BOF <> True Then rsGroups.MoveFirst
  grdGroups.AddItem "" & vbTab & "" & vbTab
  grdGroups.FixedRows = 1
  EndMsg
  Exit Sub
Err_Handler:
  EndMsg
  If Err.Number = -2147217887 Then
    MsgBox "Access Denied!", vbExclamation
    Unload Me
    Exit Sub
  End If
  If Err.Number <> 0 Then LogError Err, "frmGroups, cmdRefresh_click"
End Sub

Private Sub Form_Load()
On Error GoTo Err_Handler
  LogMsg "Loading Form: " & Me.Name
  Me.Height = 3600
  Me.Width = 5715
  cmdRefresh_Click
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmGroups, Form_Load"
End Sub

Private Sub Form_Resize()
On Error GoTo Err_Handler
  If Me.WindowState <> 1 Then
    If Me.WindowState = 0 Then
      If Me.Width < 5715 Then Me.Width = 5715
      If Me.Height < 3600 Then Me.Height = 3600
    End If
    grdGroups.Width = Me.ScaleWidth
    grdGroups.Height = Me.ScaleHeight - cmdRefresh.Height - 50
    cmdRefresh.Top = Me.ScaleHeight - cmdRefresh.Height
    cmdDrop.Top = Me.ScaleHeight - cmdRefresh.Height
    cmdCreate.Top = Me.ScaleHeight - cmdRefresh.Height
    cmdModify.Top = Me.ScaleHeight - cmdRefresh.Height
    If grdGroups.Width > 6120 Then
      grdGroups.ColWidth(0) = (grdGroups.Width / 4) - 20
      grdGroups.ColWidth(1) = (grdGroups.Width / 4) - 20
      grdGroups.ColWidth(2) = 2 * (grdGroups.Width / 4) - 40
    Else
      grdGroups.ColWidth(0) = 1020
      grdGroups.ColWidth(1) = 1020
      grdGroups.ColWidth(2) = 4080
    End If
  End If
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmGroups, Form_Resize"
End Sub

Private Sub grdGroups_DblClick()
On Error GoTo Err_Handler
  If grdGroups.Text <> "" Then cmdModify_Click
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmGroups, grdGroups_DblClick"
End Sub

Private Sub cmdCreate_Click()
On Error GoTo Err_Handler
  If SuperUser <> True Then
    MsgBox "You do not have sufficient authorisation to modify User Groups!", vbExclamation, "Error"
    Exit Sub
  End If
  Load frmAddGroup
  frmAddGroup.Show
  frmAddGroup.WindowState = WinState
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmGroups, cmdCreate_click"
End Sub

Private Sub cmdDrop_Click()
On Error GoTo Err_Handler
  If grdGroups.Text = "" Then Exit Sub
  If SuperUser <> True Then
    MsgBox "You do not have sufficient authorisation to modify User Groups!", vbExclamation, "Error"
    Exit Sub
  End If
  If grdGroups.Text = "" Then
    MsgBox "You must select a Group to drop!", vbExclamation, "Error"
    Exit Sub
  Else
    If MsgBox("Are you sure you wish to delete " & grdGroups.Text & "?", vbYesNo + vbQuestion, _
              "Confirm Group Delete") = vbYes Then
      StartMsg "Dropping Group..."
      fMainForm.txtSQLPane.Text = "DELETE FROM pg_group WHERE groname = '" & grdGroups.Text & "'"
      LogMsg "Executing: DELETE FROM pg_group WHERE groname = '" & grdGroups.Text & "'"
      gConnection.Execute "DELETE FROM pg_group WHERE groname = '" & grdGroups.Text & "'"
      grdGroups.RemoveItem grdGroups.Row
      EndMsg
    End If
  End If
  Exit Sub
Err_Handler:
  EndMsg
  If Err.Number <> 0 Then LogError Err, "frmGroups, cmdDrop_click"
End Sub

Private Sub cmdModify_Click()
On Error GoTo Err_Handler
  If grdGroups.Text = "" Then Exit Sub
  If SuperUser <> True Then
    MsgBox "You do not have sufficient authorisation to modify User Groups!", vbExclamation, "Error"
    Exit Sub
  End If
  Load frmModifyGroup
  frmModifyGroup.Show
  frmModifyGroup.WindowState = WinState
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmGroups, cmdModify_click"
End Sub

