#!/usr/bin/env python

""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from common import *
from pgtmlphp import *
from pgmlgraph import *
import getopt
import sys

def main():
	"""
	pgtml2sphp output select php

	usage: pgtml2sphp -s <pgml schema file> -f <pgtml view file> [-h] 
	-h : this help
	-s : pgml schema file
	-f : pgtml file
	-o : sphp output

	"""
	
	try:
		opts, args = getopt.getopt(sys.argv[1:], 's:o:f:h')
	except getopt.error, msg:
		usage(msg)

	pgmlFilename=''
	pgtmlFilename=''
	sqlFilename=''

	for o, a in opts:
		if o == '-f': pgtmlFilename = a
		if o == '-s': pgmlFilename = a
		if o == '-h': usage(main.__doc__)
		if o == '-o': sqlFilename = a

	if not pgmlFilename: usage(main.__doc__,'error : missing database pgml file')
	if not pgtmlFilename: usage(main.__doc__,'error : missing ptgml file')

	b = PgmlGraph()
	b.read(pgmlFilename)
	b.simplify()

	g = PgtmlPhp(b)
	g.read(pgtmlFilename)
	
	output = stdout
	if sqlFilename:
		output = open(sqlFilename,'w')
	g.write_select_query(output)

if __name__ == '__main__':
	main()
