#!/bin/bash

VERSION=$1
if [ "$VERSION" == "" ]; then
	echo "What's the version number?"
	exit 1;
fi
DIR=dbmodeller-$VERSION
rm -rf dbmodeller-* dist
mkdir $DIR
mkdir dist
cvs co -P -d $DIR dbmodeller
tar -cvf dbmodeller-src-$VERSION.tar $DIR/build.xml $DIR/src $DIR/images $DIR/bin $DIR/lib/include
gzip dbmodeller-src-$VERSION.tar
zip -r dbmodeller-src-$VERSION.zip $DIR/build.xml $DIR/src $DIR/images $DIR/bin $DIR/lib/include
mv dbmodeller-src-$VERSION.tar.gz dbmodeller-src-$VERSION.zip dist
cd $DIR
echo "building..."
ant clean build-all
cd ..
tar -cvf dbmodeller-$VERSION.tar $DIR/images $DIR/lib/include $DIR/build $DIR/bin
gzip dbmodeller-$VERSION.tar
zip -r dbmodeller-$VERSION.zip $DIR/images $DIR/lib/include $DIR/build $DIR/bin
mv dbmodeller-$VERSION.tar.gz dbmodeller-$VERSION.zip dist
rm -rf $DIR
echo "Dist files in the dist dir:"
ls -l dist
