/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;

public class PGcircle
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint center;
    double radius;

    public PGcircle() {
        this.setType("circle");
    }

    public PGcircle(double d, double d2, double d3) {
        this(new PGpoint(d, d2), d3);
    }

    public PGcircle(String string) throws SQLException {
        this();
        this.setValue(string);
    }

    public PGcircle(PGpoint pGpoint, double d) {
        this();
        this.center = pGpoint;
        this.radius = d;
    }

    public Object clone() {
        return new PGcircle((PGpoint)this.center.clone(), this.radius);
    }

    public boolean equals(Object object) {
        if (object instanceof PGcircle) {
            PGcircle pGcircle = (PGcircle)object;
            return pGcircle.center.equals(this.center) && pGcircle.radius == this.radius;
        }
        return false;
    }

    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }

    public void setValue(String string) throws SQLException {
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removeAngle(string), ',');
        if (pGtokenizer.getSize() != 2) {
            throw new PSQLException("postgresql.geo.circle", (Object)string);
        }
        try {
            this.center = new PGpoint(pGtokenizer.getToken(0));
            this.radius = Double.valueOf(pGtokenizer.getToken(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException("postgresql.geo.circle", numberFormatException);
        }
    }
}

