#!/usr/local/bin/perl
#
# cafPage.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package Context;

@Context::ISA = ('cafPage');

# fName => "contextid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
	{ fName => "contextid", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "contextlabel" },
	{ fName => "connector_id" },
	{ fName => "workdir" },
	{ fName => "programdir" },
	{ fName => "ftpconnector_id" },
	{ fName => "mailconnector_id" },
	{ fName => "pop3connector_id" },
	{ fName => "archconnector_id" },
	{ fName => "archdelay" },
	{ fName => "adminmail" }
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) { $cond->[++$icond] = [ "contextid", "like", $self->{search1} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("cafusers", $cond);
	my $rowscount = $self->_hiddenvar("_rowscount");
	my $lastrow = $self->_hiddenvar("_lastrow");
	my $maxlistdisplay = $conf->maxlistdisplay();
	
	my $query = $dbh->newquery({contextid => $self->{search1}, status => $self->{search2} });
	$query->scontextlist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	$self->{list1count} = $query->hrowcount();

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
}

sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_getcheckfields ($cgi, $editfields);
	$self->_hiddenvar ("search1", $cgi->param("search1"));

	my $actiondetail = $self->_hiddenvar ("_actiondetail");

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("contextid", $cgi->param("_objectid")) unless ($self->_datavar("contextid")); }

	my $c = $self->_datavar("contextid");
	$actiondetail = $self->_hiddenvar ("_actiondetail");

	unless ($self->{_system}{noselect}) {
		my $query = $dbh->newquery({ contextid => $self->_datavar("contextid") });
		$query->scontextlist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (keys %{$row}) { $row->{$field} = undef unless($row->{$field}); $self->{_data}{$field} = $row->{$field}; }
		my $objectids = $self->_getmyobjectids(qw( connector_id ftpconnector_id mailconnector_id pop3connector_id archconnector_id));
	}
	$self->_datavar("archdelay", 7) unless ($self->_datavar("archdelay"));
	unless ($actiondetail eq "new") {
#		my $query = $dbh->newquery({ contextid => $self->_datavar("contextid"), object_type => [ "flow", "subflow" ] });
		my $query = $dbh->newquery({ contextid => $self->_datavar("contextid"), object_type => [ "flow" ] });
		$query->sdeployedobjects();
		my $deployedobjects = $dbh->hexecfetchall($query, 1) || [];
		unshift @$deployedobjects, ({},{});
		$self->_hiddenvar ("_listdeployedobjectscount", $#$deployedobjects);
		$self->{_deployedobjects} = $deployedobjects; 
		my $query = $query->clear({ contextid => $self->_datavar("contextid") });
		$query->sdeployedobjectscount();
		my $row = $dbh->execfetchall($query, 1) || [];
		$self->_hiddenvar ("_countofdeployedobjects", $row->[0][0] || 0);
	}
	if ($actiondetail eq 'copy') { $self->_datavar("contextid", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("contextid"));
}

sub meth_vnew () {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->icontext();

	my $ret = $dbh->executefinish($query);
	$dbh->commit();
	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->ucontext();

	my $ret = $dbh->executefinish($query);
	$dbh->commit();
	return ($ret);
}

sub meth_vdeploy {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;


	my @selectedObjects;

	my $contextid = $cgi->param("_objectid");
	my $objcounts = $cgi->param("_listdeployedobjectscount");
	for (my $i = 0; $i <= $objcounts; $i++) {
		my $objectid;
		next unless $objectid = $cgi->param("object_id_$i");
		if ($cgi->param("update_$i") or $cgi->param("deploy_$i")) { push @selectedObjects, $objectid; }
	}
	return undef unless (@selectedObjects and ($#selectedObjects >= 0));

	my $query = $dbh->newquery({ contextid => $self->_datavar("contextid") });
	$query->scontextlist ();
	my $context = $dbh->hexecfetchrow($query, 1);

	foreach my $con (qw( connector_id ftpconnector_id mailconnector_id pop3connector_id archconnector_id)) {
		if ($context->{$con}) { push @selectedObjects, $context->{$con}; }
	}

	eval {
	require connectors::ObjHier;
	my $refrep = ObjHier->new($dbh, "REPOSITORY", $contextid, $context);
	$refrep->gethierarchy(\@selectedObjects);
#	my $ptext = $refrep->dumpall();
	
#	print "<TEXTAREA rows=10 cols=100>$ptext</TEXTAREA>";

	my $ret = $refrep->outputupdatable();
	
	if ($ret > 0) {
		$ret = $refrep->runsqlgeneratetables();
	}
	if ($ret > 0) {
		$dbh->commit();
		my $outdbh = $refrep->outdbh();
		$outdbh->commit();
	}
	else {
		$dbh->rollback();
		$refrep->outdbh()->rollback();
	}
	};
	if ($@) {
#		print "ERROR : $@<BR>";
		my $qryText;
		if (my $q = $dbh->lastquery()) {
			$qryText = $q->query();
#			my $e =  "<BR>\nlast query is: <I>" . $q->query() . "<BR>\n"; print "$e";
		}
		cafDbg->pushstackdump(1);
		cafDbg->pusherror("10000; ERROR WHILE DEPLOYING : $@ <BR>\nlast query is: <I>$qryText</I>\n");
	}

}

sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->dcontext();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}

1;
