#!/usr/local/bin/perl
#
# Connector.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package Connector;

@Connector::ISA = ('cafPage');

# fName => "userid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
#??	{ fName => "id" },
	{ fName => "type" },
	{ fName => "name", fType => "atom", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "parent_id" },
	{ fName => "created" },
	{ fName => "modified" },
	{ fName => "deleted" },
	{ fName => "comments" },
	{ fName => "status" },
	{ fName => "createdby" },
	{ fName => "modifiedby" },
	{ fName => "object_id" },

	{ fName => "externalname", fType => "string", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "contextid", fType => "string", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "dbidsn", fType => "string", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "master_id" },
	{ fName => "proxy_id" },
	{ fName => "ismaster", fType => "list", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "port", fType => "string", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "serverid", fType => "string", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "userid", fType => "string", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "protocolid", fType => "string", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "driverid", fType => "string", fMand => 1, fMin => 3, dMax => 30 }, 

#self._data.contextid
#self._data.contextname
#self._data.dbidsn
#self._data.externalname
#self._data.master_id
#self._data.master_id_name
#self._data.name
#self._data.object_id
#self._data.port
#self._data.serverid
#self._data.serverid_name
#self._data.userid
#self._data.userid_name
#	{ fName => "host_address", fType => "ipaddress", fMand => 0, fMin => 3, dMax => 30 },
#	{ fName => "currentuser" },
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search2} = $cgi->param("search2")) =~ s/ *//g;
	($self->{search3} = $cgi->param("search3")) =~ s/ *//g;
	$self->{search0} = $cgi->param("search0");

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) {
		$cond->[++$icond] = [ [ "objects.name", "connector.externalname" ], "like", $self->{search1} ];
	}
	if ($self->{search2}) { $cond->[++$icond] = [ "objects.status", "like", $self->{search2} ]; }
	if ($self->{search3}) { $self->{search3} =~ s/[^0-9]*//g; $cond->[++$icond] = [ "objects.parent_id", "=", $self->{search3} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("connector", $cond, "isobject");
	
	my $query = $dbh->newquery({ name => $self->{search1}, status => $self->{search2}, parent_id => $self->{search3} });
	$query->sconnectorlist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	$self->{list1count} = $query->hrowcount();

	my @serverids;
	foreach my $conn (@{$self->{_list1}}) {
		push @serverids, $conn->{parent_id} if ($conn->{parent_id});
	}
	my $objectids = $self->_getobjectids(@serverids);

	foreach my $conn (@{$self->{_list1}}) {
		foreach my $server (@{$objectids}) {
			if ($conn->{parent_id} eq $server->{id}) { $conn->{parent_id_name} = $server->{name}; last; }
		}
	}
			
	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
	# print "<BR>\nlist1count = $self->{list1count}";
}

sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_getcheckfields ($cgi, $editfields);
	$self->_systemvar("_miscinfo_", '_miscinfo_');
	$self->_datavar("type", 'connector');
	$self->_datavar("parent_id", -1) unless ($self->_datavar("parent_id"));
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));

	my $query = $dbh->newquery();
	$query->sprotocollist();
	$self->{_protocollist} = $dbh->hexecfetchall($query);

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id")); }

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	unless ($self->{_system}{noselect}) {
		$query = $dbh->newquery({ object_id => $self->_datavar("object_id"), id => $self->_datavar("object_id"), });
		$self->_datavar("id", $self->_datavar("object_id"));

		$query->sconnectorlist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (keys %{$row}) { $self->_datavar($field, $row->{$field}); }

		$query->sobject();
		my $row = $dbh->hexecfetchrow($query, 1);
		foreach my $field (keys %{$row}) { $self->_datavar($field, $row->{$field}); }

		my $objectids = $self->_getmyobjectids(qw(parent_id userid master_id proxy_id));
	}
	if ($actiondetail eq 'copy') { $self->_datavar("object_id", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("object_id"));

	$query = $dbh->newquery();
	$query->scontextlist();
	$self->{_contextlist} = $dbh->hexecfetchall($query);
	unshift @{$self->{_contextlist}}, { contextid => "", contextlabel => "___________"  };

	if ($self->_datavar("protocolid")) {
		$query = $dbh->newquery( { "protocolid" => $self->_datavar("protocolid") });
		$query->sdriverlist();
		$self->{_driverlist} = $dbh->hexecfetchall($query);
	}


	$self->{_attributeslist} = $self->_getmyattributes($dbh);
}

sub meth_vnew () {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $ret;


	if ($self->_datavar("driverid")) {
		$self->_datavar("object_id", $dbh->nextseq("objects"));
		my $bindvars = $self->_getmyfields();
		my $query = $dbh->newquery($bindvars);

		$query->iobject();
		if (($ret = $dbh->executefinish($query)) > 0) {
			$query->iconnector();
			$ret = $dbh->executefinish($query);
			if ($ret > 0) { $self->_updateattributes(); }
			if ($ret > 0) { $dbh->commit(); }
			else { $dbh->rollback(); }
		}
		else { $dbh->rollback(); }
	}
	else { $self->{_system}{noselect} = 1; return undef; }

	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
	my $query = $dbh->newquery($self->_getmyfields());
	my $ret;

	$query->uobject();
	if (($ret = $dbh->executefinish($query)) > 0) {
		$query->uconnector();
		if (($ret = $dbh->executefinish($query)) > 0) {
			$self->_updateattributes();
			$dbh->commit();
		}
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }

	return ($ret);
}

sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->dconnector();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}


1;
