#! /usr/local/bin/php -q
<?php

$table_name = "noname";
$db_class = "DB_Noname";
$db = "test";

$argc = isset($HTTP_SERVER_VARS["argc"])?$HTTP_SERVER_VARS["argc"]:0;
if (isset($HTTP_SERVER_VARS["argv"])) {
   $argv = $HTTP_SERVER_VARS["argv"];
}

if ($argc != 1 && $argc != 4) {
  print("Usage: \$argv[0] [table_name db_class database]\n");
  exit;
}

if (isset($argv) && is_array($argv) && isset($argv[1])) {
  $table_name = $argv[1];
}
if (isset($argv) && is_array($argv) && isset($argv[2])) {
  $db_class = $argv[2];
}
if (isset($argv) && is_array($argv) && isset($argv[3])) {
  $db = $argv[3];
}

//$table_name = "auth_user_md5";
//$db_class = "DB_Pgimage";
//$db = "pgimage";

pg_connect("","5432","",$db);

$sql = "SELECT a.attnum, a.attname, t.typname, a.attlen, a.atttypmod,
      a.attnotnull, a.atthasdef, c.oid
      FROM pg_class c, pg_attribute a, pg_type t
      WHERE c.relname = '$table_name' 
      AND a.attnum > 0 AND a.attrelid = c.oid AND a.atttypid = t.oid
      ORDER BY a.attnum";

$result = pg_exec($sql);
$oid = pg_result($result,0,"oid");
$num_attrs = pg_numrows($result);
for ($i=0;$i<$num_attrs;$i++) {
  $md[$i]["name"] = pg_result($result,$i,"attname");
  $md[$i]["typename"] = pg_result($result,$i,"typname");
  $md[$i]["len"] = pg_result($result,$i,"attlen");
  $md[$i]["modifier"] = pg_result($result,$i,"atttypmod");
  $md[$i]["notnull"] = pg_result($result,$i,"attnotnull");
  $md[$i]["defaultval"] = pg_result($result,$i,"atthasdef");
}
pg_freeresult($result);

$sql =<<<EOF
SELECT a.attname FROM pg_index i, pg_class c, pg_attribute a
 WHERE i.indisprimary AND i.indrelid = $oid
 AND i.indexrelid = c.oid AND a.attnum > 0
 AND a.attrelid = c.oid ORDER BY a.attnum
EOF;
$result = pg_exec($sql);
$rows = pg_numrows($result);

for ($i=0;$i<$rows;$i++) {
  $pkeys[$i] = pg_result($result,$i,"attname");
}
pg_freeresult($result);

pg_close();

print <<<EOF
<?php
/*
 * This file was automatically generated by gen_class.php.
 * Please do not edit by hand.
EOF;

printf(" * Generated on %s. generated by %s.\n", date("Y/m/d H:i:s"),getenv("USER"));

print <<<EOF
 */\n
//------------------------------------------------------
class $table_name {
  var \$table_name = "$table_name";	// ơ֥̾
  var \$num_attrs = $num_attrs;	// 
  var \$col_info;	// [0-n][name]or[typename]
  var \$col_vars;	// (̾б)
  var \$nulls;		// NULLե饰(̾б)
  var \$db;		// DB֥


//------------------------------------------------------
  // 󥹥ȥ饯 
  function $table_name () {
\n
EOF;

for ($i=0;$i<$num_attrs;$i++) {
  $name = $md[$i]["name"];
  $typename = $md[$i]["typename"];
  print <<<EOF
    \$this->col_info[$i]["name"] = "$name";
    \$this->col_info[$i]["typename"] = "$typename";
    \$this->col_vars["$name"] = "";
    \$this->nulls["$name"] = false;
\n
EOF;
}

print <<<EOF
    \$this->db = new $db_class;
  }

//------------------------------------------------------
  // ߤΥ쥳ɤ饤󥹥ѿ
  function get_one_record (\$db) {
    if (\$this->db->next_record() == false) return false;

    for (\$i=0;\$i<\$this->num_attrs;\$i++) {
      \$name = \$this->col_info[\$i]["name"];
      \$this->col_vars[\$name] = \$this->db->f(\$name);
      \$this->nulls[\$name] = pg_fieldisnull(\$this->db->Query_ID, 0, \$i);
    }
    return true;
  }

//------------------------------------------------------
\n  // 祭饤󥹥ѿ
  function create_obj (
EOF;

for ($i=0;$i<count($pkeys);$i++) {
  print("\$$pkeys[$i]");
  if ($i != (count($pkeys)-1)) print(",");
}

print <<<EOF
) {
    \$this->db->query(sprintf("SELECT * FROM \$this->table_name WHERE 
EOF;

for ($i=0;$i<count($pkeys);$i++) {
  print("$pkeys[$i] = '%s'");
  if ($i != (count($pkeys)-1)) print(" AND ");
}

print <<<EOF
",
EOF;

for ($i=0;$i<count($pkeys);$i++) {
  print("addslashes(\$$pkeys[$i])");
  if ($i != (count($pkeys)-1)) print(", ");
}

print <<<EOF

));
    return \$this->get_one_record(\$this->db);
  }

//------------------------------------------------------
\n  // WHERE狼饤󥹥ѿ
    // addslashes()ϸƤӽФ¦ǤǹԤ
  function create_obj_by_qual (\$qual) {
    \$this->db->query(sprintf("SELECT * FROM \$this->table_name WHERE %s", \$qual));
    return \$this->get_one_record(\$this->db);
  }

//------------------------------------------------------
\n  // 쥳ɤINSERT
  function insert () {
    \$this->db->query("BEGIN");
    \$this->db->query("LOCK TABLE \$this->table_name IN SHARE ROW EXCLUSIVE MODE");
    \$sql = "SELECT * FROM \$this->table_name ";
    \$where = " WHERE ";
\n
EOF;

for ($i=0;$i<count($pkeys);$i++) {
  print <<<EOF
    \$val = addslashes(\$this->get("$pkeys[$i]"));
    \$where .= "$pkeys[$i] = '\$val'";
\n
EOF;
  if ($i != (count($pkeys)-1)) print("    \$where .= \" AND \";\n");
}

print <<<EOF
    \$sql .= \$where;
    \$this->db->query(\$sql);
    if (\$this->db->num_rows() > 0) {
      print("$table_name: ǤƱΥ쥳ɤ¸ߤޤ<br>");
      \$this->db->query("COMMIT");
      return(0);
    } else {
      \$sql = "INSERT INTO \$this->table_name VALUES (";
      for (\$i=0;\$i<\$this->num_attrs;\$i++) {
        \$name = \$this->col_info[\$i]["name"];
        if (\$this->nulls["\$name"]) \$sql .= "NULL";
        else \$sql .= "'" . addslashes(\$this->col_vars[\$name]) . "'";
        if (\$i != (\$this->num_attrs -1)) {
          \$sql .= ",";
        }
      }
      \$sql .= ")";
      \$this->db->query(\$sql);
      \$rtn = \$this->db->affected_rows();
      \$this->db->query("COMMIT");
      return(\$rtn);
    }
  }

//------------------------------------------------------
\n  // 쥳ɤUPDATE
  function update (
EOF;

for ($i=0;$i<count($pkeys);$i++) {
  print("\$$pkeys[$i]");
  if ($i != (count($pkeys)-1)) print(",");
}

print <<<EOF
) {

    \$where = " WHERE ";
\n
EOF;

for ($i=0;$i<count($pkeys);$i++) {
  print <<<EOF
    \$val = addslashes(\$this->get("$pkeys[$i]"));
    \$where .= "$pkeys[$i] = '\$val'";
\n
EOF;
  if ($i != (count($pkeys)-1)) print("    \$where .= \" AND \";\n");
}

print <<<EOF
    \$sql = "UPDATE \$this->table_name SET ";
    for (\$i=0;\$i<\$this->num_attrs;\$i++) {
      \$name = \$this->col_info[\$i]["name"];
      \$sql .= "\$name = ";
      if (\$this->nulls["\$name"]) \$sql .= "NULL";
      else \$sql .= "'" . addslashes(\$this->col_vars["\$name"]) . "'";
      if (\$i != (\$this->num_attrs -1)) {
        \$sql .= ",";
      }
    }
    \$sql .= \$where;
    \$this->db->query(\$sql);
    return(\$this->db->affected_rows());
  }

//------------------------------------------------------
\n  // ֤ͤ
  function get (\$col) {
    return(\$this->col_vars[\$col]);
  }

//------------------------------------------------------
\n  // ͤ򥻥åȤ
  function put (\$col, \$val) {
    \$this->col_vars[\$col] = \$val;
  }

//------------------------------------------------------
\n  // NULLɤ֤
  function is_null (\$col) {
    if (\$this->nulls[\$col] == true) {
      return(true);
    } else {
      return(false);
    }
  }

//------------------------------------------------------
\n  // NULL򥻥åȤ
  function set_null (\$col) {
    \$this->nulls[\$col] = true;
  }

//------------------------------------------------------
\n  // NULLꥻåȤ
  function reset_null (\$col) {
    \$this->nulls[\$col] = false;
  }

//------------------------------------------------------
\n  // DB³
  function connect () {
    return(\$this->db->connect());
  }

//------------------------------------------------------
\n  // Link_ID֤
  function link_id () {
    \$this->db->connect();
    return(\$this->db->Link_ID);
  }


}

//------------------------------------------------------
?>
EOF;
?>
