/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     TYPECAST = 326,
     CSTRING = 327,
     CVARIABLE = 328,
     CPP_LINE = 329,
     IP = 330,
     DOLCONST = 331,
     ECONST = 332,
     NCONST = 333,
     UCONST = 334,
     UIDENT = 335,
     ABORT_P = 336,
     ABSOLUTE_P = 337,
     ACCESS = 338,
     ACTION = 339,
     ADD_P = 340,
     ADMIN = 341,
     AFTER = 342,
     AGGREGATE = 343,
     ALL = 344,
     ALSO = 345,
     ALTER = 346,
     ALWAYS = 347,
     ANALYSE = 348,
     ANALYZE = 349,
     AND = 350,
     ANY = 351,
     ARRAY = 352,
     AS = 353,
     ASC = 354,
     ASSERTION = 355,
     ASSIGNMENT = 356,
     ASYMMETRIC = 357,
     AT = 358,
     AUTHORIZATION = 359,
     BACKWARD = 360,
     BEFORE = 361,
     BEGIN_P = 362,
     BETWEEN = 363,
     BIGINT = 364,
     BINARY = 365,
     BIT = 366,
     BOOLEAN_P = 367,
     BOTH = 368,
     BY = 369,
     CACHE = 370,
     CALLED = 371,
     CASCADE = 372,
     CASCADED = 373,
     CASE = 374,
     CAST = 375,
     CATALOG_P = 376,
     CHAIN = 377,
     CHAR_P = 378,
     CHARACTER = 379,
     CHARACTERISTICS = 380,
     CHECK = 381,
     CHECKPOINT = 382,
     CLASS = 383,
     CLOSE = 384,
     CLUSTER = 385,
     COALESCE = 386,
     COLLATE = 387,
     COLUMN = 388,
     COMMENT = 389,
     COMMIT = 390,
     COMMITTED = 391,
     CONCURRENTLY = 392,
     CONFIGURATION = 393,
     CONNECTION = 394,
     CONSTRAINT = 395,
     CONSTRAINTS = 396,
     CONTENT_P = 397,
     CONTINUE_P = 398,
     CONVERSION_P = 399,
     COPY = 400,
     COST = 401,
     CREATE = 402,
     CREATEDB = 403,
     CREATEROLE = 404,
     CREATEUSER = 405,
     CROSS = 406,
     CSV = 407,
     CURRENT_P = 408,
     CURRENT_CATALOG = 409,
     CURRENT_DATE = 410,
     CURRENT_ROLE = 411,
     CURRENT_SCHEMA = 412,
     CURRENT_TIME = 413,
     CURRENT_TIMESTAMP = 414,
     CURRENT_USER = 415,
     CURSOR = 416,
     CYCLE = 417,
     DATA_P = 418,
     DATABASE = 419,
     DAY_P = 420,
     DEALLOCATE = 421,
     DEC = 422,
     DECIMAL_P = 423,
     DECLARE = 424,
     DEFAULT = 425,
     DEFAULTS = 426,
     DEFERRABLE = 427,
     DEFERRED = 428,
     DEFINER = 429,
     DELETE_P = 430,
     DELIMITER = 431,
     DELIMITERS = 432,
     DESC = 433,
     DICTIONARY = 434,
     DISABLE_P = 435,
     DISCARD = 436,
     DISTINCT = 437,
     DO = 438,
     DOCUMENT_P = 439,
     DOMAIN_P = 440,
     DOUBLE_P = 441,
     DROP = 442,
     EACH = 443,
     ELSE = 444,
     ENABLE_P = 445,
     ENCODING = 446,
     ENCRYPTED = 447,
     END_P = 448,
     ENUM_P = 449,
     ESCAPE = 450,
     EXCEPT = 451,
     EXCLUDING = 452,
     EXCLUSIVE = 453,
     EXECUTE = 454,
     EXISTS = 455,
     EXPLAIN = 456,
     EXTERNAL = 457,
     EXTRACT = 458,
     FALSE_P = 459,
     FAMILY = 460,
     FETCH = 461,
     FIRST_P = 462,
     FLOAT_P = 463,
     FOLLOWING = 464,
     FOR = 465,
     FORCE = 466,
     FOREIGN = 467,
     FORWARD = 468,
     FREEZE = 469,
     FROM = 470,
     FULL = 471,
     FUNCTION = 472,
     GLOBAL = 473,
     GRANT = 474,
     GRANTED = 475,
     GREATEST = 476,
     GROUP_P = 477,
     HANDLER = 478,
     HAVING = 479,
     HEADER_P = 480,
     HOLD = 481,
     HOUR_P = 482,
     IDENTITY_P = 483,
     IF_P = 484,
     ILIKE = 485,
     IMMEDIATE = 486,
     IMMUTABLE = 487,
     IMPLICIT_P = 488,
     IN_P = 489,
     INCLUDING = 490,
     INCREMENT = 491,
     INDEX = 492,
     INDEXES = 493,
     INHERIT = 494,
     INHERITS = 495,
     INITIALLY = 496,
     INNER_P = 497,
     INOUT = 498,
     INPUT_P = 499,
     INSENSITIVE = 500,
     INSERT = 501,
     INSTEAD = 502,
     INT_P = 503,
     INTEGER = 504,
     INTERSECT = 505,
     INTERVAL = 506,
     INTO = 507,
     INVOKER = 508,
     IS = 509,
     ISNULL = 510,
     ISOLATION = 511,
     JOIN = 512,
     KEY = 513,
     LANCOMPILER = 514,
     LANGUAGE = 515,
     LARGE_P = 516,
     LAST_P = 517,
     LC_COLLATE_P = 518,
     LC_CTYPE_P = 519,
     LEADING = 520,
     LEAST = 521,
     LEFT = 522,
     LEVEL = 523,
     LIKE = 524,
     LIMIT = 525,
     LISTEN = 526,
     LOAD = 527,
     LOCAL = 528,
     LOCALTIME = 529,
     LOCALTIMESTAMP = 530,
     LOCATION = 531,
     LOCK_P = 532,
     LOGIN_P = 533,
     MAPPING = 534,
     MATCH = 535,
     MAXVALUE = 536,
     MINUTE_P = 537,
     MINVALUE = 538,
     MODE = 539,
     MONTH_P = 540,
     MOVE = 541,
     NAME_P = 542,
     NAMES = 543,
     NATIONAL = 544,
     NATURAL = 545,
     NCHAR = 546,
     NEW = 547,
     NEXT = 548,
     NO = 549,
     NOCREATEDB = 550,
     NOCREATEROLE = 551,
     NOCREATEUSER = 552,
     NOINHERIT = 553,
     NOLOGIN_P = 554,
     NONE = 555,
     NOSUPERUSER = 556,
     NOT = 557,
     NOTHING = 558,
     NOTIFY = 559,
     NOTNULL = 560,
     NOWAIT = 561,
     NULL_P = 562,
     NULLIF = 563,
     NULLS_P = 564,
     NUMERIC = 565,
     OBJECT_P = 566,
     OF = 567,
     OFF = 568,
     OFFSET = 569,
     OIDS = 570,
     OLD = 571,
     ON = 572,
     ONLY = 573,
     OPERATOR = 574,
     OPTION = 575,
     OPTIONS = 576,
     OR = 577,
     ORDER = 578,
     OUT_P = 579,
     OUTER_P = 580,
     OVER = 581,
     OVERLAPS = 582,
     OVERLAY = 583,
     OWNED = 584,
     OWNER = 585,
     PARSER = 586,
     PARTIAL = 587,
     PARTITION = 588,
     PASSWORD = 589,
     PLACING = 590,
     PLANS = 591,
     POSITION = 592,
     PRECEDING = 593,
     PRECISION = 594,
     PRESERVE = 595,
     PREPARE = 596,
     PREPARED = 597,
     PRIMARY = 598,
     PRIOR = 599,
     PRIVILEGES = 600,
     PROCEDURAL = 601,
     PROCEDURE = 602,
     QUOTE = 603,
     RANGE = 604,
     READ = 605,
     REAL = 606,
     REASSIGN = 607,
     RECHECK = 608,
     RECURSIVE = 609,
     REFERENCES = 610,
     REINDEX = 611,
     RELATIVE_P = 612,
     RELEASE = 613,
     RENAME = 614,
     REPEATABLE = 615,
     REPLACE = 616,
     REPLICA = 617,
     RESET = 618,
     RESTART = 619,
     RESTRICT = 620,
     RETURNING = 621,
     RETURNS = 622,
     REVOKE = 623,
     RIGHT = 624,
     ROLE = 625,
     ROLLBACK = 626,
     ROW = 627,
     ROWS = 628,
     RULE = 629,
     SAVEPOINT = 630,
     SCHEMA = 631,
     SCROLL = 632,
     SEARCH = 633,
     SECOND_P = 634,
     SECURITY = 635,
     SELECT = 636,
     SEQUENCE = 637,
     SERIALIZABLE = 638,
     SERVER = 639,
     SESSION = 640,
     SESSION_USER = 641,
     SET = 642,
     SETOF = 643,
     SHARE = 644,
     SHOW = 645,
     SIMILAR = 646,
     SIMPLE = 647,
     SMALLINT = 648,
     SOME = 649,
     STABLE = 650,
     STANDALONE_P = 651,
     START = 652,
     STATEMENT = 653,
     STATISTICS = 654,
     STDIN = 655,
     STDOUT = 656,
     STORAGE = 657,
     STRICT_P = 658,
     STRIP_P = 659,
     SUBSTRING = 660,
     SUPERUSER_P = 661,
     SYMMETRIC = 662,
     SYSID = 663,
     SYSTEM_P = 664,
     TABLE = 665,
     TABLESPACE = 666,
     TEMP = 667,
     TEMPLATE = 668,
     TEMPORARY = 669,
     TEXT_P = 670,
     THEN = 671,
     TIME = 672,
     TIMESTAMP = 673,
     TO = 674,
     TRAILING = 675,
     TRANSACTION = 676,
     TREAT = 677,
     TRIGGER = 678,
     TRIM = 679,
     TRUE_P = 680,
     TRUNCATE = 681,
     TRUSTED = 682,
     TYPE_P = 683,
     UNBOUNDED = 684,
     UNCOMMITTED = 685,
     UNENCRYPTED = 686,
     UNION = 687,
     UNIQUE = 688,
     UNKNOWN = 689,
     UNLISTEN = 690,
     UNTIL = 691,
     UPDATE = 692,
     USER = 693,
     USING = 694,
     VACUUM = 695,
     VALID = 696,
     VALIDATOR = 697,
     VALUE_P = 698,
     VALUES = 699,
     VARCHAR = 700,
     VARIADIC = 701,
     VARYING = 702,
     VERBOSE = 703,
     VERSION_P = 704,
     VIEW = 705,
     VOLATILE = 706,
     WHEN = 707,
     WHERE = 708,
     WHITESPACE_P = 709,
     WINDOW = 710,
     WITH = 711,
     WITHOUT = 712,
     WORK = 713,
     WRAPPER = 714,
     WRITE = 715,
     XML_P = 716,
     XMLATTRIBUTES = 717,
     XMLCONCAT = 718,
     XMLELEMENT = 719,
     XMLFOREST = 720,
     XMLPARSE = 721,
     XMLPI = 722,
     XMLROOT = 723,
     XMLSERIALIZE = 724,
     YEAR_P = 725,
     YES_P = 726,
     ZONE = 727,
     NULLS_FIRST = 728,
     NULLS_LAST = 729,
     WITH_TIME = 730,
     IDENT = 731,
     FCONST = 732,
     SCONST = 733,
     BCONST = 734,
     XCONST = 735,
     Op = 736,
     ICONST = 737,
     PARAM = 738,
     POSTFIXOP = 739,
     UMINUS = 740
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_COUNT 265
#define SQL_DATETIME_INTERVAL_CODE 266
#define SQL_DATETIME_INTERVAL_PRECISION 267
#define SQL_DESCRIBE 268
#define SQL_DESCRIPTOR 269
#define SQL_DISCONNECT 270
#define SQL_FOUND 271
#define SQL_FREE 272
#define SQL_GET 273
#define SQL_GO 274
#define SQL_GOTO 275
#define SQL_IDENTIFIED 276
#define SQL_INDICATOR 277
#define SQL_KEY_MEMBER 278
#define SQL_LENGTH 279
#define SQL_LONG 280
#define SQL_NULLABLE 281
#define SQL_OCTET_LENGTH 282
#define SQL_OPEN 283
#define SQL_OUTPUT 284
#define SQL_REFERENCE 285
#define SQL_RETURNED_LENGTH 286
#define SQL_RETURNED_OCTET_LENGTH 287
#define SQL_SCALE 288
#define SQL_SECTION 289
#define SQL_SHORT 290
#define SQL_SIGNED 291
#define SQL_SQL 292
#define SQL_SQLERROR 293
#define SQL_SQLPRINT 294
#define SQL_SQLWARNING 295
#define SQL_START 296
#define SQL_STOP 297
#define SQL_STRUCT 298
#define SQL_UNSIGNED 299
#define SQL_VAR 300
#define SQL_WHENEVER 301
#define S_ADD 302
#define S_AND 303
#define S_ANYTHING 304
#define S_AUTO 305
#define S_CONST 306
#define S_DEC 307
#define S_DIV 308
#define S_DOTPOINT 309
#define S_EQUAL 310
#define S_EXTERN 311
#define S_INC 312
#define S_LSHIFT 313
#define S_MEMPOINT 314
#define S_MEMBER 315
#define S_MOD 316
#define S_MUL 317
#define S_NEQUAL 318
#define S_OR 319
#define S_REGISTER 320
#define S_RSHIFT 321
#define S_STATIC 322
#define S_SUB 323
#define S_VOLATILE 324
#define S_TYPEDEF 325
#define TYPECAST 326
#define CSTRING 327
#define CVARIABLE 328
#define CPP_LINE 329
#define IP 330
#define DOLCONST 331
#define ECONST 332
#define NCONST 333
#define UCONST 334
#define UIDENT 335
#define ABORT_P 336
#define ABSOLUTE_P 337
#define ACCESS 338
#define ACTION 339
#define ADD_P 340
#define ADMIN 341
#define AFTER 342
#define AGGREGATE 343
#define ALL 344
#define ALSO 345
#define ALTER 346
#define ALWAYS 347
#define ANALYSE 348
#define ANALYZE 349
#define AND 350
#define ANY 351
#define ARRAY 352
#define AS 353
#define ASC 354
#define ASSERTION 355
#define ASSIGNMENT 356
#define ASYMMETRIC 357
#define AT 358
#define AUTHORIZATION 359
#define BACKWARD 360
#define BEFORE 361
#define BEGIN_P 362
#define BETWEEN 363
#define BIGINT 364
#define BINARY 365
#define BIT 366
#define BOOLEAN_P 367
#define BOTH 368
#define BY 369
#define CACHE 370
#define CALLED 371
#define CASCADE 372
#define CASCADED 373
#define CASE 374
#define CAST 375
#define CATALOG_P 376
#define CHAIN 377
#define CHAR_P 378
#define CHARACTER 379
#define CHARACTERISTICS 380
#define CHECK 381
#define CHECKPOINT 382
#define CLASS 383
#define CLOSE 384
#define CLUSTER 385
#define COALESCE 386
#define COLLATE 387
#define COLUMN 388
#define COMMENT 389
#define COMMIT 390
#define COMMITTED 391
#define CONCURRENTLY 392
#define CONFIGURATION 393
#define CONNECTION 394
#define CONSTRAINT 395
#define CONSTRAINTS 396
#define CONTENT_P 397
#define CONTINUE_P 398
#define CONVERSION_P 399
#define COPY 400
#define COST 401
#define CREATE 402
#define CREATEDB 403
#define CREATEROLE 404
#define CREATEUSER 405
#define CROSS 406
#define CSV 407
#define CURRENT_P 408
#define CURRENT_CATALOG 409
#define CURRENT_DATE 410
#define CURRENT_ROLE 411
#define CURRENT_SCHEMA 412
#define CURRENT_TIME 413
#define CURRENT_TIMESTAMP 414
#define CURRENT_USER 415
#define CURSOR 416
#define CYCLE 417
#define DATA_P 418
#define DATABASE 419
#define DAY_P 420
#define DEALLOCATE 421
#define DEC 422
#define DECIMAL_P 423
#define DECLARE 424
#define DEFAULT 425
#define DEFAULTS 426
#define DEFERRABLE 427
#define DEFERRED 428
#define DEFINER 429
#define DELETE_P 430
#define DELIMITER 431
#define DELIMITERS 432
#define DESC 433
#define DICTIONARY 434
#define DISABLE_P 435
#define DISCARD 436
#define DISTINCT 437
#define DO 438
#define DOCUMENT_P 439
#define DOMAIN_P 440
#define DOUBLE_P 441
#define DROP 442
#define EACH 443
#define ELSE 444
#define ENABLE_P 445
#define ENCODING 446
#define ENCRYPTED 447
#define END_P 448
#define ENUM_P 449
#define ESCAPE 450
#define EXCEPT 451
#define EXCLUDING 452
#define EXCLUSIVE 453
#define EXECUTE 454
#define EXISTS 455
#define EXPLAIN 456
#define EXTERNAL 457
#define EXTRACT 458
#define FALSE_P 459
#define FAMILY 460
#define FETCH 461
#define FIRST_P 462
#define FLOAT_P 463
#define FOLLOWING 464
#define FOR 465
#define FORCE 466
#define FOREIGN 467
#define FORWARD 468
#define FREEZE 469
#define FROM 470
#define FULL 471
#define FUNCTION 472
#define GLOBAL 473
#define GRANT 474
#define GRANTED 475
#define GREATEST 476
#define GROUP_P 477
#define HANDLER 478
#define HAVING 479
#define HEADER_P 480
#define HOLD 481
#define HOUR_P 482
#define IDENTITY_P 483
#define IF_P 484
#define ILIKE 485
#define IMMEDIATE 486
#define IMMUTABLE 487
#define IMPLICIT_P 488
#define IN_P 489
#define INCLUDING 490
#define INCREMENT 491
#define INDEX 492
#define INDEXES 493
#define INHERIT 494
#define INHERITS 495
#define INITIALLY 496
#define INNER_P 497
#define INOUT 498
#define INPUT_P 499
#define INSENSITIVE 500
#define INSERT 501
#define INSTEAD 502
#define INT_P 503
#define INTEGER 504
#define INTERSECT 505
#define INTERVAL 506
#define INTO 507
#define INVOKER 508
#define IS 509
#define ISNULL 510
#define ISOLATION 511
#define JOIN 512
#define KEY 513
#define LANCOMPILER 514
#define LANGUAGE 515
#define LARGE_P 516
#define LAST_P 517
#define LC_COLLATE_P 518
#define LC_CTYPE_P 519
#define LEADING 520
#define LEAST 521
#define LEFT 522
#define LEVEL 523
#define LIKE 524
#define LIMIT 525
#define LISTEN 526
#define LOAD 527
#define LOCAL 528
#define LOCALTIME 529
#define LOCALTIMESTAMP 530
#define LOCATION 531
#define LOCK_P 532
#define LOGIN_P 533
#define MAPPING 534
#define MATCH 535
#define MAXVALUE 536
#define MINUTE_P 537
#define MINVALUE 538
#define MODE 539
#define MONTH_P 540
#define MOVE 541
#define NAME_P 542
#define NAMES 543
#define NATIONAL 544
#define NATURAL 545
#define NCHAR 546
#define NEW 547
#define NEXT 548
#define NO 549
#define NOCREATEDB 550
#define NOCREATEROLE 551
#define NOCREATEUSER 552
#define NOINHERIT 553
#define NOLOGIN_P 554
#define NONE 555
#define NOSUPERUSER 556
#define NOT 557
#define NOTHING 558
#define NOTIFY 559
#define NOTNULL 560
#define NOWAIT 561
#define NULL_P 562
#define NULLIF 563
#define NULLS_P 564
#define NUMERIC 565
#define OBJECT_P 566
#define OF 567
#define OFF 568
#define OFFSET 569
#define OIDS 570
#define OLD 571
#define ON 572
#define ONLY 573
#define OPERATOR 574
#define OPTION 575
#define OPTIONS 576
#define OR 577
#define ORDER 578
#define OUT_P 579
#define OUTER_P 580
#define OVER 581
#define OVERLAPS 582
#define OVERLAY 583
#define OWNED 584
#define OWNER 585
#define PARSER 586
#define PARTIAL 587
#define PARTITION 588
#define PASSWORD 589
#define PLACING 590
#define PLANS 591
#define POSITION 592
#define PRECEDING 593
#define PRECISION 594
#define PRESERVE 595
#define PREPARE 596
#define PREPARED 597
#define PRIMARY 598
#define PRIOR 599
#define PRIVILEGES 600
#define PROCEDURAL 601
#define PROCEDURE 602
#define QUOTE 603
#define RANGE 604
#define READ 605
#define REAL 606
#define REASSIGN 607
#define RECHECK 608
#define RECURSIVE 609
#define REFERENCES 610
#define REINDEX 611
#define RELATIVE_P 612
#define RELEASE 613
#define RENAME 614
#define REPEATABLE 615
#define REPLACE 616
#define REPLICA 617
#define RESET 618
#define RESTART 619
#define RESTRICT 620
#define RETURNING 621
#define RETURNS 622
#define REVOKE 623
#define RIGHT 624
#define ROLE 625
#define ROLLBACK 626
#define ROW 627
#define ROWS 628
#define RULE 629
#define SAVEPOINT 630
#define SCHEMA 631
#define SCROLL 632
#define SEARCH 633
#define SECOND_P 634
#define SECURITY 635
#define SELECT 636
#define SEQUENCE 637
#define SERIALIZABLE 638
#define SERVER 639
#define SESSION 640
#define SESSION_USER 641
#define SET 642
#define SETOF 643
#define SHARE 644
#define SHOW 645
#define SIMILAR 646
#define SIMPLE 647
#define SMALLINT 648
#define SOME 649
#define STABLE 650
#define STANDALONE_P 651
#define START 652
#define STATEMENT 653
#define STATISTICS 654
#define STDIN 655
#define STDOUT 656
#define STORAGE 657
#define STRICT_P 658
#define STRIP_P 659
#define SUBSTRING 660
#define SUPERUSER_P 661
#define SYMMETRIC 662
#define SYSID 663
#define SYSTEM_P 664
#define TABLE 665
#define TABLESPACE 666
#define TEMP 667
#define TEMPLATE 668
#define TEMPORARY 669
#define TEXT_P 670
#define THEN 671
#define TIME 672
#define TIMESTAMP 673
#define TO 674
#define TRAILING 675
#define TRANSACTION 676
#define TREAT 677
#define TRIGGER 678
#define TRIM 679
#define TRUE_P 680
#define TRUNCATE 681
#define TRUSTED 682
#define TYPE_P 683
#define UNBOUNDED 684
#define UNCOMMITTED 685
#define UNENCRYPTED 686
#define UNION 687
#define UNIQUE 688
#define UNKNOWN 689
#define UNLISTEN 690
#define UNTIL 691
#define UPDATE 692
#define USER 693
#define USING 694
#define VACUUM 695
#define VALID 696
#define VALIDATOR 697
#define VALUE_P 698
#define VALUES 699
#define VARCHAR 700
#define VARIADIC 701
#define VARYING 702
#define VERBOSE 703
#define VERSION_P 704
#define VIEW 705
#define VOLATILE 706
#define WHEN 707
#define WHERE 708
#define WHITESPACE_P 709
#define WINDOW 710
#define WITH 711
#define WITHOUT 712
#define WORK 713
#define WRAPPER 714
#define WRITE 715
#define XML_P 716
#define XMLATTRIBUTES 717
#define XMLCONCAT 718
#define XMLELEMENT 719
#define XMLFOREST 720
#define XMLPARSE 721
#define XMLPI 722
#define XMLROOT 723
#define XMLSERIALIZE 724
#define YEAR_P 725
#define YES_P 726
#define ZONE 727
#define NULLS_FIRST 728
#define NULLS_LAST 729
#define WITH_TIME 730
#define IDENT 731
#define FCONST 732
#define SCONST 733
#define BCONST 734
#define XCONST 735
#define Op 736
#define ICONST 737
#define PARAM 738
#define POSTFIXOP 739
#define UMINUS 740




/* Copy the first part of user declarations.  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);
			
			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->lineno), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 387 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1447 "preproc.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1471 "preproc.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   84963

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  505
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  617
/* YYNRULES -- Number of rules. */
#define YYNRULES  2436
/* YYNRULES -- Number of states. */
#define YYNSTATES  4237

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   740

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   492,     2,     2,
     497,   498,   490,   488,   500,   489,   499,   491,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   502,   501,
     485,   484,   486,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   495,     2,   496,   493,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   503,     2,   504,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   487,
     494
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   244,   250,   252,   253,   256,   257,   260,
     263,   267,   271,   273,   275,   277,   279,   281,   283,   285,
     287,   289,   291,   293,   295,   299,   303,   306,   309,   312,
     315,   319,   323,   329,   335,   340,   346,   351,   355,   361,
     365,   371,   377,   384,   386,   388,   392,   398,   405,   410,
     412,   413,   416,   417,   419,   421,   423,   425,   427,   429,
     432,   436,   440,   444,   448,   452,   456,   460,   464,   467,
     473,   476,   479,   482,   485,   489,   493,   497,   499,   503,
     505,   509,   511,   513,   515,   518,   521,   524,   526,   528,
     530,   532,   534,   536,   538,   542,   549,   551,   553,   555,
     557,   559,   560,   562,   564,   567,   571,   576,   580,   583,
     586,   588,   592,   597,   603,   608,   611,   616,   618,   620,
     622,   624,   626,   629,   632,   635,   638,   643,   648,   653,
     658,   660,   664,   668,   673,   680,   687,   694,   701,   706,
     714,   717,   722,   726,   730,   734,   738,   742,   747,   752,
     756,   760,   764,   768,   772,   776,   781,   786,   790,   793,
     797,   801,   805,   808,   811,   815,   818,   820,   822,   823,
     826,   827,   831,   834,   835,   837,   841,   845,   847,   853,
     857,   860,   863,   874,   881,   883,   885,   887,   889,   891,
     894,   895,   897,   899,   903,   907,   909,   911,   915,   919,
     923,   928,   930,   931,   934,   935,   939,   940,   942,   943,
     955,   968,   970,   972,   975,   978,   981,   984,   985,   987,
     988,   990,   994,   996,   998,  1000,  1004,  1007,  1008,  1012,
    1014,  1016,  1019,  1021,  1025,  1030,  1035,  1038,  1044,  1046,
    1049,  1052,  1055,  1059,  1062,  1063,  1066,  1069,  1072,  1075,
    1078,  1081,  1085,  1087,  1092,  1099,  1107,  1119,  1123,  1124,
    1126,  1130,  1132,  1135,  1138,  1141,  1142,  1144,  1146,  1149,
    1152,  1153,  1157,  1161,  1164,  1166,  1168,  1171,  1174,  1179,
    1180,  1183,  1186,  1189,  1190,  1194,  1199,  1204,  1205,  1208,
    1209,  1214,  1215,  1221,  1225,  1226,  1228,  1232,  1234,  1237,
    1241,  1242,  1248,  1253,  1255,  1256,  1258,  1261,  1264,  1266,
    1269,  1273,  1276,  1279,  1282,  1285,  1289,  1293,  1295,  1299,
    1301,  1302,  1304,  1307,  1309,  1315,  1325,  1327,  1328,  1330,
    1333,  1336,  1339,  1341,  1342,  1345,  1346,  1352,  1360,  1362,
    1363,  1370,  1373,  1374,  1378,  1384,  1392,  1399,  1408,  1416,
    1423,  1430,  1435,  1436,  1438,  1442,  1447,  1449,  1453,  1455,
    1458,  1461,  1464,  1467,  1469,  1471,  1482,  1485,  1486,  1489,
    1492,  1494,  1495,  1500,  1507,  1513,  1518,  1523,  1532,  1534,
    1536,  1538,  1546,  1556,  1565,  1580,  1600,  1602,  1604,  1606,
    1610,  1616,  1618,  1620,  1622,  1624,  1628,  1629,  1631,  1632,
    1634,  1636,  1638,  1642,  1643,  1645,  1647,  1649,  1651,  1653,
    1655,  1658,  1659,  1661,  1664,  1666,  1669,  1670,  1673,  1675,
    1678,  1681,  1688,  1697,  1706,  1711,  1717,  1722,  1727,  1732,
    1736,  1744,  1753,  1760,  1767,  1774,  1781,  1785,  1787,  1791,
    1795,  1797,  1799,  1801,  1803,  1805,  1807,  1811,  1815,  1819,
    1821,  1825,  1829,  1831,  1835,  1849,  1851,  1855,  1860,  1866,
    1871,  1879,  1882,  1884,  1885,  1888,  1889,  1891,  1892,  1899,
    1908,  1917,  1919,  1923,  1929,  1935,  1943,  1953,  1961,  1971,
    1977,  1984,  1991,  1996,  1998,  2000,  2002,  2004,  2006,  2008,
    2010,  2012,  2016,  2020,  2024,  2028,  2030,  2034,  2036,  2039,
    2042,  2046,  2052,  2055,  2058,  2059,  2066,  2074,  2082,  2090,
    2099,  2108,  2115,  2124,  2134,  2144,  2152,  2163,  2171,  2180,
    2189,  2198,  2207,  2209,  2211,  2213,  2215,  2217,  2219,  2221,
    2223,  2225,  2227,  2229,  2231,  2233,  2235,  2240,  2243,  2248,
    2251,  2257,  2262,  2267,  2271,  2275,  2279,  2281,  2283,  2285,
    2287,  2290,  2293,  2295,  2297,  2299,  2302,  2305,  2307,  2310,
    2313,  2315,  2317,  2325,  2333,  2344,  2346,  2348,  2351,  2356,
    2362,  2364,  2368,  2371,  2374,  2377,  2380,  2382,  2385,  2388,
    2393,  2397,  2400,  2403,  2406,  2409,  2412,  2414,  2418,  2420,
    2423,  2427,  2428,  2430,  2434,  2437,  2444,  2451,  2461,  2465,
    2466,  2470,  2471,  2485,  2500,  2502,  2503,  2506,  2507,  2509,
    2513,  2518,  2523,  2530,  2532,  2535,  2536,  2538,  2540,  2541,
    2543,  2545,  2546,  2556,  2569,  2577,  2580,  2581,  2585,  2588,
    2590,  2594,  2598,  2601,  2603,  2607,  2611,  2615,  2618,  2621,
    2623,  2625,  2627,  2629,  2632,  2634,  2636,  2638,  2640,  2645,
    2651,  2653,  2657,  2661,  2663,  2666,  2671,  2677,  2679,  2681,
    2683,  2685,  2689,  2693,  2696,  2699,  2702,  2705,  2707,  2710,
    2713,  2715,  2717,  2719,  2723,  2726,  2727,  2730,  2732,  2736,
    2742,  2744,  2747,  2749,  2750,  2756,  2764,  2770,  2778,  2784,
    2792,  2796,  2802,  2808,  2814,  2816,  2820,  2832,  2843,  2854,
    2857,  2860,  2861,  2871,  2874,  2875,  2880,  2885,  2890,  2892,
    2894,  2896,  2897,  2905,  2912,  2919,  2926,  2933,  2941,  2951,
    2961,  2968,  2975,  2982,  2989,  2996,  3005,  3014,  3021,  3028,
    3035,  3044,  3053,  3062,  3071,  3078,  3080,  3081,  3084,  3085,
    3093,  3100,  3107,  3114,  3121,  3128,  3135,  3143,  3150,  3157,
    3164,  3171,  3179,  3187,  3197,  3207,  3214,  3221,  3228,  3237,
    3246,  3255,  3262,  3264,  3266,  3270,  3274,  3276,  3278,  3280,
    3282,  3284,  3286,  3288,  3289,  3291,  3293,  3295,  3297,  3299,
    3301,  3302,  3309,  3318,  3321,  3324,  3327,  3330,  3333,  3337,
    3341,  3344,  3347,  3350,  3353,  3357,  3360,  3366,  3371,  3375,
    3379,  3383,  3385,  3387,  3388,  3392,  3395,  3398,  3400,  3404,
    3407,  3409,  3410,  3419,  3430,  3434,  3439,  3444,  3445,  3448,
    3454,  3457,  3458,  3462,  3466,  3470,  3474,  3478,  3482,  3486,
    3490,  3494,  3498,  3502,  3506,  3510,  3515,  3519,  3523,  3525,
    3526,  3532,  3539,  3544,  3547,  3548,  3553,  3557,  3563,  3570,
    3575,  3582,  3589,  3595,  3603,  3605,  3606,  3613,  3625,  3637,
    3649,  3663,  3673,  3685,  3696,  3701,  3704,  3710,  3713,  3714,
    3719,  3725,  3731,  3734,  3739,  3741,  3743,  3745,  3746,  3748,
    3749,  3751,  3752,  3756,  3757,  3762,  3764,  3766,  3768,  3770,
    3772,  3774,  3776,  3778,  3779,  3785,  3790,  3794,  3795,  3797,
    3799,  3801,  3803,  3808,  3817,  3821,  3822,  3828,  3830,  3835,
    3838,  3840,  3844,  3847,  3850,  3851,  3858,  3861,  3862,  3868,
    3872,  3873,  3876,  3879,  3882,  3886,  3888,  3892,  3894,  3897,
    3899,  3900,  3908,  3910,  3914,  3916,  3918,  3922,  3928,  3931,
    3933,  3937,  3945,  3946,  3950,  3953,  3956,  3959,  3960,  3963,
    3966,  3968,  3970,  3974,  3978,  3980,  3983,  3988,  3993,  3996,
    4000,  4006,  4012,  4014,  4016,  4026,  4028,  4031,  4036,  4041,
    4046,  4049,  4053,  4055,  4059,  4064,  4067,  4069,  4070,  4074,
    4078,  4083,  4088,  4093,  4098,  4101,  4103,  4105,  4106,  4108,
    4110,  4111,  4113,  4119,  4121,  4122,  4124,  4125,  4129,  4131,
    4135,  4140,  4144,  4149,  4154,  4157,  4160,  4165,  4169,  4175,
    4184,  4186,  4187,  4189,  4191,  4193,  4197,  4198,  4200,  4202,
    4204,  4206,  4208,  4210,  4214,  4215,  4218,  4219,  4221,  4225,
    4227,  4228,  4230,  4233,  4238,  4243,  4246,  4247,  4250,  4254,
    4257,  4258,  4260,  4264,  4266,  4269,  4271,  4274,  4280,  4287,
    4293,  4295,  4298,  4300,  4305,  4309,  4314,  4320,  4325,  4331,
    4336,  4342,  4345,  4350,  4352,  4355,  4358,  4361,  4363,  4365,
    4366,  4371,  4374,  4376,  4379,  4382,  4387,  4389,  4393,  4395,
    4398,  4402,  4404,  4407,  4408,  4411,  4416,  4421,  4422,  4424,
    4428,  4431,  4434,  4438,  4444,  4451,  4454,  4458,  4462,  4467,
    4468,  4470,  4472,  4474,  4476,  4478,  4481,  4487,  4489,  4491,
    4493,  4495,  4498,  4502,  4506,  4507,  4509,  4511,  4513,  4515,
    4517,  4520,  4523,  4526,  4529,  4532,  4534,  4538,  4539,  4541,
    4543,  4545,  4547,  4553,  4556,  4558,  4560,  4562,  4564,  4570,
    4573,  4576,  4579,  4581,  4585,  4589,  4592,  4594,  4595,  4599,
    4600,  4606,  4609,  4615,  4618,  4620,  4623,  4627,  4628,  4630,
    4632,  4634,  4636,  4638,  4640,  4644,  4648,  4652,  4656,  4660,
    4664,  4668,  4669,  4671,  4676,  4678,  4682,  4688,  4691,  4694,
    4698,  4702,  4706,  4710,  4714,  4718,  4722,  4726,  4730,  4734,
    4737,  4740,  4744,  4748,  4751,  4755,  4761,  4766,  4773,  4777,
    4783,  4788,  4795,  4800,  4807,  4813,  4821,  4825,  4828,  4833,
    4836,  4840,  4844,  4849,  4853,  4858,  4862,  4867,  4873,  4880,
    4887,  4895,  4902,  4910,  4917,  4925,  4929,  4934,  4939,  4946,
    4949,  4953,  4958,  4960,  4964,  4967,  4970,  4974,  4978,  4982,
    4986,  4990,  4994,  4998,  5002,  5006,  5010,  5013,  5016,  5022,
    5029,  5036,  5044,  5048,  5053,  5055,  5057,  5060,  5065,  5067,
    5069,  5071,  5074,  5077,  5080,  5082,  5087,  5093,  5100,  5109,
    5116,  5123,  5129,  5131,  5133,  5138,  5140,  5145,  5147,  5152,
    5154,  5159,  5161,  5163,  5165,  5167,  5169,  5171,  5178,  5183,
    5188,  5193,  5198,  5205,  5211,  5217,  5223,  5228,  5235,  5240,
    5245,  5250,  5255,  5261,  5269,  5277,  5287,  5292,  5299,  5305,
    5313,  5321,  5329,  5332,  5336,  5340,  5344,  5349,  5350,  5355,
    5357,  5361,  5365,  5367,  5369,  5371,  5374,  5377,  5378,  5381,
    5382,  5384,  5388,  5392,  5395,  5398,  5399,  5406,  5408,  5409,
    5413,  5414,  5417,  5420,  5421,  5423,  5428,  5431,  5434,  5437,
    5442,  5446,  5452,  5454,  5456,  5458,  5460,  5462,  5464,  5466,
    5468,  5470,  5472,  5474,  5476,  5478,  5480,  5482,  5487,  5489,
    5494,  5496,  5501,  5503,  5506,  5508,  5511,  5513,  5517,  5519,
    5523,  5527,  5531,  5534,  5536,  5540,  5544,  5545,  5547,  5549,
    5551,  5553,  5555,  5557,  5559,  5561,  5566,  5570,  5573,  5577,
    5578,  5582,  5586,  5589,  5592,  5594,  5595,  5598,  5601,  5605,
    5608,  5610,  5612,  5616,  5622,  5624,  5627,  5632,  5635,  5636,
    5638,  5639,  5641,  5644,  5647,  5650,  5654,  5660,  5662,  5665,
    5666,  5669,  5671,  5672,  5674,  5676,  5678,  5682,  5686,  5688,
    5692,  5696,  5699,  5701,  5703,  5705,  5707,  5709,  5713,  5715,
    5718,  5720,  5724,  5726,  5728,  5730,  5732,  5734,  5736,  5738,
    5741,  5743,  5745,  5747,  5749,  5751,  5754,  5760,  5763,  5767,
    5774,  5776,  5778,  5780,  5782,  5784,  5786,  5788,  5790,  5792,
    5795,  5798,  5800,  5802,  5804,  5806,  5808,  5810,  5812,  5814,
    5816,  5818,  5820,  5822,  5824,  5826,  5828,  5830,  5832,  5834,
    5836,  5838,  5840,  5842,  5844,  5846,  5848,  5850,  5852,  5854,
    5856,  5858,  5860,  5862,  5864,  5866,  5868,  5870,  5872,  5874,
    5876,  5878,  5880,  5882,  5884,  5886,  5888,  5890,  5892,  5894,
    5896,  5898,  5900,  5902,  5904,  5906,  5908,  5910,  5912,  5914,
    5916,  5918,  5920,  5922,  5924,  5926,  5928,  5930,  5932,  5934,
    5936,  5938,  5940,  5942,  5944,  5946,  5948,  5950,  5952,  5954,
    5956,  5958,  5960,  5962,  5964,  5966,  5968,  5970,  5972,  5974,
    5976,  5978,  5980,  5982,  5984,  5986,  5988,  5990,  5992,  5994,
    5996,  5998,  6000,  6002,  6004,  6006,  6008,  6010,  6012,  6014,
    6016,  6018,  6020,  6022,  6024,  6026,  6028,  6030,  6032,  6034,
    6036,  6038,  6040,  6042,  6044,  6046,  6048,  6050,  6052,  6054,
    6056,  6058,  6060,  6062,  6064,  6066,  6068,  6070,  6072,  6074,
    6076,  6078,  6080,  6082,  6084,  6086,  6088,  6090,  6092,  6094,
    6096,  6098,  6100,  6102,  6104,  6106,  6108,  6110,  6111,  6114,
    6119,  6123,  6126,  6128,  6130,  6132,  6134,  6136,  6137,  6146,
    6147,  6162,  6165,  6171,  6175,  6178,  6181,  6185,  6193,  6195,
    6197,  6199,  6200,  6203,  6206,  6208,  6209,  6211,  6215,  6217,
    6220,  6221,  6224,  6225,  6228,  6229,  6231,  6235,  6240,  6244,
    6246,  6248,  6250,  6252,  6255,  6256,  6259,  6264,  6265,  6268,
    6271,  6274,  6276,  6278,  6286,  6290,  6292,  6294,  6296,  6298,
    6301,  6302,  6304,  6308,  6312,  6316,  6320,  6321,  6326,  6332,
    6338,  6339,  6341,  6343,  6345,  6347,  6350,  6353,  6356,  6358,
    6361,  6362,  6370,  6371,  6377,  6378,  6383,  6386,  6389,  6390,
    6393,  6395,  6397,  6399,  6401,  6403,  6405,  6407,  6409,  6411,
    6413,  6415,  6421,  6424,  6426,  6430,  6433,  6436,  6440,  6441,
    6447,  6449,  6450,  6456,  6459,  6462,  6464,  6466,  6468,  6471,
    6474,  6478,  6480,  6483,  6486,  6490,  6494,  6499,  6502,  6504,
    6507,  6509,  6511,  6514,  6517,  6521,  6523,  6525,  6527,  6529,
    6530,  6532,  6536,  6542,  6543,  6546,  6547,  6549,  6552,  6556,
    6559,  6561,  6563,  6565,  6566,  6568,  6570,  6572,  6574,  6576,
    6579,  6582,  6586,  6587,  6589,  6592,  6594,  6599,  6604,  6605,
    6607,  6609,  6613,  6615,  6617,  6619,  6621,  6624,  6627,  6629,
    6632,  6635,  6637,  6639,  6641,  6646,  6651,  6656,  6658,  6659,
    6663,  6667,  6672,  6674,  6678,  6682,  6687,  6689,  6693,  6697,
    6699,  6701,  6703,  6710,  6712,  6716,  6720,  6727,  6729,  6733,
    6737,  6739,  6741,  6744,  6747,  6749,  6751,  6753,  6755,  6757,
    6759,  6761,  6763,  6765,  6767,  6769,  6771,  6773,  6775,  6777,
    6779,  6784,  6789,  6791,  6793,  6798,  6803,  6807,  6808,  6816,
    6818,  6819,  6820,  6828,  6832,  6837,  6841,  6843,  6845,  6847,
    6850,  6854,  6860,  6863,  6869,  6872,  6874,  6876,  6878,  6880,
    6882,  6884,  6886,  6888,  6890,  6892,  6894,  6896,  6898,  6900,
    6902,  6904,  6906,  6908,  6910,  6912,  6914,  6916,  6918,  6920,
    6922,  6924,  6926,  6928,  6930,  6932,  6934,  6936,  6938,  6940,
    6942,  6944,  6946,  6948,  6950,  6952,  6954,  6956,  6958,  6960,
    6962,  6964,  6966,  6968,  6970,  6972,  6974,  6976,  6978,  6980,
    6982,  6984,  6986,  6988,  6990,  6992,  6994,  6996,  6998,  7000,
    7002,  7004,  7006,  7008,  7010,  7012,  7014,  7016,  7018,  7020,
    7022,  7024,  7026,  7028,  7030,  7032,  7034,  7036,  7038,  7040,
    7042,  7044,  7046,  7048,  7050,  7052,  7054,  7056,  7058,  7060,
    7062,  7064,  7066,  7068,  7070,  7072,  7074,  7076,  7078,  7080,
    7082,  7084,  7086,  7088,  7090,  7092,  7094,  7096,  7098,  7100,
    7102,  7104,  7106,  7108,  7110,  7112,  7114,  7116,  7118,  7120,
    7122,  7124,  7126,  7128,  7130,  7132,  7134,  7136,  7138,  7140,
    7142,  7144,  7146,  7148,  7150,  7152,  7154,  7156,  7158,  7160,
    7162,  7164,  7166,  7168,  7170,  7172,  7174,  7176,  7178,  7180,
    7182,  7184,  7186,  7188,  7190,  7192,  7194,  7196,  7198,  7200,
    7202,  7204,  7206,  7208,  7210,  7212,  7214,  7216,  7218,  7220,
    7222,  7224,  7226,  7228,  7230,  7232,  7234,  7236,  7238,  7240,
    7242,  7244,  7246,  7248,  7250,  7252,  7254,  7256,  7258,  7260,
    7262,  7264,  7266,  7268,  7270,  7272,  7274,  7276,  7278,  7280,
    7282,  7284,  7286,  7288,  7290,  7292,  7294,  7296,  7298,  7300,
    7302,  7304,  7306,  7308,  7310,  7312,  7314,  7316,  7318,  7320,
    7322,  7324,  7326,  7328,  7330,  7332,  7334,  7336,  7338,  7340,
    7342,  7344,  7346,  7348,  7350,  7352,  7354,  7356,  7358,  7360,
    7362,  7364,  7366,  7368,  7370,  7372,  7374,  7376,  7378,  7380,
    7382,  7384,  7386,  7388,  7390,  7392,  7394,  7396,  7398,  7400,
    7402,  7404,  7406,  7408,  7410,  7412,  7414,  7416,  7418,  7420,
    7422,  7424,  7426,  7428,  7430,  7432,  7434,  7436,  7438,  7440,
    7442,  7444,  7446,  7448,  7450,  7452,  7454,  7456,  7458,  7460,
    7462,  7464,  7466,  7468,  7470,  7472,  7474,  7476,  7478,  7480,
    7482,  7484,  7488,  7490,  7491,  7493,  7496,  7498,  7501,  7503,
    7505,  7508,  7511,  7513,  7515,  7517,  7519,  7521,  7523,  7525,
    7527,  7529,  7531,  7533,  7535,  7537,  7539,  7541,  7543,  7546,
    7550,  7552,  7555,  7557,  7561,  7563,  7567,  7569,  7571,  7573,
    7575,  7577,  7579,  7581,  7583,  7585,  7587,  7589,  7591,  7593,
    7595,  7597,  7599,  7601,  7603,  7605,  7607,  7609,  7611,  7613,
    7615,  7617,  7619,  7621,  7623,  7625,  7627,  7629,  7631,  7633,
    7635,  7637,  7639,  7641,  7643,  7645,  7647,  7649,  7651,  7653,
    7655,  7657,  7659,  7661,  7663,  7665,  7667,  7669,  7671,  7673,
    7675,  7677,  7679,  7681,  7683,  7685,  7687,  7689,  7692,  7696,
    7699,  7703,  7705,  7709,  7713,  7717,  7721,  7725,  7729,  7731,
    7733,  7734,  7737,  7740,  7742,  7744,  7747
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     506,     0,    -1,   974,    -1,   774,    -1,   775,    -1,   780,
      -1,   618,    -1,   632,    -1,   732,    -1,   520,    -1,   750,
      -1,   751,    -1,   599,    -1,   545,    -1,   514,    -1,   513,
      -1,   783,    -1,   782,    -1,   636,    -1,   516,    -1,   515,
      -1,   788,    -1,   543,    -1,   555,    -1,   785,    -1,   684,
      -1,   540,    -1,   556,    -1,   976,    -1,   651,    -1,   740,
      -1,   784,    -1,   779,    -1,   616,    -1,   627,    -1,   713,
      -1,   519,    -1,   663,    -1,   669,    -1,   670,    -1,   605,
      -1,   523,    -1,   598,    -1,   565,    -1,   613,    -1,   637,
      -1,   508,    -1,   512,    -1,   633,    -1,   770,    -1,  1118,
      -1,   820,    -1,   653,    -1,   807,    -1,   544,    -1,   652,
      -1,   742,    -1,   617,    -1,   631,    -1,   522,    -1,   673,
      -1,   674,    -1,   675,    -1,   611,    -1,   758,    -1,   677,
      -1,   615,    -1,   650,    -1,   517,    -1,   518,    -1,   635,
      -1,   778,    -1,   800,    -1,   794,    -1,   687,    -1,   690,
      -1,   701,    -1,   705,    -1,   802,    -1,   760,    -1,   769,
      -1,   809,    -1,   759,    -1,   797,    -1,   676,    -1,   744,
      -1,   736,    -1,   735,    -1,   737,    -1,   747,    -1,   691,
      -1,   702,    -1,   978,    -1,   823,    -1,   762,    -1,   682,
      -1,   761,    -1,   813,    -1,   787,    -1,   537,    -1,   527,
      -1,   539,    -1,   767,    -1,  1055,    -1,   981,    -1,   998,
      -1,  1056,    -1,  1038,    -1,  1053,    -1,  1039,    -1,   999,
      -1,  1043,    -1,  1065,    -1,  1057,    -1,  1044,    -1,  1073,
      -1,  1075,    -1,  1068,    -1,  1060,    -1,  1076,    -1,  1079,
      -1,  1081,    -1,    -1,   147,   370,   966,   509,   510,    -1,
     456,    -1,    -1,   510,   511,    -1,    -1,   334,  1108,    -1,
     334,   307,    -1,   192,   334,  1108,    -1,   431,   334,  1108,
      -1,   406,    -1,   301,    -1,   239,    -1,   298,    -1,   148,
      -1,   295,    -1,   149,    -1,   296,    -1,   150,    -1,   297,
      -1,   278,    -1,   299,    -1,   139,   270,   967,    -1,   441,
     436,  1108,    -1,   438,   956,    -1,   408,   965,    -1,    86,
     956,    -1,   370,   956,    -1,   234,   370,   956,    -1,   234,
     222,   956,    -1,   147,   438,   966,   509,   510,    -1,    91,
     370,   966,   509,   510,    -1,    91,   370,   966,   538,    -1,
      91,   438,   966,   509,   510,    -1,    91,   438,   966,   538,
      -1,   187,   370,   956,    -1,   187,   370,   229,   200,   956,
      -1,   187,   438,   956,    -1,   187,   438,   229,   200,   956,
      -1,   147,   222,   966,   509,   510,    -1,    91,   222,   966,
     521,   438,   956,    -1,    85,    -1,   187,    -1,   187,   222,
     956,    -1,   187,   222,   229,   200,   956,    -1,   147,   376,
     524,   104,   966,   525,    -1,   147,   376,   968,   525,    -1,
     968,    -1,    -1,   525,   526,    -1,    -1,   565,    -1,   705,
      -1,   598,    -1,   637,    -1,   690,    -1,   767,    -1,   387,
     528,    -1,   387,   273,   528,    -1,   387,   385,   528,    -1,
     529,   419,   530,    -1,   529,   484,   530,    -1,   529,   419,
     170,    -1,   529,   484,   170,    -1,   529,   215,   153,    -1,
     417,   472,   534,    -1,   421,   765,    -1,   385,   125,    98,
     421,   765,    -1,   121,  1108,    -1,   376,  1108,    -1,   288,
     535,    -1,   370,   536,    -1,   385,   104,   536,    -1,   385,
     104,   170,    -1,   461,   320,   905,    -1,  1088,    -1,   529,
     499,   968,    -1,   531,    -1,   530,   500,   531,    -1,   533,
      -1,   536,    -1,   604,    -1,   350,   430,    -1,   350,   136,
      -1,   360,   350,    -1,   383,    -1,   425,    -1,   204,    -1,
     317,    -1,   313,    -1,  1108,    -1,  1110,    -1,   892,  1108,
     894,    -1,   892,   497,   965,   498,  1108,   894,    -1,   604,
      -1,   170,    -1,   273,    -1,  1108,    -1,   170,    -1,    -1,
     968,    -1,  1108,    -1,   363,   529,    -1,   363,   417,   472,
      -1,   363,   421,   256,   268,    -1,   363,   385,   104,    -1,
     363,    89,    -1,   387,   528,    -1,   537,    -1,   390,   529,
    1121,    -1,   390,   417,   472,  1121,    -1,   390,   421,   256,
     268,  1121,    -1,   390,   385,   104,  1121,    -1,   390,    89,
      -1,   387,   141,   541,   542,    -1,    89,    -1,   954,    -1,
     173,    -1,   231,    -1,   127,    -1,   181,    89,    -1,   181,
     412,    -1,   181,   414,    -1,   181,   336,    -1,    91,   410,
     864,   546,    -1,    91,   237,   955,   546,    -1,    91,   382,
     955,   546,    -1,    91,   450,   955,   546,    -1,   547,    -1,
     546,   500,   547,    -1,    85,   748,   570,    -1,    91,   748,
     968,   548,    -1,    91,   748,   968,   187,   302,   307,    -1,
      91,   748,   968,   387,   302,   307,    -1,    91,   748,   968,
     387,   399,   967,    -1,    91,   748,   968,   387,   402,   968,
      -1,   187,   748,   968,   549,    -1,    91,   748,   968,   749,
     428,   872,   550,    -1,    85,   578,    -1,   187,   140,   957,
     549,    -1,   387,   456,   315,    -1,   387,   457,   315,    -1,
     130,   317,   957,    -1,   387,   457,   130,    -1,   190,   423,
     957,    -1,   190,    92,   423,   957,    -1,   190,   362,   423,
     957,    -1,   190,   423,    89,    -1,   190,   423,   438,    -1,
     180,   423,   957,    -1,   180,   423,    89,    -1,   180,   423,
     438,    -1,   190,   374,   957,    -1,   190,    92,   374,   957,
      -1,   190,   362,   374,   957,    -1,   180,   374,   957,    -1,
     239,   955,    -1,   294,   239,   955,    -1,   330,   419,   966,
      -1,   387,   411,   957,    -1,   387,   551,    -1,   363,   551,
      -1,   387,   170,   896,    -1,   187,   170,    -1,   117,    -1,
     365,    -1,    -1,   439,   896,    -1,    -1,   497,   553,   498,
      -1,   456,   551,    -1,    -1,   554,    -1,   553,   500,   554,
      -1,  1089,   484,   657,    -1,  1089,    -1,  1089,   499,  1089,
     484,   657,    -1,  1089,   499,  1089,    -1,   129,   957,    -1,
     129,    89,    -1,   145,   561,   955,   580,   562,   557,   558,
     563,   509,   559,    -1,   145,   824,   419,   558,   509,   559,
      -1,   215,    -1,   419,    -1,  1108,    -1,   400,    -1,   401,
      -1,   559,   560,    -1,    -1,   110,    -1,   315,    -1,   176,
     781,  1108,    -1,   307,   781,  1108,    -1,   152,    -1,   225,
      -1,   348,   781,  1108,    -1,   195,   781,  1108,    -1,   211,
     348,   581,    -1,   211,   302,   307,   581,    -1,   110,    -1,
      -1,   456,   315,    -1,    -1,   564,   177,  1108,    -1,    -1,
     439,    -1,    -1,   147,   566,   410,   955,   497,   567,   498,
     588,   589,   590,   591,    -1,   147,   566,   410,   955,   312,
     955,   497,   567,   498,   589,   590,   591,    -1,   414,    -1,
     412,    -1,   273,   414,    -1,   273,   412,    -1,   218,   414,
      -1,   218,   412,    -1,    -1,   568,    -1,    -1,   569,    -1,
     568,   500,   569,    -1,   570,    -1,   575,    -1,   578,    -1,
     968,   872,   571,    -1,   571,   572,    -1,    -1,   140,   957,
     573,    -1,   573,    -1,   574,    -1,   302,   307,    -1,   307,
      -1,   433,   729,   592,    -1,   343,   258,   729,   592,    -1,
     126,   497,   896,   498,    -1,   170,   897,    -1,   355,   955,
     580,   583,   584,    -1,   172,    -1,   302,   172,    -1,   241,
     173,    -1,   241,   231,    -1,   269,   955,   576,    -1,   576,
     577,    -1,    -1,   235,   171,    -1,   197,   171,    -1,   235,
     141,    -1,   197,   141,    -1,   235,   238,    -1,   197,   238,
      -1,   140,   957,   579,    -1,   579,    -1,   126,   497,   896,
     498,    -1,   433,   497,   581,   498,   729,   592,    -1,   343,
     258,   497,   581,   498,   729,   592,    -1,   212,   258,   497,
     581,   498,   355,   955,   580,   583,   584,   647,    -1,   497,
     581,   498,    -1,    -1,   582,    -1,   581,   500,   582,    -1,
     968,    -1,   280,   216,    -1,   280,   332,    -1,   280,   392,
      -1,    -1,   585,    -1,   586,    -1,   585,   586,    -1,   586,
     585,    -1,    -1,   317,   437,   587,    -1,   317,   175,   587,
      -1,   294,    84,    -1,   365,    -1,   117,    -1,   387,   307,
      -1,   387,   170,    -1,   240,   497,   954,   498,    -1,    -1,
     456,   551,    -1,   456,   315,    -1,   457,   315,    -1,    -1,
     317,   135,   187,    -1,   317,   135,   175,   373,    -1,   317,
     135,   340,   373,    -1,    -1,   411,   957,    -1,    -1,   439,
     237,   411,   957,    -1,    -1,   955,   594,   589,   590,   591,
      -1,   497,   595,   498,    -1,    -1,   596,    -1,   595,   500,
     596,    -1,   968,    -1,   456,   163,    -1,   456,   294,   163,
      -1,    -1,   147,   566,   382,   955,   600,    -1,    91,   382,
     955,   601,    -1,   601,    -1,    -1,   602,    -1,   601,   602,
      -1,   115,   604,    -1,   162,    -1,   294,   162,    -1,   236,
     603,   604,    -1,   281,   604,    -1,   283,   604,    -1,   294,
     281,    -1,   294,   283,    -1,   329,   114,   680,    -1,   397,
     509,   604,    -1,   364,    -1,   364,   509,   604,    -1,   114,
      -1,    -1,  1107,    -1,   489,  1107,    -1,   967,    -1,   147,
     606,   612,   260,   536,    -1,   147,   606,   612,   260,   536,
     223,   607,   609,   610,    -1,   427,    -1,    -1,   957,    -1,
     957,   681,    -1,   442,   607,    -1,   294,   442,    -1,   608,
      -1,    -1,   259,  1108,    -1,    -1,   187,   612,   260,   536,
     549,    -1,   187,   612,   260,   229,   200,   536,   549,    -1,
     346,    -1,    -1,   147,   411,   957,   614,   276,  1108,    -1,
     330,   957,    -1,    -1,   187,   411,   957,    -1,   187,   411,
     229,   200,   957,    -1,   147,   212,   163,   459,   957,   609,
     619,    -1,   187,   212,   163,   459,   957,   549,    -1,   187,
     212,   163,   459,   229,   200,   957,   549,    -1,    91,   212,
     163,   459,   957,   608,   621,    -1,    91,   212,   163,   459,
     957,   608,    -1,    91,   212,   163,   459,   957,   621,    -1,
     321,   497,   620,   498,    -1,    -1,   624,    -1,   620,   500,
     624,    -1,   321,   497,   622,   498,    -1,   623,    -1,   622,
     500,   623,    -1,   624,    -1,   387,   624,    -1,    85,   624,
      -1,   187,   625,    -1,   625,   626,    -1,  1089,    -1,  1108,
      -1,   147,   384,   957,   628,   630,   212,   163,   459,   957,
     619,    -1,   428,  1108,    -1,    -1,   449,  1108,    -1,   449,
     307,    -1,   629,    -1,    -1,   187,   384,   957,   549,    -1,
     187,   384,   229,   200,   957,   549,    -1,    91,   384,   957,
     629,   621,    -1,    91,   384,   957,   629,    -1,    91,   384,
     957,   621,    -1,   147,   438,   279,   210,   634,   384,   957,
     619,    -1,   160,    -1,   438,    -1,   966,    -1,   187,   438,
     279,   210,   634,   384,   957,    -1,   187,   438,   279,   229,
     200,   210,   634,   384,   957,    -1,    91,   438,   279,   210,
     634,   384,   957,   621,    -1,   147,   423,   957,   638,   639,
     317,   955,   641,   199,   347,   963,   497,   644,   498,    -1,
     147,   140,   423,   957,    87,   639,   317,   955,   646,   647,
     210,   188,   372,   199,   347,   963,   497,   644,   498,    -1,
     106,    -1,    87,    -1,   640,    -1,   640,   322,   640,    -1,
     640,   322,   640,   322,   640,    -1,   246,    -1,   175,    -1,
     437,    -1,   426,    -1,   210,   642,   643,    -1,    -1,   188,
      -1,    -1,   372,    -1,   398,    -1,   645,    -1,   644,   500,
     645,    -1,    -1,   965,    -1,  1107,    -1,  1108,    -1,  1106,
      -1,   480,    -1,   968,    -1,   215,   955,    -1,    -1,   648,
      -1,   648,   649,    -1,   649,    -1,   649,   648,    -1,    -1,
     302,   172,    -1,   172,    -1,   241,   231,    -1,   241,   173,
      -1,   187,   423,   957,   317,   955,   549,    -1,   187,   423,
     229,   200,   957,   317,   955,   549,    -1,   147,   100,   957,
     126,   497,   896,   498,   647,    -1,   187,   100,   957,   549,
      -1,   147,    88,   963,   658,   654,    -1,   147,    88,   963,
     659,    -1,   147,   319,   739,   654,    -1,   147,   428,   680,
     654,    -1,   147,   428,   680,    -1,   147,   428,   680,    98,
     497,   870,   498,    -1,   147,   428,   680,    98,   194,   497,
     662,   498,    -1,   147,   415,   378,   331,   680,   654,    -1,
     147,   415,   378,   179,   680,   654,    -1,   147,   415,   378,
     413,   680,   654,    -1,   147,   415,   378,   138,   680,   654,
      -1,   497,   655,   498,    -1,   656,    -1,   655,   500,   656,
      -1,  1089,   484,   657,    -1,  1089,    -1,   723,    -1,   972,
      -1,   922,    -1,   604,    -1,  1108,    -1,   497,   925,   498,
      -1,   497,   490,   498,    -1,   497,   660,   498,    -1,   661,
      -1,   660,   500,   661,    -1,  1110,   484,   657,    -1,  1108,
      -1,   662,   500,  1108,    -1,   147,   319,   128,   680,   666,
     210,   428,   872,   439,   959,   667,    98,   664,    -1,   665,
      -1,   664,   500,   665,    -1,   319,   965,   739,   668,    -1,
     319,   965,   739,   738,   668,    -1,   217,   965,   963,   715,
      -1,   217,   965,   497,   925,   498,   963,   715,    -1,   402,
     872,    -1,   170,    -1,    -1,   205,   680,    -1,    -1,   353,
      -1,    -1,   147,   319,   205,   680,   439,   959,    -1,    91,
     319,   205,   680,   439,   959,    85,   664,    -1,    91,   319,
     205,   680,   439,   959,   187,   671,    -1,   672,    -1,   671,
     500,   672,    -1,   319,   965,   497,   925,   498,    -1,   217,
     965,   497,   925,   498,    -1,   187,   319,   128,   680,   439,
     959,   549,    -1,   187,   319,   128,   229,   200,   680,   439,
     959,   549,    -1,   187,   319,   205,   680,   439,   959,   549,
      -1,   187,   319,   205,   229,   200,   680,   439,   959,   549,
      -1,   187,   329,   114,   956,   549,    -1,   352,   329,   114,
     956,   419,   957,    -1,   187,   678,   229,   200,   679,   549,
      -1,   187,   678,   679,   549,    -1,   410,    -1,   382,    -1,
     450,    -1,   237,    -1,   428,    -1,   185,    -1,   144,    -1,
     376,    -1,   415,   378,   331,    -1,   415,   378,   179,    -1,
     415,   378,   413,    -1,   415,   378,   138,    -1,   680,    -1,
     679,   500,   680,    -1,   968,    -1,   968,   681,    -1,   499,
     960,    -1,   681,   499,   960,    -1,   426,   833,   865,   683,
     549,    -1,   143,   228,    -1,   364,   228,    -1,    -1,   134,
     317,   685,   680,   254,   686,    -1,   134,   317,    88,   963,
     658,   254,   686,    -1,   134,   317,   217,   963,   715,   254,
     686,    -1,   134,   317,   319,   739,   738,   254,   686,    -1,
     134,   317,   140,   957,   317,   680,   254,   686,    -1,   134,
     317,   374,   957,   317,   680,   254,   686,    -1,   134,   317,
     374,   957,   254,   686,    -1,   134,   317,   423,   957,   317,
     680,   254,   686,    -1,   134,   317,   319,   128,   680,   439,
     959,   254,   686,    -1,   134,   317,   319,   205,   680,   439,
     959,   254,   686,    -1,   134,   317,   261,   311,   604,   254,
     686,    -1,   134,   317,   120,   497,   872,    98,   872,   498,
     254,   686,    -1,   134,   317,   612,   260,   680,   254,   686,
      -1,   134,   317,   415,   378,   331,   680,   254,   686,    -1,
     134,   317,   415,   378,   179,   680,   254,   686,    -1,   134,
     317,   415,   378,   413,   680,   254,   686,    -1,   134,   317,
     415,   378,   138,   680,   254,   686,    -1,   133,    -1,   164,
      -1,   376,    -1,   237,    -1,   382,    -1,   410,    -1,   185,
      -1,   428,    -1,   450,    -1,   144,    -1,   411,    -1,   370,
      -1,  1108,    -1,   307,    -1,   206,   688,   689,   957,    -1,
     206,   957,    -1,   286,   688,   689,   957,    -1,   286,   957,
      -1,   206,   688,   689,   957,  1121,    -1,   206,   688,   957,
    1121,    -1,   206,   689,   957,  1121,    -1,   206,   957,  1121,
      -1,   206,   688,   957,    -1,   206,   689,   957,    -1,   293,
      -1,   344,    -1,   207,    -1,   262,    -1,    82,   967,    -1,
     357,   967,    -1,   967,    -1,    89,    -1,   213,    -1,   213,
     967,    -1,   213,    89,    -1,   105,    -1,   105,   967,    -1,
     105,    89,    -1,   215,    -1,   234,    -1,   219,   692,   317,
     695,   419,   696,   698,    -1,   368,   692,   317,   695,   215,
     696,   549,    -1,   368,   219,   320,   210,   692,   317,   695,
     215,   696,   549,    -1,   693,    -1,    89,    -1,    89,   345,
      -1,    89,   497,   581,   498,    -1,    89,   345,   497,   581,
     498,    -1,   694,    -1,   693,   500,   694,    -1,   381,   580,
      -1,   355,   580,    -1,   147,   580,    -1,   968,   580,    -1,
     954,    -1,   410,   954,    -1,   382,   954,    -1,   212,   163,
     459,   956,    -1,   212,   384,   956,    -1,   217,   699,    -1,
     164,   956,    -1,   260,   956,    -1,   376,   956,    -1,   411,
     956,    -1,   697,    -1,   696,   500,   697,    -1,   966,    -1,
     222,   966,    -1,   456,   219,   320,    -1,    -1,   700,    -1,
     699,   500,   700,    -1,   963,   715,    -1,   219,   693,   419,
     956,   703,   704,    -1,   368,   693,   215,   956,   704,   549,
      -1,   368,    86,   320,   210,   693,   215,   956,   704,   549,
      -1,   456,    86,   320,    -1,    -1,   220,   114,   966,    -1,
      -1,   147,   706,   237,   961,   317,   955,   707,   497,   708,
     498,   552,   591,   868,    -1,   147,   706,   237,   137,   961,
     317,   955,   707,   497,   708,   498,   552,   591,   868,    -1,
     433,    -1,    -1,   439,   959,    -1,    -1,   709,    -1,   708,
     500,   709,    -1,   968,   710,   711,   712,    -1,   899,   710,
     711,   712,    -1,   497,   896,   498,   710,   711,   712,    -1,
     680,    -1,   439,   680,    -1,    -1,    99,    -1,   178,    -1,
      -1,   473,    -1,   474,    -1,    -1,   147,   714,   217,   963,
     717,   367,   722,   725,   729,    -1,   147,   714,   217,   963,
     717,   367,   410,   497,   731,   498,   725,   729,    -1,   147,
     714,   217,   963,   717,   725,   729,    -1,   322,   361,    -1,
      -1,   497,   716,   498,    -1,   497,   498,    -1,   719,    -1,
     716,   500,   719,    -1,   497,   718,   498,    -1,   497,   498,
      -1,   724,    -1,   718,   500,   724,    -1,   720,   721,   723,
      -1,   721,   720,   723,    -1,   721,   723,    -1,   720,   723,
      -1,   723,    -1,   234,    -1,   324,    -1,   243,    -1,   234,
     324,    -1,   446,    -1,   969,    -1,   723,    -1,   872,    -1,
     969,   681,   492,   428,    -1,   388,   969,   681,   492,   428,
      -1,   719,    -1,   719,   170,   896,    -1,   719,   484,   896,
      -1,   727,    -1,   725,   727,    -1,   116,   317,   307,   244,
      -1,   367,   307,   317,   307,   244,    -1,   403,    -1,   232,
      -1,   395,    -1,   451,    -1,   202,   380,   174,    -1,   202,
     380,   253,    -1,   380,   174,    -1,   380,   253,    -1,   146,
     604,    -1,   373,   604,    -1,   538,    -1,    98,   728,    -1,
     260,   536,    -1,   455,    -1,   726,    -1,  1108,    -1,  1108,
     500,  1108,    -1,   456,   654,    -1,    -1,   721,   723,    -1,
     730,    -1,   731,   500,   730,    -1,    91,   217,   700,   733,
     734,    -1,   726,    -1,   733,   726,    -1,   365,    -1,    -1,
     187,   217,   963,   715,   549,    -1,   187,   217,   229,   200,
     963,   715,   549,    -1,   187,    88,   963,   658,   549,    -1,
     187,    88,   229,   200,   963,   658,   549,    -1,   187,   319,
     739,   738,   549,    -1,   187,   319,   229,   200,   739,   738,
     549,    -1,   497,   872,   498,    -1,   497,   872,   500,   872,
     498,    -1,   497,   300,   500,   872,   498,    -1,   497,   872,
     500,   300,   498,    -1,   919,    -1,   968,   499,   739,    -1,
     147,   120,   497,   872,    98,   872,   498,   456,   217,   700,
     741,    -1,   147,   120,   497,   872,    98,   872,   498,   457,
     217,   741,    -1,   147,   120,   497,   872,    98,   872,   498,
     456,   243,   741,    -1,    98,   233,    -1,    98,   101,    -1,
      -1,   187,   120,   743,   497,   872,    98,   872,   498,   549,
      -1,   229,   200,    -1,    -1,   356,   745,   955,   746,    -1,
     356,   409,   957,   746,    -1,   356,   164,   957,   746,    -1,
     237,    -1,   410,    -1,   211,    -1,    -1,    91,    88,   963,
     658,   359,   419,   957,    -1,    91,   144,   680,   359,   419,
     957,    -1,    91,   164,   958,   359,   419,   958,    -1,    91,
     217,   700,   359,   419,   957,    -1,    91,   222,   966,   359,
     419,   966,    -1,    91,   612,   260,   957,   359,   419,   957,
      -1,    91,   319,   128,   680,   439,   959,   359,   419,   957,
      -1,    91,   319,   205,   680,   439,   959,   359,   419,   957,
      -1,    91,   376,   957,   359,   419,   957,    -1,    91,   410,
     864,   359,   419,   957,    -1,    91,   382,   955,   359,   419,
     957,    -1,    91,   450,   955,   359,   419,   957,    -1,    91,
     237,   955,   359,   419,   957,    -1,    91,   410,   864,   359,
     748,   957,   419,   957,    -1,    91,   423,   957,   317,   955,
     359,   419,   957,    -1,    91,   370,   966,   359,   419,   966,
      -1,    91,   438,   966,   359,   419,   966,    -1,    91,   411,
     957,   359,   419,   957,    -1,    91,   415,   378,   331,   680,
     359,   419,   957,    -1,    91,   415,   378,   179,   680,   359,
     419,   957,    -1,    91,   415,   378,   413,   680,   359,   419,
     957,    -1,    91,   415,   378,   138,   680,   359,   419,   957,
      -1,    91,   428,   680,   359,   419,   957,    -1,   133,    -1,
      -1,   387,   163,    -1,    -1,    91,    88,   963,   658,   387,
     376,   957,    -1,    91,   185,   680,   387,   376,   957,    -1,
      91,   217,   700,   387,   376,   957,    -1,    91,   410,   864,
     387,   376,   957,    -1,    91,   382,   955,   387,   376,   957,
      -1,    91,   450,   955,   387,   376,   957,    -1,    91,   428,
     680,   387,   376,   957,    -1,    91,    88,   963,   658,   330,
     419,   966,    -1,    91,   144,   680,   330,   419,   966,    -1,
      91,   164,   958,   330,   419,   966,    -1,    91,   185,   680,
     330,   419,   966,    -1,    91,   217,   700,   330,   419,   966,
      -1,    91,   612,   260,   957,   330,   419,   966,    -1,    91,
     319,   739,   738,   330,   419,   966,    -1,    91,   319,   128,
     680,   439,   959,   330,   419,   966,    -1,    91,   319,   205,
     680,   439,   959,   330,   419,   966,    -1,    91,   376,   957,
     330,   419,   966,    -1,    91,   428,   680,   330,   419,   966,
      -1,    91,   411,   957,   330,   419,   966,    -1,    91,   415,
     378,   179,   680,   330,   419,   966,    -1,    91,   415,   378,
     138,   680,   330,   419,   966,    -1,    91,   212,   163,   459,
     957,   330,   419,   966,    -1,    91,   384,   957,   330,   419,
     966,    -1,   303,    -1,   754,    -1,   497,   753,   498,    -1,
     753,   501,   755,    -1,   755,    -1,   823,    -1,   802,    -1,
     813,    -1,   807,    -1,   759,    -1,   754,    -1,    -1,   381,
      -1,   437,    -1,   175,    -1,   246,    -1,   247,    -1,    90,
      -1,    -1,   187,   374,   957,   317,   955,   549,    -1,   187,
     374,   229,   200,   957,   317,   955,   549,    -1,   304,   968,
      -1,   271,   968,    -1,   435,   968,    -1,   435,   490,    -1,
      81,   763,    -1,   107,   763,   766,    -1,   397,   421,   766,
      -1,   135,   763,    -1,   193,   763,    -1,   371,   763,    -1,
     375,   968,    -1,   358,   375,   968,    -1,   358,   968,    -1,
     371,   763,   419,   375,   968,    -1,   371,   763,   419,   968,
      -1,   341,   421,  1108,    -1,   135,   342,  1108,    -1,   371,
     342,  1108,    -1,   458,    -1,   421,    -1,    -1,   256,   268,
     532,    -1,   350,   318,    -1,   350,   460,    -1,   764,    -1,
     765,   500,   764,    -1,   765,   764,    -1,   765,    -1,    -1,
     147,   566,   450,   955,   580,    98,   823,   768,    -1,   147,
     322,   361,   566,   450,   955,   580,    98,   823,   768,    -1,
     456,   126,   320,    -1,   456,   118,   126,   320,    -1,   456,
     273,   126,   320,    -1,    -1,   272,   962,    -1,   147,   164,
     958,   509,   771,    -1,   771,   772,    -1,    -1,   411,   773,
     957,    -1,   411,   773,   170,    -1,   276,   773,  1108,    -1,
     276,   773,   170,    -1,   413,   773,   957,    -1,   413,   773,
     170,    -1,   191,   773,  1108,    -1,   191,   773,   965,    -1,
     191,   773,   170,    -1,   263,   773,  1108,    -1,   263,   773,
     170,    -1,   264,   773,  1108,    -1,   264,   773,   170,    -1,
     139,   270,   773,   967,    -1,   330,   773,   957,    -1,   330,
     773,   170,    -1,   484,    -1,    -1,    91,   164,   958,   509,
     776,    -1,    91,   164,   958,   387,   411,   957,    -1,    91,
     164,   958,   538,    -1,   776,   777,    -1,    -1,   139,   270,
     773,   967,    -1,   187,   164,   958,    -1,   187,   164,   229,
     200,   958,    -1,   147,   185,   680,   781,   872,   571,    -1,
      91,   185,   680,   548,    -1,    91,   185,   680,   187,   302,
     307,    -1,    91,   185,   680,   387,   302,   307,    -1,    91,
     185,   680,    85,   578,    -1,    91,   185,   680,   187,   140,
     957,   549,    -1,    98,    -1,    -1,    91,   415,   378,   179,
     680,   654,    -1,    91,   415,   378,   138,   680,    85,   279,
     210,   956,   456,   679,    -1,    91,   415,   378,   138,   680,
      91,   279,   210,   956,   456,   679,    -1,    91,   415,   378,
     138,   680,    91,   279,   361,   680,   456,   680,    -1,    91,
     415,   378,   138,   680,    91,   279,   210,   956,   361,   680,
     456,   680,    -1,    91,   415,   378,   138,   680,   187,   279,
     210,   956,    -1,    91,   415,   378,   138,   680,   187,   279,
     229,   200,   210,   956,    -1,   147,   666,   144,   680,   210,
    1108,   419,  1108,   215,   680,    -1,   130,   790,   955,   786,
      -1,   130,   790,    -1,   130,   790,   961,   317,   955,    -1,
     439,   961,    -1,    -1,   440,   791,   792,   790,    -1,   440,
     791,   792,   790,   955,    -1,   440,   791,   792,   790,   788,
      -1,   789,   790,    -1,   789,   790,   955,   793,    -1,    94,
      -1,    93,    -1,   448,    -1,    -1,   216,    -1,    -1,   214,
      -1,    -1,   497,   956,   498,    -1,    -1,   201,   796,   790,
     795,    -1,   823,    -1,   802,    -1,   813,    -1,   807,    -1,
     820,    -1,   976,    -1,   800,    -1,   789,    -1,    -1,   341,
     997,   798,    98,   799,    -1,   341,   997,   215,  1042,    -1,
     497,   925,   498,    -1,    -1,   823,    -1,   802,    -1,   813,
      -1,   807,    -1,   199,   997,   801,  1120,    -1,   147,   566,
     410,   593,    98,   199,   997,   801,    -1,   497,   924,   498,
      -1,    -1,   246,   252,   955,   803,   806,    -1,   823,    -1,
     497,   804,   498,   823,    -1,   170,   444,    -1,   805,    -1,
     804,   500,   805,    -1,   968,   946,    -1,   366,   951,    -1,
      -1,   175,   215,   866,   808,   869,   806,    -1,   439,   857,
      -1,    -1,   277,   833,   865,   810,   812,    -1,   234,   811,
     284,    -1,    -1,    83,   389,    -1,   372,   389,    -1,   372,
     198,    -1,   389,   437,   198,    -1,   389,    -1,   389,   372,
     198,    -1,   198,    -1,    83,   198,    -1,   306,    -1,    -1,
     437,   866,   387,   814,   856,   869,   806,    -1,   815,    -1,
     814,   500,   815,    -1,   816,    -1,   817,    -1,   818,   484,
     948,    -1,   497,   819,   498,   484,   950,    -1,   968,   946,
      -1,   818,    -1,   819,   500,   818,    -1,   169,   957,   821,
     161,   822,   210,   823,    -1,    -1,   821,   294,   377,    -1,
     821,   377,    -1,   821,   110,    -1,   821,   245,    -1,    -1,
     456,   226,    -1,   457,   226,    -1,   825,    -1,   824,    -1,
     497,   825,   498,    -1,   497,   824,   498,    -1,   827,    -1,
     826,   837,    -1,   826,   836,   850,   841,    -1,   826,   836,
     840,   851,    -1,   828,   827,    -1,   828,   826,   837,    -1,
     828,   826,   836,   850,   841,    -1,   828,   826,   836,   840,
     851,    -1,   827,    -1,   824,    -1,   381,   835,   951,   831,
     856,   868,   848,   849,   907,    -1,   855,    -1,   410,   864,
      -1,   826,   432,   834,   826,    -1,   826,   250,   834,   826,
      -1,   826,   196,   834,   826,    -1,   456,   829,    -1,   456,
     354,   829,    -1,   830,    -1,   829,   500,   830,    -1,   957,
     793,    98,   824,    -1,   252,   832,    -1,  1121,    -1,    -1,
     414,   833,   955,    -1,   412,   833,   955,    -1,   273,   414,
     833,   955,    -1,   273,   412,   833,   955,    -1,   218,   414,
     833,   955,    -1,   218,   412,   833,   955,    -1,   410,   955,
      -1,   955,    -1,   410,    -1,    -1,    89,    -1,   182,    -1,
      -1,   182,    -1,   182,   317,   497,   924,   498,    -1,    89,
      -1,    -1,   837,    -1,    -1,   323,   114,   838,    -1,   839,
      -1,   838,   500,   839,    -1,   896,   439,   922,   712,    -1,
     896,   711,   712,    -1,   270,   842,   314,   844,    -1,   314,
     844,   270,   842,    -1,   270,   842,    -1,   314,   844,    -1,
     270,   842,   500,   844,    -1,   314,   845,   846,    -1,   206,
     847,   843,   846,   318,    -1,   314,   845,   846,   206,   847,
     843,   846,   318,    -1,   840,    -1,    -1,   896,    -1,    89,
      -1,   967,    -1,   497,   896,   498,    -1,    -1,   896,    -1,
     898,    -1,   372,    -1,   373,    -1,   207,    -1,   293,    -1,
     222,   114,   924,    -1,    -1,   224,   896,    -1,    -1,   852,
      -1,   210,   350,   318,    -1,   850,    -1,    -1,   853,    -1,
     852,   853,    -1,   210,   437,   854,   812,    -1,   210,   389,
     854,   812,    -1,   312,   954,    -1,    -1,   444,   950,    -1,
     855,   500,   950,    -1,   215,   857,    -1,    -1,   858,    -1,
     857,   500,   858,    -1,   864,    -1,   864,   860,    -1,   867,
      -1,   867,   860,    -1,   867,    98,   497,   870,   498,    -1,
     867,    98,   968,   497,   870,   498,    -1,   867,   968,   497,
     870,   498,    -1,   824,    -1,   824,   860,    -1,   859,    -1,
     497,   859,   498,   860,    -1,   497,   859,   498,    -1,   858,
     151,   257,   858,    -1,   858,   861,   257,   858,   863,    -1,
     858,   257,   858,   863,    -1,   858,   290,   861,   257,   858,
      -1,   858,   290,   257,   858,    -1,    98,   968,   497,   956,
     498,    -1,    98,   968,    -1,   968,   497,   956,   498,    -1,
     968,    -1,   216,   862,    -1,   267,   862,    -1,   369,   862,
      -1,   242,    -1,   325,    -1,    -1,   439,   497,   956,   498,
      -1,   317,   896,    -1,   955,    -1,   955,   490,    -1,   318,
     955,    -1,   318,   497,   955,   498,    -1,   864,    -1,   865,
     500,   864,    -1,   864,    -1,   864,   968,    -1,   864,    98,
     968,    -1,   899,    -1,   453,   896,    -1,    -1,   453,   896,
      -1,   453,   153,   312,   957,    -1,   453,   153,   312,  1105,
      -1,    -1,   871,    -1,   870,   500,   871,    -1,   968,   872,
      -1,   874,   873,    -1,   388,   874,   873,    -1,   874,    97,
     495,   965,   496,    -1,   388,   874,    97,   495,   965,   496,
      -1,   874,    97,    -1,   388,   874,    97,    -1,   873,   495,
     496,    -1,   873,   495,  1119,   496,    -1,    -1,   876,    -1,
     878,    -1,   880,    -1,   884,    -1,   891,    -1,   892,   894,
      -1,   892,   497,   965,   498,   894,    -1,   878,    -1,   881,
      -1,   885,    -1,   891,    -1,   969,   877,    -1,   969,   681,
     877,    -1,   497,   924,   498,    -1,    -1,   248,    -1,   249,
      -1,   393,    -1,   109,    -1,   351,    -1,   208,   879,    -1,
     186,   339,    -1,   168,   877,    -1,   167,   877,    -1,   310,
     877,    -1,   112,    -1,   497,   965,   498,    -1,    -1,   882,
      -1,   883,    -1,   882,    -1,   883,    -1,   111,   889,   497,
     924,   498,    -1,   111,   889,    -1,   886,    -1,   887,    -1,
     886,    -1,   887,    -1,   888,   497,   965,   498,   890,    -1,
     888,   890,    -1,   124,   889,    -1,   123,   889,    -1,   445,
      -1,   289,   124,   889,    -1,   289,   123,   889,    -1,   291,
     889,    -1,   447,    -1,    -1,   124,   387,   968,    -1,    -1,
     418,   497,   965,   498,   893,    -1,   418,   893,    -1,   417,
     497,   965,   498,   893,    -1,   417,   893,    -1,   251,    -1,
     475,   472,    -1,   457,   417,   472,    -1,    -1,   470,    -1,
     285,    -1,   165,    -1,   227,    -1,   282,    -1,   895,    -1,
     470,   419,   285,    -1,   165,   419,   227,    -1,   165,   419,
     282,    -1,   165,   419,   895,    -1,   227,   419,   282,    -1,
     227,   419,   895,    -1,   282,   419,   895,    -1,    -1,   379,
      -1,   379,   497,   965,   498,    -1,   898,    -1,   896,    71,
     872,    -1,   896,   103,   417,   472,   896,    -1,   488,   896,
      -1,   489,   896,    -1,   896,   488,   896,    -1,   896,   489,
     896,    -1,   896,   490,   896,    -1,   896,   491,   896,    -1,
     896,   492,   896,    -1,   896,   493,   896,    -1,   896,   485,
     896,    -1,   896,   486,   896,    -1,   896,   484,   896,    -1,
     896,   921,   896,    -1,   921,   896,    -1,   896,   921,    -1,
     896,    95,   896,    -1,   896,   322,   896,    -1,   302,   896,
      -1,   896,   269,   896,    -1,   896,   269,   896,   195,   896,
      -1,   896,   302,   269,   896,    -1,   896,   302,   269,   896,
     195,   896,    -1,   896,   230,   896,    -1,   896,   230,   896,
     195,   896,    -1,   896,   302,   230,   896,    -1,   896,   302,
     230,   896,   195,   896,    -1,   896,   391,   419,   896,    -1,
     896,   391,   419,   896,   195,   896,    -1,   896,   302,   391,
     419,   896,    -1,   896,   302,   391,   419,   896,   195,   896,
      -1,   896,   254,   307,    -1,   896,   255,    -1,   896,   254,
     302,   307,    -1,   896,   305,    -1,   917,   327,   917,    -1,
     896,   254,   425,    -1,   896,   254,   302,   425,    -1,   896,
     254,   204,    -1,   896,   254,   302,   204,    -1,   896,   254,
     434,    -1,   896,   254,   302,   434,    -1,   896,   254,   182,
     215,   896,    -1,   896,   254,   302,   182,   215,   896,    -1,
     896,   254,   312,   497,   925,   498,    -1,   896,   254,   302,
     312,   497,   925,   498,    -1,   896,   108,   947,   897,    95,
     897,    -1,   896,   302,   108,   947,   897,    95,   897,    -1,
     896,   108,   407,   897,    95,   897,    -1,   896,   302,   108,
     407,   897,    95,   897,    -1,   896,   234,   937,    -1,   896,
     302,   234,   937,    -1,   896,   923,   918,   824,    -1,   896,
     923,   918,   497,   896,   498,    -1,   433,   824,    -1,   896,
     254,   184,    -1,   896,   254,   302,   184,    -1,   898,    -1,
     897,    71,   872,    -1,   488,   897,    -1,   489,   897,    -1,
     897,   488,   897,    -1,   897,   489,   897,    -1,   897,   490,
     897,    -1,   897,   491,   897,    -1,   897,   492,   897,    -1,
     897,   493,   897,    -1,   897,   485,   897,    -1,   897,   486,
     897,    -1,   897,   484,   897,    -1,   897,   921,   897,    -1,
     921,   897,    -1,   897,   921,    -1,   897,   254,   182,   215,
     897,    -1,   897,   254,   302,   182,   215,   897,    -1,   897,
     254,   312,   497,   925,   498,    -1,   897,   254,   302,   312,
     497,   925,   498,    -1,   897,   254,   184,    -1,   897,   254,
     302,   184,    -1,   943,    -1,   964,    -1,  1105,   946,    -1,
     497,   896,   498,   946,    -1,   938,    -1,   899,    -1,   824,
      -1,   200,   824,    -1,    97,   824,    -1,    97,   926,    -1,
     917,    -1,   963,   497,   498,   910,    -1,   963,   497,   924,
     498,   910,    -1,   963,   497,   446,   896,   498,   910,    -1,
     963,   497,   924,   500,   446,   896,   498,   910,    -1,   963,
     497,    89,   924,   498,   910,    -1,   963,   497,   182,   924,
     498,   910,    -1,   963,   497,   490,   498,   910,    -1,   155,
      -1,   158,    -1,   158,   497,   965,   498,    -1,   159,    -1,
     159,   497,   965,   498,    -1,   274,    -1,   274,   497,   965,
     498,    -1,   275,    -1,   275,   497,   965,   498,    -1,   156,
      -1,   160,    -1,   386,    -1,   438,    -1,   154,    -1,   157,
      -1,   120,   497,   896,    98,   872,   498,    -1,   203,   497,
     928,   498,    -1,   328,   497,   930,   498,    -1,   337,   497,
     932,   498,    -1,   405,   497,   933,   498,    -1,   422,   497,
     896,    98,   872,   498,    -1,   424,   497,   113,   936,   498,
      -1,   424,   497,   265,   936,   498,    -1,   424,   497,   420,
     936,   498,    -1,   424,   497,   936,   498,    -1,   308,   497,
     896,   500,   896,   498,    -1,   131,   497,   924,   498,    -1,
     221,   497,   924,   498,    -1,   266,   497,   924,   498,    -1,
     463,   497,   924,   498,    -1,   464,   497,   287,  1089,   498,
      -1,   464,   497,   287,  1089,   500,   902,   498,    -1,   464,
     497,   287,  1089,   500,   924,   498,    -1,   464,   497,   287,
    1089,   500,   902,   500,   924,   498,    -1,   465,   497,   903,
     498,    -1,   466,   497,   905,   896,   906,   498,    -1,   467,
     497,   287,  1089,   498,    -1,   467,   497,   287,  1089,   500,
     896,   498,    -1,   468,   497,   896,   500,   900,   901,   498,
      -1,   469,   497,   905,   896,    98,   874,   498,    -1,   449,
     896,    -1,   449,   294,   443,    -1,   500,   396,   471,    -1,
     500,   396,   294,    -1,   500,   396,   294,   443,    -1,    -1,
     462,   497,   903,   498,    -1,   904,    -1,   903,   500,   904,
      -1,   896,    98,  1089,    -1,   896,    -1,   184,    -1,   142,
      -1,   340,   454,    -1,   404,   454,    -1,    -1,   455,   908,
      -1,    -1,   909,    -1,   908,   500,   909,    -1,   968,    98,
     911,    -1,   326,   911,    -1,   326,   968,    -1,    -1,   497,
     912,   913,   836,   914,   498,    -1,   968,    -1,    -1,   333,
     114,   924,    -1,    -1,   349,   915,    -1,   373,   915,    -1,
      -1,   916,    -1,   108,   916,    95,   916,    -1,   429,   338,
      -1,   429,   209,    -1,   153,   372,    -1,   372,   497,   924,
     498,    -1,   372,   497,   498,    -1,   497,   924,   500,   896,
     498,    -1,    96,    -1,   394,    -1,    89,    -1,   481,    -1,
     920,    -1,   488,    -1,   489,    -1,   490,    -1,   491,    -1,
     492,    -1,   493,    -1,   485,    -1,   486,    -1,   484,    -1,
     481,    -1,   319,   497,   739,   498,    -1,   919,    -1,   319,
     497,   739,   498,    -1,   919,    -1,   319,   497,   739,   498,
      -1,   269,    -1,   302,   269,    -1,   230,    -1,   302,   230,
      -1,   896,    -1,   924,   500,   896,    -1,   872,    -1,   925,
     500,   872,    -1,   495,   924,   496,    -1,   495,   927,   496,
      -1,   495,   496,    -1,   926,    -1,   927,   500,   926,    -1,
     929,   215,   896,    -1,    -1,  1110,    -1,   470,    -1,   285,
      -1,   165,    -1,   227,    -1,   282,    -1,   379,    -1,  1108,
      -1,   896,   931,   934,   935,    -1,   896,   931,   934,    -1,
     335,   896,    -1,   897,   234,   897,    -1,    -1,   896,   934,
     935,    -1,   896,   935,   934,    -1,   896,   934,    -1,   896,
     935,    -1,   924,    -1,    -1,   215,   896,    -1,   210,   896,
      -1,   896,   215,   924,    -1,   215,   924,    -1,   924,    -1,
     824,    -1,   497,   924,   498,    -1,   119,   942,   939,   941,
     193,    -1,   940,    -1,   939,   940,    -1,   452,   896,   416,
     896,    -1,   189,   896,    -1,    -1,   896,    -1,    -1,   953,
      -1,   953,   945,    -1,   499,   960,    -1,   499,   490,    -1,
     495,   896,   496,    -1,   495,   896,   502,   896,   496,    -1,
     944,    -1,   945,   944,    -1,    -1,   946,   944,    -1,   102,
      -1,    -1,   896,    -1,   170,    -1,   948,    -1,   949,   500,
     948,    -1,   497,   949,   498,    -1,   952,    -1,   951,   500,
     952,    -1,   896,    98,  1089,    -1,   896,  1110,    -1,   896,
      -1,   490,    -1,   973,    -1,   968,    -1,   955,    -1,   954,
     500,   955,    -1,   953,    -1,   953,   945,    -1,   957,    -1,
     956,   500,   957,    -1,   968,    -1,   968,    -1,   968,    -1,
    1089,    -1,   968,    -1,  1108,    -1,   969,    -1,   953,   945,
      -1,   965,    -1,  1107,    -1,  1108,    -1,  1106,    -1,   480,
      -1,   963,  1108,    -1,   963,   497,   924,   498,  1108,    -1,
     875,  1108,    -1,   892,  1108,   894,    -1,   892,   497,   965,
     498,  1108,   894,    -1,   425,    -1,   204,    -1,   307,    -1,
    1102,    -1,  1101,    -1,   482,    -1,   968,    -1,   965,    -1,
    1102,    -1,   488,   965,    -1,   489,   965,    -1,  1110,    -1,
    1093,    -1,   970,    -1,  1083,    -1,  1092,    -1,   123,    -1,
     444,    -1,  1110,    -1,  1093,    -1,   971,    -1,  1083,    -1,
    1086,    -1,  1092,    -1,   109,    -1,   111,    -1,   112,    -1,
     124,    -1,   131,    -1,   167,    -1,   168,    -1,   200,    -1,
     203,    -1,   208,    -1,   221,    -1,   243,    -1,   249,    -1,
     251,    -1,   266,    -1,   289,    -1,   291,    -1,   300,    -1,
     308,    -1,   310,    -1,   324,    -1,   328,    -1,   337,    -1,
     339,    -1,   351,    -1,   372,    -1,   388,    -1,   393,    -1,
     405,    -1,   417,    -1,   418,    -1,   422,    -1,   424,    -1,
     445,    -1,   462,    -1,   463,    -1,   464,    -1,   465,    -1,
     466,    -1,   467,    -1,   468,    -1,   469,    -1,   104,    -1,
     108,    -1,   110,    -1,   151,    -1,   157,    -1,   214,    -1,
     216,    -1,   230,    -1,   242,    -1,   254,    -1,   255,    -1,
     257,    -1,   267,    -1,   269,    -1,   290,    -1,   305,    -1,
     325,    -1,   326,    -1,   327,    -1,   369,    -1,   391,    -1,
     448,    -1,    89,    -1,    93,    -1,    94,    -1,    95,    -1,
      96,    -1,    97,    -1,    98,    -1,    99,    -1,   102,    -1,
     113,    -1,   119,    -1,   120,    -1,   126,    -1,   132,    -1,
     133,    -1,   140,    -1,   147,    -1,   154,    -1,   155,    -1,
     156,    -1,   158,    -1,   159,    -1,   160,    -1,   170,    -1,
     172,    -1,   178,    -1,   182,    -1,   183,    -1,   189,    -1,
     193,    -1,   196,    -1,   204,    -1,   206,    -1,   210,    -1,
     212,    -1,   215,    -1,   219,    -1,   222,    -1,   224,    -1,
     234,    -1,   241,    -1,   250,    -1,   252,    -1,   265,    -1,
     270,    -1,   274,    -1,   275,    -1,   292,    -1,   302,    -1,
     307,    -1,   313,    -1,   314,    -1,   316,    -1,   317,    -1,
     318,    -1,   322,    -1,   323,    -1,   335,    -1,   343,    -1,
     355,    -1,   366,    -1,   381,    -1,   386,    -1,   394,    -1,
     407,    -1,   410,    -1,   416,    -1,   420,    -1,   425,    -1,
     433,    -1,   438,    -1,   439,    -1,   446,    -1,   452,    -1,
     453,    -1,   455,    -1,   456,    -1,   316,    -1,   292,    -1,
      -1,   974,   975,    -1,  1098,   980,   507,   501,    -1,  1098,
     507,   501,    -1,  1098,  1000,    -1,  1005,    -1,  1116,    -1,
      74,    -1,   503,    -1,   504,    -1,    -1,   147,   566,   410,
     593,    98,   977,   823,   597,    -1,    -1,   147,   714,   374,
     957,    98,   979,   317,   756,   419,   955,   868,   183,   757,
     752,    -1,   103,  1041,    -1,     9,   419,   982,   989,   990,
      -1,     9,   419,   170,    -1,     9,   991,    -1,   164,   982,
      -1,   983,   986,   988,    -1,   984,   502,   985,   988,   491,
     983,   994,    -1,   993,    -1,  1108,    -1,   958,    -1,    -1,
    1110,  1104,    -1,   481,   987,    -1,   985,    -1,    -1,   968,
      -1,   968,   499,   987,    -1,    75,    -1,   502,   965,    -1,
      -1,    98,  1041,    -1,    -1,   438,   991,    -1,    -1,   992,
      -1,   992,   491,   992,    -1,   992,    21,   114,   992,    -1,
     992,   439,   992,    -1,   966,    -1,  1108,    -1,  1102,    -1,
    1104,    -1,   481,   995,    -1,    -1,   968,   996,    -1,   968,
     996,   481,   995,    -1,    -1,   484,   965,    -1,   484,  1110,
      -1,   484,  1102,    -1,   957,    -1,   993,    -1,   169,   957,
     821,   161,   822,   210,   997,    -1,   199,   231,  1042,    -1,
    1001,    -1,  1012,    -1,  1014,    -1,   604,    -1,   500,   604,
      -1,    -1,   894,    -1,   470,   419,   282,    -1,   470,   419,
     379,    -1,   165,   419,   165,    -1,   285,   419,   285,    -1,
      -1,  1007,  1006,  1009,  1008,    -1,  1098,   107,   169,    34,
     501,    -1,  1098,   193,   169,    34,   501,    -1,    -1,  1010,
      -1,    74,    -1,  1014,    -1,  1012,    -1,  1010,  1014,    -1,
    1010,  1012,    -1,  1010,    74,    -1,  1014,    -1,  1011,  1014,
      -1,    -1,    70,  1013,  1021,  1037,  1090,   873,   501,    -1,
      -1,  1018,  1021,  1015,  1034,   501,    -1,    -1,  1021,  1016,
    1034,   501,    -1,  1024,   501,    -1,   502,   965,    -1,    -1,
    1019,  1020,    -1,  1019,    -1,  1020,    -1,    56,    -1,    67,
      -1,    65,    -1,    50,    -1,    51,    -1,    69,    -1,  1030,
      -1,  1026,    -1,  1022,    -1,  1090,   497,  1002,  1003,   498,
      -1,  1090,  1004,    -1,  1028,    -1,   194,  1087,  1023,    -1,
     194,  1023,    -1,   194,  1087,    -1,   503,  1114,   504,    -1,
      -1,  1028,  1025,   503,  1011,   504,    -1,  1024,    -1,    -1,
    1029,  1027,   503,  1011,   504,    -1,    43,  1087,    -1,   432,
    1087,    -1,    43,    -1,   432,    -1,  1031,    -1,  1033,  1032,
      -1,    44,    35,    -1,    44,    35,   248,    -1,    44,    -1,
      44,   248,    -1,    44,    25,    -1,    44,    25,   248,    -1,
      44,    25,    25,    -1,    44,    25,    25,   248,    -1,    44,
     123,    -1,    35,    -1,    35,   248,    -1,   248,    -1,    25,
      -1,    25,   248,    -1,    25,    25,    -1,    25,    25,   248,
      -1,     5,    -1,   123,    -1,   186,    -1,    36,    -1,    -1,
    1035,    -1,  1034,   500,  1035,    -1,  1037,  1091,   873,  1017,
    1036,    -1,    -1,   484,  1115,    -1,    -1,   490,    -1,   490,
     490,    -1,   169,   398,  1110,    -1,    15,  1040,    -1,  1041,
      -1,   153,    -1,    89,    -1,    -1,   958,    -1,   170,    -1,
     993,    -1,   993,    -1,    72,    -1,    17,   957,    -1,    17,
      89,    -1,    28,   957,  1045,    -1,    -1,  1046,    -1,   439,
    1050,    -1,  1047,    -1,   439,  1049,    14,  1111,    -1,   252,
    1049,    14,  1111,    -1,    -1,    37,    -1,  1051,    -1,  1051,
     500,  1050,    -1,  1052,    -1,  1102,    -1,  1101,    -1,   965,
      -1,   488,   965,    -1,   489,   965,    -1,  1107,    -1,   488,
    1107,    -1,   489,  1107,    -1,  1108,    -1,  1106,    -1,  1109,
      -1,    13,   244,   957,  1047,    -1,    13,  1054,   957,  1047,
      -1,    13,  1054,   957,  1048,    -1,    29,    -1,    -1,     3,
      14,  1111,    -1,   166,    14,  1111,    -1,    18,    14,  1111,
    1058,    -1,  1059,    -1,  1058,   500,  1059,    -1,  1104,   484,
    1064,    -1,   387,    14,  1111,  1061,    -1,  1062,    -1,  1061,
     500,  1062,    -1,  1064,   484,  1063,    -1,   965,    -1,  1104,
      -1,    10,    -1,    18,    14,  1111,   443,  1063,  1066,    -1,
    1067,    -1,  1066,   500,  1067,    -1,  1104,   484,  1072,    -1,
     387,    14,  1111,   443,  1063,  1069,    -1,  1070,    -1,  1069,
     500,  1070,    -1,  1072,   484,  1071,    -1,  1107,    -1,  1063,
      -1,   489,  1107,    -1,   489,   965,    -1,  1108,    -1,     8,
      -1,   163,    -1,    11,    -1,    12,    -1,    22,    -1,    23,
      -1,    24,    -1,   287,    -1,    26,    -1,    27,    -1,   339,
      -1,    31,    -1,    32,    -1,    33,    -1,   428,    -1,   387,
       4,   484,  1074,    -1,   387,     4,   419,  1074,    -1,   317,
      -1,   313,    -1,   387,   139,   419,  1041,    -1,   387,   139,
     484,  1041,    -1,   387,   139,  1041,    -1,    -1,   428,  1077,
    1090,   254,  1021,   873,  1078,    -1,    30,    -1,    -1,    -1,
      45,  1080,  1089,   254,  1021,   873,  1078,    -1,    46,    38,
    1082,    -1,    46,   302,    16,  1082,    -1,    46,    40,  1082,
      -1,   143,    -1,    39,    -1,    42,    -1,    20,   957,    -1,
      19,   419,   957,    -1,   183,   957,   497,  1099,   498,    -1,
     183,     6,    -1,     7,   957,   497,  1099,   498,    -1,     7,
     957,    -1,  1084,    -1,  1085,    -1,     6,    -1,     7,    -1,
       8,    -1,    10,    -1,    11,    -1,    12,    -1,    16,    -1,
      19,    -1,    20,    -1,    21,    -1,    22,    -1,    23,    -1,
      24,    -1,    26,    -1,    27,    -1,    31,    -1,    32,    -1,
      33,    -1,    34,    -1,    37,    -1,    38,    -1,    39,    -1,
      40,    -1,    42,    -1,     9,    -1,    13,    -1,    15,    -1,
      28,    -1,    45,    -1,    46,    -1,     5,    -1,    25,    -1,
      29,    -1,    35,    -1,    43,    -1,    36,    -1,    44,    -1,
    1089,    -1,  1110,    -1,  1094,    -1,  1096,    -1,   970,    -1,
    1083,    -1,  1092,    -1,   123,    -1,   444,    -1,  1091,    -1,
    1086,    -1,   123,    -1,   244,    -1,   248,    -1,   432,    -1,
     419,    -1,  1092,    -1,  1094,    -1,  1110,    -1,   970,    -1,
     971,    -1,  1084,    -1,  1090,    -1,   972,    -1,  1095,    -1,
    1085,    -1,    50,    -1,    51,    -1,    56,    -1,    65,    -1,
      67,    -1,    70,    -1,    69,    -1,  1094,    -1,  1095,    -1,
     165,    -1,   227,    -1,   282,    -1,   285,    -1,   379,    -1,
     470,    -1,  1096,    -1,   139,    -1,    81,    -1,    82,    -1,
      83,    -1,    84,    -1,    85,    -1,    86,    -1,    87,    -1,
      88,    -1,    90,    -1,    91,    -1,    92,    -1,   100,    -1,
     101,    -1,   103,    -1,   105,    -1,   106,    -1,   107,    -1,
     114,    -1,   115,    -1,   117,    -1,   118,    -1,   122,    -1,
     125,    -1,   127,    -1,   128,    -1,   129,    -1,   130,    -1,
     134,    -1,   135,    -1,   136,    -1,   137,    -1,   138,    -1,
     141,    -1,   142,    -1,   143,    -1,   144,    -1,   145,    -1,
     146,    -1,   148,    -1,   149,    -1,   150,    -1,   152,    -1,
     161,    -1,   162,    -1,   163,    -1,   164,    -1,   166,    -1,
     169,    -1,   171,    -1,   173,    -1,   175,    -1,   176,    -1,
     177,    -1,   179,    -1,   180,    -1,   181,    -1,   184,    -1,
     185,    -1,   186,    -1,   187,    -1,   188,    -1,   190,    -1,
     191,    -1,   192,    -1,   195,    -1,   197,    -1,   198,    -1,
     199,    -1,   201,    -1,   202,    -1,   205,    -1,   207,    -1,
     211,    -1,   213,    -1,   217,    -1,   218,    -1,   220,    -1,
     223,    -1,   225,    -1,   226,    -1,   228,    -1,   229,    -1,
     231,    -1,   232,    -1,   233,    -1,   235,    -1,   236,    -1,
     237,    -1,   238,    -1,   239,    -1,   240,    -1,   245,    -1,
     246,    -1,   247,    -1,   256,    -1,   258,    -1,   259,    -1,
     260,    -1,   261,    -1,   262,    -1,   263,    -1,   264,    -1,
     268,    -1,   271,    -1,   272,    -1,   273,    -1,   276,    -1,
     277,    -1,   278,    -1,   279,    -1,   280,    -1,   281,    -1,
     283,    -1,   284,    -1,   286,    -1,   287,    -1,   288,    -1,
     293,    -1,   294,    -1,   295,    -1,   296,    -1,   297,    -1,
     298,    -1,   299,    -1,   301,    -1,   303,    -1,   304,    -1,
     306,    -1,   309,    -1,   311,    -1,   312,    -1,   315,    -1,
     319,    -1,   320,    -1,   329,    -1,   330,    -1,   331,    -1,
     332,    -1,   334,    -1,   336,    -1,   341,    -1,   342,    -1,
     340,    -1,   344,    -1,   345,    -1,   346,    -1,   347,    -1,
     348,    -1,   350,    -1,   352,    -1,   353,    -1,   354,    -1,
     356,    -1,   357,    -1,   358,    -1,   359,    -1,   360,    -1,
     361,    -1,   362,    -1,   363,    -1,   364,    -1,   365,    -1,
     367,    -1,   368,    -1,   370,    -1,   371,    -1,   373,    -1,
     374,    -1,   375,    -1,   376,    -1,   377,    -1,   378,    -1,
     382,    -1,   383,    -1,   385,    -1,   387,    -1,   389,    -1,
     390,    -1,   392,    -1,   395,    -1,   396,    -1,   397,    -1,
     398,    -1,   399,    -1,   400,    -1,   401,    -1,   402,    -1,
     403,    -1,   404,    -1,   406,    -1,   409,    -1,   408,    -1,
     411,    -1,   412,    -1,   413,    -1,   414,    -1,   415,    -1,
     421,    -1,   423,    -1,   426,    -1,   427,    -1,   428,    -1,
     430,    -1,   431,    -1,   434,    -1,   435,    -1,   436,    -1,
     437,    -1,   440,    -1,   441,    -1,   442,    -1,   443,    -1,
     447,    -1,   449,    -1,   450,    -1,   451,    -1,   454,    -1,
     457,    -1,   458,    -1,   460,    -1,   461,    -1,   471,    -1,
     472,    -1,  1100,    -1,  1097,   500,  1100,    -1,    41,    -1,
      -1,  1114,    -1,  1104,  1103,    -1,  1104,    -1,  1104,  1103,
      -1,  1104,    -1,  1104,    -1,    22,  1104,    -1,    22,   957,
      -1,    73,    -1,   483,    -1,   479,    -1,   477,    -1,   478,
      -1,    77,    -1,    78,    -1,    79,    -1,    76,    -1,   480,
      -1,   476,    -1,    72,    -1,    80,    -1,   957,    -1,   993,
      -1,  1117,    -1,   497,   498,    -1,   497,  1113,   498,    -1,
    1112,    -1,  1113,  1112,    -1,  1115,    -1,  1114,   500,  1115,
      -1,  1113,    -1,   503,  1114,   504,    -1,  1117,    -1,   497,
      -1,   498,    -1,   500,    -1,   501,    -1,  1110,    -1,   965,
      -1,  1107,    -1,  1108,    -1,   490,    -1,   488,    -1,   489,
      -1,   491,    -1,   492,    -1,   307,    -1,    47,    -1,    48,
      -1,    49,    -1,    50,    -1,    51,    -1,    52,    -1,    53,
      -1,    54,    -1,    55,    -1,    56,    -1,    57,    -1,    58,
      -1,    60,    -1,    59,    -1,    61,    -1,    62,    -1,    63,
      -1,    64,    -1,    65,    -1,    66,    -1,    67,    -1,    68,
      -1,    70,    -1,    69,    -1,     5,    -1,   194,    -1,   227,
      -1,   248,    -1,    25,    -1,   282,    -1,   285,    -1,   379,
      -1,    35,    -1,    36,    -1,    43,    -1,    44,    -1,   470,
      -1,   123,    -1,   208,    -1,   419,    -1,   432,    -1,   445,
      -1,   495,    -1,   496,    -1,   484,    -1,   502,    -1,   166,
     997,    -1,   166,   341,   997,    -1,   166,    89,    -1,   166,
     341,    89,    -1,   965,    -1,   497,  1119,   498,    -1,  1119,
     488,  1119,    -1,  1119,   489,  1119,    -1,  1119,   490,  1119,
      -1,  1119,   491,  1119,    -1,  1119,   492,  1119,    -1,  1108,
      -1,   968,    -1,    -1,  1046,  1121,    -1,  1121,  1046,    -1,
    1046,    -1,  1121,    -1,   252,  1097,    -1,  1048,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1193,  1193,  1196,  1198,  1200,  1202,  1204,  1206,  1208,
    1210,  1212,  1214,  1216,  1218,  1220,  1222,  1224,  1226,  1228,
    1230,  1232,  1234,  1236,  1254,  1256,  1258,  1260,  1262,  1264,
    1266,  1268,  1270,  1272,  1274,  1276,  1278,  1280,  1282,  1284,
    1286,  1288,  1290,  1292,  1294,  1296,  1298,  1300,  1302,  1304,
    1306,  1313,  1315,  1317,  1319,  1321,  1323,  1325,  1327,  1329,
    1331,  1333,  1335,  1337,  1339,  1341,  1343,  1345,  1347,  1349,
    1351,  1353,  1355,  1357,  1359,  1361,  1363,  1365,  1367,  1369,
    1371,  1373,  1375,  1377,  1384,  1386,  1388,  1390,  1392,  1394,
    1396,  1398,  1400,  1402,  1404,  1410,  1412,  1414,  1416,  1418,
    1420,  1422,  1424,  1426,  1432,  1442,  1446,  1454,  1458,  1468,
    1478,  1479,  1490,  1497,  1503,  1514,  1520,  1529,  1536,  1542,
    1551,  1558,  1566,  1571,  1579,  1584,  1590,  1595,  1601,  1605,
    1609,  1613,  1617,  1621,  1625,  1629,  1633,  1637,  1641,  1645,
    1649,  1653,  1657,  1661,  1665,  1669,  1673,  1677,  1681,  1685,
    1689,  1693,  1701,  1709,  1717,  1725,  1733,  1741,  1745,  1753,
    1757,  1765,  1773,  1781,  1785,  1793,  1797,  1805,  1809,  1817,
    1822,  1828,  1833,  1839,  1843,  1847,  1851,  1855,  1859,  1867,
    1871,  1875,  1883,  1887,  1891,  1895,  1899,  1903,  1907,  1911,
    1915,  1920,  1924,  1928,  1932,  1936,  1940,  1948,  1952,  1960,
    1964,  1972,  1976,  1980,  1994,  1998,  2002,  2006,  2014,  2018,
    2022,  2026,  2034,  2038,  2042,  2046,  2050,  2054,  2058,  2066,
    2070,  2075,  2081,  2085,  2093,  2097,  2101,  2105,  2109,  2117,
    2121,  2129,  2133,  2137,  2141,  2145,  2154,  2162,  2166,  2174,
    2178,  2186,  2194,  2198,  2202,  2206,  2214,  2218,  2222,  2226,
    2234,  2238,  2246,  2250,  2254,  2258,  2262,  2266,  2270,  2274,
    2278,  2282,  2286,  2290,  2294,  2298,  2302,  2306,  2310,  2314,
    2318,  2322,  2326,  2330,  2334,  2338,  2342,  2346,  2350,  2354,
    2358,  2362,  2366,  2370,  2378,  2382,  2390,  2394,  2399,  2405,
    2410,  2416,  2424,  2429,  2435,  2439,  2447,  2451,  2455,  2459,
    2467,  2471,  2479,  2490,  2501,  2505,  2513,  2517,  2521,  2529,
    2534,  2540,  2544,  2548,  2552,  2556,  2560,  2564,  2568,  2572,
    2576,  2584,  2589,  2595,  2600,  2606,  2611,  2617,  2622,  2628,
    2632,  2640,  2644,  2648,  2652,  2656,  2660,  2665,  2671,  2676,
    2682,  2686,  2694,  2698,  2702,  2710,  2718,  2723,  2729,  2733,
    2737,  2745,  2749,  2753,  2757,  2761,  2765,  2769,  2777,  2781,
    2785,  2789,  2797,  2805,  2810,  2816,  2820,  2824,  2828,  2832,
    2836,  2844,  2848,  2856,  2860,  2864,  2868,  2876,  2881,  2887,
    2891,  2899,  2907,  2911,  2916,  2921,  2927,  2931,  2935,  2939,
    2944,  2950,  2958,  2966,  2970,  2974,  2978,  2982,  2990,  2995,
    3001,  3005,  3009,  3014,  3020,  3024,  3028,  3033,  3039,  3044,
    3050,  3055,  3061,  3069,  3074,  3080,  3084,  3092,  3100,  3104,
    3109,  3115,  3123,  3131,  3136,  3142,  3146,  3154,  3158,  3162,
    3166,  3170,  3174,  3178,  3182,  3186,  3190,  3194,  3198,  3206,
    3211,  3217,  3221,  3225,  3236,  3240,  3248,  3253,  3259,  3263,
    3271,  3275,  3283,  3288,  3294,  3299,  3305,  3309,  3317,  3322,
    3328,  3336,  3341,  3347,  3351,  3359,  3367,  3371,  3379,  3383,
    3387,  3395,  3400,  3406,  3410,  3418,  3426,  3430,  3438,  3442,
    3446,  3450,  3458,  3466,  3474,  3482,  3490,  3495,  3501,  3505,
    3513,  3518,  3524,  3528,  3536,  3540,  3544,  3552,  3560,  3564,
    3568,  3576,  3580,  3588,  3596,  3600,  3608,  3612,  3620,  3624,
    3628,  3636,  3640,  3644,  3648,  3656,  3661,  3667,  3672,  3678,
    3682,  3690,  3694,  3699,  3705,  3709,  3713,  3717,  3721,  3725,
    3733,  3738,  3744,  3748,  3755,  3759,  3767,  3773,  3777,  3785,
    3789,  3797,  3801,  3809,  3818,  3827,  3831,  3835,  3839,  3843,
    3847,  3851,  3855,  3859,  3863,  3867,  3875,  3883,  3887,  3895,
    3899,  3907,  3911,  3915,  3919,  3923,  3931,  3935,  3943,  3951,
    3955,  3963,  3971,  3975,  3983,  3991,  3995,  4003,  4007,  4011,
    4015,  4019,  4027,  4032,  4038,  4043,  4049,  4055,  4061,  4069,
    4073,  4081,  4085,  4093,  4097,  4105,  4109,  4117,  4121,  4129,
    4137,  4145,  4149,  4157,  4161,  4165,  4169,  4173,  4177,  4181,
    4185,  4189,  4193,  4197,  4201,  4209,  4213,  4221,  4225,  4233,
    4237,  4245,  4253,  4257,  4262,  4268,  4272,  4276,  4280,  4284,
    4288,  4292,  4296,  4300,  4304,  4308,  4312,  4316,  4320,  4324,
    4328,  4332,  4340,  4344,  4348,  4352,  4356,  4360,  4364,  4368,
    4372,  4376,  4380,  4384,  4392,  4396,  4404,  4409,  4414,  4418,
    4422,  4427,  4432,  4437,  4442,  4447,  4456,  4460,  4464,  4468,
    4472,  4482,  4492,  4502,  4506,  4510,  4520,  4524,  4528,  4538,
    4546,  4550,  4558,  4566,  4570,  4578,  4582,  4586,  4590,  4594,
    4602,  4606,  4614,  4618,  4622,  4626,  4634,  4638,  4642,  4646,
    4650,  4654,  4658,  4662,  4666,  4670,  4678,  4682,  4690,  4694,
    4702,  4707,  4713,  4717,  4725,  4733,  4741,  4745,  4753,  4758,
    4764,  4769,  4775,  4779,  4787,  4792,  4798,  4803,  4809,  4813,
    4821,  4825,  4829,  4837,  4841,  4846,  4852,  4856,  4861,  4867,
    4871,  4876,  4882,  4886,  4890,  4898,  4903,  4909,  4913,  4921,
    4925,  4933,  4937,  4945,  4949,  4957,  4961,  4965,  4969,  4973,
    4981,  4985,  4989,  4993,  4997,  5005,  5013,  5021,  5025,  5029,
    5037,  5041,  5045,  5053,  5057,  5065,  5069,  5073,  5077,  5081,
    5085,  5089,  5093,  5097,  5101,  5105,  5109,  5113,  5121,  5125,
    5129,  5133,  5141,  5145,  5153,  5158,  5164,  5172,  5176,  5184,
    5192,  5196,  5204,  5209,  5215,  5219,  5227,  5231,  5239,  5243,
    5251,  5255,  5259,  5263,  5271,  5275,  5283,  5287,  5291,  5299,
    5303,  5308,  5314,  5322,  5327,  5333,  5337,  5341,  5349,  5353,
    5361,  5366,  5372,  5376,  5380,  5384,  5388,  5392,  5396,  5400,
    5404,  5408,  5412,  5416,  5420,  5424,  5428,  5432,  5436,  5440,
    5444,  5448,  5452,  5456,  5460,  5468,  5473,  5479,  5484,  5490,
    5494,  5498,  5502,  5506,  5510,  5514,  5522,  5526,  5530,  5534,
    5538,  5542,  5546,  5550,  5554,  5558,  5562,  5566,  5570,  5574,
    5578,  5582,  5590,  5594,  5598,  5606,  5610,  5618,  5622,  5626,
    5630,  5634,  5642,  5647,  5653,  5657,  5661,  5665,  5673,  5677,
    5682,  5688,  5692,  5700,  5708,  5716,  5720,  5728,  5732,  5736,
    5740,  5744,  5748,  5752,  5756,  5760,  5764,  5768,  5772,  5776,
    5780,  5788,  5792,  5797,  5803,  5807,  5811,  5819,  5823,  5827,
    5835,  5840,  5846,  5850,  5858,  5863,  5868,  5874,  5880,  5888,
    5896,  5901,  5907,  5911,  5915,  5919,  5923,  5927,  5931,  5935,
    5939,  5943,  5947,  5951,  5955,  5959,  5963,  5967,  5975,  5980,
    5986,  5990,  5998,  6006,  6011,  6017,  6025,  6029,  6037,  6045,
    6049,  6053,  6057,  6061,  6069,  6074,  6080,  6088,  6092,  6096,
    6100,  6104,  6108,  6116,  6124,  6128,  6132,  6140,  6145,  6151,
    6155,  6159,  6167,  6171,  6179,  6183,  6191,  6196,  6202,  6207,
    6213,  6218,  6224,  6229,  6235,  6243,  6247,  6251,  6255,  6259,
    6263,  6267,  6275,  6280,  6286,  6292,  6302,  6307,  6313,  6317,
    6321,  6325,  6333,  6335,  6343,  6348,  6354,  6362,  6366,  6370,
    6378,  6382,  6390,  6398,  6403,  6409,  6417,  6422,  6428,  6436,
    6441,  6447,  6451,  6455,  6459,  6463,  6467,  6471,  6475,  6483,
    6488,  6494,  6502,  6506,  6514,  6518,  6526,  6534,  6542,  6550,
    6554,  6562,  6594,  6596,  6600,  6604,  6608,  6617,  6623,  6627,
    6635,  6639,  6647,  6651,  6659,  6663,  6667,  6671,  6675,  6679,
    6683,  6687,  6695,  6699,  6707,  6711,  6715,  6719,  6723,  6727,
    6735,  6739,  6747,  6751,  6759,  6767,  6772,  6774,  6780,  6784,
    6788,  6792,  6796,  6800,  6804,  6808,  6816,  6821,  6827,  6831,
    6836,  6842,  6846,  6850,  6855,  6861,  6866,  6872,  6880,  6884,
    6892,  6896,  6904,  6908,  6912,  6916,  6920,  6925,  6929,  6933,
    6941,  6946,  6952,  6956,  6964,  6968,  6973,  6979,  6987,  6995,
    6999,  7007,  7011,  7019,  7024,  7030,  7035,  7041,  7045,  7053,
    7058,  7064,  7068,  7076,  7080,  7088,  7093,  7099,  7103,  7111,
    7116,  7122,  7126,  7134,  7138,  7142,  7146,  7150,  7154,  7158,
    7162,  7168,  7172,  7176,  7184,  7188,  7192,  7196,  7200,  7204,
    7212,  7216,  7220,  7224,  7232,  7236,  7240,  7244,  7252,  7257,
    7263,  7267,  7275,  7279,  7283,  7287,  7295,  7299,  7307,  7311,
    7315,  7323,  7331,  7336,  7342,  7346,  7350,  7355,  7361,  7365,
    7373,  7381,  7383,  7385,  7389,  7393,  7397,  7405,  7415,  7426,
    7435,  7439,  7443,  7447,  7451,  7455,  7459,  7467,  7471,  7475,
    7479,  7487,  7491,  7499,  7504,  7510,  7514,  7518,  7522,  7526,
    7530,  7534,  7538,  7542,  7546,  7550,  7558,  7563,  7569,  7573,
    7581,  7585,  7593,  7601,  7609,  7613,  7621,  7625,  7633,  7641,
    7649,  7653,  7657,  7661,  7665,  7669,  7677,  7682,  7688,  7693,
    7699,  7703,  7707,  7711,  7719,  7727,  7731,  7736,  7742,  7746,
    7750,  7754,  7758,  7762,  7766,  7770,  7774,  7778,  7782,  7786,
    7790,  7795,  7801,  7805,  7813,  7817,  7821,  7825,  7829,  7833,
    7837,  7841,  7845,  7849,  7853,  7857,  7861,  7865,  7869,  7873,
    7877,  7881,  7885,  7889,  7893,  7897,  7901,  7905,  7909,  7913,
    7917,  7921,  7925,  7929,  7933,  7937,  7941,  7945,  7949,  7953,
    7957,  7961,  7965,  7969,  7973,  7977,  7981,  7985,  7989,  7993,
    7997,  8001,  8005,  8009,  8013,  8017,  8021,  8025,  8029,  8033,
    8038,  8042,  8050,  8054,  8058,  8062,  8066,  8070,  8074,  8078,
    8082,  8086,  8090,  8094,  8098,  8102,  8106,  8110,  8114,  8118,
    8122,  8126,  8130,  8134,  8142,  8146,  8150,  8154,  8158,  8162,
    8166,  8170,  8174,  8178,  8182,  8190,  8194,  8198,  8202,  8206,
    8210,  8214,  8218,  8222,  8226,  8230,  8234,  8238,  8242,  8246,
    8250,  8254,  8258,  8262,  8266,  8270,  8274,  8278,  8282,  8286,
    8290,  8294,  8298,  8302,  8306,  8310,  8314,  8318,  8322,  8326,
    8330,  8334,  8338,  8342,  8346,  8350,  8354,  8358,  8362,  8366,
    8370,  8374,  8382,  8386,  8394,  8398,  8402,  8407,  8413,  8421,
    8425,  8433,  8437,  8445,  8449,  8457,  8461,  8466,  8472,  8477,
    8483,  8487,  8495,  8503,  8507,  8512,  8518,  8526,  8530,  8537,
    8542,  8548,  8552,  8557,  8563,  8568,  8577,  8581,  8585,  8593,
    8597,  8601,  8609,  8613,  8617,  8625,  8629,  8637,  8641,  8645,
    8649,  8653,  8657,  8661,  8665,  8669,  8677,  8681,  8689,  8693,
    8701,  8705,  8709,  8713,  8717,  8721,  8729,  8733,  8741,  8745,
    8753,  8757,  8761,  8769,  8773,  8781,  8786,  8792,  8796,  8800,
    8804,  8808,  8812,  8816,  8820,  8828,  8832,  8840,  8848,  8853,
    8859,  8863,  8867,  8871,  8875,  8880,  8886,  8894,  8902,  8906,
    8910,  8918,  8922,  8930,  8938,  8942,  8950,  8958,  8963,  8969,
    8974,  8980,  8984,  8992,  8996,  9000,  9004,  9012,  9016,  9025,
    9027,  9035,  9040,  9046,  9050,  9058,  9062,  9070,  9078,  9082,
    9090,  9094,  9098,  9102,  9110,  9114,  9122,  9126,  9134,  9138,
    9146,  9150,  9158,  9166,  9174,  9182,  9190,  9198,  9206,  9210,
    9218,  9222,  9226,  9230,  9234,  9238,  9242,  9246,  9250,  9254,
    9258,  9262,  9266,  9270,  9271,  9276,  9282,  9290,  9294,  9295,
    9299,  9307,  9311,  9315,  9319,  9320,  9321,  9322,  9327,  9331,
    9335,  9339,  9340,  9341,  9346,  9350,  9354,  9358,  9362,  9366,
    9370,  9374,  9378,  9382,  9386,  9390,  9394,  9398,  9402,  9406,
    9410,  9414,  9418,  9422,  9426,  9430,  9434,  9438,  9442,  9446,
    9450,  9454,  9458,  9462,  9466,  9470,  9474,  9478,  9482,  9486,
    9490,  9494,  9498,  9502,  9506,  9510,  9518,  9522,  9526,  9530,
    9534,  9538,  9542,  9546,  9550,  9554,  9558,  9562,  9566,  9570,
    9574,  9578,  9582,  9586,  9590,  9594,  9598,  9602,  9610,  9614,
    9618,  9622,  9626,  9630,  9634,  9638,  9642,  9646,  9650,  9654,
    9658,  9662,  9666,  9670,  9674,  9678,  9682,  9686,  9690,  9694,
    9698,  9702,  9706,  9710,  9714,  9718,  9722,  9726,  9730,  9734,
    9738,  9742,  9746,  9750,  9754,  9758,  9762,  9766,  9770,  9774,
    9778,  9782,  9786,  9790,  9794,  9798,  9802,  9806,  9810,  9814,
    9818,  9822,  9826,  9830,  9834,  9838,  9842,  9846,  9850,  9854,
    9858,  9862,  9866,  9870,  9874,  9878,  9882,  9886,  9890,  9894,
    9898,  9902,  9906,  9910,  9914,  9922,  9929,  9942,  9943,  9946,
    9947,  9948,  9954,  9955,  9956,  9957,  9958,  9961,  9961,  9971,
    9970,  9980,  9996,  9998, 10001, 10003, 10007, 10019, 10035, 10039,
   10050, 10051, 10054, 10066, 10075, 10076, 10079, 10080, 10081, 10084,
   10085, 10088, 10089, 10092, 10093, 10096, 10098, 10100, 10102, 10106,
   10113, 10120, 10136, 10169, 10179, 10182, 10184, 10197, 10198, 10200,
   10202, 10206, 10219, 10226, 10263, 10272, 10274, 10275, 10278, 10280,
   10281, 10284, 10285, 10286, 10287, 10288, 10295, 10294, 10304, 10306,
   10308, 10309, 10310, 10313, 10314, 10315, 10316, 10317, 10320, 10321,
   10325, 10324, 10341, 10339, 10354, 10353, 10366, 10372, 10373, 10376,
   10378, 10379, 10382, 10383, 10384, 10385, 10388, 10389, 10392, 10400,
   10417, 10425, 10448, 10546, 10580, 10582, 10584, 10588, 10592, 10591,
   10642, 10644, 10643, 10658, 10664, 10671, 10676, 10679, 10680, 10683,
   10684, 10685, 10686, 10687, 10688, 10689, 10697, 10705, 10708, 10709,
   10710, 10711, 10712, 10713, 10721, 10729, 10730, 10731, 10734, 10735,
   10738, 10740, 10744, 10830, 10831, 10838, 10839, 10840, 10846, 10855,
   10858, 10859, 10860, 10861, 10864, 10865, 10866, 10869, 10871, 10879,
   10880, 10886, 10888, 10889, 10892, 10893, 10896, 10903, 10910, 10910,
   10912, 10912, 10914, 10921, 10922, 10925, 10926, 10927, 10928, 10929,
   10930, 10931, 10932, 10933, 10939, 10946, 10953, 10962, 10963, 10975,
   10986, 10997, 11001, 11002, 11005, 11010, 11014, 11015, 11018, 11024,
   11032, 11035, 11042, 11046, 11047, 11050, 11053, 11057, 11058, 11061,
   11067, 11075, 11076, 11085, 11094, 11106, 11107, 11108, 11109, 11110,
   11111, 11112, 11113, 11114, 11115, 11116, 11117, 11118, 11119, 11120,
   11127, 11128, 11131, 11132, 11139, 11140, 11141, 11148, 11147, 11164,
   11165, 11172, 11171, 11240, 11246, 11252, 11260, 11266, 11272, 11278,
   11284, 11290, 11296, 11302, 11308, 11319, 11320, 11323, 11324, 11325,
   11326, 11327, 11328, 11329, 11330, 11331, 11332, 11333, 11334, 11335,
   11336, 11337, 11338, 11339, 11340, 11341, 11342, 11343, 11344, 11345,
   11346, 11349, 11350, 11351, 11352, 11353, 11354, 11358, 11359, 11360,
   11361, 11362, 11363, 11364, 11367, 11370, 11371, 11372, 11373, 11374,
   11375, 11376, 11377, 11382, 11383, 11384, 11385, 11386, 11387, 11388,
   11389, 11390, 11393, 11394, 11395, 11396, 11399, 11400, 11401, 11402,
   11405, 11406, 11407, 11408, 11409, 11410, 11411, 11429, 11429, 11431,
   11432, 11433, 11434, 11435, 11436, 11442, 11443, 11446, 11447, 11448,
   11449, 11450, 11451, 11452, 11453, 11454, 11455, 11456, 11457, 11458,
   11459, 11460, 11461, 11462, 11463, 11464, 11465, 11466, 11467, 11468,
   11469, 11470, 11471, 11472, 11473, 11474, 11475, 11476, 11477, 11479,
   11480, 11481, 11482, 11483, 11484, 11485, 11486, 11487, 11488, 11489,
   11490, 11491, 11492, 11494, 11495, 11496, 11497, 11498, 11499, 11500,
   11501, 11502, 11503, 11504, 11505, 11506, 11507, 11508, 11509, 11510,
   11511, 11513, 11514, 11515, 11516, 11517, 11518, 11519, 11521, 11522,
   11523, 11524, 11525, 11526, 11527, 11528, 11529, 11531, 11532, 11533,
   11534, 11535, 11536, 11537, 11538, 11539, 11540, 11541, 11542, 11543,
   11544, 11545, 11546, 11547, 11548, 11549, 11550, 11551, 11552, 11553,
   11554, 11555, 11556, 11557, 11558, 11559, 11560, 11561, 11562, 11564,
   11565, 11567, 11568, 11569, 11570, 11571, 11572, 11573, 11574, 11575,
   11576, 11577, 11578, 11579, 11580, 11581, 11582, 11583, 11584, 11585,
   11586, 11587, 11588, 11589, 11590, 11591, 11592, 11593, 11594, 11595,
   11596, 11597, 11598, 11599, 11600, 11601, 11602, 11603, 11604, 11605,
   11606, 11607, 11608, 11609, 11610, 11611, 11612, 11613, 11614, 11615,
   11616, 11617, 11618, 11619, 11620, 11621, 11622, 11623, 11624, 11626,
   11627, 11628, 11629, 11630, 11631, 11632, 11633, 11634, 11635, 11636,
   11637, 11638, 11639, 11640, 11641, 11642, 11643, 11644, 11645, 11646,
   11647, 11648, 11649, 11650, 11651, 11652, 11653, 11654, 11655, 11656,
   11657, 11658, 11659, 11660, 11661, 11662, 11663, 11664, 11665, 11666,
   11667, 11668, 11669, 11670, 11671, 11672, 11673, 11674, 11675, 11677,
   11680, 11680, 11683, 11689, 11690, 11693, 11695, 11700, 11710, 11717,
   11718, 11719, 11722, 11755, 11757, 11759, 11762, 11772, 11782, 11792,
   11793, 11796, 11798, 11799, 11800, 11803, 11805, 11813, 11814, 11815,
   11819, 11820, 11824, 11825, 11828, 11829, 11832, 11833, 11834, 11835,
   11836, 11839, 11840, 11841, 11842, 11843, 11844, 11845, 11846, 11847,
   11848, 11849, 11850, 11851, 11852, 11853, 11854, 11855, 11856, 11857,
   11858, 11859, 11860, 11861, 11862, 11863, 11864, 11865, 11866, 11867,
   11868, 11869, 11870, 11871, 11872, 11873, 11874, 11875, 11876, 11877,
   11878, 11879, 11880, 11881, 11882, 11883, 11884, 11885, 11886, 11887,
   11888, 11889, 11890, 11891, 11892, 11893, 11894, 11897, 11898, 11899,
   11900, 11903, 11904, 11905, 11906, 11907, 11908, 11909, 11910, 11911,
   11914, 11915, 11916, 11917, 11918, 11921, 11922
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", 
  "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "TYPECAST", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", 
  "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", "ADD_P", "ADMIN", "AFTER", 
  "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS", "ANALYSE", "ANALYZE", 
  "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", 
  "ASYMMETRIC", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", 
  "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", 
  "CACHE", "CALLED", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG_P", 
  "CHAIN", "CHAR_P", "CHARACTER", "CHARACTERISTICS", "CHECK", 
  "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", 
  "COLUMN", "COMMENT", "COMMIT", "COMMITTED", "CONCURRENTLY", 
  "CONFIGURATION", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", 
  "CONTINUE_P", "CONVERSION_P", "COPY", "COST", "CREATE", "CREATEDB", 
  "CREATEROLE", "CREATEUSER", "CROSS", "CSV", "CURRENT_P", 
  "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", 
  "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", 
  "DATA_P", "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", 
  "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", 
  "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", 
  "DISABLE_P", "DISCARD", "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", 
  "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", 
  "END_P", "ENUM_P", "ESCAPE", "EXCEPT", "EXCLUDING", "EXCLUSIVE", 
  "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", 
  "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", 
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GLOBAL", 
  "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING", 
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", 
  "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", 
  "INCREMENT", "INDEX", "INDEXES", "INHERIT", "INHERITS", "INITIALLY", 
  "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", 
  "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", 
  "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", 
  "LARGE_P", "LAST_P", "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAST", 
  "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", 
  "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", 
  "MAPPING", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", 
  "MONTH_P", "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", 
  "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", "NOTHING", 
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OPTIONS", "OR", "ORDER", "OUT_P", "OUTER_P", 
  "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL", 
  "PARTITION", "PASSWORD", "PLACING", "PLANS", "POSITION", "PRECEDING", 
  "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY", "PRIOR", 
  "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", "RANGE", "READ", 
  "REAL", "REASSIGN", "RECHECK", "RECURSIVE", "REFERENCES", "REINDEX", 
  "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", 
  "RESET", "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", 
  "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SERVER", "SESSION", "SESSION_USER", "SET", 
  "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", 
  "STABLE", "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN", 
  "STDOUT", "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SUPERUSER_P", 
  "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", 
  "TEMPLATE", "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNBOUNDED", "UNCOMMITTED", 
  "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", 
  "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATOR", "VALUE_P", 
  "VALUES", "VARCHAR", "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", 
  "VIEW", "VOLATILE", "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH", 
  "WITHOUT", "WORK", "WRAPPER", "WRITE", "XML_P", "XMLATTRIBUTES", 
  "XMLCONCAT", "XMLELEMENT", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", 
  "XMLSERIALIZE", "YEAR_P", "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", 
  "WITH_TIME", "IDENT", "FCONST", "SCONST", "BCONST", "XCONST", "Op", 
  "ICONST", "PARAM", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", 
  "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", 
  "','", "';'", "':'", "'{'", "'}'", "$accept", "prog", "stmt", 
  "CreateRoleStmt", "opt_with", "OptRoleList", "OptRoleElem", 
  "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", "AlterUserStmt", 
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt", 
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt", 
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt", 
  "set_rest", "var_name", "var_list", "var_value", "iso_level", 
  "opt_boolean", "zone_value", "opt_encoding", "ColId_or_Sconst", 
  "VariableResetStmt", "SetResetClause", "VariableShowStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "DiscardStmt", "AlterTableStmt", "alter_table_cmds", 
  "alter_table_cmd", "alter_column_default", "opt_drop_behavior", 
  "alter_using", "reloptions", "opt_reloptions", "reloption_list", 
  "reloption_elem", "ClosePortalStmt", "CopyStmt", "copy_from", 
  "copy_file_name", "copy_opt_list", "copy_opt_item", "opt_binary", 
  "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "key_actions", "key_update", "key_delete", 
  "key_action", "OptInherit", "OptWith", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "create_as_target", "OptCreateAs", 
  "CreateAsList", "CreateAsElement", "opt_with_data", "CreateSeqStmt", 
  "AlterSeqStmt", "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by", 
  "NumericOnly", "CreatePLangStmt", "opt_trusted", "handler_name", 
  "validator_clause", "opt_validator", "opt_lancompiler", "DropPLangStmt", 
  "opt_procedural", "CreateTableSpaceStmt", "OptTableSpaceOwner", 
  "DropTableSpaceStmt", "CreateFdwStmt", "DropFdwStmt", "AlterFdwStmt", 
  "create_generic_options", "generic_option_list", 
  "alter_generic_options", "alter_generic_option_list", 
  "alter_generic_option_elem", "generic_option_elem", 
  "generic_option_name", "generic_option_arg", "CreateForeignServerStmt", 
  "opt_type", "foreign_server_version", "opt_foreign_server_version", 
  "DropForeignServerStmt", "AlterForeignServerStmt", 
  "CreateUserMappingStmt", "auth_ident", "DropUserMappingStmt", 
  "AlterUserMappingStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "enum_val_list", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_opfamily", 
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt", 
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt", 
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt", 
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt", 
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text", 
  "FetchStmt", "fetch_direction", "from_in", "GrantStmt", "RevokeStmt", 
  "privileges", "privilege_list", "privilege", "privilege_target", 
  "grantee_list", "grantee", "opt_grant_grant_option", 
  "function_with_argtypes_list", "function_with_argtypes", 
  "GrantRoleStmt", "RevokeRoleStmt", "opt_grant_admin_option", 
  "opt_granted_by", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "opt_asc_desc", "opt_nulls_order", "CreateFunctionStmt", 
  "opt_or_replace", "func_args", "func_args_list", 
  "func_args_with_defaults", "func_args_with_defaults_list", "func_arg", 
  "arg_class", "param_name", "func_return", "func_type", 
  "func_arg_with_default", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "func_as", "opt_definition", "table_func_column", 
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list", 
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "CreateCastStmt", "cast_context", 
  "DropCastStmt", "opt_if_exists", "ReindexStmt", "reindex_type", 
  "opt_force", "RenameStmt", "opt_column", "opt_set_data", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleActionList", 
  "RuleActionMulti", "RuleActionStmt", "RuleActionStmtOrEmpty", "event", 
  "opt_instead", "DropRuleStmt", "NotifyStmt", "ListenStmt", 
  "UnlistenStmt", "TransactionStmt", "opt_transaction", 
  "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "PrepareStmt", "prep_type_clause", 
  "PreparableStmt", "ExecuteStmt", "execute_param_clause", "InsertStmt", 
  "insert_rest", "insert_column_list", "insert_column_item", 
  "returning_clause", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", "set_clause_list", 
  "set_clause", "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_options", "opt_hold", 
  "SelectStmt", "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "with_clause", "cte_list", "common_table_expr", 
  "into_clause", "OptTempTableName", "opt_table", "opt_all", 
  "opt_distinct", "opt_sort_clause", "sort_clause", "sortby_list", 
  "sortby", "select_limit", "opt_select_limit", "select_limit_value", 
  "opt_select_fetch_first_value", "select_offset_value", 
  "select_offset_value2", "row_or_rows", "first_or_next", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_list", "relation_expr_opt_alias", 
  "func_table", "where_clause", "where_or_current_clause", 
  "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType", 
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr", 
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "window_clause", 
  "window_definition_list", "window_definition", "over_clause", 
  "window_specification", "opt_existing_window_name", 
  "opt_partition_clause", "opt_frame_clause", "frame_extent", 
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "type_list", "array_expr", 
  "array_expr_list", "extract_list", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", "opt_asymmetric", 
  "ctext_expr", "ctext_expr_list", "ctext_row", "target_list", 
  "target_el", "relation_name", "qualified_name_list", "qualified_name", 
  "name_list", "name", "database_name", "access_method", "attr_name", 
  "index_name", "file_name", "func_name", "AexprConst", "Iconst", 
  "RoleId", "SignedIconst", "ColId", "type_function_name", 
  "col_name_keyword", "type_func_name_keyword", "reserved_keyword", 
  "SpecialRuleRelation", "statements", "statement", "CreateAsStmt", "@1", 
  "RuleStmt", "@2", "at", "ECPGConnect", "connection_target", 
  "opt_database_name", "db_prefix", "server", "opt_server", "server_name", 
  "opt_port", "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "connect_options", "opt_opt_value", 
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt", 
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale", 
  "ecpg_interval", "ECPGDeclaration", "@3", "sql_startdeclare", 
  "sql_enddeclare", "var_type_declarations", "vt_declarations", 
  "variable_declarations", "type_declaration", "@4", "var_declaration", 
  "@5", "@6", "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@7", "struct_union_type", "@8", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execstring", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "opt_sql", "using_list", 
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item", 
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem", 
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem", 
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off", 
  "ECPGSetConnection", "ECPGTypedef", "@9", "opt_reference", "ECPGVar", 
  "@10", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames", 
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColLabel", 
  "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "ECPGunreserved_con", "into_list", "ecpgstart", "c_args", 
  "coutputvariable", "civarind", "civar", "indicator", "cvariable", 
  "ecpg_param", "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", 
  "ecpg_xconst", "ecpg_ident", "quoted_ident_stringvar", "c_stuff_item", 
  "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 
  "DeallocateStmt", "Iresult", "execute_rest", "ecpg_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,    61,    60,    62,   739,    43,    45,
      42,    47,    37,    94,   740,    91,    93,    40,    41,    46,
      44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   505,   506,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   508,   509,   509,   510,   510,   511,   511,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   511,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   511,
     511,   511,   512,   513,   514,   515,   516,   517,   517,   518,
     518,   519,   520,   521,   521,   522,   522,   523,   523,   524,
     524,   525,   525,   526,   526,   526,   526,   526,   526,   527,
     527,   527,   528,   528,   528,   528,   528,   528,   528,   528,
     528,   528,   528,   528,   528,   528,   528,   529,   529,   530,
     530,   531,   531,   531,   532,   532,   532,   532,   533,   533,
     533,   533,   534,   534,   534,   534,   534,   534,   534,   535,
     535,   535,   536,   536,   537,   537,   537,   537,   537,   538,
     538,   539,   539,   539,   539,   539,   540,   541,   541,   542,
     542,   543,   544,   544,   544,   544,   545,   545,   545,   545,
     546,   546,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   548,   548,   549,   549,   549,   550,
     550,   551,   552,   552,   553,   553,   554,   554,   554,   554,
     555,   555,   556,   556,   557,   557,   558,   558,   558,   559,
     559,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   561,   561,   562,   562,   563,   563,   564,   564,   565,
     565,   566,   566,   566,   566,   566,   566,   566,   567,   567,
     568,   568,   569,   569,   569,   570,   571,   571,   572,   572,
     572,   573,   573,   573,   573,   573,   573,   573,   574,   574,
     574,   574,   575,   576,   576,   577,   577,   577,   577,   577,
     577,   578,   578,   579,   579,   579,   579,   580,   580,   581,
     581,   582,   583,   583,   583,   583,   584,   584,   584,   584,
     584,   585,   586,   587,   587,   587,   587,   587,   588,   588,
     589,   589,   589,   589,   590,   590,   590,   590,   591,   591,
     592,   592,   593,   594,   594,   595,   595,   596,   597,   597,
     597,   598,   599,   600,   600,   601,   601,   602,   602,   602,
     602,   602,   602,   602,   602,   602,   602,   602,   602,   603,
     603,   604,   604,   604,   605,   605,   606,   606,   607,   607,
     608,   608,   609,   609,   610,   610,   611,   611,   612,   612,
     613,   614,   614,   615,   615,   616,   617,   617,   618,   618,
     618,   619,   619,   620,   620,   621,   622,   622,   623,   623,
     623,   623,   624,   625,   626,   627,   628,   628,   629,   629,
     630,   630,   631,   631,   632,   632,   632,   633,   634,   634,
     634,   635,   635,   636,   637,   637,   638,   638,   639,   639,
     639,   640,   640,   640,   640,   641,   641,   642,   642,   643,
     643,   644,   644,   644,   645,   645,   645,   645,   645,   645,
     646,   646,   647,   647,   647,   647,   647,   648,   648,   649,
     649,   650,   650,   651,   652,   653,   653,   653,   653,   653,
     653,   653,   653,   653,   653,   653,   654,   655,   655,   656,
     656,   657,   657,   657,   657,   657,   658,   658,   659,   660,
     660,   661,   662,   662,   663,   664,   664,   665,   665,   665,
     665,   665,   666,   666,   667,   667,   668,   668,   669,   670,
     670,   671,   671,   672,   672,   673,   673,   674,   674,   675,
     676,   677,   677,   678,   678,   678,   678,   678,   678,   678,
     678,   678,   678,   678,   678,   679,   679,   680,   680,   681,
     681,   682,   683,   683,   683,   684,   684,   684,   684,   684,
     684,   684,   684,   684,   684,   684,   684,   684,   684,   684,
     684,   684,   685,   685,   685,   685,   685,   685,   685,   685,
     685,   685,   685,   685,   686,   686,   687,   687,   687,   687,
     687,   687,   687,   687,   687,   687,   688,   688,   688,   688,
     688,   688,   688,   688,   688,   688,   688,   688,   688,   688,
     689,   689,   690,   691,   691,   692,   692,   692,   692,   692,
     693,   693,   694,   694,   694,   694,   695,   695,   695,   695,
     695,   695,   695,   695,   695,   695,   696,   696,   697,   697,
     698,   698,   699,   699,   700,   701,   702,   702,   703,   703,
     704,   704,   705,   705,   706,   706,   707,   707,   708,   708,
     709,   709,   709,   710,   710,   710,   711,   711,   711,   712,
     712,   712,   713,   713,   713,   714,   714,   715,   715,   716,
     716,   717,   717,   718,   718,   719,   719,   719,   719,   719,
     720,   720,   720,   720,   720,   721,   722,   723,   723,   723,
     724,   724,   724,   725,   725,   726,   726,   726,   726,   726,
     726,   726,   726,   726,   726,   726,   726,   726,   727,   727,
     727,   727,   728,   728,   729,   729,   730,   731,   731,   732,
     733,   733,   734,   734,   735,   735,   736,   736,   737,   737,
     738,   738,   738,   738,   739,   739,   740,   740,   740,   741,
     741,   741,   742,   743,   743,   744,   744,   744,   745,   745,
     746,   746,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   747,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   747,   747,   747,   747,   748,   748,   749,   749,   750,
     750,   750,   750,   750,   750,   750,   751,   751,   751,   751,
     751,   751,   751,   751,   751,   751,   751,   751,   751,   751,
     751,   751,   752,   752,   752,   753,   753,   754,   754,   754,
     754,   754,   755,   755,   756,   756,   756,   756,   757,   757,
     757,   758,   758,   759,   760,   761,   761,   762,   762,   762,
     762,   762,   762,   762,   762,   762,   762,   762,   762,   762,
     762,   763,   763,   763,   764,   764,   764,   765,   765,   765,
     766,   766,   767,   767,   768,   768,   768,   768,   769,   770,
     771,   771,   772,   772,   772,   772,   772,   772,   772,   772,
     772,   772,   772,   772,   772,   772,   772,   772,   773,   773,
     774,   774,   775,   776,   776,   777,   778,   778,   779,   780,
     780,   780,   780,   780,   781,   781,   782,   783,   783,   783,
     783,   783,   783,   784,   785,   785,   785,   786,   786,   787,
     787,   787,   788,   788,   789,   789,   790,   790,   791,   791,
     792,   792,   793,   793,   794,   795,   795,   795,   795,   795,
     795,   795,   796,   796,   797,   797,   798,   798,   799,   799,
     799,   799,   800,   800,   801,   801,   802,   803,   803,   803,
     804,   804,   805,   806,   806,   807,   808,   808,   809,   810,
     810,   811,   811,   811,   811,   811,   811,   811,   811,   812,
     812,   813,   814,   814,   815,   815,   816,   817,   818,   819,
     819,   820,   821,   821,   821,   821,   821,   822,   822,   822,
     823,   823,   824,   824,   825,   825,   825,   825,   825,   825,
     825,   825,   826,   826,   827,   827,   827,   827,   827,   827,
     828,   828,   829,   829,   830,   831,   831,   831,   832,   832,
     832,   832,   832,   832,   832,   832,   833,   833,   834,   834,
     834,   835,   835,   835,   835,   836,   836,   837,   838,   838,
     839,   839,   840,   840,   840,   840,   840,   840,   840,   840,
     841,   841,   842,   842,   843,   843,   843,   844,   845,   846,
     846,   847,   847,   848,   848,   849,   849,   850,   850,   851,
     851,   852,   852,   853,   853,   854,   854,   855,   855,   856,
     856,   857,   857,   858,   858,   858,   858,   858,   858,   858,
     858,   858,   858,   858,   859,   859,   859,   859,   859,   859,
     860,   860,   860,   860,   861,   861,   861,   861,   862,   862,
     863,   863,   864,   864,   864,   864,   865,   865,   866,   866,
     866,   867,   868,   868,   869,   869,   869,   869,   870,   870,
     871,   872,   872,   872,   872,   872,   872,   873,   873,   873,
     874,   874,   874,   874,   874,   874,   874,   875,   875,   875,
     875,   876,   876,   877,   877,   878,   878,   878,   878,   878,
     878,   878,   878,   878,   878,   878,   879,   879,   880,   880,
     881,   881,   882,   883,   884,   884,   885,   885,   886,   887,
     888,   888,   888,   888,   888,   888,   889,   889,   890,   890,
     891,   891,   891,   891,   892,   893,   893,   893,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   895,   895,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   898,   898,   898,   898,   898,   898,
     898,   898,   898,   898,   898,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   900,   900,   901,   901,   901,   901,   902,   903,
     903,   904,   904,   905,   905,   906,   906,   906,   907,   907,
     908,   908,   909,   910,   910,   910,   911,   912,   912,   913,
     913,   914,   914,   914,   915,   915,   916,   916,   916,   917,
     917,   917,   918,   918,   918,   919,   919,   920,   920,   920,
     920,   920,   920,   920,   920,   920,   921,   921,   922,   922,
     923,   923,   923,   923,   923,   923,   924,   924,   925,   925,
     926,   926,   926,   927,   927,   928,   928,   929,   929,   929,
     929,   929,   929,   929,   929,   930,   930,   931,   932,   932,
     933,   933,   933,   933,   933,   933,   934,   935,   936,   936,
     936,   937,   937,   938,   939,   939,   940,   941,   941,   942,
     942,   943,   943,   944,   944,   944,   944,   945,   945,   946,
     946,   947,   947,   948,   948,   949,   949,   950,   951,   951,
     952,   952,   952,   952,   953,   953,   954,   954,   955,   955,
     956,   956,   957,   958,   959,   960,   961,   962,   963,   963,
     964,   964,   964,   964,   964,   964,   964,   964,   964,   964,
     964,   964,   964,   964,   964,   965,   966,   967,   967,   967,
     967,   968,   968,   968,   968,   968,   968,   968,   969,   969,
     969,   969,   969,   969,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   973,   973,   974,   974,   975,
     975,   975,   975,   975,   975,   975,   975,   977,   976,   979,
     978,   980,   981,   981,   981,   981,   982,   982,   982,   982,
     983,   983,   984,   985,   986,   986,   987,   987,   987,   988,
     988,   989,   989,   990,   990,   991,   991,   991,   991,   992,
     992,   992,   993,   994,   994,   995,   995,   996,   996,   996,
     996,   997,   997,   998,   999,  1000,  1001,  1001,  1002,  1003,
    1003,  1004,  1004,  1004,  1004,  1004,  1006,  1005,  1007,  1008,
    1009,  1009,  1009,  1010,  1010,  1010,  1010,  1010,  1011,  1011,
    1013,  1012,  1015,  1014,  1016,  1014,  1014,  1017,  1017,  1018,
    1018,  1018,  1019,  1019,  1019,  1019,  1020,  1020,  1021,  1021,
    1021,  1021,  1021,  1021,  1022,  1022,  1022,  1023,  1025,  1024,
    1026,  1027,  1026,  1028,  1028,  1029,  1029,  1030,  1030,  1031,
    1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,  1032,  1032,
    1032,  1032,  1032,  1032,  1032,  1032,  1032,  1032,  1033,  1033,
    1034,  1034,  1035,  1036,  1036,  1037,  1037,  1037,  1038,  1039,
    1040,  1040,  1040,  1040,  1041,  1041,  1041,  1042,  1042,  1043,
    1043,  1044,  1045,  1045,  1046,  1046,  1047,  1048,  1049,  1049,
    1050,  1050,  1051,  1051,  1051,  1052,  1052,  1052,  1052,  1052,
    1052,  1052,  1052,  1052,  1053,  1053,  1053,  1054,  1054,  1055,
    1056,  1057,  1058,  1058,  1059,  1060,  1061,  1061,  1062,  1063,
    1063,  1064,  1065,  1066,  1066,  1067,  1068,  1069,  1069,  1070,
    1071,  1071,  1071,  1071,  1071,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,
    1073,  1073,  1074,  1074,  1075,  1075,  1075,  1077,  1076,  1078,
    1078,  1080,  1079,  1081,  1081,  1081,  1082,  1082,  1082,  1082,
    1082,  1082,  1082,  1082,  1082,  1083,  1083,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1085,  1085,  1085,  1085,  1085,  1085,  1086,  1086,  1086,
    1086,  1086,  1086,  1086,  1087,  1088,  1088,  1088,  1088,  1088,
    1088,  1088,  1088,  1089,  1089,  1089,  1089,  1089,  1089,  1089,
    1089,  1089,  1090,  1090,  1090,  1090,  1091,  1091,  1091,  1091,
    1092,  1092,  1092,  1092,  1092,  1092,  1092,  1093,  1093,  1094,
    1094,  1094,  1094,  1094,  1094,  1095,  1095,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1097,  1097,  1098,  1099,  1099,  1100,  1100,  1101,  1102,  1103,
    1103,  1103,  1104,  1105,  1106,  1107,  1108,  1108,  1108,  1108,
    1108,  1109,  1110,  1110,  1110,  1111,  1111,  1112,  1112,  1112,
    1113,  1113,  1114,  1114,  1115,  1115,  1116,  1116,  1116,  1116,
    1116,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1118,  1118,  1118,
    1118,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1120,  1120,  1120,  1120,  1120,  1121,  1121
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     1,     0,     2,     0,     2,     2,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     2,     2,     2,     2,
       3,     3,     5,     5,     4,     5,     4,     3,     5,     3,
       5,     5,     6,     1,     1,     3,     5,     6,     4,     1,
       0,     2,     0,     1,     1,     1,     1,     1,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     5,
       2,     2,     2,     2,     3,     3,     3,     1,     3,     1,
       3,     1,     1,     1,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     3,     6,     1,     1,     1,     1,
       1,     0,     1,     1,     2,     3,     4,     3,     2,     2,
       1,     3,     4,     5,     4,     2,     4,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     4,     4,     4,     4,
       1,     3,     3,     4,     6,     6,     6,     6,     4,     7,
       2,     4,     3,     3,     3,     3,     3,     4,     4,     3,
       3,     3,     3,     3,     3,     4,     4,     3,     2,     3,
       3,     3,     2,     2,     3,     2,     1,     1,     0,     2,
       0,     3,     2,     0,     1,     3,     3,     1,     5,     3,
       2,     2,    10,     6,     1,     1,     1,     1,     1,     2,
       0,     1,     1,     3,     3,     1,     1,     3,     3,     3,
       4,     1,     0,     2,     0,     3,     0,     1,     0,    11,
      12,     1,     1,     2,     2,     2,     2,     0,     1,     0,
       1,     3,     1,     1,     1,     3,     2,     0,     3,     1,
       1,     2,     1,     3,     4,     4,     2,     5,     1,     2,
       2,     2,     3,     2,     0,     2,     2,     2,     2,     2,
       2,     3,     1,     4,     6,     7,    11,     3,     0,     1,
       3,     1,     2,     2,     2,     0,     1,     1,     2,     2,
       0,     3,     3,     2,     1,     1,     2,     2,     4,     0,
       2,     2,     2,     0,     3,     4,     4,     0,     2,     0,
       4,     0,     5,     3,     0,     1,     3,     1,     2,     3,
       0,     5,     4,     1,     0,     1,     2,     2,     1,     2,
       3,     2,     2,     2,     2,     3,     3,     1,     3,     1,
       0,     1,     2,     1,     5,     9,     1,     0,     1,     2,
       2,     2,     1,     0,     2,     0,     5,     7,     1,     0,
       6,     2,     0,     3,     5,     7,     6,     8,     7,     6,
       6,     4,     0,     1,     3,     4,     1,     3,     1,     2,
       2,     2,     2,     1,     1,    10,     2,     0,     2,     2,
       1,     0,     4,     6,     5,     4,     4,     8,     1,     1,
       1,     7,     9,     8,    14,    19,     1,     1,     1,     3,
       5,     1,     1,     1,     1,     3,     0,     1,     0,     1,
       1,     1,     3,     0,     1,     1,     1,     1,     1,     1,
       2,     0,     1,     2,     1,     2,     0,     2,     1,     2,
       2,     6,     8,     8,     4,     5,     4,     4,     4,     3,
       7,     8,     6,     6,     6,     6,     3,     1,     3,     3,
       1,     1,     1,     1,     1,     1,     3,     3,     3,     1,
       3,     3,     1,     3,    13,     1,     3,     4,     5,     4,
       7,     2,     1,     0,     2,     0,     1,     0,     6,     8,
       8,     1,     3,     5,     5,     7,     9,     7,     9,     5,
       6,     6,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     3,     3,     1,     3,     1,     2,     2,
       3,     5,     2,     2,     0,     6,     7,     7,     7,     8,
       8,     6,     8,     9,     9,     7,    10,     7,     8,     8,
       8,     8,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     2,     4,     2,
       5,     4,     4,     3,     3,     3,     1,     1,     1,     1,
       2,     2,     1,     1,     1,     2,     2,     1,     2,     2,
       1,     1,     7,     7,    10,     1,     1,     2,     4,     5,
       1,     3,     2,     2,     2,     2,     1,     2,     2,     4,
       3,     2,     2,     2,     2,     2,     1,     3,     1,     2,
       3,     0,     1,     3,     2,     6,     6,     9,     3,     0,
       3,     0,    13,    14,     1,     0,     2,     0,     1,     3,
       4,     4,     6,     1,     2,     0,     1,     1,     0,     1,
       1,     0,     9,    12,     7,     2,     0,     3,     2,     1,
       3,     3,     2,     1,     3,     3,     3,     2,     2,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     4,     5,
       1,     3,     3,     1,     2,     4,     5,     1,     1,     1,
       1,     3,     3,     2,     2,     2,     2,     1,     2,     2,
       1,     1,     1,     3,     2,     0,     2,     1,     3,     5,
       1,     2,     1,     0,     5,     7,     5,     7,     5,     7,
       3,     5,     5,     5,     1,     3,    11,    10,    10,     2,
       2,     0,     9,     2,     0,     4,     4,     4,     1,     1,
       1,     0,     7,     6,     6,     6,     6,     7,     9,     9,
       6,     6,     6,     6,     6,     8,     8,     6,     6,     6,
       8,     8,     8,     8,     6,     1,     0,     2,     0,     7,
       6,     6,     6,     6,     6,     6,     7,     6,     6,     6,
       6,     7,     7,     9,     9,     6,     6,     6,     8,     8,
       8,     6,     1,     1,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     1,     1,     1,     1,     1,
       0,     6,     8,     2,     2,     2,     2,     2,     3,     3,
       2,     2,     2,     2,     3,     2,     5,     4,     3,     3,
       3,     1,     1,     0,     3,     2,     2,     1,     3,     2,
       1,     0,     8,    10,     3,     4,     4,     0,     2,     5,
       2,     0,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     4,     3,     3,     1,     0,
       5,     6,     4,     2,     0,     4,     3,     5,     6,     4,
       6,     6,     5,     7,     1,     0,     6,    11,    11,    11,
      13,     9,    11,    10,     4,     2,     5,     2,     0,     4,
       5,     5,     2,     4,     1,     1,     1,     0,     1,     0,
       1,     0,     3,     0,     4,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     5,     4,     3,     0,     1,     1,
       1,     1,     4,     8,     3,     0,     5,     1,     4,     2,
       1,     3,     2,     2,     0,     6,     2,     0,     5,     3,
       0,     2,     2,     2,     3,     1,     3,     1,     2,     1,
       0,     7,     1,     3,     1,     1,     3,     5,     2,     1,
       3,     7,     0,     3,     2,     2,     2,     0,     2,     2,
       1,     1,     3,     3,     1,     2,     4,     4,     2,     3,
       5,     5,     1,     1,     9,     1,     2,     4,     4,     4,
       2,     3,     1,     3,     4,     2,     1,     0,     3,     3,
       4,     4,     4,     4,     2,     1,     1,     0,     1,     1,
       0,     1,     5,     1,     0,     1,     0,     3,     1,     3,
       4,     3,     4,     4,     2,     2,     4,     3,     5,     8,
       1,     0,     1,     1,     1,     3,     0,     1,     1,     1,
       1,     1,     1,     3,     0,     2,     0,     1,     3,     1,
       0,     1,     2,     4,     4,     2,     0,     2,     3,     2,
       0,     1,     3,     1,     2,     1,     2,     5,     6,     5,
       1,     2,     1,     4,     3,     4,     5,     4,     5,     4,
       5,     2,     4,     1,     2,     2,     2,     1,     1,     0,
       4,     2,     1,     2,     2,     4,     1,     3,     1,     2,
       3,     1,     2,     0,     2,     4,     4,     0,     1,     3,
       2,     2,     3,     5,     6,     2,     3,     3,     4,     0,
       1,     1,     1,     1,     1,     2,     5,     1,     1,     1,
       1,     2,     3,     3,     0,     1,     1,     1,     1,     1,
       2,     2,     2,     2,     2,     1,     3,     0,     1,     1,
       1,     1,     5,     2,     1,     1,     1,     1,     5,     2,
       2,     2,     1,     3,     3,     2,     1,     0,     3,     0,
       5,     2,     5,     2,     1,     2,     3,     0,     1,     1,
       1,     1,     1,     1,     3,     3,     3,     3,     3,     3,
       3,     0,     1,     4,     1,     3,     5,     2,     2,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
       2,     3,     3,     2,     3,     5,     4,     6,     3,     5,
       4,     6,     4,     6,     5,     7,     3,     2,     4,     2,
       3,     3,     4,     3,     4,     3,     4,     5,     6,     6,
       7,     6,     7,     6,     7,     3,     4,     4,     6,     2,
       3,     4,     1,     3,     2,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     5,     6,
       6,     7,     3,     4,     1,     1,     2,     4,     1,     1,
       1,     2,     2,     2,     1,     4,     5,     6,     8,     6,
       6,     5,     1,     1,     4,     1,     4,     1,     4,     1,
       4,     1,     1,     1,     1,     1,     1,     6,     4,     4,
       4,     4,     6,     5,     5,     5,     4,     6,     4,     4,
       4,     4,     5,     7,     7,     9,     4,     6,     5,     7,
       7,     7,     2,     3,     3,     3,     4,     0,     4,     1,
       3,     3,     1,     1,     1,     2,     2,     0,     2,     0,
       1,     3,     3,     2,     2,     0,     6,     1,     0,     3,
       0,     2,     2,     0,     1,     4,     2,     2,     2,     4,
       3,     5,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     1,     4,
       1,     4,     1,     2,     1,     2,     1,     3,     1,     3,
       3,     3,     2,     1,     3,     3,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     3,     2,     3,     0,
       3,     3,     2,     2,     1,     0,     2,     2,     3,     2,
       1,     1,     3,     5,     1,     2,     4,     2,     0,     1,
       0,     1,     2,     2,     2,     3,     5,     1,     2,     0,
       2,     1,     0,     1,     1,     1,     3,     3,     1,     3,
       3,     2,     1,     1,     1,     1,     1,     3,     1,     2,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     1,     1,     1,     2,     5,     2,     3,     6,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     2,     4,
       3,     2,     1,     1,     1,     1,     1,     0,     8,     0,
      14,     2,     5,     3,     2,     2,     3,     7,     1,     1,
       1,     0,     2,     2,     1,     0,     1,     3,     1,     2,
       0,     2,     0,     2,     0,     1,     3,     4,     3,     1,
       1,     1,     1,     2,     0,     2,     4,     0,     2,     2,
       2,     1,     1,     7,     3,     1,     1,     1,     1,     2,
       0,     1,     3,     3,     3,     3,     0,     4,     5,     5,
       0,     1,     1,     1,     1,     2,     2,     2,     1,     2,
       0,     7,     0,     5,     0,     4,     2,     2,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     5,     2,     1,     3,     2,     2,     3,     0,     5,
       1,     0,     5,     2,     2,     1,     1,     1,     2,     2,
       3,     1,     2,     2,     3,     3,     4,     2,     1,     2,
       1,     1,     2,     2,     3,     1,     1,     1,     1,     0,
       1,     3,     5,     0,     2,     0,     1,     2,     3,     2,
       1,     1,     1,     0,     1,     1,     1,     1,     1,     2,
       2,     3,     0,     1,     2,     1,     4,     4,     0,     1,
       1,     3,     1,     1,     1,     1,     2,     2,     1,     2,
       2,     1,     1,     1,     4,     4,     4,     1,     0,     3,
       3,     4,     1,     3,     3,     4,     1,     3,     3,     1,
       1,     1,     6,     1,     3,     3,     6,     1,     3,     3,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       4,     4,     1,     1,     4,     4,     3,     0,     7,     1,
       0,     0,     7,     3,     4,     3,     1,     1,     1,     2,
       3,     5,     2,     5,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     0,     1,     2,     1,     2,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     3,
       1,     2,     1,     3,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     2,
       3,     1,     3,     3,     3,     3,     3,     3,     1,     1,
       0,     2,     2,     1,     1,     2,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
    1757,     0,     2,     1,  2395,  2399,  2403,  2404,  2322,  2405,
    2406,  2371,  2372,  2373,  2374,  2375,  2376,  2377,  2378,  2379,
    2380,  2381,  2382,  2384,  2383,  2385,  2386,  2387,  2388,  2389,
    2390,  2391,  2392,  2394,  2393,  2343,  1764,  2340,  2337,  2338,
    2339,  2344,  2408,  2396,  2409,  2397,  2398,  2400,  2401,  2370,
    2402,  2410,  2411,  2412,  2407,  2342,  2335,  2336,  1595,  2415,
    2366,  2367,  2365,  2368,  2369,  2413,  2414,  2357,  2358,  2359,
    2360,  2416,  1765,  1766,  2362,  1758,  1762,  1826,  1899,  2363,
    2364,  2361,  1763,  2356,  1899,     0,  2017,  2018,  2019,     0,
    2020,  2021,  2022,  1948,  1913,  2023,     0,     0,  2024,  2025,
    2026,  2027,  2028,  2029,  2030,  2031,     0,  2032,  2033,  2034,
    2035,  1898,  2036,  2037,  2038,  2039,  2040,  1875,  1881,  2001,
       0,  1855,  1856,  1852,  1854,  1853,  1857,  1840,   923,   459,
     995,   994,     0,  1656,   923,  1657,  1614,  1658,  1615,  1616,
    1617,   241,     0,   997,  1618,     0,   923,   322,   337,  1659,
    1660,  1781,     0,  1619,  1620,     0,     0,     0,   459,   923,
       0,     0,  1621,  1013,  1622,     0,  1623,  1661,  1662,     0,
    1624,  1663,  1664,  1625,     0,  1626,  1627,  1665,  1666,  1667,
    1628,  1668,  1669,     0,     0,  1107,     0,  1629,  1670,  1630,
    1631,     0,  1671,  1632,  1633,  1634,  1672,  1673,  1674,  1635,
    1636,  1637,     0,  1638,     0,     0,     0,     0,     0,  1675,
     923,  1639,     0,  1114,     0,  1640,     0,  1676,  1641,     0,
    1642,     0,  1643,  1644,  1645,  1646,  1107,  1997,  1876,     0,
       0,   999,     0,  1647,  1677,     0,  1648,  1649,  1650,  1651,
    1652,  1653,  1654,  1655,     0,     0,    46,    47,    15,    14,
      20,    19,    68,    69,    36,     9,    59,    41,   100,    99,
     101,    26,    22,    54,    13,    23,    27,    43,    42,    12,
      40,    63,    44,    66,    33,    57,     6,    34,    58,     7,
      48,    70,    18,    45,    67,    29,    55,    52,    37,    38,
      39,    60,    61,    62,    84,    65,    95,    25,    74,    75,
      90,    76,    91,    77,    35,     8,    87,    86,    88,    30,
      56,    85,    89,    10,    11,    64,    82,    79,    96,    94,
     102,    80,    49,     3,     4,    71,    32,     5,    17,    16,
      31,    24,    98,    21,   997,    73,    83,    72,    78,    53,
      81,    97,    51,    93,  1083,  1070,  1116,  1082,     0,  1085,
    2073,  2074,    28,    92,   122,   104,   105,   110,  1761,  1815,
    1816,  1817,  1899,  1850,  1851,  1844,  1860,  1870,  1859,  1863,
    1871,  1858,  1877,     0,   107,   109,   111,   114,   108,   103,
     106,   113,   118,   112,   117,   115,   116,   119,   120,   121,
    2075,  1291,  2072,    50,  1832,     0,  1899,  1834,  1833,     0,
    2041,  2042,  2043,  2044,  2045,  2046,  2080,  2081,  2082,  2083,
    2084,  2086,  2085,  2332,  2097,  2098,  2099,  2100,  2101,  2102,
    2103,  2104,  2105,  2106,  2107,  2108,  2109,  2110,  2111,  2112,
    2113,  2114,  2115,  2116,  2117,  2118,  1606,  2119,  2120,  2121,
    2122,  2123,  2124,  2125,  2126,  2127,  2128,  2096,  2129,  2130,
    2131,  2132,  2133,  2134,  2135,  2136,  2137,  2138,  2139,  2140,
    2141,  2142,  2089,  2143,  2144,  2145,  2146,  2147,  2148,  2149,
    2150,  2151,  2152,  2153,  2154,  2155,  2156,  2157,  2158,  2159,
    2160,  2161,  2162,  2163,  2164,  2165,  2166,  2167,  2168,  2169,
    2170,  2171,  2172,  2173,  2174,  2175,  2176,  2090,  2177,  2178,
    2179,  2180,  2181,  2182,  2183,  2184,  2185,  2186,  2187,  2188,
    2189,  2190,  2191,  2192,  2193,  2194,  2195,  2196,  2197,  2198,
    2199,  2200,  2201,  2202,  2203,  2204,  2205,  2206,  2207,  2208,
    2091,  2209,  2210,  2092,  2211,  2212,  2213,  2214,  2215,  2216,
    2217,  2218,  2219,  2220,  2221,  2222,  2223,  2224,  2225,  2226,
    2227,  2228,  2229,  2230,  2231,  2232,  2233,  2234,  2235,  2236,
    2239,  2237,  2238,  2240,  2241,  2242,  2243,  2244,  2245,  2246,
    2247,  2248,  2249,  2250,  2251,  2252,  2253,  2254,  2255,  2256,
    2257,  2258,  2259,  2260,  2261,  2262,  2263,  2264,  2265,  2266,
    2267,  2268,  2093,  2269,  2270,  2271,  2272,  2273,  2274,  2275,
    2276,  2277,  2278,  2279,  2280,  2281,  2282,  2283,  2284,  2285,
    2286,  2288,  2287,  2289,  2290,  2291,  2292,  2293,  1781,  2294,
    2295,  2296,  2297,  2298,  2299,  2300,  2301,  2302,  2303,  2304,
    2305,  2306,  2307,  2308,  1607,  2309,  2310,  2311,  2312,  2313,
    2314,  2315,  2316,  2317,  2094,  2318,  2319,  1799,  1596,  1603,
    1774,  1795,  1604,  2015,  2016,  1605,  1602,  2087,  2088,  2095,
    1801,  2328,  1800,  1601,  1947,     0,     0,  1912,  1911,  1915,
    1914,  1573,  1916,  1909,  1910,  1802,  1920,  1919,  1572,     0,
    1922,  2047,  2048,  2049,  2050,  2052,  2051,  2053,  1678,  1679,
    1680,  1681,  1682,  1683,  1684,  1685,  1686,  1687,  1688,  1689,
    2065,  1690,  1691,  1692,  1693,  1694,  1695,  1696,  1697,  1698,
    1699,  1700,  1701,  1702,  1703,  1704,  1705,  1706,  1707,  1708,
    1709,  1710,  1711,  1712,  1713,  1714,  1715,  1716,  1717,  1718,
    2066,  2067,  1719,  1720,  1721,  1722,  1723,  1724,  1725,  1726,
    1727,  1728,  1729,  1730,  1731,  1732,  1733,  1734,  1735,  1736,
    1737,  1738,  1739,  1740,  1741,  1742,  1743,  1744,  2069,  1745,
    1746,  2068,  1747,  1748,  1749,  1750,  1751,  1752,  1753,  1754,
    2077,  2079,  2064,  1873,  2054,  2076,  2063,  2070,  2071,  2078,
    1883,  1879,  1887,  1882,     0,     0,     0,     0,  1899,   922,
     921,   907,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   458,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1771,     0,   931,   301,   300,   996,
     985,   459,     0,   910,   321,     0,     0,     0,     0,     0,
       0,     0,   582,     0,     0,     0,     0,     0,     0,     0,
       0,   170,     0,     0,   332,   331,     0,     0,   446,     0,
     724,     0,     0,   459,     0,     0,     0,  1780,  1775,  1785,
       0,  1778,  1779,  1601,     0,  2419,  2237,  1811,  1812,  2417,
    2279,  1062,     0,   242,   245,   243,   244,     0,     0,   824,
     609,     0,   608,     0,     0,     0,   606,     0,     0,     0,
       0,   610,   604,     0,   603,     0,     0,     0,   607,     0,
     605,     0,     0,   911,     0,  1865,  1866,  2179,  1025,  1012,
     997,  2098,   673,   677,   668,   674,   680,   681,   669,   666,
     667,  2250,     0,     0,     0,     0,   657,  1597,   672,  1598,
     686,   378,   378,   378,     0,   685,   690,   378,     0,   904,
     938,  1577,  1106,     0,     0,   659,   903,  2294,  1017,     0,
       0,   828,     0,   829,     0,  2265,   915,   228,  2061,  2271,
    1643,  2294,  2062,   224,  2058,  2059,   197,  2060,  2056,  2057,
    2055,  2102,     0,     0,   685,     0,   912,   913,  1113,  1111,
       0,     0,     0,     0,     0,  2129,  2202,   221,  2261,  2266,
    2271,  1643,  2294,  2317,   179,     0,   235,  2271,  1643,  2294,
       0,   931,  1756,  1755,     0,  1086,  1568,  1192,  1565,  1564,
       0,     0,  1874,   906,   905,  1198,     0,   998,  1001,     0,
    1157,  2248,  1090,  1092,  1003,  1083,     0,  1760,   992,  1110,
    1110,     0,  1110,     0,  1075,  1083,  1116,  1082,     0,   923,
       0,  1842,  1870,  1849,  1905,  1846,     0,     0,  1895,  1891,
    1888,  1896,  1897,  1890,  1878,  1280,  1281,  1282,  1279,  1292,
    1278,     0,  1821,  1283,  1862,  1827,     0,  1837,  1836,  1835,
    2345,  2346,  1949,  1773,  1792,     0,     0,     0,     0,     0,
       0,  1928,  1921,  1923,  1925,  1885,  1884,  1880,     0,     0,
       0,     0,  2007,  2008,  2006,     0,  2003,  2005,     0,  1905,
       0,     0,  1578,  1610,  1604,  1612,  1605,  1602,  1601,     0,
     617,   125,     0,     0,     0,     0,     0,     0,  2121,  2167,
    1475,  1485,  1483,  1484,  1477,  1478,  1479,  1480,  1481,  1482,
       0,   814,  1476,     0,   125,     0,     0,     0,     0,     0,
       0,     0,     0,  2206,   125,     0,     0,     0,     0,     0,
     927,   930,   908,   988,     0,  1565,     0,     0,   642,     0,
     651,   643,   648,     0,   645,     0,     0,   653,     0,   644,
     646,   647,   652,     0,     0,   649,   650,     0,     0,   919,
     378,     0,     0,     0,     0,     0,   125,   975,     0,   336,
     335,   125,   334,   333,  2121,  2167,     0,   745,   125,     0,
     172,   487,   462,     0,     0,   549,  2206,   125,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1784,  1790,     0,
    1782,  1950,  2420,  2418,  1908,     0,  1037,  2178,     0,   288,
       0,     0,  2178,   966,     0,  2178,     0,  2178,   165,  1570,
    2121,  2167,  2178,     0,     0,  2178,   157,  2178,     0,  2178,
     288,  2178,   463,     0,  2178,     0,  2178,  2206,   159,     0,
    2178,   288,   615,     0,     0,  2350,  2354,     0,  2352,  2347,
    1864,  1918,  1917,  1814,     0,  2430,     0,   670,   679,   678,
     676,   675,   671,  1599,  1600,     0,   664,   665,  1928,  2436,
     663,   687,     0,     0,   694,   693,   692,     0,     0,     0,
     695,     0,  1196,  1040,     0,   918,     0,     0,     0,     0,
     831,   831,   831,   914,   227,   225,     0,     0,     0,     0,
       0,     0,   920,     0,     0,     0,  1614,  1615,  1616,  1540,
       0,  1606,  1617,  1618,  1405,  1392,  1401,  1406,  1393,  1395,
    1402,  1619,  1620,  2155,  1621,  1622,  1591,  1623,  1624,  1235,
    1626,  1627,  1628,  1397,  1399,  1629,  1630,     0,  1592,  1632,
    1633,  2229,  1635,  1636,  1638,  1639,  1403,  1641,  1642,  1643,
    1644,  1645,  1646,  1590,     0,  1404,  1647,  1649,  1650,  1651,
    1652,  1653,  1654,  1655,  2334,  1584,  1486,  2333,     0,     0,
    1563,     0,  1380,     0,  1227,  1228,  1250,  1251,  1229,  1256,
    1257,  1269,  1230,     0,  1562,  1294,  1379,  1384,     0,  1378,
    1374,  1097,  1558,  1541,     0,  1375,  1580,  1594,  1593,  2328,
    1549,  1583,  1581,  1582,     0,     0,     0,   190,     0,     0,
    1996,   237,     0,   238,  1566,  2271,   180,   220,   192,   219,
     193,   222,   223,   191,     0,  2119,   181,     0,   188,     0,
       0,     0,     0,     0,     0,     0,   231,   909,     0,  1194,
       0,     0,  1547,  1569,  1193,   624,     0,     0,  1199,     0,
    1000,   997,  1554,  1553,  1555,     0,  1091,     0,     0,     0,
    1073,  1072,  1003,  1108,  1109,     0,     0,     0,     0,     0,
       0,     0,     0,  1150,  1131,  1147,  1151,     0,  1079,  1158,
    1759,  1905,  1906,     0,  1900,     0,  1899,  1899,  1893,  1892,
    1889,     0,     0,     0,     0,     0,     0,     0,  1818,   443,
    1820,   441,     0,     0,  1794,     0,  1798,  1796,  1928,  1944,
    1928,  1945,  1946,     0,  1951,  1952,     0,  1929,  2341,     0,
       0,  1935,     0,  1924,  1930,  1932,  1934,  1933,  1942,  1938,
    1941,  1943,  1886,  1899,  2014,     0,  2009,  2012,     0,  2004,
       0,  1579,     0,     0,     0,     0,     0,   618,     0,     0,
       0,   124,   964,   230,   962,     0,     0,     0,     0,   969,
       0,     0,     0,     0,   778,     0,     0,     0,     0,     0,
       0,   779,   777,   780,   787,   800,   803,     0,   714,   163,
     164,     0,     0,   856,   856,     0,     0,   856,     0,     0,
       0,     0,     0,     0,     0,   247,   250,     0,     0,     0,
       0,     0,     0,     0,   127,   154,     0,     0,     0,   428,
     440,     0,     0,     0,     0,     0,   437,     0,   125,   248,
     422,   425,     0,     0,     0,   496,   495,   856,     0,   246,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   127,   156,     0,     0,   249,     0,  1828,     0,
     925,   926,     0,   929,     0,   984,     0,     0,     0,     0,
       0,     0,  2121,  2167,     0,     0,     0,     0,     0,     0,
     324,   307,   308,   125,   306,     0,     0,   546,     0,  1238,
    1267,  1245,  1267,  1267,  1234,  1234,  1247,  1236,  1274,     0,
    1267,  1234,  1239,     0,  1237,  1277,  1277,  1262,     0,  1219,
    1220,  1221,  1222,  1248,  1249,  1223,  1254,  1255,  1224,  1291,
    1234,  1611,  1613,  1609,  1608,     0,   941,   974,     0,     0,
     127,   583,     0,     0,   547,     0,   127,     0,   168,     0,
     491,     0,     0,     0,     0,     0,     0,   507,   506,     0,
       0,   548,     0,   127,   424,     0,   414,   378,     0,     0,
    2127,     0,  1576,     0,     0,  1788,  1786,  1783,     0,  1776,
    1790,  1065,  1067,  1066,     0,  1064,     0,  1207,     0,   288,
     286,   287,   544,   823,     0,     0,     0,     0,   288,     0,
       0,  2178,     0,  2178,     0,     0,   288,   288,     0,     0,
       0,     0,   492,     0,   614,   612,   611,   613,     0,     0,
       0,     0,     0,  2178,   288,     0,     0,   602,  2348,     0,
       0,  2351,     0,  1867,  1496,     0,  2433,  1022,  2434,   337,
       0,     0,  1004,  1011,  1006,  1008,  1007,  1009,  1005,  1010,
     656,   661,   662,     0,  2435,  2320,  2326,     0,     0,   379,
     381,     0,  2142,     0,  2171,  2194,  2266,  2269,     0,  2289,
       0,   696,   719,   691,     0,     0,  1034,  1027,     0,     0,
    1050,   658,  1015,  1498,     0,     0,     0,   830,   827,   826,
     825,   226,   198,     0,     0,     0,   721,  2265,   917,     0,
       0,  1382,  1383,  1266,  1253,  1539,     0,     0,  1261,  1260,
       0,     0,     0,     0,  1243,  1242,  1241,  1381,  1506,     0,
    1240,     0,     0,     0,     0,  1267,  1267,  1265,  1313,     0,
    1244,     0,     0,  1519,     0,  1525,     0,     0,     0,  1273,
       0,  1271,     0,     0,  1349,     0,     0,     0,     0,     0,
       0,     0,  1297,  1298,  1607,  1380,  1496,     0,  1587,     0,
       0,  1259,     0,  1291,     0,     0,     0,     0,  1552,  1494,
       0,     0,  1327,  1492,     0,  1329,     0,     0,     0,  1486,
    1485,  1483,  1484,  1477,  1478,  1479,  1480,  1481,  1482,  1490,
    1310,     0,  1561,     0,  1309,  1928,     0,  1160,  1096,  1542,
       0,  1585,     0,  2327,  2329,  1376,  1993,  1992,  1991,  1990,
    1961,     0,  1955,  1956,     0,  1994,  1995,   239,   240,   236,
       0,     0,   195,   194,     0,   217,   218,   187,   216,     0,
     212,   213,  1444,  1443,   196,   186,   184,   209,   211,   210,
     208,   182,   199,   201,   202,   203,   185,   183,   234,   232,
       0,     0,     0,  1544,  1543,  1575,  1548,     0,     0,   288,
    1899,  1200,     0,  1160,  1052,  1054,  1055,     0,  1549,   989,
    1557,     0,  1093,     0,     0,   993,  1089,  1082,  1088,  1117,
    1118,   738,  1087,  1141,  1142,  1136,     0,  1156,  1156,  1133,
    1124,  1132,  1125,     0,  1137,  1294,  1149,  1077,  1130,  1076,
       0,  1152,  1150,  1131,     0,  1907,  1905,  1845,  1219,  1899,
    1838,  1899,  1894,  1824,  1285,  1286,  1287,  1288,  1289,  1290,
    1825,     0,  1822,  1284,  1823,   442,     0,     0,     0,  1791,
       0,  1772,  1797,  1959,     0,  1960,     0,     0,  1936,  1939,
    1937,  1940,     0,     0,  1219,  2323,  2010,  2323,  1219,     0,
       0,     0,     0,     0,     0,     0,   619,     0,     0,     0,
    2289,   229,   960,     0,     0,     0,     0,     0,   972,   372,
       0,   285,     0,     0,     0,     0,     0,     0,     0,   785,
       0,     0,     0,     0,   786,   783,   784,  2266,   802,   801,
     799,   760,   762,   761,     0,   764,   748,     0,   749,     0,
       0,   759,   767,   765,     0,     0,   855,   260,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   278,
       0,     0,     0,     0,   283,     0,     0,     0,   282,     0,
       0,     0,     0,     0,     0,   815,     0,   153,     0,     0,
     427,   439,     0,   431,   432,   429,   433,   434,     0,     0,
       0,     0,     0,     0,   426,     0,     0,   489,   488,   494,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   498,   499,     0,   500,     0,   155,     0,
       0,     0,     0,     0,     0,   207,   924,   928,   987,   986,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   310,
       0,   569,  1608,   545,     0,  1219,     0,  1215,  1211,  1280,
    1279,  1278,     0,  1225,  1234,  1231,     0,   939,   347,   453,
     161,     0,     0,     0,   557,   560,     0,   123,   172,   337,
       0,   171,   173,   175,   176,   177,   174,   178,   486,   490,
       0,   461,     0,     0,     0,     0,     0,   512,   511,   514,
     513,     0,   508,     0,     0,     0,   152,   421,   423,  1767,
       0,   339,   403,     0,   444,     0,     0,     0,     0,     0,
    1769,     0,  1789,     0,     0,     0,     0,  1063,     0,  1170,
    1036,  1161,  1172,  1163,  1165,  1201,  1568,     0,     0,  1034,
       0,   806,     0,   967,  2178,   288,     0,   804,   166,  1571,
       0,     0,     0,     0,     0,   808,   599,   158,     0,   288,
     288,   464,     0,   288,   160,     0,     0,     0,   456,   288,
     616,  2349,  2355,  2353,  1024,     0,  2431,  2432,     0,  1062,
     660,     0,     0,  2325,     0,   688,     0,   377,   702,     0,
       0,   701,   712,   703,   704,   698,   697,   705,     0,     0,
     721,  1029,     0,  1030,  1549,     0,  1026,     0,  1047,     0,
    1045,     0,  1197,  1049,  1038,  1016,     0,  1014,  1019,  1021,
    1020,  1018,     0,     0,     0,   685,     0,     0,   288,   916,
       0,  1502,     0,  1503,     0,     0,     0,  1538,  1534,     0,
       0,     0,     0,     0,  1510,  1511,  1512,  1509,  1513,  1508,
       0,     0,  1514,  1507,     0,     0,     0,     0,     0,  1264,
    1263,     0,     0,     0,     0,     0,     0,     0,  1352,  1384,
       0,     0,  1470,     0,  1496,  1524,     0,     0,  1275,     0,
       0,     0,     0,     0,     0,     0,  1496,  1530,     0,     0,
       0,  1442,     0,  1439,     0,     0,     0,     0,  1549,     0,
       0,     0,     0,  1588,  1295,  1311,  1560,     0,  1551,     0,
       0,  1318,     0,  1531,  1345,     0,  1350,  1333,     0,  1326,
       0,  1331,  1335,  1314,  1552,  1495,     0,  1493,     0,     0,
    1312,     0,  1307,  1305,  1306,  1299,  1300,  1301,  1302,  1303,
    1304,  1308,  1474,  1472,  1473,     0,     0,     0,  1330,  2036,
    2172,  2202,     0,  1107,  1107,  1095,  1105,  1559,     0,  1203,
       0,     0,     0,     0,  1455,     0,  2331,  2330,  1550,     0,
       0,     0,  1567,     0,     0,  1291,     0,   233,  1195,  1545,
       0,   622,   623,   621,  1219,  1059,     0,     0,  1207,     0,
    1058,   991,   990,  1556,  1002,  1094,     0,   736,   737,     0,
     741,     0,     0,  1134,  1148,     0,  1050,  1050,     0,     0,
       0,  1139,  1140,  1127,  1081,  1080,  1843,  1901,  1848,  1869,
    1839,  1872,  1293,  1819,  1861,     0,  1793,  1962,  1963,     0,
    1953,  1954,  1926,  1931,  2000,     0,  2324,     0,     0,   567,
     566,     0,     0,     0,   867,   833,   620,   868,   834,   961,
       0,   963,     0,     0,     0,     0,     0,   288,   970,   869,
     284,   971,   860,     0,     0,     0,   469,   470,     0,   781,
     782,   870,   835,     0,   861,   763,  1234,   747,     0,     0,
     758,     0,   757,  1234,  1234,   836,   162,   252,     0,   858,
     264,   277,   272,   273,   271,   288,   288,     0,     0,     0,
       0,   274,   269,   270,   266,   279,   280,   844,     0,   294,
     297,   281,   262,   265,   263,   251,     0,  1574,     0,     0,
     810,     0,     0,   847,     0,     0,   136,   138,   140,     0,
       0,   134,   142,   137,   139,   141,   135,   143,   133,     0,
       0,   132,     0,     0,     0,     0,   126,   875,   840,   430,
     435,   842,   438,   863,   436,  2101,  2156,  2272,     0,   476,
     478,     0,   483,   881,   841,     0,   862,   877,   849,     0,
       0,     0,     0,     0,     0,     0,   976,     0,     0,     0,
     876,   854,   865,     0,   848,   843,   864,     0,     0,   205,
     204,   206,     0,     0,     0,     0,     0,     0,     0,     0,
     655,   631,   654,     0,     0,     0,     0,     0,     0,     0,
     625,   323,   304,   305,     0,   303,   568,     0,     0,     0,
    1216,  1212,     0,     0,     0,     0,     0,     0,  1232,     0,
       0,   959,   959,   959,   959,   959,   959,   959,   940,   968,
     452,   472,     0,   588,   556,     0,     0,   378,   167,     0,
       0,     0,   460,   555,   553,   552,   554,     0,     0,     0,
       0,  1208,     0,     0,     0,     0,     0,     0,     0,   338,
     340,   342,   343,   344,     0,   415,   417,     0,     0,   407,
       0,     0,     0,     0,   727,   752,     0,   770,   753,     0,
       0,     0,   790,   795,   791,   773,     0,  1787,  1781,  1068,
    1069,     0,  1083,     0,  1172,     0,  1171,  1183,     0,     0,
    1189,  1187,     0,  1189,     0,  1189,     0,  1164,     0,  1166,
    1183,  1569,     0,     0,  1204,  1035,   288,     0,     0,   466,
     288,     0,   288,     0,   288,   288,     0,   901,   493,     0,
     541,     0,     0,   288,   601,  1497,     0,     0,  1927,  2321,
     689,   380,     0,   700,     0,     0,   711,   706,   708,     0,
     715,     0,     0,  1032,  1033,  1048,  1041,  1043,  1042,     0,
       0,  1039,  1499,   600,     0,     0,   288,     0,   716,  1112,
    1500,  1501,     0,     0,     0,     0,  1535,     0,     0,  1418,
    1394,  1396,  1233,  1408,     0,  1246,  1419,  1420,  1398,  1400,
       0,  1487,     0,     0,  1409,  1354,  1355,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1367,  1366,  1410,  1469,     0,     0,  1522,  1523,  1411,  1276,
    1277,  1277,     0,     0,  1529,     0,     0,     0,  1416,  1421,
       0,     0,  1426,     0,  1447,     0,     0,     0,  1377,  1497,
    1268,  1269,     0,     0,     0,     0,     0,     0,     0,     0,
    1351,  1334,  1328,     0,  1332,  1336,     0,     0,     0,     0,
    1320,  1346,  1316,     0,     0,  1322,     0,  1347,  1107,  1107,
    1107,  1107,  1104,     0,     0,  1159,     0,  1144,     0,     0,
       0,  1455,     0,  1385,  1455,     0,  1975,  1977,  1978,  1979,
    1980,  1981,  1983,  1984,  1986,  1987,  1988,  1976,  1982,  1985,
    1989,  1966,  1967,     0,  1957,  1958,   189,     0,   214,   200,
       0,  2000,     0,     0,  1053,  1034,  1056,  1119,     0,  1488,
     741,   739,   740,  1121,     0,     0,  1155,  1154,  1153,  1122,
    1126,  1123,     0,     0,  1903,  1829,     0,     0,  1999,  2002,
    2013,  2011,  1841,   866,   832,   859,   959,     0,   371,     0,
       0,     0,   973,   451,     0,   450,   448,   468,   775,     0,
    1234,   750,   755,   756,     0,   347,     0,     0,   253,     0,
     261,   258,   275,   267,   276,   268,   291,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   872,
     148,     0,     0,     0,     0,   129,   128,   149,   147,     0,
     146,     0,   480,   481,   479,   475,     0,   482,   484,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   871,   837,   626,     0,     0,   627,   635,     0,     0,
     628,     0,     0,     0,     0,     0,     0,   637,   326,   311,
     315,   975,   975,     0,   316,   975,   312,   975,   309,   570,
       0,  2229,  1477,  1478,   564,   571,   561,   563,   562,   565,
     536,     0,     0,     0,  1217,     0,  2421,  2429,  2428,     0,
    1291,     0,   959,   958,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   358,     0,     0,   352,     0,     0,
     795,   346,   349,   350,     0,   465,     0,   558,   559,     0,
     337,     0,     0,   516,   509,     0,   572,   550,     0,  1210,
     472,  1025,   420,   339,   364,   399,     0,   413,     0,   401,
     400,   402,     0,   409,   937,   453,     0,   727,     0,     0,
     751,     0,     0,     0,   788,   792,   789,     0,     0,   766,
       0,   774,   744,     0,  1804,  1061,  1813,  1174,  1181,     0,
    1162,     0,  1188,  1184,     0,  1185,     0,     0,  1186,     0,
       0,  1181,     0,     0,     0,   807,     0,   288,   805,     0,
     595,     0,   597,   809,   288,   288,   501,     0,   457,   414,
    1067,   699,   713,   709,     0,     0,   682,   718,  1028,  1031,
    1046,  1044,   721,     0,   683,   720,  1504,  1252,     0,  1537,
    1533,     0,  1505,     0,  1517,  1516,  1353,  1518,     0,  1372,
       0,     0,  1364,  1362,  1363,  1356,  1357,  1358,  1359,  1360,
    1361,  1365,  1527,  1526,  1520,  1521,  1272,  1270,     0,  1413,
    1414,  1415,  1528,  1422,     0,  1441,  1440,     0,     0,     0,
    1428,     0,     0,  1437,     0,  1471,  1258,  1291,  1296,     0,
       0,  1319,  1532,  1337,     0,     0,     0,  1315,     0,     0,
       0,     0,  1324,  1487,     0,     0,     0,     0,     0,     0,
    1099,  1098,  1202,     0,  1146,  1455,  1455,  1455,  1391,  1458,
    1453,  1454,  1386,  1586,     0,     0,     0,     0,  1546,  1998,
       0,  1060,  1051,     0,  1120,  1135,  1128,  1136,  1847,     0,
    1902,  1964,  1965,     0,   373,     0,     0,   795,   880,   449,
     776,     0,   768,   345,     0,   857,     0,     0,     0,     0,
     295,   296,   299,     0,     0,     0,     0,     0,   589,   575,
       0,     0,   590,   591,     0,     0,   812,   813,   811,   144,
     130,   151,   150,   131,   145,   477,   845,     0,     0,     0,
       0,     0,   879,   853,   878,   851,   850,   852,   846,   503,
       0,   629,     0,     0,   630,   641,   639,   638,   640,   632,
     327,   125,     0,     0,     0,     0,     0,     0,     0,   538,
       0,     0,   543,   532,   534,     0,     0,     0,  1213,     0,
       0,     0,     0,     0,     0,  1218,  1226,   531,     0,   950,
     949,   948,   952,   951,   954,   953,   945,   944,   957,   956,
     943,   942,   947,   946,     0,     0,   356,   360,   361,   359,
     351,   795,   378,   411,     0,     0,     0,     0,     0,   518,
       0,     0,   551,     0,  1209,   497,  1023,     0,  1768,     0,
     362,     0,   403,   341,   416,   417,     0,     0,   412,     0,
     932,   455,     0,     0,   726,     0,   754,   771,   772,     0,
       0,   795,   794,   896,   897,   894,   895,     0,     0,  1777,
    1173,     0,     0,  1175,     0,     0,  1177,  1179,     0,     0,
       0,     0,     0,  1572,  1455,  1205,  1206,   288,   467,   288,
     288,   902,   542,     0,     0,     0,     0,   707,   288,     0,
    1536,  1407,  1417,  1515,     0,     0,  1373,     0,     0,  1412,
    1648,     0,     0,  1445,  1446,  1427,     0,  2215,  1432,     0,
       0,     0,  1589,  1343,  1341,  1338,     0,  1339,     0,     0,
    1321,  1317,     0,  1323,  1348,  1103,  1102,  1101,  1100,     0,
       0,  1449,  1389,  1390,  1387,  1460,  1457,     0,  1968,     0,
    1971,  1969,  1970,  1974,  1291,  1057,     0,     0,  1904,   965,
       0,   795,   411,   769,   254,   255,   256,   257,   290,     0,
     873,   838,     0,     0,   581,     0,     0,     0,     0,   874,
     839,     0,     0,     0,   981,     0,     0,   633,   634,   310,
       0,   313,   318,     0,   319,   314,   317,   540,   539,   537,
     533,   535,  1214,     0,   821,   821,  2422,  2423,  2424,  2425,
    2426,  2427,     0,   536,   955,     0,     0,   348,   411,   385,
       0,   353,     0,   473,     0,   937,   339,   472,   517,     0,
       0,   510,   573,   418,     0,   403,     0,     0,   363,     0,
     407,     0,   404,     0,   408,     0,     0,     0,     0,   445,
       0,     0,     0,     0,   728,   735,   735,   793,     0,   797,
       0,   765,   742,     0,  1807,  1803,     0,  1182,  1191,     0,
    1178,  1176,  1167,     0,  1169,   822,   596,   598,   502,     0,
     710,   717,   288,  1368,     0,     0,     0,     0,  1423,     0,
    1424,  1429,  1433,     0,  1430,  1431,  1340,  1344,  1342,  1325,
    1143,  1145,     0,  1084,     0,  1116,  1455,  1973,  1972,   215,
    1489,     0,     0,   411,   374,     0,   259,   298,     0,     0,
     587,   576,     0,     0,   592,     0,     0,     0,     0,     0,
     636,   302,   325,   320,   821,     0,   818,   817,   530,     0,
     355,   354,     0,   390,     0,   471,     0,   585,   933,   485,
     519,   520,   515,     0,   419,   407,   368,   366,   370,   367,
     365,   369,     0,   409,   405,   406,     0,   934,     0,   454,
     983,     0,     0,   293,     0,     0,   733,   738,   738,   796,
       0,     0,  1203,     0,  1805,  1180,     0,  1168,   684,  1369,
       0,  1370,     0,     0,  1435,  1434,  1448,  1450,     0,     0,
    1463,  1115,  1388,  1129,   378,   375,   289,     0,   579,   586,
     577,   587,     0,     0,   977,     0,   978,   979,   982,   816,
     820,   819,     0,   382,   383,   384,     0,   357,   386,   387,
       0,   474,     0,     0,     0,   409,   398,   329,   935,   936,
     293,   735,     0,   409,   729,   734,   741,   741,   795,   798,
       0,  1808,  1810,  1809,     0,  1190,  1371,  1438,  1425,  1436,
       0,     0,  1459,     0,     0,     0,   385,     0,   578,   594,
     593,     0,     0,     0,     0,     0,   388,     0,   389,   410,
     584,     0,   523,   330,   409,   738,   292,  1203,   731,   730,
     743,   900,  1806,  1451,  1452,     0,     0,     0,  1461,  1464,
    1462,  1456,   390,     0,   980,     0,   395,     0,   394,     0,
     392,   391,   574,   528,     0,   521,   524,   529,   527,   525,
     526,  1203,   741,   722,   899,   898,     0,     0,  1468,  1467,
    1466,   536,   580,     0,   393,   397,   396,   504,     0,   723,
     732,   882,   893,  1770,   883,   891,   888,   890,   889,   887,
       0,   376,     0,   522,     0,   892,   886,  1083,  1070,  1465,
       0,   884,   893,   523,   885,     0,   505
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,   245,   246,  1572,  2237,  2806,   247,   248,   249,
     250,   251,   252,   253,   254,   255,  1602,   256,   257,  1199,
    1748,  2341,   258,  2161,   995,  2041,  2042,  2286,  2043,  2027,
    1438,  2044,  1573,  1594,   260,   261,  1432,  2019,   262,   263,
     264,  1615,  1616,  1579,  1792,  3986,  2228,  4113,  2768,  2769,
     265,   266,  2874,  1693,  2875,  3318,   825,  2308,  3641,  3642,
     267,  1745,  2928,  2929,  2930,  2931,  2899,  3361,  3362,  3363,
    2932,  3710,  3908,  2933,  2169,  1294,  1858,  1859,  4013,  4097,
    4098,  4099,  4180,  3712,  2939,  3393,  3718,  3891,  1765,  2372,
    2934,  2935,  3708,   268,   269,  2367,  1640,  1641,  2242,  3324,
     270,   853,  3225,  2900,  2901,  3919,   271,   813,   272,  1752,
     273,   274,   275,   276,  3365,  3892,  1645,  2818,  2819,  2820,
    2821,  3277,   277,  1750,  1646,  2350,   278,   279,   280,  2275,
     281,   282,   283,  1759,  2361,  2362,  3700,  3899,  4022,  4184,
    4185,  3883,  3652,  3653,  3654,   284,   285,   286,   287,  1744,
    2333,  2334,  3325,  1563,  1697,  2310,  2311,  3375,   288,  3598,
    3599,   854,  4103,  4080,   289,   290,  3602,  3603,   291,   292,
     293,   294,   295,   902,  1261,  1262,  2744,   296,  2059,   297,
    1178,  2861,   298,   924,   925,   299,   300,   934,  2485,   936,
    1870,  3016,  3017,  3456,  2451,  1114,   301,   302,  2460,  2488,
     303,   855,  3399,  3923,  3924,  4047,  2660,  3193,   304,   856,
    1598,  2197,  2379,  2946,  2947,  2199,  2200,  3408,  2201,  2948,
    2953,  2954,  2955,  3404,  3412,  3929,  3930,   305,  1596,  2190,
     306,   307,   308,  1620,  1130,   309,  4006,   310,  1231,   311,
     954,  1888,   312,  2208,  3239,   313,   314,  4213,  4224,  4225,
    4226,  3737,  4196,   315,  4215,   317,   318,   319,   816,  1150,
    1151,  1152,   320,  3720,   321,   322,  2327,  2898,  3344,   323,
     324,  2162,  2711,   325,   326,   327,  1738,   328,   329,   330,
     331,  1675,   332,   333,   334,   820,  1018,  1471,  1479,   335,
    1842,   910,   336,  1308,  2477,   337,  1275,  4216,  1876,  2462,
    2463,  2466,  4217,  1787,   340,  1880,  2471,  2474,  4218,  2063,
    2064,  2065,  2066,  2067,  2646,   342,  1225,  2386,  4219,  1392,
     345,   346,   347,   348,  1022,  1023,  1997,  2615,   943,  1485,
     980,  1033,  1034,  2079,  2080,  2098,  2099,  2090,  2662,  2092,
    2093,  2673,  2085,  3544,  3811,  2096,  2097,  1495,  1496,  2666,
     349,  2619,  2390,  2391,  2392,  2966,  2976,  3423,  3746,  2393,
    1303,  1016,  2394,  3147,  2399,  2920,  2921,  2202,  2318,  1719,
    1393,  1720,  2325,  1394,  1920,  1722,  1395,  1396,  1397,  1725,
    1398,  1399,  1400,  1401,  1904,  1961,  1402,  1403,  1939,  1062,
    1063,  1834,  2527,  1405,  1406,  3513,  3790,  3781,  2552,  2553,
    2034,  3509,  3973,  4066,  4067,  3552,  3550,  3815,  3975,  4135,
    4168,  4169,  1407,  2605,  1989,  1132,  1408,  3327,  1991,  2547,
    2150,  1902,  2494,  2510,  2511,  2524,  3063,  2531,  2536,  3086,
    3087,  2548,  2574,  1409,  2497,  2498,  3047,  1906,  1410,  1462,
    1463,  2005,  2570,  1474,  1475,  1020,  1411,  1412,  1413,  1871,
    1007,  3742,  1239,   670,  2776,  2054,  1154,   940,  1414,  1415,
    1416,   647,  1519,  1008,  1102,   649,  1103,   770,  1009,     2,
      75,   352,  2925,   353,  2956,   354,   355,   858,   859,   860,
    1217,  1218,  1777,  1779,  1524,  2131,   650,   651,   868,  3739,
    3935,  4054,   908,   356,   357,   358,   359,  1520,  2127,  1064,
      76,    84,    77,  1065,   395,   396,  2109,   360,   788,  2110,
    1501,  1044,  3204,   362,   363,   364,   365,   366,   905,   367,
    1046,   368,  1047,   369,   370,   371,   372,  1054,   373,  1503,
    1504,  3570,  1505,   374,   375,   673,   674,  1273,   376,   377,
    1082,  1083,  1084,  1289,  1853,  1543,  1544,  1545,   378,   666,
     379,   380,   381,  1534,  1535,   382,  2012,  2013,  2134,  2014,
     383,  2687,  2688,   384,  3171,  3172,  3821,  3173,   385,  2008,
     386,   387,  1011,  3209,   388,   784,   389,  1096,   652,   653,
     654,  1105,   773,   966,  2822,   775,   776,   655,   656,   657,
     658,   659,  1854,    78,  2695,  1855,  1417,  1418,  2003,  1419,
    1420,  1421,  1422,  1423,  1551,   663,  1072,  1265,  1266,  2696,
    1268,    82,  1269,   393,  3339,  1837,  1290
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3752
static const int yypact[] =
{
   -3752,   773, 11231, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, 18736, -3752,
   -3752, -3752, -3752, -3752, 82619,   342, -3752, -3752, -3752, 44447,
   -3752, -3752, -3752,   396, 55305, -3752, 62841,   354, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, 69435, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, 47757,  1324, -3752,
     384, -3752, -3752, -3752, -3752, -3752, -3752, -3752,   -70,  4379,
   -3752, -3752, 59544, -3752,    71, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, 63312,   385, -3752,    61,   981,    76, 11710, -3752,
   -3752, 45393, 57660, -3752, -3752, 69906,   640,   381,  6753,   -70,
   18262, 63783, -3752,  1532, -3752, 42045, -3752, -3752, -3752, 55776,
   -3752, -3752, -3752, -3752,   638, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, 69435,   442,   587, 42529, -3752, -3752, -3752,
   -3752, 69435, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, 64254, -3752,   806,    52, 70377, 70848, 54834, -3752,
    1032, -3752, 69435,   995, 47285, -3752, 71319, -3752, -3752,   761,
   -3752, 58131, -3752, -3752, -3752, -3752,   587, -3752, 47757, 40121,
   58131,  1230,   823, -3752, -3752, 71790, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752,  1346,   833, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752,   385, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752,   240, -3752,    56,  1056,  1318,  1086,
   -3752, -3752, -3752, -3752, 17101, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, 84020,  1088, -3752, -3752, -3752,   980, -3752,  1031,
   -3752, -3752, -3752,  1910, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752,   309, -3752, -3752, -3752,  1596, 83086, -3752, -3752, 64725,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, 44920, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752,   136, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, 69435, 69435, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, 64725,
    1211, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
     205,  1411, -3752, -3752, 47757,  1860,  1860,  1656, 84020, -3752,
   -3752, -3752, 48701, 69435, 69435, 69435,  1544, 48701, 69435, 60015,
   36736, -3752, 69435, 69435, 60015, 69435, 58131, 69435,  1368, 69435,
   69435, 72261, 60015,  1454, -3752,  1690,    51, -3752, -3752, -3752,
   60015,  9374,   442, -3752, -3752, 60015,  1341, 48701, 69435,  1270,
    1358, 69435, -3752, 69435,  1624,  1186, 69435,  1540, 37224,  1440,
   69435, 69435, 69435, 69435, -3752, -3752,  1429, 69435, -3752, 69435,
   -3752, 72732,  1330,  1466,  1691,  1589,    46, -3752, -3752,  1400,
    1347, -3752, -3752,  1802, 64725, -3752, 60486, -3752, -3752, -3752,
     137, -3752, 58131, -3752, -3752, -3752, -3752, 49173, 69435,  1693,
   -3752, 73203, -3752,  1731, 49645, 73674, -3752, 37712,  1816, 74145,
   74616, -3752, -3752, 75087, -3752, 75558,  1565, 76029, -3752, 76500,
   -3752,  1764, 76971, -3752, 12871, -3752,  1555,  1357,  1568, -3752,
     385,   194, -3752,   142,   -25,   196, -3752, -3752,   169,   457,
     498,   194,  1611,  1611, 60957, 69435,  1820, -3752, -3752, -3752,
     530,  1585,  1585,  1585,  1780,   717, -3752,  1585, 60015, -3752,
   -3752, -3752, -3752, 58131,   775, -3752, -3752,   442,    26,  1988,
   69435, -3752, 69435, -3752, 60015, 69435, -3752, -3752, -3752,  1983,
    1639,  1859, -3752,  1627, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752,  1812,  1828,  1839,    34,   442,  1740, -3752, -3752,  1874,
   24153,   -92, 64725,   442, 43013, 58602, 77442,   243, 46339,   442,
   65196,  1702,    51,  1891, -3752,   453, -3752,  2122,  1747,  1990,
     174,    51, -3752, -3752, 34353, -3752,  1447,  1709, -3752, -3752,
   58131, 84487, -3752, -3752, -3752, 77913,  1842, -3752,  2021, 24646,
   -3752, 69435,  1750, -3752,  1758,  1760,  1775, -3752, 60015,  1110,
    1110,  2164,  1110,  1373,  1613, -3752,    56,  1150,   823,   -70,
    1793, -3752, -3752, -3752,  1794, -3752,  1798,  1804, -3752,   212,
    2067, -3752, -3752, -3752, -3752,  1961,  1964,  1970,  1989,  1834,
    2011,   473, -3752, -3752, -3752, -3752,  2149, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752,  2276,  2303, 45393, 45393,  2003,   539,
     121,   177, -3752, -3752, -3752,  2209, -3752, -3752,  2227, 69435,
    2044, 69435, -3752, -3752, -3752, 78384, -3752, -3752,  1860,  1794,
    1447,  1975, -3752, -3752,   216, -3752,   406,   418,   422,   470,
    1985,  1033,   220,  2028,  3040,  2004,   590,  2229, 69435, 69435,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
    2015, -3752, -3752,  2014,  1546,  1264,  3428,  1036,  2844,  1479,
     649,  2201,  1246,  2311,  1588,  3078, 69435,  2038,  2264,   491,
   -3752,   526, -3752,  2104,  2232,  2254, 48701,  2080, -3752, 69435,
   -3752, -3752, -3752, 48701, -3752,  2278, 38200, -3752, 69435, -3752,
   -3752, -3752, -3752,  2212, 69435, -3752, -3752,  2336, 69435, -3752,
    1585,   319,  2103,  2488, 52005, 69435,  2172,  2531,  2173, -3752,
   -3752,  2172, -3752, -3752, 69435, 69435,  2134,  1402,  2172,  2532,
    2533,  2207,  2309,   679,  1443,    86,  2430,  2172, 60015, 60015,
   60015,  2381, 69435, 78855, 48701, 69435, 65667, -3752,  2140,  1400,
   -3752, -3752, -3752, -3752, -3752,  1494,  2205,  2452,  1975,   102,
    2453,  2158,  2454, -3752,  2198,  2458,  2004,  2460,  2162, -3752,
   79326, 79797,  2463,  2015, 69435,  2465,  2162,  2466,  2351,  2469,
     102,  2470, -3752,   742,  2475,  2359,  2477,  1520,  2162, 46812,
    2478,    72, -3752, 16466, 12871, -3752, 19754,  1501, -3752, -3752,
   -3752, -3752, -3752, -3752, 27111,   549,  1642, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, 69435,  1820,  1820,  1427, -3752,
   -3752,  2182, 69435, 69435, -3752, -3752, -3752, 56247, 69435, 59073,
   -3752,  1308, -3752,    41, 69435, -3752,  1357, 52005,  2583, 69435,
    2471,  2471,  2471, -3752, -3752, -3752,  2416, 69435,  2476,  2479,
   56247, 69435, -3752, 80268,  2188,  1375,   954,   352,  1066, 27111,
    2191,   261,   261,  2193, -3752, -3752, -3752,   478,  2195,  2196,
   -3752,   492,   492,  2355,  2199,  2200, -3752,   887,  2203, -3752,
    1118,   917,  2214,  2216,  2217,  1895,   261, 27111, -3752,  2221,
     492,  2228,  2238,  2239,  1168,  2241, -3752,  1207,  2242,   297,
     356,  2243,  2244, -3752,  2199, -3752,   401,  2245,  2246,  2247,
    2250,  2251,  2252,  2255, -3752, -3752, -3752, -3752, 27111, 27111,
   -3752, 23167, -3752,   442, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752,    63, -3752,   926,  7950, -3752, -3752,  2368, 27111, -3752,
   -3752,   115, -3752,  1447,   937, -3752, -3752, -3752, -3752,   296,
   -3752, -3752, -3752, -3752,  1696,  1696,   162, -3752, 59544, 59544,
   -3752, -3752,   181,  2202, -3752,   245, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, 45866,  2600, -3752,  1841,   526,  1315,
    2553, 40593, 41077,  1820,  1820,  2462, -3752, -3752, 60015, -3752,
   27111, 39177, -3752,  1447, -3752,    53,  2472, 69435, -3752, 34825,
   -3752,   385, -3752,  9929, -3752,  1408,  1750, 69435, 69435,  2630,
   -3752, -3752,  1758, -3752, -3752,  1318,  1318, 27111,  1318,   942,
     -53, 25139, 27111,  2541,  1197,  2546, -3752,  1373,  1613, -3752,
   -3752,  1794,  2267,  1498, -3752, 53892, 83553, 83553,  2510, -3752,
   -3752,  1094,    21,  2380,  2480,  1611,  1143,  1221, -3752, -3752,
    2262, -3752,  2594, 59544,  2326, 45393, -3752, -3752,  2729, -3752,
    2729, -3752, -3752,   110,  2268, -3752,  2286, -3752, -3752,  1221,
    1221, -3752,  2757, -3752,  2272, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, 84020,  2277, 69435, -3752,  2281,  2282, -3752,
   84487,  1447, 39649,  1523,  2354,  2356, 47757,  2283,  2361,  2362,
   80739, -3752, -3752, -3752, -3752,   765,  1166,  2364,    87, -3752,
   69435,  2468,   473,  2406, -3752,  2369,  2370,  2483,   473,   824,
   81210, -3752, -3752, -3752, -3752, -3752,  1597, 21240, -3752, -3752,
   -3752,  2372,  2358,  1267,  2659,  2481,  1003,  1374,   556, 60015,
    2555,  2385,  2389,  2302,  1095,  2300, -3752,  2371,  2373, 51061,
    2484, 38688,  2394, 77442, -3752, -3752,  2396,  2397,   473, -3752,
    2703,   473,   473,  1336,  2704,  2401,   601,  1482,  2172,  2300,
    2233, -3752,  2325,  2407,   256, -3752,  2503,    67,  1733,  2300,
    2409,  2413, 69435, 69435, 69435, 69435, 60015,  2415,  2417,  2490,
   61428,  2419, -3752, -3752,  2420,  1751,  2300,  1581, -3752,  1524,
   -3752, -3752,    51, -3752, 69435, -3752, 60015,  1975, 52005,  2524,
    2004,   473, 69435, 69435,  2015,    54,  1189,  2525, 69435,  2590,
    2395, -3752, -3752,  2172, -3752, 39649,  2134, -3752,  2348, -3752,
    2408, -3752,  2408,  2408,  2363,  2363,  2374, -3752, -3752,  1895,
    2408,  2363, -3752, 52949, -3752,  1394,  1398, -3752,  2761,  2771,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,  1300,
    1470, -3752, -3752, -3752, -3752,  2787, -3752, -3752, 52005, 69435,
   -3752,  2705,  2439, 47757, -3752,  2429, -3752, 69435,   199,   442,
    2434, 69435,  2608, 69435, 69435, 69435, 69435, -3752, -3752,   639,
      19, -3752, 61428, -3752,  2233,  2788,   368,  1585, 46339,  2678,
   69435,  2572, -3752,  2399,  2794, -3752,  2400, -3752,  1611, -3752,
    2140, -3752,  1681, -3752,  2516, -3752, 30548,  2447, 48701,   102,
   -3752, -3752, -3752, -3752, 52005, 69435, 81681, 48701,   102, 69435,
   69435,  2702,  2467,  2707,  2473, 38688,   102,   103, 69435, 69435,
   60015, 69435, -3752, 69435, -3752, -3752, -3752, -3752, 69435, 60015,
   69435, 61428,  2710,  2714,   102, 69435, 69435, -3752, -3752, 19673,
    1517, -3752, 12871, -3752,  9929,  1478,  1820, -3752,  1211,   668,
   69435, 64725, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
    1820, -3752, -3752,  2902,  2418, -3752,   296, 69435,  1512, -3752,
   -3752,  1590, 69435,    81, 48701, 69435, 69435, 60015, 60015, 69435,
    2501,  2202,   961, -3752,  2482, 33881,  2562, -3752,   118, 58131,
    2615, -3752, -3752, -3752,  1605,  1234,   897, -3752, -3752, -3752,
   -3752, -3752, -3752, 59073, 55776,  2715,    62, 69435, -3752, 27111,
   23660, -3752, -3752, -3752,  2441,  9929,  2489, 27111, -3752, -3752,
   27111,  1611,  1611, 27111, -3752, -3752, -3752, -3752,  1552,  1611,
   -3752, 27111, 27111,  1611,  1611,  2408,  2408, -3752,  3791, 27111,
   -3752, 38688, 27111, 28590, 20746, 27111,  2523,  2487,  1611, -3752,
    1611, -3752, 27111, 22674, -3752, 27111,  2655, 27111,  1315,  2657,
   27111,  1315,  2879,  2879,   823,  3299,  4763,  2451, -3752,  2565,
    1611, -3752,  1611,  1511, 52005, 27111, 47757,  2538,   159, 27111,
    2459,  1822, -3752, 27111,   653, -3752,  2464, 27111,  2544,   139,
   27111, 27111, 27111, 27111, 27111, 27111, 27111, 27111, 27111, -3752,
   29083,   182, -3752,   -74,   277, 56718, 24153,  2745, -3752,   234,
   20252, -3752, 64725, -3752, -3752,  1447, -3752, -3752, -3752, -3752,
   -3752,   110,  2491, -3752,  2485, -3752, -3752, -3752, -3752, -3752,
   60015,  2600, -3752, -3752,  2543, -3752, -3752, -3752, -3752,   946,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752,  2495, -3752, -3752, -3752, -3752, -3752,  2495, -3752, -3752,
    1820,  2494,  3444, -3752, -3752, -3752, -3752,  2737,  2739,   102,
   84020, -3752, 69435,    65, -3752, -3752, -3752,  2504, -3752, 57189,
   -3752, 24646, -3752,  1625,  2199, -3752,  2718, -3752, -3752,  2496,
   -3752,  8309,  2718, -3752, -3752,   156,  2661,  2663,  2663, -3752,
     -31,  9929,  2720,  1791,  9929,  1814, -3752, -3752, -3752, -3752,
     709, -3752,  2541,  1197,  1742, -3752,  1794, -3752, -3752, 17605,
   -3752, 19208, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752,  2499, -3752, -3752, -3752, -3752,   473,  2502,  2959, -3752,
   45393, -3752, -3752, -3752,  1802, -3752,  1802,  2989, -3752, -3752,
   -3752, -3752, 64725,   816, -3752, 12871, -3752, 12871, -3752,  2505,
    1655,  2585,  2586,  2626, 69435, 69435, -3752, 47757, 69435, 69435,
   69435, -3752,  2867,  2511, 69435,  2751,  2752,  2514, -3752, -3752,
   69435, -3752,  2706, 69435, 27111,  2708, 69435,   889,  2709, -3752,
     907, 69435, 69435,  2695, -3752, -3752, -3752, 46339, -3752, -3752,
   -3752,  2690, -3752, -3752, 52949, -3752, -3752,  1680, -3752, 52477,
   50117, -3752, -3752,   707, 69435, 69435, -3752, -3752, 69435, 69435,
   69435, 69435, 61899, 69435, 69435,  1037,  1061, 69435, 62370, -3752,
   60015, 69435, 69435, 47757, -3752, 69435,  2711,   594, -3752,  2493,
   69435, 69435,  2517,  1684,  2599, -3752, 69435,  5000, 69435, 69435,
   -3752, -3752,   473, -3752, -3752, -3752, -3752, -3752, 69435, 69435,
     473, 69435,   473,  1290, -3752, 48229, 69435, -3752, -3752, -3752,
   69435, 69435, 69435, 69435, 69435,  1068,   878,  2662,  2666,  2668,
   69435, 69435, 69435, -3752, -3752,  2636, -3752, 69435,  5000, 69435,
   69435,  2609,  2610,   129,  2680, -3752, -3752, -3752, -3752, -3752,
    2778,  2937, 69435,  2782,  2784,  2601,  2602,  2789,   993, 69435,
   69435, 69435, 69435, 69435, 69435,  2790,   993,  2733,    47, -3752,
    1714, -3752,  2563, -3752, 27111,  2956, 52005,  2559,  2560,  2638,
   -3752,  2639,  1611, -3752,  1719, -3752,   639,  1665, -3752,     5,
    5000,  2851, 69435,  1724, -3752,  2578, 60015,  5000, -3752,  1268,
   55776, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
    2852, -3752,   442,  2134,  2134,  2134,  2134, -3752, -3752, -3752,
   -3752,  2746,  2743,  2570, 69435,  2684,  5000, -3752,  2233,  2871,
   60015, 54363,  1832,  2973,  2850,   442,  2758, 60015, 21720,  2679,
   -3752, 65667, -3752,  2587,  2853,  2858,  2866, -3752, 30069, 66138,
    2577,  1543, -3752, 66138, 66609, -3752,  1447,  2589, 25632,  2562,
    1975, -3752,  2990, -3752,  2887,   102,  2004, -3752,  2162, -3752,
   69435, 69435, 69435, 69435,  2015, -3752, -3752,  2162,  2772,   102,
     102, -3752,  2773,   102,  2162,  2712,  2883, 46339, -3752,    72,
   -3752, -3752, -3752, -3752, -3752, 27111, -3752, -3752,  2685, -3752,
   -3752, 64725,  1802, -3752,  1727, -3752, 69435, -3752,  2162,  2635,
   69435,  2597, -3752,  2162,  2162,  2202,  2202,  2162, 67080,  3012,
    2880, -3752,  1734, -3752, -3752, 24153, -3752,   537, -3752,   578,
     968,  2817, -3752, -3752, -3752, -3752, 52005, -3752, -3752, -3752,
   -3752, -3752, 69435,    89,  2785,  2603, 67080,  2991,   102, -3752,
    1738, -3752,  1529, -3752,  1560, 27111, 27111,   134, -3752,  8581,
    1763,  2606,  2611,  1770, -3752, -3752, -3752, -3752, -3752, -3752,
    2613,  2891, -3752, -3752,  2614,  1783,  1787,  2616,  2619, -3752,
   -3752,  2231,  2620,  8630,  2621, 28590, 28590,   562, -3752, -3752,
   28590,  2623, -3752,  1797,  8386,  2607,  2627,  2641, -3752,  2628,
    2629,  9173, 26125, 27111, 26125, 26125,  9065,  2607,  2631,  1800,
   47757,  9477,  1808, -3752, 27111, 47757,  4251, 27111, -3752, 27111,
   69435,  2633,  2637, -3752, -3752,  3791, -3752,  2652, -3752, 28590,
   28590,  2157, 23167, -3752, -3752,  2893, -3752, -3752,  1682, -3752,
    2640, -3752, -3752,  2732,   251, 27111,  2459, 27111,  2717, 38688,
   10387, 27111,  6771,  5125,  5125,   378,   378,   104,   104,   104,
     279,   277, -3752, -3752, -3752,  2642,  2241, 27111, -3752,  3119,
    1913,  1929, 60015, 10686, 10694, -3752, -3752, -3752, 30548,  2689,
   27111, 27111, 27111,  2645,  2819,  1851, -3752, -3752, -3752,  1306,
    2989,   110, -3752,    51,  1611,  1511, 41561, -3752, -3752, -3752,
   27111, -3752, -3752, -3752, -3752, -3752,  1856, 34825,  2447, 24646,
    1447, -3752, -3752, -3752, -3752, -3752, 27111, -3752, -3752,  1943,
    1837, 27111,  1791, -3752, -3752, 60015,  2615,  2615, 27111, 27111,
   25139, -3752, -3752,  2941, -3752, -3752, -3752, -3752,  1163, -3752,
   -3752, -3752, -3752, -3752, -3752,  2647, -3752,  2651, -3752,  2670,
   -3752, -3752, -3752, -3752,   131,  2664,  2660,  2667,  1044, -3752,
   -3752, 69435, 69435, 69435, -3752, -3752, -3752, -3752, -3752, -3752,
    2889, -3752, 27111,   511,  2671,  2673, 69435,   102, -3752, -3752,
    9929, -3752, -3752,  2719,  2738, 69435,  2503, -3752,  2920, -3752,
   -3752, -3752, -3752,  2864, -3752, -3752,  1470, -3752, 50117, 52477,
   -3752, 52477, -3752,  1470,  1458, -3752,  2162, -3752, 52005,   263,
   -3752, -3752, -3752, -3752, -3752,   102,   102, 69435, 69435, 69435,
   69435, -3752, -3752, -3752, -3752, -3752, -3752, -3752,  1857, -3752,
    1104, -3752, -3752, -3752, -3752, -3752,  1594, -3752,   670, 52005,
   -3752, 51533, 69435, -3752, 69435,  2903, -3752, -3752, -3752,  2838,
     675, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,  1054,
   69435, -3752,  1611,  2841, 69435,  2740, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, 47757, 47757, 47757,  1870, -3752,
   -3752,   442, -3752, -3752, -3752,  2759, -3752, -3752, -3752,  2898,
    2901,  2904,  2763,  2765,  2775,  2776, -3752,  2777,  2779,  2780,
   -3752, -3752, -3752, 69435, -3752, -3752, -3752, 69435, 69435, -3752,
   -3752, -3752,   993, 52005,  2936,   993,   993, 69435, 69435,   993,
   -3752, -3752, -3752,  2947,  2950,  2955,  2957,  2958,  2961,   993,
   -3752, -3752, -3752, -3752,   319,  1984, -3752,   137, 36248,  4833,
    2721,  2560,  2728,  1611, 32451,    59,  2925,  2735, -3752,  2900,
    2949,  2750,  2750,  2750,  2750,  2750,  2750,  2750, -3752,  2218,
   -3752,  2906,  2802, -3752, -3752, 47757, 36248,  1585,   199,  2874,
    1396,  3075, -3752, -3752, -3752, -3752, -3752, 60015,   639,   442,
    1877, -3752, 52005, 69435, 64725,  1346,  2744, 60015,  2742,  2747,
   -3752, -3752, -3752, -3752,  1881, -3752, 52005,   -42,  2928,  2927,
    1346, 69435,  2826, 60015,  2809, -3752,  1896,    42, -3752,   442,
   46339, 50589, -3752,  2019, -3752, -3752,  2932, -3752, 69435, -3752,
   -3752, 33409, 31978,  1543,  2753, 69435, -3752,  2755, 30548,  2993,
    2929, -3752, 30548,  2929,  1516,  2929,  2996, -3752, 35297, -3752,
    2760,  1491, 20252,  2952,  9929, -3752,   102, 52005, 69435, -3752,
     102,  2820,   102,  2823,   102,   102, 60015, -3752, -3752, 60015,
   -3752, 69435, 61428,   102, -3752,  9929, 60015,  1631, -3752, -3752,
   -3752, -3752, 69435,  2162, 48701, 69435,  1035, -3752, -3752,  2951,
   -3752,  1346, 69435,  1447,  2770, -3752, -3752, -3752, -3752,  3076,
    3081, -3752, -3752, -3752, 69435, 56247,   149, 69435, -3752, -3752,
   -3752, -3752,  2781,  1915,  9627, 27111, -3752,  3088, 52005, -3752,
   -3752, -3752, -3752, -3752, 27111, -3752, -3752, -3752, -3752, -3752,
   27111, -3752, 27111,  3068, -3752,  3213,  3213, 52005, 28590,   836,
    2228, 28590, 28590, 28590, 28590, 28590, 28590, 28590, 28590, 28590,
   29576,   348, -3752, -3752, 27111, 27111,  3077,  3068, -3752, -3752,
    1177,  1177, 52005,  2793,  2607,  2796,  2798, 27111, -3752, -3752,
    1920, 47757, -3752, 27111,  8230,  1923,  2836,  9833,  1447,  5500,
   -3752,  3164,   442, 27111,   862,  1578, 27111,  1939, 27111,  3083,
   -3752, -3752, -3752,  2808, -3752, -3752, 52005, 27111, 28590, 28590,
    2886, -3752,  3818, 27111,  2810,  5109, 23167, -3752,   587,   587,
     587,   587, -3752, 60015, 60015,  2577, 27111,  3084,  1940,  1945,
    5741,  2819, 35769, -3752,   426, 26618, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752,  2811, -3752,  2828, -3752, -3752,   526,  2815, -3752, -3752,
    5632,   131,  2830, 69435, -3752,  2562, -3752, -3752,  2818, -3752,
    1837, -3752, -3752, -3752,  5775,  2998,  2202, -3752, -3752, -3752,
   -3752, -3752,   942,  1611,  2834, -3752,  1802,  1306, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752,  2750,  6209, -3752, 69435,
   69435,  1948, -3752, -3752, 69435, -3752,  1985, -3752, -3752,  3079,
    1469, -3752, -3752, -3752,  2892, -3752,   114,  1448, -3752,  2897,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, 47757, 36248, 47757,
    2907,  2909,   715,   593,  2910,  2913,  2821,  2837,  2839, -3752,
    2162,   194,   442, 69435, 69435, -3752, -3752,  2162, -3752,   442,
    2162,   442, -3752, -3752, -3752, -3752, 48229, -3752, -3752, 69435,
    3111,   570,  1525, 69435, 69435, 69435, 69435, 69435, 69435, 69435,
    2503, -3752, -3752, -3752,  2840,   993, -3752, -3752,  3080,  3082,
   -3752,   993,   993,   993,   993,   993,   993, -3752,   200, -3752,
   -3752,  2531,  2531,  1042, -3752,  2531, -3752,  2531, -3752, -3752,
    2563,  2818,  1611,  1221, -3752, -3752, -3752, -3752, -3752, -3752,
    1039,  1611,  1879,  2843, -3752, 32930, -3752, -3752, -3752,  1875,
    1511, 60015,  2750, -3752,   126,   286,   367,   959, 67551, 68022,
   68493,  2849, 69435, 28590, -3752,   866,   599, -3752,  3091, 60015,
    2884, -3752, -3752, -3752,  2854, -3752, 52005, -3752, -3752,  3243,
     668, 60015,  2894,  3147,  3036,  1955, -3752, -3752, 69435, -3752,
    2906,  1568,  2905, 54363, -3752,  3123, 54363, -3752, 69435, -3752,
   -3752, -3752,  3230,  2969,  2912,     5,   442,  2809, 69435,  2885,
   -3752, 50117, 27111, 27111, -3752,  2881, -3752,  2890,  3090, -3752,
    2134, -3752, -3752,   535,  2908, -3752, -3752, 66138,  2895, 69435,
    1543, 30548, -3752, -3752,  2225, -3752, 30548,  3126, -3752, 30548,
   69435,  2899, 69435,  1958, 43492, -3752,  2888,   102, -3752, 69435,
   -3752, 69435, -3752, -3752,   102,   102, -3752,  3000, -3752,  2915,
    1681,  2162, -3752, -3752,  3169, 67080, -3752, -3752, -3752, -3752,
   -3752, -3752,    62,  3175, -3752, -3752, -3752, -3752, 27111,  9929,
   -3752,  2911,  9929,  6553,  9929,  3077, -3752,   737,  3182, -3752,
     903,  2917,   737,   634,   634,   208,   208,   105,   105,   105,
    3213,   348,  9929,  9929, -3752, -3752, -3752, -3752,  2919, -3752,
   -3752, -3752,  2607, -3752, 27604, -3752, -3752,  2944,  2946,  2921,
   -3752, 27111, 28097,  2918, 52949, -3752, -3752,  1511,  2879, 28590,
   28590,  1912, -3752,   333, 27111, 52005,  1966,  1912,  2018,  2492,
   27111, 27111,  7121,   235, 27111,  6661, 60015, 60015, 60015, 60015,
   -3752, -3752,  9929,  3287,  3191,  2819,  2819,  2819, -3752, 82152,
   -3752, -3752, -3752, -3752, 27111,  1306,  1092,   442, -3752, -3752,
     823, -3752, -3752, 38688, -3752, -3752, -3752,   156, -3752, 12871,
   -3752, -3752, -3752,   194, -3752,  1973,  1979,  2884, -3752,  2283,
   -3752,  2978, -3752,  2218,  3114, -3752,  3115,   194, 69435, 52005,
   -3752, -3752,  2939, 69435, 69435,  1611,  1611, 52005,  2926, -3752,
    1611,  1611,  2930, -3752, 69435, 69435, -3752, -3752, -3752, -3752,
   -3752,  2162,  2162, -3752, -3752, -3752, -3752, 69435, 69435, 69435,
   69435,  3228, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
    3178, -3752,   993,   993, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752,  2172,  3252,   442,   442,  3127, 69435,   442,   442, -3752,
    1079,  3261, -3752,  3195,   762,  2942,   112,  3222, -3752,  1712,
   32930, 32930, 32930, 32930, 32930, -3752, -3752,  3225,   194, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, 27111,  1361,   737, -3752, -3752, -3752,
   -3752,  2884,  1585,  3003, 47757,  3005,  1346,   416, 69435,  3258,
    3248,   639, -3752,   442, -3752, -3752, -3752,   813, -3752,  2953,
     146,  2962,  1832, -3752, -3752, -3752,   874, 69435, -3752,   975,
   -3752,  3189,  3234,  2963, -3752, 31027, -3752,  9929,  9929,   442,
   53421,  2019, -3752, -3752, -3752, -3752, -3752,  3031, 69435, -3752,
   -3752, 69435,  1980, -3752, 27111,  2964, -3752, -3752, 30548,  2225,
    1997, 69435,  1998, 52005,  2819, -3752, -3752,   102, -3752,   102,
     102, -3752, -3752, 69435, 69435,  3242,  3134, -3752,   102, 67080,
    9929, -3752, -3752, -3752, 28590,  3240, -3752,  2965, 52005, -3752,
    2967,  2026,  2030, -3752, -3752, -3752,  7012,  3013,  9929,  3062,
    2968,  2971, -3752,   255,   255,   333,  2031, -3752, 28590, 28590,
    1912,  1912, 27111,  1912, -3752, -3752, -3752, -3752, -3752, 27111,
   27111,  3016, -3752, -3752, -3752,  3139, -3752,  7412, -3752,  1221,
   -3752, -3752, -3752, -3752,  1511, -3752,  2975,  1791, -3752, -3752,
    3112,  2884,  3003, -3752, -3752, -3752, -3752, -3752,  3035, 36248,
   -3752, -3752, 31506, 38688, -3752,   715,  2979,  2981,   593, -3752,
   -3752,  1077,   938,  3019,  2162,  3269,   993, -3752, -3752, -3752,
     442, -3752, -3752, 69435,  2980, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, 48701,  3383,  3383, -3752,  1706,  1706, -3752,
   -3752, -3752, 60015,  1039, -3752,  7625,  3177, -3752,  3003,  3207,
    3251, -3752,  2037, -3752, 69435,  2912, 54363,  2906, -3752,   947,
    3142, -3752, -3752, -3752,  3327,  1832,   176,  1265, -3752, 60015,
    2927,  3121, -3752,  3124, -3752,  3370,  3179,  3374,   442, -3752,
   69435, 31027, 27111,  2046, -3752, 68964, 22193, -3752, 52477, -3752,
    2054, -3752, -3752, 60015,  3017, -3752,  2057, -3752,  9929, 69435,
   -3752, -3752, -3752,  2060, -3752, -3752, -3752, -3752, -3752,  1346,
   -3752, -3752,   149,   371, 28590, 52005,  2068, 27111, -3752, 27111,
   -3752, -3752, -3752,   -20, -3752, -3752, -3752,   255,   255,  1912,
    2607,  9929, 69435, -3752,  3388,  3180,  2819, -3752, -3752, -3752,
   -3752,  3190, 60015,  3003, -3752, 27111, -3752, -3752, 52005,  2004,
     377, -3752, 52005, 52005, -3752, 69435, 69435, 69435, 69435, 69435,
   -3752,  1984, -3752,  2980,  3383,   940, -3752, -3752, -3752,  3297,
   -3752, -3752,   627,  3193,  3100, -3752, 47757,  3307, -3752, -3752,
   -3752, -3752, -3752, 48701, -3752,  2927, -3752, -3752, -3752, -3752,
   -3752, -3752,  2072,  2969, -3752, -3752,  3194, -3752,  3196, -3752,
   -3752,  2076,  7866,  3061, 31027, 69435, -3752,  1022,  1022, -3752,
    3090, 53421,  2689,   108,  3041, -3752,  2082, -3752, -3752,   371,
    2095, -3752,  2101,  2106,  3085, -3752,  3024, -3752,  3427, 27111,
    1144, -3752, -3752, -3752,  1585, -3752,  9929,  2107, -3752, -3752,
   -3752,  3173,  2110,  2111,  3027,  3073,  3027, -3752,  2162, -3752,
   -3752, -3752,  3344, -3752, -3752, -3752,   184, -3752,  3217,  3218,
   69435, -3752, 69435,  3438,  3043,  2969, -3752, -3752, -3752, -3752,
    3061, 68964,  2302,  2969, -3752, -3752,  1837,  1837,  2019, -3752,
    3354, -3752, -3752, -3752, 69435, -3752, -3752, -3752, -3752, -3752,
   69435,  3045,  2607,    98,    98,  3046,  3207, 48701, -3752, -3752,
   -3752, 69435,  3166,   324,   324,  3371, -3752,  3113, -3752, -3752,
   -3752,   715, 43970, -3752,  2969,  1022, -3752,  2689, -3752, -3752,
   -3752,   210, -3752, -3752, -3752,    44,  3176,   984, -3752, -3752,
   -3752, -3752,  3193,  2004, -3752,  3357, -3752,  3469, -3752,   784,
   -3752, -3752,  2926, -3752,  2115, -3752, -3752, -3752, -3752, -3752,
   -3752,  2689,  1837, -3752, -3752, -3752,  1872,  3462, -3752, -3752,
   -3752,  1039, -3752,  3212, -3752, -3752, -3752, -3752, 43970, -3752,
   -3752, -3752,  1796, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
      44, -3752, 48701, -3752,  1327, -3752, -3752,  1534,  1775, -3752,
    3063, -3752,  1796, 43970, -3752,  2120, -3752
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3752, -3752,  3208, -3752, -1094,   -54, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
    1226, -3752, -3752,   -76,  1119,  2113,   930, -3752, -3752, -3752,
   -3752,  -957,   154,   687, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752,   606,  1342,   821,  1063, -3752, -1595,  -538, -3752,   326,
   -3752, -3752, -3752,   700,  -284, -3752, -3752, -3752, -3752, -3752,
   -1645,  -119,   195, -3752,   191,  1372,   344, -3752,  -102, -3752,
   -3752, -3752, -3752,  -785,   869,  -916, -1261,  1138,  -551,  -586,
    -512,  -510,  -553, -3752, -2865, -3620, -2545, -3544, -3752, -3752,
   -3752,   207, -3752, -1636, -3752, -3752,  1829, -1501, -3752,  -941,
   -3752, -3752,   655,  1420,   206, -3752, -3752,   -18, -3752, -3752,
   -3752, -3752, -3752, -3752, -3225, -3752, -1568, -3752,   327, -2726,
     786, -3752, -3752, -3752,  1850, -3752, -3752, -3752, -3752, -1677,
   -3752, -3752, -1630, -3752,  1278, -2784, -3752, -3752, -3752,  -628,
    -602, -3752, -3673,   -47,   -44, -3752, -3752, -3752, -3752, -1166,
   -3752,   705, -2773, -1092, -3752, -3752,   734, -3752, -3752,  -537,
    -229,  1876, -3752,  -458, -3752, -3752, -3752,  -224, -3752, -3752,
   -3752, -3752, -3752, -3752, -1803,  3417, -1069, -3752, -3752, -3752,
   -3752, -2192, -3752,  3441,   643, -1629, -3752,  -149,  -122,  2329,
   -1260, -2402,   179, -3752, -3752, -1834, -3752, -3752, -3752, -2344,
   -1627, -3752,   238,  -285,  -407, -3140, -2745, -3058, -3752, -3752,
   -1228, -3752, -3752, -3752, -1487,  1438, -2164, -3752, -2146,   239,
   -3266,  -954, -2858, -3752, -3219,  -412, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -1230,  -836, -3752, -2588, -3752, -3752, -3752,
   -3752,  1034, -3752,   285, -3752, -3752, -3752, -3752, -3752,  -549,
    -589, -3752, -3752, -3752,   325, -3752, -3752, -3752,  1538, -1123,
    -923,  2648, -1626,  -247, -3752, -3752, -3752, -3752, -2671, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752, -1266, -3752, -3752, -3752,
   -3752, -3752, -3752,  1582,  3487,  -206, -3752, -3752,  2170, -3752,
   -3752, -3752, -3752, -3752, -3752,  2377,   275,   -45, -3752, -3752,
     635, -2262,   -40, -3752, -3752, -3752, -3752,  -306,   -26, -3752,
    1016, -3752, -3752, -1951, -3752,  2390,  1231,   215,   -63,   -67,
    -239,  -246,  -219, -3752,  2654,  2206, -3752, -3752,  -216,  1595,
   -3752, -1032, -1029, -3752,  1017,  -869,  1569,  1006,   113,  -178,
   -3752, -2574,   475, -3752, -3752,  -863,  1580, -3752,  2197,  1602,
   -3752,  1628,  1076, -2265,  1307, -2267,   722,  -349,   -46,  -154,
    2692,  2832, -3752, -3751,  1052, -3172,   328,  1055, -1949, -1670,
   -3752, -3752, -1296,  6859, -3752, -3752, -3752, 10771, 12804, -3752,
   -3752, 13062, 13110, -3752, -1163,   596, 13231,  9052, -1314, -1693,
   -1441, 12252,  1638,  1600, -1752, -3752, -3752, -3752,  -252,   611,
     171, -3752, -3752, -3752,  -415, -2563,  -414, -3752, -3752, -3752,
    -418, -3408,  1838, -3752,  -794, -3752, 14261,  1059, -3752,  -759,
   -1284, -1799, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -1569,
   -2908,  -504,  1133, -3752, -3752,  1223, -3752, -3752, -3752, -1382,
   -1023, -1912,  1137, -1924, -3752, -1019,  1258,  1728,  3953,  -960,
    3636,   -97, 11013,  -125, -2165, -1420, -1055, -3752,  -692, -3752,
      25,  3643,  -162,  5545,  6351,    31,   -10, -2735, -3752, -3752,
   -3752,  2450, -3752, -3752, -3752, -3752, -3752,  3110,   771, -3752,
    2513, -3752,  1349,  1953, -3752, -3752,  1606,  -914,   -57, -3752,
    -389, -3752,  -140, -3752, -3752, -3752, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752, -3752, -3752,  2230,   152, -3752,   -36,
   -3752, -3752, -3752, -3752, -3752,  3375,  -299, -3752,  2833,  -297,
   -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752, -3752,  2240,
    1634, -3752,  2644, -3752, -3752, -3752,   -49,  2438, -3752, -3752,
   -3752, -1124,  1371,  2669,  -908,  1604, -3752, -3752, -3752, -3752,
   -3752, -3752, -3752, -3752,  1609, -3752, -3752,  1120, -1929,  1614,
   -3752, -3752,   546, -3752, -3752,   198, -3752,   547, -3752,  2330,
   -3752, -3752, -3752,   575, -3752, -3752, -3752,  -518,  9640,   155,
      48,    14,   939, -3752,  -103,    -5,  2256,  7429, 12083,   -62,
     117,  -108, -3752,  3364,  1617,  1323,  -951,   -69,  1904,   449,
     334, -1080,     7,    -2, -3752,  2405,  -621, -1113,  2506,  -706,
   -1783, -3752,  3765, -3752, -2275, -3752,  -876
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2293
static const short yytable[] =
{
      80,  1548,  1196,   928,  1497,  1026,  1131,  1498,  1798,    79,
    1010,   344,   869,  1806,   774,   343,  1295,  1296,  2224,  1499,
     660,  1300,  2429,  1884,   928,  1433,   857,    74,  1673,   852,
    2452,  1440,  1861,   338,  2395,  2739,  2323,   672,   339,  1761,
    1624,  1567,   361,  2315,  1131,  1914,  1915,   935,   398,  2433,
    1662,  1243,   341,  2740,  2742,   778,  1941,   774,  1080,   973,
    1895,  3153,   948,  1041,  1930,  1042,  2778,  1005,   351,  1448,
    2116,  2118,  2119,   391,   351,   672,  1015,  1561,  2259,   391,
     826,  2056,  2629,   814,  3036,  2365,   974,   662,  3195,  3272,
    1696,  3274,  1736,  1131,   861,  3411,   929,  1740,   778,   969,
    1101,  2493,  1036,  2342,  1746,  1115,   969,   351,   969,   350,
    2198,  2645,  2343,  1763,  2870,   350,  3020,   929,  2344,  2345,
    1518,  2346,  2347,  2963,  1456,   774,  2977,  2979,  1028,  1037,
    1546,   772,  3564,  3368,  3374,  1182,  1789,  2985,   994,  2254,
     901,  3693,  3731,  3328,  2425,   968,  2156,  2653,   350,   862,
     351,  1836,   968,  1831,   968,  3705,  2650,  1075,  1771,  2678,
    1595,  3208,  1526,  1527,  1493,   771,   778,  2903,  1908,  1909,
    1494,  3328,  2010,  1542,   772,  1964,  3067,  1025,  3494,  2056,
      35,   413,   941,   413,  1760,  1228,   824,  1959,    41,  1790,
     927,   350,  1236,  1927,   413,  2694,  2057,  4166,  1267,  2698,
    2206,  2467,    37,    38,    39,    40,  4165,  1967,   771,    35,
    4009,   927,  3402,  2363,  1537,   413,   950,    41,   351,  1790,
    1790,  3345,  3346,  3347,  3348,  3349,  3350, -2168, -1475,   413,
    1085,  1278,   259,   390,   779, -1475,   397,  1508,   964,   390,
     815,  1306,   772,  1221,  2449,   964,  2992,   964,  2994,  1321,
     413,  4166,  1029,    37,    38,    39,    40,  2174,  3750,   350,
    3752,  2568,  2872,  1214,  1690,  2849,  1790,   413,  1097,   413,
    2563,  2602,   390,  3389,  4064,  1878,   771,   779,  2603,  3067,
    2618,  1035,  2487,  2668,  2171,  1280,  2114,   344,  3984,   951,
    4033,   343, -1611, -1611, -1611, -1611,  3669,  2086,  2606,  2723,
    4194,  4120,  1824,  2117,  3034,  1575,  1030,  1148,  2298,   338,
   -1579, -1579, -1579, -1579,   339,   390,  2468,  4026,  2002,    37,
      38,    39,    40,  3045, -1491,  1673,  3067,  1424,   341,  3873,
    1684, -1491,    37,    38,    39,    40,  2087, -1267, -1267, -1267,
   -1267,  2115,  1071,  3906,  4011,   779,  2339,  4027,  1964,  1444,
    1964,   789,   351,  2568,  2017,  3874,   399,   391,  3832,  4143,
    1069,  1426,    37,    38,    39,    40,  2881,  1995,   679,   413,
    2021,  2299,  1131, -1277, -1277, -1277, -1277,  -328,   821,  1031,
    1967,  3907,  1967,   390,  2088, -1267,   351, -1071,   790,  2175,
    1999,   391,  1425,   350, -2111,    37,    38,    39,    40,  1838,
    1059,  1149,  1941,   316,  1964,  4105,  4193,  1576,  1914,  1915,
    1851,  1852,  2018,  1437,  4028,  1930,  3584,  2058,  2340,  3067,
    1215, -2196,   785,  2607,   786,   664,  1288,   350, -1267, -1267,
   -1267, -1267, -1277, -1277, -1277, -1277,  1967,  1791,  1059,  4075,
    4209,  4176,  3067,    37,    38,    39,    40,  2725, -2170,  1964,
    3236,  4065,  2293,  1086,  2297,  2223,  3672,  4195, -2213, -1071,
    1509,   952,   953,  2176,  1677,  2450,  2873,  1791,  1791,  2669,
     873,  1680,  3888,  4167,  1055,  3591, -2168, -1262, -1262, -1262,
   -1262,  1967, -1613, -1613, -1613, -1613,  2260,  2023,  1032,  1099,
    2469,  1042,   789,   857, -1609, -1609, -1609, -1609, -1608, -1608,
   -1608, -1608,    37,    38,    39,    40,  2028,  2470,   259,  3069,
    2045,  2045,  3932,  3328,  1791,  1835,  2364,   390,    37,    38,
      39,    40,  1773,  1307,  2315, -1262,  3403,  4167,  4221,   790,
    2313,  1971,  1972, -1475,  1299,  1998,  1056,  3674,   661,  1908,
    1909,  1879,  2250,   675,  2252,  3573,   413,  1927,  1068,  2287,
    1577,   390,  3023,  1879, -1660, -1660, -1660, -1660,  1830,  2850,
    1960,   861,  1800,  2257,  1533,  2647,  2569,  3773, -1234, -1234,
   -1234, -1234,  1826,   244,  3070,  1076,  2604,  2048,  2049,  3943,
    1559,   675,  1975,  1743,    55,  2290,  2496, -2293,  3548,  1299,
      58,  1057,    58,  3232,  1058,  3233,  2444,  1988,  3079,  2309,
     675,   675,  3069,  1800,    57,  2011, -1071,  1578,    58,  2727,
     675,  2132,  3983,    55,   661,  1996,   862,  2056,  4177,  2288,
    1542,  4144,  1071,  2628,    58, -2293,  2884,  1077,  2102, -1491,
     922,   923,  1957,  3067,  2103,   661,  2395,  2163,    58,  3640,
     665,  2179,  2189, -2111,   922,   923,  3108,  2184,  2215,  3455,
    3237,   675,  1138,  2661,    56,    57,  1384,  1538,  3128,    58,
    3293,  2324, -2213,  3296,  3297,  1539,  1540,  3300,  1450,  1111,
   -2196,  3668,  4019,  1317,  -125,  1599,    58,  3307,    58,   316,
    2370,  1088,   922,   923,   922,   923,   787,  2240,  1059,  4178,
    2243,  2244,  3298,  3299, -1611,  3181, -1071, -2170,  3076,  3077,
    3078,  3079,  3175,  3420,  1276,  3067,  1186,  3424,  1903, -2214,
    3733,  4179, -1579, -1611,  2437,  2376,  1831,   874,  1015,  1691,
    1692,    57,   778,  2165,  2773,  3186,  1223, -2213,  2370,  1460,
    4079, -1579,  3326,  1461,    57,  3025,  1386,  2706, -1071, -1267,
    2294, -1071, -2213,  3074,  3075,  3076,  3077,  3078,  3079,  1277,
   -2240,  1279,  3152,  1281,  1936,  3252,  1233,  4197, -1267,  1282,
    3326,  2584,  2519,  2520,    57,  1983,  1984,  1985,  1986,  1987,
    1988,  3689,  1937,     3,   351, -1277,  3027,  1600,   351,  1060,
    3618,  3734,  1148,   391,  4118,  2235,  4048,  1652,  1238,  1302,
    2168,  1530,  1246,   875,  1938,   876,  3068,    57,   772,  1903,
    1564,  1288,  1258,  1177, -1234,  3409,  1061,  1071,  3067,  1670,
    3600,  2374,  4229,  1936,  2357,   350,  3069,  1753,  2207,   350,
    1179,  1983,  1984,  1985,  1986,  1987,  1988,  1131,  1653,  1565,
   -1267,  1937,   771,   819, -1277,  1211,  3074,  3075,  3076,  3077,
    3078,  3079,   929,  4093,   929,    57,   929,  3910,   675, -1267,
    1272,  2373,   929,  1940,  2166,   872,  1302,  3253,  1754,  3074,
    3075,  3076,  3077,  3078,  3079,  2371,  2395,  2254,  1985,  1986,
    1987,  1988,  1451,  3411,  1619,  1291,  1149, -1234,   969, -1262,
    1814,  3070,   969,  2585, -1613,  2358,   835,  2586,  3069,   413,
     938,  2163,    37,    38,    39,    40, -1609,  3263, -1262,  4160,
   -1608,   779,    80, -1613,    57,  2164,  3690,  2455,  2456,  2774,
    1436,    79,  3601,  3896,  1446, -1609,  3735,  3901,  2216, -1608,
      57,  1815,  2587,  3562,   968,  1071,  3026,   672,   968,    74,
    2217,  3619,  3595,  3067,  3649,  1430,   927,  1452,   927,   390,
     927,   837,  3178,   390,  2167,  1305,   927,  1283,  1284,  1601,
      56,  1671,  1317,  3070,  4205,    58, -1660,  3519, -2214,  4094,
    2436,   922,  1517, -1247, -1247, -1247, -1247,  3028,  3893,  2414,
   -1234,  4155,  3736,  1322,  2440, -1660,  3903,  2165,  1528,  2218,
    1654,  1427,  3812,  3813,  3814,  1439,  1442,  1443,  1081,  1913,
     916,  3069,   929, -1274, -1274, -1274, -1274,   942,  2185, -2240,
    3254,   351,    37,    38,    39,    40,  1466,   660,   660,   917,
    1755,  1131,  1547,    37,    38,    39,    40,   964,  3478,  4095,
    3479,   964,    37,    38,    39,    40,  1672,  1292,  2888,  3255,
   -1238, -1238, -1238, -1238,  3596,    37,    38,    39,    40,  3687,
    4025,  4090,   350,  1386,  2588,  3264,  3071,  3072,  3073,  3911,
    3074,  3075,  3076,  3077,  3078,  3079,  3070,  1571,  4158,  4159,
    3659,  3912,  1655,  1548,  3651,  2359,  3987,   675,  1521,    37,
      38,    39,    40,  1816,   662,   662,  2360,  2186,  -125,  1550,
     844,  2729,   845,  -125,   978,  3775,   927,  3776,  1549,  -125,
    -125,  4206,  1756,  3915,  2397,  2522,  2400,  3688,  2087,   906,
    2836,  3916,  3326,  3631,  3328,  2406,  1541,  3904,  2166,  3634,
    3635,  3636,  3637,  3638,  3639,  1386,  3069,  3597,  3768, -2293,
   -2293,  2657,  3074,  3075,  3076,  3077,  3078,  3079,   675,  3676,
      37,    38,    39,    40,  4210,   949,  1298,  1131,  3480,   122,
    2490,  2492, -1245, -1245, -1245, -1245,  2088,  1807,  3481,  2083,
    3740,  2500,  1026,  2829,  2503,  1817,  3743,   126,  3227,  2830,
    2730,  3747,  2515,  2516,  3749,   413,   390,  1012,    37,    38,
      39,    40,  1115,  4091,  2637,  2533,  2535,   979,  2990,  1694,
    3452,  3070,  1001,  2723,  2995,  2683,  2549,  2913,  2914,  2915,
    2916, -1234,  1546,  4199, -1236, -1236, -1236, -1236,  2167,  1483,
    2658,  1872, -1234, -1074,  1913, -1234,  1566, -1234,  2834,   344,
    1642,  3649,  1886,  1848,  3913,  3777,  2395,  1299,  1386,  2724,
    2395,  3071,  3072,  3073,  1896,  3074,  3075,  3076,  3077,  3078,
    3079,  1844,  3561,  3724,   344,  2084,  1845,  2835,  1877,  2076,
    2078,  2625,  2082,  3466, -1239, -1239, -1239, -1239,  3917,  1272,
    1846,  3231,  3867,  3981,  2144,  2831,  1042,  1442,  1901,  2113,
    3411,    80,    80,  2342,    80,  2069,  2077,  2077,  2628,  2077,
      79,    79,  2343,    79,  3759, -1074,  3760,  1917,  2344,  2345,
    3650,  2346,  2347, -1237, -1237, -1237, -1237,  4007,    74,    74,
    4101,    74,  1484,    56,    57,  1384,  1538, -1078,    58,  3996,
    2860,  2809,  4116,  4117,  1539,  1540,  2170,  1944,  2986,  2812,
    3868,  2814,  1220,   675,  3156,   675,  2482,  3157,  3158,  4020,
    1019,  2114,  4200,   822,  1955,  3447,   963,  2300,  3159,  3160,
    3161,  2725,  3162,  3163,  1027,  1000,  2171,  3164,  3165,  3166,
    3029,  3651,  3390,  1386,  3645,  4021,  3071,  3072,  3073,   780,
    3074,  3075,  3076,  3077,  3078,  3079,   675,  1642,  2055,   781,
     661,  3265,   661,  1568,   661, -1247,  1643,  3952,  2301, -1078,
     661,   672,   672,  2981,   975,  1743,  2115,  2211,   929,  2015,
    2016,  2073,   929,   929,  1919,  3877,  3878,  3879,  3880,  3881,
    3646,  1958,  1569,  2163,  3997, -1274,   207,  1800,  2832,   778,
    2206,  1963,   789,  1489,    57,  3030,  4029,  2164,   830,   156,
    4192,  2757,  2001,  4072, -1274,    57,  4089,  2459,  1035,  1035,
    1570,  1035, -1074,  1962,    57,  2122,  2212,  2833,  2123,  1271,
     413,   675, -1238,   675,  2000,  2759,  4030,    57,  1800,   790,
    3857,  3858,  1442,  2634,  2116,  2030,  1017,   782,  2888,  1442,
    1442,   351,  2245,   789,  1521,  3221,   660,  2032,  1521,  1521,
    2758,  1800,   969,  2055,  1537,  2319,   672,  1491,  2172,  3167,
    3003,    57,   927,  1059,  2129,   772,   927,   927,  1874,  2165,
     174,  1045,   969,  3940,  2760,  1644,   835,  3351,  4107,  1571,
     790,  3454,   350,  4133,  3475,   351,   351,   351,  2245,  2033,
     413,   391,   391,  4031,   778,  -725,  2225,  2206,   968,   771,
     661,  1492, -1074,   929,  2213,   969, -1078,  4134,  3495,   929,
    2302,  2692,  2124,   662,  2125,   661,   661,  1056,   968,  1536,
    1757,  3353,    57,  3995, -1868,  3455,   350,   350,   350,  2884,
    2121,   837,  1284,   351, -1245,  3212,  2139,  2141,   391,  1758,
     351,  2226,  2227,   771, -1074,  2148,   351, -1074,  2133,   929,
    4153,   968,   929,   929,  2138,  2140,  3928,  1285,  4157,    56,
      57,  2246,   783,  2247,    58,  2220,  1657,  1800,   779,  1489,
     772,  3819,  1057,  1490,   350,  2320,  1038,  1304,  3248,  1521,
    2909,   350,  2223,  3168,  1626,  1521, -1236,   350,  1189,  2056,
    1190,   964,  2303,  3249,  1781,  1658, -1078,   927,  2278,  4191,
    2166,  3585,   929,   927,   771,   213,   390,  2246,  2174,  2247,
     835,   964,   779,  1627,    35,   130,   131,  3820,    37,    38,
      39,    40,    41,  1659,  1936,  1521,  1026,     8,  1521,  1521,
    2335,  2628,  2258,  1491,   221,  3169, -1239,  3666, -1078,  3067,
    1081, -1078,  1937,   927,   964,  1782,   927,   927,  2884,  1087,
     390,   390,   390,  3886,  4000,  3203,   791,  3230,  3357,  2395,
    2403,   230,  1098,  3520,  2395,   837,  2319,  2395,   232,  1059,
     844,   778,   845,   779,   823, -1237,  2330,  1492,  1521,   213,
     235,   847,  2337,  3326,  2969,  2045,  2397,   903,    56,   213,
    2167,   850,  2408,    58,  3358,  3196,   927,  1113,   390,  2366,
    3176,  2417,  1208,  1581,  1146,   390,  3359,  2504,   221,  2389,
    2438,   390,  3629,  2424,  1147,  2472,  2628,   213,   221,  4017,
    1821,   244,  2970,   351,  3170,  3620,  3043,  1856,  1056,  1783,
    1209,  1781,  1639,  1582,  1649,  2484,  1140,  2348,   976,  1822,
    3586,  1666,   232,  3134,  3621,   675,   221,   772,  2971,  2970,
    1181,  2644,   232,  1042,   235,  2448,  1442,  1184,  2453,  2454,
    2321,  2483,  2457,  3426,   350,  3463,  3496,  3497,  1208,  2505,
    1210,  1185,  4049,  2973,  3094,  2971,  3828,  1188,  1784,  1839,
     232,   771,  3450,  1057,  3360,  1131,  2320,  2322,  1574,  1583,
    2972,  1197,   235,  2382,  2890,  1875,  3371,  1203,  1025,  1650,
    2973,  1840,   801,  3117,   844,   244,   845,   156,   344, -1115,
    3008,  1625,  2481, -1115,  3792,  4231,  1213,    80,  4232,  1584,
      80,  1663,  3069,  2974,  2506,  1212,    79,  2507,  1651,    79,
    2478,  1841,  3526,   244,  3791,  2479,  1210,  3587,  1957,  1219,
    3588,  1936,  -337,  2151,    74,  1936,  2891,    74,  2251,  2480,
     779,  3148,  3149,  2566,  3119,  3189,  3120,  1089,  2004,  1937,
    1900,  1785,   244,  1937,  2283,   413,  1783,   675,   675,  1090,
    1091,  1216,  2152, -1115,  2284,  2975,  3121,  3928,   174,  2209,
    1059,  1938,  2214,  2225,  1234,  1940,   661,  3070,   390,  1092,
     661,   661,  1093,  2573,   778,  1622,  2070,  2285,  2071,   207,
    2153,  2281,  2975,    35,   413,  1048,  2512,    37,    38,    39,
      40,    41,  1230,  2663,  3250,  1784,  2397, -1115,  2892,  2893,
    1244,  2508,  2261,  1623,  2888,  1049,  2501,  2502,  2226,  2227,
    2282,  2894,  1460,  1253,  2514,  1050,  1461,  1661,  2517,  2518,
    3234,   207,  1192,  3251,  1193,  1913,   351,  2157,  3575,  3576,
     207,  3581,  2188,  2539,  1587,  2540,  1913,  1913,  2157,  1566,
    1588,   156,   675,  3925,   661,  1623,  2434,  1589,  2435,  2223,
     772,  2321,  2135,  1964,  1623,  2561,  1460,  2562, -1579,  3122,
    1461,  3369,  1591,  3406,  3123,  2895,  2395,   350,  2106,  2107,
    1592,  1832,  1571,  1094,  2575,  1833,  2576,  2655,  1785,  2006,
    2445,  2025,  2446,  2007,   771,  1967,   929,  1832,  1925,  1926,
    1968,  2432,  2509,   213,  1259,  3040,  2577,  2635,    55,  2435,
      57,   661,  1480,  1051,  2708, -1071,  2133,   661,  3093,  4004,
    3095,  3096,   174,  1095,  1571,  3643,  3644,   156,  1593,  3647,
     351,  3648,   221,  1673,  2055,   391,  3041,   929,   904,  1386,
    3042,   660,  3071,  3072,  3073,  1274,  3074,  3075,  3076,  3077,
    3078,  3079,  1288,  2680,  1547,  2680,  2896,   661,  2897,   230,
     661,   661,  1293,   779,  3189,  1071,   232,  1314,  2447,  3067,
    2446,   350,  1708,    58,  3309,   778,  1052,  1297,   235,   351,
     191,   351,  1309,  2475,   391,  2476,   391,  3124,  2746,  2262,
     927,  1315,  3189,  3798,  2026,  1316,  3125,  2949,   174,  2554,
    2770,   390,  2557,  2654,  2578,  1800,  1317,  2280,   662,  2579,
     661,  3979,  1318,  1521,  2580,  1581,  3310,  2384,  2385,   244,
     350,  1550,   350,    80,  2225,    80,  1970,   351,  1319,  1026,
    1549,   927,    79,  2700,    79,  2476,  1320,  3579,  1053,  1323,
    3311,   778,  2225,  2671,  2672,  1582,  1971,  1972,  1541,  3925,
      74,   772,    74,   929,  1447,  4211,   191,   213,  2737,  3312,
    2738,   929,  2780,   929,  2781,  1443, -1138, -1138,   350,  2226,
    2227,  1324,  4084,   778,  4086,  3313,  3662,  3663,  3664,  1464,
    3660,  3661,  3662,  3663,  3664,   771,   221,  2226,  2227,  3314,
    3876,  1449,  2876,   351,  2877,   390,  1913,  1975,  2157,  1454,
    2910,  1583,  2904,  3433,  2905,  3010,  1453,  2446,  1964,  1469,
    2223,  1976,  3021,   230,  3022,  1470,  3039,   772,  2435,  1718,
     232,  3796,  2106,  2676,  3732,   351,  1455,  2581,  2223,  1521,
    1477,  1584,   235,   213,   350,  1478,  2582,  1521,  1480,  1521,
    1967,  3049,  3188,  2435,   390,  1968,   390,   927,  3052,   772,
    2435,   771,  3069,  1481,   779,   927,  2397,   927,  1487,  2950,
    2397,  3056,   221,  2435,  1502,  3057,   350,  2435,  2937,  2938,
     675,  3315,  3925,   244,  1500,  3083,  2862,  2435,  3099,  3316,
    2435,  1506,  1964,   771,  2862,  2004,  3102,  1507,  3103,   230,
    3191,  3192,   390,  1812,  1603,  1510,   232,    55,    56,    57,
    1604,  2962,  1115,    58,  1827,  3138,  1965,  3139,   235,   922,
    1517,  1515,  3317,  1026,  1967,  3656,  3657,  3070,  3502,  1968,
     779,  3140,  1522,  3141,  3351,  1889,  1890,  2887,  1628,  3154,
    2912,  3155,  3116,  3013,  3182,  3246,  3183,  3247,  3352,  1605,
    3197,  3198,  1883,  3660,  3661,  3662,  3663,  3664,  3275,  4212,
    3276,  3665,   779,  2942,  1523,  3377,  2969,  3378,   390,  3387,
    1511,  3388,   207,  1512,  1071,  3864,  1587, -2293,  3353,  1513,
    3354,  1970,  1588,  1979,  3400,  1629,  3401,  3143,  3144,  1589,
    1983,  1984,  1985,  1986,  1987,  1988,  1623,    81,  1514,  1606,
     390,  1971,  1972,  3467,  1591,  2435,  1607,  1525,  3503,  1608,
    3504,  3510,  1592,  3511,  1120,  1442, -2293,  1121,  1122,  1123,
    1516,  1124,  1125,  1126,  1127,  1128,  1129,  3522,  3545,  2435,
    2435,  2970,  1528,  3546,  1856,  2435,  3577,  3100,  2446,  1529,
    1531,  2627,  3105,  3702,  3189,  3703,  3754,  1552,  3155,  3355,
    2135,  1969,  1975,  1555,  3797,  1970,  2476,  2971,  1609,  1630,
    1593,  3830,  1562,  2446,  2952,  3410,  1976,  3831,  3937,  2446,
    1800,  1553,  2972,   392,  1566,  1971,  1972,  1580,   778,   392,
    3199,  3200,  2973,   778,  3956,  3942,  3944,  3378,  3378,  1386,
    1973,  1597,  3071,  3072,  3073,  1955,  3074,  3075,  3076,  3077,
    3078,  3079,  1619,  1621,  1631,  2974,  1632,  4156,  1656,  2573,
    3356,  1660,   392,  1610,  3958,  3357,  3959,  2253,  3960,  3966,
    2435,  2476,  1669,  1974,   661,  4015,  1975,  4016,  3137,  1668,
     351,  3825,  3744,  1674,  4043,   351,  4044,  3859, -2293,  1676,
    1976,  2389,  4050,  1977,  4051,  4055,   863,  1800,  4057,  1611,
    3378,  3358,  1634,  3067,   772,   392,  4061,   929,  2476,   772,
    4106, -1576,  2020,  3359,  4110,   661,  4044,  1678,  1603,   661,
    4125,   350,  1800,  2689,  1604,  1536,   350,  3799,  1612,  1681,
    1686,   675,  1613,  4126,  2975,  2476,  1688,  1636,   771,  4127,
    1695,  3103,  4003,   771,  4128,  4137,  2435,  2476,  4139,  4140,
    2476,  2476,   970,  4207,  1698,  4208,  1614,  1883,  4236,   970,
    4208,   970,  1978,  1605,  3425,  1486,  3428,  1488,  1571,  1737,
    1638,  1743,  1739,   392,  1442,  1749,  1747,  -169,  1979,  1751,
    1762,  1768,  1778,  1521,  1786,  1983,  1984,  1985,  1986,  1987,
    1988,  3360,  1788,  1793,  1795,  1794,  2133,  1796,  1797,  3177,
    1799,   927,  1800,  1805,  3745,  1808,  1809,   779,  1810,  1811,
    1813,  4060,   779,  1606,  2233,  1818,  1819,  1820,  1825,  1857,
    1607,  1885,  1887,  1608,  1891,  1899,  1893,  3260,  1907,  1894,
    1910,   661,  1911,  1912,  1916,  1993,   244,  1918,  2024,   661,
    1921,   661,  2020,  3267,  4077,   390,  2035,  3270,  4082,  4083,
     390,  1922,  1979,  1923,  1924,  1980,  1981,  1982,  1929,  1983,
    1984,  1985,  1986,  1987,  1988,  1931,  2060,  3826,  2074,  2397,
    2050,  3060,  1609,  2291,  2397,  1932,  1933,  2397,  1934,  1935,
    1942,  1943,  1945,  1946,  1947,  3782,  3069,  1948,  1949,  1950,
    1883,  1490,  1951,   778,   778,   778,  2100,  2105,  2112,  1059,
    4081,  4078,  2126,  2128,  2130,  2120,  1537,   392,  2136,  1131,
    2137,  2142,  2143,  2154,  2145,  2155,  3889,  2949, -2017,  2147,
    2158,  2159,  2157,  2173,  3381,  2178,  2180,  1610,  2181,  2182,
    2183,  2204,  2206,  2328,  2220,  1581,  2205,  3266,  2210,  2223,
    2229,   392,  2335,  1964,  2221,   351,   351,   351,  2222,   929,
    2230,  3070,  2231,  2236,  2234,  2238,  2239,  2241,  2248,  3278,
    2249,  3416,  2255,  1611,  1642,  1582,  2256,  3268,  2263,   772,
     772,   772,  2264,   857,  2270,  1967,  2271,   929,  2277,  2279,
    1968,  2292,  2304,   778,  2306,  2314,   350,   350,   350,  2402,
    2862,  2307,  2401,  2862,  2862,  1903,  1613,  2862,   344,  2316,
    1913,  2407,  3382,   771,   771,   771,  2272,  2862,  2317,  2415,
    2416,  1919,  1694,   344,  2326,   832,  3329,  3394,  2332,  2336,
    1614,  1583,  3338,  1644,  2352,  1521,  2369,  2428,  2375,  2377,
     675,  1856,  2380,  2387,   344,   351,  2378,  1026,  3415,  2381,
    2398,  2389,  2410,   927,  3329,  2389,  2411,  2412,  3333,  3336,
    2426,  1584,  2413,  1521,  2427,  3451,  2441,  3376,  2442,   772,
    2458,  2473,  3536,  3537,  3538,  3539,  2461,  3127,  2465,  1603,
    2486,   927,   779,   779,   779,  1604,   350,  3462,  2495,  2950,
    2537,  2496,  2550,  4070,  2555,  4202,  4071,  3405,  1442,  4032,
    1964,  2559,  2560,   771,   344,  2567,  2572,  1964,  3458,  2538,
    2618,  2589, -2293,  2591,  2633,  2641,  1970,  2642,  1030,  2631,
     390,   390,   390,  1386,  1605,  2665,  3071,  3072,  3073,  2664,
    3074,  3075,  3076,  3077,  3078,  3079,  1971,  1972,  2649,  1967,
    2670,  2630,  2638,  2685,  1968,  2636,  2656,  2682,  3505,  2010,
    2684, -2293,  2703,  2699,  2701,  2702,  2710,  3990,  2712,  2714,
    2715,  2716,  2733,  2718,  2735,  2721,  2728,  2779,  2782,  2564,
    2843,  2837,   779,   863,  1606,  2838,  2772,  2839,  2847,  2848,
    2851,  1607,  2852,  2397,  1608,  2853,  2855,  1975,  2856,   778,
    2857,  2858,   207,  2859,  2869,  3189,  2951,  2878,  2871,  1131,
    3970,  1976,  1588,  2880,  2883,  2884,  2397,  2885,  2886,  1589,
     390,  2902,  2906,  2917,  2911,  2918,  1623,  2919,  2923,  1955,
    2924,  2940,  4188,  2941,  1591,  2943,  2961,  2968,  2958,  2959,
    2135,  3530,  1592,  1609,  2960,   661,  2982,  2988,  2987,  2996,
    2999,   351,  2095,  3002,  3012,  3006,  3001,  3014,  3019,  3609,
    2487,  3031,  3035,  1299,  3050,  3037,  3054,  2435,  3118,  3051,
    3517,  3053,  3055,  3089,  3058,   772, -2293,  3059,  3061,  3064,
    1970,  3082,  2643, -2293,  3113,  3088,  3090,  3091,  4188,  3098,
    1593,  3111,   350, -1929,  2952,  3112,  3133,  3126,  1610,  3136,
    1971,  1972,  3146,  3151,  2770,  3152,  3592,  3202,  3205,   771,
    3989,  3206,  3553,  4188,  3207, -2293,  1581,  3224,  4136,  3216,
    1832,  3223,  3210,  1603,  3228,  3211,  3611,  3612,  3219,  1604,
    3220,  3229,  3262,  3261,  1611,  3269,  3271,  3280,  3279,   929,
    3281,  1115,  3283,  3282,  3284,   778,  1582,   778,  2949,   392,
    3295,  1975,   929,   392,  3285,  3286,  3287,  1108,  3288,  3289,
    4063,  3301,  1108,  1647,  3302,  1976,  1581,  1613,  1605,  3303,
    2123,  3304,  3305,  1979,   778,  3306,  3331,  3341,   779,  3342,
    1983,  1984,  1985,  1986,  1987,  1988,  3332,  3364,  3568,  2397,
    3366,  1648,  1108,  3340,  3343,  3370,  1582,   351,  3372,   351,
    3385,  3383,  1583,  3391,  3392,  3396,  3329,  3386,  3398,  3413,
    3421,  3417,  3419,  3429,  3422,  1521,   390,  3432,  1606,  3439,
    3610,   772,  3441,   772,  3434,  1607,   351,  3613,  1608,  3614,
    1996,  3457,  1584,   927,  3460,  1224,  1900, -2293,   350,  3461,
     350,  3470,  1108,  3085,  3067,  3512,   927,  3084,  1959,  1108,
     772,  3499,  1583,  2862,  3500,   771,  3501,   771,  3524,  2862,
    2862,  2862,  2862,  2862,  2862,  3525,  3543,   350,  3533,    81,
    4132,  3555,  3556,  3557,  3560,  3563,  3566,  1609,  3569,  3606,
    3582,  3617,  1584,  3580,   771,  3589,  3593,   661,  3594,  3604,
    2125,  4104,  3605,  3338,  3632,  3607,  3633,  3608,  3630,  3658,
    3410,  3696,  3671,  3673,  3675,  3677,  3684,  1283,  1284,  3691,
    2950,  3694,  2397,  3698,  2389,   661,  3655,  3699,  3701,  2389,
    3336,  3707,  2389,  3711,   779,  3716,   779,  1979,  3719,  3670,
    1585,  2882,  1610,   675,  1983,  1984,  1985,  1986,  1987,  1988,
    3717,  3729,  3725,  3748,  3763,  1108,  3757,  3730,  3766,  3738,
    3769,   970,  3741,   779,  3722,   970,  3751,  3774,  3783,  1586,
    3784,  3809,   390,   207,   390,  2663,  3833,  1587,  1611,  3771,
     675,  3829,  3764,  1588,  3778,  3810,   392,  3779,  3789,  3785,
    1589,  3834,  3835,  3839,  1108,  3836,  3845,  1590,  3855,  3860,
    3848,   390,  3856,  3869,  3863,  1591,  3650,  1664,  3872,  3875,
    3882,  1613,  3890,  1592,  3894,  4173,  3898,  3900,  3918,  3920,
    3933,  3905,  3949,   207,  3950,  3954,  3962,  1587,  3963,  3909,
    3921,  3939,  3955,  1588,  3957,  1665,  3964,  3982,  2989,  3965,
    1589,  3972,  3974,  3980,  3985,  3998,  3992,  1623,  3993,  3999,
    2446,  4005,  2997,  2998,  3690,  1591,  3000,  4012,  4014,  4023,
    4024,  1593,  3004,  1592,  4034, -1083,  4036,  4035,   929,  4037,
    4038,  4053,  4069,  1031,   929, -1083,  3884,  4092,  4073, -1083,
    4096,  4100,  4102,  1603,  4108,  1964,  4109,  4112,   929,  1604,
    3851,  3852,  4124,  3854,  4130,  4131,  4079,  1826,  4129,  4141,
    4230,  3032,  4142,  2528,  4145,  4147,  4151,  4161,  4175,  1965,
    4152,  1593,  3549,  1628,  4171,  2952,  4143,  1967,  4198, -1083,
    4144,  3038,  1968,  4204,  3823,  3824,  4203,  4220,  1605,  4222,
    4233,  1108,  1040,  3822,  2908,  2047,  3179,    80,  1108, -1083,
    3238,  2775,  4154,  3590,  3308,  4001,    79,  3713,  3709,  3583,
    2747,  2133,  3218,  3887,  3011,  4172,  4201,  4148,  4146,  1734,
    1629,  4181,   927,  2368,    74,  3714,  3395,  2726,   927,   929,
    2349,  3721,  3273,  3615,  2889,  4235,  4223,  3871,  1606,  3870,
    3367,  3319,   927, -1083,  4182,  1607,  3991,  2331,  1608,  1108,
    3842,  3843, -1083,  4138,  3994,  3846,  3847,   944,  1873,   344,
    2862,  2862,   778,  3895,  3767,  3723,  4041,  4114,  2741,  4119,
    3726,  3861,  3862,  4234,  3936,  3865,  3866,  4214,  4018,  1457,
     909,  2651,  2075,  1843,  3936,  2689,  3706,  3459,  3338,  3338,
    3338,  3338,  3338,  3184,  1630,  3765,  1847,  1609,    81,    81,
    3007,    81,  2675,  3187,  1969,  1476,  3201,  3567,  1970,  1108,
    3827,  2389,  2674,  2072,   351,  3336,  3336,  3336,  3336,  3336,
    2667,  2648,  2101,   927,  3145,  2964,  3427,   661,  1971,  1972,
    3185,  3902,  1465,  3941,  1226,  4062,  3704,  3516,   772,  1631,
     661,  1632,  1734,  1973,  3506,  4163,  4170,  4164,  3190,  3131,
    3046,  3129,  1633,  3024,  2617,   350,  1849,  3927,  1074,  3414,
    2957, -1083,  1780,  2383,  1108,  4162,  2686,  2111,  1043,  1270,
    2677,  2104,   771,  1560,  1882,  2690,  1974,  2693,  1532,  1975,
    3174,  2691,  3571,  3818,  3572,  2009,  3559,  1634,  1611,  1066,
    2443,  2108,  1108,  1976,  2697,  3009,  1977,    83,  3756,  1829,
     929,  2529,     0,     0,     0,     0,     0,     0,     0,     0,
    3222,     0,     0,     0,     0,     0,     0,  1635,     0,     0,
       0,  1613,  1636,  1108,  1108,     0,  1108,  1480,     0,     0,
       0,     0,     0,  3235,     0,     0,     0,     0,     0,  1992,
       0,   779,     0,  1108,     0,  1637,     0,     0,  3240,  3241,
       0,     0,     0,     0,     0,  1638,  3978,     0,     0,     0,
       0,  2608,     0,     0,  3256,  1978,  3258,  3329,     0,     0,
       0,     0,  4056,     0,  3977,     0,  1521,     0,     0,   390,
       0,     0,  2031,     0,  2862,     0,     0,     0,  4002,     0,
       0,     0,  1964,     0,   927,  1108,   392,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   344,     0,     0,     0,  3415,     0,     0,  1964,
       0,     0,  1108,     0,  1967,     0,  1108,  1108,     0,  1968,
       0,     0,  4088,     0,     0,     0,     0,     0,  3294,     0,
     392,   392,   392,     0,     0,     0,  4039,     0,     0,     0,
       0,  1967,     0,     0,     0,  1979,  1968,     0,  1980,  1981,
    1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,     0,     0,
    2639,     0,     0,     0,     0,     0,  2640,     0,     0,     0,
       0,     0,     0,     0,   778,     0,     0,     0,   392,     0,
       0,     0,     0,     0,     0,   392,     0,  1734,     0,     0,
       0,   392,     0,  4228,     0,   970,     0,  3379,     0,     0,
       0,     0,     0,     0,  4122,     0,     0,     0,     0,     0,
       0,  3235,     0,     0,     0,   970,     0,     0,     0,     0,
       0,     0,  1734,     0,     0,  2135,   351,     0,     0,     0,
       0,     0,     0,  3531,     0,     0,   661,     0,     0,     0,
       0,  1969,   661,     0,  1734,  1970,     0,     0,   970,     0,
     772,     0,     0,     0,     0,     0,   661,     0,     0,     0,
       0,     0,  3436,     0,     0,  1971,  1972,   350, -2293,  3435,
       0,     0,  1970,  3438,     0,  3440,     0,  3442,  3443,     0,
    1973,     0,     0,     0,   771,     0,  3448,     0,     0,     0,
       0,     0,  1971,  1972,     0,     0,     0,     0,  4121,     0,
       0,     0,     0,  1734,     0,     0,     0, -2293,     0,     0,
       0,     0,     0,  1974,     0,     0,  1975,     0,     0,  3464,
    2312,     0,     0,  3471,     0,     0,     0,     0,     0,     0,
    1976,     0,     0,     0,     0,     0,     0,   661,  1734,     0,
       0,     0,  3476,  1975,     0,  2528,  2528,     0,     0,   344,
    2528,     0,     0,   779,     0,     0,     0,  1976,     0,     0,
       0,     0,     0,  1734,     0,  4227,     0,  3498,   392,     0,
    4190,     0,     0,     0,     0,     0,     0,     0,     0,  4189,
       0,     0,     0,  3065,  3066,   344,     0,     0,  3081,  2528,
    2528,   390,     0,     0,  1006,     0,     0,  4186,     0,     0,
       0,  1883,  1978,  1006,     0,     0,     0,     0,     0,     0,
       0,  1108,     0,  1108,     0,     0,     0,     0,     0,  1734,
       0,     0,  1108,     0,     0,     0,  4190,  3114,  3115, -2293,
    1109,     0,  1112,     0,     0,  4189,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1142,     0,     0,
       0,  4190,     0,  4186,    81,     0,     0,    81,     0,     0,
    4189,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1187,     0,     0,     0,     0,     0,     0,     0,  4186,     0,
       0,     0,     0,     0,     0,     0,  1205,     0,     0,  1108,
       0,     0,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,
    1984,  1985,  1986,  1987,  1988,     0,     0,     0,   661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1979,
       0,     0,     0,     0,  1108,  1108,  1983,  1984,  1985,  1986,
    1987,  1988,  1108,     0,     0,  1108,     0,     0,  1108,     0,
       0,     0,  1964,  2513,     0,     0,  1108,  1108,     0,     0,
       0,     0,     0,     0,  1108,     0,     0,  1108,  1108,  1108,
    1108,     0,     0,     0,     0,     0,  1965,  1108,  1108,     0,
    1108,     0,  1108,     0,  1967,  1108,     0,     0,     0,  1968,
       0,     0,     0,  2529,  2529,     0,     0,     0,  2529,  1734,
    1108,   392,     0,     0,  1108,     0,     0,     0,  1108,     0,
       0,     0,  1108,     0,     0,  1108,  1108,  1108,  1108,  1108,
    1108,  1108,  1108,  1108,     0,  1108,     0,     0,     0,     0,
       0,  1108,     0,     0,     0,  1108,     0,  2529,  2529,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3695,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1117,     0,     0,     0,     0,
    1136,  1116,     0,     0,     0,  1134,     0,     0,  1145,     0,
       0,     0,     0,     0,  1144,     0,  1153,     0,     0,     0,
       0,  1180,     0,     0,     0,   392,     0,   792,     0,     0,
       0,     0,     0,     0,     0,     0,  1108,     0,     0,  1191,
       0,  1969,     0,  1198,     0,  1970,     0,     0,     0,     0,
       0,     0,     0,     0,  1207,     0,     0,     0,     0,     0,
    3758,     0,   661,     0,     0,  1971,  1972,  3761,  3762,     0,
       0,     0,     0,     0,   392,     0,   392,     0,     0,     0,
    1973,     0,     0,   793,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1617,  1618,     0,     0,     0,
       0,     0,     0,   794,     0,     0,     0,     0,     0,     0,
      81,     0,    81,  1974,     0,     0,  1975,     0,     0,     0,
       0,     0,   392,     0,   795,     0,     0,     0,     0,     0,
    1976,     0,     0,  1977,  1301,     0,     0,     0,     0,  1108,
    1883,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1312,   796,     0,     0,     0,  1689,   797,     0,     0,  1734,
       0,   798,     0,     0,  1734,  1734,     0,     0,     0,     0,
       0,  1741,  1742,     0,     0,     0,   799,     0,     0,     0,
       0,  1434,     0,     0,     0,     0,     0,     0,   392,  1769,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1459,     0,  1978,     0,  3838,     0,     0,     0,     0,     0,
       0,     0,  3844,     0,     0,     0,     0,  1802,  1804,     0,
     392,     0,     0,     0,  1482,     0,     0,     0,  2528,     0,
       0,  2528,  2528,  2528,  2528,  2528,  2528,  2528,  2528,  2528,
    2528,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   800,     0,
       0,     0,     0,     0,     0,     0,  3477,     0,     0,  3482,
    3483,  3484,  3485,  3486,  3487,  3488,  3489,  3490,  3491,  1108,
       0,  1734,     0,     0,     0,   801,     0,     0,  2528,  2528,
       0,     0,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,
    1984,  1985,  1986,  1987,  1988,  1100,     0,     0,     0,   802,
    1100,  3106,  1006,     0,     0,   803,     0,  1006,     0,  1006,
       0,   804,     0,   805,     0,  1006,  3528,  3529,     0,     0,
       0,     0,     0,  1006,     0,     0,     0,     0,  1006,     0,
    1100,     0,     0,  1734,     0,     0,     0,     0,     0,   806,
     807,     0,     0,  1108,   808,     0,     0,     0,     0,     0,
       0,     0,   809,  1108,     0,     0,     0,   810,  3379,     0,
       0,     0,     0,     0,     0,     0,     0,   811,     0,     0,
    3945,     0,  3946,  3947,     0,  1006,     0,     0,     0,   812,
    1100,  3951,     0,  1883,  1964,     0,     0,  1100,     0,     0,
    1108,     0,     0,     0,  1764,  1766,  1767,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1965,     0,
       0,     0,     0,     0,     0,     0,  1967,     0,     0,     0,
    1108,  1968,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1734,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1006,     0,     0,     0,     0,  1006,     0,     0,     0,
    1108,  1108,     0,     0,  1964,     0,  2529,  1006,     0,  2529,
    2529,  2529,  2529,  2529,  2529,  2529,  2529,  2529,  2529,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1965,     0,
    1108,  1108,     0,  1434,     0,  1108,  1967,     0,  1006,     0,
       0,  1968,     0,     0,     0,     0,     0,  1108,  1108,  1108,
    1108,     0,     0,  2528,     0,   392,  1434,  1006,     0,  1108,
     392,     0,  1108,  1006,  1108,     0,  2529,  2529,     0,     0,
       0,     0,     0,     0,  1108,  1108,     0,  1108,     0,     0,
       0,  1006,     0,     0,     0,     0,     0,     0,     0,     0,
    1108,  3686,  1108,  1969,     0,     0,  1108,  1970,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1883,     0,  1108,     0,     0,  4058,     0,  1971,  1972,     0,
       0,     0,     0,  1108,     0,  1108,  1108,  1108,     0,     0,
       0,     0,  1973,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1883,     0,  1108,     0,  1883,  1883,     0,
       0,     0,     0,     0,  1108,     0,     0,     0,     0,     0,
       0,  1108,     0,  1969,     0,  1974,  1108,  1970,  1975,  2265,
    2266,  2267,  2268,  1108,  1108,  1108,     0,     0,     0,     0,
       0,     0,  1976,     0,     0,  1977,  2784,  1971,  1972,     0,
       0,     0,     0,     0,  2051,     0,     0,     0,     0,  2295,
    2296,     0,  1973,     0,     0,  2305,     0,     0,     0,  1100,
       0,     0,     0,     0,     0,     0,  1100,  1108,     0,  2528,
    2528,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1974,     0,     0,  1975,  2785,
       0,     0,     0,  1734,  1734,     0,  1734,     0,  2786,  2787,
    2788,     0,  1976,  1734,  1978,  1977,     0,  3793,  3794,     0,
       0,  1006,  1006,  1006,     0,     0,     0,  1100,     0,     0,
    2353,  2354,  2355,  2356,     0,     0,     0,     0,     0,     0,
    1964,     0,     0,     0,  1734,     0,  1734,     0,     0,     0,
       0,  2529,  2789,     0,     0,     0,  1964,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1967,     0,     0,     0,     0,  1968,     0,     0,
     392,   392,   392,     0,  1978,     0,     0,     0,  1967,     0,
       0,     0,     0,  1968,  2790,     0,     0,     0,     0,  2791,
       0,     0,     0,  2430,  1979,  2219,     0,  1980,  1981,  1982,
    1006,  1983,  1984,  1985,  1986,  1987,  1988,     0,  1734,     0,
       0,  2558,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1006,     0,     0,     0,     0,  2792,     0,
       0,     0,  3320,  1734,     0,     0,     0,     0,     0,     0,
       0,     0,  2269,     0,     0,  2793,  2794,  2795,  2796,  2797,
       0,  2798,     0,  2276,  3534,     0,     0,     0,     0,     0,
     392,  1734,  2289,     0,  1979,     0,     0,  1980,  1981,  1982,
       0,  1983,  1984,  1985,  1986,  1987,  1988,  1734,     0,     0,
       0,  3330,     0,     0,  2799,     0,     0,     0,     0, -2293,
       0,  1734,     0,  1970,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1969,  1734,  2529,  2529,  1970,
       0,     0,     0,  1971,  1972,     0,     0,     0,     0,     0,
    2800,     0,     0,  1108,  2528,     0,     0,  1108, -2293,  1971,
    1972,     0,     0,     0,     0,     0,     0,  1108,     0,     0,
    2338,     0,  1734,     0,  1973,     0,     0,     0,  2528,  2528,
       0,     0,     0,     0,     0,  2276,  2801,     0,  2802,     0,
       0,  1006,  3953,     0,  1975,     0,     0,     0,     0,  1108,
       0,     0,     0,     0,     0,     0,     0,     0,  1976,     0,
    1975,  2803,     0,     0,     0,     0,  3967,  3968,  2804,     0,
       0,  2805,     0,     0,  1976,     0,  2419,     0,     0,     0,
    1108,     0,     0,  1734,     0,  2423,     0,     0,     0,  1108,
       0,     0,     0,     0,  2276,  1108,     0,  1108,     0,     0,
       0,     0,  1734,  1108,     0,     0,  1108,  1108,  1108,  1108,
    1108,  1108,  1108,  1108,  1108,  1108,     0,     0,     0,  1108,
    1108,     0,     0,     0,     0,     0,     0,  1734,     0,     0,
   -2293,     0,  1108,  1434,  1434,     0,   392,     0,  1108,     0,
       0,     0,     0,     0,     0,     0,  1978,     0,  1108,     0,
       0,  1108,     0,  1108,     0,     0,     0,     0,     0,     0,
       0,  1734,  1108,  1108,  1108,     0,     0,     0,  1108,     0,
       0,  1108,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1108,     0,     0,  2528,     0,     0,     0,     0,     0,
    1108,     0,  1006,     0,     0,     0,     0,     0,     0,     0,
       0,  1964,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1979,     0,  4059,     0,     0,  1965,     0,  1983,  1984,  1985,
    1986,  1987,  1988,  1967,     0,     0,  1979,     0,  1968,  1006,
   -2293, -2293,  2529,  1983,  1984,  1985,  1986,  1987,  1988,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1006,
       0,  2616,     0,     0,   648,     0,  2529,  2529,     0,   671,
       0,   678,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   678,   392,  1734,   392,     0,  2632,     0,     0,     0,
       0,     0,     0,     0,     0,  2810,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   671,     0,     0,
       0,   392,     0,     0,     0,     0,     0,   678,     0,     0,
       0,     0,     0,     0,     0,     0,   671,   678,     0,     0,
     678,     0,     0,  1964,     0,  2652,   678,     0,     0,  2854,
     678,     0,     0,     0,   937,     0,  2863,  2864,  2865,  2866,
    2867,  2868,     0,     0,     0,     0,     0,  1965,   939,     0,
    1969,   678,     0,     0,  1970,  1967,   946,     0,     0,  2396,
    1968,  1100,     0,     0,     0,     0,     0,   678,     0,     0,
    1100,   956,     0,   937,  1971,  1972,     0,   977,  1108,     0,
       0,     0,     0,  1006,     0,     0,     0,     0,     0,  1973,
       0,  1734,  1006,     0,  1014,     0,     0,     0,     0,     0,
     678,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2529,     0,     0,     0,     0,  2704,     0,     0,
       0,  2707,  1974,     0,     0,  1975,  1734,  1108,  1108,     0,
       0,     0,  1964,     0,     0,     0,  2719,  1100,     0,  1976,
    1006,  1006,  1977,     0,  2731,     0,  1108,  2991,     0,  2993,
       0,  1108,  1006,     0,  1108,     0,  1965,     0,     0,     0,
       0,     0,     0,     0,  1967,     0,  1964,  2745,     0,  1968,
       0,     0,     0,     0,     0,     0,  2765,     0,     0,     0,
       0,     0,  1969,     0,  2766,     0,  1970,     0,     0,     0,
    1965,     0,     0,  1108,     0,     0,     0,     0,  1967,  2783,
       0,  2807,     0,  1968,     0,     0,  1971,  1972,     0,     0,
       0,  1978,     0,     0,     0,     0,     0,     0,     0,  2823,
       0,  1973,     0,     0,     0,     0,  2827,     0,     0,  1108,
       0,     0,     0,  2840,     0,     0,  1108,  1108,     0,  1734,
    2844,     0,     0,     0,  1108,  1108,     0,     0,     0,  1108,
    1734,     0,     0,     0,  1974,  1108,  1108,  1975,     0,  1108,
       0,     0,     0,     0,   678,     0,     0,     0,  1006,     0,
       0,  1976,     0,     0,  1977,     0,     0,     0,     0,  1108,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1969,  2907,  1006,    81,  1970,     0,     0,     0,     0,
       0,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,  1984,
    1985,  1986,  1987,  1988,  1734,  1971,  1972,     0,  3515,     0,
       0,     0,  1734,     0,     0,  1969,  2926,     0,     0,  1970,
    1973,     0,     0,  2944,     0,     0,     0,     0,     0,     0,
       0,     0,  1006,  1978,     0,     0,     0,     0,     0,  1971,
    1972,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1974,  1973,     0,  1975,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1976,     0,     0,  1977,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1974,     0,     0,
    1975,     0,     0,     0,     0,     0,     0,     0,     0,  1108,
       0,     0,     0,     0,  1976,     0,     0,  1977,     0,   392,
       0,  3018,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1979,     0,     0,  1980,  1981,  1982,     0,
    1983,  1984,  1985,  1986,  1987,  1988,     0,     0,  3558,  3018,
    1108,     0,  1978,     0,     0,  1734,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1108,
       0,     0,     0,  1108,     0,     0,     0,     0,  1734,     0,
       0,     0,     0,   671,     0,     0,  1978,     0,     0,     0,
       0,     0,     0,  1006,     0,     0,     0,     0,     0,  1108,
       0,     0,     0,  1734,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1108,  1108,     0,     0,  1108,     0,     0,
     678,   678,     0,     0,  1108,  1108,     0,     0,     0,     0,
       0,     0,  1979,     0,   678,  1980,  1981,  1982,     0,  1983,
    1984,  1985,  1986,  1987,  1988,     0,     0,     0,     0,  3547,
       0,     0,     0,     0,  1734,     0,     0,  1108,  3142,     0,
       0,     0,     0,     0,     0,     0,  1979,     0,     0,  1980,
    1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,     0,
       0,     0,     0,  3565,     0,     0,     0,     0,  1108,     0,
    1964,     0,     0,     0,     0,     0,     0,     0,     0,  1006,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1434,     0,     0,  1965,     0,     0,     0,     0,     0,
       0,     0,  1967,     0,     0,     0,     0,  1968,     0,     0,
       0,     0,     0,  1006,     0,     0,  1108,  1108,     0,     0,
    1006,     0,     0,  1734,     0,     0,     0,     0,  1110,   671,
    1110,  2396,     0,   648,  3213,  1133,     0,   648,   678,     0,
     678,     0,   678,     0,   678,  1110,   648,     0,     0,  1108,
    1734,     0,  1108,     0,  1108,  1155,     0,     0,     0,     0,
       0,     0,     0,   678,     0,     0,   671,     0,  1110,     0,
       0,   648,     0,  1133,     0,   648,  1200,   678,   678,     0,
    1108,     0,   678,  1734,  1110,     0,   648,  1734,  1734,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   678,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   392,     0,   678,     0,  3259,   671,     0,  1108,     0,
     678,     0,  1133,     0,   678,   678,     0,     0,   678,  1969,
     678,     0,   678,  1970,   678,     0,     0,  1110,     0,  1108,
       0,     0,     0,     0,     0,     0,  1734,     0,  4123,     0,
       0,     0,     0,  1971,  1972,     0,     0,     0,     0,   678,
     678,     0,     0,     0,  1108,     0,     0,     0,  1973,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3291,     0,     0,     0,     0,   678,     0,   678,     0,     0,
    1313,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1974,     0,     0,  1975,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   678,  1976,   671,
       0,  1977,     0,  1441,     0,     0,     0,     0,     0,     0,
       0,     0,  1108,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3373,     0,     0,     0,     0,     0,     0,
    1468,     0,     0,  3384,     0,  1006,   678,     0,     0,     0,
       0,  2396,     0,     0,     0,     0,     0,     0,     0,  3397,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1978,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1006,     0,
       0,   648,   648,     0,  1964,     0,     0,  1108,     0,     0,
       0,     0,  3444,     0,   678,  3445,   678,     0,     0,     0,
     678,     0,  3449,     0,     0,  2276,     0,     0,  1965,     0,
       0,     0,     0,     0,     0,     0,  1967,     0,  3453,     0,
       0,  1968,     0,  1110,  1110,     0,     0,     0,     0,     0,
       0,  1434,     0,     0,     0,     0,     0,     0,     0,     0,
    3465,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1979,   678,     0,  1980,  1981,  1982,     0,  1983,  1984,  1985,
    1986,  1987,  1988,     0,   678,     0,     0,  3574,     0,     0,
       0,  1133,     0,   678,     0,     0,     0,     0,     0,   678,
       0,     0,     0,  1110,     0,     0,     0,     0,     0,     0,
     678,     0,  1964,     0,     0,     0,     0,     0,     0,  1110,
    1110,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1965,  1110,  1772,     0,
     678,  1776,     0,     0,  1967,     0,     0,     0,     0,  1968,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3540,
    3541,     0,     0,  1969,     0,  1110,  1110,  1970,     0,   678,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1441,     0,     0,  1971,  1972,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1973,     0,     0,     0,     0,     0,     0,     0,
     678,     0,     0,     0,     0,     0,     0,  1860,  1860,     0,
       0,   877,  1964,   678,   937,     0,     0,     0,     0,   678,
       0,     0,     0,   878,   678,  1974,     0,     0,  1975,     0,
       0,     0,  1892,     0,     0,     0,   678,  3578,  1898,     0,
    1006,     0,  1976,   879,  1967,  1977,     0,     0,     0,  1968,
    1006,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1969,     0,     0,     0,  1970,  1006,   880,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1971,  1972,   881,     0,     0,
       0,  2396,     0,     0,     0,  2396,  3622,     0,  3624,     0,
    1973,     0,     0,     0,     0,     0,     0,     0,   882,     0,
       0,     0,     0,     0,  1978,     0,     0,     0,     0,  1006,
       0,     0,  1006,     0,     0,     0,     0,     0,     0,  1006,
       0,     0,     0,  1974,     0,   883,  1975,  1100,     0,     0,
     884,     0,     0,   671,   671,   885,     0,  3667,     0,     0,
    1976,     0,     0,  1977,     0,     0,     0,     0,  1006,  1441,
     886,     0,     0,     0,     0,  3692,  1441,  1441,     0,     0,
       0,  1969,     0,     0,     0,  1970,     0,  3697,     0,     0,
       0,     0,  2061,     0,  2068,     0,     0,     0,     0,     0,
       0,     0,   678,   678,     0,  1971,  1972,     0,     0,     0,
       0,     0,     0,     0,  1979,     0,  3853,  1980,  1981,  1982,
    1973,  1983,  1984,  1985,  1986,  1987,  1988,     0,     0,     0,
       0,  3772,  1978,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   671,     0,
     648,     0,   887,     0,     0,     0,  1975,     0,     0,     0,
       0,     0,   888,  1964,     0,     0,     0,     0,     0,     0,
    1976,     0,     0,     0,     0,     0,  1006,  1006,  3018,   801,
     678,     0,     0,     0,     0,     0,     0,  1965,     0,     0,
       0,     0,     0,     0,     0,  1967,     0,     0,     0,     0,
    1968,     0,     0,   889,     0,   678,     0,   890,     0,   891,
       0,     0,     0,     0,     0,   892,     0,   893,     0,     0,
       0,     0,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,
    1984,  1985,  1986,  1987,  1988,     0,     0,     0,     0,  3804,
       0,     0,  1978,   894,   895,     0,  1133,     0,   896,     0,
       0,     0,  3805,  3806,  3807,  3808,   897,     0,     0,     0,
       0,   898,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   899,  1964,     0,     0,     0,     0,  1110,  1110,  1110,
    1110,     0,     0,   900,     0,   648,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1772,
       0,     0,     0,     0,  1967,     0,     0,  1110,  1110,  1968,
       0,     0,     0,  1110,     0,     0,  3840,     0,     0,     0,
       0,     0,  1969,     0,     0,     0,  1970,  3849,     0,     0,
       0,     0,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,
    1984,  1985,  1986,  1987,  1988,     0,  1971,  1972,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1973,     0,     0,   678,     0,     0,     0,     0,     0,
       0,     0,   648,     0,  1006,     0,   678,     0,  1110,  1110,
    1110,  1110,     0,     0,     0,     0,     0,   648,     0,     0,
       0,     0,  1006,  1441,  1974,  1772,  3802,  1975,     0,     0,
       0,     0,     0,     0,  1006,     0,     0,     0,     0,     0,
       0,  1976,     0,     0,  1977,     0,     0,  4040,     0,     0,
     671,   678,  4046,  4046,   678,   678,     0,     0,     0,     0,
    1133, -2293,     0,   678,   678,  1970,   678,     0,   678,     0,
       0,     0,     0,   678,     0,   678,   648,     0,     0,     0,
    1110,  1110,     0,     0,  2396,  1971,  1972,     0,     0,  2396,
       0,     0,  2396,     0,     0,   678,   678,     0,     0,     0,
   -2293,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1860,  1978,     0,     0,     0,   678,     0,     0,
     678,   678,  3018,  4085,   678,  4087,     0,     0,     0,     0,
    2464,     0,     0,     0,     0,     0,  1975,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   937,   937,
    1976,     0,  2489,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4115,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1133,     0,     0,     0,
       0,     0,     0,  1964,     0,     0,     0,     0,     0,  1006,
    1006,  1006,  1006,  1979,     0,     0,  1980,  1981,  1982,     0,
    1983,  1984,  1985,  1986,  1987,  1988,     0,  1965,     0,     0,
    3961,     0, -2293,     0,     0,  1967,     0,     0,  4008,  4150,
    1968,     0,     0,     0,     0,     0,     0,     0,  4046,     0,
       0,     0,     0,     0,     0,  1730,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1434,   777,   678,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4174,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4052,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   777,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1979,     0,     0,     0,     0,  2068,     0,  1983,
    1984,  1985,  1986,  1987,  1988,     0,     0,     0,  4074,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   967,     0,     0,     0,
       0,     0,  1969,   967,     0,   967,  1970,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   777,  1730,     0,
       0,     0,     0,     0,     0,     0,  1971,  1972,     0,     0,
       0,     0,     0,     0,     0,   648,     0,     0,  1100,     0,
       0,  1973,     0,     0,     0,     0,     0,   678,     0,     0,
       0,     0,     0,     0,     0,     0,  1964,     0,     0,   648,
     678,  2396,     0,   648,   671,   678,     0,     0,     0,   678,
       0,     0,     0,     0,  1974,   678,     0,  1975,   648,     0,
    1965,   678,     0,     0,     0,     0,   648,   678,  1967,     0,
       0,  1976,   678,  1968,  1977,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   648,
     678,     0,     0,  2748,  2749,   678,   678,   678,   678,  2756,
       0,     0,   678,   678,     0,     0,   648,   678,     0,     0,
     678,     0,     0,     0,     0,  2777,  2777,     0,     0,     0,
       0,   648,     0,   648,   678,     0,     0,     0,     0,     0,
       0,     0,     0,  1110,   678,  1100,   678,     0,     0,     0,
       0,   648,     0,  1978,     0,   678,   678,   678,   648,   678,
       0,     0,     0,     0,     0,   648,   678,   678,     0,     0,
       0,     0,   648,     0,   678,   678,  1100,     0,     0,     0,
       0,     0,     0,     0,     0,  1006,     0,  1110,     0,     0,
       0,     0,     0,     0,  1110,  1110,  1110,  1110,  1110,  1110,
       0,     0,     0,     0,     0,  1969,     0,     0,     0,  1970,
       0,     0,  1006,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1100,     0,     0,  2777,     0,  1971,
    1972,     0,     0,     0,     0,   937,  1006,     0,     0,     0,
       0,     0,     0,  1979,  1973,     0,  1980,  1981,  1982,     0,
    1983,  1984,  1985,  1986,  1987,  1988,     0,     0,     0,  2922,
    3976,     0,     0,  1730,     0,     0,  2936,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1776,  1974,     0,     0,
    1975,     0,     0,     0,  2967,  1006,     0,  1964,  2967,  2980,
       0,     0,     0,     0,  1976,     0,     0,  1977,  2203,     0,
       0,     0,     0,     0,     0,  1110,  2777,  1110,  2777,     0,
       0,  1965,     0,     0,     0,     0,     0,     0,     0,  1967,
    1730,     0,  1441,     0,  1968,     0,  1100,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,     0,     0,
       0,  1860,     0,     0,     0,   678,     0,  1100,     0,     0,
       0,     0,     0,   648,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1978,     0,     0,     0,
       0,  1964,    35,     0,     0,     0,     0,   678,     0,  1730,
      41,   648,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1721,     0,  1965,  1730,     0,  1966,     0,
       0,     0,     0,  1967,     0,     0,     0,     0,  1968,     0,
       0,     0,     0,     0,  1730,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1730,
    1100,     0,     0,     0,     0,     0,  1969,     0,     0,     0,
    1970,     0,     0,     0,     0,  3110,  1979,     0,     0,  1980,
    1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,     0,
    1971,  1972,     0,  4010,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1133,  1973,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1730,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1721,     0,  1974,     0,
       0,  1975,     0,     0,     0,  1100,     0,     0,     0,     0,
    1969,  1441,     0,     0,  1970,  1976,     0,     0,  1977,     0,
       0,     0,  2068,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1971,  1972,     0,     0,     0,     0,
       0,     0,     0,   777,     0,     0,     0,     0,     0,  1973,
       0,  1106,     0,     0,     0,     0,  1106,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   648,   678,   678,     0,
       0,     0,  1974,     0,     0,  1975,  1106,  1978,     0,     0,
       0,  1860,     0,     0,     0,     0,     0,     0,     0,  1976,
     678,     0,  1977,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1964,   678,   678,   678,   678,  1106,     0,     0,     0,
       0,     0,     0,  1106,     0,  1730,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1965,     0,   648,     0,   678,
       0,     0,     0,  1967,     0,     0,     0,     0,  1968,     0,
       0,  1978,     0,     0,     0,   678,     0,  1979,     0,   678,
    1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,
       0,     0,     0,     0,  4111,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1964,     0,     0,     0,     0,     0,     0,     0,   678,     0,
       0,     0,   648,   678,     0,     0,     0,     0,     0,     0,
       0,     0,  2777,  2777,  1965,     0,     0,     0,  2657,  1106,
       0,     0,  1967,     0,     0,   967,     0,  1968,     0,   967,
       0,  1721,     0,     0,     0,     0,    55,     0,     0,  3337,
       0,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,  1984,
    1985,  1986,  1987,  1988,     0,     0,     0,     0,  1106,     0,
       0,     0,     0,     0,     0,     0,  1721,  1964,     0,     0,
    1969,     0,     0,     0,  1970,     0,     0,     0,   678,   678,
       0,     0,     0,     0,     0,     0,     0,     0,  1721,     0,
       0,  1965,     0,     0,  1971,  1972,   678,  2658,     0,  1967,
       0,     0,     0,     0,  1968,  1441,     0,     0,     0,  1973,
       0,     0,     0,   671,     0,     0,   678,  2967,     0,     0,
    3418,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3431,     0,     0,     0,     0,     0,     0,
       0,     0,  1974,   678,     0,  1975,     0,  1721,     0,  1969,
       0,     0,     0,  1970,     0,  2736,   678,   648,     0,  1976,
    2203,  2743,  1977,     0,  1721,     0,     0,   678,     0,     0,
     648,     0,     0,  1971,  1972,     0,     0,  2464,     0,     0,
    3507,     0,  1721,     0,     0,     0,     0,     0,  1973,   678,
       0,     0,   648,     0,     0,  1106,     0,     0,     0,     0,
       0,     0,  1106,     0,     0,     0,  3084,  1721,     0,     0,
       0,  3085,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1974,     0,  1732,  1975,     0,  1969,     0,     0,     0,
    1970,  1978,     0,     0,     0,     0,     0,     0,  1976,     0,
       0,  1977,     0,     0,  3508,     0,     0,     0,     0,     0,
    1971,  1972,     0,  1106,     0,     0,     0,     0,     0,     0,
       0,     0,  1964,  1721,     0,  1973,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1730,     0,     0,
       0,     0,     0,     0,     0,     0,  1965,     0,     0,  3048,
       0,     0,     0,     0,  1967,     0,     0,     0,  1974,  1968,
       0,  1975,     0,     0,     0,     0,     0,  3551,     0,     0,
    1978,  1964,     0,  1106,     0,  1976,     0,     0,  1977,     0,
       0,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,  1984,
    1985,  1986,  1987,  1988,     0,  1965,     0,     0,  2068,  2203,
       0,     0,     0,  1967,     0,     0,  1732,     0,  1968,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2659,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1106,     0,
       0,     0,     0,     0,  1860,  1860,     0,     0,     0,   648,
       0,     0,     0,     0,     0,     0,     0,  1978,     0,     0,
       0,     0,     0,     0,     0,     0,  1106,     0,     0,     0,
    1979,     0,     0,  1980,  1981,  1982,     0,  1983,  1984,  1985,
    1986,  1987,  1988,     0,     0,     0,     0,     0,   678,   678,
       0,  1969,     0,     0,     0,  1970,     0,  1106,  1106,     0,
    1106,     0,     0,  1721,   678,     0,     0,  1730,   648,   678,
     648,   678,   678,   678,   678,  1971,  1972,  1106,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1973,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1969,     0,     0,     0,  1970,     0,     0,  1979,     0,     0,
    1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,
    3337,     0,     0,  1974,  1971,  1972,  1975,     0,     0,  1106,
     777,     0,     0,   678,   678,   678,     0,   678,     0,  1973,
    1976,     0,     0,  1977,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1106,     0,     0,     0,
    1106,  1106,     0,  2922,     0,     0,     0,     0,  2748,     0,
       0,  2748,  1974,  3715,     0,  1975,     0,     0,     0,     0,
       0,     0,     0,  2777,     0,     0,     0,     0,     0,  1976,
       0,     0,  1977,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2967,     0,   678,  3062,     0,     0,     0,     0,
       0,     0,  1978,     0,     0,  2922,     0,  3753,     0,   678,
       0,     0,     0,     0,  2777,     0,  2777,     0,     0,     0,
       0,  1732,     0,     0,     0,   777,     0,     0,     0,   967,
     648,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   967,
       0,  1978,     0,     0,     0,     0,  1732,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1732,     0,
       0,     0,   967,  1721,     0,     0,     0,     0,  1721,  1721,
       0,     0,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,
    1984,  1985,  1986,  1987,  1988,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2203,
    2743,     0,  2743,     0,  3816,     0,     0,     0,     0,  1730,
       0,     0,     0,     0,     0,     0,     0,  1732,  1133,     0,
       0,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,  1984,
    1985,  1986,  1987,  1988,  1732,     0,     0,     0,     0,     0,
    1730,     0,  1730,  3837,     0,     0,  1964,     0,   648,   678,
       0,     0,  1732,     0,     0,     0,     0,     0,     0,   648,
     678,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1965,     0,   678,   678,  1110,   678,     0,  1732,  1967,     0,
       0,     0,   777,  1968,     0,  1721,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1860,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1730,  3337,  3337,  3337,  3337,  3337,
       0,     0,     0,     0,     0,  1106,     0,  1106,     0,     0,
       0,     0,     0,  1732,     0,     0,  1106,     0,     0,  2743,
       0,     0,     0,     0,     0,     0,     0,  1721,     0,     0,
       0,     0,     0,   678,  1964,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2743,     0,     0,
       0,     0,   678,     0,     0,     0,     0,     0,  1965,     0,
    3926,  3092,     0,  1730,     0,     0,  1967,     0,     0,     0,
    3097,  1968,     0,  3934,     0,     0,   678,  1730,     0,     0,
       0,     0,     0,  1106,     0,  1969,  3753,     0,     0,  1970,
       0,     0,  2743,     0,     0,     0,     0,     0,   678,  3715,
       0,     0,     0,     0,   648,     0,     0,     0,     0,  1971,
    1972,     0,     0,     0,     0,     0,     0,     0,  1106,  1106,
       0,     0,     0,     0,  1973,  1721,  1106,     0,  1730,  1106,
       0,     0,  1106,     0,     0,     0,     0,     0,     0,     0,
    1106,  1106,     0,     0,     0,     0,     0,     0,  1106,     0,
       0,  1106,  1106,  1106,  1106,     0,     0,  1974,     0,     0,
    1975,  1106,  1106,     0,  1106,     0,  1106,     0,     0,  1106,
       0,     0,     0,     0,  1976,     0,     0,  1977,  1133,     0,
       0,     0,     0,  1732,  1106,   777,     0,     0,  1106,  1730,
       0,     0,  1106,  1969,     0,     0,  1106,  1970,  1860,  1106,
    1106,  1106,  1106,  1106,  1106,  1106,  1106,  1106,  1730,  1106,
       0,     0,     0,     0,     0,  1106,     0,  1971,  1972,  1106,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2777,
       0,  2748,  1973,  1730,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1978,     0,     0,     0,
       0,     0,  1156,     0,     0,  1110,  3926,     0,     0,     0,
    1110,  1110,     0,     0,     0,  1974,     0,  1730,  1975,     0,
       0,     0,     0,     0,   678,     0,     0,     0,     0,     0,
       0,     0,  1976,     0,  1157,  1977,     0,     0,     0,     0,
    1106,     0,     0,     0,     0,     0,     0,  1158,     0,     0,
       0,     0,     0,     0,  1159,     0,     0,  4068,  1160,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1161,     0,
    1110,  1110,  1110,  1110,   678,     0,  1979,     0,  1964,  1980,
    1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,  1162,
       0,     0,     0,     0,  1978,     0,     0,     0,     0,     0,
       0,     0,  1965,     0,     0,  3101,     0,     0,     0,     0,
    1967,     0,     0,     0,     0,  1968,   777,     0,     0,  3926,
    1110,  1163,     0,     0,     0,     0,     0,  1721,  1721,  2743,
    1721,     0,     0,  1106,     0,     0,     0,  1721,     0,     0,
       0,  1164,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1732,     0,     0,     0,     0,  1732,  1732,
       0,     0,     0,     0,     0,  1165,     0,     0,  1721,     0,
    1721,     0,     0,     0,     0,   678,     0,  1110,     0,     0,
       0,     0,   777,     0,  1979,     0,  1110,  1980,  1981,  1982,
       0,  1983,  1984,  1985,  1986,  1987,  1988,     0,     0,  3934,
       0,     0,     0,     0,     0,  4068,     0,     0,     0,     0,
       0,     0,     0,     0,   777,     0,  1110,     0,     0,     0,
       0,     0,     0,  1166,     0,     0,     0,  4187,  1964,     0,
       0,     0,     0,     0,     0,     0,     0,  1969,     0,     0,
       0,  1970,  1721,     0,     0,     0,     0,  1730,     0,     0,
     801,     0,  1965,     0,     0,     0,     0,     0,     0,     0,
    1967,  1971,  1972,     0,     0,  1968,     0,  1721,     0,     0,
       0,     0,     0,  1106,  1167,  1732,  1973,     0,  1168,     0,
    1169,     0,  2203,  4187,     0,     0,  1170,     0,     0,     0,
       0,     0,     0,     0,     0,  1721,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4187,  1974,
       0,  1721,  1975,     0,  1171,  1172,     0,     0,     0,  1173,
       0,     0,     0,     0,     0,  1721,  1976,  1174,     0,  1977,
       0,     0,  1175,     0,     0,     0,     0,  1732,     0,     0,
    1721,     0,     0,     0,     0,     0,     0,  1106,     0,     0,
       0,     0,     0,     0,  1176,     0,     0,  1106,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1721,   965,     0,     0,
       0,     0,     0,     0,   965,     0,   965,  1969,     0,     0,
       0,  1970,     0,     0,  1106,  1730,     0,     0,  1978,     0,
       0,     0,     0,     0,     0,     0,  1730,     0,     0,     0,
       0,  1971,  1972,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1106,     0,  1973,     0,     0,     0,
       0,     0,     0,     0,  1964,  1732,     0,  1721,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1106,  1106,  1721,     0,  1965,  1974,
       0,  3514,  1975,     0,     0,     0,  1967,     0,     0,     0,
    1730,  1968,     0,     0,     0,     0,  1976,     0,  1730,  1977,
       0,  1721,     0,     0,  1106,  1106,     0,     0,  1979,  1106,
       0,  1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,
    1988,  1106,  1106,  1106,  1106,     0,     0,     0,     0,   777,
       0,     0,     0,  1106,   777,  1721,  1106,     0,  1106,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1106,  1106,
    1964,  1106,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1106,     0,  1106,     0,  1978,     0,
    1106,     0,     0,     0,  1965,     0,     0,     0,     0,     0,
       0,     0,  1967,     0,     0,     0,  1106,  1968,     0,     0,
       0,     0,     0,  3468,     0,     0,     0,  1106,     0,  1106,
    1106,  1106,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1969,     0,     0,     0,  1970,     0,  1106,
       0,     0,     0,     0,     0,     0,     0,     0,  1106,     0,
       0,  3931,     0,     0,     0,  1106,     0,  1971,  1972,     0,
    1106,     0,     0,     0,     0,     0,     0,  1106,  1106,  1106,
       0,     0,  1973,     0,  1730,     0,     0,  1721,  1979,     0,
       0,  1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,
    1988,     0,     0,     0,     0,     0,     0,     0,     0,  1730,
       0,     0,     0,     0,     0,  1974,     0,     0,  1975,     0,
       0,  1106,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1976,     0,     0,  1977,     0,     0,     0,  1969,
       0,     0,     0,  1970,     0,     0,     0,  1732,  1732,     0,
    1732,     0,     0,     0,     0,     0,     0,  1732,     0,     0,
       0,     0,     0,  1971,  1972,     0,     0,     0,     0,     0,
    2743,     0,     0,     0,     0,     0,     0,     0,  1973,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1732,     0,
    1732,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1978,  1721,     0,     0,     0,     0,
       0,  1974,     0,     0,  1975,     0,  1729,     0,     0,     0,
       0,     0,     0,     0,   777,   777,   777,     0,  1976,     0,
       0,  1977,     0,     0,     0,     0,     0,     0,     0,     0,
    1721,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2743,
       0,     0,  1732,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1730,  1732,     0,     0,
       0,     0,     0,     0,  1979,     0,     0,  1980,  1981,  1982,
    1978,  1983,  1984,  1985,  1986,  1987,  1988,     0,     0,     0,
       0,     0,     0,     0,   777,  1732,     0,     0,     0,  1730,
       0,     0,     0,  1730,  1730,     0,     0,     0,     0,     0,
       0,  1732,     0,     0,     0,     0,     0,     0,     0,  1729,
       0,     0,     0,     0,     0,  1732,     0,     0,     0,     0,
       0,     0,     0,  1721,     0,     0,     0,     0,     0,     0,
    1732,     0,     0,     0,  1721,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1106,     0,     0,
       0,  1106,  3931,     0,     0,     0,     0,     0,     0,     0,
    1979,  1106,     0,  1980,  1981,  1982,  1732,  1983,  1984,  1985,
    1986,  1987,  1988,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1104,     0,     0,     0,     0,  1104,     0,     0,
       0,     0,     0,  1106,     0,     0,     0,     0,  1721,     0,
       0,     0,     0,     0,     0,     0,  1721,     0,  1964,     0,
       0,     0,     0,     0,     0,     0,     0,  1104,     0,     0,
       0,     0,     0,     0,  1106,     0,     0,  1732,     0,     0,
       0,     0,  1965,  1106,     0,     0,     0,     0,     0,  1106,
    1967,  1106,     0,     0,     0,  1968,  1732,  1106,     0,  2029,
    1106,  1106,  1106,  1106,  1106,  1106,  1106,  1106,  1106,  1106,
       0,     0,     0,  1106,  1106,     0,     0,  1104,     0,     0,
       0,  1732,     0,     0,  1104,     0,  1106,     0,     0,     0,
     777,     0,  1106,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1106,     0,     0,  1106,     0,  1106,     0,     0,
       0,     0,     0,     0,     0,  1732,  1106,  1106,  1106,     0,
       0,     0,  1106,     0,     0,  1106,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1106,     0,     0,     0,     0,
       0,     0,     0,     0,  1106,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1721,     0,  1729,     0,     0,  1969,     0,     0,
    1104,  1970,     0,     0,     0,     0,   965,     0,     0,     0,
     965,     0,     0,     0,     0,     0,     0,  1721,     0,     0,
       0,  1971,  1972,     0,     0,     0,     0,     0,     0,  1729,
       0,     0,     0,     0,     0,     0,  1973,     0,     0,  1104,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1729,     0,     0,     0,     0,   777,  1732,   777,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1974,
       0,     0,  1975,     0,     0,     0,     0,     0,  1721,     0,
       0,     0,     0,     0,     0,   777,  1976,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1729,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1729,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1729,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1978,     0,
       0,     0,  1106,     0,     0,     0,     0,  1721,     0,     0,
    1729,     0,     0,     0,     0,  1732,  1104,     0,     0,     0,
       0,     0,     0,  1104,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1721,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1731,     0,     0,     0,     0,     0,
    1732,  1106,  1106, -2290,     0,     0,     0,     0,     0,     0,
       0, -2292,     0,     0,     0,     0,  1729,  1721,     0,     0,
    1106,  1721,  1721,     0,  1104,  1106,     0,     0,  1106,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1979,     0,
       0,  1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,
    1988,     0, -2290,     0,     0,     0,     0,     0,     0,     0,
   -2292,     0, -2290,     0,     0,     0, -2290,  1106,     0,     0,
   -2292, -2290,     0,     0, -2292, -2290,     0,     0, -2290, -2292,
   -2290,     0,     0, -2292,  1104,     0, -2292,     0, -2292,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1106,     0,     0, -2290,     0,     0,     0,
    1106,  1106,     0,  1732, -2292,     0,     0,  1731,  1106,  1106,
       0,     0,     0,  1106,  1732,     0, -2290,     0,     0,  1106,
    1106,     0,     0,  1106, -2292,     0,     0,     0,     0,  1104,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1106,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1104,     0,     0,
   -2290,     0,     0,     0,     0,     0,     0,     0, -2292, -2290,
       0,     0,     0,     0,     0,     0,  1729, -2292,  1732,     0,
       0,     0,     0,     0,     0,     0,  1732,     0,  1104,  1104,
       0,  1104,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1104,     0,
       0,     0, -2290,     0,     0,     0,     0,     0,     0,     0,
   -2292,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   942,     0,     0,     0,
    1104,     0,     0,     0,   942,     0,     0,     0,     0,   677,
       0,     0,     0,  1106,     0,     0,     0,     0, -2290,   680,
       0,     0,     0,   777,     0,     0, -2292,  1104,     0,     0,
       0,  1104,  1104,     0,     0,     0,     0,     0,     0, -2290,
       0, -2290, -2290,     0,     0,     0,     0, -2292,     0, -2292,
   -2292,     0,     0,     0,  1106,   818,     0,     0,     0,  1732,
       0,     0,     0,     0,     0,   867,     0,     0,   871,     0,
       0,     0,     0,  1106,   867,     0,     0,  1106,   926,     0,
       0, -2290,  1732,     0, -2290, -2290,     0, -2290,     0, -2292,
       0,     0, -2292, -2292,     0, -2292,     0,     0,     0,   945,
       0,     0,  1731,  1106,     0,     0,     0,  1732,     0,     0,
     965,     0,     0,     0,     0,   867,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1106,  1106,     0,
     965,  1106,     0,     0,     0,     0,     4,  1731,  1106,  1106,
       0,     0,     0,     0,     0,     0,  1729,     0,  1024,     0,
       0,  1729,  1729,     0,     0,     0,     5,     0,     0,  1731,
       0,     0,     0,   965,     0,     0,     6,     7,  1732,     0,
       0,  1106,     8,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,  1106,    35,     0,    36,     0,    37,    38,    39,
      40,    41,     0,     0,     0,     0,     0,     0,  1731,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1731,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1106,  1106,     0,  1731,    42,     0,     0,  1732,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1729,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1731,     0,
       0,     0,     0,  1106,  1732,     0,  1106,     0,  1106,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1070,     0,  1106,     0,     0,  1732,     0,     0,
       0,  1732,  1732,     0,     0,    43,  1104,     0,  1104,     0,
    1729,     0,     0,     0,  1731,     0,     0,  1104,     0,    44,
       0,     0,     0,     0,     0,   777,     0,     0,     0,     0,
       0,     0,  1106,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1106,     0,     0,     0,     0,     0,    46,
    1732,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1106,     0,
       0,     0,     0,     0,  1104,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1729,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,  1104,
    1104,     0,     0,     0,     0,     0,     0,  1104,     0,     0,
    1104,     0,     0,  1104,     0,     0,     0,     0,     0,     0,
       0,  1104,  1104,     0,     0,     0,  1106,     0,     0,  1104,
       0,     0,  1104,  1104,  1104,  1104,     0,     0,     0,     0,
       0,     0,  1104,  1104,     0,  1104,     0,  1104,     0,     0,
    1104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1731,  1104,     0,     0,     0,  1104,
      50,     0,     0,  1104,     0,     0,     0,  1104,     0,     0,
    1104,  1104,  1104,  1104,  1104,  1104,  1104,  1104,  1104,     0,
    1104,     0,     0,     0,     0,     0,  1104,     0,     0,     0,
    1104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      51,  1106,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    52,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    53,     0,  1078,  1079,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1070,     0,     0,     0,     0,     0,     0,     0,
       0,    54,     0,     0,     0,     0,     0,    55,    56,    57,
       0,  1104,     0,    58,     0,    59,     0,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,    67,    68,
       0,    69,    70,    71,    72,    73,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1729,  1729,     0,  1729,     0,     0,     0,     0,   827,     0,
    1729,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     828,     0,     0,     0,  1104,     0,  1135,     0,  1137,     0,
    1139,     0,  1141,     0,     0,     0,     0,     0,     0,     0,
     829,  1729,     0,  1729,  1731,     0,     0,     0,     0,  1731,
    1731,  1183,     0,     0,     0,     0,     0,     0,     0,     0,
     830,     0,     0,     0,  -583,  1201,  1202,     0,     0,     0,
    1204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   831,     0,     0,  1070,     0,   867,
     832,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1229,     0,     0,     0,   833,     0,     0,     0,     0,
       0,     0,     0,  1248,     0,  1729,  1250,     0,  1252,     0,
    1255,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   834,     0,     0,     0,     0,  -746,   835,     0,
    1729,     0,   836,     0,     0,     0,     0,  1286,  1287,     0,
       0,     0,     0,     0,     0,     0,     0,  -725,     0,     0,
       0,     0,     0,     0,  1104,  1723,  1731,     0,  1729,     0,
       0,     0,     0,  1310,     0,  1311,     0,     0,     0,     0,
    -447,     0,     0,     0,  1729,     0,     0,     0,     0,     0,
       0,     0,     0,   837,     0,     0,     0,     0,  1729,     0,
       0,     0,     0,     0,     0,  1070,     0,     0,     0,     0,
       0,     0,     0,  1729,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1731,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1104,   838,
       0,     0,   839,     0,  1024,     0,     0,     0,  1104,  1729,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -447,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1104,     0,     0,  1723,     0,
     840,     0,     0,     0,  -746,     0,   841,     0,     0,     0,
       0,     0,     0,     0,   842,     0,     0,     0,     0,     0,
    1729,     0,  1554,     0,  1556,  1104,     0,     0,  1558,     0,
       0,     0,     0,     0,     0,     0,  1731,     0,     0,  1729,
       0,   843,   844,     0,   845,   846,     0,     0,     0,     0,
       0,     0,     0,   847,     0,  1104,  1104,   848,   849,     0,
       0,     0,     0,   850,  1729,     0,     0,     0,   851,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1667,
       0,     0,     0,     0,     0,  1104,  1104,     0,     0,     0,
    1104,     0,  1679,     0,     0,     0,     0,     0,  1729,     0,
       0,  1685,  1104,  1104,  1104,  1104,     0,  1687,     0,     0,
       0,     0,     0,     0,  1104,     0,     0,  1104,  1735,  1104,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1104,
    1104,     0,  1104,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1104,     0,  1104,  1774,     0,
       0,  1104,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1104,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1104,     0,
    1104,  1104,  1104,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1104,     0,     0,     0,     0,     0,     0,     0,     0,  1104,
       0,     0,     0,     0,     0,     0,  1104,     0,  1850,     0,
    1729,  1104,     0,     0,     0,     0,     0,     0,  1104,  1104,
    1104,     0,     0,     0,     0,     0,     0,  1881,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1723,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1104,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1723,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1731,  1731,
       0,  1731,     0,     0,     0,     0,     0,     0,  1731,     0,
    1723,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1729,  1731,
       0,  1731,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1723,
       0,     0,     0,  1729,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1723,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1723,     0,     0,     0,     0,     0,
    1024,     0,     0,  1731,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1723,
       0,     0,     0,     0,     0,     0,     0,     0,  1731,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1731,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1731,     0,     0,  1723,  1729,     0,  2146,     0,
       0,     0,     0,     0,     0,     0,  1731,  1729,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1731,     0,  2177,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1104,     0,
       0,     0,  1104,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1104,     0,     0,     0,     0,  1731,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1729,     0,     0,     0,     0,     0,     0,     0,  1729,
       0,     0,     0,     0,  1104,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1104,     0,     0,  1731,     0,
       0,     0,     0,     0,  1104,     0,     0,     0,     0,     0,
    1104,     0,  1104,     0,     0,     0,     0,  1731,  1104,     0,
       0,  1104,  1104,  1104,  1104,  1104,  1104,  1104,  1104,  1104,
    1104,     0,     0,     0,  1104,  1104,     0,     0,     0,     0,
       0,     0,  1731,     0,     0,  1723,     0,  1104,     0,     0,
       0,     0,     0,  1104,     0,     0,     0,     0,     0,     0,
       0,     0,  2329,  1104,     0,     0,  1104,     0,  1104,     0,
       0,     0,     0,     0,  2351,     0,  1731,  1104,  1104,  1104,
       0,     0,     0,  1104,     0,     0,  1104,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1104,     0,     0,     0,
       0,     0,     0,     0,     0,  1104,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1729,     0,     0,     0,  2405,
       0,     0,     0,  2409,     0,     0,     0,     0,     0,     0,
       0,     0,  2418,     0,  2420,     0,  2421,     0,     0,     0,
    1729,  2422,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2439,   867,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1107,     4,     0,     0,     0,
    1107,     0,     0,     0,     0,     0,     0,     0,  1731,     0,
       0,  1729,     0,     0,     0,     0,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     0,     0,
    1107,     0,     0,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,     0,    35,     0,     0,     0,    37,    38,    39,
      40,    41,     0,     0,     0,     0,     0,     0,     0,     0,
    1107,     0,     0,     0,     0,  1723,     0,  1107,     0,     0,
    1723,  1723,     0,     0,     0,     0,     0,     0,     0,     0,
    1729,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1104,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1731,  1729,     0,     0,
       0,     0,     0,     0,     0,  2626,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1729,  1731,  1104,  1104,  1729,  1729,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1104,     0,  1107,     0,    43,  1104,     0,     0,  1104,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    44,
       0,     0,     0,     0,     0,     0,     0,  1723,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    45,     0,
       0,     0,  1107,     0,     0,     0,     0,     0,  1104,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1104,     0,     0,     0,     0,  1723,
       0,  1104,  1104,    47,  1731,  1070,    48,     0,     0,  1104,
    1104,     0,     0,     0,  1104,  1731,     0,     0,  2705,     0,
    1104,  1104,     0,  2709,  1104,     0,     0,  2713,    49,     0,
       0,     0,     0,  2717,     0,     0,     0,     0,     0,  2722,
       0,     0,     0,     0,  1104,  2732,     0,     0,     0,     0,
    2734,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2750,  2751,  2754,  2755,     0,     0,  1731,
    2761,  2764,  1404,     0,     0,  2767,     0,  1731,  2771,  1107,
       0,     0,     0,     0,     0,     0,  1107,  1723,     0,     0,
      50,     0,  2808,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2811,     0,  2813,     0,     0,  1733,     0,     0,
       0,  1473,     0,  2824,  2825,  2826,     0,  2828,     0,     0,
       0,     0,     0,     0,  2841,  2842,     0,     0,     0,     0,
      51,     0,  2845,  2846,     0,     0,     0,  1107,     0,     0,
       0,     0,     0,    52,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    53,     0,     0,     0,
       0,     0,     0,     0,  1104,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    54,     0,     0,     0,     0,     0,    55,    56,    57,
       0,     0,     0,    58,     0,    59,     0,  1107,     0,    60,
      61,    62,    63,    64,     0,  1104,    65,    66,  1263,     0,
    1731,     0,     0,    71,  1264,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1104,     0,     0,     0,  1104,     0,
    1733,     0,     0,  1731,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1107,     0,  1104,     0,     0,     0,  1731,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1104,  1104,
    1107,     0,  1104,     0,     0,     0,     0,     0,     0,  1104,
    1104,     0,     0,     0,  1070,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1107,  1107,     0,  1107,     0,     0,     0,     0,  1731,
       0,     0,  1104,     0,     0,     0,     0,     0,     0,     0,
       0,  1107,     0,     0,     0,  3033,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1723,
    1723,     0,  1723,  1104,     0,     0,     0,     0,     0,  1723,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1107,     0,     0,     0,     0,     0,     0,
    1723,     0,  1723,     0,     0,     0,     0,     0,     0,     0,
       0,  1104,  1104,     0,     0,     0,     0,     0,  1731,     0,
    1107,     0,     0,     0,  1107,  1107,     0,     0,     0,     0,
       0,  1905,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1104,  1731,     0,  1104,     0,  1104,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1928,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1723,  1104,     0,     0,  1731,     0,
       0,     0,  1731,  1731,     0,     0,     0,     0,     0,     0,
    1952,  1953,     0,  1956,     0,  1733,     0,     0,     0,  1723,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1994,     0,     0,  1104,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1723,     0,     0,
    1733,     0,     0,     0,  1104,     0,     0,     0,     0,     0,
       0,  1731,     0,  1723,     0,     0,     0,     0,     0,     0,
       0,     0,  1733,     0,     0,     0,     0,  1723,     0,  1104,
       0,     0,  2052,     0,     0,  3214,  3215,     0,     0,     0,
       0,     0,  1723,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3226,  2081,
       0,     0,     0,  2091,  2094,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1723,     0,
       0,  1733,     0,     0,     0,     0,     0,     0,     0,     0,
    3242,  3243,  3244,  3245,     0,     0,     0,  1104,  1733,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1733,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1723,
       0,  1733,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1723,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3290,     0,     0,     0,
       0,  3292,  1104,  1723,     0,     0,     0,     0,     0,  1107,
       0,  1107,     0,     0,     0,     0,     0,  1733,     0,     0,
    1107,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1723,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3380,   867,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,     0,     0,
       0,     0,     0,     0,  3226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   867,     0,     0,     0,     0,     0,
       0,     0,  1107,  1107,     0,     0,     0,     0,  1724,     0,
    1107,     0,     0,  1107,     0,     0,  1107,     0,     0,     0,
       0,  3437,     0,     0,  1107,  1107,     0,     0,     0,     0,
       0,     0,  1107,     0,  3446,  1107,  1107,  1107,  1107,  1723,
       0,     0,     0,     0,     0,  1107,  1107,     0,  1107,     0,
    1107,     0,     0,  1107,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1733,  1107,     0,
       0,     0,  1107,     0,     0,     0,  1107,     0,     0,     0,
    1107,     0,     0,  1107,  1107,  1107,  1107,  1107,  1107,  1107,
    1107,  1107,     0,  1107,     0,     0,     0,     0,     0,  1107,
       0,     0,     0,  1107,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1724,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1723,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1107,     0,     0,     0,     0,  2499,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1723,     0,     0,     0,     0,     0,     0,     0,
       0,  2521,     0,     0,  2523,     0,     0,  2534,     0,     0,
       0,     0,     0,     0,  2541,  2546,     0,     0,     0,  2551,
       0,     0,  2556,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2565,     0,     0,
       0,  2571,     0,     0,     0,  2583,     0,     0,     0,  2590,
       0,     0,  2592,  2593,  2594,  2595,  2596,  2597,  2598,  2599,
    2600,     0,  2601,     0,     0,     0,  1726,     0,  1404,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1733,     0,     0,
       0,     0,  1733,  1733,     0,  1723,     0,     0,     0,     0,
       0,     0,  3616,     0,  1727,     0,  1723,  3623,     0,  3625,
    3626,  3627,  3628,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1473,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1723,  3679,  3681,  3683,     0,  3685,  1724,     0,  1723,  1726,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,     0,  1733,
       0,  1724,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1728,     0,  1727,     0,     0,
       0,     0,     0,  1724,     0,     0,  2720,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3755,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1733,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1107,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1107,  1724,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1724,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1724,  1107,     0,
       0,     0,     0,     0,  1723,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1728,     0,
       0,     0,  1724,     0,     0,     0,     0,     0,  1107,  1723,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1733,
       0,     0,     0,     0,     0,     0,  2879,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1107,  1107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1724,     0,
       0,     0,     0,     0,     0,     0,     0,  3841,  1107,  1107,
    1723,     0,     0,  1107,     0,     0,     0,     0,  3850,     0,
       0,     0,     0,     0,  1726,  1107,  1107,  1107,  1107,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,     0,     0,
    1107,     0,  1107,     0,     0,     0,     0,     0,     0,     0,
    2984,     0,  1107,  1107,     0,  1107,     0,     0,     0,  1726,
       0,     0,     0,     0,     0,     0,     0,     0,  1107,     0,
    1107,     0,  1727,     0,  1107,     0,     0,     0,     0,     0,
       0,  1726,     0,     0,     0,     0,     0,  3005,     0,     0,
    1107,     0,     0,     0,     0,     0,     0,     0,     0,  1723,
       0,  1107,     0,  1107,  1107,  1107,     0,  1727,     0,     0,
       0,  3897,     0,     0,     0,     0,     0,  1404,     0,     0,
       0,     0,     0,  1107,     0,     0,  1723,     0,     0,  1727,
    3914,     0,  1107,     0,     0,     0,     0,     0,     0,  1107,
    1726,     0,     0,     0,  1107,     0,     0,     0,  3044,     0,
       0,  1107,  1107,  1107,     0,     0,     0,  1726,     0,  1723,
       0,     0,     0,  1723,  1723,     0,     0,     0,  1724,     0,
       0,     0,     0,     0,     0,  1726,  3948,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1727,     0,
       0,     0,     0,  1728,  2546,  1107,  2546,  2546,     0,     0,
    1726,     0,     0,     0,     0,  1727,  3104,     0,     0,  3107,
       0,  3109,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1733,  1733,  1727,  1733,     0,     0,     0,  1728,     0,
       0,  1733,     0,     0,     0,     0,     0,  3130,     0,  3132,
       0,     0,     0,  3135,     0,     0,     0,     0,  1727,     0,
    1728,     0,     0,     0,     0,     0,  1726,     0,     0,     0,
       0,     0,  1733,     0,  1733,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3150,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3180,     0,     0,     0,     0,     0,     0,     0,
       0,  1473,     0,     0,  1727,     0,     0,     0,  2081,  1728,
       0,     0,     0,  3194,     0,     0,     0,     0,     0,     0,
    2094,  2094,  2091,     0,     0,     0,  1728,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1733,     0,     0,     0,
       0,     0,     0,     0,  1728,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1733,     0,     0,  3217,     0,     0,     0,     0,  1728,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1733,
       0,     0,     0,     0,     0,     0,     0,     0,  1724,     0,
       0,     0,     0,  1724,  1724,  1733,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1733,
       0,     0,     0,     0,     0,  1728,  1726,     0,     0,     0,
       0,     0,     0,     0,  1733,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1107,     0,     0,     0,  1107,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1107,     0,     0,     0,     0,
    1733,     0,     0,     0,  1727,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4149,     0,     0,     0,     0,     0,     0,
    1724,     0,     0,     0,     0,     0,     0,     0,  1107,     0,
       0,  1733,     0,     0,     0,     0,     0,  1107,     0,     0,
       0,     0,     0,  1107,     0,  1107,     0,     0,     0,     0,
    1733,  1107,     0,     0,  1107,  1107,  1107,  1107,  1107,  1107,
    1107,  1107,  1107,  1107,     0,     0,     0,  1107,  1107,     0,
       0,     0,     0,     0,     0,  1733,     0,     0,     0,     0,
    1107,     0,  1724,     0,     0,     0,  1107,     0,     0,     0,
       0,     0,     0,     0,     0,  1728,  1107,     0,     0,  1107,
       0,  1107,     0,     0,     0,     0,     0,     0,     0,  1733,
    1107,  1107,  1107,     0,     0,     0,  1107,     0,     0,  1107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1107,
       0,     0,     0,     0,     0,     0,     0,     0,  1107,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1726,     0,     0,     0,
       0,  1726,  1726,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1724,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3469,     0,     0,
       0,     0,     0,     0,  1727,     0,  3472,     0,     0,  1727,
    1727,     0,  3473,     0,  3474,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1733,     0,     0,     0,     0,  3492,  3493,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2551,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3518,     0,     0,  3521,     0,
    3523,     0,     0,     0,     0,     0,     0,     0,  1726,  3527,
       0,     0,     0,     0,     0,  3532,     0,     0,  3535,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3542,     0,
       0,     0,     0,     0,     0,     0,     0,  3005,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1728,  1727,     0,     0,     0,
    1728,  1728,     0,     0,     0,     0,  1107,     0,     0,     0,
    1726,     0,     0,     0,     0,     0,     0,     0,     0,  1733,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1733,  1107,  1107,     0,  1727,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1107,     0,     0,     0,     0,  1107,
       0,     0,  1107,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1726,     0,
       0,     0,  1724,  1724,     0,  1724,     0,  1728,     0,     0,
       0,  1107,  1724,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1724,     0,  1724,  1727,  1107,     0,     0,
       0,     0,     0,     0,  1107,  1107,     0,  1733,     0,     0,
       0,     0,  1107,  1107,     0,     0,     0,  1107,  1733,  1728,
       0,     0,     0,  1107,  1107,     0,     0,  1107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3727,  3728,     0,  1724,     0,     0,
       0,     0,     0,     0,     0,  1990,     0,     0,     0,     0,
       0,     0,  1733,     0,     0,     0,     0,     0,     0,     0,
    1733,     0,  1724,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1728,     0,     0,
    1724,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3770,     0,     0,     0,     0,     0,  1724,     0,     0,     0,
       0,     0,     0,     0,  1990,     0,     0,     0,     0,     0,
    1724,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1724,     0,     0,     0,     0,
       0,     0,     0,  3786,  3788,     0,     0,  1107,     0,     0,
       0,     0,     0,     0,     0,     0,  3795,     0,     0,     0,
       0,     0,  3800,  3801,     0,     0,  3803,     0,     0,     0,
       0,  1724,     0,     0,     0,     0,     0,     0,     0,     0,
    1726,  1726,     0,  1726,     0,     0,  3817,     0,  1107,     0,
    1726,     0,     0,  1733,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,     0,     0,
       0,  1107,     0,     0,     0,     0,  1733,     0,     0,     0,
       0,  1726,     0,  1726,     0,     0,     0,     0,  1727,  1727,
       0,  1727,  1724,     0,     0,     0,     0,  1107,  1727,     0,
       0,  1733,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1724,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1107,  1107,     0,     0,  1107,     0,     0,     0,  1727,
       0,  1727,  1107,  1107,     0,     0,  1724,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1726,     0,     0,     0,     0,
       0,     0,  1733,     0,     0,  1107,     0,     0,     0,     0,
    1724,     0,     0,     0,     0,     0,  3885,     0,     0,     0,
    1726,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1107,     0,     0,     0,
       0,     0,     0,  1727,     0,     0,     0,     0,  1726,  1728,
    1728,     0,  1728,     0,     0,     0,     0,     0,     0,  1728,
       0,     0,     0,     0,  1726,     0,     0,     0,  1727,     0,
       0,     0,     0,     0,     0,     0,  3938,     0,  1726,     0,
       0,     0,     0,     0,  1107,  1107,     0,     0,     0,     0,
    1728,  1733,  1728,  1726,     0,     0,  1727,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1727,     0,     0,     0,     0,  1107,  1733,     0,
    1107,     0,  1107,     0,     0,     0,  1727,     0,     0,  1726,
       0,     0,  1724,     0,  3969,     0,     0,     0,     0,     0,
       0,  1727,  3971,     0,     0,     0,     0,     0,  1107,     0,
       0,  1733,     0,     0,     0,  1733,  1733,     0,     0,     0,
       0,     0,     0,     0,  1728,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1990,     0,  1727,     0,     0,
       0,     0,     0,     0,     0,     0,  1107,     0,     0,  1728,
    1726,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,     0,  1726,
       0,     0,     0,     0,  1733,     0,     0,  1728,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1107,  1728,  1726,     0,     0,     0,  1727,     0,
       0,     0,     0,     0,     0,     0,  1990,  1728,     0,     0,
    1724,     0,     0,     0,  4042,     0,     0,  1727,     0,     0,
       0,     0,  1728,     0,     0,     0,     0,     0,  1726,  1990,
       0,     0,     0,     0,  2530,     0,     0,     0,     0,     0,
       0,     0,  1727,     0,     0,  1724,     0,     0,     0,  2551,
       0,     0,     0,  1990,  1990,     0,     0,  1990,  1728,     0,
    1107,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1727,  4076,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1990,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1728,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1728,     0,
       0,     0,     0,     0,     0,  1107,     0,     0,     0,     0,
    1726,     0,     0,  1990,     0,     0,     0,     0,  1724,     0,
       0,     0,     0,  1728,     0,     0,     0,     0,     0,  1724,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1990,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1990,     0,     0,  1990,     0,  1728,  1727,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1724,     0,     0,     0,     0,     0,     0,
       0,  1724,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1726,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1726,     0,     0,     0,     0,     0,     0,
       0,     4,     0,     0,     0,     0,  1727,     0,     0,  1728,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,     0,     0,     9,
      10,  1727,     0,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,     0,    35,     0,
       0,     0,    37,    38,    39,    40,    41,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1724,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1726,     0,     0,     0,
       0,     0,  1724,     0,     0,     0,     0,  1726,     0,    42,
       0,     0,     0,     0,     0,     0,     0,  1728,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1727,     0,     0,     0,     0,     0,
       0,     0,  1728,     0,     0,  1727,     0,     0,     0,     0,
       0,     0,     0,  1724,     0,     0,     0,     0,     0,     0,
       0,  1726,     0,     0,     0,     0,     0,     0,     0,  1726,
      43,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,     0,  1727,
       0,     0,     0,     0,     0,     0,     0,  1727,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1724,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1728,     0,     0,    47,     0,
       0,    48,     0,     0,     0,     0,  1728,     0,     0,  1724,
    1990,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    49,     0,     0,     0,     0,     0,     0,
       0,     0,  1990,     0,  1990,     0,  2530,  2530,  3080,     0,
       0,  2530,  1724,     0,     0,  1990,  1724,  1724,     0,     0,
       0,     0,  1990,     0,     0,     0,     0,  1990,     0,     0,
       0,     0,  1990,     0,     0,  1726,     0,  1990,     0,     0,
    1728,     0,     0,     0,     0,     0,  1990,     0,  1728,     0,
    2530,  2530,  1990,     0,     0,     0,     0,     0,     0,     0,
    1726,     0,     0,     0,  1990,    50,     0,     0,     0,     0,
       0,  1990,     0,  1990,  1990,  1990,  1990,  1990,  1990,  1990,
    1990,  1990,  1990,  1727,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    51,     0,     0,  1727,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    52,     0,
       0,  1726,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    53,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    54,     0,     0,     0,
       0,     0,    55,    56,    57,     0,     0,     0,    58,  1727,
      59,     0,     0,     0,    60,    61,    62,    63,    64,     0,
       0,    65,    66,  1263,  1828,     0,     0,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1990,     0,     0,  1728,     0,     0,     0,     0,     0,
    1726,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1728,
       0,     0,     0,     0,     0,     0,     0,  1726,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1727,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1726,     0,     0,     0,  1726,  1726,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1727,     0,     0,     0,     0,
    1728,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1727,     0,
       0,     0,  1727,  1727,    85,     0,     0,     0,     0,     0,
      89,     0,     0,     0,    93,     0,    94,     0,    96,    97,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   106,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1990,     0,     0,     0,     0,     0,   119,   120,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1728,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   128,     0,     0,     0,  1728,     0,     0,     0,
       0,     0,   129,     0,   130,   131,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1039,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1728,
       0,     0,     0,  1728,  1728,     0,     0,     0,   141,     0,
     142,   143,     0,     0,     0,   145,   146,     0,     0,     0,
       0,     0,     0,     0,     0,  1990,   147,     0,   148,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   151,  1990,   152,     0,     0,
     155,     0,     0,     0,     0,     0,   156,     0,     0,     0,
       0,     0,   157,     0,     0,     0,     0,     0,   158,     0,
       0,     0,     0,     0,   159,     0,     0,     0,     0,     0,
     161,     0,   163,     0,     0,  1990,     0,   165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     169,     0,     0,     0,     0,     0,  3080,  3080,     0,  2530,
       0,     0,  2530,  2530,  2530,  2530,  2530,  2530,  2530,  2530,
    2530,  2530,  3080,     0,     0,     0,     0,   174,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1990,     0,     0,  1990,     0,
    1990,     0,   183,   184,     0,  3080,  3080,     0,   185,     0,
       0,     0,     0,     0,     0,     0,     0,   186,     0,  2530,
    2530,  1990,     0,  1990,     0,     0,  1990,     0,     0,     0,
       0,     0,     0,     0,     0,   191,     0,     0,     0,     0,
       0,  1990,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1990,   202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   204,     0,  1990,     0,   205,     0,   206,
       0,     0,     0,     0,   207,     0,     0,     0,     0,   208,
       0,     0,   210,     0,     0,     0,   212,     0,  1990,     0,
       0,     0,   213,     0,     0,     0,     0,     0,   214,     0,
       0,   216,     0,     0,     0,     0,     0,     0,   219,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   221,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   226,     0,   227,
       0,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,     0,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   235,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   244,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    86,    87,    88,  2530,    90,    91,    92,     0,     0,
       0,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,     0,     0,     0,   107,   108,   109,   110,
       0,   111,   112,   113,   114,   115,     0,   116,   117,   118,
       0,     0,     0,     0,     0,   121,   122,     0,     0,     0,
       0,   123,     0,     0,     0,     0,     0,     0,     0,     0,
     124,     0,   125,     0,   126,     0,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,     0,     0,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
    1990,     0,     0,  1990,  1990,  1990,   144,     0,  3080,     0,
       0,     0,     0,  3080,  3080,  3080,  3080,  3080,  3080,  3080,
    3080,  3080,  3080,  1990,  1990,     0,   149,     0,     0,     0,
       0,     0,   150,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   153,   154,     0,     0,     0,     0,     0,  1990,
    2530,  2530,  1990,     0,  1990,     0,     0,     0,  1990,  3080,
    3080,     0,     0,  1990,     0,     0,  1990,     0,     0,   160,
       0,     0,     0,  1990,     0,   162,     0,     0,   164,     0,
       0,     0,     0,   166,     0,     0,     0,     0,     0,   167,
       0,   168,     0,     0,     0,     0,   170,     0,     0,     0,
       0,     0,     0,     0,     0,   171,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   172,   173,     0,
       0,     0,     0,     0,   175,     0,   176,     0,     0,   177,
     178,     0,   179,     0,     0,     0,     0,     0,     0,     0,
       0,   180,   181,     0,   182,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   187,   188,   189,     0,     0,     0,
       0,     0,     0,     0,     0,   190,     0,     0,     0,     0,
     192,     0,     0,   193,     0,   194,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   195,
     196,   197,   198,   199,     0,     0,     0,     0,     0,     0,
       0,     0,   200,     0,   201,     0,     0,  3080,     0,     0,
       0,     0,     0,     0,     0,     0,   203,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   209,     0,     0,   211,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1990,  1990,
       0,     0,     0,   215,     0,     0,   217,     0,   218,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     220,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   222,   223,     0,     0,     0,   224,     0,   225,
       0,  1990,     0,     0,     0,  2530,     0,   228,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1990,     0,  1990,
     233,     0,     0,   234,  3080,  3080,  1990,     0,     0,  2530,
    2530,  1990,  1990,     0,  1990,     0,     0,   236,   237,   238,
     239,   240,   241,   242,   243,     0,     0,     0,  1990,     0,
       0,    55,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2679,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1990,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1990,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3080,  2530,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3080,  3080,
    1990,     0,  1990,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   681,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   682,   104,   105,
     403,   683,     0,   107,   108,   109,   110,   684,   685,   112,
     113,   114,   115,  1990,   116,   686,   687,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
    3080,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,  1990,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,   688,   422,   423,   424,   689,   690,   691,   692,   693,
     694,   695,   425,   426,   696,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,   697,   431,   432,     0,   433,
     434,   698,   699,     0,   435,   700,   140,   437,   701,   438,
     439,   440,   441,   144,   702,   703,   442,   443,   444,   445,
     446,   447,   704,   448,   449,   450,   451,   452,   453,   705,
     454,   455,   456,   149,   457,     0,   706,   707,   708,   150,
     709,   710,   711,   458,   459,   460,   461,   462,   463,   153,
     154,   464,   712,   465,   713,   466,     0,   467,   468,   469,
     714,   470,   471,   472,   715,   716,   473,   474,   475,   476,
     477,   717,   478,   479,   480,   718,     0,   481,   719,   482,
     483,   484,   162,   485,   486,   164,   720,   487,   721,   488,
     166,     0,   722,   489,   723,   490,   167,   724,   168,   491,
     492,   725,   493,   170,   726,   494,   727,   495,   496,   497,
     498,   499,   171,   500,   501,   502,   728,   503,   504,   505,
     506,   507,   508,   729,   172,   173,   730,   509,   510,   511,
     731,   175,   732,   176,   733,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,   734,   180,   181,
     520,   182,   735,   521,   522,   523,   736,   737,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,   188,   189,   738,   537,   538,   539,   540,   541,
     542,   543,   190,   544,   739,   545,   546,   192,   547,   740,
     193,   548,   194,   549,   550,   741,   742,   551,   743,   744,
     745,   552,   553,     0,   746,   747,   195,   196,   197,   198,
     199,   554,   555,   556,   557,     0,   558,   748,   559,   200,
       0,   201,   560,   561,   562,   749,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,   750,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,   751,   582,
     583,   209,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,   752,   593,   594,     0,   595,   753,   596,
     215,   597,   598,   217,   599,   218,   754,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,   755,
     611,   612,   756,   613,   614,   615,   616,   617,   757,   222,
     223,   758,   759,   619,   224,   620,   225,   760,   621,   622,
     623,     0,   624,   625,   761,   762,   626,   627,   628,   629,
     763,   764,   630,   631,   632,   633,     0,   233,   765,   635,
     234,   636,   637,   638,   766,   767,   639,   768,   769,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    85,
       0,     0,    86,    87,    88,    89,    90,    91,    92,    93,
       0,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   106,   904,     0,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115,     0,   116,   117,
     118,   119,   120,     0,     0,     0,   121,   122,     0,     0,
       0,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   125,     0,   126,   127,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   128,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   129,     0,   130,
     131,     0,     0,     0,     0,     0,     0,     0,     0,   132,
     133,     0,     0,   134,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,   141,     0,   142,   143,   144,     0,     0,
     145,   146,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   147,     0,   148,     0,     0,     0,   149,     0,     0,
       0,     0,     0,   150,     0,     0,     0,     0,     0,     0,
     151,     0,   152,   153,   154,   155,     0,     0,     0,     0,
       0,   156,     0,     0,     0,     0,     0,   157,     0,     0,
       0,     0,     0,   158,     0,     0,     0,     0,     0,   159,
     160,     0,     0,     0,     0,   161,   162,   163,     0,   164,
       0,     0,   165,     0,   166,     0,     0,     0,     0,     0,
     167,     0,   168,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,     0,     0,     0,   171,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   172,   173,
       0,     0,   174,     0,     0,   175,     0,   176,     0,     0,
     177,   178,     0,   179,     0,     0,     0,     0,     0,     0,
       0,     0,   180,   181,     0,   182,     0,   183,   184,     0,
       0,     0,     0,   185,     0,     0,     0,     0,     0,     0,
       0,     0,   186,     0,     0,   187,   188,   189,     0,     0,
       0,     0,     0,     0,     0,     0,   190,     0,     0,     0,
     191,   192,     0,     0,   193,     0,   194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     195,   196,   197,   198,   199,     0,     0,     0,     0,     0,
       0,     0,     0,   200,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,     0,   205,     0,   206,     0,     0,     0,     0,   207,
       0,     0,     0,     0,   208,   209,     0,   210,   211,     0,
       0,   212,     0,     0,     0,     0,     0,   213,     0,     0,
       0,     0,     0,   214,   215,     0,   216,   217,     0,   218,
       0,     0,     0,   219,     0,     0,     0,     0,     0,     0,
       0,   220,     0,     0,     0,     0,   221,     0,     0,     0,
       0,     0,     0,   222,   223,     0,     0,     0,   224,     0,
     225,     0,   226,     0,   227,     0,     0,     0,   228,     0,
       0,   229,     0,   230,     0,     0,   231,     0,     0,     0,
     232,   233,     0,     0,   234,     0,     0,     0,     0,     0,
       0,     0,   235,     0,     0,     0,     0,     0,   236,   237,
     238,   239,   240,   241,   242,   243,     0,     0,     0,     0,
       0,     0,    55,     0,    86,    87,    88,     0,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   244,   104,   105,     0,  -122,     0,   107,
     108,   109,   110,     0,   111,   112,   113,   114,   115,     0,
     116,   117,   118,     0,     0,     0,     0,     0,   121,   122,
       0,     0,     0,     0,   123,     0,     0,     0,     0,     0,
       0,     0,     0,   124,     0,   125,     0,   126,     0,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   149,
       0,     0,     0,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   153,   154,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   160,     0,     0,     0,     0,     0,   162,     0,
       0,   164,     0,     0,     0,     0,   166,     0,     0,     0,
       0,     0,   167,     0,   168,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,     0,     0,   171,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     172,   173,     0,     0,     0,     0,     0,   175,     0,   176,
       0,     0,   177,   178,     0,   179,     0,     0,     0,     0,
       0,     0,     0,     0,   180,   181,     0,   182,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   187,   188,   189,
       0,     0,     0,     0,     0,     0,     0,     0,   190,     0,
       0,     0,     0,   192,     0,     0,   193,     0,   194,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   195,   196,   197,   198,   199,     0,     0,     0,
       0,     0,     0,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   209,     0,     0,
     211,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   215,     0,     0,   217,
       0,   218,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   222,   223,     0,     0,     0,
     224,     0,   225,     0,     0,     0,     0,     0,     0,     0,
     228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,     0,     0,   234,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     236,   237,   238,   239,   240,   241,   242,   243,     4,     0,
       0,     0,     0,     0,    55,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       0,     0,  2681,     0,     0,     0,     9,    10,     0,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,     0,    35,     0,     0,     0,    37,
      38,    39,    40,    41,     0,     0,     0,     0,     0,     4,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     0,     0,     0,     0,     0,    42,     9,    10,     0,
       0,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,     0,    35,     0,     0,     0,
      37,    38,    39,    40,    41,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    42,     0,     0,
       0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,     0,     0,     0,    47,     0,     0,    48,     0,
       0,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,    48,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,     0,     0,     0,     0,     0,     0,     0,
       0,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    51,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    52,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    53,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    54,     0,     0,     0,     0,     0,    55,
      56,    57,     0,     0,     0,    58,     0,    59,     0,     0,
       0,    60,    61,    62,    63,    64,     0,     0,    65,    66,
    1263,  2431,     0,    51,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    54,     0,     0,     0,     0,     0,
      55,    56,    57,     0,     0,     0,    58,     0,    59,     0,
       0,     0,    60,    61,    62,    63,    64,     0,     0,    65,
      66,  1263,     0,     0,     0,     0,    71,   681,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   682,   104,   105,
     403,   683,     0,   107,   108,   109,   110,   684,   685,   112,
     113,   114,   115,     0,   116,   686,   687,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,  2620,   422,   423,   424,     0,     0,     0,     0,  1325,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1326,   137,  1327,  1328,     0,   431,   432,     0,   433,
     434,  1329,  1330,     0,   435,  1331,  1332,   437,     0,   438,
     439,   440,   441,  1333,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,   149,   457,     0,  1334,  1335,  1336,  1337,
    1338,  1339,  1340,   458,   459,   460,   461,   462,   463,  1341,
    1342,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,  2621,     0,   473,   474,  1343,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,  1344,   485,   486,  1345,  1346,   487,     0,   488,
    1347,     0,     0,   489,     0,   490,   167,     0,   168,   491,
     492,     0,   493,  1348,     0,   494,     0,   495,   496,   497,
     498,   499,   171,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,   172,   173,     0,   509,   510,   511,
    1349,  1350,     0,  1351,     0,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,     0,  1352,   181,
     520,   182,     0,   521,   522,   523,  1353,  1354,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,  1355,   188,  1356,  1002,   537,   538,   539,   540,   541,
     542,   543,   190,   544,  1357,   545,   546,   192,   547,  1358,
    1359,   548,  1360,   549,   550,     0,     0,   551,  1003,     0,
       0,  1361,   553,     0,     0,     0,   195,   196,   197,   198,
    1362,   554,   555,   556,   557,     0,   558,     0,   559,  1363,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,  1364,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,   209,   584,   585,  1365,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,  1366,   596,
     215,   597,   598,   217,   599,  1367,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,  1368,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,  1369,
    1370,     0,     0,   619,  1371,   620,  1372,  1373,   621,   622,
     623,     0,   624,   625,     0,  1374,   626,   627,   628,   629,
    1375,     0,   630,   631,   632,   633,   634,  1376,  2622,   635,
     234,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,  1377,  1378,  1379,  1380,  1381,
    1382,  1383,   644,   645,   646,     0,     0,     0,    55,    56,
      57,  1384,  1385,  1386,    58,  1387,     0,     0,     0,     0,
    1388,  1389,  2623,     0,     0,     0,     0,     0,     0,  1391,
    2624,   681,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   682,   104,   105,   403,   683,     0,   107,   108,   109,
     110,   684,   685,   112,   113,   114,   115,     0,   116,   686,
     687,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,  1325,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,  1326,   137,  1327,  1328,     0,
     431,   432,     0,   433,   434,  1329,  1330,     0,   435,  1331,
    1332,   437,     0,   438,   439,   440,   441,  1333,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,   149,   457,     0,
    1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,   460,
     461,   462,   463,  1341,  1342,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,  1343,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,  1344,   485,   486,  1345,
    1346,   487,     0,   488,  1347,     0,     0,   489,     0,   490,
     167,     0,   168,   491,   492,     0,   493,  1348,     0,   494,
       0,   495,   496,   497,   498,   499,   171,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,   172,   173,
       0,   509,   510,   511,  1349,  1350,     0,  1351,     0,     0,
     177,   178,   512,   179,   513,   514,   515,   516,   517,   518,
     519,     0,  1352,   181,   520,   182,     0,   521,   522,   523,
    1353,  1354,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,  1355,   188,  1356,  1002,   537,
     538,   539,   540,   541,   542,   543,   190,   544,  1357,   545,
     546,   192,   547,  1358,  1359,   548,  1360,   549,   550,     0,
       0,   551,  1003,     0,     0,  1361,   553,     0,     0,     0,
     195,   196,   197,   198,  1362,   554,   555,   556,   557,     0,
     558,     0,   559,  1363,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,  1364,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,   209,   584,   585,  1365,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,  1366,   596,   215,   597,   598,   217,   599,  1367,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,  1368,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,  1369,  1370,     0,     0,   619,  1371,   620,
    1372,  1373,   621,   622,   623,     0,   624,   625,     0,  1374,
     626,   627,   628,   629,  1375,     0,   630,   631,   632,   633,
     634,  1376,     0,   635,   234,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,  1377,
    1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,     0,
       0,     0,    55,    56,    57,  1384,  1385,  1386,    58,  1387,
       0,     0,     0,     0,  1388,  1389,     0,     0,     0,     0,
       0,     0,     0,  1391,  2532,   681,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   682,   104,   105,   403,   683,
       0,   107,   108,   109,   110,   684,   685,   112,   113,   114,
     115,     0,   116,   686,   687,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1699,
     137,  1700,  1701,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,  1702,  1703,   437,     0,   438,   439,   440,
     441,     0,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,   149,   457,     0,     0,     0,     0,   150,     0,     0,
       0,   458,   459,   460,   461,   462,   463,  1704,  1705,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,  1343,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
       0,   485,   486,     0,     0,   487,     0,   488,  1706,     0,
       0,   489,     0,   490,   167,     0,   168,   491,   492,     0,
     493,     0,     0,   494,     0,   495,   496,   497,   498,   499,
     171,   500,   501,   502,  2191,   503,   504,   505,   506,   507,
     508,     0,   172,  2192,     0,   509,   510,   511,  1349,  1707,
       0,  1708,     0,     0,   177,   178,   512,   179,   513,   514,
     515,   516,   517,   518,   519,     0,     0,   181,   520,   182,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,  1709,
     188,  1710,     0,   537,   538,   539,   540,   541,   542,   543,
       0,   544,     0,   545,   546,   192,   547,     0,     0,   548,
    1711,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,  2193,   196,   197,   198,     0,   554,
     555,   556,   557,     0,   558,     0,   559,     0,     0,     0,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,  1712,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,   209,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,  2194,   597,
     598,   217,   599,  1714,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,     0,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,  1715,  1716,     0,
       0,   619,     0,   620,     0,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,     0,  1717,  2195,   635,   234,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,     0,     0,     0,     0,     0,     0,     0,     0,
     644,   645,   646,     0,     0,     0,    55,     0,     0,     0,
       0,     0,     0,     0,     0,   681,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,  2196,    98,
      99,   100,   101,   102,   103,   682,   104,   105,   403,   683,
       0,   107,   108,   109,   110,   684,   685,   112,   113,   114,
     115,     0,   116,   686,   687,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1699,
     137,  1700,  1701,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,  1702,  1703,   437,     0,   438,   439,   440,
     441,     0,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,   149,   457,     0,     0,     0,     0,   150,     0,     0,
       0,   458,   459,   460,   461,   462,   463,  1704,  1705,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,  1343,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
       0,   485,   486,     0,     0,   487,     0,   488,  1706,     0,
       0,   489,     0,   490,   167,     0,   168,   491,   492,     0,
     493,     0,     0,   494,     0,   495,   496,   497,   498,   499,
     171,   500,   501,   502,  2191,   503,   504,   505,   506,   507,
     508,     0,   172,  2192,     0,   509,   510,   511,  1349,  1707,
       0,  1708,     0,     0,   177,   178,   512,   179,   513,   514,
     515,   516,   517,   518,   519,     0,     0,   181,   520,   182,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,  1709,
     188,  1710,     0,   537,   538,   539,   540,   541,   542,   543,
       0,   544,     0,   545,   546,   192,   547,     0,     0,   548,
    1711,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,  2193,   196,   197,   198,     0,   554,
     555,   556,   557,     0,   558,     0,   559,     0,     0,     0,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,  1712,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,   209,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,  2194,   597,
     598,   217,   599,  1714,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,     0,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,  1715,  1716,     0,
       0,   619,     0,   620,     0,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,     0,  1717,  2195,   635,   234,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,     0,     0,     0,     0,     0,     0,     0,     0,
     644,   645,   646,     0,     0,     0,    55,     0,     0,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,  2945,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,  4045,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   681,
      86,    87,    88,   400,    90,    91,    92,   401, -1565,   402,
      95,     0, -1565,    98,    99,   100,   101,   102,   103,   682,
     104,   105,   403,   683,     0,   107,   108,   109,   110,   684,
     685,   112,   113,   114,   115,     0,   116,   686,   687,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,  1325,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1326,   137,  1327,  1328,  2542,   431,   432,
       0,   433,   434,  1329,  1330,     0,   435,  1331,  1332,   437,
       0,   438,   439,   440,   441,  1333,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,   149,   457,     0,  1334,  1335,
    1336,  1337,  1338,  1339,  1340,   458,   459,   460,   461,   462,
     463,  1341,  1342,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
    1343,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,  1344,   485,   486,  1345,  1346,   487,
       0,   488,  1347,     0,     0,   489,     0,   490,   167,  2543,
     168,   491,   492,     0,   493,  1348,     0,   494,     0,   495,
     496,   497,   498,   499,   171,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,   172,   173,     0,   509,
     510,   511,  1349,  1350,     0,  1351,     0,     0,   177,   178,
     512,   179,   513,   514,   515,   516,   517,   518,   519,  2544,
    1352,   181,   520,   182,     0,   521,   522,   523,  1353,  1354,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,  1355,   188,  1356,  1002,   537,   538,   539,
     540,   541,   542,   543,   190,   544,  1357,   545,   546,   192,
     547,  1358,  1359,   548,  1360,   549,   550,     0,     0,   551,
    1003,     0,     0,  1361,   553,     0,     0,     0,   195,   196,
     197,   198,  1362,   554,   555,   556,   557,     0,   558,     0,
     559,  1363,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,  1364,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,   209,   584,   585,  1365,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
    1366,   596,   215,   597,   598,   217,   599,  1367,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,  1368,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,  1369,  1370,     0,  2545,   619,  1371,   620,  1372,  1373,
     621,   622,   623,     0,   624,   625,     0,  1374,   626,   627,
     628,   629,  1375,     0,   630,   631,   632,   633,   634,  1376,
       0,   635,   234,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,  1377,  1378,  1379,
    1380,  1381,  1382,  1383,   644,   645,   646,     0,     0,     0,
      55,    56,    57,  1384,  1385,  1386,    58,  1387,     0,     0,
       0,     0,  1388,  1389,     0,     0,     0,     0,     0,     0,
       0,  1391,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,  1325,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1326,   137,  1327,  1328,
       0,   431,   432,     0,   433,   434,  1329,  1330,     0,   435,
    1331,  1332,   437,     0,   438,   439,   440,   441,  1333,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,   149,   457,
       0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,
     460,   461,   462,   463,  1341,  1342,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,  1343,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,  1344,   485,   486,
    1345,  1346,   487,     0,   488,  1347,     0,     0,   489,     0,
     490,   167,     0,   168,   491,   492,     0,   493,  1348,     0,
     494,     0,   495,   496,   497,   498,   499,   171,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,   172,
     173,     0,   509,   510,   511,  1349,  1350,     0,  1351,     0,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,     0,  1352,   181,   520,   182,     0,   521,   522,
     523,  1353,  1354,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,  1355,   188,  1356,  1002,
     537,   538,   539,   540,   541,   542,   543,   190,   544,  1357,
     545,   546,   192,   547,  1358,  1359,   548,  1360,   549,   550,
       0,     0,   551,  1003,     0,     0,  1361,   553,     0,     0,
       0,   195,   196,   197,   198,  1362,   554,   555,   556,   557,
       0,   558,     0,   559,  1363,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,  1364,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,   209,   584,   585,  1365,
     586,   587,   588,   589,   590,   591,   592,     0,   213,   593,
     594,     0,   595,  1366,   596,   215,   597,   598,   217,   599,
    1367,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,  1368,   610,     0,   611,   612,   221,   613,   614,
     615,   616,   617,     0,  1369,  1370,     0,     0,   619,  1371,
     620,  1372,  1373,   621,   622,   623,     0,   624,   625,     0,
    1374,   626,   627,   628,   629,  1375,     0,   630,   631,   632,
     633,  1954,  1376,     0,   635,   234,   636,   637,   638,     0,
       0,   639,     0,   235,   640,   641,     0,   642,   643,   236,
    1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,
       0,     0,     0,    55,    56,    57,  1384,  1385,  1386,    58,
    1387,     0,     0,     0,     0,  1388,  1389,     0,     0,     0,
       0,     0,     0,     0,  1391,   681,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   682,   104,   105,   403,   683,
       0,   107,   108,   109,   110,   684,   685,   112,   113,   114,
     115,     0,   116,   686,   687,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,  1325,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1326,
     137,  1327,  1328,     0,   431,   432,     0,   433,   434,  1329,
    1330,     0,   435,  1331,  1332,   437,     0,   438,   439,   440,
     441,  1333,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,   149,   457,     0,  1334,  1335,  1336,  1337,  1338,  1339,
    1340,   458,   459,   460,   461,   462,   463,  1341,  1342,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,  1343,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
    1344,   485,   486,  1345,  1346,   487,     0,   488,  1347,     0,
       0,   489,     0,   490,   167,     0,   168,   491,   492,     0,
     493,  1348,     0,   494,     0,   495,   496,   497,   498,   499,
     171,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,   172,   173,     0,   509,   510,   511,  1349,  1350,
       0,  1351,     0,     0,   177,   178,   512,   179,   513,   514,
     515,   516,   517,   518,   519,     0,  1352,   181,   520,   182,
       0,   521,   522,   523,  1353,  1354,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,  1355,
     188,  1356,  1002,   537,   538,   539,   540,   541,   542,   543,
     190,   544,  1357,   545,   546,   192,   547,  1358,  1359,   548,
    1360,   549,   550,     0,     0,   551,  1003,     0,     0,  1361,
     553,     0,     0,     0,   195,   196,   197,   198,  1362,   554,
     555,   556,   557,     0,   558,     0,   559,  1363,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,  1364,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,   209,
     584,   585,  1365,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,  1366,   596,   215,   597,
     598,   217,   599,  1367,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,  1368,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,  1369,  1370,     0,
       0,   619,  1371,   620,  1372,  1373,   621,   622,   623,     0,
     624,   625,     0,  1374,   626,   627,   628,   629,  1375,     0,
     630,   631,   632,   633,   634,  1376,     0,   635,   234,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,
     644,   645,   646,     0,     0,     0,    55,    56,    57,  1384,
    1385,  1386,    58,  1387,     0,     0,     0,     0,  1388,  1389,
       0,     0,     0,     0,     0,  1900,  2491,  1391,   681,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   682,   104,
     105,   403,   683,     0,   107,   108,   109,   110,   684,   685,
     112,   113,   114,   115,     0,   116,   686,   687,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
    1325,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,  1326,   137,  1327,  1328,     0,   431,   432,     0,
     433,   434,  1329,  1330,     0,   435,  1331,  1332,   437,     0,
     438,   439,   440,   441,  1333,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,   149,   457,     0,  1334,  1335,  1336,
    1337,  1338,  1339,  1340,   458,   459,   460,   461,   462,   463,
    1341,  1342,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,  1343,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,  1344,   485,   486,  1345,  1346,   487,     0,
     488,  1347,     0,     0,   489,     0,   490,   167,     0,   168,
     491,   492,     0,   493,  1348,     0,   494,     0,   495,   496,
     497,   498,   499,   171,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,   172,   173,     0,   509,   510,
     511,  1349,  1350,     0,  1351,     0,     0,   177,   178,   512,
     179,   513,   514,   515,   516,   517,   518,   519,     0,  1352,
     181,   520,   182,     0,   521,   522,   523,  1353,  1354,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,  1355,   188,  1356,  1002,   537,   538,   539,   540,
     541,   542,   543,   190,   544,  1357,   545,   546,   192,   547,
    1358,  1359,   548,  1360,   549,   550,     0,     0,   551,  1003,
       0,     0,  1361,   553,     0,     0,     0,   195,   196,   197,
     198,  1362,   554,   555,   556,   557,     0,   558,     0,   559,
    1363,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,  1364,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,   209,   584,   585,  1365,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,  1366,
     596,   215,   597,   598,   217,   599,  1367,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,  1368,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
    1369,  1370,     0,     0,   619,  1371,   620,  1372,  1373,   621,
     622,   623,     0,   624,   625,     0,  1374,   626,   627,   628,
     629,  1375,     0,   630,   631,   632,   633,   634,  1376,     0,
     635,   234,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,  1377,  1378,  1379,  1380,
    1381,  1382,  1383,   644,   645,   646,     0,     0,     0,    55,
      56,    57,  1384,  1385,  1386,    58,  1387,     0,     0,     0,
       0,  1388,  1389,  1390,     0,     0,     0,     0,     0,     0,
    1391,   681,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   682,   104,   105,   403,   683,     0,   107,   108,   109,
     110,   684,   685,   112,   113,   114,   115,     0,   116,   686,
     687,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,  1325,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,  1326,   137,  1327,  1328,     0,
     431,   432,     0,   433,   434,  1329,  1330,     0,   435,  1331,
    1332,   437,     0,   438,   439,   440,   441,  1333,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,   149,   457,     0,
    1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,   460,
     461,   462,   463,  1341,  1342,   464,  1472,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,  1343,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,  1344,   485,   486,  1345,
    1346,   487,     0,   488,  1347,     0,     0,   489,     0,   490,
     167,     0,   168,   491,   492,     0,   493,  1348,     0,   494,
       0,   495,   496,   497,   498,   499,   171,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,   172,   173,
       0,   509,   510,   511,  1349,  1350,     0,  1351,     0,     0,
     177,   178,   512,   179,   513,   514,   515,   516,   517,   518,
     519,     0,  1352,   181,   520,   182,     0,   521,   522,   523,
    1353,  1354,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,  1355,   188,  1356,  1002,   537,
     538,   539,   540,   541,   542,   543,   190,   544,  1357,   545,
     546,   192,   547,  1358,  1359,   548,  1360,   549,   550,     0,
       0,   551,  1003,     0,     0,  1361,   553,     0,     0,     0,
     195,   196,   197,   198,  1362,   554,   555,   556,   557,     0,
     558,     0,   559,  1363,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,  1364,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,   209,   584,   585,  1365,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,  1366,   596,   215,   597,   598,   217,   599,  1367,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,  1368,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,  1369,  1370,     0,     0,   619,  1371,   620,
    1372,  1373,   621,   622,   623,     0,   624,   625,     0,  1374,
     626,   627,   628,   629,  1375,     0,   630,   631,   632,   633,
     634,  1376,     0,   635,   234,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,  1377,
    1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,     0,
       0,     0,    55,    56,    57,  1384,  1385,  1386,    58,  1387,
       0,     0,     0,     0,  1388,  1389,     0,     0,     0,     0,
       0,     0,     0,  1391,   681,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,    37,    38,    39,    40,    41,
     414,   415,   416,   417,   418,   419,   420,   421,  2089,   422,
     423,   424,     0,     0,     0,     0,  1325,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1326,   137,
    1327,  1328,     0,   431,   432,     0,   433,   434,  1329,  1330,
       0,   435,  1331,  1332,   437,     0,   438,   439,   440,   441,
    1333,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
     149,   457,     0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,
     458,   459,   460,   461,   462,   463,  1341,  1342,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,  1343,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,  1344,
     485,   486,  1345,  1346,   487,     0,   488,  1347,     0,     0,
     489,     0,   490,   167,     0,   168,   491,   492,     0,   493,
    1348,     0,   494,     0,   495,   496,   497,   498,   499,   171,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,   172,   173,     0,   509,   510,   511,  1349,  1350,     0,
    1351,     0,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,     0,  1352,   181,   520,   182,     0,
     521,   522,   523,  1353,  1354,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,  1355,   188,
    1356,  1002,   537,   538,   539,   540,   541,   542,   543,   190,
     544,  1357,   545,   546,   192,   547,  1358,  1359,   548,  1360,
     549,   550,     0,     0,   551,  1003,     0,     0,  1361,   553,
       0,     0,     0,   195,   196,   197,   198,  1362,   554,   555,
     556,   557,     0,   558,     0,   559,  1363,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
    1364,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,   209,   584,
     585,  1365,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,  1366,   596,   215,   597,   598,
     217,   599,  1367,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,  1368,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,  1369,  1370,     0,     0,
     619,  1371,   620,  1372,  1373,   621,   622,   623,     0,   624,
     625,     0,  1374,   626,   627,   628,   629,  1375,     0,   630,
     631,   632,   633,   634,  1376,     0,   635,   234,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,
     645,   646,     0,     0,     0,    55,    56,    57,  1384,  1385,
    1386,    58,  1387,     0,     0,     0,     0,  1388,  1389,     0,
       0,     0,     0,     0,     0,     0,  1391,   681,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   682,   104,   105,
     403,   683,     0,   107,   108,   109,   110,   684,   685,   112,
     113,   114,   115,     0,   116,   686,   687,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,  1325,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1326,   137,  1327,  1328,     0,   431,   432,     0,   433,
     434,  1329,  1330,     0,   435,  1331,  1332,   437,     0,   438,
     439,   440,   441,  1333,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,   149,   457,  2983,  1334,  1335,  1336,  1337,
    1338,  1339,  1340,   458,   459,   460,   461,   462,   463,  1341,
    1342,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,  1343,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,  1344,   485,   486,  1345,  1346,   487,     0,   488,
    1347,     0,     0,   489,     0,   490,   167,     0,   168,   491,
     492,     0,   493,  1348,     0,   494,     0,   495,   496,   497,
     498,   499,   171,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,   172,   173,     0,   509,   510,   511,
    1349,  1350,     0,  1351,     0,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,     0,  1352,   181,
     520,   182,     0,   521,   522,   523,  1353,  1354,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,  1355,   188,  1356,  1002,   537,   538,   539,   540,   541,
     542,   543,   190,   544,  1357,   545,   546,   192,   547,  1358,
    1359,   548,  1360,   549,   550,     0,     0,   551,  1003,     0,
       0,  1361,   553,     0,     0,     0,   195,   196,   197,   198,
    1362,   554,   555,   556,   557,     0,   558,     0,   559,  1363,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,  1364,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,   209,   584,   585,  1365,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,  1366,   596,
     215,   597,   598,   217,   599,  1367,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,  1368,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,  1369,
    1370,     0,     0,   619,  1371,   620,  1372,  1373,   621,   622,
     623,     0,   624,   625,     0,  1374,   626,   627,   628,   629,
    1375,     0,   630,   631,   632,   633,   634,  1376,     0,   635,
     234,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,  1377,  1378,  1379,  1380,  1381,
    1382,  1383,   644,   645,   646,     0,     0,     0,    55,    56,
      57,  1384,  1385,  1386,    58,  1387,     0,     0,     0,     0,
    1388,  1389,     0,     0,     0,     0,     0,     0,     0,  1391,
     681,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     682,   104,   105,   403,   683,     0,   107,   108,   109,   110,
     684,   685,   112,   113,   114,   115,     0,   116,   686,   687,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,  1325,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1326,   137,  1327,  1328,     0,   431,
     432,     0,   433,   434,  1329,  1330,     0,   435,  1331,  1332,
     437,     0,   438,   439,   440,   441,  1333,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,   149,   457,     0,  1334,
    1335,  1336,  1337,  1338,  1339,  1340,   458,   459,   460,   461,
     462,   463,  1341,  1342,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,  1343,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,  1344,   485,   486,  1345,  1346,
     487,     0,   488,  1347,     0,     0,   489,     0,   490,   167,
    2543,   168,   491,   492,     0,   493,  1348,     0,   494,     0,
     495,   496,   497,   498,   499,   171,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,   172,   173,     0,
     509,   510,   511,  1349,  1350,     0,  1351,     0,     0,   177,
     178,   512,   179,   513,   514,   515,   516,   517,   518,   519,
       0,  1352,   181,   520,   182,     0,   521,   522,   523,  1353,
    1354,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,  1355,   188,  1356,  1002,   537,   538,
     539,   540,   541,   542,   543,   190,   544,  1357,   545,   546,
     192,   547,  1358,  1359,   548,  1360,   549,   550,     0,     0,
     551,  1003,     0,     0,  1361,   553,     0,     0,     0,   195,
     196,   197,   198,  1362,   554,   555,   556,   557,     0,   558,
       0,   559,  1363,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,  1364,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,   209,   584,   585,  1365,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,  1366,   596,   215,   597,   598,   217,   599,  1367,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
    1368,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,  1369,  1370,     0,     0,   619,  1371,   620,  1372,
    1373,   621,   622,   623,     0,   624,   625,     0,  1374,   626,
     627,   628,   629,  1375,     0,   630,   631,   632,   633,   634,
    1376,     0,   635,   234,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,  1377,  1378,
    1379,  1380,  1381,  1382,  1383,   644,   645,   646,     0,     0,
       0,    55,    56,    57,  1384,  1385,  1386,    58,  1387,     0,
       0,     0,     0,  1388,  1389,     0,     0,     0,     0,     0,
       0,     0,  1391,   681,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   682,   104,   105,   403,   683,     0,   107,
     108,   109,   110,   684,   685,   112,   113,   114,   115,     0,
     116,   686,   687,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,  1325,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1326,   137,  1327,
    1328,     0,   431,   432,     0,   433,   434,  1329,  1330,     0,
     435,  1331,  1332,   437,     0,   438,   439,   440,   441,  1333,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,   149,
     457,     0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,
     459,   460,   461,   462,   463,  1341,  1342,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,  1343,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,  1344,   485,
     486,  1345,  1346,   487,     0,   488,  1347,     0,     0,   489,
       0,   490,   167,     0,   168,   491,   492,     0,   493,  1348,
       0,   494,     0,   495,   496,   497,   498,   499,   171,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
     172,   173,     0,   509,   510,   511,  1349,  1350,     0,  1351,
       0,     0,   177,   178,   512,   179,   513,   514,   515,   516,
     517,   518,   519,     0,  1352,   181,   520,   182,     0,   521,
     522,   523,  1353,  1354,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,  1355,   188,  1356,
    1002,   537,   538,   539,   540,   541,   542,   543,   190,   544,
    1357,   545,   546,   192,   547,  1358,  1359,   548,  1360,   549,
     550,     0,     0,   551,  1003,     0,     0,  1361,   553,     0,
       0,     0,   195,   196,   197,   198,  1362,   554,   555,   556,
     557,     0,   558,     0,   559,  1363,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,  1364,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,   209,   584,   585,
    1365,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,  1366,   596,   215,   597,   598,   217,
     599,  1367,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,  1368,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,  1369,  1370,     0,     0,   619,
    1371,   620,  1372,  1373,   621,   622,   623,     0,   624,   625,
       0,  1374,   626,   627,   628,   629,  1375,     0,   630,   631,
     632,   633,   634,  1376,  3554,   635,   234,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,
     646,     0,     0,     0,    55,    56,    57,  1384,  1385,  1386,
      58,  1387,     0,     0,     0,     0,  1388,  1389,     0,     0,
       0,     0,     0,     0,     0,  1391,   681,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   682,   104,   105,   403,
     683,     0,   107,   108,   109,   110,   684,   685,   112,   113,
     114,   115,     0,   116,   686,   687,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,  1325,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1326,   137,  1327,  1328,     0,   431,   432,     0,   433,   434,
    1329,  1330,     0,   435,  1331,  1332,   437,     0,   438,   439,
     440,   441,  1333,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,   149,   457,     0,  1334,  1335,  1336,  1337,  1338,
    1339,  1340,   458,   459,   460,   461,   462,   463,  1341,  1342,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,  1343,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,  1344,   485,   486,  1345,  1346,   487,     0,   488,  1347,
       0,     0,   489,     0,   490,   167,     0,   168,   491,   492,
       0,   493,  1348,     0,   494,     0,   495,   496,   497,   498,
     499,   171,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,   172,   173,     0,   509,   510,   511,  1349,
    1350,     0,  1351,     0,     0,   177,   178,   512,   179,   513,
     514,   515,   516,   517,   518,   519,     0,  1352,   181,   520,
     182,     0,   521,   522,   523,  1353,  1354,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
    1355,   188,  1356,  1002,   537,   538,   539,   540,   541,   542,
     543,   190,   544,  1357,   545,   546,   192,   547,  1358,  1359,
     548,  1360,   549,   550,     0,     0,   551,  1003,     0,     0,
    1361,   553,     0,     0,     0,   195,   196,   197,   198,  1362,
     554,   555,   556,   557,     0,   558,     0,   559,  1363,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,  1364,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
     209,   584,   585,  1365,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,  1366,   596,   215,
     597,   598,   217,   599,  1367,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,  1368,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,  1369,  1370,
       0,     0,   619,  1371,   620,  1372,  1373,   621,   622,   623,
       0,   624,   625,     0,  1374,   626,   627,   628,   629,  1375,
       0,   630,   631,   632,   633,   634,  1376,     0,   635,   234,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,  1377,  1378,  1379,  1380,  1381,  1382,
    1383,   644,   645,   646,     0,     0,     0,    55,    56,    57,
    1384,  1385,  1386,    58,  1387,     0,     0,     0,     0,  1388,
    1389,     0,     0,     0,     0,     0,     0,     0,  1391,   681,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   682,
     104,   105,   403,   683,     0,   107,   108,   109,   110,   684,
     685,   112,   113,   114,   115,     0,   116,   686,   687,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,  1325,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1326,   137,  1327,  1328,     0,   431,   432,
       0,   433,   434,  1329,  1330,     0,   435,  1331,  1332,   437,
       0,   438,   439,   440,   441,  1333,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,   149,   457,     0,  1334,  1335,
    1336,  1337,  1338,  1339,  1340,   458,   459,   460,   461,   462,
     463,  1341,  1342,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
    1343,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,  1344,   485,   486,  1345,  1346,   487,
       0,   488,  1347,     0,     0,   489,     0,   490,   167,     0,
     168,   491,   492,     0,   493,  1348,     0,   494,     0,   495,
     496,   497,   498,   499,   171,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,   172,   173,     0,   509,
     510,   511,  1349,  1350,     0,  1351,     0,     0,   177,   178,
     512,   179,   513,   514,   515,   516,   517,   518,   519,     0,
    1352,   181,   520,   182,     0,   521,   522,   523,  1353,  1354,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,  1355,   188,  1356,  1002,   537,   538,   539,
     540,   541,   542,   543,   190,   544,  1357,   545,   546,   192,
     547,  1358,  1359,   548,  1360,   549,   550,     0,     0,   551,
    1003,     0,     0,  1361,   553,     0,     0,     0,   195,   196,
     197,   198,  1362,   554,   555,   556,   557,     0,   558,     0,
     559,  1363,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,  1364,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,   209,   584,   585,  1365,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
    1366,   596,   215,   597,   598,   217,   599,  1367,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,  1368,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,  1369,  1370,     0,     0,   619,  1371,   620,  1372,  1373,
     621,   622,   623,     0,   624,   625,     0,  1374,   626,   627,
     628,   629,  1375,     0,   630,   631,   632,   633,   634,  1376,
       0,   635,   234,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,  3780,  1377,  1378,  1379,
    1380,  1381,  1382,  1383,   644,   645,   646,     0,     0,     0,
      55,    56,    57,  1384,  1385,  1386,    58,  1387,     0,     0,
       0,     0,  1388,  1389,     0,     0,     0,     0,     0,     0,
       0,  1391,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,  1325,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1326,   137,  1327,  1328,
       0,   431,   432,     0,   433,   434,  1329,  1330,     0,   435,
    1331,  1332,   437,     0,   438,   439,   440,   441,  1333,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,   149,   457,
       0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,
     460,   461,   462,   463,  1341,  1342,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,  1343,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,  1344,   485,   486,
    1345,  1346,   487,     0,   488,  1347,     0,     0,   489,     0,
     490,   167,     0,   168,   491,   492,     0,   493,  1348,     0,
     494,     0,   495,   496,   497,   498,   499,   171,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,   172,
     173,     0,   509,   510,   511,  1349,  1350,     0,  1351,     0,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,     0,  1352,   181,   520,   182,     0,   521,   522,
     523,  1353,  1354,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,  1355,   188,  1356,  1002,
     537,  3787,   539,   540,   541,   542,   543,   190,   544,  1357,
     545,   546,   192,   547,  1358,  1359,   548,  1360,   549,   550,
       0,     0,   551,  1003,     0,     0,  1361,   553,     0,     0,
       0,   195,   196,   197,   198,  1362,   554,   555,   556,   557,
       0,   558,     0,   559,  1363,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,  1364,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,   209,   584,   585,  1365,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,  1366,   596,   215,   597,   598,   217,   599,
    1367,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,  1368,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,  1369,  1370,     0,     0,   619,  1371,
     620,  1372,  1373,   621,   622,   623,     0,   624,   625,     0,
    1374,   626,   627,   628,   629,  1375,     0,   630,   631,   632,
     633,   634,  1376,     0,   635,   234,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
    1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,
       0,     0,     0,    55,    56,    57,  1384,  1385,  1386,    58,
    1387,     0,     0,     0,     0,  1388,  1389,     0,     0,     0,
       0,     0,     0,     0,  1391,   681,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   682,   104,   105,   403,   683,
       0,   107,   108,   109,   110,   684,   685,   112,   113,   114,
     115,     0,   116,   686,   687,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,  1325,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1326,
     137,  1327,  1328,     0,   431,   432,     0,   433,   434,  1329,
    1330,     0,   435,  1331,  1332,   437,     0,   438,   439,   440,
     441,  1333,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,   149,   457,     0,  1334,  1335,  1336,  1337,  1338,  1339,
    1340,   458,   459,   460,   461,   462,   463,  1341,  1342,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,  1343,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
    1344,   485,   486,  1345,  1346,   487,     0,   488,  1347,     0,
       0,   489,     0,   490,   167,     0,   168,   491,   492,     0,
     493,  1348,     0,   494,     0,   495,   496,   497,   498,   499,
     171,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,   172,   173,     0,   509,   510,   511,  1349,  1350,
       0,  1351,     0,     0,   177,   178,   512,   179,   513,   514,
     515,   516,   517,   518,   519,     0,  1352,   181,   520,   182,
       0,   521,   522,   523,  1353,  1354,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,  1355,
     188,  1356,  1002,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,   192,   547,  1358,  1359,   548,
    1360,   549,   550,     0,     0,   551,  1003,     0,     0,  1361,
     553,     0,     0,     0,   195,   196,   197,   198,  1362,   554,
     555,   556,   557,     0,   558,     0,   559,  1363,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,  1364,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,   209,
     584,   585,  1365,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,  1366,   596,   215,   597,
     598,   217,   599,  1367,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,  1368,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,  1369,  1370,     0,
       0,   619,  1371,   620,  1372,  1373,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,  1375,     0,
     630,   631,   632,   633,   634,  1376,     0,   635,   234,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,
     644,   645,   646,     0,     0,     0,    55,    56,    57,  1384,
    1385,  1386,    58,  1387,     0,     0,     0,     0,  2525,  2526,
       0,     0,     0,     0,     0,     0,     0,  1391,   681,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   682,   104,
     105,   403,   683,     0,   107,   108,   109,   110,   684,   685,
     112,   113,   114,   115,     0,   116,   686,   687,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
    1325,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,     0,  1326,   137,  1327,  1328,     0,   431,   432,     0,
     433,   434,  1329,  1330,     0,   435,  1331,  1332,   437,     0,
     438,   439,   440,   441,  1333,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,   149,   457,     0,  1334,  1335,  1336,
    1337,  1338,  1339,  1340,   458,   459,   460,   461,   462,   463,
    1341,  1342,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,  1343,
     476,   477,     0,   478,   479,   480,     0,     0,     0,     0,
     482,   483,   484,  1344,   485,   486,  1345,  1346,   487,     0,
     488,  1347,     0,     0,   489,     0,   490,   167,     0,   168,
     491,   492,     0,   493,  1348,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,   172,   173,     0,   509,   510,
     511,  1349,  1350,     0,  1351,     0,     0,   177,   178,   512,
     179,   513,   514,   515,   516,   517,   518,   519,     0,  1352,
     181,   520,     0,     0,   521,   522,   523,  1353,  1354,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,  1355,   188,  1356,  1002,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,   192,   547,
    1358,  1359,   548,  1360,   549,   550,     0,     0,   551,  1003,
       0,     0,  1361,   553,     0,     0,     0,   195,   196,   197,
     198,  1362,   554,   555,   556,   557,     0,   558,     0,   559,
    1363,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,  1364,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,   209,   584,   585,  1365,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,  1366,
     596,   215,   597,   598,     0,   599,  1367,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,  1368,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
    1369,  1370,     0,     0,   619,  1371,   620,  1372,  1373,   621,
     622,   623,     0,   624,   625,     0,  1374,   626,   627,   628,
     629,  1375,     0,   630,   631,   632,   633,   634,  1376,     0,
     635,   234,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,  1377,  1378,  1379,  1380,
    1381,  1382,  1383,   644,   645,   646,     0,     0,     0,    55,
      56,    57,  1384,  1385,  1386,    58,  1387,     0,     0,     0,
       0,  1388,  1389,     0,     0,     0,     0,     0,     0,     0,
    1391,   681,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   682,   104,   105,   403,   683,     0,   107,   108,   109,
     110,   684,   685,   112,   113,   114,   115,     0,   116,   686,
     687,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,  1325,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,     0,  1326,   137,  1327,  1328,     0,
     431,   432,     0,   433,   434,  1329,  1330,     0,   435,  1331,
    1332,   437,     0,   438,   439,   440,   441,  1333,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,   149,   457,     0,
    1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,   460,
     461,   462,   463,  1341,  1342,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,  1343,   476,   477,     0,   478,   479,   480,     0,
       0,     0,     0,   482,   483,   484,  1344,   485,   486,  1345,
    1346,   487,     0,   488,  1347,     0,     0,   489,     0,   490,
     167,     0,   168,   491,   492,     0,   493,  1348,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,   172,   173,
       0,   509,   510,   511,  1349,  1350,     0,  1351,     0,     0,
     177,   178,   512,   179,   513,   514,   515,   516,   517,   518,
     519,     0,  1352,   181,   520,     0,     0,   521,   522,   523,
    1353,  1354,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,  1355,   188,  1356,  1002,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,   192,   547,  1358,  1359,   548,  1360,   549,   550,     0,
       0,   551,  1003,     0,     0,  1361,   553,     0,     0,     0,
     195,   196,   197,   198,  1362,   554,   555,   556,   557,     0,
     558,     0,   559,  1363,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,  1364,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,   209,   584,   585,  1365,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,  1366,   596,   215,   597,   598,     0,   599,  1367,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,  1368,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,  1369,  1370,     0,     0,   619,  1371,   620,
    1372,  1373,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,  1375,     0,   630,   631,   632,   633,
     634,  1376,     0,   635,   234,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,  1377,
    1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,     0,
       0,     0,    55,    56,    57,  1384,  1385,  1386,    58,  1387,
       0,     0,     0,     0,  2525,  2526,     0,     0,     0,     0,
       0,     0,     0,  1391,   681,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,     0,   433,   434,     0,  1330,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
    1333,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
     149,   457,     0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,  1345,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,   167,     0,   168,   491,   492,     0,   493,
    1348,     0,   494,     0,   495,   496,   497,   498,   499,   171,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,   172,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,     0,  1352,   181,   520,   182,     0,
     521,   522,   523,  1353,  1354,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,   188,
     189,  1002,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,   192,   547,     0,  1359,   548,   194,
     549,   550,     0,     0,   551,  1003,     0,  1004,   552,   553,
       0,     0,     0,   195,   196,   197,   198,  1362,   554,   555,
     556,   557,     0,   558,     0,   559,  1363,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,   209,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
     213,   593,   594,     0,   595,  1366,   596,   215,   597,   598,
     217,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,  1368,   610,     0,   611,   612,   221,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,  1371,   620,  1372,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,  1375,     0,   630,
     631,   632,   633,  1954,   233,     0,   635,   234,   636,   637,
     638,     0,     0,   639,     0,   235,   640,   641,     0,   642,
     643,   236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,
     645,   646,     0,     0,     0,    55,     0,     0,     0,     0,
       0,     0,     0,   681,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,  2388,    98,    99,   100,
     101,   102,   103,   682,   104,   105,   403,   683,     0,   107,
     108,   109,   110,   684,   685,   112,   113,   114,   115,     0,
     116,   686,   687,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,     0,   433,   434,     0,  1330,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,  1333,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,   149,
     457,     0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,  1345,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,   167,     0,   168,   491,   492,     0,   493,  1348,
       0,   494,     0,   495,   496,   497,   498,   499,   171,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
     172,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,   177,   178,   512,   179,   513,   514,   515,   516,
     517,   518,   519,     0,  1352,   181,   520,   182,     0,   521,
     522,   523,  1353,  1354,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,   188,   189,
    1002,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,   192,   547,     0,  1359,   548,   194,   549,
     550,     0,     0,   551,  1003,     0,  1004,   552,   553,     0,
       0,     0,   195,   196,   197,   198,  1362,   554,   555,   556,
     557,     0,   558,     0,   559,  1363,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,   209,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,  1366,   596,   215,   597,   598,   217,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,  1368,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
    1371,   620,  1372,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,  1375,     0,   630,   631,
     632,   633,   634,   233,     0,   635,   234,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,
     646,     0,     0,     0,    55,     0,     0,     0,     0,     0,
       0,     0,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,  2388,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,     0,   433,   434,     0,  1330,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,  1333,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,   149,   457,
       0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
    1345,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,   167,     0,   168,   491,   492,     0,   493,  1348,     0,
     494,     0,   495,   496,   497,   498,   499,   171,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,   172,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,     0,  1352,   181,   520,   182,     0,   521,   522,
     523,  1353,  1354,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,   188,   189,  1002,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,   192,   547,     0,  1359,   548,   194,   549,   550,
       0,     0,   551,  1003,     0,     0,   552,   553,     0,     0,
       0,   195,   196,   197,   198,  1362,   554,   555,   556,   557,
       0,   558,     0,   559,  1363,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,   209,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,  1366,   596,   215,   597,   598,   217,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,  1368,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,  1371,
     620,  1372,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,  1375,     0,   630,   631,   632,
     633,   634,   233,     0,   635,   234,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
    1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,
       0,     0,     0,    55,     0,     0,     0,     0,     0,     0,
       0,   681,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,  3922,    98,    99,   100,   101,   102,
     103,   682,   104,   105,   403,   683,     0,   107,   108,   109,
     110,   684,   685,   112,   113,   114,   115,     0,   116,   686,
     687,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,   149,   457,     0,
       0,     0,     0,   150,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
     167,     0,   168,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,   171,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,   172,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
     177,   178,   512,   179,   513,   514,   515,   516,   517,   518,
     519,     0,   180,   181,   520,   182,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,   188,   189,  1002,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,   192,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,  1003,     0,     0,   552,   553,     0,     0,     0,
     195,   196,   197,   198,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,   209,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,   217,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,   234,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,     0,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,  3988,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,  2965,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456, -1170,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0, -1170,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
   -1170,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512, -1170,   513,   514,   515,   516,
     517,   518,   519,     0,   180, -1170,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187, -1170,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583, -1170,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,     0,     0,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,  1480,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,     0,    57,
       0,     0,     0,    58,     0,     0,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,  3334,  3335,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,     0,    57,     0,
       0,     0,    58,     0,     0,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,  3335,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
     213,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,   221,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,  1954,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,   235,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,     0,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   244,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,   213,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,   221,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,  1954,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,   235,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,     0,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   244,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,  1002,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,  1003,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
       0,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
    1458,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,     0,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,  2062,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,     0,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,  3430,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,     0,     0,     0,     0,
       0,     0,     0,   681,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,  3549,    98,    99,   100,
     101,   102,   103,   682,   104,   105,   403,   683,     0,   107,
     108,   109,   110,   684,   685,   112,   113,   114,   115,     0,
     116,   686,   687,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,   688,   422,   423,
     424,   689,   690,   691,   692,   693,   694,   695,   425,   426,
     696,   427,   133,   428,   429,   430,   135,  1699,   137,  1700,
    1701,   697,   431,   432,     0,   433,   434,   698,   699,     0,
     435,  1702,  1703,   437,   701,   438,   439,   440,   441,     0,
     702,   703,   442,   443,   444,   445,   446,   447,   704,   448,
     449,   450,   451,   452,   453,   705,   454,   455,   456,   149,
     457,     0,   706,   707,   708,   150,   709,   710,   711,   458,
     459,   460,   461,   462,   463,  1704,  1705,   464,   712,   465,
     713,   466,     0,   467,   468,   469,   714,   470,   471,   472,
     715,   716,   473,   474,  1343,   476,   477,   717,   478,   479,
     480,   718,     0,   481,   719,   482,   483,   484,     0,   485,
     486,     0,   720,   487,   721,   488,  1706,     0,   722,   489,
     723,   490,   167,   724,   168,   491,   492,   725,   493,     0,
     726,   494,   727,   495,   496,   497,   498,   499,   171,   500,
     501,   502,   728,   503,   504,   505,   506,   507,   508,   729,
     172,     0,     0,   509,   510,   511,  1349,  1707,   732,  1708,
     733,     0,   177,   178,   512,   179,   513,   514,   515,   516,
     517,   518,   519,   734,     0,   181,   520,   182,   735,   521,
     522,   523,   736,   737,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,  1709,   188,  1710,
     738,   537,   538,   539,   540,   541,   542,   543,     0,   544,
     739,   545,   546,   192,   547,   740,     0,   548,  1711,   549,
     550,   741,   742,   551,   743,   744,   745,  3321,   553,     0,
     746,   747,     0,   196,   197,   198,     0,   554,   555,   556,
     557,     0,   558,   748,   559,     0,     0,     0,   560,   561,
     562,   749,   563,   564,   565,   566,   567,     0,   568,  1712,
     569,   570,   571,   750,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,   751,   582,   583,   209,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,     0,   752,
     593,   594,     0,   595,   753,   596,  2194,   597,   598,   217,
     599,  1714,   754,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,     0,   610,   755,   611,   612,   756,   613,
     614,   615,   616,   617,   757,  1715,  1716,     0,   759,   619,
       0,   620,     0,   760,   621,   622,   623,     0,   624,   625,
       0,   762,   626,   627,   628,   629,   763,   764,   630,   631,
     632,   633,     0,  1717,   765,   635,   234,   636,   637,   638,
     766,   767,   639,   768,   769,   640,   641,     0,   642,   643,
       0,     0,     0,     0,     0,     0,     0,     0,   644,   645,
     646,     0,     0,     0,    55,    56,    57,     0,     0,  1120,
      58,     0,  1121,  1122,  1123,     0,  3322,  3323,  1126,  1127,
    1128,  1129,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,  1118,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,  1119,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,     0,     0,     0,     0,  1120,     0,     0,
    1121,  1122,  1123,     0,  1124,  1125,  1126,  1127,  1128,  1129,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,  1194,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,  1195,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,     0,     0,     0,     0,  1120,     0,     0,  1121,  1122,
    1123,     0,  1124,  1125,  1126,  1127,  1128,  1129,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
    1240,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,  1241,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,  1242,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,     0,
       0,     0,     0,  1120,     0,     0,  1121,  1122,  1123,     0,
    1124,  1125,  1126,  1127,  1128,  1129,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,  1682,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,  1683,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,     0,     0,     0,
       0,  1120,     0,     0,  1121,  1122,  1123,     0,  1124,  1125,
    1126,  1127,  1128,  1129,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,     0,     0,     0,     0,  1120,
       0,     0,  1121,  1122,  1123,     0,  1124,  1125,  1126,  1127,
    1128,  1129,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,   688,   422,   423,   424,
     689,   690,   691,   692,   693,   694,   695,   425,   426,   696,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
     697,   431,   432,     0,   433,   434,   698,   699,     0,   435,
     700,   140,   437,   701,   438,   439,   440,   441,   144,   702,
     703,   442,   443,   444,   445,   446,   447,   704,   448,   449,
     450,   451,   452,   453,   705,   454,   455,   456,   149,   457,
       0,   706,   707,   708,   150,   709,   710,   711,   458,   459,
     460,   461,   462,   463,   153,   154,   464,   712,   465,   713,
     466,     0,   467,   468,   469,   714,   470,   471,   472,   715,
     716,   473,   474,   475,   476,   477,   717,   478,   479,   480,
     718,     0,   481,   719,   482,   483,   484,   162,   485,   486,
     164,   720,   487,   721,   488,   166,     0,   722,   489,   723,
     490,   167,   724,   168,   491,   492,   725,   493,   170,   726,
     494,   727,   495,   496,   497,   498,   499,   171,   500,   501,
     502,   728,   503,   504,   505,   506,   507,   508,   729,   172,
     173,   730,   509,   510,   511,   731,   175,   732,   176,   733,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,   734,   180,   181,   520,   182,   735,   521,   522,
     523,   736,   737,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,   188,   189,   738,
     537,   538,   539,   540,   541,   542,   543,   190,   544,   739,
     545,   546,   192,   547,   740,   193,   548,   194,   549,   550,
     741,   742,   551,   743,   744,   745,   552,   553,     0,   746,
     747,   195,   196,   197,   198,   199,   554,   555,   556,   557,
       0,   558,   748,   559,   200,     0,   201,   560,   561,   562,
     749,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,   750,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,   751,   582,   583,   209,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,   752,   593,
     594,     0,   595,   753,   596,   215,   597,   598,   217,   599,
     218,   754,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,   755,   611,   612,   756,   613,   614,
     615,   616,   617,   757,   222,   223,   758,   759,   619,   224,
     620,   225,   760,   621,   622,   623,     0,   624,   625,   761,
     762,   626,   627,   628,   629,   763,   764,   630,   631,   632,
     633,     0,   233,   765,   635,   234,   636,   637,   638,   766,
     767,   639,   768,   769,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,   681,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,  2053,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1699,   137,
    1700,  1701,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,  1702,  1703,   437,     0,   438,   439,   440,   441,
       0,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
     149,   457,     0,     0,     0,     0,   150,     0,     0,     0,
     458,   459,   460,   461,   462,   463,  1704,  1705,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,  1343,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,     0,
     485,   486,     0,     0,   487,     0,   488,  1706,     0,     0,
     489,     0,   490,   167,     0,   168,   491,   492,     0,   493,
       0,     0,   494,     0,   495,   496,   497,   498,   499,   171,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,   172,     0,     0,   509,   510,   511,  1349,  1707,     0,
    1708,     0,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,     0,     0,   181,   520,   182,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,  1709,   188,
    1710,     0,   537,   538,   539,   540,   541,   542,   543,     0,
     544,     0,   545,   546,   192,   547,     0,     0,   548,  1711,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,     0,   196,   197,   198,     0,   554,   555,
     556,   557,     0,   558,     0,   559,     0,     0,     0,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
    1712,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,   209,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,  1713,   597,   598,
     217,   599,  1714,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,  1715,  1716,     0,     0,
     619,     0,   620,     0,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,     0,  1717,     0,   635,   234,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,     0,     0,     0,     0,     0,     0,     0,     0,   644,
     645,   646,     0,     0,     0,    55,     0,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,  2149,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,     0,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,  1013,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,  2036,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,  2037,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,  2038,     0,   551,     0,
    2039,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,  2040,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      56,    57,     0,     0,     0,    58,     0,     0,     0,     0,
       0,   922,  1517,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,  2046,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,  2037,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
    2038,     0,   551,     0,  2039,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,  2040,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    56,    57,     0,     0,     0,    58,
       0,     0,     0,     0,     0,   922,  1517,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,  2037,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,  2038,     0,   551,     0,  2039,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,  2040,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    56,    57,
       0,     0,     0,    58,     0,     0,     0,     0,     0,   922,
    1517,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,     0,     0,     0,     0,    41,   414,   911,   416,   417,
     418,   419,   420,   421,   912,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     913,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   914,   166,     0,     0,   489,     0,   915,     0,
     916,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,   917,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   918,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   919,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   920,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   921,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,     0,     0,     0,     0,     0,    58,     0,     0,
       0,     0,     0,   922,   923,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,     0,     0,     0,     0,    41,
     414,   911,   416,   417,   418,   419,   420,   421,   912,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   913,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   914,   166,     0,     0,
     489,     0,   915,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   918,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   919,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   920,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   921,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,     0,     0,     0,     0,
       0,    58,     0,     0,     0,     0,     0,   922,   923,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,   669,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,  1428,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,  1429,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,     0,
       0,     0,     0,     0,     0,  1387,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    56,    57,  1384,
    4183,     0,    58,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,   618,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,     0,    57,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
    1073,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,     0,    57,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
       0,    57,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,  2022,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,     0,    57,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,    37,    38,    39,    40,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,     0,    57,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,  1823,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,   981,
      57,    86,    87,    88,   400,    90,    91,    92,   401,   982,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,   983,   435,   958,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   984,     0,   985,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   986,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   987,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   988,   585,   211,   586,   587,
     588,   989,   590,   591,   592,     0,     0,   593,   594,     0,
     990,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   991,   223,     0,     0,   992,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   962,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   993,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,   688,   422,   423,   424,
     689,   690,   691,   692,   693,   694,   695,   425,   426,   696,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
     697,   431,   432,     0,   433,   434,   698,   699,     0,   435,
     700,   140,   437,   701,   438,   439,   440,   441,   144,   702,
     703,   442,   443,   444,   445,   446,   447,   704,   448,   449,
     450,   451,   452,   453,   705,   454,   455,   456,   149,   457,
       0,   706,   707,   708,   150,   709,   710,   711,   458,   459,
     460,   461,   462,   463,   153,   154,   464,   712,   465,   713,
     466,     0,   467,   468,   469,   714,   470,   471,   472,   715,
     716,   473,   474,   475,   476,   477,   717,   478,   479,   480,
     718,     0,   481,   719,   482,   483,   484,   162,   485,   486,
     164,   720,   487,   721,   488,   166,     0,   722,   489,   723,
     490,   167,   724,   168,   491,   492,   725,   493,   170,   726,
     494,   727,   495,   496,   497,   498,   499,   171,   500,   501,
     502,   728,   503,   504,   505,   506,   507,   508,   729,   172,
     173,   730,   509,   510,   511,   731,   175,   732,   176,   733,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,   734,   180,   181,   520,   182,   735,   521,   522,
     523,   736,   737,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,   188,   189,   738,
     537,   538,   539,   540,   541,   542,   543,   190,   544,   739,
     545,   546,   192,   547,   740,   193,   548,   194,   549,   550,
     741,   742,   551,   743,   744,   745,   552,   553,     0,   746,
     747,   195,   196,   197,   198,   199,   554,   555,   556,   557,
       0,   558,   748,   559,   200,     0,   201,   560,   561,   562,
     749,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,   750,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,   751,   582,   583,   209,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,   752,   593,
     594,     0,   595,   753,   596,   215,   597,   598,   217,   599,
     218,   754,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,   755,   611,   612,   756,   613,   614,
     615,   616,   617,   757,   222,   223,   758,   759,   619,   224,
     620,   225,   760,   621,   622,   623,     0,   624,   625,   761,
     762,   626,   627,   628,   629,   763,   764,   630,   631,   632,
     633,     0,   233,   765,   635,   234,   636,   637,   638,   766,
     767,   639,   768,   769,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,   681,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,  2815,   419,   420,   421,   688,   422,
     423,   424,   689,   690,   691,   692,   693,   694,   695,   425,
     426,   696,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,   697,   431,   432,     0,   433,   434,   698,   699,
       0,   435,   700,   140,   437,   701,   438,   439,   440,   441,
     144,   702,   703,   442,   443,   444,   445,   446,   447,   704,
     448,   449,   450,   451,   452,   453,   705,   454,   455,   456,
     149,   457,     0,   706,   707,   708,   150,   709,   710,   711,
     458,   459,   460,   461,   462,   463,   153,   154,   464,   712,
     465,   713,   466,     0,   467,   468,   469,   714,   470,   471,
     472,   715,   716,   473,   474,   475,  2816,   477,   717,   478,
     479,   480,   718,     0,   481,   719,   482,   483,   484,   162,
     485,   486,   164,   720,   487,   721,   488,   166,     0,   722,
     489,   723,   490,   167,   724,   168,   491,   492,   725,   493,
     170,   726,   494,   727,   495,   496,   497,   498,   499,   171,
     500,   501,   502,   728,   503,   504,   505,   506,   507,   508,
     729,   172,   173,   730,   509,   510,   511,   731,   175,   732,
     176,   733,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,   734,   180,   181,   520,   182,   735,
     521,   522,   523,   736,   737,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,   188,
     189,   738,   537,   538,   539,   540,   541,   542,   543,   190,
     544,   739,   545,   546,   192,   547,   740,   193,   548,   194,
     549,   550,   741,   742,   551,   743,   744,   745,   552,   553,
       0,   746,   747,   195,   196,   197,   198,   199,   554,   555,
     556,   557,     0,   558,   748,   559,   200,     0,   201,   560,
     561,   562,   749,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,   750,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,   751,   582,   583,   209,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
     752,   593,   594,     0,   595,   753,  2817,   215,   597,   598,
     217,   599,   218,   754,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,   755,   611,   612,   756,
     613,   614,   615,   616,   617,   757,   222,   223,   758,   759,
     619,   224,   620,   225,   760,   621,   622,   623,     0,   624,
     625,   761,   762,   626,   627,   628,   629,   763,   764,   630,
     631,   632,   633,     0,   233,   765,   635,   234,   636,   637,
     638,   766,   767,   639,   768,   769,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,   681,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   682,   104,   105,   403,
     683,     0,   107,   108,   109,   110,   684,   685,   112,   113,
     114,   115,     0,   116,   686,   687,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,   149,   457,     0,     0,     0,     0,   150,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,   167,     0,   168,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,   171,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,   172,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,   177,   178,   512,   179,   513,
     514,   515,   516,   517,   518,   519,     0,   180,   181,   520,
     182,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,   188,   189,  1002,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,   192,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,  1003,     0,     0,
     552,   553,     0,     0,     0,   195,   196,   197,   198,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
     209,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,   217,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,   234,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,   681,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   682,   104,
     105,   403,   683,     0,   107,   108,   109,   110,   684,   685,
     112,   113,   114,   115,     0,   116,   686,   687,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,   149,   457,     0,     0,     0,     0,
     150,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,   167,     0,   168,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,  1227,   171,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,   172,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,   177,   178,   512,
     179,   513,   514,   515,   516,   517,   518,   519,     0,   180,
     181,   520,   182,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,   188,   189,  1002,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,   192,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,  1003,
       0,     0,   552,   553,     0,     0,     0,   195,   196,   197,
     198,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,   209,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,   217,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,   234,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
     681,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     682,   104,   105,   403,   683,     0,   107,   108,   109,   110,
     684,   685,   112,   113,   114,   115,     0,   116,   686,   687,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,   136,   137,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,   149,   457,     0,     0,
       0,     0,   150,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,   167,
       0,   168,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,  1235,   171,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,   172,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,   177,
     178,   512,   179,   513,   514,   515,   516,   517,   518,   519,
       0,   180,   181,   520,   182,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,   188,   189,  1002,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
     192,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,  1003,     0,     0,   552,   553,     0,     0,     0,   195,
     196,   197,   198,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,   209,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,   217,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,   234,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1699,   137,  1700,  1701,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
    1702,  1703,   437,     0,   438,   439,   440,   441,     0,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,   149,   457,
       0,     0,     0,     0,   150,     0,     0,     0,   458,   459,
     460,   461,   462,   463,  1704,  1705,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,  1343,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,     0,   485,   486,
       0,     0,   487,     0,   488,  1706,     0,     0,   489,     0,
     490,   167,     0,   168,   491,   492,     0,   493,     0,     0,
     494,     0,   495,   496,   497,   498,   499,   171,   500,   501,
     502,  2191,   503,   504,   505,   506,   507,   508,     0,   172,
    2192,     0,   509,   510,   511,  1349,  1707,     0,  1708,     0,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,     0,     0,   181,   520,   182,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,  1709,   188,  1710,     0,
     537,   538,   539,   540,   541,   542,   543,     0,   544,     0,
     545,   546,   192,   547,     0,     0,   548,  1711,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,  2193,   196,   197,   198,     0,   554,   555,   556,   557,
       0,   558,     0,   559,     0,     0,     0,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,  1712,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,   209,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,  2194,   597,   598,   217,   599,
    1714,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,     0,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,  1715,  1716,     0,     0,   619,     0,
     620,     0,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,     0,  1717,  2195,   635,   234,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,     0,
       0,     0,     0,     0,     0,     0,     0,   644,   645,   646,
       0,     0,     0,    55,   681,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1699,   137,
    1700,  1701,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,  1702,  1703,   437,     0,   438,   439,   440,   441,
       0,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
     149,   457,     0,     0,     0,     0,   150,     0,     0,     0,
     458,   459,   460,   461,   462,   463,  1704,  1705,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,  1343,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,     0,
     485,   486,     0,     0,   487,     0,   488,  1706,     0,     0,
     489,     0,   490,   167,     0,   168,   491,   492,     0,   493,
       0,     0,   494,     0,   495,   496,   497,   498,   499,   171,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,   172,     0,     0,   509,   510,   511,  1349,  1707,     0,
    1708,     0,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,     0,     0,   181,   520,   182,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,  1709,   188,
    1710,     0,   537,   538,   539,   540,   541,   542,   543,     0,
     544,     0,   545,   546,   192,   547,  2183,     0,   548,  1711,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,     0,   196,   197,   198,     0,   554,   555,
     556,   557,     0,   558,     0,   559,     0,     0,     0,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
    1712,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,   209,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,  2194,   597,   598,
     217,   599,  1714,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,     0,   611,   612,  3407,
     613,   614,   615,   616,   617,     0,  1715,  1716,     0,     0,
     619,     0,   620,     0,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,     0,  1717,     0,   635,   234,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,     0,     0,     0,     0,     0,     0,     0,     0,   644,
     645,   646,     0,     0,     0,    55,   681,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   682,   104,   105,   403,
     683,     0,   107,   108,   109,   110,   684,   685,   112,   113,
     114,   115,     0,   116,   686,   687,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1699,   137,  1700,  1701,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,  1702,  1703,   437,     0,   438,   439,
     440,   441,     0,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,   149,   457,     0,     0,     0,     0,   150,     0,
       0,     0,   458,   459,   460,   461,   462,   463,  1704,  1705,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,  1343,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,     0,   485,   486,     0,     0,   487,     0,   488,  1706,
       0,     0,   489,     0,   490,   167,     0,   168,   491,   492,
       0,   493,     0,     0,   494,     0,   495,   496,   497,   498,
     499,   171,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,   172,     0,     0,   509,   510,   511,  1349,
    1707,     0,  1708,     0,     0,   177,   178,   512,   179,   513,
     514,   515,   516,   517,   518,   519,     0,     0,   181,   520,
     182,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
    1709,   188,  1710,     0,   537,   538,   539,   540,   541,   542,
     543,  2232,   544,     0,   545,   546,   192,   547,     0,     0,
     548,  1711,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,     0,   196,   197,   198,     0,
     554,   555,   556,   557,     0,   558,     0,   559,     0,     0,
       0,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,  1712,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
     209,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,  1713,
     597,   598,   217,   599,  1714,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,     0,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,  1715,  1716,
       0,     0,   619,     0,   620,     0,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,     0,  1717,     0,   635,   234,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,     0,     0,     0,     0,     0,     0,     0,
       0,   644,   645,   646,     0,     0,     0,    55,   681,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   682,   104,
     105,   403,   683,     0,   107,   108,   109,   110,   684,   685,
     112,   113,   114,   115,     0,   116,   686,   687,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,  1699,   137,  1700,  1701,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,  1702,  1703,   437,     0,
     438,   439,   440,   441,     0,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,   149,   457,     0,     0,     0,     0,
     150,     0,     0,     0,   458,   459,   460,   461,   462,   463,
    1704,  1705,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,  1343,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,     0,   485,   486,     0,     0,   487,     0,
     488,  1706,     0,     0,   489,     0,   490,   167,     0,   168,
     491,   492,     0,   493,     0,     0,   494,     0,   495,   496,
     497,   498,   499,   171,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,   172,     0,     0,   509,   510,
     511,  1349,  1707,     0,  1708,     0,     0,   177,   178,   512,
     179,   513,   514,   515,   516,   517,   518,   519,     0,     0,
     181,   520,   182,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,  1709,   188,  1710,     0,   537,   538,   539,   540,
     541,   542,   543,  3257,   544,     0,   545,   546,   192,   547,
       0,     0,   548,  1711,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,     0,   196,   197,
     198,     0,   554,   555,   556,   557,     0,   558,     0,   559,
       0,     0,     0,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,  1712,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,   209,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,  1713,   597,   598,   217,   599,  1714,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
    1715,  1716,     0,     0,   619,     0,   620,     0,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,     0,  1717,     0,
     635,   234,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,     0,     0,     0,     0,     0,
       0,     0,     0,   644,   645,   646,     0,     0,     0,    55,
     681,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     682,   104,   105,   403,   683,     0,   107,   108,   109,   110,
     684,   685,   112,   113,   114,   115,     0,   116,   686,   687,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1699,   137,  1700,  1701,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,  1702,  1703,
     437,     0,   438,   439,   440,   441,     0,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,   149,   457,     0,     0,
       0,     0,   150,     0,     0,     0,   458,   459,   460,   461,
     462,   463,  1704,  1705,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,  1343,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,     0,   485,   486,     0,     0,
     487,     0,   488,  1706,     0,     0,   489,     0,   490,   167,
       0,   168,   491,   492,     0,   493,     0,     0,   494,     0,
     495,   496,   497,   498,   499,   171,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,   172,     0,     0,
     509,   510,   511,  1349,  1707,     0,  1708,     0,     0,   177,
     178,   512,   179,   513,   514,   515,   516,   517,   518,   519,
       0,     0,   181,   520,   182,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,  1709,   188,  1710,     0,   537,   538,
     539,   540,   541,   542,   543,     0,   544,     0,   545,   546,
     192,   547,     0,     0,   548,  1711,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,     0,
     196,   197,   198,     0,   554,   555,   556,   557,     0,   558,
       0,   559,     0,     0,     0,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,  1712,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,   209,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,  1713,   597,   598,   217,   599,  1714,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
       0,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,  1715,  1716,     0,     0,   619,     0,   620,     0,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,     0,
    1717,     0,   635,   234,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,     0,     0,     0,
       0,     0,     0,     0,     0,   644,   645,   646,     0,     0,
       0,    55,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1699,   137,  1700,  1701,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
    1702,  1703,   437,     0,   438,   439,   440,   441,     0,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,   149,   457,
       0,     0,     0,     0,   150,     0,     0,     0,   458,   459,
     460,   461,   462,   463,  1704,  1705,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,  1343,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,     0,   485,   486,
       0,     0,   487,     0,   488,  1706,     0,     0,   489,     0,
     490,   167,     0,   168,   491,   492,     0,   493,     0,     0,
     494,     0,   495,   496,   497,   498,   499,   171,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,   172,
       0,     0,   509,   510,   511,  1349,  1707,     0,  1708,     0,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,     0,     0,   181,   520,   182,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,  1709,   188,  1710,     0,
     537,   538,   539,   540,   541,   542,   543,     0,   544,     0,
     545,   546,   192,   547,     0,     0,   548,  1711,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,     0,   196,   197,   198,     0,   554,   555,   556,   557,
       0,   558,     0,   559,     0,     0,     0,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,  1712,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,   209,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,  2194,   597,   598,   217,   599,
    1714,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,     0,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,  1715,  1716,     0,     0,   619,     0,
     620,     0,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,     0,  1717,     0,   635,   234,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,     0,
       0,     0,     0,     0,     0,     0,     0,   644,   645,   646,
       0,     0,     0,    55,   681,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1699,   137,
    1700,  1701,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,  1702,  1703,   437,     0,   438,   439,   440,   441,
       0,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
     149,   457,     0,     0,     0,     0,   150,     0,     0,     0,
     458,   459,   460,   461,   462,   463,  1704,  1705,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,  1343,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,     0,
     485,   486,     0,     0,   487,     0,   488,  1706,     0,     0,
     489,     0,   490,   167,     0,   168,   491,   492,     0,   493,
       0,     0,   494,     0,   495,   496,   497,   498,   499,   171,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,   172,     0,     0,   509,   510,   511,  1349,  1707,     0,
    1708,     0,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,     0,     0,   181,   520,   182,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,  1709,   188,
    1710,     0,   537,   538,   539,   540,   541,   542,   543,     0,
     544,     0,   545,   546,   192,   547,     0,     0,   548,  1711,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,     0,   196,   197,   198,     0,   554,   555,
     556,   557,     0,   558,     0,   559,     0,     0,     0,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
    1712,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,   209,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,     0,   597,   598,
     217,   599,  1714,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,  1715,  1716,     0,     0,
     619,     0,   620,     0,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,     0,  1717,     0,   635,   234,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,     0,     0,     0,     0,     0,     0,     0,     0,   644,
     645,   646,     0,     0,     0,    55,   681,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   682,   104,   105,   403,
     683,     0,   107,   108,   109,   110,   684,   685,   112,   113,
     114,   115,     0,   116,   686,   687,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
       0,   137,     0,     0,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,     0,     0,   437,     0,   438,   439,
     440,   441,     0,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,   149,   457,     0,     0,     0,     0,   150,     0,
       0,     0,   458,   459,   460,   461,   462,   463,     0,     0,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,     0,   485,   486,     0,     0,   487,     0,   488,     0,
       0,     0,   489,     0,   490,   167,     0,   168,   491,   492,
       0,   493,     0,     0,   494,     0,   495,   496,   497,   498,
     499,   171,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,   172,     0,     0,   509,   510,   511,     0,
       0,     0,     0,     0,     0,   177,   178,   512,   179,   513,
     514,   515,   516,   517,   518,   519,     0,     0,   181,   520,
     182,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
       0,   188,     0,     0,   537,   538,   539,   540,   541,   542,
     543,     0,   544,     0,   545,   546,   192,   547,     0,     0,
     548,     0,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,     0,   196,   197,   198,     0,
     554,   555,   556,   557,     0,   558,     0,   559,     0,     0,
       0,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,     0,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
     209,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,     0,
     597,   598,   217,   599,     0,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,     0,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,     0,     0,
       0,     0,   619,     0,   620,     0,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,     0,     0,     0,   635,   234,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,     0,     0,     0,     0,     0,     0,     0,
       0,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,   688,   422,   423,   424,   689,   690,   691,   692,   693,
     694,   695,   425,   426,   696,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,   697,   431,   432,     0,   433,
     434,   698,   699,     0,   435,     0,   140,   437,   701,   438,
     439,   440,   441,   144,   702,   703,   442,   443,   444,   445,
     446,   447,   704,   448,   449,   450,   451,   452,   453,   705,
     454,   455,   456,   149,   457,     0,   706,   707,   708,   150,
     709,   710,   711,   458,   459,   460,   461,     0,   463,   153,
     154,   464,   712,   465,   713,   466,     0,   467,   468,   469,
     714,   470,   471,   472,   715,   716,   473,   474,   475,   476,
     477,   717,   478,   479,   480,   718,     0,   481,   719,   482,
     483,   484,   162,   485,   486,   164,   720,   487,   721,   488,
     166,     0,   722,   489,   723,   490,   167,   724,   168,   491,
     492,   725,   493,   170,   726,   494,   727,   495,   496,     0,
     498,   499,   171,   500,   501,   502,   728,   503,   504,   505,
     506,   507,   508,   729,   172,   173,     0,   509,   510,   511,
       0,   175,   732,   176,   733,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,   734,   180,   181,
     520,   182,   735,   521,   522,   523,   736,   737,   524,   525,
     526,   527,   528,   529,     0,   531,   532,     0,   534,   535,
     536,   187,   188,   189,   738,   537,   538,   539,   540,   541,
     542,   543,   190,   544,   739,   545,   546,   192,   547,   740,
     193,   548,   194,   549,   550,   741,   742,   551,   743,   744,
     745,   552,   553,     0,   746,   747,   195,   196,   197,   198,
     199,   554,   555,   556,   557,     0,   558,   748,   559,   200,
       0,   201,   560,   561,   562,   749,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,   750,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,   751,   582,
     583,   209,   584,   585,   211,   586,   587,   588,   589,   590,
     591,     0,     0,   752,   593,   594,     0,   595,   753,   596,
     215,   597,   598,   217,   599,   218,   754,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,   755,
     611,   612,   756,   613,   614,   615,   616,   617,   757,   222,
     223,     0,   759,   619,   224,   620,   225,   760,   621,   622,
     623,     0,   624,   625,     0,   762,   626,   627,   628,   629,
     763,   764,   630,   631,   632,   633,     0,   233,   765,   635,
     234,   636,   637,   638,   766,   767,   639,   768,   769,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,     0,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,  2163,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,  2164,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,  2165,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,  2927,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,  2166,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,  2167,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     971,   420,   421,   930,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,   931,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,   972,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,   932,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,   933,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,   667,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,   668,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,   669,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,   930,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,   931,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,   932,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,   933,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,  1862,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,  1863,
     490,     0,     0,     0,  1864,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,  1865,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,  1002,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,  1003,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,  1866,   590,   591,   592,     0,     0,  1867,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,  1868,  1869,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,  2609,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,  2610,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,  2611,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
    1002,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,  1003,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,  2612,   613,
    2613,   615,  2614,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,   130,   131,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,  1002,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,  1003,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,   864,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,   865,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   866,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,  1002,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,  1003,     0,  1004,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,  1431,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,  1002,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,  1003,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
     931,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,   932,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,   933,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,   669,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,  1002,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,  1003,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,  1222,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,   916,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,   917,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,  2273,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,  2274,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,  2752,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,  2753,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,  2762,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,  2763,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
     676,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,   817,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   907,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   947,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
    1444,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,   983,   435,   958,
     140,  1445,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,     0,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   987,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   988,   585,   211,   586,
     587,   588,   989,   590,   591,   592,     0,     0,   593,   594,
       0,  1435,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   991,   223,     0,     0,   992,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     962,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   993,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,  1775,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,  2965,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,  2978,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,  3015,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,  3678,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,  3680,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,  3682,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,  4045,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   870,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   955,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,   957,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   958,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,     0,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   959,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   960,   223,     0,     0,   961,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   962,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,   996,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   958,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,     0,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   997,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   998,   223,     0,     0,
     999,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   962,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,  1021,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
    1143,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,  1206,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,  1232,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,  1237,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,  1245,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,  1247,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,  1249,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,  1251,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,  1254,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,  1256,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,  1257,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
    1260,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,   983,   435,   958,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,     0,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     987,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   988,   585,   211,   586,   587,   588,   989,   590,
     591,   592,     0,     0,   593,   594,     0,  1435,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   991,
     223,     0,     0,   992,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   962,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   993,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,  1467,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
       0,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
    1557,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,  1770,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,  1801,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,  1803,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,  1897,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
     983,   435,   958,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,     0,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   987,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   988,
     585,   211,   586,   587,   588,   989,   590,   591,   592,     0,
       0,   593,   594,     0,  1435,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
    2160,   614,   615,   616,   617,     0,   991,   223,     0,     0,
     992,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   962,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     993,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,   983,   435,   958,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,     0,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   987,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     988,   585,   211,   586,   587,   588,  2187,   590,   591,   592,
       0,     0,   593,   594,     0,  1435,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   991,   223,     0,
       0,   992,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   962,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   993,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
    2404,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,     0,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,    86,    87,    88,    55,    90,
      91,    92,     0,     0,     0,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,     0,     0,     0,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
   -1830,   116,   117,   118,     0,     0,     0,     0,     0,   121,
     122,     0,     0,     0,     0,   123,     0,     0,     0,     0,
       0,     0,     0,     0,   124,     0,   125,     0,   126,   127,
       0,    35,     0,   394,     0,     0,     0,     0,     0,    41,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
     144,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     149,     0,     0,     0,     0,     0,   150,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   153,   154,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   160,     0,     0,     0,     0,     0,   162,
       0,     0,   164,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,   167,     0,   168,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,     0,     0,   171,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   172,   173,     0,     0,     0,     0,     0,   175,     0,
     176,     0,     0,   177,   178,     0,   179,     0,     0,     0,
       0,     0,     0,     0,     0,   180,   181,     0,   182,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   187,   188,
     189,     0,     0,     0,     0,     0,     0,     0,     0,   190,
       0,     0,     0,     0,   192,     0,     0,   193,     0,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   195,   196,   197,   198,   199,     0,     0,
       0,     0,     0,     0,     0,     0,   200,     0,   201,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   209,     0,
       0,   211,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   215,     0,     0,
     217,     0,   218,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,   223,     0,     0,
       0,   224,     0,   225,     0,     0,     0,     0,     0,     0,
       0,   228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,     0,     0,   234,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   236,   237,   238,   239,   240,   241,   242,   243,     0,
       0,     0,    86,    87,    88,    55,    90,    91,    92,     0,
       0,     0,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,     0,     0,     0,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115, -1831,   116,   117,
     118,     0,     0,     0,     0,     0,   121,   122,     0,     0,
       0,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   125,     0,   126,   127,     0,    35,     0,
    1067,     0,     0,     0,     0,     0,    41,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     133,     0,     0,     0,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,   144,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   149,     0,     0,
       0,     0,     0,   150,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   153,   154,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     160,     0,     0,     0,     0,     0,   162,     0,     0,   164,
       0,     0,     0,     0,   166,     0,     0,     0,     0,     0,
     167,     0,   168,     0,     0,     0,     0,   170,     0,     0,
       0,     0,     0,     0,     0,     0,   171,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   172,   173,
       0,     0,     0,     0,     0,   175,     0,   176,     0,     0,
     177,   178,     0,   179,     0,     0,     0,     0,     0,     0,
       0,     0,   180,   181,     0,   182,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   187,   188,   189,     0,     0,
       0,     0,     0,     0,     0,     0,   190,     0,     0,     0,
       0,   192,     0,     0,   193,     0,   194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     195,   196,   197,   198,   199,     0,     0,     0,     0,     0,
       0,     0,     0,   200,     0,   201,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   209,     0,     0,   211,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   215,     0,     0,   217,     0,   218,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   220,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   222,   223,     0,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,     0,     0,   228,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,     0,     0,   234,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   236,   237,
     238,   239,   240,   241,   242,   243,     0,     0,     0,    86,
      87,    88,    55,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,     0,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   149,     0,     0,     0,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     153,   154,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   160,     0,     0,
       0,     0,     0,   162,     0,     0,   164,     0,     0,     0,
       0,   166,     0,     0,     0,     0,     0,   167,     0,   168,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,     0,     0,   171,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   172,   173,     0,     0,     0,
       0,     0,   175,     0,   176,     0,     0,   177,   178,     0,
     179,     0,     0,     0,     0,     0,     0,     0,     0,   180,
     181,     0,   182,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   187,   188,   189,     0,     0,     0,     0,     0,
       0,     0,     0,   190,     0,     0,     0,     0,   192,     0,
       0,   193,     0,   194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   195,   196,   197,
     198,   199,     0,     0,     0,     0,     0,     0,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   209,     0,     0,   211,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   215,     0,     0,   217,     0,   218,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   220,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     222,   223,     0,     0,     0,   224,     0,   225,     0,     0,
       0,     0,     0,     0,     0,   228,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,     0,
       0,   234,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   236,   237,   238,   239,   240,
     241,   242,   243,     0,     0,     0,    86,    87,    88,    55,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115,     0,   116,   117,   118,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,   144,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   149,     0,     0,     0,     0,     0,   150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   153,   154,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   160,     0,     0,     0,     0,     0,
     162,     0,     0,   164,     0,     0,     0,     0,   166,     0,
       0,     0,     0,     0,   167,     0,   168,     0,     0,     0,
       0,   170,     0,     0,     0,     0,     0,     0,     0,     0,
     171,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   172,   173,     0,     0,     0,     0,     0,   175,
       0,   176,     0,     0,   177,   178,     0,   179,     0,     0,
       0,     0,     0,     0,     0,     0,   180,   181,     0,   182,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   187,
     188,   189,     0,     0,     0,     0,     0,     0,     0,     0,
     190,     0,     0,     0,     0,   192,     0,     0,   193,     0,
     194,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   195,   196,   197,   198,   199,     0,
       0,     0,     0,     0,     0,     0,     0,   200,     0,   201,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   209,
       0,     0,   211,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   215,     0,
       0,   217,     0,   218,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,   223,     0,
       0,     0,   224,     0,   225,     0,     0,     0,     0,     0,
       0,     0,   228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,     0,     0,   234,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   236,   237,   238,   239,   240,   241,   242,   243,
       0,     0,     0,    86,    87,    88,    55,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   149,     0,
       0,     0,     0,     0,   150,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   153,   154,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   162,     0,     0,
     164,     0,     0,     0,     0,   166,     0,     0,     0,     0,
       0,   167,     0,   168,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,     0,     0,   171,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   172,
     173,     0,     0,     0,     0,     0,   175,     0,   176,     0,
       0,   177,   178,     0,   179,     0,     0,     0,     0,     0,
       0,     0,     0,   180,   181,     0,   182,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   187,   188,   189,     0,
       0,     0,     0,     0,     0,     0,     0,   190,     0,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   195,   196,   197,   198,   199,     0,     0,     0,     0,
       0,     0,     0,     0,   200,     0,   201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   209,     0,     0,   211,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   215,     0,     0,   217,     0,
     218,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   222,   223,     0,     0,     0,   224,
       0,   225,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,     0,     0,   234,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   236,
     237,   238,   239,   240,   241,   242,   243,     0,     0,     0,
       0,     0,     0,    55
};

static const short yycheck[] =
{
       2,  1081,   838,   165,  1036,   244,   800,  1036,  1236,     2,
     226,    78,   152,  1243,   117,    78,   932,   933,  1613,  1038,
      89,   937,  1825,  1307,   186,   985,   151,     2,  1151,   148,
    1864,   988,  1293,    78,  1786,  2199,  1729,    94,    78,  1205,
    1134,  1110,    78,  1713,   838,  1341,  1342,   169,    84,  1832,
    1144,   887,    78,  2199,  2200,   117,  1370,   160,   679,   208,
    1320,  2624,   202,   362,  1360,   362,  2231,   221,    78,   992,
    1511,  1512,  1513,    78,    84,   132,   230,  1100,  1646,    84,
     147,  1463,  2011,   132,  2486,  1762,   208,    89,  2662,  2815,
    1182,  2817,  1186,   887,   151,  2953,   165,  1191,   160,   207,
     792,  1900,   348,  1748,  1198,   797,   214,   117,   216,    78,
    1597,  2062,  1748,  1207,  2306,    84,  2460,   186,  1748,  1748,
    1061,  1748,  1748,  2388,  1000,   228,  2393,  2394,   334,   348,
    1081,   117,  3190,  2906,  2918,   827,  1228,  2399,   214,  1640,
     158,  3360,  3408,  2878,  1821,   207,  1566,  2071,   117,   151,
     160,  1275,   214,  1266,   216,  3380,  2068,    21,  1213,  2108,
    1114,    30,  1076,  1077,  1033,   117,   228,  2332,  1331,  1332,
    1033,  2906,    10,  1081,   160,    71,    71,   244,  3086,  1561,
      72,    73,   184,    73,    98,   877,   110,   124,    80,   117,
     165,   160,   884,  1356,    73,  2144,   143,   153,   904,  2148,
     133,    83,    76,    77,    78,    79,   108,   103,   160,    72,
    3883,   186,   170,   194,    37,    73,   164,    80,   228,   117,
     117,  2892,  2893,  2894,  2895,  2896,  2897,   252,    89,    73,
      25,    89,    78,    78,   117,    96,    84,    25,   207,    84,
     169,   215,   228,   864,   163,   214,  2411,   216,  2413,   215,
      73,   153,   196,    76,    77,    78,    79,   170,  3430,   228,
    3432,   102,   215,   217,  1180,   136,   117,    73,   786,    73,
    1963,    89,   117,   315,   294,   234,   228,   160,    96,    71,
     215,   348,   220,   314,   170,    89,   227,   354,  3832,   237,
    3910,   354,    76,    77,    78,    79,   170,   350,   372,   294,
      90,  4052,  1259,   282,   215,    85,   250,   256,   254,   354,
      76,    77,    78,    79,   354,   160,   198,   141,    22,    76,
      77,    78,    79,   189,    89,  1448,    71,   419,   354,   217,
    1166,    96,    76,    77,    78,    79,   389,    76,    77,    78,
      79,   282,   399,   197,  3888,   228,   147,   171,    71,   104,
      71,   421,   362,   102,   173,   243,    14,   362,  3577,   175,
     396,   982,    76,    77,    78,    79,  2315,   252,    14,    73,
     125,   317,  1166,    76,    77,    78,    79,   177,   317,   323,
     103,   235,   103,   228,   437,   124,   396,   147,   458,   302,
    1413,   396,   484,   362,   252,    76,    77,    78,    79,  1275,
     379,   350,  1716,    78,    71,  4025,  4157,   187,  1704,  1705,
    1286,  1287,   231,   170,   238,  1711,   302,   364,   219,    71,
     374,   252,    38,   497,    40,    29,   252,   396,    76,    77,
      78,    79,    76,    77,    78,    79,   103,   365,   379,  3983,
    4191,   117,    71,    76,    77,    78,    79,   442,   252,    71,
     187,   471,  1680,   248,  1684,   497,   170,   247,   215,   219,
     248,   409,   410,   376,  1156,   384,   419,   365,   365,   500,
      89,  1163,  3691,   429,   165,  3248,   501,    76,    77,    78,
      79,   103,    76,    77,    78,    79,   419,  1444,   432,   788,
     372,   788,   421,   618,    76,    77,    78,    79,    76,    77,
      78,    79,    76,    77,    78,    79,  1447,   389,   354,   254,
    1451,  1452,  3731,  3248,   365,  1274,   497,   362,    76,    77,
      78,    79,  1214,   497,  2194,   124,   484,   429,  4201,   458,
    1696,   254,   255,   394,   500,  1411,   227,   170,    89,  1702,
    1703,   500,  1636,    94,  1638,  3216,    73,  1710,   396,  1672,
     330,   396,  2464,   500,    76,    77,    78,    79,  1264,   430,
     497,   618,   500,   307,   443,   500,   407,  3475,    76,    77,
      78,    79,   500,   497,   319,   439,   394,  1453,  1454,  3751,
    1098,   132,   305,   497,   476,  1677,   452,   254,  3151,   500,
     482,   282,   482,  2739,   285,  2741,  1857,   493,   493,  1693,
     151,   152,   254,   500,   478,   443,   366,   387,   482,  2177,
     161,  1525,  3831,   476,   165,   500,   618,  1999,   294,  1674,
    1528,   437,   679,  2005,   482,   254,   495,   491,  1497,   394,
     488,   489,  1391,    71,  1497,   186,  2388,   126,   482,   439,
     244,  1582,  1596,   501,   488,   489,  2558,  1588,    92,   500,
     387,   202,   806,   497,   477,   478,   479,   480,   407,   482,
    2852,  1730,   419,  2855,  2856,   488,   489,  2859,   215,   794,
     501,  3342,  3897,   499,    73,    85,   482,  2869,   482,   354,
     312,   784,   488,   489,   488,   489,   302,  1628,   379,   365,
    1631,  1632,  2857,  2858,   478,  2644,   456,   501,   490,   491,
     492,   493,  2631,  2968,   910,    71,   831,  2972,   447,   252,
     175,   387,   478,   497,  1838,  1770,  1829,   336,   872,   400,
     401,   478,   784,   212,   130,  2649,   866,   484,   312,   495,
     353,   497,  2878,   499,   478,   198,   481,  2157,   498,   478,
    1681,   501,   499,   488,   489,   490,   491,   492,   493,   911,
     252,   913,   326,   915,   457,    85,   881,  4165,   497,   921,
    2906,   108,  1925,  1926,   478,   488,   489,   490,   491,   492,
     493,   172,   475,     0,   784,   478,   198,   187,   788,   470,
     210,   246,   256,   788,  4050,  1621,  3926,   138,   885,   943,
    1575,   252,   889,   412,   497,   414,   234,   478,   784,   447,
     330,   252,   899,   821,    97,  2951,   497,   864,    71,   318,
     217,  1768,  4220,   457,   175,   784,   254,   138,  1603,   788,
     822,   488,   489,   490,   491,   492,   493,  1621,   179,   359,
     478,   475,   784,   448,   478,   853,   488,   489,   490,   491,
     492,   493,   911,   216,   913,   478,   915,  3712,   399,   497,
     907,  1767,   921,   497,   343,   215,  1010,   187,   179,   488,
     489,   490,   491,   492,   493,   497,  2618,  2368,   490,   491,
     492,   493,   419,  3731,   497,   345,   350,   170,   986,   478,
     138,   319,   990,   230,   478,   246,   218,   234,   254,    73,
     252,   126,    76,    77,    78,    79,   478,   222,   497,  4118,
     478,   784,   904,   497,   478,   140,   307,  1867,  1868,   315,
     986,   904,   319,   497,   990,   497,   381,  3701,   362,   497,
     478,   179,   269,  3185,   986,   982,   389,   984,   990,   904,
     374,   361,   217,    71,   172,   984,   911,   484,   913,   784,
     915,   273,  2635,   788,   433,   947,   921,   922,   923,   359,
     477,   460,   499,   319,   170,   482,   478,    95,   501,   332,
    1836,   488,   489,    76,    77,    78,    79,   389,  3694,  1805,
     478,  4111,   437,   975,  1850,   497,   163,   212,   439,   423,
     331,   983,  3545,  3546,  3547,   987,   988,   989,   439,   497,
     215,   254,  1061,    76,    77,    78,    79,   410,   174,   501,
     330,  1011,    76,    77,    78,    79,  1011,  1076,  1077,   234,
     331,  1805,  1081,    76,    77,    78,    79,   986,   182,   392,
     184,   990,    76,    77,    78,    79,   500,   497,  2324,   359,
      76,    77,    78,    79,   319,    76,    77,    78,    79,   173,
    3905,   101,  1011,   481,   391,   370,   484,   485,   486,   175,
     488,   489,   490,   491,   492,   493,   319,   456,  4116,  4117,
    3335,   187,   413,  2143,   302,   426,  3839,   618,  1061,    76,
      77,    78,    79,   331,  1076,  1077,   437,   253,   477,  1081,
     412,   174,   414,   482,    89,   182,  1061,   184,  1081,   488,
     489,   307,   413,   118,  1786,  1931,  1788,   231,   389,   160,
    2266,   126,  3248,  3295,  3839,  1797,  1081,   294,   343,  3301,
    3302,  3303,  3304,  3305,  3306,   481,   254,   402,  3462,   485,
     486,    99,   488,   489,   490,   491,   492,   493,   679,   170,
      76,    77,    78,    79,  4192,   329,   419,  1931,   302,    51,
    1899,  1900,    76,    77,    78,    79,   437,  1244,   312,   207,
    3417,  1910,  1391,    85,  1913,   413,  3421,    69,  2726,    91,
     253,  3426,  1921,  1922,  3429,    73,  1011,   228,    76,    77,
      78,    79,  1864,   233,  2050,  1934,  1935,   182,  2406,  1181,
    3014,   319,   421,   294,  2414,  2126,  1945,  2353,  2354,  2355,
    2356,   484,  2143,   209,    76,    77,    78,    79,   433,    89,
     178,  1298,   495,   147,   497,   498,   499,   500,   330,  1276,
     321,   172,  1309,  1276,   340,   312,  2968,   500,   481,   330,
    2972,   484,   485,   486,  1321,   488,   489,   490,   491,   492,
     493,  1276,  3183,  3398,  1301,   293,  1276,   359,  1301,  1485,
    1486,  2000,  1488,  3042,    76,    77,    78,    79,   273,  1306,
    1276,  2738,   173,  3827,  1553,   187,  1553,  1259,  1325,   165,
    4118,  1263,  1264,  2908,  1266,  1471,  1485,  1486,  2650,  1488,
    1263,  1264,  2908,  1266,  3439,   219,  3441,  1344,  2908,  2908,
     241,  2908,  2908,    76,    77,    78,    79,  3875,  1263,  1264,
    4016,  1266,   182,   477,   478,   479,   480,   147,   482,   361,
     307,  2242,  4047,  4048,   488,   489,   140,  1374,  2400,  2250,
     231,  2252,   863,   864,     8,   866,   419,    11,    12,   372,
     497,   227,   338,   342,  1391,  3002,   207,   138,    22,    23,
      24,   442,    26,    27,   501,   216,   170,    31,    32,    33,
     372,   302,  2937,   481,   302,   398,   484,   485,   486,    25,
     488,   489,   490,   491,   492,   493,   907,   321,  1461,    35,
     911,   307,   913,   330,   915,   478,   330,  3769,   179,   219,
     921,  1428,  1429,  2396,   342,   497,   282,   374,  1447,  1428,
    1429,  1478,  1451,  1452,   497,  3660,  3661,  3662,  3663,  3664,
     348,  1393,   359,   126,   456,   478,   363,   500,   330,  1461,
     133,  1403,   421,   206,   478,   437,   141,   140,   140,   175,
    4155,   374,  1414,  3976,   497,   478,  4004,   456,  1485,  1486,
     387,  1488,   366,   497,   478,   282,   423,   359,   285,    72,
      73,   982,   478,   984,   497,   374,   171,   478,   500,   458,
    3632,  3633,  1444,   497,  2885,  1447,   216,   123,  2744,  1451,
    1452,  1461,   162,   421,  1447,  2716,  1525,   142,  1451,  1452,
     423,   500,  1570,  1566,    37,   165,  1523,   270,   302,   163,
    2427,   478,  1447,   379,  1523,  1461,  1451,  1452,   170,   212,
     246,   501,  1590,  3748,   423,   449,   218,   126,  4033,   456,
     458,   456,  1461,   349,  3063,  1505,  1506,  1507,   162,   184,
      73,  1506,  1507,   238,  1566,   237,   411,   133,  1570,  1461,
    1061,   314,   456,  1582,   140,  1623,   366,   373,  3087,  1588,
     331,  2142,   379,  1525,  1517,  1076,  1077,   227,  1590,  1080,
      87,   170,   478,   456,   503,   500,  1505,  1506,  1507,   495,
    1515,   273,  1517,  1553,   478,   501,  1539,  1540,  1553,   106,
    1560,   456,   457,  1505,   498,  1560,  1566,   501,  1533,  1628,
    4105,  1623,  1631,  1632,  1539,  1540,  3730,   924,  4113,   477,
     478,   281,   248,   283,   482,   239,   330,   500,  1461,   206,
    1566,   489,   282,   210,  1553,   285,   500,   944,   484,  1582,
     322,  1560,   497,   287,   330,  1588,   478,  1566,   412,  2981,
     414,  1570,   413,   499,   110,   359,   456,  1582,  1662,  4154,
     343,   163,  1681,  1588,  1566,   381,  1461,   281,   170,   283,
     218,  1590,  1505,   359,    72,    93,    94,  3556,    76,    77,
      78,    79,    80,   387,   457,  1628,  1875,    41,  1631,  1632,
    1743,  3023,  1644,   270,   410,   339,   478,  3340,   498,    71,
     439,   501,   475,  1628,  1623,   161,  1631,  1632,   495,   248,
    1505,  1506,  1507,   302,  3856,   502,   128,  2736,   307,  3421,
    1795,   437,    16,    95,  3426,   273,   165,  3429,   444,   379,
     412,  1743,   414,  1566,   146,   478,  1740,   314,  1681,   381,
     456,   423,  1746,  3839,   151,  2636,  2388,   159,   477,   381,
     433,   433,  1799,   482,   343,  2665,  1681,   163,  1553,  1763,
    2633,  1808,   382,   116,   260,  1560,   355,   165,   410,  1786,
    1839,  1566,  3290,  1820,    34,  1879,  3108,   381,   410,  3894,
     210,   497,   216,  1743,   428,   210,  2495,  1288,   227,   245,
     410,   110,  1136,   146,  1138,  1894,   378,  1749,   210,   229,
     302,  1145,   444,  2589,   229,  1306,   410,  1743,   242,   216,
     419,  2060,   444,  2060,   456,  1862,  1768,   497,  1865,  1866,
     470,  1893,  1869,   257,  1743,  3035,  3090,  3091,   382,   227,
     450,   423,  3928,   267,  2543,   242,  3569,   163,   294,   147,
     444,  1743,   161,   282,   433,  2589,   285,   497,  1111,   202,
     257,   361,   456,  1778,   139,   497,   410,   378,  1875,   330,
     267,   169,   346,  2572,   412,   497,   414,   175,  1885,   206,
    2441,  1134,  1885,   210,  3517,   498,   237,  1829,   501,   232,
    1832,  1144,   254,   290,   282,   144,  1829,   285,   359,  1832,
    1885,   199,  3126,   497,  3514,  1885,   450,   399,  2607,   502,
     402,   457,   450,   330,  1829,   457,   191,  1832,   376,  1885,
    1743,  2620,  2621,  1966,   182,  2659,   184,     7,  1419,   475,
     495,   377,   497,   475,   350,    73,   245,  1428,  1429,    19,
      20,   481,   359,   270,   360,   369,   204,  4051,   246,  1604,
     379,   497,  1607,   411,   163,   497,  1447,   319,  1743,    39,
    1451,  1452,    42,  1970,  1966,   359,   498,   383,   500,   363,
     387,   330,   369,    72,    73,     5,  1918,    76,    77,    78,
      79,    80,   229,  2085,   330,   294,  2618,   314,   263,   264,
     114,   379,  1647,   387,  3230,    25,  1911,  1912,   456,   457,
     359,   276,   495,   378,  1919,    35,   499,   359,  1923,  1924,
     492,   363,   412,   359,   414,   497,  1966,   499,  3219,  3220,
     363,   492,   365,  1938,   367,  1940,   497,   497,   499,   499,
     373,   175,  1523,  3725,  1525,   387,   498,   380,   500,   497,
    1966,   470,  1533,    71,   387,  1960,   495,  1962,   497,   307,
     499,  2907,   395,  2950,   312,   330,  3748,  1966,   500,   501,
     403,   500,   456,   143,   182,   504,   184,  2074,   377,   313,
     498,   170,   500,   317,  1966,   103,  2085,   500,   123,   124,
     108,   504,   470,   381,   260,   496,   204,  2029,   476,   500,
     478,  1582,   498,   123,  2159,   501,  2011,  1588,  2542,  3873,
    2544,  2545,   246,   183,   456,  3311,  3312,   175,   451,  3315,
    2060,  3317,   410,  3176,  2157,  2060,   496,  2126,   503,   481,
     500,  2130,   484,   485,   486,   497,   488,   489,   490,   491,
     492,   493,   252,  2109,  2143,  2111,   411,  1628,   413,   437,
    1631,  1632,   497,  1966,  2878,  2142,   444,   104,   498,    71,
     500,  2060,   251,   482,   110,  2157,   186,   317,   456,  2109,
     304,  2111,   114,   498,  2109,   500,  2111,   425,  2205,   376,
    2085,   472,  2906,    95,   273,   256,   434,    98,   246,  1948,
    2223,  1966,  1951,   498,   302,   500,   499,   376,  2130,   307,
    1681,  3824,   320,  2126,   312,   116,   152,   456,   457,   497,
    2109,  2143,  2111,  2145,   411,  2147,   234,  2157,   320,  2388,
    2143,  2126,  2145,   498,  2147,   500,   317,  3226,   248,   419,
     176,  2223,   411,   372,   373,   146,   254,   255,  2143,  3921,
    2145,  2157,  2147,  2242,   472,   303,   304,   381,   498,   195,
     500,  2250,   498,  2252,   500,  2187,   372,   373,  2157,   456,
     457,   317,  3995,  2255,  3997,   211,   490,   491,   492,   490,
     488,   489,   490,   491,   492,  2157,   410,   456,   457,   225,
     498,   320,   498,  2223,   500,  2060,   497,   305,   499,   472,
    2339,   202,   498,  2982,   500,   498,   104,   500,    71,   387,
     497,   319,   498,   437,   500,   214,   498,  2223,   500,  1184,
     444,  3525,   500,   501,  3410,  2255,   256,   425,   497,  2242,
     500,   232,   456,   381,  2223,   497,   434,  2250,   498,  2252,
     103,   498,   319,   500,  2109,   108,  2111,  2242,   498,  2255,
     500,  2223,   254,   498,  2157,  2250,  2968,  2252,   114,   260,
    2972,   498,   410,   500,   490,   498,  2255,   500,   456,   457,
    1841,   307,  4044,   497,   501,   498,  2298,   500,   498,   315,
     500,   503,    71,  2255,  2306,  1856,   498,   503,   500,   437,
     473,   474,  2157,  1250,    85,   248,   444,   476,   477,   478,
      91,  2388,  3014,   482,  1261,   412,    95,   414,   456,   488,
     489,   497,   348,  2572,   103,   456,   457,   319,  3097,   108,
    2223,   412,   193,   414,   126,  1311,  1312,  2322,   115,   498,
    2352,   500,   195,  2450,   498,   498,   500,   500,   140,   130,
    2666,  2667,  1307,   488,   489,   490,   491,   492,   498,   497,
     500,   496,  2255,  2375,    98,   498,   151,   500,  2223,   498,
     419,   500,   363,   419,  2441,  3646,   367,   230,   170,   419,
     172,   234,   373,   481,   498,   162,   500,  2613,  2614,   380,
     488,   489,   490,   491,   492,   493,   387,     2,   419,   180,
    2255,   254,   255,   498,   395,   500,   187,   114,   498,   190,
     500,   498,   403,   500,   481,  2427,   269,   484,   485,   486,
     419,   488,   489,   490,   491,   492,   493,   498,   498,   500,
     500,   216,   439,   498,  1995,   500,   498,  2550,   500,  1078,
    1079,  2002,  2555,   498,  3248,   500,   498,   248,   500,   241,
    2011,   230,   305,   419,   498,   234,   500,   242,   239,   236,
     451,   498,   497,   500,   455,   456,   319,   498,   498,   500,
     500,   254,   257,    78,   499,   254,   255,   459,  2550,    84,
    2668,  2669,   267,  2555,  3778,   498,   498,   500,   500,   481,
     269,   497,   484,   485,   486,  2572,   488,   489,   490,   491,
     492,   493,   497,   499,   281,   290,   283,  4112,   317,  2586,
     302,   210,   117,   294,   498,   307,   500,   294,   498,   498,
     500,   500,   268,   302,  2085,   498,   305,   500,  2605,   501,
    2550,  3560,   317,   439,   498,  2555,   500,  3641,   391,   317,
     319,  2618,   498,   322,   500,   498,   151,   500,   498,   330,
     500,   343,   329,    71,  2550,   160,   498,  2636,   500,  2555,
     498,   317,   500,   355,   498,  2126,   500,   497,    85,  2130,
     498,  2550,   500,  2134,    91,  2136,  2555,    95,   359,   311,
     378,  2142,   363,   498,   369,   500,   260,   364,  2550,   498,
     497,   500,  3863,  2555,   498,   498,   500,   500,   498,   498,
     500,   500,   207,   498,   126,   500,   387,  1562,   498,   214,
     500,   216,   391,   130,  2973,  1030,  2975,  1032,   456,    98,
     397,   497,   459,   228,  2636,   428,   104,   104,   481,   330,
     210,   260,   502,  2636,   439,   488,   489,   490,   491,   492,
     493,   433,   200,   200,   200,   497,  2631,   459,   200,  2634,
     200,  2636,   500,   200,   439,   200,   200,  2550,   317,   200,
     200,  3955,  2555,   180,  1619,   200,   317,   200,   200,   497,
     187,    98,   211,   190,   268,   497,   210,  2784,   497,   210,
     497,  2242,   497,   497,   339,   327,   497,   497,    98,  2250,
     497,  2252,   500,  2800,  3988,  2550,   153,  2804,  3992,  3993,
    2555,   497,   481,   497,   497,   484,   485,   486,   497,   488,
     489,   490,   491,   492,   493,   497,   254,  3563,    98,  3421,
     268,   500,   239,  1678,  3426,   497,   497,  3429,   497,   497,
     497,   497,   497,   497,   497,  3504,   254,   497,   497,   497,
    1695,   210,   497,  2815,  2816,  2817,   210,   490,   248,   379,
    3990,  3989,   500,   169,   438,   285,    37,   362,   500,  3563,
     484,    14,   500,   419,   497,   419,  3692,    98,   497,   497,
     419,   419,   499,   419,  2924,   317,   380,   294,   419,   419,
     307,   419,   133,  1738,   239,   116,   438,  2799,   317,   497,
     500,   396,  2905,    71,   419,  2815,  2816,  2817,   419,  2878,
     439,   319,   439,   419,   330,   419,   419,   114,   114,  2821,
     419,  2961,   497,   330,   321,   146,   419,  2802,   419,  2815,
    2816,  2817,   419,  2958,   419,   103,   419,  2906,   419,   419,
     108,   317,   317,  2905,   254,   497,  2815,  2816,  2817,  1794,
    2852,   456,  1789,  2855,  2856,   447,   363,  2859,  2925,    98,
     497,  1798,  2925,  2815,  2816,  2817,   376,  2869,    97,  1806,
    1807,   497,  2874,  2940,    87,   170,  2878,  2940,   439,   450,
     387,   202,  2884,   449,   276,  2878,    98,  1824,   210,   317,
    2441,  2442,    98,   377,  2961,  2905,   497,  3136,  2961,   499,
     453,  2968,   200,  2878,  2906,  2972,   439,   200,  2883,  2884,
     200,   232,   439,  2906,   200,  3012,    14,  2919,   500,  2905,
     419,   306,  3138,  3139,  3140,  3141,   444,   195,   366,    85,
     215,  2906,  2815,  2816,  2817,    91,  2905,  3034,   497,   260,
     417,   452,   287,  3975,   287,  4173,  3975,  2949,  2950,  3909,
      71,   500,   387,  2905,  3021,   417,   497,    71,  3021,   472,
     215,   497,   230,   419,   421,   228,   234,   228,   250,   484,
    2815,  2816,  2817,   481,   130,   312,   484,   485,   486,   318,
     488,   489,   490,   491,   492,   493,   254,   255,   484,   103,
     270,   500,   498,    34,   108,   500,   500,   498,  3101,    10,
     498,   269,   376,   498,   419,   419,   139,  3843,   497,   258,
     258,   497,   317,   307,   324,   307,   307,   500,   419,  1964,
     384,   359,  2905,   618,   180,   359,   315,   359,   419,   419,
     350,   187,   254,  3725,   190,    98,   254,   305,   254,  3101,
     439,   439,   363,   254,   254,  3839,   367,   484,   315,  3843,
    3809,   319,   373,    97,   495,   495,  3748,   419,   419,   380,
    2905,   210,   484,   317,   212,   322,   387,   497,   384,  3136,
     199,    98,  4152,   223,   395,   317,   210,   500,   491,   226,
    2631,   195,   403,   239,   226,  2636,   497,   200,    98,   317,
     317,  3101,  1492,   210,   459,   410,   384,   500,    86,  3261,
     220,   284,   317,   500,   498,   114,   215,   500,   215,   498,
    3112,   498,   498,   472,   498,  3101,   230,   498,   498,   498,
     234,   498,  2059,   391,   472,   498,   498,   498,  4208,   498,
     451,   498,  3101,    14,   455,   498,   419,   497,   294,   497,
     254,   255,   453,   498,  3247,   326,  3249,   206,   501,  3101,
    3842,   500,  3154,  4233,   484,   269,   116,   419,  4074,   270,
     500,   442,   498,    85,   244,   498,  3263,  3264,   497,    91,
     497,   307,   334,   270,   330,   334,   436,   279,   419,  3248,
     279,  3873,   419,   279,   419,  3247,   146,  3249,    98,   784,
     254,   305,  3261,   788,   419,   419,   419,   792,   419,   419,
    3959,   254,   797,   359,   254,   319,   116,   363,   130,   254,
     285,   254,   254,   481,  3276,   254,   495,   317,  3101,   270,
     488,   489,   490,   491,   492,   493,   498,   321,  3203,  3921,
     428,   387,   827,   498,   484,   361,   146,  3247,   163,  3249,
     498,   497,   202,   315,   317,   419,  3248,   500,   439,   317,
     257,   498,   497,   257,   325,  3248,  3101,   497,   180,   439,
    3262,  3247,   439,  3249,   312,   187,  3276,  3269,   190,  3271,
     500,   320,   232,  3248,   198,   870,   495,   391,  3247,   198,
    3249,   193,   877,   215,    71,   449,  3261,   210,   124,   884,
    3276,   498,   202,  3295,   498,  3247,   498,  3249,   215,  3301,
    3302,  3303,  3304,  3305,  3306,   497,   222,  3276,   498,   904,
    4069,   500,   484,   498,   484,   497,   318,   239,   484,   498,
     428,   210,   232,   244,  3276,   428,   419,  2878,   419,   419,
    3323,  4023,   419,  3335,   254,   498,   254,   498,   498,   496,
     456,    98,  3344,  3345,  3346,  3347,   497,  3322,  3323,   258,
     260,   497,  4044,   459,  3421,  2906,  3331,   210,   322,  3426,
    3335,   456,  3429,   240,  3247,   135,  3249,   481,   456,  3344,
     330,  2316,   294,  2924,   488,   489,   490,   491,   492,   493,
     411,   500,   497,   257,   384,   980,   498,   497,   219,   481,
     215,   986,   497,  3276,  3396,   990,   497,   215,   454,   359,
     454,   114,  3247,   363,  3249,  3567,   428,   367,   330,   498,
    2961,  3573,   497,   373,   497,   224,  1011,   498,   500,   498,
     380,   307,   307,   484,  1019,  3587,   500,   387,   200,   177,
     500,  3276,   254,   172,   307,   395,   241,   359,   496,   217,
     215,   363,   439,   403,   439,  4137,   188,   199,   259,   215,
     419,   498,   210,   363,   320,   215,   443,   367,   396,   497,
     497,   497,   497,   373,   497,   387,   498,   355,  2405,   498,
     380,   455,   333,   498,   439,   456,   497,   387,   497,   210,
     500,    98,  2419,  2420,   307,   395,  2423,   280,   237,   347,
     163,   451,  2429,   403,   373,   196,   126,   373,  3567,   320,
     126,   484,   114,   323,  3573,   206,  3668,   210,   318,   210,
     317,   411,   205,    85,   320,    71,   320,   456,  3587,    91,
    3617,  3618,   481,  3620,   500,    98,   353,   500,   443,   456,
    4222,  2476,   188,  1933,   317,   317,    98,   183,   372,    95,
     497,   451,   497,   115,   498,   455,   175,   103,   372,   250,
     437,  2488,   108,    84,  3556,  3557,   199,    95,   130,   347,
     497,  1156,   354,  3556,  2338,  1452,  2636,  3569,  1163,   270,
    2749,  2229,  4110,  3247,  2874,  3859,  3569,  3386,  3383,  3235,
    2208,  3556,  2713,  3685,  2446,  4136,  4172,  4099,  4098,  1184,
     162,  4144,  3567,  1764,  3569,  3388,  2941,  2177,  3573,  3668,
    1750,  3395,  2816,  3276,  2326,  4233,  4208,  3654,   180,  3653,
    2905,  2877,  3587,   314,  4151,   187,  3845,  1741,   190,  1214,
    3595,  3596,   323,  4081,  3848,  3600,  3601,   186,  1299,  3696,
    3632,  3633,  3694,  3696,  3455,  3397,  3921,  4044,  2200,  4051,
    3401,  3643,  3644,  4232,  3741,  3647,  3648,  4196,  3895,  1001,
     163,  2069,  1482,  1276,  3751,  3206,  3381,  3022,  3660,  3661,
    3662,  3663,  3664,  2647,   236,  3450,  1276,   239,  1263,  1264,
    2439,  1266,  2103,  2656,   230,  1021,  2670,  3202,   234,  1274,
    3567,  3748,  2102,  1477,  3694,  3660,  3661,  3662,  3663,  3664,
    2088,  2063,  1495,  3668,  2618,  2388,  2974,  3248,   254,   255,
    2648,  3703,  1010,  3749,   872,  3957,  3378,  3111,  3694,   281,
    3261,   283,  1307,   269,  3103,  4130,  4134,  4131,  2659,  2586,
    2497,  2584,   294,  2465,  1996,  3694,  1276,  3729,   618,  2958,
    2381,   432,  1219,  1780,  1329,  4124,  2130,  1507,   363,   906,
    2106,  1501,  3694,  1099,  1306,  2136,   302,  2143,  1079,   305,
    2630,  2137,  3206,  3555,  3207,  1425,  3181,   329,   330,   395,
    1856,  1505,  1357,   319,  2147,  2442,   322,     2,  3434,  1263,
    3839,  1933,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2717,    -1,    -1,    -1,    -1,    -1,    -1,   359,    -1,    -1,
      -1,   363,   364,  1388,  1389,    -1,  1391,   498,    -1,    -1,
      -1,    -1,    -1,  2748,    -1,    -1,    -1,    -1,    -1,  1404,
      -1,  3694,    -1,  1408,    -1,   387,    -1,    -1,  2755,  2756,
      -1,    -1,    -1,    -1,    -1,   397,  3819,    -1,    -1,    -1,
      -1,  1993,    -1,    -1,  2779,   391,  2781,  3839,    -1,    -1,
      -1,    -1,  3939,    -1,  3819,    -1,  3839,    -1,    -1,  3694,
      -1,    -1,  1447,    -1,  3856,    -1,    -1,    -1,  3860,    -1,
      -1,    -1,    71,    -1,  3839,  1460,  1461,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3949,    -1,    -1,    -1,  3949,    -1,    -1,    71,
      -1,    -1,  1487,    -1,   103,    -1,  1491,  1492,    -1,   108,
      -1,    -1,  3999,    -1,    -1,    -1,    -1,    -1,  2853,    -1,
    1505,  1506,  1507,    -1,    -1,    -1,  3918,    -1,    -1,    -1,
      -1,   103,    -1,    -1,    -1,   481,   108,    -1,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
     496,    -1,    -1,    -1,    -1,    -1,   502,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4016,    -1,    -1,    -1,  1553,    -1,
      -1,    -1,    -1,    -1,    -1,  1560,    -1,  1562,    -1,    -1,
      -1,  1566,    -1,  4212,    -1,  1570,    -1,  2922,    -1,    -1,
      -1,    -1,    -1,    -1,  4053,    -1,    -1,    -1,    -1,    -1,
      -1,  2936,    -1,    -1,    -1,  1590,    -1,    -1,    -1,    -1,
      -1,    -1,  1597,    -1,    -1,  3556,  4016,    -1,    -1,    -1,
      -1,    -1,    -1,   195,    -1,    -1,  3567,    -1,    -1,    -1,
      -1,   230,  3573,    -1,  1619,   234,    -1,    -1,  1623,    -1,
    4016,    -1,    -1,    -1,    -1,    -1,  3587,    -1,    -1,    -1,
      -1,    -1,  2987,    -1,    -1,   254,   255,  4016,   230,  2986,
      -1,    -1,   234,  2990,    -1,  2992,    -1,  2994,  2995,    -1,
     269,    -1,    -1,    -1,  4016,    -1,  3003,    -1,    -1,    -1,
      -1,    -1,   254,   255,    -1,    -1,    -1,    -1,  4053,    -1,
      -1,    -1,    -1,  1678,    -1,    -1,    -1,   269,    -1,    -1,
      -1,    -1,    -1,   302,    -1,    -1,   305,    -1,    -1,  3036,
    1695,    -1,    -1,  3048,    -1,    -1,    -1,    -1,    -1,    -1,
     319,    -1,    -1,    -1,    -1,    -1,    -1,  3668,  1713,    -1,
      -1,    -1,  3067,   305,    -1,  2525,  2526,    -1,    -1,  4196,
    2530,    -1,    -1,  4016,    -1,    -1,    -1,   319,    -1,    -1,
      -1,    -1,    -1,  1738,    -1,  4212,    -1,  3092,  1743,    -1,
    4152,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4152,
      -1,    -1,    -1,  2525,  2526,  4232,    -1,    -1,  2530,  2569,
    2570,  4016,    -1,    -1,   221,    -1,    -1,  4152,    -1,    -1,
      -1,  3126,   391,   230,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1786,    -1,  1788,    -1,    -1,    -1,    -1,    -1,  1794,
      -1,    -1,  1797,    -1,    -1,    -1,  4208,  2569,  2570,   391,
     793,    -1,   795,    -1,    -1,  4208,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   810,    -1,    -1,
      -1,  4233,    -1,  4208,  1829,    -1,    -1,  1832,    -1,    -1,
    4233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     833,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4233,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   849,    -1,    -1,  1864,
      -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,  3839,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   481,
      -1,    -1,    -1,    -1,  1899,  1900,   488,   489,   490,   491,
     492,   493,  1907,    -1,    -1,  1910,    -1,    -1,  1913,    -1,
      -1,    -1,    71,  1918,    -1,    -1,  1921,  1922,    -1,    -1,
      -1,    -1,    -1,    -1,  1929,    -1,    -1,  1932,  1933,  1934,
    1935,    -1,    -1,    -1,    -1,    -1,    95,  1942,  1943,    -1,
    1945,    -1,  1947,    -1,   103,  1950,    -1,    -1,    -1,   108,
      -1,    -1,    -1,  2525,  2526,    -1,    -1,    -1,  2530,  1964,
    1965,  1966,    -1,    -1,  1969,    -1,    -1,    -1,  1973,    -1,
      -1,    -1,  1977,    -1,    -1,  1980,  1981,  1982,  1983,  1984,
    1985,  1986,  1987,  1988,    -1,  1990,    -1,    -1,    -1,    -1,
      -1,  1996,    -1,    -1,    -1,  2000,    -1,  2569,  2570,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3366,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   799,    -1,    -1,    -1,    -1,
     804,   798,    -1,    -1,    -1,   802,    -1,    -1,   812,    -1,
      -1,    -1,    -1,    -1,   811,    -1,   820,    -1,    -1,    -1,
      -1,   825,    -1,    -1,    -1,  2060,    -1,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2071,    -1,    -1,   836,
      -1,   230,    -1,   840,    -1,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   851,    -1,    -1,    -1,    -1,    -1,
    3437,    -1,  4053,    -1,    -1,   254,   255,  3444,  3445,    -1,
      -1,    -1,    -1,    -1,  2109,    -1,  2111,    -1,    -1,    -1,
     269,    -1,    -1,   144,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1118,  1119,    -1,    -1,    -1,
      -1,    -1,    -1,   164,    -1,    -1,    -1,    -1,    -1,    -1,
    2145,    -1,  2147,   302,    -1,    -1,   305,    -1,    -1,    -1,
      -1,    -1,  2157,    -1,   185,    -1,    -1,    -1,    -1,    -1,
     319,    -1,    -1,   322,   938,    -1,    -1,    -1,    -1,  2174,
    3525,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     954,   212,    -1,    -1,    -1,  1178,   217,    -1,    -1,  2194,
      -1,   222,    -1,    -1,  2199,  2200,    -1,    -1,    -1,    -1,
      -1,  1194,  1195,    -1,    -1,    -1,   237,    -1,    -1,    -1,
      -1,   985,    -1,    -1,    -1,    -1,    -1,    -1,  2223,  1212,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1004,    -1,   391,    -1,  3589,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3597,    -1,    -1,    -1,    -1,  1240,  1241,    -1,
    2255,    -1,    -1,    -1,  1028,    -1,    -1,    -1,  3068,    -1,
      -1,  3071,  3072,  3073,  3074,  3075,  3076,  3077,  3078,  3079,
    3080,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3068,    -1,    -1,  3071,
    3072,  3073,  3074,  3075,  3076,  3077,  3078,  3079,  3080,  2314,
      -1,  2316,    -1,    -1,    -1,   346,    -1,    -1,  3128,  3129,
      -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,   792,    -1,    -1,    -1,   370,
     797,   500,   799,    -1,    -1,   376,    -1,   804,    -1,   806,
      -1,   382,    -1,   384,    -1,   812,  3128,  3129,    -1,    -1,
      -1,    -1,    -1,   820,    -1,    -1,    -1,    -1,   825,    -1,
     827,    -1,    -1,  2378,    -1,    -1,    -1,    -1,    -1,   410,
     411,    -1,    -1,  2388,   415,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   423,  2398,    -1,    -1,    -1,   428,  3753,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   438,    -1,    -1,
    3757,    -1,  3759,  3760,    -1,   872,    -1,    -1,    -1,   450,
     877,  3768,    -1,  3778,    71,    -1,    -1,   884,    -1,    -1,
    2435,    -1,    -1,    -1,  1208,  1209,  1210,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,
    2465,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2476,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   938,    -1,    -1,    -1,    -1,   943,    -1,    -1,    -1,
    2495,  2496,    -1,    -1,    71,    -1,  3068,   954,    -1,  3071,
    3072,  3073,  3074,  3075,  3076,  3077,  3078,  3079,  3080,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,
    2525,  2526,    -1,  1297,    -1,  2530,   103,    -1,   985,    -1,
      -1,   108,    -1,    -1,    -1,    -1,    -1,  2542,  2543,  2544,
    2545,    -1,    -1,  3353,    -1,  2550,  1320,  1004,    -1,  2554,
    2555,    -1,  2557,  1010,  2559,    -1,  3128,  3129,    -1,    -1,
      -1,    -1,    -1,    -1,  2569,  2570,    -1,  2572,    -1,    -1,
      -1,  1028,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2585,  3353,  2587,   230,    -1,    -1,  2591,   234,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3955,    -1,  2607,    -1,    -1,  3952,    -1,   254,   255,    -1,
      -1,    -1,    -1,  2618,    -1,  2620,  2621,  2622,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3988,    -1,  2640,    -1,  3992,  3993,    -1,
      -1,    -1,    -1,    -1,  2649,    -1,    -1,    -1,    -1,    -1,
      -1,  2656,    -1,   230,    -1,   302,  2661,   234,   305,  1652,
    1653,  1654,  1655,  2668,  2669,  2670,    -1,    -1,    -1,    -1,
      -1,    -1,   319,    -1,    -1,   322,    86,   254,   255,    -1,
      -1,    -1,    -1,    -1,  1458,    -1,    -1,    -1,    -1,  1682,
    1683,    -1,   269,    -1,    -1,  1688,    -1,    -1,    -1,  1156,
      -1,    -1,    -1,    -1,    -1,    -1,  1163,  2712,    -1,  3519,
    3520,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,   305,   139,
      -1,    -1,    -1,  2738,  2739,    -1,  2741,    -1,   148,   149,
     150,    -1,   319,  2748,   391,   322,    -1,  3519,  3520,    -1,
      -1,  1208,  1209,  1210,    -1,    -1,    -1,  1214,    -1,    -1,
    1753,  1754,  1755,  1756,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    -1,    -1,  2779,    -1,  2781,    -1,    -1,    -1,
      -1,  3353,   192,    -1,    -1,    -1,    71,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   103,    -1,    -1,    -1,    -1,   108,    -1,    -1,
    2815,  2816,  2817,    -1,   391,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,   108,   234,    -1,    -1,    -1,    -1,   239,
      -1,    -1,    -1,  1826,   481,  1609,    -1,   484,   485,   486,
    1297,   488,   489,   490,   491,   492,   493,    -1,  2853,    -1,
      -1,   498,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1320,    -1,    -1,    -1,    -1,   278,    -1,
      -1,    -1,  2877,  2878,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1656,    -1,    -1,   295,   296,   297,   298,   299,
      -1,   301,    -1,  1660,   195,    -1,    -1,    -1,    -1,    -1,
    2905,  2906,  1676,    -1,   481,    -1,    -1,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,  2922,    -1,    -1,
      -1,   498,    -1,    -1,   334,    -1,    -1,    -1,    -1,   230,
      -1,  2936,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   230,  2951,  3519,  3520,   234,
      -1,    -1,    -1,   254,   255,    -1,    -1,    -1,    -1,    -1,
     370,    -1,    -1,  2968,  3774,    -1,    -1,  2972,   269,   254,
     255,    -1,    -1,    -1,    -1,    -1,    -1,  2982,    -1,    -1,
    1747,    -1,  2987,    -1,   269,    -1,    -1,    -1,  3798,  3799,
      -1,    -1,    -1,    -1,    -1,  1762,   406,    -1,   408,    -1,
      -1,  1458,  3774,    -1,   305,    -1,    -1,    -1,    -1,  3014,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,    -1,
     305,   431,    -1,    -1,    -1,    -1,  3798,  3799,   438,    -1,
      -1,   441,    -1,    -1,   319,    -1,  1810,    -1,    -1,    -1,
    3045,    -1,    -1,  3048,    -1,  1819,    -1,    -1,    -1,  3054,
      -1,    -1,    -1,    -1,  1821,  3060,    -1,  3062,    -1,    -1,
      -1,    -1,  3067,  3068,    -1,    -1,  3071,  3072,  3073,  3074,
    3075,  3076,  3077,  3078,  3079,  3080,    -1,    -1,    -1,  3084,
    3085,    -1,    -1,    -1,    -1,    -1,    -1,  3092,    -1,    -1,
     391,    -1,  3097,  1867,  1868,    -1,  3101,    -1,  3103,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,  3113,    -1,
      -1,  3116,    -1,  3118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3126,  3127,  3128,  3129,    -1,    -1,    -1,  3133,    -1,
      -1,  3136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3146,    -1,    -1,  3954,    -1,    -1,    -1,    -1,    -1,
    3155,    -1,  1609,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     481,    -1,  3954,    -1,    -1,    95,    -1,   488,   489,   490,
     491,   492,   493,   103,    -1,    -1,   481,    -1,   108,  1656,
     485,   486,  3774,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1676,
      -1,  1995,    -1,    -1,    89,    -1,  3798,  3799,    -1,    94,
      -1,    96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   106,  3247,  3248,  3249,    -1,  2020,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2248,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,
      -1,  3276,    -1,    -1,    -1,    -1,    -1,   142,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   151,   152,    -1,    -1,
     155,    -1,    -1,    71,    -1,  2069,   161,    -1,    -1,  2292,
     165,    -1,    -1,    -1,   169,    -1,  2299,  2300,  2301,  2302,
    2303,  2304,    -1,    -1,    -1,    -1,    -1,    95,   183,    -1,
     230,   186,    -1,    -1,   234,   103,   191,    -1,    -1,  1786,
     108,  1788,    -1,    -1,    -1,    -1,    -1,   202,    -1,    -1,
    1797,   206,    -1,   208,   254,   255,    -1,   212,  3353,    -1,
      -1,    -1,    -1,  1810,    -1,    -1,    -1,    -1,    -1,   269,
      -1,  3366,  1819,    -1,   229,    -1,    -1,    -1,    -1,    -1,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3954,    -1,    -1,    -1,    -1,  2154,    -1,    -1,
      -1,  2158,   302,    -1,    -1,   305,  3401,  3402,  3403,    -1,
      -1,    -1,    71,    -1,    -1,    -1,  2173,  1864,    -1,   319,
    1867,  1868,   322,    -1,  2181,    -1,  3421,  2410,    -1,  2412,
      -1,  3426,  1879,    -1,  3429,    -1,    95,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   103,    -1,    71,  2204,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,  2220,    -1,    -1,    -1,
      -1,    -1,   230,    -1,  2221,    -1,   234,    -1,    -1,    -1,
      95,    -1,    -1,  3468,    -1,    -1,    -1,    -1,   103,  2236,
      -1,  2238,    -1,   108,    -1,    -1,   254,   255,    -1,    -1,
      -1,   391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2256,
      -1,   269,    -1,    -1,    -1,    -1,  2263,    -1,    -1,  3504,
      -1,    -1,    -1,  2270,    -1,    -1,  3511,  3512,    -1,  3514,
    2277,    -1,    -1,    -1,  3519,  3520,    -1,    -1,    -1,  3524,
    3525,    -1,    -1,    -1,   302,  3530,  3531,   305,    -1,  3534,
      -1,    -1,    -1,    -1,   399,    -1,    -1,    -1,  1995,    -1,
      -1,   319,    -1,    -1,   322,    -1,    -1,    -1,    -1,  3554,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   230,  2336,  2020,  3569,   234,    -1,    -1,    -1,    -1,
      -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,  3589,   254,   255,    -1,   498,    -1,
      -1,    -1,  3597,    -1,    -1,   230,  2370,    -1,    -1,   234,
     269,    -1,    -1,  2377,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2069,   391,    -1,    -1,    -1,    -1,    -1,   254,
     255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   302,   269,    -1,   305,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     319,    -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,
     305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3684,
      -1,    -1,    -1,    -1,   319,    -1,    -1,   322,    -1,  3694,
      -1,  2458,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,   496,  2486,
    3725,    -1,   391,    -1,    -1,  3730,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3744,
      -1,    -1,    -1,  3748,    -1,    -1,    -1,    -1,  3753,    -1,
      -1,    -1,    -1,   618,    -1,    -1,   391,    -1,    -1,    -1,
      -1,    -1,    -1,  2220,    -1,    -1,    -1,    -1,    -1,  3774,
      -1,    -1,    -1,  3778,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3798,  3799,    -1,    -1,  3802,    -1,    -1,
     665,   666,    -1,    -1,  3809,  3810,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    -1,   679,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,   498,
      -1,    -1,    -1,    -1,  3839,    -1,    -1,  3842,  2612,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,   498,    -1,    -1,    -1,    -1,  3873,    -1,
      71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2336,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2665,    -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   103,    -1,    -1,    -1,    -1,   108,    -1,    -1,
      -1,    -1,    -1,  2370,    -1,    -1,  3921,  3922,    -1,    -1,
    2377,    -1,    -1,  3928,    -1,    -1,    -1,    -1,   793,   794,
     795,  2388,    -1,   798,  2701,   800,    -1,   802,   803,    -1,
     805,    -1,   807,    -1,   809,   810,   811,    -1,    -1,  3954,
    3955,    -1,  3957,    -1,  3959,   820,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   828,    -1,    -1,   831,    -1,   833,    -1,
      -1,   836,    -1,   838,    -1,   840,   841,   842,   843,    -1,
    3985,    -1,   847,  3988,   849,    -1,   851,  3992,  3993,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   864,
      -1,   866,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4016,    -1,   878,    -1,  2782,   881,    -1,  4023,    -1,
     885,    -1,   887,    -1,   889,   890,    -1,    -1,   893,   230,
     895,    -1,   897,   234,   899,    -1,    -1,   902,    -1,  4044,
      -1,    -1,    -1,    -1,    -1,    -1,  4051,    -1,  4053,    -1,
      -1,    -1,    -1,   254,   255,    -1,    -1,    -1,    -1,   924,
     925,    -1,    -1,    -1,  4069,    -1,    -1,    -1,   269,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2847,    -1,    -1,    -1,    -1,   950,    -1,   952,    -1,    -1,
     955,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   302,    -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   982,   319,   984,
      -1,   322,    -1,   988,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2917,    -1,    -1,    -1,    -1,    -1,    -1,
    1015,    -1,    -1,  2927,    -1,  2612,  1021,    -1,    -1,    -1,
      -1,  2618,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2943,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2665,    -1,
      -1,  1076,  1077,    -1,    71,    -1,    -1,  4222,    -1,    -1,
      -1,    -1,  2996,    -1,  1089,  2999,  1091,    -1,    -1,    -1,
    1095,    -1,  3006,    -1,    -1,  3002,    -1,    -1,    95,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   103,    -1,  3015,    -1,
      -1,   108,    -1,  1118,  1119,    -1,    -1,    -1,    -1,    -1,
      -1,  3035,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3037,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     481,  1146,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,  1159,    -1,    -1,   498,    -1,    -1,
      -1,  1166,    -1,  1168,    -1,    -1,    -1,    -1,    -1,  1174,
      -1,    -1,    -1,  1178,    -1,    -1,    -1,    -1,    -1,    -1,
    1185,    -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,  1194,
    1195,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,  1212,  1213,    -1,
    1215,  1216,    -1,    -1,   103,    -1,    -1,    -1,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3143,
    3144,    -1,    -1,   230,    -1,  1240,  1241,   234,    -1,  1244,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1259,    -1,    -1,   254,   255,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1285,    -1,    -1,    -1,    -1,    -1,    -1,  1292,  1293,    -1,
      -1,    88,    71,  1298,  1299,    -1,    -1,    -1,    -1,  1304,
      -1,    -1,    -1,   100,  1309,   302,    -1,    -1,   305,    -1,
      -1,    -1,  1317,    -1,    -1,    -1,  1321,  3224,  1323,    -1,
    2917,    -1,   319,   120,   103,   322,    -1,    -1,    -1,   108,
    2927,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   230,    -1,    -1,    -1,   234,  2943,   144,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   254,   255,   164,    -1,    -1,
      -1,  2968,    -1,    -1,    -1,  2972,  3283,    -1,  3285,    -1,
     269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   185,    -1,
      -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,  2996,
      -1,    -1,  2999,    -1,    -1,    -1,    -1,    -1,    -1,  3006,
      -1,    -1,    -1,   302,    -1,   212,   305,  3014,    -1,    -1,
     217,    -1,    -1,  1428,  1429,   222,    -1,  3341,    -1,    -1,
     319,    -1,    -1,   322,    -1,    -1,    -1,    -1,  3035,  1444,
     237,    -1,    -1,    -1,    -1,  3359,  1451,  1452,    -1,    -1,
      -1,   230,    -1,    -1,    -1,   234,    -1,  3371,    -1,    -1,
      -1,    -1,  1467,    -1,  1469,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1477,  1478,    -1,   254,   255,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   481,    -1,  3619,   484,   485,   486,
     269,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,   498,   391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1523,    -1,
    1525,    -1,   319,    -1,    -1,    -1,   305,    -1,    -1,    -1,
      -1,    -1,   329,    71,    -1,    -1,    -1,    -1,    -1,    -1,
     319,    -1,    -1,    -1,    -1,    -1,  3143,  3144,  3455,   346,
    1555,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,
     108,    -1,    -1,   370,    -1,  1580,    -1,   374,    -1,   376,
      -1,    -1,    -1,    -1,    -1,   382,    -1,   384,    -1,    -1,
      -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,   498,
      -1,    -1,   391,   410,   411,    -1,  1621,    -1,   415,    -1,
      -1,    -1,  3536,  3537,  3538,  3539,   423,    -1,    -1,    -1,
      -1,   428,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   438,    71,    -1,    -1,    -1,    -1,  1652,  1653,  1654,
    1655,    -1,    -1,   450,    -1,  1660,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1674,
      -1,    -1,    -1,    -1,   103,    -1,    -1,  1682,  1683,   108,
      -1,    -1,    -1,  1688,    -1,    -1,  3593,    -1,    -1,    -1,
      -1,    -1,   230,    -1,    -1,    -1,   234,  3604,    -1,    -1,
      -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,   254,   255,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   269,    -1,    -1,  1739,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1747,    -1,  3341,    -1,  1751,    -1,  1753,  1754,
    1755,  1756,    -1,    -1,    -1,    -1,    -1,  1762,    -1,    -1,
      -1,    -1,  3359,  1768,   302,  1770,   195,   305,    -1,    -1,
      -1,    -1,    -1,    -1,  3371,    -1,    -1,    -1,    -1,    -1,
      -1,   319,    -1,    -1,   322,    -1,    -1,  3920,    -1,    -1,
    1795,  1796,  3925,  3926,  1799,  1800,    -1,    -1,    -1,    -1,
    1805,   230,    -1,  1808,  1809,   234,  1811,    -1,  1813,    -1,
      -1,    -1,    -1,  1818,    -1,  1820,  1821,    -1,    -1,    -1,
    1825,  1826,    -1,    -1,  3421,   254,   255,    -1,    -1,  3426,
      -1,    -1,  3429,    -1,    -1,  1840,  1841,    -1,    -1,    -1,
     269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1857,   391,    -1,    -1,    -1,  1862,    -1,    -1,
    1865,  1866,  3769,  3996,  1869,  3998,    -1,    -1,    -1,    -1,
    1875,    -1,    -1,    -1,    -1,    -1,   305,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1893,  1894,
     319,    -1,  1897,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4045,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1931,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,  3536,
    3537,  3538,  3539,   481,    -1,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    95,    -1,    -1,
     498,    -1,   391,    -1,    -1,   103,    -1,    -1,  3882,  4102,
     108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4111,    -1,
      -1,    -1,    -1,    -1,    -1,  1184,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3909,   117,  2002,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4141,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3933,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   160,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    -1,    -1,    -1,    -1,  2062,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,  3982,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   207,    -1,    -1,    -1,
      -1,    -1,   230,   214,    -1,   216,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   228,  1307,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   254,   255,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2130,    -1,    -1,  3725,    -1,
      -1,   269,    -1,    -1,    -1,    -1,    -1,  2142,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    -1,  2154,
    2155,  3748,    -1,  2158,  2159,  2160,    -1,    -1,    -1,  2164,
      -1,    -1,    -1,    -1,   302,  2170,    -1,   305,  2173,    -1,
      95,  2176,    -1,    -1,    -1,    -1,  2181,  2182,   103,    -1,
      -1,   319,  2187,   108,   322,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2204,
    2205,    -1,    -1,  2208,  2209,  2210,  2211,  2212,  2213,  2214,
      -1,    -1,  2217,  2218,    -1,    -1,  2221,  2222,    -1,    -1,
    2225,    -1,    -1,    -1,    -1,  2230,  2231,    -1,    -1,    -1,
      -1,  2236,    -1,  2238,  2239,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2248,  2249,  3842,  2251,    -1,    -1,    -1,
      -1,  2256,    -1,   391,    -1,  2260,  2261,  2262,  2263,  2264,
      -1,    -1,    -1,    -1,    -1,  2270,  2271,  2272,    -1,    -1,
      -1,    -1,  2277,    -1,  2279,  2280,  3873,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3882,    -1,  2292,    -1,    -1,
      -1,    -1,    -1,    -1,  2299,  2300,  2301,  2302,  2303,  2304,
      -1,    -1,    -1,    -1,    -1,   230,    -1,    -1,    -1,   234,
      -1,    -1,  3909,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3921,    -1,    -1,  2332,    -1,   254,
     255,    -1,    -1,    -1,    -1,  2340,  3933,    -1,    -1,    -1,
      -1,    -1,    -1,   481,   269,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,  2364,
     498,    -1,    -1,  1562,    -1,    -1,  2371,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2381,   302,    -1,    -1,
     305,    -1,    -1,    -1,  2389,  3982,    -1,    71,  2393,  2394,
      -1,    -1,    -1,    -1,   319,    -1,    -1,   322,  1597,    -1,
      -1,    -1,    -1,    -1,    -1,  2410,  2411,  2412,  2413,    -1,
      -1,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,
    1619,    -1,  2427,    -1,   108,    -1,  4023,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2441,    -1,    -1,    -1,
      -1,  2446,    -1,    -1,    -1,  2450,    -1,  4044,    -1,    -1,
      -1,    -1,    -1,  2458,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,
      -1,    71,    72,    -1,    -1,    -1,    -1,  2482,    -1,  1678,
      80,  2486,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1184,    -1,    95,  1695,    -1,    98,    -1,
      -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,   108,    -1,
      -1,    -1,    -1,    -1,  1713,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1738,
    4137,    -1,    -1,    -1,    -1,    -1,   230,    -1,    -1,    -1,
     234,    -1,    -1,    -1,    -1,  2560,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
     254,   255,    -1,   498,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2589,   269,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1794,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1307,    -1,   302,    -1,
      -1,   305,    -1,    -1,    -1,  4222,    -1,    -1,    -1,    -1,
     230,  2636,    -1,    -1,   234,   319,    -1,    -1,   322,    -1,
      -1,    -1,  2647,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   254,   255,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   784,    -1,    -1,    -1,    -1,    -1,   269,
      -1,   792,    -1,    -1,    -1,    -1,   797,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2701,  2702,  2703,    -1,
      -1,    -1,   302,    -1,    -1,   305,   827,   391,    -1,    -1,
      -1,  2716,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,
    2725,    -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,  2757,  2758,  2759,  2760,   877,    -1,    -1,    -1,
      -1,    -1,    -1,   884,    -1,  1964,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    -1,  2782,    -1,  2784,
      -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,   108,    -1,
      -1,   391,    -1,    -1,    -1,  2800,    -1,   481,    -1,  2804,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,   498,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2843,    -1,
      -1,    -1,  2847,  2848,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2857,  2858,    95,    -1,    -1,    -1,    99,   980,
      -1,    -1,   103,    -1,    -1,   986,    -1,   108,    -1,   990,
      -1,  1562,    -1,    -1,    -1,    -1,   476,    -1,    -1,  2884,
      -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,  1019,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1597,    71,    -1,    -1,
     230,    -1,    -1,    -1,   234,    -1,    -1,    -1,  2923,  2924,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1619,    -1,
      -1,    95,    -1,    -1,   254,   255,  2941,   178,    -1,   103,
      -1,    -1,    -1,    -1,   108,  2950,    -1,    -1,    -1,   269,
      -1,    -1,    -1,  2958,    -1,    -1,  2961,  2962,    -1,    -1,
    2965,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2978,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   302,  2988,    -1,   305,    -1,  1678,    -1,   230,
      -1,    -1,    -1,   234,    -1,  2194,  3001,  3002,    -1,   319,
    2199,  2200,   322,    -1,  1695,    -1,    -1,  3012,    -1,    -1,
    3015,    -1,    -1,   254,   255,    -1,    -1,  3022,    -1,    -1,
     340,    -1,  1713,    -1,    -1,    -1,    -1,    -1,   269,  3034,
      -1,    -1,  3037,    -1,    -1,  1156,    -1,    -1,    -1,    -1,
      -1,    -1,  1163,    -1,    -1,    -1,   210,  1738,    -1,    -1,
      -1,   215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   302,    -1,  1184,   305,    -1,   230,    -1,    -1,    -1,
     234,   391,    -1,    -1,    -1,    -1,    -1,    -1,   319,    -1,
      -1,   322,    -1,    -1,   404,    -1,    -1,    -1,    -1,    -1,
     254,   255,    -1,  1214,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,  1794,    -1,   269,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2316,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,    98,
      -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,   302,   108,
      -1,   305,    -1,    -1,    -1,    -1,    -1,  3152,    -1,    -1,
     391,    71,    -1,  1274,    -1,   319,    -1,    -1,   322,    -1,
      -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,    -1,    95,    -1,    -1,  3183,  2378,
      -1,    -1,    -1,   103,    -1,    -1,  1307,    -1,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   439,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1329,    -1,
      -1,    -1,    -1,    -1,  3219,  3220,    -1,    -1,    -1,  3224,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1357,    -1,    -1,    -1,
     481,    -1,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,  3263,  3264,
      -1,   230,    -1,    -1,    -1,   234,    -1,  1388,  1389,    -1,
    1391,    -1,    -1,  1964,  3279,    -1,    -1,  2476,  3283,  3284,
    3285,  3286,  3287,  3288,  3289,   254,   255,  1408,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     230,    -1,    -1,    -1,   234,    -1,    -1,   481,    -1,    -1,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
    3335,    -1,    -1,   302,   254,   255,   305,    -1,    -1,  1460,
    1461,    -1,    -1,  3348,  3349,  3350,    -1,  3352,    -1,   269,
     319,    -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1487,    -1,    -1,    -1,
    1491,  1492,    -1,  3378,    -1,    -1,    -1,    -1,  3383,    -1,
      -1,  3386,   302,  3388,    -1,   305,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3398,    -1,    -1,    -1,    -1,    -1,   319,
      -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3417,    -1,  3419,   335,    -1,    -1,    -1,    -1,
      -1,    -1,   391,    -1,    -1,  3430,    -1,  3432,    -1,  3434,
      -1,    -1,    -1,    -1,  3439,    -1,  3441,    -1,    -1,    -1,
      -1,  1562,    -1,    -1,    -1,  1566,    -1,    -1,    -1,  1570,
    3455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1590,
      -1,   391,    -1,    -1,    -1,    -1,  1597,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1619,    -1,
      -1,    -1,  1623,  2194,    -1,    -1,    -1,    -1,  2199,  2200,
      -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2738,
    2739,    -1,  2741,    -1,  3549,    -1,    -1,    -1,    -1,  2748,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1678,  3563,    -1,
      -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,  1695,    -1,    -1,    -1,    -1,    -1,
    2779,    -1,  2781,  3588,    -1,    -1,    71,    -1,  3593,  3594,
      -1,    -1,  1713,    -1,    -1,    -1,    -1,    -1,    -1,  3604,
    3605,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,  3617,  3618,  3619,  3620,    -1,  1738,   103,    -1,
      -1,    -1,  1743,   108,    -1,  2316,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3646,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2853,  3660,  3661,  3662,  3663,  3664,
      -1,    -1,    -1,    -1,    -1,  1786,    -1,  1788,    -1,    -1,
      -1,    -1,    -1,  1794,    -1,    -1,  1797,    -1,    -1,  2878,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2378,    -1,    -1,
      -1,    -1,    -1,  3698,    71,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2906,    -1,    -1,
      -1,    -1,  3717,    -1,    -1,    -1,    -1,    -1,    95,    -1,
    3725,    98,    -1,  2922,    -1,    -1,   103,    -1,    -1,    -1,
     215,   108,    -1,  3738,    -1,    -1,  3741,  2936,    -1,    -1,
      -1,    -1,    -1,  1864,    -1,   230,  3751,    -1,    -1,   234,
      -1,    -1,  2951,    -1,    -1,    -1,    -1,    -1,  3763,  3764,
      -1,    -1,    -1,    -1,  3769,    -1,    -1,    -1,    -1,   254,
     255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1899,  1900,
      -1,    -1,    -1,    -1,   269,  2476,  1907,    -1,  2987,  1910,
      -1,    -1,  1913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1921,  1922,    -1,    -1,    -1,    -1,    -1,    -1,  1929,    -1,
      -1,  1932,  1933,  1934,  1935,    -1,    -1,   302,    -1,    -1,
     305,  1942,  1943,    -1,  1945,    -1,  1947,    -1,    -1,  1950,
      -1,    -1,    -1,    -1,   319,    -1,    -1,   322,  3843,    -1,
      -1,    -1,    -1,  1964,  1965,  1966,    -1,    -1,  1969,  3048,
      -1,    -1,  1973,   230,    -1,    -1,  1977,   234,  3863,  1980,
    1981,  1982,  1983,  1984,  1985,  1986,  1987,  1988,  3067,  1990,
      -1,    -1,    -1,    -1,    -1,  1996,    -1,   254,   255,  2000,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3894,
      -1,  3896,   269,  3092,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,
      -1,    -1,    88,    -1,    -1,  3920,  3921,    -1,    -1,    -1,
    3925,  3926,    -1,    -1,    -1,   302,    -1,  3126,   305,    -1,
      -1,    -1,    -1,    -1,  3939,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   319,    -1,   120,   322,    -1,    -1,    -1,    -1,
    2071,    -1,    -1,    -1,    -1,    -1,    -1,   133,    -1,    -1,
      -1,    -1,    -1,    -1,   140,    -1,    -1,  3972,   144,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   164,    -1,
    3995,  3996,  3997,  3998,  3999,    -1,   481,    -1,    71,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,   185,
      -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    -1,    -1,    98,    -1,    -1,    -1,    -1,
     103,    -1,    -1,    -1,    -1,   108,  2157,    -1,    -1,  4044,
    4045,   217,    -1,    -1,    -1,    -1,    -1,  2738,  2739,  3248,
    2741,    -1,    -1,  2174,    -1,    -1,    -1,  2748,    -1,    -1,
      -1,   237,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2194,    -1,    -1,    -1,    -1,  2199,  2200,
      -1,    -1,    -1,    -1,    -1,   261,    -1,    -1,  2779,    -1,
    2781,    -1,    -1,    -1,    -1,  4100,    -1,  4102,    -1,    -1,
      -1,    -1,  2223,    -1,   481,    -1,  4111,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,    -1,    -1,  4124,
      -1,    -1,    -1,    -1,    -1,  4130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2255,    -1,  4141,    -1,    -1,    -1,
      -1,    -1,    -1,   319,    -1,    -1,    -1,  4152,    71,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   230,    -1,    -1,
      -1,   234,  2853,    -1,    -1,    -1,    -1,  3366,    -1,    -1,
     346,    -1,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     103,   254,   255,    -1,    -1,   108,    -1,  2878,    -1,    -1,
      -1,    -1,    -1,  2314,   370,  2316,   269,    -1,   374,    -1,
     376,    -1,  3401,  4208,    -1,    -1,   382,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2906,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4233,   302,
      -1,  2922,   305,    -1,   410,   411,    -1,    -1,    -1,   415,
      -1,    -1,    -1,    -1,    -1,  2936,   319,   423,    -1,   322,
      -1,    -1,   428,    -1,    -1,    -1,    -1,  2378,    -1,    -1,
    2951,    -1,    -1,    -1,    -1,    -1,    -1,  2388,    -1,    -1,
      -1,    -1,    -1,    -1,   450,    -1,    -1,  2398,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2987,   207,    -1,    -1,
      -1,    -1,    -1,    -1,   214,    -1,   216,   230,    -1,    -1,
      -1,   234,    -1,    -1,  2435,  3514,    -1,    -1,   391,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3525,    -1,    -1,    -1,
      -1,   254,   255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2465,    -1,   269,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,  2476,    -1,  3048,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2495,  2496,  3067,    -1,    95,   302,
      -1,    98,   305,    -1,    -1,    -1,   103,    -1,    -1,    -1,
    3589,   108,    -1,    -1,    -1,    -1,   319,    -1,  3597,   322,
      -1,  3092,    -1,    -1,  2525,  2526,    -1,    -1,   481,  2530,
      -1,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,  2542,  2543,  2544,  2545,    -1,    -1,    -1,    -1,  2550,
      -1,    -1,    -1,  2554,  2555,  3126,  2557,    -1,  2559,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2569,  2570,
      71,  2572,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2585,    -1,  2587,    -1,   391,    -1,
    2591,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   103,    -1,    -1,    -1,  2607,   108,    -1,    -1,
      -1,    -1,    -1,   416,    -1,    -1,    -1,  2618,    -1,  2620,
    2621,  2622,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   230,    -1,    -1,    -1,   234,    -1,  2640,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2649,    -1,
      -1,  3730,    -1,    -1,    -1,  2656,    -1,   254,   255,    -1,
    2661,    -1,    -1,    -1,    -1,    -1,    -1,  2668,  2669,  2670,
      -1,    -1,   269,    -1,  3753,    -1,    -1,  3248,   481,    -1,
      -1,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3778,
      -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,   305,    -1,
      -1,  2712,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   319,    -1,    -1,   322,    -1,    -1,    -1,   230,
      -1,    -1,    -1,   234,    -1,    -1,    -1,  2738,  2739,    -1,
    2741,    -1,    -1,    -1,    -1,    -1,    -1,  2748,    -1,    -1,
      -1,    -1,    -1,   254,   255,    -1,    -1,    -1,    -1,    -1,
    3839,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2779,    -1,
    2781,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   391,  3366,    -1,    -1,    -1,    -1,
      -1,   302,    -1,    -1,   305,    -1,  1184,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2815,  2816,  2817,    -1,   319,    -1,
      -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3401,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3928,
      -1,    -1,  2853,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3955,  2878,    -1,    -1,
      -1,    -1,    -1,    -1,   481,    -1,    -1,   484,   485,   486,
     391,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2905,  2906,    -1,    -1,    -1,  3988,
      -1,    -1,    -1,  3992,  3993,    -1,    -1,    -1,    -1,    -1,
      -1,  2922,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1307,
      -1,    -1,    -1,    -1,    -1,  2936,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3514,    -1,    -1,    -1,    -1,    -1,    -1,
    2951,    -1,    -1,    -1,  3525,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2968,    -1,    -1,
      -1,  2972,  4051,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     481,  2982,    -1,   484,   485,   486,  2987,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   792,    -1,    -1,    -1,    -1,   797,    -1,    -1,
      -1,    -1,    -1,  3014,    -1,    -1,    -1,    -1,  3589,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3597,    -1,    71,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   827,    -1,    -1,
      -1,    -1,    -1,    -1,  3045,    -1,    -1,  3048,    -1,    -1,
      -1,    -1,    95,  3054,    -1,    -1,    -1,    -1,    -1,  3060,
     103,  3062,    -1,    -1,    -1,   108,  3067,  3068,    -1,  1447,
    3071,  3072,  3073,  3074,  3075,  3076,  3077,  3078,  3079,  3080,
      -1,    -1,    -1,  3084,  3085,    -1,    -1,   877,    -1,    -1,
      -1,  3092,    -1,    -1,   884,    -1,  3097,    -1,    -1,    -1,
    3101,    -1,  3103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3113,    -1,    -1,  3116,    -1,  3118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3126,  3127,  3128,  3129,    -1,
      -1,    -1,  3133,    -1,    -1,  3136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3146,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3155,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3753,    -1,  1562,    -1,    -1,   230,    -1,    -1,
     980,   234,    -1,    -1,    -1,    -1,   986,    -1,    -1,    -1,
     990,    -1,    -1,    -1,    -1,    -1,    -1,  3778,    -1,    -1,
      -1,   254,   255,    -1,    -1,    -1,    -1,    -1,    -1,  1597,
      -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,  1019,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1619,    -1,    -1,    -1,    -1,  3247,  3248,  3249,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,
      -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,  3839,    -1,
      -1,    -1,    -1,    -1,    -1,  3276,   319,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1678,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1695,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1713,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,
      -1,    -1,  3353,    -1,    -1,    -1,    -1,  3928,    -1,    -1,
    1738,    -1,    -1,    -1,    -1,  3366,  1156,    -1,    -1,    -1,
      -1,    -1,    -1,  1163,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3955,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1184,    -1,    -1,    -1,    -1,    -1,
    3401,  3402,  3403,   147,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   147,    -1,    -1,    -1,    -1,  1794,  3988,    -1,    -1,
    3421,  3992,  3993,    -1,  1214,  3426,    -1,    -1,  3429,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,
      -1,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,   196,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     196,    -1,   206,    -1,    -1,    -1,   210,  3468,    -1,    -1,
     206,   215,    -1,    -1,   210,   219,    -1,    -1,   222,   215,
     224,    -1,    -1,   219,  1274,    -1,   222,    -1,   224,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3504,    -1,    -1,   250,    -1,    -1,    -1,
    3511,  3512,    -1,  3514,   250,    -1,    -1,  1307,  3519,  3520,
      -1,    -1,    -1,  3524,  3525,    -1,   270,    -1,    -1,  3530,
    3531,    -1,    -1,  3534,   270,    -1,    -1,    -1,    -1,  1329,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3554,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1357,    -1,    -1,
     314,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   314,   323,
      -1,    -1,    -1,    -1,    -1,    -1,  1964,   323,  3589,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3597,    -1,  1388,  1389,
      -1,  1391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1408,    -1,
      -1,    -1,   366,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     366,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   410,    -1,    -1,    -1,
    1460,    -1,    -1,    -1,   410,    -1,    -1,    -1,    -1,    96,
      -1,    -1,    -1,  3684,    -1,    -1,    -1,    -1,   432,   106,
      -1,    -1,    -1,  3694,    -1,    -1,   432,  1487,    -1,    -1,
      -1,  1491,  1492,    -1,    -1,    -1,    -1,    -1,    -1,   453,
      -1,   455,   456,    -1,    -1,    -1,    -1,   453,    -1,   455,
     456,    -1,    -1,    -1,  3725,   142,    -1,    -1,    -1,  3730,
      -1,    -1,    -1,    -1,    -1,   152,    -1,    -1,   155,    -1,
      -1,    -1,    -1,  3744,   161,    -1,    -1,  3748,   165,    -1,
      -1,   495,  3753,    -1,   498,   499,    -1,   501,    -1,   495,
      -1,    -1,   498,   499,    -1,   501,    -1,    -1,    -1,   186,
      -1,    -1,  1562,  3774,    -1,    -1,    -1,  3778,    -1,    -1,
    1570,    -1,    -1,    -1,    -1,   202,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3798,  3799,    -1,
    1590,  3802,    -1,    -1,    -1,    -1,     5,  1597,  3809,  3810,
      -1,    -1,    -1,    -1,    -1,    -1,  2194,    -1,   235,    -1,
      -1,  2199,  2200,    -1,    -1,    -1,    25,    -1,    -1,  1619,
      -1,    -1,    -1,  1623,    -1,    -1,    35,    36,  3839,    -1,
      -1,  3842,    41,    -1,    43,    44,    -1,    -1,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,  3873,    72,    -1,    74,    -1,    76,    77,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,    -1,  1678,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1695,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3921,  3922,    -1,  1713,   123,    -1,    -1,  3928,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2316,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1738,    -1,
      -1,    -1,    -1,  3954,  3955,    -1,  3957,    -1,  3959,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   399,    -1,  3985,    -1,    -1,  3988,    -1,    -1,
      -1,  3992,  3993,    -1,    -1,   194,  1786,    -1,  1788,    -1,
    2378,    -1,    -1,    -1,  1794,    -1,    -1,  1797,    -1,   208,
      -1,    -1,    -1,    -1,    -1,  4016,    -1,    -1,    -1,    -1,
      -1,    -1,  4023,    -1,    -1,    -1,    -1,    -1,   227,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4044,    -1,    -1,    -1,    -1,    -1,   248,
    4051,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4069,    -1,
      -1,    -1,    -1,    -1,  1864,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   282,    -1,    -1,   285,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2476,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   307,  1899,
    1900,    -1,    -1,    -1,    -1,    -1,    -1,  1907,    -1,    -1,
    1910,    -1,    -1,  1913,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1921,  1922,    -1,    -1,    -1,  4137,    -1,    -1,  1929,
      -1,    -1,  1932,  1933,  1934,  1935,    -1,    -1,    -1,    -1,
      -1,    -1,  1942,  1943,    -1,  1945,    -1,  1947,    -1,    -1,
    1950,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1964,  1965,    -1,    -1,    -1,  1969,
     379,    -1,    -1,  1973,    -1,    -1,    -1,  1977,    -1,    -1,
    1980,  1981,  1982,  1983,  1984,  1985,  1986,  1987,  1988,    -1,
    1990,    -1,    -1,    -1,    -1,    -1,  1996,    -1,    -1,    -1,
    2000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     419,  4222,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   432,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   445,    -1,   665,   666,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   679,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   470,    -1,    -1,    -1,    -1,    -1,   476,   477,   478,
      -1,  2071,    -1,   482,    -1,   484,    -1,    -1,    -1,   488,
     489,   490,   491,   492,    -1,    -1,   495,   496,   497,   498,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2738,  2739,    -1,  2741,    -1,    -1,    -1,    -1,    88,    -1,
    2748,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     100,    -1,    -1,    -1,  2174,    -1,   803,    -1,   805,    -1,
     807,    -1,   809,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     120,  2779,    -1,  2781,  2194,    -1,    -1,    -1,    -1,  2199,
    2200,   828,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     140,    -1,    -1,    -1,   144,   842,   843,    -1,    -1,    -1,
     847,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   164,    -1,    -1,   864,    -1,   866,
     170,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   878,    -1,    -1,    -1,   185,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   890,    -1,  2853,   893,    -1,   895,    -1,
     897,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   212,    -1,    -1,    -1,    -1,   217,   218,    -1,
    2878,    -1,   222,    -1,    -1,    -1,    -1,   924,   925,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,
      -1,    -1,    -1,    -1,  2314,  1184,  2316,    -1,  2906,    -1,
      -1,    -1,    -1,   950,    -1,   952,    -1,    -1,    -1,    -1,
     260,    -1,    -1,    -1,  2922,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,    -1,    -1,    -1,    -1,  2936,    -1,
      -1,    -1,    -1,    -1,    -1,   982,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2951,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2378,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2388,   319,
      -1,    -1,   322,    -1,  1021,    -1,    -1,    -1,  2398,  2987,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   346,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2435,    -1,    -1,  1307,    -1,
     370,    -1,    -1,    -1,   374,    -1,   376,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   384,    -1,    -1,    -1,    -1,    -1,
    3048,    -1,  1089,    -1,  1091,  2465,    -1,    -1,  1095,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2476,    -1,    -1,  3067,
      -1,   411,   412,    -1,   414,   415,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   423,    -1,  2495,  2496,   427,   428,    -1,
      -1,    -1,    -1,   433,  3092,    -1,    -1,    -1,   438,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1146,
      -1,    -1,    -1,    -1,    -1,  2525,  2526,    -1,    -1,    -1,
    2530,    -1,  1159,    -1,    -1,    -1,    -1,    -1,  3126,    -1,
      -1,  1168,  2542,  2543,  2544,  2545,    -1,  1174,    -1,    -1,
      -1,    -1,    -1,    -1,  2554,    -1,    -1,  2557,  1185,  2559,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2569,
    2570,    -1,  2572,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2585,    -1,  2587,  1215,    -1,
      -1,  2591,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2607,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2618,    -1,
    2620,  2621,  2622,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2640,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2649,
      -1,    -1,    -1,    -1,    -1,    -1,  2656,    -1,  1285,    -1,
    3248,  2661,    -1,    -1,    -1,    -1,    -1,    -1,  2668,  2669,
    2670,    -1,    -1,    -1,    -1,    -1,    -1,  1304,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1562,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2712,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1597,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2738,  2739,
      -1,  2741,    -1,    -1,    -1,    -1,    -1,    -1,  2748,    -1,
    1619,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3366,  2779,
      -1,  2781,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1678,
      -1,    -1,    -1,  3401,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1695,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1713,    -1,    -1,    -1,    -1,    -1,
    1477,    -1,    -1,  2853,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1738,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2878,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2906,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2922,    -1,    -1,  1794,  3514,    -1,  1555,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2936,  3525,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2951,    -1,  1580,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2968,    -1,
      -1,    -1,  2972,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2982,    -1,    -1,    -1,    -1,  2987,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3589,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3597,
      -1,    -1,    -1,    -1,  3014,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3045,    -1,    -1,  3048,    -1,
      -1,    -1,    -1,    -1,  3054,    -1,    -1,    -1,    -1,    -1,
    3060,    -1,  3062,    -1,    -1,    -1,    -1,  3067,  3068,    -1,
      -1,  3071,  3072,  3073,  3074,  3075,  3076,  3077,  3078,  3079,
    3080,    -1,    -1,    -1,  3084,  3085,    -1,    -1,    -1,    -1,
      -1,    -1,  3092,    -1,    -1,  1964,    -1,  3097,    -1,    -1,
      -1,    -1,    -1,  3103,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1739,  3113,    -1,    -1,  3116,    -1,  3118,    -1,
      -1,    -1,    -1,    -1,  1751,    -1,  3126,  3127,  3128,  3129,
      -1,    -1,    -1,  3133,    -1,    -1,  3136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3146,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3155,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3753,    -1,    -1,    -1,  1796,
      -1,    -1,    -1,  1800,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1809,    -1,  1811,    -1,  1813,    -1,    -1,    -1,
    3778,  1818,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1840,  1841,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   792,     5,    -1,    -1,    -1,
     797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3248,    -1,
      -1,  3839,    -1,    -1,    -1,    -1,    25,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    35,    36,    -1,    -1,
     827,    -1,    -1,    -1,    43,    44,    -1,    -1,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    -1,    72,    -1,    -1,    -1,    76,    77,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     877,    -1,    -1,    -1,    -1,  2194,    -1,   884,    -1,    -1,
    2199,  2200,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3928,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3353,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3366,  3955,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2002,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3988,  3401,  3402,  3403,  3992,  3993,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3421,    -1,   980,    -1,   194,  3426,    -1,    -1,  3429,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   208,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2316,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   227,    -1,
      -1,    -1,  1019,    -1,    -1,    -1,    -1,    -1,  3468,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3504,    -1,    -1,    -1,    -1,  2378,
      -1,  3511,  3512,   282,  3514,  2142,   285,    -1,    -1,  3519,
    3520,    -1,    -1,    -1,  3524,  3525,    -1,    -1,  2155,    -1,
    3530,  3531,    -1,  2160,  3534,    -1,    -1,  2164,   307,    -1,
      -1,    -1,    -1,  2170,    -1,    -1,    -1,    -1,    -1,  2176,
      -1,    -1,    -1,    -1,  3554,  2182,    -1,    -1,    -1,    -1,
    2187,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2210,  2211,  2212,  2213,    -1,    -1,  3589,
    2217,  2218,   980,    -1,    -1,  2222,    -1,  3597,  2225,  1156,
      -1,    -1,    -1,    -1,    -1,    -1,  1163,  2476,    -1,    -1,
     379,    -1,  2239,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2249,    -1,  2251,    -1,    -1,  1184,    -1,    -1,
      -1,  1019,    -1,  2260,  2261,  2262,    -1,  2264,    -1,    -1,
      -1,    -1,    -1,    -1,  2271,  2272,    -1,    -1,    -1,    -1,
     419,    -1,  2279,  2280,    -1,    -1,    -1,  1214,    -1,    -1,
      -1,    -1,    -1,   432,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   445,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3684,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   470,    -1,    -1,    -1,    -1,    -1,   476,   477,   478,
      -1,    -1,    -1,   482,    -1,   484,    -1,  1274,    -1,   488,
     489,   490,   491,   492,    -1,  3725,   495,   496,   497,    -1,
    3730,    -1,    -1,   502,   503,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3744,    -1,    -1,    -1,  3748,    -1,
    1307,    -1,    -1,  3753,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1329,    -1,  3774,    -1,    -1,    -1,  3778,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3798,  3799,
    1357,    -1,  3802,    -1,    -1,    -1,    -1,    -1,    -1,  3809,
    3810,    -1,    -1,    -1,  2441,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1388,  1389,    -1,  1391,    -1,    -1,    -1,    -1,  3839,
      -1,    -1,  3842,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1408,    -1,    -1,    -1,  2482,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2738,
    2739,    -1,  2741,  3873,    -1,    -1,    -1,    -1,    -1,  2748,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1460,    -1,    -1,    -1,    -1,    -1,    -1,
    2779,    -1,  2781,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3921,  3922,    -1,    -1,    -1,    -1,    -1,  3928,    -1,
    1487,    -1,    -1,    -1,  1491,  1492,    -1,    -1,    -1,    -1,
      -1,  1329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3954,  3955,    -1,  3957,    -1,  3959,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1357,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2853,  3985,    -1,    -1,  3988,    -1,
      -1,    -1,  3992,  3993,    -1,    -1,    -1,    -1,    -1,    -1,
    1388,  1389,    -1,  1391,    -1,  1562,    -1,    -1,    -1,  2878,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1408,    -1,    -1,  4023,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2906,    -1,    -1,
    1597,    -1,    -1,    -1,  4044,    -1,    -1,    -1,    -1,    -1,
      -1,  4051,    -1,  2922,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1619,    -1,    -1,    -1,    -1,  2936,    -1,  4069,
      -1,    -1,  1460,    -1,    -1,  2702,  2703,    -1,    -1,    -1,
      -1,    -1,  2951,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2725,  1487,
      -1,    -1,    -1,  1491,  1492,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2987,    -1,
      -1,  1678,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2757,  2758,  2759,  2760,    -1,    -1,    -1,  4137,  1695,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1713,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3048,
      -1,  1738,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3067,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2843,    -1,    -1,    -1,
      -1,  2848,  4222,  3092,    -1,    -1,    -1,    -1,    -1,  1786,
      -1,  1788,    -1,    -1,    -1,    -1,    -1,  1794,    -1,    -1,
    1797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3126,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2923,  2924,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1864,    -1,    -1,
      -1,    -1,    -1,    -1,  2941,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2961,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1899,  1900,    -1,    -1,    -1,    -1,  1184,    -1,
    1907,    -1,    -1,  1910,    -1,    -1,  1913,    -1,    -1,    -1,
      -1,  2988,    -1,    -1,  1921,  1922,    -1,    -1,    -1,    -1,
      -1,    -1,  1929,    -1,  3001,  1932,  1933,  1934,  1935,  3248,
      -1,    -1,    -1,    -1,    -1,  1942,  1943,    -1,  1945,    -1,
    1947,    -1,    -1,  1950,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1964,  1965,    -1,
      -1,    -1,  1969,    -1,    -1,    -1,  1973,    -1,    -1,    -1,
    1977,    -1,    -1,  1980,  1981,  1982,  1983,  1984,  1985,  1986,
    1987,  1988,    -1,  1990,    -1,    -1,    -1,    -1,    -1,  1996,
      -1,    -1,    -1,  2000,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1307,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3366,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2071,    -1,    -1,    -1,    -1,  1907,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3401,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1929,    -1,    -1,  1932,    -1,    -1,  1935,    -1,    -1,
      -1,    -1,    -1,    -1,  1942,  1943,    -1,    -1,    -1,  1947,
      -1,    -1,  1950,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1965,    -1,    -1,
      -1,  1969,    -1,    -1,    -1,  1973,    -1,    -1,    -1,  1977,
      -1,    -1,  1980,  1981,  1982,  1983,  1984,  1985,  1986,  1987,
    1988,    -1,  1990,    -1,    -1,    -1,  1184,    -1,  1996,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2174,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2194,    -1,    -1,
      -1,    -1,  2199,  2200,    -1,  3514,    -1,    -1,    -1,    -1,
      -1,    -1,  3279,    -1,  1184,    -1,  3525,  3284,    -1,  3286,
    3287,  3288,  3289,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2071,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3589,  3348,  3349,  3350,    -1,  3352,  1562,    -1,  3597,  1307,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2314,    -1,  2316,
      -1,  1597,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1184,    -1,  1307,    -1,    -1,
      -1,    -1,    -1,  1619,    -1,    -1,  2174,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3434,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2398,  1678,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1695,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1713,  2435,    -1,
      -1,    -1,    -1,    -1,  3753,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1307,    -1,
      -1,    -1,  1738,    -1,    -1,    -1,    -1,    -1,  2465,  3778,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2476,
      -1,    -1,    -1,    -1,    -1,    -1,  2314,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2495,  2496,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1794,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3594,  2525,  2526,
    3839,    -1,    -1,  2530,    -1,    -1,    -1,    -1,  3605,    -1,
      -1,    -1,    -1,    -1,  1562,  2542,  2543,  2544,  2545,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2554,    -1,    -1,
    2557,    -1,  2559,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2398,    -1,  2569,  2570,    -1,  2572,    -1,    -1,    -1,  1597,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2585,    -1,
    2587,    -1,  1562,    -1,  2591,    -1,    -1,    -1,    -1,    -1,
      -1,  1619,    -1,    -1,    -1,    -1,    -1,  2435,    -1,    -1,
    2607,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3928,
      -1,  2618,    -1,  2620,  2621,  2622,    -1,  1597,    -1,    -1,
      -1,  3698,    -1,    -1,    -1,    -1,    -1,  2465,    -1,    -1,
      -1,    -1,    -1,  2640,    -1,    -1,  3955,    -1,    -1,  1619,
    3717,    -1,  2649,    -1,    -1,    -1,    -1,    -1,    -1,  2656,
    1678,    -1,    -1,    -1,  2661,    -1,    -1,    -1,  2496,    -1,
      -1,  2668,  2669,  2670,    -1,    -1,    -1,  1695,    -1,  3988,
      -1,    -1,    -1,  3992,  3993,    -1,    -1,    -1,  1964,    -1,
      -1,    -1,    -1,    -1,    -1,  1713,  3763,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1678,    -1,
      -1,    -1,    -1,  1562,  2542,  2712,  2544,  2545,    -1,    -1,
    1738,    -1,    -1,    -1,    -1,  1695,  2554,    -1,    -1,  2557,
      -1,  2559,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2738,  2739,  1713,  2741,    -1,    -1,    -1,  1597,    -1,
      -1,  2748,    -1,    -1,    -1,    -1,    -1,  2585,    -1,  2587,
      -1,    -1,    -1,  2591,    -1,    -1,    -1,    -1,  1738,    -1,
    1619,    -1,    -1,    -1,    -1,    -1,  1794,    -1,    -1,    -1,
      -1,    -1,  2779,    -1,  2781,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2622,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2640,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2649,    -1,    -1,  1794,    -1,    -1,    -1,  2656,  1678,
      -1,    -1,    -1,  2661,    -1,    -1,    -1,    -1,    -1,    -1,
    2668,  2669,  2670,    -1,    -1,    -1,  1695,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2853,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1713,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2878,    -1,    -1,  2712,    -1,    -1,    -1,    -1,  1738,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2906,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2194,    -1,
      -1,    -1,    -1,  2199,  2200,  2922,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2936,
      -1,    -1,    -1,    -1,    -1,  1794,  1964,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2951,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2968,    -1,    -1,    -1,  2972,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2982,    -1,    -1,    -1,    -1,
    2987,    -1,    -1,    -1,  1964,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3014,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4100,    -1,    -1,    -1,    -1,    -1,    -1,
    2316,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3045,    -1,
      -1,  3048,    -1,    -1,    -1,    -1,    -1,  3054,    -1,    -1,
      -1,    -1,    -1,  3060,    -1,  3062,    -1,    -1,    -1,    -1,
    3067,  3068,    -1,    -1,  3071,  3072,  3073,  3074,  3075,  3076,
    3077,  3078,  3079,  3080,    -1,    -1,    -1,  3084,  3085,    -1,
      -1,    -1,    -1,    -1,    -1,  3092,    -1,    -1,    -1,    -1,
    3097,    -1,  2378,    -1,    -1,    -1,  3103,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1964,  3113,    -1,    -1,  3116,
      -1,  3118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3126,
    3127,  3128,  3129,    -1,    -1,    -1,  3133,    -1,    -1,  3136,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3146,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3155,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2194,    -1,    -1,    -1,
      -1,  2199,  2200,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2476,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3045,    -1,    -1,
      -1,    -1,    -1,    -1,  2194,    -1,  3054,    -1,    -1,  2199,
    2200,    -1,  3060,    -1,  3062,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3248,    -1,    -1,    -1,    -1,  3084,  3085,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3103,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3113,    -1,    -1,  3116,    -1,
    3118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2316,  3127,
      -1,    -1,    -1,    -1,    -1,  3133,    -1,    -1,  3136,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3146,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3155,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2194,  2316,    -1,    -1,    -1,
    2199,  2200,    -1,    -1,    -1,    -1,  3353,    -1,    -1,    -1,
    2378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3366,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3401,  3402,  3403,    -1,  2378,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3421,    -1,    -1,    -1,    -1,  3426,
      -1,    -1,  3429,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2476,    -1,
      -1,    -1,  2738,  2739,    -1,  2741,    -1,  2316,    -1,    -1,
      -1,  3468,  2748,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2779,    -1,  2781,  2476,  3504,    -1,    -1,
      -1,    -1,    -1,    -1,  3511,  3512,    -1,  3514,    -1,    -1,
      -1,    -1,  3519,  3520,    -1,    -1,    -1,  3524,  3525,  2378,
      -1,    -1,    -1,  3530,  3531,    -1,    -1,  3534,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3554,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3402,  3403,    -1,  2853,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1404,    -1,    -1,    -1,    -1,
      -1,    -1,  3589,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3597,    -1,  2878,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2476,    -1,    -1,
    2906,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3468,    -1,    -1,    -1,    -1,    -1,  2922,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1473,    -1,    -1,    -1,    -1,    -1,
    2936,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2951,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3511,  3512,    -1,    -1,  3684,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3524,    -1,    -1,    -1,
      -1,    -1,  3530,  3531,    -1,    -1,  3534,    -1,    -1,    -1,
      -1,  2987,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2738,  2739,    -1,  2741,    -