/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONTINUE = 265,
     SQL_COUNT = 266,
     SQL_CURRENT = 267,
     SQL_DATA = 268,
     SQL_DATETIME_INTERVAL_CODE = 269,
     SQL_DATETIME_INTERVAL_PRECISION = 270,
     SQL_DESCRIBE = 271,
     SQL_DESCRIPTOR = 272,
     SQL_DISCONNECT = 273,
     SQL_ENUM = 274,
     SQL_FOUND = 275,
     SQL_FREE = 276,
     SQL_GO = 277,
     SQL_GOTO = 278,
     SQL_IDENTIFIED = 279,
     SQL_INDICATOR = 280,
     SQL_KEY_MEMBER = 281,
     SQL_LENGTH = 282,
     SQL_LONG = 283,
     SQL_NAME = 284,
     SQL_NULLABLE = 285,
     SQL_OCTET_LENGTH = 286,
     SQL_OPEN = 287,
     SQL_OUTPUT = 288,
     SQL_REFERENCE = 289,
     SQL_RETURNED_LENGTH = 290,
     SQL_RETURNED_OCTET_LENGTH = 291,
     SQL_SCALE = 292,
     SQL_SECTION = 293,
     SQL_SHORT = 294,
     SQL_SIGNED = 295,
     SQL_SQL = 296,
     SQL_SQLERROR = 297,
     SQL_SQLPRINT = 298,
     SQL_SQLWARNING = 299,
     SQL_START = 300,
     SQL_STOP = 301,
     SQL_STRUCT = 302,
     SQL_UNSIGNED = 303,
     SQL_VALUE = 304,
     SQL_VAR = 305,
     SQL_WHENEVER = 306,
     S_ADD = 307,
     S_AND = 308,
     S_ANYTHING = 309,
     S_AUTO = 310,
     S_CONST = 311,
     S_DEC = 312,
     S_DIV = 313,
     S_DOTPOINT = 314,
     S_EQUAL = 315,
     S_EXTERN = 316,
     S_INC = 317,
     S_LSHIFT = 318,
     S_MEMPOINT = 319,
     S_MEMBER = 320,
     S_MOD = 321,
     S_MUL = 322,
     S_NEQUAL = 323,
     S_OR = 324,
     S_REGISTER = 325,
     S_RSHIFT = 326,
     S_STATIC = 327,
     S_SUB = 328,
     S_VOLATILE = 329,
     S_TYPEDEF = 330,
     TYPECAST = 331,
     ABORT_P = 332,
     ABSOLUTE_P = 333,
     ACCESS = 334,
     ACTION = 335,
     ADD = 336,
     ADMIN = 337,
     AFTER = 338,
     AGGREGATE = 339,
     ALL = 340,
     ALSO = 341,
     ALTER = 342,
     ANALYSE = 343,
     ANALYZE = 344,
     AND = 345,
     ANY = 346,
     ARRAY = 347,
     AS = 348,
     ASC = 349,
     ASSERTION = 350,
     ASSIGNMENT = 351,
     ASYMMETRIC = 352,
     AT = 353,
     AUTHORIZATION = 354,
     BACKWARD = 355,
     BEFORE = 356,
     BEGIN_P = 357,
     BETWEEN = 358,
     BIGINT = 359,
     BINARY = 360,
     BIT = 361,
     BOOLEAN_P = 362,
     BOTH = 363,
     BY = 364,
     CACHE = 365,
     CALLED = 366,
     CASCADE = 367,
     CASE = 368,
     CAST = 369,
     CHAIN = 370,
     CHAR_P = 371,
     CHARACTER = 372,
     CHARACTERISTICS = 373,
     CHECK = 374,
     CHECKPOINT = 375,
     CLASS = 376,
     CLOSE = 377,
     CLUSTER = 378,
     COALESCE = 379,
     COLLATE = 380,
     COLUMN = 381,
     COMMENT = 382,
     COMMIT = 383,
     COMMITTED = 384,
     CONNECTION = 385,
     CONSTRAINT = 386,
     CONSTRAINTS = 387,
     CONVERSION_P = 388,
     CONVERT = 389,
     COPY = 390,
     CREATE = 391,
     CREATEDB = 392,
     CREATEROLE = 393,
     CREATEUSER = 394,
     CROSS = 395,
     CSV = 396,
     CURRENT_DATE = 397,
     CURRENT_ROLE = 398,
     CURRENT_TIME = 399,
     CURRENT_TIMESTAMP = 400,
     CURRENT_USER = 401,
     CURSOR = 402,
     CYCLE = 403,
     DATABASE = 404,
     DAY_P = 405,
     DEALLOCATE = 406,
     DEC = 407,
     DECIMAL_P = 408,
     DECLARE = 409,
     DEFAULT = 410,
     DEFAULTS = 411,
     DEFERRABLE = 412,
     DEFERRED = 413,
     DEFINER = 414,
     DELETE_P = 415,
     DELIMITER = 416,
     DELIMITERS = 417,
     DESC = 418,
     DISABLE_P = 419,
     DISTINCT = 420,
     DO = 421,
     DOMAIN_P = 422,
     DOUBLE_P = 423,
     DROP = 424,
     EACH = 425,
     ELSE = 426,
     ENABLE_P = 427,
     ENCODING = 428,
     ENCRYPTED = 429,
     END_P = 430,
     ESCAPE = 431,
     EXCEPT = 432,
     EXCLUSIVE = 433,
     EXCLUDING = 434,
     EXECUTE = 435,
     EXISTS = 436,
     EXPLAIN = 437,
     EXTERNAL = 438,
     EXTRACT = 439,
     FALSE_P = 440,
     FETCH = 441,
     FIRST_P = 442,
     FLOAT_P = 443,
     FOR = 444,
     FORCE = 445,
     FOREIGN = 446,
     FORWARD = 447,
     FREEZE = 448,
     FROM = 449,
     FULL = 450,
     FUNCTION = 451,
     GET = 452,
     GLOBAL = 453,
     GRANT = 454,
     GRANTED = 455,
     GREATEST = 456,
     GROUP_P = 457,
     HANDLER = 458,
     HAVING = 459,
     HEADER = 460,
     HOLD = 461,
     HOUR_P = 462,
     ILIKE = 463,
     IMMEDIATE = 464,
     IMMUTABLE = 465,
     IMPLICIT_P = 466,
     IN_P = 467,
     INCLUDING = 468,
     INCREMENT = 469,
     INDEX = 470,
     INHERIT = 471,
     INHERITS = 472,
     INITIALLY = 473,
     INNER_P = 474,
     INOUT = 475,
     INPUT_P = 476,
     INSENSITIVE = 477,
     INSERT = 478,
     INSTEAD = 479,
     INT_P = 480,
     INTEGER = 481,
     INTERSECT = 482,
     INTERVAL = 483,
     INTO = 484,
     INVOKER = 485,
     IS = 486,
     ISNULL = 487,
     ISOLATION = 488,
     JOIN = 489,
     KEY = 490,
     LANCOMPILER = 491,
     LANGUAGE = 492,
     LARGE_P = 493,
     LAST_P = 494,
     LEADING = 495,
     LEAST = 496,
     LEFT = 497,
     LEVEL = 498,
     LIKE = 499,
     LIMIT = 500,
     LISTEN = 501,
     LOAD = 502,
     LOCAL = 503,
     LOCALTIME = 504,
     LOCALTIMESTAMP = 505,
     LOCATION = 506,
     LOCK_P = 507,
     LOGIN_P = 508,
     MATCH = 509,
     MAXVALUE = 510,
     MINUTE_P = 511,
     MINVALUE = 512,
     MODE = 513,
     MONTH_P = 514,
     MOVE = 515,
     NAMES = 516,
     NATIONAL = 517,
     NATURAL = 518,
     NCHAR = 519,
     NEW = 520,
     NEXT = 521,
     NO = 522,
     NOCREATEDB = 523,
     NOCREATEROLE = 524,
     NOCREATEUSER = 525,
     NOINHERIT = 526,
     NOLOGIN_P = 527,
     NONE = 528,
     NOSUPERUSER = 529,
     NOT = 530,
     NOTHING = 531,
     NOTIFY = 532,
     NOTNULL = 533,
     NOWAIT = 534,
     NULL_P = 535,
     NULLIF = 536,
     NUMERIC = 537,
     OBJECT_P = 538,
     OF = 539,
     OFF = 540,
     OFFSET = 541,
     OIDS = 542,
     OLD = 543,
     ON = 544,
     ONLY = 545,
     OPERATOR = 546,
     OPTION = 547,
     OR = 548,
     ORDER = 549,
     OUT_P = 550,
     OUTER_P = 551,
     OVERLAPS = 552,
     OVERLAY = 553,
     OWNER = 554,
     PARTIAL = 555,
     PASSWORD = 556,
     PLACING = 557,
     POSITION = 558,
     PRECISION = 559,
     PRESERVE = 560,
     PREPARE = 561,
     PREPARED = 562,
     PRIMARY = 563,
     PRIOR = 564,
     PRIVILEGES = 565,
     PROCEDURAL = 566,
     PROCEDURE = 567,
     QUOTE = 568,
     READ = 569,
     REAL = 570,
     RECHECK = 571,
     REFERENCES = 572,
     REINDEX = 573,
     RELATIVE_P = 574,
     RELEASE = 575,
     RENAME = 576,
     REPEATABLE = 577,
     REPLACE = 578,
     RESET = 579,
     RESTART = 580,
     RESTRICT = 581,
     RETURNS = 582,
     REVOKE = 583,
     RIGHT = 584,
     ROLE = 585,
     ROLLBACK = 586,
     ROW = 587,
     ROWS = 588,
     RULE = 589,
     SAVEPOINT = 590,
     SCHEMA = 591,
     SCROLL = 592,
     SECOND_P = 593,
     SECURITY = 594,
     SELECT = 595,
     SEQUENCE = 596,
     SERIALIZABLE = 597,
     SESSION = 598,
     SESSION_USER = 599,
     SET = 600,
     SETOF = 601,
     SHARE = 602,
     SHOW = 603,
     SIMILAR = 604,
     SIMPLE = 605,
     SMALLINT = 606,
     SOME = 607,
     STABLE = 608,
     START = 609,
     STATEMENT = 610,
     STATISTICS = 611,
     STDIN = 612,
     STDOUT = 613,
     STORAGE = 614,
     STRICT_P = 615,
     SUBSTRING = 616,
     SUPERUSER_P = 617,
     SYMMETRIC = 618,
     SYSID = 619,
     SYSTEM_P = 620,
     TABLE = 621,
     TABLESPACE = 622,
     TEMP = 623,
     TEMPLATE = 624,
     TEMPORARY = 625,
     THEN = 626,
     TIME = 627,
     TIMESTAMP = 628,
     TO = 629,
     TOAST = 630,
     TRAILING = 631,
     TRANSACTION = 632,
     TREAT = 633,
     TRIGGER = 634,
     TRIM = 635,
     TRUE_P = 636,
     TRUNCATE = 637,
     TRUSTED = 638,
     TYPE_P = 639,
     UNCOMMITTED = 640,
     UNENCRYPTED = 641,
     UNION = 642,
     UNIQUE = 643,
     UNKNOWN = 644,
     UNLISTEN = 645,
     UNTIL = 646,
     UPDATE = 647,
     USER = 648,
     USING = 649,
     VACUUM = 650,
     VALID = 651,
     VALIDATOR = 652,
     VALUES = 653,
     VARCHAR = 654,
     VARYING = 655,
     VERBOSE = 656,
     VIEW = 657,
     VOLATILE = 658,
     WHEN = 659,
     WHERE = 660,
     WITH = 661,
     WITHOUT = 662,
     WORK = 663,
     WRITE = 664,
     YEAR_P = 665,
     ZONE = 666,
     UNIONJOIN = 667,
     IDENT = 668,
     SCONST = 669,
     Op = 670,
     CSTRING = 671,
     CVARIABLE = 672,
     CPP_LINE = 673,
     IP = 674,
     BCONST = 675,
     XCONST = 676,
     ICONST = 677,
     PARAM = 678,
     FCONST = 679,
     POSTFIXOP = 680,
     UMINUS = 681
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONTINUE 265
#define SQL_COUNT 266
#define SQL_CURRENT 267
#define SQL_DATA 268
#define SQL_DATETIME_INTERVAL_CODE 269
#define SQL_DATETIME_INTERVAL_PRECISION 270
#define SQL_DESCRIBE 271
#define SQL_DESCRIPTOR 272
#define SQL_DISCONNECT 273
#define SQL_ENUM 274
#define SQL_FOUND 275
#define SQL_FREE 276
#define SQL_GO 277
#define SQL_GOTO 278
#define SQL_IDENTIFIED 279
#define SQL_INDICATOR 280
#define SQL_KEY_MEMBER 281
#define SQL_LENGTH 282
#define SQL_LONG 283
#define SQL_NAME 284
#define SQL_NULLABLE 285
#define SQL_OCTET_LENGTH 286
#define SQL_OPEN 287
#define SQL_OUTPUT 288
#define SQL_REFERENCE 289
#define SQL_RETURNED_LENGTH 290
#define SQL_RETURNED_OCTET_LENGTH 291
#define SQL_SCALE 292
#define SQL_SECTION 293
#define SQL_SHORT 294
#define SQL_SIGNED 295
#define SQL_SQL 296
#define SQL_SQLERROR 297
#define SQL_SQLPRINT 298
#define SQL_SQLWARNING 299
#define SQL_START 300
#define SQL_STOP 301
#define SQL_STRUCT 302
#define SQL_UNSIGNED 303
#define SQL_VALUE 304
#define SQL_VAR 305
#define SQL_WHENEVER 306
#define S_ADD 307
#define S_AND 308
#define S_ANYTHING 309
#define S_AUTO 310
#define S_CONST 311
#define S_DEC 312
#define S_DIV 313
#define S_DOTPOINT 314
#define S_EQUAL 315
#define S_EXTERN 316
#define S_INC 317
#define S_LSHIFT 318
#define S_MEMPOINT 319
#define S_MEMBER 320
#define S_MOD 321
#define S_MUL 322
#define S_NEQUAL 323
#define S_OR 324
#define S_REGISTER 325
#define S_RSHIFT 326
#define S_STATIC 327
#define S_SUB 328
#define S_VOLATILE 329
#define S_TYPEDEF 330
#define TYPECAST 331
#define ABORT_P 332
#define ABSOLUTE_P 333
#define ACCESS 334
#define ACTION 335
#define ADD 336
#define ADMIN 337
#define AFTER 338
#define AGGREGATE 339
#define ALL 340
#define ALSO 341
#define ALTER 342
#define ANALYSE 343
#define ANALYZE 344
#define AND 345
#define ANY 346
#define ARRAY 347
#define AS 348
#define ASC 349
#define ASSERTION 350
#define ASSIGNMENT 351
#define ASYMMETRIC 352
#define AT 353
#define AUTHORIZATION 354
#define BACKWARD 355
#define BEFORE 356
#define BEGIN_P 357
#define BETWEEN 358
#define BIGINT 359
#define BINARY 360
#define BIT 361
#define BOOLEAN_P 362
#define BOTH 363
#define BY 364
#define CACHE 365
#define CALLED 366
#define CASCADE 367
#define CASE 368
#define CAST 369
#define CHAIN 370
#define CHAR_P 371
#define CHARACTER 372
#define CHARACTERISTICS 373
#define CHECK 374
#define CHECKPOINT 375
#define CLASS 376
#define CLOSE 377
#define CLUSTER 378
#define COALESCE 379
#define COLLATE 380
#define COLUMN 381
#define COMMENT 382
#define COMMIT 383
#define COMMITTED 384
#define CONNECTION 385
#define CONSTRAINT 386
#define CONSTRAINTS 387
#define CONVERSION_P 388
#define CONVERT 389
#define COPY 390
#define CREATE 391
#define CREATEDB 392
#define CREATEROLE 393
#define CREATEUSER 394
#define CROSS 395
#define CSV 396
#define CURRENT_DATE 397
#define CURRENT_ROLE 398
#define CURRENT_TIME 399
#define CURRENT_TIMESTAMP 400
#define CURRENT_USER 401
#define CURSOR 402
#define CYCLE 403
#define DATABASE 404
#define DAY_P 405
#define DEALLOCATE 406
#define DEC 407
#define DECIMAL_P 408
#define DECLARE 409
#define DEFAULT 410
#define DEFAULTS 411
#define DEFERRABLE 412
#define DEFERRED 413
#define DEFINER 414
#define DELETE_P 415
#define DELIMITER 416
#define DELIMITERS 417
#define DESC 418
#define DISABLE_P 419
#define DISTINCT 420
#define DO 421
#define DOMAIN_P 422
#define DOUBLE_P 423
#define DROP 424
#define EACH 425
#define ELSE 426
#define ENABLE_P 427
#define ENCODING 428
#define ENCRYPTED 429
#define END_P 430
#define ESCAPE 431
#define EXCEPT 432
#define EXCLUSIVE 433
#define EXCLUDING 434
#define EXECUTE 435
#define EXISTS 436
#define EXPLAIN 437
#define EXTERNAL 438
#define EXTRACT 439
#define FALSE_P 440
#define FETCH 441
#define FIRST_P 442
#define FLOAT_P 443
#define FOR 444
#define FORCE 445
#define FOREIGN 446
#define FORWARD 447
#define FREEZE 448
#define FROM 449
#define FULL 450
#define FUNCTION 451
#define GET 452
#define GLOBAL 453
#define GRANT 454
#define GRANTED 455
#define GREATEST 456
#define GROUP_P 457
#define HANDLER 458
#define HAVING 459
#define HEADER 460
#define HOLD 461
#define HOUR_P 462
#define ILIKE 463
#define IMMEDIATE 464
#define IMMUTABLE 465
#define IMPLICIT_P 466
#define IN_P 467
#define INCLUDING 468
#define INCREMENT 469
#define INDEX 470
#define INHERIT 471
#define INHERITS 472
#define INITIALLY 473
#define INNER_P 474
#define INOUT 475
#define INPUT_P 476
#define INSENSITIVE 477
#define INSERT 478
#define INSTEAD 479
#define INT_P 480
#define INTEGER 481
#define INTERSECT 482
#define INTERVAL 483
#define INTO 484
#define INVOKER 485
#define IS 486
#define ISNULL 487
#define ISOLATION 488
#define JOIN 489
#define KEY 490
#define LANCOMPILER 491
#define LANGUAGE 492
#define LARGE_P 493
#define LAST_P 494
#define LEADING 495
#define LEAST 496
#define LEFT 497
#define LEVEL 498
#define LIKE 499
#define LIMIT 500
#define LISTEN 501
#define LOAD 502
#define LOCAL 503
#define LOCALTIME 504
#define LOCALTIMESTAMP 505
#define LOCATION 506
#define LOCK_P 507
#define LOGIN_P 508
#define MATCH 509
#define MAXVALUE 510
#define MINUTE_P 511
#define MINVALUE 512
#define MODE 513
#define MONTH_P 514
#define MOVE 515
#define NAMES 516
#define NATIONAL 517
#define NATURAL 518
#define NCHAR 519
#define NEW 520
#define NEXT 521
#define NO 522
#define NOCREATEDB 523
#define NOCREATEROLE 524
#define NOCREATEUSER 525
#define NOINHERIT 526
#define NOLOGIN_P 527
#define NONE 528
#define NOSUPERUSER 529
#define NOT 530
#define NOTHING 531
#define NOTIFY 532
#define NOTNULL 533
#define NOWAIT 534
#define NULL_P 535
#define NULLIF 536
#define NUMERIC 537
#define OBJECT_P 538
#define OF 539
#define OFF 540
#define OFFSET 541
#define OIDS 542
#define OLD 543
#define ON 544
#define ONLY 545
#define OPERATOR 546
#define OPTION 547
#define OR 548
#define ORDER 549
#define OUT_P 550
#define OUTER_P 551
#define OVERLAPS 552
#define OVERLAY 553
#define OWNER 554
#define PARTIAL 555
#define PASSWORD 556
#define PLACING 557
#define POSITION 558
#define PRECISION 559
#define PRESERVE 560
#define PREPARE 561
#define PREPARED 562
#define PRIMARY 563
#define PRIOR 564
#define PRIVILEGES 565
#define PROCEDURAL 566
#define PROCEDURE 567
#define QUOTE 568
#define READ 569
#define REAL 570
#define RECHECK 571
#define REFERENCES 572
#define REINDEX 573
#define RELATIVE_P 574
#define RELEASE 575
#define RENAME 576
#define REPEATABLE 577
#define REPLACE 578
#define RESET 579
#define RESTART 580
#define RESTRICT 581
#define RETURNS 582
#define REVOKE 583
#define RIGHT 584
#define ROLE 585
#define ROLLBACK 586
#define ROW 587
#define ROWS 588
#define RULE 589
#define SAVEPOINT 590
#define SCHEMA 591
#define SCROLL 592
#define SECOND_P 593
#define SECURITY 594
#define SELECT 595
#define SEQUENCE 596
#define SERIALIZABLE 597
#define SESSION 598
#define SESSION_USER 599
#define SET 600
#define SETOF 601
#define SHARE 602
#define SHOW 603
#define SIMILAR 604
#define SIMPLE 605
#define SMALLINT 606
#define SOME 607
#define STABLE 608
#define START 609
#define STATEMENT 610
#define STATISTICS 611
#define STDIN 612
#define STDOUT 613
#define STORAGE 614
#define STRICT_P 615
#define SUBSTRING 616
#define SUPERUSER_P 617
#define SYMMETRIC 618
#define SYSID 619
#define SYSTEM_P 620
#define TABLE 621
#define TABLESPACE 622
#define TEMP 623
#define TEMPLATE 624
#define TEMPORARY 625
#define THEN 626
#define TIME 627
#define TIMESTAMP 628
#define TO 629
#define TOAST 630
#define TRAILING 631
#define TRANSACTION 632
#define TREAT 633
#define TRIGGER 634
#define TRIM 635
#define TRUE_P 636
#define TRUNCATE 637
#define TRUSTED 638
#define TYPE_P 639
#define UNCOMMITTED 640
#define UNENCRYPTED 641
#define UNION 642
#define UNIQUE 643
#define UNKNOWN 644
#define UNLISTEN 645
#define UNTIL 646
#define UPDATE 647
#define USER 648
#define USING 649
#define VACUUM 650
#define VALID 651
#define VALIDATOR 652
#define VALUES 653
#define VARCHAR 654
#define VARYING 655
#define VERBOSE 656
#define VIEW 657
#define VOLATILE 658
#define WHEN 659
#define WHERE 660
#define WITH 661
#define WITHOUT 662
#define WORK 663
#define WRITE 664
#define YEAR_P 665
#define ZONE 666
#define UNIONJOIN 667
#define IDENT 668
#define SCONST 669
#define Op 670
#define CSTRING 671
#define CVARIABLE 672
#define CPP_LINE 673
#define IP 674
#define BCONST 675
#define XCONST 676
#define ICONST 677
#define PARAM 678
#define FCONST 679
#define POSTFIXOP 680
#define UMINUS 681




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;
	
	fprintf(stderr, "%s:%d: ", input_filename, yylineno);
	
	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);
	
	fprintf(stderr, "\n");
	
	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct 
	 * An array is only allowed together with an element argument 
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else 
	 * so we don't have to worry here. */
	
	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * { 
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming. 
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable 
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;
		
	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);
		
		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}
		
		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		
		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);
			
			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier 
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);
	
	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 312 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1249 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1261 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   56172

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  447
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  528
/* YYNRULES -- Number of rules. */
#define YYNRULES  2027
/* YYNRULES -- Number of states. */
#define YYNSTATES  3362

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   682

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   433,     2,     2,
     438,   439,   431,   429,   445,   430,   440,   432,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   446,   441,
     426,   425,   427,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   436,     2,   437,   434,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   442,     2,   443,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     428,   435,   444
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   220,   222,   224,
     226,   228,   230,   232,   234,   240,   242,   243,   246,   250,
     254,   256,   258,   260,   262,   264,   266,   268,   270,   272,
     274,   278,   282,   285,   288,   291,   294,   298,   302,   308,
     314,   320,   325,   331,   337,   342,   346,   350,   356,   363,
     365,   367,   371,   378,   383,   385,   386,   389,   390,   392,
     394,   396,   398,   400,   402,   405,   409,   413,   417,   421,
     425,   428,   434,   437,   440,   444,   448,   450,   454,   456,
     458,   460,   464,   467,   470,   473,   475,   477,   479,   481,
     483,   485,   487,   489,   491,   493,   497,   504,   506,   508,
     510,   512,   513,   515,   517,   520,   524,   529,   533,   536,
     539,   543,   548,   552,   555,   560,   562,   564,   566,   568,
     570,   575,   580,   582,   586,   590,   595,   602,   609,   616,
     623,   628,   635,   638,   643,   647,   651,   655,   659,   663,
     667,   671,   675,   679,   683,   685,   689,   693,   697,   701,
     704,   706,   708,   709,   712,   713,   716,   726,   728,   730,
     732,   734,   736,   739,   740,   742,   744,   748,   752,   754,
     756,   760,   764,   768,   773,   775,   776,   779,   780,   784,
     785,   787,   788,   800,   813,   815,   817,   820,   823,   826,
     829,   830,   832,   833,   835,   839,   841,   843,   845,   849,
     852,   853,   857,   859,   861,   864,   866,   869,   873,   878,
     881,   887,   889,   892,   895,   898,   902,   905,   908,   909,
     913,   915,   920,   926,   933,   945,   949,   950,   954,   956,
     958,   961,   964,   965,   967,   969,   972,   975,   976,   980,
     984,   987,   989,   991,   994,   997,  1002,  1003,  1006,  1009,
    1010,  1014,  1019,  1024,  1025,  1028,  1029,  1034,  1035,  1036,
    1045,  1049,  1053,  1055,  1059,  1060,  1064,  1066,  1068,  1074,
    1079,  1082,  1083,  1086,  1088,  1091,  1095,  1098,  1101,  1104,
    1107,  1111,  1115,  1117,  1118,  1124,  1134,  1136,  1137,  1139,
    1142,  1145,  1146,  1149,  1150,  1156,  1158,  1159,  1166,  1169,
    1170,  1174,  1189,  1209,  1211,  1213,  1215,  1219,  1225,  1227,
    1229,  1231,  1235,  1236,  1238,  1239,  1241,  1243,  1245,  1249,
    1250,  1252,  1254,  1255,  1258,  1260,  1263,  1265,  1268,  1269,
    1272,  1274,  1277,  1280,  1287,  1296,  1300,  1305,  1310,  1315,
    1321,  1325,  1329,  1331,  1335,  1339,  1341,  1343,  1345,  1347,
    1360,  1362,  1366,  1371,  1379,  1384,  1387,  1389,  1390,  1392,
    1393,  1401,  1406,  1408,  1410,  1412,  1414,  1416,  1418,  1420,
    1422,  1424,  1428,  1430,  1433,  1436,  1440,  1444,  1450,  1455,
    1460,  1464,  1469,  1473,  1477,  1480,  1485,  1488,  1490,  1492,
    1494,  1496,  1499,  1502,  1504,  1506,  1508,  1511,  1514,  1516,
    1519,  1522,  1524,  1526,  1533,  1543,  1551,  1561,  1570,  1579,
    1586,  1596,  1604,  1615,  1623,  1625,  1627,  1629,  1631,  1633,
    1635,  1637,  1639,  1641,  1643,  1645,  1647,  1655,  1663,  1674,
    1677,  1679,  1681,  1683,  1687,  1689,  1691,  1693,  1695,  1697,
    1700,  1703,  1706,  1709,  1712,  1715,  1717,  1721,  1723,  1726,
    1730,  1731,  1733,  1737,  1740,  1747,  1754,  1758,  1759,  1763,
    1764,  1777,  1779,  1780,  1783,  1784,  1786,  1790,  1793,  1796,
    1801,  1803,  1806,  1807,  1817,  1825,  1828,  1829,  1833,  1836,
    1838,  1842,  1846,  1850,  1853,  1856,  1858,  1860,  1862,  1864,
    1867,  1869,  1873,  1875,  1877,  1879,  1884,  1886,  1889,  1894,
    1900,  1902,  1904,  1906,  1908,  1912,  1916,  1919,  1922,  1925,
    1928,  1930,  1933,  1934,  1940,  1942,  1945,  1947,  1948,  1954,
    1962,  1964,  1966,  1974,  1976,  1980,  1984,  1988,  1990,  1994,
    2006,  2017,  2020,  2021,  2030,  2035,  2040,  2045,  2047,  2049,
    2051,  2052,  2062,  2069,  2076,  2084,  2091,  2098,  2108,  2115,
    2122,  2129,  2138,  2147,  2154,  2161,  2163,  2164,  2174,  2181,
    2189,  2196,  2203,  2210,  2220,  2227,  2234,  2241,  2249,  2259,
    2269,  2276,  2283,  2290,  2291,  2306,  2308,  2310,  2314,  2318,
    2320,  2322,  2324,  2326,  2328,  2330,  2332,  2333,  2335,  2337,
    2339,  2341,  2343,  2345,  2346,  2353,  2356,  2359,  2362,  2365,
    2368,  2372,  2376,  2379,  2382,  2385,  2388,  2392,  2395,  2401,
    2406,  2410,  2414,  2418,  2420,  2422,  2423,  2427,  2430,  2433,
    2435,  2439,  2442,  2444,  2445,  2453,  2463,  2466,  2472,  2476,
    2478,  2481,  2485,  2489,  2493,  2497,  2501,  2505,  2509,  2513,
    2518,  2522,  2526,  2528,  2529,  2535,  2541,  2546,  2549,  2550,
    2555,  2559,  2566,  2571,  2578,  2585,  2591,  2599,  2601,  2602,
    2613,  2618,  2621,  2623,  2628,  2634,  2640,  2643,  2648,  2650,
    2652,  2654,  2655,  2657,  2658,  2660,  2661,  2665,  2666,  2671,
    2673,  2675,  2677,  2679,  2681,  2683,  2684,  2689,  2694,  2697,
    2699,  2707,  2712,  2716,  2718,  2721,  2727,  2730,  2731,  2737,
    2741,  2742,  2745,  2748,  2751,  2755,  2757,  2761,  2763,  2766,
    2768,  2769,  2776,  2784,  2785,  2788,  2791,  2794,  2798,  2799,
    2802,  2805,  2807,  2809,  2813,  2817,  2819,  2822,  2827,  2832,
    2834,  2836,  2845,  2850,  2855,  2860,  2863,  2865,  2866,  2870,
    2874,  2879,  2884,  2889,  2894,  2897,  2899,  2901,  2902,  2904,
    2905,  2907,  2913,  2915,  2916,  2918,  2919,  2923,  2925,  2929,
    2933,  2936,  2939,  2941,  2946,  2951,  2954,  2957,  2962,  2964,
    2965,  2967,  2969,  2971,  2975,  2976,  2979,  2980,  2985,  2990,
    2994,  2996,  2997,  3000,  3001,  3004,  3005,  3009,  3011,  3013,
    3016,  3018,  3021,  3027,  3034,  3040,  3042,  3045,  3047,  3052,
    3056,  3061,  3065,  3071,  3076,  3082,  3087,  3093,  3096,  3101,
    3103,  3106,  3109,  3112,  3114,  3116,  3117,  3122,  3125,  3127,
    3130,  3133,  3138,  3140,  3143,  3144,  3146,  3150,  3153,  3156,
    3160,  3166,  3173,  3177,  3182,  3183,  3185,  3189,  3193,  3197,
    3201,  3205,  3209,  3211,  3213,  3215,  3217,  3219,  3221,  3223,
    3226,  3232,  3235,  3237,  3239,  3241,  3243,  3245,  3247,  3249,
    3251,  3253,  3255,  3257,  3260,  3263,  3266,  3269,  3272,  3274,
    3278,  3279,  3285,  3289,  3290,  3296,  3300,  3301,  3303,  3305,
    3307,  3309,  3315,  3318,  3320,  3322,  3324,  3326,  3332,  3335,
    3338,  3341,  3343,  3347,  3351,  3354,  3356,  3357,  3361,  3362,
    3368,  3371,  3377,  3380,  3382,  3386,  3390,  3391,  3393,  3395,
    3397,  3399,  3401,  3403,  3407,  3411,  3415,  3419,  3423,  3427,
    3431,  3432,  3434,  3438,  3444,  3447,  3450,  3454,  3458,  3462,
    3466,  3470,  3474,  3478,  3482,  3486,  3490,  3493,  3496,  3500,
    3504,  3507,  3511,  3517,  3522,  3529,  3533,  3539,  3544,  3551,
    3556,  3563,  3569,  3577,  3580,  3584,  3587,  3592,  3596,  3601,
    3605,  3610,  3614,  3619,  3625,  3632,  3640,  3647,  3655,  3662,
    3670,  3674,  3679,  3684,  3691,  3694,  3696,  3700,  3703,  3707,
    3711,  3715,  3719,  3723,  3727,  3731,  3735,  3739,  3743,  3746,
    3749,  3755,  3762,  3770,  3772,  3774,  3777,  3782,  3784,  3786,
    3788,  3791,  3794,  3797,  3799,  3803,  3808,  3814,  3820,  3825,
    3827,  3829,  3834,  3836,  3841,  3843,  3848,  3850,  3855,  3857,
    3859,  3861,  3863,  3870,  3875,  3880,  3885,  3890,  3897,  3903,
    3909,  3915,  3920,  3927,  3932,  3939,  3944,  3949,  3954,  3959,
    3963,  3969,  3971,  3973,  3975,  3977,  3979,  3981,  3983,  3985,
    3987,  3989,  3991,  3993,  3995,  3997,  3999,  4004,  4006,  4011,
    4013,  4018,  4020,  4023,  4025,  4028,  4030,  4034,  4038,  4039,
    4043,  4045,  4047,  4051,  4055,  4059,  4061,  4063,  4065,  4067,
    4069,  4071,  4073,  4075,  4080,  4084,  4087,  4091,  4092,  4096,
    4100,  4103,  4106,  4108,  4109,  4112,  4115,  4119,  4122,  4124,
    4126,  4130,  4136,  4139,  4141,  4146,  4149,  4150,  4152,  4153,
    4155,  4158,  4161,  4164,  4168,  4174,  4176,  4179,  4180,  4183,
    4185,  4186,  4190,  4192,  4196,  4198,  4200,  4204,  4212,  4214,
    4217,  4222,  4224,  4228,  4233,  4238,  4242,  4244,  4246,  4248,
    4250,  4252,  4254,  4258,  4260,  4263,  4265,  4269,  4271,  4273,
    4275,  4277,  4279,  4281,  4283,  4286,  4288,  4291,  4295,  4302,
    4304,  4306,  4308,  4310,  4312,  4314,  4316,  4318,  4320,  4322,
    4324,  4326,  4329,  4331,  4333,  4335,  4337,  4340,  4343,  4345,
    4347,  4349,  4351,  4353,  4355,  4357,  4359,  4362,  4365,  4367,
    4369,  4371,  4373,  4375,  4377,  4379,  4381,  4383,  4385,  4387,
    4389,  4395,  4399,  4402,  4405,  4409,  4417,  4419,  4422,  4425,
    4427,  4428,  4430,  4434,  4436,  4439,  4440,  4443,  4444,  4447,
    4448,  4450,  4454,  4459,  4463,  4465,  4467,  4469,  4472,  4473,
    4481,  4485,  4488,  4490,  4492,  4494,  4495,  4501,  4502,  4507,
    4510,  4512,  4515,  4516,  4518,  4522,  4526,  4530,  4534,  4535,
    4540,  4546,  4552,  4553,  4555,  4557,  4559,  4561,  4564,  4567,
    4570,  4572,  4575,  4576,  4584,  4585,  4591,  4592,  4597,  4600,
    4603,  4605,  4607,  4609,  4611,  4613,  4615,  4617,  4619,  4621,
    4623,  4625,  4631,  4634,  4636,  4640,  4643,  4646,  4650,  4651,
    4657,  4659,  4660,  4666,  4669,  4672,  4674,  4676,  4678,  4681,
    4684,  4688,  4690,  4693,  4696,  4700,  4704,  4709,  4712,  4714,
    4717,  4719,  4721,  4724,  4727,  4731,  4733,  4735,  4737,  4739,
    4740,  4742,  4746,  4751,  4752,  4755,  4756,  4758,  4761,  4765,
    4768,  4770,  4772,  4774,  4775,  4777,  4779,  4783,  4784,  4789,
    4792,  4795,  4797,  4799,  4800,  4802,  4804,  4806,  4808,  4811,
    4815,  4816,  4818,  4821,  4823,  4828,  4833,  4834,  4836,  4839,
    4841,  4843,  4847,  4849,  4851,  4856,  4861,  4866,  4871,  4873,
    4874,  4878,  4882,  4887,  4889,  4893,  4897,  4902,  4904,  4908,
    4912,  4914,  4921,  4923,  4927,  4931,  4938,  4940,  4944,  4948,
    4950,  4952,  4954,  4956,  4958,  4960,  4962,  4964,  4966,  4968,
    4970,  4972,  4974,  4976,  4978,  4983,  4988,  4990,  4992,  4997,
    5002,  5006,  5007,  5015,  5017,  5018,  5019,  5027,  5031,  5036,
    5040,  5042,  5044,  5046,  5049,  5053,  5059,  5062,  5068,  5071,
    5073,  5075,  5077,  5079,  5081,  5083,  5085,  5087,  5089,  5091,
    5093,  5095,  5097,  5099,  5101,  5103,  5105,  5107,  5109,  5111,
    5113,  5115,  5117,  5119,  5121,  5123,  5125,  5127,  5129,  5131,
    5133,  5135,  5137,  5139,  5141,  5143,  5145,  5147,  5149,  5151,
    5153,  5155,  5157,  5159,  5161,  5163,  5165,  5167,  5169,  5171,
    5173,  5175,  5177,  5179,  5181,  5183,  5185,  5187,  5189,  5191,
    5193,  5195,  5197,  5199,  5201,  5203,  5205,  5207,  5209,  5211,
    5213,  5215,  5217,  5219,  5221,  5223,  5225,  5227,  5229,  5231,
    5233,  5235,  5237,  5239,  5241,  5243,  5245,  5247,  5249,  5251,
    5253,  5255,  5257,  5259,  5261,  5263,  5265,  5267,  5269,  5271,
    5273,  5275,  5277,  5279,  5281,  5283,  5285,  5287,  5289,  5291,
    5293,  5295,  5297,  5299,  5301,  5303,  5305,  5307,  5309,  5311,
    5313,  5315,  5317,  5319,  5321,  5323,  5325,  5327,  5329,  5331,
    5333,  5335,  5337,  5339,  5341,  5343,  5345,  5347,  5349,  5351,
    5353,  5355,  5357,  5359,  5361,  5363,  5365,  5367,  5369,  5371,
    5373,  5375,  5377,  5379,  5381,  5383,  5385,  5387,  5389,  5391,
    5393,  5395,  5397,  5399,  5401,  5403,  5405,  5407,  5409,  5411,
    5413,  5415,  5417,  5419,  5421,  5423,  5425,  5427,  5429,  5431,
    5433,  5435,  5437,  5439,  5441,  5443,  5445,  5447,  5449,  5451,
    5453,  5455,  5457,  5459,  5461,  5463,  5465,  5467,  5469,  5471,
    5473,  5475,  5477,  5479,  5481,  5483,  5485,  5487,  5489,  5491,
    5493,  5495,  5497,  5499,  5501,  5503,  5505,  5507,  5509,  5511,
    5513,  5515,  5517,  5519,  5521,  5523,  5525,  5527,  5529,  5531,
    5533,  5535,  5537,  5539,  5541,  5543,  5545,  5547,  5549,  5551,
    5553,  5555,  5557,  5559,  5561,  5563,  5565,  5567,  5569,  5571,
    5573,  5575,  5577,  5579,  5581,  5583,  5585,  5587,  5589,  5591,
    5593,  5595,  5597,  5599,  5601,  5603,  5605,  5607,  5609,  5611,
    5613,  5615,  5617,  5619,  5621,  5623,  5625,  5627,  5629,  5631,
    5633,  5635,  5637,  5639,  5641,  5643,  5645,  5647,  5649,  5651,
    5653,  5655,  5657,  5659,  5661,  5663,  5665,  5667,  5669,  5671,
    5673,  5675,  5677,  5679,  5681,  5683,  5685,  5687,  5689,  5691,
    5693,  5695,  5697,  5699,  5701,  5703,  5705,  5707,  5709,  5711,
    5713,  5715,  5717,  5719,  5721,  5723,  5725,  5727,  5729,  5731,
    5733,  5735,  5737,  5739,  5741,  5743,  5745,  5747,  5749,  5751,
    5753,  5755,  5757,  5759,  5761,  5763,  5765,  5767,  5769,  5771,
    5773,  5775,  5777,  5779,  5781,  5783,  5785,  5787,  5789,  5791,
    5793,  5795,  5797,  5799,  5801,  5803,  5805,  5807,  5809,  5811,
    5813,  5815,  5817,  5819,  5821,  5823,  5825,  5827,  5829,  5831,
    5833,  5835,  5837,  5839,  5841,  5843,  5845,  5847,  5849,  5851,
    5853,  5855,  5857,  5859,  5861,  5863,  5865,  5867,  5869,  5871,
    5873,  5875,  5877,  5879,  5881,  5883,  5885,  5887,  5889,  5891,
    5893,  5895,  5897,  5901,  5903,  5904,  5906,  5909,  5911,  5914,
    5916,  5918,  5921,  5924,  5926,  5928,  5930,  5932,  5934,  5936,
    5939,  5943,  5945,  5948,  5950,  5954,  5956,  5960,  5962,  5964,
    5966,  5968,  5970,  5972,  5974,  5976,  5978,  5980,  5982,  5984,
    5986,  5988,  5990,  5992,  5994,  5996,  5998,  6000,  6002,  6004,
    6006,  6008,  6010,  6012,  6014,  6016,  6018,  6020,  6022,  6024,
    6026,  6028,  6030,  6032,  6034,  6036,  6038,  6040,  6042,  6044,
    6046,  6048,  6050,  6052,  6054,  6056,  6058,  6060,  6062,  6064,
    6066,  6068,  6070,  6072,  6074,  6076,  6078,  6080
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     448,     0,    -1,   449,    -1,    -1,   449,   450,    -1,   960,
     451,   452,   441,    -1,   960,   452,   441,    -1,   960,   851,
      -1,   859,    -1,   973,    -1,   418,    -1,   442,    -1,   443,
      -1,    98,   837,    -1,   670,    -1,   671,    -1,   676,    -1,
     628,    -1,   463,    -1,   645,    -1,   646,    -1,   539,    -1,
     487,    -1,   458,    -1,   457,    -1,   459,    -1,   681,    -1,
     486,    -1,   495,    -1,   679,    -1,   590,    -1,   483,    -1,
     496,    -1,   532,    -1,   567,    -1,   637,    -1,   678,    -1,
     675,    -1,   614,    -1,   462,    -1,   543,    -1,   575,    -1,
     453,    -1,   466,    -1,   538,    -1,   505,    -1,   550,    -1,
     553,    -1,   456,    -1,   666,    -1,   701,    -1,   569,    -1,
     694,    -1,   568,    -1,   639,    -1,   465,    -1,   580,    -1,
     548,    -1,   460,    -1,   655,    -1,   581,    -1,   552,    -1,
     566,    -1,   461,    -1,   674,    -1,   687,    -1,   587,    -1,
     593,    -1,   604,    -1,   608,    -1,   690,    -1,   657,    -1,
     665,    -1,   696,    -1,   656,    -1,   640,    -1,   632,    -1,
     634,    -1,   631,    -1,   643,    -1,   594,    -1,   605,    -1,
     647,    -1,   704,    -1,   659,    -1,   586,    -1,   658,    -1,
     700,    -1,   680,    -1,   470,    -1,   481,    -1,   482,    -1,
     664,    -1,   913,    -1,   836,    -1,   849,    -1,   850,    -1,
     914,    -1,   891,    -1,   911,    -1,   892,    -1,   895,    -1,
     900,    -1,   922,    -1,   915,    -1,   901,    -1,   910,    -1,
     929,    -1,   931,    -1,   925,    -1,   918,    -1,   932,    -1,
     935,    -1,   937,    -1,   136,   330,   834,   454,   455,    -1,
     406,    -1,    -1,   301,   824,    -1,   174,   301,   824,    -1,
     386,   301,   824,    -1,   362,    -1,   274,    -1,   216,    -1,
     271,    -1,   137,    -1,   268,    -1,   138,    -1,   269,    -1,
     253,    -1,   272,    -1,   130,   245,   826,    -1,   396,   391,
     824,    -1,   393,   811,    -1,   364,   825,    -1,    82,   811,
      -1,   330,   811,    -1,   212,   330,   811,    -1,   212,   202,
     811,    -1,   136,   393,   834,   454,   455,    -1,    87,   330,
     834,   454,   455,    -1,    87,   330,   834,   345,   471,    -1,
      87,   330,   834,   482,    -1,    87,   393,   834,   454,   455,
      -1,    87,   393,   834,   345,   471,    -1,    87,   393,   834,
     482,    -1,   169,   330,   811,    -1,   169,   393,   811,    -1,
     136,   202,   834,   454,   455,    -1,    87,   202,   834,   464,
     393,   811,    -1,    81,    -1,   169,    -1,   169,   202,   811,
      -1,   136,   336,   467,    99,   834,   468,    -1,   136,   336,
     945,   468,    -1,   945,    -1,    -1,   468,   469,    -1,    -1,
     505,    -1,   608,    -1,   538,    -1,   553,    -1,   593,    -1,
     664,    -1,   345,   471,    -1,   345,   248,   471,    -1,   345,
     343,   471,    -1,   472,   374,   473,    -1,   472,   444,   473,
      -1,   372,   411,   478,    -1,   377,   662,    -1,   343,   118,
      93,   377,   662,    -1,   261,   479,    -1,   330,   480,    -1,
     343,    99,   480,    -1,   343,    99,   155,    -1,   944,    -1,
     472,   440,   945,    -1,   474,    -1,   155,    -1,   476,    -1,
     474,   445,   476,    -1,   314,   385,    -1,   314,   129,    -1,
     322,   314,    -1,   342,    -1,   477,    -1,   832,    -1,   945,
      -1,   381,    -1,   185,    -1,   289,    -1,   285,    -1,   832,
      -1,   967,    -1,   762,   829,   764,    -1,   762,   438,   825,
     439,   829,   764,    -1,   155,    -1,   248,    -1,   829,    -1,
     155,    -1,    -1,   945,    -1,   829,    -1,   348,   472,    -1,
     348,   372,   411,    -1,   348,   377,   233,   243,    -1,   348,
     343,    99,    -1,   348,    85,    -1,   324,   472,    -1,   324,
     372,   411,    -1,   324,   377,   233,   243,    -1,   324,   343,
      99,    -1,   324,    85,    -1,   345,   132,   484,   485,    -1,
      85,    -1,   811,    -1,   158,    -1,   209,    -1,   120,    -1,
      87,   366,   735,   488,    -1,    87,   215,   735,   490,    -1,
     489,    -1,   488,   445,   489,    -1,    81,   644,   510,    -1,
      87,   644,   945,   492,    -1,    87,   644,   945,   169,   275,
     280,    -1,    87,   644,   945,   345,   275,   280,    -1,    87,
     644,   945,   345,   356,   825,    -1,    87,   644,   945,   345,
     359,   945,    -1,   169,   644,   945,   493,    -1,    87,   644,
     945,   384,   740,   494,    -1,    81,   517,    -1,   169,   131,
     812,   493,    -1,   345,   407,   287,    -1,   136,   375,   366,
      -1,   123,   289,   812,    -1,   345,   407,   123,    -1,   172,
     379,   812,    -1,   172,   379,    85,    -1,   172,   379,   393,
      -1,   164,   379,   812,    -1,   164,   379,    85,    -1,   164,
     379,   393,    -1,   491,    -1,   490,   445,   491,    -1,   299,
     374,   834,    -1,   345,   367,   812,    -1,   345,   155,   765,
      -1,   169,   155,    -1,   112,    -1,   326,    -1,    -1,   394,
     765,    -1,    -1,   122,   812,    -1,   135,   501,   810,   502,
     497,   498,   503,   454,   499,    -1,   374,    -1,   194,    -1,
     829,    -1,   357,    -1,   358,    -1,   499,   500,    -1,    -1,
     105,    -1,   287,    -1,   161,   677,   829,    -1,   280,   677,
     829,    -1,   141,    -1,   205,    -1,   313,   677,   824,    -1,
     176,   677,   824,    -1,   190,   313,   520,    -1,   190,   275,
     280,   520,    -1,   105,    -1,    -1,   406,   287,    -1,    -1,
     504,   162,   829,    -1,    -1,   394,    -1,    -1,   136,   506,
     366,   810,   438,   507,   439,   527,   528,   529,   530,    -1,
     136,   506,   366,   810,   284,   810,   438,   507,   439,   528,
     529,   530,    -1,   370,    -1,   368,    -1,   248,   370,    -1,
     248,   368,    -1,   198,   370,    -1,   198,   368,    -1,    -1,
     508,    -1,    -1,   509,    -1,   508,   445,   509,    -1,   510,
      -1,   515,    -1,   517,    -1,   945,   740,   511,    -1,   511,
     512,    -1,    -1,   131,   812,   513,    -1,   513,    -1,   514,
      -1,   275,   280,    -1,   280,    -1,   388,   531,    -1,   308,
     235,   531,    -1,   119,   438,   765,   439,    -1,   155,   766,
      -1,   317,   810,   519,   522,   523,    -1,   157,    -1,   275,
     157,    -1,   218,   158,    -1,   218,   209,    -1,   244,   810,
     516,    -1,   213,   156,    -1,   179,   156,    -1,    -1,   131,
     812,   518,    -1,   518,    -1,   119,   438,   765,   439,    -1,
     388,   438,   520,   439,   531,    -1,   308,   235,   438,   520,
     439,   531,    -1,   191,   235,   438,   520,   439,   317,   810,
     519,   522,   523,   563,    -1,   438,   520,   439,    -1,    -1,
     520,   445,   521,    -1,   521,    -1,   945,    -1,   254,   195,
      -1,   254,   300,    -1,    -1,   524,    -1,   525,    -1,   524,
     525,    -1,   525,   524,    -1,    -1,   289,   160,   526,    -1,
     289,   392,   526,    -1,   267,    80,    -1,   326,    -1,   112,
      -1,   345,   155,    -1,   345,   280,    -1,   217,   438,   809,
     439,    -1,    -1,   406,   287,    -1,   407,   287,    -1,    -1,
     289,   128,   169,    -1,   289,   128,   160,   333,    -1,   289,
     128,   305,   333,    -1,    -1,   367,   812,    -1,    -1,   394,
     215,   367,   812,    -1,    -1,    -1,   136,   506,   366,   810,
     535,   534,   533,   704,    -1,   406,   287,    93,    -1,   407,
     287,    93,    -1,    93,    -1,   438,   536,   439,    -1,    -1,
     536,   445,   537,    -1,   537,    -1,   945,    -1,   136,   506,
     341,   810,   540,    -1,    87,   341,   810,   540,    -1,   540,
     541,    -1,    -1,   110,   831,    -1,   148,    -1,   267,   148,
      -1,   214,   542,   831,    -1,   255,   831,    -1,   257,   831,
      -1,   267,   255,    -1,   267,   257,    -1,   354,   454,   831,
      -1,   325,   454,   831,    -1,   109,    -1,    -1,   136,   544,
     549,   237,   480,    -1,   136,   544,   549,   237,   480,   203,
     545,   546,   547,    -1,   383,    -1,    -1,   812,    -1,   812,
     585,    -1,   397,   545,    -1,    -1,   236,   829,    -1,    -1,
     169,   549,   237,   829,   493,    -1,   311,    -1,    -1,   136,
     367,   812,   551,   251,   824,    -1,   299,   812,    -1,    -1,
     169,   367,   812,    -1,   136,   379,   812,   554,   555,   289,
     810,   557,   180,   312,   812,   438,   560,   439,    -1,   136,
     131,   379,   812,    83,   555,   289,   810,   562,   563,   189,
     170,   332,   180,   312,   818,   438,   560,   439,    -1,   101,
      -1,    83,    -1,   556,    -1,   556,   293,   556,    -1,   556,
     293,   556,   293,   556,    -1,   223,    -1,   160,    -1,   392,
      -1,   189,   558,   559,    -1,    -1,   170,    -1,    -1,   332,
      -1,   355,    -1,   561,    -1,   560,   445,   561,    -1,    -1,
     833,    -1,   945,    -1,    -1,   194,   810,    -1,   564,    -1,
     564,   565,    -1,   565,    -1,   565,   564,    -1,    -1,   275,
     157,    -1,   157,    -1,   218,   209,    -1,   218,   158,    -1,
     169,   379,   812,   289,   810,   493,    -1,   136,    95,   812,
     119,   438,   765,   439,   563,    -1,   169,    95,   812,    -1,
     136,    84,   818,   571,    -1,   136,   291,   771,   571,    -1,
     136,   384,   584,   571,    -1,   136,   384,   584,    93,   570,
      -1,   438,   738,   439,    -1,   438,   572,   439,    -1,   573,
      -1,   572,   445,   573,    -1,   948,   425,   574,    -1,   948,
      -1,   623,    -1,   774,    -1,   832,    -1,   136,   291,   121,
     584,   578,   189,   384,   740,   394,   814,    93,   576,    -1,
     577,    -1,   576,   445,   577,    -1,   291,   825,   636,   579,
      -1,   291,   825,   636,   438,   635,   439,   579,    -1,   196,
     825,   818,   616,    -1,   359,   740,    -1,   155,    -1,    -1,
     316,    -1,    -1,   169,   291,   121,   584,   394,   814,   493,
      -1,   169,   582,   583,   493,    -1,   366,    -1,   341,    -1,
     402,    -1,   215,    -1,   384,    -1,   167,    -1,   133,    -1,
     336,    -1,   584,    -1,   583,   445,   584,    -1,   945,    -1,
     945,   585,    -1,   440,   815,    -1,   585,   440,   815,    -1,
     382,   711,   809,    -1,   186,   588,   589,   812,   907,    -1,
     186,   588,   812,   907,    -1,   186,   589,   812,   907,    -1,
     186,   812,   907,    -1,   186,   588,   589,   812,    -1,   186,
     588,   812,    -1,   186,   589,   812,    -1,   186,   812,    -1,
     260,   588,   589,   812,    -1,   260,   812,    -1,   266,    -1,
     309,    -1,   187,    -1,   239,    -1,    78,   826,    -1,   319,
     826,    -1,   826,    -1,    85,    -1,   192,    -1,   192,   826,
      -1,   192,    85,    -1,   100,    -1,   100,   826,    -1,   100,
      85,    -1,   212,    -1,   194,    -1,   127,   289,   591,   812,
     231,   592,    -1,   127,   289,    84,   818,   438,   633,   439,
     231,   592,    -1,   127,   289,   196,   818,   616,   231,   592,
      -1,   127,   289,   291,   771,   438,   635,   439,   231,   592,
      -1,   127,   289,   379,   812,   289,   584,   231,   592,    -1,
     127,   289,   334,   812,   289,   584,   231,   592,    -1,   127,
     289,   334,   812,   231,   592,    -1,   127,   289,   291,   121,
     584,   394,   814,   231,   592,    -1,   127,   289,   238,   283,
     831,   231,   592,    -1,   127,   289,   114,   438,   740,    93,
     740,   439,   231,   592,    -1,   127,   289,   549,   237,   584,
     231,   592,    -1,   126,    -1,   149,    -1,   336,    -1,   215,
      -1,   341,    -1,   366,    -1,   167,    -1,   384,    -1,   402,
      -1,   133,    -1,   829,    -1,   280,    -1,   199,   595,   289,
     598,   374,   599,   601,    -1,   328,   595,   289,   598,   194,
     599,   493,    -1,   328,   199,   292,   189,   595,   289,   598,
     194,   599,   493,    -1,    85,   310,    -1,    85,    -1,   596,
      -1,   597,    -1,   596,   445,   597,    -1,   340,    -1,   317,
      -1,   136,    -1,   945,    -1,   809,    -1,   366,   809,    -1,
     196,   602,    -1,   149,   811,    -1,   237,   811,    -1,   336,
     811,    -1,   367,   811,    -1,   600,    -1,   599,   445,   600,
      -1,   834,    -1,   202,   834,    -1,   406,   199,   292,    -1,
      -1,   603,    -1,   602,   445,   603,    -1,   818,   616,    -1,
     199,   596,   374,   811,   606,   607,    -1,   328,   596,   194,
     811,   607,   493,    -1,   406,    82,   292,    -1,    -1,   200,
     109,   834,    -1,    -1,   136,   609,   215,   816,   289,   810,
     610,   438,   611,   439,   530,   737,    -1,   388,    -1,    -1,
     394,   814,    -1,    -1,   612,    -1,   611,   445,   612,    -1,
     945,   613,    -1,   768,   613,    -1,   438,   765,   439,   613,
      -1,   584,    -1,   394,   584,    -1,    -1,   136,   615,   196,
     818,   616,   327,   622,   624,   627,    -1,   136,   615,   196,
     818,   616,   624,   627,    -1,   293,   323,    -1,    -1,   438,
     617,   439,    -1,   438,   439,    -1,   618,    -1,   617,   445,
     618,    -1,   619,   621,   623,    -1,   621,   619,   623,    -1,
     621,   623,    -1,   619,   623,    -1,   623,    -1,   212,    -1,
     295,    -1,   220,    -1,   212,   295,    -1,   829,    -1,   829,
     445,   829,    -1,   947,    -1,   623,    -1,   740,    -1,   946,
     585,   433,   384,    -1,   626,    -1,   624,   626,    -1,   111,
     289,   280,   221,    -1,   327,   280,   289,   280,   221,    -1,
     360,    -1,   210,    -1,   353,    -1,   403,    -1,   183,   339,
     159,    -1,   183,   339,   230,    -1,   339,   159,    -1,   339,
     230,    -1,    93,   620,    -1,   237,   480,    -1,   625,    -1,
     406,   571,    -1,    -1,    87,   196,   603,   629,   630,    -1,
     625,    -1,   629,   625,    -1,   326,    -1,    -1,   169,   196,
     818,   616,   493,    -1,   169,    84,   818,   438,   633,   439,
     493,    -1,   740,    -1,   431,    -1,   169,   291,   771,   438,
     635,   439,   493,    -1,   740,    -1,   740,   445,   740,    -1,
     273,   445,   740,    -1,   740,   445,   273,    -1,   771,    -1,
     945,   440,   636,    -1,   136,   114,   438,   740,    93,   740,
     439,   406,   196,   603,   638,    -1,   136,   114,   438,   740,
      93,   740,   439,   407,   196,   638,    -1,    93,    96,    -1,
      -1,   169,   114,   438,   740,    93,   740,   439,   493,    -1,
     318,   641,   810,   642,    -1,   318,   365,   812,   642,    -1,
     318,   149,   812,   642,    -1,   215,    -1,   366,    -1,   190,
      -1,    -1,    87,    84,   818,   438,   633,   439,   321,   374,
     812,    -1,    87,   133,   584,   321,   374,   812,    -1,    87,
     149,   813,   321,   374,   813,    -1,    87,   196,   818,   616,
     321,   374,   812,    -1,    87,   202,   834,   321,   374,   834,
      -1,    87,   237,   812,   321,   374,   812,    -1,    87,   291,
     121,   584,   394,   814,   321,   374,   812,    -1,    87,   336,
     812,   321,   374,   812,    -1,    87,   366,   735,   321,   374,
     812,    -1,    87,   215,   735,   321,   374,   812,    -1,    87,
     366,   735,   321,   644,   812,   374,   812,    -1,    87,   379,
     812,   289,   735,   321,   374,   812,    -1,    87,   393,   834,
     321,   374,   834,    -1,    87,   367,   812,   321,   374,   812,
      -1,   126,    -1,    -1,    87,    84,   818,   438,   633,   439,
     345,   336,   812,    -1,    87,   167,   584,   345,   336,   812,
      -1,    87,   196,   818,   616,   345,   336,   812,    -1,    87,
     341,   735,   345,   336,   812,    -1,    87,   366,   735,   345,
     336,   812,    -1,    87,   384,   584,   345,   336,   812,    -1,
      87,    84,   818,   438,   633,   439,   299,   374,   834,    -1,
      87,   133,   584,   299,   374,   834,    -1,    87,   149,   813,
     299,   374,   834,    -1,    87,   167,   813,   299,   374,   834,
      -1,    87,   196,   818,   616,   299,   374,   834,    -1,    87,
     291,   636,   438,   635,   439,   299,   374,   834,    -1,    87,
     291,   121,   584,   394,   814,   299,   374,   834,    -1,    87,
     336,   812,   299,   374,   834,    -1,    87,   384,   584,   299,
     374,   834,    -1,    87,   367,   812,   299,   374,   834,    -1,
      -1,   136,   615,   334,   812,    93,   648,   289,   653,   374,
     810,   737,   166,   654,   649,    -1,   276,    -1,   651,    -1,
     438,   650,   439,    -1,   650,   441,   652,    -1,   652,    -1,
     704,    -1,   690,    -1,   700,    -1,   694,    -1,   656,    -1,
     651,    -1,    -1,   340,    -1,   392,    -1,   160,    -1,   223,
      -1,   224,    -1,    86,    -1,    -1,   169,   334,   812,   289,
     810,   493,    -1,   277,   810,    -1,   246,   810,    -1,   390,
     810,    -1,   390,   431,    -1,    77,   660,    -1,   102,   660,
     663,    -1,   354,   377,   663,    -1,   128,   660,    -1,   175,
     660,    -1,   331,   660,    -1,   335,   945,    -1,   320,   335,
     945,    -1,   320,   945,    -1,   331,   660,   374,   335,   945,
      -1,   331,   660,   374,   945,    -1,   306,   377,   829,    -1,
     128,   307,   829,    -1,   331,   307,   829,    -1,   408,    -1,
     377,    -1,    -1,   233,   243,   475,    -1,   314,   290,    -1,
     314,   409,    -1,   661,    -1,   662,   445,   661,    -1,   662,
     661,    -1,   662,    -1,    -1,   136,   506,   402,   810,   519,
      93,   704,    -1,   136,   293,   323,   506,   402,   810,   519,
      93,   704,    -1,   247,   817,    -1,   136,   149,   813,   406,
     667,    -1,   136,   149,   813,    -1,   668,    -1,   667,   668,
      -1,   367,   669,   812,    -1,   367,   669,   155,    -1,   251,
     669,   829,    -1,   251,   669,   155,    -1,   369,   669,   812,
      -1,   369,   669,   155,    -1,   173,   669,   830,    -1,   173,
     669,   155,    -1,   130,   245,   669,   825,    -1,   299,   669,
     812,    -1,   299,   669,   155,    -1,   425,    -1,    -1,    87,
     149,   813,   454,   672,    -1,    87,   149,   813,   345,   471,
      -1,    87,   149,   813,   482,    -1,   672,   673,    -1,    -1,
     130,   245,   669,   825,    -1,   169,   149,   813,    -1,   136,
     167,   584,   677,   740,   511,    -1,    87,   167,   584,   492,
      -1,    87,   167,   584,   169,   275,   280,    -1,    87,   167,
     584,   345,   275,   280,    -1,    87,   167,   584,    81,   517,
      -1,    87,   167,   584,   169,   131,   812,   493,    -1,    93,
      -1,    -1,   136,   578,   133,   584,   189,   829,   374,   829,
     194,   584,    -1,   123,   816,   289,   810,    -1,   123,   810,
      -1,   123,    -1,   395,   684,   685,   683,    -1,   395,   684,
     685,   683,   810,    -1,   395,   684,   685,   683,   681,    -1,
     682,   683,    -1,   682,   683,   810,   686,    -1,    89,    -1,
      88,    -1,   401,    -1,    -1,   195,    -1,    -1,   193,    -1,
      -1,   438,   811,   439,    -1,    -1,   182,   689,   683,   688,
      -1,   704,    -1,   690,    -1,   700,    -1,   694,    -1,   701,
      -1,   682,    -1,    -1,   223,   229,   810,   691,    -1,   398,
     438,   806,   439,    -1,   155,   398,    -1,   704,    -1,   438,
     692,   439,   398,   438,   806,   439,    -1,   438,   692,   439,
     704,    -1,   692,   445,   693,    -1,   693,    -1,   945,   798,
      -1,   160,   194,   735,   695,   737,    -1,   394,   728,    -1,
      -1,   252,   711,   809,   697,   699,    -1,   212,   698,   258,
      -1,    -1,    79,   347,    -1,   332,   347,    -1,   332,   178,
      -1,   347,   392,   178,    -1,   347,    -1,   347,   332,   178,
      -1,   178,    -1,    79,   178,    -1,   279,    -1,    -1,   392,
     735,   345,   802,   727,   737,    -1,   154,   812,   702,   147,
     703,   189,   704,    -1,    -1,   702,   105,    -1,   702,   222,
      -1,   702,   337,    -1,   702,   267,   337,    -1,    -1,   406,
     206,    -1,   407,   206,    -1,   706,    -1,   705,    -1,   438,
     706,   439,    -1,   438,   705,   439,    -1,   708,    -1,   707,
     715,    -1,   707,   714,   724,   719,    -1,   707,   714,   718,
     725,    -1,   708,    -1,   705,    -1,   340,   713,   800,   709,
     727,   737,   722,   723,    -1,   707,   387,   712,   707,    -1,
     707,   227,   712,   707,    -1,   707,   177,   712,   707,    -1,
     229,   710,    -1,   907,    -1,    -1,   370,   711,   810,    -1,
     368,   711,   810,    -1,   248,   370,   711,   810,    -1,   248,
     368,   711,   810,    -1,   198,   370,   711,   810,    -1,   198,
     368,   711,   810,    -1,   366,   810,    -1,   810,    -1,   366,
      -1,    -1,    85,    -1,    -1,   165,    -1,   165,   289,   438,
     776,   439,    -1,    85,    -1,    -1,   715,    -1,    -1,   294,
     109,   716,    -1,   717,    -1,   716,   445,   717,    -1,   765,
     394,   774,    -1,   765,    94,    -1,   765,   163,    -1,   765,
      -1,   245,   720,   286,   721,    -1,   286,   721,   245,   720,
      -1,   245,   720,    -1,   286,   721,    -1,   245,   720,   445,
     721,    -1,   718,    -1,    -1,   765,    -1,    85,    -1,   765,
      -1,   202,   109,   776,    -1,    -1,   204,   765,    -1,    -1,
     189,   392,   726,   699,    -1,   189,   347,   726,   699,    -1,
     189,   314,   290,    -1,   724,    -1,    -1,   284,   811,    -1,
      -1,   194,   728,    -1,    -1,   728,   445,   729,    -1,   729,
      -1,   735,    -1,   735,   731,    -1,   736,    -1,   736,   731,
      -1,   736,    93,   438,   738,   439,    -1,   736,    93,   945,
     438,   738,   439,    -1,   736,   945,   438,   738,   439,    -1,
     705,    -1,   705,   731,    -1,   730,    -1,   438,   730,   439,
     731,    -1,   438,   730,   439,    -1,   729,   140,   234,   729,
      -1,   729,   412,   729,    -1,   729,   732,   234,   729,   734,
      -1,   729,   234,   729,   734,    -1,   729,   263,   732,   234,
     729,    -1,   729,   263,   234,   729,    -1,    93,   945,   438,
     811,   439,    -1,    93,   945,    -1,   945,   438,   811,   439,
      -1,   945,    -1,   195,   733,    -1,   242,   733,    -1,   329,
     733,    -1,   219,    -1,   296,    -1,    -1,   394,   438,   811,
     439,    -1,   289,   765,    -1,   810,    -1,   810,   431,    -1,
     290,   810,    -1,   290,   438,   810,   439,    -1,   768,    -1,
     405,   765,    -1,    -1,   739,    -1,   738,   445,   739,    -1,
     945,   740,    -1,   743,   741,    -1,   346,   743,   741,    -1,
     743,    92,   436,   825,   437,    -1,   346,   743,    92,   436,
     825,   437,    -1,   436,   437,   741,    -1,   436,   742,   437,
     741,    -1,    -1,   825,    -1,   438,   742,   439,    -1,   742,
     429,   742,    -1,   742,   430,   742,    -1,   742,   431,   742,
      -1,   742,   432,   742,    -1,   742,   433,   742,    -1,   824,
      -1,   945,    -1,   745,    -1,   761,    -1,   746,    -1,   750,
      -1,   754,    -1,   762,   764,    -1,   762,   438,   825,   439,
     764,    -1,   946,   585,    -1,   745,    -1,   761,    -1,   746,
      -1,   751,    -1,   755,    -1,   946,    -1,   225,    -1,   226,
      -1,   351,    -1,   104,    -1,   315,    -1,   188,   747,    -1,
     168,   304,    -1,   153,   749,    -1,   152,   749,    -1,   282,
     748,    -1,   107,    -1,   438,   825,   439,    -1,    -1,   438,
     825,   445,   825,   439,    -1,   438,   825,   439,    -1,    -1,
     438,   825,   445,   825,   439,    -1,   438,   825,   439,    -1,
      -1,   752,    -1,   753,    -1,   752,    -1,   753,    -1,   106,
     759,   438,   825,   439,    -1,   106,   759,    -1,   756,    -1,
     757,    -1,   756,    -1,   757,    -1,   758,   438,   825,   439,
     760,    -1,   758,   760,    -1,   117,   759,    -1,   116,   759,
      -1,   399,    -1,   262,   117,   759,    -1,   262,   116,   759,
      -1,   264,   759,    -1,   400,    -1,    -1,   117,   345,   945,
      -1,    -1,   373,   438,   825,   439,   763,    -1,   373,   763,
      -1,   372,   438,   825,   439,   763,    -1,   372,   763,    -1,
     228,    -1,   406,   372,   411,    -1,   407,   372,   411,    -1,
      -1,   410,    -1,   259,    -1,   150,    -1,   207,    -1,   256,
      -1,   338,    -1,   410,   374,   259,    -1,   150,   374,   207,
      -1,   150,   374,   256,    -1,   150,   374,   338,    -1,   207,
     374,   256,    -1,   256,   374,   338,    -1,   207,   374,   338,
      -1,    -1,   767,    -1,   765,    76,   740,    -1,   765,    98,
     372,   411,   765,    -1,   429,   765,    -1,   430,   765,    -1,
     765,   429,   765,    -1,   765,   430,   765,    -1,   765,   431,
     765,    -1,   765,   432,   765,    -1,   765,   433,   765,    -1,
     765,   434,   765,    -1,   765,   426,   765,    -1,   765,   427,
     765,    -1,   765,   425,   765,    -1,   765,   773,   765,    -1,
     773,   765,    -1,   765,   773,    -1,   765,    90,   765,    -1,
     765,   293,   765,    -1,   275,   765,    -1,   765,   244,   765,
      -1,   765,   244,   765,   176,   765,    -1,   765,   275,   244,
     765,    -1,   765,   275,   244,   765,   176,   765,    -1,   765,
     208,   765,    -1,   765,   208,   765,   176,   765,    -1,   765,
     275,   208,   765,    -1,   765,   275,   208,   765,   176,   765,
      -1,   765,   349,   374,   765,    -1,   765,   349,   374,   765,
     176,   765,    -1,   765,   275,   349,   374,   765,    -1,   765,
     275,   349,   374,   765,   176,   765,    -1,   765,   232,    -1,
     765,   231,   280,    -1,   765,   278,    -1,   765,   231,   275,
     280,    -1,   765,   231,   381,    -1,   765,   231,   275,   381,
      -1,   765,   231,   185,    -1,   765,   231,   275,   185,    -1,
     765,   231,   389,    -1,   765,   231,   275,   389,    -1,   765,
     231,   165,   194,   765,    -1,   765,   231,   284,   438,   778,
     439,    -1,   765,   231,   275,   284,   438,   778,   439,    -1,
     765,   103,   799,   766,    90,   766,    -1,   765,   275,   103,
     799,   766,    90,   766,    -1,   765,   103,   363,   766,    90,
     766,    -1,   765,   275,   103,   363,   766,    90,   766,    -1,
     765,   212,   789,    -1,   765,   275,   212,   789,    -1,   765,
     775,   770,   705,    -1,   765,   775,   770,   438,   765,   439,
      -1,   388,   705,    -1,   767,    -1,   766,    76,   740,    -1,
     430,   766,    -1,   766,   429,   766,    -1,   766,   430,   766,
      -1,   766,   431,   766,    -1,   766,   432,   766,    -1,   766,
     433,   766,    -1,   766,   434,   766,    -1,   766,   426,   766,
      -1,   766,   427,   766,    -1,   766,   425,   766,    -1,   766,
     415,   766,    -1,   773,   766,    -1,   766,   773,    -1,   766,
     231,   165,   194,   766,    -1,   766,   231,   284,   438,   766,
     439,    -1,   766,   231,   275,   284,   438,   766,   439,    -1,
     795,    -1,   819,    -1,   423,   798,    -1,   438,   765,   439,
     798,    -1,   790,    -1,   768,    -1,   705,    -1,   181,   705,
      -1,    92,   705,    -1,    92,   780,    -1,   769,    -1,   818,
     438,   439,    -1,   818,   438,   776,   439,    -1,   818,   438,
      85,   776,   439,    -1,   818,   438,   165,   776,   439,    -1,
     818,   438,   431,   439,    -1,   142,    -1,   144,    -1,   144,
     438,   825,   439,    -1,   145,    -1,   145,   438,   825,   439,
      -1,   249,    -1,   249,   438,   825,   439,    -1,   250,    -1,
     250,   438,   825,   439,    -1,   143,    -1,   146,    -1,   344,
      -1,   393,    -1,   114,   438,   765,    93,   740,   439,    -1,
     184,   438,   777,   439,    -1,   298,   438,   782,   439,    -1,
     303,   438,   784,   439,    -1,   361,   438,   785,   439,    -1,
     378,   438,   765,    93,   740,   439,    -1,   380,   438,   108,
     788,   439,    -1,   380,   438,   240,   788,   439,    -1,   380,
     438,   376,   788,   439,    -1,   380,   438,   788,   439,    -1,
     134,   438,   765,   394,   584,   439,    -1,   134,   438,   776,
     439,    -1,   281,   438,   765,   445,   765,   439,    -1,   124,
     438,   776,   439,    -1,   201,   438,   776,   439,    -1,   241,
     438,   776,   439,    -1,   332,   438,   776,   439,    -1,   332,
     438,   439,    -1,   438,   776,   445,   765,   439,    -1,    91,
      -1,   352,    -1,    85,    -1,   415,    -1,   772,    -1,   429,
      -1,   430,    -1,   431,    -1,   433,    -1,   434,    -1,   432,
      -1,   426,    -1,   427,    -1,   425,    -1,   415,    -1,   291,
     438,   636,   439,    -1,   771,    -1,   291,   438,   636,   439,
      -1,   771,    -1,   291,   438,   636,   439,    -1,   244,    -1,
     275,   244,    -1,   208,    -1,   275,   208,    -1,   765,    -1,
     776,   445,   765,    -1,   781,   194,   765,    -1,    -1,   778,
     445,   740,    -1,   740,    -1,   780,    -1,   779,   445,   780,
      -1,   436,   776,   437,    -1,   436,   779,   437,    -1,   967,
      -1,   410,    -1,   259,    -1,   150,    -1,   207,    -1,   256,
      -1,   338,    -1,   829,    -1,   765,   783,   786,   787,    -1,
     765,   783,   786,    -1,   302,   765,    -1,   766,   212,   766,
      -1,    -1,   765,   786,   787,    -1,   765,   787,   786,    -1,
     765,   786,    -1,   765,   787,    -1,   776,    -1,    -1,   194,
     765,    -1,   189,   765,    -1,   765,   194,   776,    -1,   194,
     776,    -1,   776,    -1,   705,    -1,   438,   776,   439,    -1,
     113,   794,   791,   793,   175,    -1,   791,   792,    -1,   792,
      -1,   404,   765,   371,   765,    -1,   171,   765,    -1,    -1,
     765,    -1,    -1,   808,    -1,   808,   797,    -1,   440,   815,
      -1,   440,   431,    -1,   436,   765,   437,    -1,   436,   765,
     446,   765,   437,    -1,   796,    -1,   797,   796,    -1,    -1,
     798,   796,    -1,    97,    -1,    -1,   800,   445,   801,    -1,
     801,    -1,   765,    93,   948,    -1,   765,    -1,   431,    -1,
     802,   445,   805,    -1,   438,   803,   439,   425,   438,   804,
     439,    -1,   805,    -1,   945,   798,    -1,   945,   798,   445,
     803,    -1,   765,    -1,   765,   445,   804,    -1,   945,   798,
     425,   765,    -1,   945,   798,   425,   155,    -1,   806,   445,
     807,    -1,   807,    -1,   765,    -1,   155,    -1,   835,    -1,
     945,    -1,   810,    -1,   809,   445,   810,    -1,   808,    -1,
     808,   797,    -1,   812,    -1,   811,   445,   812,    -1,   945,
      -1,   945,    -1,   945,    -1,   948,    -1,   945,    -1,   829,
      -1,   947,    -1,   808,   797,    -1,   833,    -1,   744,   829,
      -1,   762,   829,   764,    -1,   762,   438,   825,   439,   829,
     764,    -1,   381,    -1,   185,    -1,   280,    -1,   963,    -1,
     422,    -1,   424,    -1,   420,    -1,   421,    -1,   414,    -1,
     820,    -1,   964,    -1,   825,    -1,   430,   825,    -1,   820,
      -1,   966,    -1,   821,    -1,   827,    -1,   430,   821,    -1,
     430,   820,    -1,   824,    -1,   824,    -1,   964,    -1,   820,
      -1,   824,    -1,   964,    -1,   821,    -1,   820,    -1,   430,
     821,    -1,   430,   820,    -1,   964,    -1,   824,    -1,   831,
      -1,   824,    -1,   821,    -1,   820,    -1,   822,    -1,   823,
      -1,   964,    -1,   945,    -1,   288,    -1,   265,    -1,     9,
     374,   837,   843,   844,    -1,     9,   374,   155,    -1,     9,
     845,    -1,   149,   837,    -1,   813,   840,   842,    -1,   838,
     446,   839,   842,   432,   813,   848,    -1,   847,    -1,   967,
     966,    -1,   415,   841,    -1,   839,    -1,    -1,   945,    -1,
     945,   440,   841,    -1,   419,    -1,   446,   825,    -1,    -1,
      93,   837,    -1,    -1,   393,   845,    -1,    -1,   846,    -1,
     846,   432,   846,    -1,   846,    24,   109,   846,    -1,   846,
     394,   846,    -1,   834,    -1,   829,    -1,   966,    -1,   415,
     945,    -1,    -1,   154,   812,   702,   147,   703,   189,   899,
      -1,   151,   306,   899,    -1,   151,   899,    -1,   852,    -1,
     866,    -1,   853,    -1,    -1,   871,   874,   854,   887,   441,
      -1,    -1,   874,   855,   887,   441,    -1,   877,   441,    -1,
     831,    -1,   445,   831,    -1,    -1,   764,    -1,   410,   374,
     256,    -1,   410,   374,   338,    -1,   150,   374,   150,    -1,
     259,   374,   259,    -1,    -1,   861,   860,   863,   862,    -1,
     960,   102,   154,    38,   441,    -1,   960,   175,   154,    38,
     441,    -1,    -1,   864,    -1,   418,    -1,   868,    -1,   866,
      -1,   864,   868,    -1,   864,   866,    -1,   864,   418,    -1,
     868,    -1,   865,   868,    -1,    -1,    75,   867,   874,   890,
     949,   741,   441,    -1,    -1,   871,   874,   869,   887,   441,
      -1,    -1,   874,   870,   887,   441,    -1,   877,   441,    -1,
     872,   873,    -1,   872,    -1,   873,    -1,    61,    -1,    72,
      -1,    70,    -1,    55,    -1,    56,    -1,    74,    -1,   883,
      -1,   879,    -1,   875,    -1,   949,   438,   856,   857,   439,
      -1,   949,   858,    -1,   881,    -1,    19,   943,   876,    -1,
      19,   876,    -1,    19,   943,    -1,   442,   971,   443,    -1,
      -1,   881,   878,   442,   865,   443,    -1,   877,    -1,    -1,
     882,   880,   442,   865,   443,    -1,    47,   943,    -1,   387,
     943,    -1,    47,    -1,   387,    -1,   884,    -1,   886,   885,
      -1,    48,    39,    -1,    48,    39,   225,    -1,    48,    -1,
      48,   225,    -1,    48,    28,    -1,    48,    28,   225,    -1,
      48,    28,    28,    -1,    48,    28,    28,   225,    -1,    48,
     116,    -1,    39,    -1,    39,   225,    -1,   225,    -1,    28,
      -1,    28,   225,    -1,    28,    28,    -1,    28,    28,   225,
      -1,     5,    -1,   116,    -1,   168,    -1,    40,    -1,    -1,
     888,    -1,   887,   445,   888,    -1,   890,   950,   741,   889,
      -1,    -1,   425,   972,    -1,    -1,   431,    -1,   431,   431,
      -1,   154,   355,   967,    -1,    18,   893,    -1,   894,    -1,
      12,    -1,    85,    -1,    -1,   837,    -1,   155,    -1,   180,
     209,   898,    -1,    -1,   180,   899,   896,   897,    -1,   903,
     907,    -1,   907,   903,    -1,   903,    -1,   907,    -1,    -1,
     847,    -1,   416,    -1,   812,    -1,   847,    -1,    21,   812,
      -1,    32,   812,   902,    -1,    -1,   903,    -1,   394,   908,
      -1,   904,    -1,   394,   906,    17,   968,    -1,   229,   906,
      17,   968,    -1,    -1,    41,    -1,   229,   959,    -1,   905,
      -1,   909,    -1,   909,   445,   908,    -1,   832,    -1,   963,
      -1,   306,   899,   194,   898,    -1,    16,   221,   812,   904,
      -1,    16,   912,   812,   904,    -1,    16,   912,   812,   905,
      -1,    33,    -1,    -1,     3,    17,   968,    -1,   151,    17,
     968,    -1,   197,    17,   968,   916,    -1,   917,    -1,   916,
     445,   917,    -1,   966,   425,   921,    -1,   345,    17,   968,
     919,    -1,   920,    -1,   919,   445,   920,    -1,   921,   425,
     827,    -1,    11,    -1,   197,    17,   968,    49,   827,   923,
      -1,   924,    -1,   923,   445,   924,    -1,   966,   425,   928,
      -1,   345,    17,   968,    49,   827,   926,    -1,   927,    -1,
     926,   445,   927,    -1,   928,   425,   828,    -1,     8,    -1,
      13,    -1,    14,    -1,    15,    -1,    25,    -1,    26,    -1,
      27,    -1,    29,    -1,    30,    -1,    31,    -1,   304,    -1,
      35,    -1,    36,    -1,    37,    -1,   384,    -1,   345,     4,
     425,   930,    -1,   345,     4,   374,   930,    -1,   289,    -1,
     285,    -1,   345,   130,   374,   894,    -1,   345,   130,   425,
     894,    -1,   345,   130,   894,    -1,    -1,   384,   933,   949,
     231,   874,   741,   934,    -1,    34,    -1,    -1,    -1,    50,
     936,   948,   231,   874,   741,   934,    -1,    51,    42,   938,
      -1,    51,   275,    20,   938,    -1,    51,    44,   938,    -1,
      10,    -1,    43,    -1,    46,    -1,    23,   812,    -1,    22,
     374,   812,    -1,   166,   812,   438,   961,   439,    -1,   166,
       6,    -1,     7,   812,   438,   961,   439,    -1,     7,   812,
      -1,   940,    -1,   941,    -1,     6,    -1,     7,    -1,     8,
      -1,    10,    -1,    11,    -1,    13,    -1,    14,    -1,    15,
      -1,    20,    -1,    22,    -1,    23,    -1,    24,    -1,    25,
      -1,    26,    -1,    27,    -1,    29,    -1,    30,    -1,    31,
      -1,    35,    -1,    36,    -1,    37,    -1,    38,    -1,    41,
      -1,    42,    -1,    43,    -1,    44,    -1,    46,    -1,    49,
      -1,     9,    -1,    16,    -1,    18,    -1,    32,    -1,    50,
      -1,    51,    -1,     5,    -1,    28,    -1,    33,    -1,    39,
      -1,    47,    -1,    40,    -1,    48,    -1,   948,    -1,   967,
      -1,   953,    -1,   955,    -1,   956,    -1,   939,    -1,   951,
      -1,   116,    -1,   967,    -1,   952,    -1,   956,    -1,   939,
      -1,   951,    -1,   116,    -1,   967,    -1,   952,    -1,   939,
      -1,   942,    -1,   951,    -1,   967,    -1,   952,    -1,   957,
      -1,   939,    -1,   951,    -1,   950,    -1,   942,    -1,   116,
      -1,   221,    -1,   225,    -1,   387,    -1,   374,    -1,   951,
      -1,   953,    -1,   967,    -1,   956,    -1,   957,    -1,   940,
      -1,   949,    -1,   958,    -1,   954,    -1,   941,    -1,    55,
      -1,    56,    -1,    61,    -1,    70,    -1,    72,    -1,    75,
      -1,    74,    -1,   953,    -1,   954,    -1,   150,    -1,   207,
      -1,   256,    -1,   259,    -1,   338,    -1,   410,    -1,   955,
      -1,   130,    -1,    77,    -1,    78,    -1,    79,    -1,    80,
      -1,    81,    -1,    82,    -1,    83,    -1,    84,    -1,    86,
      -1,    87,    -1,    95,    -1,    96,    -1,    98,    -1,   100,
      -1,   101,    -1,   102,    -1,   109,    -1,   110,    -1,   112,
      -1,   115,    -1,   118,    -1,   120,    -1,   121,    -1,   122,
      -1,   123,    -1,   127,    -1,   128,    -1,   129,    -1,   132,
      -1,   133,    -1,   135,    -1,   137,    -1,   138,    -1,   139,
      -1,   141,    -1,   147,    -1,   148,    -1,   149,    -1,   151,
      -1,   154,    -1,   156,    -1,   158,    -1,   160,    -1,   161,
      -1,   162,    -1,   164,    -1,   167,    -1,   168,    -1,   169,
      -1,   170,    -1,   172,    -1,   173,    -1,   174,    -1,   176,
      -1,   179,    -1,   178,    -1,   180,    -1,   182,    -1,   186,
      -1,   187,    -1,   190,    -1,   192,    -1,   196,    -1,   198,
      -1,   200,    -1,   203,    -1,   205,    -1,   206,    -1,   209,
      -1,   210,    -1,   211,    -1,   213,    -1,   214,    -1,   215,
      -1,   216,    -1,   217,    -1,   222,    -1,   223,    -1,   224,
      -1,   233,    -1,   235,    -1,   236,    -1,   237,    -1,   238,
      -1,   239,    -1,   243,    -1,   246,    -1,   247,    -1,   248,
      -1,   251,    -1,   252,    -1,   253,    -1,   254,    -1,   255,
      -1,   257,    -1,   258,    -1,   260,    -1,   261,    -1,   266,
      -1,   267,    -1,   268,    -1,   269,    -1,   270,    -1,   271,
      -1,   272,    -1,   274,    -1,   276,    -1,   277,    -1,   279,
      -1,   283,    -1,   284,    -1,   287,    -1,   291,    -1,   292,
      -1,   299,    -1,   300,    -1,   301,    -1,   306,    -1,   307,
      -1,   305,    -1,   309,    -1,   310,    -1,   311,    -1,   312,
      -1,   313,    -1,   314,    -1,   316,    -1,   318,    -1,   319,
      -1,   320,    -1,   321,    -1,   322,    -1,   323,    -1,   324,
      -1,   325,    -1,   326,    -1,   327,    -1,   328,    -1,   330,
      -1,   331,    -1,   333,    -1,   334,    -1,   335,    -1,   336,
      -1,   337,    -1,   341,    -1,   342,    -1,   343,    -1,   345,
      -1,   347,    -1,   348,    -1,   350,    -1,   353,    -1,   354,
      -1,   355,    -1,   356,    -1,   357,    -1,   358,    -1,   359,
      -1,   362,    -1,   360,    -1,   365,    -1,   364,    -1,   367,
      -1,   368,    -1,   369,    -1,   370,    -1,   375,    -1,   377,
      -1,   379,    -1,   382,    -1,   383,    -1,   384,    -1,   385,
      -1,   386,    -1,   389,    -1,   390,    -1,   391,    -1,   392,
      -1,   395,    -1,   396,    -1,   398,    -1,   400,    -1,   402,
      -1,   406,    -1,   407,    -1,   408,    -1,   409,    -1,   411,
      -1,   104,    -1,   106,    -1,   117,    -1,   124,    -1,   134,
      -1,   152,    -1,   153,    -1,   181,    -1,   184,    -1,   188,
      -1,   201,    -1,   220,    -1,   226,    -1,   228,    -1,   241,
      -1,   262,    -1,   264,    -1,   273,    -1,   281,    -1,   282,
      -1,   295,    -1,   298,    -1,   303,    -1,   304,    -1,   315,
      -1,   332,    -1,   346,    -1,   351,    -1,   361,    -1,   372,
      -1,   373,    -1,   378,    -1,   380,    -1,   399,    -1,    99,
      -1,   103,    -1,   105,    -1,   140,    -1,   193,    -1,   195,
      -1,   208,    -1,   219,    -1,   231,    -1,   232,    -1,   234,
      -1,   242,    -1,   244,    -1,   263,    -1,   278,    -1,   296,
      -1,   297,    -1,   329,    -1,   349,    -1,   401,    -1,    85,
      -1,    88,    -1,    89,    -1,    90,    -1,    91,    -1,    92,
      -1,    93,    -1,    94,    -1,    97,    -1,   108,    -1,   113,
      -1,   114,    -1,   119,    -1,   125,    -1,   126,    -1,   131,
      -1,   136,    -1,   142,    -1,   144,    -1,   145,    -1,   143,
      -1,   146,    -1,   155,    -1,   157,    -1,   163,    -1,   165,
      -1,   166,    -1,   171,    -1,   175,    -1,   177,    -1,   185,
      -1,   189,    -1,   191,    -1,   194,    -1,   199,    -1,   202,
      -1,   204,    -1,   212,    -1,   218,    -1,   227,    -1,   229,
      -1,   240,    -1,   245,    -1,   265,    -1,   275,    -1,   280,
      -1,   285,    -1,   286,    -1,   288,    -1,   289,    -1,   290,
      -1,   293,    -1,   294,    -1,   308,    -1,   317,    -1,   340,
      -1,   344,    -1,   352,    -1,   363,    -1,   366,    -1,   371,
      -1,   376,    -1,   381,    -1,   388,    -1,   393,    -1,   394,
      -1,   404,    -1,   405,    -1,   962,    -1,   959,   445,   962,
      -1,    45,    -1,    -1,   971,    -1,   966,   965,    -1,   966,
      -1,   966,   965,    -1,   966,    -1,   966,    -1,    25,   966,
      -1,    25,   812,    -1,   417,    -1,   413,    -1,   416,    -1,
     812,    -1,   847,    -1,   974,    -1,   438,   439,    -1,   438,
     970,   439,    -1,   969,    -1,   970,   969,    -1,   972,    -1,
     971,   445,   972,    -1,   970,    -1,   442,   971,   443,    -1,
     974,    -1,   438,    -1,   439,    -1,   445,    -1,   441,    -1,
     413,    -1,   416,    -1,   820,    -1,   821,    -1,   824,    -1,
     431,    -1,   429,    -1,   430,    -1,   432,    -1,   433,    -1,
     280,    -1,    52,    -1,    53,    -1,    54,    -1,    55,    -1,
      56,    -1,    57,    -1,    58,    -1,    59,    -1,    60,    -1,
      61,    -1,    62,    -1,    63,    -1,    65,    -1,    64,    -1,
      66,    -1,    67,    -1,    68,    -1,    69,    -1,    70,    -1,
      71,    -1,    72,    -1,    73,    -1,    75,    -1,    74,    -1,
       5,    -1,    19,    -1,   207,    -1,   225,    -1,    28,    -1,
     256,    -1,   259,    -1,   338,    -1,    39,    -1,    40,    -1,
      47,    -1,    48,    -1,   410,    -1,   116,    -1,   188,    -1,
     374,    -1,   387,    -1,   399,    -1,   436,    -1,   437,    -1,
     425,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   604,   604,   606,   607,   610,   611,   612,   618,   619,
     620,   621,   622,   625,   637,   638,   639,   640,   641,   642,
     643,   644,   645,   646,   647,   648,   649,   650,   651,   673,
     674,   675,   676,   677,   678,   679,   680,   681,   682,   683,
     684,   685,   686,   687,   688,   689,   690,   691,   692,   693,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   712,   713,   714,   715,
     716,   717,   718,   719,   720,   722,   723,   724,   725,   726,
     727,   728,   729,   730,   731,   737,   738,   739,   740,   741,
     742,   743,   744,   745,   751,   761,   765,   773,   781,   785,
     796,   806,   810,   817,   824,   830,   840,   850,   856,   865,
     872,   878,   887,   894,   915,   919,   920,   929,   930,   931,
     932,   933,   934,   935,   936,   937,   938,   939,   940,   941,
     942,   943,   944,   945,   946,   947,   948,   949,   959,   973,
     977,   979,   989,   992,   994,  1004,  1014,  1024,  1034,  1038,
    1039,  1048,  1059,  1061,  1065,  1066,  1069,  1070,  1077,  1078,
    1079,  1080,  1081,  1082,  1095,  1097,  1099,  1103,  1105,  1107,
    1109,  1111,  1113,  1115,  1117,  1119,  1123,  1124,  1128,  1130,
    1134,  1136,  1140,  1141,  1142,  1143,  1146,  1147,  1148,  1151,
    1152,  1153,  1154,  1164,  1165,  1166,  1168,  1170,  1172,  1176,
    1177,  1178,  1181,  1182,  1185,  1187,  1189,  1191,  1193,  1197,
    1199,  1201,  1203,  1205,  1209,  1213,  1215,  1219,  1220,  1226,
    1237,  1239,  1245,  1246,  1250,  1254,  1257,  1260,  1263,  1266,
    1269,  1272,  1275,  1278,  1281,  1284,  1287,  1290,  1293,  1296,
    1299,  1302,  1305,  1308,  1312,  1313,  1319,  1322,  1327,  1328,
    1331,  1332,  1333,  1336,  1337,  1347,  1361,  1366,  1367,  1375,
    1376,  1377,  1380,  1381,  1384,  1385,  1386,  1388,  1390,  1391,
    1392,  1394,  1396,  1398,  1403,  1404,  1407,  1408,  1415,  1418,
    1421,  1422,  1432,  1435,  1445,  1446,  1447,  1448,  1449,  1450,
    1451,  1455,  1458,  1460,  1462,  1466,  1467,  1468,  1471,  1477,
    1478,  1481,  1483,  1484,  1498,  1500,  1502,  1504,  1506,  1508,
    1510,  1525,  1526,  1527,  1528,  1531,  1538,  1539,  1540,  1547,
    1549,  1553,  1555,  1557,  1559,  1564,  1565,  1568,  1570,  1574,
    1577,  1579,  1585,  1588,  1589,  1590,  1591,  1592,  1595,  1599,
    1603,  1604,  1605,  1606,  1607,  1610,  1613,  1616,  1617,  1618,
    1621,  1622,  1623,  1624,  1627,  1628,  1631,  1632,  1641,  1640,
    1658,  1659,  1660,  1664,  1667,  1670,  1672,  1676,  1687,  1691,
    1695,  1696,  1699,  1701,  1703,  1705,  1707,  1709,  1711,  1713,
    1715,  1717,  1721,  1722,  1733,  1735,  1740,  1741,  1748,  1749,
    1752,  1755,  1757,  1760,  1763,  1767,  1768,  1778,  1782,  1783,
    1797,  1808,  1813,  1821,  1822,  1825,  1827,  1829,  1833,  1834,
    1835,  1838,  1841,  1844,  1845,  1848,  1849,  1852,  1854,  1857,
    1860,  1861,  1864,  1865,  1868,  1869,  1876,  1877,  1885,  1890,
    1892,  1896,  1898,  1902,  1913,  1921,  1936,  1938,  1940,  1942,
    1946,  1950,  1954,  1955,  1958,  1959,  1963,  1964,  1965,  1968,
    1975,  1976,  1979,  1981,  1983,  1985,  1989,  1990,  1993,  1994,
    1997,  2009,  2013,  2014,  2015,  2016,  2017,  2018,  2019,  2020,
    2023,  2025,  2029,  2030,  2033,  2034,  2043,  2058,  2063,  2068,
    2073,  2078,  2083,  2088,  2093,  2098,  2100,  2104,  2105,  2106,
    2107,  2108,  2109,  2110,  2111,  2112,  2113,  2114,  2115,  2116,
    2117,  2120,  2121,  2124,  2126,  2128,  2130,  2132,  2134,  2136,
    2138,  2140,  2142,  2144,  2148,  2149,  2150,  2151,  2152,  2153,
    2154,  2155,  2156,  2157,  2160,  2161,  2171,  2175,  2179,  2186,
    2187,  2188,  2191,  2193,  2197,  2198,  2199,  2200,  2203,  2205,
    2207,  2209,  2211,  2213,  2215,  2219,  2221,  2225,  2226,  2229,
    2234,  2237,  2239,  2243,  2252,  2257,  2261,  2262,  2265,  2266,
    2278,  2283,  2284,  2287,  2290,  2293,  2294,  2297,  2299,  2301,
    2305,  2306,  2307,  2310,  2313,  2318,  2319,  2322,  2324,  2328,
    2330,  2334,  2335,  2336,  2337,  2338,  2341,  2342,  2343,  2344,
    2347,  2349,  2353,  2355,  2365,  2367,  2372,  2374,  2379,  2381,
    2383,  2385,  2387,  2389,  2391,  2393,  2395,  2397,  2400,  2402,
    2404,  2408,  2409,  2413,  2417,  2418,  2421,  2422,  2435,  2439,
    2443,  2444,  2448,  2452,  2454,  2456,  2458,  2463,  2465,  2469,
    2472,  2477,  2478,  2482,  2493,  2495,  2497,  2501,  2502,  2505,
    2506,  2517,  2519,  2521,  2523,  2525,  2527,  2529,  2531,  2533,
    2535,  2537,  2539,  2541,  2543,  2547,  2548,  2558,  2560,  2562,
    2564,  2566,  2568,  2578,  2580,  2582,  2584,  2586,  2588,  2590,
    2592,  2594,  2596,  2608,  2607,  2617,  2618,  2619,  2623,  2625,
    2629,  2630,  2631,  2632,  2633,  2636,  2637,  2641,  2642,  2643,
    2644,  2647,  2648,  2649,  2652,  2664,  2668,  2672,  2674,  2687,
    2688,  2689,  2690,  2691,  2692,  2693,  2694,  2695,  2696,  2697,
    2698,  2699,  2700,  2703,  2704,  2705,  2709,  2711,  2712,  2716,
    2717,  2718,  2722,  2723,  2733,  2735,  2747,  2759,  2761,  2765,
    2767,  2771,  2773,  2775,  2777,  2779,  2781,  2783,  2785,  2787,
    2789,  2791,  2795,  2796,  2807,  2811,  2813,  2818,  2819,  2823,
    2833,  2844,  2851,  2853,  2855,  2857,  2859,  2863,  2864,  2868,
    2882,  2884,  2886,  2899,  2901,  2903,  2907,  2909,  2913,  2914,
    2917,  2918,  2921,  2922,  2925,  2926,  2929,  2932,  2943,  2948,
    2949,  2950,  2951,  2952,  2956,  2957,  3006,  3010,  3012,  3014,
    3016,  3018,  3022,  3024,  3028,  3040,  3044,  3045,  3048,  3052,
    3055,  3058,  3059,  3060,  3061,  3062,  3063,  3064,  3065,  3068,
    3069,  3079,  3093,  3124,  3125,  3126,  3127,  3128,  3131,  3135,
    3136,  3146,  3148,  3152,  3154,  3158,  3160,  3162,  3164,  3168,
    3169,  3172,  3176,  3178,  3180,  3184,  3189,  3190,  3200,  3202,
    3204,  3206,  3208,  3210,  3212,  3214,  3218,  3219,  3222,  3223,
    3226,  3228,  3230,  3233,  3236,  3237,  3240,  3244,  3245,  3248,
    3250,  3252,  3254,  3258,  3260,  3262,  3264,  3266,  3270,  3271,
    3274,  3275,  3278,  3288,  3291,  3294,  3297,  3300,  3302,  3304,
    3308,  3309,  3313,  3314,  3325,  3326,  3329,  3330,  3340,  3342,
    3344,  3346,  3348,  3350,  3352,  3354,  3356,  3358,  3360,  3381,
    3383,  3385,  3387,  3389,  3391,  3393,  3397,  3399,  3401,  3403,
    3407,  3408,  3409,  3410,  3414,  3415,  3425,  3427,  3431,  3433,
    3435,  3437,  3441,  3444,  3445,  3448,  3450,  3454,  3467,  3469,
    3471,  3473,  3478,  3484,  3491,  3498,  3499,  3500,  3501,  3502,
    3503,  3504,  3505,  3506,  3509,  3510,  3511,  3512,  3513,  3514,
    3516,  3518,  3522,  3523,  3524,  3525,  3526,  3529,  3537,  3539,
    3541,  3543,  3545,  3547,  3549,  3551,  3553,  3555,  3557,  3561,
    3564,  3567,  3569,  3572,  3575,  3577,  3580,  3588,  3589,  3592,
    3593,  3596,  3600,  3609,  3610,  3613,  3614,  3617,  3621,  3625,
    3627,  3629,  3631,  3633,  3635,  3639,  3642,  3645,  3648,  3651,
    3653,  3655,  3657,  3661,  3665,  3667,  3670,  3673,  3674,  3675,
    3676,  3677,  3678,  3679,  3680,  3681,  3682,  3683,  3684,  3685,
    3686,  3712,  3714,  3716,  3727,  3729,  3731,  3733,  3735,  3737,
    3739,  3741,  3743,  3745,  3747,  3749,  3751,  3753,  3755,  3757,
    3759,  3761,  3763,  3765,  3767,  3769,  3771,  3773,  3775,  3777,
    3779,  3781,  3783,  3785,  3787,  3789,  3791,  3802,  3804,  3806,
    3808,  3810,  3812,  3814,  3816,  3818,  3820,  3822,  3824,  3826,
    3828,  3830,  3832,  3834,  3836,  3848,  3850,  3852,  3854,  3856,
    3858,  3860,  3862,  3864,  3866,  3868,  3870,  3872,  3874,  3876,
    3878,  3880,  3882,  3894,  3896,  3898,  3900,  3902,  3904,  3906,
    3908,  3910,  3912,  3914,  3926,  3928,  3930,  3932,  3934,  3936,
    3938,  3940,  3942,  3944,  3946,  3948,  3950,  3952,  3954,  3956,
    3958,  3960,  3962,  3964,  3966,  3968,  3970,  3972,  3975,  3977,
    3979,  3981,  3983,  3985,  3987,  3989,  3991,  3993,  3998,  4000,
    4002,  4006,  4007,  4008,  4011,  4012,  4015,  4016,  4017,  4018,
    4019,  4020,  4021,  4022,  4023,  4026,  4027,  4030,  4031,  4034,
    4035,  4036,  4037,  4038,  4039,  4042,  4044,  4048,  4051,  4054,
    4056,  4060,  4061,  4065,  4066,  4072,  4073,  4074,  4075,  4076,
    4077,  4078,  4079,  4083,  4085,  4090,  4094,  4097,  4100,  4102,
    4104,  4106,  4108,  4111,  4114,  4118,  4122,  4124,  4126,  4130,
    4132,  4139,  4143,  4145,  4149,  4153,  4156,  4159,  4160,  4163,
    4164,  4168,  4169,  4170,  4171,  4174,  4175,  4179,  4180,  4183,
    4184,  4193,  4195,  4200,  4202,  4204,  4209,  4211,  4235,  4239,
    4248,  4259,  4267,  4277,  4279,  4283,  4285,  4289,  4290,  4300,
    4301,  4304,  4306,  4310,  4312,  4316,  4318,  4323,  4324,  4325,
    4326,  4327,  4329,  4331,  4333,  4341,  4343,  4345,  4347,  4349,
    4351,  4353,  4355,  4359,  4360,  4361,  4362,  4363,  4374,  4375,
    4378,  4379,  4382,  4390,  4393,  4401,  4402,  4411,  4420,  4432,
    4433,  4436,  4437,  4438,  4441,  4442,  4443,  4444,  4445,  4448,
    4449,  4452,  4453,  4454,  4455,  4456,  4457,  4460,  4462,  4469,
    4485,  4487,  4490,  4492,  4496,  4508,  4524,  4530,  4542,  4551,
    4552,  4555,  4556,  4557,  4560,  4561,  4564,  4565,  4568,  4569,
    4572,  4574,  4576,  4578,  4582,  4589,  4612,  4644,  4654,  4661,
    4701,  4703,  4710,  4712,  4713,  4718,  4716,  4731,  4730,  4743,
    4749,  4751,  4752,  4755,  4756,  4757,  4758,  4759,  4766,  4765,
    4775,  4777,  4779,  4780,  4781,  4784,  4785,  4786,  4787,  4788,
    4791,  4792,  4796,  4795,  4856,  4854,  4869,  4868,  4881,  4887,
    4891,  4895,  4901,  4902,  4903,  4904,  4907,  4908,  4911,  4919,
    4936,  4944,  4967,  5061,  5095,  5097,  5099,  5103,  5107,  5106,
    5157,  5159,  5158,  5173,  5179,  5186,  5191,  5194,  5195,  5198,
    5199,  5200,  5201,  5202,  5203,  5204,  5212,  5220,  5223,  5224,
    5225,  5226,  5227,  5228,  5236,  5244,  5245,  5246,  5249,  5250,
    5253,  5255,  5259,  5330,  5331,  5338,  5339,  5340,  5346,  5355,
    5358,  5359,  5360,  5361,  5364,  5365,  5371,  5385,  5384,  5402,
    5403,  5404,  5405,  5406,  5409,  5411,  5415,  5416,  5423,  5428,
    5430,  5431,  5434,  5435,  5438,  5445,  5452,  5452,  5454,  5455,
    5458,  5458,  5460,  5470,  5479,  5485,  5491,  5497,  5505,  5506,
    5518,  5528,  5539,  5543,  5544,  5547,  5552,  5556,  5557,  5560,
    5567,  5574,  5578,  5579,  5582,  5585,  5589,  5590,  5593,  5600,
    5601,  5602,  5603,  5604,  5605,  5606,  5607,  5608,  5609,  5610,
    5611,  5612,  5613,  5614,  5644,  5645,  5648,  5649,  5656,  5657,
    5658,  5665,  5664,  5723,  5724,  5731,  5730,  5799,  5805,  5811,
    5819,  5825,  5831,  5837,  5843,  5849,  5855,  5861,  5867,  5878,
    5879,  5882,  5883,  5884,  5885,  5886,  5887,  5888,  5889,  5890,
    5891,  5892,  5893,  5894,  5895,  5896,  5897,  5898,  5899,  5900,
    5901,  5902,  5903,  5904,  5905,  5906,  5907,  5908,  5909,  5912,
    5913,  5914,  5915,  5916,  5917,  5921,  5922,  5923,  5924,  5925,
    5926,  5927,  5930,  5944,  5945,  5946,  5947,  5948,  5949,  5950,
    5954,  5955,  5956,  5957,  5958,  5959,  5964,  5965,  5966,  5967,
    5968,  5973,  5974,  5975,  5976,  5977,  5983,  5984,  5985,  5986,
    5987,  5988,  5989,  5990,  5991,  5994,  5995,  5996,  5997,  6000,
    6001,  6002,  6003,  6006,  6007,  6008,  6009,  6010,  6011,  6012,
    6030,  6030,  6032,  6033,  6034,  6035,  6036,  6037,  6044,  6045,
    6048,  6049,  6050,  6051,  6052,  6053,  6054,  6055,  6056,  6057,
    6058,  6059,  6060,  6061,  6062,  6063,  6064,  6065,  6066,  6067,
    6068,  6069,  6070,  6071,  6072,  6073,  6074,  6075,  6077,  6078,
    6079,  6080,  6081,  6082,  6083,  6084,  6085,  6086,  6088,  6089,
    6090,  6091,  6092,  6093,  6094,  6095,  6096,  6097,  6098,  6099,
    6100,  6101,  6102,  6103,  6104,  6105,  6106,  6107,  6108,  6109,
    6110,  6111,  6112,  6113,  6114,  6115,  6116,  6117,  6119,  6120,
    6121,  6122,  6123,  6124,  6125,  6126,  6127,  6128,  6129,  6130,
    6131,  6132,  6133,  6134,  6135,  6136,  6137,  6138,  6139,  6140,
    6141,  6142,  6143,  6144,  6146,  6147,  6149,  6150,  6151,  6152,
    6153,  6154,  6155,  6156,  6157,  6158,  6159,  6160,  6161,  6162,
    6163,  6164,  6165,  6166,  6167,  6168,  6169,  6170,  6171,  6172,
    6173,  6174,  6175,  6176,  6177,  6178,  6179,  6180,  6181,  6182,
    6183,  6184,  6185,  6186,  6187,  6188,  6189,  6190,  6191,  6192,
    6193,  6194,  6195,  6196,  6197,  6199,  6200,  6201,  6202,  6203,
    6204,  6205,  6206,  6207,  6208,  6209,  6210,  6211,  6212,  6213,
    6214,  6215,  6216,  6217,  6218,  6219,  6220,  6221,  6222,  6223,
    6224,  6225,  6226,  6227,  6228,  6229,  6230,  6231,  6232,  6233,
    6234,  6235,  6236,  6237,  6238,  6239,  6240,  6241,  6243,  6257,
    6258,  6262,  6263,  6264,  6265,  6266,  6267,  6268,  6269,  6270,
    6271,  6275,  6276,  6277,  6278,  6279,  6280,  6281,  6282,  6283,
    6284,  6285,  6286,  6287,  6288,  6289,  6290,  6291,  6292,  6293,
    6294,  6295,  6296,  6310,  6311,  6312,  6313,  6314,  6315,  6316,
    6317,  6318,  6319,  6320,  6321,  6322,  6323,  6324,  6325,  6326,
    6327,  6328,  6329,  6339,  6340,  6341,  6342,  6343,  6344,  6345,
    6346,  6347,  6348,  6349,  6350,  6351,  6352,  6353,  6354,  6355,
    6356,  6357,  6358,  6359,  6360,  6361,  6362,  6363,  6364,  6365,
    6366,  6367,  6368,  6369,  6370,  6371,  6372,  6373,  6374,  6375,
    6376,  6377,  6378,  6379,  6380,  6381,  6382,  6383,  6384,  6385,
    6386,  6387,  6388,  6389,  6390,  6391,  6392,  6393,  6394,  6395,
    6396,  6397,  6398,  6399,  6403,  6404,  6408,  6409,  6410,  6411,
    6412,  6416,  6416,  6419,  6422,  6423,  6426,  6428,  6433,  6443,
    6450,  6451,  6452,  6455,  6484,  6485,  6488,  6490,  6498,  6499,
    6500,  6504,  6505,  6509,  6510,  6513,  6514,  6517,  6518,  6519,
    6520,  6521,  6524,  6525,  6526,  6527,  6528,  6529,  6530,  6531,
    6532,  6533,  6534,  6535,  6536,  6537,  6538,  6539,  6540,  6541,
    6542,  6543,  6544,  6545,  6546,  6547,  6548,  6549,  6550,  6551,
    6552,  6553,  6554,  6555,  6556,  6557,  6558,  6559,  6560,  6561,
    6562,  6563,  6564,  6565,  6566,  6567,  6568,  6569,  6570,  6571,
    6572,  6573,  6574,  6575,  6576,  6577,  6578,  6579
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", "SQL_DATA", 
  "SQL_DATETIME_INTERVAL_CODE", "SQL_DATETIME_INTERVAL_PRECISION", 
  "SQL_DESCRIBE", "SQL_DESCRIPTOR", "SQL_DISCONNECT", "SQL_ENUM", 
  "SQL_FOUND", "SQL_FREE", "SQL_GO", "SQL_GOTO", "SQL_IDENTIFIED", 
  "SQL_INDICATOR", "SQL_KEY_MEMBER", "SQL_LENGTH", "SQL_LONG", "SQL_NAME", 
  "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", 
  "SQL_REFERENCE", "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", 
  "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", 
  "SQL_SQLERROR", "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", 
  "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", 
  "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", 
  "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", 
  "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", 
  "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", 
  "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ANALYSE", 
  "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", 
  "ASSIGNMENT", "ASYMMETRIC", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", 
  "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN_P", "BOTH", 
  "BY", "CACHE", "CALLED", "CASCADE", "CASE", "CAST", "CHAIN", "CHAR_P", 
  "CHARACTER", "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", 
  "CLUSTER", "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", 
  "COMMITTED", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONVERSION_P", 
  "CONVERT", "COPY", "CREATE", "CREATEDB", "CREATEROLE", "CREATEUSER", 
  "CROSS", "CSV", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", 
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", 
  "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", 
  "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P", 
  "DELIMITER", "DELIMITERS", "DESC", "DISABLE_P", "DISTINCT", "DO", 
  "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", 
  "ENCRYPTED", "END_P", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXCLUDING", 
  "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", 
  "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", "FOREIGN", "FORWARD", 
  "FREEZE", "FROM", "FULL", "FUNCTION", "GET", "GLOBAL", "GRANT", 
  "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING", "HEADER", "HOLD", 
  "HOUR_P", "ILIKE", "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", 
  "INCLUDING", "INCREMENT", "INDEX", "INHERIT", "INHERITS", "INITIALLY", 
  "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", 
  "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", 
  "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", 
  "LARGE_P", "LAST_P", "LEADING", "LEAST", "LEFT", "LEVEL", "LIKE", 
  "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", 
  "LOCATION", "LOCK_P", "LOGIN_P", "MATCH", "MAXVALUE", "MINUTE_P", 
  "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAMES", "NATIONAL", "NATURAL", 
  "NCHAR", "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", 
  "NOCREATEUSER", "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", 
  "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNER", "PARTIAL", "PASSWORD", "PLACING", "POSITION", 
  "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY", "PRIOR", 
  "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", "READ", "REAL", 
  "RECHECK", "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", 
  "REPEATABLE", "REPLACE", "RESET", "RESTART", "RESTRICT", "RETURNS", 
  "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", 
  "SAVEPOINT", "SCHEMA", "SCROLL", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", 
  "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "STABLE", 
  "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", 
  "STRICT_P", "SUBSTRING", "SUPERUSER_P", "SYMMETRIC", "SYSID", 
  "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", 
  "THEN", "TIME", "TIMESTAMP", "TO", "TOAST", "TRAILING", "TRANSACTION", 
  "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", 
  "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", 
  "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATOR", 
  "VALUES", "VARCHAR", "VARYING", "VERBOSE", "VIEW", "VOLATILE", "WHEN", 
  "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", "YEAR_P", "ZONE", 
  "UNIONJOIN", "IDENT", "SCONST", "Op", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "BCONST", "XCONST", "ICONST", "PARAM", "FCONST", 
  "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", 
  "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "';'", "'{'", "'}'", 
  "\"=\"", "','", "':'", "$accept", "prog", "statements", "statement", 
  "opt_at", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList", 
  "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", "AlterUserStmt", 
  "DropRoleStmt", "DropUserStmt", "CreateGroupStmt", "AlterGroupStmt", 
  "add_drop", "DropGroupStmt", "CreateSchemaStmt", "OptSchemaName", 
  "OptSchemaEltList", "schema_stmt", "VariableSetStmt", "set_rest", 
  "var_name", "var_list_or_default", "var_list", "iso_level", "var_value", 
  "opt_boolean", "zone_value", "opt_encoding", "ColId_or_Sconst", 
  "VariableShowStmt", "VariableResetStmt", "ConstraintsSetStmt", 
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt", 
  "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_rel_cmds", "alter_rel_cmd", "alter_column_default", 
  "opt_drop_behavior", "alter_using", "ClosePortalStmt", "CopyStmt", 
  "copy_from", "copy_file_name", "copy_opt_list", "copy_opt_item", 
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", 
  "OptTemp", "OptTableElementList", "TableElementList", "TableElement", 
  "columnDef", "ColQualList", "ColConstraint", "ColConstraintElem", 
  "ConstraintAttr", "TableLikeClause", "like_including_defaults", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "key_actions", "key_delete", "key_update", 
  "key_action", "OptInherit", "OptWithOids", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "CreateAsStmt", "@1", 
  "WithOidsAs", "OptCreateAs", "CreateAsList", "CreateAsElement", 
  "CreateSeqStmt", "AlterSeqStmt", "OptSeqList", "OptSeqElem", "opt_by", 
  "CreatePLangStmt", "opt_trusted", "handler_name", "opt_validator", 
  "opt_lancompiler", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents", 
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", "TriggerForType", 
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable", 
  "ConstraintAttributeSpec", "ConstraintDeferrabilitySpec", 
  "ConstraintTimeSpec", "DropTrigStmt", "CreateAssertStmt", 
  "DropAssertStmt", "DefineStmt", "rowdefinition", "definition", 
  "def_list", "def_elem", "def_arg", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_recheck", 
  "DropOpClassStmt", "DropStmt", "drop_type", "any_name_list", "any_name", 
  "attrs", "TruncateStmt", "FetchStmt", "fetch_direction", "from_in", 
  "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "function_with_argtypes_list", "function_with_argtypes", 
  "GrantRoleStmt", "RevokeRoleStmt", "opt_grant_admin_option", 
  "opt_granted_by", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "opt_definition", "AlterFunctionStmt", 
  "alterfunc_opt_list", "opt_restrict", "RemoveFuncStmt", 
  "RemoveAggrStmt", "aggr_argtype", "RemoveOperStmt", "oper_argtypes", 
  "any_operator", "CreateCastStmt", "cast_context", "DropCastStmt", 
  "ReindexStmt", "reindex_type", "opt_force", "RenameStmt", "opt_column", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "LoadStmt", 
  "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", "opt_equal", 
  "AlterDatabaseStmt", "AlterDatabaseSetStmt", "alterdb_opt_list", 
  "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt", "AlterDomainStmt", 
  "opt_as", "CreateConversionStmt", "ClusterStmt", "VacuumStmt", 
  "AnalyzeStmt", "analyze_keyword", "opt_verbose", "opt_full", 
  "opt_freeze", "opt_name_list", "ExplainStmt", "ExplainableStmt", 
  "opt_analyze", "InsertStmt", "insert_rest", "insert_column_list", 
  "insert_column_item", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "locked_rels_list", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "func_table", "where_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "Numeric", 
  "opt_float", "opt_numeric", "opt_decimal", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", 
  "func_expr", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "extract_list", "type_list", 
  "array_expr_list", "array_expr", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", "opt_asymmetric", 
  "target_list", "target_el", "update_target_list", "inf_col_list", 
  "inf_val_list", "update_target_el", "insert_target_list", 
  "insert_target_el", "relation_name", "qualified_name_list", 
  "qualified_name", "name_list", "name", "database_name", "access_method", 
  "attr_name", "index_name", "file_name", "func_name", "AexprConst", 
  "Iconst", "Fconst", "Bconst", "Xconst", "Sconst", "PosIntConst", 
  "IntConst", "IntConstVar", "AllConstVar", "StringConst", 
  "PosIntStringConst", "NumConst", "AllConst", "PosAllConst", "RoleId", 
  "SpecialRuleRelation", "ECPGConnect", "connection_target", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", "ECPGDeallocate", 
  "ECPGVarDeclaration", "single_vt_declaration", "single_var_declaration", 
  "@3", "@4", "precision", "opt_scale", "ecpg_interval", 
  "ECPGDeclaration", "@5", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@6", "var_declaration", "@7", "@8", 
  "storage_declaration", "storage_clause", "storage_modifier", "var_type", 
  "enum_type", "enum_definition", "struct_union_type_with_symbol", "@9", 
  "struct_union_type", "@10", "s_struct_union_symbol", "s_struct_union", 
  "simple_type", "unsigned_type", "signed_type", "opt_signed", 
  "variable_list", "variable", "opt_initializer", "opt_pointer", 
  "ECPGDeclare", "ECPGDisconnect", "dis_name", "connection_object", 
  "ECPGExecute", "@11", "execute_rest", "execstring", "prepared_name", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "opt_sql", "ecpg_into", 
  "using_list", "UsingConst", "ECPGPrepare", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", 
  "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ECPGColId", "ColId", "type_name", 
  "function_name", "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", 
  "ECPGCKeywords", "unreserved_keyword", "ECPGunreserved_interval", 
  "ECPGunreserved", "ECPGunreserved_con", "col_name_keyword", 
  "func_name_keyword", "reserved_keyword", "into_list", "ecpgstart", 
  "c_args", "coutputvariable", "civarind", "civar", "indicator", 
  "cvariable", "ident", "quoted_ident_stringvar", "c_stuff_item", 
  "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,    61,    60,    62,   680,    43,
      45,    42,    47,    37,    94,   681,    91,    93,    40,    41,
      46,    59,   123,   125,   682,    44,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   447,   448,   449,   449,   450,   450,   450,   450,   450,
     450,   450,   450,   451,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   453,   454,   454,   455,   455,   455,
     455,   455,   455,   455,   455,   455,   455,   455,   455,   455,
     455,   455,   455,   455,   455,   455,   455,   455,   456,   457,
     458,   458,   459,   458,   458,   460,   461,   462,   463,   464,
     464,   465,   466,   466,   467,   467,   468,   468,   469,   469,
     469,   469,   469,   469,   470,   470,   470,   471,   471,   471,
     471,   471,   471,   471,   471,   471,   472,   472,   473,   473,
     474,   474,   475,   475,   475,   475,   476,   476,   476,   477,
     477,   477,   477,   478,   478,   478,   478,   478,   478,   479,
     479,   479,   480,   480,   481,   481,   481,   481,   481,   482,
     482,   482,   482,   482,   483,   484,   484,   485,   485,   486,
     487,   487,   488,   488,   489,   489,   489,   489,   489,   489,
     489,   489,   489,   489,   489,   489,   489,   489,   489,   489,
     489,   489,   489,   489,   490,   490,   491,   491,   492,   492,
     493,   493,   493,   494,   494,   495,   496,   497,   497,   498,
     498,   498,   499,   499,   500,   500,   500,   500,   500,   500,
     500,   500,   500,   500,   501,   501,   502,   502,   503,   503,
     504,   504,   505,   505,   506,   506,   506,   506,   506,   506,
     506,   507,   507,   508,   508,   509,   509,   509,   510,   511,
     511,   512,   512,   512,   513,   513,   513,   513,   513,   513,
     513,   514,   514,   514,   514,   515,   516,   516,   516,   517,
     517,   518,   518,   518,   518,   519,   519,   520,   520,   521,
     522,   522,   522,   523,   523,   523,   523,   523,   524,   525,
     526,   526,   526,   526,   526,   527,   527,   528,   528,   528,
     529,   529,   529,   529,   530,   530,   531,   531,   533,   532,
     534,   534,   534,   535,   535,   536,   536,   537,   538,   539,
     540,   540,   541,   541,   541,   541,   541,   541,   541,   541,
     541,   541,   542,   542,   543,   543,   544,   544,   545,   545,
     546,   546,   547,   547,   548,   549,   549,   550,   551,   551,
     552,   553,   553,   554,   554,   555,   555,   555,   556,   556,
     556,   557,   557,   558,   558,   559,   559,   560,   560,   560,
     561,   561,   562,   562,   563,   563,   563,   563,   563,   564,
     564,   565,   565,   566,   567,   568,   569,   569,   569,   569,
     570,   571,   572,   572,   573,   573,   574,   574,   574,   575,
     576,   576,   577,   577,   577,   577,   578,   578,   579,   579,
     580,   581,   582,   582,   582,   582,   582,   582,   582,   582,
     583,   583,   584,   584,   585,   585,   586,   587,   587,   587,
     587,   587,   587,   587,   587,   587,   587,   588,   588,   588,
     588,   588,   588,   588,   588,   588,   588,   588,   588,   588,
     588,   589,   589,   590,   590,   590,   590,   590,   590,   590,
     590,   590,   590,   590,   591,   591,   591,   591,   591,   591,
     591,   591,   591,   591,   592,   592,   593,   594,   594,   595,
     595,   595,   596,   596,   597,   597,   597,   597,   598,   598,
     598,   598,   598,   598,   598,   599,   599,   600,   600,   601,
     601,   602,   602,   603,   604,   605,   606,   606,   607,   607,
     608,   609,   609,   610,   610,   611,   611,   612,   612,   612,
     613,   613,   613,   614,   614,   615,   615,   616,   616,   617,
     617,   618,   618,   618,   618,   618,   619,   619,   619,   619,
     620,   620,   621,   622,   623,   623,   624,   624,   625,   625,
     625,   625,   625,   625,   625,   625,   625,   625,   626,   626,
     626,   627,   627,   628,   629,   629,   630,   630,   631,   632,
     633,   633,   634,   635,   635,   635,   635,   636,   636,   637,
     637,   638,   638,   639,   640,   640,   640,   641,   641,   642,
     642,   643,   643,   643,   643,   643,   643,   643,   643,   643,
     643,   643,   643,   643,   643,   644,   644,   645,   645,   645,
     645,   645,   645,   646,   646,   646,   646,   646,   646,   646,
     646,   646,   646,   648,   647,   649,   649,   649,   650,   650,
     651,   651,   651,   651,   651,   652,   652,   653,   653,   653,
     653,   654,   654,   654,   655,   656,   657,   658,   658,   659,
     659,   659,   659,   659,   659,   659,   659,   659,   659,   659,
     659,   659,   659,   660,   660,   660,   661,   661,   661,   662,
     662,   662,   663,   663,   664,   664,   665,   666,   666,   667,
     667,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   669,   669,   670,   671,   671,   672,   672,   673,
     674,   675,   676,   676,   676,   676,   676,   677,   677,   678,
     679,   679,   679,   680,   680,   680,   681,   681,   682,   682,
     683,   683,   684,   684,   685,   685,   686,   686,   687,   688,
     688,   688,   688,   688,   689,   689,   690,   691,   691,   691,
     691,   691,   692,   692,   693,   694,   695,   695,   696,   697,
     697,   698,   698,   698,   698,   698,   698,   698,   698,   699,
     699,   700,   701,   702,   702,   702,   702,   702,   703,   703,
     703,   704,   704,   705,   705,   706,   706,   706,   706,   707,
     707,   708,   708,   708,   708,   709,   709,   709,   710,   710,
     710,   710,   710,   710,   710,   710,   711,   711,   712,   712,
     713,   713,   713,   713,   714,   714,   715,   716,   716,   717,
     717,   717,   717,   718,   718,   718,   718,   718,   719,   719,
     720,   720,   721,   722,   722,   723,   723,   724,   724,   724,
     725,   725,   726,   726,   727,   727,   728,   728,   729,   729,
     729,   729,   729,   729,   729,   729,   729,   729,   729,   730,
     730,   730,   730,   730,   730,   730,   731,   731,   731,   731,
     732,   732,   732,   732,   733,   733,   734,   734,   735,   735,
     735,   735,   736,   737,   737,   738,   738,   739,   740,   740,
     740,   740,   741,   741,   741,   742,   742,   742,   742,   742,
     742,   742,   742,   742,   743,   743,   743,   743,   743,   743,
     743,   743,   744,   744,   744,   744,   744,   745,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   747,
     747,   748,   748,   748,   749,   749,   749,   750,   750,   751,
     751,   752,   753,   754,   754,   755,   755,   756,   757,   758,
     758,   758,   758,   758,   758,   759,   759,   760,   760,   761,
     761,   761,   761,   762,   763,   763,   763,   764,   764,   764,
     764,   764,   764,   764,   764,   764,   764,   764,   764,   764,
     764,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   766,   766,   766,   766,   766,
     766,   766,   766,   766,   766,   766,   766,   766,   766,   766,
     766,   766,   766,   767,   767,   767,   767,   767,   767,   767,
     767,   767,   767,   767,   768,   768,   768,   768,   768,   768,
     768,   768,   768,   768,   768,   768,   768,   768,   768,   768,
     768,   768,   768,   768,   768,   768,   768,   768,   768,   768,
     768,   768,   768,   768,   768,   768,   768,   768,   769,   769,
     769,   770,   770,   770,   771,   771,   772,   772,   772,   772,
     772,   772,   772,   772,   772,   773,   773,   774,   774,   775,
     775,   775,   775,   775,   775,   776,   776,   777,   777,   778,
     778,   779,   779,   780,   780,   781,   781,   781,   781,   781,
     781,   781,   781,   782,   782,   783,   784,   784,   785,   785,
     785,   785,   785,   785,   786,   787,   788,   788,   788,   789,
     789,   790,   791,   791,   792,   793,   793,   794,   794,   795,
     795,   796,   796,   796,   796,   797,   797,   798,   798,   799,
     799,   800,   800,   801,   801,   801,   802,   802,   802,   803,
     803,   804,   804,   805,   805,   806,   806,   807,   807,   808,
     808,   809,   809,   810,   810,   811,   811,   812,   813,   814,
     815,   816,   817,   818,   818,   819,   819,   819,   819,   819,
     819,   819,   819,   820,   821,   822,   823,   824,   825,   825,
     826,   826,   827,   827,   828,   828,   828,   828,   828,   829,
     829,   830,   830,   830,   831,   831,   831,   831,   831,   832,
     832,   833,   833,   833,   833,   833,   833,   834,   835,   835,
     836,   836,   836,   836,   837,   837,   837,   838,   839,   840,
     840,   841,   841,   841,   842,   842,   843,   843,   844,   844,
     845,   845,   845,   845,   846,   846,   847,   848,   848,   849,
     850,   850,   851,   852,   852,   854,   853,   855,   853,   853,
     856,   857,   857,   858,   858,   858,   858,   858,   860,   859,
     861,   862,   863,   863,   863,   864,   864,   864,   864,   864,
     865,   865,   867,   866,   869,   868,   870,   868,   868,   871,
     871,   871,   872,   872,   872,   872,   873,   873,   874,   874,
     874,   874,   874,   874,   875,   875,   875,   876,   878,   877,
     879,   880,   879,   881,   881,   882,   882,   883,   883,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   886,   886,
     887,   887,   888,   889,   889,   890,   890,   890,   891,   892,
     893,   893,   893,   893,   894,   894,   895,   896,   895,   897,
     897,   897,   897,   897,   898,   898,   899,   899,   900,   901,
     902,   902,   903,   903,   904,   905,   906,   906,   907,   907,
     908,   908,   909,   909,   910,   911,   911,   911,   912,   912,
     913,   914,   915,   916,   916,   917,   918,   919,   919,   920,
     921,   922,   923,   923,   924,   925,   926,   926,   927,   928,
     928,   928,   928,   928,   928,   928,   928,   928,   928,   928,
     928,   928,   928,   928,   929,   929,   930,   930,   931,   931,
     931,   933,   932,   934,   934,   936,   935,   937,   937,   937,
     938,   938,   938,   938,   938,   938,   938,   938,   938,   939,
     939,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   941,
     941,   941,   941,   941,   941,   942,   942,   942,   942,   942,
     942,   942,   943,   944,   944,   944,   944,   944,   944,   944,
     945,   945,   945,   945,   945,   945,   946,   946,   946,   946,
     946,   947,   947,   947,   947,   947,   948,   948,   948,   948,
     948,   948,   948,   948,   948,   949,   949,   949,   949,   950,
     950,   950,   950,   951,   951,   951,   951,   951,   951,   951,
     952,   952,   953,   953,   953,   953,   953,   953,   954,   954,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   956,
     956,   956,   956,   956,   956,   956,   956,   956,   956,   956,
     956,   956,   956,   956,   956,   956,   956,   956,   956,   956,
     956,   956,   956,   956,   956,   956,   956,   956,   956,   956,
     956,   956,   956,   957,   957,   957,   957,   957,   957,   957,
     957,   957,   957,   957,   957,   957,   957,   957,   957,   957,
     957,   957,   957,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   959,   959,   960,   961,   961,   962,   962,   963,   964,
     965,   965,   965,   966,   967,   967,   968,   968,   969,   969,
     969,   970,   970,   971,   971,   972,   972,   973,   973,   973,
     973,   973,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     1,     0,     2,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     2,     2,     2,     2,     3,     3,     5,     5,
       5,     4,     5,     5,     4,     3,     3,     5,     6,     1,
       1,     3,     6,     4,     1,     0,     2,     0,     1,     1,
       1,     1,     1,     1,     2,     3,     3,     3,     3,     3,
       2,     5,     2,     2,     3,     3,     1,     3,     1,     1,
       1,     3,     2,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     6,     1,     1,     1,
       1,     0,     1,     1,     2,     3,     4,     3,     2,     2,
       3,     4,     3,     2,     4,     1,     1,     1,     1,     1,
       4,     4,     1,     3,     3,     4,     6,     6,     6,     6,
       4,     6,     2,     4,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     1,     3,     3,     3,     3,     2,
       1,     1,     0,     2,     0,     2,     9,     1,     1,     1,
       1,     1,     2,     0,     1,     1,     3,     3,     1,     1,
       3,     3,     3,     4,     1,     0,     2,     0,     3,     0,
       1,     0,    11,    12,     1,     1,     2,     2,     2,     2,
       0,     1,     0,     1,     3,     1,     1,     1,     3,     2,
       0,     3,     1,     1,     2,     1,     2,     3,     4,     2,
       5,     1,     2,     2,     2,     3,     2,     2,     0,     3,
       1,     4,     5,     6,    11,     3,     0,     3,     1,     1,
       2,     2,     0,     1,     1,     2,     2,     0,     3,     3,
       2,     1,     1,     2,     2,     4,     0,     2,     2,     0,
       3,     4,     4,     0,     2,     0,     4,     0,     0,     8,
       3,     3,     1,     3,     0,     3,     1,     1,     5,     4,
       2,     0,     2,     1,     2,     3,     2,     2,     2,     2,
       3,     3,     1,     0,     5,     9,     1,     0,     1,     2,
       2,     0,     2,     0,     5,     1,     0,     6,     2,     0,
       3,    14,    19,     1,     1,     1,     3,     5,     1,     1,
       1,     3,     0,     1,     0,     1,     1,     1,     3,     0,
       1,     1,     0,     2,     1,     2,     1,     2,     0,     2,
       1,     2,     2,     6,     8,     3,     4,     4,     4,     5,
       3,     3,     1,     3,     3,     1,     1,     1,     1,    12,
       1,     3,     4,     7,     4,     2,     1,     0,     1,     0,
       7,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     2,     2,     3,     3,     5,     4,     4,
       3,     4,     3,     3,     2,     4,     2,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     2,     2,     1,     2,
       2,     1,     1,     6,     9,     7,     9,     8,     8,     6,
       9,     7,    10,     7,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     7,     7,    10,     2,
       1,     1,     1,     3,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     2,     1,     3,     1,     2,     3,
       0,     1,     3,     2,     6,     6,     3,     0,     3,     0,
      12,     1,     0,     2,     0,     1,     3,     2,     2,     4,
       1,     2,     0,     9,     7,     2,     0,     3,     2,     1,
       3,     3,     3,     2,     2,     1,     1,     1,     1,     2,
       1,     3,     1,     1,     1,     4,     1,     2,     4,     5,
       1,     1,     1,     1,     3,     3,     2,     2,     2,     2,
       1,     2,     0,     5,     1,     2,     1,     0,     5,     7,
       1,     1,     7,     1,     3,     3,     3,     1,     3,    11,
      10,     2,     0,     8,     4,     4,     4,     1,     1,     1,
       0,     9,     6,     6,     7,     6,     6,     9,     6,     6,
       6,     8,     8,     6,     6,     1,     0,     9,     6,     7,
       6,     6,     6,     9,     6,     6,     6,     7,     9,     9,
       6,     6,     6,     0,    14,     1,     1,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     1,
       1,     1,     1,     0,     6,     2,     2,     2,     2,     2,
       3,     3,     2,     2,     2,     2,     3,     2,     5,     4,
       3,     3,     3,     1,     1,     0,     3,     2,     2,     1,
       3,     2,     1,     0,     7,     9,     2,     5,     3,     1,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     4,
       3,     3,     1,     0,     5,     5,     4,     2,     0,     4,
       3,     6,     4,     6,     6,     5,     7,     1,     0,    10,
       4,     2,     1,     4,     5,     5,     2,     4,     1,     1,
       1,     0,     1,     0,     1,     0,     3,     0,     4,     1,
       1,     1,     1,     1,     1,     0,     4,     4,     2,     1,
       7,     4,     3,     1,     2,     5,     2,     0,     5,     3,
       0,     2,     2,     2,     3,     1,     3,     1,     2,     1,
       0,     6,     7,     0,     2,     2,     2,     3,     0,     2,
       2,     1,     1,     3,     3,     1,     2,     4,     4,     1,
       1,     8,     4,     4,     4,     2,     1,     0,     3,     3,
       4,     4,     4,     4,     2,     1,     1,     0,     1,     0,
       1,     5,     1,     0,     1,     0,     3,     1,     3,     3,
       2,     2,     1,     4,     4,     2,     2,     4,     1,     0,
       1,     1,     1,     3,     0,     2,     0,     4,     4,     3,
       1,     0,     2,     0,     2,     0,     3,     1,     1,     2,
       1,     2,     5,     6,     5,     1,     2,     1,     4,     3,
       4,     3,     5,     4,     5,     4,     5,     2,     4,     1,
       2,     2,     2,     1,     1,     0,     4,     2,     1,     2,
       2,     4,     1,     2,     0,     1,     3,     2,     2,     3,
       5,     6,     3,     4,     0,     1,     3,     3,     3,     3,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     2,
       5,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     1,     3,
       0,     5,     3,     0,     5,     3,     0,     1,     1,     1,
       1,     5,     2,     1,     1,     1,     1,     5,     2,     2,
       2,     1,     3,     3,     2,     1,     0,     3,     0,     5,
       2,     5,     2,     1,     3,     3,     0,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     3,     3,     3,     3,
       0,     1,     3,     5,     2,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     3,     3,
       2,     3,     5,     4,     6,     3,     5,     4,     6,     4,
       6,     5,     7,     2,     3,     2,     4,     3,     4,     3,
       4,     3,     4,     5,     6,     7,     6,     7,     6,     7,
       3,     4,     4,     6,     2,     1,     3,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
       5,     6,     7,     1,     1,     2,     4,     1,     1,     1,
       2,     2,     2,     1,     3,     4,     5,     5,     4,     1,
       1,     4,     1,     4,     1,     4,     1,     4,     1,     1,
       1,     1,     6,     4,     4,     4,     4,     6,     5,     5,
       5,     4,     6,     4,     6,     4,     4,     4,     4,     3,
       5,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     1,     4,     1,
       4,     1,     2,     1,     2,     1,     3,     3,     0,     3,
       1,     1,     3,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     3,     2,     3,     0,     3,     3,
       2,     2,     1,     0,     2,     2,     3,     2,     1,     1,
       3,     5,     2,     1,     4,     2,     0,     1,     0,     1,
       2,     2,     2,     3,     5,     1,     2,     0,     2,     1,
       0,     3,     1,     3,     1,     1,     3,     7,     1,     2,
       4,     1,     3,     4,     4,     3,     1,     1,     1,     1,
       1,     1,     3,     1,     2,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     2,     3,     6,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       5,     3,     2,     2,     3,     7,     1,     2,     2,     1,
       0,     1,     3,     1,     2,     0,     2,     0,     2,     0,
       1,     3,     4,     3,     1,     1,     1,     2,     0,     7,
       3,     2,     1,     1,     1,     0,     5,     0,     4,     2,
       1,     2,     0,     1,     3,     3,     3,     3,     0,     4,
       5,     5,     0,     1,     1,     1,     1,     2,     2,     2,
       1,     2,     0,     7,     0,     5,     0,     4,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     5,     2,     1,     3,     2,     2,     3,     0,     5,
       1,     0,     5,     2,     2,     1,     1,     1,     2,     2,
       3,     1,     2,     2,     3,     3,     4,     2,     1,     2,
       1,     1,     2,     2,     3,     1,     1,     1,     1,     0,
       1,     3,     4,     0,     2,     0,     1,     2,     3,     2,
       1,     1,     1,     0,     1,     1,     3,     0,     4,     2,
       2,     1,     1,     0,     1,     1,     1,     1,     2,     3,
       0,     1,     2,     1,     4,     4,     0,     1,     2,     1,
       1,     3,     1,     1,     4,     4,     4,     4,     1,     0,
       3,     3,     4,     1,     3,     3,     4,     1,     3,     3,
       1,     6,     1,     3,     3,     6,     1,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     4,     1,     1,     4,     4,
       3,     0,     7,     1,     0,     0,     7,     3,     4,     3,
       1,     1,     1,     2,     3,     5,     2,     5,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     1,     0,     1,     2,     1,     2,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     2,
       3,     1,     2,     1,     3,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  2007,  2008,  2011,  2015,  2016,  1943,
    2017,  2018,  1983,  1984,  1985,  1986,  1987,  1988,  1989,  1990,
    1991,  1992,  1993,  1994,  1996,  1995,  1997,  1998,  1999,  2000,
    2001,  2002,  2003,  2004,  2006,  2005,  2020,  2021,  2009,  2010,
    2012,  2013,  1982,  2014,  2022,  2023,  2024,  2019,  1972,  1267,
    1973,    10,  1263,  1264,  2027,  1978,  1979,  1977,  1980,  1981,
    2025,  2026,  1968,  1969,  1971,    11,    12,  1970,     4,  1974,
    1975,  1976,     8,  1348,  1419,     9,  1967,  1419,     0,  1531,
    1532,  1533,     0,  1534,  1535,  1536,  1537,  1538,  1469,  1433,
       0,  1539,     0,  1540,  1541,  1542,  1543,  1544,  1545,  1546,
    1547,  1548,     0,  1549,  1550,  1551,  1552,  1418,  1553,  1554,
    1555,  1556,  1557,  1395,  1401,  1558,  1515,     0,  1375,  1376,
    1372,  1374,  1373,  1377,  1362,   715,     0,   769,   768,     0,
    1853,   715,  1854,  1819,  1855,  1820,  1821,   219,     0,   762,
    1822,     0,   715,  1823,   275,   290,  1856,     0,     0,  1824,
    1825,     0,     0,   396,   715,     0,  1826,   785,  1827,     0,
    1828,  1857,  1858,     0,     0,  1829,  1859,  1860,  1830,     0,
    1831,  1832,  1861,  1862,  1863,  1833,  1864,  1865,     0,     0,
     847,     0,  1834,  1866,  1835,  1836,     0,  1867,  1837,  1838,
    1839,  1868,  1869,  1840,  1841,  1842,     0,  1843,     0,     0,
       0,     0,  1870,   715,  1844,     0,   853,     0,  1845,     0,
    1871,  1846,     0,  1847,  1848,  1849,  1850,  1851,   847,  1511,
    1396,     0,     0,   773,  1852,  1872,  1954,  1955,     0,     0,
       0,    42,    48,    24,    23,    25,    58,    63,    39,    18,
      55,    43,    89,    90,    91,    31,    27,    22,    28,    32,
      45,    33,    44,    21,    40,    57,    46,    61,    47,    62,
      34,    53,    51,    41,    56,    60,    85,    66,    30,    67,
      80,    68,    81,    69,    38,    17,    78,    76,    77,    35,
      54,    75,    79,    19,    20,    82,    59,    74,    71,    86,
      84,    92,    72,    49,    14,    15,    64,    37,    16,    36,
      29,    88,    26,   771,    65,    70,    52,    73,    87,    50,
      83,   830,   821,   855,   829,    94,    95,    96,     7,  1332,
    1334,  1333,  1419,  1370,  1371,  1337,  1380,  1390,  1379,  1383,
    1391,  1378,  1397,     0,    98,   100,   101,   102,   105,   106,
      99,    93,    97,   104,   110,   103,   109,   107,   108,   111,
     112,   113,  1608,  1020,  1606,  1607,  1605,  1354,     0,  1419,
    1356,  1355,  1419,  1366,  1390,     0,  1559,  1560,  1561,  1562,
    1563,  1564,  1613,  1614,  1615,  1616,  1617,  1619,  1618,  1630,
    1631,  1632,  1633,  1634,  1635,  1636,  1637,  1638,  1639,  1640,
    1641,  1642,  1643,  1644,  1645,  1646,  1647,  1648,  1649,  1585,
    1650,  1651,  1652,  1653,  1654,  1655,  1656,  1657,  1629,  1658,
    1659,  1660,  1661,  1662,  1663,  1664,  1665,  1666,  1667,  1622,
    1668,  1669,  1670,  1671,  1672,  1673,  1674,  1675,  1676,  1677,
    1678,  1679,  1680,  1681,  1682,  1683,  1685,  1684,  1686,  1687,
    1688,  1689,  1690,  1691,  1692,  1693,  1694,  1695,  1696,  1697,
    1623,  1698,  1699,  1700,  1701,  1702,  1703,  1704,  1705,  1706,
    1707,  1708,  1709,  1710,  1711,  1712,  1713,  1714,  1715,  1716,
    1717,  1718,  1719,  1720,  1721,  1722,  1723,  1624,  1724,  1725,
    1625,  1726,  1727,  1728,  1729,  1730,  1731,  1732,  1733,  1734,
    1735,  1736,  1737,  1738,  1739,  1740,  1741,  1742,  1743,  1744,
    1745,  1746,  1749,  1747,  1748,  1750,  1751,  1752,  1753,  1754,
    1755,  1756,  1757,  1758,  1759,  1760,  1761,  1762,  1763,  1764,
    1765,  1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,  1774,
    1626,  1775,  1776,  1777,  1778,  1779,  1780,  1781,  1782,  1783,
    1784,  1785,  1786,  1787,  1788,  1790,  1789,  1792,  1791,  1793,
    1794,  1795,  1796,     0,  1797,  1798,  1799,  1800,  1801,  1802,
    1803,  1804,  1805,  1806,  1807,  1808,  1809,  1810,  1811,  1812,
    1813,  1814,  1815,  1816,  1817,  1627,  1818,  1953,  1279,  1325,
    1324,  1302,  1320,  1583,  1529,  1530,  1297,  1584,  1581,  1620,
    1621,  1628,  1582,  1280,  1949,  1580,  1468,     0,     0,  1431,
    1432,  1435,  1310,  1434,     0,  1306,  1429,  1430,  1248,  1326,
    1580,  1565,  1566,  1567,  1568,  1570,  1569,  1571,  1873,  1874,
    1875,  1876,  1877,  1878,  1879,  1880,  1881,  1882,  1883,  1884,
    1598,  1885,  1886,  1887,  1888,  1889,  1890,  1893,  1891,  1892,
    1894,  1895,  1896,  1897,  1898,  1899,  1900,  1901,  1902,  1903,
    1904,  1905,  1906,  1907,  1908,  1909,  1910,  1911,  1599,  1600,
    1912,  1913,  1914,  1915,  1916,  1917,  1918,  1919,  1920,  1921,
    1922,  1923,  1924,  1925,  1926,  1927,  1928,  1929,  1930,  1931,
    1932,  1933,  1602,  1934,  1935,  1601,  1936,  1937,  1938,  1939,
    1940,     0,  1385,  1612,  1597,  1386,  1572,  1609,  1596,  1603,
    1604,  1611,  1610,  1448,  1247,  1450,  1393,  1403,  1399,  1407,
    1402,     0,     0,     0,     0,  1419,   714,   713,   699,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    13,     0,   723,   255,
    1299,  1298,  1243,   761,     0,  1239,  1240,   396,     0,   702,
     274,     0,     0,     0,     0,     0,     0,   456,     0,     0,
       0,     0,     0,     0,     0,   155,     0,   285,   284,     0,
     386,     0,   561,     0,     0,   396,     0,     0,     0,  1303,
       0,  1747,  1446,  1447,  1331,  1784,   813,     0,     0,     0,
       0,   468,     0,   467,     0,     0,   465,     0,   395,     0,
       0,   469,   463,   462,     0,     0,   466,     0,   464,     0,
       0,   703,  1698,  1437,   784,   771,  1631,   494,   498,   489,
     495,   502,   501,   490,   487,   488,  1758,     0,     0,     0,
     484,  1268,  1270,   493,  1269,     0,   530,   536,   535,   534,
       0,   531,   532,   537,     0,   696,  1240,   726,  1252,   846,
       0,     0,   486,   695,  1798,     0,     0,   637,     0,   638,
       0,  1772,   707,   213,  1579,  1777,  1848,  1798,   209,  1577,
     176,  1578,  1574,  1575,  1576,  1573,     0,     0,   531,     0,
     704,   705,   852,   850,     0,     0,     0,     0,  1658,  1718,
    1727,  1768,  1777,  1848,  1798,   164,     0,   208,  1777,  1848,
    1798,   204,   723,     0,     0,  1394,   698,   697,     0,     0,
     918,   772,   775,   830,     0,   715,     0,     6,   770,   766,
     849,   849,     0,   849,     0,   826,  1335,  1390,  1369,  1425,
    1339,     0,     0,  1415,  1411,  1408,  1416,  1417,  1410,  1398,
    1009,  1010,  1011,  1008,  1012,  1007,     0,  1343,  1382,  1349,
       0,  1359,  1358,  1357,  1364,  1425,  1368,  1956,  1957,  1470,
    1301,  1317,     0,     0,     0,     0,     0,     0,  1309,  1315,
       0,  1307,     0,     0,  1961,  1965,     0,  1963,  1958,  1384,
    1456,  1449,  1451,  1453,  1405,  1404,  1400,     0,     0,  1520,
       0,     0,  1521,  1522,     0,  1517,  1519,     0,  1425,     0,
       0,  1583,  1253,  1584,  1581,  1593,  1580,     0,   472,   116,
       0,     0,   472,     0,     0,     0,     0,     0,  1652,  1144,
    1154,  1152,  1153,  1146,  1147,  1148,  1151,  1149,  1150,     0,
     627,  1145,     0,   116,     0,     0,   371,     0,     0,     0,
       0,   116,     0,     0,     0,   719,   722,   700,     0,     0,
    1215,  1244,     0,     0,     0,   514,   523,   515,   520,     0,
     517,     0,     0,     0,   516,   518,   519,     0,   521,   522,
       0,     0,   711,   277,     0,     0,     0,     0,   728,   758,
     289,   288,   116,   287,   286,     0,     0,   575,   116,     0,
     157,   399,     0,     0,   116,     0,     0,     0,     0,     0,
       0,     0,     0,  1471,  1330,  1428,     0,   797,     0,   435,
       0,   750,     0,   151,  1245,     0,     0,   145,     0,   400,
       0,   146,     0,   252,   470,  1445,  1444,  1436,  1443,     0,
     491,   500,   499,   497,   496,   492,  1271,     0,   482,   483,
    1456,  1459,   480,     0,   529,     0,     0,     0,     0,   800,
    1241,     0,   710,     0,   640,   640,   640,   706,   212,   210,
       0,     0,     0,     0,     0,   712,     0,     0,     0,  1819,
    1820,   968,  1208,     0,  1585,  1821,  1822,  1823,  1109,  1118,
    1110,  1112,  1119,  1824,  1825,  1677,  1826,  1827,  1260,  1828,
    1829,   958,  1831,  1832,  1833,  1114,  1116,  1834,  1835,     0,
    1261,  1837,  1838,  1742,  1840,  1841,  1843,  1844,  1120,  1846,
    1847,  1848,  1849,  1850,  1851,  1259,     0,  1121,  1852,  1155,
    1265,  1266,  1217,     0,     0,  1225,     0,  1099,     0,   952,
     954,   955,   979,   980,   956,   985,   986,   998,   953,     0,
    1224,  1021,  1098,  1103,     0,  1097,  1093,   837,  1222,  1209,
       0,  1094,  1293,  1292,  1294,  1295,  1291,  1255,  1583,  1589,
     957,  1584,  1581,  1262,  1296,  1949,  1580,     0,     0,     0,
       0,     0,  1510,   215,     0,   216,  1777,   165,   200,   172,
     199,   173,   203,   202,     0,  1650,   166,     0,   170,     0,
       0,   207,   205,     0,   701,   476,     0,     0,   920,     0,
     919,   774,   771,   824,   823,     5,   777,   848,     0,     0,
       0,     0,     0,     0,     0,   881,   869,  1425,  1426,     0,
    1420,     0,  1419,  1419,  1413,  1412,  1409,     0,     0,     0,
       0,     0,     0,  1285,  1284,  1340,  1342,  1288,     0,  1425,
       0,     0,  1319,     0,  1323,  1321,  1456,  1465,  1456,  1466,
    1467,  1313,  1308,  1311,     0,  1304,  1315,  1959,     0,     0,
    1962,  1387,     0,  1457,  1289,  1290,  1462,     0,  1452,  1460,
    1463,  1406,  1419,  1528,     0,  1523,  1526,     0,  1518,     0,
    1254,     0,     0,     0,     0,   473,     0,     0,     0,   115,
     748,   746,     0,     0,     0,   752,     0,     0,     0,   601,
       0,     0,   602,   600,   603,   614,   617,     0,   553,   149,
     150,     0,     0,     0,     0,     0,   221,   244,     0,     0,
       0,     0,     0,     0,   141,     0,     0,     0,   369,   656,
     656,     0,     0,     0,   656,     0,   656,     0,   220,   222,
       0,     0,     0,     0,     0,     0,     0,     0,   144,  1350,
       0,   717,   718,     0,   721,     0,  1212,  1211,  1250,  1216,
     760,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   436,     0,   961,   996,   996,   996,
     976,   976,   970,   959,  1003,     0,   996,   973,   962,     0,
     960,  1006,  1006,   991,     0,   934,   944,   946,   947,   977,
     978,   948,   983,   984,   945,  1020,  1588,   957,  1590,  1587,
    1586,     0,     0,   757,     0,     0,   457,   437,     0,     0,
       0,   153,     0,     0,   404,   403,     0,     0,   438,     0,
     371,   364,   326,     0,     0,     0,  1251,     0,     0,   814,
     818,   815,     0,   816,     0,   924,     0,     0,   252,     0,
       0,     0,     0,     0,   252,   250,   251,     0,   461,  1438,
    1441,  1442,     0,   778,   780,   782,   781,   783,   779,   481,
     478,   479,     0,  1458,  1941,  1947,     0,  1472,  1473,     0,
    1667,  1692,  1712,  1773,     0,  1793,     0,   538,   557,   533,
       0,     0,     0,   786,   789,     0,     0,   810,   485,  1464,
     639,   636,   635,   634,   211,   177,     0,     0,   559,  1772,
     709,     0,     0,  1101,  1102,   995,   982,  1207,     0,     0,
     990,   989,     0,     0,     0,     0,     0,   966,   965,   964,
    1100,  1168,     0,   963,     0,     0,     0,     0,   996,   996,
     994,  1040,     0,     0,   967,     0,     0,  1187,     0,  1193,
       0,     0,     0,  1002,     0,  1000,     0,     0,  1074,  1095,
    1024,  1025,  1099,  1165,     0,  1256,     0,     0,   988,     0,
    1020,     0,     0,     0,     0,  1220,  1163,     0,     0,  1053,
    1161,     0,  1055,     0,     0,     0,  1155,  1154,  1152,  1153,
    1146,  1147,  1148,  1151,  1149,  1150,  1159,  1037,     0,  1036,
    1456,     0,   885,   836,  1210,     0,     0,  1948,  1950,  1507,
    1506,  1505,  1504,  1480,     0,  1476,  1477,     0,  1508,  1509,
     217,   218,   214,     0,   175,   174,     0,   197,   198,   169,
       0,   193,   194,   179,   190,   192,   191,   189,   167,   178,
     180,   186,   187,   188,   168,   206,  1419,     0,     0,   885,
    1228,  1217,   763,     0,   767,   830,   834,   829,   833,   856,
     857,   862,   832,     0,   883,   883,   871,   865,   870,   866,
     872,   880,   828,   868,   827,     0,  1427,  1338,  1425,   934,
    1419,  1360,  1419,  1414,  1346,  1014,  1015,  1016,  1017,  1019,
    1018,  1347,  1344,  1013,  1345,  1287,  1286,     0,     0,     0,
       0,  1367,  1316,     0,  1300,  1322,     0,  1314,     0,  1960,
    1966,  1964,     0,     0,   934,  1944,  1524,  1944,   934,   621,
       0,   620,     0,     0,   474,     0,     0,     0,   745,   744,
       0,     0,     0,     0,     0,   755,   320,     0,   249,     0,
       0,     0,     0,     0,     0,     0,     0,   606,   607,   616,
     615,   613,   586,   588,   587,   578,     0,   579,     0,     0,
     585,   594,  1594,   957,   592,  1595,  1592,  1591,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   623,   628,   140,     0,     0,   124,   126,     0,     0,
     122,   128,   125,   127,   123,   129,   121,     0,     0,   120,
       0,     0,     0,     0,   139,     0,     0,     0,     0,   373,
     383,     0,     0,     0,   116,   116,   370,   655,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   143,   142,
       0,     0,   185,   716,   720,  1213,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   276,   258,
     257,     0,     0,   442,   445,     0,   934,     0,     0,     0,
     928,  1009,  1008,  1007,     0,   949,   951,     0,     0,   743,
     743,   743,   743,   743,   727,   729,   300,   147,     0,     0,
     114,   157,   290,     0,   156,   158,   160,   161,   162,   159,
     163,   398,     0,   409,   408,   410,     0,   405,     0,   439,
     138,   368,     0,   292,     0,     0,     0,   384,     0,     0,
       0,   673,     0,     0,     0,   817,     0,   895,   796,   887,
     897,   888,   890,   922,  1243,     0,   795,     0,     0,   618,
    1246,     0,     0,   252,   252,   394,   471,  1439,  1440,   813,
     477,     0,     0,  1946,  1272,     0,  1273,     0,     0,   541,
     540,   551,     0,   542,   543,   539,   544,     0,     0,   559,
     788,     0,     0,   793,  1217,     0,   807,     0,   805,     0,
    1242,   809,   798,     0,   531,     0,     0,   252,   708,  1165,
       0,     0,     0,  1171,     0,     0,  1206,  1203,     0,     0,
    1165,     0,     0,     0,     0,  1178,  1179,  1180,  1177,  1181,
    1176,     0,     0,  1182,  1175,     0,     0,     0,     0,     0,
     993,   992,     0,     0,     0,     0,     0,     0,     0,  1075,
       0,     0,  1139,     0,  1165,  1192,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1165,  1198,     0,  1218,
    1217,     0,     0,     0,     0,  1257,  1022,  1038,  1223,     0,
    1219,     0,     0,  1045,     0,  1199,  1070,     0,  1059,     0,
    1054,     0,  1057,  1061,  1041,  1220,  1164,     0,  1162,     0,
       0,  1039,     0,  1034,  1032,  1033,  1026,  1027,  1028,  1029,
    1030,  1031,  1035,  1143,  1141,  1142,     0,  1553,  1693,  1718,
       0,   847,   847,   835,   845,  1221,     0,   924,     0,     0,
       0,  1104,     0,  1952,  1951,     0,     0,     0,     0,     0,
    1020,     0,   934,   921,     0,  1217,     0,   924,     0,   765,
     764,     0,     0,   860,   861,     0,   879,     0,   810,   810,
       0,     0,     0,  1336,  1421,  1423,  1389,  1361,  1392,  1341,
    1381,     0,  1365,  1318,  1312,     0,  1454,  1461,  1514,     0,
    1945,     0,     0,     0,   664,   642,   475,   665,   643,     0,
     747,     0,     0,     0,     0,     0,   252,   753,   248,   754,
     658,   666,     0,   604,   605,     0,   589,   577,     0,     0,
     584,     0,   583,   951,     0,     0,     0,   645,   148,   246,
     650,   247,   245,   646,     0,  1249,     0,     0,     0,   134,
       0,     0,     0,     0,   117,   135,   133,     0,   132,     0,
     670,   648,   660,   372,   382,     0,   376,   377,   374,   378,
     379,     0,     0,   224,     0,     0,   236,   235,   242,   243,
     241,   252,   252,   239,   240,   238,   649,     0,   661,   237,
     234,     0,   223,   672,   654,     0,   671,   662,   653,   183,
     182,   184,     0,     0,     0,     0,     0,     0,     0,   525,
     509,   524,     0,     0,     0,   503,   260,   261,   279,   259,
     441,     0,     0,     0,     0,   929,     0,     0,   934,     0,
       0,   942,   935,   943,     0,     0,     0,     0,   743,   742,
       0,     0,     0,     0,     0,   730,   751,     0,   326,   152,
       0,     0,   397,     0,     0,     0,   925,     0,     0,     0,
       0,   291,   293,   295,   296,   297,     0,   366,   367,   362,
       0,     0,   358,     0,   328,   329,     0,     0,     0,   564,
       0,     0,     0,   612,   610,   596,     0,   819,   820,     0,
     895,     0,   897,     0,   896,   909,     0,     0,   915,   913,
       0,   915,     0,   915,     0,     0,   889,     0,   891,   909,
    1244,   923,   252,     0,   252,   252,   694,   433,     0,  1455,
    1942,  1481,  1482,     0,  1474,  1475,     0,   553,     0,   550,
     545,   547,     0,   554,  1238,  1237,     0,  1236,     0,     0,
     794,   808,   801,   803,   802,     0,     0,   799,     0,   252,
       0,   555,   851,     0,  1173,  1174,     0,     0,     0,     0,
    1202,     0,     0,  1135,     0,  1133,  1111,  1113,   975,     0,
    1123,     0,   969,  1136,  1137,  1115,  1117,     0,   972,     0,
    1156,     0,     0,  1124,  1077,     0,     0,     0,     0,  1155,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1089,
    1088,  1125,  1138,     0,     0,  1190,  1191,  1126,  1004,  1005,
    1006,  1006,     0,     0,  1197,     0,     0,     0,  1131,  1096,
    1166,   997,   998,     0,     0,     0,     0,     0,     0,     0,
    1060,  1056,     0,  1058,  1062,     0,     0,     0,     0,  1047,
    1071,  1043,     0,     0,  1049,     0,  1072,   847,   847,   847,
     847,   844,     0,     0,   884,   874,     0,     0,  1108,  1105,
    1489,  1490,  1491,  1492,  1493,  1494,  1495,  1496,  1497,  1498,
    1500,  1501,  1502,  1499,  1503,  1485,  1486,     0,  1478,  1479,
     171,     0,   195,   181,  1514,     0,  1229,  1226,   811,     0,
     776,   858,     0,  1157,   859,   882,   878,   877,   863,   867,
     864,     0,  1422,  1351,  1328,  1513,  1516,  1527,  1525,  1363,
       0,     0,     0,   743,     0,   319,     0,     0,     0,   756,
     598,     0,   580,   581,   582,     0,   667,   644,   659,     0,
       0,   625,     0,   626,   624,   130,   118,   137,   136,   119,
     131,   375,   381,   380,   300,     0,     0,     0,   225,   233,
     230,     0,     0,  1214,     0,     0,   505,   511,     0,     0,
       0,     0,   513,   280,   116,     0,   443,  1742,  1147,   444,
     446,   447,   448,   428,     0,     0,     0,   932,     0,     0,
       0,     0,     0,     0,   934,  1020,     0,     0,   738,  1281,
    1282,   737,  1283,   734,   733,   741,   740,   732,   731,   736,
     735,     0,     0,     0,   311,     0,     0,   305,     0,     0,
     357,   299,   302,   303,     0,     0,   290,     0,   412,   406,
     440,     0,   927,   292,   318,   346,     0,   363,     0,     0,
       0,     0,   325,     0,   724,   391,   388,     0,     0,     0,
     608,   590,   609,     0,   593,     0,   597,   574,     0,   812,
    1329,   899,   907,     0,   886,     0,   914,   910,     0,   911,
       0,     0,   912,   901,     0,     0,   907,     0,   619,   252,
     460,   622,   818,     0,     0,   552,   548,     0,     0,   526,
     556,   787,     0,     0,   791,   792,   806,   804,     0,   527,
     558,  1166,  1172,   981,     0,  1205,  1201,     0,     0,     0,
    1167,     0,     0,  1185,  1184,  1076,  1186,     0,     0,     0,
    1087,  1086,  1084,  1085,  1078,  1079,  1080,  1081,  1082,  1083,
    1195,  1194,  1188,  1189,  1001,   999,     0,  1128,  1129,  1130,
    1196,  1140,   987,  1020,  1023,     0,     0,  1046,  1200,  1063,
       0,  1170,     0,  1042,     0,     0,     0,     0,  1051,  1156,
       0,     0,     0,     0,     0,     0,   839,   838,     0,   876,
    1106,  1107,     0,     0,     0,  1512,     0,     0,  1234,  1233,
       0,  1424,     0,  1305,     0,     0,     0,     0,   321,     0,
       0,   357,   599,   595,     0,     0,     0,   298,     0,     0,
       0,     0,   254,   651,   652,     0,     0,     0,     0,   508,
     507,   263,     0,   430,     0,     0,   434,   424,   426,     0,
       0,     0,   930,   936,   937,   938,   939,   940,   941,   933,
     950,   422,   739,     0,     0,   309,   313,   314,   312,   304,
     357,   326,     0,   306,     0,     0,     0,   414,     0,     0,
     926,     0,     0,     0,   315,     0,   349,   294,   365,   367,
     360,   361,   359,   327,     0,   393,   389,     0,   563,     0,
       0,   612,   611,   689,   690,   687,   688,     0,   898,     0,
       0,   900,     0,     0,   903,   905,     0,     0,     0,     0,
       0,  1247,   633,     0,  1483,  1484,     0,   546,  1235,     0,
       0,  1204,  1122,  1132,   974,  1134,   971,  1183,     0,     0,
       0,  1127,  1258,  1068,  1066,     0,  1064,     0,     0,     0,
    1048,  1044,     0,  1050,  1073,   843,   842,   841,   840,     0,
       0,   831,  1487,     0,  1274,  1278,  1275,  1488,  1020,     0,
    1230,     0,  1327,   663,   641,   657,   749,     0,   357,   322,
     669,   647,   668,   226,   227,   228,   229,     0,   231,   504,
       0,   510,   506,   256,   278,   432,   431,   429,   425,   427,
     931,     0,   632,     0,   428,     0,     0,   301,   307,   332,
       0,     0,   725,   292,   413,     0,     0,   407,   349,   317,
     316,     0,     0,     0,   353,   390,     0,   385,     0,     0,
       0,   565,   572,   572,   591,   573,     0,     0,   908,   917,
       0,   904,   902,   892,     0,   894,     0,   549,     0,   252,
    1090,     0,     0,  1065,  1169,  1069,  1067,  1052,   873,   875,
    1277,  1276,   196,  1231,     0,  1158,     0,   323,   253,   512,
     264,   268,   758,   758,     0,   269,   758,   265,   758,   262,
     632,     0,   630,   423,     0,   308,     0,   337,     0,     0,
     415,   416,   411,     0,   353,     0,   347,   348,     0,   355,
     392,   759,     0,   355,     0,     0,   570,   568,   567,   924,
     906,     0,   893,   790,   528,     0,  1091,     0,  1227,   326,
       0,     0,     0,     0,     0,     0,   629,   631,     0,   330,
     331,     0,   310,   333,   334,   356,     0,     0,   355,   345,
       0,     0,   282,   572,   924,   566,   571,     0,   916,  1092,
    1232,   332,   266,   271,     0,   272,   267,   270,     0,     0,
       0,     0,   335,     0,   336,     0,     0,     0,   449,   450,
     419,   283,     0,   350,     0,   354,   569,   560,   693,   337,
     273,     0,   342,     0,   341,     0,   338,   339,     0,     0,
     455,     0,     0,   417,   420,   421,   351,   352,   692,   691,
       0,   428,     0,   340,   343,   344,     0,   459,   451,   401,
       0,   675,   686,   674,   676,   684,   681,   683,   682,   680,
     324,     0,   454,   458,     0,   452,   418,     0,   685,   679,
     830,   821,     0,     0,   677,   686,   419,   459,   678,     0,
     453,   402
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    68,   229,   230,   231,  1390,  1904,   232,
     233,   234,   235,   236,   237,   238,   239,  1412,   240,   241,
    1089,  1521,  1994,   242,   895,   896,  1738,  1739,  1943,  1740,
    1741,  1729,  1279,  1281,   243,   244,   245,  1274,  1722,   246,
     247,  1438,  1439,  1416,  1417,  1395,  1558,  3108,   248,   249,
    1961,  2378,  3113,  3199,   751,  1472,  2724,  2725,   250,  1518,
    2420,  2421,  2422,  2423,  2406,  2771,  2772,  2773,  2424,  3004,
    2425,  1836,  2016,  2433,  2434,  3207,  3252,  3253,  3254,  3306,
    3006,  3144,  3219,  3262,  2993,   251,  2791,  2432,  2014,  2426,
    2427,   252,   253,  1428,  1916,  2325,   254,   775,  2795,  3015,
    3147,   255,   809,   256,  1523,   257,   258,  1526,  2006,  2007,
    2998,  3135,  3212,  3312,  3313,  3124,  2966,  2967,  2968,   259,
     260,   261,   262,  2009,  1474,  1962,  1963,  2729,   263,  3288,
    3289,   776,  3345,   264,   265,   810,  1123,  3226,  1385,   266,
     267,   828,   829,   268,  1071,  2370,   269,   270,   840,  2084,
     842,  1586,  2489,  2490,  2839,  2060,  1013,   271,   272,  2069,
    2087,   273,   777,  2799,  3150,  3151,  3227,   274,   778,  1408,
    1856,  1857,  1858,  2800,  1859,  2803,  1860,  2443,  2444,  2445,
    2807,   275,  1406,  1851,   276,   277,  1820,   278,  1880,  1029,
     279,  3202,   280,   281,   860,  1601,   282,  1919,   283,   284,
     285,  2446,  3333,  3347,  3348,  3349,  3027,  3320,   286,  3335,
     288,   289,   290,   738,  1045,  1046,  1047,   291,   292,   293,
    1984,  1985,  2400,   294,   295,  1829,  2270,   296,   297,   298,
    1514,   299,   300,   301,   302,   303,   919,   912,  1302,  1754,
     304,  1563,   815,  3336,  1593,  2072,  2073,  3337,  1545,   307,
    1597,  2079,  2082,  3338,   309,  1106,  2024,  3339,  1227,   312,
     313,   314,  1702,  2203,   850,  1308,   884,   924,   925,  1759,
    1760,  1315,  1774,  1767,  1769,  2919,  3081,  1316,  1772,  2238,
    2207,  2028,  2029,  2030,  2454,  2465,  2817,  3034,  2031,  2032,
    2036,  2415,  2416,  1861,  1970,  2390,  1495,  1228,  1229,  1230,
    1633,  1644,  1627,  1498,  1231,  1232,  1233,  1501,  1234,  1235,
    1236,  1237,  1616,  1668,  1238,  1239,  1653,   947,  2089,  2128,
    1241,  1242,  1243,  2196,  1696,  1031,  1244,  2654,  1698,  2147,
    2111,  2902,  2092,  1614,  2112,  2126,  2542,  2131,  2136,  2565,
    2566,  2148,  2166,  1245,  2096,  2097,  2521,  1618,  1246,  2149,
    1051,  1659,  2162,  1247,  1248,  1749,  2224,  3184,  1750,  2496,
    2497,  1249,  1587,   910,  3030,  1114,   602,  2304,  1457,   744,
     847,  1250,  1251,  1252,  1253,  1254,  1255,  1256,   832,   833,
    2055,  3087,  2371,  2751,  1365,  1742,  1257,   580,   745,   315,
     603,   604,   968,   969,  1352,  1355,  1342,  1804,   581,   582,
     605,  2933,   316,   317,   318,   319,   320,  1317,   929,  1336,
    1798,   948,    72,    77,    73,   949,   358,   359,  1780,   321,
     715,  1781,  1339,   955,   362,   323,   324,   363,   326,   692,
     364,   931,   328,   932,   329,   330,   331,   332,   939,   333,
    1319,  1320,  2662,  1321,   334,   335,   606,   607,   336,  1128,
    1559,  1127,   784,   337,   338,   981,   982,   983,  1141,  1572,
    1142,  1368,  1369,   339,   340,   598,   341,   342,   343,  1577,
    1578,   344,  1715,  1716,  1717,   345,  2481,  2482,   346,  2635,
    2636,  2637,   347,  1711,   348,   349,   904,  2666,   350,   711,
     351,   995,   583,   584,   585,  1259,   695,   870,   846,  1260,
    1002,   696,   353,   698,   587,   588,   589,   590,   591,   592,
    1005,   702,  1573,    74,  2259,  1574,  1263,  1264,  1707,  1265,
     595,   959,   974,   975,  2260,   977,    75,   978
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -2916
static const int yypact[] =
{
   -2916,   711, 12738, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, 14944, -2916, -2916, 33559,   614, -2916,
   -2916, -2916, 36445, -2916, -2916, -2916, -2916, -2916,   174, 35621,
   13711, -2916, 51256, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, 51256, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, 34386,  1076, -2916, -2916,   311, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916,   734,  3475, -2916, -2916, 38917,
   -2916,    41, -2916, -2916, -2916, -2916, -2916, -2916, 51256, 46324,
   -2916,   499,   419, -2916,   695,  2964, -2916, 38917, 37269, -2916,
   -2916, 51667,   627,  3154,   734, 39329, -2916,  1414, -2916, 31066,
   -2916, -2916, -2916,   851, 44269, -2916, -2916, -2916, -2916,   669,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, 46324,   989,
     579, 31484, -2916, -2916, -2916, -2916, 46324, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, 39741, -2916,   444, 52078,
   52489, 43858, -2916,   700, -2916, 51256,   206, 33148, -2916, 52900,
   -2916, -2916,   667, -2916, -2916, -2916, -2916, -2916,   579, -2916,
   34386, 29804, 45091,   912, -2916, -2916, -2916, -2916,   -51,  5266,
     676, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916,   732, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916,    33, -2916,   486,    49, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, 55359,   253, -2916, -2916, -2916,   716, -2916,   705,
   -2916, -2916, -2916,  1075, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916,   126, -2916, -2916, -2916, -2916,  1122, 33972,
   -2916, -2916, 55359, -2916,   736, 38917, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, 37681, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916,    73, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, 51256, 51256, -2916,
   -2916, -2916,   800, -2916,   781, -2916, -2916, -2916, -2916, -2916,
     842, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, 13224, -2916, -2916, -2916,   822, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916,   898, -2916,   200,  1046, -2916,
   -2916, 34386,  1361,  1361,  1311, 55359, -2916, -2916, -2916, 43036,
   51256, 51256, 51256, 43036, 51256, 45091, 51256, 28121, 51256, 51256,
   45091, 45091, 51256, 51256, 51256, 51256, -2916,  1309,    35, -2916,
   -2916, -2916,  -117, -2916,  1087, -2916,  1096,  3196,   989, -2916,
   -2916, 46324, 43036, 51256,   996,  1085, 51256, -2916, 51256,  1156,
   51256,  1193,  1139,  1168, 51256, 51256, 51256, -2916, -2916, 51256,
   -2916, 51256, -2916, 51256,   782,  1226,  1365,  1337,    47, -2916,
   38917, 38917, -2916, -2916, -2916,  1162, -2916, 45091, 43036, 51256,
    1118, -2916, 51256, -2916, 43036, 51256, -2916,  1170, -2916, 51256,
   51256, -2916, -2916, -2916, 51256, 51256, -2916, 51256, -2916,  1342,
   51256, -2916,  1176, -2916, -2916,   732,  1270, -2916,   148,    93,
     188, -2916, -2916,   119,   180,   183,  1270,   535, 46735, 51256,
    1376, -2916, -2916, -2916, -2916, 38917,  1303, -2916, -2916, -2916,
    1331,  -103, -2916, -2916, 46324, -2916, -2916, -2916, -2916, -2916,
   46324,   512, -2916, -2916,   989,  1444, 51256, -2916, 51256, -2916,
   46324, 51256, -2916, -2916, -2916,  1572,  1275,  1457,  1266, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916,  1403,  1426,    12,   989,
    1350, -2916, -2916,  1439, 17975,   392, 38917, 31902, 47968, 54544,
      36, 38093, 53311,  1333,    35, -2916,  -110, -2916,  1713,  1405,
    1591,  1266,    35, 46324, 55756, -2916, -2916, -2916, 25607,  1520,
    1437, -2916,  1697,  1455,  1468,   734,  1477, -2916, -2916, 46324,
    1826,  1826,  1816,  1826,   779,   790, -2916, -2916, -2916,  1504,
   -2916,  1508,  1519, -2916,   358,  1739, -2916, -2916, -2916, -2916,
    1594,  1601,  1613,  1616, -2916,  1634,  1259, -2916, -2916, -2916,
    1836, -2916, -2916, -2916, -2916,  1504, -2916, -2916, -2916, -2916,
   -2916,  1922,  1919, 38093, 38093,  1639,    -5, 32734, -2916,  1595,
     800, -2916, 17040, 13224, -2916, 23073,   802, -2916, -2916, -2916,
     160, -2916, -2916, -2916,  1817, -2916, -2916,  1814, 51256, -2916,
    1676, 51256, -2916, -2916, 53722, -2916, -2916,  1361,  1504,  -117,
    1619,  1620, -2916,  1621,  1623, -2916,  1624,   637,  1627,  1099,
     134,  1764,   329,   574,  1630,   254,   876,  1761, 51256, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,  1646,
   -2916, -2916,  1641,   857,   985,  1738,   305,  1335,  1090,  1797,
     610,   901,  1647,  1844,   -43, -2916,   488, -2916, 20973, 28980,
   -2916,  -117, 46324, 43036,  1651, -2916, -2916, -2916, -2916, 43036,
   -2916,  1807,  1819, 51256, -2916, -2916, -2916, 51256, -2916, -2916,
    1854, 51256, -2916,  1688,  1658,  1981, 41802, 51256,  1700,  2014,
   -2916, -2916,  1707, -2916, -2916, 51256,  1658,   762,  1707,  2016,
    2017,  1818,   946,    79,  1707, 46324, 46324, 46324,  1881, 51256,
   51256, 43036, 51256, -2916, -2916, -2916,   803,  1729,  1687, -2916,
   41802, -2916,  1630,  1682, -2916, 51256,  1690,  1682,  1842, -2916,
    1843,  1682,   989,    48, -2916, -2916, -2916, -2916,   218,   733,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, 51256,  1376,  1376,
      91, -2916, -2916,   103, -2916, 45502, 51256, 45913,    53,    -3,
   -2916, 51256, -2916,  1176,  1943,  1943,  1943, -2916, -2916, -2916,
    1892, 51256,  1947, 45502, 51256, -2916, 54133,  1699,   921,  1245,
     927, -2916, 20973,  1702,    56,    56,  1706,  1708, -2916, -2916,
    1709,  1710, -2916,   894,   894,  1846,  1715,  1716, -2916,   931,
    1717, -2916,  1249,  1025,  1723,  1725,  1727,  1531,    56, 20973,
   -2916,  1728,  1070,  1730,  1731,  1741,  1261,  1742, -2916,  1357,
    1743,  1372,  1424,  1750,  1757, -2916,  1715, -2916,    69, -2916,
   -2916, -2916, -2916, 20973, 20973, -2916, 18409, -2916,   989, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916,    37, -2916,  1100,
    7031, -2916, -2916, -2916, 20973, -2916, -2916,     7, -2916,  -117,
    1759, -2916, -2916, -2916, -2916, -2916, -2916, -2916,  1117, -2916,
   -2916,  1119,  1145, -2916, -2916,   102,  1173,   743,   743,   583,
   38505, 38505, -2916, -2916,   653,  1682,   207, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, 36857,  2074, -2916,   642,   488, 30216,
   30216, -2916, -2916,  1933, -2916,  1732,  1967, 46324, -2916, 26858,
   -2916, -2916,   732, -2916, -2916, -2916,  1762, -2916,   -51,   -51,
   20973,   -51,    -9, 18835, 20973,  2010,   730,  1504,  1770,   877,
   -2916, 42625, 54955, 54955,  1978, -2916, -2916,   591,   352,  1868,
    1948,   527,  1436, -2916, -2916, -2916,  1763, -2916,  2055,  1504,
    1004, 38917,  1820, 38093, -2916, -2916,  2169, -2916,  2169, -2916,
   -2916, -2916, -2916,  1771,   535, -2916,  1595, -2916, 17114,  1536,
   -2916, -2916, 13224, -2916, -2916, -2916, -2916,  2195, -2916,  1769,
   -2916, -2916, 55359,  1780, 51256, -2916,  1782,  1784, -2916, 55756,
    -117, 29392,  1851,  1853, 34386,  1790,  1858,  1861, 54544, -2916,
   -2916, -2916,    92,   588,    61, -2916,  1863,  1949,  1900, -2916,
    1960,   529, -2916, -2916, -2916, -2916,  1962, 16231,  1116, -2916,
   -2916,  1869,  1849,  1873,  1880,  1891,  1815, -2916,  1885,  1867,
   40566, 28550, 54544,  1840, -2916,  1888,  1890,  1929,  1916,   812,
    2140,  1980,  1896,  1893,   990,  1894,   155,   465,  1822, -2916,
    1901,  1902, 45091,  1903,  1945,  1905, 54544,  1840, -2916, -2916,
    1187, -2916, -2916,    35, -2916,  3476, -2916, -2916, -2916, -2916,
   -2916,  1845, 41802,  1630,  1259, 51256,  1847,    62,  1993, 51256,
    2062,  2012,   123, 34386, -2916,  1862, -2916,  1904,  1904,  1904,
    1865,  1865,  1871, -2916, -2916,  1531,  1904,  1872, -2916, 42214,
   -2916,   763,   967, -2916,  2212,    75, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916,  1143, -2916,  1627, -2916, -2916,
   -2916,  2223,   418, -2916, 41802,  1840,  2152, -2916,  1909,  1840,
   51256,   452, 51256,  2061, -2916, -2916,   184,  1875, -2916,  1840,
   -2916,   -46,  1876, 38093,  2128,  2030, -2916,  1630,  2228, -2916,
    1369, -2916,  1987, -2916, 23923,  1923, 29392,  2234,   109, 51256,
    1937, 40566, 46324, 46324,   109, -2916, -2916, 51256, -2916, -2916,
    1376,   898, 51256, -2916, -2916, -2916, -2916, -2916, -2916,  1376,
   -2916, -2916,  2321,  1897, -2916,   102,   535,  1899, -2916,  1920,
   51256, 43036, 51256, 51256, 46324, 51256,  1973,  1732,   299, -2916,
    1951,  1912, 26441, -2916, -2916,   186, 46324,  2072, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, 44269,  2158,    -4, 51256,
   -2916, 20973, 19261, -2916, -2916, -2916,  1917,  8858,  1952, 20973,
   -2916, -2916, 20973, 20973,   535,   535,   535, -2916, -2916, -2916,
   -2916,  1685,   535, -2916, 20973, 20973,   535,   535,  1904,  1904,
   -2916,  2792, 20973,   535, -2916, 28550, 20973, 21399, 15796, 20973,
    1986,  1988,   535, -2916,   535, -2916, 20973, 17549, -2916,  -117,
    2283,  2283,  1735,  2405,  1918, -2916,  2019,   535, -2916,   535,
     948, 41802, 20973, 34386,  1989,   137, 20973,  1924,  1265, -2916,
   20973,   196, -2916,  1930, 20973,  1997,   135, 20973, 20973, 20973,
   20973, 20973, 20973, 20973, 20973, 20973, -2916, 21825,   150,  1036,
   36033, 17975,  2178, -2916,  1301, 15361, 38917, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916,   535,  1931, -2916,  1950, -2916, -2916,
   -2916, -2916, -2916,  2074, -2916, -2916,  2000, -2916, -2916, -2916,
    1215, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,  1934,
   -2916, -2916, -2916, -2916, -2916, -2916, 55359,  1939, 51256,    20,
   -2916, -2916, 44680, 51256, -2916, -2916,  2154, -2916, -2916,  1954,
   -2916,  6516,  2154,  2094,  2108,  2108, -2916,   -57,  8858,  2149,
    8858, -2916, -2916, -2916, -2916,  1034, -2916, -2916,  1504,  1959,
   14125, -2916, 14529, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916,  1259,  1963,  2365,
    1045, -2916, -2916, 38093, -2916, -2916, 32734, -2916,  1972, -2916,
   -2916, -2916, 38917,  1255,  1959, 13224, -2916, 13224,  1959, -2916,
    1974, -2916, 51256, 51256, -2916, 34386, 51256, 51256, -2916,  2284,
    1977, 51256,  2181,  2184,  1982, -2916, -2916, 51256, -2916,  2141,
   20973,  2142, 51256, 51256,  2145,   604,  2137, -2916, -2916, -2916,
   -2916, -2916,  2132, -2916, -2916, -2916,   837, -2916, 35210, 40154,
   -2916, -2916,   177,  1627, -2916,   209,   262,   337,  2056,  2059,
    2093, 51256, 51256, 51256, 51256, 51256,   706, 51256, 51256,  1990,
    1995,  1992, -2916, -2916, 51256,  2196, -2916, -2916,  2144,    43,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916,  2026, 51256, -2916,
     535,  2146, 51256,  2051, -2916, 51256, 51256, 51256,  1259, -2916,
    2337,  1259,  1259,   680,  1707,  1707, -2916, -2916, -2916, 51256,
   51256, 51256,  2082, 47146, 51256, 51256, 47557, 51256, 51256, 51256,
     159,  1538, 51256, 51256,  2129, 51256, 51256, 51256, -2916, -2916,
      63,  2135, -2916, -2916, -2916, -2916, 20973, 29392,  2360,  2224,
    2225,  2060, 40566,   490, 51256, 51256,  2226,   490, -2916, -2916,
   -2916,   895,   897, -2916,  2033, 20973,    90, 41802,  2024, 24757,
   -2916,  2087, -2916,  2088,   535, -2916,  1790,   184,  2218,  2039,
    2039,  2039,  2039,  2039,   418, -2916, -2916, -2916,  2276, 46324,
   -2916, -2916,   835, 44269, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916,  2026, -2916, -2916, -2916,  2177,  2174, 51256, -2916,
   -2916,  1916, 46324, 43447,    78, 51256,  2375,  2266,   989, 46324,
    1528, -2916,  2264,  2265,  2286, -2916, 23506, 48379,  2027,  1130,
   -2916, 48379, 48790, -2916,  -117, 20973, -2916,  2034, 41802, -2916,
   -2916, 51256,  2037,   109,   109, -2916, -2916, -2916, -2916, -2916,
   -2916, 38917,   842, -2916, -2916,   842, -2916,   842,  2466,  1682,
    2038, -2916,  1630,  1682,  1682,  1732,  1682, 49201,  2397,  2282,
   -2916, 19695,   993, -2916, -2916,    59, -2916,   395,   -53,  2230,
   -2916, -2916, -2916,  2197,  2044, 49201,  2384,   109, -2916,  8858,
    1035,   593,   868, -2916,   535, 20973,    39, -2916,  7573,  1167,
    7864,  1198,  2045,  2057,  1210, -2916, -2916, -2916, -2916, -2916,
   -2916,  2066,  2300, -2916, -2916,  2068,  1225,  1260,  2070,  2073,
   -2916, -2916,  3565,  1269,  2078,  8150,  2080, 21399,   320, -2916,
   21399,  2085, -2916,  1274,  6764,  2053,  2086,  2090,  2110,  2089,
    2092,  8258, 20121, 20973, 20121, 20121,  7132,  2053,  2096, -2916,
   -2916, 20973, 51256,  2097,  2100, -2916, -2916,  2792, -2916,  2118,
   -2916, 21399, 21399,  2511, 18409, -2916, -2916,  2305, -2916,   777,
   -2916,  2102, -2916, -2916,  3858,   164, 20973,  1924, 20973,  2167,
   28550,  7623, 20973,  2341,  3977,  3977,   107,   107,    82,    82,
      82,  1314,  1036, -2916, -2916, -2916,  2105,  2515,  1628,  1629,
   46324,  3775,  4422, -2916, -2916, -2916, 23923,  1923, 20973, 20973,
    2106, -2916,  1284, -2916, -2916,   332,  2466,   535,    35,   535,
     948, 30641,  1959, -2916,  2111, -2916, 51256,  1923,   793, -2916,
   -2916,  1287, 20973, -2916, -2916,  2565, -2916, 51256,  2072,  2072,
   20973, 20973, 18835, -2916, -2916,  2122, -2916, -2916, -2916, -2916,
   -2916,  2114, -2916, -2916, -2916, 51256, -2916, -2916,  2522,  2119,
    2112,  2120,  2121,  1161, -2916, -2916, -2916, -2916, -2916,  2318,
   -2916, 20973,   453,  2127,  2133, 51256,   109, -2916,  8858, -2916,
   -2916, -2916,  2346, -2916, -2916,  2290, -2916, -2916, 34798, 41802,
   -2916, 41802, -2916,   341, 51256, 51256, 51256, -2916,  1682, -2916,
   -2916, -2916, -2916, -2916,  1152, -2916, 41802,  2275, 40978,  1682,
    1270,  2026, 51256, 51256, -2916,  1682, -2916,  2026,  1682,  2026,
   -2916, -2916, -2916, -2916, -2916,  1259, -2916, -2916, -2916, -2916,
   -2916,  1259,  1259, -2916, 41802,    30, -2916, -2916, -2916, -2916,
   -2916,   109,   109, -2916, -2916, -2916, -2916,  2201, -2916, -2916,
   -2916,  2170, -2916, -2916, -2916,  2202, -2916, -2916, -2916, -2916,
   -2916, -2916,  6124,  2143, 41802,   490,   490, 51256,  2147, -2916,
   -2916, -2916,  2348,  2349,   490, -2916, -2916, -2916,   116, -2916,
   -2916, 34386, 27692,  4254,  2153, -2916,  2151,   535,  1959, 25190,
    1441, -2916, -2916, -2916,    32,  2322,  2156,  2294,  2039, -2916,
     248,   142, 49612, 50023, 50434, -2916,  2857,  2204,  1876,   452,
    2268,   914, -2916, 46324,   184,  1288, -2916, 41802,  2155, 46324,
    2157,  2159, -2916, -2916, -2916, -2916,  1297, -2916, 41802, -2916,
    2310,  2311, -2916,  1313, -2916, -2916,   -51, 51256,  2227,  2198,
     989, 38093, 41390,  2163, -2916, -2916,  2313, -2916, -2916, 26024,
   22677,  1130,  2161, 51256, -2916,  2165, 23923,  2374,  2316, -2916,
   23923,  2316,  1214,  2316, 23923,  2388, -2916, 27275, -2916,  2186,
    1301,  8858,   109,  2187,   109,   109, -2916, -2916,   887, -2916,
   -2916,  2180, -2916,  2203, -2916, -2916, 43036, -2916, 51256,   483,
   -2916, -2916,  2335, -2916, -2916,  8858,  1323, -2916,   697, 51256,
    -117, -2916, -2916, -2916, -2916,  2452,  2453, -2916, 45502,    76,
   51256, -2916, -2916, 20973, -2916, -2916,  2205,  2194,  9579, 20973,
   -2916,  2464, 41802, -2916, 51256, -2916, -2916, -2916, -2916,   535,
   -2916, 20973, -2916, -2916, -2916, -2916, -2916, 20973, -2916,   535,
   -2916, 20973,  2446, -2916,  2566, 41802, 21399,   538,  1730, 22251,
   21399, 21399, 21399, 21399, 21399, 21399, 21399, 21399, 21399, -2916,
     300, -2916, -2916, 20973, 20973,  2454,  2446, -2916, -2916, -2916,
    1381,  1381, 41802,  2206,  2053,  2207,  2208, 20973, -2916,  -117,
    4340, -2916,  2527,   989, 20973,   805,  1367, 20973,  1327, 20973,
   -2916, -2916,  2210, -2916, -2916, 41802, 20973, 21399, 21399,  5302,
   -2916,  5330, 20973,  2211,  5932, 18409, -2916,   579,   579,   579,
     579, -2916, 46324, 46324,  2027,  2449,  1328,  1345, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916,  2209, -2916,  2231, -2916, -2916,
     488,  2214, -2916, -2916,  2522,  2235,  1146, -2916, -2916, 20547,
   -2916, -2916,  2229, -2916, -2916,  1682, -2916, -2916, -2916, -2916,
   -2916, 13224, -2916, -2916,  2240, -2916, -2916, -2916, -2916, -2916,
    2287,  2288,  2327,  2039,  4707, -2916, 51256, 51256,  1346, -2916,
   -2916,  2443, -2916, -2916, -2916,  2281, -2916, -2916, -2916,  2292,
    2296, -2916,  2298, -2916, -2916, -2916, -2916,  1682,  1682, -2916,
   -2916, -2916, -2916, -2916, -2916,   149,   464, 41802, -2916, -2916,
   -2916, 51256, 51256, -2916,  2442,  2236, -2916, -2916,  2445,  2447,
     490,   490, -2916, -2916,  1707,  2512, -2916,  2229,  1436, -2916,
   -2916, -2916, -2916,   608,   535,  1422,  2242, -2916,  1413, 25190,
   25190, 25190, 25190, 25190,  1959,   948, 46324,   535, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916,  2239, 51256, 21399, -2916,   843,   158, -2916,  2450, 46324,
    2295, -2916, -2916, -2916, 41802,  2588,   581, 46324,  2493,  2393,
   -2916, 51256, -2916, 43447,   911,  2471, 43447, -2916, 51256,  2598,
    2600,   -51, -2916, 51256, -2916,  2297,  1627,   989, 51256,  2257,
   -2916,  2252, -2916,  2191, -2916,  1658, -2916, -2916,    44, -2916,
   -2916, 48379,  2261, 51256,  1130, 23923, -2916, -2916,  2217, -2916,
   23923,  2467, -2916, -2916, 23923, 51256,  2262, 51256, -2916,   109,
   -2916, -2916,  1369,   842,   332, -2916, -2916,  2505, 49201, -2916,
   -2916, -2916, 19695,  2267, -2916, -2916, -2916, -2916,  2514, -2916,
   -2916,  8858, -2916, -2916, 20973,  8858, -2916,  2270,  2272,  2273,
    8858,  4828,  2274,  8858,  2454, -2916,  1760,  2520,  2422,  2277,
     300,  1760,   427,   427,   121,   121,    64,    64,    64,  2566,
    8858,  8858, -2916, -2916, -2916, -2916,  2278, -2916, -2916, -2916,
    2053, -2916, -2916,   948,  2283, 21399, 21399,  1316, -2916,  1089,
   41802, -2916,  1375,  1316,  1470,  1645, 20973, 20973,  6214,   211,
   20973,  5421, 46324, 46324, 46324, 46324, -2916, -2916,  2607,  2516,
   -2916, -2916,   332,  1491,   989, -2916,  2280, 51256, -2916,  8858,
   28550, -2916, 51256, -2916, 51256, 51256, 51256,   535, -2916,  1387,
    1388,  2295, -2916, -2916, 51256, 51256, 51256,  2857,  2441,  2448,
     535, 51256,  2328, -2916, -2916,   490,  2496,   490,   490, -2916,
   -2916, -2916,   989, -2916,   942,  2572, -2916,  2513,    97,  2293,
    2537,  2538, -2916, -2916,  1561,  1561, -2916, -2916, -2916, -2916,
   -2916,  2550, -2916, 20973,  1334,  1760, -2916, -2916, -2916, -2916,
    2295,  1876,  2531, -2916,  2353,   -51,   -33,  2580,  2571,   184,
   -2916,  2320,  2596,  2604, -2916,  2324,  1442, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, 51256,  2528,  1790,  2569, -2916, 24340,
     989,  2163, -2916, -2916, -2916, -2916, -2916,  2402, -2916, 51256,
    1408, -2916, 20973,  2340, -2916, -2916, 23923,  2217,  1418, 51256,
    1430, 41802, -2916,  2590, -2916, -2916,  2488, -2916, -2916, 19695,
   49201,  8858, -2916, -2916, -2916, -2916, -2916, -2916, 21399,  2343,
   21399, -2916, -2916,  1063,  1063,  1448, -2916, 41802, 21399, 21399,
    1316,  1316, 20973,  1316, -2916, -2916, -2916, -2916, -2916, 20973,
   20973, -2916, -2916,  1436, -2916, -2916, -2916, -2916,   948, 20973,
   -2916,  2344, -2916, -2916, -2916, -2916, -2916,  2465,  2295, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, 20973, -2916, -2916,
     490, -2916, -2916,  1944, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, 43036,  2691, 46324,   608,  5493,  2506, -2916, -2916,  2536,
    2418, 51256, -2916, 43447, -2916,   -34,  2479, -2916,  1442, -2916,
   -2916, 46324,  2508,  2509,  2510, -2916,   989, -2916, 51256, 20973,
    1487, -2916, 50845, 16642, -2916, -2916, 46324,  1500, -2916,  8858,
   51256, -2916, -2916, -2916,  1510, -2916,   -51, -2916,  1512,    76,
     361, 21399,   170, -2916, -2916,  1063,  1063,  1316,  2053,  8858,
   -2916, -2916, -2916,  4050,  2358, -2916, 46324, -2916,  8858, -2916,
   -2916, -2916,  2014,  2014,   412, -2916,  2014, -2916,  2014, -2916,
    2691,  2702, -2916, -2916,  2611, -2916,   131,  2517, 51256,  2711,
   -2916, -2916, -2916, 51256,  2510,  1513, -2916, -2916,  2677,  2440,
   -2916, -2916,  5727,  2440, 24340, 51256, -2916, -2916, -2916,  1923,
   -2916,  1521, -2916, -2916, -2916,   208, -2916, 20973, -2916,  1876,
     989,  2026,  2529, 51256,   989,  2026, -2916, -2916,  2638, -2916,
   -2916,   151, -2916,  2521,  2523, -2916,   447,  2373,  2440, -2916,
     643, 51256, -2916, 50845,  1923, -2916, -2916,  2647, -2916, -2916,
   -2916,  2536, -2916, -2916, 51256,  2370, -2916, -2916,  2484,   430,
     430,  2425, -2916,  2658, -2916,   535,   535, 41802,  2376, -2916,
   32315, -2916,  2486, -2916,  2491, -2916, -2916, -2916,   167,  2517,
    2370,  2645, -2916,  2746, -2916,   475, -2916, -2916, 43036, 28550,
   -2916,   447,  1524, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
     816,   608,  2530, -2916, -2916, -2916,  1630,   -60, -2916, -2916,
   32315, -2916,   929, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, 43036, -2916, -2916, 40566, -2916, -2916,  1565, -2916, -2916,
    1566,  1468,  2389,  2390, -2916,   929, 32315,  2524, -2916,  1526,
   -2916, -2916
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -2916, -2916, -2916, -2916, -2916,  2599, -2916,  -990,  -320, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916,   850, -2916, -2916,  -736,   831,  1543, -2916, -2916,   622,
   -2916, -2916, -2916, -1213, -2916,   293, -2916, -2916, -2916, -2916,
   -2916, -2916,   915, -2916,   969,   514, -1329, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -1427,  -141,
      72, -2916,    71,   928,   154, -2916,  -125, -2916, -2916, -2916,
   -1098,   589, -2307, -2195,    70,  -409,  -435,  -389,  -387,  -413,
   -2916,  -269,  -344, -2915, -2370, -2916, -2916, -2916, -2916, -2916,
      84, -1419, -2916,  1344, -2916, -2916, -2916, -2916,  -139, -2916,
   -2916, -2916,   415, -2916, -2916, -2916, -1413, -2916,   899, -2331,
   -2916, -2916, -2916,  -479,  -452, -2916, -2734,   -89,   -87, -2916,
   -2916, -2916, -2916, -2916, -1062, -2916,   500, -2916, -2916, -2916,
    -428,  1368,  -472, -2916, -2916, -2916, -2916,  -705, -1443, -2916,
   -2916,  2705,   309, -2916, -2916, -1870, -1409, -2916,  -171,   685,
    1744, -1131, -2039,    50, -2916, -2916, -1563, -2916, -2916, -2916,
     820, -1403, -2916, -2916, -2916,  -331, -2911, -2916, -2916, -1103,
   -2916,   612,  1037, -2916,  1040, -2916, -1722,    98,  -893, -2364,
    -119, -2916, -2916, -2916, -2916, -2916, -1435, -2916, -1537, -1418,
   -2916,  -297, -2916, -2916, -2916,   724, -2916,   105, -2916, -2916,
   -2916, -2916, -2916, -2916,  -415,  -449, -2916, -2916, -2916,   198,
   -2916, -2916, -2916,   760, -1025,  -855,  2005, -1392, -2916, -2916,
   -2916,   924, -1837, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -1439, -2916, -2916, -2916,  1158,  2754,  -722, -2916, -2916, -2916,
   -2916, -2916, -2916,   -11, -2916, -2916,   413,    -7, -2916, -2916,
   -2916, -2916,  -475,     2,  1785,   864,    83,   -66,   -67,  -217,
     619,   665, -2916, -2916,  -199,  1101, -2916, -2916, -2916, -2916,
     686,  1607, -2916,   675,  -240, -2916, -2916,  1610, -2916,  1169,
    1188,   744, -1898,   913, -1932,   492,  -436,   -79,  -181, -2916,
   -2138, -2414,   171,  1106, -1676, -2048,  1471, -2916,  3942,  6131,
   -2916, -2916,  -972, -2916, -2916,  6529,  7330, -2916, -2916,  8907,
    9113, -2916, -1024,   379,  9811,  1659, -1174, -1472,  8148, -1875,
     631, -1469, -2916, -2916,  -725, -2916, 10510,   580, -2916, -1190,
   -2916,    67, -2916, -1530, -2916, -2916, -2916, -2916, -2916, -1520,
   -2375,  -629,   786, -2916, -2916,   872, -2916, -2916, -2916,  -719,
    -921, -1644,   789, -2916,  1271, -2916,    46,  -266,   752,   -70,
     139,  6172,  -844,   958,  -686,  7336,  -666, -1968, -1288,  1882,
   -2916,  -703, -2916,    -2,     8, -2916, -2916,  1643,  -583,  -766,
   -1649, -2916,    51, -2916,  -885,  -958, -2180,  -654, -2916, -2916,
     -52, -2916,  2013, -2916,  1178,  1631, -2916, -2916,  1182,  -815,
    -108, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
   -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,  1666,   110,
   -2916,   -64, -2916, -2916,  2928, -2916,  2680,   -62, -2916,  2312,
     -48, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
    -825,  1228, -2916,  2011, -2916, -2916, -2916,  -748, -2916, -2916,
   -2916,  1855,  -154, -2916, -2916, -2916, -1014,  1054,  2049,  -821,
    -962,  1197, -2916, -2916, -2916, -2916, -2916, -2916, -2916, -2916,
     954, -2916, -2916,   801,   961, -2916, -2916,   187, -2916, -2916,
      94,   193, -2916,  1753, -2916, -2916, -2916,   378, -2916, -2916,
   -2916,  -529,  7919,    57,   -65,   -45,   654, -2916,   111,  9844,
   -1323,  -684,   -56,  1711,  4837,  9481,   -85,   -55,   -84,  2594,
     104, -2916, -2916,  2670,  1216,   979,  -894,  5872,  1459,  2139,
    3533,  -718,  -834,  2063,  -502, -1318, -2916,  3035
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1797
static const short yytable[] =
{
      69,   813,  1030,  1882,   774,   700,  1149,   311,   310,  1548,
      70,   914,   325,   361,  2042,  1007,  1000,  1010,  2061,   903,
    1014,  1454,  1366,  1050,  1517,   693,   327,   987,   700,  1040,
     877,  1528,  1607,  1975,   697,   701,  1664,  1086,  1655,  1288,
     783,   909,   855,  1423,  1811,   694,  2509,   783,   693,  1074,
    1130,  1447,  1132,  1079,  1134,  1009,  1011,   697,   701,  1295,
    1135,  1335,  1103,   305,  1976,  2215,  1093,   306,   694,  2615,
    1015,  1725,  1116,  2474,  1033,  2033,   308,   736,  1380,  2806,
    2678,  1041,  2093,  2779,  1864,  1108,  1370,  2375,   783,  2648,
    1078,  1112,  1515,  1129,  1995,   779,  1824,   962,  1519,  2466,
    2468,  2775,  1996,  2245,  1529,  1124,  1082,  2228,  1997,  1113,
    1088,  2037,  1998,  1117,  1560,   872,   873,  1143,  1999,  1094,
    1405,  1121,   872,   873,   872,   873,  1111,  1706,  2451,  2000,
    1340,   352,  1363,   579,   352,   700,  2290,  2292,  2258,  1272,
    2545,  1360,  2262,  2401,  2402,  2403,  2404,   352,  1344,  1345,
    1620,  1621,  1576,  1277,  1666,   693,  1286,   831,  1671,  1367,
    1555,   913,   311,   310,   697,   701,  1561,  1968,  1269,  -822,
     352,  2429,  1527,  -996,  1640,   694,  1570,  1571,   355,   831,
    1674,   355,  2384,  1671,   996,  -825,  -991,   360,  1555,   976,
    2882,  1278,  2359,   586,   355,   737,  2086,  2545,  2155,  2705,
     608,  1363,  1275,   704,  3023,  1674,  1164,   596,  1590,  1595,
    2519,  1830,  1628,   704,  2206,  1392,  1840,   355,   305,  2039,
   -1144,  1555,   306,  1831,  1348,  2045, -1144,  2124,   984,  2240,
     848,   308,  -822,  1131,  2160,  2193,  1700,  2501,  2012,  1785,
     608,  2194,  3228,  1101,  1136,  2312,  2545,  1451,  -825,   704,
     746,  2012,  2544,  3318,  2963,  2560,  3343,   958,   608,   704,
     926,  2160,   704,  1454,  1289,  2075,   704,  3024,  1043, -1588,
     704,  1146,   287,  1133,   927,   843,   940,   352,  -281,  2505,
    1050,  1917,  2349,  1832,  2545,  1703,  2585,  2586,  1786,   206,
    2385,   882,   704,  1953,  1835,   953, -1160,  2753,  3210,  2175,
     954, -1590, -1160,  1393,  1838,  1763,  1284,   704,  3264,   119,
     862,  3279,   843,  1419,   927,  2988,   881,  1959,  1655,  1048,
    2017,  3211, -1689,  1049,   355,  1723,  3249,   123,  1704,  1731,
    1161,  1918,  1459,   941,  1290,  1409,  1841,  1466,  1764,  2506,
    2620,  2738,  1147,  3291,  2003,  2621,  2622,  2623, -1714,  1044,
    1461,  1954,  3296,   712, -1587,   713,  1463,  2624,  2625,  2626,
    1949,  2627,  2628,  2629,  2076,  1458,  1452,  2630,  2631,  2632,
    1787,   883,  2965,  2313,  1556,  2706,  2545, -1643,  3344,   352,
    1516,  1102,   942,  1765,  3025,   943,  1324,   228,  2241,  1346,
    3204,  3319,  2013,   206,  1534,   597,  2545,  1842,  1537,  2718,
    1833,  2547,  1556,  2748,  2176,  3133,  2502,  2004,  2177, -1728,
    1550,  3038, -1750,  3040,  2707,  2368,   352, -1691,   716,   352,
    2293,  2090,  2091,  1410,  2948,   985,   355,   287,  1944, -1586,
    2500,  3250,  2099,  2101,  2020,  1556,  3026,  2545,  2989,  2547,
    2178,  1549,  1596,  2095,  2116,  2117,  2350,  1140,  2360,   717,
      49,  1591,  1701,   577,  1620,  1621,  1615,  1147,  2133,  2135,
    1588,  2548,  1640,   355,   944,  2226,   355,   963,  1378,   952,
    -996,  1359,  -822,  -996,  -822,  1667,   704,  -201,  1608,  1394,
    1834,  2939,  2940,  -991,  2430,  2431,  -991, -1144,  -825,  3057,
    -825,  1592,  1775,  1557,  -996,  2716,  2717,  1960,  2558,  2548,
    2161,   961,  2195,  2545,  2722,   964,  2579,  -991,   577,  1628,
    2723,  1969,  2363,  1850,  1800,  2212,  1695,  1473,  2077,   577,
     577,  2838,  1718,  1719,  1360,  1367,  1969,  2597,  1805,  1927,
    1050,  2547,  2546,  2078, -1689,  1864,   945,  2266,  1692,  1693,
    1694,  1695,  3302,  3280,  1016,  2179,  2644,  2048,  1978,  1035,
    1037,  2547,  2555,  2556,  2557,  2558,    49,  2033,  2814,   577,
   -1714,  2747,  2818, -1160,   946,   577,  2823,  2683,  2639,  2684,
      52,  3099,  1830,  2503,    49,  1411,  2005,   577,   827,  1950,
    1752,  2646,    52,  1325,    53,  2549,   714,  3340,  1992, -1643,
    1332,  1979, -1797,   856,  1713,  2550,  2551,  2552,  2047,  2553,
    2554,  2555,  2556,  2557,  2558,   577,  1107,  2050,  1788,  3236,
      52,  2548,   980, -1588,  2120,  2121, -1588, -1588,   827,  1840,
    3128, -1728, -1588,  2549, -1750,  3164,   700,  1104, -1248, -1691,
    3324,   365,  1714,  2550,  2551,  2552,  2633,  2553,  2554,  2555,
    2556,  2557,  2558,  3285,  1832, -1590,   693,  3269, -1590, -1590,
    -918,  1993,  1828,   998, -1590,   697,   701,  2806,  2547,   857,
    2730,  1459,    49,   920,   608,   577,   694,   927,  3137,  1980,
      52,  2866,   958,   783,  2870,  2871,  2872,  2873,  2874,  2875,
    2876,  2877,  2878,  2879,  3129,  1397,  1883,  3242,  1847,    69,
    1789,  2974,  2975,  2976,  2977,  2978,  1030,  3303, -1587,    70,
    1458, -1587, -1587,  2867,  1126,  2068,   821, -1587,   704,   704,
    1938,     3,  2737,   921,  2476,  2477,  2634,  1981,  2548,  1837,
    2804,  1043,  2904,  2905,   822,  3243,   748,   958,  3187,  2553,
    2554,  2555,  2556,  2557,  2558,  2549,  1300,  2033,  3286,  2949,
    2065,  1784,  2504,  1838,  1549,  2550,  2551,  2552,  2642,  2553,
    2554,  2555,  2556,  2557,  2558,  3325,  3304,  1398,  2511,  1848,
    1951,  1833,  2603,  2283,  1956,  2963,  1267,   706,   352,  1384,
    2369,  1807,   352, -1586,  2685,  3305, -1586, -1586,   958,   759,
     922,  1825, -1586,  1792,  1399,  1982,  1793,  1983,   747,  1964,
    2553,  2554,  2555,  2556,  2557,  2558,   716,  1727,  1785,  1072,
     750,  1929,  1044,  3292,   872,   873,  3287,   872,   873,   858,
     859,  1720,  3293,  2868,   831,   355,   831,  1268,   831,   355,
    2950,   787,  2869,  2951,   831,   831,  2964,   717,  2328,   761,
    3018,  1008,   608,  1012,  2284,   586,  2937,   704,  1032,   586,
     704,  1834,  2549,   704,   704,  1008,   586,  1786,  1296,   841,
    2959,  2960,  2046, -1797, -1797,  1366,  2553,  2554,  2555,  2556,
    2557,  2558,  1721,  1839,   704,  1794,  1991,   608,   835,  1008,
    1484,   586,  1930,   923,   905,   586,  1090,   704,  2062,  3028,
     704,  2545,  1008,  2965,   586,   718,   878,  1562,  2985,  2837,
    1728,   704,   704,   152,  2059,  2895,  2063,  2064,   844,  2066,
     704,  1400,   749,   608,    49,  1152,   704,   577,  1539,  1443,
     704,   704,  2249,  1401,   811,   704,   704,  3031,   704,  1370,
    1030,  1008,  3035,  2835,  2331,  2332,  3037,  1402,  2838,  1787,
    1165,  1830,  3271,  1453,  1403,  2329,  1382,  2330,  1917,   704,
     704,  1280,  1282,  1831,  1333,   849,   704,  2679,  3294,   767,
    1540,   768,   577,  2574,  1334,  1444,   169,    52,  1383,  2487,
     759,   352,  2590,   880,   700,  1864,   755,   704,  1312,   704,
      69,    69,  1157,    69,  2588,  1313,   152,  1404,  1333,  -854,
      70,    70,  1995,    70,   693,  1459,  2852,  2033,  1334,  2158,
    1996,  2033,  1539,   697,   701,  2033,  1997,   704,   608,   704,
    1998,  2986,  1283,  1832,   694,  1413,  1999,   879,   355,   914,
     761,  3169,  2709,  2710,   579,   579,  1314,  2000,  2616,  2617,
    3063,  3064,  2864,  2323,  1313,  1541,  2326,  2327,  1709,  1524,
    2514,   868,  1710,   759,  2832,  -854,  2547,   206,  2513,   169,
     901,  2102,  2103,  2104,   902,  1126,  2883,  1525,  3275,  2115,
    -562,  1415,  2987,  2118,  2119,   226,    49,  2591,   227,   577,
    2123,  2592,   311,  1568,    52,  1314,    53,  2231,  2979,  2139,
    1542,  2140,  1332,   206,   586,   586,  -854,   716,  1353,  3300,
     933,   311,  1594,   761,  2153,  3109,  2154,  3111,  3112,   152,
    3002,  3267,  3331,   186,  2256,  2843,  2548,   743,  1971,   704,
    3115,  1613,   704,   934,   707,   704,   352,   911,   717,  1541,
    3314,   716,  1671,  2470,   935,   708,  1917,   917,  1564,  1630,
    1833,  1924,  1565,  1095,  3003,   222,  3297,  1939,  2410,  1008,
     767,  1566,   768,   918,  1674,   228,   845,  1137,  3161,  2545,
    1543,  1458,   717,  2828,   853,  2830,  2831, -1388,  1096,  1658,
    3314,  3116,   169,   355,  1542,   941,   206,   930,  2593,  1662,
    1151,  2268,  1070,  3209,  -290,  1671,  2594,     9,  2264,  1650,
    1651,   228,  2267,  1554,   704,  1413,  3314,   956,   704,   907,
    2849,   200,   704,  3170,  1097,  3172,  2298,  1674,   704,  2281,
    1098,   936,   709,  3175,  3176,  1987,  1008,  1414,  2309,  1990,
    1834,  1652,  1422,   767,   942,   768,   186,  1972,   222,  2010,
    1008,  1536,  2315,   704,   769,   967,  2318,  2297,  2649,  2299,
    2549,  1415,  1445,   772,  1543,   200,  1008,   970,  2802,  1048,
    2550,  2551,  2552,  1049,  2553,  2554,  2555,  2556,  2557,  2558,
    3189,  1755,  1755,   937,  1755,  1361,  1446,  1362,   704,  2372,
    2373,  2320,  2376,  2377,  3332,  1095,   693,   704,   843,   577,
    1085,  1934,   704,  1389,   691,   697,   701,  1678,  1679,   206,
    2457,   986,  1605,  2980,  3086,   704,  2287,  1610,  2353,  1665,
    2777,  2356,  2288,  2358,  1425,  1333,   944,  1333,  1333,  1802,
    1670,  1115,   980,  1971,  2547,  1334,  3235,  1334,  1334,   700,
     938,   710,  1391,   872,   873,  2515,  1426,  1389,  -976,    49,
    1814,  -976,   577,  2516,  1682,  1050,  1097,  2316,  1777,   693,
   -1797,   222,  1778,  1818,   927,  2458,  1424,  1615,   697,   701,
    1795,   997,  1626,  2479,  1448,  1282,  2380,   872,   873,   694,
    1796,  -996,  2381,  2931,  -996,  -970,  2033,  1042,  -970,  2459,
     941,  2033,   831,  3016,  2548,  2033,    69,  1612,  1973,   228,
      69,   872,   873,  2640,  2460,  -996,    70,   228,   988,  1632,
      70,   989,  2461,  1650,  1651,   914,  1052,  2848,   352,   352,
     352,   608,   608,   990,   991, -1251,  2392,  2890,   700,  1440,
    1671,  2396,  1671,  2462,   579,  1283,  2884,  2885,  1386,   942,
    1743,  1743,  1972,    49,   992,  1654,   577,   993,   693,  2458,
    1751,  1441,  1674,  2491,  1674,  1868,  1429,   697,   701,  1675,
    1387,  3062,  1430,   200,  2732,   355,   355,   355,   694,   352,
    2167,  2491,  2498,  2459,  1076,  2083,   352,  1869,  2499, -1003,
    2701,   352, -1003,  2545,  1388,  1801,  2702,  2703,  2820,  1778,
    2168,  2689,   608,  2761,   586,  1030,  2461,  2896,  1431,  2463,
    2670,  1870,  1333, -1003,  1077,  1690,  1691,  1692,  1693,  1694,
    1695,  1432,  1334,  2690,  2512,  2243,   355,  2027,  2549,  1778,
    2513,   944,  2671,   355,  -973,   704,  2252,  -973,   355,  2763,
    1778,  1087,  2553,  2554,  2555,  2556,  2557,  2558,  1099,  1433,
    3042,  1940,   127,   128,  1434,  1389,  2672,  1435,  1643,  1941,
    2653,  2517,  3091,  2573,    49,  2575,  2576,   577,  1690,  1691,
    1692,  1693,  1694,  1695,  1080,   913,  1081,   994,  1677,  1942,
     352, -1588,  1032, -1590, -1588,  1920, -1590,   798,  1669,  1925,
    2169,  1928,  2464,  2463,  2695,  2170,  2545,  1678,  1679,  2171,
    3152,  2655,  1100,  1973,  1019, -1594,  1110, -1595,  3200, -1587,
    3068,  1083, -1587,  1084,  1020,  1021,  1022,  2033,  1023,  1024,
    1025,  1026,  1027,  1028,  2054,   226,  1008,   355,   227,  1122,
    1008,  1974,  1048, -1592,  1282,  1019,  1049, -1586,   700,  2664,
   -1586,  2927,  1125,   577,  1682,  1020,  1021,  1022,  2547,  1023,
    1024,  1025,  1026,  1027,  1028,  1140,  2523,  1683,   693,  3126,
    2165, -1591,  2513,  1144,  2767,  1454,  3182,   697,   701,  1429,
    1145,  2440,   831,   831,   831,  1430,  2697,  2698,   694,    49,
     831,   586,   577,   704,   831,   831,  2641,  2525,  1153,  1397,
    2686,   831,  2768,  2513,  1283,    71,  2172,  1638,  1639,  2528,
     831,  2769,   831,  2219,  2173,  2529,  1436,  2653,  2548,  -961,
     704,  1431,  -961,  -959,  2533,   831,  -959,   831,  1008,    49,
    2513,  1158,   577,   704,  1432,  -962,   577,    52,  -962,    53,
    1437,    52,  2113,    53,  2222,  1332,  1159,   577,  1036,  1332,
    1160,   704,    52,   704,   704,  1162,   704,  1964,   927,  2534,
     827,  2547,  1433,  2074,   958,  2513,  1161,  1434,  2538,  1073,
    1435,  1398,  2054,  2562,  2539,  1163,  2247,   843,  2247,  2513,
    2088,  2545,  2770,  2619,  1166,   578,  2650,  2780,  1167,  2513,
     352,  1686,  1549,  2781,  2961,  3069,  2787,  1048,  1399, -1254,
     700,  1049,  2788,  3022,  1287,  1690,  1691,  1692,  1693,  1694,
    1695,  1459,  2792,  3240,  3241,  3152,  1032,  3244,  2793,  3245,
     693,  2548,  2841,  2656,  2657,  2441,  2898,  2920,  2842,   697,
     701,  -960,  2513,  2513,  -960,  2022,  2023,   355,  1650,  1651,
     694,  2220,  2549,  2062,  2921,  2941, -1006,  1650,  1651, -1006,
    2513,  2793,  2550,  2551,  2552,  1333,  2553,  2554,  2555,  2556,
    2557,  2558,  1148,   352,  2736,  1334,  2392,  3353,  1150,   914,
    1652,  1333,  1291,    69,  3066,    69,  1292,   704,  1156,  2858,
    3067,  1334,   578,    70,  1293,    70,  3097,  3098,  2970,  2971,
    1650,  1651,  2793,  2793,  2836,  2105,  2545,   352, -1006,   352,
    3234, -1006,  2739,  2740,  2741,  2742,  2743,  3158,  3142,  3143,
     355,  2411,  2973,  1549,   579,  2442,  2850,  3163,    52,  2225,
      53,  1150,  1654,  2781,   704,  1299,  1298,  1401,  1300,  3165,
    2739,  2740,  2741,  2742,  2743,  2781,  2547,  1306,  2744,  1602,
    1603,  1402,   352,  2351,   355,  2549,   355,  3173,  1403,  3178,
    1301,  3327,  2106,  3067,  1303,  2550,  2551,  2552,   831,  2553,
    2554,  2555,  2556,  2557,  2558,    49,  1333,  1304,   577,  1333,
    1333,  1307,  -830,    52,   586,    53,  1334,  1353,  1305,  1334,
    1334,  3083,  1884,   704,  -830,  1310,  3223,  1756,  1758,   355,
    1762,  1404,  3224,   586,   704,  1318,  2548,   586,   608,  3230,
    1465,  2107,   704,   958,  2108,  1549,  2859,   914,   704,  3232,
    1322,  3233,  3259,   704,   586,  2781,  2862,  2842,  1596,  2450,
    3268,  1323,  -830,  3329,  1326,  3361,  1549,   831,  1327,  3330,
    1885,  3330,   831,  1757,  1757,  1328,  1757,  1886,  1887,  1810,
    -830,  1362,   586,   704,   586,   704,   704,  1329,   704,  2305,
    1330,  2547,  2741,  2742,  2743,   704,  2607,  2609,  2608,  2610,
    2658,  2659,  2612,  2613,  3354,  1303,  3355,  -822,  1331,   704,
    1460,  1338,  2379,   704,  1888,  1341,   586,   704,   704,  1347,
    1349,  -830,  1309,  2109,  1311,  2819,  1908,  2822,  1343,  -830,
    2334,  2335,   704,  1346,   704,   704,  2342,   704,   704,   704,
     704,  1354,  1371,   586,   704,  1372,   586,   704,   586,  3190,
    1374,  2548,  1889,  1530,  1531,  1532,  1890,  1381, -1594, -1595,
    2549, -1592, -1591,  1396,  1909,  1008,  1008,  1384,  1407,  2438,
    2550,  2551,  2552,  1397,  2553,  2554,  2555,  2556,  2557,  2558,
    2393,  1421,  1418,  1427,  1420,  3191,  1442,  1450,  1449,  1462,
    1464,  1469,   831,  1891,  1471,  2110,  1473,  1662,   226,    49,
    1475,   227,   577,  1150,   843,  3192,  1512,  1513,  1892,  1893,
    2165,  1894,  1895,  1389,  1896,  1520,  -154,  1522,  1533,  2417,
    3193,  1150,  -830,  1544,  2428,  1546,  2435,  1549,  1551,  2606,
    1910,  1552,  1553,  1600,  3194,  1604,  1606,  1611,  2455,  2027,
    1619,  1897,  2455,  2469,  1622,  1398,  1623,  1624,  1625,  3195,
    1629,  2969,  2305,   228,  1631,  1634,  2392,  2392,  2392,  2392,
    2392,  1635,   704,  1636,  2982,  1637,  1642,  1726,  1645,  1646,
    1898,  1911,  1399,  1912,  1303,  2549,  1745,  1596,   586,  1647,
    1648,  1649,  1494,  1913,  2491,  2550,  2551,  2552,  1656,  2553,
    2554,  2555,  2556,  2557,  2558,  1657,   586,  1705,  1746,  1312,
    1753,  1776,  1899,  1783,  1900,  1030,  1790,  1791,  1797,  1799,
    1363,  1806,  1812,  1803,  1813,  2054,  1547,   831,  1815,  1333,
   -1531,   594,  1817,  3342,  3196,  1822,  1901,  1823,   609,  1334,
    1825,  3197,  1826,  1902,  1019,  1827,  1903,  1843,  1844,  1845,
    1846,  1914,  1872,  1871,  1020,  1021,  1022,  1873,  1023,  1024,
    1025,  1026,  1027,  1028,  1874,  1747,  2440,  3198,  1875,  1877,
    1876,  1878,  1905,  2581,  1906,  1907,  1917,  1931,   609,  1921,
    1915,  1922,  1923,  1926,  1397,  1932,  1933,  1935,  2129,  1937,
    3093,  1936,  1955,  1947,  2440,  1952,   609,   609,  1849,  1400,
    3100,  1032,  3102,  1957,   609,  2810,   700,  3215,   594,  1958,
    1965,  1401,  1397,  1626,  1615,  1967,  1977,   757,   831,  1632,
    1643,  1989,  2002,  2008,  2015,  1402,   693,  2018,   594,  2019,
     594,  2021,  1403,  1333,  2025,   697,   701,  2038,  2035,  1333,
    1333,  2041,  1743,  1334,    71,   609,   694,  1751,  2051,  1334,
    1334,   783,  2052,  3157,  2057,  2058,  1398,  2067,   704,  2070,
    2071,  2081,  2085,  3157,  3096,  2094,  2095,  2457,  2137,  1671,
    2138,  2159,  2164,  2151,  2152,  1404,   608,  3105,  2180,   311,
    2794,  2182,  2206,  1399,  1398,  2217,  2216,  2218,  2223,  2221,
    1333,   921,   311,  2809,  2236,   831,  2435,   831,   914,  2027,
    1334,   578,  2237,  2027,  2242,  1969,  2491,  2027,  2749,  2232,
    2441,  1399,  2250,  2251,  2255,   586,   704,   704,  2912,  2913,
    2914,  2915,  2458,  2263,  2269,  2271,  2273,  1671,  2062,  2274,
    2275,  2277,  2279,   704,   704,  2282,  2285,  2286,  2441,  2296,
    2294,   311,  2844,  2295,  2307,  2306,  2459,  2308,   352,  1674,
      49,  2310,  2319,  3221,  1675,  2311,  2324,  2317,  2337,  2361,
    2355,  2460,  2754,  2364,  2367,  2365,  2366,  2374,  2382,  2461,
    2387,  2394,  2395,  2398,  2399,  2407,  2413,  2414,  2436,  2437,
    2447,  2448,  2456,  2472,  3231,  2449,  2475,  1713,  2305,  2492,
    2462,  1671,  2086,  2486,  2526,   355,  2508,  1821,  2507,  1147,
    1400,  2801,  1282,  2510,  2531,  1672,  2527,   578,  2513,  2589,
    2393,  2568,  1401,  1674,   609,  2530,  3032,  2532,  1675,  2535,
    2043,  2044,  2536,   704,   704,   704,  1402,  2540,  1400,  2543,
    3266,  2569,   578,  1403,  2561,  2567,  1881,   831,  2570,  2584,
    1401,  2571, -1457,   578,   578,  2578,  2582,   831,  1662,  2583,
    2595,  2602,  1150,  2605,  1402,  2618,  2463,  2661,   704,  1676,
    2645,  1403,  1283,  1677,  2080,  2663,  2665,  1362,  2667,  2668,
     704,  2455,  2669,  2673,  2812,  2676,  1404,  2680,  1948,  2805,
    2681,  2677,  1678,  1679,  2692,  2711,  2712,  1930,  2826,  2720,
    2721,  1793,  2714,  2746,  1030,  1680,  2719,  1671,  2774,  2734,
    2735,  2776,  2798,  2783,  1404,  2745,  2785,  2789,  2790,   586,
    2811,  2797,  2808,  2813,  2786,  3326,   578,   578,  2815,  1674,
    2074,  3033,  2816,  1676,  1675,    71,    71,  1677,    71,  1682,
    1986,   586,  2824,  1364,  2827,  2833,  2829,  2840,  2834,  2464,
    2846,  2847,  1683,  2853,  2893,  1008,  1678,  1679,  3352,  2856,
    2564,  1612,  2545,  2563,  1666,  2887,  2888,  2889,  2900,  1680,
    2909,  2918,  1821,  2924,  2922,  2932,  2923,  1881,  2204,    69,
    2926,  2934,  2935,  2936,  2942,  2943,  2944,  2930,   354,    70,
    2945,   354,  2946,  2955,  2962,  2956,  2957,  2983,  2958,  2972,
    1681,  2995,  2997,  1682,   354,  2990,  2999,  2587,  3005,  2992,
    1685,  3010,   609,  3011,  3014,  3019,  1683,  3020,  1684,  3029,
    3039,  3036,  3308,  3309,  3046,  3049,  3059,   354,  3050,  3052,
    2230,  3053,  3054,  3056,  3058,  3060,  3079,  3061,  3089, -1797,
    3080,  3103,  3107,  1677,   311,  3012,  1795,  3110,  3104,  3117,
    3120,  2964,   831,  3121,  3122,  1505,  1796,   831,   831,   831,
     831,   831,  1678,  1679,  3123,   831,  3130,  3131,  2027,   971,
    3134,  3136,  3139,  2027,  1685, -1797,  1686,  2027,  2129,  3138,
    3140,  2129,  3141,  3148,  3146,   578,  1687,  1688,  1689,  1505,
    1690,  1691,  1692,  1693,  1694,  1695,  3156,  2156,  3160,  3166,
    3167,  3171,  3186,  3185,  3201,  3208,  2989,  2435,  2435,  1682,
    3206,  3213,  2129,  2129,   874,  3216,  3217,  3238,  3247,  3218,
    3248,   874,  1683,   874,  3256,  3260,  3251,  3261,  3278,  3274,
    3281,  3290,  3283,  3298,   354,  2793,  3301,  3280,  3279,  3316,
    1686,  3311,   704,   704,  3317,  3322,  3323,  3356,   916,  3357,
    1687,  1688,  1689,  1744,  1690,  1691,  1692,  1693,  1694,  1695,
    3343,  2409,  3341,  2643,  2150,  2302,  2352,  2333,  3017,  2708,
    2393,  2393,  2393,  2393,  2393,  3001,  2652,  3007,  2947,  3127,
   -1797,  2675,  3299,  3013,  3321,  3284,  3282,  3307,  1671,  3214,
    3258,   578,  3008,   704,  2011,  3145,  2397,  3359,  3346,  3119,
    3118,  2726,   578,  3328,  1988,  3360,   851,   594,  3047,  2493,
    1674,  1589,  2417,  3265,  2334,  1675,  2291,  2334,  2289,  3009,
    2682,  3021,  3155,  3246,  2435,  3334,  3358,  1294,  2405,  2305,
    2229,   814,  2845,  2478,  1567,  3043,   354,  2660,  2651,   609,
     609,  2054,  2455,  1773,   704,  1771,  1686,   578,   311,  3132,
    1364,  3084,  1364,  1364,  2239,   831,  2417,  2227,  3041,  2452,
    1690,  1691,  1692,  1693,  1694,  1695,  1730,  2408,   831,   586,
    2614,   609,  3000,   354,  2821,   594,   354,   594,  3162,   594,
    1966,  2892,  2731,  2600,  2598,   594,   594,  3065,  2520,  2027,
    2418,  3270,  2205,  3090,   609,  3088,  2761,  2439,  2647,  3168,
    1019,  3048,  1535,  1356,  2254,  2253,   578,  1808,  2762,  1782,
    1020,  1021,  1022,   594,  1023,  1024,  1025,  1026,  1027,  1028,
    1676,    71,   322,   928,  1677,    71,  2244,   979,  1599,  1379,
    2257,  2484,  2763,  3114,  2764,  1350,  3082,  2638,   594,  2485,
    3044,  1712,  2925,  1678,  1679,   609,   609,  3045,   950,   594,
     594,  2480,  1779,  2261,  2053,  1358,  1680,    76,  2225,     0,
    1505,  1032,     0,  3092,     0,   586,   704,   704,   752,     0,
       0,     0,     0,  1821,     0,   586,   704,   586,  1881,   753,
       0,     0,  3106,     0,     0,     0,  1505,  1681,     0,     0,
    1682,  3154,     0,  2386,     0,  2765,     0,     0,   754,  1505,
       0,  3180,     0,  1683,     0,   594,     0,     0,     0,     0,
       0,  3181,     0,     0,     0,   755,     0,  -457,     0,   311,
    2809,     0,   594,   594,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   756,     0,  3351,     0,     0,     0,   757,
       0,  1505,     0,     0,     0,   704,     0,     0,     0,     0,
    3153,   758,  2766,     0,     0,     0,     0,  2767,     0,     0,
     704,  1685,     0,     0,  2473,     0,     0,     0,  1505,     0,
    3041,     0,     0,     0,     0,     0,     0,     0,  2611,     0,
    -576,   586,   759,     0,     0,  2768,   760,     0,     0,     0,
       0,     0,     0,  1505,  2769,     0,   578,  2129,     0,  -562,
    2129,  2129,  2129,  2129,  2129,  2129,  2129,  2129,  2129,  2129,
       0,     0,     0,     0,     0,     0,     0,  3220,     0,     0,
       0,  -387,     0,     0,     0,  1505,     0,  1686,     0,     0,
    1505,     0,   761,     0,     0,     0,     0,  1687,  1688,  1689,
       0,  1690,  1691,  1692,  1693,  1694,  1695,     0,  2129,  2129,
       0,     0,     0,     0,     0,     0,     0,     0,   788,     0,
       0,     0,  2305,     0,  2334,  2770,     0,     0,     0,   789,
       0,     0,     0,   311,     0,   762,     0,   763,     0,  1008,
       0,   594,     0,  1008,  1008,  3350,     0,     0,   790,     0,
       0,   704,     0,     0,   578,  -387,     0,     0,     0,  1575,
    1053,     0,  1579,   831,   831,     0,     0,   791,   311,     0,
       0,  3272,   609,     0,   764,  3276,     0,     0,  -576,     0,
     765,     0,     0,   792,     0,   354,     0,     0,     0,   354,
    1054,     0,     0,     0,     0,     0,     0,     0,     0,   704,
       0,   793,  1055,     0,   704,     0,     0,     0,     0,  1056,
    1505,   766,   767,     0,   768,  3153,  1008,     0,     0,     0,
       0,     0,     0,   769,     0,  1057,     0,   770,   771,     0,
     794,     0,   772,     0,  2435,     0,   795,   773,     0,     0,
       0,     0,     0,  1058,     0,     0,     0,   594,     0,   796,
       0,  2778,   704,   578,  1008,     0,     0,  2784,   594,     0,
       0,     0,     0,     0,     0,  2435,     0,     0,     0,     0,
       0,     0,  1059,     0,  2129,     0,     0,     0,     0,     0,
       0,  3315,     0,     0,  1708,     0,     0,     0,     0,   609,
     609,  1060,  2691,     0,  2694,     0,     0,     0,     0,     0,
    1032,     0,     0,   594,     0,     0,   594,     0,   594,   594,
       0,     0,     0,     0,  1061,     0,     0,     0,     0,     0,
    2704,  3315,     0,     0,     0,   797,   578,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1364,     0,    71,     0,
      71,     0,     0,     0,     0,   798,  1150,  3315,     0,     0,
    2715,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     609,     0,   594,   874,   799,     0,   874,  1062,   800,     0,
     801,     0,     0,   594,     0,   802,     0,     0,   354,     0,
       0,     0,     0,     0,     0,     0,     0,   798,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1505,  1505,     0,
     803,   804,     0,  2782,     0,     0,  2129,  2129,     0,     0,
    1063,     0,  1064,   805,  2704,     0,     0,  1065,   806,     0,
    2314,     0,     0,     0,     0,     0,     0,   807,     0,     0,
       0,     0,  1671,     0,     0,     0,   808,     0,     0,   719,
       0,     0,  1066,     0,     0,     0,  1672,     0,     0,     0,
    2916,  2917,     0,     0,  1674,  1067,     0,     0,     0,  1675,
    1068,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   578,     0,  1069,     0,
     578,     0,     0,   594,   578,     0,  1505,   356,   720,     0,
     356,  1505,  2391,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   610,   356,   721,     0,  1505,     0,  2857,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1671,   722,   354,     0,  2412,   356,     0,     0,     0,
       0,  2865,     0,     0,     0,  1672,     0,     0,     0,     0,
       0,   578,   610,  1674,     0,     0,     0,     0,  1675,     0,
       0,   723,   594,     0,     0,     0,     0,   724,  2886,     0,
     610,     0,     0,     0,  1676,     0,     0,     0,  1677,  2129,
     725,  2129,     0,     0,     0,     0,     0,  1505,     0,  2129,
    2129,  2901,     0,     0,  2981,     0,     0,  1678,  1679,     0,
       0,     0,   726,     0,  1708,  2056,     0,     0,     0,     0,
    1680,     0,     0,     0,     0,     0,     0,  2991,     0,     0,
       0,     0,     0,   875,     0,  2996,     0,     0,     0,     0,
     875,     0,   875,     0,     0,     0,     0,     0,     0,     0,
       0,  1681,     0,   356,  1682,     0,     0,     0,     0,     0,
       0,     0,     0,   594,   594,   594,   727,  1683,     0,  1684,
     594,   594,     0,  1676,     0,   594,   594,  1677,     0,     0,
       0,     0,   594,     0,     0,     0,     0,     0,     0,     0,
       0,   594,     0,   594,     0,     0,  1678,  1679,     0,     0,
       0,     0,  2129,     0,     0,   728,   594,     0,   594,  1680,
       0,   729,     0,  2952,     0,     0,   730,     0,     0,     0,
       0,     0,     0,     0,     0,  1685,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1575,
    1681,   731,   732,  1682,     0,  2214,     0,     0,     0,     0,
       0,     0,     0,  2056,   733,   356,  1683,     0,  1684,   734,
       0,     0,     0,     0,  1364,     0,     0,     0,   735,   594,
    3075,  3076,  3077,  3078,     0,     0,     0,     0,     0,     0,
    2994,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1686,   356,     0,     0,   356,     0,     0,     0,     0,
       0,  1687,  1688,  1689,     0,  1690,  1691,  1692,  1693,  1694,
    1695, -1794,     0,  1945,  1685,   354,   354,   354,     0,     0,
       0,     0,  1946,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1671,     0,   594,     0,     0,     0,
       0,     0,   594,     0,     0,     0,     0,  1505,  1505,     0,
    1505,   609, -1794,     0,  2696,     0,  1674,     0,     0,     0,
    2699,  1675,  2700,     0, -1794,  1505,   354,  1505,     0, -1794,
       0,     0,     0,   354, -1794,     0,     0, -1794,   354, -1794,
    1686,     0,   874,     0,     0,     0,     0,     0,     0,     0,
    1687,  1688,  1689,  1505,  1690,  1691,  1692,  1693,  1694,  1695,
       0,     0, -1794,     0,     0,     0,  2901,     0,   578,   578,
    2537,     0,     0,     0,     0,     0,   874,   578,     0,     0,
   -1794,     0,     0,  1505,     0,  1364,     0,     0,     0,     0,
       0,     0,  2391,     0,  2596,     0,     0,     0,     0,   594,
     874,  1505,     0,  2750,   578,     0,     0,   594,     0,     0,
     594,   594,     0,  1671,     0,     0,     0,     0,     0,     0,
       0, -1794,     0,     0,     0,     0, -1797,   354,     0, -1794,
    1677,     0,     0,     0,     0,  1674,  1505,     0,     0,     0,
    1675,  3203,     0,   578,   578,     0,   610,  1505,     0,  1678,
    1679,     0,   594,     0,     0,     0,   594,     0,     0,  1150,
     594,  1505, -1797,     0,     0,     0,     0,     0,   594,     0,
       0,     0,     0,   594,  3229,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1671,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1682,     0,     0,     0,
    1672,   849,     0,     0,  3239,     0,     0,  2782,  1674,  1683,
       0,     0,     0,  1675,     0,     0,     0,   594,     0,     0,
       0,     0, -1794,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3174,     0,     0,     0,     0,     0,     0,
   -1794,  1505,     0,     0,     0,  1676,     0,     0,     0,  1677,
     609,  1575,     0,     0,  2483,     0,  1579,     0,     0,     0,
       0,     0,     0,     0,  1505,     0,     0, -1797,  1678,  1679,
       0, -1794,     0,     0, -1794, -1794, -1794,     0,     0,     0,
       0,  1680,     0,     0,     0,     0,   578,     0,     0,     0,
       0,  1505,     0,   594,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   356,     0,     0,     0,   356,     0,
       0,     0,  1006,     0,  1505,  1682,  1006,     0,  1676,     0,
       0,     0,  1677,     0,     0,     0,     0,   354,  1683,     0,
       0,     0,     0,  1686,     0,     0,     0,     0,     0,     0,
       0,  1678,  1679,     0,     0,  1006,     0,  1690,  1691,  1692,
    1693,  1694,  1695,     0,  1680,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    71,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1105,     0,
       0,  1006,     0,     0,     0,  1681,  1685,  1006,  1682,     0,
    1671,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     354,  1683,     0,  1684,  1672,     0,     0,     0,     0,     0,
       0,     0,  1674,     0,     0,     0,  2056,  1675,   594,     0,
     594,     0,     0,   578,   578,     0,  1505,     0,     0,     0,
       0,     0,     0,     0,   354,     0,   354,     0,     0,     0,
       0,     0,  2391,  2391,  2391,  2391,  2391,     0,     0,     0,
       0,     0,  1686,  3310,     0,     0,     0,     0,     0,  1685,
       0,     0,     0, -1797, -1797,     0,  1690,  1691,  1692,  1693,
    1694,  1695,     0,     0,     0,     0,  1671,  1266,     0,   354,
     610,     0,   875,     0,     0,   875,     0,     0,     0,     0,
    1672,     0,     0,  1505,     0,     0,     0,   356,  1674,     0,
     578,     0,     0,  1675,     0,     0,     0,     0,     0,   594,
    1881,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1676,     0,   594,  1686,  1677,     0,     0,     0,
     594,   594,     0,     0,     0,  1687,  1688,  1689,     0,  1690,
    1691,  1692,  1693,  1694,  1695,  1678,  1679,     0,     0,     0,
       0,     0,     0,     0,     0,  3237,     0,     0,  1680,     0,
       0,     0,     0,     0,   594,   594,     0,     0,     0,     0,
       0,     0,     0,   594,     0,     0,     0,     0,     0,     0,
       0,   594,     0,     0,     0,     0,   594,     0,   594,  1681,
       0,     0,  1682,     0,     0,     0,     0,     0,     0,   594,
     594,     0,     0,     0,     0,  1683,     0,  1684,  1676,     0,
       0,     0,  1677,     0,     0,     0,     0,     0, -1796,  1505,
       0,     0,     0,     0,     0,     0,  3085,   578,     0,     0,
       0,  1678,  1679,     0,     0,     0,     0,     0,     0,   594,
     594,  1266,   356,     0,  1680,     0,  1006,     0,   609,     0,
       0,     0,  1006,     0,     0,     0,     0,     0,   578, -1796,
     578,   578,     0,  1685,     0,   578,     0,     0,     0,  1510,
       0, -1796,     0,     0,     0,  1681, -1796,     0,  1682,     0,
       0, -1796,     0,     0, -1796,     0, -1796,     0,     0,     0,
       0,  1683,     0,  1684,  1006,     0,     0,     0,     0,     0,
       0,     0,     0,  1510,     0,     0,     0,     0,     0, -1796,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   578,     0,     0,     0, -1796,   594,  1686,
       0,     0,     0,     0,     0,     0,     0,     0,   594,  1687,
    1688,  1689,     0,  1690,  1691,  1692,  1693,  1694,  1695,  1685,
       0,     0,     0,  2733,     0,     0,     0,     0,     0,     0,
    1505,     0,     0,     0,     0,  1266,     0,     0, -1796,     0,
       0,     0,     0,     0,     0,     0, -1796,     0,     0,     0,
       0,     0,   594,     0,     0,     0,  1505,     0,     0,     0,
       0,     0,  1266,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   578,     0,  1686,  1266,  1266,     0,  1266,
       0,     0,     0,     0,     0,  1687,  1688,  1689,     0,  1690,
    1691,  1692,  1693,  1694,  1695,     0,     0,  1266,     0,  2891,
       0,     0,     0,  1671,     0,     0,     0,     0,   849,   578,
       0,     0,     0,     0,     0,     0,     0,  1672,     0,     0,
       0,     0,     0,   610,   610,  1674,     0,     0,     0, -1796,
    1675,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1732,     0,     0,     0,     0,     0,     0, -1796,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1266,     0,     0,  1266,  1266,     0,     0,
       0,     0,     0,     0,   356,   356,   356,     0, -1796,   594,
     594, -1796, -1796, -1796,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   594,   610,     0,     0,     0,   594,   594,
     594,   594,   594,   578,  3273,     0,   594,   578,  3277,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1671,   356,     0,     0,     0,     0,
       0,     0,   356,     0,  1510,  1676,     0,   356,  1672,  1677,
       0,   875,     0,     0,     0,     0,  1674,   699,     0,     0,
       0,  1675,     0,     0,     0,     0,   594,     0,  1678,  1679,
    1867,     0,     0,     0,     0,     0,  1505,     0,     0,     0,
     699,  1680,     0,  1510,     0,   875,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2483,     0,     0,   354,     0,     0,     0,   875,
       0,     0,  1681,     0,     0,  1682,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1510,     0,     0,  1683,     0,
    1684,     0,     0,  1505,     0,     0,   356,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1496,     0,
       0,     0,  1510,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1676,   871,     0,     0,
    1677,     0,     0,     0,   871,     0,   871,  1510,     0,     0,
       0,     0,  1496,     0,     0,     0,  1685,   699,     0,  1678,
    1679,     0,  2056,   594,     0,     0,     0,     0,     0,     0,
       0,     0,  1680,     0,     0,     0,   594,  1006,     0,  1510,
       0,     0,     0,     0,  1510,     0,     0,     0,     0,   594,
       0,     0,     0,     0,   594,     0,   594,   594,     0,     0,
       0,   594,     0,  1681,     0,     0,  1682,     0,     0,     0,
       0,     0,     0,     0,  1006,     0,     0,     0,     0,  1683,
       0,  1684,  1686,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1687,  1688,  1689,     0,  1690,  1691,  1692,  1693,
    1694,  1695,     0,     0,  1266,  1266,  2938,     0,     0,     0,
       0,     0,  1266,     0,     0,  1266,  1266,     0,     0,   594,
       0,     0,     0,     0,  2114,     0,     0,  1266,  1266,     0,
       0,     0,     0,     0,     0,  1266,     0,  1685,     0,  1266,
    1266,  1266,  1266,     0,     0,     0,     0,     0,     0,  1266,
    1266,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1510,  1266,   356,     0,     0,  1266,
       0,     0,     0,  1266,     0,     0,     0,  1266,     0,     0,
    1266,  1266,  1266,  1266,  1266,  1266,  1266,  1266,  1266,     0,
    1266,     0,     0,     0,  1266,     0,     0,     0,  1266,     0,
       0,     0,     0,  1686,     0,     0,     0,     0,     0,   594,
       0,     0,     0,  1687,  1688,  1689,     0,  1690,  1691,  1692,
    1693,  1694,  1695,     0,     0,     0,     0,  3055,     0,    78,
       0,     0,     0,     0,     0,    82,     0,     0,     0,   356,
       0,     0,    88,     0,    89,   594,     0,    92,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   102,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   356,     0,   356,   116,   117,     0,     0,
       0,     0,     0,  1496,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   125,     0,     0,     0,     0,     0,  1496,
       0,     0,     0,   126,   127,   128,     0,     0,   356,     0,
       0,     0,  1496,     0,     0,     0,     0,     0,   915,     0,
       0,     0,     0,  1266,     0,     0,     0,     0,  1671,   594,
       0,     0,     0,   594,     0,     0,   137,     0,   138,   139,
       0,  1867,  1510,   141,   142,     0,     0,     0,     0,     0,
    1674,   144,   145,     0,  1496,  1675,  1671,     0,     0,     0,
       0,     0,     0,     0,     0,   147,     0,   148,     0,     0,
     151,     0,     0,     0,   594,   594,   152,     0,  1674,   594,
       0,  1496,     0,  1675,     0,   153,     0,     0,     0,     0,
       0,   154,     0,     0,     0,     0,   155,     0,   157,     0,
       0,     0,   159,     0,     0,     0,  1496,     0,     0,     0,
       0,     0,     0,   163,     0,   164,     0,     0,     0,   594,
       0,     0,     0,     0,     0,     0,     0,     0,  2906,  1266,
    1510,     0,     0,     0,     0,  1510,     0,     0,  1496,   169,
       0,     0,     0,  1496,     0,   594,     0,  1671,  1266,     0,
    1510,     0,     0,     0,     0,     0,  2907,     0,     0,     0,
   -1797,  1672,   178,   179,  1677,     0,     0,     0,   180,  1674,
       0,     0,     0,     0,  1675,     0,   181,     0,     0,     0,
       0,     0,     0,  1678,  1679,     0,     0,     0, -1797,     0,
       0,     0,  1677,   186,     0,     0, -1797,     0,   699,     0,
       0,     0,     0,     0,     0,     0,  1003,     0,     0,  1006,
    1003,  1678,  1679,     0,     0,     0,     0,     0,  1266,  1671,
       0,  1510,   196,     0, -1797,     0,     0,     0,     0,     0,
    1682,     0,     0,  1672,   198,     0,   199,     0,     0,  1003,
     200,  1674,     0,  1683,   201,     0,  1675,   203,     0,     0,
       0,   205,     0,     0,  1266,     0,   206,     0,  1682,     0,
       0,   207,     0,  1496,   209,     0,     0,     0,     0,     0,
     212,  1683,     0,     0,     0,  1003,     0,     0,  1266,  1676,
       0,  1003,     0,  1677,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   218,     0,
     219, -1797,  1678,  1679,     0,     0,   221,     0,   222,     0,
    1266,   223,     0,  1266,     0,  1680,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1266,  1266,  1266,  1266, -1797,
       0,     0,     0,     0,  1266,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1266,  1266,  1681,  1266,     0,  1682,
       0,  1676,     0,     0,   228,  1677,     0,     0,     0,  1266,
       0,  1266,  1683,     0,  1684,  1266,     0,  1686,     0,     0,
       0,  1261,     0,     0,  1678,  1679,   871,     0,     0,   871,
       0,  1690,  1691,  1692,  1693,  1694,  1695,  1680,     0,  1006,
       0,  1266,  1266,     0,     0,  1686,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1690,
    1691,  1692,  1693,  1694,  1695,  1266,     0,     0,  1681,     0,
    1685,  1682,     0,  1266,  1266,  1266,     0,     0,     0,     0,
       0,     0,     0,     0,  1683,     0,  1684,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1496,  1496,     0,  1671,  1266,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1672,     0,     0,
       0,  1867,  1510,     0,  1510,  1674,     0,     0,     0,     0,
    1675,     0,     0,     0,     0,     0,  1686,     0,     0,  1510,
       0,  1510,  1685,     0,     0,     0,  1687,  1688,  1689,     0,
    1690,  1691,  1692,  1693,  1694,  1695,     0,     0,     0,     0,
    3074,     0,     0,     0,     0,     0,     0,  1510,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1261,   699,     0,     0,  1496,
    1003,     0,     0,     0,  1496,     0,  1003,  1510,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1686,  1496,
       0,     0,     0,  1508,   356,  1510,     0,     0,  1687,  1688,
    1689,     0,  1690,  1691,  1692,  1693,  1694,  1695,     0,     0,
       0,     0,  3205,     0,     0,  1676,     0,     0,  1003,  1677,
       0,     0,     0,     0,     0,     0,     0,  1508,     0,     0,
    1510,     0,     0,     0,   593,     0,     0,     0,  1678,  1679,
       0,  1510,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1680,     0,     0,     0,  1510,     0,     0,     0,     0,
    1496,     0,     0,     0,     0,     0,     0,     0,     0,  1006,
       0,     0,     0,  1006,     0,     0,     0,  1006,     0,     0,
       0,     0,  1681,     0,     0,  1682,     0,     0,  1671,  1261,
       0,     0,     0,     0,     0,     0,     0,     0,  1683,  1006,
    1684,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1674,   834,     0,     0,     0,  1675,  1261,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1266,     0,     0,     0,
       0,   593,  1266,   834,     0,  1510,     0,     0,     0,     0,
    1261,  1261,     0,  1261,  1266,     0,     0,     0,     0,     0,
    1266,     0,     0,     0,  1266,     0,  1685,     0,  1510,  1266,
       0,  1261,  1266,  1266,  1266,  1266,  1266,  1266,  1266,  1266,
    1266,  1266,     0,     0,     0,     0,  1266,  1266,     0,     0,
       0,     0,     0,     0,     0,  1510,     0,     0,  2910,     0,
    1266,     0,     0,     0,     0,     0,     0,  1266,     0,     0,
    1266,     0,  1266,     0,     0,     0,     0,     0,  1510,  1266,
    1266,  1266,     0,     0,     0,  1266,     0,     0,  1266,     0,
   -1797,     0,  1686,     0,  1677,     0,     0,  1261,     0,     0,
    1261,  1261,  1687,  1688,  1689,     0,  1690,  1691,  1692,  1693,
    1694,  1695,     0,  1678,  1679,     0,  3263,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1797,     0,     0,     0,
       0,     0,  1266,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1671,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1682,     0,     0,     0,  1672,     0,     0,     0,  1508,     0,
       0,   699,  1674,  1683,     0,   871,     0,  1675,     0,     0,
    1496,  1496,     0,  1496,     0,     0,     0,     0,     0,     0,
    1510,     0,     0,     0,  1865,     0,     0,     0,  1496,     0,
    1496,     0,     0,     0,     0,     0,     0,  1508,     0,   871,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1496,     0,     0,     0,
       0, -1797,     0,   871,     0,     0,     0,     0,     0,     0,
    1671,     0,     0,     0,     0,     0,  1266,     0,     0,  1508,
       0,     0,     0,     0,     0,     0,  1496,  1510,     0,     0,
     699,   742,  1674,     0,     0,     0,     0,  1675,     0,     0,
       0,     0,     0,     0,  1496,     0,  1508,     0,     0,     0,
       0,     0,  1676,     0,     0,     0,  1677,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1686,  1006,     0,
     742,  1508,     0,  1006,     0,  1678,  1679,  1006,   742,  1496,
       0,  1690,  1691,  1692,  1693,  1694,  1695,     0,  1680,     0,
    1496,     0,     0,     0,     0,  1266,     0,     0,     0,     0,
       0,  1003,     0,  1508,  1496,     0,     0,  1266,  1508,     0,
    3072,     0,     0,   742,   742,     0,     0,     0,     0,  1681,
       0,     0,  1682,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1683,     0,  1684,  1003,     0,
       0,     0, -1797,     0,     0,     0,  1677,     0,  1266,  1266,
       0,     0,     0,  1510,     0,     0,     0,     0,     0,  1266,
    1266,     0,     0,  1266,     0,  1678,  1679,     0,  1261,  1261,
       0,     0,     0,     0,     0,     0,  1261,     0, -1797,  1261,
    1261,     0,     0,     0,  1496,     0,     0,     0,     0,     0,
       0,  1261,  1261,  1685,     0,     0,     0,     0,     0,  1261,
       0,     0,     0,  1261,  1261,  1261,  1261,  1496,     0,     0,
       0,     0,  1682,  1261,  1261,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1683,     0,     0,  1508,  1261,
     699,     0,     0,  1261,  1496,     0,  1266,  1261,     0,     0,
       0,  1261,     0,     0,  1261,  1261,  1261,  1261,  1261,  1261,
    1261,  1261,  1261,     0,  1261,     0,     0,  1496,  1261,  1686,
       0,     0,  1261,     0,     0,     0,     0,     0,     0,  1687,
    1688,  1689,  1006,  1690,  1691,  1692,  1693,  1694,  1695,     0,
       0,  2713,     0, -1797,     0,  1266,     0,     0,     0,  1006,
       0,     0,     0,     0,  1510,     0,     0,     0,     0,     0,
       0,     0,  1266,     0,     0,     0,     0,     0,     0,     0,
       0,  1266,  1671,  1266,     0,     0,     0,     0,     0,     0,
    1510,  1266,  1266,     0,     0,  1266,  1672,     0,     0,     0,
    2233,     0,  1266,  1266,  1674,     0,     0,     0,     0,  1675,
     593,     0,  1266,     0,     0,     0,     0,     0,     0,  1686,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1266,     0,     0,  1690,  1691,  1692,  1693,  1694,  1695,  1496,
       0,     0,     0,     0,  1006,     0,     0,     0,     0,     0,
       0,     0,   699,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1261,     0,  2234,
       0,     0,  1266,     0,     0,     0,     0,     0,   834,     0,
     834,     0,   834,     0,     0,  1865,  1508,     0,   834,   834,
       0,     0,     0,     0,  1266,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1496,     0,     0,     0,
       0,     0,     0,     0,  1676,     0,   593,     0,  1677,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1678,  1679,     0,
       0,   593,     0,     0,     0,     0,     0,  1006,     0,     0,
    1680,     0,   593,   593,     0,     0,     0,     0,     0,     0,
    1266,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1261,  1508,     0,     0,     0,     0,  1508,
       0,  1681,     0,     0,  1682,     0,     0,     0,     0,     0,
       0,     0,  1261,     0,  1508,     0,     0,  1683,     0,  1684,
       0,     0,     0,     0,     0,     0,     0,     0,  1337,     0,
    1510,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   593,   593,     0,     0,     0,
    1671,  1006,  1496,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1337,     0,  1672,     0,     0,     0,     0,     0,
       0,     0,  1674,  1003,     0,  1685,     0,  1675,     0,     0,
       0,     0,  1261,     0,  1006,  1508,     0,  1510,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   999,     0,     0,     0,   999,     0,   742,     0,     0,
       0,     0,   742,   742,     0,     0,     0,     0,  1261,     0,
    2235,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   742,   999,     0,     0,     0,     0,     0,
       0,  1686,  1261,     0,     0,     0,     0,     0,     0,     0,
       0,  1687,  1688,  1689,     0,  1690,  1691,  1692,  1693,  1694,
    1695,     0,     0,  2563,     0,     0,     0,     0,  2564,   742,
     999,     0,     0,     0,  1261,     0,   999,  1261,     0,     0,
       0,     0,  1676,     0,     0,     0,  1677,     0,     0,  1261,
    1261,  1261,  1261,  1496,     0,     0,     0,     0,  1261,     0,
       0,     0,     0,     0,   593,  1678,  1679,     0,  1261,  1261,
       0,  1261,     0,     0,     0,     0,     0,     0,  1680,  1496,
       0,     0,     0,  1261,     0,  1261,   742,     0,     0,  1261,
       0,     0,   742,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   742,     0,     0,     0,     0,     0,     0,  1681,
       0,     0,  1682,  1003,     0,  1261,  1261,     0,     0,     0,
       0,     0,     0,     0,     0,  1683,     0,  1684,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1261,
       0,     0,     0,     0,     0,   742,     0,  1261,  1261,  1261,
     742,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   742,     0,     0,     0,     0,     0,     0,     0,     0,
     593,     0,     0,     0,     0,     0,     0,  1671,  1261,     0,
       0,   593,     0,  1685,     0,     0,     0,     0,     0,     0,
       0,  1672,     0,     0,  1673,  1865,  1508,     0,  1508,  1674,
       0,     0,     0,     0,  1675,     0,     0,     0,     0,     0,
       0,     0,     0,  1508,     0,  1508,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   593,     0,     0,  1337,
       0,  1337,  1337,     0,     0,     0,     0,     0,     0,     0,
       0,  1508,     0,     0,     0,     0,     0,     0,     0,  1686,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1687,
    1688,  1689,     0,  1690,  1691,  1692,  1693,  1694,  1695,     0,
       0,  1508,     0,     0,     0,     0,     0,  1497,  1671,     0,
       0,     0,     0,     0,     0,   593,     0,     0,   699,  1508,
       0,     0,  1672,     0,   742,   999,   834,     0,     0,  1496,
    1674,   999,     0,     0,     0,  1675,     0,     0,     0,  1676,
       0,  1497,     0,  1677,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1508,     0,     0,     0,     0,     0,
       0,     0,  1678,  1679,     0,  1508,     0,   742,   742,   742,
       0,     0,     0,   999,     0,  1680,     0,     0,     0,  1508,
       0,     0,     0,     0,     0,     0,  1496,     0,     0,     0,
       0,     0,     0,  1003,     0,     0,     0,  1003,     0,     0,
       0,  1003,     0,     0,     0,     0,  1681,     0,     0,  1682,
       0,     0,     0,     0,     0,     0,     0,   742,     0,     0,
       0,     0,  1683,  1003,  1684,     0,  2577,     0,     0,     0,
       0,     0,     0,     0,     0,   742,  1337,     0,     0,     0,
    1676,     0,     0,     0,  1677,     0,     0,     0,     0,     0,
    1261,     0,     0,     0,     0,     0,  1261,     0,     0,  1508,
       0,     0,     0,  1678,  1679,     0,     0,     0,  1261,     0,
       0,     0,     0,     0,  1261,     0,  1680,     0,  1261,     0,
    1685,     0,  1508,  1261,     0,     0,  1261,  1261,  1261,  1261,
    1261,  1261,  1261,  1261,  1261,  1261,     0,     0,     0,     0,
    1261,  1261,     0,     0,     0,   593,     0,  1681,     0,  1508,
    1682,     0,     0,     0,  1261,     0,     0,     0,     0,     0,
       0,  1261,     0,  1683,  1261,  1684,  1261,     0,   703,     0,
       0,     0,  1508,  1261,  1261,  1261,     0,     0,   705,  1261,
       0,     0,  1261,     0,     0,     0,  1686,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1687,  1688,  1689,     0,
    1690,  1691,  1692,  1693,  1694,  1695,     0,     0,     0,   742,
       0,     0,     0,     0,   739,     0,     0,     0,     0,     0,
       0,  1685,     0,     0,   782,     0,  1261,   786,     0,     0,
       0,   782,     0,     0,     0,   830,   834,   834,   834,     0,
       0,     0,     0,   593,   834,     0,     0,     0,   834,   834,
       0,     0,  1497,     0,     0,   834,     0,   852,     0,     0,
       0,     0,     0,     0,   834,     0,   834,     0,     0,     0,
       0,     0,   782,     0,     0,     0,     0,     0,  1497,   834,
       0,   834,     0,     0,  1508,     0,     0,  1686,     0,     0,
       0,  1497,     0,     0,     0,     0,     0,  1687,  1688,  1689,
       0,  1690,  1691,  1692,  1693,  1694,  1695,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1497,     0,     0,     0,     0,     0,     0,
    1261,     0,   593,     0,     0,  1499,     0,     0,     0,     0,
       0,  1508,     0,     0,   742,     0,     0,     0,     0,     0,
    1497,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1499,
       0,     0,     0,     0,     0,  1497,     0,     0,     0,  1671,
       0,     0,  1003,     0,     0,     0,     0,  1003,     0,     0,
       0,  1003,     0,  1672,     0,     0,  2522,     0,     0,  1337,
       0,  1674,     0,     0,     0,   593,  1675,  1497,     0,  1261,
       0,     0,  1497,     0,     0,  1337,     0,     0,     0,     0,
       0,  1261,     0,     0,     0,     0,     0,     0,     0,  1671,
       0,   957,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1672,     0,     0,  2034,     0,     0,     0,
       0,  1674,     0,     0,   742,   742,  1675,     0,     0,     0,
       0,     0,  1261,  1261,     0,     0,     0,  1508,     0,     0,
       0,     0,     0,  1261,  1261,     0,     0,  1261,     0,     0,
       0,     0,     0,   999,     0,     0,   742,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   742,     0,
       0,     0,   834,     0,     0,     0,     0,     0,     0,     0,
    1337,  1676,     0,  1337,  1337,  1677,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1497,     0,  1678,  1679,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1680,     0,     0,
    1261,     0,     0,     0,     0,   593,     0,     0,     0,   593,
       0,  1676,     0,   593,     0,  1677,     0,     0,     0,     0,
       0,   834,     0,     0,     0,     0,   834,     0,  1681,     0,
       0,  1682,     0,     0,  1678,  1679,  1003,     0,     0,     0,
       0,     0,     0,     0,  1683,     0,  1684,  1680,     0,  1261,
       0,     0,   742,  1003,     0,     0,     0,     0,  1508,     0,
       0,     0,     0,     0,     0,     0,  1261,     0,     0,     0,
     593,     0,     0,     0,     0,  1261,     0,  1261,  1681,     0,
       0,  1682,     0,     0,  1508,  1261,  1261,     0,     0,  1261,
    1499,     0,     0,     0,  1683,     0,  1261,  1261,     0,     0,
       0,     0,  1685,     0,   742,     0,  1261,     0,     0,     0,
       0,     0,     0,   965,   966,     0,  1499,     0,     0,     0,
    1671,     0,     0,     0,  1261,     0,     0,     0,     0,  1499,
       0,     0,     0,     0,  1672,     0,     0,     0,  1003,     0,
       0,     0,  1674,     0,     0,     0,   834,  1675,     0,     0,
       0,     0,  1685,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1261,     0,  1686,  1497,
    1497,  1499,     0,     0,     0,     0,     0,     0,  1687,  1688,
    1689,     0,  1690,  1691,  1692,  1693,  1694,  1695,  1261,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1499,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1686,     0,
       0,     0,     0,  1499,     0,     0,     0,     0,  1687,  1688,
    1689,     0,  1690,  1691,  1692,  1693,  1694,  1695,     0,     0,
       0,  1003,  1017,     0,     0,  1034,     0,     0,  1038,  1039,
       0,     0,  1676,     0,  1261,  1499,  1677,     0,  1497,     0,
    1499,     0,     0,  1497,     0,     0,     0,     0,     0,  1075,
       0,   834,     0,  1337,     0,  1678,  1679,     0,  1497,     0,
       0,     0,  1091,     0,     0,  1092,     0,     0,  1680,     0,
       0,     0,     0,     0,     0,     0,   957,   782,     0,   869,
       0,     0,     0,     0,  1508,  1109,   869,     0,   869,     0,
       0,     0,     0,     0,     0,     0,  1118,     0,     0,  1681,
    1119,  1120,  1682,     0,     0,  1003,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1683,     0,  1684,     0,     0,
       0,   742,     0,     0,  1138,  1139,     0,     0,     0,  1497,
       0,   957,     0,     0,     0,     0,     0,     0,  1003,     0,
       0,  1508,   834,     0,   742,     0,     0,     0,     0,     0,
       0,   742,  1154,     0,  1155,     0,     0,  1337,  2034,     0,
    1499,     0,     0,  1337,  1337,     0,     0,     0,     0,     0,
       0,     0,     0,  1685,     0,     0,     0,     0,     0,     0,
       0,     0,   957,     0,     0,     0,  1671,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   593,   593,     0,
    1672,     0,     0,     0,     0,     0,   593,     0,  1674,     0,
       0,     0,     0,  1675,  1337,     0,     0,     0,  2524,   834,
       0,   834,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2752,   593,     0,     0,     0,     0,     0,  1686,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1687,
    1688,  1689,     0,  1690,  1691,  1692,  1693,  1694,  1695,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   593,   593,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1373,     0,     0,  1375,     0,     0,
    1377,     0,     0,     0,  1671,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1672,     0,
       0,  2572,     0,     0,     0,     0,  1674,     0,  1676,     0,
       0,  1675,  1677,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   742,     0,     0,     0,     0,     0,  2034,     0,
       0,  1678,  1679,     0,     0,     0,     0,  1499,  1499,     0,
       0,     0,     0,     0,  1680,     0,     0,     0,     0,  1467,
       0,   834,     0,  1468,     0,     0,  1500,  1470,     0,     0,
       0,   834,     0,  1511,     0,     0,     0,     0,     0,  1497,
    1497,     0,  1497,     0,     0,  1681,     0,     0,  1682,     0,
       0,     0,     0,     0,     0,     0,     0,  1497,  1538,  1497,
    1500,  1683,     0,  1684,     0,     0,     0,     0,     0,     0,
       0,     0,  2541,     0,     0,   593,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1497,  1676,     0,     0,     0,
    1677,     0,     0,  1569,     0,     0,  1499,     0,     0,     0,
       0,  1499,     0,     0,     0,     0,     0,  1598,     0,  1678,
    1679,     0,     0,     0,     0,  1497,  1499,     0,     0,  1685,
       0,     0,  1680,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1497,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1681,     0,     0,  1682,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1497,  1683,
       0,  1684,     0,     0,     0,     0,     0,     0,     0,  1497,
       0,     0,     0,     0,     0,  1686,     0,  1499,     0,     0,
       0,     0,     0,  1497,     0,  1687,  1688,  1689,     0,  1690,
    1691,  1692,  1693,  1694,  1695,   742,     0,     0,     0,     0,
       0,   742,   593,   593,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   834,  1685,     0,     0,
       0,   834,   834,   834,   834,   834,     0,     0,     0,   834,
       0,     0,     0,     0,     0,     0,     0,     0,  2034,     0,
       0,     0,  2034,     0,     0,     0,  2034,     0,  1001,     0,
       0,     0,  1001,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1497,     0,     0,     0,     0,   999,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   593,
       0,  1001,     0,  1686,     0,     0,  1497,     0,     0,     0,
     742,     0,     0,  1687,  1688,  1689,     0,  1690,  1691,  1692,
    1693,  1694,  1695,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1497,     0,     0,     0,  1001,     0,     0,
    1816,  1500,     0,  1001,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1497,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1500,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1500,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   742,   742,     0,     0,     0,     0,
       0,     0,  1500,     0,     0,     0,   593,     0,     0,     0,
       0,     0,     0,  1258,     0,     0,     0,     0,   869,   834,
       0,   869,     0,     0,     0,     0,     0,  1499,  1499,  1500,
    1499,     0,   834,     0,     0,     0,     0,   593,     0,   593,
     593,     0,     0,     0,   593,  1499,     0,  1499,  1497,     0,
       0,     0,     0,     0,  1500,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2001,     0,
       0,     0,     0,  1499,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1500,     0,     0,     0,
       0,  1500,     0,     0,     0,  2040,     0,     0,     0,     0,
       0,     0,   593,  1499,     0,     0,     0,     0,  2049,     0,
       0,     0,     0,     0,     0,  1497,     0,     0,     0,     0,
       0,  1499,     0,     0,     0,     0,     0,     0,   742,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1671,     0,     0,     0,     0,     0,
       0,   742,     0,     0,     0,     0,  1499,     0,  1672,   742,
       0,     0,     0,     0,     0,     0,  1674,  1499,     0,     0,
       0,  1675,     0,     0,     0,     0,     0,  1258,     0,     0,
       0,  1499,  1001,     0,     0,     0,     0,     0,  1001,     0,
       0,     0,   593,     0,     0,     0,     0,  2034,     0,     0,
       0,     0,  2034,     0,     0,  1506,  2034,     0,     0,     0,
       0,  1500,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   593,     0,
    1001,     0,     0,     0,     0,     0,     0,     0,     0,  1506,
       0,  1497,  1240,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2213,     0,     0,     0,     0,     0,     0,     0,
       0,  1499,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1676,     0,     0,     0,
    1677,     0,     0,     0,  1499,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   742,   742,   742,   742,     0,  1678,
    1679,  1258,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1499,  1680,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   593,     0,     0,     0,   593,     0,  1258,     0,
       0,     0,     0,     0,  1499,     0,     0,     0,     0,     0,
       0,     0,     0,  1681,     0,     0,  1682,     0,     0,     0,
       0,     0,  1258,  1258,     0,  1258,     0,     0,   957,  1683,
       0,  1684,     0,     0,     0,     0,     0,   834,   834,  2265,
       0,     0,     0,  1258,     0,     0,     0,  2272,     0,     0,
       0,     0,  1497,  2276,     0,     0,     0,     0,  2280,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1500,  1500,
       0,   999,     0,     0,     0,     0,  1455,     0,  1497,     0,
       0,     0,     0,     0,     0,     0,     0,  1685,  2034,     0,
    2300,  2301,     0,  2303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1258,
       0,     0,  1258,  1258,     0,     0,  1499,     0,     0,     0,
       0,     0,  2321,  2322,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2336,     0,  2340,
    2341,     0,  2345,  2346,  2347,  2348,     0,     0,     0,  2354,
       0,     0,  2357,  1686,     0,     0,     0,  1500,     0,     0,
       0,     0,  1500,  1687,  1688,  1689,     0,  1690,  1691,  1692,
    1693,  1694,  1695,   999,     0,   742,     0,  1500,     0,     0,
    1506,     0,     0,  1499,     0,     0,     0,   869,     0,     0,
       0,     0,     0,   742,     0,     0,     0,     0,     0,     0,
    1617,     0,     0,     0,     0,     0,  1862,     0,   742,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1506,
       0,   869,     0,     0,     0,     0,     0,  1641,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   742,     0,
       0,     0,     0,     0,     0,   869,     0,     0,  1500,     0,
       0,  1660,  1661,     0,  1663,     0,     0,     0,     0,     0,
       0,  1506,     0,     0,     0,     0,     0,   957,     0,     0,
       0,     0,  1699,     0,     0,     0,   999,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1506,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1497,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1499,
       0,     0,     0,  1506,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1761,     0,
       0,  1768,  1770,  1001,     0,  1506,     0,     0,     0,     0,
    1506,     0,     0,     0,     0,  1497,     0,     0,     0,     0,
     999,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1001,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   999,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1258,  1258,     0,     0,     0,     0,     0,     0,  1258,     0,
       0,  1258,  1258,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1258,  1258,     0,     0,     0,     0,     0,
       0,  1258,     0,     0,     0,  1258,  1258,  1258,  1258,     0,
    1499,     0,     0,     0,     0,  1258,  1258,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1506,  1258,     0,     0,     0,  1258,  1499,     0,     0,  1258,
       0,     0,     0,  1258,     0,     0,  1258,  1258,  1258,  1258,
    1258,  1258,  1258,  1258,  1258,     0,  1258,     0,  1500,  1500,
    1258,  1500,     0,     0,  1258,     0,     0,     0,     0,     0,
       0,  2687,  2688,     0,     0,     0,  1500,     0,  1500,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1671,     0,     0,     0,     0,
       0,     0,     0,     0,  1500,     0,     0,     0,     0,  1672,
       0,     0,     0,     0,     0,     0,     0,  1674,     0,     0,
       0,     0,  1675,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1500,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1500,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2756,  2758,
    2760,     0,     0,     0,     0,     0,     0,  1500,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1500,  1258,
       0,     0,     0,     0,     0,     0,     0,  2098,     0,     0,
       0,  2100,  1500,  2796,     0,     0,     0,  1862,  1506,     0,
       0,     0,     0,     0,     0,   782,     0,  1676,     0,     0,
    2122,  1677,     0,     0,  2125,     0,     0,  2134,     0,     0,
       0,     0,     0,     0,  2141,  2146,     0,     0,     0,     0,
    1678,  1679,     0,     0,     0,     0,  1499,     0,     0,     0,
    2157,     0,     0,  1680,  2163,     0,     0,     0,  2174,     0,
       0,     0,  2181,     0,     0,  2183,  2184,  2185,  2186,  2187,
    2188,  2189,  2190,  2191,     0,  2192,     0,     0,     0,  1240,
       0,     0,  1500,     0,  1681,     0,     0,  1682,     0,     0,
       0,     0,     0,     0,     0,  1258,  1506,     0,     0,     0,
    1683,  1506,  1684,  1499,     0,  1500,     0,     0,     0,     0,
       0,     0,     0,     0,  1258,     0,  1506,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1500,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1500,     0,     0,  1685,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1001,     0,     0,     0,     0,
    2854,     0,     0,     0,  1258,     0,     0,  1506,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1502,     0,     0,     0,     0,  2278,     0,
    1258,     0,     0,     0,  1686,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1687,  1688,  1689,     0,  1690,  1691,
    1692,  1693,  1694,  1695,  1258,     0,     0,  1502,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1500,     0,     0,
       0,     0,     0,     0,     0,     0,  1258,  2953,  2954,  1258,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1258,  1258,  1258,  1258,     0,     0,     0,     0,     0,
    1258,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1258,  1258,     0,  1258,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2362,  1258,     0,  1258,  2984,     0,
       0,  1258,     0,     0,  1500,     0,     0,     0,     0,     0,
       0,     0,     0,  2383,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1001,     0,  1258,  1258,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1258,     0,     0,     0,     0,     0,     0,     0,  1258,
    1258,  1258,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2471,     0,     0,     0,     0,     0,  1503,
    1258,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1004,     0,     0,     0,  1004,     0,     0,  1862,  1506,     0,
    1506,     0,     0,     0,     0,     0,     0,     0,     0,  2495,
       0,     0,     0,  1503,     0,  1506,     0,  1506,     0,     0,
    1500,     0,     0,  1004,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2518,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1506,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1004,
       0,  3094,  3095,     0,     0,  1004,     0,     0,     0,     0,
       0,  3101,     0,  1506,     0,     0,     0,     0,  1502,     0,
    2146,     0,  2146,  2146,     0,     0,     0,     0,     0,  2580,
       0,  1506,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1502,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2599,     0,  2601,  1502,     0,     0,
    2604,     0,     0,     0,     0,     0,  1506,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1506,     0,     0,
    2796,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1506,     0,     0,     0,  1262,     0,     0,     0,  1502,
       0,  1500,     0,     0,     0,  1001,     0,     0,     0,  1001,
    1761,     0,     0,  1001,     0,     0,     0,     0,  1770,  1770,
    1768,     0,     0,     0,     0,     0,  1502,  1500,     0,     0,
       0,     0,     0,     0,     0,  1001,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2674,
       0,  1502,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1258,     0,     0,     0,     0,     0,  1258,     0,
       0,  1506,     0,     0,     0,     0,     0,     0,     0,     0,
    1258,     0,     0,  1502,     0,     0,  1258,     0,  1502,     0,
    1258,     0,     0,     0,  1506,  1258,     0,     0,  1258,  1258,
    1258,  1258,  1258,  1258,  1258,  1258,  1258,  1258,     0,     0,
       0,     0,  1258,  1258,     0,     0,     0,     0,     0,     0,
       0,  1506,     0,     0,  1503,     0,  1258,     0,     0,     0,
       0,     0,     0,  1258,     0,     0,  1258,     0,  1258,     0,
       0,     0,     0,     0,  1506,  1258,  1258,  1258,     0,     0,
    1503,  1258,     0,     0,  1258,     0,     0,     0,     0,  1262,
       0,     0,     0,  1503,  1004,     0,     0,     0,     0,     0,
    1004,     0,     0,     0,  3255,     0,     0,     0,     0,  3257,
       0,     0,     0,     0,     0,     0,     0,  1509,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1258,     0,
       0,     0,     0,     0,     0,  1503,     0,     0,  1502,     0,
       0,     0,  1004,     0,     0,     0,     0,     0,     0,     0,
       0,  1509,     0,     0,     0,     0,     0,  3295,     0,     0,
       0,     0,  1503,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1500,     0,     0,
       0,     0,     0,     0,     0,     0,  1506,  1503,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1262,     0,     0,     0,     0,     0,  1503,
       0,  2851,     0,     0,  1503,     0,     0,  2855,     0,     0,
       0,     0,     0,     0,  1500,     0,     0,     0,     0,  2860,
    1262,     0,  1258,     0,     0,  2861,     0,     0,     0,  2863,
       0,     0,     0,  1506,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1262,  1262,     0,  1262,     0,     0,
       0,  2880,  2881,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1262,     0,     0,     0,     0,
       0,     0,  2894,     0,  1001,  2897,     0,  2899,     0,  1001,
       0,     0,     0,  1001,  2903,     0,     0,     0,     0,     0,
    2908,     0,     0,  2911,     0,     0,     0,     0,     0,     0,
       0,  1258,     0,     0,     0,  1502,  1502,     0,     0,     0,
       0,     0,     0,  1258,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1503,     0,     0,     0,     0,     0,
       0,  1262,     0,     0,  1262,  1262,     0,  2929,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1258,  1258,     0,     0,     0,  1506,
       0,     0,     0,     0,     0,  1258,  1258,     0,     0,  1258,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1502,     0,     0,     0,     0,  1502,
       0,     0,  1509,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1502,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1504,  1866,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1509,  1258,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1507,  1504,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1001,     0,
       0,     0,     0,  1509,     0,  1502,     0,     0,     0,     0,
       0,  1258,     0,     0,  1507,  1001,     0,     0,     0,     0,
    1506,     0,     0,     0,     0,     0,     0,     0,  1258,     0,
    1509,  1503,  1503,     0,     0,     0,     0,  1258,     0,  1258,
       0,     0,     0,     0,     0,     0,  1506,  1258,  1258,     0,
    2495,  1258,     0,     0,     0,  1509,     0,     0,  1258,  1258,
       0,     0,  3051,     0,     0,     0,     0,     0,  1258,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1004,  1258,  1509,     0,     0,
       0,     0,  1509,     0,     0,     0,     0,     0,     0,     0,
    1001,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3070,  3071,     0,     0,  3073,     0,
    1503,     0,  1004,     0,     0,  1503,     0,     0,  1258,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1503,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1258,     0,  1262,  1262,     0,     0,     0,     0,     0,     0,
    1262,     0,     0,  1262,  1262,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1262,  1262,     0,     0,     0,
       0,     0,     0,  1262,     0,     0,     0,  1262,  1262,  1262,
    1262,  3125,     0,     0,     0,     0,     0,  1262,  1262,     0,
       0,     0,     0,  1001,     0,     0,     0,     0,     0,     0,
       0,  1503,  1509,  1262,     0,     0,  1258,  1262,     0,     0,
       0,  1262,     0,     0,     0,  1262,     0,     0,  1262,  1262,
    1262,  1262,  1262,  1262,  1262,  1262,  1262,     0,  1262,     0,
    3159,     0,  1262,     0,     0,     0,  1262,     0,     0,     0,
       0,     0,  1504,     0,     0,  1502,  1502,  2495,  1502,     0,
       0,     0,     0,     0,     0,     0,  1506,     0,     0,     0,
       0,     0,     0,  1502,     0,  1502,     0,     0,  1504,     0,
    3177,     0,     0,     0,     0,  1507,     0,  1001,  3179,     0,
       0,  1504,     0,     0,     0,     0,     0,  3183,     0,     0,
       0,  1502,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1863,     0,     0,     0,  3188,     0,     0,     0,     0,
    1001,     0,     0,  1506,  1507,     0,     0,     0,     0,     0,
       0,  1502,     0,  1504,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1502,
       0,     0,     0,     0,     0,     0,     0,  3222,     0,     0,
    1504,     0,     0,     0,     0,     0,  1507,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1262,     0,     0,  1502,  1504,     0,     0,     0,     0,
       0,     0,     0,  1507,     0,  1502,     0,     0,     0,  1866,
    1509,     0,     0,     0,     0,     0,     0,     0,     0,  1502,
       0,     0,     0,     0,     0,     0,     0,  1504,  1507,     0,
       0,     0,  1504,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3183,     0,     0,     0,     0,
    1507,     0,     0,     0,     0,  1507,     0,     0,     0,     0,
       0,  1503,  1503,     0,  1503,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1503,
       0,  1503,     0,     0,     0,     0,     0,  1262,  1509,  1502,
       0,     0,     0,  1509,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1262,  1503,  1509,     0,
       0,     0,  1502,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1503,     0,  1502,
       0,     0,  1504,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1503,     0,     0,     0,     0,
       0,     0,  1502,     0,     0,     0,     0,  1004,     0,     0,
       0,     0,     0,     0,     0,  1507,  1262,     0,     0,  1509,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1503,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1503,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1262,     0,     0,  1503,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1262,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1262,     0,
       0,  1262,     0,     0,  1502,     0,     0,     0,     0,     0,
       0,     0,     0,  1262,  1262,  1262,  1262,     0,     0,     0,
       0,     0,  1262,     0,     0,  1503,     0,     0,     0,     0,
       0,     0,  1262,  1262,     0,  1262,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1262,  1503,  1262,
       0,     0,     0,  1262,     0,     0,     0,     0,     0,  1504,
    1504,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1502,     0,     0,     0,  1503,     0,  1004,     0,  1262,
    1262,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1863,  1863,     0,     0,     0,     0,  1503,     0,
       0,     0,     0,  1262,     0,     0,     0,     0,     0,     0,
       0,  1262,  1262,  1262,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1697,     0,  1262,     0,     0,     0,     0,     0,  1504,     0,
       0,     0,     0,  1504,     0,     0,     0,     0,     0,  1866,
    1509,     0,  1509,     0,     0,     0,     0,     0,  1504,     0,
       0,     0,     0,     0,     0,     0,     0,  1509,     0,  1509,
       0,  1507,     0,     0,     0,     0,  1507,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1502,     0,     0,
       0,  1507,     0,     0,     0,  1509,     0,     0,     0,     0,
    1503,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1509,     0,     0,     0,  1504,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1509,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1507,     0,     0,     0,     0,  1503,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1509,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1509,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1509,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1004,     0,     0,
       0,  1004,     0,     0,     0,  1004,     0,     0,  1502,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1697,     0,  1004,     0,     0,
       0,     0,     0,     0,  1502,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1262,     0,     0,     0,     0,     0,
    1262,     0,     0,  1509,     0,     0,     0,     0,     0,     0,
       0,     0,  1262,  1503,     0,     0,     0,     0,  1262,     0,
       0,     0,  1262,     0,     0,     0,  1509,  1262,     0,     0,
    1262,  1262,  1262,  1262,  1262,  1262,  1262,  1262,  1262,  1262,
       0,     0,     0,     0,  1262,  1262,     0,     0,     0,     0,
       0,     0,     0,  1509,     0,     0,     0,     0,  1262,     0,
       0,     0,     0,     0,     0,  1262,     0,     0,  1262,     0,
    1262,     0,     0,     0,     0,     0,  1509,  1262,  1262,  1262,
       0,     0,     0,  1262,     0,     0,  1262,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1504,
    1504,     0,  1504,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1504,     0,  1504,
       0,     0,     0,     0,     0,     0,     0,  1697,     0,     0,
    1262,     0,  1863,  1863,     0,  1863,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1504,     0,     0,     0,     0,
    1507,  1697,  1507,     0,  1503,     0,     0,  2130,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1697,  1697,     0,  1697,     0,  1504,     0,     0,  1507,     0,
    1503,     0,     0,     0,     0,     0,     0,     0,  1509,     0,
       0,     0,     0,  1504,  1502,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1507,  1697,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1863,     0,  1504,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1504,
       0,     0,     0,     0,  1262,     0,     0,     0,     0,     0,
       0,  1502,     0,  1504,     0,  1509,     0,     0,     0,     0,
       0,  1507,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1697,  1507,     0,     0,     0,     0,     0,  1697,     0,
    1697,     0,     0,     0,     0,     0,  1863,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1004,     0,     0,     0,
       0,  1004,     0,     0,     0,  1004,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1262,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1504,     0,  1262,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1504,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1507,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1262,  1262,     0,     0,
       0,  1509,     0,  1504,     0,     0,     0,  1262,  1262,  1507,
       0,  1262,     0,     0,     0,     0,     0,     0,     0,     0,
    1503,     0,     0,     0,     0,     0,  1504,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1507,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1507,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1503,     0,     0,
       0,     0,     0,     0,  1262,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1004,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1262,     0,     0,     0,  1004,  1504,     0,
       0,     0,  1509,     0,     0,     0,     0,     0,     0,     0,
    1262,     0,     0,     0,     0,     0,     0,     0,     0,  1262,
       0,  1262,     0,     0,     0,     0,     0,     0,  1509,  1262,
    1262,  1507,     0,  1262,     0,     0,     0,     0,     0,     0,
    1262,  1262,     0,     0,     0,     0,     0,     0,     0,     0,
    1262,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1504,     0,     0,  1262,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1697,
       0,     0,  1004,     0,     0,     0,     0,     0,  1697,     0,
    1697,     0,     0,     0,     0,     0,     0,     0,  1507,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1262,     0,  1697,     0,     0,  1697,     0,  2130,  2559,     0,
    2130,     0,     0,     0,  1697,     0,     0,     0,     0,     0,
       0,  1697,  1262,     0,     0,     0,  1697,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1697,     0,     0,
       0,  2130,  2130,  1697,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1697,     0,     0,     0,     0,     0,
       0,  1697,     0,  1697,  1697,  1697,  1697,  1697,  1697,  1697,
    1697,  1697,  1697,     0,     0,  1004,     0,     0,     0,     0,
       0,  1504,     0,     0,     0,     0,     0,     0,  1262,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     4,  1507,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     0,  1509,     0,
       0,     0,     0,     0,     0,     0,     0,     7,     8,     0,
       0,     0,     0,     9,     0,    10,    11,     0,  1697,  1004,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,     0,     0,     0,
       0,     0,  1004,     0,     0,  1509,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1504,     0,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1697,     0,     0,     0,     0,     0,  1504,     0,
       0,     0,     0,     0,     0,  1507,     0,     0,     0,     0,
       0,     0,     0,  1697,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1507,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    38,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    39,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1697,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    40,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,  1697,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1697,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2559,     0,  2130,     0,     0,  2130,
    2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,     0,
    2559,     0,     0,     0,     0,     0,    43,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1697,     0,     0,     0,     0,  2559,  2559,     0,  1504,     0,
       0,     0,     0,     0,     0,     0,     0,  2130,  2130,  1697,
       0,  1697,    44,     0,  1697,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    45,     0,     0,     0,     0,
       0,  1507,     0,     0,     0,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,    48,    49,     0,    50,  1504,    51,     0,     0,     0,
      52,     0,    53,    54,     0,     0,     0,    55,    56,    57,
      58,    59,     0,     0,    60,    61,    62,    63,     0,    64,
      65,    66,     0,    67,  1697,     0,     0,     0,  1507,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     4,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     7,     8,     0,     0,     0,     0,     0,
       0,    10,    11,  2130,     0,     0,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1697,     0,     0,     0,  1697,     0,     0,     0,     0,
    1697,  1697,     0,  1697,     0,     0,  2559,     0,     0,     0,
    2559,  2559,  2559,  2559,  2559,  2559,  2559,  2559,  2559,  2559,
    1697,  1697,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1697,  2130,  2130,  1697,     0,  1697,
       0,     0,    37,  1697,  2559,  2559,     0,     0,  1697,     0,
       0,  1697,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    38,     0,     0,     0,     0,     0,     0,     0,  1697,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    39,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      40,     0,     0,    41,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2559,     0,     0,     0,     0,
       0,     0,     0,     0,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1697,    43,     0,     0,     0,     0,     0,  2130,     0,
    2130,     0,     0,  2559,  2559,     0,     0,     0,  2130,  2130,
    1697,  1697,     0,  1697,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,  1697,     0,    48,    49,     0,
      50,     0,     0,     0,     0,     0,    52,     0,    53,    54,
       0,     0,     0,    55,    56,    57,    58,    59,     0,     0,
      60,    61,   972,     0,     0,     0,   973,     0,     0,  1697,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2559,  2130,  2559,     0,     0,  2559,  2559,  1697,     0,  1697,
       0,     0,     0,  1697,     0,     0,     0,     0,  1697,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   611,    79,    80,    81,
     366,    83,    84,     0,    85,    86,    87,   367,     0,   368,
       0,    91,  1697,    93,    94,    95,    96,    97,    98,   612,
      99,   100,   101,   369,   613,  2559,   103,   104,   105,   106,
     614,   615,   108,   109,   110,   111,     0,   112,   616,   617,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,   618,   387,   388,   619,
     620,   621,   622,   623,   624,   625,   389,   390,   626,   391,
     130,   392,   393,   394,   132,   133,   134,   135,     0,   627,
     395,   396,     0,   397,   628,   629,   398,   630,   136,   400,
     631,   401,   402,   403,   404,   140,   632,   633,   405,   406,
     407,   408,   634,   409,   410,   143,   411,   635,   412,   413,
     414,   146,   415,   636,   637,   638,   639,   640,   416,   417,
     418,   419,   420,   149,   150,   421,   641,   422,   642,   423,
       0,   424,   425,   426,   643,   427,   644,   645,   428,   429,
     430,   431,   646,   432,   433,   434,   647,   435,   648,   436,
     437,   438,   156,   439,     0,   158,   649,   440,   441,   160,
     650,   442,   651,   443,   161,   652,   162,   444,     0,   445,
     653,   446,   165,   654,   447,   655,   448,   449,   450,   166,
     451,   452,   453,   656,   454,   455,   456,   457,   458,   657,
     167,   168,   658,   459,   460,   461,   659,   170,   660,   171,
     661,     0,   172,   173,   462,   174,   463,   464,   465,   466,
     467,   662,   175,   176,   468,   177,   663,   469,   470,   471,
       0,     0,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   182,   183,   184,   664,   483,   484,   485,
     486,   487,   488,   489,   185,   490,   665,   491,   492,   187,
     493,   666,   188,   189,   494,   495,   667,   668,   496,   669,
     670,   671,   497,   498,   672,   673,   190,   191,   192,   193,
     499,   500,   501,     0,   194,   195,   502,   503,   504,   674,
     505,   506,   507,   508,   509,   510,   197,   511,   675,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
     202,   523,   524,   204,   525,   526,   527,   528,   529,   530,
       0,   676,   531,   532,   533,   677,   534,   208,   535,   536,
     210,   537,   211,   678,   538,   539,   540,   541,   542,   543,
     544,   545,   213,   546,   679,   547,   548,   680,   549,   550,
     551,   552,   681,   214,   215,   682,   554,   683,   555,   216,
     556,   217,   684,   557,   558,   559,   560,   561,   685,   686,
     562,   563,   564,   565,   687,   688,   566,   567,     0,   568,
     224,   569,   225,   570,     0,   689,   690,   571,   572,   573,
     574,   575,   576,     0,   226,     0,     0,   227,     0,     0,
       0,    79,    80,    81,     0,    83,    84,     0,    85,    86,
      87,     0,     0,     0,    90,    91,     0,    93,    94,    95,
      96,    97,    98,   691,    99,   100,   101,     0,     0,     0,
     103,   104,   105,   106,     0,   107,   108,   109,   110,   111,
       0,   112,   113,   114,   115,     0,     0,     0,     0,     0,
     118,   119,     0,     0,     0,     0,   120,     0,     0,     0,
       0,     0,     0,     0,     0,   121,     0,   122,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   130,     0,     0,     0,   132,   133,
     134,   135,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   136,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   143,
       0,     0,     0,     0,     0,   146,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   149,   150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   156,     0,     0,   158,
       0,     0,     0,   160,     0,     0,     0,     0,   161,     0,
     162,     0,     0,     0,     0,     0,   165,     0,     0,     0,
       0,     0,     0,   166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   170,     0,   171,     0,     0,   172,   173,     0,   174,
       0,     0,     0,     0,     0,     0,   175,   176,     0,   177,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   182,   183,   184,
       0,     0,     0,     0,     0,     0,     0,     0,   185,     0,
       0,     0,     0,   187,     0,     0,   188,   189,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     190,   191,   192,   193,     0,     0,     0,     0,   194,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   202,     0,     0,   204,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   208,     0,     0,   210,     0,   211,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   213,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   214,   215,     0,
       0,     0,     0,   216,     0,   217,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
       0,     0,     0,     0,     0,    79,    80,    81,   226,    83,
      84,   227,    85,    86,    87,     0,     0,     0,    90,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,     0,     0,     0,   103,   104,   105,   106,  2246,   107,
     108,   109,   110,   111,     0,   112,   113,   114,   115,     0,
       0,     0,     0,     0,   118,   119,     0,     0,     0,     0,
     120,     0,     0,     0,     0,     0,     0,     0,     0,   121,
       0,   122,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   130,     0,
       0,     0,   132,   133,   134,   135,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   136,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   143,     0,     0,     0,     0,     0,   146,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   149,   150,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     156,     0,     0,   158,     0,     0,     0,   160,     0,     0,
       0,     0,   161,     0,   162,     0,     0,     0,     0,     0,
     165,     0,     0,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   170,     0,   171,     0,     0,
     172,   173,     0,   174,     0,     0,     0,     0,     0,     0,
     175,   176,     0,   177,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   182,   183,   184,     0,     0,     0,     0,     0,     0,
       0,     0,   185,     0,     0,     0,     0,   187,     0,     0,
     188,   189,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   190,   191,   192,   193,     0,     0,
       0,     0,   194,   195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   202,     0,
       0,   204,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   208,     0,     0,   210,     0,
     211,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     213,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   214,   215,     0,     0,     0,     0,   216,     0,   217,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,   227,     0,    78,     0,     0,
      79,    80,    81,    82,    83,    84,     0,    85,    86,    87,
      88,     0,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,  2248,    99,   100,   101,   102,     0,     0,   103,
     104,   105,   106,     0,   107,   108,   109,   110,   111,     0,
     112,   113,   114,   115,   116,   117,     0,     0,     0,   118,
     119,     0,     0,     0,     0,   120,     0,     0,     0,     0,
       0,     0,     0,     0,   121,     0,   122,     0,   123,   124,
       0,   125,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   126,   127,   128,     0,     0,     0,     0,     0,     0,
       0,     0,   129,   130,     0,     0,   131,   132,   133,   134,
     135,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   136,     0,     0,   137,     0,   138,   139,   140,     0,
       0,   141,   142,     0,     0,     0,     0,     0,   143,   144,
     145,     0,     0,     0,   146,     0,     0,     0,     0,     0,
       0,     0,     0,   147,     0,   148,   149,   150,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
       0,     0,     0,   153,     0,     0,     0,     0,     0,   154,
       0,     0,     0,     0,   155,   156,   157,     0,   158,     0,
     159,     0,   160,     0,     0,     0,     0,   161,     0,   162,
       0,   163,     0,   164,     0,   165,     0,     0,     0,     0,
       0,     0,   166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
     170,     0,   171,     0,     0,   172,   173,     0,   174,     0,
       0,     0,     0,     0,     0,   175,   176,     0,   177,     0,
     178,   179,     0,     0,     0,     0,   180,     0,     0,     0,
       0,     0,     0,     0,   181,     0,   182,   183,   184,     0,
       0,     0,     0,     0,     0,     0,     0,   185,     0,     0,
       0,   186,   187,     0,     0,   188,   189,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   190,
     191,   192,   193,     0,     0,     0,     0,   194,   195,     0,
     196,     0,     0,     0,     0,     0,     0,     0,     0,   197,
       0,     0,   198,     0,   199,     0,     0,     0,   200,     0,
       0,     0,   201,   202,     0,   203,   204,     0,     0,   205,
       0,     0,     0,     0,   206,     0,     0,     0,     0,   207,
     208,     0,   209,   210,     0,   211,     0,     0,   212,     0,
       0,     0,     0,     0,     0,   213,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   214,   215,     0,     0,
       0,     0,   216,     0,   217,     0,   218,     0,   219,     0,
       0,   220,     0,     0,   221,     0,   222,     0,     0,   223,
       0,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
     227,     0,     0,     0,     0,     0,   611,    79,    80,    81,
     366,    83,    84,     0,    85,    86,    87,   367,     0,   368,
       0,    91,   228,    93,    94,    95,    96,    97,    98,   612,
      99,   100,   101,   369,   613,     0,   103,   104,   105,   106,
     614,   615,   108,   109,   110,   111,     0,   112,   616,   617,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,  2208,   387,   388,     0,
       0,     0,     0,  1168,     0,     0,   389,   390,     0,   391,
     130,   392,   393,   394,   132,  1169,   134,  1170,  1171,     0,
     395,   396,     0,   397,  1172,  1173,   398,  1174,  1175,   400,
       0,   401,   402,   403,   404,  1176,     0,     0,   405,   406,
     407,   408,     0,   409,   410,  1177,   411,     0,   412,   413,
     414,   146,   415,  1178,  1179,  1180,  1181,  1182,   416,   417,
     418,   419,   420,  1183,  1184,   421,     0,   422,     0,   423,
       0,   424,   425,   426,     0,   427,  2209,     0,   428,  1185,
     430,   431,     0,   432,   433,   434,     0,   435,     0,   436,
     437,   438,  1186,   439,     0,  1187,  1188,   440,   441,  1189,
       0,   442,     0,   443,   161,     0,   162,   444,     0,   445,
       0,   446,  1190,     0,   447,     0,   448,   449,   450,   166,
     451,   452,   453,     0,   454,   455,   456,   457,   458,     0,
     167,   168,     0,   459,   460,   461,  1191,  1192,     0,  1193,
       0,     0,   172,   173,   462,   174,   463,   464,   465,   466,
     467,     0,  1194,   176,   468,   177,     0,   469,   470,   471,
    1195,  1196,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,  1197,   183,  1198,   740,   483,   484,   485,
     486,   487,   488,   489,   185,   490,  1199,   491,   492,   187,
     493,  1200,  1201,  1202,   494,   495,     0,     0,   496,   741,
       0,     0,  1203,   498,     0,     0,   190,   191,   192,  1204,
     499,   500,   501,     0,  1205,   195,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,  1206,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
     202,   523,   524,  1207,   525,   526,   527,   528,   529,   530,
       0,     0,   531,   532,   533,  1208,   534,   208,   535,   536,
     210,   537,  1209,     0,   538,   539,   540,   541,   542,   543,
     544,   545,  1210,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,  1211,  1212,     0,   554,     0,   555,  1213,
     556,  1214,  1215,   557,   558,   559,   560,   561,     0,  1216,
     562,   563,   564,   565,  1217,     0,   566,   567,     0,   568,
    1218,   569,   225,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,    49,  1219,   227,   577,     0,
       0,  1220,  1221,    52,  1222,    53,     0,     0,     0,     0,
    1223,  1224,  2210,     0,     0,     0,     0,     0,     0,  1226,
    2211,   611,    79,    80,    81,   366,    83,    84,     0,    85,
      86,    87,   367,     0,   368,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   612,    99,   100,   101,   369,   613,
       0,   103,   104,   105,   106,   614,   615,   108,   109,   110,
     111,     0,   112,   616,   617,   115,   370,   371,     0,     0,
       0,   372,   373,     0,     0,     0,     0,   374,     0,     0,
       0,     0,     0,     0,     0,     0,   375,     0,   376,     0,
     377,   378,     0,   379,   380,   381,   382,   383,   384,   385,
     386,     0,   387,   388,     0,     0,     0,     0,  1168,     0,
       0,   389,   390,     0,   391,   130,   392,   393,   394,   132,
    1169,   134,  1170,  1171,     0,   395,   396,     0,   397,  1172,
    1173,   398,  1174,  1175,   400,     0,   401,   402,   403,   404,
    1176,     0,     0,   405,   406,   407,   408,     0,   409,   410,
    1177,   411,     0,   412,   413,   414,   146,   415,  1178,  1179,
    1180,  1181,  1182,   416,   417,   418,   419,   420,  1183,  1184,
     421,     0,   422,     0,   423,     0,   424,   425,   426,     0,
     427,     0,     0,   428,  1185,   430,   431,     0,   432,   433,
     434,     0,   435,     0,   436,   437,   438,  1186,   439,     0,
    1187,  1188,   440,   441,  1189,     0,   442,     0,   443,   161,
       0,   162,   444,     0,   445,     0,   446,  1190,     0,   447,
       0,   448,   449,   450,   166,   451,   452,   453,     0,   454,
     455,   456,   457,   458,     0,   167,   168,     0,   459,   460,
     461,  1191,  1192,     0,  1193,     0,     0,   172,   173,   462,
     174,   463,   464,   465,   466,   467,     0,  1194,   176,   468,
     177,     0,   469,   470,   471,  1195,  1196,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,  1197,   183,
    1198,   740,   483,   484,   485,   486,   487,   488,   489,   185,
     490,  1199,   491,   492,   187,   493,  1200,  1201,  1202,   494,
     495,     0,     0,   496,   741,     0,     0,  1203,   498,     0,
       0,   190,   191,   192,  1204,   499,   500,   501,     0,  1205,
     195,   502,   503,   504,     0,   505,   506,   507,   508,   509,
     510,  1206,   511,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   522,   202,   523,   524,  1207,   525,
     526,   527,   528,   529,   530,     0,     0,   531,   532,   533,
    1208,   534,   208,   535,   536,   210,   537,  1209,     0,   538,
     539,   540,   541,   542,   543,   544,   545,  1210,   546,     0,
     547,   548,     0,   549,   550,   551,   552,     0,  1211,  1212,
       0,   554,     0,   555,  1213,   556,  1214,  1215,   557,   558,
     559,   560,   561,     0,  1216,   562,   563,   564,   565,  1217,
       0,   566,   567,     0,   568,  1218,   569,   225,   570,     0,
       0,     0,   571,   572,   573,   574,   575,   576,     0,   226,
      49,  1219,   227,   577,     0,     0,  1220,  1221,    52,  1222,
      53,     0,     0,     0,     0,  1223,  1224,     0,     0,     0,
       0,     0,     0,     0,  1226,  2132,   611,    79,    80,    81,
     366,    83,    84,     0,    85,    86,    87,   367,     0,   368,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   612,
      99,   100,   101,   369,   613,     0,   103,   104,   105,   106,
     614,   615,   108,   109,   110,   111,     0,   112,   616,   617,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,     0,     0,     0,     0,   389,   390,     0,   391,
     130,   392,   393,   394,   132,  1476,   134,  1477,  1171,     0,
     395,   396,     0,   397,     0,     0,   398,  1478,  1479,   400,
       0,   401,   402,   403,   404,     0,     0,     0,   405,   406,
     407,   408,     0,   409,   410,     0,   411,     0,   412,   413,
     414,   146,   415,     0,     0,     0,     0,     0,   416,   417,
     418,   419,   420,  1480,  1481,   421,     0,   422,     0,   423,
       0,   424,   425,   426,     0,   427,     0,     0,   428,  1185,
     430,   431,     0,   432,   433,   434,     0,   435,     0,   436,
     437,   438,     0,   439,     0,     0,     0,   440,   441,  1482,
       0,   442,     0,   443,   161,     0,   162,   444,     0,   445,
       0,   446,     0,     0,   447,     0,   448,   449,   450,   166,
     451,   452,   453,  1852,   454,   455,   456,   457,   458,     0,
     167,  1853,     0,   459,   460,   461,  1191,  1483,     0,  1484,
       0,     0,   172,   173,   462,   174,   463,   464,   465,   466,
     467,     0,     0,   176,   468,   177,     0,   469,   470,   471,
       0,     0,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,  1485,   183,  1486,     0,   483,   484,   485,
     486,   487,   488,   489,     0,   490,     0,   491,   492,   187,
     493,     0,     0,  1487,   494,   495,     0,     0,   496,     0,
       0,     0,   497,   498,     0,     0,  1854,   191,   192,     0,
     499,   500,   501,     0,     0,     0,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,  1488,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
     202,   523,   524,     0,   525,   526,   527,   528,   529,   530,
       0,     0,   531,   532,   533,     0,   534,  1489,   535,   536,
     210,   537,  1490,     0,   538,   539,   540,   541,   542,   543,
     544,   545,     0,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,  1491,  1492,     0,   554,     0,   555,     0,
     556,     0,     0,   557,   558,   559,   560,   561,     0,     0,
     562,   563,   564,   565,     0,     0,   566,   567,     0,   568,
    1493,   569,   225,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,     0,     0,   227,    79,    80,
      81,   366,    83,    84,     0,    85,    86,    87,   367,     0,
     368,     0,    91,     0,    93,    94,    95,    96,    97,    98,
    1855,    99,   100,   101,   369,     0,     0,   103,   104,   105,
     106,     0,     0,   108,   109,   110,   111,     0,   112,     0,
       0,   115,   370,   371,     0,     0,     0,   372,   373,     0,
       0,     0,     0,   374,     0,     0,     0,     0,     0,     0,
       0,     0,   375,     0,   376,     0,   377,   378,     0,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,     0,     0,     0,     0,   389,   390,     0,
     391,     0,   392,   393,   394,     0,   133,     0,   135,     0,
       0,   395,   396,     0,   397,     0,     0,   398,   399,   136,
     400,     0,   401,   402,   403,   404,   140,     0,     0,   405,
     406,   407,   408,     0,   409,   410,   143,   411,     0,   412,
     413,   414,     0,   415,     0,     0,     0,     0,     0,   416,
     417,   418,   419,   420,   149,   150,   421,     0,   422,     0,
     423,     0,   424,   425,   426,     0,   427,     0,     0,   428,
     429,   430,   431,     0,   432,   433,   434,     0,   435,     0,
     436,   437,   438,   156,   439,     0,   158,     0,   440,   441,
     160,     0,   442,     0,   443,     0,     0,     0,   444,     0,
     445,     0,   446,   165,     0,   447,     0,   448,   449,   450,
       0,   451,   452,   453,     0,   454,   455,   456,   457,   458,
       0,     0,   168,     0,   459,   460,   461,     0,   170,     0,
     171,     0,     0,     0,     0,   462,     0,   463,   464,   465,
     466,   467,     0,   175,     0,   468,     0,     0,   469,   470,
     471,     0,     0,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,   182,     0,   184,     0,   483,   484,
     485,   486,   487,   488,   489,   185,   490,     0,   491,   492,
       0,   493,     0,   188,   189,   494,   495,     0,     0,   496,
       0,     0,     0,   497,   498,     0,     0,   190,     0,     0,
     193,   499,   500,   501,     0,   194,   195,   502,   503,   504,
       0,   505,   506,   507,   508,   509,   510,   197,   511,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   524,   204,   525,   526,   527,   528,   529,
     530,     0,     0,   531,   532,   533,     0,   534,   208,   535,
     536,     0,   537,   211,     0,   538,   539,   540,   541,   542,
     543,   544,   545,   213,   546,     0,   547,   548,     0,   549,
     550,   551,   552,     0,   214,   215,     0,   554,     0,   555,
     216,   556,   217,     0,   557,   558,   559,   560,   561,     0,
       0,   562,   563,   564,   565,     0,  3225,   566,   567,     0,
     568,   224,   569,     0,   570,     4,     0,     0,   571,   572,
     573,   574,   575,   576,     0,   226,     0,     0,   227,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1240,     7,
       8,     0, -1240,     0,     0,     0,     0,    10,    11,     0,
       0,     0,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,     0,     0,     0,     4,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     7,     8,     0,    36,     0,     0,     0,
       0,    10,    11,     0,     0,     0,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,     0,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    38,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    40,     0,     0,    41,
       0,     0,    37,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      42,    38,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    39,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      40,     0,     0,    41,     0,     0,     0,     0,    43,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,    43,    48,    49,     0,    50,     0,     0,     0,
       0,     0,    52,     0,    53,    54,     0,     0,     0,    55,
      56,    57,    58,    59,     0,     0,    60,    61,   972,  1357,
       0,     0,     0,     0,     0,     0,     0,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,    48,    49,     0,
      50,     0,     0,     0,     0,     0,    52,     0,    53,    54,
       0,     0,     0,    55,    56,    57,    58,    59,     0,     0,
      60,    61,   972,  1809,   611,    79,    80,    81,   366,    83,
      84,     0,    85,    86,    87,   367,     0,   368,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   612,    99,   100,
     101,   369,   613,     0,   103,   104,   105,   106,   614,   615,
     108,   109,   110,   111,     0,   112,   616,   617,   115,   370,
     371,     0,     0,     0,   372,   373,     0,     0,     0,     0,
     374,     0,     0,     0,     0,     0,     0,     0,     0,   375,
       0,   376,     0,   377,   378,     0,   379,   380,   381,   382,
     383,   384,   385,   386,     0,   387,   388,     0,     0,     0,
       0,  1168,     0,     0,   389,   390,     0,   391,   130,   392,
     393,   394,   132,  1169,   134,  1170,  1171,  2142,   395,   396,
       0,   397,  1172,  1173,   398,  1174,  1175,   400,     0,   401,
     402,   403,   404,  1176,     0,     0,   405,   406,   407,   408,
       0,   409,   410,  1177,   411,     0,   412,   413,   414,   146,
     415,  1178,  1179,  1180,  1181,  1182,   416,   417,   418,   419,
     420,  1183,  1184,   421,     0,   422,     0,   423,     0,   424,
     425,   426,     0,   427,     0,     0,   428,  1185,   430,   431,
       0,   432,   433,   434,     0,   435,     0,   436,   437,   438,
    1186,   439,     0,  1187,  1188,   440,   441,  1189,     0,   442,
       0,   443,   161,  2143,   162,   444,     0,   445,     0,   446,
    1190,     0,   447,     0,   448,   449,   450,   166,   451,   452,
     453,     0,   454,   455,   456,   457,   458,     0,   167,   168,
       0,   459,   460,   461,  1191,  1192,     0,  1193,     0,     0,
     172,   173,   462,   174,   463,   464,   465,   466,   467,  2144,
    1194,   176,   468,   177,     0,   469,   470,   471,  1195,  1196,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,  1197,   183,  1198,   740,   483,   484,   485,   486,   487,
     488,   489,   185,   490,  1199,   491,   492,   187,   493,  1200,
    1201,  1202,   494,   495,     0,     0,   496,   741,     0,     0,
    1203,   498,     0,     0,   190,   191,   192,  1204,   499,   500,
     501,     0,  1205,   195,   502,   503,   504,     0,   505,   506,
     507,   508,   509,   510,  1206,   511,     0,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   202,   523,
     524,  1207,   525,   526,   527,   528,   529,   530,     0,     0,
     531,   532,   533,  1208,   534,   208,   535,   536,   210,   537,
    1209,     0,   538,   539,   540,   541,   542,   543,   544,   545,
    1210,   546,     0,   547,   548,     0,   549,   550,   551,   552,
       0,  1211,  1212,     0,   554,  2145,   555,  1213,   556,  1214,
    1215,   557,   558,   559,   560,   561,     0,  1216,   562,   563,
     564,   565,  1217,     0,   566,   567,     0,   568,  1218,   569,
     225,   570,     0,     0,     0,   571,   572,   573,   574,   575,
     576,     0,   226,    49,  1219,   227,   577,     0,     0,  1220,
    1221,    52,  1222,    53,     0,     0,     0,     0,  1223,  1224,
     611,    79,    80,    81,   366,    83,    84,  1226,    85,    86,
      87,   367,     0,   368,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   612,    99,   100,   101,   369,   613,     0,
     103,   104,   105,   106,   614,   615,   108,   109,   110,   111,
       0,   112,   616,   617,   115,   370,   371,     0,     0,     0,
     372,   373,     0,     0,     0,     0,   374,     0,     0,     0,
       0,     0,     0,     0,     0,   375,     0,   376,     0,   377,
     378,     0,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,     0,  1168,     0,     0,
     389,   390,     0,   391,   130,   392,   393,   394,   132,  1169,
     134,  1170,  1171,     0,   395,   396,     0,   397,  1172,  1173,
     398,  1174,  1175,   400,     0,   401,   402,   403,   404,  1176,
       0,     0,   405,   406,   407,   408,     0,   409,   410,  1177,
     411,     0,   412,   413,   414,   146,   415,  1178,  1179,  1180,
    1181,  1182,   416,   417,   418,   419,   420,  1183,  1184,   421,
       0,   422,     0,   423,     0,   424,   425,   426,     0,   427,
       0,     0,   428,  1185,   430,   431,     0,   432,   433,   434,
       0,   435,     0,   436,   437,   438,  1186,   439,     0,  1187,
    1188,   440,   441,  1189,     0,   442,     0,   443,   161,     0,
     162,   444,     0,   445,     0,   446,  1190,     0,   447,     0,
     448,   449,   450,   166,   451,   452,   453,     0,   454,   455,
     456,   457,   458,     0,   167,   168,     0,   459,   460,   461,
    1191,  1192,     0,  1193,     0,     0,   172,   173,   462,   174,
     463,   464,   465,   466,   467,     0,  1194,   176,   468,   177,
       0,   469,   470,   471,  1195,  1196,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,  1197,   183,  1198,
     740,   483,   484,   485,   486,   487,   488,   489,   185,   490,
    1199,   491,   492,   187,   493,  1200,  1201,  1202,   494,   495,
       0,     0,   496,   741,     0,     0,  1203,   498,     0,     0,
     190,   191,   192,  1204,   499,   500,   501,     0,  1205,   195,
     502,   503,   504,     0,   505,   506,   507,   508,   509,   510,
    1206,   511,     0,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   522,   202,   523,   524,  1207,   525,   526,
     527,   528,   529,   530,     0,     0,   531,   532,   533,  1208,
     534,   208,   535,   536,   210,   537,  1209,     0,   538,   539,
     540,   541,   542,   543,   544,   545,  1210,   546,     0,   547,
     548,     0,   549,   550,   551,   552,     0,  1211,  1212,     0,
     554,     0,   555,  1213,   556,  1214,  1215,   557,   558,   559,
     560,   561,     0,  1216,   562,   563,   564,   565,  1217,     0,
     566,   567,     0,   568,  1218,   569,   225,   570,     0,     0,
       0,   571,   572,   573,   574,   575,   576,     0,   226,    49,
    1219,   227,   577,     0,     0,  1220,  1221,    52,  1222,    53,
       0,     0,     0,     0,  1223,  1224,  1225,     0,     0,     0,
       0,     0,     0,  1226,   611,    79,    80,    81,   366,    83,
      84,     0,    85,    86,    87,   367,     0,   368,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   612,    99,   100,
     101,   369,   613,     0,   103,   104,   105,   106,   614,   615,
     108,   109,   110,   111,     0,   112,   616,   617,   115,   370,
     371,     0,     0,     0,   372,   373,     0,     0,     0,     0,
     374,     0,     0,     0,     0,     0,     0,     0,     0,   375,
       0,   376,     0,   377,   378,     0,   379,   380,   381,   382,
     383,   384,   385,   386,     0,   387,   388,     0,     0,     0,
       0,  1168,     0,     0,   389,   390,     0,   391,   130,   392,
     393,   394,   132,  1169,   134,  1170,  1171,     0,   395,   396,
       0,   397,  1172,  1173,   398,  1174,  1175,   400,     0,   401,
     402,   403,   404,  1176,     0,     0,   405,   406,   407,   408,
       0,   409,   410,  1177,   411,     0,   412,   413,   414,   146,
     415,  1178,  1179,  1180,  1181,  1182,   416,   417,   418,   419,
     420,  1183,  1184,   421,     0,   422,     0,   423,     0,   424,
     425,   426,     0,   427,     0,     0,   428,  1185,   430,   431,
       0,   432,   433,   434,     0,   435,     0,   436,   437,   438,
    1186,   439,     0,  1187,  1188,   440,   441,  1189,     0,   442,
       0,   443,   161,     0,   162,   444,     0,   445,     0,   446,
    1190,     0,   447,     0,   448,   449,   450,   166,   451,   452,
     453,     0,   454,   455,   456,   457,   458,     0,   167,   168,
       0,   459,   460,   461,  1191,  1192,     0,  1193,     0,     0,
     172,   173,   462,   174,   463,   464,   465,   466,   467,     0,
    1194,   176,   468,   177,     0,   469,   470,   471,  1195,  1196,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,  1197,   183,  1198,   740,   483,   484,   485,   486,   487,
     488,   489,   185,   490,  1199,   491,   492,   187,   493,  1200,
    1201,  1202,   494,   495,     0,     0,   496,   741,     0,     0,
    1203,   498,     0,     0,   190,   191,   192,  1204,   499,   500,
     501,     0,  1205,   195,   502,   503,   504,     0,   505,   506,
     507,   508,   509,   510,  1206,   511,     0,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   202,   523,
     524,  1207,   525,   526,   527,   528,   529,   530,     0,   206,
     531,   532,   533,  1208,   534,   208,   535,   536,   210,   537,
    1209,     0,   538,   539,   540,   541,   542,   543,   544,   545,
    1210,   546,     0,   547,   548,     0,   549,   550,   551,   552,
       0,  1211,  1212,     0,   554,     0,   555,  1213,   556,  1214,
    1215,   557,   558,   559,   560,   561,     0,  1216,   562,   563,
     564,   565,  1217,     0,   566,   567,     0,   568,  1218,   569,
     225,   570,     0,     0,     0,   571,   572,   573,   574,   575,
     576,     0,   226,    49,  1219,   227,   577,     0,     0,  1220,
    1221,    52,  1222,    53,     0,     0,     0,     0,  1223,  1224,
     611,    79,    80,    81,   366,    83,    84,  1226,    85,    86,
      87,   367,     0,   368,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   612,    99,   100,   101,   369,   613,     0,
     103,   104,   105,   106,   614,   615,   108,   109,   110,   111,
       0,   112,   616,   617,   115,   370,   371,     0,     0,     0,
     372,   373,     0,     0,     0,     0,   374,     0,     0,     0,
       0,     0,     0,     0,     0,   375,     0,   376,     0,   377,
     378,     0,   379,   380,   381,   382,   383,   384,   385,   386,
    1766,   387,   388,     0,     0,     0,     0,  1168,     0,     0,
     389,   390,     0,   391,   130,   392,   393,   394,   132,  1169,
     134,  1170,  1171,     0,   395,   396,     0,   397,  1172,  1173,
     398,  1174,  1175,   400,     0,   401,   402,   403,   404,  1176,
       0,     0,   405,   406,   407,   408,     0,   409,   410,  1177,
     411,     0,   412,   413,   414,   146,   415,  1178,  1179,  1180,
    1181,  1182,   416,   417,   418,   419,   420,  1183,  1184,   421,
       0,   422,     0,   423,     0,   424,   425,   426,     0,   427,
       0,     0,   428,  1185,   430,   431,     0,   432,   433,   434,
       0,   435,     0,   436,   437,   438,  1186,   439,     0,  1187,
    1188,   440,   441,  1189,     0,   442,     0,   443,   161,     0,
     162,   444,     0,   445,     0,   446,  1190,     0,   447,     0,
     448,   449,   450,   166,   451,   452,   453,     0,   454,   455,
     456,   457,   458,     0,   167,   168,     0,   459,   460,   461,
    1191,  1192,     0,  1193,     0,     0,   172,   173,   462,   174,
     463,   464,   465,   466,   467,     0,  1194,   176,   468,   177,
       0,   469,   470,   471,  1195,  1196,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,  1197,   183,  1198,
     740,   483,   484,   485,   486,   487,   488,   489,   185,   490,
    1199,   491,   492,   187,   493,  1200,  1201,  1202,   494,   495,
       0,     0,   496,   741,     0,     0,  1203,   498,     0,     0,
     190,   191,   192,  1204,   499,   500,   501,     0,  1205,   195,
     502,   503,   504,     0,   505,   506,   507,   508,   509,   510,
    1206,   511,     0,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   522,   202,   523,   524,  1207,   525,   526,
     527,   528,   529,   530,     0,     0,   531,   532,   533,  1208,
     534,   208,   535,   536,   210,   537,  1209,     0,   538,   539,
     540,   541,   542,   543,   544,   545,  1210,   546,     0,   547,
     548,     0,   549,   550,   551,   552,     0,  1211,  1212,     0,
     554,     0,   555,  1213,   556,  1214,  1215,   557,   558,   559,
     560,   561,     0,  1216,   562,   563,   564,   565,  1217,     0,
     566,   567,     0,   568,  1218,   569,   225,   570,     0,     0,
       0,   571,   572,   573,   574,   575,   576,     0,   226,    49,
    1219,   227,   577,     0,     0,  1220,  1221,    52,  1222,    53,
       0,     0,     0,     0,  1223,  1224,   611,    79,    80,    81,
     366,    83,    84,  1226,    85,    86,    87,   367,     0,   368,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   612,
      99,   100,   101,   369,   613,     0,   103,   104,   105,   106,
     614,   615,   108,   109,   110,   111,     0,   112,   616,   617,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,     0,  1168,     0,     0,   389,   390,     0,   391,
     130,   392,   393,   394,   132,  1169,   134,  1170,  1171,     0,
     395,   396,     0,   397,  1172,  1173,   398,  1174,  1175,   400,
       0,   401,   402,   403,   404,  1176,     0,     0,   405,   406,
     407,   408,     0,   409,   410,  1177,   411,     0,   412,   413,
     414,   146,   415,  1178,  1179,  1180,  1181,  1182,   416,   417,
     418,   419,   420,  1183,  1184,   421,     0,   422,     0,   423,
       0,   424,   425,   426,     0,   427,     0,     0,   428,  1185,
     430,   431,     0,   432,   433,   434,     0,   435,     0,   436,
     437,   438,  1186,   439,     0,  1187,  1188,   440,   441,  1189,
       0,   442,     0,   443,   161,     0,   162,   444,     0,   445,
       0,   446,  1190,     0,   447,     0,   448,   449,   450,   166,
     451,   452,   453,     0,   454,   455,   456,   457,   458,     0,
     167,   168,     0,   459,   460,   461,  1191,  1192,     0,  1193,
       0,     0,   172,   173,   462,   174,   463,   464,   465,   466,
     467,     0,  1194,   176,   468,   177,     0,   469,   470,   471,
    1195,  1196,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,  1197,   183,  1198,   740,   483,   484,   485,
     486,   487,   488,   489,   185,   490,  1199,   491,   492,   187,
     493,  1200,  1201,  1202,   494,   495,     0,     0,   496,   741,
       0,     0,  1203,   498,     0,     0,   190,   191,   192,  1204,
     499,   500,   501,     0,  1205,   195,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,  1206,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
     202,   523,   524,  1207,   525,   526,   527,   528,   529,   530,
       0,     0,   531,   532,   533,  1208,   534,   208,   535,   536,
     210,   537,  1209,     0,   538,   539,   540,   541,   542,   543,
     544,   545,  1210,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,  1211,  1212,     0,   554,     0,   555,  1213,
     556,  1214,  1215,   557,   558,   559,   560,   561,     0,  1216,
     562,   563,   564,   565,  1217,     0,   566,   567,     0,   568,
    1218,   569,   225,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,    49,  1219,   227,   577,     0,
       0,  1220,  1221,    52,  1222,    53,     0,     0,     0,     0,
    1223,  1224,     0,     0,     0,     0,     0,  1612,     0,  1226,
     611,    79,    80,    81,   366,    83,    84,     0,    85,    86,
      87,   367,     0,   368,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   612,    99,   100,   101,   369,   613,     0,
     103,   104,   105,   106,   614,   615,   108,   109,   110,   111,
       0,   112,   616,   617,   115,   370,   371,     0,     0,     0,
     372,   373,     0,     0,     0,     0,   374,     0,     0,     0,
       0,     0,     0,     0,     0,   375,     0,   376,     0,   377,
     378,     0,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,     0,  1168,     0,     0,
     389,   390,     0,   391,   130,   392,   393,   394,   132,  1169,
     134,  1170,  1171,     0,   395,   396,     0,   397,  1172,  1173,
     398,  1174,  1175,   400,     0,   401,   402,   403,   404,  1176,
       0,     0,   405,   406,   407,   408,     0,   409,   410,  1177,
     411,     0,   412,   413,   414,   146,   415,  1178,  1179,  1180,
    1181,  1182,   416,   417,   418,   419,   420,  1183,  1184,   421,
    2494,   422,     0,   423,     0,   424,   425,   426,     0,   427,
       0,     0,   428,  1185,   430,   431,     0,   432,   433,   434,
       0,   435,     0,   436,   437,   438,  1186,   439,     0,  1187,
    1188,   440,   441,  1189,     0,   442,     0,   443,   161,     0,
     162,   444,     0,   445,     0,   446,  1190,     0,   447,     0,
     448,   449,   450,   166,   451,   452,   453,     0,   454,   455,
     456,   457,   458,     0,   167,   168,     0,   459,   460,   461,
    1191,  1192,     0,  1193,     0,     0,   172,   173,   462,   174,
     463,   464,   465,   466,   467,     0,  1194,   176,   468,   177,
       0,   469,   470,   471,  1195,  1196,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,  1197,   183,  1198,
     740,   483,   484,   485,   486,   487,   488,   489,   185,   490,
    1199,   491,   492,   187,   493,  1200,  1201,  1202,   494,   495,
       0,     0,   496,   741,     0,     0,  1203,   498,     0,     0,
     190,   191,   192,  1204,   499,   500,   501,     0,  1205,   195,
     502,   503,   504,     0,   505,   506,   507,   508,   509,   510,
    1206,   511,     0,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   522,   202,   523,   524,  1207,   525,   526,
     527,   528,   529,   530,     0,     0,   531,   532,   533,  1208,
     534,   208,   535,   536,   210,   537,  1209,     0,   538,   539,
     540,   541,   542,   543,   544,   545,  1210,   546,     0,   547,
     548,     0,   549,   550,   551,   552,     0,  1211,  1212,     0,
     554,     0,   555,  1213,   556,  1214,  1215,   557,   558,   559,
     560,   561,     0,  1216,   562,   563,   564,   565,  1217,     0,
     566,   567,     0,   568,  1218,   569,   225,   570,     0,     0,
       0,   571,   572,   573,   574,   575,   576,     0,   226,    49,
    1219,   227,   577,     0,     0,  1220,  1221,    52,  1222,    53,
       0,     0,     0,     0,  1223,  1224,   611,    79,    80,    81,
     366,    83,    84,  1226,    85,    86,    87,   367,     0,   368,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   612,
      99,   100,   101,   369,   613,     0,   103,   104,   105,   106,
     614,   615,   108,   109,   110,   111,     0,   112,   616,   617,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,     0,  1168,     0,     0,   389,   390,     0,   391,
     130,   392,   393,   394,   132,  1169,   134,  1170,  1171,     0,
     395,   396,     0,   397,  1172,  1173,   398,  1174,  1175,   400,
       0,   401,   402,   403,   404,  1176,     0,     0,   405,   406,
     407,   408,     0,   409,   410,  1177,   411,     0,   412,   413,
     414,   146,   415,  1178,  1179,  1180,  1181,  1182,   416,   417,
     418,   419,   420,  1183,  1184,   421,     0,   422,     0,   423,
       0,   424,   425,   426,     0,   427,     0,     0,   428,  1185,
     430,   431,     0,   432,   433,   434,     0,   435,     0,   436,
     437,   438,  1186,   439,     0,  1187,  1188,   440,   441,  1189,
       0,   442,     0,   443,   161,  2143,   162,   444,     0,   445,
       0,   446,  1190,     0,   447,     0,   448,   449,   450,   166,
     451,   452,   453,     0,   454,   455,   456,   457,   458,     0,
     167,   168,     0,   459,   460,   461,  1191,  1192,     0,  1193,
       0,     0,   172,   173,   462,   174,   463,   464,   465,   466,
     467,     0,  1194,   176,   468,   177,     0,   469,   470,   471,
    1195,  1196,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,  1197,   183,  1198,   740,   483,   484,   485,
     486,   487,   488,   489,   185,   490,  1199,   491,   492,   187,
     493,  1200,  1201,  1202,   494,   495,     0,     0,   496,   741,
       0,     0,  1203,   498,     0,     0,   190,   191,   192,  1204,
     499,   500,   501,     0,  1205,   195,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,  1206,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
     202,   523,   524,  1207,   525,   526,   527,   528,   529,   530,
       0,     0,   531,   532,   533,  1208,   534,   208,   535,   536,
     210,   537,  1209,     0,   538,   539,   540,   541,   542,   543,
     544,   545,  1210,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,  1211,  1212,     0,   554,     0,   555,  1213,
     556,  1214,  1215,   557,   558,   559,   560,   561,     0,  1216,
     562,   563,   564,   565,  1217,     0,   566,   567,     0,   568,
    1218,   569,   225,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,    49,  1219,   227,   577,     0,
       0,  1220,  1221,    52,  1222,    53,     0,     0,     0,     0,
    1223,  1224,   611,    79,    80,    81,   366,    83,    84,  1226,
      85,    86,    87,   367,     0,   368,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   612,    99,   100,   101,   369,
     613,     0,   103,   104,   105,   106,   614,   615,   108,   109,
     110,   111,     0,   112,   616,   617,   115,   370,   371,     0,
       0,     0,   372,   373,     0,     0,     0,     0,   374,     0,
       0,     0,     0,     0,     0,     0,     0,   375,     0,   376,
       0,   377,   378,     0,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,     0,  1168,
       0,     0,   389,   390,     0,   391,   130,   392,   393,   394,
     132,  1169,   134,  1170,  1171,     0,   395,   396,     0,   397,
    1172,  1173,   398,  1174,  1175,   400,     0,   401,   402,   403,
     404,  1176,     0,     0,   405,   406,   407,   408,     0,   409,
     410,  1177,   411,     0,   412,   413,   414,   146,   415,  1178,
    1179,  1180,  1181,  1182,   416,   417,   418,   419,   420,  1183,
    1184,   421,  2928,   422,     0,   423,     0,   424,   425,   426,
       0,   427,     0,     0,   428,  1185,   430,   431,     0,   432,
     433,   434,     0,   435,     0,   436,   437,   438,  1186,   439,
       0,  1187,  1188,   440,   441,  1189,     0,   442,     0,   443,
     161,     0,   162,   444,     0,   445,     0,   446,  1190,     0,
     447,     0,   448,   449,   450,   166,   451,   452,   453,     0,
     454,   455,   456,   457,   458,     0,   167,   168,     0,   459,
     460,   461,  1191,  1192,     0,  1193,     0,     0,   172,   173,
     462,   174,   463,   464,   465,   466,   467,     0,  1194,   176,
     468,   177,     0,   469,   470,   471,  1195,  1196,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,  1197,
     183,  1198,   740,   483,   484,   485,   486,   487,   488,   489,
     185,   490,  1199,   491,   492,   187,   493,  1200,  1201,  1202,
     494,   495,     0,     0,   496,   741,     0,     0,  1203,   498,
       0,     0,   190,   191,   192,  1204,   499,   500,   501,     0,
    1205,   195,   502,   503,   504,     0,   505,   506,   507,   508,
     509,   510,  1206,   511,     0,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   522,   202,   523,   524,  1207,
     525,   526,   527,   528,   529,   530,     0,     0,   531,   532,
     533,  1208,   534,   208,   535,   536,   210,   537,  1209,     0,
     538,   539,   540,   541,   542,   543,   544,   545,  1210,   546,
       0,   547,   548,     0,   549,   550,   551,   552,     0,  1211,
    1212,     0,   554,     0,   555,  1213,   556,  1214,  1215,   557,
     558,   559,   560,   561,     0,  1216,   562,   563,   564,   565,
    1217,     0,   566,   567,     0,   568,  1218,   569,   225,   570,
       0,     0,     0,   571,   572,   573,   574,   575,   576,     0,
     226,    49,  1219,   227,   577,     0,     0,  1220,  1221,    52,
    1222,    53,     0,     0,     0,     0,  1223,  1224,   611,    79,
      80,    81,   366,    83,    84,  1226,    85,    86,    87,   367,
       0,   368,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   612,    99,   100,   101,   369,   613,     0,   103,   104,
     105,   106,   614,   615,   108,   109,   110,   111,     0,   112,
     616,   617,   115,   370,   371,     0,     0,     0,   372,   373,
       0,     0,     0,     0,   374,     0,     0,     0,     0,     0,
       0,     0,     0,   375,     0,   376,     0,   377,   378,     0,
     379,   380,   381,   382,   383,   384,   385,   386,     0,   387,
     388,     0,     0,     0,     0,  1168,     0,     0,   389,   390,
       0,   391,   130,   392,   393,   394,   132,  1169,   134,  1170,
    1171,     0,   395,   396,     0,   397,  1172,  1173,   398,  1174,
    1175,   400,     0,   401,   402,   403,   404,  1176,     0,     0,
     405,   406,   407,   408,     0,   409,   410,  1177,   411,     0,
     412,   413,   414,   146,   415,  1178,  1179,  1180,  1181,  1182,
     416,   417,   418,   419,   420,  1183,  1184,   421,     0,   422,
       0,   423,     0,   424,   425,   426,     0,   427,     0,     0,
     428,  1185,   430,   431,     0,   432,   433,   434,     0,   435,
       0,   436,   437,   438,  1186,   439,     0,  1187,  1188,   440,
     441,  1189,     0,   442,     0,   443,   161,     0,   162,   444,
       0,   445,     0,   446,  1190,     0,   447,     0,   448,   449,
     450,   166,   451,   452,   453,     0,   454,   455,   456,   457,
     458,     0,   167,   168,     0,   459,   460,   461,  1191,  1192,
       0,  1193,     0,     0,   172,   173,   462,   174,   463,   464,
     465,   466,   467,     0,  1194,   176,   468,   177,     0,   469,
     470,   471,  1195,  1196,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,  1197,   183,  1198,   740,   483,
     484,   485,   486,   487,   488,   489,   185,   490,  1199,   491,
     492,   187,   493,  1200,  1201,  1202,   494,   495,     0,     0,
     496,   741,     0,     0,  1203,   498,     0,     0,   190,   191,
     192,  1204,   499,   500,   501,     0,  1205,   195,   502,   503,
     504,     0,   505,   506,   507,   508,   509,   510,  1206,   511,
       0,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   522,   202,   523,   524,  1207,   525,   526,   527,   528,
     529,   530,     0,     0,   531,   532,   533,  1208,   534,   208,
     535,   536,   210,   537,  1209,     0,   538,   539,   540,   541,
     542,   543,   544,   545,  1210,   546,     0,   547,   548,     0,
     549,   550,   551,   552,     0,  1211,  1212,     0,   554,     0,
     555,  1213,   556,  1214,  1215,   557,   558,   559,   560,   561,
       0,  1216,   562,   563,   564,   565,  1217,     0,   566,   567,
       0,   568,  1218,   569,   225,   570,     0,     0,     0,   571,
     572,   573,   574,   575,   576,     0,   226,    49,  1219,   227,
     577,     0,     0,  1220,  1221,    52,  1222,    53,     0,     0,
       0,     0,  1223,  1224,   611,    79,    80,    81,   366,    83,
      84,  1226,    85,    86,    87,   367,     0,   368,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   612,    99,   100,
     101,   369,   613,     0,   103,   104,   105,   106,   614,   615,
     108,   109,   110,   111,     0,   112,   616,   617,   115,   370,
     371,     0,     0,     0,   372,   373,     0,     0,     0,     0,
     374,     0,     0,     0,     0,     0,     0,     0,     0,   375,
       0,   376,     0,   377,   378,     0,   379,   380,   381,   382,
     383,   384,   385,   386,     0,   387,   388,     0,     0,     0,
       0,  1168,     0,     0,   389,   390,     0,   391,   130,   392,
     393,   394,   132,  1169,   134,  1170,  1171,     0,   395,   396,
       0,   397,  1172,  1173,   398,  1174,  1175,   400,     0,   401,
     402,   403,   404,  1176,     0,     0,   405,   406,   407,   408,
       0,   409,   410,  1177,   411,     0,   412,   413,   414,   146,
     415,  1178,  1179,  1180,  1181,  1182,   416,   417,   418,   419,
     420,  1183,  1184,   421,     0,   422,     0,   423,     0,   424,
     425,   426,     0,   427,     0,     0,   428,  1185,   430,   431,
       0,   432,   433,   434,     0,   435,     0,   436,   437,   438,
    1186,   439,     0,  1187,  1188,   440,   441,  1189,     0,   442,
       0,   443,   161,     0,   162,   444,     0,   445,     0,   446,
    1190,     0,   447,     0,   448,   449,   450,   166,   451,   452,
     453,     0,   454,   455,   456,   457,   458,     0,   167,   168,
       0,   459,   460,   461,  1191,  1192,     0,  1193,     0,     0,
     172,   173,   462,   174,   463,   464,   465,   466,   467,     0,
    1194,   176,   468,   177,     0,   469,   470,   471,  1195,  1196,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,  1197,   183,  1198,   740,   483,   484,   485,   486,   487,
     488,   489,   185,   490,     0,   491,   492,   187,   493,  1200,
    1201,  1202,   494,   495,     0,     0,   496,   741,     0,     0,
    1203,   498,     0,     0,   190,   191,   192,  1204,   499,   500,
     501,     0,  1205,   195,   502,   503,   504,     0,   505,   506,
     507,   508,   509,   510,  1206,   511,     0,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   202,   523,
     524,  1207,   525,   526,   527,   528,   529,   530,     0,     0,
     531,   532,   533,  1208,   534,   208,   535,   536,   210,   537,
    1209,     0,   538,   539,   540,   541,   542,   543,   544,   545,
    1210,   546,     0,   547,   548,     0,   549,   550,   551,   552,
       0,  1211,  1212,     0,   554,     0,   555,  1213,   556,  1214,
    1215,   557,   558,   559,   560,   561,     0,     0,   562,   563,
     564,   565,  1217,     0,   566,   567,     0,   568,  1218,   569,
     225,   570,     0,     0,     0,   571,   572,   573,   574,   575,
     576,     0,   226,    49,  1219,   227,   577,     0,     0,  1220,
    1221,    52,  1222,    53,     0,     0,     0,     0,     0,  2127,
     611,    79,    80,    81,   366,    83,    84,  1226,    85,    86,
      87,   367,     0,   368,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   612,    99,   100,   101,   369,   613,     0,
     103,   104,   105,   106,   614,   615,   108,   109,   110,   111,
       0,   112,   616,   617,   115,   370,   371,     0,     0,     0,
     372,   373,     0,     0,     0,     0,   374,     0,     0,     0,
       0,     0,     0,     0,     0,   375,     0,   376,     0,   377,
     378,     0,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,     0,  1168,     0,     0,
     389,   390,     0,   391,   130,   392,   393,   394,     0,  1169,
     134,  1170,  1171,     0,   395,   396,     0,   397,  1172,  1173,
     398,  1174,  1175,   400,     0,   401,   402,   403,   404,  1176,
       0,     0,   405,   406,   407,   408,     0,   409,   410,  1177,
     411,     0,   412,   413,   414,   146,   415,  1178,  1179,  1180,
    1181,  1182,   416,   417,   418,   419,   420,  1183,  1184,   421,
       0,   422,     0,   423,     0,   424,   425,   426,     0,   427,
       0,     0,   428,  1185,   430,   431,     0,   432,   433,   434,
       0,     0,     0,   436,   437,   438,  1186,   439,     0,  1187,
    1188,   440,   441,  1189,     0,   442,     0,   443,   161,     0,
     162,   444,     0,   445,     0,   446,  1190,     0,   447,     0,
     448,   449,   450,     0,   451,   452,   453,     0,   454,   455,
     456,   457,   458,     0,   167,   168,     0,   459,   460,   461,
    1191,  1192,     0,  1193,     0,     0,   172,   173,   462,   174,
     463,   464,   465,   466,   467,     0,  1194,   176,   468,     0,
       0,   469,   470,   471,  1195,  1196,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,  1197,   183,  1198,
     740,   483,   484,   485,   486,   487,   488,   489,   185,   490,
       0,   491,   492,   187,   493,  1200,  1201,  1202,   494,   495,
       0,     0,   496,   741,     0,     0,  1203,   498,     0,     0,
     190,   191,   192,  1204,   499,   500,   501,     0,  1205,   195,
     502,   503,   504,     0,   505,   506,   507,   508,   509,   510,
    1206,   511,     0,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   522,   202,   523,   524,  1207,   525,   526,
     527,   528,   529,   530,     0,     0,   531,   532,   533,  1208,
     534,   208,   535,   536,     0,   537,  1209,     0,   538,   539,
     540,   541,   542,   543,   544,   545,  1210,   546,     0,   547,
     548,     0,   549,   550,   551,   552,     0,  1211,  1212,     0,
     554,     0,   555,  1213,   556,  1214,  1215,   557,   558,   559,
     560,   561,     0,  1216,   562,   563,   564,   565,  1217,     0,
     566,   567,     0,   568,  1218,   569,   225,   570,     0,     0,
       0,   571,   572,   573,   574,   575,   576,     0,   226,    49,
    1219,   227,   577,     0,     0,  1220,  1221,    52,  1222,    53,
       0,     0,     0,     0,  1223,  1224,   611,    79,    80,    81,
     366,    83,    84,  1226,    85,    86,    87,   367,     0,   368,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   612,
      99,   100,   101,   369,   613,     0,   103,   104,   105,   106,
     614,   615,   108,   109,   110,   111,     0,   112,   616,   617,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,     0,  1168,     0,     0,   389,   390,     0,   391,
     130,   392,   393,   394,     0,  1169,   134,  1170,  1171,     0,
     395,   396,     0,   397,  1172,  1173,   398,  1174,  1175,   400,
       0,   401,   402,   403,   404,  1176,     0,     0,   405,   406,
     407,   408,     0,   409,   410,  1177,   411,     0,   412,   413,
     414,   146,   415,  1178,  1179,  1180,  1181,  1182,   416,   417,
     418,   419,   420,  1183,  1184,   421,     0,   422,     0,   423,
       0,   424,   425,   426,     0,   427,     0,     0,   428,  1185,
     430,   431,     0,   432,   433,   434,     0,     0,     0,   436,
     437,   438,  1186,   439,     0,  1187,  1188,   440,   441,  1189,
       0,   442,     0,   443,   161,     0,   162,   444,     0,   445,
       0,   446,  1190,     0,   447,     0,   448,   449,   450,     0,
     451,   452,   453,     0,   454,   455,   456,   457,   458,     0,
     167,   168,     0,   459,   460,   461,  1191,  1192,     0,  1193,
       0,     0,   172,   173,   462,   174,   463,   464,   465,   466,
     467,     0,  1194,   176,   468,     0,     0,   469,   470,   471,
    1195,  1196,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,  1197,   183,  1198,   740,   483,   484,   485,
     486,   487,   488,   489,   185,   490,     0,   491,   492,   187,
     493,  1200,  1201,  1202,   494,   495,     0,     0,   496,   741,
       0,     0,     0,   498,     0,     0,   190,   191,   192,  1204,
     499,   500,   501,     0,  1205,   195,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,  1206,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
     202,   523,   524,  1207,   525,   526,   527,   528,   529,   530,
       0,     0,   531,   532,   533,  1208,   534,   208,   535,   536,
       0,   537,  1209,     0,   538,   539,   540,   541,   542,   543,
     544,   545,  1210,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,  1211,  1212,     0,   554,     0,   555,  1213,
     556,  1214,  1215,   557,   558,   559,   560,   561,     0,     0,
     562,   563,   564,   565,  1217,     0,   566,   567,     0,   568,
    1218,   569,   225,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,    49,     0,   227,   577,     0,
       0,  1220,  1221,    52,  1222,    53,     0,     0,     0,     0,
       0,  2127,     0,    79,    80,    81,   366,    83,    84,  1226,
      85,    86,    87,   367,     0,   368,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   369,
       0,     0,   103,   104,   105,   106,     0,     0,   108,   109,
     110,   111,     0,   112,     0,     0,   115,   370,   371,     0,
       0,     0,   372,   373,     0,     0,     0,     0,   374,     0,
       0,     0,     0,     0,     0,     0,     0,   375,     0,   376,
       0,   377,   378,     0,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,     0,     0,
    2453,     0,   389,   390,     0,   391,     0,   392,   393,   394,
       0,   133,     0,   135,     0,     0,   395,   396,     0,   397,
       0,     0,   398,   399,   136,   400,     0,   401,   402,   403,
     404,   140,     0,     0,   405,   406,   407,   408,     0,   409,
     410,   143,   411,     0,   412,   413,   414,     0,   415,     0,
       0,     0,     0,     0,   416,   417,   418,   419,   420,   149,
     150,   421,     0,   422,     0,   423,     0,   424,   425,   426,
       0,   427,     0,     0,   428,   429,   430,   431,     0,   432,
     433,   434,     0,   435,  -830,   436,   437,   438,   156,   439,
       0,   158,     0,   440,   441,   160,  -830,   442,     0,   443,
       0,     0,     0,   444,     0,   445,     0,   446,   165,     0,
     447,     0,   448,   449,   450,     0,   451,   452,   453,     0,
     454,   455,   456,   457,   458,     0,     0,   168,     0,   459,
     460,   461,     0,   170,  -830,   171,     0,     0,     0,     0,
     462,     0,   463,   464,   465,   466,   467,     0,   175,     0,
     468,     0,  -830,   469,   470,   471,     0,     0,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   182,
       0,   184,     0,   483,   484,   485,   486,   487,   488,   489,
     185,   490,     0,   491,   492,     0,   493,     0,   188,   189,
     494,   495,     0,  -830,   496,     0,     0,     0,   497,   498,
       0,  -830,   190,     0,     0,   193,   499,   500,   501,     0,
     194,   195,   502,   503,   504,     0,   505,   506,   507,   508,
     509,   510,   197,   511,     0,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   524,   204,
     525,   526,   527,   528,   529,   530,     0,     0,   531,   532,
     533,     0,   534,   208,   535,   536,     0,   537,   211,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   213,   546,
       0,   547,   548,     0,   549,   550,   551,   552,     0,   214,
     215,     0,   554,     0,   555,   216,   556,   217,     0,   557,
     558,   559,   560,   561,  -830,     0,   562,   563,   564,   565,
       0,     0,   566,   567,     0,   568,   224,   569,     4,   570,
       0,     0,     0,   571,   572,   573,   574,   575,   576,     0,
     226,     0,     5,   227,     0,     0,     0,     0,     0,     0,
       0,     6,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     7,     8,     0,     0,  1303,     0,     0,     0,
      10,    11,     0,     0,     0,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      38,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    39,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    40,
       0,     0,    41,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,    48,    49,     0,    50,
       0,     0,     0,     0,     0,    52,     0,    53,    54,     0,
       0,     0,    55,    56,    57,    58,    59,     0,     0,    60,
      61,   972,    79,    80,    81,   366,    83,    84,     0,    85,
      86,    87,   367,     0,   368,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   369,     0,
       0,   103,   104,   105,   106,     0,     0,   108,   109,   110,
     111,     0,   112,     0,     0,   115,   370,   371,     0,     0,
       0,   372,   373,     0,     0,     0,     0,   374,     0,     0,
       0,     0,     0,     0,     0,     0,   375,     0,   376,     0,
     377,   378,     0,   379,   380,   381,   382,   383,   384,   385,
     386,     0,   387,   388,     0,     0,     0,     0,     0,     0,
       0,   389,   390,     0,   391,   130,   392,   393,   394,   132,
     133,   134,   135,     0,     0,   395,   396,     0,   397,     0,
    1173,   398,   399,   136,   400,     0,   401,   402,   403,   404,
    1176,     0,     0,   405,   406,   407,   408,     0,   409,   410,
    1177,   411,     0,   412,   413,   414,   146,   415,  1178,  1179,
    1180,  1181,  1182,   416,   417,   418,   419,   420,   149,   150,
     421,     0,   422,     0,   423,     0,   424,   425,   426,     0,
     427,     0,     0,   428,   429,   430,   431,     0,   432,   433,
     434,     0,   435,     0,   436,   437,   438,   156,   439,     0,
    1187,     0,   440,   441,   160,     0,   442,     0,   443,   161,
       0,   162,   444,     0,   445,     0,   446,  1190,     0,   447,
       0,   448,   449,   450,   166,   451,   452,   453,     0,   454,
     455,   456,   457,   458,     0,   167,   168,     0,   459,   460,
     461,     0,   170,     0,   171,     0,     0,   172,   173,   462,
     174,   463,   464,   465,   466,   467,     0,  1194,   176,   468,
     177,     0,   469,   470,   471,  1195,  1196,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   182,   183,
     184,   740,   483,   484,   485,   486,   487,   488,   489,   185,
     490,     0,   491,   492,   187,   493,     0,  1201,   189,   494,
     495,     0,     0,   496,   741,     0,   908,   497,   498,     0,
       0,   190,   191,   192,  1204,   499,   500,   501,     0,  1205,
     195,   502,   503,   504,     0,   505,   506,   507,   508,   509,
     510,   197,   511,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   522,   202,   523,   524,   204,   525,
     526,   527,   528,   529,   530,     0,   206,   531,   532,   533,
    1208,   534,   208,   535,   536,   210,   537,   211,     0,   538,
     539,   540,   541,   542,   543,   544,   545,  1210,   546,     0,
     547,   548,     0,   549,   550,   551,   552,     0,   214,   215,
       0,   554,     0,   555,  1213,   556,  1214,     0,   557,   558,
     559,   560,   561,     0,     0,   562,   563,   564,   565,  1217,
       0,   566,   567,     0,   568,   224,   569,   225,   570,     0,
       0,     0,   571,   572,   573,   574,   575,   576,     0,   226,
       0,     0,   227,     0,     0,     0,     0,     0,     0,    79,
      80,    81,   366,    83,    84,     0,    85,    86,    87,   367,
       0,   368,     0,    91,  2026,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   369,     0,     0,   103,   104,
     105,   106,     0,     0,   108,   109,   110,   111,     0,   112,
       0,     0,   115,   370,   371,     0,     0,     0,   372,   373,
       0,     0,     0,     0,   374,     0,     0,     0,     0,     0,
       0,     0,     0,   375,     0,   376,     0,   377,   378,     0,
     379,   380,   381,   382,   383,   384,   385,   386,     0,   387,
     388,     0,     0,     0,     0,     0,     0,     0,   389,   390,
       0,   391,   130,   392,   393,   394,   132,   133,   134,   135,
       0,     0,   395,   396,     0,   397,     0,  1173,   398,   399,
     136,   400,     0,   401,   402,   403,   404,  1176,     0,     0,
     405,   406,   407,   408,     0,   409,   410,  1177,   411,     0,
     412,   413,   414,   146,   415,  1178,  1179,  1180,  1181,  1182,
     416,   417,   418,   419,   420,   149,   150,   421,     0,   422,
       0,   423,     0,   424,   425,   426,     0,   427,     0,     0,
     428,   429,   430,   431,     0,   432,   433,   434,     0,   435,
       0,   436,   437,   438,   156,   439,     0,  1187,     0,   440,
     441,   160,     0,   442,     0,   443,   161,     0,   162,   444,
       0,   445,     0,   446,  1190,     0,   447,     0,   448,   449,
     450,   166,   451,   452,   453,     0,   454,   455,   456,   457,
     458,     0,   167,   168,     0,   459,   460,   461,     0,   170,
       0,   171,     0,     0,   172,   173,   462,   174,   463,   464,
     465,   466,   467,     0,  1194,   176,   468,   177,     0,   469,
     470,   471,  1195,  1196,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   182,   183,   184,   740,   483,
     484,   485,   486,   487,   488,   489,   185,   490,     0,   491,
     492,   187,   493,     0,  1201,   189,   494,   495,     0,     0,
     496,   741,     0,   908,   497,   498,     0,     0,   190,   191,
     192,  1204,   499,   500,   501,     0,  1205,   195,   502,   503,
     504,     0,   505,   506,   507,   508,   509,   510,   197,   511,
       0,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   522,   202,   523,   524,   204,   525,   526,   527,   528,
     529,   530,     0,     0,   531,   532,   533,  1208,   534,   208,
     535,   536,   210,   537,   211,     0,   538,   539,   540,   541,
     542,   543,   544,   545,  1210,   546,     0,   547,   548,     0,
     549,   550,   551,   552,     0,   214,   215,     0,   554,     0,
     555,  1213,   556,  1214,     0,   557,   558,   559,   560,   561,
       0,     0,   562,   563,   564,   565,  1217,     0,   566,   567,
       0,   568,   224,   569,   225,   570,     0,     0,     0,   571,
     572,   573,   574,   575,   576,     0,   226,     0,     0,   227,
       0,     0,     0,     0,     0,     0,    79,    80,    81,   366,
      83,    84,     0,    85,    86,    87,   367,     0,   368,     0,
      91,  2026,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   369,     0,     0,   103,   104,   105,   106,     0,
       0,   108,   109,   110,   111,     0,   112,     0,     0,   115,
     370,   371,     0,     0,     0,   372,   373,     0,     0,     0,
       0,   374,     0,     0,     0,     0,     0,     0,     0,     0,
     375,     0,   376,     0,   377,   378,     0,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,     0,     0,     0,     0,   389,   390,     0,   391,   130,
     392,   393,   394,   132,   133,   134,   135,     0,     0,   395,
     396,     0,   397,     0,  1173,   398,   399,   136,   400,     0,
     401,   402,   403,   404,  1176,     0,     0,   405,   406,   407,
     408,     0,   409,   410,  1177,   411,     0,   412,   413,   414,
     146,   415,  1178,  1179,  1180,  1181,  1182,   416,   417,   418,
     419,   420,   149,   150,   421,     0,   422,     0,   423,     0,
     424,   425,   426,     0,   427,     0,     0,   428,   429,   430,
     431,     0,   432,   433,   434,     0,   435,     0,   436,   437,
     438,   156,   439,     0,  1187,     0,   440,   441,   160,     0,
     442,     0,   443,   161,     0,   162,   444,     0,   445,     0,
     446,  1190,     0,   447,     0,   448,   449,   450,   166,   451,
     452,   453,     0,   454,   455,   456,   457,   458,     0,   167,
     168,     0,   459,   460,   461,     0,   170,     0,   171,     0,
       0,   172,   173,   462,   174,   463,   464,   465,   466,   467,
       0,  1194,   176,   468,   177,     0,   469,   470,   471,  1195,
    1196,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,   182,   183,   184,   740,   483,   484,   485,   486,
     487,   488,   489,   185,   490,     0,   491,   492,   187,   493,
       0,  1201,   189,   494,   495,     0,     0,   496,   741,     0,
       0,   497,   498,     0,     0,   190,   191,   192,  1204,   499,
     500,   501,     0,  1205,   195,   502,   503,   504,     0,   505,
     506,   507,   508,   509,   510,   197,   511,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   522,   202,
     523,   524,   204,   525,   526,   527,   528,   529,   530,     0,
       0,   531,   532,   533,  1208,   534,   208,   535,   536,   210,
     537,   211,     0,   538,   539,   540,   541,   542,   543,   544,
     545,  1210,   546,     0,   547,   548,     0,   549,   550,   551,
     552,     0,   214,   215,     0,   554,     0,   555,  1213,   556,
    1214,     0,   557,   558,   559,   560,   561,     0,     0,   562,
     563,   564,   565,  1217,     0,   566,   567,     0,   568,   224,
     569,   225,   570,     0,     0,     0,   571,   572,   573,   574,
     575,   576,     0,   226,     0,     0,   227,     0,     0,     0,
       0,     0,     0,    79,    80,    81,   366,    83,    84,     0,
      85,    86,    87,   367,     0,   368,     0,    91,  3149,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   369,
       0,     0,   103,   104,   105,   106,     0,     0,   108,   109,
     110,   111,     0,   112,     0,     0,   115,   370,   371,     0,
       0,     0,   372,   373,     0,     0,     0,     0,   374,     0,
       0,     0,     0,     0,     0,     0,     0,   375,     0,   376,
       0,   377,   378,     0,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,     0,     0,
       0,     0,   389,   390,     0,   391,     0,   392,   393,   394,
       0,   133,     0,   135,     0,     0,   395,   396,     0,   397,
       0,     0,   398,   399,   136,   400,     0,   401,   402,   403,
     404,   140,     0,     0,   405,   406,   407,   408,     0,   409,
     410,   143,   411,     0,   412,   413,   414,     0,   415,     0,
       0,     0,     0,     0,   416,   417,   418,   419,   420,   149,
     150,   421,     0,   422,     0,   423,     0,   424,   425,   426,
       0,   427,     0,     0,   428,   429,   430,   431,     0,   432,
     433,   434,     0,   435,     0,   436,   437,   438,   156,   439,
       0,   158,     0,   440,   441,   160,     0,   442,     0,   443,
       0,     0,     0,   444,     0,   445,     0,   446,   165,     0,
     447,     0,   448,   449,   450,     0,   451,   452,   453,     0,
     454,   455,   456,   457,   458,     0,     0,   168,     0,   459,
     460,   461,     0,   170,     0,   171,     0,     0,     0,     0,
     462,     0,   463,   464,   465,   466,   467,     0,   175,     0,
     468,     0,     0,   469,   470,   471,     0,     0,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   182,
       0,   184,     0,   483,   484,   485,   486,   487,   488,   489,
     185,   490,     0,   491,   492,     0,   493,     0,   188,   189,
     494,   495,     0,     0,   496,     0,     0,     0,   497,   498,
       0,     0,   190,     0,     0,   193,   499,   500,   501,     0,
     194,   195,   502,   503,   504,     0,   505,   506,   507,   508,
     509,   510,   197,   511,     0,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   524,   204,
     525,   526,   527,   528,   529,   530,     0,     0,   531,   532,
     533,     0,   534,   208,   535,   536,     0,   537,   211,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   213,   546,
       0,   547,   548,     0,   549,   550,   551,   552,     0,   214,
     215,     0,   554,     0,   555,   216,   556,   217,     0,   557,
     558,   559,   560,   561,     0,     0,   562,   563,   564,   565,
       0,     0,   566,   567,     0,   568,   224,   569,     0,   570,
       0,     0,     0,   571,   572,   573,   574,   575,   576,     0,
     226,    49,     0,   227,   577,     0,     0,     0,     0,    52,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2388,  2389,    79,    80,    81,   366,
      83,    84,     0,    85,    86,    87,   367,     0,   368,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   369,     0,     0,   103,   104,   105,   106,     0,
       0,   108,   109,   110,   111,     0,   112,     0,     0,   115,
     370,   371,     0,     0,     0,   372,   373,     0,     0,     0,
       0,   374,     0,     0,     0,     0,     0,     0,     0,     0,
     375,     0,   376,     0,   377,   378,     0,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,     0,     0,     0,     0,   389,   390,     0,   391,     0,
     392,   393,   394,     0,   133,     0,   135,     0,     0,   395,
     396,     0,   397,     0,     0,   398,   399,   136,   400,     0,
     401,   402,   403,   404,   140,     0,     0,   405,   406,   407,
     408,     0,   409,   410,   143,   411,     0,   412,   413,   414,
       0,   415,     0,     0,     0,     0,     0,   416,   417,   418,
     419,   420,   149,   150,   421,     0,   422,     0,   423,     0,
     424,   425,   426,     0,   427,     0,     0,   428,   429,   430,
     431,     0,   432,   433,   434,     0,   435,     0,   436,   437,
     438,   156,   439,     0,   158,     0,   440,   441,   160,     0,
     442,     0,   443,     0,     0,     0,   444,     0,   445,     0,
     446,   165,     0,   447,     0,   448,   449,   450,     0,   451,
     452,   453,     0,   454,   455,   456,   457,   458,     0,     0,
     168,     0,   459,   460,   461,     0,   170,     0,   171,     0,
       0,     0,     0,   462,     0,   463,   464,   465,   466,   467,
       0,   175,     0,   468,     0,     0,   469,   470,   471,     0,
       0,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,   182,     0,   184,     0,   483,   484,   485,   486,
     487,   488,   489,   185,   490,     0,   491,   492,     0,   493,
       0,   188,   189,   494,   495,     0,     0,   496,     0,     0,
       0,   497,   498,     0,     0,   190,     0,     0,   193,   499,
     500,   501,     0,   194,   195,   502,   503,   504,     0,   505,
     506,   507,   508,   509,   510,   197,   511,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   524,   204,   525,   526,   527,   528,   529,   530,     0,
       0,   531,   532,   533,     0,   534,   208,   535,   536,     0,
     537,   211,     0,   538,   539,   540,   541,   542,   543,   544,
     545,   213,   546,     0,   547,   548,     0,   549,   550,   551,
     552,     0,   214,   215,     0,   554,     0,   555,   216,   556,
     217,     0,   557,   558,   559,   560,   561,     0,     0,   562,
     563,   564,   565,     0,     0,   566,   567,     0,   568,   224,
     569,     0,   570,     0,     0,     0,   571,   572,   573,   574,
     575,   576,     0,   226,    49,     0,   227,   577,     0,     0,
       0,     0,    52,    79,    80,    81,   366,    83,    84,     0,
      85,    86,    87,   367,     0,   368,     0,    91,  2389,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   369,
       0,     0,   103,   104,   105,   106,     0,     0,   108,   109,
     110,   111,     0,   112,     0,     0,   115,   370,   371,     0,
       0,     0,   372,   373,     0,     0,     0,     0,   374,     0,
       0,     0,     0,     0,     0,     0,     0,   375,     0,   376,
       0,   377,   378,     0,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,     0,     0,
       0,     0,   389,   390,     0,   391,     0,   392,   393,   394,
       0,   133,     0,   135,     0,     0,   395,   396,     0,   397,
       0,     0,   398,   399,   136,   400,     0,   401,   402,   403,
     404,   140,     0,     0,   405,   406,   407,   408,     0,   409,
     410,   143,   411,     0,   412,   413,   414,     0,   415,     0,
       0,     0,     0,     0,   416,   417,   418,   419,   420,   149,
     150,   421,     0,   422,     0,   423,     0,   424,   425,   426,
       0,   427,     0,     0,   428,   429,   430,   431,     0,   432,
     433,   434,     0,   435,     0,   436,   437,   438,   156,   439,
       0,   158,     0,   440,   441,   160,     0,   442,     0,   443,
       0,     0,     0,   444,     0,   445,     0,   446,   165,     0,
     447,     0,   448,   449,   450,     0,   451,   452,   453,     0,
     454,   455,   456,   457,   458,     0,     0,   168,     0,   459,
     460,   461,     0,   170,     0,   171,     0,     0,     0,     0,
     462,     0,   463,   464,   465,   466,   467,     0,   175,     0,
     468,     0,     0,   469,   470,   471,     0,     0,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   182,
       0,   184,   740,   483,   484,   485,   486,   487,   488,   489,
     185,   490,     0,   491,   492,     0,   493,     0,   188,   189,
     494,   495,     0,     0,   496,   741,     0,     0,   497,   498,
       0,     0,   190,     0,     0,   193,   499,   500,   501,     0,
     194,   195,   502,   503,   504,     0,   505,   506,   507,   508,
     509,   510,   197,   511,     0,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   524,   204,
     525,   526,   527,   528,   529,   530,     0,     0,   531,   532,
     533,     0,   534,   208,   535,   536,     0,   537,   211,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   213,   546,
       0,   547,   548,     0,   549,   550,   551,   552,     0,   214,
     215,     0,   554,     0,   555,   216,   556,   217,     0,   557,
     558,   559,   560,   561,     0,     0,   562,   563,   564,   565,
       0,     0,   566,   567,     0,   568,   224,   569,     0,   570,
       0,     0,     0,   571,   572,   573,   574,   575,   576,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,     0,
      79,    80,    81,   366,    83,    84,     0,    85,    86,    87,
     367,     0,   368,     0,    91,  1297,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   369,     0,     0,   103,
     104,   105,   106,     0,     0,   108,   109,   110,   111,     0,
     112,     0,     0,   115,   370,   371,     0,     0,     0,   372,
     373,     0,     0,     0,     0,   374,     0,     0,     0,     0,
       0,     0,     0,     0,   375,     0,   376,     0,   377,   378,
       0,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,     0,     0,     0,     0,   389,
     390,     0,   391,     0,   392,   393,   394,     0,   133,     0,
     135,     0,     0,   395,   396,     0,   397,     0,     0,   398,
     399,   136,   400,     0,   401,   402,   403,   404,   140,     0,
       0,   405,   406,   407,   408,     0,   409,   410,   143,   411,
       0,   412,   413,   414,     0,   415,     0,     0,     0,     0,
       0,   416,   417,   418,   419,   420,   149,   150,   421,     0,
     422,     0,   423,     0,   424,   425,   426,     0,   427,     0,
       0,   428,   429,   430,   431,     0,   432,   433,   434,     0,
     435,     0,   436,   437,   438,   156,   439,     0,   158,     0,
     440,   441,   160,     0,   442,     0,   443,     0,     0,     0,
     444,     0,   445,     0,   446,   165,     0,   447,     0,   448,
     449,   450,     0,   451,   452,   453,     0,   454,   455,   456,
     457,   458,     0,     0,   168,     0,   459,   460,   461,     0,
     170,     0,   171,     0,     0,     0,     0,   462,     0,   463,
     464,   465,   466,   467,     0,   175,     0,   468,     0,     0,
     469,   470,   471,     0,     0,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,   182,     0,   184,     0,
     483,   484,   485,   486,   487,   488,   489,   185,   490,     0,
     491,   492,     0,   493,     0,   188,   189,   494,   495,     0,
       0,   496,     0,     0,     0,   497,   498,     0,     0,   190,
       0,     0,   193,   499,   500,   501,     0,   194,   195,   502,
     503,   504,     0,   505,   506,   507,   508,   509,   510,   197,
     511,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   524,   204,   525,   526,   527,
     528,   529,   530,     0,   206,   531,   532,   533,     0,   534,
     208,   535,   536,     0,   537,   211,     0,   538,   539,   540,
     541,   542,   543,   544,   545,   213,   546,     0,   547,   548,
       0,   549,   550,   551,   552,     0,   214,   215,     0,   554,
       0,   555,   216,   556,   217,     0,   557,   558,   559,   560,
     561,     0,     0,   562,   563,   564,   565,     0,     0,   566,
     567,     0,   568,   224,   569,     0,   570,     0,     0,     0,
     571,   572,   573,   574,   575,   576,     0,   226,     0,     0,
     227,   577,     0,     0,     0,     0,     0,    79,    80,    81,
     366,    83,    84,     0,    85,    86,    87,   367,     0,   368,
       0,    91,   228,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   369,     0,     0,   103,   104,   105,   106,
       0,     0,   108,   109,   110,   111,     0,   112,     0,     0,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,     0,     0,     0,     0,   389,   390,     0,   391,
       0,   392,   393,   394,     0,   133,     0,   135,     0,     0,
     395,   396,     0,   397,     0,     0,   398,   399,   136,   400,
       0,   401,   402,   403,   404,   140,     0,     0,   405,   406,
     407,   408,     0,   409,   410,   143,   411,     0,   412,   413,
     414,     0,   415,     0,     0,     0,     0,     0,   416,   417,
     418,   419,   420,   149,   150,   421,     0,   422,     0,   423,
       0,   424,   425,   426,     0,   427,     0,     0,   428,   429,
     430,   431,     0,   432,   433,   434,     0,   435,     0,   436,
     437,   438,   156,   439,     0,   158,     0,   440,   441,   160,
       0,   442,     0,   443,     0,     0,     0,   444,     0,   445,
       0,   446,   165,     0,   447,     0,   448,   449,   450,     0,
     451,   452,   453,     0,   454,   455,   456,   457,   458,     0,
       0,   168,     0,   459,   460,   461,     0,   170,     0,   171,
       0,     0,     0,     0,   462,     0,   463,   464,   465,   466,
     467,     0,   175,     0,   468,     0,     0,   469,   470,   471,
       0,     0,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   182,     0,   184,     0,   483,   484,   485,
     486,   487,   488,   489,   185,   490,     0,   491,   492,     0,
     493,     0,   188,   189,   494,   495,     0,     0,   496,     0,
       0,     0,   497,   498,     0,     0,   190,     0,     0,   193,
     499,   500,   501,     0,   194,   195,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,   197,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   524,   204,   525,   526,   527,   528,   529,   530,
       0,   206,   531,   532,   533,     0,   534,   208,   535,   536,
       0,   537,   211,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   213,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,   214,   215,     0,   554,     0,   555,   216,
     556,   217,     0,   557,   558,   559,   560,   561,     0,     0,
     562,   563,   564,   565,     0,     0,   566,   567,     0,   568,
     224,   569,     0,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,     0,     0,   227,     0,     0,
       0,     0,     0,     0,    79,    80,    81,   366,    83,    84,
       0,    85,    86,    87,   367,     0,   368,     0,    91,   228,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     369,     0,     0,   103,   104,   105,   106,     0,     0,   108,
     109,   110,   111,     0,   112,     0,     0,   115,   370,   371,
       0,     0,     0,   372,   373,     0,     0,     0,     0,   374,
       0,     0,     0,     0,     0,     0,     0,     0,   375,     0,
     376,     0,   377,   378,     0,   379,   380,   381,   382,   383,
     384,   385,   386,     0,   387,   388,     0,     0,     0,     0,
       0,     0,     0,   389,   390,     0,   391,     0,   392,   393,
     394,     0,   133,     0,   135,     0,     0,   395,   396,     0,
     397,     0,     0,   398,   399,   136,   400,     0,   401,   402,
     403,   404,   140,     0,     0,   405,   406,   407,   408,     0,
     409,   410,   143,   411,     0,   412,   413,   414,     0,   415,
       0,     0,     0,     0,     0,   416,   417,   418,   419,   420,
     149,   150,   421,     0,   422,     0,   423,     0,   424,   425,
     426,     0,   427,     0,     0,   428,   429,   430,   431,     0,
     432,   433,   434,     0,   435,     0,   436,   437,   438,   156,
     439,     0,   158,     0,   440,   441,   160,     0,   442,     0,
     443,     0,     0,     0,   444,     0,   445,     0,   446,   165,
       0,   447,     0,   448,   449,   450,     0,   451,   452,   453,
       0,   454,   455,   456,   457,   458,     0,     0,   168,     0,
     459,   460,   461,     0,   170,     0,   171,     0,     0,     0,
       0,   462,     0,   463,   464,   465,   466,   467,     0,   175,
       0,   468,     0,     0,   469,   470,   471,     0,     0,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
     182,     0,   184,     0,   483,   484,   485,   486,   487,   488,
     489,   185,   490,     0,   491,   492,     0,   493,     0,   188,
     189,   494,   495,     0,     0,   496,     0,     0,     0,   497,
     498,     0,     0,   190,     0,     0,   193,   499,   500,   501,
       0,   194,   195,   502,   503,   504,     0,   505,   506,   507,
     508,   509,   510,   197,   511,     0,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   524,
     204,   525,   526,   527,   528,   529,   530,     0,     0,   531,
     532,   533,     0,   534,   208,   535,   536,     0,   537,   211,
       0,   538,   539,   540,   541,   542,   543,   544,   545,   213,
     546,     0,   547,   548,     0,   549,   550,   551,   552,     0,
     214,   215,     0,   554,     0,   555,   216,   556,   217,     0,
     557,   558,   559,   560,   561,     0,     0,   562,   563,   564,
     565,     0,     0,   566,   567,     0,   568,   224,   569,     0,
     570,     0,     0,     0,   571,   572,   573,   574,   575,   576,
       0,   226,     0,     0,   227,     0,     0,     0,     0,     0,
       0,    79,    80,    81,   366,    83,    84,     0,    85,    86,
      87,   367,     0,   368,     0,    91,  1748,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   369,     0,     0,
     103,   104,   105,   106,     0,     0,   108,   109,   110,   111,
       0,   112,     0,     0,   115,   370,   371,     0,     0,     0,
     372,   373,     0,     0,     0,     0,   374,     0,     0,     0,
       0,     0,     0,     0,     0,   375,     0,   376,     0,   377,
     378,     0,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,     0,     0,     0,     0,
     389,   390,     0,   391,     0,   392,   393,   394,     0,   133,
       0,   135,     0,     0,   395,   396,     0,   397,     0,     0,
     398,   399,   136,   400,     0,   401,   402,   403,   404,   140,
       0,     0,   405,   406,   407,   408,     0,   409,   410,   143,
     411,     0,   412,   413,   414,     0,   415,     0,     0,     0,
       0,     0,   416,   417,   418,   419,   420,   149,   150,   421,
       0,   422,     0,   423,     0,   424,   425,   426,     0,   427,
       0,     0,   428,   429,   430,   431,     0,   432,   433,   434,
       0,   435,     0,   436,   437,   438,   156,   439,     0,   158,
       0,   440,   441,   160,     0,   442,     0,   443,     0,     0,
       0,   444,     0,   445,     0,   446,   165,     0,   447,     0,
     448,   449,   450,     0,   451,   452,   453,     0,   454,   455,
     456,   457,   458,     0,     0,   168,     0,   459,   460,   461,
       0,   170,     0,   171,     0,     0,     0,     0,   462,     0,
     463,   464,   465,   466,   467,     0,   175,     0,   468,     0,
       0,   469,   470,   471,     0,     0,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   182,     0,   184,
       0,   483,   484,   485,   486,   487,   488,   489,   185,   490,
       0,   491,   492,     0,   493,     0,   188,   189,   494,   495,
       0,     0,   496,     0,     0,     0,   497,   498,     0,     0,
     190,     0,     0,   193,   499,   500,   501,     0,   194,   195,
     502,   503,   504,     0,   505,   506,   507,   508,   509,   510,
     197,   511,     0,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   524,   204,   525,   526,
     527,   528,   529,   530,     0,     0,   531,   532,   533,     0,
     534,   208,   535,   536,     0,   537,   211,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   213,   546,     0,   547,
     548,     0,   549,   550,   551,   552,     0,   214,   215,     0,
     554,     0,   555,   216,   556,   217,     0,   557,   558,   559,
     560,   561,     0,     0,   562,   563,   564,   565,     0,     0,
     566,   567,     0,   568,   224,   569,     0,   570,     0,     0,
       0,   571,   572,   573,   574,   575,   576,     0,   226,     0,
       0,   227,     0,     0,     0,     0,     0,   611,    79,    80,
      81,   366,    83,    84,     0,    85,    86,    87,   367,     0,
     368,     0,    91,  2825,    93,    94,    95,    96,    97,    98,
     612,    99,   100,   101,   369,   613,     0,   103,   104,   105,
     106,   614,   615,   108,   109,   110,   111,     0,   112,   616,
     617,   115,   370,   371,     0,     0,     0,   372,   373,     0,
       0,     0,     0,   374,     0,     0,     0,     0,     0,     0,
       0,     0,   375,     0,   376,     0,   377,   378,     0,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,     0,     0,     0,     0,   389,   390,     0,
     391,     0,   392,   393,   394,     0,  1476,     0,  1477,  1171,
       0,   395,   396,     0,   397,     0,     0,   398,  1478,  1479,
     400,     0,   401,   402,   403,   404,     0,     0,     0,   405,
     406,   407,   408,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   415,     0,     0,     0,     0,     0,   416,
     417,   418,   419,   420,  1480,  1481,   421,     0,   422,     0,
     423,     0,   424,   425,   426,     0,   427,     0,     0,   428,
    1185,   430,   431,     0,   432,   433,   434,     0,   435,     0,
     436,   437,   438,     0,   439,     0,     0,     0,   440,   441,
    1482,     0,   442,     0,   443,     0,     0,     0,   444,     0,
     445,     0,   446,     0,     0,   447,     0,   448,   449,   450,
       0,   451,   452,   453,     0,   454,   455,   456,   457,   458,
       0,     0,     0,     0,   459,   460,   461,  1191,  1483,     0,
    1484,     0,     0,     0,     0,   462,     0,   463,   464,   465,
     466,   467,     0,     0,     0,   468,     0,     0,   469,   470,
     471,     0,     0,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,  1485,     0,  1486,     0,   483,   484,
     485,   486,   487,   488,   489,     0,   490,     0,   491,   492,
       0,   493,     0,     0,  1487,   494,   495,     0,     0,   496,
       0,     0,     0,  2727,   498,     0,     0,     0,     0,     0,
       0,   499,   500,   501,     0,     0,     0,   502,   503,   504,
       0,   505,   506,   507,   508,   509,   510,  1488,   511,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   524,     0,   525,   526,   527,   528,   529,
     530,     0,     0,   531,   532,   533,     0,   534,  1489,   535,
     536,     0,   537,  1490,     0,   538,   539,   540,   541,   542,
     543,   544,   545,     0,   546,     0,   547,   548,     0,   549,
     550,   551,   552,     0,  1491,  1492,     0,   554,     0,   555,
       0,   556,     0,     0,   557,   558,   559,   560,   561,     0,
       0,   562,   563,   564,   565,     0,     0,   566,   567,     0,
     568,  1493,   569,     0,   570,     0,     0,     0,   571,   572,
     573,   574,   575,   576,     0,   226,    49,  1019,   227,   577,
       0,     0,     0,     0,    52,     0,    53,  1020,  1021,  1022,
       0,  1023,  2728,  1025,  1026,  1027,  1028,    79,    80,    81,
     366,    83,    84,     0,    85,    86,    87,   367,     0,   368,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   369,     0,     0,   103,   104,   105,   106,
       0,     0,   108,   109,   110,   111,     0,   112,     0,     0,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,     0,     0,     0,     0,   389,   390,     0,   391,
       0,   392,   393,   394,     0,   133,     0,   135,     0,     0,
     395,   396,     0,   397,     0,     0,   398,   399,   136,   400,
       0,   401,  1018,   403,   404,   140,     0,     0,   405,   406,
     407,   408,     0,   409,   410,   143,   411,     0,   412,   413,
     414,     0,   415,     0,     0,     0,     0,     0,   416,   417,
     418,   419,   420,   149,   150,   421,     0,   422,     0,   423,
       0,   424,   425,   426,     0,   427,     0,     0,   428,   429,
     430,   431,     0,   432,   433,   434,     0,   435,     0,   436,
     437,   438,   156,   439,     0,   158,     0,   440,   441,   160,
       0,   442,     0,   443,     0,     0,     0,   444,     0,   445,
       0,   446,   165,     0,   447,     0,   448,   449,   450,     0,
     451,   452,   453,     0,   454,   455,   456,   457,   458,     0,
       0,   168,     0,   459,   460,   461,     0,   170,     0,   171,
       0,     0,     0,     0,   462,     0,   463,   464,   465,   466,
     467,     0,   175,     0,   468,     0,     0,   469,   470,   471,
       0,     0,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   182,     0,   184,     0,   483,   484,   485,
     486,   487,   488,   489,   185,   490,     0,   491,   492,     0,
     493,     0,   188,   189,   494,   495,     0,     0,   496,     0,
       0,     0,   497,   498,     0,     0,   190,     0,     0,   193,
     499,   500,   501,     0,   194,   195,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,   197,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   524,   204,   525,   526,   527,   528,   529,   530,
       0,     0,   531,   532,   533,     0,   534,   208,   535,   536,
       0,   537,   211,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   213,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,   214,   215,     0,   554,     0,   555,   216,
     556,   217,     0,   557,   558,   559,   560,   561,     0,     0,
     562,   563,   564,   565,     0,     0,   566,   567,     0,   568,
     224,   569,     0,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,     0,  1019,   227,     0,     0,
       0,     0,     0,     0,     0,     0,  1020,  1021,  1022,     0,
    1023,  1024,  1025,  1026,  1027,  1028,    79,    80,    81,   366,
      83,    84,     0,    85,    86,    87,   367,     0,   368,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   369,     0,     0,   103,   104,   105,   106,     0,
       0,   108,   109,   110,   111,     0,   112,     0,     0,   115,
     370,   371,     0,     0,     0,   372,   373,     0,     0,     0,
       0,   374,     0,     0,     0,     0,     0,     0,     0,     0,
     375,     0,   376,     0,   377,   378,     0,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,     0,     0,     0,     0,   389,   390,     0,   391,     0,
     392,   393,   394,     0,   133,     0,   135,     0,     0,   395,
     396,     0,   397,     0,     0,   398,   399,   136,   400,     0,
     401,   402,   403,   404,   140,     0,     0,   405,   406,   407,
     408,     0,   409,   410,   143,   411,     0,   412,   413,   414,
       0,   415,     0,     0,     0,     0,     0,   416,   417,   418,
     419,   420,   149,   150,   421,     0,   422,     0,   423,     0,
     424,   425,   426,     0,   427,     0,     0,   428,   429,   430,
     431,     0,   432,   433,   434,     0,   435,     0,   436,   437,
     438,   156,   439,     0,   158,     0,   440,   441,   160,     0,
     442,     0,   443,     0,     0,     0,   444,     0,   445,     0,
     446,   165,     0,   447,     0,   448,   449,   450,     0,   451,
     452,   453,     0,   454,   455,   456,   457,   458,     0,     0,
     168,     0,   459,   460,   461,     0,   170,     0,   171,     0,
       0,     0,     0,   462,     0,   463,   464,   465,   466,   467,
       0,   175,     0,   468,     0,     0,   469,   470,   471,     0,
       0,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,   182,     0,   184,     0,   483,   484,   485,   486,
     487,   488,   489,   185,   490,     0,   491,   492,     0,   493,
       0,   188,   189,   494,   495,     0,     0,   496,     0,     0,
       0,   497,   498,     0,     0,   190,     0,     0,   193,   499,
     500,   501,     0,   194,   195,   502,   503,   504,     0,   505,
     506,   507,   508,   509,   510,   197,   511,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   524,   204,   525,   526,   527,   528,   529,   530,     0,
       0,   531,   532,   533,     0,   534,   208,   535,   536,     0,
     537,   211,     0,   538,   539,   540,   541,   542,   543,   544,
     545,   213,   546,     0,   547,   548,     0,   549,   550,   551,
     552,     0,   214,   215,     0,   554,     0,   555,   216,   556,
     217,     0,   557,   558,   559,   560,   561,     0,     0,   562,
     563,   564,   565,     0,     0,   566,   567,     0,   568,   224,
     569,     0,   570,     0,     0,     0,   571,   572,   573,   574,
     575,   576,     0,   226,     0,  1019,   227,     0,     0,     0,
       0,     0,     0,     0,     0,  1020,  1021,  1022,     0,  1023,
    1024,  1025,  1026,  1027,  1028,   611,    79,    80,    81,   366,
      83,    84,     0,    85,    86,    87,   367,     0,   368,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   612,    99,
     100,   101,   369,   613,     0,   103,   104,   105,   106,   614,
     615,   108,   109,   110,   111,     0,   112,   616,   617,   115,
     370,   371,     0,     0,     0,   372,   373,     0,     0,     0,
       0,   374,     0,     0,     0,     0,     0,     0,     0,     0,
     375,     0,   376,     0,   377,   378,     0,   379,   380,   381,
     382,   383,   384,   385,   386,   618,   387,   388,   619,   620,
     621,   622,   623,   624,   625,   389,   390,   626,   391,   130,
     392,   393,   394,   132,   133,   134,   135,     0,   627,   395,
     396,     0,   397,   628,   629,   398,   630,   136,   400,   631,
     401,   402,   403,   404,   140,   632,   633,   405,   406,   407,
     408,   634,   409,   410,   143,   411,   635,   412,   413,   414,
     146,   415,   636,   637,   638,   639,   640,   416,   417,   418,
     419,   420,   149,   150,   421,   641,   422,   642,   423,     0,
     424,   425,   426,   643,   427,   644,   645,   428,   429,   430,
     431,   646,   432,   433,   434,   647,   435,   648,   436,   437,
     438,   156,   439,     0,   158,   649,   440,   441,   160,   650,
     442,   651,   443,   161,   652,   162,   444,     0,   445,   653,
     446,   165,   654,   447,   655,   448,   449,   450,   166,   451,
     452,   453,   656,   454,   455,   456,   457,   458,   657,   167,
     168,   658,   459,   460,   461,   659,   170,   660,   171,   661,
       0,   172,   173,   462,   174,   463,   464,   465,   466,   467,
     662,   175,   176,   468,   177,   663,   469,   470,   471,     0,
       0,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,   182,   183,   184,   664,   483,   484,   485,   486,
     487,   488,   489,   185,   490,   665,   491,   492,   187,   493,
     666,   188,   189,   494,   495,   667,   668,   496,   669,   670,
     671,   497,   498,   672,   673,   190,   191,   192,   193,   499,
     500,   501,     0,   194,   195,   502,   503,   504,   674,   505,
     506,   507,   508,   509,   510,   197,   511,   675,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   522,   202,
     523,   524,   204,   525,   526,   527,   528,   529,   530,     0,
     676,   531,   532,   533,   677,   534,   208,   535,   536,   210,
     537,   211,   678,   538,   539,   540,   541,   542,   543,   544,
     545,   213,   546,   679,   547,   548,   680,   549,   550,   551,
     552,   681,   214,   215,   682,   554,   683,   555,   216,   556,
     217,   684,   557,   558,   559,   560,   561,   685,   686,   562,
     563,   564,   565,   687,   688,   566,   567,     0,   568,   224,
     569,   225,   570,     0,   689,   690,   571,   572,   573,   574,
     575,   576,     0,   226,     0,     0,   227,   611,    79,    80,
      81,   366,    83,    84,     0,    85,    86,    87,   367,     0,
     368,  1456,    91,     0,    93,    94,    95,    96,    97,    98,
     612,    99,   100,   101,   369,   613,     0,   103,   104,   105,
     106,   614,   615,   108,   109,   110,   111,     0,   112,   616,
     617,   115,   370,   371,     0,     0,     0,   372,   373,     0,
       0,     0,     0,   374,     0,     0,     0,     0,     0,     0,
       0,     0,   375,     0,   376,     0,   377,   378,     0,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,     0,     0,     0,     0,   389,   390,     0,
     391,     0,   392,   393,   394,     0,  1476,     0,  1477,  1171,
       0,   395,   396,     0,   397,     0,     0,   398,  1478,  1479,
     400,     0,   401,   402,   403,   404,     0,     0,     0,   405,
     406,   407,   408,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   415,     0,     0,     0,     0,     0,   416,
     417,   418,   419,   420,  1480,  1481,   421,     0,   422,     0,
     423,     0,   424,   425,   426,     0,   427,     0,     0,   428,
    1185,   430,   431,     0,   432,   433,   434,     0,   435,     0,
     436,   437,   438,     0,   439,     0,     0,     0,   440,   441,
    1482,     0,   442,     0,   443,     0,     0,     0,   444,     0,
     445,     0,   446,     0,     0,   447,     0,   448,   449,   450,
       0,   451,   452,   453,     0,   454,   455,   456,   457,   458,
       0,     0,     0,     0,   459,   460,   461,  1191,  1483,     0,
    1484,     0,     0,     0,     0,   462,     0,   463,   464,   465,
     466,   467,     0,     0,     0,   468,     0,     0,   469,   470,
     471,     0,     0,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,  1485,     0,  1486,     0,   483,   484,
     485,   486,   487,   488,   489,     0,   490,     0,   491,   492,
       0,   493,     0,     0,  1487,   494,   495,     0,     0,   496,
       0,     0,     0,   497,   498,     0,     0,     0,     0,     0,
       0,   499,   500,   501,     0,     0,     0,   502,   503,   504,
       0,   505,   506,   507,   508,   509,   510,  1488,   511,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   524,     0,   525,   526,   527,   528,   529,
     530,     0,     0,   531,   532,   533,     0,   534,  1489,   535,
     536,     0,   537,  1490,     0,   538,   539,   540,   541,   542,
     543,   544,   545,     0,   546,     0,   547,   548,     0,   549,
     550,   551,   552,     0,  1491,  1492,     0,   554,     0,   555,
       0,   556,     0,     0,   557,   558,   559,   560,   561,     0,
       0,   562,   563,   564,   565,     0,     0,   566,   567,     0,
     568,  1493,   569,     0,   570,     0,     0,     0,   571,   572,
     573,   574,   575,   576,     0,   226,     0,     0,   227,     0,
      79,    80,    81,   366,    83,    84,     0,    85,    86,    87,
     367,     0,   368,  1819,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   369,     0,     0,   103,
     104,   105,   106,     0,     0,   108,   109,   110,   111,     0,
     112,     0,     0,   115,   370,   371,     0,     0,     0,   372,
     373,     0,     0,     0,     0,   374,     0,     0,     0,     0,
       0,     0,     0,     0,   375,     0,   376,     0,   377,   378,
       0,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,     0,     0,     0,     0,   389,
     390,     0,   391,     0,   392,   393,   394,     0,   133,     0,
     135,     0,     0,   395,   396,     0,   397,     0,     0,   398,
     399,   136,   400,     0,   401,   402,   403,   404,   140,     0,
       0,   405,   406,   407,   408,     0,   409,   410,   143,   411,
       0,   412,   413,   414,     0,   415,     0,     0,     0,     0,
       0,   416,   417,   418,   419,   420,   149,   150,   421,     0,
     422,     0,   423,     0,   424,   425,   426,     0,   427,     0,
       0,   428,   429,   430,   431,     0,   432,   433,   434,     0,
     435,     0,   436,   437,   438,   156,   439,     0,   158,     0,
     440,   441,   160,     0,   442,     0,   443,     0,     0,     0,
     444,     0,   445,     0,   446,   165,     0,   447,     0,   448,
     449,   450,     0,   451,   452,   453,     0,   454,   455,   456,
     457,   458,     0,     0,   168,     0,   459,   460,   461,     0,
     170,     0,   171,     0,     0,     0,     0,   462,     0,   463,
     464,   465,   466,   467,     0,   175,     0,   468,     0,     0,
     469,   470,   471,     0,     0,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,   182,     0,   184,   740,
     483,   484,   485,   486,   487,   488,   489,   185,   490,     0,
     491,   492,     0,   493,     0,   188,   189,   494,   495,     0,
       0,   496,   741,     0,     0,   497,   498,     0,     0,   190,
       0,     0,   193,   499,   500,   501,     0,   194,   195,   502,
     503,   504,     0,   505,   506,   507,   508,   509,   510,   197,
     511,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   524,   204,   525,   526,   527,
     528,   529,   530,     0,     0,   531,   532,   533,     0,   534,
     208,   535,   536,     0,   537,   211,     0,   538,   539,   540,
     541,   542,   543,   544,   545,   213,   546,     0,   547,   548,
       0,   549,   550,   551,   552,     0,   214,   215,     0,   554,
       0,   555,   216,   556,   217,     0,   557,   558,   559,   560,
     561,     0,     0,   562,   563,   564,   565,     0,     0,   566,
     567,     0,   568,   224,   569,     0,   570,     0,     0,     0,
     571,   572,   573,   574,   575,   576,     0,   226,     0,     0,
     227,     0,    79,    80,    81,   366,    83,    84,     0,    85,
      86,    87,   367,     0,   368,   906,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   369,     0,
       0,   103,   104,   105,   106,     0,     0,   108,   109,   110,
     111,     0,   112,     0,     0,   115,   370,   371,     0,     0,
       0,   372,   373,     0,     0,     0,     0,   374,     0,     0,
       0,     0,     0,     0,     0,     0,   375,     0,   376,     0,
     377,   378,     0,   379,   380,   381,   382,   383,   384,   385,
     386,     0,   387,   388,     0,     0,     0,     0,     0,     0,
       0,   389,   390,     0,   391,     0,   392,   393,   394,     0,
     133,     0,   135,     0,     0,   395,   396,     0,   397,     0,
       0,   398,   399,   136,   400,     0,   401,   402,   403,   404,
     140,     0,     0,   405,   406,   407,   408,     0,   409,   410,
     143,   411,     0,   412,   413,   414,     0,   415,     0,     0,
       0,     0,     0,   416,   417,   418,   419,   420,   149,   150,
     421,  1733,   422,     0,   423,     0,   424,   425,   426,     0,
     427,     0,     0,   428,   429,   430,   431,     0,   432,   433,
     434,     0,   435,     0,   436,   437,   438,   156,   439,     0,
     158,  1734,   440,   441,   160,     0,   442,     0,   443,     0,
       0,     0,   444,     0,   445,     0,   446,   165,     0,   447,
       0,   448,   449,   450,     0,   451,   452,   453,     0,   454,
     455,   456,   457,   458,     0,     0,   168,     0,   459,   460,
     461,     0,   170,     0,   171,     0,     0,     0,     0,   462,
       0,   463,   464,   465,   466,   467,     0,   175,     0,   468,
       0,     0,   469,   470,   471,     0,     0,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   182,     0,
     184,     0,   483,   484,   485,   486,   487,   488,   489,   185,
     490,     0,   491,   492,     0,   493,     0,   188,   189,   494,
     495,  1735,     0,   496,     0,  1736,     0,   497,   498,     0,
       0,   190,     0,     0,   193,   499,   500,   501,     0,   194,
     195,   502,   503,   504,     0,   505,   506,   507,   508,   509,
     510,   197,   511,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   524,   204,   525,
     526,   527,   528,   529,   530,     0,     0,   531,   532,   533,
       0,   534,   208,   535,   536,     0,   537,   211,     0,   538,
     539,   540,   541,   542,   543,   544,   545,   213,   546,     0,
     547,   548,     0,   549,   550,   551,   552,     0,   214,   215,
       0,   554,     0,   555,   216,   556,   217,  1737,   557,   558,
     559,   560,   561,     0,     0,   562,   563,   564,   565,     0,
       0,   566,   567,     0,   568,   224,   569,     0,   570,     0,
       0,     0,   571,   572,   573,   574,   575,   576,     0,   226,
      49,     0,   227,   577,     0,     0,     0,     0,    52,     0,
      53,     0,     0,     0,     0,     0,  1332,    79,    80,    81,
     366,    83,    84,     0,    85,    86,    87,   367,     0,   368,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   369,     0,     0,   103,   104,   105,   106,
       0,     0,   108,   109,   110,   111,     0,   112,     0,     0,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,     0,     0,     0,     0,   389,   390,     0,   391,
       0,   392,   393,   394,     0,   133,     0,   135,     0,     0,
     395,   396,     0,   397,     0,     0,   398,   399,   136,   400,
       0,   401,   402,   403,   404,   140,     0,     0,   405,   406,
     407,   408,     0,   409,   410,   143,   411,     0,   412,   413,
     414,     0,   415,     0,     0,     0,     0,     0,   416,   417,
     418,   419,   420,   149,   150,   421,     0,   422,     0,   423,
       0,   424,   425,   426,     0,   427,     0,     0,   428,   429,
     430,   431,     0,   432,   433,   434,     0,   435,     0,   436,
     437,   438,   156,   439,     0,   158,  1734,   440,   441,   160,
       0,   442,     0,   443,     0,     0,     0,   444,     0,   445,
       0,   446,   165,     0,   447,     0,   448,   449,   450,     0,
     451,   452,   453,     0,   454,   455,   456,   457,   458,     0,
       0,   168,     0,   459,   460,   461,     0,   170,     0,   171,
       0,     0,     0,     0,   462,     0,   463,   464,   465,   466,
     467,     0,   175,     0,   468,     0,     0,   469,   470,   471,
       0,     0,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   182,     0,   184,     0,   483,   484,   485,
     486,   487,   488,   489,   185,   490,     0,   491,   492,     0,
     493,     0,   188,   189,   494,   495,  1735,     0,   496,     0,
    1736,     0,   497,   498,     0,     0,   190,     0,     0,   193,
     499,   500,   501,     0,   194,   195,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,   197,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   524,   204,   525,   526,   527,   528,   529,   530,
       0,     0,   531,   532,   533,     0,   534,   208,   535,   536,
       0,   537,   211,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   213,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,   214,   215,     0,   554,     0,   555,   216,
     556,   217,  1737,   557,   558,   559,   560,   561,     0,     0,
     562,   563,   564,   565,     0,     0,   566,   567,     0,   568,
     224,   569,     0,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,    49,     0,   227,   577,     0,
       0,     0,     0,    52,     0,    53,     0,     0,     0,     0,
       0,  1332,    79,    80,    81,   366,    83,    84,     0,    85,
      86,    87,   367,     0,   368,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   369,     0,
       0,   103,   104,   105,   106,     0,     0,   108,   109,   110,
     111,     0,   112,     0,     0,   115,   370,   371,     0,     0,
       0,   372,   373,     0,     0,     0,     0,   374,     0,     0,
       0,     0,     0,     0,     0,     0,   375,     0,   376,     0,
     377,   378,     0,   379,   816,   381,   382,   383,   384,   385,
     386,   817,   387,   388,     0,     0,     0,     0,     0,     0,
       0,   389,   390,     0,   391,     0,   818,   393,   394,     0,
     133,     0,   135,     0,     0,   395,   396,     0,   397,     0,
       0,   398,   399,   136,   400,     0,   401,   402,   403,   404,
     140,     0,     0,   405,   406,   407,   408,     0,   409,   410,
     143,   411,     0,   412,   413,   414,     0,   415,     0,     0,
       0,     0,     0,   416,   417,   418,   419,   420,   149,   150,
     421,     0,   422,     0,   423,     0,   424,   425,   426,     0,
     427,     0,     0,   428,   429,   430,   431,     0,   432,   433,
     434,     0,   435,     0,   436,   437,   438,   156,   439,     0,
     158,     0,   440,   819,   160,     0,   442,     0,   820,     0,
     821,     0,   444,     0,   445,     0,   446,   165,     0,   447,
       0,   448,   449,   450,     0,   451,   452,   453,   822,   454,
     455,   456,   457,   458,     0,     0,   168,     0,   459,   460,
     461,     0,   170,     0,   171,     0,     0,     0,     0,   462,
       0,   463,   464,   465,   466,   823,     0,   175,     0,   468,
       0,     0,   469,   470,   471,     0,     0,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   182,     0,
     184,     0,   824,   484,   485,   486,   487,   488,   489,   185,
     490,     0,   491,   492,     0,   493,     0,   188,   189,   494,
     495,     0,     0,   496,     0,     0,     0,   497,   498,     0,
       0,   190,     0,     0,   193,   499,   500,   501,     0,   194,
     195,   502,   503,   504,     0,   825,   506,   507,   508,   509,
     510,   197,   511,     0,   512,   826,   514,   515,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   524,   204,   525,
     526,   527,   528,   529,   530,     0,     0,   531,   532,   533,
       0,   534,   208,   535,   536,     0,   537,   211,     0,   538,
     539,   540,   541,   542,   543,   544,   545,   213,   546,     0,
     547,   548,     0,   549,   550,   551,   552,     0,   214,   215,
       0,   554,     0,   555,   216,   556,   217,     0,   557,   558,
     559,   560,   561,     0,     0,   562,   563,   564,   565,     0,
       0,   566,   567,     0,   568,   224,   569,     0,   570,     0,
       0,     0,   571,   572,   573,   574,   575,   576,     0,   226,
       0,     0,   227,   577,     0,     0,     0,     0,    52,     0,
      79,    80,    81,   366,    83,    84,   827,    85,    86,    87,
     367,     0,   368,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   369,     0,     0,   103,
     104,   105,   106,     0,     0,   108,   109,   110,   111,     0,
     112,     0,     0,   115,   370,   371,     0,     0,     0,   372,
     373,     0,     0,     0,     0,   374,     0,     0,     0,     0,
       0,     0,     0,     0,   375,     0,   376,     0,   377,   378,
       0,   379,   816,   381,   382,   383,   384,   385,   386,   817,
     387,   388,     0,     0,     0,     0,     0,     0,     0,   389,
     390,     0,   391,     0,   818,   393,   394,     0,   133,     0,
     135,     0,     0,   395,   396,     0,   397,     0,     0,   398,
     399,   136,   400,     0,   401,   402,   403,   404,   140,     0,
       0,   405,   406,   407,   408,     0,   409,   410,   143,   411,
       0,   412,   413,   414,     0,   415,     0,     0,     0,     0,
       0,   416,   417,   418,   419,   420,   149,   150,   421,     0,
     422,     0,   423,     0,   424,   425,   426,     0,   427,     0,
       0,   428,   429,   430,   431,     0,   432,   433,   434,     0,
     435,     0,   436,   437,   438,   156,   439,     0,   158,     0,
     440,   819,   160,     0,   442,     0,   820,     0,     0,     0,
     444,     0,   445,     0,   446,   165,     0,   447,     0,   448,
     449,   450,     0,   451,   452,   453,     0,   454,   455,   456,
     457,   458,     0,     0,   168,     0,   459,   460,   461,     0,
     170,     0,   171,     0,     0,     0,     0,   462,     0,   463,
     464,   465,   466,   823,     0,   175,     0,   468,     0,     0,
     469,   470,   471,     0,     0,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,   182,     0,   184,     0,
     824,   484,   485,   486,   487,   488,   489,   185,   490,     0,
     491,   492,     0,   493,     0,   188,   189,   494,   495,     0,
       0,   496,     0,     0,     0,   497,   498,     0,     0,   190,
       0,     0,   193,   499,   500,   501,     0,   194,   195,   502,
     503,   504,     0,   825,   506,   507,   508,   509,   510,   197,
     511,     0,   512,   826,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   524,   204,   525,   526,   527,
     528,   529,   530,     0,     0,   531,   532,   533,     0,   534,
     208,   535,   536,     0,   537,   211,     0,   538,   539,   540,
     541,   542,   543,   544,   545,   213,   546,     0,   547,   548,
       0,   549,   550,   551,   552,     0,   214,   215,     0,   554,
       0,   555,   216,   556,   217,     0,   557,   558,   559,   560,
     561,     0,     0,   562,   563,   564,   565,     0,     0,   566,
     567,     0,   568,   224,   569,     0,   570,     0,     0,     0,
     571,   572,   573,   574,   575,   576,     0,   226,     0,     0,
     227,   577,     0,     0,     0,     0,    52,     0,    79,    80,
      81,   366,    83,    84,   827,    85,    86,    87,   367,     0,
     368,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   369,     0,     0,   103,   104,   105,
     106,     0,     0,   108,   109,   110,   111,     0,   112,     0,
       0,   115,   370,   371,     0,     0,     0,   372,   373,     0,
       0,     0,     0,   374,     0,     0,     0,     0,     0,     0,
       0,     0,   375,     0,   376,     0,   377,   378,     0,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,     0,     0,     0,     0,   389,   390,     0,
     391,     0,   392,   393,   394,     0,   133,     0,   135,     0,
       0,   395,   396,     0,   397,     0,     0,   398,   399,   136,
     400,     0,   401,   402,   403,   404,   140,     0,     0,   405,
     406,   407,   408,     0,   409,   410,   143,   411,     0,   412,
     413,   414,     0,   415,     0,     0,     0,     0,     0,   416,
     417,   418,   419,   420,   149,   150,   421,   601,   422,     0,
     423,     0,   424,   425,   426,     0,   427,     0,     0,   428,
     429,   430,   431,     0,   432,   433,   434,     0,   435,     0,
     436,   437,   438,   156,   439,     0,   158,     0,   440,   441,
     160,     0,   442,     0,   443,     0,     0,     0,   444,     0,
     445,     0,   446,   165,     0,   447,     0,   448,   449,   450,
       0,   451,   452,   453,     0,   454,   455,   456,   457,   458,
       0,     0,   168,     0,   459,   460,   461,     0,   170,     0,
     171,     0,     0,     0,     0,   462,     0,   463,   464,   465,
     466,   467,     0,   175,     0,   468,     0,     0,   469,   470,
     471,     0,     0,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,   182,     0,   184,     0,   483,   484,
     485,   486,   487,   488,   489,   185,   490,     0,   491,   492,
       0,   493,     0,   188,   189,   494,   495,     0,     0,   496,
       0,     0,     0,   497,   498,     0,     0,   190,     0,     0,
     193,   499,   500,   501,     0,   194,   195,   502,   503,   504,
       0,   505,   506,   507,   508,   509,   510,   197,   511,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   524,   204,   525,   526,   527,   528,   529,
     530,     0,     0,   531,   532,   533,     0,   534,   208,   535,
     536,     0,   537,   211,     0,   538,   539,   540,   541,   542,
     543,   544,   545,   213,   546,     0,   547,   548,     0,   549,
     550,   551,   552,     0,   214,   215,  1270,   554,     0,   555,
     216,   556,   217,     0,   557,   558,   559,   560,   561,     0,
       0,   562,   563,   564,   565,     0,     0,   566,   567,     0,
     568,   224,   569,     0,   570,     0,     0,     0,   571,   572,
     573,   574,   575,   576,     0,   226,     0,     0,   227,   577,
       0,    79,    80,    81,   366,    83,    84,  1271,    85,    86,
      87,   367,     0,   368,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   369,     0,     0,
     103,   104,   105,   106,     0,     0,   108,   109,   110,   111,
       0,   112,     0,     0,   115,   370,   371,     0,     0,     0,
     372,   373,     0,     0,     0,     0,   374,     0,     0,     0,
       0,     0,     0,     0,     0,   375,     0,   376,     0,   377,
     378,     0,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,     0,     0,     0,     0,
     389,   390,     0,   391,     0,   392,   393,   394,     0,   133,
       0,   135,     0,     0,   395,   396,     0,   397,     0,     0,
     398,   399,   136,   400,     0,   401,   402,   403,   404,   140,
       0,     0,   405,   406,   407,   408,     0,   409,   410,   143,
     411,     0,   412,   413,   414,     0,   415,     0,     0,     0,
       0,     0,   416,   417,   418,   419,   420,   149,   150,   421,
       0,   422,     0,   423,     0,   424,   425,   426,     0,   427,
       0,     0,   428,   429,   430,   431,     0,   432,   433,   434,
       0,   435,     0,   436,   437,   438,   156,   439,     0,   158,
       0,   440,   441,   160,     0,   442,     0,   443,     0,     0,
       0,   444,     0,   445,     0,   446,   165,     0,   447,     0,
     448,   449,   450,     0,   451,   452,   453,     0,   454,   455,
     456,   457,   458,     0,     0,   168,     0,   459,   460,   461,
       0,   170,     0,   171,     0,     0,     0,     0,   462,     0,
     463,   464,   465,   466,   467,     0,   175,     0,   468,     0,
       0,   469,   470,   471,     0,     0,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   182,     0,   184,
       0,   483,   484,   485,   486,   487,   488,   489,   185,   490,
       0,   491,   492,     0,   493,     0,   188,   189,   494,   495,
       0,     0,   496,     0,     0,     0,   497,   498,     0,     0,
     190,     0,     0,   193,   499,   500,   501,     0,   194,   195,
     502,   503,   504,     0,   505,   506,   507,   508,   509,   510,
     197,   511,     0,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   524,   204,   525,   526,
     527,   528,   529,   530,     0,     0,   531,   532,   533,     0,
     534,   208,   535,   536,     0,   537,   211,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   213,   546,     0,   547,
     548,     0,   549,   550,   551,   552,     0,   214,   215,     0,
     554,     0,   555,   216,   556,   217,     0,   557,   558,   559,
     560,   561,     0,     0,   562,   563,   564,   565,     0,     0,
     566,   567,     0,   568,   224,   569,     0,   570,     0,     0,
       0,   571,   572,   573,   574,   575,   576,     0,   226,    49,
       0,   227,   577,     0,     0,  1220,  1221,    52,     0,    53,
      79,    80,    81,   366,    83,    84,     0,    85,    86,    87,
     367,     0,   368,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   369,     0,     0,   103,
     104,   105,   106,     0,     0,   108,   109,   110,   111,     0,
     112,     0,     0,   115,   370,   371,     0,     0,     0,   372,
     373,     0,     0,     0,     0,   374,     0,     0,     0,     0,
       0,     0,     0,     0,   375,     0,   376,     0,   377,   378,
       0,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,     0,     0,     0,     0,   389,
     390,     0,   391,     0,   392,   393,   394,     0,   133,     0,
     135,     0,     0,   395,   396,     0,   397,     0,     0,   398,
     399,   136,   400,     0,   401,   402,   403,   404,   140,     0,
       0,   405,   406,   407,   408,     0,   409,   410,   143,   411,
       0,   412,   413,   414,     0,   415,     0,     0,     0,     0,
       0,   416,   417,   418,   419,   420,   149,   150,   421,     0,
     422,     0,   423,     0,   424,   425,   426,     0,   427,     0,
       0,   428,   429,   430,   431,     0,   432,   433,   434,     0,
     435,     0,   436,   437,   438,   156,   439,     0,   158,     0,
     440,   441,   160,     0,   442,     0,   443,     0,     0,     0,
     444,     0,   445,     0,   446,   165,     0,   447,     0,   448,
     449,   450,     0,   451,   452,   453,     0,   454,   455,   456,
     457,   458,     0,     0,   168,     0,   459,   460,   461,     0,
     170,     0,   171,     0,     0,     0,     0,   462,     0,   463,
     464,   465,   466,   467,     0,   175,     0,   468,     0,     0,
     469,   470,   471,     0,     0,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,   182,     0,   184,     0,
     483,   484,   485,   486,   487,   488,   489,   185,   490,     0,
     491,   492,     0,   493,     0,   188,   189,   494,   495,     0,
       0,   496,     0,     0,     0,   497,   498,     0,     0,   190,
       0,     0,   193,   499,   500,   501,     0,   194,   195,   502,
     503,   504,     0,   505,   506,   507,   508,   509,   510,   197,
     511,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   524,   204,   525,   526,   527,
     528,   529,   530,     0,     0,   531,   532,   533,     0,   534,
     208,   535,   536,     0,   537,   211,     0,   538,   539,   540,
     541,   542,   543,   544,   545,   213,   546,     0,   547,   548,
       0,   549,   550,   551,   552,     0,   214,   215,     0,   554,
       0,   555,   216,   556,   217,     0,   557,   558,   559,   560,
     561,     0,     0,   562,   563,   564,   565,     0,     0,   566,
     567,     0,   568,   224,   569,     0,   570,     0,     0,     0,
     571,   572,   573,   574,   575,   576,     0,   226,     0,     0,
     227,     0,   885,  1351,    79,    80,    81,   366,    83,    84,
       0,    85,    86,    87,   367,   886,   368,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     369,     0,     0,   103,   104,   105,   106,     0,     0,   108,
     109,   110,   111,     0,   112,     0,     0,   115,   370,   371,
       0,     0,     0,   372,   373,     0,     0,     0,     0,   374,
       0,     0,     0,     0,     0,     0,     0,     0,   375,     0,
     376,     0,   377,   378,     0,   379,   380,   381,   382,   383,
     384,   385,   386,     0,   387,   388,     0,     0,     0,     0,
       0,     0,     0,   389,   390,     0,   391,     0,   392,   393,
     394,     0,   133,     0,   135,     0,     0,   395,   396,     0,
     397,     0,     0,   398,   864,   136,   400,     0,   401,   402,
     403,   404,   140,     0,     0,   405,   406,   407,   887,     0,
     888,   410,   143,   411,     0,   412,   413,   414,     0,   415,
       0,     0,     0,     0,     0,   416,   417,   418,   419,   420,
     149,   150,   421,     0,   422,     0,   423,     0,   424,   425,
     426,     0,   427,     0,     0,   428,   429,   430,   431,     0,
     432,   433,   434,     0,   435,     0,   436,   437,   438,   156,
     439,     0,   158,     0,   440,   441,   160,     0,   442,     0,
     443,     0,     0,     0,   444,     0,   445,     0,   446,   165,
       0,   447,     0,   448,   449,   450,     0,   451,   452,   453,
       0,   454,   455,   456,   457,   458,     0,     0,   168,     0,
     459,   460,   461,     0,   170,     0,   171,     0,     0,     0,
       0,   462,     0,   463,   464,   465,   466,   467,     0,   175,
       0,   468,     0,     0,   469,   470,   889,     0,     0,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   890,
     182,     0,   184,     0,   483,   484,   485,   486,   487,   488,
     489,   185,   490,     0,   491,   492,     0,   493,     0,   188,
     189,   494,   495,     0,     0,   496,     0,     0,     0,   497,
     498,     0,     0,   190,     0,     0,   193,   499,   500,   501,
       0,   194,   195,   502,   503,   504,     0,   505,   506,   507,
     508,   509,   510,   197,   511,     0,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   522,     0,   891,   524,
     204,   525,   526,   527,   528,   529,   530,     0,     0,   531,
     532,   892,     0,   534,   208,   535,   536,     0,   537,   211,
       0,   538,   539,   540,   541,   542,   543,   544,   545,   213,
     546,     0,   547,   548,     0,   549,   550,   551,   552,     0,
     893,   215,     0,   554,     0,   894,   216,   556,   217,     0,
     557,   558,   559,   560,   561,     0,     0,   562,   563,   564,
     565,     0,     0,   566,   567,     0,   568,   224,   569,     0,
     570,     0,     0,     0,   571,   572,   573,   574,   575,   576,
       0,   226,     0,     0,   227,    79,    80,    81,     0,    83,
      84,     0,    85,    86,    87,     0,     0,     0,    90,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,     0,     0,     0,   103,   104,   105,   106,     0,   107,
     108,   109,   110,   111, -1352,   112,   113,   114,   115,     0,
       0,     0,     0,     0,   118,   119,     0,     0,     0,     0,
     120,     0,     0,     0,     0,     0,     0,     0,     0,   121,
       0,   122,     0,   123,   124,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   130,     0,
       0,     0,   132,   133,   134,   135,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   136,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   143,     0,     0,     0,     0,     0,   146,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   149,   150,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     156,     0,     0,   158,     0,     0,     0,   160,     0,     0,
       0,     0,   161,     0,   162,     0,     0,     0,     0,     0,
     165,     0,     0,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   170,     0,   171,     0,     0,
     172,   173,     0,   174,     0,     0,     0,     0,     0,     0,
     175,   176,     0,   177,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   182,   183,   184,     0,     0,     0,     0,     0,     0,
       0,     0,   185,     0,     0,     0,     0,   187,     0,     0,
     188,   189,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   190,   191,   192,   193,     0,     0,
       0,     0,   194,   195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   202,     0,
       0,   204,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   208,     0,     0,   210,     0,
     211,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     213,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   214,   215,     0,     0,     0,     0,   216,     0,   217,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,   227,     0,   357,    79,    80,
      81,     0,    83,    84,     0,    85,    86,    87,     0,     0,
       0,    90,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,     0,     0,     0,   103,   104,   105,
     106,     0,   107,   108,   109,   110,   111, -1353,   112,   113,
     114,   115,     0,     0,     0,     0,     0,   118,   119,     0,
       0,     0,     0,   120,     0,     0,     0,     0,     0,     0,
       0,     0,   121,     0,   122,     0,   123,   124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   130,     0,     0,     0,   132,   133,   134,   135,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   136,
       0,     0,     0,     0,     0,     0,   140,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   143,     0,     0,     0,
       0,     0,   146,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   149,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   156,     0,     0,   158,     0,     0,     0,
     160,     0,     0,     0,     0,   161,     0,   162,     0,     0,
       0,     0,     0,   165,     0,     0,     0,     0,     0,     0,
     166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   170,     0,
     171,     0,     0,   172,   173,     0,   174,     0,     0,     0,
       0,     0,     0,   175,   176,     0,   177,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   182,   183,   184,     0,     0,     0,
       0,     0,     0,     0,     0,   185,     0,     0,     0,     0,
     187,     0,     0,   188,   189,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   190,   191,   192,
     193,     0,     0,     0,     0,   194,   195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   202,     0,     0,   204,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   208,     0,
       0,   210,     0,   211,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   213,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   214,   215,     0,     0,     0,     0,
     216,     0,   217,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   224,     0,   225,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   226,     0,     0,   227,     0,
     951,   611,    79,    80,    81,   366,    83,    84,     0,    85,
      86,    87,   367,     0,   368,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   612,    99,   100,   101,   369,   613,
       0,   103,   104,   105,   106,   614,   615,   108,   109,   110,
     111,     0,   112,   616,   617,   115,   370,   371,     0,     0,
       0,   372,   373,     0,     0,     0,     0,   374,     0,     0,
       0,     0,     0,     0,     0,     0,   375,     0,   376,     0,
     377,   378,     0,   379,   380,   381,   382,   383,   384,   385,
     386,   618,   387,   388,   619,   620,   621,   622,   623,   624,
     625,   389,   390,   626,   391,   130,   392,   393,   394,   132,
     133,   134,   135,     0,   627,   395,   396,     0,   397,   628,
     629,   398,   630,   136,   400,   631,   401,   402,   403,   404,
     140,   632,   633,   405,   406,   407,   408,   634,   409,   410,
     143,   411,   635,   412,   413,   414,   146,   415,   636,   637,
     638,   639,   640,   416,   417,   418,   419,   420,   149,   150,
     421,   641,   422,   642,   423,     0,   424,   425,   426,   643,
     427,   644,   645,   428,   429,   430,   431,   646,   432,   433,
     434,   647,   435,   648,   436,   437,   438,   156,   439,     0,
     158,   649,   440,   441,   160,   650,   442,   651,   443,   161,
     652,   162,   444,     0,   445,   653,   446,   165,   654,   447,
     655,   448,   449,   450,   166,   451,   452,   453,   656,   454,
     455,   456,   457,   458,   657,   167,   168,   658,   459,   460,
     461,   659,   170,   660,   171,   661,     0,   172,   173,   462,
     174,   463,   464,   465,   466,   467,   662,   175,   176,   468,
     177,   663,   469,   470,   471,     0,     0,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   182,   183,
     184,   664,   483,   484,   485,   486,   487,   488,   489,   185,
     490,   665,   491,   492,   187,   493,   666,   188,   189,   494,
     495,   667,   668,   496,   669,   670,   671,   497,   498,   672,
     673,   190,   191,   192,   193,   499,   500,   501,     0,   194,
     195,   502,   503,   504,   674,   505,   506,   507,   508,   509,
     510,   197,   511,   675,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   522,   202,   523,   524,   204,   525,
     526,   527,   528,   529,   530,     0,   676,   531,   532,   533,
     677,   534,   208,   535,   536,   210,   537,   211,   678,   538,
     539,   540,   541,   542,   543,   544,   545,   213,   546,   679,
     547,   548,   680,   549,   550,   551,   552,   681,   214,   215,
     682,   554,   683,   555,   216,   556,   217,   684,   557,   558,
     559,   560,   561,   685,   686,   562,   563,   564,   565,   687,
     688,   566,   567,     0,   568,   224,   569,   225,   570,     0,
     689,   690,   571,   572,   573,   574,   575,   576,     0,   226,
       0,     0,   227,   611,    79,    80,    81,   366,    83,    84,
       0,    85,    86,    87,   367,     0,   368,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   612,    99,   100,   101,
     369,   613,     0,   103,   104,   105,   106,   614,   615,   108,
     109,   110,   111,     0,   112,   616,   617,   115,   370,   371,
       0,     0,     0,   372,   373,     0,     0,     0,     0,   374,
       0,     0,     0,     0,     0,     0,     0,     0,   375,     0,
     376,     0,   377,   378,     0,   379,   380,   381,   382,   383,
     384,   385,   386,     0,   387,   388,     0,     0,     0,     0,
       0,     0,     0,   389,   390,     0,   391,   130,   392,   393,
     394,   132,  1476,   134,  1477,  1171,     0,   395,   396,     0,
     397,     0,     0,   398,  1478,  1479,   400,     0,   401,   402,
     403,   404,     0,     0,     0,   405,   406,   407,   408,     0,
     409,   410,     0,   411,     0,   412,   413,   414,   146,   415,
       0,     0,     0,     0,     0,   416,   417,   418,   419,   420,
    1480,  1481,   421,     0,   422,     0,   423,     0,   424,   425,
     426,     0,   427,     0,     0,   428,  1185,   430,   431,     0,
     432,   433,   434,     0,   435,     0,   436,   437,   438,     0,
     439,     0,     0,     0,   440,   441,  1482,     0,   442,     0,
     443,   161,     0,   162,   444,     0,   445,     0,   446,     0,
       0,   447,     0,   448,   449,   450,   166,   451,   452,   453,
    1852,   454,   455,   456,   457,   458,     0,   167,  1853,     0,
     459,   460,   461,  1191,  1483,     0,  1484,     0,     0,   172,
     173,   462,   174,   463,   464,   465,   466,   467,     0,     0,
     176,   468,   177,     0,   469,   470,   471,     0,     0,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
    1485,   183,  1486,     0,   483,   484,   485,   486,   487,   488,
     489,     0,   490,     0,   491,   492,   187,   493,     0,     0,
    1487,   494,   495,     0,     0,   496,     0,     0,     0,   497,
     498,     0,     0,  1854,   191,   192,     0,   499,   500,   501,
       0,     0,     0,   502,   503,   504,     0,   505,   506,   507,
     508,   509,   510,  1488,   511,     0,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   522,   202,   523,   524,
       0,   525,   526,   527,   528,   529,   530,     0,     0,   531,
     532,   533,     0,   534,  1489,   535,   536,   210,   537,  1490,
       0,   538,   539,   540,   541,   542,   543,   544,   545,     0,
     546,     0,   547,   548,     0,   549,   550,   551,   552,     0,
    1491,  1492,     0,   554,     0,   555,     0,   556,     0,     0,
     557,   558,   559,   560,   561,     0,     0,   562,   563,   564,
     565,     0,     0,   566,   567,     0,   568,  1493,   569,   225,
     570,     0,     0,     0,   571,   572,   573,   574,   575,   576,
       0,   226,     0,     0,   227,   611,    79,    80,    81,   366,
      83,    84,     0,    85,    86,    87,   367,     0,   368,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   612,    99,
     100,   101,   369,   613,     0,   103,   104,   105,   106,   614,
     615,   108,   109,   110,   111,     0,   112,   616,   617,   115,
     370,   371,     0,     0,     0,   372,   373,     0,     0,     0,
       0,   374,     0,     0,     0,     0,     0,     0,     0,     0,
     375,     0,   376,     0,   377,   378,     0,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,     0,     0,     0,     0,   389,   390,     0,   391,   130,
     392,   393,   394,   132,  1476,   134,  1477,  1171,     0,   395,
     396,     0,   397,     0,     0,   398,  1478,  1479,   400,     0,
     401,   402,   403,   404,     0,     0,     0,   405,   406,   407,
     408,     0,   409,   410,     0,   411,     0,   412,   413,   414,
     146,   415,     0,     0,     0,     0,     0,   416,   417,   418,
     419,   420,  1480,  1481,   421,     0,   422,     0,   423,     0,
     424,   425,   426,     0,   427,     0,     0,   428,  1185,   430,
     431,     0,   432,   433,   434,     0,   435,     0,   436,   437,
     438,     0,   439,     0,     0,     0,   440,   441,  1482,     0,
     442,     0,   443,   161,     0,   162,   444,     0,   445,     0,
     446,     0,     0,   447,     0,   448,   449,   450,   166,   451,
     452,   453,     0,   454,   455,   456,   457,   458,     0,   167,
       0,     0,   459,   460,   461,  1191,  1483,     0,  1484,     0,
       0,   172,   173,   462,   174,   463,   464,   465,   466,   467,
       0,     0,   176,   468,   177,     0,   469,   470,   471,     0,
       0,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,  1485,   183,  1486,     0,   483,   484,   485,   486,
     487,   488,   489,     0,   490,     0,   491,   492,   187,   493,
       0,     0,  1487,   494,   495,     0,     0,   496,     0,     0,
       0,   497,   498,     0,     0,     0,   191,   192,     0,   499,
     500,   501,     0,     0,     0,   502,   503,   504,     0,   505,
     506,   507,   508,   509,   510,  1488,   511,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   522,   202,
     523,   524,     0,   525,   526,   527,   528,   529,   530,     0,
       0,   531,   532,   533,     0,   534,  1489,   535,   536,   210,
     537,  1490,     0,   538,   539,   540,   541,   542,   543,   544,
     545,     0,   546,     0,   547,   548,     0,   549,   550,   551,
     552,     0,  1491,  1492,     0,   554,     0,   555,     0,   556,
       0,     0,   557,   558,   559,   560,   561,     0,     0,   562,
     563,   564,   565,     0,     0,   566,   567,     0,   568,  1493,
     569,   225,   570,     0,     0,     0,   571,   572,   573,   574,
     575,   576,     0,   226,     0,     0,   227,    79,    80,    81,
     366,    83,    84,   599,    85,    86,    87,   367,     0,   368,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   369,     0,     0,   103,   104,   105,   106,
       0,     0,   108,   109,   110,   111,     0,   112,     0,     0,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,   600,   387,   388,     0,
       0,     0,     0,     0,     0,     0,   389,   390,     0,   391,
       0,   392,   393,   394,     0,   133,     0,   135,     0,     0,
     395,   396,     0,   397,     0,     0,   398,   399,   136,   400,
       0,   401,   402,   403,   404,   140,     0,     0,   405,   406,
     407,   408,     0,   409,   410,   143,   411,     0,   412,   413,
     414,     0,   415,     0,     0,     0,     0,     0,   416,   417,
     418,   419,   420,   149,   150,   421,   601,   422,     0,   423,
       0,   424,   425,   426,     0,   427,     0,     0,   428,   429,
     430,   431,     0,   432,   433,   434,     0,   435,     0,   436,
     437,   438,   156,   439,     0,   158,     0,   440,   441,   160,
       0,   442,     0,   443,     0,     0,     0,   444,     0,   445,
       0,   446,   165,     0,   447,     0,   448,   449,   450,     0,
     451,   452,   453,     0,   454,   455,   456,   457,   458,     0,
       0,   168,     0,   459,   460,   461,     0,   170,     0,   171,
       0,     0,     0,     0,   462,     0,   463,   464,   465,   466,
     467,     0,   175,     0,   468,     0,     0,   469,   470,   471,
       0,     0,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   182,     0,   184,     0,   483,   484,   485,
     486,   487,   488,   489,   185,   490,     0,   491,   492,     0,
     493,     0,   188,   189,   494,   495,     0,     0,   496,     0,
       0,     0,   497,   498,     0,     0,   190,     0,     0,   193,
     499,   500,   501,     0,   194,   195,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,   197,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   524,   204,   525,   526,   527,   528,   529,   530,
       0,     0,   531,   532,   533,     0,   534,   208,   535,   536,
       0,   537,   211,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   213,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,   214,   215,     0,   554,     0,   555,   216,
     556,   217,     0,   557,   558,   559,   560,   561,     0,     0,
     562,   563,   564,   565,     0,     0,   566,   567,     0,   568,
     224,   569,     0,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,     0,     0,   227,   577,    79,
      80,    81,   366,    83,    84,     0,    85,    86,    87,   367,
       0,   368,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   369,     0,     0,   103,   104,
     105,   106,     0,     0,  2197,   109,   110,   111,     0,   112,
       0,     0,   115,   370,   371,     0,     0,     0,   372,   373,
       0,     0,     0,     0,   374,     0,     0,     0,     0,     0,
       0,     0,     0,   375,     0,   376,     0,   377,   378,     0,
     379,   380,   381,   382,   383,   384,   385,   386,     0,   387,
     388,     0,     0,     0,     0,     0,     0,     0,   389,   390,
       0,   391,     0,   392,   393,   394,     0,   133,     0,   135,
       0,     0,   395,   396,     0,   397,     0,     0,   398,   399,
     136,   400,     0,   401,   402,   403,   404,   140,     0,     0,
     405,   406,   407,   408,     0,   409,   410,   143,   411,     0,
     412,   413,   414,     0,   415,     0,     0,     0,     0,     0,
     416,   417,   418,   419,   420,   149,   150,   421,     0,   422,
       0,   423,     0,   424,   425,   426,     0,   427,     0,     0,
     428,   429,   430,   431,     0,   432,   433,   434,     0,   435,
       0,   436,   437,   438,   156,   439,     0,   158,     0,   440,
     441,   160,     0,   442,     0,   443,     0,     0,     0,   444,
       0,  2198,     0,   446,   165,     0,   447,     0,   448,   449,
     450,     0,   451,   452,   453,     0,   454,   455,   456,   457,
     458,     0,     0,   168,     0,   459,   460,   461,     0,   170,
       0,   171,     0,     0,     0,     0,   462,     0,   463,   464,
     465,   466,   467,     0,   175,     0,   468,     0,     0,   469,
     470,  2199,     0,     0,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   182,     0,   184,   740,   483,
     484,   485,   486,   487,   488,   489,   185,   490,     0,   491,
     492,     0,   493,     0,   188,   189,   494,   495,     0,     0,
     496,   741,     0,     0,   497,   498,     0,     0,   190,     0,
       0,   193,   499,   500,   501,     0,   194,   195,   502,   503,
     504,     0,   505,   506,   507,   508,   509,   510,   197,   511,
       0,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   524,   204,   525,   526,   527,   528,
     529,   530,     0,     0,   531,   532,   533,     0,   534,   208,
     535,   536,     0,   537,   211,     0,   538,   539,   540,   541,
     542,   543,   544,   545,   213,   546,     0,   547,   548,  2200,
     549,  2201,   551,  2202,     0,   214,   215,     0,   554,     0,
     555,   216,   556,   217,     0,   557,   558,   559,   560,   561,
       0,     0,   562,   563,   564,   565,     0,     0,   566,   567,
       0,   568,   224,   569,     0,   570,     0,     0,     0,   571,
     572,   573,   574,   575,   576,     0,   226,     0,     0,   227,
     577,    79,    80,    81,   366,    83,    84,     0,    85,    86,
      87,   367,     0,   368,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   369,     0,     0,
     103,   104,   105,   106,     0,     0,   108,   109,   110,   111,
       0,   112,     0,     0,   115,   370,   371,     0,     0,     0,
     372,   373,     0,     0,     0,     0,   374,     0,     0,     0,
       0,     0,     0,     0,     0,   375,     0,   376,     0,   377,
     378,     0,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,     0,     0,     0,     0,
     389,   390,     0,   391,     0,   392,   393,   394,     0,   133,
       0,   135,     0,     0,   395,   396,     0,   397,     0,     0,
     398,   399,   136,   400,     0,   401,   402,   403,   404,   140,
       0,     0,   405,   406,   407,   408,     0,   409,   410,   143,
     411,     0,   412,   413,   414,     0,   415,     0,     0,     0,
       0,     0,   416,   417,   418,   419,   420,   149,   150,   421,
       0,   422,     0,   423,     0,   424,   425,   426,     0,   427,
       0,     0,   428,   429,   430,   431,     0,   432,   433,   434,
       0,   435,     0,   436,   437,   438,   156,   439,     0,   158,
       0,   440,   441,   160,     0,   442,     0,   443,     0,     0,
       0,   444,     0,   445,     0,   446,   165,     0,   447,     0,
     448,   449,   450,     0,   451,   452,   453,     0,   454,   455,
     456,   457,   458,     0,     0,   168,     0,   459,   460,   461,
       0,   170,     0,   171,     0,     0,     0,     0,   462,     0,
     463,   464,   465,   466,   467,     0,   175,     0,   468,     0,
       0,   469,   470,   471,     0,     0,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   182,     0,   184,
       0,   483,   484,   485,   486,   487,   488,   489,   185,   490,
       0,   491,   492,     0,   493,     0,   188,   189,   494,   495,
       0,     0,   496,     0,     0,     0,   497,   498,     0,     0,
     190,     0,     0,   193,   499,   500,   501,     0,   194,   195,
     502,   503,   504,     0,   505,   506,   507,   508,   509,   510,
     197,   511,     0,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   524,   204,   525,   526,
     527,   528,   529,   530,     0,     0,   531,   532,   533,     0,
     534,   208,   535,   536,     0,   537,   211,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   213,   546,     0,   547,
     548,     0,   549,   550,   551,   552,     0,   214,   215,   553,
     554,     0,   555,   216,   556,   217,     0,   557,   558,   559,
     560,   561,     0,     0,   562,   563,   564,   565,     0,     0,
     566,   567,     0,   568,   224,   569,     0,   570,     0,     0,
       0,   571,   572,   573,   574,   575,   576,     0,   226,    49,
       0,   227,   577,    79,    80,    81,   366,    83,    84,     0,
      85,    86,    87,   367,     0,   368,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   369,
       0,     0,   103,   104,   105,   106,     0,     0,   108,   109,
     110,   111,     0,   112,     0,     0,   115,   370,   371,     0,
       0,     0,   372,   373,     0,     0,     0,     0,   374,     0,
       0,     0,     0,     0,     0,     0,     0,   375,     0,   376,
       0,   377,   378,     0,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,     0,     0,
       0,     0,   389,   390,     0,   391,     0,   392,   393,   394,
       0,   133,     0,   135,     0,     0,   395,   396,     0,   397,
       0,     0,   398,   399,   136,   400,     0,   401,   402,   403,
     404,   140,     0,     0,   405,   406,   407,   408,     0,   409,
     410,   143,   411,     0,   412,   413,   414,     0,   415,     0,
       0,     0,     0,     0,   416,   417,   418,   419,   420,   149,
     150,   421,  1724,   422,     0,   423,     0,   424,   425,   426,
       0,   427,     0,     0,   428,   429,   430,   431,     0,   432,
     433,   434,     0,   435,     0,   436,   437,   438,   156,   439,
       0,   158,     0,   440,   441,   160,     0,   442,     0,   443,
       0,     0,     0,   444,     0,   445,     0,   446,   165,     0,
     447,     0,   448,   449,   450,     0,   451,   452,   453,     0,
     454,   455,   456,   457,   458,     0,     0,   168,     0,   459,
     460,   461,     0,   170,     0,   171,     0,     0,     0,     0,
     462,     0,   463,   464,   465,   466,   467,     0,   175,     0,
     468,     0,     0,   469,   470,   471,     0,     0,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   182,
       0,   184,     0,   483,   484,   485,   486,   487,   488,   489,
     185,   490,     0,   491,   492,     0,   493,     0,   188,   189,
     494,   495,     0,     0,   496,     0,     0,     0,   497,   498,
       0,     0,   190,     0,     0,   193,   499,   500,   501,     0,
     194,   195,   502,   503,   504,     0,   505,   506,   507,   508,
     509,   510,   197,   511,     0,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   524,   204,
     525,   526,   527,   528,   529,   530,     0,     0,   531,   532,
     533,     0,   534,   208,   535,   536,     0,   537,   211,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   213,   546,
       0,   547,   548,     0,   549,   550,   551,   552,     0,   214,
     215,     0,   554,     0,   555,   216,   556,   217,     0,   557,
     558,   559,   560,   561,     0,     0,   562,   563,   564,   565,
       0,     0,   566,   567,     0,   568,   224,   569,     0,   570,
       0,     0,     0,   571,   572,   573,   574,   575,   576,     0,
     226,    49,     0,   227,   577,    79,    80,    81,   366,    83,
      84,     0,    85,    86,    87,   367,   780,   368,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   369,     0,     0,   103,   104,   105,   106,     0,     0,
     108,   109,   110,   111,     0,   112,     0,     0,   115,   370,
     371,     0,     0,     0,   372,   373,     0,     0,     0,     0,
     374,     0,     0,     0,     0,     0,     0,     0,     0,   375,
       0,   376,     0,   377,   378,     0,   379,   380,   381,   382,
     383,   384,   385,   386,     0,   387,   388,     0,     0,     0,
       0,     0,     0,     0,   389,   390,     0,   391,     0,   392,
     393,   394,     0,   133,     0,   135,     0,     0,   395,   396,
       0,   397,     0,     0,   398,   399,   136,   400,     0,   401,
     402,   403,   404,   140,     0,     0,   405,   406,   407,   408,
       0,   409,   410,   143,   411,     0,   412,   413,   414,     0,
     415,     0,     0,     0,     0,     0,   416,   417,   418,   419,
     420,   149,   150,   421,     0,   422,     0,   423,     0,   424,
     425,   426,     0,   427,     0,     0,   428,   429,   430,   431,
       0,   432,   433,   434,     0,   435,     0,   436,   437,   438,
     156,   439,     0,   158,     0,   440,   441,   160,     0,   442,
       0,   443,     0,     0,     0,   444,     0,   445,     0,   446,
     165,     0,   447,     0,   448,   449,   450,     0,   451,   452,
     453,     0,   454,   455,   456,   457,   458,     0,     0,   168,
       0,   459,   460,   461,     0,   170,     0,   171,     0,     0,
       0,     0,   462,     0,   463,   464,   465,   466,   467,     0,
     175,     0,   468,     0,     0,   469,   470,   471,     0,     0,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   182,     0,   184,     0,   483,   484,   485,   486,   487,
     488,   489,   185,   490,     0,   491,   492,     0,   493,     0,
     188,   189,   494,   495,     0,     0,   496,     0,     0,     0,
     497,   498,     0,     0,   190,     0,     0,   193,   499,   500,
     501,     0,   194,   195,   502,   781,   504,     0,   505,   506,
     507,   508,   509,   510,   197,   511,     0,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     524,   204,   525,   526,   527,   528,   529,   530,     0,     0,
     531,   532,   533,     0,   534,   208,   535,   536,     0,   537,
     211,     0,   538,   539,   540,   541,   542,   543,   544,   545,
     213,   546,     0,   547,   548,     0,   549,   550,   551,   552,
       0,   214,   215,     0,   554,     0,   555,   216,   556,   217,
       0,   557,   558,   559,   560,   561,     0,     0,   562,   563,
     564,   565,     0,     0,   566,   567,     0,   568,   224,   569,
       0,   570,     0,     0,     0,   571,   572,   573,   574,   575,
     576,     0,   226,     0,     0,   227,   577,    79,    80,    81,
     366,    83,    84,     0,    85,    86,    87,   367,     0,   368,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   369,     0,     0,   103,   104,   105,   106,
       0,     0,   108,   109,   110,   111,     0,   112,     0,     0,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,     0,     0,     0,     0,   389,   390,     0,   391,
       0,   392,   393,   394,     0,   133,     0,   135,     0,     0,
     395,   396,     0,   397,     0,     0,   398,   399,   136,   400,
       0,   401,   402,   403,   404,   140,     0,     0,   405,   406,
     407,   408,     0,   409,   410,   143,   411,     0,   412,   413,
     414,     0,   415,     0,     0,     0,     0,     0,   416,   417,
     418,   419,   420,   149,   150,   421,   960,   422,     0,   423,
       0,   424,   425,   426,     0,   427,     0,     0,   428,   429,
     430,   431,     0,   432,   433,   434,     0,   435,     0,   436,
     437,   438,   156,   439,     0,   158,     0,   440,   441,   160,
       0,   442,     0,   443,     0,     0,     0,   444,     0,   445,
       0,   446,   165,     0,   447,     0,   448,   449,   450,     0,
     451,   452,   453,     0,   454,   455,   456,   457,   458,     0,
       0,   168,     0,   459,   460,   461,     0,   170,     0,   171,
       0,     0,     0,     0,   462,     0,   463,   464,   465,   466,
     467,     0,   175,     0,   468,     0,     0,   469,   470,   471,
       0,     0,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   182,     0,   184,     0,   483,   484,   485,
     486,   487,   488,   489,   185,   490,     0,   491,   492,     0,
     493,     0,   188,   189,   494,   495,     0,     0,   496,     0,
       0,     0,   497,   498,     0,     0,   190,     0,     0,   193,
     499,   500,   501,     0,   194,   195,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,   197,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   524,   204,   525,   526,   527,   528,   529,   530,
       0,     0,   531,   532,   533,     0,   534,   208,   535,   536,
       0,   537,   211,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   213,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,   214,   215,     0,   554,     0,   555,   216,
     556,   217,     0,   557,   558,   559,   560,   561,     0,     0,
     562,   563,   564,   565,     0,     0,   566,   567,     0,   568,
     224,   569,     0,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,     0,     0,   227,   577,    79,
      80,    81,   366,    83,    84,     0,    85,    86,    87,   367,
       0,   368,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   369,     0,     0,   103,   104,
     105,   106,     0,     0,   108,   109,   110,   111,     0,   112,
       0,     0,   115,   370,   371,     0,     0,     0,   372,   373,
       0,     0,     0,     0,   374,     0,     0,     0,     0,     0,
       0,     0,     0,   375,     0,   376,     0,   377,   378,     0,
     379,   380,   381,   382,   383,   384,   385,   386,     0,   387,
     388,     0,     0,     0,     0,     0,     0,     0,   389,   390,
       0,   391,     0,   392,   393,   394,     0,   133,     0,   135,
       0,     0,   395,   396,     0,   397,     0,     0,   398,   399,
     136,   400,     0,   401,   402,   403,   404,   140,     0,     0,
     405,   406,   407,   408,     0,   409,   410,   143,   411,     0,
     412,   413,   414,     0,   415,     0,     0,     0,     0,     0,
     416,   417,   418,   419,   420,   149,   150,   421,     0,   422,
       0,   423,     0,   424,   425,   426,     0,   427,     0,     0,
     428,   429,   430,   431,     0,   432,   433,   434,     0,   435,
       0,   436,   437,   438,   156,   439,     0,   158,     0,   440,
     441,   160,     0,   442,     0,   443,     0,     0,     0,   444,
       0,   445,     0,   446,   165,     0,   447,     0,   448,   449,
     450,     0,   451,   452,   453,     0,   454,   455,   456,   457,
     458,     0,     0,   168,     0,   459,   460,   461,     0,   170,
       0,   171,     0,     0,     0,     0,   462,     0,   463,   464,
     465,   466,   467,     0,   175,     0,   468,     0,     0,   469,
     470,   471,     0,     0,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   182,     0,   184,     0,   483,
     484,   485,   486,   487,   488,   489,   185,   490,     0,   491,
     492,     0,   493,     0,   188,   189,   494,   495,     0,     0,
     496,     0,     0,     0,   497,   498,     0,     0,   190,     0,
       0,   193,   499,   500,   501,     0,   194,   195,   502,   503,
     504,     0,   505,   506,   507,   508,   509,   510,   197,   511,
       0,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   524,   204,   525,   526,   527,   528,
     529,   530,     0,     0,   531,   532,   533,     0,   534,   208,
     535,   536,     0,   537,   211,     0,   538,   539,   540,   541,
     542,   543,   544,   545,   213,   546,     0,   547,   548,     0,
     549,   550,   551,   552,     0,   214,   215,     0,   554,     0,
     555,   216,   556,   217,     0,   557,   558,   559,   560,   561,
       0,     0,   562,   563,   564,   565,     0,     0,   566,   567,
       0,   568,   224,   569,     0,   570,     0,     0,     0,   571,
     572,   573,   574,   575,   576,     0,   226,    49,     0,   227,
     577,    79,    80,    81,   366,    83,    84,     0,    85,    86,
      87,   367,     0,   368,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   369,     0,     0,
     103,   104,   105,   106,     0,     0,   108,   109,   110,   111,
       0,   112,     0,     0,   115,   370,   371,     0,     0,     0,
     372,   373,     0,     0,     0,     0,   374,     0,     0,     0,
       0,     0,     0,     0,     0,   375,     0,   376,     0,   377,
     378,     0,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,     0,     0,     0,     0,
     389,   390,     0,   391,     0,   392,   393,   394,     0,   133,
       0,   135,     0,     0,   395,   396,     0,   397,     0,     0,
     398,   399,   136,   400,     0,   401,   402,   403,   404,   140,
       0,     0,   405,   406,   407,   408,     0,   409,   410,   143,
     411,     0,   412,   413,   414,     0,   415,     0,     0,     0,
       0,     0,   416,   417,   418,   419,   420,   149,   150,   421,
     601,   422,     0,   423,     0,   424,   425,   426,     0,   427,
       0,     0,   428,   429,   430,   431,     0,   432,   433,   434,
       0,   435,     0,   436,   437,   438,   156,   439,     0,   158,
       0,   440,   441,   160,     0,   442,     0,   443,     0,     0,
       0,   444,     0,   445,     0,   446,   165,     0,   447,     0,
     448,   449,   450,     0,   451,   452,   453,     0,   454,   455,
     456,   457,   458,     0,     0,   168,     0,   459,   460,   461,
       0,   170,     0,   171,     0,     0,     0,     0,   462,     0,
     463,   464,   465,   466,   467,     0,   175,     0,   468,     0,
       0,   469,   470,   471,     0,     0,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   182,     0,   184,
       0,   483,   484,   485,   486,   487,   488,   489,   185,   490,
       0,   491,   492,     0,   493,     0,   188,   189,   494,   495,
       0,     0,   496,     0,     0,     0,   497,   498,     0,     0,
     190,     0,     0,   193,   499,   500,   501,     0,   194,   195,
     502,   503,   504,     0,   505,   506,   507,   508,   509,   510,
     197,   511,     0,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   524,   204,   525,   526,
     527,   528,   529,   530,     0,     0,   531,   532,   533,     0,
     534,   208,   535,   536,     0,   537,   211,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   213,   546,     0,   547,
     548,     0,   549,   550,   551,   552,     0,   214,   215,     0,
     554,     0,   555,   216,   556,   217,     0,   557,   558,   559,
     560,   561,     0,     0,   562,   563,   564,   565,     0,     0,
     566,   567,     0,   568,   224,   569,     0,   570,     0,     0,
       0,   571,   572,   573,   574,   575,   576,     0,   226,     0,
       0,   227,   577,    79,    80,    81,   366,    83,    84,     0,
      85,    86,    87,   367,     0,   368,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   369,
       0,     0,   103,   104,   105,   106,     0,     0,   108,   109,
     110,   111,     0,   112,     0,     0,   115,   370,   371,     0,
       0,     0,   372,   373,     0,     0,     0,     0,   374,     0,
       0,     0,     0,     0,     0,     0,     0,   375,     0,   376,
       0,   377,   378,     0,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,     0,     0,
       0,     0,   389,   390,     0,   391,     0,   392,   393,   394,
       0,   133,     0,   135,     0,     0,   395,   396,     0,   397,
       0,     0,   398,   399,   136,   400,     0,   401,   402,   403,
     404,   140,     0,     0,   405,   406,   407,   408,     0,   409,
     410,   143,   411,     0,   412,   413,   414,     0,   415,     0,
       0,     0,     0,     0,   416,   417,   418,   419,   420,   149,
     150,   421,     0,   422,     0,   423,     0,   424,   425,   426,
       0,   427,     0,     0,   428,   429,   430,   431,     0,   432,
     433,   434,     0,   435,     0,   436,   437,   438,   156,   439,
       0,   158,     0,   440,   441,   160,     0,   442,     0,   443,
       0,     0,     0,   444,     0,   445,     0,   446,   165,     0,
     447,     0,   448,   449,   450,     0,   451,   452,   453,     0,
     454,   455,   456,   457,   458,     0,     0,   168,     0,   459,
     460,   461,     0,   170,     0,   171,     0,     0,     0,     0,
     462,     0,   463,   464,   465,   466,   467,     0,   175,     0,
     468,     0,     0,   469,   470,   471,     0,     0,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   182,
       0,   184,     0,   483,   484,   485,   486,   487,   488,   489,
     185,   490,     0,   491,   492,     0,   493,     0,   188,   189,
     494,   495,     0,     0,   496,     0,     0,     0,   497,   498,
       0,     0,   190,     0,     0,   193,   499,   500,   501,     0,
     194,   195,   502,   503,   504,     0,   505,   506,   507,   508,
     509,   510,   197,   511,     0,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   524,   204,
     525,   526,   527,   528,   529,   530,     0,     0,   531,   532,
     533,     0,   534,   208,   535,   536,     0,   537,   211,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   213,   546,
       0,   547,   548,     0,   549,   550,   551,   552,     0,   214,
     215,     0,   554,     0,   555,   216,   556,   217,     0,   557,
     558,   559,   560,   561,     0,     0,   562,   563,   564,   565,
       0,     0,   566,   567,     0,   568,   224,   569,     0,   570,
       0,     0,     0,   571,   572,   573,   574,   575,   576,     0,
     226,     0,     0,   227,   577,    79,    80,    81,   366,    83,
      84,     0,    85,    86,    87,   367,     0,   368,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   369,     0,     0,   103,   104,   105,   106,     0,     0,
     108,   109,   110,   111,     0,   112,     0,     0,   115,   370,
     371,     0,     0,     0,   372,   373,     0,     0,     0,     0,
     374,     0,     0,     0,     0,     0,     0,     0,     0,   375,
       0,   376,     0,   377,   378,     0,   379,   380,   381,   382,
     383,   384,   385,   386,     0,   387,   388,     0,     0,     0,
       0,     0,     0,     0,   389,   390,     0,   391,     0,   392,
     393,   394,     0,   133,     0,   135,     0,     0,   395,   396,
       0,   397,     0,     0,   398,   399,   136,   400,     0,   401,
     402,   403,   404,   140,     0,     0,   405,   406,   407,   408,
       0,   409,   410,   143,   411,     0,   412,   413,   414,     0,
     415,     0,     0,     0,     0,     0,   416,   417,   418,   419,
     420,   149,   150,   421,     0,   422,     0,   423,     0,   424,
     425,   426,     0,   427,     0,     0,   428,   429,   430,   431,
       0,   432,   433,   434,     0,   435,     0,   436,   437,   438,
     156,   439,     0,   158,     0,   440,   441,   160,     0,   442,
       0,   443,     0,     0,     0,   444,     0,   445,     0,   446,
     165,     0,   447,     0,   448,   449,   450,     0,   812,   452,
     453,     0,   454,   455,   456,   457,   458,     0,     0,   168,
       0,   459,   460,   461,     0,   170,     0,   171,     0,     0,
       0,     0,   462,     0,   463,   464,   465,   466,   467,     0,
     175,     0,   468,     0,     0,   469,   470,   471,     0,     0,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   182,     0,   184,     0,   483,   484,   485,   486,   487,
     488,   489,   185,   490,     0,   491,   492,     0,   493,     0,
     188,   189,   494,   495,     0,     0,   496,     0,     0,     0,
     497,   498,     0,     0,   190,     0,     0,   193,   499,   500,
     501,     0,   194,   195,   502,   503,   504,     0,   505,   506,
     507,   508,   509,   510,   197,   511,     0,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     524,   204,   525,   526,   527,   528,   529,   530,     0,     0,
     531,   532,   533,     0,   534,   208,   535,   536,     0,   537,
     211,     0,   538,   539,   540,   541,   542,   543,   544,   545,
     213,   546,     0,   547,   548,     0,   549,   550,   551,   552,
       0,   214,   215,     0,   554,     0,   555,   216,   556,   217,
       0,   557,   558,   559,   560,   561,     0,     0,   562,   563,
     564,   565,     0,     0,   566,   567,     0,   568,   224,   569,
       0,   570,     0,     0,     0,   571,   572,   573,   574,   575,
     576,     0,   226,     0,     0,   227,   577,    79,    80,    81,
     366,    83,    84,     0,    85,    86,    87,   367,     0,   368,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   369,     0,     0,   103,   104,   105,   106,
       0,     0,   108,   109,   110,   111,     0,   112,     0,     0,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,     0,     0,     0,     0,   389,   390,     0,   391,
       0,   392,   393,   394,     0,   133,     0,   135,     0,     0,
     395,   396,     0,   397,     0,     0,   398,   399,   136,   400,
       0,   401,   402,   403,   404,   140,     0,     0,   405,   406,
     407,   408,     0,   409,   410,   143,   411,     0,   412,   413,
     414,     0,   415,     0,     0,     0,     0,     0,   416,   417,
     418,   419,   420,   149,   150,   421,     0,   422,     0,   423,
       0,   424,   425,   426,     0,   427,     0,     0,   428,   429,
     430,   431,     0,   432,   433,   434,     0,   435,     0,   436,
     437,   438,   156,   439,     0,   158,     0,   440,   441,   160,
       0,   442,     0,   443,     0,     0,     0,   444,     0,   445,
       0,   446,   165,     0,   447,     0,   448,   449,   450,     0,
     451,   452,   453,     0,   454,   455,   456,   457,   458,     0,
       0,   168,     0,   459,   460,   461,     0,   170,     0,   171,
       0,     0,     0,     0,   462,     0,   463,   464,   465,   466,
     467,     0,   175,     0,   468,     0,     0,   469,   470,   471,
       0,     0,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   182,     0,   184,     0,   483,   484,   485,
     486,   487,   488,   489,   185,   490,     0,   491,   492,     0,
     493,     0,   188,   189,   494,   495,     0,     0,   496,     0,
       0,     0,   497,   498,     0,     0,   190,     0,     0,   193,
     499,   500,   501,     0,   194,   195,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,   197,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   524,   204,   525,   526,   527,   528,   529,   530,
       0,     0,   531,   532,   533,     0,   534,   208,   535,   536,
       0,   537,   211,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   213,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,   214,   215,     0,   554,     0,   854,   216,
     556,   217,     0,   557,   558,   559,   560,   561,     0,     0,
     562,   563,   564,   565,     0,     0,   566,   567,     0,   568,
     224,   569,     0,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,     0,     0,   227,   577,   611,
      79,    80,    81,   366,    83,    84,     0,    85,    86,    87,
     367,     0,   368,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   612,    99,   100,   101,   369,   613,     0,   103,
     104,   105,   106,   614,   615,   108,   109,   110,   111,     0,
     112,   616,   617,   115,   370,   371,     0,     0,     0,   372,
     373,     0,     0,     0,     0,   374,     0,     0,     0,     0,
       0,     0,     0,     0,   375,     0,   376,     0,   377,   378,
       0,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,     0,     0,     0,     0,   389,
     390,     0,   391,     0,   392,   393,   394,     0,  1476,     0,
    1477,  1171,     0,   395,   396,     0,   397,     0,     0,   398,
    1478,  1479,   400,     0,   401,   402,   403,   404,     0,     0,
       0,   405,   406,   407,   408,     0,   409,   410,     0,   411,
       0,   412,   413,   414,     0,   415,     0,     0,     0,     0,
       0,   416,   417,   418,   419,   420,  1480,  1481,   421,     0,
     422,     0,   423,     0,   424,   425,   426,     0,   427,     0,
       0,   428,  1185,   430,   431,     0,   432,   433,   434,     0,
     435,     0,   436,   437,   438,     0,   439,     0,     0,     0,
     440,   441,  1482,     0,   442,     0,   443,     0,     0,     0,
     444,     0,   445,     0,   446,     0,     0,   447,     0,   448,
     449,   450,     0,   451,   452,   453,  1852,   454,   455,   456,
     457,   458,     0,     0,  1853,     0,   459,   460,   461,  1191,
    1483,     0,  1484,     0,     0,     0,     0,   462,     0,   463,
     464,   465,   466,   467,     0,     0,     0,   468,     0,     0,
     469,   470,   471,     0,     0,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,  1485,     0,  1486,     0,
     483,   484,   485,   486,   487,   488,   489,     0,   490,     0,
     491,   492,     0,   493,     0,     0,  1487,   494,   495,     0,
       0,   496,     0,     0,     0,   497,   498,     0,     0,  1854,
       0,     0,     0,   499,   500,   501,     0,     0,     0,   502,
     503,   504,     0,   505,   506,   507,   508,   509,   510,  1488,
     511,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   524,     0,   525,   526,   527,
     528,   529,   530,     0,     0,   531,   532,   533,     0,   534,
    1489,   535,   536,     0,   537,  1490,     0,   538,   539,   540,
     541,   542,   543,   544,   545,     0,   546,     0,   547,   548,
       0,   549,   550,   551,   552,     0,  1491,  1492,     0,   554,
       0,   555,     0,   556,     0,     0,   557,   558,   559,   560,
     561,     0,     0,   562,   563,   564,   565,     0,     0,   566,
     567,     0,   568,  1493,   569,     0,   570,     0,     0,     0,
     571,   572,   573,   574,   575,   576,     0,   226,     0,     0,
     227,   611,    79,    80,    81,   366,    83,    84,     0,    85,
      86,    87,   367,     0,   368,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   612,    99,   100,   101,   369,   613,
       0,   103,   104,   105,   106,   614,   615,   108,   109,   110,
     111,     0,   112,   616,   617,   115,   370,   371,     0,     0,
       0,   372,   373,     0,     0,     0,     0,   374,     0,     0,
       0,     0,     0,     0,     0,     0,   375,     0,   376,     0,
     377,   378,     0,   379,   380,   381,   382,   383,   384,   385,
     386,     0,   387,   388,     0,     0,     0,     0,     0,     0,
       0,   389,   390,     0,   391,     0,   392,   393,   394,     0,
    1476,     0,  1477,  1171,     0,   395,   396,     0,   397,     0,
       0,   398,  1478,  1479,   400,     0,   401,   402,   403,   404,
       0,     0,     0,   405,   406,   407,   408,     0,   409,   410,
       0,   411,     0,   412,   413,   414,     0,   415,     0,     0,
       0,     0,     0,   416,   417,   418,   419,   420,  1480,  1481,
     421,     0,   422,     0,   423,     0,   424,   425,   426,     0,
     427,     0,     0,   428,  1185,   430,   431,     0,   432,   433,
     434,     0,   435,     0,   436,   437,   438,     0,   439,     0,
       0,     0,   440,   441,  1482,     0,   442,     0,   443,     0,
       0,     0,   444,     0,   445,     0,   446,     0,     0,   447,
       0,   448,   449,   450,     0,   451,   452,   453,     0,   454,
     455,   456,   457,   458,     0,     0,     0,     0,   459,   460,
     461,  1191,  1483,     0,  1484,     0,     0,     0,     0,   462,
       0,   463,   464,   465,   466,   467,     0,     0,     0,   468,
       0,     0,   469,   470,   471,     0,     0,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,  1485,     0,
    1486,     0,   483,   484,   485,   486,   487,   488,   489,  1879,
     490,     0,   491,   492,     0,   493,     0,     0,  1487,   494,
     495,     0,     0,   496,     0,     0,     0,   497,   498,     0,
       0,     0,     0,     0,     0,   499,   500,   501,     0,     0,
       0,   502,   503,   504,     0,   505,   506,   507,   508,   509,
     510,  1488,   511,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   524,     0,   525,
     526,   527,   528,   529,   530,     0,     0,   531,   532,   533,
       0,   534,  1489,   535,   536,     0,   537,  1490,     0,   538,
     539,   540,   541,   542,   543,   544,   545,     0,   546,     0,
     547,   548,     0,   549,   550,   551,   552,     0,  1491,  1492,
       0,   554,     0,   555,     0,   556,     0,     0,   557,   558,
     559,   560,   561,     0,     0,   562,   563,   564,   565,     0,
       0,   566,   567,     0,   568,  1493,   569,     0,   570,     0,
       0,     0,   571,   572,   573,   574,   575,   576,     0,   226,
       0,     0,   227,   611,    79,    80,    81,   366,    83,    84,
       0,    85,    86,    87,   367,     0,   368,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   612,    99,   100,   101,
     369,   613,     0,   103,   104,   105,   106,   614,   615,   108,
     109,   110,   111,     0,   112,   616,   617,   115,   370,   371,
       0,     0,     0,   372,   373,     0,     0,     0,     0,   374,
       0,     0,     0,     0,     0,     0,     0,     0,   375,     0,
     376,     0,   377,   378,     0,   379,   380,   381,   382,   383,
     384,   385,   386,     0,   387,   388,     0,     0,     0,     0,
       0,     0,     0,   389,   390,     0,   391,     0,   392,   393,
     394,     0,  1476,     0,  1477,  1171,     0,   395,   396,     0,
     397,     0,     0,   398,  1478,  1479,   400,     0,   401,   402,
     403,   404,     0,     0,     0,   405,   406,   407,   408,     0,
     409,   410,     0,   411,     0,   412,   413,   414,     0,   415,
       0,     0,     0,     0,     0,   416,   417,   418,   419,   420,
    1480,  1481,   421,     0,   422,     0,   423,     0,   424,   425,
     426,     0,   427,     0,     0,   428,  1185,   430,   431,     0,
     432,   433,   434,     0,   435,     0,   436,   437,   438,     0,
     439,     0,     0,     0,   440,   441,  1482,     0,   442,     0,
     443,     0,     0,     0,   444,     0,   445,     0,   446,     0,
       0,   447,     0,   448,   449,   450,     0,   451,   452,   453,
       0,   454,   455,   456,   457,   458,     0,     0,     0,     0,
     459,   460,   461,  1191,  1483,     0,  1484,     0,     0,     0,
       0,   462,     0,   463,   464,   465,   466,   467,     0,     0,
       0,   468,     0,     0,   469,   470,   471,     0,     0,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
    1485,     0,  1486,     0,   483,   484,   485,   486,   487,   488,
     489,  2693,   490,     0,   491,   492,     0,   493,     0,     0,
    1487,   494,   495,     0,     0,   496,     0,     0,     0,   497,
     498,     0,     0,     0,     0,     0,     0,   499,   500,   501,
       0,     0,     0,   502,   503,   504,     0,   505,   506,   507,
     508,   509,   510,  1488,   511,     0,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   524,
       0,   525,   526,   527,   528,   529,   530,     0,     0,   531,
     532,   533,     0,   534,  1489,   535,   536,     0,   537,  1490,
       0,   538,   539,   540,   541,   542,   543,   544,   545,     0,
     546,     0,   547,   548,     0,   549,   550,   551,   552,     0,
    1491,  1492,     0,   554,     0,   555,     0,   556,     0,     0,
     557,   558,   559,   560,   561,     0,     0,   562,   563,   564,
     565,     0,     0,   566,   567,     0,   568,  1493,   569,     0,
     570,     0,     0,     0,   571,   572,   573,   574,   575,   576,
       0,   226,     0,     0,   227,   611,    79,    80,    81,   366,
      83,    84,     0,    85,    86,    87,   367,     0,   368,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   612,    99,
     100,   101,   369,   613,     0,   103,   104,   105,   106,   614,
     615,   108,   109,   110,   111,     0,   112,   616,   617,   115,
     370,   371,     0,     0,     0,   372,   373,     0,     0,     0,
       0,   374,     0,     0,     0,     0,     0,     0,     0,     0,
     375,     0,   376,     0,   377,   378,     0,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,     0,     0,     0,     0,   389,   390,     0,   391,     0,
     392,   393,   394,     0,  1476,     0,  1477,  1171,     0,   395,
     396,     0,   397,     0,     0,   398,  1478,  1479,   400,     0,
     401,   402,   403,   404,     0,     0,     0,   405,   406,   407,
     408,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   415,     0,     0,     0,     0,     0,   416,   417,   418,
     419,   420,  1480,  1481,   421,     0,   422,     0,   423,     0,
     424,   425,   426,     0,   427,     0,     0,   428,  1185,   430,
     431,     0,   432,   433,   434,     0,   435,     0,   436,   437,
     438,     0,   439,     0,     0,     0,   440,   441,  1482,     0,
     442,     0,   443,     0,     0,     0,   444,     0,   445,     0,
     446,     0,     0,   447,     0,   448,   449,   450,     0,   451,
     452,   453,     0,   454,   455,   456,   457,   458,     0,     0,
       0,     0,   459,   460,   461,  1191,  1483,     0,  1484,     0,
       0,     0,     0,   462,     0,   463,   464,   465,   466,   467,
       0,     0,     0,   468,     0,     0,   469,   470,   471,     0,
       0,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,  1485,     0,  1486,     0,   483,   484,   485,   486,
     487,   488,   489,     0,   490,     0,   491,   492,     0,   493,
    1846,     0,  1487,   494,   495,     0,     0,   496,     0,     0,
       0,   497,   498,     0,     0,     0,     0,     0,     0,   499,
     500,   501,     0,     0,     0,   502,   503,   504,     0,   505,
     506,   507,   508,   509,   510,  1488,   511,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   524,     0,   525,   526,   527,   528,   529,   530,     0,
       0,   531,   532,   533,     0,   534,  1489,   535,   536,     0,
     537,  1490,     0,   538,   539,   540,   541,   542,   543,   544,
     545,     0,   546,     0,   547,   548,     0,   549,   550,   551,
     552,     0,  1491,  1492,     0,   554,     0,   555,     0,   556,
       0,     0,   557,   558,   559,   560,   561,     0,     0,   562,
     563,   564,   565,     0,     0,   566,   567,     0,   568,  1493,
     569,     0,   570,     0,     0,     0,   571,   572,   573,   574,
     575,   576,     0,   226,     0,     0,   227,   611,    79,    80,
      81,   366,    83,    84,     0,    85,    86,    87,   367,     0,
     368,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     612,    99,   100,   101,   369,   613,     0,   103,   104,   105,
     106,   614,   615,   108,   109,   110,   111,     0,   112,   616,
     617,   115,   370,   371,     0,     0,     0,   372,   373,     0,
       0,     0,     0,   374,     0,     0,     0,     0,     0,     0,
       0,     0,   375,     0,   376,     0,   377,   378,     0,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,     0,     0,     0,     0,   389,   390,     0,
     391,     0,   392,   393,   394,     0,  1476,     0,  1477,  1171,
       0,   395,   396,     0,   397,     0,     0,   398,  1478,  1479,
     400,     0,   401,   402,   403,   404,     0,     0,     0,   405,
     406,   407,   408,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   415,     0,     0,     0,     0,     0,   416,
     417,   418,   419,   420,  1480,  1481,   421,     0,   422,     0,
     423,     0,   424,   425,   426,     0,   427,     0,     0,   428,
    1185,   430,   431,     0,   432,   433,   434,     0,   435,     0,
     436,   437,   438,     0,   439,     0,     0,     0,   440,   441,
    1482,     0,   442,     0,   443,     0,     0,     0,   444,     0,
     445,     0,   446,     0,     0,   447,     0,   448,   449,   450,
       0,   451,   452,   453,     0,   454,   455,   456,   457,   458,
       0,     0,     0,     0,   459,   460,   461,  1191,  1483,     0,
    1484,     0,     0,     0,     0,   462,     0,   463,   464,   465,
     466,   467,     0,     0,     0,   468,     0,     0,   469,   470,
     471,     0,     0,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,  1485,     0,  1486,     0,   483,   484,
     485,   486,   487,   488,   489,     0,   490,     0,   491,   492,
       0,   493,     0,     0,  1487,   494,   495,     0,     0,   496,
       0,     0,     0,   497,   498,     0,     0,     0,     0,     0,
       0,   499,   500,   501,     0,     0,     0,   502,   503,   504,
       0,   505,   506,   507,   508,   509,   510,  1488,   511,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   524,     0,   525,   526,   527,   528,   529,
     530,     0,     0,   531,   532,   533,     0,   534,  1489,   535,
     536,     0,   537,  1490,     0,   538,   539,   540,   541,   542,
     543,   544,   545,     0,   546,     0,   547,   548,     0,   549,
     550,   551,   552,     0,  1491,  1492,     0,   554,     0,   555,
       0,   556,     0,     0,   557,   558,   559,   560,   561,     0,
       0,   562,   563,   564,   565,     0,     0,   566,   567,     0,
     568,  1493,   569,     0,   570,     0,     0,     0,   571,   572,
     573,   574,   575,   576,     0,   226,     0,     0,   227,   611,
      79,    80,    81,   366,    83,    84,     0,    85,    86,    87,
     367,     0,   368,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   612,    99,   100,   101,   369,   613,     0,   103,
     104,   105,   106,   614,   615,   108,   109,   110,   111,     0,
     112,   616,   617,   115,   370,   371,     0,     0,     0,   372,
     373,     0,     0,     0,     0,   374,     0,     0,     0,     0,
       0,     0,     0,     0,   375,     0,   376,     0,   377,   378,
       0,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,     0,     0,     0,     0,   389,
     390,     0,   391,     0,   392,   393,   394,     0,  1476,     0,
    1477,  1171,     0,   395,   396,     0,   397,     0,     0,   398,
    1478,  1479,   400,     0,   401,   402,   403,   404,     0,     0,
       0,   405,   406,   407,   408,     0,   409,   410,     0,   411,
       0,   412,   413,   414,     0,   415,     0,     0,     0,     0,
       0,   416,   417,   418,   419,   420,  1480,  1481,   421,     0,
     422,     0,   423,     0,   424,   425,   426,     0,   427,     0,
       0,   428,  1185,   430,   431,     0,   432,   433,   434,     0,
     435,     0,   436,   437,   438,     0,   439,     0,     0,     0,
     440,   441,  1482,     0,   442,     0,   443,     0,     0,     0,
     444,     0,   445,     0,   446,     0,     0,   447,     0,   448,
     449,   450,     0,   451,   452,   453,     0,   454,   455,   456,
     457,   458,     0,     0,     0,     0,   459,   460,   461,  1191,
    1483,     0,  1484,     0,     0,     0,     0,   462,     0,   463,
     464,   465,   466,   467,     0,     0,     0,   468,     0,     0,
     469,   470,   471,     0,     0,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,  1485,     0,  1486,     0,
     483,   484,   485,   486,   487,   488,   489,     0,   490,     0,
     491,   492,     0,   493,     0,     0,  1487,   494,   495,     0,
       0,   496,     0,     0,     0,   497,   498,     0,     0,     0,
       0,     0,     0,   499,   500,   501,     0,     0,     0,   502,
     503,   504,     0,   505,   506,   507,   508,   509,   510,  1488,
     511,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   524,     0,   525,   526,   527,
     528,   529,   530,     0,     0,   531,   532,   533,     0,   534,
       0,   535,   536,     0,   537,  1490,     0,   538,   539,   540,
     541,   542,   543,   544,   545,     0,   546,     0,   547,   548,
       0,   549,   550,   551,   552,     0,  1491,  1492,     0,   554,
       0,   555,     0,   556,     0,     0,   557,   558,   559,   560,
     561,     0,     0,   562,   563,   564,   565,     0,     0,   566,
     567,     0,   568,  1493,   569,     0,   570,     0,     0,     0,
     571,   572,   573,   574,   575,   576,     0,   226,     0,     0,
     227,    79,    80,    81,   366,    83,    84,     0,    85,    86,
      87,   367,     0,   368,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   369,     0,     0,
     103,   104,   105,   106,     0,     0,   108,   109,   110,   111,
       0,   112,     0,     0,   115,   370,   371,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   379,   380,   381,   382,   383,   384,   385,   386,
     618,   387,   388,   619,   620,   621,   622,   623,   624,   625,
     389,   390,   626,   391,   130,   392,   393,   394,   132,   133,
     134,   135,     0,   627,   395,   396,     0,   397,   628,   629,
     398,     0,   136,   400,   631,   401,   402,   403,   404,   140,
     632,   633,   405,   406,   407,   408,   634,   409,   410,   143,
     411,   635,   412,   413,   414,   146,   415,   636,   637,   638,
     639,   640,   416,   417,   418,     0,   420,   149,   150,   421,
     641,   422,   642,   423,     0,   424,   425,   426,   643,   427,
     644,   645,   428,   429,   430,   431,   646,   432,   433,   434,
     647,   435,   648,   436,   437,   438,   156,   439,     0,   158,
     649,   440,   441,   160,   650,   442,   651,   443,   161,   652,
     162,   444,     0,   445,   653,   446,   165,   654,   447,   655,
     448,   449,     0,   166,   451,   452,   453,   656,   454,   455,
     456,   457,   458,   657,   167,   168,     0,   459,   460,   461,
       0,   170,   660,   171,   661,     0,   172,   173,   462,   174,
     463,   464,   465,   466,   467,   662,   175,   176,   468,   177,
     663,   469,   470,   471,     0,     0,   472,   473,   474,   475,
     476,     0,   478,   479,     0,   481,   482,   182,   183,   184,
     664,   483,   484,   485,   486,   487,   488,   489,   185,   490,
     665,   491,   492,   187,   493,   666,   188,   189,   494,   495,
     667,   668,   496,   669,   670,   671,   497,   498,   672,   673,
     190,   191,   192,   193,   499,   500,   501,     0,   194,   195,
     502,   503,   504,   674,   505,   506,   507,   508,   509,   510,
     197,   511,   675,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   522,   202,   523,   524,   204,   525,   526,
     527,   528,   529,     0,     0,   676,   531,   532,   533,   677,
     534,   208,   535,   536,   210,   537,   211,   678,   538,   539,
     540,   541,   542,   543,   544,   545,   213,   546,   679,   547,
     548,   680,   549,   550,   551,   552,   681,   214,   215,     0,
     554,   683,   555,   216,   556,   217,   684,   557,   558,   559,
     560,   561,     0,   686,   562,   563,   564,   565,   687,   688,
     566,   567,     0,   568,   224,   569,   225,   570,     0,   689,
     690,   571,   572,   573,   574,     0,   576,     0,   226,     0,
       0,   227,    79,    80,    81,   366,    83,    84,     0,    85,
      86,    87,   367,     0,   368,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   369,     0,
       0,   103,   104,   105,   106,     0,     0,   108,   109,   110,
     111,     0,   112,     0,     0,   115,   370,   371,     0,     0,
       0,   372,   373,     0,     0,     0,     0,   374,     0,     0,
       0,     0,     0,     0,     0,     0,   375,     0,   376,     0,
     377,   378,     0,   379,   380,   381,   382,   383,   384,   385,
     386,     0,   387,   388,     0,     0,     0,     0,     0,     0,
       0,   389,   390,     0,   391,   130,   392,   393,   394,   132,
     133,   134,   135,     0,     0,   395,   396,     0,   397,     0,
       0,   398,   399,   136,   400,     0,   401,   402,   403,   404,
     140,     0,     0,   405,   406,   407,   408,     0,   409,   410,
     143,   411,     0,   412,   413,   414,   146,   415,     0,     0,
       0,     0,     0,   416,   417,   418,   419,   420,   149,   150,
     421,     0,   422,     0,   423,     0,   424,   425,   426,     0,
     427,     0,     0,   428,   429,   430,   431,     0,   432,   433,
     434,     0,   435,     0,   436,   437,   438,   156,   439,     0,
     158,     0,   440,   441,   160,     0,   442,     0,   443,   161,
       0,   162,   444,     0,   445,     0,   446,   165,     0,   447,
       0,   448,   449,   450,   166,   451,   452,   453,     0,   454,
     455,   456,   457,   458,     0,   167,   168,     0,   459,   460,
     461,     0,   170,     0,   171,     0,     0,   172,   173,   462,
     174,   463,   464,   465,   466,   467,     0,   175,   176,   468,
     177,     0,   469,   470,   471,     0,     0,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   182,   183,
     184,   740,   483,   484,   485,   486,   487,   488,   489,   185,
     490,     0,   491,   492,   187,   493,     0,   188,   189,   494,
     495,     0,     0,   496,   741,     0,     0,   497,   498,     0,
       0,   190,   191,   192,   193,   499,   500,   501,     0,   194,
     195,   502,   503,   504,     0,   505,   506,   507,   508,   509,
     510,   197,   511,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   522,   202,   523,   524,   204,   525,
     526,   527,   528,   529,   530,     0,     0,   531,   532,   533,
       0,   534,   208,   535,   536,   210,   537,   211,     0,   538,
     539,   540,   541,   542,   543,   544,   545,   213,   546,     0,
     547,   548,     0,   549,   550,   551,   552,     0,   214,   215,
       0,   554,     0,   555,   216,   556,   217,     0,   557,   558,
     559,   560,   561,     0,     0,   562,   563,   564,   565,     0,
       0,   566,   567,     0,   568,   224,   569,   225,   570,     0,
       0,     0,   571,   572,   573,   574,   575,   576,     0,   226,
       0,     0,   227,    79,    80,    81,   366,    83,    84,     0,
      85,    86,    87,   367,     0,   368,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   369,
       0,     0,   103,   104,   105,   106,     0,     0,   108,   109,
     110,   111,     0,   112,     0,     0,   115,   370,   371,     0,
       0,     0,   372,   373,     0,     0,     0,     0,   374,     0,
       0,     0,     0,     0,     0,     0,     0,   375,     0,   376,
       0,   377,   378,     0,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,     0,     0,
       0,     0,   389,   390,     0,   391,     0,   392,   393,   394,
       0,   133,     0,   135,     0,     0,   395,   396,     0,   397,
       0,     0,   398,   399,   136,   400,  1830,   401,   402,   403,
     404,   140,     0,     0,   405,   406,   407,   408,  1831,   409,
     410,   143,   411,     0,   412,   413,   414,     0,   415,     0,
       0,     0,     0,     0,   416,   417,   418,   419,   420,   149,
     150,   421,     0,   422,     0,   423,     0,   424,   425,   426,
       0,   427,     0,     0,   428,   429,   430,   431,     0,   432,
     433,   434,     0,   435,     0,   436,   437,   438,   156,   439,
       0,   158,     0,   440,   441,   160,     0,   442,  1832,   443,
       0,     0,     0,   444,     0,   445,     0,   446,   165,     0,
     447,     0,   448,   449,   450,     0,   451,   452,   453,     0,
     454,   455,   456,   457,   458,     0,     0,   168,     0,   459,
     460,   461,     0,   170,     0,   171,     0,     0,     0,     0,
     462,     0,   463,   464,   465,   466,   467,     0,   175,     0,
     468,  2419,     0,   469,   470,   471,     0,     0,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   182,
       0,   184,     0,   483,   484,   485,   486,   487,   488,   489,
     185,   490,     0,   491,   492,     0,   493,     0,   188,   189,
     494,   495,     0,     0,   496,     0,     0,     0,   497,   498,
       0,     0,   190,     0,     0,   193,   499,   500,   501,     0,
     194,   195,   502,   503,   504,  1833,   505,   506,   507,   508,
     509,   510,   197,   511,     0,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   524,   204,
     525,   526,   527,   528,   529,   530,     0,     0,   531,   532,
     533,     0,   534,   208,   535,   536,     0,   537,   211,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   213,   546,
       0,   547,   548,     0,   549,   550,   551,   552,     0,   214,
     215,     0,   554,     0,   555,   216,   556,   217,     0,   557,
     558,   559,   560,   561,     0,  1834,   562,   563,   564,   565,
       0,     0,   566,   567,     0,   568,   224,   569,     0,   570,
       0,     0,     0,   571,   572,   573,   574,   575,   576,     0,
     226,     0,     0,   227,    79,    80,    81,   366,    83,    84,
       0,    85,    86,    87,   367,     0,   368,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     369,     0,     0,   103,   104,   105,   106,     0,     0,   108,
     109,   110,   111,     0,   112,     0,     0,   115,   370,   371,
       0,     0,     0,   372,   373,     0,     0,     0,     0,   374,
       0,     0,     0,     0,     0,     0,     0,     0,   375,     0,
     376,     0,   377,   378,     0,   379,   380,   381,   382,   383,
     384,   385,   386,   836,   387,   388,     0,     0,     0,     0,
       0,     0,     0,   389,   390,     0,   391,     0,   392,   393,
     394,     0,   133,     0,   135,     0,     0,   395,   396,     0,
     397,     0,     0,   398,   399,   136,   400,     0,   401,   402,
     403,   404,   140,     0,     0,   405,   406,   407,   408,     0,
     409,   410,   143,   411,   837,   412,   413,   414,     0,   415,
       0,     0,     0,     0,     0,   416,   417,   418,   419,   420,
     149,   150,   421,     0,   422,     0,   423,     0,   424,   425,
     426,     0,   427,     0,     0,   428,   429,   430,   431,     0,
     432,   433,   434,     0,   435,     0,   436,   437,   438,   156,
     439,     0,   158,     0,   440,   441,   160,     0,   442,     0,
     443,     0,     0,     0,   444,     0,   445,   876,   446,   165,
       0,   447,     0,   448,   449,   450,     0,   451,   452,   453,
       0,   454,   455,   456,   457,   458,     0,     0,   168,     0,
     459,   460,   461,     0,   170,     0,   171,     0,     0,     0,
       0,   462,     0,   463,   464,   465,   466,   467,     0,   175,
       0,   468,     0,     0,   469,   470,   471,     0,     0,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
     182,     0,   184,     0,   483,   484,   485,   486,   487,   488,
     489,   185,   490,     0,   491,   492,     0,   493,     0,   188,
     189,   494,   495,     0,     0,   496,     0,     0,     0,   497,
     498,     0,     0,   190,     0,     0,   193,   499,   500,   501,
       0,   194,   195,   502,   503,   504,     0,   505,   506,   507,
     508,   509,   510,   197,   511,   838,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   524,
     204,   525,   526,   527,   528,   529,   530,     0,   839,   531,
     532,   533,     0,   534,   208,   535,   536,     0,   537,   211,
       0,   538,   539,   540,   541,   542,   543,   544,   545,   213,
     546,     0,   547,   548,     0,   549,   550,   551,   552,     0,
     214,   215,     0,   554,     0,   555,   216,   556,   217,     0,
     557,   558,   559,   560,   561,     0,     0,   562,   563,   564,
     565,     0,     0,   566,   567,     0,   568,   224,   569,     0,
     570,     0,     0,     0,   571,   572,   573,   574,   575,   576,
       0,   226,     0,     0,   227,    79,    80,    81,   366,    83,
      84,     0,    85,    86,    87,   367,     0,   368,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   369,     0,     0,   103,   104,   105,   106,     0,     0,
     108,   109,   110,   111,     0,   112,     0,     0,   115,   370,
     371,     0,     0,     0,   372,   373,     0,     0,     0,     0,
     374,     0,     0,     0,     0,     0,     0,     0,     0,   375,
       0,   376,     0,   377,   378,     0,   379,   380,   381,   382,
     383,   384,   385,   386,   836,   387,   388,     0,     0,     0,
       0,     0,     0,     0,   389,   390,     0,   391,     0,   392,
     393,   394,     0,   133,     0,   135,     0,     0,   395,   396,
       0,   397,     0,     0,   398,   399,   136,   400,     0,   401,
     402,   403,   404,   140,     0,     0,   405,   406,   407,   408,
       0,   409,   410,   143,   411,   837,   412,   413,   414,     0,
     415,     0,     0,     0,     0,     0,   416,   417,   418,   419,
     420,   149,   150,   421,     0,   422,     0,   423,     0,   424,
     425,   426,     0,   427,     0,     0,   428,   429,   430,   431,
       0,   432,   433,   434,     0,   435,     0,   436,   437,   438,
     156,   439,     0,   158,     0,   440,   441,   160,     0,   442,
       0,   443,     0,     0,     0,   444,     0,   445,     0,   446,
     165,     0,   447,     0,   448,   449,   450,     0,   451,   452,
     453,     0,   454,   455,   456,   457,   458,     0,     0,   168,
       0,   459,   460,   461,     0,   170,     0,   171,     0,     0,
       0,     0,   462,     0,   463,   464,   465,   466,   467,     0,
     175,     0,   468,     0,     0,   469,   470,   471,     0,     0,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   182,     0,   184,     0,   483,   484,   485,   486,   487,
     488,   489,   185,   490,     0,   491,   492,     0,   493,     0,
     188,   189,   494,   495,     0,     0,   496,     0,     0,     0,
     497,   498,     0,     0,   190,     0,     0,   193,   499,   500,
     501,     0,   194,   195,   502,   503,   504,     0,   505,   506,
     507,   508,   509,   510,   197,   511,   838,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     524,   204,   525,   526,   527,   528,   529,   530,     0,   839,
     531,   532,   533,     0,   534,   208,   535,   536,     0,   537,
     211,     0,   538,   539,   540,   541,   542,   543,   544,   545,
     213,   546,     0,   547,   548,     0,   549,   550,   551,   552,
       0,   214,   215,     0,   554,     0,   555,   216,   556,   217,
       0,   557,   558,   559,   560,   561,     0,     0,   562,   563,
     564,   565,     0,     0,   566,   567,     0,   568,   224,   569,
       0,   570,     0,     0,     0,   571,   572,   573,   574,   575,
     576,     0,   226,     0,     0,   227,    79,    80,    81,   366,
      83,    84,     0,    85,    86,    87,   367,     0,   368,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   369,     0,     0,   103,   104,   105,   106,     0,
       0,   108,   109,   110,   111,     0,   112,     0,     0,   115,
     370,   371,     0,     0,     0,   372,   373,     0,     0,     0,
       0,   374,     0,     0,     0,     0,     0,     0,     0,     0,
     375,     0,   376,     0,   377,   378,     0,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,   127,   128,
       0,     0,     0,     0,     0,   389,   390,     0,   391,     0,
     392,   393,   394,     0,   133,     0,   135,     0,     0,   395,
     396,     0,   397,     0,     0,   398,   399,   136,   400,     0,
     401,   402,   403,   404,   140,     0,     0,   405,   406,   407,
     408,     0,   409,   410,   143,   411,     0,   412,   413,   414,
       0,   415,     0,     0,     0,     0,     0,   416,   417,   418,
     419,   420,   149,   150,   421,     0,   422,     0,   423,     0,
     424,   425,   426,     0,   427,     0,     0,   428,   429,   430,
     431,     0,   432,   433,   434,     0,   435,     0,   436,   437,
     438,   156,   439,     0,   158,     0,   440,   441,   160,     0,
     442,     0,   443,     0,     0,     0,   444,     0,   445,     0,
     446,   165,     0,   447,     0,   448,   449,   450,     0,   451,
     452,   453,     0,   454,   455,   456,   457,   458,     0,     0,
     168,     0,   459,   460,   461,     0,   170,     0,   171,     0,
       0,     0,     0,   462,     0,   463,   464,   465,   466,   467,
       0,   175,     0,   468,     0,     0,   469,   470,   471,     0,
       0,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,   182,     0,   184,   740,   483,   484,   485,   486,
     487,   488,   489,   185,   490,     0,   491,   492,     0,   493,
       0,   188,   189,   494,   495,     0,     0,   496,   741,     0,
       0,   497,   498,     0,     0,   190,     0,     0,   193,   499,
     500,   501,     0,   194,   195,   502,   503,   504,     0,   505,
     506,   507,   508,   509,   510,   197,   511,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   524,   204,   525,   526,   527,   528,   529,   530,     0,
       0,   531,   532,   533,     0,   534,   208,   535,   536,     0,
     537,   211,     0,   538,   539,   540,   541,   542,   543,   544,
     545,   213,   546,     0,   547,   548,     0,   549,   550,   551,
     552,     0,   214,   215,     0,   554,     0,   555,   216,   556,
     217,     0,   557,   558,   559,   560,   561,     0,     0,   562,
     563,   564,   565,     0,     0,   566,   567,     0,   568,   224,
     569,     0,   570,     0,     0,     0,   571,   572,   573,   574,
     575,   576,     0,   226,     0,     0,   227,    79,    80,    81,
     366,    83,    84,     0,    85,    86,    87,   367,     0,   368,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   369,     0,     0,   103,   104,   105,   106,
       0,     0,   108,   109,   110,   111,     0,   112,     0,     0,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,     0,     0,     0,     0,   389,   390,     0,   391,
       0,   392,   393,   394,     0,   133,     0,   135,     0,     0,
     395,   396,     0,   397,     0,     0,   398,   399,   136,   400,
       0,   401,   402,   403,   404,   140,     0,     0,   405,   406,
     407,   408,     0,   409,   410,   143,   411,     0,   412,   413,
     414,     0,   415,     0,     0,     0,     0,     0,   416,   417,
     418,   419,   420,   149,   150,   421,     0,   422,     0,   423,
       0,   424,   425,   426,     0,   427,     0,     0,   428,   429,
     430,   431,     0,   432,   433,   434,     0,   435,     0,   436,
     437,   438,   156,   439,     0,   158,     0,   440,   441,   160,
       0,   442,     0,   443,     0,     0,     0,   444,     0,   445,
       0,   446,   165,     0,   447,     0,   448,   449,   450,     0,
     451,   452,   453,     0,   454,   455,   456,   457,   458,     0,
       0,   168,     0,   459,   460,   461,     0,   170,     0,   171,
       0,     0,     0,     0,   462,     0,   463,   464,   465,   466,
     467,     0,   175,     0,   468,     0,     0,   469,   470,   471,
       0,     0,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   182,     0,   184,   740,   483,   484,   485,
     486,   487,   488,   489,   185,   490,     0,   491,   492,     0,
     493,     0,   188,   189,   494,   495,     0,     0,   496,   741,
       0,   908,   497,   498,     0,     0,   190,     0,     0,   193,
     499,   500,   501,     0,   194,   195,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,   197,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   524,   204,   525,   526,   527,   528,   529,   530,
       0,     0,   531,   532,   533,     0,   534,   208,   535,   536,
       0,   537,   211,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   213,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,   214,   215,     0,   554,     0,   555,   216,
     556,   217,     0,   557,   558,   559,   560,   561,     0,     0,
     562,   563,   564,   565,     0,     0,   566,   567,     0,   568,
     224,   569,     0,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,     0,     0,   227,    79,    80,
      81,   366,    83,    84,     0,    85,    86,    87,   367,     0,
     368,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   369,     0,     0,   103,   104,   105,
     106,     0,     0,   108,   109,   110,   111,     0,   112,     0,
       0,   115,   370,   371,     0,     0,     0,   372,   373,     0,
       0,     0,     0,   374,     0,     0,     0,     0,     0,     0,
       0,     0,   375,     0,   376,     0,   377,   378,     0,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,     0,     0,     0,     0,   389,   390,     0,
     391,     0,   392,   393,   394,     0,   133,     0,   135,     0,
       0,   395,   396,     0,   397,     0,     0,   398,   399,   136,
     400,     0,   401,   402,   403,   404,   140,     0,     0,   405,
     406,   407,   408,     0,   409,   410,   143,   411,     0,   412,
     413,   414,     0,   415,     0,     0,     0,     0,     0,   416,
     417,  1580,   419,   420,   149,   150,   421,     0,   422,     0,
     423,     0,   424,   425,   426,     0,   427,     0,     0,   428,
     429,   430,   431,     0,   432,   433,   434,     0,   435,     0,
     436,   437,   438,   156,   439,     0,   158,     0,   440,   441,
     160,     0,   442,     0,   443,     0,     0,     0,  1581,     0,
     445,     0,   446,   165,     0,   447,     0,   448,   449,   450,
       0,   451,   452,   453,     0,   454,   455,   456,   457,   458,
       0,     0,   168,     0,   459,   460,   461,     0,   170,     0,
     171,     0,     0,     0,     0,   462,     0,   463,   464,  1582,
     466,   467,     0,   175,     0,   468,     0,     0,   469,   470,
     471,     0,     0,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,   182,     0,   184,   740,   483,   484,
     485,   486,   487,   488,   489,   185,   490,     0,   491,   492,
       0,   493,     0,   188,   189,   494,   495,     0,     0,   496,
     741,     0,     0,   497,   498,     0,     0,   190,     0,     0,
     193,   499,   500,   501,     0,   194,   195,   502,   503,   504,
       0,   505,   506,   507,   508,   509,   510,   197,   511,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   524,   204,   525,   526,   527,  1583,   529,
     530,     0,     0,   531,   532,   533,     0,   534,   208,   535,
     536,     0,   537,   211,     0,   538,   539,   540,   541,   542,
     543,   544,   545,   213,   546,     0,   547,   548,  1584,  1585,
     550,   551,   552,     0,   214,   215,     0,   554,     0,   555,
     216,   556,   217,     0,   557,   558,   559,   560,   561,     0,
       0,   562,   563,   564,   565,     0,     0,   566,   567,     0,
     568,   224,   569,     0,   570,     0,     0,     0,   571,   572,
     573,   574,   575,   576,     0,   226,     0,     0,   227,    79,
      80,    81,   366,    83,    84,     0,    85,    86,    87,   367,
       0,   368,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   369,     0,     0,   103,   104,
     105,   106,     0,     0,   108,   109,   110,   111,     0,   112,
       0,     0,   115,   370,   371,     0,     0,     0,   372,   373,
       0,     0,     0,     0,   374,     0,     0,     0,     0,     0,
       0,     0,     0,   375,     0,   376,     0,   377,   378,     0,
     379,   380,   381,   382,   383,   384,   385,   386,     0,   387,
     388,     0,     0,     0,     0,     0,     0,     0,   389,   390,
       0,   391,     0,   392,   393,   394,     0,   133,     0,   135,
       0,     0,   395,   396,     0,   397,     0,     0,   398,   399,
     136,   400,     0,   401,   402,   403,   404,   140,     0,     0,
     405,   406,   407,   408,     0,   409,   410,   143,   411,   837,
     412,   413,   414,     0,   415,     0,     0,     0,     0,     0,
     416,   417,   418,   419,   420,   149,   150,   421,     0,   422,
       0,   423,     0,   424,   425,   426,     0,   427,     0,     0,
     428,   429,   430,   431,     0,   432,   433,   434,     0,   435,
       0,   436,   437,   438,   156,   439,     0,   158,     0,   440,
     441,   160,     0,   442,     0,   443,     0,     0,     0,   444,
       0,   445,     0,   446,   165,     0,   447,     0,   448,   449,
     450,     0,   451,   452,   453,     0,   454,   455,   456,   457,
     458,     0,     0,   168,     0,   459,   460,   461,     0,   170,
       0,   171,     0,     0,     0,     0,   462,     0,   463,   464,
     465,   466,   467,     0,   175,     0,   468,     0,     0,   469,
     470,   471,     0,     0,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   182,     0,   184,     0,   483,
     484,   485,   486,   487,   488,   489,   185,   490,     0,   491,
     492,     0,   493,     0,   188,   189,   494,   495,     0,     0,
     496,     0,     0,     0,   497,   498,     0,     0,   190,     0,
       0,   193,   499,   500,   501,     0,   194,   195,   502,   503,
     504,     0,   505,   506,   507,   508,   509,   510,   197,   511,
     838,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   524,   204,   525,   526,   527,   528,
     529,   530,     0,   839,   531,   532,   533,     0,   534,   208,
     535,   536,     0,   537,   211,     0,   538,   539,   540,   541,
     542,   543,   544,   545,   213,   546,     0,   547,   548,     0,
     549,   550,   551,   552,     0,   214,   215,     0,   554,     0,
     555,   216,   556,   217,     0,   557,   558,   559,   560,   561,
       0,     0,   562,   563,   564,   565,     0,     0,   566,   567,
       0,   568,   224,   569,     0,   570,     0,     0,     0,   571,
     572,   573,   574,   575,   576,     0,   226,     0,     0,   227,
      79,    80,    81,   366,    83,    84,     0,    85,    86,    87,
     367,     0,   368,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   369,     0,     0,   103,
     104,   105,   106,     0,     0,   108,   109,   110,   111,     0,
     112,     0,     0,   115,   370,   371,     0,     0,     0,   372,
     373,     0,     0,     0,     0,   374,     0,     0,     0,     0,
       0,     0,     0,     0,   375,     0,   376,     0,   377,   378,
       0,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,     0,     0,     0,     0,   389,
     390,     0,   391,     0,   392,   393,   394,     0,   133,     0,
     135,     0,     0,   395,   396,     0,   397,     0,     0,   398,
     399,   136,   400,     0,   401,   402,   403,   404,   140,     0,
       0,   405,   406,   407,   408,     0,   409,   410,   143,   411,
       0,   412,   413,   414,     0,   415,     0,     0,     0,     0,
       0,   416,   417,   418,   419,   420,   149,   150,   421,     0,
     422,     0,   423,     0,   424,   425,   426,     0,   427,     0,
       0,   428,   429,   430,   431,     0,   432,   433,   434,     0,
     435,     0,   436,   437,   438,   156,   439,     0,   158,     0,
     440,   441,   160,     0,   442,     0,   443,     0,     0,     0,
     444,     0,   445,     0,   446,   165,     0,   447,     0,   448,
     449,   450,     0,   451,   452,   453,     0,   454,   455,   456,
     457,   458,     0,     0,   168,     0,   459,   460,   461,     0,
     170,     0,   171,     0,     0,     0,     0,   462,     0,   463,
     464,   465,   466,   467,     0,   175,     0,   468,     0,     0,
     469,   470,   471,     0,     0,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,   182,     0,   184,   740,
     483,   484,   485,   486,   487,   488,   489,   185,   490,     0,
     491,   492,     0,   493,     0,   188,   189,   494,   495,     0,
       0,   496,   741,     0,     0,   497,   498,     0,     0,   190,
       0,     0,   193,   499,   500,   501,     0,   194,   195,   502,
     503,   504,     0,   505,   506,   507,   508,   509,   510,   197,
     511,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   524,   204,   525,   526,   527,
     528,   529,   530,     0,     0,   531,   532,   533,     0,   534,
     208,   535,   536,     0,   537,   211,     0,   538,   539,   540,
     541,   542,   543,   544,   545,   213,   546,     0,   547,   548,
       0,   549,   550,   551,   552,     0,   214,   215,     0,   554,
       0,   555,   216,   556,   217,     0,   557,   558,   559,   560,
     561,     0,     0,   562,   563,   564,   565,     0,     0,   566,
     567,     0,   568,   224,   569,     0,   570,     0,     0,     0,
     571,   572,   573,   574,   575,   576,     0,   226,     0,     0,
     227,    79,    80,    81,   366,    83,    84,     0,    85,    86,
      87,   367,     0,   368,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   369,     0,     0,
     103,   104,   105,   106,     0,     0,   108,   109,   110,   111,
       0,   112,     0,     0,   115,   370,   371,     0,     0,     0,
     372,   373,     0,     0,     0,     0,   374,     0,     0,     0,
       0,     0,     0,     0,     0,   375,     0,   376,     0,   377,
     378,     0,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,     0,     0,     0,     0,
     389,   390,     0,   391,     0,   392,   393,   394,     0,   133,
       0,   135,     0,     0,   395,   396,     0,   397,     0,     0,
     398,   399,   136,   400,     0,   401,   402,   403,   404,   140,
       0,     0,   405,   406,   407,   408,     0,   409,   410,   143,
     411,     0,   412,   413,   414,     0,   415,     0,     0,     0,
       0,     0,   416,   417,   418,   419,   420,   149,   150,   421,
       0,   422,     0,   423,     0,   424,   425,   426,     0,   427,
       0,     0,   428,   429,   430,   431,     0,   432,   433,   434,
       0,   435,     0,   436,   437,   438,   156,   439,     0,   158,
       0,   440,   441,   160,     0,   442,     0,   443,     0,   821,
       0,   444,     0,   445,     0,   446,   165,     0,   447,     0,
     448,   449,   450,     0,   451,   452,   453,   822,   454,   455,
     456,   457,   458,     0,     0,   168,     0,   459,   460,   461,
       0,   170,     0,   171,     0,     0,     0,     0,   462,     0,
     463,   464,   465,   466,   467,     0,   175,     0,   468,     0,
       0,   469,   470,   471,     0,     0,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   182,     0,   184,
       0,   483,   484,   485,   486,   487,   488,   489,   185,   490,
       0,   491,   492,     0,   493,     0,   188,   189,   494,   495,
       0,     0,   496,     0,     0,     0,   497,   498,     0,     0,
     190,     0,     0,   193,   499,   500,   501,     0,   194,   195,
     502,   503,   504,     0,   505,   506,   507,   508,   509,   510,
     197,   511,     0,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   524,   204,   525,   526,
     527,   528,   529,   530,     0,     0,   531,   532,   533,     0,
     534,   208,   535,   536,     0,   537,   211,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   213,   546,     0,   547,
     548,     0,   549,   550,   551,   552,     0,   214,   215,     0,
     554,     0,   555,   216,   556,   217,     0,   557,   558,   559,
     560,   561,     0,     0,   562,   563,   564,   565,     0,     0,
     566,   567,     0,   568,   224,   569,     0,   570,     0,     0,
       0,   571,   572,   573,   574,   575,   576,     0,   226,     0,
       0,   227,    79,    80,    81,   366,    83,    84,     0,    85,
      86,    87,   367,     0,   368,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   369,     0,
       0,   103,   104,   105,   106,     0,     0,   108,   109,   110,
     111,     0,   112,     0,     0,   115,   370,   371,     0,     0,
       0,   372,   373,     0,     0,     0,     0,   374,     0,     0,
       0,     0,     0,     0,     0,     0,   375,     0,   376,     0,
     377,   378,     0,   379,   380,   381,   382,   383,   384,   385,
     386,  2338,   387,   388,     0,     0,     0,     0,     0,     0,
       0,   389,   390,     0,   391,     0,   392,   393,   394,     0,
     133,     0,   135,     0,     0,   395,   396,     0,   397,     0,
       0,   398,   399,   136,   400,     0,   401,   402,   403,   404,
     140,     0,     0,   405,   406,   407,   408,     0,   409,   410,
     143,   411,     0,   412,   413,   414,     0,   415,     0,     0,
       0,     0,     0,   416,   417,   418,   419,   420,   149,   150,
     421,     0,   422,     0,   423,     0,   424,   425,   426,     0,
     427,     0,     0,   428,   429,   430,   431,     0,   432,   433,
     434,     0,   435,     0,   436,   437,   438,   156,   439,     0,
     158,     0,   440,   441,   160,     0,   442,     0,   443,     0,
       0,     0,   444,     0,   445,     0,   446,   165,     0,   447,
       0,   448,   449,   450,     0,   451,   452,   453,     0,   454,
     455,   456,   457,   458,     0,     0,   168,     0,   459,   460,
     461,     0,   170,     0,   171,     0,     0,     0,     0,   462,
       0,   463,   464,   465,   466,   467,     0,   175,     0,   468,
       0,     0,   469,   470,   471,     0,     0,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   182,     0,
     184,     0,   483,   484,   485,   486,   487,   488,   489,   185,
     490,     0,   491,   492,     0,   493,     0,   188,   189,   494,
     495,     0,     0,   496,     0,     0,     0,   497,   498,     0,
       0,   190,     0,     0,   193,   499,   500,   501,     0,   194,
     195,   502,   503,   504,     0,   505,   506,   507,   508,   509,
     510,   197,   511,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   524,   204,   525,
     526,   527,   528,   529,   530,     0,     0,   531,   532,   533,
       0,   534,   208,   535,   536,     0,   537,   211,     0,   538,
     539,   540,   541,   542,   543,   544,   545,   213,   546,     0,
     547,   548,     0,   549,   550,   551,   552,     0,   214,   215,
       0,   554,     0,   555,   216,   556,   217,     0,   557,   558,
     559,   560,   561,     0,     0,   562,   563,   564,   565,  2339,
       0,   566,   567,     0,   568,   224,   569,     0,   570,     0,
       0,     0,   571,   572,   573,   574,   575,   576,     0,   226,
       0,     0,   227,    79,    80,    81,   366,    83,    84,     0,
      85,    86,    87,   367,     0,   368,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   369,
       0,     0,   103,   104,   105,   106,     0,     0,   108,   109,
     110,   111,     0,   112,     0,     0,   115,   370,   371,     0,
       0,     0,   372,   373,     0,     0,     0,     0,   374,     0,
       0,     0,     0,     0,     0,     0,     0,   375,     0,   376,
       0,   377,   378,     0,   379,   380,   381,   382,   383,   384,
     385,   386,  2343,   387,   388,     0,     0,     0,     0,     0,
       0,     0,   389,   390,     0,   391,     0,   392,   393,   394,
       0,   133,     0,   135,     0,     0,   395,   396,     0,   397,
       0,     0,   398,   399,   136,   400,     0,   401,   402,   403,
     404,   140,     0,     0,   405,   406,   407,   408,     0,   409,
     410,   143,   411,     0,   412,   413,   414,     0,   415,     0,
       0,     0,     0,     0,   416,   417,   418,   419,   420,   149,
     150,   421,     0,   422,     0,   423,     0,   424,   425,   426,
       0,   427,     0,     0,   428,   429,   430,   431,     0,   432,
     433,   434,     0,   435,     0,   436,   437,   438,   156,   439,
       0,   158,     0,   440,   441,   160,     0,   442,     0,   443,
       0,     0,     0,   444,     0,   445,     0,   446,   165,     0,
     447,     0,   448,   449,   450,     0,   451,   452,   453,     0,
     454,   455,   456,   457,   458,     0,     0,   168,     0,   459,
     460,   461,     0,   170,     0,   171,     0,     0,     0,     0,
     462,     0,   463,   464,   465,   466,   467,     0,   175,     0,
     468,     0,     0,   469,   470,   471,     0,     0,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   182,
       0,   184,     0,   483,   484,   485,   486,   487,   488,   489,
     185,   490,     0,   491,   492,     0,   493,     0,   188,   189,
     494,   495,     0,     0,   496,     0,     0,     0,   497,   498,
       0,     0,   190,     0,     0,   193,   499,   500,   501,     0,
     194,   195,   502,   503,   504,     0,   505,   506,   507,   508,
     509,   510,   197,   511,     0,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   524,   204,
     525,   526,   527,   528,   529,   530,     0,     0,   531,   532,
     533,     0,   534,   208,   535,   536,     0,   537,   211,     0,
     538,   539,   540,   541,   542,   543,   544,   545,   213,   546,
       0,   547,   548,     0,   549,   550,   551,   552,     0,   214,
     215,     0,   554,     0,   555,   216,   556,   217,     0,   557,
     558,   559,   560,   561,     0,     0,   562,   563,   564,   565,
    2344,     0,   566,   567,     0,   568,   224,   569,     0,   570,
       0,     0,     0,   571,   572,   573,   574,   575,   576,     0,
     226,     0,     0,   227,    79,    80,    81,   366,    83,    84,
       0,    85,    86,    87,   367,     0,   368,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     369,     0,     0,   103,   104,   105,   106,     0,     0,   108,
     109,   110,   111,     0,   112,     0,     0,   115,   370,   371,
       0,     0,     0,   372,   373,     0,     0,     0,     0,   374,
       0,     0,     0,     0,     0,     0,     0,     0,   375,     0,
     376,     0,   377,   378,     0,   379,   380,   381,   382,   383,
     384,   385,   386,  1273,   387,   388,     0,     0,     0,     0,
       0,     0,     0,   389,   390,     0,   391,     0,   392,   393,
     394,     0,   133,     0,   135,     0,     0,   395,   396,     0,
     397,     0,     0,   398,   399,   136,   400,     0,   401,   402,
     403,   404,   140,     0,     0,   405,   406,   407,   408,     0,
     409,   410,   143,   411,     0,   412,   413,   414,     0,   415,
       0,     0,     0,     0,     0,   416,   417,   418,   419,   420,
     149,   150,   421,     0,   422,     0,   423,     0,   424,   425,
     426,     0,   427,     0,     0,   428,   429,   430,   431,     0,
     432,   433,   434,     0,   435,     0,   436,   437,   438,   156,
     439,     0,   158,     0,   440,   441,   160,     0,   442,     0,
     443,     0,     0,     0,   444,     0,   445,     0,   446,   165,
       0,   447,     0,   448,   449,   450,     0,   451,   452,   453,
       0,   454,   455,   456,   457,   458,     0,     0,   168,     0,
     459,   460,   461,     0,   170,     0,   171,     0,     0,     0,
       0,   462,     0,   463,   464,   465,   466,   467,     0,   175,
       0,   468,     0,     0,   469,   470,   471,     0,     0,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
     182,     0,   184,     0,   483,   484,   485,   486,   487,   488,
     489,   185,   490,     0,   491,   492,     0,   493,     0,   188,
     189,   494,   495,     0,     0,   496,     0,     0,     0,   497,
     498,     0,     0,   190,     0,     0,   193,   499,   500,   501,
       0,   194,   195,   502,   503,   504,     0,   505,   506,   507,
     508,   509,   510,   197,   511,     0,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   524,
     204,   525,   526,   527,   528,   529,   530,     0,     0,   531,
     532,   533,     0,   534,   208,   535,   536,     0,   537,   211,
       0,   538,   539,   540,   541,   542,   543,   544,   545,   213,
     546,     0,   547,   548,     0,   549,   550,   551,   552,     0,
     214,   215,     0,   554,     0,   555,   216,   556,   217,     0,
     557,   558,   559,   560,   561,     0,     0,   562,   563,   564,
     565,     0,     0,   566,   567,     0,   568,   224,   569,     0,
     570,     0,     0,     0,   571,   572,   573,   574,   575,   576,
       0,   226,     0,     0,   227,    79,    80,    81,   366,    83,
      84,     0,    85,    86,    87,   367,     0,   368,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   369,     0,     0,   103,   104,   105,   106,     0,     0,
     108,   109,   110,   111,     0,   112,     0,     0,   115,   370,
     371,     0,     0,     0,   372,   373,     0,     0,     0,     0,
     374,     0,     0,     0,     0,     0,     0,     0,     0,   375,
       0,   376,     0,   377,   378,     0,   379,   380,   381,   382,
     383,   384,   385,   386,     0,   387,   388,     0,     0,     0,
       0,     0,  2453,     0,   389,   390,     0,   391,     0,   392,
     393,   394,     0,   133,     0,   135,     0,     0,   395,   396,
       0,   397,     0,     0,   398,   399,   136,   400,     0,   401,
     402,   403,   404,   140,     0,     0,   405,   406,   407,   408,
       0,   409,   410,   143,   411,     0,   412,   413,   414,     0,
     415,     0,     0,     0,     0,     0,   416,   417,   418,   419,
     420,   149,   150,   421,     0,   422,     0,   423,     0,   424,
     425,   426,     0,   427,     0,     0,   428,   429,   430,   431,
       0,   432,   433,   434,     0,   435,     0,   436,   437,   438,
     156,   439,     0,   158,     0,   440,   441,   160,     0,   442,
       0,   443,     0,     0,     0,   444,     0,   445,     0,   446,
     165,     0,   447,     0,   448,   449,   450,     0,   451,   452,
     453,     0,   454,   455,   456,   457,   458,     0,     0,   168,
       0,   459,   460,   461,     0,   170,     0,   171,     0,     0,
       0,     0,   462,     0,   463,   464,   465,   466,   467,     0,
     175,     0,   468,     0,     0,   469,   470,   471,     0,     0,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   182,     0,   184,     0,   483,   484,   485,   486,   487,
     488,   489,   185,   490,     0,   491,   492,     0,   493,     0,
     188,   189,   494,   495,     0,     0,   496,     0,     0,     0,
     497,   498,     0,     0,   190,     0,     0,   193,   499,   500,
     501,     0,   194,   195,   502,   503,   504,     0,   505,   506,
     507,   508,   509,   510,   197,   511,     0,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     524,   204,   525,   526,   527,   528,   529,   530,     0,     0,
     531,   532,   533,     0,   534,   208,   535,   536,     0,   537,
     211,     0,   538,   539,   540,   541,   542,   543,   544,   545,
     213,   546,     0,   547,   548,     0,   549,   550,   551,   552,
       0,   214,   215,     0,   554,     0,   555,   216,   556,   217,
       0,   557,   558,   559,   560,   561,     0,     0,   562,   563,
     564,   565,     0,     0,   566,   567,     0,   568,   224,   569,
       0,   570,     0,     0,     0,   571,   572,   573,   574,   575,
     576,     0,   226,     0,     0,   227,    79,    80,    81,   366,
      83,    84,     0,    85,    86,    87,   367,     0,   368,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   369,     0,     0,   103,   104,   105,   106,     0,
       0,   108,   109,   110,   111,     0,   112,     0,     0,   115,
     370,   371,     0,     0,     0,   372,   373,     0,     0,     0,
       0,   374,     0,     0,     0,     0,     0,     0,     0,     0,
     375,     0,   376,     0,   377,   378,     0,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,     0,     0,  2467,     0,   389,   390,     0,   391,     0,
     392,   393,   394,     0,   133,     0,   135,     0,     0,   395,
     396,     0,   397,     0,     0,   398,   399,   136,   400,     0,
     401,   402,   403,   404,   140,     0,     0,   405,   406,   407,
     408,     0,   409,   410,   143,   411,     0,   412,   413,   414,
       0,   415,     0,     0,     0,     0,     0,   416,   417,   418,
     419,   420,   149,   150,   421,     0,   422,     0,   423,     0,
     424,   425,   426,     0,   427,     0,     0,   428,   429,   430,
     431,     0,   432,   433,   434,     0,   435,     0,   436,   437,
     438,   156,   439,     0,   158,     0,   440,   441,   160,     0,
     442,     0,   443,     0,     0,     0,   444,     0,   445,     0,
     446,   165,     0,   447,     0,   448,   449,   450,     0,   451,
     452,   453,     0,   454,   455,   456,   457,   458,     0,     0,
     168,     0,   459,   460,   461,     0,   170,     0,   171,     0,
       0,     0,     0,   462,     0,   463,   464,   465,   466,   467,
       0,   175,     0,   468,     0,     0,   469,   470,   471,     0,
       0,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,   182,     0,   184,     0,   483,   484,   485,   486,
     487,   488,   489,   185,   490,     0,   491,   492,     0,   493,
       0,   188,   189,   494,   495,     0,     0,   496,     0,     0,
       0,   497,   498,     0,     0,   190,     0,     0,   193,   499,
     500,   501,     0,   194,   195,   502,   503,   504,     0,   505,
     506,   507,   508,   509,   510,   197,   511,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   524,   204,   525,   526,   527,   528,   529,   530,     0,
       0,   531,   532,   533,     0,   534,   208,   535,   536,     0,
     537,   211,     0,   538,   539,   540,   541,   542,   543,   544,
     545,   213,   546,     0,   547,   548,     0,   549,   550,   551,
     552,     0,   214,   215,     0,   554,     0,   555,   216,   556,
     217,     0,   557,   558,   559,   560,   561,     0,     0,   562,
     563,   564,   565,     0,     0,   566,   567,     0,   568,   224,
     569,     0,   570,     0,     0,     0,   571,   572,   573,   574,
     575,   576,     0,   226,     0,     0,   227,    79,    80,    81,
     366,    83,    84,     0,    85,    86,    87,   367,     0,   368,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   369,     0,     0,   103,   104,   105,   106,
       0,     0,   108,   109,   110,   111,     0,   112,     0,     0,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,     0,     0,     0,     0,   389,   390,     0,   391,
       0,   392,   393,   394,     0,   133,     0,   135,     0,     0,
     395,   396,     0,   397,     0,     0,   398,   399,   136,   400,
       0,   401,   402,   403,   404,   140,     0,     0,   405,   406,
     407,   408,     0,   409,   410,   143,   411,     0,   412,   413,
     414,     0,   415,     0,     0,     0,     0,     0,   416,   417,
     418,   419,   420,   149,   150,   421,     0,   422,     0,   423,
       0,   424,   425,   426,     0,   427,     0,     0,   428,   429,
     430,   431,     0,   432,   433,   434,     0,   435,     0,   436,
     437,   438,   156,   439,     0,   158,     0,   440,   441,   160,
       0,   442,     0,   443,     0,     0,     0,   444,     0,   445,
       0,   446,   165,  2488,   447,     0,   448,   449,   450,     0,
     451,   452,   453,     0,   454,   455,   456,   457,   458,     0,
       0,   168,     0,   459,   460,   461,     0,   170,     0,   171,
       0,     0,     0,     0,   462,     0,   463,   464,   465,   466,
     467,     0,   175,     0,   468,     0,     0,   469,   470,   471,
       0,     0,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   182,     0,   184,     0,   483,   484,   485,
     486,   487,   488,   489,   185,   490,     0,   491,   492,     0,
     493,     0,   188,   189,   494,   495,     0,     0,   496,     0,
       0,     0,   497,   498,     0,     0,   190,     0,     0,   193,
     499,   500,   501,     0,   194,   195,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,   197,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   524,   204,   525,   526,   527,   528,   529,   530,
       0,     0,   531,   532,   533,     0,   534,   208,   535,   536,
       0,   537,   211,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   213,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,   214,   215,     0,   554,     0,   555,   216,
     556,   217,     0,   557,   558,   559,   560,   561,     0,     0,
     562,   563,   564,   565,     0,     0,   566,   567,     0,   568,
     224,   569,     0,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,     0,     0,   227,    79,    80,
      81,   366,    83,    84,     0,    85,    86,    87,   367,     0,
     368,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   369,     0,     0,   103,   104,   105,
     106,     0,     0,   108,   109,   110,   111,     0,   112,     0,
       0,   115,   370,   371,     0,     0,     0,   372,   373,     0,
       0,     0,     0,   374,     0,     0,     0,     0,     0,     0,
       0,     0,   375,     0,   376,     0,   377,   378,     0,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,     0,     0,     0,     0,   389,   390,     0,
     391,     0,   392,   393,   394,     0,   133,     0,   135,     0,
       0,   395,   396,     0,   397,     0,     0,   398,   399,   136,
     400,     0,   401,   402,   403,   404,   140,     0,     0,   405,
     406,   407,   408,     0,   409,   410,   143,   411,     0,   412,
     413,   414,     0,   415,     0,     0,     0,     0,     0,   416,
     417,   418,   419,   420,   149,   150,   421,  2755,   422,     0,
     423,     0,   424,   425,   426,     0,   427,     0,     0,   428,
     429,   430,   431,     0,   432,   433,   434,     0,   435,     0,
     436,   437,   438,   156,   439,     0,   158,     0,   440,   441,
     160,     0,   442,     0,   443,     0,     0,     0,   444,     0,
     445,     0,   446,   165,     0,   447,     0,   448,   449,   450,
       0,   451,   452,   453,     0,   454,   455,   456,   457,   458,
       0,     0,   168,     0,   459,   460,   461,     0,   170,     0,
     171,     0,     0,     0,     0,   462,     0,   463,   464,   465,
     466,   467,     0,   175,     0,   468,     0,     0,   469,   470,
     471,     0,     0,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,   182,     0,   184,     0,   483,   484,
     485,   486,   487,   488,   489,   185,   490,     0,   491,   492,
       0,   493,     0,   188,   189,   494,   495,     0,     0,   496,
       0,     0,     0,   497,   498,     0,     0,   190,     0,     0,
     193,   499,   500,   501,     0,   194,   195,   502,   503,   504,
       0,   505,   506,   507,   508,   509,   510,   197,   511,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   524,   204,   525,   526,   527,   528,   529,
     530,     0,     0,   531,   532,   533,     0,   534,   208,   535,
     536,     0,   537,   211,     0,   538,   539,   540,   541,   542,
     543,   544,   545,   213,   546,     0,   547,   548,     0,   549,
     550,   551,   552,     0,   214,   215,     0,   554,     0,   555,
     216,   556,   217,     0,   557,   558,   559,   560,   561,     0,
       0,   562,   563,   564,   565,     0,     0,   566,   567,     0,
     568,   224,   569,     0,   570,     0,     0,     0,   571,   572,
     573,   574,   575,   576,     0,   226,     0,     0,   227,    79,
      80,    81,   366,    83,    84,     0,    85,    86,    87,   367,
       0,   368,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   369,     0,     0,   103,   104,
     105,   106,     0,     0,   108,   109,   110,   111,     0,   112,
       0,     0,   115,   370,   371,     0,     0,     0,   372,   373,
       0,     0,     0,     0,   374,     0,     0,     0,     0,     0,
       0,     0,     0,   375,     0,   376,     0,   377,   378,     0,
     379,   380,   381,   382,   383,   384,   385,   386,     0,   387,
     388,     0,     0,     0,     0,     0,     0,     0,   389,   390,
       0,   391,     0,   392,   393,   394,     0,   133,     0,   135,
       0,     0,   395,   396,     0,   397,     0,     0,   398,   399,
     136,   400,     0,   401,   402,   403,   404,   140,     0,     0,
     405,   406,   407,   408,     0,   409,   410,   143,   411,     0,
     412,   413,   414,     0,   415,     0,     0,     0,     0,     0,
     416,   417,   418,   419,   420,   149,   150,   421,  2757,   422,
       0,   423,     0,   424,   425,   426,     0,   427,     0,     0,
     428,   429,   430,   431,     0,   432,   433,   434,     0,   435,
       0,   436,   437,   438,   156,   439,     0,   158,     0,   440,
     441,   160,     0,   442,     0,   443,     0,     0,     0,   444,
       0,   445,     0,   446,   165,     0,   447,     0,   448,   449,
     450,     0,   451,   452,   453,     0,   454,   455,   456,   457,
     458,     0,     0,   168,     0,   459,   460,   461,     0,   170,
       0,   171,     0,     0,     0,     0,   462,     0,   463,   464,
     465,   466,   467,     0,   175,     0,   468,     0,     0,   469,
     470,   471,     0,     0,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   182,     0,   184,     0,   483,
     484,   485,   486,   487,   488,   489,   185,   490,     0,   491,
     492,     0,   493,     0,   188,   189,   494,   495,     0,     0,
     496,     0,     0,     0,   497,   498,     0,     0,   190,     0,
       0,   193,   499,   500,   501,     0,   194,   195,   502,   503,
     504,     0,   505,   506,   507,   508,   509,   510,   197,   511,
       0,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   524,   204,   525,   526,   527,   528,
     529,   530,     0,     0,   531,   532,   533,     0,   534,   208,
     535,   536,     0,   537,   211,     0,   538,   539,   540,   541,
     542,   543,   544,   545,   213,   546,     0,   547,   548,     0,
     549,   550,   551,   552,     0,   214,   215,     0,   554,     0,
     555,   216,   556,   217,     0,   557,   558,   559,   560,   561,
       0,     0,   562,   563,   564,   565,     0,     0,   566,   567,
       0,   568,   224,   569,     0,   570,     0,     0,     0,   571,
     572,   573,   574,   575,   576,     0,   226,     0,     0,   227,
      79,    80,    81,   366,    83,    84,     0,    85,    86,    87,
     367,     0,   368,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   369,     0,     0,   103,
     104,   105,   106,     0,     0,   108,   109,   110,   111,     0,
     112,     0,     0,   115,   370,   371,     0,     0,     0,   372,
     373,     0,     0,     0,     0,   374,     0,     0,     0,     0,
       0,     0,     0,     0,   375,     0,   376,     0,   377,   378,
       0,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,     0,     0,     0,     0,   389,
     390,     0,   391,     0,   392,   393,   394,     0,   133,     0,
     135,     0,     0,   395,   396,     0,   397,     0,     0,   398,
     399,   136,   400,     0,   401,   402,   403,   404,   140,     0,
       0,   405,   406,   407,   408,     0,   409,   410,   143,   411,
       0,   412,   413,   414,     0,   415,     0,     0,     0,     0,
       0,   416,   417,   418,   419,   420,   149,   150,   421,  2759,
     422,     0,   423,     0,   424,   425,   426,     0,   427,     0,
       0,   428,   429,   430,   431,     0,   432,   433,   434,     0,
     435,     0,   436,   437,   438,   156,   439,     0,   158,     0,
     440,   441,   160,     0,   442,     0,   443,     0,     0,     0,
     444,     0,   445,     0,   446,   165,     0,   447,     0,   448,
     449,   450,     0,   451,   452,   453,     0,   454,   455,   456,
     457,   458,     0,     0,   168,     0,   459,   460,   461,     0,
     170,     0,   171,     0,     0,     0,     0,   462,     0,   463,
     464,   465,   466,   467,     0,   175,     0,   468,     0,     0,
     469,   470,   471,     0,     0,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,   182,     0,   184,     0,
     483,   484,   485,   486,   487,   488,   489,   185,   490,     0,
     491,   492,     0,   493,     0,   188,   189,   494,   495,     0,
       0,   496,     0,     0,     0,   497,   498,     0,     0,   190,
       0,     0,   193,   499,   500,   501,     0,   194,   195,   502,
     503,   504,     0,   505,   506,   507,   508,   509,   510,   197,
     511,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   524,   204,   525,   526,   527,
     528,   529,   530,     0,     0,   531,   532,   533,     0,   534,
     208,   535,   536,     0,   537,   211,     0,   538,   539,   540,
     541,   542,   543,   544,   545,   213,   546,     0,   547,   548,
       0,   549,   550,   551,   552,     0,   214,   215,     0,   554,
       0,   555,   216,   556,   217,     0,   557,   558,   559,   560,
     561,     0,     0,   562,   563,   564,   565,     0,     0,   566,
     567,     0,   568,   224,   569,     0,   570,     0,     0,     0,
     571,   572,   573,   574,   575,   576,     0,   226,     0,     0,
     227,    79,    80,    81,   366,    83,    84,     0,    85,    86,
      87,   367,     0,   368,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   369,     0,     0,
     103,   104,   105,   106,     0,     0,   108,   109,   110,   111,
       0,   112,     0,     0,   115,   370,   371,     0,     0,     0,
     372,   373,     0,     0,     0,     0,   374,     0,     0,     0,
       0,     0,     0,     0,     0,   375,     0,   376,     0,   377,
     378,     0,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,     0,     0,     0,     0,
     389,   390,     0,   391,     0,   392,   393,   394,     0,   133,
       0,   135,     0,     0,   395,   396,     0,   397,     0,     0,
     398,   399,   136,   400,     0,   401,   402,   403,   404,   140,
       0,     0,   405,   406,   407,   408,     0,   409,   410,   143,
     411,     0,   412,   413,   414,     0,   415,     0,     0,     0,
       0,     0,   416,   417,   418,   419,   420,   149,   150,   421,
       0,   422,     0,   423,     0,   424,   425,   426,     0,   427,
       0,     0,   428,   429,   430,   431,     0,   432,   433,   434,
       0,   435,     0,   436,   437,   438,   156,   439,     0,   158,
       0,   440,   441,   160,     0,   442,     0,   443,     0,     0,
       0,   444,     0,   445,     0,   446,   165,     0,   447,     0,
     448,   449,   450,     0,   451,   452,   453,     0,   454,   455,
     456,   457,   458,     0,     0,   168,     0,   459,   460,   461,
       0,   170,     0,   171,     0,     0,     0,     0,   462,     0,
     463,   464,   465,   466,   467,     0,   175,     0,   468,     0,
       0,   469,   470,   471,     0,     0,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   182,     0,   184,
       0,   483,   484,   485,   486,   487,   488,   489,   185,   490,
       0,   491,   492,     0,   493,     0,   188,   189,   494,   495,
       0,     0,   496,     0,     0,     0,   497,   498,     0,     0,
     190,     0,     0,   193,   499,   500,   501,     0,   194,   195,
     502,   503,   504,     0,   505,   506,   507,   508,   509,   510,
     197,   511,     0,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   524,   204,   525,   526,
     527,   528,   529,   530,     0,     0,   531,   532,   533,     0,
     534,   208,   535,   536,     0,   537,   211,     0,   538,   539,
     540,   541,   542,   543,   544,   545,   213,   546,     0,   547,
     548,     0,   549,   550,   551,   552,     0,   214,   215,     0,
     554,     0,   555,   216,   556,   217,     0,   557,   558,   559,
     560,   561,     0,     0,   562,   563,   564,   565,     0,  3225,
     566,   567,     0,   568,   224,   569,     0,   570,     0,     0,
       0,   571,   572,   573,   574,   575,   576,     0,   226,     0,
       0,   227,    79,    80,    81,   366,    83,    84,     0,    85,
      86,    87,   367,     0,   368,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   369,     0,
       0,   103,   104,   105,   106,     0,     0,   108,   109,   110,
     111,     0,   112,     0,     0,   115,   370,   371,     0,     0,
       0,   372,   373,     0,     0,     0,     0,   374,     0,     0,
       0,     0,     0,     0,     0,     0,   375,     0,   376,     0,
     377,   378,     0,   379,   380,   381,   382,   383,   384,   385,
     386,     0,   387,   388,     0,     0,     0,     0,     0,     0,
       0,   389,   390,     0,   391,     0,   392,   393,   394,     0,
     133,     0,   135,     0,     0,   395,   396,     0,   397,     0,
       0,   398,   399,   136,   400,     0,   401,   402,   403,   404,
     140,     0,     0,   405,   406,   407,   408,     0,   409,   410,
     143,   411,     0,   412,   413,   414,     0,   415,     0,     0,
       0,     0,     0,   416,   417,   418,   419,   420,   149,   150,
     421,     0,   422,     0,   423,     0,   424,   425,   426,     0,
     427,     0,     0,   428,   429,   430,   431,     0,   432,   433,
     434,     0,   435,     0,   436,   437,   438,   156,   439,     0,
     158,     0,   440,   441,   160,     0,   442,     0,   443,     0,
       0,     0,   444,     0,   445,     0,   446,   165,     0,   447,
       0,   448,   449,   450,     0,   451,   452,   453,     0,   454,
     455,   456,   457,   458,     0,     0,   168,     0,   459,   460,
     461,     0,   170,     0,   171,     0,     0,     0,     0,   462,
       0,   463,   464,   465,   466,   467,     0,   175,     0,   468,
       0,     0,   469,   470,   471,     0,     0,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   182,     0,
     184,     0,   483,   484,   485,   486,   487,   488,   489,   185,
     490,     0,   491,   492,     0,   493,     0,   188,   189,   494,
     495,     0,     0,   496,     0,     0,     0,   497,   498,     0,
       0,   190,     0,     0,   193,   499,   500,   501,     0,   194,
     195,   502,   503,   504,     0,   505,   506,   507,   508,   509,
     510,   197,   511,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   524,   204,   525,
     526,   527,   528,   529,   530,     0,     0,   531,   532,   533,
       0,   534,   208,   535,   536,     0,   537,   211,     0,   538,
     539,   540,   541,   542,   543,   544,   545,   213,   546,     0,
     547,   548,     0,   549,   550,   551,   552,     0,   214,   215,
       0,   554,     0,   555,   216,   556,   217,     0,   557,   558,
     559,   560,   561,     0,     0,   562,   563,   564,   565,     0,
       0,   566,   567,     0,   568,   224,   569,     0,   570,     0,
       0,     0,   571,   572,   573,   574,   575,   576,     0,   226,
       0,     0,   227,    79,    80,    81,   366,    83,    84,     0,
      85,    86,    87,   367,     0,   368,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   369,
       0,     0,   103,   104,   105,   106,     0,     0,   108,   109,
     110,   111,     0,   112,     0,     0,   115,   370,   371,     0,
       0,     0,   372,   373,     0,     0,     0,     0,   374,     0,
       0,     0,     0,     0,     0,     0,     0,   375,     0,   376,
       0,   377,   378,     0,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,     0,     0,
       0,     0,   389,   390,     0,   391,     0,   392,   393,   394,
       0,   133,     0,   135,     0,     0,   395,   396,     0,   397,
       0,     0,   398,   399,   136,   400,     0,   401,   402,   403,
     404,   140,     0,     0,   405,   406,   407,   408,     0,   409,
     410,   143,   411,     0,   412,   413,   414,     0,   415,     0,
       0,     0,     0,     0,   416,   417,   418,   419,   420,   149,
     150,   421,     0,   422,     0,   423,     0,   424,   425,   426,
       0,   427,     0,     0,   428,   429,   430,   431,     0,   432,
     433,   434,     0,   435,     0,   436,   437,   438,   156,   439,
       0,   158,     0,   440,   441,   160,     0,   442,     0,   443,
       0,     0,     0,   444,     0,   445,     0,   446,   165,     0,
     447,     0,   448,   449,   450,     0,   451,   452,   453,     0,
     454,   455,   456,   457,   458,     0,     0,   168,     0,   459,
     460,   461,     0,   170,     0,   171,     0,     0,     0,     0,
     462,     0,   463,   464,   465,   466,   467,     0,   175,     0,
     468,     0,     0,   469,   470,   471,     0,     0,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   182,
       0,   184,     0,   483,   484,   485,   486,   487,   488,   489,
     185,   490,     0,   491,   492,     0,   493,     0,   188,   189,
     494,   495,     0,     0,   496,     0,     0,     0,   497,   498,
       0,     0,   190,     0,     0,   193,   499,   500,   501,     0,
     194,   195,   502,   503,   504,     0,   505,   506,   507,   508,
     509,   510,   197,   511,     0,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   524,   204,
     525,   526,   527,   528,   529,   530,     0,     0,   531,   532,
     533,     0,   534,   208,   535,   536,     0,   537,   211,     0,
     538,   539,   785,   541,   542,   543,   544,   545,   213,   546,
       0,   547,   548,     0,   549,   550,   551,   552,     0,   214,
     215,     0,   554,     0,   555,   216,   556,   217,     0,   557,
     558,   559,   560,   561,     0,     0,   562,   563,   564,   565,
       0,     0,   566,   567,     0,   568,   224,   569,     0,   570,
       0,     0,     0,   571,   572,   573,   574,   575,   576,     0,
     226,     0,     0,   227,    79,    80,    81,   366,    83,    84,
       0,    85,    86,    87,   367,     0,   368,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     369,     0,     0,   103,   104,   105,   106,     0,     0,   108,
     109,   110,   111,     0,   112,     0,     0,   115,   370,   371,
       0,     0,     0,   372,   373,     0,     0,     0,     0,   374,
       0,     0,     0,     0,     0,     0,     0,     0,   375,     0,
     376,     0,   377,   378,     0,   379,   380,   381,   382,   383,
     384,   385,   386,     0,   387,   388,     0,     0,     0,     0,
       0,     0,     0,   389,   390,     0,   391,     0,   392,   393,
     394,     0,   133,     0,   135,     0,     0,   395,   396,     0,
     397,     0,     0,   398,   399,   136,   400,     0,   401,   402,
     403,   404,   140,     0,     0,   405,   406,   407,   408,     0,
     409,   410,   143,   411,     0,   412,   413,   414,     0,   415,
       0,     0,     0,     0,     0,   416,   417,   418,   419,   420,
     149,   150,   421,     0,   422,     0,   423,     0,   424,   425,
     426,     0,   427,     0,     0,   428,   429,   430,   431,     0,
     432,   433,   434,     0,   435,     0,   436,   437,   438,   156,
     439,     0,   158,     0,   440,   441,   160,     0,   442,     0,
     443,     0,     0,     0,   444,     0,   445,     0,   446,   165,
       0,   447,     0,   448,   449,   450,     0,   451,   452,   453,
       0,   454,   455,   456,   457,   458,     0,     0,   168,     0,
     459,   460,   461,     0,   170,     0,   171,     0,     0,     0,
       0,   462,     0,   463,   464,   465,   466,   467,     0,   175,
       0,   468,     0,     0,   469,   470,   471,     0,     0,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
     182,     0,   184,     0,   483,   484,   485,   486,   487,   488,
     489,   185,   490,     0,   491,   492,     0,   493,     0,   188,
     189,   494,   495,     0,     0,   496,     0,     0,     0,   497,
     498,     0,     0,   190,     0,     0,   193,   499,   500,   501,
       0,   194,   195,   502,   503,   504,     0,   505,   506,   507,
     508,   509,   510,   197,   511,     0,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   524,
     204,   525,   526,   861,   528,   529,   530,     0,     0,   531,
     532,   533,     0,   534,   208,   535,   536,     0,   537,   211,
       0,   538,   539,   540,   541,   542,   543,   544,   545,   213,
     546,     0,   547,   548,     0,   549,   550,   551,   552,     0,
     214,   215,     0,   554,     0,   555,   216,   556,   217,     0,
     557,   558,   559,   560,   561,     0,     0,   562,   563,   564,
     565,     0,     0,   566,   567,     0,   568,   224,   569,     0,
     570,     0,     0,     0,   571,   572,   573,   574,   575,   576,
       0,   226,     0,     0,   227,    79,    80,    81,   366,    83,
      84,     0,    85,    86,    87,   367,     0,   368,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   369,     0,     0,   103,   104,   105,   106,     0,     0,
     108,   109,   110,   111,     0,   112,     0,     0,   115,   370,
     371,     0,     0,     0,   372,   373,     0,     0,     0,     0,
     374,     0,     0,     0,     0,     0,     0,     0,     0,   375,
       0,   376,     0,   377,   378,     0,   379,   380,   381,   382,
     383,   384,   385,   386,   863,   387,   388,     0,     0,     0,
       0,     0,     0,     0,   389,   390,     0,   391,     0,   392,
     393,   394,     0,   133,     0,   135,     0,     0,   395,   396,
       0,   397,     0,     0,   398,   864,   136,   400,     0,   401,
     402,   403,   404,   140,     0,     0,   405,   406,   407,     0,
       0,   409,   410,   143,   411,     0,   412,   413,   414,     0,
     415,     0,     0,     0,     0,     0,   416,   417,   418,   419,
     420,   149,   150,   421,     0,   422,     0,   423,     0,   424,
     425,   426,     0,   427,     0,     0,   428,   429,   430,   431,
       0,   432,   433,   434,     0,   435,     0,   436,   437,   438,
     156,   439,     0,   158,     0,   440,   441,   160,     0,   442,
       0,   443,     0,     0,     0,   444,     0,   445,     0,   446,
     165,     0,   447,     0,   448,   449,   450,     0,   451,   452,
     453,     0,   454,   455,   456,   457,   458,     0,     0,   168,
       0,   459,   460,   461,     0,   170,     0,   171,     0,     0,
       0,     0,   462,     0,   463,   464,   465,   466,   467,     0,
     175,     0,   468,     0,     0,   469,   470,   471,     0,     0,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   182,     0,   184,     0,   483,   484,   485,   486,   487,
     488,   489,   185,   490,     0,   491,   492,     0,   493,     0,
     188,   189,   494,   495,     0,     0,   496,     0,     0,     0,
     497,   498,     0,     0,   190,     0,     0,   193,   499,   500,
     501,     0,   194,   195,   502,   503,   504,     0,   505,   506,
     507,   508,   509,   510,   197,   511,     0,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     524,   204,   525,   526,   527,   528,   529,   530,     0,     0,
     531,   532,   865,     0,   534,   208,   535,   536,     0,   537,
     211,     0,   538,   539,   540,   541,   542,   543,   544,   545,
     213,   546,     0,   547,   548,     0,   549,   550,   551,   552,
       0,   866,   215,     0,   554,     0,   867,   216,   556,   217,
       0,   557,   558,   559,   560,   561,     0,     0,   562,   563,
     564,   565,     0,     0,   566,   567,     0,   568,   224,   569,
       0,   570,     0,     0,     0,   571,   572,   573,   574,   575,
     576,     0,   226,     0,     0,   227,    79,    80,    81,   366,
      83,    84,     0,    85,    86,    87,   367,     0,   368,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   369,     0,     0,   103,   104,   105,   106,     0,
       0,   108,   109,   110,   111,     0,   112,     0,     0,   115,
     370,   371,     0,     0,     0,   372,   373,     0,     0,     0,
       0,   374,     0,     0,     0,     0,     0,     0,     0,     0,
     375,     0,   376,     0,   377,   378,     0,   379,   380,   381,
     382,   383,   384,   385,   386,   897,   387,   388,     0,     0,
       0,     0,     0,     0,     0,   389,   390,     0,   391,     0,
     392,   393,   394,     0,   133,     0,   135,     0,     0,   395,
     396,     0,   397,     0,     0,   398,   864,   136,   400,     0,
     401,   402,   403,   404,   140,     0,     0,   405,   406,   407,
       0,     0,   409,   410,   143,   411,     0,   412,   413,   414,
       0,   415,     0,     0,     0,     0,     0,   416,   417,   418,
     419,   420,   149,   150,   421,     0,   422,     0,   423,     0,
     424,   425,   426,     0,   427,     0,     0,   428,   429,   430,
     431,     0,   432,   433,   434,     0,   435,     0,   436,   437,
     438,   156,   439,     0,   158,     0,   440,   441,   160,     0,
     442,     0,   443,     0,     0,     0,   444,     0,   445,     0,
     446,   165,     0,   447,     0,   448,   449,   450,     0,   451,
     452,   453,     0,   454,   455,   456,   457,   458,     0,     0,
     168,     0,   459,   460,   461,     0,   170,     0,   171,     0,
       0,     0,     0,   462,     0,   463,   464,   465,   466,   467,
       0,   175,     0,   468,     0,     0,   469,   470,   471,     0,
       0,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,   182,     0,   184,     0,   483,   484,   485,   486,
     487,   488,   489,   185,   490,     0,   491,   492,     0,   493,
       0,   188,   189,   494,   495,     0,     0,   496,     0,     0,
       0,   497,   498,     0,     0,   190,     0,     0,   193,   499,
     500,   501,     0,   194,   195,   502,   503,   504,     0,   505,
     506,   507,   508,   509,   510,   197,   511,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   524,   204,   525,   526,   527,   528,   529,   530,     0,
       0,   531,   532,   898,     0,   534,   208,   535,   536,     0,
     537,   211,     0,   538,   539,   540,   541,   542,   543,   544,
     545,   213,   546,     0,   547,   548,     0,   549,   550,   551,
     552,     0,   899,   215,     0,   554,     0,   900,   216,   556,
     217,     0,   557,   558,   559,   560,   561,     0,     0,   562,
     563,   564,   565,     0,     0,   566,   567,     0,   568,   224,
     569,     0,   570,     0,     0,     0,   571,   572,   573,   574,
     575,   576,     0,   226,     0,     0,   227,    79,    80,    81,
     366,    83,    84,     0,    85,    86,    87,   367,     0,   368,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   369,     0,     0,   103,   104,   105,   106,
       0,     0,   108,   109,   110,   111,     0,   112,     0,     0,
     115,   370,   371,     0,     0,     0,   372,   373,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,   375,     0,   376,     0,   377,   378,     0,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,     0,     0,     0,     0,   389,   390,     0,   391,
    1284,   392,   393,   394,     0,   133,     0,   135,     0,     0,
     395,   396,     0,   397,     0,     0,   398,   864,   136,  1285,
       0,   401,   402,   403,   404,   140,     0,     0,   405,   406,
     407,     0,     0,   409,   410,   143,   411,     0,   412,   413,
     414,     0,   415,     0,     0,     0,     0,     0,   416,   417,
     418,   419,   420,   149,   150,   421,     0,   422,     0,   423,
       0,   424,   425,   426,     0,   427,     0,     0,   428,   429,
     430,   431,     0,   432,   433,   434,     0,   435,     0,   436,
     437,   438,   156,   439,     0,   158,     0,   440,   441,   160,
       0,   442,     0,   443,     0,     0,     0,   444,     0,   445,
       0,   446,   165,     0,   447,     0,   448,   449,   450,     0,
     451,   452,   453,     0,   454,   455,   456,   457,   458,     0,
       0,   168,     0,   459,   460,   461,     0,   170,     0,   171,
       0,     0,     0,     0,   462,     0,   463,   464,   465,   466,
     467,     0,   175,     0,   468,     0,     0,   469,   470,   471,
       0,     0,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   890,   182,     0,   184,     0,   483,   484,   485,
     486,   487,   488,   489,   185,   490,     0,   491,   492,     0,
     493,     0,   188,   189,   494,   495,     0,     0,   496,     0,
       0,     0,   497,   498,     0,     0,   190,     0,     0,   193,
     499,   500,   501,     0,   194,   195,   502,   503,   504,     0,
     505,   506,   507,   508,   509,   510,   197,   511,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   891,   524,   204,   525,   526,   527,   528,   529,   530,
       0,     0,   531,   532,  1276,     0,   534,   208,   535,   536,
       0,   537,   211,     0,   538,   539,   540,   541,   542,   543,
     544,   545,   213,   546,     0,   547,   548,     0,   549,   550,
     551,   552,     0,   893,   215,     0,   554,     0,   894,   216,
     556,   217,     0,   557,   558,   559,   560,   561,     0,     0,
     562,   563,   564,   565,     0,     0,   566,   567,     0,   568,
     224,   569,     0,   570,     0,     0,     0,   571,   572,   573,
     574,   575,   576,     0,   226,     0,     0,   227,  1376,    80,
      81,   366,    83,    84,     0,    85,    86,    87,   367,     0,
     368,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   369,     0,     0,   103,   104,   105,
     106,     0,     0,   108,   109,   110,   111,     0,   112,     0,
       0,   115,   370,   371,     0,     0,     0,   372,   373,     0,
       0,     0,     0,   374,     0,     0,     0,     0,     0,     0,
       0,     0,   375,     0,   376,     0,   377,   378,     0,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,     0,     0,     0,     0,   389,   390,     0,
     391,     0,   392,   393,   394,     0,   133,     0,   135,     0,
       0,   395,   396,     0,   397,     0,     0,   398,   399,   136,
     400,     0,   401,   402,   403,   404,   140,     0,     0,   405,
     406,   407,   408,     0,   409,   410,   143,   411,     0,   412,
     413,   414,     0,   415,     0,     0,     0,     0,     0,   416,
     417,   418,   419,   420,   149,   150,   421,     0,   422,     0,
     423,     0,   424,   425,   426,     0,   427,     0,     0,   428,
     429,   430,   431,     0,   432,   433,   434,     0,   435,     0,
     436,   437,   438,   156,   439,     0,   158,     0,   440,   441,
     160,     0,   442,     0,   443,     0,     0,     0,   444,     0,
     445,     0,   446,   165,     0,   447,     0,   448,   449,   450,
       0,   451,   452,   453,     0,   454,   455,   456,   457,   458,
       0,     0,   168,     0,   459,   460,   461,     0,   170,     0,
     171,     0,     0,     0,     0,   462,     0,   463,   464,   465,
     466,   467,     0,   175,     0,   468,     0,     0,   469,   470,
     471,     0,     0,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,   182,     0,   184,     0,   483,   484,
     485,   486,   487,   488,   489,   185,   490,     0,   491,   492,
       0,   493,     0,   188,   189,   494,   495,     0,     0,   496,
       0,     0,     0,   497,   498,     0,     0,   190,     0,     0,
     193,   499,   500,   501,     0,   194,   195,   502,   503,   504,
       0,   505,   506,   507,   508,   509,   510,   197,   511,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   524,   204,   525,   526,   527,   528,   529,
     530,     0,     0,   531,   532,   533,     0,   534,   208,   535,
     536,     0,   537,   211,     0,   538,   539,   540,   541,   542,
     543,   544,   545,   213,   546,     0,   547,   548,     0,   549,
     550,   551,   552,     0,   214,   215,     0,   554,     0,   555,
     216,   556,   217,     0,   557,   558,   559,   560,   561,     0,
       0,   562,   563,   564,   565,     0,     0,   566,   567,     0,
     568,   224,   569,     0,   570,     0,     0,     0,   571,   572,
     573,   574,   575,   576,     0,   226,     0,     0,   227,    79,
      80,    81,   366,    83,    84,     0,    85,    86,    87,   367,
       0,   368,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   369,     0,     0,   103,   104,
     105,   106,     0,     0,   108,   109,   110,   111,     0,   112,
       0,     0,   115,   370,   371,     0,     0,     0,   372,   373,
       0,     0,     0,     0,   374,     0,     0,     0,     0,     0,
       0,     0,     0,   375,     0,   376,     0,   377,   378,     0,
     379,   380,   381,   382,   383,   384,   385,   386,     0,   387,
     388,     0,     0,     0,     0,     0,     0,     0,   389,   390,
       0,   391,     0,   392,   393,   394,     0,   133,     0,   135,
       0,     0,   395,   396,     0,   397,     0,     0,   398,   399,
     136,   400,     0,   401,   402,   403,   404,   140,     0,     0,
     405,   406,   407,   408,     0,   409,   410,   143,   411,     0,
     412,   413,   414,     0,   415,     0,     0,     0,     0,     0,
     416,   417,   418,   419,   420,   149,   150,   421,     0,   422,
       0,   423,     0,   424,   425,   426,     0,   427,     0,     0,
     428,   429,   430,   431,     0,   432,   433,   434,     0,   435,
       0,   436,   437,   438,   156,   439,     0,   158,     0,   440,
     441,   160,     0,   442,     0,   443,     0,     0,     0,   444,
       0,   445,     0,   446,   165,     0,   447,     0,   448,   449,
     450,     0,   451,   452,   453,     0,   454,   455,   456,   457,
     458,     0,     0,   168,     0,   459,   460,   461,     0,   170,
       0,   171,     0,     0,     0,     0,   462,     0,   463,   464,
     465,   466,   467,     0,   175,     0,   468,     0,     0,   469,
     470,   471,     0,     0,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   182,     0,   184,     0,   483,
     484,   485,   486,   487,   488,   489,   185,   490,     0,   491,
     492,     0,   493,     0,   188,   189,   494,   495,     0,     0,
     496,     0,     0,     0,   497,   498,     0,     0,   190,     0,
       0,   193,   499,   500,   501,     0,   194,   195,   502,   503,
     504,     0,   505,   506,   507,   508,   509,   510,   197,   511,
       0,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   524,   204,   525,   526,  1609,   528,
     529,   530,     0,     0,   531,   532,   533,     0,   534,   208,
     535,   536,     0,   537,   211,     0,   538,   539,   540,   541,
     542,   543,   544,   545,   213,   546,     0,   547,   548,     0,
     549,   550,   551,   552,     0,   214,   215,     0,   554,     0,
     555,   216,   556,   217,     0,   557,   558,   559,   560,   561,
       0,     0,   562,   563,   564,   565,     0,     0,   566,   567,
       0,   568,   224,   569,     0,   570,     0,     0,     0,   571,
     572,   573,   574,   575,   576,     0,   226,     0,     0,   227,
      79,    80,    81,   366,    83,    84,     0,    85,    86,    87,
     367,     0,   368,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   369,     0,     0,   103,
     104,   105,   106,     0,     0,   108,   109,   110,   111,     0,
     112,     0,     0,   115,   370,   371,     0,     0,     0,   372,
     373,     0,     0,     0,     0,   374,     0,     0,     0,     0,
       0,     0,     0,     0,   375,     0,   376,     0,   377,   378,
       0,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,     0,     0,     0,     0,   389,
     390,     0,   391,     0,   392,   393,   394,     0,   133,     0,
     135,     0,     0,   395,   396,     0,   397,     0,     0,   398,
     864,   136,   400,     0,   401,   402,   403,   404,   140,     0,
       0,   405,   406,   407,     0,     0,   409,   410,   143,   411,
       0,   412,   413,   414,     0,   415,     0,     0,     0,     0,
       0,   416,   417,   418,   419,   420,   149,   150,   421,     0,
     422,     0,   423,     0,   424,   425,   426,     0,   427,     0,
       0,   428,   429,   430,   431,     0,   432,   433,   434,     0,
     435,     0,   436,   437,   438,   156,   439,     0,   158,     0,
     440,   441,   160,     0,   442,     0,   443,     0,     0,     0,
     444,     0,   445,     0,   446,   165,     0,   447,     0,   448,
     449,   450,     0,   451,   452,   453,     0,   454,   455,   456,
     457,   458,     0,     0,   168,     0,   459,   460,   461,     0,
     170,     0,   171,     0,     0,     0,     0,   462,     0,   463,
     464,   465,   466,   467,     0,   175,     0,   468,     0,     0,
     469,   470,   471,     0,     0,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   890,   182,     0,   184,     0,
     483,   484,   485,   486,   487,   488,   489,   185,   490,     0,
     491,   492,     0,   493,     0,   188,   189,   494,   495,     0,
       0,   496,     0,     0,     0,   497,   498,     0,     0,   190,
       0,     0,   193,   499,   500,   501,     0,   194,   195,   502,
     503,   504,     0,   505,   506,   507,   508,   509,   510,   197,
     511,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   891,   524,   204,   525,   526,   527,
     528,   529,   530,     0,     0,   531,   532,  1276,     0,   534,
     208,   535,   536,     0,   537,   211,     0,   538,   539,   540,
     541,   542,   543,   544,   545,   213,   546,     0,   547,   548,
       0,   549,   550,   551,   552,     0,   893,   215,     0,   554,
       0,   894,   216,   556,   217,     0,   557,   558,   559,   560,
     561,     0,     0,   562,   563,   564,   565,     0,     0,   566,
     567,     0,   568,   224,   569,     0,   570,     0,     0,     0,
     571,   572,   573,   574,   575,   576,     0,   226,     0,     0,
     227,    79,    80,    81,     0,    83,    84,     0,    85,    86,
      87,     0,     0,     0,    90,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,     0,     0,     0,
     103,   104,   105,   106,     0,   107,   108,   109,   110,   111,
       0,   112,   113,   114,   115,     0,     0,     0,     0,     0,
     118,   119,     0,     0,     0,     0,   120,     0,     0,     0,
       0,     0,     0,     0,     0,   121,     0,   122,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   130,     0,     0,     0,   132,   133,
     134,   135,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   136,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   143,
       0,     0,     0,     0,     0,   146,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   149,   150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   156,     0,     0,   158,
       0,     0,     0,   160,     0,     0,     0,     0,   161,     0,
     162,     0,     0,     0,     0,     0,   165,     0,     0,     0,
       0,     0,     0,   166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   170,     0,   171,     0,     0,   172,   173,     0,   174,
       0,     0,     0,     0,     0,     0,   175,   176,     0,   177,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   182,   183,   184,
       0,     0,     0,     0,     0,     0,     0,     0,   185,     0,
       0,     0,     0,   187,     0,     0,   188,   189,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     190,   191,   192,   193,     0,     0,     0,     0,   194,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   202,     0,     0,   204,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   208,     0,     0,   210,     0,   211,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   213,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   214,   215,     0,
       0,     0,     0,   216,     0,   217,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
       0,     0,     0,     0,     0,    79,    80,    81,   226,    83,
      84,   227,    85,    86,    87,     0,     0,     0,    90,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,     0,     0,     0,   103,   104,   105,   106,     0,   107,
     108,   109,   110,   111,     0,   112,   113,   114,   115,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   130,     0,
       0,     0,   132,   133,   134,   135,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   136,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   143,     0,     0,     0,     0,     0,   146,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   149,   150,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     156,     0,     0,   158,     0,     0,     0,   160,     0,     0,
       0,     0,   161,     0,   162,     0,     0,     0,     0,     0,
     165,     0,     0,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   170,     0,   171,     0,     0,
     172,   173,     0,   174,     0,     0,     0,     0,     0,     0,
     175,   176,     0,   177,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   182,   183,   184,     0,     0,     0,     0,     0,     0,
       0,     0,   185,     0,     0,     0,     0,   187,     0,     0,
     188,   189,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   190,   191,   192,   193,     0,     0,
       0,     0,   194,   195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   202,     0,
       0,   204,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   208,     0,     0,   210,     0,
     211,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     213,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   214,   215,     0,     0,     0,     0,   216,     0,   217,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   224,     0,
     225,     0,    79,    80,    81,     0,    83,    84,     0,    85,
      86,    87,   226,     0,     0,   227,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,     0,     0,
       0,   103,   104,   105,   106,     0,     0,   108,   109,   110,
     111,     0,   112,     0,     0,   115,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   130,     0,     0,     0,   132,
     133,   134,   135,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   136,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     143,     0,     0,     0,     0,     0,   146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   149,   150,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   156,     0,     0,
     158,     0,     0,     0,   160,     0,     0,     0,     0,   161,
       0,   162,     0,     0,     0,     0,     0,   165,     0,     0,
       0,     0,     0,     0,   166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   170,     0,   171,     0,     0,   172,   173,     0,
     174,     0,     0,     0,     0,     0,     0,   175,   176,     0,
     177,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   182,   183,
     184,     0,     0,     0,     0,     0,     0,     0,     0,   185,
       0,     0,     0,     0,   187,     0,     0,   188,   189,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   190,   191,   192,   193,     0,     0,     0,     0,   194,
     195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   197,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   202,     0,     0,   204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   208,     0,     0,   210,     0,   211,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   213,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   214,   215,
       0,     0,     0,     0,   216,     0,   217,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   224,     0,   225,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   226,
       0,     0,   227
};

static const short yycheck[] =
{
       2,   155,   727,  1421,   145,    90,   850,    74,    74,  1112,
       2,   228,    74,    77,  1551,   720,   719,   722,  1581,   218,
     723,  1046,   980,   742,  1086,    90,    74,   711,   113,   734,
     201,  1093,  1163,  1505,    90,    90,  1226,   762,  1212,   894,
     148,   222,   196,  1033,  1362,    90,  2085,   155,   113,   752,
     816,  1041,   818,   758,   820,   721,   722,   113,   113,   903,
     826,   946,   780,    74,  1507,  1714,   771,    74,   113,  2207,
     724,  1284,   797,  2041,   728,  1544,    74,   129,   999,  2443,
    2275,   735,  1612,  2414,  1407,   788,   980,  1957,   196,  2227,
     756,   794,  1082,   815,  1521,   147,  1384,    24,  1088,  2031,
    2032,  2408,  1521,  1779,  1094,   810,   760,  1751,  1521,   795,
     764,  1546,  1521,   799,  1128,   200,   200,   835,  1521,   773,
    1013,   807,   207,   207,   209,   209,   792,    25,  2026,  1521,
     955,    74,    41,    82,    77,   220,  1858,  1859,  1814,   887,
      76,   975,  1818,  1980,  1981,  1982,  1983,    90,   963,   964,
    1174,  1175,    49,   889,   117,   220,   892,   159,    76,   980,
     112,   228,   229,   229,   220,   220,  1128,    92,   886,   136,
     113,    93,    93,   117,  1198,   220,  1138,  1139,    74,   181,
      98,    77,    92,    76,   713,   136,   117,    77,   112,   691,
    2565,   155,   129,    82,    90,   154,   200,    76,  1670,   169,
      89,    41,   888,    92,   160,    98,   194,    33,   155,   212,
     171,   119,  1184,   102,   194,    81,   155,   113,   229,  1548,
      85,   112,   229,   131,   229,  1554,    91,  1645,    28,   286,
     179,   229,   199,    85,    97,    85,   229,   178,   284,   207,
     129,    91,  3153,   196,   827,   202,    76,   290,   199,   138,
     139,   284,  2127,    86,   157,  2130,   316,   365,   147,   148,
     322,    97,   151,  1288,   374,    79,   155,   223,   233,    92,
     159,   374,    74,    85,   322,   164,   150,   220,   162,   332,
     999,   126,   123,   191,    76,  1247,  2161,  2162,   256,   340,
    1966,    85,   181,   231,  1392,   359,    85,   155,   332,   103,
     362,    92,    91,   169,   155,   314,    99,   196,  3223,    56,
     199,   160,   201,  1018,   362,   157,   205,   194,  1492,   436,
    1533,   355,   229,   440,   220,   118,   195,    74,  1249,  1287,
     440,  1429,  1051,   207,   444,    81,   275,  1062,   347,   392,
       8,  2389,   445,  3258,   160,    13,    14,    15,   229,   314,
    1053,   289,  3263,    42,    92,    44,  1059,    25,    26,    27,
    1463,    29,    30,    31,   178,  1049,   409,    35,    36,    37,
     338,   165,   275,   330,   326,   345,    76,   229,   438,   322,
    1085,   334,   256,   392,   340,   259,    28,   438,   445,   394,
    3124,   224,   438,   340,  1099,   221,    76,   336,  1101,  2367,
     308,   231,   326,   155,   208,   438,   347,   223,   212,   229,
    1115,  2825,   229,  2827,   384,  1952,   359,   229,   377,   362,
    1863,  1611,  1612,   169,   275,   225,   322,   229,  1453,    92,
    2074,   300,  1622,  1623,  1537,   326,   392,    76,   280,   231,
     244,   445,   445,   404,  1634,  1635,   287,   229,   385,   408,
     414,   398,   445,   417,  1478,  1479,   400,   445,  1648,  1649,
    1146,   291,  1486,   359,   338,   445,   362,   394,   997,   359,
     414,   973,   439,   417,   441,   438,   365,   441,  1164,   345,
     388,  2676,  2677,   414,   406,   407,   417,   352,   439,  2864,
     441,   438,  1317,   445,   438,  2365,  2366,   374,   434,   291,
     363,   553,   352,    76,  2374,   432,  2150,   438,   417,  1481,
     394,   436,  1947,  1406,  1339,  1705,   434,   438,   332,   417,
     417,   445,  1270,  1271,  1358,  1346,   436,   363,  1343,   374,
    1249,   231,   212,   347,   441,  1858,   410,  1825,   431,   432,
     433,   434,   112,   392,   725,   349,  2222,  1561,   130,   730,
     731,   231,   431,   432,   433,   434,   414,  2026,  2456,   417,
     441,  2398,  2460,   352,   438,   417,  2464,  2289,  2217,  2291,
     422,  2941,   119,   178,   414,   321,   392,   417,   430,  1464,
    1302,  2225,   422,   225,   424,   415,   275,  3321,   136,   441,
     430,   173,   231,   149,    11,   425,   426,   427,  1560,   429,
     430,   431,   432,   433,   434,   417,   787,  1569,   256,   439,
     422,   291,   394,   436,  1638,  1639,   439,   440,   430,   155,
    2990,   441,   445,   415,   441,  3039,   711,   781,   299,   441,
     155,    17,    49,   425,   426,   427,   304,   429,   430,   431,
     432,   433,   434,   196,   191,   436,   711,   439,   439,   440,
     345,   199,  1388,   715,   445,   711,   711,  3021,   231,   215,
    2382,  1380,   414,   177,   553,   417,   711,   715,  2999,   251,
     422,  2546,   780,   781,  2549,  2550,  2551,  2552,  2553,  2554,
    2555,  2556,  2557,  2558,  2991,   111,  1422,   275,   159,   691,
     338,  2739,  2740,  2741,  2742,  2743,  1421,   267,   436,   691,
    1384,   439,   440,   165,   812,   406,   194,   445,   597,   598,
    1446,     0,  2388,   227,  2043,  2044,   384,   299,   291,   131,
    2442,   233,  2597,  2598,   212,   313,   307,   835,  3098,   429,
     430,   431,   432,   433,   434,   415,   431,  2206,   291,   275,
    1584,   150,   347,   155,   445,   425,   426,   427,  2220,   429,
     430,   431,   432,   433,   434,   280,   326,   183,  2087,   230,
    1465,   308,  2180,   159,  1469,   157,   374,   113,   711,   440,
     280,  1354,   715,   436,   433,   345,   439,   440,   886,   198,
     294,   440,   445,   256,   210,   367,   259,   369,   289,  1473,
     429,   430,   431,   432,   433,   434,   377,   155,   207,   748,
     105,   336,   314,   160,   889,   889,   359,   892,   892,   365,
     366,   158,   169,   275,   816,   711,   818,   425,   820,   715,
     356,   194,   284,   359,   826,   827,   218,   408,   148,   248,
    2798,   720,   721,   722,   230,   724,  2673,   726,   727,   728,
     729,   388,   415,   732,   733,   734,   735,   256,   904,   164,
    2720,  2721,  1557,   426,   427,  1813,   429,   430,   431,   432,
     433,   434,   209,   275,   753,   338,  1520,   756,    17,   758,
     228,   760,   407,   387,   220,   764,   765,   766,  1581,  2811,
     769,    76,   771,   275,   773,   125,   201,   154,  2763,   406,
     248,   780,   781,   160,  1580,    90,  1582,  1583,   229,  1585,
     789,   327,   142,   792,   414,   854,   795,   417,   105,   299,
     799,   800,  1797,   339,   154,   804,   805,  2815,   807,  1813,
    1645,   810,  2820,  2486,  1914,  1915,  2824,   353,   445,   338,
     879,   119,  3239,   445,   360,   255,   299,   257,   126,   828,
     829,   890,   891,   131,   946,   366,   835,  2276,   305,   368,
     147,   370,   417,  2143,   946,   345,   223,   422,   321,  2062,
     198,   904,   185,   203,  1049,  2288,   131,   856,   189,   858,
     972,   973,   861,   975,  2164,   245,   160,   403,   980,   189,
     972,   973,  2409,   975,  1049,  1704,  2516,  2456,   980,  1673,
    2409,  2460,   105,  1049,  1049,  2464,  2409,   886,   887,   888,
    2409,   158,   891,   191,  1049,   299,  2409,   307,   904,  1226,
     248,  3050,  2341,  2342,   963,   964,   286,  2409,  2208,  2209,
    2895,  2896,  2542,  1908,   245,   222,  1911,  1912,   285,    83,
     437,   200,   289,   198,   147,   245,   231,   340,   445,   223,
     209,  1624,  1625,  1626,   377,  1153,  2566,   101,  3243,  1632,
     215,   345,   209,  1636,  1637,   413,   414,   280,   416,   417,
    1643,   284,  1129,  1129,   422,   286,   424,  1753,  2744,  1652,
     267,  1654,   430,   340,   963,   964,   286,   377,   967,  3274,
       5,  1148,  1148,   248,  1667,  2955,  1669,  2957,  2958,   160,
     179,  3229,   276,   277,  1812,   398,   291,   139,   150,   988,
     158,  1168,   991,    28,    28,   994,  1049,   195,   408,   222,
    3290,   377,    76,  2034,    39,    39,   126,   441,  1129,  1186,
     308,   131,  1129,   341,   213,   392,  3264,  1447,   293,  1018,
     368,  1129,   370,   401,    98,   438,   178,   828,  3036,    76,
     337,  1825,   408,  2472,   186,  2474,  2475,   442,   366,  1216,
    3330,   209,   223,  1049,   267,   207,   340,   441,   381,  1226,
     851,  1827,   747,  3131,   402,    76,   389,    45,  1822,   406,
     407,   438,  1826,  1122,  1063,   299,  3356,   441,  1067,   221,
    2509,   324,  1071,  3058,   402,  3060,  1872,    98,  1077,  1843,
     775,   116,   116,  3068,  3069,  1515,  1085,   321,  1884,  1519,
     388,   438,   345,   368,   256,   370,   277,   259,   392,  1529,
    1099,  1100,  1898,  1102,   379,   415,  1902,  1871,   425,  1873,
     415,   345,   321,   388,   337,   324,  1115,   446,  2441,   436,
     425,   426,   427,   440,   429,   430,   431,   432,   433,   434,
    3110,  1308,  1309,   168,  1311,   443,   345,   445,  1137,  1954,
    1955,  1905,   357,   358,   438,   341,  1321,  1146,  1147,   417,
     121,  1442,  1151,   406,   442,  1321,  1321,   231,   232,   340,
     140,   225,  1161,  2745,  2923,  1164,   439,  1166,  1932,  1228,
     366,  1935,   445,  1937,   299,  1287,   338,  1289,  1290,  1341,
    1239,   121,   394,   150,   231,  1287,  3171,  1289,  1290,  1384,
     225,   225,  1009,  1388,  1388,   437,   321,   406,   414,   414,
    1372,   417,   417,   445,   278,  2034,   402,  1900,   441,  1384,
     231,   392,   445,  1379,  1372,   195,  1033,   400,  1384,  1384,
    1332,    20,   438,  2051,  1041,  1284,   439,  1422,  1422,  1384,
    1332,   414,   445,  2661,   417,   414,  2815,    38,   417,   219,
     207,  2820,  1354,  2796,   291,  2824,  1358,   436,   410,   438,
    1362,  1446,  1446,  2218,   234,   438,  1358,   438,     7,   438,
    1362,    10,   242,   406,   407,  1592,   289,  2508,  1321,  1322,
    1323,  1270,  1271,    22,    23,   289,  1969,  2577,  1473,   299,
      76,  1974,    76,   263,  1343,  1284,  2570,  2571,   299,   256,
    1289,  1290,   259,   414,    43,   438,   417,    46,  1473,   195,
    1299,   321,    98,  2067,    98,   299,    81,  1473,  1473,   103,
     321,  2893,    87,   324,  2382,  1321,  1322,  1323,  1473,  1372,
     165,  2085,   439,   219,   438,  1606,  1379,   321,   445,   414,
    2325,  1384,   417,    76,   345,   441,  2331,  2332,   234,   445,
     185,   299,  1341,   119,  1343,  2180,   242,    90,   123,   329,
     299,   345,  1464,   438,   379,   429,   430,   431,   432,   433,
     434,   136,  1464,   321,   439,   441,  1372,  1544,   415,   445,
     445,   338,   321,  1379,   414,  1374,   441,   417,  1384,   155,
     445,   323,   429,   430,   431,   432,   433,   434,   133,   164,
    2829,   314,    88,    89,   169,   406,   345,   172,   438,   322,
    2235,  2094,  2930,  2142,   414,  2144,  2145,   417,   429,   430,
     431,   432,   433,   434,   368,  1592,   370,   166,   212,   342,
    1473,   414,  1421,   414,   417,  1430,   417,   311,   438,  1434,
     275,  1436,   412,   329,  2310,   280,    76,   231,   232,   284,
    3019,  2237,   215,   410,   415,   438,   438,   438,  3121,   414,
      90,   368,   417,   370,   425,   426,   427,  3036,   429,   430,
     431,   432,   433,   434,  1576,   413,  1465,  1473,   416,   237,
    1469,   438,   436,   438,  1533,   415,   440,   414,  1673,  2255,
     417,   445,   416,   417,   278,   425,   426,   427,   231,   429,
     430,   431,   432,   433,   434,   229,   439,   291,  1673,   275,
    1677,   438,   445,   310,   280,  2640,  3088,  1673,  1673,    81,
     289,    93,  1624,  1625,  1626,    87,  2312,  2313,  1673,   414,
    1632,  1520,   417,  1522,  1636,  1637,  2219,   439,   194,   111,
    2294,  1643,   308,   445,  1533,     2,   381,   116,   117,   439,
    1652,   317,  1654,   438,   389,   445,   321,  2382,   291,   414,
    1549,   123,   417,   414,   439,  1667,   417,  1669,  1557,   414,
     445,    99,   417,  1562,   136,   414,   417,   422,   417,   424,
     345,   422,  1631,   424,  1746,   430,   411,   417,   730,   430,
     233,  1580,   422,  1582,  1583,   292,  1585,  2381,  1746,   439,
     430,   231,   164,  1592,  1812,   445,   440,   169,   439,   751,
     172,   183,  1714,   439,   445,   289,  1780,  1606,  1782,   445,
    1609,    76,   388,   439,   374,    82,   439,   439,   289,   445,
    1673,   415,   445,   445,  2724,    90,   439,   436,   210,   438,
    1825,   440,   445,  2805,   411,   429,   430,   431,   432,   433,
     434,  2470,   439,  3192,  3193,  3224,  1645,  3196,   445,  3198,
    1825,   291,   439,  2238,  2239,   237,   439,   439,   445,  1825,
    1825,   414,   445,   445,   417,   406,   407,  1673,   406,   407,
    1825,  1730,   415,  2486,   439,   439,   414,   406,   407,   417,
     445,   445,   425,   426,   427,  1797,   429,   430,   431,   432,
     433,   434,   844,  1746,  2387,  1797,  2389,  3344,   850,  2026,
     438,  1813,    99,  1815,   439,  1817,   411,  1706,   860,  2524,
     445,  1813,   179,  1815,   233,  1817,   439,   439,   406,   407,
     406,   407,   445,   445,  2488,   150,    76,  1780,   414,  1782,
    3169,   417,   429,   430,   431,   432,   433,   439,   406,   407,
    1746,  1992,   439,   445,  1803,   327,  2510,   439,   422,  1748,
     424,   903,   438,   445,  1753,   345,   908,   339,   431,   439,
     429,   430,   431,   432,   433,   445,   231,   919,   437,  1155,
    1156,   353,  1825,   345,  1780,   415,  1782,   439,   360,  3079,
     193,  3309,   207,   445,   439,   425,   426,   427,  1900,   429,
     430,   431,   432,   433,   434,   414,  1908,   439,   417,  1911,
    1912,    85,   177,   422,  1803,   424,  1908,  1806,   441,  1911,
    1912,   430,    82,  1812,   189,   109,   439,  1308,  1309,  1825,
    1311,   403,   445,  1822,  1823,   431,   291,  1826,  1827,   439,
     121,   256,  1831,  2051,   259,   445,  2529,  2164,  1837,   439,
     442,   439,   439,  1842,  1843,   445,  2539,   445,   445,  2026,
     439,   442,   227,   439,   225,   439,   445,  1969,   374,   445,
     130,   445,  1974,  1308,  1309,   374,  1311,   137,   138,   443,
     245,   445,  1871,  1872,  1873,  1874,  1875,   374,  1877,  1878,
     374,   231,   431,   432,   433,  1884,   368,   368,   370,   370,
    2240,  2241,  2201,  2202,   439,   439,   441,   441,   374,  1898,
    1052,   175,  1961,  1902,   174,    93,  1905,  1906,  1907,   965,
     966,   286,   921,   338,   923,  2461,   110,  2463,   109,   294,
    1919,  1920,  1921,   394,  1923,  1924,  1925,  1926,  1927,  1928,
    1929,   446,   225,  1932,  1933,   231,  1935,  1936,  1937,   105,
     374,   291,   212,  1095,  1096,  1097,   216,   438,   438,   438,
     415,   438,   438,   299,   148,  1954,  1955,   440,   438,  2018,
     425,   426,   427,   111,   429,   430,   431,   432,   433,   434,
    1969,   440,   321,   345,   438,   141,   289,   243,   441,   438,
     283,   237,  2094,   253,   406,   410,   438,  2164,   413,   414,
     119,   416,   417,  1145,  1993,   161,   406,    93,   268,   269,
    2177,   271,   272,   406,   274,    99,    99,   299,   237,  2008,
     176,  1163,   387,   394,  2013,   438,  2015,   445,   438,  2196,
     214,   289,   289,   190,   190,   243,   189,   438,  2027,  2206,
     438,   301,  2031,  2032,   438,   183,   438,   438,   438,   205,
     304,  2734,  2041,   438,   438,   438,  2739,  2740,  2741,  2742,
    2743,   438,  2051,   438,  2747,   438,   438,    93,   438,   438,
     330,   255,   210,   257,   439,   415,   243,   445,  2067,   438,
     438,   438,  1076,   267,  2838,   425,   426,   427,   438,   429,
     430,   431,   432,   433,   434,   438,  2085,   438,   231,   189,
     438,   431,   362,   225,   364,  2930,   338,   259,   445,   154,
      41,   440,    17,   393,   445,  2217,  1110,  2219,   438,  2221,
     438,    82,   438,  3326,   280,   374,   386,   374,    89,  2221,
     440,   287,   374,   393,   415,   374,   396,   374,   289,   339,
     280,   325,   393,   374,   425,   426,   427,   374,   429,   430,
     431,   432,   433,   434,   374,  1297,    93,   313,   367,   374,
     445,   394,   374,  2152,   374,   336,   126,   445,   129,   289,
     354,   375,   379,   379,   111,   374,   374,   374,  1647,   374,
    2934,   336,   289,   438,    93,   438,   147,   148,   326,   327,
    2944,  2180,  2946,   231,   155,  2449,  2381,  3141,   159,   287,
     438,   339,   111,   438,   400,    93,    83,   155,  2310,   438,
     438,   402,   251,   438,   438,   353,  2381,   189,   179,   289,
     181,    93,   360,  2325,   337,  2381,  2381,    93,   405,  2331,
    2332,   394,  2221,  2325,   691,   196,  2381,  2226,    17,  2331,
    2332,  2449,   445,  3029,   445,   425,   183,   374,  2237,   398,
     438,   279,   194,  3039,  2937,   438,   404,   140,   372,    76,
     372,   372,   438,   445,   345,   403,  2255,  2950,   438,  2436,
    2436,   374,   194,   210,   183,   425,   445,   377,   439,   445,
    2382,   227,  2449,  2449,   290,  2387,  2275,  2389,  2605,  2456,
    2382,   748,   284,  2460,   245,   436,  3050,  2464,  2400,   445,
     237,   210,   439,    38,   432,  2294,  2295,  2296,  2607,  2608,
    2609,  2610,   195,   439,   130,   438,   235,    76,  3121,   235,
     438,   280,   280,  2312,  2313,   280,   289,   295,   237,   336,
     374,  2498,  2498,   374,   439,   445,   219,   445,  2381,    98,
     414,   245,   391,  3148,   103,   301,   109,   301,   366,   314,
     321,   234,  2401,    93,   394,   231,   231,   231,   425,   242,
     436,   374,   374,   245,   425,   189,   289,   293,    93,   203,
     206,   206,   445,   439,  3160,   189,   439,    11,  2367,    82,
     263,    76,   200,   445,   439,  2381,   289,  1381,   258,   445,
     327,  2440,  2441,   109,   194,    90,   439,   854,   445,   194,
    2389,   411,   339,    98,   365,   439,   289,   439,   103,   439,
    1552,  1553,   439,  2402,  2403,  2404,   353,   439,   327,   439,
    3225,   411,   879,   360,   439,   439,  1420,  2529,   439,   411,
     339,   439,    17,   890,   891,   439,   439,  2539,  2605,   439,
     438,   374,  1584,   438,   353,   439,   329,   425,  2437,   208,
     439,   360,  2441,   212,  1596,   441,    34,   445,   439,   439,
    2449,  2450,   441,   245,  2453,   438,   403,   221,  1462,   406,
     280,   438,   231,   232,   299,   374,   374,   407,  2467,   231,
     231,   259,   439,   289,  3309,   244,   439,    76,   384,   436,
     439,   323,   394,   438,   403,   439,   439,   287,   287,  2488,
     439,   374,   289,   438,   445,  3308,   963,   964,   234,    98,
    2499,   394,   296,   208,   103,   972,   973,   212,   975,   278,
    1514,  2510,   234,   980,   438,   445,   439,   292,   425,   412,
     178,   178,   291,   439,  2583,  2524,   231,   232,  3341,   175,
     194,   436,    76,   189,   117,   439,   439,   439,   438,   244,
     439,   202,  1546,   439,   445,   415,   425,  1551,  1700,  2661,
     425,   374,   374,   336,   221,   384,   374,   438,    74,  2661,
     374,    77,   374,   231,   162,   439,   231,   438,   231,   437,
     275,    93,   189,   278,    90,   235,   293,   176,   217,   394,
     349,    93,   553,    93,   397,   438,   291,   445,   293,   438,
     438,   234,  3285,  3286,   199,   438,   284,   113,   194,   439,
    1752,   439,   439,   439,   194,   438,   109,   439,   438,   208,
     204,   280,   394,   212,  2791,  2791,  2728,   231,   280,   157,
     437,   218,  2734,   196,   196,  1076,  2728,  2739,  2740,  2741,
    2742,  2743,   231,   232,   194,  2747,   215,   394,  2815,   610,
     170,   180,   156,  2820,   349,   244,   415,  2824,  2127,   439,
     156,  2130,   438,   194,   236,  1122,   425,   426,   427,  1110,
     429,   430,   431,   432,   433,   434,   374,  1671,   438,   189,
     292,   438,   317,   439,    93,   367,   280,  2676,  2677,   278,
     254,   312,  2161,  2162,   200,   287,   287,   439,    96,   289,
     189,   207,   291,   209,    93,   128,   289,   367,   170,   280,
     289,   438,   289,   166,   220,   445,   332,   392,   160,   333,
     415,   445,  2711,  2712,   333,   180,    80,   438,   229,   439,
     425,   426,   427,  1290,   429,   430,   431,   432,   433,   434,
     316,  1991,   312,  2221,   439,  1876,  1931,  1919,  2797,  2335,
    2739,  2740,  2741,  2742,  2743,  2783,   291,  2786,  2704,  2984,
     349,  2272,  3271,  2793,  3299,  3254,  3253,  3280,    76,  3138,
    3214,  1228,  2788,  2762,  1530,  3014,  1977,  3356,  3330,  2968,
    2967,  2381,  1239,  3311,  1516,  3357,   181,   748,  2838,  2069,
      98,  1147,  2781,  3224,  2783,   103,  1859,  2786,  1858,  2788,
    2288,  2803,  3021,  3200,  2793,  3320,  3355,   902,  1984,  2798,
    1752,   157,  2499,  2049,  1129,  2832,   322,  2242,  2232,   780,
     781,  2923,  2811,  1316,  2813,  1315,   415,  1284,  2995,  2995,
    1287,  2923,  1289,  1290,  1765,  2937,  2825,  1749,  2827,  2026,
     429,   430,   431,   432,   433,   434,  1287,  1989,  2950,  2838,
    2206,   812,  2781,   359,  2462,   816,   362,   818,  3037,   820,
    1489,  2582,  2382,  2177,  2175,   826,   827,  2900,  2096,  3036,
    2012,  3237,  1701,  2927,   835,  2924,   119,  2019,  2226,  3049,
     415,  2842,  1100,   970,  1806,  1803,  1343,  1356,   131,  1323,
     425,   426,   427,   854,   429,   430,   431,   432,   433,   434,
     208,  1358,    74,   323,   212,  1362,  1778,   695,  1153,   998,
    1813,  2057,   155,  2962,   157,   966,  2922,  2216,   879,  2058,
    2833,  1268,  2644,   231,   232,   886,   887,  2834,   358,   890,
     891,  2052,  1321,  1817,  1575,   972,   244,     2,  2927,    -1,
    1381,  2930,    -1,  2932,    -1,  2934,  2935,  2936,    84,    -1,
      -1,    -1,    -1,  1947,    -1,  2944,  2945,  2946,  1952,    95,
      -1,    -1,  2951,    -1,    -1,    -1,  1407,   275,    -1,    -1,
     278,  3020,    -1,  1967,    -1,   218,    -1,    -1,   114,  1420,
      -1,  3083,    -1,   291,    -1,   946,    -1,    -1,    -1,    -1,
      -1,  3083,    -1,    -1,    -1,   131,    -1,   133,    -1,  3166,
    3166,    -1,   963,   964,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,    -1,  3332,    -1,    -1,    -1,   155,
      -1,  1462,    -1,    -1,    -1,  3014,    -1,    -1,    -1,    -1,
    3019,   167,   275,    -1,    -1,    -1,    -1,   280,    -1,    -1,
    3029,   349,    -1,    -1,  2038,    -1,    -1,    -1,  1489,    -1,
    3039,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2200,    -1,
     196,  3050,   198,    -1,    -1,   308,   202,    -1,    -1,    -1,
      -1,    -1,    -1,  1514,   317,    -1,  1533,  2546,    -1,   215,
    2549,  2550,  2551,  2552,  2553,  2554,  2555,  2556,  2557,  2558,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3146,    -1,    -1,
      -1,   237,    -1,    -1,    -1,  1546,    -1,   415,    -1,    -1,
    1551,    -1,   248,    -1,    -1,    -1,    -1,   425,   426,   427,
      -1,   429,   430,   431,   432,   433,   434,    -1,  2597,  2598,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,
      -1,    -1,  3131,    -1,  3133,   388,    -1,    -1,    -1,    95,
      -1,    -1,    -1,  3320,    -1,   291,    -1,   293,    -1,  3148,
      -1,  1122,    -1,  3152,  3153,  3332,    -1,    -1,   114,    -1,
      -1,  3160,    -1,    -1,  1631,   311,    -1,    -1,    -1,  1140,
      84,    -1,  1143,  3285,  3286,    -1,    -1,   133,  3355,    -1,
      -1,  3240,  1153,    -1,   330,  3244,    -1,    -1,   334,    -1,
     336,    -1,    -1,   149,    -1,   711,    -1,    -1,    -1,   715,
     114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3208,
      -1,   167,   126,    -1,  3213,    -1,    -1,    -1,    -1,   133,
    1671,   367,   368,    -1,   370,  3224,  3225,    -1,    -1,    -1,
      -1,    -1,    -1,   379,    -1,   149,    -1,   383,   384,    -1,
     196,    -1,   388,    -1,  3243,    -1,   202,   393,    -1,    -1,
      -1,    -1,    -1,   167,    -1,    -1,    -1,  1228,    -1,   215,
      -1,  2413,  3261,  1730,  3263,    -1,    -1,  2419,  1239,    -1,
      -1,    -1,    -1,    -1,    -1,  3274,    -1,    -1,    -1,    -1,
      -1,    -1,   196,    -1,  2763,    -1,    -1,    -1,    -1,    -1,
      -1,  3290,    -1,    -1,  1265,    -1,    -1,    -1,    -1,  1270,
    1271,   215,  2306,    -1,  2308,    -1,    -1,    -1,    -1,    -1,
    3309,    -1,    -1,  1284,    -1,    -1,  1287,    -1,  1289,  1290,
      -1,    -1,    -1,    -1,   238,    -1,    -1,    -1,    -1,    -1,
    2334,  3330,    -1,    -1,    -1,   291,  1803,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1813,    -1,  1815,    -1,
    1817,    -1,    -1,    -1,    -1,   311,  2508,  3356,    -1,    -1,
    2364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1341,    -1,  1343,   889,   330,    -1,   892,   291,   334,    -1,
     336,    -1,    -1,  1354,    -1,   341,    -1,    -1,   904,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   311,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1858,  1859,    -1,
     366,   367,    -1,  2417,    -1,    -1,  2895,  2896,    -1,    -1,
     334,    -1,   336,   379,  2428,    -1,    -1,   341,   384,    -1,
    1897,    -1,    -1,    -1,    -1,    -1,    -1,   393,    -1,    -1,
      -1,    -1,    76,    -1,    -1,    -1,   402,    -1,    -1,    84,
      -1,    -1,   366,    -1,    -1,    -1,    90,    -1,    -1,    -1,
    2612,  2613,    -1,    -1,    98,   379,    -1,    -1,    -1,   103,
     384,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1953,    -1,   402,    -1,
    1957,    -1,    -1,  1464,  1961,    -1,  1947,    74,   133,    -1,
      77,  1952,  1969,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    90,   149,    -1,  1967,    -1,  2522,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,   167,  1049,    -1,  2002,   113,    -1,    -1,    -1,
      -1,  2545,    -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,
      -1,  2018,   129,    98,    -1,    -1,    -1,    -1,   103,    -1,
      -1,   196,  1533,    -1,    -1,    -1,    -1,   202,  2572,    -1,
     147,    -1,    -1,    -1,   208,    -1,    -1,    -1,   212,  3058,
     215,  3060,    -1,    -1,    -1,    -1,    -1,  2038,    -1,  3068,
    3069,  2595,    -1,    -1,  2746,    -1,    -1,   231,   232,    -1,
      -1,    -1,   237,    -1,  1575,  1576,    -1,    -1,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,    -1,  2769,    -1,    -1,
      -1,    -1,    -1,   200,    -1,  2777,    -1,    -1,    -1,    -1,
     207,    -1,   209,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   275,    -1,   220,   278,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1624,  1625,  1626,   291,   291,    -1,   293,
    1631,  1632,    -1,   208,    -1,  1636,  1637,   212,    -1,    -1,
      -1,    -1,  1643,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1652,    -1,  1654,    -1,    -1,   231,   232,    -1,    -1,
      -1,    -1,  3171,    -1,    -1,   330,  1667,    -1,  1669,   244,
      -1,   336,    -1,  2707,    -1,    -1,   341,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   349,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1700,
     275,   366,   367,   278,    -1,  1706,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1714,   379,   322,   291,    -1,   293,   384,
      -1,    -1,    -1,    -1,  2221,    -1,    -1,    -1,   393,  1730,
    2912,  2913,  2914,  2915,    -1,    -1,    -1,    -1,    -1,    -1,
    2774,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   415,   359,    -1,    -1,   362,    -1,    -1,    -1,    -1,
      -1,   425,   426,   427,    -1,   429,   430,   431,   432,   433,
     434,   136,    -1,   437,   349,  1321,  1322,  1323,    -1,    -1,
      -1,    -1,   446,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    -1,  1797,    -1,    -1,    -1,
      -1,    -1,  1803,    -1,    -1,    -1,    -1,  2288,  2289,    -1,
    2291,  1812,   177,    -1,  2311,    -1,    98,    -1,    -1,    -1,
    2317,   103,  2319,    -1,   189,  2306,  1372,  2308,    -1,   194,
      -1,    -1,    -1,  1379,   199,    -1,    -1,   202,  1384,   204,
     415,    -1,  1388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     425,   426,   427,  2334,   429,   430,   431,   432,   433,   434,
      -1,    -1,   227,    -1,    -1,    -1,  2900,    -1,  2365,  2366,
     445,    -1,    -1,    -1,    -1,    -1,  1422,  2374,    -1,    -1,
     245,    -1,    -1,  2364,    -1,  2382,    -1,    -1,    -1,    -1,
      -1,    -1,  2389,    -1,   176,    -1,    -1,    -1,    -1,  1900,
    1446,  2382,    -1,  2400,  2401,    -1,    -1,  1908,    -1,    -1,
    1911,  1912,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   286,    -1,    -1,    -1,    -1,   208,  1473,    -1,   294,
     212,    -1,    -1,    -1,    -1,    98,  2417,    -1,    -1,    -1,
     103,  3123,    -1,  2440,  2441,    -1,   553,  2428,    -1,   231,
     232,    -1,  1953,    -1,    -1,    -1,  1957,    -1,    -1,  3141,
    1961,  2442,   244,    -1,    -1,    -1,    -1,    -1,  1969,    -1,
      -1,    -1,    -1,  1974,  3156,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   278,    -1,    -1,    -1,
      90,   366,    -1,    -1,  3186,    -1,    -1,  3041,    98,   291,
      -1,    -1,    -1,   103,    -1,    -1,    -1,  2018,    -1,    -1,
      -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3067,    -1,    -1,    -1,    -1,    -1,    -1,
     405,  2522,    -1,    -1,    -1,   208,    -1,    -1,    -1,   212,
    2051,  2052,    -1,    -1,  2055,    -1,  2057,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2545,    -1,    -1,   349,   231,   232,
      -1,   436,    -1,    -1,   439,   440,   441,    -1,    -1,    -1,
      -1,   244,    -1,    -1,    -1,    -1,  2583,    -1,    -1,    -1,
      -1,  2572,    -1,  2094,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   711,    -1,    -1,    -1,   715,    -1,
      -1,    -1,   719,    -1,  2595,   278,   723,    -1,   208,    -1,
      -1,    -1,   212,    -1,    -1,    -1,    -1,  1673,   291,    -1,
      -1,    -1,    -1,   415,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   231,   232,    -1,    -1,   752,    -1,   429,   430,   431,
     432,   433,   434,    -1,   244,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2661,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   785,    -1,
      -1,   788,    -1,    -1,    -1,   275,   349,   794,   278,    -1,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1746,   291,    -1,   293,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,    -1,  2217,   103,  2219,    -1,
    2221,    -1,    -1,  2720,  2721,    -1,  2707,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1780,    -1,  1782,    -1,    -1,    -1,
      -1,    -1,  2739,  2740,  2741,  2742,  2743,    -1,    -1,    -1,
      -1,    -1,   415,  3287,    -1,    -1,    -1,    -1,    -1,   349,
      -1,    -1,    -1,   426,   427,    -1,   429,   430,   431,   432,
     433,   434,    -1,    -1,    -1,    -1,    76,   884,    -1,  1825,
     887,    -1,   889,    -1,    -1,   892,    -1,    -1,    -1,    -1,
      90,    -1,    -1,  2774,    -1,    -1,    -1,   904,    98,    -1,
    2797,    -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,  2310,
    3344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   208,    -1,  2325,   415,   212,    -1,    -1,    -1,
    2331,  2332,    -1,    -1,    -1,   425,   426,   427,    -1,   429,
     430,   431,   432,   433,   434,   231,   232,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   445,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,  2365,  2366,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2374,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2382,    -1,    -1,    -1,    -1,  2387,    -1,  2389,   275,
      -1,    -1,   278,    -1,    -1,    -1,    -1,    -1,    -1,  2400,
    2401,    -1,    -1,    -1,    -1,   291,    -1,   293,   208,    -1,
      -1,    -1,   212,    -1,    -1,    -1,    -1,    -1,   136,  2900,
      -1,    -1,    -1,    -1,    -1,    -1,  2923,  2924,    -1,    -1,
      -1,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,  2440,
    2441,  1048,  1049,    -1,   244,    -1,  1053,    -1,  2449,    -1,
      -1,    -1,  1059,    -1,    -1,    -1,    -1,    -1,  2955,   177,
    2957,  2958,    -1,   349,    -1,  2962,    -1,    -1,    -1,  1076,
      -1,   189,    -1,    -1,    -1,   275,   194,    -1,   278,    -1,
      -1,   199,    -1,    -1,   202,    -1,   204,    -1,    -1,    -1,
      -1,   291,    -1,   293,  1101,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1110,    -1,    -1,    -1,    -1,    -1,   227,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3020,    -1,    -1,    -1,   245,  2529,   415,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2539,   425,
     426,   427,    -1,   429,   430,   431,   432,   433,   434,   349,
      -1,    -1,    -1,   439,    -1,    -1,    -1,    -1,    -1,    -1,
    3041,    -1,    -1,    -1,    -1,  1172,    -1,    -1,   286,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   294,    -1,    -1,    -1,
      -1,    -1,  2583,    -1,    -1,    -1,  3067,    -1,    -1,    -1,
      -1,    -1,  1199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3110,    -1,   415,  1223,  1224,    -1,  1226,
      -1,    -1,    -1,    -1,    -1,   425,   426,   427,    -1,   429,
     430,   431,   432,   433,   434,    -1,    -1,  1244,    -1,   439,
      -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,   366,  3146,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,
      -1,    -1,    -1,  1270,  1271,    98,    -1,    -1,    -1,   387,
     103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1287,    -1,    -1,    -1,    -1,    -1,    -1,   405,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1310,    -1,    -1,  1313,  1314,    -1,    -1,
      -1,    -1,    -1,    -1,  1321,  1322,  1323,    -1,   436,  2720,
    2721,   439,   440,   441,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2734,  1341,    -1,    -1,    -1,  2739,  2740,
    2741,  2742,  2743,  3240,  3241,    -1,  2747,  3244,  3245,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,  1372,    -1,    -1,    -1,    -1,
      -1,    -1,  1379,    -1,  1381,   208,    -1,  1384,    90,   212,
      -1,  1388,    -1,    -1,    -1,    -1,    98,    90,    -1,    -1,
      -1,   103,    -1,    -1,    -1,    -1,  2797,    -1,   231,   232,
    1407,    -1,    -1,    -1,    -1,    -1,  3287,    -1,    -1,    -1,
     113,   244,    -1,  1420,    -1,  1422,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2833,    -1,    -1,  2381,    -1,    -1,    -1,  1446,
      -1,    -1,   275,    -1,    -1,   278,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1462,    -1,    -1,   291,    -1,
     293,    -1,    -1,  3344,    -1,    -1,  1473,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1076,    -1,
      -1,    -1,  1489,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   208,   200,    -1,    -1,
     212,    -1,    -1,    -1,   207,    -1,   209,  1514,    -1,    -1,
      -1,    -1,  1110,    -1,    -1,    -1,   349,   220,    -1,   231,
     232,    -1,  2923,  2924,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   244,    -1,    -1,    -1,  2937,  1544,    -1,  1546,
      -1,    -1,    -1,    -1,  1551,    -1,    -1,    -1,    -1,  2950,
      -1,    -1,    -1,    -1,  2955,    -1,  2957,  2958,    -1,    -1,
      -1,  2962,    -1,   275,    -1,    -1,   278,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1581,    -1,    -1,    -1,    -1,   291,
      -1,   293,   415,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   425,   426,   427,    -1,   429,   430,   431,   432,
     433,   434,    -1,    -1,  1611,  1612,   439,    -1,    -1,    -1,
      -1,    -1,  1619,    -1,    -1,  1622,  1623,    -1,    -1,  3020,
      -1,    -1,    -1,    -1,  1631,    -1,    -1,  1634,  1635,    -1,
      -1,    -1,    -1,    -1,    -1,  1642,    -1,   349,    -1,  1646,
    1647,  1648,  1649,    -1,    -1,    -1,    -1,    -1,    -1,  1656,
    1657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1671,  1672,  1673,    -1,    -1,  1676,
      -1,    -1,    -1,  1680,    -1,    -1,    -1,  1684,    -1,    -1,
    1687,  1688,  1689,  1690,  1691,  1692,  1693,  1694,  1695,    -1,
    1697,    -1,    -1,    -1,  1701,    -1,    -1,    -1,  1705,    -1,
      -1,    -1,    -1,   415,    -1,    -1,    -1,    -1,    -1,  3110,
      -1,    -1,    -1,   425,   426,   427,    -1,   429,   430,   431,
     432,   433,   434,    -1,    -1,    -1,    -1,   439,    -1,     3,
      -1,    -1,    -1,    -1,    -1,     9,    -1,    -1,    -1,  1746,
      -1,    -1,    16,    -1,    18,  3146,    -1,    21,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    32,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1780,    -1,  1782,    50,    51,    -1,    -1,
      -1,    -1,    -1,  1381,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,  1407,
      -1,    -1,    -1,    87,    88,    89,    -1,    -1,  1825,    -1,
      -1,    -1,  1420,    -1,    -1,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,  1840,    -1,    -1,    -1,    -1,    76,  3240,
      -1,    -1,    -1,  3244,    -1,    -1,   120,    -1,   122,   123,
      -1,  1858,  1859,   127,   128,    -1,    -1,    -1,    -1,    -1,
      98,   135,   136,    -1,  1462,   103,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   149,    -1,   151,    -1,    -1,
     154,    -1,    -1,    -1,  3285,  3286,   160,    -1,    98,  3290,
      -1,  1489,    -1,   103,    -1,   169,    -1,    -1,    -1,    -1,
      -1,   175,    -1,    -1,    -1,    -1,   180,    -1,   182,    -1,
      -1,    -1,   186,    -1,    -1,    -1,  1514,    -1,    -1,    -1,
      -1,    -1,    -1,   197,    -1,   199,    -1,    -1,    -1,  3330,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   176,  1946,
    1947,    -1,    -1,    -1,    -1,  1952,    -1,    -1,  1546,   223,
      -1,    -1,    -1,  1551,    -1,  3356,    -1,    76,  1965,    -1,
    1967,    -1,    -1,    -1,    -1,    -1,   176,    -1,    -1,    -1,
     208,    90,   246,   247,   212,    -1,    -1,    -1,   252,    98,
      -1,    -1,    -1,    -1,   103,    -1,   260,    -1,    -1,    -1,
      -1,    -1,    -1,   231,   232,    -1,    -1,    -1,   208,    -1,
      -1,    -1,   212,   277,    -1,    -1,   244,    -1,   711,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   719,    -1,    -1,  2026,
     723,   231,   232,    -1,    -1,    -1,    -1,    -1,  2035,    76,
      -1,  2038,   306,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     278,    -1,    -1,    90,   318,    -1,   320,    -1,    -1,   752,
     324,    98,    -1,   291,   328,    -1,   103,   331,    -1,    -1,
      -1,   335,    -1,    -1,  2071,    -1,   340,    -1,   278,    -1,
      -1,   345,    -1,  1671,   348,    -1,    -1,    -1,    -1,    -1,
     354,   291,    -1,    -1,    -1,   788,    -1,    -1,  2095,   208,
      -1,   794,    -1,   212,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   382,    -1,
     384,   349,   231,   232,    -1,    -1,   390,    -1,   392,    -1,
    2127,   395,    -1,  2130,    -1,   244,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2142,  2143,  2144,  2145,   349,
      -1,    -1,    -1,    -1,  2151,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2161,  2162,   275,  2164,    -1,   278,
      -1,   208,    -1,    -1,   438,   212,    -1,    -1,    -1,  2176,
      -1,  2178,   291,    -1,   293,  2182,    -1,   415,    -1,    -1,
      -1,   884,    -1,    -1,   231,   232,   889,    -1,    -1,   892,
      -1,   429,   430,   431,   432,   433,   434,   244,    -1,  2206,
      -1,  2208,  2209,    -1,    -1,   415,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   429,
     430,   431,   432,   433,   434,  2232,    -1,    -1,   275,    -1,
     349,   278,    -1,  2240,  2241,  2242,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   291,    -1,   293,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1858,  1859,    -1,    76,  2271,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,
      -1,  2288,  2289,    -1,  2291,    98,    -1,    -1,    -1,    -1,
     103,    -1,    -1,    -1,    -1,    -1,   415,    -1,    -1,  2306,
      -1,  2308,   349,    -1,    -1,    -1,   425,   426,   427,    -1,
     429,   430,   431,   432,   433,   434,    -1,    -1,    -1,    -1,
     439,    -1,    -1,    -1,    -1,    -1,    -1,  2334,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1048,  1049,    -1,    -1,  1947,
    1053,    -1,    -1,    -1,  1952,    -1,  1059,  2364,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   415,  1967,
      -1,    -1,    -1,  1076,  2381,  2382,    -1,    -1,   425,   426,
     427,    -1,   429,   430,   431,   432,   433,   434,    -1,    -1,
      -1,    -1,   439,    -1,    -1,   208,    -1,    -1,  1101,   212,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1110,    -1,    -1,
    2417,    -1,    -1,    -1,    82,    -1,    -1,    -1,   231,   232,
      -1,  2428,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   244,    -1,    -1,    -1,  2442,    -1,    -1,    -1,    -1,
    2038,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2456,
      -1,    -1,    -1,  2460,    -1,    -1,    -1,  2464,    -1,    -1,
      -1,    -1,   275,    -1,    -1,   278,    -1,    -1,    76,  1172,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   291,  2486,
     293,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,   159,    -1,    -1,    -1,   103,  1199,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2513,    -1,    -1,    -1,
      -1,   179,  2519,   181,    -1,  2522,    -1,    -1,    -1,    -1,
    1223,  1224,    -1,  1226,  2531,    -1,    -1,    -1,    -1,    -1,
    2537,    -1,    -1,    -1,  2541,    -1,   349,    -1,  2545,  2546,
      -1,  1244,  2549,  2550,  2551,  2552,  2553,  2554,  2555,  2556,
    2557,  2558,    -1,    -1,    -1,    -1,  2563,  2564,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2572,    -1,    -1,   176,    -1,
    2577,    -1,    -1,    -1,    -1,    -1,    -1,  2584,    -1,    -1,
    2587,    -1,  2589,    -1,    -1,    -1,    -1,    -1,  2595,  2596,
    2597,  2598,    -1,    -1,    -1,  2602,    -1,    -1,  2605,    -1,
     208,    -1,   415,    -1,   212,    -1,    -1,  1310,    -1,    -1,
    1313,  1314,   425,   426,   427,    -1,   429,   430,   431,   432,
     433,   434,    -1,   231,   232,    -1,   439,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,  2649,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     278,    -1,    -1,    -1,    90,    -1,    -1,    -1,  1381,    -1,
      -1,  1384,    98,   291,    -1,  1388,    -1,   103,    -1,    -1,
    2288,  2289,    -1,  2291,    -1,    -1,    -1,    -1,    -1,    -1,
    2707,    -1,    -1,    -1,  1407,    -1,    -1,    -1,  2306,    -1,
    2308,    -1,    -1,    -1,    -1,    -1,    -1,  1420,    -1,  1422,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2334,    -1,    -1,    -1,
      -1,   349,    -1,  1446,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    -1,    -1,    -1,    -1,    -1,  2763,    -1,    -1,  1462,
      -1,    -1,    -1,    -1,    -1,    -1,  2364,  2774,    -1,    -1,
    1473,   139,    98,    -1,    -1,    -1,    -1,   103,    -1,    -1,
      -1,    -1,    -1,    -1,  2382,    -1,  1489,    -1,    -1,    -1,
      -1,    -1,   208,    -1,    -1,    -1,   212,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   415,  2815,    -1,
     178,  1514,    -1,  2820,    -1,   231,   232,  2824,   186,  2417,
      -1,   429,   430,   431,   432,   433,   434,    -1,   244,    -1,
    2428,    -1,    -1,    -1,    -1,  2842,    -1,    -1,    -1,    -1,
      -1,  1544,    -1,  1546,  2442,    -1,    -1,  2854,  1551,    -1,
     176,    -1,    -1,   221,   222,    -1,    -1,    -1,    -1,   275,
      -1,    -1,   278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   291,    -1,   293,  1581,    -1,
      -1,    -1,   208,    -1,    -1,    -1,   212,    -1,  2895,  2896,
      -1,    -1,    -1,  2900,    -1,    -1,    -1,    -1,    -1,  2906,
    2907,    -1,    -1,  2910,    -1,   231,   232,    -1,  1611,  1612,
      -1,    -1,    -1,    -1,    -1,    -1,  1619,    -1,   244,  1622,
    1623,    -1,    -1,    -1,  2522,    -1,    -1,    -1,    -1,    -1,
      -1,  1634,  1635,   349,    -1,    -1,    -1,    -1,    -1,  1642,
      -1,    -1,    -1,  1646,  1647,  1648,  1649,  2545,    -1,    -1,
      -1,    -1,   278,  1656,  1657,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   291,    -1,    -1,  1671,  1672,
    1673,    -1,    -1,  1676,  2572,    -1,  2983,  1680,    -1,    -1,
      -1,  1684,    -1,    -1,  1687,  1688,  1689,  1690,  1691,  1692,
    1693,  1694,  1695,    -1,  1697,    -1,    -1,  2595,  1701,   415,
      -1,    -1,  1705,    -1,    -1,    -1,    -1,    -1,    -1,   425,
     426,   427,  3019,   429,   430,   431,   432,   433,   434,    -1,
      -1,   437,    -1,   349,    -1,  3032,    -1,    -1,    -1,  3036,
      -1,    -1,    -1,    -1,  3041,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3049,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3058,    76,  3060,    -1,    -1,    -1,    -1,    -1,    -1,
    3067,  3068,  3069,    -1,    -1,  3072,    90,    -1,    -1,    -1,
      94,    -1,  3079,  3080,    98,    -1,    -1,    -1,    -1,   103,
     748,    -1,  3089,    -1,    -1,    -1,    -1,    -1,    -1,   415,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3107,    -1,    -1,   429,   430,   431,   432,   433,   434,  2707,
      -1,    -1,    -1,    -1,  3121,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1825,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1840,    -1,   163,
      -1,    -1,  3149,    -1,    -1,    -1,    -1,    -1,   816,    -1,
     818,    -1,   820,    -1,    -1,  1858,  1859,    -1,   826,   827,
      -1,    -1,    -1,    -1,  3171,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2774,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   208,    -1,   854,    -1,   212,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   231,   232,    -1,
      -1,   879,    -1,    -1,    -1,    -1,    -1,  3224,    -1,    -1,
     244,    -1,   890,   891,    -1,    -1,    -1,    -1,    -1,    -1,
    3237,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1946,  1947,    -1,    -1,    -1,    -1,  1952,
      -1,   275,    -1,    -1,   278,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1965,    -1,  1967,    -1,    -1,   291,    -1,   293,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   946,    -1,
    3287,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   963,   964,    -1,    -1,    -1,
      76,  3308,  2900,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   980,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,  2026,    -1,   349,    -1,   103,    -1,    -1,
      -1,    -1,  2035,    -1,  3341,  2038,    -1,  3344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   719,    -1,    -1,    -1,   723,    -1,   725,    -1,    -1,
      -1,    -1,   730,   731,    -1,    -1,    -1,    -1,  2071,    -1,
     394,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   751,   752,    -1,    -1,    -1,    -1,    -1,
      -1,   415,  2095,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   425,   426,   427,    -1,   429,   430,   431,   432,   433,
     434,    -1,    -1,   189,    -1,    -1,    -1,    -1,   194,   787,
     788,    -1,    -1,    -1,  2127,    -1,   794,  2130,    -1,    -1,
      -1,    -1,   208,    -1,    -1,    -1,   212,    -1,    -1,  2142,
    2143,  2144,  2145,  3041,    -1,    -1,    -1,    -1,  2151,    -1,
      -1,    -1,    -1,    -1,  1122,   231,   232,    -1,  2161,  2162,
      -1,  2164,    -1,    -1,    -1,    -1,    -1,    -1,   244,  3067,
      -1,    -1,    -1,  2176,    -1,  2178,   844,    -1,    -1,  2182,
      -1,    -1,   850,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   860,    -1,    -1,    -1,    -1,    -1,    -1,   275,
      -1,    -1,   278,  2206,    -1,  2208,  2209,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   291,    -1,   293,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2232,
      -1,    -1,    -1,    -1,    -1,   903,    -1,  2240,  2241,  2242,
     908,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   919,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1228,    -1,    -1,    -1,    -1,    -1,    -1,    76,  2271,    -1,
      -1,  1239,    -1,   349,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    -1,    -1,    93,  2288,  2289,    -1,  2291,    98,
      -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2306,    -1,  2308,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1284,    -1,    -1,  1287,
      -1,  1289,  1290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   415,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   425,
     426,   427,    -1,   429,   430,   431,   432,   433,   434,    -1,
      -1,  2364,    -1,    -1,    -1,    -1,    -1,  1076,    76,    -1,
      -1,    -1,    -1,    -1,    -1,  1343,    -1,    -1,  2381,  2382,
      -1,    -1,    90,    -1,  1052,  1053,  1354,    -1,    -1,  3287,
      98,  1059,    -1,    -1,    -1,   103,    -1,    -1,    -1,   208,
      -1,  1110,    -1,   212,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2417,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   231,   232,    -1,  2428,    -1,  1095,  1096,  1097,
      -1,    -1,    -1,  1101,    -1,   244,    -1,    -1,    -1,  2442,
      -1,    -1,    -1,    -1,    -1,    -1,  3344,    -1,    -1,    -1,
      -1,    -1,    -1,  2456,    -1,    -1,    -1,  2460,    -1,    -1,
      -1,  2464,    -1,    -1,    -1,    -1,   275,    -1,    -1,   278,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1145,    -1,    -1,
      -1,    -1,   291,  2486,   293,    -1,   194,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1163,  1464,    -1,    -1,    -1,
     208,    -1,    -1,    -1,   212,    -1,    -1,    -1,    -1,    -1,
    2513,    -1,    -1,    -1,    -1,    -1,  2519,    -1,    -1,  2522,
      -1,    -1,    -1,   231,   232,    -1,    -1,    -1,  2531,    -1,
      -1,    -1,    -1,    -1,  2537,    -1,   244,    -1,  2541,    -1,
     349,    -1,  2545,  2546,    -1,    -1,  2549,  2550,  2551,  2552,
    2553,  2554,  2555,  2556,  2557,  2558,    -1,    -1,    -1,    -1,
    2563,  2564,    -1,    -1,    -1,  1533,    -1,   275,    -1,  2572,
     278,    -1,    -1,    -1,  2577,    -1,    -1,    -1,    -1,    -1,
      -1,  2584,    -1,   291,  2587,   293,  2589,    -1,    92,    -1,
      -1,    -1,  2595,  2596,  2597,  2598,    -1,    -1,   102,  2602,
      -1,    -1,  2605,    -1,    -1,    -1,   415,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   425,   426,   427,    -1,
     429,   430,   431,   432,   433,   434,    -1,    -1,    -1,  1297,
      -1,    -1,    -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,
      -1,   349,    -1,    -1,   148,    -1,  2649,   151,    -1,    -1,
      -1,   155,    -1,    -1,    -1,   159,  1624,  1625,  1626,    -1,
      -1,    -1,    -1,  1631,  1632,    -1,    -1,    -1,  1636,  1637,
      -1,    -1,  1381,    -1,    -1,  1643,    -1,   181,    -1,    -1,
      -1,    -1,    -1,    -1,  1652,    -1,  1654,    -1,    -1,    -1,
      -1,    -1,   196,    -1,    -1,    -1,    -1,    -1,  1407,  1667,
      -1,  1669,    -1,    -1,  2707,    -1,    -1,   415,    -1,    -1,
      -1,  1420,    -1,    -1,    -1,    -1,    -1,   425,   426,   427,
      -1,   429,   430,   431,   432,   433,   434,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1462,    -1,    -1,    -1,    -1,    -1,    -1,
    2763,    -1,  1730,    -1,    -1,  1076,    -1,    -1,    -1,    -1,
      -1,  2774,    -1,    -1,  1442,    -1,    -1,    -1,    -1,    -1,
    1489,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1110,
      -1,    -1,    -1,    -1,    -1,  1514,    -1,    -1,    -1,    76,
      -1,    -1,  2815,    -1,    -1,    -1,    -1,  2820,    -1,    -1,
      -1,  2824,    -1,    90,    -1,    -1,    93,    -1,    -1,  1797,
      -1,    98,    -1,    -1,    -1,  1803,   103,  1546,    -1,  2842,
      -1,    -1,  1551,    -1,    -1,  1813,    -1,    -1,    -1,    -1,
      -1,  2854,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      -1,   365,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    -1,    -1,  1544,    -1,    -1,    -1,
      -1,    98,    -1,    -1,  1552,  1553,   103,    -1,    -1,    -1,
      -1,    -1,  2895,  2896,    -1,    -1,    -1,  2900,    -1,    -1,
      -1,    -1,    -1,  2906,  2907,    -1,    -1,  2910,    -1,    -1,
      -1,    -1,    -1,  1581,    -1,    -1,  1584,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1596,    -1,
      -1,    -1,  1900,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1908,   208,    -1,  1911,  1912,   212,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1671,    -1,   231,   232,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   244,    -1,    -1,
    2983,    -1,    -1,    -1,    -1,  1953,    -1,    -1,    -1,  1957,
      -1,   208,    -1,  1961,    -1,   212,    -1,    -1,    -1,    -1,
      -1,  1969,    -1,    -1,    -1,    -1,  1974,    -1,   275,    -1,
      -1,   278,    -1,    -1,   231,   232,  3019,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   291,    -1,   293,   244,    -1,  3032,
      -1,    -1,  1700,  3036,    -1,    -1,    -1,    -1,  3041,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3049,    -1,    -1,    -1,
    2018,    -1,    -1,    -1,    -1,  3058,    -1,  3060,   275,    -1,
      -1,   278,    -1,    -1,  3067,  3068,  3069,    -1,    -1,  3072,
    1381,    -1,    -1,    -1,   291,    -1,  3079,  3080,    -1,    -1,
      -1,    -1,   349,    -1,  1752,    -1,  3089,    -1,    -1,    -1,
      -1,    -1,    -1,   597,   598,    -1,  1407,    -1,    -1,    -1,
      76,    -1,    -1,    -1,  3107,    -1,    -1,    -1,    -1,  1420,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,  3121,    -1,
      -1,    -1,    98,    -1,    -1,    -1,  2094,   103,    -1,    -1,
      -1,    -1,   349,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3149,    -1,   415,  1858,
    1859,  1462,    -1,    -1,    -1,    -1,    -1,    -1,   425,   426,
     427,    -1,   429,   430,   431,   432,   433,   434,  3171,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1489,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   415,    -1,
      -1,    -1,    -1,  1514,    -1,    -1,    -1,    -1,   425,   426,
     427,    -1,   429,   430,   431,   432,   433,   434,    -1,    -1,
      -1,  3224,   726,    -1,    -1,   729,    -1,    -1,   732,   733,
      -1,    -1,   208,    -1,  3237,  1546,   212,    -1,  1947,    -1,
    1551,    -1,    -1,  1952,    -1,    -1,    -1,    -1,    -1,   753,
      -1,  2219,    -1,  2221,    -1,   231,   232,    -1,  1967,    -1,
      -1,    -1,   766,    -1,    -1,   769,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   780,   781,    -1,   200,
      -1,    -1,    -1,    -1,  3287,   789,   207,    -1,   209,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   800,    -1,    -1,   275,
     804,   805,   278,    -1,    -1,  3308,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   291,    -1,   293,    -1,    -1,
      -1,  1989,    -1,    -1,   828,   829,    -1,    -1,    -1,  2038,
      -1,   835,    -1,    -1,    -1,    -1,    -1,    -1,  3341,    -1,
      -1,  3344,  2310,    -1,  2012,    -1,    -1,    -1,    -1,    -1,
      -1,  2019,   856,    -1,   858,    -1,    -1,  2325,  2026,    -1,
    1671,    -1,    -1,  2331,  2332,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   349,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   886,    -1,    -1,    -1,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2365,  2366,    -1,
      90,    -1,    -1,    -1,    -1,    -1,  2374,    -1,    98,    -1,
      -1,    -1,    -1,   103,  2382,    -1,    -1,    -1,   394,  2387,
      -1,  2389,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2400,  2401,    -1,    -1,    -1,    -1,    -1,   415,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   425,
     426,   427,    -1,   429,   430,   431,   432,   433,   434,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2440,  2441,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   988,    -1,    -1,   991,    -1,    -1,
     994,    -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      -1,    93,    -1,    -1,    -1,    -1,    98,    -1,   208,    -1,
      -1,   103,   212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2200,    -1,    -1,    -1,    -1,    -1,  2206,    -1,
      -1,   231,   232,    -1,    -1,    -1,    -1,  1858,  1859,    -1,
      -1,    -1,    -1,    -1,   244,    -1,    -1,    -1,    -1,  1063,
      -1,  2529,    -1,  1067,    -1,    -1,  1076,  1071,    -1,    -1,
      -1,  2539,    -1,  1077,    -1,    -1,    -1,    -1,    -1,  2288,
    2289,    -1,  2291,    -1,    -1,   275,    -1,    -1,   278,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2306,  1102,  2308,
    1110,   291,    -1,   293,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   302,    -1,    -1,  2583,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2334,   208,    -1,    -1,    -1,
     212,    -1,    -1,  1137,    -1,    -1,  1947,    -1,    -1,    -1,
      -1,  1952,    -1,    -1,    -1,    -1,    -1,  1151,    -1,   231,
     232,    -1,    -1,    -1,    -1,  2364,  1967,    -1,    -1,   349,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2382,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   275,    -1,    -1,   278,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2417,   291,
      -1,   293,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2428,
      -1,    -1,    -1,    -1,    -1,   415,    -1,  2038,    -1,    -1,
      -1,    -1,    -1,  2442,    -1,   425,   426,   427,    -1,   429,
     430,   431,   432,   433,   434,  2413,    -1,    -1,    -1,    -1,
      -1,  2419,  2720,  2721,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2734,   349,    -1,    -1,
      -1,  2739,  2740,  2741,  2742,  2743,    -1,    -1,    -1,  2747,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2456,    -1,
      -1,    -1,  2460,    -1,    -1,    -1,  2464,    -1,   719,    -1,
      -1,    -1,   723,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2522,    -1,    -1,    -1,    -1,  2486,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2797,
      -1,   752,    -1,   415,    -1,    -1,  2545,    -1,    -1,    -1,
    2508,    -1,    -1,   425,   426,   427,    -1,   429,   430,   431,
     432,   433,   434,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2572,    -1,    -1,    -1,   788,    -1,    -1,
    1374,  1381,    -1,   794,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2595,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1407,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1420,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2612,  2613,    -1,    -1,    -1,    -1,
      -1,    -1,  1462,    -1,    -1,    -1,  2924,    -1,    -1,    -1,
      -1,    -1,    -1,   884,    -1,    -1,    -1,    -1,   889,  2937,
      -1,   892,    -1,    -1,    -1,    -1,    -1,  2288,  2289,  1489,
    2291,    -1,  2950,    -1,    -1,    -1,    -1,  2955,    -1,  2957,
    2958,    -1,    -1,    -1,  2962,  2306,    -1,  2308,  2707,    -1,
      -1,    -1,    -1,    -1,  1514,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1522,    -1,
      -1,    -1,    -1,  2334,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1546,    -1,    -1,    -1,
      -1,  1551,    -1,    -1,    -1,  1549,    -1,    -1,    -1,    -1,
      -1,    -1,  3020,  2364,    -1,    -1,    -1,    -1,  1562,    -1,
      -1,    -1,    -1,    -1,    -1,  2774,    -1,    -1,    -1,    -1,
      -1,  2382,    -1,    -1,    -1,    -1,    -1,    -1,  2746,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,
      -1,  2769,    -1,    -1,    -1,    -1,  2417,    -1,    90,  2777,
      -1,    -1,    -1,    -1,    -1,    -1,    98,  2428,    -1,    -1,
      -1,   103,    -1,    -1,    -1,    -1,    -1,  1048,    -1,    -1,
      -1,  2442,  1053,    -1,    -1,    -1,    -1,    -1,  1059,    -1,
      -1,    -1,  3110,    -1,    -1,    -1,    -1,  2815,    -1,    -1,
      -1,    -1,  2820,    -1,    -1,  1076,  2824,    -1,    -1,    -1,
      -1,  1671,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3146,    -1,
    1101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1110,
      -1,  2900,   884,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1706,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   208,    -1,    -1,    -1,
     212,    -1,    -1,    -1,  2545,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2912,  2913,  2914,  2915,    -1,   231,
     232,  1172,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2572,   244,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3240,    -1,    -1,    -1,  3244,    -1,  1199,    -1,
      -1,    -1,    -1,    -1,  2595,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   275,    -1,    -1,   278,    -1,    -1,    -1,
      -1,    -1,  1223,  1224,    -1,  1226,    -1,    -1,  1812,   291,
      -1,   293,    -1,    -1,    -1,    -1,    -1,  3285,  3286,  1823,
      -1,    -1,    -1,  1244,    -1,    -1,    -1,  1831,    -1,    -1,
      -1,    -1,  3041,  1837,    -1,    -1,    -1,    -1,  1842,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1858,  1859,
      -1,  3019,    -1,    -1,    -1,    -1,  1048,    -1,  3067,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   349,  3036,    -1,
    1874,  1875,    -1,  1877,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1310,
      -1,    -1,  1313,  1314,    -1,    -1,  2707,    -1,    -1,    -1,
      -1,    -1,  1906,  1907,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1921,    -1,  1923,
    1924,    -1,  1926,  1927,  1928,  1929,    -1,    -1,    -1,  1933,
      -1,    -1,  1936,   415,    -1,    -1,    -1,  1947,    -1,    -1,
      -1,    -1,  1952,   425,   426,   427,    -1,   429,   430,   431,
     432,   433,   434,  3121,    -1,  3123,    -1,  1967,    -1,    -1,
    1381,    -1,    -1,  2774,    -1,    -1,    -1,  1388,    -1,    -1,
      -1,    -1,    -1,  3141,    -1,    -1,    -1,    -1,    -1,    -1,
    1172,    -1,    -1,    -1,    -1,    -1,  1407,    -1,  3156,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1420,
      -1,  1422,    -1,    -1,    -1,    -1,    -1,  1199,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3186,    -1,
      -1,    -1,    -1,    -1,    -1,  1446,    -1,    -1,  2038,    -1,
      -1,  1223,  1224,    -1,  1226,    -1,    -1,    -1,    -1,    -1,
      -1,  1462,    -1,    -1,    -1,    -1,    -1,  2051,    -1,    -1,
      -1,    -1,  1244,    -1,    -1,    -1,  3224,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1489,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3287,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2900,
      -1,    -1,    -1,  1514,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1310,    -1,
      -1,  1313,  1314,  1544,    -1,  1546,    -1,    -1,    -1,    -1,
    1551,    -1,    -1,    -1,    -1,  3344,    -1,    -1,    -1,    -1,
    3308,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1581,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1611,  1612,    -1,    -1,    -1,    -1,    -1,    -1,  1619,    -1,
      -1,  1622,  1623,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1634,  1635,    -1,    -1,    -1,    -1,    -1,
      -1,  1642,    -1,    -1,    -1,  1646,  1647,  1648,  1649,    -1,
    3041,    -1,    -1,    -1,    -1,  1656,  1657,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1671,  1672,    -1,    -1,    -1,  1676,  3067,    -1,    -1,  1680,
      -1,    -1,    -1,  1684,    -1,    -1,  1687,  1688,  1689,  1690,
    1691,  1692,  1693,  1694,  1695,    -1,  1697,    -1,  2288,  2289,
    1701,  2291,    -1,    -1,  1705,    -1,    -1,    -1,    -1,    -1,
      -1,  2295,  2296,    -1,    -1,    -1,  2306,    -1,  2308,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2334,    -1,    -1,    -1,    -1,    90,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2364,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2402,  2403,
    2404,    -1,    -1,    -1,    -1,    -1,    -1,  2417,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2428,  1840,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1619,    -1,    -1,
      -1,  1623,  2442,  2437,    -1,    -1,    -1,  1858,  1859,    -1,
      -1,    -1,    -1,    -1,    -1,  2449,    -1,   208,    -1,    -1,
    1642,   212,    -1,    -1,  1646,    -1,    -1,  1649,    -1,    -1,
      -1,    -1,    -1,    -1,  1656,  1657,    -1,    -1,    -1,    -1,
     231,   232,    -1,    -1,    -1,    -1,  3287,    -1,    -1,    -1,
    1672,    -1,    -1,   244,  1676,    -1,    -1,    -1,  1680,    -1,
      -1,    -1,  1684,    -1,    -1,  1687,  1688,  1689,  1690,  1691,
    1692,  1693,  1694,  1695,    -1,  1697,    -1,    -1,    -1,  1701,
      -1,    -1,  2522,    -1,   275,    -1,    -1,   278,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1946,  1947,    -1,    -1,    -1,
     291,  1952,   293,  3344,    -1,  2545,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1965,    -1,  1967,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2572,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2595,    -1,    -1,   349,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2026,    -1,    -1,    -1,    -1,
     371,    -1,    -1,    -1,  2035,    -1,    -1,  2038,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1076,    -1,    -1,    -1,    -1,  1840,    -1,
    2071,    -1,    -1,    -1,   415,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   425,   426,   427,    -1,   429,   430,
     431,   432,   433,   434,  2095,    -1,    -1,  1110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2707,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2127,  2711,  2712,  2130,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2142,  2143,  2144,  2145,    -1,    -1,    -1,    -1,    -1,
    2151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2161,  2162,    -1,  2164,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1946,  2176,    -1,  2178,  2762,    -1,
      -1,  2182,    -1,    -1,  2774,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1965,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2206,    -1,  2208,  2209,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2240,
    2241,  2242,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2035,    -1,    -1,    -1,    -1,    -1,  1076,
    2271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     719,    -1,    -1,    -1,   723,    -1,    -1,  2288,  2289,    -1,
    2291,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2071,
      -1,    -1,    -1,  1110,    -1,  2306,    -1,  2308,    -1,    -1,
    2900,    -1,    -1,   752,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2095,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2334,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   788,
      -1,  2935,  2936,    -1,    -1,   794,    -1,    -1,    -1,    -1,
      -1,  2945,    -1,  2364,    -1,    -1,    -1,    -1,  1381,    -1,
    2142,    -1,  2144,  2145,    -1,    -1,    -1,    -1,    -1,  2151,
      -1,  2382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1407,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2176,    -1,  2178,  1420,    -1,    -1,
    2182,    -1,    -1,    -1,    -1,    -1,  2417,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2428,    -1,    -1,
    3014,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2442,    -1,    -1,    -1,   884,    -1,    -1,    -1,  1462,
      -1,  3041,    -1,    -1,    -1,  2456,    -1,    -1,    -1,  2460,
    2232,    -1,    -1,  2464,    -1,    -1,    -1,    -1,  2240,  2241,
    2242,    -1,    -1,    -1,    -1,    -1,  1489,  3067,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2486,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2271,
      -1,  1514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2513,    -1,    -1,    -1,    -1,    -1,  2519,    -1,
      -1,  2522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2531,    -1,    -1,  1546,    -1,    -1,  2537,    -1,  1551,    -1,
    2541,    -1,    -1,    -1,  2545,  2546,    -1,    -1,  2549,  2550,
    2551,  2552,  2553,  2554,  2555,  2556,  2557,  2558,    -1,    -1,
      -1,    -1,  2563,  2564,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2572,    -1,    -1,  1381,    -1,  2577,    -1,    -1,    -1,
      -1,    -1,    -1,  2584,    -1,    -1,  2587,    -1,  2589,    -1,
      -1,    -1,    -1,    -1,  2595,  2596,  2597,  2598,    -1,    -1,
    1407,  2602,    -1,    -1,  2605,    -1,    -1,    -1,    -1,  1048,
      -1,    -1,    -1,  1420,  1053,    -1,    -1,    -1,    -1,    -1,
    1059,    -1,    -1,    -1,  3208,    -1,    -1,    -1,    -1,  3213,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1076,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2649,    -1,
      -1,    -1,    -1,    -1,    -1,  1462,    -1,    -1,  1671,    -1,
      -1,    -1,  1101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1110,    -1,    -1,    -1,    -1,    -1,  3261,    -1,    -1,
      -1,    -1,  1489,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3287,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2707,  1514,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1172,    -1,    -1,    -1,    -1,    -1,  1546,
      -1,  2513,    -1,    -1,  1551,    -1,    -1,  2519,    -1,    -1,
      -1,    -1,    -1,    -1,  3344,    -1,    -1,    -1,    -1,  2531,
    1199,    -1,  2763,    -1,    -1,  2537,    -1,    -1,    -1,  2541,
      -1,    -1,    -1,  2774,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1223,  1224,    -1,  1226,    -1,    -1,
      -1,  2563,  2564,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1244,    -1,    -1,    -1,    -1,
      -1,    -1,  2584,    -1,  2815,  2587,    -1,  2589,    -1,  2820,
      -1,    -1,    -1,  2824,  2596,    -1,    -1,    -1,    -1,    -1,
    2602,    -1,    -1,  2605,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2842,    -1,    -1,    -1,  1858,  1859,    -1,    -1,    -1,
      -1,    -1,    -1,  2854,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1671,    -1,    -1,    -1,    -1,    -1,
      -1,  1310,    -1,    -1,  1313,  1314,    -1,  2649,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2895,  2896,    -1,    -1,    -1,  2900,
      -1,    -1,    -1,    -1,    -1,  2906,  2907,    -1,    -1,  2910,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1947,    -1,    -1,    -1,    -1,  1952,
      -1,    -1,  1381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1967,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1076,  1407,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1420,  2983,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1076,  1110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3019,    -1,
      -1,    -1,    -1,  1462,    -1,  2038,    -1,    -1,    -1,    -1,
      -1,  3032,    -1,    -1,  1110,  3036,    -1,    -1,    -1,    -1,
    3041,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3049,    -1,
    1489,  1858,  1859,    -1,    -1,    -1,    -1,  3058,    -1,  3060,
      -1,    -1,    -1,    -1,    -1,    -1,  3067,  3068,  3069,    -1,
    2842,  3072,    -1,    -1,    -1,  1514,    -1,    -1,  3079,  3080,
      -1,    -1,  2854,    -1,    -1,    -1,    -1,    -1,  3089,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1544,  3107,  1546,    -1,    -1,
      -1,    -1,  1551,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3121,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2906,  2907,    -1,    -1,  2910,    -1,
    1947,    -1,  1581,    -1,    -1,  1952,    -1,    -1,  3149,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1967,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3171,    -1,  1611,  1612,    -1,    -1,    -1,    -1,    -1,    -1,
    1619,    -1,    -1,  1622,  1623,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1634,  1635,    -1,    -1,    -1,
      -1,    -1,    -1,  1642,    -1,    -1,    -1,  1646,  1647,  1648,
    1649,  2983,    -1,    -1,    -1,    -1,    -1,  1656,  1657,    -1,
      -1,    -1,    -1,  3224,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2038,  1671,  1672,    -1,    -1,  3237,  1676,    -1,    -1,
      -1,  1680,    -1,    -1,    -1,  1684,    -1,    -1,  1687,  1688,
    1689,  1690,  1691,  1692,  1693,  1694,  1695,    -1,  1697,    -1,
    3032,    -1,  1701,    -1,    -1,    -1,  1705,    -1,    -1,    -1,
      -1,    -1,  1381,    -1,    -1,  2288,  2289,  3049,  2291,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3287,    -1,    -1,    -1,
      -1,    -1,    -1,  2306,    -1,  2308,    -1,    -1,  1407,    -1,
    3072,    -1,    -1,    -1,    -1,  1381,    -1,  3308,  3080,    -1,
      -1,  1420,    -1,    -1,    -1,    -1,    -1,  3089,    -1,    -1,
      -1,  2334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1407,    -1,    -1,    -1,  3107,    -1,    -1,    -1,    -1,
    3341,    -1,    -1,  3344,  1420,    -1,    -1,    -1,    -1,    -1,
      -1,  2364,    -1,  1462,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2382,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3149,    -1,    -1,
    1489,    -1,    -1,    -1,    -1,    -1,  1462,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1840,    -1,    -1,  2417,  1514,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1489,    -1,  2428,    -1,    -1,    -1,  1858,
    1859,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2442,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1546,  1514,    -1,
      -1,    -1,  1551,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3237,    -1,    -1,    -1,    -1,
    1546,    -1,    -1,    -1,    -1,  1551,    -1,    -1,    -1,    -1,
      -1,  2288,  2289,    -1,  2291,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2306,
      -1,  2308,    -1,    -1,    -1,    -1,    -1,  1946,  1947,  2522,
      -1,    -1,    -1,  1952,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1965,  2334,  1967,    -1,
      -1,    -1,  2545,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2364,    -1,  2572,
      -1,    -1,  1671,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2382,    -1,    -1,    -1,    -1,
      -1,    -1,  2595,    -1,    -1,    -1,    -1,  2026,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1671,  2035,    -1,    -1,  2038,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2417,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2428,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2071,    -1,    -1,  2442,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2095,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2127,    -1,
      -1,  2130,    -1,    -1,  2707,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2142,  2143,  2144,  2145,    -1,    -1,    -1,
      -1,    -1,  2151,    -1,    -1,  2522,    -1,    -1,    -1,    -1,
      -1,    -1,  2161,  2162,    -1,  2164,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2176,  2545,  2178,
      -1,    -1,    -1,  2182,    -1,    -1,    -1,    -1,    -1,  1858,
    1859,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2774,    -1,    -1,    -1,  2572,    -1,  2206,    -1,  2208,
    2209,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1858,  1859,    -1,    -1,    -1,    -1,  2595,    -1,
      -1,    -1,    -1,  2232,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2240,  2241,  2242,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1240,    -1,  2271,    -1,    -1,    -1,    -1,    -1,  1947,    -1,
      -1,    -1,    -1,  1952,    -1,    -1,    -1,    -1,    -1,  2288,
    2289,    -1,  2291,    -1,    -1,    -1,    -1,    -1,  1967,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2306,    -1,  2308,
      -1,  1947,    -1,    -1,    -1,    -1,  1952,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2900,    -1,    -1,
      -1,  1967,    -1,    -1,    -1,  2334,    -1,    -1,    -1,    -1,
    2707,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2364,    -1,    -1,    -1,  2038,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2382,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2038,    -1,    -1,    -1,    -1,  2774,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2417,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2428,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2442,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2456,    -1,    -1,
      -1,  2460,    -1,    -1,    -1,  2464,    -1,    -1,  3041,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1455,    -1,  2486,    -1,    -1,
      -1,    -1,    -1,    -1,  3067,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2513,    -1,    -1,    -1,    -1,    -1,
    2519,    -1,    -1,  2522,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2531,  2900,    -1,    -1,    -1,    -1,  2537,    -1,
      -1,    -1,  2541,    -1,    -1,    -1,  2545,  2546,    -1,    -1,
    2549,  2550,  2551,  2552,  2553,  2554,  2555,  2556,  2557,  2558,
      -1,    -1,    -1,    -1,  2563,  2564,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2572,    -1,    -1,    -1,    -1,  2577,    -1,
      -1,    -1,    -1,    -1,    -1,  2584,    -1,    -1,  2587,    -1,
    2589,    -1,    -1,    -1,    -1,    -1,  2595,  2596,  2597,  2598,
      -1,    -1,    -1,  2602,    -1,    -1,  2605,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2288,
    2289,    -1,  2291,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2306,    -1,  2308,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1617,    -1,    -1,
    2649,    -1,  2288,  2289,    -1,  2291,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2334,    -1,    -1,    -1,    -1,
    2306,  1641,  2308,    -1,  3041,    -1,    -1,  1647,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1660,  1661,    -1,  1663,    -1,  2364,    -1,    -1,  2334,    -1,
    3067,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2707,    -1,
      -1,    -1,    -1,  2382,  3287,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2364,  1699,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2382,    -1,  2417,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2428,
      -1,    -1,    -1,    -1,  2763,    -1,    -1,    -1,    -1,    -1,
      -1,  3344,    -1,  2442,    -1,  2774,    -1,    -1,    -1,    -1,
      -1,  2417,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1761,  2428,    -1,    -1,    -1,    -1,    -1,  1768,    -1,
    1770,    -1,    -1,    -1,    -1,    -1,  2442,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2815,    -1,    -1,    -1,
      -1,  2820,    -1,    -1,    -1,  2824,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2842,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2522,    -1,  2854,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2545,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2522,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2895,  2896,    -1,    -1,
      -1,  2900,    -1,  2572,    -1,    -1,    -1,  2906,  2907,  2545,
      -1,  2910,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3287,    -1,    -1,    -1,    -1,    -1,  2595,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2572,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2595,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3344,    -1,    -1,
      -1,    -1,    -1,    -1,  2983,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3019,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3032,    -1,    -1,    -1,  3036,  2707,    -1,
      -1,    -1,  3041,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3049,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3058,
      -1,  3060,    -1,    -1,    -1,    -1,    -1,    -1,  3067,  3068,
    3069,  2707,    -1,  3072,    -1,    -1,    -1,    -1,    -1,    -1,
    3079,  3080,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3089,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2774,    -1,    -1,  3107,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2089,
      -1,    -1,  3121,    -1,    -1,    -1,    -1,    -1,  2098,    -1,
    2100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2774,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3149,    -1,  2122,    -1,    -1,  2125,    -1,  2127,  2128,    -1,
    2130,    -1,    -1,    -1,  2134,    -1,    -1,    -1,    -1,    -1,
      -1,  2141,  3171,    -1,    -1,    -1,  2146,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2157,    -1,    -1,
      -1,  2161,  2162,  2163,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2174,    -1,    -1,    -1,    -1,    -1,
      -1,  2181,    -1,  2183,  2184,  2185,  2186,  2187,  2188,  2189,
    2190,  2191,  2192,    -1,    -1,  3224,    -1,    -1,    -1,    -1,
      -1,  2900,    -1,    -1,    -1,    -1,    -1,    -1,  3237,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     5,  2900,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    28,    -1,  3287,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    39,    40,    -1,
      -1,    -1,    -1,    45,    -1,    47,    48,    -1,  2278,  3308,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3341,    -1,    -1,  3344,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3041,    -1,   116,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2362,    -1,    -1,    -1,    -1,    -1,  3067,    -1,
      -1,    -1,    -1,    -1,    -1,  3041,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2383,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3067,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   207,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   225,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   256,    -1,    -1,   259,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2495,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   280,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2518,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2544,    -1,  2546,    -1,    -1,  2549,
    2550,  2551,  2552,  2553,  2554,  2555,  2556,  2557,  2558,    -1,
    2560,    -1,    -1,    -1,    -1,    -1,   338,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2580,    -1,    -1,    -1,    -1,  2585,  2586,    -1,  3287,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2597,  2598,  2599,
      -1,  2601,   374,    -1,  2604,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,
      -1,  3287,    -1,    -1,    -1,    -1,    -1,   399,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   410,    -1,
      -1,   413,   414,    -1,   416,  3344,   418,    -1,    -1,    -1,
     422,    -1,   424,   425,    -1,    -1,    -1,   429,   430,   431,
     432,   433,    -1,    -1,   436,   437,   438,   439,    -1,   441,
     442,   443,    -1,   445,  2674,    -1,    -1,    -1,  3344,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    28,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    39,    40,    -1,    -1,    -1,    -1,    -1,
      -1,    47,    48,  2763,    -1,    -1,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     116,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2851,    -1,    -1,    -1,  2855,    -1,    -1,    -1,    -1,
    2860,  2861,    -1,  2863,    -1,    -1,  2866,    -1,    -1,    -1,
    2870,  2871,  2872,  2873,  2874,  2875,  2876,  2877,  2878,  2879,
    2880,  2881,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2894,  2895,  2896,  2897,    -1,  2899,
      -1,    -1,   188,  2903,  2904,  2905,    -1,    -1,  2908,    -1,
      -1,  2911,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   207,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2929,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   225,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     256,    -1,    -1,   259,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2985,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   280,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3051,   338,    -1,    -1,    -1,    -1,    -1,  3058,    -1,
    3060,    -1,    -1,  3063,  3064,    -1,    -1,    -1,  3068,  3069,
    3070,  3071,    -1,  3073,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   374,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   399,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   410,  3125,    -1,   413,   414,    -1,
     416,    -1,    -1,    -1,    -1,    -1,   422,    -1,   424,   425,
      -1,    -1,    -1,   429,   430,   431,   432,   433,    -1,    -1,
     436,   437,   438,    -1,    -1,    -1,   442,    -1,    -1,  3159,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3170,  3171,  3172,    -1,    -1,  3175,  3176,  3177,    -1,  3179,
      -1,    -1,    -1,  3183,    -1,    -1,    -1,    -1,  3188,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     5,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,  3222,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,  3235,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    -1,    46,    47,    48,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,   108,
     109,   110,    -1,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,    -1,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,    -1,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,    -1,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,   340,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,   401,   402,    -1,   404,   405,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,    -1,    -1,
      -1,     6,     7,     8,    -1,    10,    11,    -1,    13,    14,
      15,    -1,    -1,    -1,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,   442,    29,    30,    31,    -1,    -1,    -1,
      35,    36,    37,    38,    -1,    40,    41,    42,    43,    44,
      -1,    46,    47,    48,    49,    -1,    -1,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   117,    -1,    -1,    -1,    -1,    -1,    -1,   124,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,
      -1,    -1,    -1,    -1,    -1,   140,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   152,   153,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,    -1,   184,
      -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,   193,    -1,
     195,    -1,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
      -1,    -1,    -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   219,   220,    -1,    -1,    -1,    -1,
      -1,   226,    -1,   228,    -1,    -1,   231,   232,    -1,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,    -1,   244,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   262,   263,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,
      -1,    -1,    -1,   278,    -1,    -1,   281,   282,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     295,   296,   297,   298,    -1,    -1,    -1,    -1,   303,   304,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   329,    -1,    -1,   332,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   346,    -1,    -1,   349,    -1,   351,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   361,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   372,   373,    -1,
      -1,    -1,    -1,   378,    -1,   380,    -1,    -1,    -1,    -1,
      -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   399,    -1,   401,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     6,     7,     8,   413,    10,
      11,   416,    13,    14,    15,    -1,    -1,    -1,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    -1,    -1,    -1,    35,    36,    37,    38,   443,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    -1,
      -1,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,    -1,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,    -1,   140,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   152,   153,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     181,    -1,    -1,   184,    -1,    -1,    -1,   188,    -1,    -1,
      -1,    -1,   193,    -1,   195,    -1,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,    -1,    -1,    -1,   208,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   219,   220,
      -1,    -1,    -1,    -1,    -1,   226,    -1,   228,    -1,    -1,
     231,   232,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   262,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,    -1,    -1,    -1,    -1,   278,    -1,    -1,
     281,   282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   295,   296,   297,   298,    -1,    -1,
      -1,    -1,   303,   304,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   315,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,    -1,
      -1,   332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   346,    -1,    -1,   349,    -1,
     351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   372,   373,    -1,    -1,    -1,    -1,   378,    -1,   380,
      -1,    -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   399,    -1,
     401,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   413,    -1,    -1,   416,    -1,     3,    -1,    -1,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,   443,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    40,    41,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    87,    88,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,   102,   103,   104,   105,
     106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   117,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,    -1,   134,   135,
     136,    -1,    -1,    -1,   140,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,    -1,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   169,    -1,    -1,    -1,    -1,    -1,   175,
      -1,    -1,    -1,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,   188,    -1,    -1,    -1,    -1,   193,    -1,   195,
      -1,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,    -1,
      -1,    -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   219,   220,    -1,    -1,   223,    -1,    -1,
     226,    -1,   228,    -1,    -1,   231,   232,    -1,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,
     246,   247,    -1,    -1,    -1,    -1,   252,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   260,    -1,   262,   263,   264,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,    -1,    -1,   281,   282,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,
     296,   297,   298,    -1,    -1,    -1,    -1,   303,   304,    -1,
     306,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   315,
      -1,    -1,   318,    -1,   320,    -1,    -1,    -1,   324,    -1,
      -1,    -1,   328,   329,    -1,   331,   332,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,    -1,    -1,    -1,    -1,   345,
     346,    -1,   348,   349,    -1,   351,    -1,    -1,   354,    -1,
      -1,    -1,    -1,    -1,    -1,   361,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   372,   373,    -1,    -1,
      -1,    -1,   378,    -1,   380,    -1,   382,    -1,   384,    -1,
      -1,   387,    -1,    -1,   390,    -1,   392,    -1,    -1,   395,
      -1,    -1,    -1,   399,    -1,   401,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   413,    -1,    -1,
     416,    -1,    -1,    -1,    -1,    -1,     5,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,   438,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    -1,    46,    47,    48,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,    -1,   112,   113,   114,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,   165,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,   185,   186,   187,   188,
      -1,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,   208,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
     219,   220,    -1,   222,   223,   224,   225,   226,    -1,   228,
      -1,    -1,   231,   232,   233,   234,   235,   236,   237,   238,
     239,    -1,   241,   242,   243,   244,    -1,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,    -1,   287,   288,
      -1,    -1,   291,   292,    -1,    -1,   295,   296,   297,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,   393,    -1,   395,   396,    -1,   398,
     399,   400,   401,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,   416,   417,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,    -1,    -1,
     429,   430,   431,    -1,    -1,    -1,    -1,    -1,    -1,   438,
     439,     5,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    -1,    46,    47,    48,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    -1,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,    -1,   109,   110,    -1,   112,   113,
     114,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,   185,   186,   187,   188,    -1,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,   208,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,   219,   220,    -1,   222,   223,
     224,   225,   226,    -1,   228,    -1,    -1,   231,   232,   233,
     234,   235,   236,   237,   238,   239,    -1,   241,   242,   243,
     244,    -1,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,
      -1,   295,   296,   297,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,   378,   379,   380,   381,   382,   383,
     384,   385,   386,    -1,   388,   389,   390,   391,   392,   393,
      -1,   395,   396,    -1,   398,   399,   400,   401,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,   416,   417,    -1,    -1,   420,   421,   422,   423,
     424,    -1,    -1,    -1,    -1,   429,   430,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   438,   439,     5,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    -1,    46,    47,    48,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,    -1,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,    -1,   135,    -1,   137,   138,
     139,   140,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,    -1,   182,    -1,    -1,    -1,   186,   187,   188,
      -1,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
      -1,   200,    -1,    -1,   203,    -1,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,    -1,
     219,   220,    -1,   222,   223,   224,   225,   226,    -1,   228,
      -1,    -1,   231,   232,   233,   234,   235,   236,   237,   238,
     239,    -1,    -1,   242,   243,   244,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,    -1,   274,    -1,   276,   277,   278,
     279,    -1,    -1,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,   296,   297,    -1,
     299,   300,   301,    -1,    -1,    -1,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,    -1,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,    -1,
     379,    -1,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,   401,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
     439,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,   201,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
      -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,   394,   395,   396,    -1,
     398,   399,   400,    -1,   402,     5,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,    19,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    28,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   436,    39,
      40,    -1,   440,    -1,    -1,    -1,    -1,    47,    48,    -1,
      -1,    -1,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    -1,    -1,     5,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    28,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    39,    40,    -1,   116,    -1,    -1,    -1,
      -1,    47,    48,    -1,    -1,    -1,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,
     116,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   207,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   225,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,   259,
      -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     280,   207,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   225,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     256,    -1,    -1,   259,    -1,    -1,    -1,    -1,   338,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   280,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   374,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   399,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     410,    -1,   338,   413,   414,    -1,   416,    -1,    -1,    -1,
      -1,    -1,   422,    -1,   424,   425,    -1,    -1,    -1,   429,
     430,   431,   432,   433,    -1,    -1,   436,   437,   438,   439,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   374,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   399,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   410,    -1,    -1,   413,   414,    -1,
     416,    -1,    -1,    -1,    -1,    -1,   422,    -1,   424,   425,
      -1,    -1,    -1,   429,   430,   431,   432,   433,    -1,    -1,
     436,   437,   438,   439,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,   185,   186,   187,   188,    -1,   190,
      -1,   192,   193,   194,   195,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,   208,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,   219,   220,
      -1,   222,   223,   224,   225,   226,    -1,   228,    -1,    -1,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,    -1,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,    -1,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,   376,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,    -1,   395,   396,    -1,   398,   399,   400,
     401,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,   416,   417,    -1,    -1,   420,
     421,   422,   423,   424,    -1,    -1,    -1,    -1,   429,   430,
       5,     6,     7,     8,     9,    10,    11,   438,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
     185,   186,   187,   188,    -1,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,   208,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,   219,   220,    -1,   222,   223,   224,
     225,   226,    -1,   228,    -1,    -1,   231,   232,   233,   234,
     235,   236,   237,   238,   239,    -1,   241,   242,   243,   244,
      -1,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,   393,    -1,
     395,   396,    -1,   398,   399,   400,   401,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,   416,   417,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,    -1,    -1,   429,   430,   431,    -1,    -1,    -1,
      -1,    -1,    -1,   438,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,   185,   186,   187,   188,    -1,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,   208,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,   219,   220,
      -1,   222,   223,   224,   225,   226,    -1,   228,    -1,    -1,
     231,   232,   233,   234,   235,   236,   237,   238,   239,    -1,
     241,   242,   243,   244,    -1,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,    -1,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,   340,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,    -1,   395,   396,    -1,   398,   399,   400,
     401,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,   416,   417,    -1,    -1,   420,
     421,   422,   423,   424,    -1,    -1,    -1,    -1,   429,   430,
       5,     6,     7,     8,     9,    10,    11,   438,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
     185,   186,   187,   188,    -1,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,   208,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,   219,   220,    -1,   222,   223,   224,
     225,   226,    -1,   228,    -1,    -1,   231,   232,   233,   234,
     235,   236,   237,   238,   239,    -1,   241,   242,   243,   244,
      -1,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,   393,    -1,
     395,   396,    -1,   398,   399,   400,   401,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,   416,   417,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,    -1,    -1,   429,   430,     5,     6,     7,     8,
       9,    10,    11,   438,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    -1,    46,    47,    48,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,    -1,   112,   113,   114,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,   185,   186,   187,   188,
      -1,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,   208,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
     219,   220,    -1,   222,   223,   224,   225,   226,    -1,   228,
      -1,    -1,   231,   232,   233,   234,   235,   236,   237,   238,
     239,    -1,   241,   242,   243,   244,    -1,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,    -1,   287,   288,
      -1,    -1,   291,   292,    -1,    -1,   295,   296,   297,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,   393,    -1,   395,   396,    -1,   398,
     399,   400,   401,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,   416,   417,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,    -1,    -1,
     429,   430,    -1,    -1,    -1,    -1,    -1,   436,    -1,   438,
       5,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
     185,   186,   187,   188,    -1,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,   208,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,   219,   220,    -1,   222,   223,   224,
     225,   226,    -1,   228,    -1,    -1,   231,   232,   233,   234,
     235,   236,   237,   238,   239,    -1,   241,   242,   243,   244,
      -1,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,   393,    -1,
     395,   396,    -1,   398,   399,   400,   401,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,   416,   417,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,    -1,    -1,   429,   430,     5,     6,     7,     8,
       9,    10,    11,   438,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    -1,    46,    47,    48,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,    -1,   112,   113,   114,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,   185,   186,   187,   188,
      -1,   190,    -1,   192,   193,   194,   195,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,   208,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
     219,   220,    -1,   222,   223,   224,   225,   226,    -1,   228,
      -1,    -1,   231,   232,   233,   234,   235,   236,   237,   238,
     239,    -1,   241,   242,   243,   244,    -1,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,    -1,   287,   288,
      -1,    -1,   291,   292,    -1,    -1,   295,   296,   297,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,   393,    -1,   395,   396,    -1,   398,
     399,   400,   401,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,   416,   417,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,    -1,    -1,
     429,   430,     5,     6,     7,     8,     9,    10,    11,   438,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,   185,   186,   187,   188,    -1,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,   208,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,   220,    -1,   222,
     223,   224,   225,   226,    -1,   228,    -1,    -1,   231,   232,
     233,   234,   235,   236,   237,   238,   239,    -1,   241,   242,
     243,   244,    -1,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,    -1,    -1,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,   296,   297,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,    -1,   388,   389,   390,   391,   392,
     393,    -1,   395,   396,    -1,   398,   399,   400,   401,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,   415,   416,   417,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,    -1,    -1,   429,   430,     5,     6,
       7,     8,     9,    10,    11,   438,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    -1,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    -1,    46,
      47,    48,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      -1,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,    -1,   112,   113,   114,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,   185,   186,
     187,   188,    -1,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,   208,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,   219,   220,    -1,   222,   223,   224,   225,   226,
      -1,   228,    -1,    -1,   231,   232,   233,   234,   235,   236,
     237,   238,   239,    -1,   241,   242,   243,   244,    -1,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,    -1,
     287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,
     297,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,   393,    -1,   395,   396,
      -1,   398,   399,   400,   401,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,   414,   415,   416,
     417,    -1,    -1,   420,   421,   422,   423,   424,    -1,    -1,
      -1,    -1,   429,   430,     5,     6,     7,     8,     9,    10,
      11,   438,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,   185,   186,   187,   188,    -1,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,   208,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,   219,   220,
      -1,   222,   223,   224,   225,   226,    -1,   228,    -1,    -1,
     231,   232,   233,   234,   235,   236,   237,   238,   239,    -1,
     241,   242,   243,   244,    -1,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,    -1,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,   393,    -1,   395,   396,    -1,   398,   399,   400,
     401,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,   416,   417,    -1,    -1,   420,
     421,   422,   423,   424,    -1,    -1,    -1,    -1,    -1,   430,
       5,     6,     7,     8,     9,    10,    11,   438,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,    -1,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,    -1,    -1,   178,   179,   180,   181,   182,    -1,   184,
     185,   186,   187,   188,    -1,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,   219,   220,    -1,   222,   223,   224,
     225,   226,    -1,   228,    -1,    -1,   231,   232,   233,   234,
     235,   236,   237,   238,   239,    -1,   241,   242,   243,    -1,
      -1,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,   393,    -1,
     395,   396,    -1,   398,   399,   400,   401,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,   416,   417,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,    -1,    -1,   429,   430,     5,     6,     7,     8,
       9,    10,    11,   438,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    -1,    46,    47,    48,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,
      99,   100,   101,   102,    -1,   104,   105,   106,   107,    -1,
     109,   110,    -1,   112,   113,   114,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,    -1,    -1,   178,
     179,   180,   181,   182,    -1,   184,   185,   186,   187,   188,
      -1,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
     219,   220,    -1,   222,   223,   224,   225,   226,    -1,   228,
      -1,    -1,   231,   232,   233,   234,   235,   236,   237,   238,
     239,    -1,   241,   242,   243,    -1,    -1,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,    -1,   287,   288,
      -1,    -1,    -1,   292,    -1,    -1,   295,   296,   297,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,   393,    -1,   395,   396,    -1,   398,
     399,   400,   401,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,    -1,   416,   417,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,    -1,    -1,
      -1,   430,    -1,     6,     7,     8,     9,    10,    11,   438,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      93,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,   177,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,   189,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,   227,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,   245,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,   286,   287,    -1,    -1,    -1,   291,   292,
      -1,   294,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,     5,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    19,   416,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    28,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    39,    40,    -1,    -1,   439,    -1,    -1,    -1,
      47,    48,    -1,    -1,    -1,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     207,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   225,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   256,
      -1,    -1,   259,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   280,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   338,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   374,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   399,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   410,    -1,    -1,   413,   414,    -1,   416,
      -1,    -1,    -1,    -1,    -1,   422,    -1,   424,   425,    -1,
      -1,    -1,   429,   430,   431,   432,   433,    -1,    -1,   436,
     437,   438,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    41,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
     114,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,    -1,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,   208,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,   219,   220,    -1,   222,   223,
     224,    -1,   226,    -1,   228,    -1,    -1,   231,   232,   233,
     234,   235,   236,   237,   238,   239,    -1,   241,   242,   243,
     244,    -1,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,   278,   279,    -1,   281,   282,   283,
     284,    -1,    -1,   287,   288,    -1,   290,   291,   292,    -1,
      -1,   295,   296,   297,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,   393,
      -1,   395,   396,    -1,   398,   399,   400,   401,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,    -1,    -1,    -1,    -1,    -1,    -1,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,   438,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    41,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,   114,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,   208,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,   219,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,   231,   232,   233,   234,   235,   236,
     237,   238,   239,    -1,   241,   242,   243,   244,    -1,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,   278,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,   288,    -1,   290,   291,   292,    -1,    -1,   295,   296,
     297,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,   393,    -1,   395,   396,
      -1,   398,   399,   400,   401,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,    -1,    -1,   416,
      -1,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,   438,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,   114,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,   208,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,   219,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,   231,   232,   233,   234,   235,   236,   237,   238,   239,
      -1,   241,   242,   243,   244,    -1,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,   278,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,   288,    -1,
      -1,   291,   292,    -1,    -1,   295,   296,   297,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,   393,    -1,   395,   396,    -1,   398,   399,
     400,   401,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,    -1,    -1,    -1,
      -1,    -1,    -1,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,   438,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,    -1,   416,   417,    -1,    -1,    -1,    -1,   422,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   437,   438,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,   414,    -1,   416,   417,    -1,    -1,
      -1,    -1,   422,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,   438,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,    -1,    -1,    -1,    -1,    -1,    -1,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,   438,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    41,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,   417,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,   438,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,   340,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,    -1,    -1,
      -1,    -1,    -1,    -1,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,   438,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,    -1,    -1,    -1,    -1,    -1,
      -1,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,   438,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    41,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,    -1,
      -1,   416,    -1,    -1,    -1,    -1,    -1,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,   438,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,   107,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,    -1,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,    -1,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,    -1,   182,    -1,    -1,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,    -1,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,    -1,    -1,   222,   223,   224,   225,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,    -1,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,    -1,   274,    -1,   276,   277,
      -1,   279,    -1,    -1,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,    -1,    -1,    -1,
      -1,   299,   300,   301,    -1,    -1,    -1,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
      -1,   379,    -1,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,   414,   415,   416,   417,
      -1,    -1,    -1,    -1,   422,    -1,   424,   425,   426,   427,
      -1,   429,   430,   431,   432,   433,   434,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,   415,   416,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   425,   426,   427,    -1,
     429,   430,   431,   432,   433,   434,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,   415,   416,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   425,   426,   427,    -1,   429,
     430,   431,   432,   433,   434,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,   108,   109,
     110,    -1,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,    -1,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,    -1,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,   229,
      -1,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
     340,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,   396,    -1,   398,   399,
     400,   401,   402,    -1,   404,   405,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,   431,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,   107,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,    -1,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,    -1,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,    -1,   182,    -1,    -1,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,    -1,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,    -1,    -1,   222,   223,   224,   225,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,    -1,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,    -1,   274,    -1,   276,   277,
      -1,   279,    -1,    -1,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,    -1,    -1,    -1,
      -1,   299,   300,   301,    -1,    -1,    -1,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
      -1,   379,    -1,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,    -1,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,   431,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    41,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,    -1,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,   431,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    41,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,   185,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,   220,    -1,   222,   223,
     224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,   241,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,    -1,   279,    -1,   281,   282,   283,
     284,   285,    -1,   287,    -1,   289,    -1,   291,   292,    -1,
      -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,   378,   379,   380,   381,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,    -1,   416,   417,    -1,    -1,    -1,    -1,   422,    -1,
     424,    -1,    -1,    -1,    -1,    -1,   430,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,   185,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,   285,    -1,   287,    -1,
     289,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,    -1,   416,   417,    -1,
      -1,    -1,    -1,   422,    -1,   424,    -1,    -1,    -1,    -1,
      -1,   430,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    41,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
     194,    -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,   212,   213,
     214,   215,   216,   217,    -1,    -1,   220,    -1,   222,   223,
     224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,   241,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,    -1,   279,    -1,   281,   282,   283,
     284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,
      -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,   417,    -1,    -1,    -1,    -1,   422,    -1,
       6,     7,     8,     9,    10,    11,   430,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    41,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,   417,    -1,    -1,    -1,    -1,   422,    -1,     6,     7,
       8,     9,    10,    11,   430,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,   201,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
      -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,   374,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,   417,
      -1,     6,     7,     8,     9,    10,    11,   425,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    41,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
      -1,   416,   417,    -1,    -1,   420,   421,   422,    -1,   424,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    41,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,    -1,     4,   419,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    17,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,     6,     7,     8,    -1,    10,
      11,    -1,    13,    14,    15,    -1,    -1,    -1,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    -1,    -1,    -1,    35,    36,    37,    38,    -1,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    -1,
      -1,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,    -1,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,    -1,   140,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   152,   153,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     181,    -1,    -1,   184,    -1,    -1,    -1,   188,    -1,    -1,
      -1,    -1,   193,    -1,   195,    -1,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,    -1,    -1,    -1,   208,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   219,   220,
      -1,    -1,    -1,    -1,    -1,   226,    -1,   228,    -1,    -1,
     231,   232,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   262,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,    -1,    -1,    -1,    -1,   278,    -1,    -1,
     281,   282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   295,   296,   297,   298,    -1,    -1,
      -1,    -1,   303,   304,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   315,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,    -1,
      -1,   332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   346,    -1,    -1,   349,    -1,
     351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   372,   373,    -1,    -1,    -1,    -1,   378,    -1,   380,
      -1,    -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   399,    -1,
     401,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   413,    -1,    -1,   416,    -1,   418,     6,     7,
       8,    -1,    10,    11,    -1,    13,    14,    15,    -1,    -1,
      -1,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    -1,    -1,    -1,    35,    36,    37,
      38,    -1,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    -1,    -1,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    99,    -1,    -1,    -1,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   134,    -1,    -1,    -1,
      -1,    -1,   140,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   152,   153,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   181,    -1,    -1,   184,    -1,    -1,    -1,
     188,    -1,    -1,    -1,    -1,   193,    -1,   195,    -1,    -1,
      -1,    -1,    -1,   201,    -1,    -1,    -1,    -1,    -1,    -1,
     208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   219,   220,    -1,    -1,    -1,    -1,    -1,   226,    -1,
     228,    -1,    -1,   231,   232,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   262,   263,   264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,    -1,    -1,    -1,    -1,
     278,    -1,    -1,   281,   282,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,   296,   297,
     298,    -1,    -1,    -1,    -1,   303,   304,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   315,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   329,    -1,    -1,   332,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   346,    -1,
      -1,   349,    -1,   351,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   372,   373,    -1,    -1,    -1,    -1,
     378,    -1,   380,    -1,    -1,    -1,    -1,    -1,    -1,   387,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   399,    -1,   401,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   413,    -1,    -1,   416,    -1,
     418,     5,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    -1,    46,    47,    48,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,   108,   109,   110,    -1,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,   158,    -1,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   180,   181,   182,    -1,
     184,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,    -1,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,   229,    -1,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,   380,   381,   382,   383,
     384,   385,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,    -1,   398,   399,   400,   401,   402,    -1,
     404,   405,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,     5,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,    -1,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,    -1,   135,    -1,   137,   138,   139,   140,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,    -1,
     182,    -1,    -1,    -1,   186,   187,   188,    -1,   190,    -1,
     192,   193,    -1,   195,   196,    -1,   198,    -1,   200,    -1,
      -1,   203,    -1,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,    -1,   219,   220,    -1,
     222,   223,   224,   225,   226,    -1,   228,    -1,    -1,   231,
     232,   233,   234,   235,   236,   237,   238,   239,    -1,    -1,
     242,   243,   244,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,    -1,   276,   277,   278,   279,    -1,    -1,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,   295,   296,   297,    -1,   299,   300,   301,
      -1,    -1,    -1,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,   349,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,    -1,   379,    -1,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,   401,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,    -1,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,    -1,   135,    -1,   137,   138,   139,
     140,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,    -1,   182,    -1,    -1,    -1,   186,   187,   188,    -1,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,
     200,    -1,    -1,   203,    -1,   205,   206,   207,   208,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,   219,
      -1,    -1,   222,   223,   224,   225,   226,    -1,   228,    -1,
      -1,   231,   232,   233,   234,   235,   236,   237,   238,   239,
      -1,    -1,   242,   243,   244,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,    -1,   276,   277,   278,   279,
      -1,    -1,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,    -1,   296,   297,    -1,   299,
     300,   301,    -1,    -1,    -1,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,   349,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,    -1,   379,
      -1,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,   401,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,   417,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    41,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,   366,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,    -1,    -1,   416,
     417,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    41,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,   374,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
      -1,   416,   417,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,    -1,   416,   417,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    17,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      41,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,    -1,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
      -1,    -1,   233,    -1,   235,   236,   237,   238,   239,    -1,
     241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,    -1,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,    -1,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,    -1,    -1,   416,   417,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,   417,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    41,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,   414,    -1,   416,
     417,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    41,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,    -1,
      -1,   416,   417,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,   417,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      41,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,    -1,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
      -1,    -1,   233,    -1,   235,   236,   237,   238,   239,    -1,
     241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,    -1,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,    -1,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,    -1,    -1,   416,   417,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,   417,     5,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,   107,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,    -1,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,    -1,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,    -1,   182,    -1,    -1,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,    -1,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,   212,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,   225,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,    -1,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,    -1,   274,    -1,
     276,   277,    -1,   279,    -1,    -1,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,    -1,   299,   300,   301,    -1,    -1,    -1,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,    -1,   379,    -1,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     5,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    -1,    46,    47,    48,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,   107,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
      -1,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
      -1,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,    -1,   182,    -1,
      -1,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,    -1,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,    -1,    -1,   222,   223,
     224,   225,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,    -1,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,    -1,   279,    -1,    -1,   282,   283,
     284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,
      -1,    -1,    -1,    -1,    -1,   299,   300,   301,    -1,    -1,
      -1,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,    -1,   379,    -1,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,     5,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,   107,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,    -1,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,    -1,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,    -1,
     182,    -1,    -1,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,    -1,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,    -1,    -1,
     222,   223,   224,   225,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,    -1,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,    -1,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,    -1,    -1,    -1,    -1,   299,   300,   301,
      -1,    -1,    -1,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,    -1,   379,    -1,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,   107,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,    -1,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,    -1,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,    -1,   182,    -1,    -1,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,    -1,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
      -1,    -1,   222,   223,   224,   225,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,    -1,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,    -1,   276,   277,    -1,   279,
     280,    -1,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,    -1,    -1,    -1,    -1,   299,
     300,   301,    -1,    -1,    -1,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,    -1,   379,
      -1,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,   107,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,    -1,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,    -1,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,    -1,   182,    -1,    -1,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,    -1,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,    -1,    -1,   222,   223,   224,   225,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,    -1,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,    -1,   274,    -1,   276,   277,
      -1,   279,    -1,    -1,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,    -1,    -1,    -1,
      -1,   299,   300,   301,    -1,    -1,    -1,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
      -1,   379,    -1,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,     5,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,   107,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,    -1,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,    -1,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,    -1,   182,    -1,    -1,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,    -1,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,    -1,    -1,   222,   223,   224,   225,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,    -1,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,    -1,   274,    -1,
     276,   277,    -1,   279,    -1,    -1,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,    -1,
      -1,    -1,    -1,   299,   300,   301,    -1,    -1,    -1,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
      -1,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,    -1,   379,    -1,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    41,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,   108,   109,   110,    -1,   112,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,    -1,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,    -1,   198,   199,   200,   201,   202,   203,   204,
     205,   206,    -1,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,    -1,   222,   223,   224,
      -1,   226,   227,   228,   229,    -1,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,    -1,   257,   258,    -1,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,    -1,    -1,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,    -1,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,   401,   402,    -1,   404,
     405,   406,   407,   408,   409,    -1,   411,    -1,   413,    -1,
      -1,   416,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    41,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,   140,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,    -1,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,   208,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,   219,   220,    -1,   222,   223,
     224,    -1,   226,    -1,   228,    -1,    -1,   231,   232,   233,
     234,   235,   236,   237,   238,   239,    -1,   241,   242,   243,
     244,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,   278,   279,    -1,   281,   282,   283,
     284,    -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,
      -1,   295,   296,   297,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,   349,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,   401,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,   191,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,   244,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,   136,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,   199,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,   340,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      41,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,   137,   138,   139,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,    -1,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
      -1,    -1,   233,    -1,   235,   236,   237,   238,   239,    -1,
     241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,    -1,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,    -1,    -1,   416,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    88,    89,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,   288,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,   288,
      -1,   290,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,   201,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
      -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,   287,
     288,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,   366,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    41,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,   136,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,   340,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,    -1,    -1,   416,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    41,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    41,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,   194,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,   212,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,    -1,
      -1,   416,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    41,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,   220,    -1,   222,   223,
     224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,   241,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,    -1,   279,    -1,   281,   282,   283,
     284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,
      -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,   393,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
     393,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      41,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    93,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,    -1,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
      -1,    -1,   233,    -1,   235,   236,   237,   238,   239,    -1,
     241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,    -1,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,    -1,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,    -1,    -1,   416,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    93,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,   202,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,   201,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
      -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    41,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,    -1,    -1,   416,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    41,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    41,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283