/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONNECTION = 265,
     SQL_CONTINUE = 266,
     SQL_COUNT = 267,
     SQL_CURRENT = 268,
     SQL_DATA = 269,
     SQL_DATETIME_INTERVAL_CODE = 270,
     SQL_DATETIME_INTERVAL_PRECISION = 271,
     SQL_DESCRIBE = 272,
     SQL_DESCRIPTOR = 273,
     SQL_DISCONNECT = 274,
     SQL_ENUM = 275,
     SQL_FOUND = 276,
     SQL_FREE = 277,
     SQL_GO = 278,
     SQL_GOTO = 279,
     SQL_IDENTIFIED = 280,
     SQL_INDICATOR = 281,
     SQL_KEY_MEMBER = 282,
     SQL_LENGTH = 283,
     SQL_LONG = 284,
     SQL_NAME = 285,
     SQL_NULLABLE = 286,
     SQL_OCTET_LENGTH = 287,
     SQL_OPEN = 288,
     SQL_OUTPUT = 289,
     SQL_RELEASE = 290,
     SQL_REFERENCE = 291,
     SQL_RETURNED_LENGTH = 292,
     SQL_RETURNED_OCTET_LENGTH = 293,
     SQL_SCALE = 294,
     SQL_SECTION = 295,
     SQL_SHORT = 296,
     SQL_SIGNED = 297,
     SQL_SQL = 298,
     SQL_SQLERROR = 299,
     SQL_SQLPRINT = 300,
     SQL_SQLWARNING = 301,
     SQL_START = 302,
     SQL_STOP = 303,
     SQL_STRUCT = 304,
     SQL_UNSIGNED = 305,
     SQL_VALUE = 306,
     SQL_VAR = 307,
     SQL_WHENEVER = 308,
     S_ADD = 309,
     S_AND = 310,
     S_ANYTHING = 311,
     S_AUTO = 312,
     S_CONST = 313,
     S_DEC = 314,
     S_DIV = 315,
     S_DOTPOINT = 316,
     S_EQUAL = 317,
     S_EXTERN = 318,
     S_INC = 319,
     S_LSHIFT = 320,
     S_MEMPOINT = 321,
     S_MEMBER = 322,
     S_MOD = 323,
     S_MUL = 324,
     S_NEQUAL = 325,
     S_OR = 326,
     S_REGISTER = 327,
     S_RSHIFT = 328,
     S_STATIC = 329,
     S_SUB = 330,
     S_VOLATILE = 331,
     S_TYPEDEF = 332,
     TYPECAST = 333,
     ABORT_P = 334,
     ABSOLUTE_P = 335,
     ACCESS = 336,
     ACTION = 337,
     ADD = 338,
     AFTER = 339,
     AGGREGATE = 340,
     ALL = 341,
     ALSO = 342,
     ALTER = 343,
     ANALYSE = 344,
     ANALYZE = 345,
     AND = 346,
     ANY = 347,
     ARRAY = 348,
     AS = 349,
     ASC = 350,
     ASSERTION = 351,
     ASSIGNMENT = 352,
     AT = 353,
     AUTHORIZATION = 354,
     BACKWARD = 355,
     BEFORE = 356,
     BEGIN_P = 357,
     BETWEEN = 358,
     BIGINT = 359,
     BINARY = 360,
     BIT = 361,
     BOOLEAN_P = 362,
     BOTH = 363,
     BY = 364,
     CACHE = 365,
     CALLED = 366,
     CASCADE = 367,
     CASE = 368,
     CAST = 369,
     CHAIN = 370,
     CHAR_P = 371,
     CHARACTER = 372,
     CHARACTERISTICS = 373,
     CHECK = 374,
     CHECKPOINT = 375,
     CLASS = 376,
     CLOSE = 377,
     CLUSTER = 378,
     COALESCE = 379,
     COLLATE = 380,
     COLUMN = 381,
     COMMENT = 382,
     COMMIT = 383,
     COMMITTED = 384,
     CONSTRAINT = 385,
     CONSTRAINTS = 386,
     CONVERSION_P = 387,
     CONVERT = 388,
     COPY = 389,
     CREATE = 390,
     CREATEDB = 391,
     CREATEUSER = 392,
     CROSS = 393,
     CSV = 394,
     CURRENT_DATE = 395,
     CURRENT_TIME = 396,
     CURRENT_TIMESTAMP = 397,
     CURRENT_USER = 398,
     CURSOR = 399,
     CYCLE = 400,
     DATABASE = 401,
     DAY_P = 402,
     DEALLOCATE = 403,
     DEC = 404,
     DECIMAL_P = 405,
     DECLARE = 406,
     DEFAULT = 407,
     DEFAULTS = 408,
     DEFERRABLE = 409,
     DEFERRED = 410,
     DEFINER = 411,
     DELETE_P = 412,
     DELIMITER = 413,
     DELIMITERS = 414,
     DESC = 415,
     DISTINCT = 416,
     DO = 417,
     DOMAIN_P = 418,
     DOUBLE_P = 419,
     DROP = 420,
     EACH = 421,
     ELSE = 422,
     ENCODING = 423,
     ENCRYPTED = 424,
     END_P = 425,
     ESCAPE = 426,
     EXCEPT = 427,
     EXCLUSIVE = 428,
     EXCLUDING = 429,
     EXECUTE = 430,
     EXISTS = 431,
     EXPLAIN = 432,
     EXTERNAL = 433,
     EXTRACT = 434,
     FALSE_P = 435,
     FETCH = 436,
     FIRST_P = 437,
     FLOAT_P = 438,
     FOR = 439,
     FORCE = 440,
     FOREIGN = 441,
     FORWARD = 442,
     FREEZE = 443,
     FROM = 444,
     FULL = 445,
     FUNCTION = 446,
     GET = 447,
     GLOBAL = 448,
     GRANT = 449,
     GROUP_P = 450,
     HANDLER = 451,
     HAVING = 452,
     HOLD = 453,
     HOUR_P = 454,
     ILIKE = 455,
     IMMEDIATE = 456,
     IMMUTABLE = 457,
     IMPLICIT_P = 458,
     IN_P = 459,
     INCLUDING = 460,
     INCREMENT = 461,
     INDEX = 462,
     INHERITS = 463,
     INITIALLY = 464,
     INNER_P = 465,
     INOUT = 466,
     INPUT_P = 467,
     INSENSITIVE = 468,
     INSERT = 469,
     INSTEAD = 470,
     INT_P = 471,
     INTEGER = 472,
     INTERSECT = 473,
     INTERVAL = 474,
     INTO = 475,
     INVOKER = 476,
     IS = 477,
     ISNULL = 478,
     ISOLATION = 479,
     JOIN = 480,
     KEY = 481,
     LANCOMPILER = 482,
     LANGUAGE = 483,
     LARGE_P = 484,
     LAST_P = 485,
     LEADING = 486,
     LEFT = 487,
     LEVEL = 488,
     LIKE = 489,
     LIMIT = 490,
     LISTEN = 491,
     LOAD = 492,
     LOCAL = 493,
     LOCATION = 494,
     LOCK_P = 495,
     MATCH = 496,
     MAXVALUE = 497,
     MINUTE_P = 498,
     MINVALUE = 499,
     MODE = 500,
     MONTH_P = 501,
     MOVE = 502,
     NAMES = 503,
     NATIONAL = 504,
     NATURAL = 505,
     NCHAR = 506,
     NEW = 507,
     NEXT = 508,
     NO = 509,
     NOCREATEDB = 510,
     NOCREATEUSER = 511,
     NONE = 512,
     NOT = 513,
     NOTHING = 514,
     NOTIFY = 515,
     NOTNULL = 516,
     NOWAIT = 517,
     NULL_P = 518,
     NULLIF = 519,
     NUMERIC = 520,
     OBJECT_P = 521,
     OF = 522,
     OFF = 523,
     OFFSET = 524,
     OIDS = 525,
     OLD = 526,
     ON = 527,
     ONLY = 528,
     OPERATOR = 529,
     OPTION = 530,
     OR = 531,
     ORDER = 532,
     OUT_P = 533,
     OUTER_P = 534,
     OVERLAPS = 535,
     OVERLAY = 536,
     OWNER = 537,
     PARTIAL = 538,
     PASSWORD = 539,
     PLACING = 540,
     POSITION = 541,
     PRECISION = 542,
     PRESERVE = 543,
     PREPARE = 544,
     PRIMARY = 545,
     PRIOR = 546,
     PRIVILEGES = 547,
     PROCEDURAL = 548,
     PROCEDURE = 549,
     QUOTE = 550,
     READ = 551,
     REAL = 552,
     RECHECK = 553,
     REFERENCES = 554,
     REINDEX = 555,
     RELATIVE_P = 556,
     RENAME = 557,
     REPEATABLE = 558,
     REPLACE = 559,
     RESET = 560,
     RESTART = 561,
     RESTRICT = 562,
     RETURNS = 563,
     REVOKE = 564,
     RIGHT = 565,
     ROLLBACK = 566,
     ROW = 567,
     ROWS = 568,
     RULE = 569,
     SCHEMA = 570,
     SCROLL = 571,
     SECOND_P = 572,
     SECURITY = 573,
     SELECT = 574,
     SEQUENCE = 575,
     SERIALIZABLE = 576,
     SESSION = 577,
     SESSION_USER = 578,
     SET = 579,
     SETOF = 580,
     SHARE = 581,
     SHOW = 582,
     SIMILAR = 583,
     SIMPLE = 584,
     SMALLINT = 585,
     SOME = 586,
     STABLE = 587,
     START = 588,
     STATEMENT = 589,
     STATISTICS = 590,
     STDIN = 591,
     STDOUT = 592,
     STORAGE = 593,
     STRICT_P = 594,
     SUBSTRING = 595,
     SYSID = 596,
     TABLE = 597,
     TABLESPACE = 598,
     TEMP = 599,
     TEMPLATE = 600,
     TEMPORARY = 601,
     THEN = 602,
     TIME = 603,
     TIMESTAMP = 604,
     TO = 605,
     TOAST = 606,
     TRAILING = 607,
     TRANSACTION = 608,
     TREAT = 609,
     TRIGGER = 610,
     TRIM = 611,
     TRUE_P = 612,
     TRUNCATE = 613,
     TRUSTED = 614,
     TYPE_P = 615,
     UNCOMMITTED = 616,
     UNENCRYPTED = 617,
     UNION = 618,
     UNIQUE = 619,
     UNKNOWN = 620,
     UNLISTEN = 621,
     UNTIL = 622,
     UPDATE = 623,
     USAGE = 624,
     USER = 625,
     USING = 626,
     VACUUM = 627,
     VALID = 628,
     VALUES = 629,
     VARCHAR = 630,
     VARYING = 631,
     VERBOSE = 632,
     VIEW = 633,
     VOLATILE = 634,
     WHEN = 635,
     WHERE = 636,
     WITH = 637,
     WITHOUT = 638,
     WORK = 639,
     WRITE = 640,
     YEAR_P = 641,
     ZONE = 642,
     UNIONJOIN = 643,
     IDENT = 644,
     SCONST = 645,
     Op = 646,
     CSTRING = 647,
     CVARIABLE = 648,
     CPP_LINE = 649,
     IP = 650,
     BCONST = 651,
     XCONST = 652,
     ICONST = 653,
     PARAM = 654,
     FCONST = 655,
     POSTFIXOP = 656,
     UMINUS = 657
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONNECTION 265
#define SQL_CONTINUE 266
#define SQL_COUNT 267
#define SQL_CURRENT 268
#define SQL_DATA 269
#define SQL_DATETIME_INTERVAL_CODE 270
#define SQL_DATETIME_INTERVAL_PRECISION 271
#define SQL_DESCRIBE 272
#define SQL_DESCRIPTOR 273
#define SQL_DISCONNECT 274
#define SQL_ENUM 275
#define SQL_FOUND 276
#define SQL_FREE 277
#define SQL_GO 278
#define SQL_GOTO 279
#define SQL_IDENTIFIED 280
#define SQL_INDICATOR 281
#define SQL_KEY_MEMBER 282
#define SQL_LENGTH 283
#define SQL_LONG 284
#define SQL_NAME 285
#define SQL_NULLABLE 286
#define SQL_OCTET_LENGTH 287
#define SQL_OPEN 288
#define SQL_OUTPUT 289
#define SQL_RELEASE 290
#define SQL_REFERENCE 291
#define SQL_RETURNED_LENGTH 292
#define SQL_RETURNED_OCTET_LENGTH 293
#define SQL_SCALE 294
#define SQL_SECTION 295
#define SQL_SHORT 296
#define SQL_SIGNED 297
#define SQL_SQL 298
#define SQL_SQLERROR 299
#define SQL_SQLPRINT 300
#define SQL_SQLWARNING 301
#define SQL_START 302
#define SQL_STOP 303
#define SQL_STRUCT 304
#define SQL_UNSIGNED 305
#define SQL_VALUE 306
#define SQL_VAR 307
#define SQL_WHENEVER 308
#define S_ADD 309
#define S_AND 310
#define S_ANYTHING 311
#define S_AUTO 312
#define S_CONST 313
#define S_DEC 314
#define S_DIV 315
#define S_DOTPOINT 316
#define S_EQUAL 317
#define S_EXTERN 318
#define S_INC 319
#define S_LSHIFT 320
#define S_MEMPOINT 321
#define S_MEMBER 322
#define S_MOD 323
#define S_MUL 324
#define S_NEQUAL 325
#define S_OR 326
#define S_REGISTER 327
#define S_RSHIFT 328
#define S_STATIC 329
#define S_SUB 330
#define S_VOLATILE 331
#define S_TYPEDEF 332
#define TYPECAST 333
#define ABORT_P 334
#define ABSOLUTE_P 335
#define ACCESS 336
#define ACTION 337
#define ADD 338
#define AFTER 339
#define AGGREGATE 340
#define ALL 341
#define ALSO 342
#define ALTER 343
#define ANALYSE 344
#define ANALYZE 345
#define AND 346
#define ANY 347
#define ARRAY 348
#define AS 349
#define ASC 350
#define ASSERTION 351
#define ASSIGNMENT 352
#define AT 353
#define AUTHORIZATION 354
#define BACKWARD 355
#define BEFORE 356
#define BEGIN_P 357
#define BETWEEN 358
#define BIGINT 359
#define BINARY 360
#define BIT 361
#define BOOLEAN_P 362
#define BOTH 363
#define BY 364
#define CACHE 365
#define CALLED 366
#define CASCADE 367
#define CASE 368
#define CAST 369
#define CHAIN 370
#define CHAR_P 371
#define CHARACTER 372
#define CHARACTERISTICS 373
#define CHECK 374
#define CHECKPOINT 375
#define CLASS 376
#define CLOSE 377
#define CLUSTER 378
#define COALESCE 379
#define COLLATE 380
#define COLUMN 381
#define COMMENT 382
#define COMMIT 383
#define COMMITTED 384
#define CONSTRAINT 385
#define CONSTRAINTS 386
#define CONVERSION_P 387
#define CONVERT 388
#define COPY 389
#define CREATE 390
#define CREATEDB 391
#define CREATEUSER 392
#define CROSS 393
#define CSV 394
#define CURRENT_DATE 395
#define CURRENT_TIME 396
#define CURRENT_TIMESTAMP 397
#define CURRENT_USER 398
#define CURSOR 399
#define CYCLE 400
#define DATABASE 401
#define DAY_P 402
#define DEALLOCATE 403
#define DEC 404
#define DECIMAL_P 405
#define DECLARE 406
#define DEFAULT 407
#define DEFAULTS 408
#define DEFERRABLE 409
#define DEFERRED 410
#define DEFINER 411
#define DELETE_P 412
#define DELIMITER 413
#define DELIMITERS 414
#define DESC 415
#define DISTINCT 416
#define DO 417
#define DOMAIN_P 418
#define DOUBLE_P 419
#define DROP 420
#define EACH 421
#define ELSE 422
#define ENCODING 423
#define ENCRYPTED 424
#define END_P 425
#define ESCAPE 426
#define EXCEPT 427
#define EXCLUSIVE 428
#define EXCLUDING 429
#define EXECUTE 430
#define EXISTS 431
#define EXPLAIN 432
#define EXTERNAL 433
#define EXTRACT 434
#define FALSE_P 435
#define FETCH 436
#define FIRST_P 437
#define FLOAT_P 438
#define FOR 439
#define FORCE 440
#define FOREIGN 441
#define FORWARD 442
#define FREEZE 443
#define FROM 444
#define FULL 445
#define FUNCTION 446
#define GET 447
#define GLOBAL 448
#define GRANT 449
#define GROUP_P 450
#define HANDLER 451
#define HAVING 452
#define HOLD 453
#define HOUR_P 454
#define ILIKE 455
#define IMMEDIATE 456
#define IMMUTABLE 457
#define IMPLICIT_P 458
#define IN_P 459
#define INCLUDING 460
#define INCREMENT 461
#define INDEX 462
#define INHERITS 463
#define INITIALLY 464
#define INNER_P 465
#define INOUT 466
#define INPUT_P 467
#define INSENSITIVE 468
#define INSERT 469
#define INSTEAD 470
#define INT_P 471
#define INTEGER 472
#define INTERSECT 473
#define INTERVAL 474
#define INTO 475
#define INVOKER 476
#define IS 477
#define ISNULL 478
#define ISOLATION 479
#define JOIN 480
#define KEY 481
#define LANCOMPILER 482
#define LANGUAGE 483
#define LARGE_P 484
#define LAST_P 485
#define LEADING 486
#define LEFT 487
#define LEVEL 488
#define LIKE 489
#define LIMIT 490
#define LISTEN 491
#define LOAD 492
#define LOCAL 493
#define LOCATION 494
#define LOCK_P 495
#define MATCH 496
#define MAXVALUE 497
#define MINUTE_P 498
#define MINVALUE 499
#define MODE 500
#define MONTH_P 501
#define MOVE 502
#define NAMES 503
#define NATIONAL 504
#define NATURAL 505
#define NCHAR 506
#define NEW 507
#define NEXT 508
#define NO 509
#define NOCREATEDB 510
#define NOCREATEUSER 511
#define NONE 512
#define NOT 513
#define NOTHING 514
#define NOTIFY 515
#define NOTNULL 516
#define NOWAIT 517
#define NULL_P 518
#define NULLIF 519
#define NUMERIC 520
#define OBJECT_P 521
#define OF 522
#define OFF 523
#define OFFSET 524
#define OIDS 525
#define OLD 526
#define ON 527
#define ONLY 528
#define OPERATOR 529
#define OPTION 530
#define OR 531
#define ORDER 532
#define OUT_P 533
#define OUTER_P 534
#define OVERLAPS 535
#define OVERLAY 536
#define OWNER 537
#define PARTIAL 538
#define PASSWORD 539
#define PLACING 540
#define POSITION 541
#define PRECISION 542
#define PRESERVE 543
#define PREPARE 544
#define PRIMARY 545
#define PRIOR 546
#define PRIVILEGES 547
#define PROCEDURAL 548
#define PROCEDURE 549
#define QUOTE 550
#define READ 551
#define REAL 552
#define RECHECK 553
#define REFERENCES 554
#define REINDEX 555
#define RELATIVE_P 556
#define RENAME 557
#define REPEATABLE 558
#define REPLACE 559
#define RESET 560
#define RESTART 561
#define RESTRICT 562
#define RETURNS 563
#define REVOKE 564
#define RIGHT 565
#define ROLLBACK 566
#define ROW 567
#define ROWS 568
#define RULE 569
#define SCHEMA 570
#define SCROLL 571
#define SECOND_P 572
#define SECURITY 573
#define SELECT 574
#define SEQUENCE 575
#define SERIALIZABLE 576
#define SESSION 577
#define SESSION_USER 578
#define SET 579
#define SETOF 580
#define SHARE 581
#define SHOW 582
#define SIMILAR 583
#define SIMPLE 584
#define SMALLINT 585
#define SOME 586
#define STABLE 587
#define START 588
#define STATEMENT 589
#define STATISTICS 590
#define STDIN 591
#define STDOUT 592
#define STORAGE 593
#define STRICT_P 594
#define SUBSTRING 595
#define SYSID 596
#define TABLE 597
#define TABLESPACE 598
#define TEMP 599
#define TEMPLATE 600
#define TEMPORARY 601
#define THEN 602
#define TIME 603
#define TIMESTAMP 604
#define TO 605
#define TOAST 606
#define TRAILING 607
#define TRANSACTION 608
#define TREAT 609
#define TRIGGER 610
#define TRIM 611
#define TRUE_P 612
#define TRUNCATE 613
#define TRUSTED 614
#define TYPE_P 615
#define UNCOMMITTED 616
#define UNENCRYPTED 617
#define UNION 618
#define UNIQUE 619
#define UNKNOWN 620
#define UNLISTEN 621
#define UNTIL 622
#define UPDATE 623
#define USAGE 624
#define USER 625
#define USING 626
#define VACUUM 627
#define VALID 628
#define VALUES 629
#define VARCHAR 630
#define VARYING 631
#define VERBOSE 632
#define VIEW 633
#define VOLATILE 634
#define WHEN 635
#define WHERE 636
#define WITH 637
#define WITHOUT 638
#define WORK 639
#define WRITE 640
#define YEAR_P 641
#define ZONE 642
#define UNIONJOIN 643
#define IDENT 644
#define SCONST 645
#define Op 646
#define CSTRING 647
#define CVARIABLE 648
#define CPP_LINE 649
#define IP 650
#define BCONST 651
#define XCONST 652
#define ICONST 653
#define PARAM 654
#define FCONST 655
#define POSTFIXOP 656
#define UMINUS 657




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;
	
	fprintf(stderr, "%s:%d: ", input_filename, yylineno);
	
	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);
	
	fprintf(stderr, "\n");
	
	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct 
	 * An array is only allowed together with an element argument 
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else 
	 * so we don't have to worry here. */
	
	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * This breaks standard and leads to some very dangerous programming. 
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;
		
	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);
		
		if ((ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}
		
		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		
		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);
			
			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}
	if (insert)
	{
		/* add all those input variables that were given earlier 
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);
	
	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 300 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1189 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1201 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   49952

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  423
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  511
/* YYNRULES -- Number of rules. */
#define YYNRULES  1930
/* YYNRULES -- Number of states. */
#define YYNSTATES  3171

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   658

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   409,     2,     2,
     414,   415,   407,   405,   420,   406,   416,   408,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   422,   417,
     402,   401,   403,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   412,     2,   413,   410,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   418,     2,   419,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   404,   411,   421
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   220,   226,   228,
     229,   234,   240,   246,   251,   255,   258,   259,   262,   265,
     267,   269,   271,   273,   277,   281,   285,   287,   292,   298,
     301,   302,   305,   308,   315,   322,   326,   334,   340,   342,
     343,   346,   347,   349,   351,   353,   355,   357,   359,   362,
     366,   370,   374,   378,   382,   385,   391,   394,   398,   402,
     404,   408,   410,   412,   414,   418,   421,   424,   427,   429,
     431,   433,   435,   437,   439,   441,   443,   445,   447,   451,
     458,   460,   462,   464,   466,   467,   469,   471,   474,   478,
     483,   487,   490,   493,   497,   502,   506,   509,   514,   516,
     518,   520,   522,   524,   529,   531,   535,   539,   544,   551,
     558,   565,   572,   577,   584,   587,   592,   596,   600,   604,
     608,   612,   616,   620,   623,   625,   627,   628,   631,   632,
     635,   645,   647,   649,   651,   653,   655,   658,   659,   661,
     663,   667,   671,   673,   677,   681,   685,   690,   692,   693,
     696,   697,   701,   702,   704,   705,   717,   730,   732,   734,
     737,   740,   743,   746,   747,   749,   750,   752,   756,   758,
     760,   762,   766,   769,   770,   774,   776,   778,   781,   783,
     785,   788,   793,   796,   802,   804,   807,   810,   813,   817,
     820,   823,   824,   828,   830,   835,   840,   846,   858,   862,
     863,   867,   869,   871,   874,   877,   878,   880,   882,   885,
     888,   889,   893,   897,   900,   902,   904,   907,   910,   915,
     916,   919,   922,   923,   927,   932,   937,   938,   941,   942,
     943,   952,   956,   960,   962,   966,   967,   971,   973,   975,
     981,   986,   989,   990,   993,   995,   998,  1002,  1005,  1008,
    1011,  1014,  1018,  1022,  1024,  1025,  1034,  1036,  1037,  1039,
    1042,  1045,  1046,  1052,  1054,  1055,  1062,  1065,  1066,  1070,
    1085,  1105,  1107,  1109,  1111,  1115,  1121,  1123,  1125,  1127,
    1131,  1132,  1134,  1135,  1137,  1139,  1141,  1145,  1146,  1148,
    1150,  1151,  1154,  1156,  1159,  1161,  1164,  1167,  1169,  1172,
    1175,  1182,  1191,  1195,  1200,  1205,  1210,  1216,  1220,  1224,
    1226,  1230,  1234,  1236,  1238,  1240,  1242,  1255,  1257,  1261,
    1266,  1274,  1279,  1282,  1284,  1285,  1287,  1288,  1296,  1301,
    1303,  1305,  1307,  1309,  1311,  1313,  1315,  1317,  1319,  1323,
    1325,  1328,  1331,  1335,  1339,  1345,  1350,  1355,  1359,  1364,
    1368,  1372,  1375,  1380,  1383,  1385,  1387,  1389,  1391,  1394,
    1397,  1399,  1401,  1403,  1406,  1409,  1411,  1414,  1417,  1419,
    1421,  1423,  1430,  1440,  1448,  1458,  1467,  1476,  1483,  1493,
    1501,  1512,  1520,  1522,  1524,  1526,  1528,  1530,  1532,  1534,
    1536,  1538,  1540,  1542,  1544,  1552,  1561,  1564,  1566,  1568,
    1570,  1574,  1576,  1578,  1580,  1582,  1584,  1586,  1588,  1590,
    1592,  1594,  1596,  1598,  1600,  1603,  1606,  1609,  1612,  1615,
    1618,  1620,  1624,  1626,  1629,  1633,  1634,  1638,  1639,  1641,
    1645,  1648,  1661,  1663,  1664,  1667,  1668,  1670,  1674,  1677,
    1683,  1688,  1690,  1693,  1694,  1704,  1707,  1708,  1712,  1715,
    1717,  1721,  1725,  1728,  1730,  1732,  1734,  1735,  1737,  1741,
    1743,  1745,  1747,  1752,  1754,  1757,  1760,  1763,  1765,  1767,
    1769,  1774,  1780,  1782,  1786,  1790,  1793,  1796,  1799,  1800,
    1806,  1814,  1816,  1818,  1826,  1828,  1832,  1836,  1840,  1842,
    1846,  1858,  1869,  1872,  1873,  1882,  1887,  1892,  1894,  1896,
    1898,  1899,  1909,  1916,  1923,  1931,  1938,  1945,  1955,  1962,
    1969,  1978,  1987,  1994,  2001,  2003,  2004,  2014,  2021,  2028,
    2035,  2043,  2053,  2063,  2070,  2077,  2084,  2085,  2100,  2102,
    2104,  2108,  2112,  2114,  2116,  2118,  2120,  2122,  2124,  2126,
    2127,  2129,  2131,  2133,  2135,  2137,  2139,  2140,  2147,  2150,
    2153,  2156,  2159,  2162,  2166,  2170,  2173,  2176,  2179,  2181,
    2183,  2184,  2188,  2190,  2195,  2200,  2202,  2203,  2206,  2209,
    2217,  2220,  2226,  2230,  2232,  2235,  2239,  2243,  2247,  2251,
    2255,  2259,  2263,  2267,  2271,  2275,  2277,  2278,  2284,  2289,
    2293,  2300,  2305,  2312,  2319,  2325,  2333,  2335,  2336,  2347,
    2352,  2355,  2357,  2362,  2368,  2374,  2377,  2382,  2384,  2386,
    2388,  2389,  2391,  2392,  2394,  2395,  2399,  2400,  2405,  2407,
    2409,  2411,  2413,  2415,  2417,  2418,  2423,  2428,  2431,  2433,
    2441,  2446,  2450,  2452,  2455,  2460,  2466,  2470,  2471,  2474,
    2477,  2480,  2484,  2486,  2490,  2492,  2495,  2497,  2498,  2505,
    2513,  2514,  2517,  2520,  2523,  2527,  2528,  2531,  2534,  2536,
    2538,  2542,  2546,  2548,  2551,  2556,  2561,  2563,  2565,  2574,
    2579,  2584,  2589,  2592,  2594,  2595,  2599,  2603,  2608,  2613,
    2618,  2623,  2626,  2628,  2630,  2631,  2633,  2634,  2636,  2642,
    2644,  2645,  2647,  2648,  2652,  2654,  2658,  2662,  2665,  2668,
    2670,  2675,  2680,  2683,  2686,  2691,  2693,  2694,  2696,  2698,
    2700,  2704,  2705,  2708,  2709,  2713,  2717,  2719,  2720,  2723,
    2724,  2727,  2728,  2732,  2734,  2736,  2739,  2741,  2744,  2750,
    2757,  2763,  2765,  2768,  2770,  2775,  2779,  2784,  2788,  2794,
    2799,  2805,  2810,  2816,  2819,  2824,  2826,  2829,  2832,  2835,
    2837,  2839,  2840,  2845,  2848,  2850,  2853,  2856,  2861,  2865,
    2870,  2873,  2874,  2876,  2880,  2883,  2886,  2890,  2896,  2903,
    2907,  2912,  2913,  2915,  2919,  2923,  2927,  2931,  2935,  2939,
    2941,  2943,  2945,  2947,  2949,  2951,  2953,  2956,  2962,  2965,
    2967,  2969,  2971,  2973,  2975,  2977,  2979,  2981,  2983,  2985,
    2987,  2990,  2993,  2996,  2999,  3002,  3004,  3008,  3009,  3015,
    3019,  3020,  3026,  3030,  3031,  3033,  3035,  3037,  3039,  3045,
    3048,  3050,  3052,  3054,  3056,  3062,  3065,  3068,  3071,  3073,
    3077,  3081,  3084,  3086,  3087,  3091,  3092,  3098,  3101,  3107,
    3110,  3112,  3116,  3120,  3121,  3123,  3125,  3127,  3129,  3131,
    3133,  3137,  3141,  3145,  3149,  3153,  3157,  3161,  3162,  3164,
    3168,  3174,  3177,  3180,  3183,  3186,  3189,  3192,  3196,  3200,
    3204,  3208,  3212,  3216,  3220,  3224,  3228,  3232,  3235,  3238,
    3242,  3246,  3249,  3253,  3259,  3264,  3271,  3275,  3281,  3286,
    3293,  3298,  3305,  3311,  3319,  3322,  3326,  3329,  3334,  3338,
    3343,  3347,  3352,  3356,  3361,  3367,  3374,  3382,  3388,  3395,
    3399,  3404,  3409,  3416,  3419,  3421,  3425,  3428,  3431,  3434,
    3437,  3440,  3444,  3448,  3452,  3456,  3460,  3464,  3468,  3472,
    3476,  3480,  3483,  3486,  3492,  3499,  3507,  3509,  3511,  3514,
    3519,  3521,  3525,  3530,  3536,  3542,  3547,  3549,  3552,  3557,
    3560,  3565,  3568,  3571,  3574,  3581,  3586,  3591,  3596,  3601,
    3608,  3614,  3620,  3626,  3631,  3638,  3643,  3645,  3648,  3651,
    3654,  3656,  3661,  3665,  3671,  3673,  3675,  3677,  3679,  3681,
    3683,  3685,  3687,  3689,  3691,  3693,  3695,  3697,  3699,  3701,
    3706,  3708,  3713,  3715,  3720,  3722,  3725,  3727,  3730,  3732,
    3736,  3740,  3741,  3745,  3747,  3749,  3753,  3757,  3761,  3763,
    3765,  3767,  3769,  3771,  3773,  3775,  3777,  3782,  3786,  3789,
    3793,  3794,  3798,  3802,  3805,  3808,  3810,  3811,  3814,  3817,
    3821,  3824,  3826,  3828,  3832,  3838,  3845,  3850,  3853,  3855,
    3860,  3863,  3864,  3866,  3867,  3869,  3872,  3875,  3878,  3882,
    3888,  3890,  3893,  3894,  3897,  3900,  3901,  3905,  3907,  3911,
    3913,  3915,  3919,  3927,  3929,  3932,  3937,  3939,  3943,  3948,
    3953,  3957,  3959,  3961,  3963,  3965,  3967,  3969,  3973,  3975,
    3978,  3980,  3984,  3986,  3988,  3990,  3992,  3994,  3996,  3998,
    4001,  4003,  4006,  4010,  4017,  4019,  4021,  4023,  4025,  4027,
    4029,  4031,  4033,  4035,  4037,  4039,  4041,  4044,  4046,  4048,
    4050,  4052,  4055,  4058,  4060,  4062,  4064,  4066,  4068,  4070,
    4072,  4074,  4077,  4080,  4082,  4084,  4086,  4088,  4090,  4092,
    4094,  4096,  4098,  4100,  4102,  4104,  4110,  4114,  4117,  4120,
    4124,  4132,  4134,  4136,  4139,  4142,  4144,  4145,  4147,  4151,
    4153,  4156,  4157,  4160,  4161,  4164,  4165,  4167,  4171,  4176,
    4180,  4182,  4184,  4186,  4189,  4190,  4198,  4202,  4205,  4207,
    4209,  4211,  4212,  4218,  4219,  4224,  4227,  4229,  4232,  4233,
    4235,  4239,  4243,  4247,  4251,  4252,  4257,  4263,  4269,  4270,
    4272,  4274,  4276,  4279,  4282,  4284,  4287,  4288,  4296,  4297,
    4303,  4304,  4309,  4312,  4315,  4317,  4319,  4321,  4323,  4325,
    4327,  4329,  4331,  4333,  4335,  4337,  4343,  4346,  4348,  4352,
    4355,  4358,  4362,  4363,  4369,  4371,  4372,  4378,  4381,  4384,
    4386,  4388,  4390,  4393,  4396,  4400,  4402,  4405,  4408,  4412,
    4416,  4421,  4424,  4426,  4429,  4431,  4433,  4436,  4439,  4443,
    4445,  4447,  4449,  4451,  4452,  4454,  4458,  4463,  4464,  4467,
    4468,  4470,  4473,  4477,  4480,  4482,  4484,  4486,  4487,  4489,
    4491,  4495,  4496,  4501,  4504,  4507,  4509,  4511,  4512,  4514,
    4516,  4518,  4520,  4523,  4527,  4528,  4530,  4533,  4535,  4540,
    4545,  4546,  4548,  4551,  4553,  4555,  4559,  4561,  4563,  4568,
    4573,  4578,  4583,  4585,  4586,  4590,  4594,  4599,  4601,  4605,
    4609,  4614,  4616,  4620,  4624,  4626,  4633,  4635,  4639,  4643,
    4650,  4652,  4656,  4660,  4662,  4664,  4666,  4668,  4670,  4672,
    4674,  4676,  4678,  4680,  4682,  4684,  4686,  4688,  4690,  4693,
    4698,  4703,  4705,  4707,  4712,  4717,  4721,  4722,  4730,  4732,
    4733,  4734,  4742,  4746,  4751,  4755,  4757,  4759,  4761,  4764,
    4768,  4774,  4777,  4783,  4786,  4788,  4790,  4792,  4794,  4796,
    4798,  4800,  4802,  4804,  4806,  4808,  4810,  4812,  4814,  4816,
    4818,  4820,  4822,  4824,  4826,  4828,  4830,  4832,  4834,  4836,
    4838,  4840,  4842,  4844,  4846,  4848,  4850,  4852,  4854,  4856,
    4858,  4860,  4862,  4864,  4866,  4868,  4870,  4872,  4874,  4876,
    4878,  4880,  4882,  4884,  4886,  4888,  4890,  4892,  4894,  4896,
    4898,  4900,  4902,  4904,  4906,  4908,  4910,  4912,  4914,  4916,
    4918,  4920,  4922,  4924,  4926,  4928,  4930,  4932,  4934,  4936,
    4938,  4940,  4942,  4944,  4946,  4948,  4950,  4952,  4954,  4956,
    4958,  4960,  4962,  4964,  4966,  4968,  4970,  4972,  4974,  4976,
    4978,  4980,  4982,  4984,  4986,  4988,  4990,  4992,  4994,  4996,
    4998,  5000,  5002,  5004,  5006,  5008,  5010,  5012,  5014,  5016,
    5018,  5020,  5022,  5024,  5026,  5028,  5030,  5032,  5034,  5036,
    5038,  5040,  5042,  5044,  5046,  5048,  5050,  5052,  5054,  5056,
    5058,  5060,  5062,  5064,  5066,  5068,  5070,  5072,  5074,  5076,
    5078,  5080,  5082,  5084,  5086,  5088,  5090,  5092,  5094,  5096,
    5098,  5100,  5102,  5104,  5106,  5108,  5110,  5112,  5114,  5116,
    5118,  5120,  5122,  5124,  5126,  5128,  5130,  5132,  5134,  5136,
    5138,  5140,  5142,  5144,  5146,  5148,  5150,  5152,  5154,  5156,
    5158,  5160,  5162,  5164,  5166,  5168,  5170,  5172,  5174,  5176,
    5178,  5180,  5182,  5184,  5186,  5188,  5190,  5192,  5194,  5196,
    5198,  5200,  5202,  5204,  5206,  5208,  5210,  5212,  5214,  5216,
    5218,  5220,  5222,  5224,  5226,  5228,  5230,  5232,  5234,  5236,
    5238,  5240,  5242,  5244,  5246,  5248,  5250,  5252,  5254,  5256,
    5258,  5260,  5262,  5264,  5266,  5268,  5270,  5272,  5274,  5276,
    5278,  5280,  5282,  5284,  5286,  5288,  5290,  5292,  5294,  5296,
    5298,  5300,  5302,  5304,  5306,  5308,  5310,  5312,  5314,  5316,
    5318,  5320,  5322,  5324,  5326,  5328,  5330,  5332,  5334,  5336,
    5338,  5340,  5342,  5344,  5346,  5348,  5350,  5352,  5354,  5356,
    5358,  5360,  5362,  5364,  5366,  5368,  5370,  5372,  5374,  5376,
    5378,  5380,  5382,  5384,  5386,  5388,  5390,  5392,  5394,  5396,
    5398,  5400,  5402,  5404,  5406,  5408,  5410,  5412,  5414,  5416,
    5418,  5420,  5422,  5424,  5426,  5428,  5430,  5432,  5434,  5436,
    5438,  5440,  5442,  5444,  5446,  5448,  5450,  5452,  5454,  5456,
    5458,  5460,  5462,  5464,  5466,  5468,  5470,  5472,  5474,  5476,
    5478,  5480,  5482,  5484,  5486,  5488,  5490,  5492,  5494,  5496,
    5498,  5500,  5502,  5504,  5506,  5508,  5510,  5512,  5514,  5516,
    5518,  5520,  5522,  5524,  5526,  5528,  5530,  5532,  5534,  5536,
    5538,  5540,  5542,  5544,  5546,  5548,  5552,  5554,  5555,  5557,
    5560,  5562,  5565,  5567,  5569,  5572,  5575,  5577,  5579,  5581,
    5583,  5585,  5587,  5590,  5594,  5596,  5599,  5601,  5605,  5607,
    5611,  5613,  5615,  5617,  5619,  5621,  5623,  5625,  5627,  5629,
    5631,  5633,  5635,  5637,  5639,  5641,  5643,  5645,  5647,  5649,
    5651,  5653,  5655,  5657,  5659,  5661,  5663,  5665,  5667,  5669,
    5671,  5673,  5675,  5677,  5679,  5681,  5683,  5685,  5687,  5689,
    5691,  5693,  5695,  5697,  5699,  5701,  5703,  5705,  5707,  5709,
    5711,  5713,  5715,  5717,  5719,  5721,  5723,  5725,  5727,  5729,
    5731
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     424,     0,    -1,   425,    -1,    -1,   425,   426,    -1,   919,
     427,   428,   417,    -1,   919,   428,   417,    -1,   919,   811,
      -1,   819,    -1,   932,    -1,   394,    -1,   418,    -1,   419,
      -1,    98,   797,    -1,   635,    -1,   638,    -1,   440,    -1,
     611,    -1,   512,    -1,   463,    -1,   432,    -1,   431,    -1,
     643,    -1,   462,    -1,   469,    -1,   641,    -1,   563,    -1,
     459,    -1,   470,    -1,   505,    -1,   539,    -1,   603,    -1,
     640,    -1,   637,    -1,   584,    -1,   437,    -1,   516,    -1,
     547,    -1,   442,    -1,   511,    -1,   479,    -1,   525,    -1,
     522,    -1,   429,    -1,   631,    -1,   662,    -1,   541,    -1,
     656,    -1,   540,    -1,   605,    -1,   441,    -1,   552,    -1,
     520,    -1,   620,    -1,   553,    -1,   524,    -1,   538,    -1,
     433,    -1,   636,    -1,   649,    -1,   559,    -1,   566,    -1,
     578,    -1,   652,    -1,   622,    -1,   630,    -1,   657,    -1,
     621,    -1,   606,    -1,   598,    -1,   600,    -1,   597,    -1,
     609,    -1,   567,    -1,   612,    -1,   665,    -1,   624,    -1,
     558,    -1,   623,    -1,   661,    -1,   642,    -1,   446,    -1,
     457,    -1,   458,    -1,   629,    -1,   873,    -1,   796,    -1,
     809,    -1,   810,    -1,   874,    -1,   851,    -1,   871,    -1,
     852,    -1,   855,    -1,   860,    -1,   882,    -1,   875,    -1,
     861,    -1,   870,    -1,   889,    -1,   890,    -1,   892,    -1,
     885,    -1,   878,    -1,   893,    -1,   896,    -1,   898,    -1,
     135,   370,   794,   430,   434,    -1,   382,    -1,    -1,    88,
     370,   794,   434,    -1,    88,   370,   794,   382,   434,    -1,
      88,   370,   794,   324,   447,    -1,    88,   370,   794,   458,
      -1,   165,   370,   436,    -1,   434,   435,    -1,    -1,   284,
     784,    -1,   341,   785,    -1,   136,    -1,   255,    -1,   137,
      -1,   256,    -1,   204,   195,   436,    -1,   373,   367,   784,
      -1,   436,   420,   794,    -1,   794,    -1,   135,   195,   794,
     438,    -1,   135,   195,   794,   382,   438,    -1,   438,   439,
      -1,    -1,   370,   436,    -1,   341,   785,    -1,    88,   195,
     794,    83,   370,   436,    -1,    88,   195,   794,   165,   370,
     436,    -1,   165,   195,   794,    -1,   135,   315,   443,    99,
     794,   504,   444,    -1,   135,   315,   905,   504,   444,    -1,
     905,    -1,    -1,   444,   445,    -1,    -1,   479,    -1,   578,
      -1,   511,    -1,   525,    -1,   566,    -1,   629,    -1,   324,
     447,    -1,   324,   238,   447,    -1,   324,   322,   447,    -1,
     448,   350,   449,    -1,   448,   421,   449,    -1,   348,   387,
     454,    -1,   353,   626,    -1,   322,   118,    94,   353,   626,
      -1,   248,   455,    -1,   322,    99,   456,    -1,   322,    99,
     152,    -1,   905,    -1,   448,   416,   905,    -1,   450,    -1,
     152,    -1,   452,    -1,   450,   420,   452,    -1,   296,   361,
      -1,   296,   129,    -1,   303,   296,    -1,   321,    -1,   453,
      -1,   792,    -1,   905,    -1,   357,    -1,   180,    -1,   272,
      -1,   268,    -1,   792,    -1,   926,    -1,   723,   789,   725,
      -1,   723,   414,   785,   415,   789,   725,    -1,   152,    -1,
     238,    -1,   789,    -1,   152,    -1,    -1,   905,    -1,   789,
      -1,   327,   905,    -1,   327,   348,   387,    -1,   327,   353,
     224,   233,    -1,   327,   322,    99,    -1,   327,    86,    -1,
     305,   905,    -1,   305,   348,   387,    -1,   305,   353,   224,
     233,    -1,   305,   322,    99,    -1,   305,    86,    -1,   324,
     131,   460,   461,    -1,    86,    -1,   771,    -1,   155,    -1,
     201,    -1,   120,    -1,    88,   342,   696,   464,    -1,   465,
      -1,   464,   420,   465,    -1,    83,   610,   484,    -1,    88,
     610,   905,   466,    -1,    88,   610,   905,   165,   258,   263,
      -1,    88,   610,   905,   324,   258,   263,    -1,    88,   610,
     905,   324,   335,   785,    -1,    88,   610,   905,   324,   338,
     905,    -1,   165,   610,   905,   467,    -1,    88,   610,   905,
     360,   701,   468,    -1,    83,   491,    -1,   165,   130,   772,
     467,    -1,   324,   383,   270,    -1,   135,   351,   342,    -1,
     282,   350,   794,    -1,   123,   272,   772,    -1,   324,   383,
     123,    -1,   324,   343,   772,    -1,   324,   152,   726,    -1,
     165,   152,    -1,   112,    -1,   307,    -1,    -1,   371,   726,
      -1,    -1,   122,   772,    -1,   134,   475,   770,   476,   471,
     472,   477,   430,   473,    -1,   350,    -1,   189,    -1,   789,
      -1,   336,    -1,   337,    -1,   473,   474,    -1,    -1,   105,
      -1,   270,    -1,   158,   639,   789,    -1,   263,   639,   789,
      -1,   139,    -1,   295,   639,   784,    -1,   171,   639,   784,
      -1,   185,   295,   494,    -1,   185,   258,   263,   494,    -1,
     105,    -1,    -1,   382,   270,    -1,    -1,   478,   159,   789,
      -1,    -1,   371,    -1,    -1,   135,   480,   342,   770,   414,
     481,   415,   501,   502,   503,   504,    -1,   135,   480,   342,
     770,   267,   770,   414,   481,   415,   502,   503,   504,    -1,
     346,    -1,   344,    -1,   238,   346,    -1,   238,   344,    -1,
     193,   346,    -1,   193,   344,    -1,    -1,   482,    -1,    -1,
     483,    -1,   482,   420,   483,    -1,   484,    -1,   489,    -1,
     491,    -1,   905,   701,   485,    -1,   485,   486,    -1,    -1,
     130,   772,   487,    -1,   487,    -1,   488,    -1,   258,   263,
      -1,   263,    -1,   364,    -1,   290,   226,    -1,   119,   414,
     726,   415,    -1,   152,   727,    -1,   299,   770,   493,   496,
     497,    -1,   154,    -1,   258,   154,    -1,   209,   155,    -1,
     209,   201,    -1,   234,   770,   490,    -1,   205,   153,    -1,
     174,   153,    -1,    -1,   130,   772,   492,    -1,   492,    -1,
     119,   414,   726,   415,    -1,   364,   414,   494,   415,    -1,
     290,   226,   414,   494,   415,    -1,   186,   226,   414,   494,
     415,   299,   770,   493,   496,   497,   535,    -1,   414,   494,
     415,    -1,    -1,   494,   420,   495,    -1,   495,    -1,   905,
      -1,   241,   190,    -1,   241,   283,    -1,    -1,   498,    -1,
     499,    -1,   498,   499,    -1,   499,   498,    -1,    -1,   272,
     157,   500,    -1,   272,   368,   500,    -1,   254,    82,    -1,
     307,    -1,   112,    -1,   324,   152,    -1,   324,   263,    -1,
     208,   414,   769,   415,    -1,    -1,   382,   270,    -1,   383,
     270,    -1,    -1,   272,   128,   165,    -1,   272,   128,   157,
     313,    -1,   272,   128,   288,   313,    -1,    -1,   343,   772,
      -1,    -1,    -1,   135,   480,   342,   770,   508,   507,   506,
     665,    -1,   382,   270,    94,    -1,   383,   270,    94,    -1,
      94,    -1,   414,   509,   415,    -1,    -1,   509,   420,   510,
      -1,   510,    -1,   905,    -1,   135,   480,   320,   770,   513,
      -1,    88,   320,   770,   513,    -1,   513,   514,    -1,    -1,
     110,   791,    -1,   145,    -1,   254,   145,    -1,   206,   515,
     791,    -1,   242,   791,    -1,   244,   791,    -1,   254,   242,
      -1,   254,   244,    -1,   333,   430,   791,    -1,   306,   430,
     791,    -1,   109,    -1,    -1,   135,   517,   521,   228,   456,
     196,   518,   519,    -1,   359,    -1,    -1,   772,    -1,   772,
     557,    -1,   227,   789,    -1,    -1,   165,   521,   228,   789,
     467,    -1,   293,    -1,    -1,   135,   343,   772,   523,   239,
     784,    -1,   282,   772,    -1,    -1,   165,   343,   772,    -1,
     135,   355,   772,   526,   527,   272,   770,   529,   175,   294,
     772,   414,   532,   415,    -1,   135,   130,   355,   772,    84,
     527,   272,   770,   534,   535,   184,   166,   312,   175,   294,
     778,   414,   532,   415,    -1,   101,    -1,    84,    -1,   528,
      -1,   528,   276,   528,    -1,   528,   276,   528,   276,   528,
      -1,   214,    -1,   157,    -1,   368,    -1,   184,   530,   531,
      -1,    -1,   166,    -1,    -1,   312,    -1,   334,    -1,   533,
      -1,   532,   420,   533,    -1,    -1,   793,    -1,   905,    -1,
      -1,   189,   770,    -1,   536,    -1,   536,   537,    -1,   537,
      -1,   537,   536,    -1,   258,   154,    -1,   154,    -1,   209,
     201,    -1,   209,   155,    -1,   165,   355,   772,   272,   770,
     467,    -1,   135,    96,   772,   119,   414,   726,   415,   535,
      -1,   165,    96,   772,    -1,   135,    85,   778,   543,    -1,
     135,   274,   731,   543,    -1,   135,   360,   556,   543,    -1,
     135,   360,   556,    94,   542,    -1,   414,   699,   415,    -1,
     414,   544,   415,    -1,   545,    -1,   544,   420,   545,    -1,
     908,   401,   546,    -1,   908,    -1,   592,    -1,   734,    -1,
     792,    -1,   135,   274,   121,   556,   550,   184,   360,   701,
     371,   774,    94,   548,    -1,   549,    -1,   548,   420,   549,
      -1,   274,   785,   602,   551,    -1,   274,   785,   602,   414,
     601,   415,   551,    -1,   191,   785,   778,   586,    -1,   338,
     701,    -1,   152,    -1,    -1,   298,    -1,    -1,   165,   274,
     121,   556,   371,   774,   467,    -1,   165,   554,   555,   467,
      -1,   342,    -1,   320,    -1,   378,    -1,   207,    -1,   360,
      -1,   163,    -1,   132,    -1,   315,    -1,   556,    -1,   555,
     420,   556,    -1,   905,    -1,   905,   557,    -1,   416,   775,
      -1,   416,   775,   557,    -1,   358,   672,   770,    -1,   181,
     560,   562,   772,   867,    -1,   181,   560,   772,   867,    -1,
     181,   562,   772,   867,    -1,   181,   772,   867,    -1,   181,
     560,   562,   772,    -1,   181,   560,   772,    -1,   181,   562,
     772,    -1,   181,   772,    -1,   247,   560,   562,   772,    -1,
     247,   772,    -1,   253,    -1,   291,    -1,   182,    -1,   230,
      -1,    80,   561,    -1,   301,   561,    -1,   561,    -1,    86,
      -1,   187,    -1,   187,   561,    -1,   187,    86,    -1,   100,
      -1,   100,   561,    -1,   100,    86,    -1,   786,    -1,   204,
      -1,   189,    -1,   127,   272,   564,   772,   222,   565,    -1,
     127,   272,    85,   778,   414,   599,   415,   222,   565,    -1,
     127,   272,   191,   778,   586,   222,   565,    -1,   127,   272,
     274,   731,   414,   601,   415,   222,   565,    -1,   127,   272,
     355,   772,   272,   556,   222,   565,    -1,   127,   272,   314,
     772,   272,   556,   222,   565,    -1,   127,   272,   314,   772,
     222,   565,    -1,   127,   272,   274,   121,   556,   371,   774,
     222,   565,    -1,   127,   272,   229,   266,   791,   222,   565,
      -1,   127,   272,   114,   414,   701,    94,   701,   415,   222,
     565,    -1,   127,   272,   521,   228,   556,   222,   565,    -1,
     126,    -1,   146,    -1,   315,    -1,   207,    -1,   320,    -1,
     342,    -1,   163,    -1,   360,    -1,   378,    -1,   132,    -1,
     789,    -1,   263,    -1,   194,   568,   272,   571,   350,   572,
     574,    -1,   309,   575,   568,   272,   571,   189,   572,   467,
      -1,    86,   292,    -1,    86,    -1,   569,    -1,   570,    -1,
     569,   420,   570,    -1,   319,    -1,   214,    -1,   368,    -1,
     157,    -1,   314,    -1,   299,    -1,   355,    -1,   175,    -1,
     369,    -1,   135,    -1,   346,    -1,   344,    -1,   769,    -1,
     342,   769,    -1,   191,   576,    -1,   146,   771,    -1,   228,
     771,    -1,   315,   771,    -1,   343,   771,    -1,   573,    -1,
     572,   420,   573,    -1,   905,    -1,   195,   905,    -1,   382,
     194,   275,    -1,    -1,   194,   275,   184,    -1,    -1,   577,
      -1,   576,   420,   577,    -1,   778,   586,    -1,   135,   579,
     207,   776,   272,   770,   580,   414,   581,   415,   504,   698,
      -1,   364,    -1,    -1,   371,   774,    -1,    -1,   582,    -1,
     581,   420,   582,    -1,   775,   583,    -1,   778,   414,   736,
     415,   583,    -1,   414,   726,   415,   583,    -1,   556,    -1,
     371,   556,    -1,    -1,   135,   585,   191,   778,   586,   308,
     592,   594,   596,    -1,   276,   304,    -1,    -1,   414,   587,
     415,    -1,   414,   415,    -1,   588,    -1,   587,   420,   588,
      -1,   589,   591,   593,    -1,   589,   593,    -1,   204,    -1,
     278,    -1,   211,    -1,    -1,   789,    -1,   789,   420,   789,
      -1,   907,    -1,   593,    -1,   701,    -1,   906,   557,   409,
     360,    -1,   595,    -1,   594,   595,    -1,    94,   590,    -1,
     228,   456,    -1,   202,    -1,   332,    -1,   379,    -1,   111,
     272,   263,   212,    -1,   308,   263,   272,   263,   212,    -1,
     339,    -1,   178,   318,   156,    -1,   178,   318,   221,    -1,
     318,   156,    -1,   318,   221,    -1,   382,   543,    -1,    -1,
     165,   191,   778,   586,   467,    -1,   165,    85,   778,   414,
     599,   415,   467,    -1,   701,    -1,   407,    -1,   165,   274,
     731,   414,   601,   415,   467,    -1,   701,    -1,   701,   420,
     701,    -1,   257,   420,   701,    -1,   701,   420,   257,    -1,
     731,    -1,   905,   416,   602,    -1,   135,   114,   414,   701,
      94,   701,   415,   382,   191,   577,   604,    -1,   135,   114,
     414,   701,    94,   701,   415,   383,   191,   604,    -1,    94,
      97,    -1,    -1,   165,   114,   414,   701,    94,   701,   415,
     467,    -1,   300,   607,   770,   608,    -1,   300,   146,   772,
     608,    -1,   207,    -1,   342,    -1,   185,    -1,    -1,    88,
      85,   778,   414,   599,   415,   302,   350,   772,    -1,    88,
     132,   556,   302,   350,   772,    -1,    88,   146,   773,   302,
     350,   773,    -1,    88,   191,   778,   586,   302,   350,   772,
      -1,    88,   195,   794,   302,   350,   794,    -1,    88,   228,
     772,   302,   350,   772,    -1,    88,   274,   121,   556,   371,
     774,   302,   350,   772,    -1,    88,   315,   772,   302,   350,
     772,    -1,    88,   342,   696,   302,   350,   772,    -1,    88,
     342,   696,   302,   610,   772,   350,   772,    -1,    88,   355,
     772,   272,   696,   302,   350,   772,    -1,    88,   370,   794,
     302,   350,   794,    -1,    88,   343,   772,   302,   350,   772,
      -1,   126,    -1,    -1,    88,    85,   778,   414,   599,   415,
     282,   350,   794,    -1,    88,   132,   556,   282,   350,   794,
      -1,    88,   146,   773,   282,   350,   794,    -1,    88,   163,
     773,   282,   350,   794,    -1,    88,   191,   778,   586,   282,
     350,   794,    -1,    88,   274,   602,   414,   601,   415,   282,
     350,   794,    -1,    88,   274,   121,   556,   371,   774,   282,
     350,   794,    -1,    88,   315,   772,   282,   350,   794,    -1,
      88,   360,   556,   282,   350,   794,    -1,    88,   343,   772,
     282,   350,   794,    -1,    -1,   135,   585,   314,   772,    94,
     613,   272,   618,   350,   770,   698,   162,   619,   614,    -1,
     259,    -1,   616,    -1,   414,   615,   415,    -1,   615,   417,
     617,    -1,   617,    -1,   665,    -1,   652,    -1,   661,    -1,
     656,    -1,   621,    -1,   616,    -1,    -1,   319,    -1,   368,
      -1,   157,    -1,   214,    -1,   215,    -1,    87,    -1,    -1,
     165,   314,   772,   272,   770,   467,    -1,   260,   770,    -1,
     236,   770,    -1,   366,   770,    -1,   366,   407,    -1,    79,
     625,    -1,   102,   625,   627,    -1,   333,   353,   627,    -1,
     128,   625,    -1,   170,   625,    -1,   311,   625,    -1,   384,
      -1,   353,    -1,    -1,   224,   233,   451,    -1,   628,    -1,
     224,   233,   451,   628,    -1,   628,   224,   233,   451,    -1,
     626,    -1,    -1,   296,   273,    -1,   296,   385,    -1,   135,
     585,   378,   770,   493,    94,   665,    -1,   237,   777,    -1,
     135,   146,   773,   382,   632,    -1,   135,   146,   773,    -1,
     633,    -1,   632,   633,    -1,   343,   634,   772,    -1,   343,
     634,   152,    -1,   239,   634,   789,    -1,   239,   634,   152,
      -1,   345,   634,   772,    -1,   345,   634,   152,    -1,   168,
     634,   790,    -1,   168,   634,   152,    -1,   282,   634,   772,
      -1,   282,   634,   152,    -1,   401,    -1,    -1,    88,   146,
     773,   324,   447,    -1,    88,   146,   773,   458,    -1,   165,
     146,   773,    -1,   135,   163,   556,   639,   701,   485,    -1,
      88,   163,   556,   466,    -1,    88,   163,   556,   165,   258,
     263,    -1,    88,   163,   556,   324,   258,   263,    -1,    88,
     163,   556,    83,   491,    -1,    88,   163,   556,   165,   130,
     772,   467,    -1,    94,    -1,    -1,   135,   550,   132,   556,
     184,   789,   350,   789,   189,   556,    -1,   123,   776,   272,
     770,    -1,   123,   770,    -1,   123,    -1,   372,   646,   647,
     645,    -1,   372,   646,   647,   645,   770,    -1,   372,   646,
     647,   645,   643,    -1,   644,   645,    -1,   644,   645,   770,
     648,    -1,    90,    -1,    89,    -1,   377,    -1,    -1,   190,
      -1,    -1,   188,    -1,    -1,   414,   771,   415,    -1,    -1,
     177,   651,   645,   650,    -1,   665,    -1,   652,    -1,   661,
      -1,   656,    -1,   662,    -1,   644,    -1,    -1,   214,   220,
     770,   653,    -1,   374,   414,   766,   415,    -1,   152,   374,
      -1,   665,    -1,   414,   654,   415,   374,   414,   766,   415,
      -1,   414,   654,   415,   665,    -1,   654,   420,   655,    -1,
     655,    -1,   905,   758,    -1,   157,   189,   696,   698,    -1,
     240,   672,   769,   658,   660,    -1,   204,   659,   245,    -1,
      -1,    81,   326,    -1,   312,   326,    -1,   312,   173,    -1,
     326,   368,   173,    -1,   326,    -1,   326,   312,   173,    -1,
     173,    -1,    81,   173,    -1,   262,    -1,    -1,   368,   696,
     324,   762,   688,   698,    -1,   151,   772,   663,   144,   664,
     184,   665,    -1,    -1,   663,   105,    -1,   663,   213,    -1,
     663,   316,    -1,   663,   254,   316,    -1,    -1,   382,   198,
      -1,   383,   198,    -1,   667,    -1,   666,    -1,   414,   667,
     415,    -1,   414,   666,   415,    -1,   669,    -1,   668,   676,
      -1,   668,   675,   685,   680,    -1,   668,   675,   679,   686,
      -1,   669,    -1,   666,    -1,   319,   674,   760,   670,   688,
     698,   683,   684,    -1,   668,   363,   673,   668,    -1,   668,
     218,   673,   668,    -1,   668,   172,   673,   668,    -1,   220,
     671,    -1,   867,    -1,    -1,   346,   672,   770,    -1,   344,
     672,   770,    -1,   238,   346,   672,   770,    -1,   238,   344,
     672,   770,    -1,   193,   346,   672,   770,    -1,   193,   344,
     672,   770,    -1,   342,   770,    -1,   770,    -1,   342,    -1,
      -1,    86,    -1,    -1,   161,    -1,   161,   272,   414,   736,
     415,    -1,    86,    -1,    -1,   676,    -1,    -1,   277,   109,
     677,    -1,   678,    -1,   677,   420,   678,    -1,   726,   371,
     734,    -1,   726,    95,    -1,   726,   160,    -1,   726,    -1,
     235,   681,   269,   682,    -1,   269,   682,   235,   681,    -1,
     235,   681,    -1,   269,   682,    -1,   235,   681,   420,   682,
      -1,   679,    -1,    -1,   726,    -1,    86,    -1,   726,    -1,
     195,   109,   736,    -1,    -1,   197,   726,    -1,    -1,   184,
     368,   687,    -1,   184,   296,   273,    -1,   685,    -1,    -1,
     267,   771,    -1,    -1,   189,   689,    -1,    -1,   689,   420,
     690,    -1,   690,    -1,   696,    -1,   696,   692,    -1,   697,
      -1,   697,   692,    -1,   697,    94,   414,   699,   415,    -1,
     697,    94,   905,   414,   699,   415,    -1,   697,   905,   414,
     699,   415,    -1,   666,    -1,   666,   692,    -1,   691,    -1,
     414,   691,   415,   692,    -1,   414,   691,   415,    -1,   690,
     138,   225,   690,    -1,   690,   388,   690,    -1,   690,   693,
     225,   690,   695,    -1,   690,   225,   690,   695,    -1,   690,
     250,   693,   225,   690,    -1,   690,   250,   225,   690,    -1,
      94,   905,   414,   771,   415,    -1,    94,   905,    -1,   905,
     414,   771,   415,    -1,   905,    -1,   190,   694,    -1,   232,
     694,    -1,   310,   694,    -1,   210,    -1,   279,    -1,    -1,
     371,   414,   771,   415,    -1,   272,   726,    -1,   770,    -1,
     770,   407,    -1,   273,   770,    -1,   273,   414,   770,   415,
      -1,   778,   414,   415,    -1,   778,   414,   736,   415,    -1,
     381,   726,    -1,    -1,   700,    -1,   699,   420,   700,    -1,
     905,   701,    -1,   704,   702,    -1,   325,   704,   702,    -1,
     704,    93,   412,   785,   413,    -1,   325,   704,    93,   412,
     785,   413,    -1,   412,   413,   702,    -1,   412,   703,   413,
     702,    -1,    -1,   785,    -1,   414,   703,   415,    -1,   703,
     405,   703,    -1,   703,   406,   703,    -1,   703,   407,   703,
      -1,   703,   408,   703,    -1,   703,   409,   703,    -1,   784,
      -1,   905,    -1,   706,    -1,   722,    -1,   707,    -1,   711,
      -1,   715,    -1,   723,   725,    -1,   723,   414,   785,   415,
     725,    -1,   906,   557,    -1,   706,    -1,   722,    -1,   707,
      -1,   712,    -1,   716,    -1,   906,    -1,   216,    -1,   217,
      -1,   330,    -1,   104,    -1,   297,    -1,   183,   708,    -1,
     164,   287,    -1,   150,   710,    -1,   149,   710,    -1,   265,
     709,    -1,   107,    -1,   414,   785,   415,    -1,    -1,   414,
     785,   420,   785,   415,    -1,   414,   785,   415,    -1,    -1,
     414,   785,   420,   785,   415,    -1,   414,   785,   415,    -1,
      -1,   713,    -1,   714,    -1,   713,    -1,   714,    -1,   106,
     720,   414,   785,   415,    -1,   106,   720,    -1,   717,    -1,
     718,    -1,   717,    -1,   718,    -1,   719,   414,   785,   415,
     721,    -1,   719,   721,    -1,   117,   720,    -1,   116,   720,
      -1,   375,    -1,   249,   117,   720,    -1,   249,   116,   720,
      -1,   251,   720,    -1,   376,    -1,    -1,   117,   324,   905,
      -1,    -1,   349,   414,   785,   415,   724,    -1,   349,   724,
      -1,   348,   414,   785,   415,   724,    -1,   348,   724,    -1,
     219,    -1,   382,   348,   387,    -1,   383,   348,   387,    -1,
      -1,   386,    -1,   246,    -1,   147,    -1,   199,    -1,   243,
      -1,   317,    -1,   386,   350,   246,    -1,   147,   350,   199,
      -1,   147,   350,   243,    -1,   147,   350,   317,    -1,   199,
     350,   243,    -1,   243,   350,   317,    -1,   199,   350,   317,
      -1,    -1,   728,    -1,   726,    78,   701,    -1,   726,    98,
     348,   387,   728,    -1,   405,   726,    -1,   406,   726,    -1,
     409,   726,    -1,   410,   726,    -1,   726,   409,    -1,   726,
     410,    -1,   726,   405,   726,    -1,   726,   406,   726,    -1,
     726,   407,   726,    -1,   726,   408,   726,    -1,   726,   409,
     726,    -1,   726,   410,   726,    -1,   726,   402,   726,    -1,
     726,   403,   726,    -1,   726,   401,   726,    -1,   726,   733,
     726,    -1,   733,   726,    -1,   726,   733,    -1,   726,    91,
     726,    -1,   726,   276,   726,    -1,   258,   726,    -1,   726,
     234,   726,    -1,   726,   234,   726,   171,   726,    -1,   726,
     258,   234,   726,    -1,   726,   258,   234,   726,   171,   726,
      -1,   726,   200,   726,    -1,   726,   200,   726,   171,   726,
      -1,   726,   258,   200,   726,    -1,   726,   258,   200,   726,
     171,   726,    -1,   726,   328,   350,   726,    -1,   726,   328,
     350,   726,   171,   726,    -1,   726,   258,   328,   350,   726,
      -1,   726,   258,   328,   350,   726,   171,   726,    -1,   726,
     223,    -1,   726,   222,   263,    -1,   726,   261,    -1,   726,
     222,   258,   263,    -1,   726,   222,   357,    -1,   726,   222,
     258,   357,    -1,   726,   222,   180,    -1,   726,   222,   258,
     180,    -1,   726,   222,   365,    -1,   726,   222,   258,   365,
      -1,   726,   222,   161,   189,   726,    -1,   726,   222,   267,
     414,   738,   415,    -1,   726,   222,   258,   267,   414,   738,
     415,    -1,   726,   103,   727,    91,   727,    -1,   726,   258,
     103,   727,    91,   727,    -1,   726,   204,   749,    -1,   726,
     258,   204,   749,    -1,   726,   735,   730,   666,    -1,   726,
     735,   730,   414,   726,   415,    -1,   364,   666,    -1,   728,
      -1,   727,    78,   701,    -1,   406,   727,    -1,   409,   727,
      -1,   410,   727,    -1,   727,   409,    -1,   727,   410,    -1,
     727,   405,   727,    -1,   727,   406,   727,    -1,   727,   407,
     727,    -1,   727,   408,   727,    -1,   727,   409,   727,    -1,
     727,   410,   727,    -1,   727,   402,   727,    -1,   727,   403,
     727,    -1,   727,   401,   727,    -1,   727,   391,   727,    -1,
     733,   727,    -1,   727,   733,    -1,   727,   222,   161,   189,
     727,    -1,   727,   222,   267,   414,   727,   415,    -1,   727,
     222,   258,   267,   414,   727,   415,    -1,   755,    -1,   779,
      -1,   399,   758,    -1,   414,   726,   415,   758,    -1,   750,
      -1,   778,   414,   415,    -1,   778,   414,   736,   415,    -1,
     778,   414,    86,   736,   415,    -1,   778,   414,   161,   736,
     415,    -1,   778,   414,   407,   415,    -1,   140,    -1,   141,
     759,    -1,   141,   414,   785,   415,    -1,   142,   759,    -1,
     142,   414,   785,   415,    -1,   143,   759,    -1,   323,   759,
      -1,   370,   759,    -1,   114,   414,   726,    94,   701,   415,
      -1,   179,   414,   737,   415,    -1,   281,   414,   742,   415,
      -1,   286,   414,   744,   415,    -1,   340,   414,   745,   415,
      -1,   354,   414,   726,    94,   701,   415,    -1,   356,   414,
     108,   748,   415,    -1,   356,   414,   231,   748,   415,    -1,
     356,   414,   352,   748,   415,    -1,   356,   414,   748,   415,
      -1,   133,   414,   726,   371,   556,   415,    -1,   133,   414,
     736,   415,    -1,   666,    -1,   176,   666,    -1,    93,   666,
      -1,    93,   740,    -1,   729,    -1,   312,   414,   736,   415,
      -1,   312,   414,   415,    -1,   414,   736,   420,   726,   415,
      -1,    92,    -1,   331,    -1,    86,    -1,   391,    -1,   732,
      -1,   405,    -1,   406,    -1,   407,    -1,   409,    -1,   410,
      -1,   408,    -1,   402,    -1,   403,    -1,   401,    -1,   391,
      -1,   274,   414,   602,   415,    -1,   731,    -1,   274,   414,
     602,   415,    -1,   731,    -1,   274,   414,   602,   415,    -1,
     234,    -1,   258,   234,    -1,   200,    -1,   258,   200,    -1,
     726,    -1,   736,   420,   726,    -1,   741,   189,   726,    -1,
      -1,   738,   420,   701,    -1,   701,    -1,   740,    -1,   739,
     420,   740,    -1,   412,   736,   413,    -1,   412,   739,   413,
      -1,   926,    -1,   386,    -1,   246,    -1,   147,    -1,   199,
      -1,   243,    -1,   317,    -1,   789,    -1,   726,   743,   746,
     747,    -1,   726,   743,   746,    -1,   285,   726,    -1,   727,
     204,   727,    -1,    -1,   726,   746,   747,    -1,   726,   747,
     746,    -1,   726,   746,    -1,   726,   747,    -1,   736,    -1,
      -1,   189,   726,    -1,   184,   726,    -1,   726,   189,   736,
      -1,   189,   736,    -1,   736,    -1,   666,    -1,   414,   736,
     415,    -1,   113,   754,   751,   753,   170,    -1,   264,   414,
     726,   420,   726,   415,    -1,   124,   414,   736,   415,    -1,
     751,   752,    -1,   752,    -1,   380,   726,   347,   726,    -1,
     167,   726,    -1,    -1,   726,    -1,    -1,   768,    -1,   768,
     757,    -1,   416,   775,    -1,   416,   407,    -1,   412,   726,
     413,    -1,   412,   726,   422,   726,   413,    -1,   756,    -1,
     757,   756,    -1,    -1,   758,   756,    -1,   414,   415,    -1,
      -1,   760,   420,   761,    -1,   761,    -1,   726,    94,   908,
      -1,   726,    -1,   407,    -1,   762,   420,   765,    -1,   414,
     763,   415,   401,   414,   764,   415,    -1,   765,    -1,   905,
     758,    -1,   905,   758,   420,   763,    -1,   726,    -1,   726,
     420,   764,    -1,   905,   758,   401,   726,    -1,   905,   758,
     401,   152,    -1,   766,   420,   767,    -1,   767,    -1,   726,
      -1,   152,    -1,   795,    -1,   905,    -1,   770,    -1,   769,
     420,   770,    -1,   768,    -1,   768,   557,    -1,   772,    -1,
     771,   420,   772,    -1,   905,    -1,   905,    -1,   905,    -1,
     905,    -1,   905,    -1,   789,    -1,   907,    -1,   768,   757,
      -1,   793,    -1,   705,   789,    -1,   723,   789,   725,    -1,
     723,   414,   785,   415,   789,   725,    -1,   357,    -1,   180,
      -1,   263,    -1,   922,    -1,   398,    -1,   400,    -1,   396,
      -1,   397,    -1,   390,    -1,   780,    -1,   923,    -1,   785,
      -1,   406,   785,    -1,   780,    -1,   925,    -1,   781,    -1,
     787,    -1,   406,   781,    -1,   406,   780,    -1,   784,    -1,
     784,    -1,   923,    -1,   780,    -1,   784,    -1,   923,    -1,
     781,    -1,   780,    -1,   406,   781,    -1,   406,   780,    -1,
     923,    -1,   784,    -1,   791,    -1,   784,    -1,   781,    -1,
     780,    -1,   782,    -1,   783,    -1,   923,    -1,   905,    -1,
     271,    -1,   252,    -1,     9,   350,   797,   803,   804,    -1,
       9,   350,   152,    -1,     9,   805,    -1,   146,   797,    -1,
     773,   800,   802,    -1,   798,   422,   799,   802,   408,   773,
     808,    -1,   784,    -1,   807,    -1,   926,   925,    -1,   391,
     801,    -1,   799,    -1,    -1,   905,    -1,   905,   416,   801,
      -1,   395,    -1,   422,   785,    -1,    -1,    94,   797,    -1,
      -1,   370,   805,    -1,    -1,   806,    -1,   806,   408,   806,
      -1,   806,    25,   109,   806,    -1,   806,   371,   806,    -1,
     794,    -1,   789,    -1,   925,    -1,   391,   905,    -1,    -1,
     151,   772,   663,   144,   664,   184,   859,    -1,   148,   289,
     859,    -1,   148,   859,    -1,   812,    -1,   826,    -1,   813,
      -1,    -1,   831,   834,   814,   847,   417,    -1,    -1,   834,
     815,   847,   417,    -1,   837,   417,    -1,   791,    -1,   420,
     791,    -1,    -1,   725,    -1,   386,   350,   243,    -1,   386,
     350,   317,    -1,   147,   350,   147,    -1,   246,   350,   246,
      -1,    -1,   821,   820,   823,   822,    -1,   919,   102,   151,
      40,   417,    -1,   919,   170,   151,    40,   417,    -1,    -1,
     824,    -1,   828,    -1,   826,    -1,   824,   828,    -1,   824,
     826,    -1,   828,    -1,   825,   828,    -1,    -1,    77,   827,
     834,   850,   909,   702,   417,    -1,    -1,   831,   834,   829,
     847,   417,    -1,    -1,   834,   830,   847,   417,    -1,   837,
     417,    -1,   832,   833,    -1,   832,    -1,   833,    -1,    63,
      -1,    74,    -1,    72,    -1,    57,    -1,    58,    -1,    76,
      -1,   843,    -1,   839,    -1,   835,    -1,   909,   414,   816,
     817,   415,    -1,   909,   818,    -1,   841,    -1,    20,   904,
     836,    -1,    20,   836,    -1,    20,   904,    -1,   418,   930,
     419,    -1,    -1,   841,   838,   418,   825,   419,    -1,   837,
      -1,    -1,   842,   840,   418,   825,   419,    -1,    49,   904,
      -1,   363,   904,    -1,    49,    -1,   363,    -1,   844,    -1,
     846,   845,    -1,    50,    41,    -1,    50,    41,   216,    -1,
      50,    -1,    50,   216,    -1,    50,    29,    -1,    50,    29,
     216,    -1,    50,    29,    29,    -1,    50,    29,    29,   216,
      -1,    50,   116,    -1,    41,    -1,    41,   216,    -1,   216,
      -1,    29,    -1,    29,   216,    -1,    29,    29,    -1,    29,
      29,   216,    -1,     5,    -1,   116,    -1,   164,    -1,    42,
      -1,    -1,   848,    -1,   847,   420,   848,    -1,   850,   910,
     702,   849,    -1,    -1,   401,   931,    -1,    -1,   407,    -1,
     407,   407,    -1,   151,   334,   926,    -1,    19,   853,    -1,
     854,    -1,    13,    -1,    86,    -1,    -1,   797,    -1,   152,
      -1,   175,   201,   858,    -1,    -1,   175,   859,   856,   857,
      -1,   863,   867,    -1,   867,   863,    -1,   863,    -1,   867,
      -1,    -1,   807,    -1,   392,    -1,   772,    -1,   807,    -1,
      22,   772,    -1,    33,   772,   862,    -1,    -1,   863,    -1,
     371,   868,    -1,   864,    -1,   371,   866,    18,   927,    -1,
     220,   866,    18,   927,    -1,    -1,    43,    -1,   220,   918,
      -1,   865,    -1,   869,    -1,   869,   420,   868,    -1,   792,
      -1,   922,    -1,   289,   859,   189,   858,    -1,    17,   212,
     772,   864,    -1,    17,   872,   772,   864,    -1,    17,   872,
     772,   865,    -1,    34,    -1,    -1,     3,    18,   927,    -1,
     148,    18,   927,    -1,   192,    18,   927,   876,    -1,   877,
      -1,   876,   420,   877,    -1,   925,   401,   881,    -1,   324,
      18,   927,   879,    -1,   880,    -1,   879,   420,   880,    -1,
     881,   401,   787,    -1,    12,    -1,   192,    18,   927,    51,
     787,   883,    -1,   884,    -1,   883,   420,   884,    -1,   925,
     401,   888,    -1,   324,    18,   927,    51,   787,   886,    -1,
     887,    -1,   886,   420,   887,    -1,   888,   401,   788,    -1,
       8,    -1,    14,    -1,    15,    -1,    16,    -1,    26,    -1,
      27,    -1,    28,    -1,    30,    -1,    31,    -1,    32,    -1,
     287,    -1,    37,    -1,    38,    -1,    39,    -1,   360,    -1,
     624,    35,    -1,   324,     4,   401,   891,    -1,   324,     4,
     350,   891,    -1,   272,    -1,   268,    -1,   324,    10,   350,
     854,    -1,   324,    10,   401,   854,    -1,   324,    10,   854,
      -1,    -1,   360,   894,   909,   222,   834,   702,   895,    -1,
      36,    -1,    -1,    -1,    52,   897,   908,   222,   834,   702,
     895,    -1,    53,    44,   899,    -1,    53,   258,    21,   899,
      -1,    53,    46,   899,    -1,    11,    -1,    45,    -1,    48,
      -1,    24,   772,    -1,    23,   350,   772,    -1,   162,   772,
     414,   920,   415,    -1,   162,     6,    -1,     7,   772,   414,
     920,   415,    -1,     7,   772,    -1,   901,    -1,   902,    -1,
       6,    -1,     7,    -1,     8,    -1,    11,    -1,    12,    -1,
      14,    -1,    15,    -1,    16,    -1,    21,    -1,    23,    -1,
      24,    -1,    25,    -1,    26,    -1,    27,    -1,    28,    -1,
      30,    -1,    31,    -1,    32,    -1,    35,    -1,    37,    -1,
      38,    -1,    39,    -1,    40,    -1,    44,    -1,    45,    -1,
      46,    -1,    48,    -1,     9,    -1,    17,    -1,    19,    -1,
      33,    -1,    52,    -1,    53,    -1,     5,    -1,    29,    -1,
      34,    -1,    41,    -1,    49,    -1,    42,    -1,    50,    -1,
     908,    -1,   926,    -1,   912,    -1,   915,    -1,   900,    -1,
     911,    -1,   116,    -1,   926,    -1,   912,    -1,   900,    -1,
     903,    -1,   911,    -1,   926,    -1,   912,    -1,   916,    -1,
     900,    -1,   911,    -1,   910,    -1,   903,    -1,   116,    -1,
     212,    -1,   216,    -1,   363,    -1,   350,    -1,   911,    -1,
     913,    -1,   926,    -1,   915,    -1,   916,    -1,   901,    -1,
     909,    -1,   917,    -1,   914,    -1,   902,    -1,    57,    -1,
      58,    -1,    63,    -1,    72,    -1,    74,    -1,    77,    -1,
      76,    -1,   913,    -1,   914,    -1,   147,    -1,   199,    -1,
     243,    -1,   246,    -1,   317,    -1,   386,    -1,    79,    -1,
      80,    -1,    81,    -1,    82,    -1,    83,    -1,    84,    -1,
      85,    -1,    87,    -1,    88,    -1,    96,    -1,    97,    -1,
      98,    -1,   100,    -1,   101,    -1,   102,    -1,   109,    -1,
     110,    -1,   112,    -1,   115,    -1,   118,    -1,   120,    -1,
     121,    -1,   122,    -1,   123,    -1,   127,    -1,   128,    -1,
     129,    -1,   131,    -1,   132,    -1,   134,    -1,   136,    -1,
     137,    -1,   139,    -1,   144,    -1,   145,    -1,   146,    -1,
     148,    -1,   151,    -1,   153,    -1,   155,    -1,   157,    -1,
     158,    -1,   159,    -1,   163,    -1,   164,    -1,   165,    -1,
     166,    -1,   168,    -1,   169,    -1,   171,    -1,   174,    -1,
     173,    -1,   175,    -1,   177,    -1,   181,    -1,   182,    -1,
     185,    -1,   187,    -1,   191,    -1,   193,    -1,   196,    -1,
     198,    -1,   201,    -1,   202,    -1,   203,    -1,   205,    -1,
     206,    -1,   207,    -1,   208,    -1,   213,    -1,   214,    -1,
     215,    -1,   224,    -1,   226,    -1,   227,    -1,   228,    -1,
     229,    -1,   230,    -1,   233,    -1,   236,    -1,   237,    -1,
     238,    -1,   239,    -1,   240,    -1,   241,    -1,   242,    -1,
     244,    -1,   245,    -1,   247,    -1,   248,    -1,   253,    -1,
     254,    -1,   255,    -1,   256,    -1,   259,    -1,   260,    -1,
     266,    -1,   267,    -1,   270,    -1,   274,    -1,   275,    -1,
     282,    -1,   283,    -1,   284,    -1,   289,    -1,   288,    -1,
     291,    -1,   292,    -1,   293,    -1,   294,    -1,   295,    -1,
     296,    -1,   298,    -1,   300,    -1,   301,    -1,   302,    -1,
     303,    -1,   304,    -1,   305,    -1,   306,    -1,   307,    -1,
     308,    -1,   309,    -1,   311,    -1,   313,    -1,   314,    -1,
     315,    -1,   316,    -1,   320,    -1,   321,    -1,   322,    -1,
     324,    -1,   326,    -1,   327,    -1,   329,    -1,   332,    -1,
     333,    -1,   334,    -1,   335,    -1,   336,    -1,   337,    -1,
     338,    -1,   339,    -1,   341,    -1,   343,    -1,   344,    -1,
     345,    -1,   346,    -1,   351,    -1,   353,    -1,   355,    -1,
     358,    -1,   359,    -1,   360,    -1,   361,    -1,   362,    -1,
     365,    -1,   366,    -1,   367,    -1,   368,    -1,   369,    -1,
     372,    -1,   373,    -1,   374,    -1,   376,    -1,   378,    -1,
     382,    -1,   383,    -1,   384,    -1,   385,    -1,   387,    -1,
     104,    -1,   106,    -1,   117,    -1,   124,    -1,   133,    -1,
     149,    -1,   150,    -1,   176,    -1,   179,    -1,   183,    -1,
     211,    -1,   217,    -1,   219,    -1,   249,    -1,   251,    -1,
     257,    -1,   264,    -1,   265,    -1,   278,    -1,   281,    -1,
     286,    -1,   287,    -1,   297,    -1,   312,    -1,   325,    -1,
     330,    -1,   340,    -1,   348,    -1,   349,    -1,   354,    -1,
     356,    -1,   375,    -1,    99,    -1,   103,    -1,   105,    -1,
     138,    -1,   188,    -1,   190,    -1,   200,    -1,   210,    -1,
     222,    -1,   223,    -1,   225,    -1,   232,    -1,   234,    -1,
     250,    -1,   261,    -1,   279,    -1,   280,    -1,   310,    -1,
     328,    -1,   377,    -1,    86,    -1,    89,    -1,    90,    -1,
      91,    -1,    92,    -1,    93,    -1,    94,    -1,    95,    -1,
     108,    -1,   113,    -1,   114,    -1,   119,    -1,   125,    -1,
     126,    -1,   130,    -1,   135,    -1,   140,    -1,   141,    -1,
     142,    -1,   143,    -1,   152,    -1,   154,    -1,   160,    -1,
     161,    -1,   162,    -1,   167,    -1,   170,    -1,   172,    -1,
     180,    -1,   184,    -1,   186,    -1,   189,    -1,   194,    -1,
     195,    -1,   197,    -1,   204,    -1,   209,    -1,   218,    -1,
     220,    -1,   231,    -1,   235,    -1,   252,    -1,   258,    -1,
     262,    -1,   263,    -1,   268,    -1,   269,    -1,   271,    -1,
     272,    -1,   273,    -1,   276,    -1,   277,    -1,   290,    -1,
     299,    -1,   319,    -1,   323,    -1,   331,    -1,   342,    -1,
     347,    -1,   352,    -1,   357,    -1,   364,    -1,   370,    -1,
     371,    -1,   380,    -1,   381,    -1,   921,    -1,   918,   420,
     921,    -1,    47,    -1,    -1,   930,    -1,   925,   924,    -1,
     925,    -1,   925,   924,    -1,   925,    -1,   925,    -1,    26,
     925,    -1,    26,   772,    -1,   393,    -1,   389,    -1,   392,
      -1,   772,    -1,   807,    -1,   933,    -1,   414,   415,    -1,
     414,   929,   415,    -1,   928,    -1,   929,   928,    -1,   931,
      -1,   930,   420,   931,    -1,   929,    -1,   418,   930,   419,
      -1,   933,    -1,   414,    -1,   415,    -1,   420,    -1,   417,
      -1,   389,    -1,   392,    -1,   780,    -1,   781,    -1,   784,
      -1,   407,    -1,   405,    -1,   406,    -1,   408,    -1,   409,
      -1,   263,    -1,    54,    -1,    55,    -1,    56,    -1,    57,
      -1,    58,    -1,    59,    -1,    60,    -1,    61,    -1,    62,
      -1,    63,    -1,    64,    -1,    65,    -1,    67,    -1,    66,
      -1,    68,    -1,    69,    -1,    70,    -1,    71,    -1,    72,
      -1,    73,    -1,    74,    -1,    75,    -1,    77,    -1,    76,
      -1,     5,    -1,    20,    -1,   199,    -1,   216,    -1,    29,
      -1,   243,    -1,   246,    -1,   317,    -1,    41,    -1,    42,
      -1,    49,    -1,    50,    -1,   386,    -1,   116,    -1,   183,
      -1,   350,    -1,   363,    -1,   375,    -1,   412,    -1,   413,
      -1,   401,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   579,   579,   581,   582,   585,   586,   587,   593,   594,
     595,   596,   597,   600,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   654,   655,   656,   657,   658,
     659,   660,   661,   662,   663,   665,   666,   667,   668,   669,
     670,   671,   672,   673,   674,   675,   676,   677,   678,   679,
     681,   682,   683,   684,   685,   686,   687,   688,   690,   691,
     692,   693,   694,   695,   696,   697,   698,   704,   705,   706,
     707,   708,   709,   710,   711,   712,   718,   728,   732,   740,
     748,   752,   763,   773,   777,   784,   791,   797,   805,   814,
     815,   821,   830,   837,   843,   852,   859,   880,   884,   885,
     896,   898,   902,   904,   914,   921,   922,   925,   927,   929,
     931,   933,   935,   937,   939,   943,   945,   955,   957,   964,
     965,   968,   970,   981,   983,   993,  1004,  1006,  1010,  1011,
    1014,  1015,  1022,  1023,  1024,  1025,  1026,  1027,  1040,  1042,
    1044,  1048,  1050,  1052,  1054,  1056,  1058,  1060,  1062,  1066,
    1067,  1071,  1073,  1077,  1079,  1083,  1084,  1085,  1086,  1089,
    1090,  1091,  1094,  1095,  1096,  1097,  1107,  1108,  1109,  1111,
    1113,  1115,  1119,  1120,  1121,  1124,  1125,  1128,  1130,  1132,
    1134,  1136,  1140,  1142,  1144,  1146,  1148,  1152,  1156,  1158,
    1162,  1163,  1169,  1180,  1185,  1186,  1190,  1194,  1197,  1200,
    1203,  1206,  1209,  1212,  1215,  1218,  1221,  1224,  1227,  1230,
    1233,  1236,  1241,  1242,  1245,  1246,  1247,  1250,  1251,  1261,
    1275,  1280,  1281,  1289,  1290,  1291,  1294,  1295,  1298,  1299,
    1300,  1302,  1304,  1305,  1307,  1309,  1311,  1316,  1317,  1320,
    1321,  1328,  1331,  1334,  1335,  1345,  1348,  1358,  1359,  1360,
    1361,  1362,  1363,  1364,  1368,  1371,  1373,  1375,  1379,  1380,
    1381,  1384,  1390,  1391,  1394,  1396,  1397,  1411,  1413,  1415,
    1417,  1419,  1421,  1423,  1438,  1439,  1440,  1441,  1444,  1451,
    1452,  1453,  1460,  1462,  1466,  1468,  1470,  1472,  1477,  1478,
    1481,  1483,  1487,  1490,  1492,  1498,  1501,  1502,  1503,  1504,
    1505,  1508,  1512,  1516,  1517,  1518,  1519,  1520,  1523,  1526,
    1529,  1530,  1531,  1534,  1535,  1536,  1537,  1540,  1541,  1550,
    1549,  1567,  1568,  1569,  1573,  1576,  1579,  1581,  1585,  1596,
    1600,  1604,  1605,  1608,  1610,  1612,  1614,  1616,  1618,  1620,
    1622,  1624,  1626,  1630,  1631,  1642,  1647,  1648,  1655,  1656,
    1659,  1662,  1665,  1669,  1670,  1680,  1684,  1685,  1699,  1710,
    1715,  1723,  1724,  1727,  1729,  1731,  1735,  1736,  1737,  1740,
    1743,  1746,  1747,  1750,  1751,  1754,  1756,  1759,  1762,  1763,
    1766,  1767,  1770,  1771,  1778,  1779,  1788,  1790,  1794,  1796,
    1800,  1811,  1819,  1834,  1836,  1838,  1840,  1844,  1848,  1852,
    1853,  1856,  1857,  1861,  1862,  1863,  1866,  1873,  1874,  1877,
    1879,  1881,  1883,  1887,  1888,  1891,  1892,  1895,  1907,  1911,
    1912,  1913,  1914,  1915,  1916,  1917,  1918,  1921,  1923,  1927,
    1928,  1935,  1936,  1945,  1960,  1965,  1970,  1975,  1980,  1985,
    1990,  1995,  2000,  2002,  2006,  2007,  2008,  2009,  2010,  2011,
    2012,  2013,  2014,  2015,  2016,  2017,  2018,  2019,  2022,  2025,
    2026,  2029,  2031,  2033,  2035,  2037,  2039,  2041,  2043,  2045,
    2047,  2049,  2053,  2054,  2055,  2056,  2057,  2058,  2059,  2060,
    2061,  2062,  2065,  2066,  2076,  2080,  2087,  2088,  2089,  2092,
    2094,  2098,  2099,  2100,  2101,  2102,  2103,  2104,  2105,  2106,
    2107,  2108,  2109,  2112,  2114,  2116,  2118,  2120,  2122,  2124,
    2128,  2130,  2134,  2135,  2138,  2143,  2146,  2151,  2154,  2156,
    2160,  2171,  2176,  2177,  2180,  2183,  2186,  2187,  2190,  2192,
    2194,  2198,  2199,  2200,  2203,  2208,  2209,  2212,  2214,  2218,
    2220,  2224,  2225,  2228,  2229,  2235,  2242,  2245,  2247,  2251,
    2253,  2263,  2265,  2270,  2272,  2276,  2278,  2280,  2282,  2284,
    2286,  2288,  2290,  2292,  2294,  2296,  2298,  2302,  2303,  2316,
    2320,  2324,  2325,  2329,  2333,  2335,  2337,  2339,  2344,  2346,
    2350,  2353,  2358,  2359,  2363,  2374,  2376,  2380,  2381,  2384,
    2385,  2396,  2398,  2400,  2402,  2404,  2406,  2408,  2410,  2412,
    2414,  2416,  2418,  2420,  2424,  2425,  2434,  2436,  2438,  2440,
    2442,  2444,  2446,  2448,  2450,  2452,  2464,  2463,  2473,  2474,
    2475,  2479,  2481,  2485,  2486,  2487,  2488,  2489,  2492,  2493,
    2497,  2498,  2499,  2500,  2503,  2504,  2505,  2508,  2520,  2524,
    2528,  2530,  2543,  2544,  2545,  2546,  2547,  2548,  2551,  2552,
    2553,  2557,  2559,  2561,  2563,  2568,  2569,  2573,  2574,  2584,
    2596,  2608,  2610,  2614,  2616,  2620,  2622,  2624,  2626,  2628,
    2630,  2632,  2634,  2636,  2638,  2642,  2643,  2654,  2656,  2667,
    2678,  2685,  2687,  2689,  2691,  2693,  2697,  2698,  2702,  2716,
    2718,  2720,  2733,  2735,  2737,  2741,  2743,  2747,  2748,  2751,
    2752,  2755,  2756,  2759,  2760,  2763,  2766,  2777,  2782,  2783,
    2784,  2785,  2786,  2790,  2791,  2840,  2844,  2846,  2848,  2850,
    2852,  2856,  2858,  2862,  2874,  2878,  2882,  2885,  2888,  2889,
    2890,  2891,  2892,  2893,  2894,  2895,  2898,  2899,  2909,  2923,
    2954,  2955,  2956,  2957,  2958,  2961,  2965,  2966,  2976,  2978,
    2982,  2984,  2988,  2990,  2992,  2994,  2998,  2999,  3002,  3006,
    3008,  3010,  3014,  3019,  3020,  3030,  3032,  3034,  3036,  3038,
    3040,  3042,  3044,  3048,  3049,  3052,  3053,  3056,  3058,  3060,
    3063,  3066,  3067,  3070,  3074,  3075,  3078,  3080,  3082,  3084,
    3088,  3090,  3092,  3094,  3096,  3100,  3101,  3104,  3105,  3108,
    3118,  3121,  3124,  3127,  3130,  3132,  3136,  3137,  3140,  3141,
    3152,  3153,  3156,  3157,  3167,  3169,  3171,  3173,  3175,  3177,
    3179,  3181,  3183,  3185,  3187,  3208,  3210,  3212,  3214,  3216,
    3218,  3220,  3224,  3226,  3228,  3230,  3234,  3235,  3236,  3237,
    3241,  3242,  3252,  3254,  3258,  3260,  3262,  3264,  3268,  3270,
    3274,  3275,  3278,  3280,  3284,  3297,  3299,  3301,  3303,  3308,
    3314,  3321,  3328,  3329,  3330,  3331,  3332,  3333,  3334,  3335,
    3336,  3339,  3340,  3341,  3342,  3343,  3344,  3346,  3348,  3352,
    3353,  3354,  3355,  3356,  3359,  3367,  3369,  3371,  3373,  3375,
    3377,  3379,  3381,  3383,  3385,  3387,  3391,  3394,  3397,  3399,
    3402,  3405,  3407,  3410,  3418,  3419,  3422,  3423,  3426,  3430,
    3439,  3440,  3443,  3444,  3447,  3451,  3455,  3457,  3459,  3461,
    3463,  3465,  3469,  3472,  3475,  3478,  3481,  3483,  3485,  3487,
    3491,  3495,  3497,  3500,  3503,  3504,  3505,  3506,  3507,  3508,
    3509,  3510,  3511,  3512,  3513,  3514,  3515,  3516,  3542,  3544,
    3546,  3557,  3559,  3561,  3563,  3565,  3567,  3569,  3571,  3573,
    3575,  3577,  3579,  3581,  3583,  3585,  3587,  3589,  3591,  3593,
    3595,  3597,  3599,  3601,  3603,  3605,  3607,  3609,  3611,  3613,
    3615,  3617,  3619,  3621,  3623,  3625,  3627,  3629,  3640,  3642,
    3644,  3646,  3648,  3650,  3652,  3654,  3656,  3658,  3660,  3662,
    3664,  3666,  3668,  3670,  3682,  3684,  3686,  3688,  3690,  3692,
    3694,  3696,  3698,  3700,  3702,  3704,  3706,  3708,  3710,  3712,
    3714,  3716,  3718,  3720,  3722,  3724,  3736,  3738,  3740,  3742,
    3744,  3746,  3748,  3750,  3752,  3754,  3756,  3758,  3760,  3762,
    3764,  3766,  3768,  3770,  3772,  3774,  3776,  3778,  3780,  3782,
    3785,  3787,  3789,  3791,  3793,  3795,  3797,  3799,  3801,  3803,
    3805,  3809,  3811,  3813,  3817,  3818,  3819,  3822,  3823,  3826,
    3827,  3828,  3829,  3830,  3831,  3832,  3833,  3834,  3837,  3838,
    3841,  3842,  3845,  3846,  3847,  3848,  3849,  3850,  3853,  3855,
    3859,  3862,  3865,  3867,  3871,  3872,  3876,  3877,  3883,  3884,
    3885,  3886,  3887,  3888,  3889,  3890,  3894,  3896,  3901,  3905,
    3908,  3911,  3913,  3915,  3917,  3919,  3922,  3925,  3929,  3933,
    3935,  3937,  3941,  3943,  3962,  3964,  3966,  3970,  3972,  3976,
    3980,  3983,  3986,  3987,  3990,  3991,  3995,  3996,  3997,  3998,
    4001,  4002,  4006,  4007,  4010,  4011,  4021,  4023,  4028,  4030,
    4032,  4037,  4039,  4063,  4067,  4076,  4087,  4095,  4105,  4107,
    4111,  4113,  4117,  4118,  4128,  4129,  4132,  4134,  4138,  4140,
    4144,  4146,  4151,  4152,  4153,  4154,  4155,  4157,  4159,  4161,
    4169,  4171,  4173,  4175,  4177,  4179,  4181,  4183,  4187,  4188,
    4189,  4190,  4191,  4202,  4203,  4206,  4207,  4210,  4218,  4221,
    4229,  4230,  4239,  4248,  4260,  4261,  4264,  4265,  4266,  4269,
    4270,  4271,  4272,  4273,  4276,  4277,  4280,  4281,  4282,  4283,
    4284,  4285,  4288,  4290,  4297,  4313,  4315,  4318,  4320,  4324,
    4332,  4348,  4355,  4361,  4373,  4382,  4383,  4386,  4387,  4388,
    4391,  4392,  4395,  4396,  4399,  4400,  4403,  4405,  4407,  4409,
    4413,  4420,  4443,  4475,  4485,  4492,  4532,  4534,  4541,  4543,
    4544,  4549,  4547,  4562,  4561,  4574,  4580,  4582,  4583,  4586,
    4587,  4588,  4589,  4590,  4597,  4596,  4606,  4608,  4610,  4611,
    4614,  4615,  4616,  4617,  4620,  4621,  4625,  4624,  4685,  4683,
    4698,  4697,  4710,  4716,  4720,  4724,  4730,  4731,  4732,  4733,
    4736,  4737,  4740,  4748,  4765,  4773,  4796,  4890,  4924,  4926,
    4928,  4932,  4936,  4935,  4986,  4988,  4987,  5002,  5008,  5015,
    5020,  5023,  5024,  5027,  5028,  5029,  5030,  5031,  5032,  5033,
    5041,  5049,  5052,  5053,  5054,  5055,  5056,  5057,  5065,  5073,
    5074,  5075,  5078,  5079,  5082,  5084,  5088,  5158,  5159,  5166,
    5167,  5168,  5174,  5183,  5186,  5187,  5188,  5189,  5192,  5193,
    5199,  5213,  5212,  5230,  5231,  5232,  5233,  5234,  5237,  5239,
    5243,  5244,  5251,  5256,  5258,  5259,  5262,  5263,  5266,  5273,
    5280,  5280,  5282,  5283,  5286,  5286,  5288,  5298,  5307,  5313,
    5319,  5325,  5333,  5334,  5346,  5356,  5367,  5371,  5372,  5375,
    5380,  5384,  5385,  5388,  5395,  5402,  5406,  5407,  5410,  5413,
    5417,  5418,  5421,  5428,  5429,  5430,  5431,  5432,  5433,  5434,
    5435,  5436,  5437,  5438,  5439,  5440,  5441,  5442,  5451,  5470,
    5471,  5474,  5475,  5482,  5483,  5484,  5491,  5490,  5549,  5550,
    5557,  5556,  5625,  5631,  5637,  5645,  5651,  5657,  5663,  5669,
    5675,  5681,  5687,  5693,  5704,  5705,  5708,  5709,  5710,  5711,
    5712,  5713,  5714,  5715,  5716,  5717,  5718,  5719,  5720,  5721,
    5722,  5723,  5724,  5725,  5726,  5727,  5728,  5729,  5730,  5731,
    5732,  5733,  5734,  5737,  5738,  5739,  5740,  5741,  5742,  5746,
    5747,  5748,  5749,  5750,  5751,  5752,  5755,  5771,  5772,  5773,
    5774,  5775,  5776,  5781,  5782,  5783,  5784,  5785,  5790,  5791,
    5792,  5793,  5794,  5800,  5801,  5802,  5803,  5804,  5805,  5806,
    5807,  5808,  5811,  5812,  5813,  5814,  5817,  5818,  5819,  5820,
    5823,  5824,  5825,  5826,  5827,  5828,  5829,  5847,  5847,  5849,
    5850,  5851,  5852,  5853,  5854,  5857,  5858,  5859,  5860,  5861,
    5862,  5863,  5864,  5865,  5866,  5867,  5868,  5869,  5870,  5871,
    5872,  5873,  5874,  5875,  5876,  5877,  5878,  5879,  5880,  5881,
    5882,  5883,  5884,  5885,  5886,  5887,  5888,  5889,  5890,  5891,
    5892,  5894,  5895,  5896,  5897,  5898,  5899,  5900,  5901,  5902,
    5903,  5904,  5905,  5906,  5907,  5908,  5909,  5910,  5911,  5912,
    5913,  5914,  5915,  5916,  5917,  5918,  5919,  5921,  5922,  5923,
    5924,  5925,  5926,  5927,  5928,  5929,  5930,  5931,  5932,  5933,
    5934,  5935,  5936,  5937,  5938,  5939,  5940,  5941,  5942,  5943,
    5944,  5946,  5947,  5949,  5950,  5951,  5952,  5953,  5954,  5955,
    5956,  5957,  5958,  5959,  5960,  5961,  5962,  5963,  5964,  5965,
    5966,  5967,  5968,  5969,  5970,  5971,  5972,  5973,  5974,  5975,
    5976,  5977,  5978,  5979,  5980,  5981,  5982,  5983,  5984,  5985,
    5986,  5987,  5988,  5990,  5991,  5992,  5993,  5994,  5995,  5996,
    5997,  5998,  5999,  6000,  6001,  6002,  6003,  6004,  6005,  6006,
    6007,  6008,  6009,  6010,  6011,  6012,  6013,  6014,  6015,  6016,
    6017,  6018,  6019,  6020,  6021,  6022,  6023,  6024,  6025,  6026,
    6027,  6028,  6029,  6030,  6031,  6033,  6047,  6048,  6052,  6053,
    6054,  6055,  6056,  6057,  6058,  6059,  6060,  6064,  6065,  6066,
    6067,  6068,  6069,  6070,  6071,  6072,  6073,  6074,  6075,  6076,
    6077,  6078,  6079,  6080,  6081,  6082,  6083,  6084,  6098,  6099,
    6100,  6101,  6102,  6103,  6104,  6105,  6106,  6107,  6108,  6109,
    6110,  6111,  6112,  6113,  6114,  6115,  6116,  6117,  6127,  6128,
    6129,  6130,  6131,  6132,  6133,  6134,  6135,  6136,  6137,  6138,
    6139,  6140,  6141,  6142,  6143,  6144,  6145,  6146,  6147,  6148,
    6149,  6150,  6151,  6152,  6153,  6154,  6155,  6156,  6157,  6158,
    6159,  6160,  6161,  6162,  6163,  6164,  6165,  6166,  6167,  6168,
    6169,  6170,  6171,  6172,  6173,  6174,  6175,  6176,  6177,  6178,
    6179,  6180,  6181,  6182,  6183,  6184,  6185,  6189,  6190,  6194,
    6195,  6196,  6197,  6198,  6202,  6202,  6205,  6208,  6209,  6212,
    6214,  6219,  6229,  6236,  6237,  6238,  6241,  6270,  6271,  6274,
    6276,  6284,  6285,  6286,  6290,  6291,  6295,  6296,  6299,  6300,
    6303,  6304,  6305,  6306,  6307,  6310,  6311,  6312,  6313,  6314,
    6315,  6316,  6317,  6318,  6319,  6320,  6321,  6322,  6323,  6324,
    6325,  6326,  6327,  6328,  6329,  6330,  6331,  6332,  6333,  6334,
    6335,  6336,  6337,  6338,  6339,  6340,  6341,  6342,  6343,  6344,
    6345,  6346,  6347,  6348,  6349,  6350,  6351,  6352,  6353,  6354,
    6355,  6356,  6357,  6358,  6359,  6360,  6361,  6362,  6363,  6364,
    6365
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONNECTION", "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", 
  "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_ENUM", "SQL_FOUND", "SQL_FREE", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NAME", "SQL_NULLABLE", 
  "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", "SQL_RELEASE", 
  "SQL_REFERENCE", "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", 
  "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", 
  "SQL_SQLERROR", "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", 
  "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", 
  "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", 
  "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", 
  "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", 
  "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", 
  "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ANALYSE", 
  "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", 
  "ASSIGNMENT", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", 
  "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", 
  "CACHE", "CALLED", "CASCADE", "CASE", "CAST", "CHAIN", "CHAR_P", 
  "CHARACTER", "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", 
  "CLUSTER", "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", 
  "COMMITTED", "CONSTRAINT", "CONSTRAINTS", "CONVERSION_P", "CONVERT", 
  "COPY", "CREATE", "CREATEDB", "CREATEUSER", "CROSS", "CSV", 
  "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", 
  "CURSOR", "CYCLE", "DATABASE", "DAY_P", "DEALLOCATE", "DEC", 
  "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", 
  "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DISTINCT", 
  "DO", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", "ENCODING", 
  "ENCRYPTED", "END_P", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXCLUDING", 
  "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", 
  "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", "FOREIGN", "FORWARD", 
  "FREEZE", "FROM", "FULL", "FUNCTION", "GET", "GLOBAL", "GRANT", 
  "GROUP_P", "HANDLER", "HAVING", "HOLD", "HOUR_P", "ILIKE", "IMMEDIATE", 
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", 
  "INHERITS", "INITIALLY", "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", 
  "INSERT", "INSTEAD", "INT_P", "INTEGER", "INTERSECT", "INTERVAL", 
  "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", "JOIN", "KEY", 
  "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P", "LEADING", "LEFT", 
  "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCATION", 
  "LOCK_P", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", 
  "MONTH_P", "MOVE", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEW", 
  "NEXT", "NO", "NOCREATEDB", "NOCREATEUSER", "NONE", "NOT", "NOTHING", 
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNER", "PARTIAL", "PASSWORD", "PLACING", "POSITION", 
  "PRECISION", "PRESERVE", "PREPARE", "PRIMARY", "PRIOR", "PRIVILEGES", 
  "PROCEDURAL", "PROCEDURE", "QUOTE", "READ", "REAL", "RECHECK", 
  "REFERENCES", "REINDEX", "RELATIVE_P", "RENAME", "REPEATABLE", 
  "REPLACE", "RESET", "RESTART", "RESTRICT", "RETURNS", "REVOKE", "RIGHT", 
  "ROLLBACK", "ROW", "ROWS", "RULE", "SCHEMA", "SCROLL", "SECOND_P", 
  "SECURITY", "SELECT", "SEQUENCE", "SERIALIZABLE", "SESSION", 
  "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", 
  "SMALLINT", "SOME", "STABLE", "START", "STATEMENT", "STATISTICS", 
  "STDIN", "STDOUT", "STORAGE", "STRICT_P", "SUBSTRING", "SYSID", "TABLE", 
  "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", "THEN", "TIME", 
  "TIMESTAMP", "TO", "TOAST", "TRAILING", "TRANSACTION", "TREAT", 
  "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", 
  "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", 
  "UNTIL", "UPDATE", "USAGE", "USER", "USING", "VACUUM", "VALID", 
  "VALUES", "VARCHAR", "VARYING", "VERBOSE", "VIEW", "VOLATILE", "WHEN", 
  "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", "YEAR_P", "ZONE", 
  "UNIONJOIN", "IDENT", "SCONST", "Op", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "BCONST", "XCONST", "ICONST", "PARAM", "FCONST", 
  "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", 
  "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "';'", "'{'", "'}'", 
  "','", "\"=\"", "':'", "$accept", "prog", "statements", "statement", 
  "opt_at", "stmt", "CreateUserStmt", "opt_with", "AlterUserStmt", 
  "AlterUserSetStmt", "DropUserStmt", "OptUserList", "OptUserElem", 
  "user_list", "CreateGroupStmt", "OptGroupList", "OptGroupElem", 
  "AlterGroupStmt", "DropGroupStmt", "CreateSchemaStmt", "OptSchemaName", 
  "OptSchemaEltList", "schema_stmt", "VariableSetStmt", "set_rest", 
  "var_name", "var_list_or_default", "var_list", "iso_level", "var_value", 
  "opt_boolean", "zone_value", "opt_encoding", "ColId_or_Sconst", 
  "VariableShowStmt", "VariableResetStmt", "ConstraintsSetStmt", 
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt", 
  "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_column_default", "opt_drop_behavior", "alter_using", 
  "ClosePortalStmt", "CopyStmt", "copy_from", "copy_file_name", 
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids", 
  "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "like_including_defaults", "TableConstraint", 
  "ConstraintElem", "opt_column_list", "columnList", "columnElem", 
  "key_match", "key_actions", "key_delete", "key_update", "key_action", 
  "OptInherit", "OptWithOids", "OnCommitOption", "OptTableSpace", 
  "CreateAsStmt", "@1", "WithOidsAs", "OptCreateAs", "CreateAsList", 
  "CreateAsElement", "CreateSeqStmt", "AlterSeqStmt", "OptSeqList", 
  "OptSeqElem", "opt_by", "CreatePLangStmt", "opt_Trusted", 
  "handler_name", "opt_lancompiler", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents", 
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", "TriggerForType", 
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable", 
  "ConstraintAttributeSpec", "ConstraintDeferrabilitySpec", 
  "ConstraintTimeSpec", "DropTrigStmt", "CreateAssertStmt", 
  "DropAssertStmt", "DefineStmt", "rowdefinition", "definition", 
  "def_list", "def_elem", "def_arg", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_recheck", 
  "DropOpClassStmt", "DropStmt", "drop_type", "any_name_list", "any_name", 
  "attrs", "TruncateStmt", "FetchStmt", "fetch_direction", "fetch_count", 
  "from_in", "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "opt_revoke_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "createfunc_opt_item", 
  "opt_definition", "RemoveFuncStmt", "RemoveAggrStmt", "aggr_argtype", 
  "RemoveOperStmt", "oper_argtypes", "any_operator", "CreateCastStmt", 
  "cast_context", "DropCastStmt", "ReindexStmt", "reindex_type", 
  "opt_force", "RenameStmt", "opt_column", "AlterOwnerStmt", "RuleStmt", 
  "@2", "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "transaction_access_mode", "ViewStmt", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseSetStmt", "DropdbStmt", "CreateDomainStmt", 
  "AlterDomainStmt", "opt_as", "CreateConversionStmt", "ClusterStmt", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "InsertStmt", "insert_rest", 
  "insert_column_list", "insert_column_item", "DeleteStmt", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_update_clause", "opt_for_update_clause", 
  "update_list", "from_clause", "from_list", "table_ref", "joined_table", 
  "alias_clause", "join_type", "join_outer", "join_qual", "relation_expr", 
  "func_table", "where_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "Numeric", 
  "opt_float", "opt_numeric", "opt_decimal", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", "row", 
  "sub_type", "all_Op", "MathOp", "qual_Op", "qual_all_Op", "subquery_Op", 
  "expr_list", "extract_list", "type_list", "array_expr_list", 
  "array_expr", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "indirection_el", 
  "indirection", "opt_indirection", "opt_empty_parentheses", 
  "target_list", "target_el", "update_target_list", "inf_col_list", 
  "inf_val_list", "update_target_el", "insert_target_list", 
  "insert_target_el", "relation_name", "qualified_name_list", 
  "qualified_name", "name_list", "name", "database_name", "access_method", 
  "attr_name", "index_name", "file_name", "func_name", "AexprConst", 
  "Iconst", "Fconst", "Bconst", "Xconst", "Sconst", "PosIntConst", 
  "IntConst", "IntConstVar", "AllConstVar", "StringConst", 
  "PosIntStringConst", "NumConst", "AllConst", "PosAllConst", "UserId", 
  "SpecialRuleRelation", "ECPGConnect", "connection_target", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", "ECPGDeallocate", 
  "ECPGVarDeclaration", "single_vt_declaration", "single_var_declaration", 
  "@3", "@4", "precision", "opt_scale", "ecpg_interval", 
  "ECPGDeclaration", "@5", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@6", "var_declaration", "@7", "@8", 
  "storage_declaration", "storage_clause", "storage_modifier", "var_type", 
  "enum_type", "enum_definition", "struct_union_type_with_symbol", "@9", 
  "struct_union_type", "@10", "s_struct_union_symbol", "s_struct_union", 
  "simple_type", "unsigned_type", "signed_type", "opt_signed", 
  "variable_list", "variable", "opt_initializer", "opt_pointer", 
  "ECPGDeclare", "ECPGDisconnect", "dis_name", "connection_object", 
  "ECPGExecute", "@11", "execute_rest", "execstring", "prepared_name", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "opt_sql", "ecpg_into", 
  "using_list", "UsingConst", "ECPGPrepare", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", "ECPGRelease", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", 
  "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ColId", "type_name", "function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "col_name_keyword", "func_name_keyword", "reserved_keyword", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "civar", "indicator", "cvariable", "ident", "quoted_ident_stringvar", 
  "c_stuff_item", "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,    61,    60,    62,   656,    43,    45,    42,    47,    37,
      94,   657,    91,    93,    40,    41,    46,    59,   123,   125,
      44,   658,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   423,   424,   425,   425,   426,   426,   426,   426,   426,
     426,   426,   426,   427,   428,   428,   428,   428,   428,   428,
     428,   428,   428,   428,   428,   428,   428,   428,   428,   428,
     428,   428,   428,   428,   428,   428,   428,   428,   428,   428,
     428,   428,   428,   428,   428,   428,   428,   428,   428,   428,
     428,   428,   428,   428,   428,   428,   428,   428,   428,   428,
     428,   428,   428,   428,   428,   428,   428,   428,   428,   428,
     428,   428,   428,   428,   428,   428,   428,   428,   428,   428,
     428,   428,   428,   428,   428,   428,   428,   428,   428,   428,
     428,   428,   428,   428,   428,   428,   428,   428,   428,   428,
     428,   428,   428,   428,   428,   428,   428,   429,   430,   430,
     431,   431,   432,   432,   433,   434,   434,   435,   435,   435,
     435,   435,   435,   435,   435,   436,   436,   437,   437,   438,
     438,   439,   439,   440,   440,   441,   442,   442,   443,   443,
     444,   444,   445,   445,   445,   445,   445,   445,   446,   446,
     446,   447,   447,   447,   447,   447,   447,   447,   447,   448,
     448,   449,   449,   450,   450,   451,   451,   451,   451,   452,
     452,   452,   453,   453,   453,   453,   454,   454,   454,   454,
     454,   454,   455,   455,   455,   456,   456,   457,   457,   457,
     457,   457,   458,   458,   458,   458,   458,   459,   460,   460,
     461,   461,   462,   463,   464,   464,   465,   465,   465,   465,
     465,   465,   465,   465,   465,   465,   465,   465,   465,   465,
     465,   465,   466,   466,   467,   467,   467,   468,   468,   469,
     470,   471,   471,   472,   472,   472,   473,   473,   474,   474,
     474,   474,   474,   474,   474,   474,   474,   475,   475,   476,
     476,   477,   477,   478,   478,   479,   479,   480,   480,   480,
     480,   480,   480,   480,   481,   481,   482,   482,   483,   483,
     483,   484,   485,   485,   486,   486,   486,   487,   487,   487,
     487,   487,   487,   487,   488,   488,   488,   488,   489,   490,
     490,   490,   491,   491,   492,   492,   492,   492,   493,   493,
     494,   494,   495,   496,   496,   496,   497,   497,   497,   497,
     497,   498,   499,   500,   500,   500,   500,   500,   501,   501,
     502,   502,   502,   503,   503,   503,   503,   504,   504,   506,
     505,   507,   507,   507,   508,   508,   509,   509,   510,   511,
     512,   513,   513,   514,   514,   514,   514,   514,   514,   514,
     514,   514,   514,   515,   515,   516,   517,   517,   518,   518,
     519,   519,   520,   521,   521,   522,   523,   523,   524,   525,
     525,   526,   526,   527,   527,   527,   528,   528,   528,   529,
     529,   530,   530,   531,   531,   532,   532,   532,   533,   533,
     534,   534,   535,   535,   535,   535,   536,   536,   537,   537,
     538,   539,   540,   541,   541,   541,   541,   542,   543,   544,
     544,   545,   545,   546,   546,   546,   547,   548,   548,   549,
     549,   549,   549,   550,   550,   551,   551,   552,   553,   554,
     554,   554,   554,   554,   554,   554,   554,   555,   555,   556,
     556,   557,   557,   558,   559,   559,   559,   559,   559,   559,
     559,   559,   559,   559,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   561,   562,
     562,   563,   563,   563,   563,   563,   563,   563,   563,   563,
     563,   563,   564,   564,   564,   564,   564,   564,   564,   564,
     564,   564,   565,   565,   566,   567,   568,   568,   568,   569,
     569,   570,   570,   570,   570,   570,   570,   570,   570,   570,
     570,   570,   570,   571,   571,   571,   571,   571,   571,   571,
     572,   572,   573,   573,   574,   574,   575,   575,   576,   576,
     577,   578,   579,   579,   580,   580,   581,   581,   582,   582,
     582,   583,   583,   583,   584,   585,   585,   586,   586,   587,
     587,   588,   588,   589,   589,   589,   589,   590,   590,   591,
     592,   593,   593,   594,   594,   595,   595,   595,   595,   595,
     595,   595,   595,   595,   595,   595,   595,   596,   596,   597,
     598,   599,   599,   600,   601,   601,   601,   601,   602,   602,
     603,   603,   604,   604,   605,   606,   606,   607,   607,   608,
     608,   609,   609,   609,   609,   609,   609,   609,   609,   609,
     609,   609,   609,   609,   610,   610,   611,   611,   611,   611,
     611,   611,   611,   611,   611,   611,   613,   612,   614,   614,
     614,   615,   615,   616,   616,   616,   616,   616,   617,   617,
     618,   618,   618,   618,   619,   619,   619,   620,   621,   622,
     623,   623,   624,   624,   624,   624,   624,   624,   625,   625,
     625,   626,   626,   626,   626,   627,   627,   628,   628,   629,
     630,   631,   631,   632,   632,   633,   633,   633,   633,   633,
     633,   633,   633,   633,   633,   634,   634,   635,   635,   636,
     637,   638,   638,   638,   638,   638,   639,   639,   640,   641,
     641,   641,   642,   642,   642,   643,   643,   644,   644,   645,
     645,   646,   646,   647,   647,   648,   648,   649,   650,   650,
     650,   650,   650,   651,   651,   652,   653,   653,   653,   653,
     653,   654,   654,   655,   656,   657,   658,   658,   659,   659,
     659,   659,   659,   659,   659,   659,   660,   660,   661,   662,
     663,   663,   663,   663,   663,   664,   664,   664,   665,   665,
     666,   666,   667,   667,   667,   667,   668,   668,   669,   669,
     669,   669,   670,   670,   670,   671,   671,   671,   671,   671,
     671,   671,   671,   672,   672,   673,   673,   674,   674,   674,
     674,   675,   675,   676,   677,   677,   678,   678,   678,   678,
     679,   679,   679,   679,   679,   680,   680,   681,   681,   682,
     683,   683,   684,   684,   685,   685,   686,   686,   687,   687,
     688,   688,   689,   689,   690,   690,   690,   690,   690,   690,
     690,   690,   690,   690,   690,   691,   691,   691,   691,   691,
     691,   691,   692,   692,   692,   692,   693,   693,   693,   693,
     694,   694,   695,   695,   696,   696,   696,   696,   697,   697,
     698,   698,   699,   699,   700,   701,   701,   701,   701,   702,
     702,   702,   703,   703,   703,   703,   703,   703,   703,   703,
     703,   704,   704,   704,   704,   704,   704,   704,   704,   705,
     705,   705,   705,   705,   706,   707,   707,   707,   707,   707,
     707,   707,   707,   707,   707,   707,   708,   708,   709,   709,
     709,   710,   710,   710,   711,   711,   712,   712,   713,   714,
     715,   715,   716,   716,   717,   718,   719,   719,   719,   719,
     719,   719,   720,   720,   721,   721,   722,   722,   722,   722,
     723,   724,   724,   724,   725,   725,   725,   725,   725,   725,
     725,   725,   725,   725,   725,   725,   725,   725,   726,   726,
     726,   726,   726,   726,   726,   726,   726,   726,   726,   726,
     726,   726,   726,   726,   726,   726,   726,   726,   726,   726,
     726,   726,   726,   726,   726,   726,   726,   726,   726,   726,
     726,   726,   726,   726,   726,   726,   726,   726,   726,   726,
     726,   726,   726,   726,   726,   726,   726,   726,   726,   726,
     726,   726,   726,   726,   727,   727,   727,   727,   727,   727,
     727,   727,   727,   727,   727,   727,   727,   727,   727,   727,
     727,   727,   727,   727,   727,   727,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   728,
     728,   729,   729,   729,   730,   730,   730,   731,   731,   732,
     732,   732,   732,   732,   732,   732,   732,   732,   733,   733,
     734,   734,   735,   735,   735,   735,   735,   735,   736,   736,
     737,   737,   738,   738,   739,   739,   740,   740,   741,   741,
     741,   741,   741,   741,   741,   741,   742,   742,   743,   744,
     744,   745,   745,   745,   745,   745,   745,   746,   747,   748,
     748,   748,   749,   749,   750,   750,   750,   751,   751,   752,
     753,   753,   754,   754,   755,   755,   756,   756,   756,   756,
     757,   757,   758,   758,   759,   759,   760,   760,   761,   761,
     761,   762,   762,   762,   763,   763,   764,   764,   765,   765,
     766,   766,   767,   767,   768,   768,   769,   769,   770,   770,
     771,   771,   772,   773,   774,   775,   776,   777,   778,   778,
     779,   779,   779,   779,   779,   779,   779,   779,   780,   781,
     782,   783,   784,   785,   785,   786,   786,   787,   787,   788,
     788,   788,   788,   788,   789,   789,   790,   790,   790,   791,
     791,   791,   791,   791,   792,   792,   793,   793,   793,   793,
     793,   793,   794,   795,   795,   796,   796,   796,   796,   797,
     797,   797,   797,   798,   799,   800,   800,   801,   801,   801,
     802,   802,   803,   803,   804,   804,   805,   805,   805,   805,
     806,   806,   807,   808,   808,   809,   810,   810,   811,   812,
     812,   814,   813,   815,   813,   813,   816,   817,   817,   818,
     818,   818,   818,   818,   820,   819,   821,   822,   823,   823,
     824,   824,   824,   824,   825,   825,   827,   826,   829,   828,
     830,   828,   828,   831,   831,   831,   832,   832,   832,   832,
     833,   833,   834,   834,   834,   834,   834,   834,   835,   835,
     835,   836,   838,   837,   839,   840,   839,   841,   841,   842,
     842,   843,   843,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   846,   846,   847,   847,   848,   849,   849,   850,
     850,   850,   851,   852,   853,   853,   853,   853,   854,   854,
     855,   856,   855,   857,   857,   857,   857,   857,   858,   858,
     859,   859,   860,   861,   862,   862,   863,   863,   864,   865,
     866,   866,   867,   867,   868,   868,   869,   869,   870,   871,
     871,   871,   872,   872,   873,   874,   875,   876,   876,   877,
     878,   879,   879,   880,   881,   882,   883,   883,   884,   885,
     886,   886,   887,   888,   888,   888,   888,   888,   888,   888,
     888,   888,   888,   888,   888,   888,   888,   888,   889,   890,
     890,   891,   891,   892,   892,   892,   894,   893,   895,   895,
     897,   896,   898,   898,   898,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   900,   900,   901,   901,   901,   901,
     901,   901,   901,   901,   901,   901,   901,   901,   901,   901,
     901,   901,   901,   901,   901,   901,   901,   901,   901,   901,
     901,   901,   901,   902,   902,   902,   902,   902,   902,   903,
     903,   903,   903,   903,   903,   903,   904,   905,   905,   905,
     905,   905,   905,   906,   906,   906,   906,   906,   907,   907,
     907,   907,   907,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   909,   909,   909,   909,   910,   910,   910,   910,
     911,   911,   911,   911,   911,   911,   911,   912,   912,   913,
     913,   913,   913,   913,   913,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   914,   914,   914,   914,
     914,   914,   914,   914,   914,   914,   915,   915,   915,   915,
     915,   915,   915,   915,   915,   915,   915,   915,   915,   915,
     915,   915,   915,   915,   915,   915,   915,   915,   915,   915,
     915,   915,   915,   915,   915,   915,   915,   915,   916,   916,
     916,   916,   916,   916,   916,   916,   916,   916,   916,   916,
     916,   916,   916,   916,   916,   916,   916,   916,   917,   917,
     917,   917,   917,   917,   917,   917,   917,   917,   917,   917,
     917,   917,   917,   917,   917,   917,   917,   917,   917,   917,
     917,   917,   917,   917,   917,   917,   917,   917,   917,   917,
     917,   917,   917,   917,   917,   917,   917,   917,   917,   917,
     917,   917,   917,   917,   917,   917,   917,   917,   917,   917,
     917,   917,   917,   917,   917,   917,   917,   917,   917,   917,
     917,   917,   917,   917,   918,   918,   919,   920,   920,   921,
     921,   922,   923,   924,   924,   924,   925,   926,   926,   927,
     927,   928,   928,   928,   929,   929,   930,   930,   931,   931,
     932,   932,   932,   932,   932,   933,   933,   933,   933,   933,
     933,   933,   933,   933,   933,   933,   933,   933,   933,   933,
     933,   933,   933,   933,   933,   933,   933,   933,   933,   933,
     933,   933,   933,   933,   933,   933,   933,   933,   933,   933,
     933,   933,   933,   933,   933,   933,   933,   933,   933,   933,
     933,   933,   933,   933,   933,   933,   933,   933,   933,   933,
     933
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     5,     1,     0,
       4,     5,     5,     4,     3,     2,     0,     2,     2,     1,
       1,     1,     1,     3,     3,     3,     1,     4,     5,     2,
       0,     2,     2,     6,     6,     3,     7,     5,     1,     0,
       2,     0,     1,     1,     1,     1,     1,     1,     2,     3,
       3,     3,     3,     3,     2,     5,     2,     3,     3,     1,
       3,     1,     1,     1,     3,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     6,
       1,     1,     1,     1,     0,     1,     1,     2,     3,     4,
       3,     2,     2,     3,     4,     3,     2,     4,     1,     1,
       1,     1,     1,     4,     1,     3,     3,     4,     6,     6,
       6,     6,     4,     6,     2,     4,     3,     3,     3,     3,
       3,     3,     3,     2,     1,     1,     0,     2,     0,     2,
       9,     1,     1,     1,     1,     1,     2,     0,     1,     1,
       3,     3,     1,     3,     3,     3,     4,     1,     0,     2,
       0,     3,     0,     1,     0,    11,    12,     1,     1,     2,
       2,     2,     2,     0,     1,     0,     1,     3,     1,     1,
       1,     3,     2,     0,     3,     1,     1,     2,     1,     1,
       2,     4,     2,     5,     1,     2,     2,     2,     3,     2,
       2,     0,     3,     1,     4,     4,     5,    11,     3,     0,
       3,     1,     1,     2,     2,     0,     1,     1,     2,     2,
       0,     3,     3,     2,     1,     1,     2,     2,     4,     0,
       2,     2,     0,     3,     4,     4,     0,     2,     0,     0,
       8,     3,     3,     1,     3,     0,     3,     1,     1,     5,
       4,     2,     0,     2,     1,     2,     3,     2,     2,     2,
       2,     3,     3,     1,     0,     8,     1,     0,     1,     2,
       2,     0,     5,     1,     0,     6,     2,     0,     3,    14,
      19,     1,     1,     1,     3,     5,     1,     1,     1,     3,
       0,     1,     0,     1,     1,     1,     3,     0,     1,     1,
       0,     2,     1,     2,     1,     2,     2,     1,     2,     2,
       6,     8,     3,     4,     4,     4,     5,     3,     3,     1,
       3,     3,     1,     1,     1,     1,    12,     1,     3,     4,
       7,     4,     2,     1,     0,     1,     0,     7,     4,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     1,
       2,     2,     3,     3,     5,     4,     4,     3,     4,     3,
       3,     2,     4,     2,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     2,     2,     1,     2,     2,     1,     1,
       1,     6,     9,     7,     9,     8,     8,     6,     9,     7,
      10,     7,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     7,     8,     2,     1,     1,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     2,
       1,     3,     1,     2,     3,     0,     3,     0,     1,     3,
       2,    12,     1,     0,     2,     0,     1,     3,     2,     5,
       4,     1,     2,     0,     9,     2,     0,     3,     2,     1,
       3,     3,     2,     1,     1,     1,     0,     1,     3,     1,
       1,     1,     4,     1,     2,     2,     2,     1,     1,     1,
       4,     5,     1,     3,     3,     2,     2,     2,     0,     5,
       7,     1,     1,     7,     1,     3,     3,     3,     1,     3,
      11,    10,     2,     0,     8,     4,     4,     1,     1,     1,
       0,     9,     6,     6,     7,     6,     6,     9,     6,     6,
       8,     8,     6,     6,     1,     0,     9,     6,     6,     6,
       7,     9,     9,     6,     6,     6,     0,    14,     1,     1,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     1,     1,     1,     1,     1,     0,     6,     2,     2,
       2,     2,     2,     3,     3,     2,     2,     2,     1,     1,
       0,     3,     1,     4,     4,     1,     0,     2,     2,     7,
       2,     5,     3,     1,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     1,     0,     5,     4,     3,
       6,     4,     6,     6,     5,     7,     1,     0,    10,     4,
       2,     1,     4,     5,     5,     2,     4,     1,     1,     1,
       0,     1,     0,     1,     0,     3,     0,     4,     1,     1,
       1,     1,     1,     1,     0,     4,     4,     2,     1,     7,
       4,     3,     1,     2,     4,     5,     3,     0,     2,     2,
       2,     3,     1,     3,     1,     2,     1,     0,     6,     7,
       0,     2,     2,     2,     3,     0,     2,     2,     1,     1,
       3,     3,     1,     2,     4,     4,     1,     1,     8,     4,
       4,     4,     2,     1,     0,     3,     3,     4,     4,     4,
       4,     2,     1,     1,     0,     1,     0,     1,     5,     1,
       0,     1,     0,     3,     1,     3,     3,     2,     2,     1,
       4,     4,     2,     2,     4,     1,     0,     1,     1,     1,
       3,     0,     2,     0,     3,     3,     1,     0,     2,     0,
       2,     0,     3,     1,     1,     2,     1,     2,     5,     6,
       5,     1,     2,     1,     4,     3,     4,     3,     5,     4,
       5,     4,     5,     2,     4,     1,     2,     2,     2,     1,
       1,     0,     4,     2,     1,     2,     2,     4,     3,     4,
       2,     0,     1,     3,     2,     2,     3,     5,     6,     3,
       4,     0,     1,     3,     3,     3,     3,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     2,     5,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     2,     2,     1,     3,     0,     5,     3,
       0,     5,     3,     0,     1,     1,     1,     1,     5,     2,
       1,     1,     1,     1,     5,     2,     2,     2,     1,     3,
       3,     2,     1,     0,     3,     0,     5,     2,     5,     2,
       1,     3,     3,     0,     1,     1,     1,     1,     1,     1,
       3,     3,     3,     3,     3,     3,     3,     0,     1,     3,
       5,     2,     2,     2,     2,     2,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     2,     3,
       3,     2,     3,     5,     4,     6,     3,     5,     4,     6,
       4,     6,     5,     7,     2,     3,     2,     4,     3,     4,
       3,     4,     3,     4,     5,     6,     7,     5,     6,     3,
       4,     4,     6,     2,     1,     3,     2,     2,     2,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     2,     2,     5,     6,     7,     1,     1,     2,     4,
       1,     3,     4,     5,     5,     4,     1,     2,     4,     2,
       4,     2,     2,     2,     6,     4,     4,     4,     4,     6,
       5,     5,     5,     4,     6,     4,     1,     2,     2,     2,
       1,     4,     3,     5,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       1,     4,     1,     4,     1,     2,     1,     2,     1,     3,
       3,     0,     3,     1,     1,     3,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     3,     2,     3,
       0,     3,     3,     2,     2,     1,     0,     2,     2,     3,
       2,     1,     1,     3,     5,     6,     4,     2,     1,     4,
       2,     0,     1,     0,     1,     2,     2,     2,     3,     5,
       1,     2,     0,     2,     2,     0,     3,     1,     3,     1,
       1,     3,     7,     1,     2,     4,     1,     3,     4,     4,
       3,     1,     1,     1,     1,     1,     1,     3,     1,     2,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     2,     3,     6,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     3,     2,     2,     3,
       7,     1,     1,     2,     2,     1,     0,     1,     3,     1,
       2,     0,     2,     0,     2,     0,     1,     3,     4,     3,
       1,     1,     1,     2,     0,     7,     3,     2,     1,     1,
       1,     0,     5,     0,     4,     2,     1,     2,     0,     1,
       3,     3,     3,     3,     0,     4,     5,     5,     0,     1,
       1,     1,     2,     2,     1,     2,     0,     7,     0,     5,
       0,     4,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     2,     1,     3,     2,
       2,     3,     0,     5,     1,     0,     5,     2,     2,     1,
       1,     1,     2,     2,     3,     1,     2,     2,     3,     3,
       4,     2,     1,     2,     1,     1,     2,     2,     3,     1,
       1,     1,     1,     0,     1,     3,     4,     0,     2,     0,
       1,     2,     3,     2,     1,     1,     1,     0,     1,     1,
       3,     0,     4,     2,     2,     1,     1,     0,     1,     1,
       1,     1,     2,     3,     0,     1,     2,     1,     4,     4,
       0,     1,     2,     1,     1,     3,     1,     1,     4,     4,
       4,     4,     1,     0,     3,     3,     4,     1,     3,     3,
       4,     1,     3,     3,     1,     6,     1,     3,     3,     6,
       1,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     4,
       4,     1,     1,     4,     4,     3,     0,     7,     1,     0,
       0,     7,     3,     4,     3,     1,     1,     1,     2,     3,
       5,     2,     5,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     0,     1,     2,
       1,     2,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     2,     3,     1,     2,     1,     3,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  1910,  1911,  1914,  1918,  1919,  1846,
    1920,  1921,  1886,  1887,  1888,  1889,  1890,  1891,  1892,  1893,
    1894,  1895,  1896,  1897,  1899,  1898,  1900,  1901,  1902,  1903,
    1904,  1905,  1906,  1907,  1909,  1908,  1923,  1924,  1912,  1913,
    1915,  1916,  1885,  1917,  1925,  1926,  1927,  1922,  1875,  1202,
    1876,    10,  1198,  1199,  1930,  1881,  1882,  1880,  1883,  1884,
    1928,  1929,  1871,  1872,  1874,    11,    12,  1873,     4,  1877,
    1878,  1879,     8,  1284,  1353,     9,  1870,  1353,     0,  1466,
    1467,  1468,     0,  1469,  1470,  1471,  1472,  1473,  1403,  1367,
       0,  1474,     0,  1475,  1476,  1477,  1478,  1479,  1480,  1481,
    1482,  1483,     0,  1484,  1485,  1486,  1487,  1488,  1352,  1489,
    1490,  1491,  1492,  1329,  1335,  1450,     0,  1309,  1310,  1306,
    1308,  1307,  1311,  1296,   660,     0,   708,   707,     0,  1758,
     660,  1759,  1726,  1760,  1727,  1728,   202,     0,   701,  1729,
       0,   660,  1730,   248,   546,  1761,     0,     0,  1731,  1732,
       0,     0,   364,   660,     0,  1733,   724,  1734,     0,  1735,
    1762,  1763,     0,     0,  1764,  1765,  1736,     0,  1737,  1738,
    1766,  1767,  1768,  1769,  1770,     0,     0,   784,     0,  1739,
    1771,  1740,  1741,     0,  1772,  1742,  1743,  1744,  1773,  1774,
    1745,  1746,  1747,     0,  1748,     0,     0,   527,  1775,   660,
    1749,   790,     0,  1750,     0,  1776,  1751,     0,  1752,  1753,
    1754,  1755,  1756,   784,  1446,  1330,     0,     0,   712,  1757,
    1777,  1857,  1858,     0,     0,     0,    43,    21,    20,    57,
      35,    16,    50,    38,    81,    82,    83,    27,    23,    19,
      24,    28,    40,    29,    39,    18,    36,    52,    42,    55,
      41,    56,    30,    48,    46,    37,    51,    54,    77,    60,
      26,    61,    73,    62,    34,    71,    69,    70,    31,    49,
      68,    72,    17,    74,    53,    67,    64,    78,    76,    84,
      65,    44,    14,    58,    33,    15,    32,    25,    80,    22,
     710,    59,    63,    47,    66,    79,    45,    75,   767,   758,
     792,   766,    86,    87,    88,     7,  1268,  1270,  1269,  1353,
    1304,  1305,  1273,  1314,  1324,  1313,  1317,  1325,  1312,  1331,
       0,    90,    92,    93,    94,    97,    98,    91,    85,    89,
      96,   103,    95,   102,    99,   100,   101,   104,   105,   106,
    1535,   957,  1533,  1534,  1532,     0,  1353,  1291,  1290,  1353,
    1300,  1324,     0,  1493,  1494,  1495,  1496,  1497,  1498,  1540,
    1541,  1542,  1543,  1544,  1546,  1545,  1555,  1556,  1557,  1558,
    1559,  1560,  1561,  1562,  1563,  1564,  1565,  1566,  1567,  1568,
    1569,  1570,  1571,  1572,  1573,  1512,  1574,  1575,  1576,  1577,
    1578,  1579,  1580,  1581,  1582,  1583,  1584,  1585,  1586,  1587,
    1588,  1589,  1590,  1549,  1591,  1592,  1593,  1594,  1595,  1596,
    1597,  1598,  1599,  1600,  1601,  1602,  1603,  1604,  1606,  1605,
    1607,  1608,  1609,  1610,  1611,  1612,  1613,  1614,  1615,  1616,
    1550,  1617,  1618,  1619,  1620,  1621,  1622,  1623,  1624,  1625,
    1626,  1627,  1628,  1629,  1630,  1631,  1632,  1633,  1634,  1635,
    1636,  1637,  1638,  1639,  1640,  1551,  1641,  1642,  1552,  1643,
    1644,  1645,  1646,  1647,  1648,  1649,  1650,  1651,  1652,  1653,
    1654,  1655,  1656,  1657,  1658,  1660,  1659,  1661,  1662,  1663,
    1664,  1665,  1666,  1667,  1668,  1669,  1670,  1671,  1672,  1673,
    1674,  1675,  1676,  1677,  1678,  1679,  1680,  1681,  1682,  1553,
    1683,  1684,  1685,  1686,  1687,  1688,  1689,  1690,  1691,  1692,
    1693,  1694,  1695,  1696,  1697,  1698,  1699,  1700,  1701,  1702,
       0,  1703,  1704,  1705,  1706,  1707,  1708,  1709,  1710,  1711,
    1712,  1713,  1714,  1715,  1716,  1717,  1718,  1719,  1720,  1721,
    1722,  1723,  1724,  1554,  1725,  1856,  1214,  1261,  1260,  1237,
    1256,  1510,  1464,  1465,  1232,  1511,  1508,  1547,  1548,  1509,
    1215,  1852,  1507,  1402,     0,     0,  1365,  1366,  1369,  1246,
    1241,  1368,     0,  1242,  1363,  1364,  1183,  1262,  1507,  1499,
    1500,  1501,  1502,  1504,  1503,  1505,  1778,  1779,  1780,  1781,
    1782,  1783,  1784,  1785,  1786,  1787,  1788,  1525,  1789,  1790,
    1791,  1792,  1793,  1794,  1795,  1796,  1797,  1798,  1799,  1800,
    1801,  1802,  1803,  1804,  1805,  1806,  1807,  1808,  1809,  1810,
    1811,  1812,  1813,  1814,  1526,  1527,  1815,  1816,  1817,  1818,
    1819,  1820,  1821,  1822,  1823,  1824,  1825,  1826,  1827,  1828,
    1829,  1830,  1831,  1832,  1833,  1834,  1835,  1836,  1529,  1837,
    1838,  1528,  1839,  1840,  1841,  1842,  1843,     0,  1319,  1539,
    1524,  1320,  1506,  1536,  1523,  1530,  1531,  1538,  1537,  1382,
    1182,  1384,  1327,  1337,  1333,  1341,  1336,     0,     0,     0,
       0,  1353,   659,   658,   652,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      13,     0,   666,   229,  1234,  1233,  1178,   700,     0,  1174,
    1175,   364,   655,   247,     0,     0,     0,     0,     0,     0,
     423,     0,     0,     0,     0,     0,     0,   139,     0,   258,
     257,     0,   356,     0,   532,     0,     0,   364,     0,     0,
       0,  1238,     0,  1659,  1380,  1381,  1267,  1692,   750,     0,
       0,     0,     0,   435,     0,   434,     0,     0,   432,     0,
     363,     0,   436,   430,   429,     0,     0,   433,     0,   431,
       0,     0,   656,  1617,  1371,   723,   710,  1556,   461,   465,
     456,   462,   470,   469,   457,   454,   455,  1669,     0,     0,
     460,     0,   451,  1203,  1205,   468,  1204,     0,   497,   510,
     504,   508,   502,   506,   505,   501,   512,   511,   507,   503,
     509,     0,   498,   499,     0,   649,  1175,   670,  1187,   783,
       0,     0,   453,   648,     0,     0,   597,   598,     0,   196,
    1685,  1753,  1704,   192,     0,     0,   657,   789,   787,     0,
       0,     0,     0,  1582,  1636,  1644,  1685,  1753,  1704,   148,
       0,   159,   191,  1685,  1753,  1704,   187,   666,     0,     0,
    1328,   651,   650,     0,     0,   854,   711,   714,   767,     0,
     660,     0,     6,  1438,   709,   705,   786,   786,     0,   786,
       0,   763,  1271,  1324,  1303,  1359,  1275,     0,     0,  1349,
    1345,  1342,  1350,  1351,  1344,  1332,   946,   947,   948,   945,
     949,   944,     0,  1279,  1316,  1285,     0,  1293,  1292,  1298,
    1359,  1302,  1859,  1860,  1404,  1236,  1253,     0,     0,     0,
       0,     0,     0,  1245,  1251,     0,  1243,     0,     0,  1864,
    1868,     0,  1866,  1861,  1318,  1390,  1383,  1385,  1387,  1339,
    1338,  1334,     0,     0,  1455,     0,     0,  1456,  1457,     0,
    1452,  1454,     0,  1359,     0,     0,  1510,  1188,  1511,  1508,
    1520,  1507,     0,   439,     0,     0,     0,   439,     0,     0,
       0,  1576,  1077,  1087,  1085,  1086,  1079,  1080,  1081,  1084,
    1082,  1083,     0,   588,  1078,     0,     0,   342,     0,     0,
       0,     0,   116,     0,     0,     0,   665,   653,   662,     0,
    1179,     0,     0,     0,   482,   491,   483,   488,     0,   485,
       0,     0,     0,   484,   486,   487,     0,   489,   490,     0,
       0,   250,     0,     0,     0,     0,   672,   697,   262,   261,
     130,   260,   259,     0,     0,   545,     0,   328,   367,     0,
       0,   109,     0,     0,     0,     0,     0,     0,     0,     0,
    1405,  1266,  1362,     0,   861,     0,   402,     0,   689,     0,
     135,     0,     0,     0,   368,     0,   114,   126,     0,   226,
     437,  1379,  1378,  1370,  1377,     0,   458,   467,   466,   464,
     463,   459,  1206,     0,   449,   450,  1390,  1393,   447,     0,
     496,     0,     0,     0,   737,  1176,     0,     0,   600,   600,
     195,   193,     0,     0,     0,     0,     0,  1726,  1727,   905,
    1143,     0,  1512,  1728,  1729,  1730,  1046,  1155,  1155,  1155,
    1731,  1732,  1599,  1733,  1734,  1195,  1735,   895,  1737,  1738,
    1739,  1740,     0,  1196,  1742,  1743,  1654,  1745,  1746,  1748,
    1749,  1155,  1751,  1752,  1753,  1754,  1755,  1756,  1194,     0,
    1155,  1757,  1088,  1200,  1201,  1152,     0,     0,  1160,     0,
       0,     0,  1066,     0,   889,   891,   892,   916,   917,   893,
     922,   923,   935,   890,     0,  1159,   958,  1070,     0,  1040,
    1036,   774,  1157,  1144,     0,  1037,  1228,  1227,  1229,  1230,
    1226,  1190,  1510,  1516,   894,  1511,  1508,  1197,  1231,  1852,
    1507,     0,     0,     0,     0,  1445,     0,   198,     0,   199,
    1180,  1685,   149,   183,   156,   182,     0,  1574,   150,     0,
     154,     0,     0,     0,   190,   188,     0,   654,   443,     0,
       0,   856,     0,   855,   713,   710,   761,   760,     5,   716,
     785,     0,     0,     0,     0,     0,     0,     0,   817,   806,
    1359,  1360,     0,  1354,     0,  1353,  1353,  1347,  1346,  1343,
       0,     0,     0,     0,     0,     0,  1220,  1219,  1276,  1278,
    1223,     0,  1359,     0,     0,  1255,     0,  1259,  1257,  1390,
    1399,  1390,  1400,  1401,  1249,  1244,  1247,     0,  1239,  1251,
    1862,     0,     0,  1865,  1321,     0,  1391,  1224,  1225,  1396,
       0,  1386,  1394,  1397,  1340,  1353,  1463,     0,  1458,  1461,
       0,  1453,     0,     0,     0,  1150,  1189,     0,     0,     0,
     440,     0,     0,     0,   688,     0,     0,     0,   691,     0,
     556,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   340,   615,   615,     0,     0,   615,     0,   615,     0,
     203,   204,     0,     0,     0,     0,     0,     0,   116,   110,
     113,  1286,     0,   667,   668,     0,   441,  1185,   699,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   403,     0,   898,   933,   933,   933,   913,   913,
     907,   896,   940,     0,   933,   910,   899,     0,   897,   943,
     943,   928,     0,   871,   881,   883,   884,   914,   915,   885,
     920,   921,   882,   957,  1515,   894,  1517,  1514,  1513,     0,
       0,   696,     0,   130,   127,   424,   404,     0,     0,   141,
       0,     0,   372,   371,     0,     0,   405,   108,   116,   342,
     335,     0,     0,     0,  1186,     0,     0,   299,   751,   755,
     752,     0,   753,     0,   734,     0,     0,   226,     0,     0,
       0,     0,     0,   226,   224,   225,     0,   428,  1372,  1375,
    1376,     0,   717,   719,   721,   720,   722,   718,   448,   445,
     446,     0,  1392,  1844,  1850,     0,  1406,  1407,     0,  1590,
    1613,  1630,  1681,     0,  1699,     0,   513,   500,     0,     0,
       0,   725,   728,     0,     0,   747,   452,  1398,   599,   596,
     595,   194,   526,     0,     0,     0,  1068,  1069,   932,   919,
    1142,     0,     0,   927,   926,     0,     0,     0,  1047,     0,
    1049,     0,  1051,     0,   903,   902,   901,  1067,  1101,     0,
     900,   933,   933,   931,   981,     0,     0,   904,     0,     0,
    1120,     0,  1052,  1126,     0,     0,     0,   939,     0,   937,
       0,     0,  1013,  1053,  1038,   961,   962,   963,   964,  1066,
    1098,     0,  1191,     0,     0,   925,     0,   957,     0,     0,
       0,     0,     0,  1096,     0,     0,   994,  1094,     0,   996,
       0,     0,     0,  1088,  1087,  1085,  1086,  1079,  1080,  1081,
    1084,   965,   966,  1092,   978,     0,   977,  1390,     0,   821,
     773,  1145,     0,     0,  1851,  1853,  1442,  1441,  1440,  1439,
    1443,  1444,  1414,     0,  1410,  1411,     0,   200,   201,   197,
       0,     0,   158,   157,   186,   185,     0,   180,   181,   153,
       0,   176,   177,   162,   173,   175,   174,   172,   151,   161,
     163,   169,   170,   171,   160,   152,   189,  1353,     0,     0,
     821,  1163,  1152,   702,     0,   706,   767,   771,   766,   770,
     793,   794,   799,   769,     0,   819,   808,   802,   807,   803,
     809,   816,   765,   805,   764,     0,  1361,  1274,  1359,   871,
    1353,  1294,  1353,  1348,  1282,   951,   952,   953,   954,   956,
     955,  1283,  1280,   950,  1281,  1222,  1221,     0,     0,     0,
       0,  1301,  1252,     0,  1235,  1258,     0,  1250,     0,  1863,
    1869,  1867,     0,     0,   871,  1847,  1459,  1847,   871,     0,
    1147,  1146,  1151,   582,     0,   581,     0,     0,     0,     0,
     687,     0,     0,     0,     0,     0,   694,   293,     0,   223,
       0,     0,     0,     0,   553,   555,   554,   548,     0,   549,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     584,   589,     0,     0,     0,   344,   354,     0,     0,     0,
     109,   109,   341,   614,   214,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   112,   111,   119,   121,     0,   120,   122,     0,
       0,     0,   115,     0,     0,   168,   661,     0,   442,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     249,   232,   231,     0,     0,   409,   412,     0,   871,     0,
       0,     0,   865,   946,   945,   944,     0,   886,   888,     0,
     686,   686,   686,   686,   686,   671,   673,   273,   128,     0,
       0,   129,     0,   328,   327,   137,   366,     0,   377,   376,
     378,     0,   373,     0,   406,   107,   339,     0,   265,     0,
       0,     0,     0,     0,   626,     0,     0,     0,     0,     0,
     754,   860,     0,     0,   579,     0,     0,   226,   226,   125,
     362,   438,  1373,  1374,   750,   444,     0,     0,  1849,  1207,
       0,  1208,     0,     0,   516,   515,   528,     0,   517,   518,
     514,   519,     0,   727,     0,     0,   732,  1152,     0,   744,
       0,   742,     0,  1177,   746,   735,     0,  1098,     0,     0,
       0,  1104,     0,     0,  1141,  1138,     0,     0,  1098,     0,
    1154,     0,     0,     0,  1111,  1112,  1113,  1110,  1114,  1109,
       0,     0,  1115,  1108,     0,   930,   929,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1014,     0,     0,  1072,
       0,  1098,  1125,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1098,  1131,     0,  1153,  1152,     0,     0,
       0,     0,  1192,   959,   979,  1158,     0,     0,   986,     0,
    1132,  1009,     0,  1000,     0,   995,     0,   998,  1002,   982,
       0,  1097,     0,  1095,     0,     0,   980,     0,   975,   973,
     974,   967,   968,   969,   970,   971,   972,   976,  1076,  1074,
    1075,     0,  1614,  1636,     0,   784,   784,   772,   782,  1156,
       0,   861,     0,     0,     0,  1041,     0,  1855,  1854,     0,
       0,     0,  1181,     0,     0,   957,     0,   871,   857,     0,
    1152,     0,   861,     0,   704,   703,     0,     0,   797,   798,
       0,   815,     0,   814,     0,     0,     0,  1272,  1355,  1357,
    1323,  1295,  1326,  1277,  1315,     0,  1299,  1254,  1248,     0,
    1388,  1395,  1449,     0,  1848,     0,     0,  1148,     0,     0,
     617,   602,   618,   603,     0,     0,     0,     0,     0,   226,
     692,   222,   693,   619,   547,   556,     0,   552,   561,  1521,
     894,   559,  1522,  1519,  1518,     0,     0,   133,   134,   605,
     606,     0,  1184,     0,     0,     0,   623,   608,   343,   353,
       0,   347,   348,   345,   349,   350,     0,     0,   206,     0,
       0,   219,   217,   226,   226,   218,   609,     0,   221,   220,
     216,   205,   625,   613,     0,   624,   612,     0,   117,   118,
       0,   166,   165,   167,   663,   664,     0,     0,     0,     0,
       0,     0,   493,   477,   492,     0,     0,     0,   471,   234,
     235,   252,   233,   408,     0,     0,     0,     0,   866,     0,
       0,   871,     0,     0,   879,   872,   880,     0,     0,     0,
       0,   685,     0,     0,     0,     0,     0,   674,   690,   132,
     131,     0,   141,   263,   140,   142,   144,   145,   146,   143,
     147,   365,     0,     0,     0,   862,     0,     0,     0,     0,
     264,   266,   268,   269,   270,     0,   337,   338,   333,     0,
       0,   329,     0,     0,   535,     0,     0,     0,   301,   302,
       0,   756,   757,     0,   226,     0,   226,   226,   647,   400,
       0,  1389,  1845,  1415,  1416,     0,  1408,  1409,     0,   530,
       0,   525,   520,   522,  1173,  1172,     0,  1171,     0,     0,
     733,   745,   738,   740,   739,     0,     0,   736,     0,   788,
       0,  1106,  1107,     0,     0,     0,     0,  1137,     0,     0,
    1136,     0,  1065,  1048,  1050,   912,     0,  1055,     0,   906,
       0,   909,     0,  1089,     0,     0,  1056,  1016,  1017,  1018,
       0,     0,     0,     0,  1088,     0,     0,     0,     0,     0,
       0,     0,  1019,  1020,  1032,  1031,  1057,  1071,     0,     0,
    1123,  1124,  1058,   941,   942,   943,   943,     0,     0,  1130,
       0,     0,     0,  1063,  1039,  1099,   934,   935,     0,     0,
       0,     0,     0,     0,  1001,   997,     0,   999,  1003,     0,
       0,     0,   988,  1010,   984,     0,     0,   990,     0,  1011,
     784,   784,   784,   784,   781,     0,     0,     0,   831,   820,
     823,   833,   824,   826,  1178,     0,   811,     0,     0,  1045,
    1042,  1423,  1424,  1425,  1426,  1427,  1428,  1429,  1430,  1431,
    1432,  1434,  1435,  1436,  1433,  1437,  1419,  1420,     0,  1412,
    1413,   155,     0,   178,   164,  1449,     0,  1164,  1161,   748,
       0,   715,   795,     0,  1090,   796,   818,   800,   804,   801,
       0,  1356,  1287,  1264,  1448,  1451,  1462,  1460,  1297,     0,
       0,     0,     0,   292,     0,     0,     0,   695,   550,   551,
     888,   620,   604,     0,     0,   586,     0,   587,   585,   346,
     352,   351,   273,     0,     0,     0,   207,   215,   212,     0,
       0,   123,   124,     0,     0,   473,   479,     0,     0,     0,
       0,   481,   253,   109,     0,   410,  1654,  1080,   411,   413,
     560,   414,   415,     0,     0,     0,     0,   869,     0,     0,
       0,     0,     0,     0,   871,   957,     0,   682,  1216,  1217,
     681,  1218,   678,   677,   684,   683,   676,   675,   680,   679,
       0,     0,     0,   284,     0,     0,   278,     0,     0,   279,
     272,   275,   276,     0,   136,     0,     0,   380,   374,   407,
       0,   864,   265,   291,   319,     0,   334,     0,     0,     0,
       0,   361,   358,     0,     0,     0,     0,     0,   298,     0,
     669,   749,  1265,   580,   226,   427,   583,   755,     0,     0,
     529,   523,     0,     0,   494,   726,     0,     0,   730,   731,
     743,   741,   226,  1099,  1105,   918,     0,  1140,  1134,     0,
       0,     0,  1100,     0,     0,  1118,  1117,  1015,  1119,     0,
       0,     0,  1030,  1029,  1027,  1028,  1021,  1022,  1023,  1024,
    1025,  1026,  1128,  1127,  1121,  1122,   938,   936,     0,  1060,
    1061,  1062,  1129,  1073,   924,   957,   960,  1007,   987,  1133,
    1004,     0,  1103,     0,   983,     0,     0,     0,   992,  1089,
       0,     0,     0,     0,     0,     0,   776,   775,   831,     0,
     833,     0,   832,   845,     0,     0,   851,   849,     0,   851,
       0,   851,     0,     0,   825,     0,   827,   845,     0,     0,
       0,   813,  1043,  1044,     0,     0,     0,  1447,     0,     0,
    1169,  1168,     0,  1358,     0,  1240,  1149,     0,     0,   294,
       0,     0,   295,     0,     0,     0,     0,   271,     0,     0,
       0,     0,   228,   610,   611,     0,     0,     0,     0,   476,
     475,   237,     0,   397,     0,     0,   401,   392,   394,     0,
       0,     0,   867,   873,   874,   875,   876,   877,   878,   870,
     887,   390,     0,     0,   282,   286,   287,   285,   277,   280,
     299,     0,     0,   382,     0,     0,   863,     0,     0,     0,
     288,     0,   322,   267,   336,   338,   331,   332,   330,     0,
     355,   359,     0,   534,     0,     0,     0,     0,   567,     0,
       0,     0,   568,   572,   569,   578,   563,   642,   643,   640,
     641,     0,   300,   594,     0,  1417,  1418,     0,   521,  1170,
       0,   495,  1139,  1054,  1064,   911,  1135,   908,  1116,     0,
       0,     0,  1059,  1193,     0,  1005,     0,  1008,   989,   985,
       0,   991,  1012,   780,   779,   778,   777,   835,   843,     0,
     822,     0,   850,   846,     0,   847,     0,     0,   848,   837,
       0,     0,   843,     0,   441,   858,     0,     0,     0,   768,
    1421,     0,  1209,  1213,  1210,  1422,   957,     0,  1165,     0,
    1263,   616,   601,     0,   296,   562,   622,   607,   621,   208,
     209,   210,   211,     0,   213,   472,     0,   478,   474,   230,
     251,   399,   398,   396,   393,   395,   868,     0,   593,     0,
       0,     0,     0,   274,   305,     0,     0,   381,     0,     0,
     375,   322,   290,   289,     0,     0,     0,   326,   360,     0,
       0,     0,   536,   543,     0,  1185,   565,   557,     0,     0,
     566,     0,   575,   576,     0,   564,   544,     0,     0,   524,
       0,  1033,     0,     0,  1006,  1102,   993,   834,     0,     0,
     836,     0,     0,   839,   841,     0,     0,     0,     0,     0,
    1182,   859,   810,   812,  1212,  1211,   179,  1166,     0,  1091,
       0,   227,   480,   238,   242,   697,   697,     0,   697,   239,
     697,   236,   593,     0,   591,   391,     0,   281,     0,   310,
       0,   265,   383,   384,   379,     0,   326,     0,   320,   321,
       0,   328,   698,     0,   328,     0,     0,   541,   538,     0,
       0,     0,   573,   574,     0,   577,   861,   729,     0,  1034,
       0,   844,   853,     0,   840,   838,   828,     0,   830,     0,
    1162,   299,     0,     0,     0,     0,     0,     0,   590,   592,
       0,   303,   304,     0,   283,   306,   307,     0,     0,   328,
     318,     0,   255,   543,   861,   537,   542,     0,   558,   570,
       0,     0,  1035,   842,     0,   829,  1167,   305,   240,   244,
       0,   245,   241,   243,     0,     0,     0,     0,   308,     0,
     309,     0,     0,     0,   416,   417,   387,   256,     0,   323,
       0,   540,   531,   543,   571,   646,   852,   310,   246,     0,
     315,     0,   314,     0,   311,   312,     0,     0,   422,     0,
       0,   385,   388,   389,   324,   325,   539,   645,   644,     0,
       0,     0,   313,   316,   317,     0,   426,   418,   369,     0,
     628,   639,   627,   629,   637,   634,   636,   635,   633,   297,
       0,   421,   425,     0,   419,   386,     0,   638,   632,   767,
     758,     0,     0,   630,   639,   387,   426,   631,     0,   420,
     370
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    68,   224,   225,   226,  1438,   227,   228,
     229,  1359,  1812,  1066,   230,  1424,  1861,   231,   232,   233,
    1036,  1865,  2234,   234,   849,   850,  1648,  1649,  1816,  1650,
    1651,  1639,  1214,  1633,   235,   236,   237,  1208,  1629,   238,
     239,  1350,  1351,  1328,  1467,  2894,   240,   241,  1833,  2201,
    2899,  2991,   714,  1380,  2513,  2514,   242,   736,  2249,  2250,
    2251,  2252,  2228,  2560,  2561,  2562,  2253,  2780,  2254,  1747,
    1886,  2267,  2268,  2999,  3054,  3055,  3056,  3114,  2782,  2927,
    3011,  1429,   243,  2580,  2261,  1879,  2255,  2256,   244,   245,
    1341,  1782,  2150,   246,   737,  2581,  2790,   247,   770,   248,
    1431,   249,   250,  1434,  1871,  1872,  2774,  2918,  3004,  3120,
    3121,  2910,  2746,  2747,  2748,   251,   252,   253,   254,  1874,
    1382,  1834,  1835,  2518,   255,  3094,  3095,   738,  3154,   256,
     257,   771,  1069,  3017,  1000,   258,   259,   789,   790,   791,
     260,  1020,  2193,   261,   262,   811,   812,   813,  1495,  2291,
    2292,  2604,   835,  1915,  1916,   263,   739,  2585,  2931,  2932,
    3018,   264,   740,  1331,  1758,  1759,  1760,  2936,  2126,  2519,
    2520,  2805,  2806,  2946,   265,   266,  1734,   267,  1769,   982,
     268,  2994,   269,   270,   828,  1509,   271,  1785,   272,   273,
    2266,  3142,  3156,  3157,  3158,  2811,  3129,   274,  3144,   276,
     277,   278,   702,   996,   997,   998,   279,   280,   281,  1855,
    1856,  2222,   282,   283,   284,   285,  1422,   286,   287,   288,
     289,   290,   875,   867,  1235,  1665,   291,  1472,   776,  3145,
    1501,  1925,  1926,  3146,   294,  1505,  1932,  1935,  3147,   296,
    1053,  1889,  3148,  1162,   299,   300,   301,  1609,  2047,   820,
    1241,   839,   880,   881,  1670,  1671,  1248,  1684,  1677,  1679,
    2701,  2869,  1249,  1682,  2083,  2051,  2409,  2410,  2411,  2682,
    2693,  2853,  2963,  2412,  2413,  1454,  2244,  2245,  1770,  1842,
    2213,  1403,  1163,  1164,  1165,  1540,  1547,  1534,  1406,  1166,
    1167,  1168,  1409,  1169,  1170,  1171,  1172,  1519,  1575,  1173,
    1174,  1557,   903,  1937,  1975,  1176,  1177,  2041,  1603,   984,
    1178,  2455,  1605,  1994,  1960,  2663,  1940,  1517,  1961,  1971,
    2335,  1978,  1983,  2360,  2361,  1995,  2011,  1179,  1944,  1945,
    2318,  1521,  1180,  1996,  1316,  1564,  1528,  1181,  1182,  1660,
    2069,  2978,  1661,  2296,  2297,  1183,  1496,   865,  2959,  1210,
     569,  2141,  2933,   708,   817,  1184,  1185,  1186,  1187,  1188,
    1189,  1190,  2215,   795,  1910,  2875,  2194,  2540,  1298,  1652,
    1191,   548,   709,   302,   571,   572,   923,   924,  1285,  1288,
    1275,  1714,   549,   550,   573,  2715,   303,   304,   305,   306,
     307,  1250,   885,  1269,  1708,   904,    72,    77,    73,   905,
     345,   346,  1690,   308,   681,  1691,  1272,   910,   349,   310,
     311,   350,   313,   658,   351,   887,   315,   888,   316,   317,
     318,   319,   895,   320,  1252,  1253,  2461,  1254,   321,   322,
     574,   575,   323,  1074,  1468,  1073,   746,   324,   325,   936,
     937,   938,  1087,  1481,  1088,  1301,  1302,   326,   327,   565,
     328,   329,   330,  1486,  1487,   331,  1624,  1625,  1626,   332,
    2283,  2284,   333,  2436,  2437,  2438,   334,   335,  1618,   336,
     337,   859,  2465,   338,   677,   339,   950,   551,   552,   553,
    1193,   661,   816,  1194,   957,   662,   341,   664,   555,   556,
     557,   558,   559,   960,   668,  1482,    74,  2103,  1483,  1197,
    1198,  1614,  1199,   562,   914,   929,   930,  2104,   932,    75,
     933
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -2748
static const int yypact[] =
{
   -2748,   247,  9243, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, 14552, -2748, -2748, 48051,   283, -2748,
   -2748, -2748, 34494, -2748, -2748, -2748, -2748, -2748,   549, 33718,
   13383, -2748, 46503, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, 46503, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, 32943,   825, -2748,   227, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748,   519,  2937, -2748, -2748, 36046, -2748,
      10, -2748, -2748, -2748, -2748, -2748, -2748, 46503, 41472, -2748,
     246,   519, -2748,   586,  6814, -2748, 36046, 36434, -2748, -2748,
   46890,   416,  1664,   519, 36822, -2748,   873, -2748, 30606, -2748,
   -2748, -2748,   736,  2435, -2748, -2748, -2748,   629, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, 41472,  1238,   555, 30994, -2748,
   -2748, -2748, -2748, 41472, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, 37210, -2748,   385, 42246,   792, -2748,   519,
   -2748,   166, 32555, -2748, 42633, -2748, -2748,   678, -2748, -2748,
   -2748, -2748, -2748,   555, -2748, 32943, 29040, 40698,   882, -2748,
   -2748, -2748, -2748,   -77, 11013,   669, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,  1087, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
     760, -2748, -2748, -2748, -2748, -2748, -2748, -2748,   110, -2748,
     793,   338, -2748, -2748, -2748, -2748, -2748, -2748, -2748, 49188,
    1086, -2748, -2748, -2748,   729, -2748,   757, -2748, -2748, -2748,
     721, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748,   599, -2748, -2748, -2748,  1139, 48430, -2748, -2748, 49188,
   -2748,   809, 37210, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   34882, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
      79, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, 46503, 46503, -2748, -2748, -2748,   865,
   -2748, -2748,   783, -2748, -2748, -2748, -2748, -2748,   844, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748,  9757, -2748, -2748,
   -2748,   878, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748,   941, -2748,   146,  1116, -2748, -2748, 32943,  1426,  1426,
    1320, 49188, -2748, -2748, -2748, 39537, 46503, 46503, 46503, 39537,
   46503, 46503, 27842, 46503, 41472, 40698, 46503, 46503, 46503, 46503,
   -2748,  1309,    15, -2748, -2748, -2748,   944, -2748,  1096, -2748,
    1105,  1746, -2748, -2748, 41472, 39537, 46503,   976,  1066, 46503,
   -2748, 46503,   763, 46503,  1054,   709,  1095, 46503, 46503, -2748,
   -2748, 46503, -2748, 46503, -2748, 46503,   679,  1137,  1329,  1274,
     346, -2748, 37210, 37210, -2748, -2748, -2748,   858, -2748, 40698,
   39537, 46503,  1099, -2748, 46503, -2748, 39537, 46503, -2748,  1208,
   -2748, 46503, -2748, -2748, -2748, 46503, 46503, -2748, 46503, -2748,
    1315, 46503, -2748,   805, -2748, -2748,   760,   835, -2748,   232,
      78,   406, -2748, -2748,    90,   105,   124,   835,   855, 41859,
   -2748, 46503,  1347, -2748, -2748, -2748, -2748, 37210,  1228, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748,  1312,  1199, -2748, 41472, -2748, -2748, -2748, -2748, -2748,
   41472,   821, -2748, -2748,  1360, 46503, -2748, -2748, 41472, -2748,
    1528,  1252,  1421, -2748,  1389,  2435, -2748, -2748,  1400, 16587,
     -94, 31382, 37210, 43020, 47277,    41, 43407,  1296,    15, -2748,
     682, -2748, -2748,  1590,  1333,  1486, -2748,    15, 41472, 49560,
   -2748, -2748, -2748, 25477,  1404,  1335, -2748,  1558,  1336,  1354,
     519,  1357, -2748, -2748, -2748, 41472,  1676,  1676,  1675,  1676,
     663,   724, -2748, -2748, -2748,  1384, -2748,  1388,  1394, -2748,
     331,  1602, -2748, -2748, -2748, -2748,  1480,  1484,  1498,  1508,
   -2748,  1511,   814, -2748, -2748, -2748,  1692, -2748, -2748, -2748,
    1384, -2748, -2748, -2748, -2748, -2748,  1769,  1755, 36046, 36046,
    1497,   -15, 32165, -2748,  1447,   865, -2748, 10364,  9757, -2748,
   12879,   846, -2748, -2748, -2748,    76, -2748, -2748, -2748,  1654,
   -2748, -2748,  1651, 46503, -2748,  1524, 46503, -2748, -2748, 47664,
   -2748, -2748,  1426,  1384,   238,  1462,  1463, -2748,  1466,  1467,
   -2748,  1469,   401,   944,   871,   114,  1604,   -99,  1470,   257,
    1586, 46503, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748,  1477, -2748, -2748,  1479,   551, -2748,   901,   558,
    1621,  1614,   -47,  1481,  1668,   344, -2748, -2748,  1678, 46503,
   -2748, 41472, 39537,  1491, -2748, -2748, -2748, -2748, 39537, -2748,
    1640,  1444, 46503, -2748, -2748, -2748, 46503, -2748, -2748,  1679,
   46503,  1526,  1496,  1792, 38375, 46503,  1533,  1822, -2748, -2748,
    1535, -2748, -2748, 46503,  1496, -2748,  1821,    85,  1639,   192,
      35,  1540, 41472, 41472,  1695, 46503, 46503, 39537, 46503, 41472,
   -2748, -2748, -2748,   554,  1544,  1512, -2748, 38375, -2748,  1470,
   -2748, 46503,  1515,  1658, -2748,  1660,  1513, -2748,  1238,    24,
   -2748, -2748, -2748, -2748,    13,   533, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, 46503,  1347,  1347,    84, -2748, -2748,    62,
   -2748, 41085,  2058,     3,   -19, -2748, 46503,   805,  1750,  1750,
   -2748, -2748,  1706,  1757,  1670,  1529,   799,  1245,   771, -2748,
   19457,  1530,   219,   219,  1532,  1536, -2748,  1538,  1541,  1542,
     773,   773,  1671,  1545,  1546, -2748,   908, -2748,  1300,   917,
    1291,   219, 19457, -2748,  1547,   983,  1549,  1551,  1553,  1346,
    1556,  1542,  1410,  1559,   862,  1126,  1560,  1568, -2748,  1545,
    1542,   234, -2748, -2748, -2748, -2748, 19457, 19457, -2748, 19457,
   19457, 16997, -2748,  1238, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748,    11, -2748,  1032,  8471, -2748, -2748, 19457, -2748,
   -2748,   -54, -2748,   238,  1569, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748,  1055, -2748, -2748,  1073,  1148, -2748, -2748,    68,
    1155,   968,   968, 35270, 35270, -2748,   245, -2748,   716,  1527,
   -2748,  1075, -2748, -2748, -2748, -2748, 35658,  1868, -2748,   902,
   -2748, 29814, 46503, 29814, -2748, -2748,  1739, -2748, -2748,  1763,
   41472, -2748, 26653, -2748, -2748,   760, -2748, -2748, -2748,  1572,
   -2748,   -77,   -77, 19457,   -77,   -26, 17407, 19457,  1804,   400,
    1384,  1582,  1234, -2748, 39150, 48809, 48809,  1774, -2748, -2748,
     905,   465,  1680,  1747,   466,  1090, -2748, -2748, -2748,  1576,
   -2748,  1841,  1384,  1387, 36046,  1628, 36046, -2748, -2748,  1956,
   -2748,  1956, -2748, -2748, -2748, -2748,  1584,   855, -2748,  1447,
   -2748, 12443,  1021, -2748, -2748,  9757, -2748, -2748, -2748, -2748,
    1983, -2748,  1588, -2748, -2748, 49188,  1595, 46503, -2748,  1596,
    1598, -2748, 49560, 19457, 29427, -2748,   238, 28653,  1663,  1665,
   -2748,  1667,  1672, 47277, -2748,   100,    83,   500, -2748,  1677,
     603,   803,  1634,  1644,  1682,  1683,  1650, 37599, 28247,  1685,
    1686,  1279,    43,  1900,  1756,  1687,  1200,  1691,    32,   -78,
    1617, -2748,  1696,  1697, 40698,  1700,  1701, 47277, -2748,  1079,
   -2748, -2748,   761, -2748, -2748,  1812,   944, -2748, -2748,  1638,
   38375,  1470,   814, 46503,  1642,   435,  1781, 46503,  1835,  1788,
      -3, 32943, -2748,  1649, -2748,  1693,  1693,  1693,  1653,  1653,
    1656, -2748, -2748,  1291,  1693,  1657, -2748, 38763, -2748,   751,
     796, -2748,  1978,    53, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748,   612, -2748,   944, -2748, -2748, -2748,  1989,
     638, -2748, 38375, -2748,   532,  1923, -2748, 46503, 46503, -2748,
   46503,  1837, -2748, -2748,    64,  1666, -2748, -2748, -2748, -2748,
     -69, 36046,  1893,  1806, -2748,  1470,  1988,  1669, -2748,  1397,
   -2748,  1768, -2748, 19457, -2748, 28653,  1992,   173,  1708, 37599,
   41472, 41472, 46503,   173, -2748, -2748, 46503, -2748, -2748,  1347,
     941, 46503, -2748, -2748, -2748, -2748, -2748, -2748,  1347, -2748,
   -2748,  2069,  1674, -2748,    68,   855,  1684, -2748,  1688, 46503,
   39537, 46503, 46503, 41472, 46503,  1740,  1689, -2748,  1728,  1694,
   26261, -2748, -2748,   127, 41472,  1843, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, 41085, 19457, 17817, -2748, -2748, -2748,  1704,
   10722,  1723, 19457, -2748, -2748, 19457, 19457,   650, -2748,   650,
   -2748,  1699, -2748,   855, -2748, -2748, -2748, -2748,  1269,   855,
   -2748,  1693,  1693, -2748,  1690, 19457,   855, -2748, 28247, 19457,
   19867, 15355, -2748, 19457,  1759,  1762,   855, -2748,   855, -2748,
   19457, 16177, -2748, -2748,   238,  2044,  2044,    61,   542,  1102,
    3597,  1705, -2748,  1805,   855, -2748,   855,   892, 38375, 19457,
   32943,  1779, 19867, 19457,  1717,  1390, -2748, 19457,   815, -2748,
    1719, 19457,  1786,   123, 19457, 19457, 19457, 19457, 19457, 19457,
   19457, 21493, 21903, -2748, 20277,   167,   148, 34106, 16587,  1950,
   -2748,  1297, 14944, 37210, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748,   855,  1721, -2748,  1748, -2748, -2748, -2748,
   46503,  1868, -2748, -2748, -2748, -2748,  1794, -2748, -2748, -2748,
    1157, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,  1725,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, 49188,  1737, 46503,
      -1, -2748, -2748, 40311, 46503, -2748, -2748,  1935, -2748, -2748,
    1741, -2748,  5764,  1935,  1884,  1892, -2748,   -52, 10722,  1927,
   10722, -2748, -2748, -2748, -2748,  1408, -2748, -2748,  1384,  1751,
   13772, -2748, 14162, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748,   814,  1752,  2129,
    1409, -2748, -2748, 36046, -2748, -2748, 32165, -2748,  1764, -2748,
   -2748, -2748, 37210,   969,  1751,  9757, -2748,  9757,  1751,  2841,
   -2748, -2748, -2748, -2748,  1758, -2748, 46503, 46503, 46503, 46503,
   -2748,  1761, 46503,  1944,  1945,  1766, -2748, -2748, 46503, -2748,
    1911, 19457,  1913, 46503, -2748, -2748, -2748, -2748,   867, -2748,
   33331,  1828,  1833, 46503, 46503, 46503, 46503, 46503,  1770,  1771,
    1772, -2748, 46503, 46503,   814, -2748,  2075,   814,   814,   486,
    1540,  1540, -2748, -2748, -2748, 46503, 46503, 46503,  1847, 46503,
   46503, 46503, 46503, 46503, 46503,   109,   985, 46503, 46503,  1889,
   46503, 46503, -2748,  1079, -2748, -2748,  2000, -2748, -2748,  1808,
     855,  1829, -2748,    60,  1908, -2748,  1910,   761, -2748, 28653,
    2115,  1995,  1996,  1840, 37599,   568, 46503, 46503,  1997,   568,
   -2748, -2748, -2748,   845,   898, -2748,  1813, 19457,    55, 38375,
    1814, 24674, -2748,  1879, -2748,  1880,   855, -2748, -2748,    64,
    1831,  1831,  1831,  1831,  1831,   638, -2748, -2748,   532,   855,
   46503, -2748,  2053,  1899, -2748,   119, -2748,  1808, -2748, -2748,
   -2748,  1977,  1974, 46503, -2748,  1079,  1279, 41472, 39924,    44,
    2055,  1238, 41472,  1947, -2748, 46503,  2158,  2060,  2061,  2076,
   -2748, 10722,  1846, 38375, -2748, 46503,  1850,   173,   173, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, 37210,   844, -2748, -2748,
     844, -2748,   844,  2250,  1527,  1848, -2748,  1470,  1527,  1527,
    1689,  1527, 43794, -2748, 18227,   904, -2748, -2748,    27, -2748,
     363,   -45,  2021, -2748, -2748, -2748,  2081, 10722,   971,   275,
     738, -2748,   855, 19457,   -13, -2748,  8624,   972,  8959,   990,
   -2748,  1858,  1859,   999, -2748, -2748, -2748, -2748, -2748, -2748,
    1863,  2091, -2748, -2748,  1867, -2748, -2748,  2562,  1019,  1869,
    9509,  1870, 19867, 19867, 19867,   419, -2748, 19867,  1871, -2748,
    1040,  8228,  1872,  1873,  1902,  1906,  1881,  1882, 10288, 18637,
   19457, 18637, 18637, 10635,  1872,  1885, -2748, -2748, 19457, 46503,
    1888,  1891, -2748, -2748,  1690, -2748,  1917,   722,  2502, 16997,
   -2748, -2748,  2098, -2748,   688, -2748,  1894, -2748, -2748,  3095,
   19867, 19457,  1717, 19457,  1957, 28247,  3887, 19457,  4127,  2278,
    2278,   163,   163,    61,    61,    61,   542,   148, -2748, -2748,
   -2748,  1896,  1129,  1190, 41472,  2059,  2808, -2748, -2748, -2748,
   23890,  1544, 19457, 19457,  1897, -2748,  1044, -2748, -2748,   164,
    2250,   855, -2748,    15,   855,   892, 30210,  1751, -2748,  1903,
   -2748, 46503,  1544,   863, -2748, -2748,  1062, 19457, -2748, -2748,
    2041, -2748, 46503, -2748, 19457, 19457, 17407, -2748, -2748,  1916,
   -2748, -2748, -2748, -2748, -2748,  1905, -2748, -2748, -2748, 46503,
   -2748, -2748,  2284,  1912,  1909,  1918,  1914, -2748, 19457,   857,
   -2748, -2748, -2748, -2748, 19457,   402,  1921,  1924, 46503,   173,
   -2748, 10722, -2748, -2748, -2748,   756, 38375, -2748, -2748,   118,
     944, -2748,   169,   188,   255, 46503, 46503,  1513,  1513, -2748,
   -2748,   890, -2748, 38375,  2050, 37987, -2748, -2748, -2748, -2748,
     814, -2748, -2748, -2748, -2748, -2748,   814,   814, -2748, 38375,
     491, -2748, -2748,   173,   173, -2748, -2748,  1973, -2748, -2748,
   -2748, -2748, -2748, -2748,  1976, -2748, -2748, 46503, -2748, -2748,
    1808, -2748, -2748, -2748, -2748, -2748,  1925, 38375,   568,   568,
   46503,  1926, -2748, -2748, -2748,  2121,  2124,   568, -2748, -2748,
   -2748,   135, -2748, -2748, 32943, 27437,  4514,  1936, -2748,  1932,
     855,  1751, 25083,  1261, -2748, -2748, -2748,   710,  2103,  1937,
    2082, -2748,    98,   136, 44181, 44568, 44955, -2748,   130, -2748,
    1513,  1993, -2748,  1773, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, 41472,    64,  1109, -2748, 38375,  1941, 41472,  1943,
    1940, -2748, -2748, -2748, -2748,  1115, -2748, 38375, -2748,  2092,
    2093, -2748, 46503,  2011,  1994, 38375,  2094,  1138, -2748, -2748,
     -77, -2748, -2748, 25869,   173,  1949,   173,   173, -2748, -2748,
     605, -2748, -2748,  1948, -2748,  1968, -2748, -2748, 39537, -2748,
   46503,   -90, -2748, -2748, -2748, 10722,  1146, -2748,   580, 46503,
     238, -2748, -2748, -2748, -2748,  2197,  2202, -2748, 43794, -2748,
   19457, -2748, -2748,  1966,  1965, 10053, 19457, -2748,  2212, 38375,
   -2748, 46503, -2748, -2748, -2748, -2748,   855, -2748, 19457, -2748,
   19457, -2748,   855, -2748, 19457,  2194, -2748,  2308,    52,  2308,
   38375, 19867,   648,  1549, 21083, 19867, 19867, 19867, 19867, 19867,
   19867, 19867, 22299, 22709, -2748,   104, -2748, -2748, 19457, 19457,
    2203,  2194, -2748, -2748, -2748,  1416,  1416, 38375,  1980,  1872,
    1982,  1984, 19457, -2748,   238,  4943, -2748,  2271,  1238, 20687,
   19867, 19457,  1153, 19457, -2748, -2748,  1979, -2748, -2748, 38375,
   19457,  1414,  3249, -2748,  4788, 19457,  1991,  5830, 16997, -2748,
     555,   555,   555,   555, -2748, 41472, 41472, 23498, 45342,  1987,
     654, -2748, 45342, 45729,  1077,  1986,  2213,  1180,  1181, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748,  1990, -2748,  2008, -2748,
   -2748, -2748,  1999, -2748, -2748,  2284,  2010,   868, -2748, -2748,
   19047, -2748, -2748,  1998, -2748, -2748,  1527, -2748, -2748, -2748,
    9757, -2748, -2748,  2007, -2748, -2748, -2748, -2748, -2748,  4906,
    2065,  2066,  5735, -2748, 46503, 46503,  1182, -2748, -2748, -2748,
    2009, -2748, -2748,  2067,  2070, -2748,  2071, -2748, -2748, -2748,
   -2748, -2748, -2748,   547,   438, 38375, -2748, -2748, -2748, 46503,
   46503,  1513, -2748,  2201,  2013, -2748, -2748,  2207,  2209,   568,
     568, -2748, -2748,  1540,  2265, -2748,  1998,  1090, -2748, -2748,
   -2748, -2748, -2748,   826,   855,  1450,  2012, -2748,   949, 25083,
   25083, 25083, 25083, 25083,  1751,   892, 41472, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
    2019, 46503, 19867, -2748,   827,   689, -2748,  2210, 41472, -2748,
   -2748, -2748, -2748, 38375,   119,   681,  2057,  2253,  2162, -2748,
   46503, -2748, 39924,   115,  2231, 39924, -2748, 46503,  2347,  2351,
     -77,  2226,   944,  1238, 46503,  2040,  1324,   627, -2748, 46503,
   -2748, -2748, -2748, -2748,   173, -2748, -2748,  1397,   844,   164,
   -2748, -2748,  2261, 43794, -2748, -2748, 18227,  2042, -2748, -2748,
   -2748, -2748,    25, 10722, -2748, -2748, 19457, 10722, -2748,  2045,
    2046,  2047, 10722,  6621,  2048, 10722,  2203, -2748,   313,  2268,
    2192,  2051,   104,   313,  1173,  1173,    92,    92,    52,    52,
      52,  2308, 10722, 10722, -2748, -2748, -2748, -2748,  2049, -2748,
   -2748, -2748,  1872, -2748, -2748,   892, -2748,   852,   653, -2748,
     170, 38375, -2748,  1205,   653, 19867, 19457, 19457,  6119,   177,
   19457,  7120, 41472, 41472, 41472, 41472, -2748, -2748, 23105,   654,
    2054, 46503, -2748,  2063, 23890,  2246,  2200, -2748, 23890,  2200,
     396,  2200, 23890,  2248, -2748, 27045, -2748,  2072, 29427, 15766,
    2371,  2286, -2748, -2748,   164,  1101,  1238, -2748,  2073, 46503,
   -2748, 10722, 28247, -2748, 46503, -2748, -2748, 46503, 46503, -2748,
    1214,  1232, -2748,  2125, 46503, 46503, 46503,   130,  2218,  2221,
     855, 46503,  2117, -2748, -2748,   568,  2267,   568,   568, -2748,
   -2748, -2748,  1238, -2748,   837,  2336, -2748,  2283,    71,  2080,
    2304,  2305, -2748, -2748,   897,   897, -2748, -2748, -2748, -2748,
   -2748,  2309, 19457,   788,   313, -2748, -2748, -2748, -2748, -2748,
    1669,  2128, 41472,  2338,  2327,    64, -2748,  2090,  2355,  2357,
   -2748,  2097,  1455, -2748, -2748, -2748, -2748, -2748, -2748,  1238,
   -2748, -2748,  2324, -2748, 24282,  1238,  2242,  2198, -2748, 36046,
    2254,   131, -2748, -2748, -2748,  1803, -2748, -2748, -2748, -2748,
   -2748,  2168, -2748, -2748,  2339, -2748, -2748,  2245, -2748, -2748,
   18227, -2748, 10722, -2748, -2748, -2748, -2748, -2748, -2748, 19867,
    2110, 19867, -2748, -2748,  1258, -2748, 38375,   852,   653,   653,
   19457,   653, -2748, -2748, -2748, -2748, -2748, 45342,  2112, 46503,
     654, 23890, -2748, -2748,  1744, -2748, 23890,  2307, -2748, -2748,
   23890, 46503,  2119, 46503,  1345, -2748,  1260, 19457, 19457, -2748,
   -2748,  1090, -2748, -2748, -2748, -2748,   892, 19457, -2748,  2120,
   -2748, -2748, -2748,  2235, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, 19457, -2748, -2748,   568, -2748, -2748,  1760,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, 39537,  2442, 41472,
     826,  7211,  2274, -2748,  2297, 46503,   324, -2748,   765,  2247,
   -2748,  1455, -2748, -2748, 41472,  2272,  2273,  2276, -2748, 46503,
   19457,  1264, -2748, 46116,  2130,  1192, -2748,  2126,  2282,   481,
   -2748,  2277, -2748, -2748,  1496, -2748, -2748, 41472,   -77, -2748,
    1267,   327, 19867,   159, -2748, -2748,   653, -2748, 46503,  1276,
   -2748, 19457,  2136, -2748, -2748, 23890,  1744,  1277, 46503,  1284,
   38375, -2748,  1872, 10722, -2748, -2748, -2748,  2995,  2138, -2748,
   41472, 10722, -2748, -2748, -2748,  1822,  1822,    14,  1822, -2748,
    1822, -2748,  2442,  2454, -2748, -2748,  2370, -2748,    74,  2285,
    2461, 39924, -2748, -2748, -2748, 46503,  2276,  1292, -2748, -2748,
    2428,  1899, -2748,  7463,  1899, 24282, 46503, -2748, -2748, 19457,
    1238,  2346, -2748, -2748,  2296, -2748,  1544, -2748,   271, -2748,
    1302, -2748, 10722, 46503, -2748, -2748, -2748,  1304, -2748, 19457,
   -2748,  1669,  1238,  1808,  2298, 46503,  1238,  1808, -2748, -2748,
    2396, -2748, -2748,    67, -2748,  2291,  2293,    21,  2152,  1899,
   -2748,   691, -2748, 46116,  1544, -2748, -2748,  1314, -2748, -2748,
    2359,  2405, -2748, -2748,  1317, -2748, -2748,  2297, -2748, -2748,
   46503,  2149, -2748, -2748,  2260,   510,   510,  2206, -2748,  2418,
   -2748,   855,   855, 38375,  2156, -2748, 31770, -2748,  2264, -2748,
    2266, -2748, -2748, 46116, -2748,   140, -2748,  2285,  2149,  2403,
   -2748,  2500, -2748,   600, -2748, -2748, 39537, 28247, -2748,    21,
    1323, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,   543,
     826,  2289, -2748, -2748, -2748,  1470,   -64, -2748, -2748, 31770,
   -2748,   777, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   39537, -2748, -2748, 37599, -2748, -2748,  1140, -2748, -2748,  1341,
    1354,  2170,  2171, -2748,   777, 31770,  2290, -2748,  1325, -2748,
   -2748
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -2748, -2748, -2748, -2748, -2748,  2363, -2748, -1697, -2748, -2748,
   -2748, -1136, -2748, -1654, -2748,  1166, -2748, -2748, -2748, -2748,
   -2748,   358, -2748, -2748,  -741, -2748,  1368, -2748,   778,   531,
   -2748, -2748, -2748, -1387, -2748,  -673, -2748, -2748, -2748, -2748,
   -2748, -2748,   802,   439, -1394, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -1777,   368,    30, -2748,
      28,   819,   116, -2748,  -156, -2748, -2748, -2748,  -328,   497,
   -2623, -2033,    29,  -464,  -491,  -439,  -435,  -465, -2748,  -298,
    -382, -1810, -2748, -2748, -2748, -2748, -2748,    48, -1776, -2748,
    1188, -2748, -2748, -2748, -2748, -2748, -2748, -2748,   194, -2748,
   -2748, -2748, -1774, -2748,   779, -2157, -2748, -2748, -2748,  -536,
    -509, -2748, -2747,  -116,  -114, -2748, -2748, -2748, -2748, -2748,
   -1017, -2748,   430, -2748, -2748, -2748,  -484,  1211,  -529, -2748,
   -2748, -2748, -2748,  -672,  -936, -2748, -2748,  2460,   563,   -50,
   -2748, -2748, -1729, -1773, -2748,  1807, -2748,  1554,  1128,   335,
      36, -2748, -2748, -2748, -2210, -1767, -2748, -2748, -2748,  -370,
   -2268, -2748,   414, -1050, -2748,   523, -2748, -2748, -2748,   386,
   -1663, -2748,  -153, -2748, -2748, -2748, -1344, -2748, -1437, -1308,
   -2748,  -342, -2748, -2748, -2748,  1555, -2748,    80, -2748, -2748,
   -2748, -2748, -2748,  -474,  -508, -2748, -2748, -2748,   536, -2748,
   -2748, -2748,   876,  -791,  1800,   842, -1763, -2748, -2748, -2748,
     804,   -87, -2748, -2748, -2748, -2748, -1396, -2748, -2748, -2748,
     998,  2507,  -689, -2748, -2748, -2748, -2748, -2748, -2748,    -8,
   -2748, -2748,   365,    -6, -2748, -2748, -2748, -2748,    -4,  1591,
     764,    70,   -71,   -73,  -219,   262,   529, -2748, -2748,  -179,
     728, -2748, -2748, -2748, -2748,   593,  1425, -2748,   589,  -244,
   -2748, -2748,  1428, -2748, -2748,  1017, -2748, -2312,   282, -2305,
     -12,  -878,  -284,  -155, -2748, -1971, -2625,   120,  -659, -1610,
   -1788,  1299, -2748,  2300,  2463, -2748, -2748,  -981, -2748, -2748,
    2759,  3257, -2748, -2748,  3428,  4146, -2748,  -990,   320,  4629,
    1395, -1097, -1378, 10260, -1375, -1457, -2748, -2748,  -687, -2748,
   10406,   493, -2748, -1140, -2748,    39, -2748, -1439, -2748, -2748,
   -2748, -2748, -2748, -1345, -2216,  -197,   683, -2748, -2748,   766,
   -2748, -2748, -2748,  -917,  1518, -1581,   198, -2748,  1100, -2748,
      -5,  -332,   640,  -106,   111,  5498,  -808,  1985,  -828,  7358,
    -637, -1836,  -980,  1681, -2748,  -644, -2748,    -2,     8, -2748,
   -2748,   162,  -145, -2748, -1556, -2748,   -80, -2748,  -829,  -891,
   -2109,  -321, -2748, -2748,   -72, -2748,  1791, -2748,  1002,  1431,
   -2748, -2748,  1008,  -786,  -129, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748,  1473,    66, -2748,   -49, -2748, -2748,  2648, -2748,
    2413,   -35, -2748,  2074,   -34, -2748, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748,  -794,  1038, -2748,  1777, -2748, -2748,
   -2748,  -720, -2748, -2748, -2748,  1636,  -147, -2748, -2748, -2748,
    -984,   922,  1810,  -809,  -950,  1014, -2748, -2748, -2748, -2748,
   -2748, -2748, -2748, -2748,   828, -2748, -2748,   684,   829, -2748,
   -2748,   141, -2748, -2748,    34,   142, -2748, -2748,  1557, -2748,
   -2748, -2748,   298, -2748, -2748, -2748,  -537,  7954,   -66,   -84,
     -58,   101,  1548,  6019,   986,  -641,   -70,  1493,  5680,  9338,
     -38,   -48,    91,    97, -2748, -2748,  2408,  1023,   841,  -858,
    6713,  1271,  2964,  4286,  -682,  -810,  1830,  -505, -1237, -2748,
    2754
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1703
static const short yytable[] =
{
      69,   298,   547,   297,   869,   983,   659,   774,   340,  1457,
      70,   340,  1094,   794,   962,  1209,   965,  1426,   745,  1366,
     663,  1571,  1896,  1436,   340,   745,   991,  1320,   348,   659,
    1771,  1320,   660,   794,   858,  1847,   942,  1315,  1034,   312,
     314,   955,   667,   663,  1299,   968,   824,   340,  1559,  1027,
     964,   966,   666,  2232,  1880,   660,   700,  1220,  1721,  2276,
    1050,  1040,   864,  1894,   745,   667,   292,  2059,   293,  1900,
     295,  1022,  1062,  1268,   741,   666,  1941,  1303,  2600,  2089,
    2416,  2073,  1026,  2156,  2157,  2476,  2568,  1075,  2235,  2236,
    1469,  2237,  2238,  1976,  1613,  2679,   818,  2127,  2239,  1070,
    2198,  2449,  2240,  1212,   917,  1218,  1055,  2694,  2696,  2137,
    2138,  1892,  1059,  1485,  2102,  1089,  1273,  1058,  2106,  1296,
    1293,  1205,  1523,  1524,  1470,  1976,  1300,  1296,  1573,  1435,
    2340,   659,  1277,  1278,  1479,  1480,  1464,  1464,  2258,  1578,
    1535,  1543,   951,   347,  2644,   663,  1840,  2914,  2207,   340,
     868,   298,   931,   297,  2316,  1498,   793,   660,  1783,  1581,
    1206,   701,  1741,  2996,    71,   342,  1607,   667,   342,  1783,
    2340,   343,  2421,  1742,   343,   939,   793,   666,  2422,  2423,
    2424,   342,  2340, -1183,  -138,  1503,  1831,   343,  2050,  2181,
    2425,  2426,  2427,  1213,  2428,  2429,  2430,  1325,  1877,  2002,
    2301,  2431,  2432,  2433,   342,  1281,  2230,  2007,  1928, -1077,
     343, -1515,  3091,  1748,   672, -1077,   292,  2084,   293,  1741,
     295,  1868,  1803,   913,  3085,  2743,  1578,  3127,  2208,  1743,
    1742,  1610,  2169,  1086,  3152,  1749,  2967,  2340,  2969,   994,
    1969,  1578,   201,   340,   546,  -759,  1581,     3,  1578,  2550,
    2537,   570,   837,  2038,  2233,  1356,  1201,  1622,   196,  2039,
    2551,  1581, -1517, -1093,  3051,  1794,  1315,  2305,  1581, -1093,
    1674,   678,  3044,   679,   882,   883,  1432,  1357,  1869,  1326,
     340, -1514,  2552,   340,  2553,  1464,  1743,  2942,  2542,  2778,
     570,  1324,  2602,  1433,  -254,  3092,  1623,   908, -1610,  1336,
    1929,   352,  1875,  1559,  -759,  1795,   342,  1202,   570,  3045,
   -1632,   995,   343,   163,   909,   883,   860,   999,  1077,  1360,
    2779,  1821,   201,  2306,  1374, -1645,  2342,   838,  1641,  2745,
    2603,  1465,  1465,  1744,  1731,  1358,  -933,   223,   546,  2554,
    1332,  1750,  1675,  3037, -1661,  1878,  2300,  1832, -1513,  2340,
    3153,  -928,  2943,  2302,  2507,  3128,  1279,  3052,  1369,  3093,
    1257,  1425,   940,   682,  1371,  1402,  1608,  1943,  2085,   969,
    1585,  1586,  2850,  1442,  1938,  1939,  2854,  1499,   992,  2170,
    2859,  2342,  1792,  3149,   935,  1947,  1949,  2191,  2555,  1458,
    1744,  2340, -1703,  2556,   683,  1883,  1523,  1524,  1456,  1732,
     342,  1504,  1030,  1445,  1543,  2340,   343,  1745,  1535,  1589,
    2828,  1980,   907,  1982,  1041,  1311,  2374,  1500,  3077,  2071,
    2557,  2182,  1333,  1292,  2528,  1574,  2259,  2260,  1428,  2558,
    1818,    49,  1870,  2343,   545,  3086,  1060,   342,  1327,  1930,
     342,  2720,  2721,   343,  1466,  2603,   343,  1067,   916,  1381,
     918,  2434, -1567,  1931, -1077,   545,  1685,  2445,  -184,  2505,
    2506,   545,  2353,  2479,  1745,  1841,    49,  1841,  2511,   545,
    1300,  1602,  2056,  -762,    52,  2186,    53,   545,  1710,  1848,
    1465,  1293,  1265,  1620,  1621,   680,  1903,   919,    49,  2447,
    1715,   545,  1079,  2342,  2559, -1610,    52,  2340,  2040,  2350,
    2351,  2352,  2353,  2278,  2279,  2440,  2512, -1632, -1093,  2348,
    2349,  2350,  2351,  2352,  2353,  1976,  1976,  1976,   711,  1902,
    1976,  1741, -1645,  2501,  2435,  -759,    49,  -759,  1905,   545,
   -1515,   825,  -762, -1515, -1515,  2342,  2303,  1047, -1515,  2960,
     988, -1661,  2957,  1822,  2964,  2343,  1663,  1258,  2966, -1703,
    2344,  1965,  1966,  1597,  1598,  1599,  1600,  1601,  1602,  1334,
    2345,  2346,  2347,  1976,  2348,  2349,  2350,  2351,  2352,  2353,
    1599,  1600,  1601,  1602,  3029,  1597,  1598,  1599,  1600,  1601,
    1602, -1517,  1740,   563, -1517, -1517,  2686,  2343,  1743, -1517,
    1751,  1877,   826,   659,  1054,  1518,  1051,  2337,  2338,  2339,
   -1514,  2527,  2355, -1514, -1514,   749,  2687,   663, -1514,  -933,
     275,   340,  -933,   913,   745,   340,  1802,  1363,  2920,   660,
    1578,  2856,  3110,  2341,  -928,   545, -1612,  -928,  2689,   667,
      52,  2153,   794,  -933,   794,  1246,   794,  3022,   788,   666,
    1581,  2342,   794,  1082,  1072,  2391,   953,   883,  -928, -1567,
    1313,   983,  1751,  3034,  1314,    69,  2493,  1825,  1735,  1448,
    1048,  1914,  2344,  1918,  1919,    70,  1921, -1513,   913,  1247,
   -1513, -1513,  2345,  2346,  2347, -1513,  2348,  2349,  2350,  2351,
    2352,  2353,   570,  1318,  1471,  1920,  3072,  2443,  2311,  2304,
     151,   713,  1744,  2343,  1732,  2310,  2729,  2992,  1449,  1749,
     151,  1823,  3023,  1319,  2344,  1828,  2691,  1826,  1698,  1702,
    1448,  1820,  1703,   913,  2345,  2346,  2347,  2396,  2348,  2349,
    2350,  2351,  2352,  2353,  1049,  2477,   889,   827,  2154,  1364,
    2155,  1578,  2348,  2349,  2350,  2351,  2352,  2353,  3001,  1083,
    1836,  2754,  2755,  2756,  2757,  2758,   896,   167,  2793,  2597,
     890,  1581,  3133,  -762,   797,  -762,  1582,   167,  1752,  1843,
     275,   564,   891,  1857,  3111,  1215,  1745,  1450,   342,  2497,
    2498,  1096,   342,  2730,   343,   793,  2731,   793,   343,   793,
    2739,  2740,  1699,  1704,  2807,   793,   793,  2235,  2236,  1229,
    2237,  2238,  2685,   340,  1901,  3101,  1735,  2239,   897,   545,
    2340,  2240,  3140,   183,    52,  2728,  1850,  1754,  1451,  2629,
    2344,   897,   788,  2380,  1755,  2494,  2741,  3112,  1450,    71,
    2345,  2346,  2347, -1612,  2348,  2349,  2350,  2351,  2352,  2353,
    1033,  2192,  1299,  1339,  3113,  3126,  2076,   892,   547,   547,
    1352,  2808,   898,  2767,  2686,   899,  1917,  1245,  3098,   814,
    2369,  2495,   201,  1340,   673,   898,  3099,  1584,  1844,  1451,
    1353,   983,   201,  3134,  2687,  1303,   674,  2289,  2384,  2382,
    1452,  1627,   682,  1859,  2614,  1585,  1586,  1851,  2093,  2688,
    2593,  1756,  2595,  2596,  1976,   893,  2689,  1976,  1976,  1976,
    1976,  1976,  1976,  1976,  1976,  1976,  1976,   819,  1246,   201,
    1266,   217,  1860,   683,  2690,  1019,  2630,  2550,  -791,  1695,
    1267,   217,  2417,  2418,  1589,  2631,   900,  1628,  2020,  2003,
    1852,  1452,  2656,  1976,  2759,    69,    69,  1590,    69,   900,
    2340,  1044,  1247,  1266,   151,    70,    70,   894,    70,  2005,
    2552,   675,   869,  1267,  2342,  2148,  2809,   223,  2151,  2152,
     342,  2385,  2768,  1696,  2607,  2386,   343,  3141,    49,  -791,
    1754,   545,   126,   127,  2691,   876,  2628,  1755,  1072,  2632,
    2633,  2634,  2635,  2636,  2637,  2638,  2639,  2640,  2641,  3100,
    2743,  1853,  2765,  1854,  1342,   901,   834,  3122,  1463,  1343,
    2626,   167,  2901,  -791,   223,  2810,  2343,  1746,  1845,  1042,
     684,  1042,   298,   570,  1477,  2657,  2895,   546,  2897,  2898,
     782,   877,  3081,   902,  1784,  2021,  2645,   712,  1757,  2022,
     298,  1043,  1502,  2772,  1344,   783,  1846,  1697,  2766,   772,
    3122,   857,  1221,  1516,  1756,  2744,  1345,   183,  2902,  1843,
    2100,   676,  2692,   545,  1593,  2387,  2912,  3108,    52,  2023,
    1537,  2556,  1694,  2388,  1637,  3071,  3122,  1813,  1597,  1598,
    1599,  1600,  1601,  1602,  1814,  1950,  1346,  1473,  1342,  1474,
     878,  1475,   866,  1343,  2342,   836,  1562,  3002,  2557,  3000,
     546,   546,  1815,  1572,  2745,  1761,   872,  2558,  1569,    71,
      71,   897,    71,  3102,  1577,  1976,   201,  1297,  1222,  3003,
     972,  2128,  2113,  1223,  1695,  1762,  1863,  1028,  1344,  1029,
     973,   974,   975,  2344,   976,   977,   978,   979,   980,   981,
    1345,  1392,   873,  2345,  2346,  2347,  2343,  2348,  2349,  2350,
    2351,  2352,  2353,  1554,  1555,   898,  1634,   874,  1844,  2470,
    1638,  1899,  1717,  2024,   118,   217,   886,  1518,  1696,  2874,
    1346,  2312,  2559,  1321,  2195,  2196,   879,  2760,  2313,  2471,
    1735,  -933,   122,  -913,  -933,  1556,  -913,  2982,  1666,  1666,
     659,  1666,  2483,  1322,  1216, -1322,   196,  2764,  1554,  1555,
    2209,  2199,  2200,  1347,   663,  -933,     9,  1533,   340,   340,
     340,   223,  2484,  1631,  2480,  1323,   547,  1071,   545,  1799,
    2813,  3062,  1712,  1348,  3064,   925,   667,   545,  1976,   900,
    1558,  1515,    52,   223,    53,  1804,  1805,  1266,  2821,  1266,
    1265,  1266,  1697,  2713,  2281,  1349,   911,  1267,   545,  1267,
     546,  1267,  2652,    52,  2275,    49,  1616,   545,   545,   340,
    1617,   788,  1728,  2344,  1554,  1555,   340,   221,   545,  3097,
     222,  2340,  -943,    52,  2456,  -943,   922,  2348,  2349,  2350,
    2351,  2352,  2353,  1705,  2450,  1294,  1295,  1347,  2646,  2647,
    1724,   883,  2441,  1706,  -767,  1313,  1556,  2833,  1845,  1314,
    1313,   869,  2124,  1806,  1314,   793,  -767,  2125,  2709,    69,
    2837,   221,    49,    69,   222,   545,   657,   659,  -907,    70,
      52,  -907,    53,    70,  2531,  2532,  2533,  -940,  1265,  1349,
    -940,   663,   935,  2203,  2522,   340,  1530,  1532,  2204,  2298,
    -767,  2489,  1539,   660,  2299,   546,  1783,  2490,  2491,  1061,
    1789,  -940,   941,   667,  1807,  1808,   546,  -767,   983,  1552,
    1076,   952,  1078,   666,  1080,   342,   342,   342,  1563,   993,
    1081,   343,   343,   343,  2529,  2530,  2531,  2532,  2533,    49,
     999,  1634,   545,  1809,  2753,   570,   570,    52,  1001,    53,
    1266,  -767,  1976,  -910,  1976,  1265,  -910, -1186,   546,  -767,
    1267,  1297,  1951,  1297,  1952,  1297,  2309,  2320,  1953,  1774,
    1024,  2310,  2310,  2454,  1964,  2342,   342,  1546,  1031,  1035,
    1032,  1968,   343,   342,  2879,  2322,  2415,  1541,  1542,   343,
    2310,  1986,  2940,  1987,  2325,  2110,  1954,  2112,  2795,  2326,
    1810,  1025,    49,  1786,  1775,   545,  1790,   868,  1793,  2000,
     760,  2001,  2123,   943,  2331,  2796,   570,   944,   546,  2332,
    1720,  1295,  1067,  1067,  2139, -1515,  1576,  2343, -1515,   945,
     946,  2146,  1811,    71,  2951,  2357,  2953,    71,  1962,  2420,
    2310,  1045,  2463, -1517,  2310,  -767, -1517,  2128,  1955, -1521,
    2165,   947,   342,  2400,   948,  2401,  2172,  2451,   343,  2175,
    2176,  1046,  1630,  1909,  2485,  1776,  2488, -1522,    52,  1313,
      53,    49,  2340,  2698,   545,  1976,   659,  1315,  2976,    52,
    2492,    53,  2797,  1667,  1669,  2665,  1673,  2871,  1554,  1555,
     663,  2010,  1956,  1057,   340,  1957,  -943,  1236,  2454,  -943,
    1090,  1777,   660,  1778,  2569,   793,  2798,   793,  2504,  2570,
    2576,   793,   667,  1779,  2402,  2577,  2403,   793, -1514,  1067,
    1558, -1514,   666,  1068,   793, -1513,  2128,    49, -1513,  1097,
     545,  2012,  2799,  2588,   793,  3163,   793,  3164,  2589,  2866,
    2065,  2605, -1519,  1836,  2344,  1373,  2606,  1086,  2659, -1518,
    2013,  2064,   793,  2310,   793, -1703, -1703,  3028,  2348,  2349,
    2350,  2351,  2352,  2353,  1091,  1780,  1958,  2571,   949,  3042,
    3043,   340,  3046,   913,  3047,  2702,  2703,  2722,  2492,   972,
    2310,  2310,  2589,   546, -1175,  1242,  2128,  1244, -1175,   973,
     974,   975,  1781,   976,   977,   978,   979,   980,   981,  1092,
    2835,  1909,  2067,   883,   340,  2836,   340,  1100,    49,  2883,
     554,   545,  2800,   547,  2589,  -898,  2342,   576,  -898,  1101,
     670,  2091,  2801,  2091,  1917,  1102,  2791,  2884,  2014,  2620,
     670,  1687,  2589,  2015,  1688,  1959,  2802,  2016,   221,    49,
    2619,   222,   545,  2803,  1103,  2179,  2529,  2530,  2531,  2532,
    2533,   342,  1105,  2954,  2534,  2971,   576,   343,  2836,  3014,
    2310,  2627,  3027,  1219,  3015,   670,   710,  2606,  2343,  1224,
    -896,  3031,  3036,  -896,   576,   670,  1630,  2570,   670,  3038,
     546,  2219,   670,  2804,  2570,  1266,   670,  3060,  2648,  1313,
    1226, -1189,  1504,  1314,  2229,  1267,  3162,  3073,  2864,  3075,
    1225,  1266,  1630,    69,  2570,    69,   670,  2972,  1232,  3103,
    2662,  1267,  3106,    70,  2310,    70,  -899,  1630,  3138,  -899,
    3170,   670,  1233,  3139,   833,  3139,  1234,  2017,   342,   750,
     851,  1236,   856,  2202,   343,  2018,  1236, -1146,  -759, -1146,
     751, -1146,  1240,  2415,  2223,  2224,  2225,  2226,  1578,  1237,
    1668,  1668,  1266,  1668,  1238,  1266,  1266,   913,   752,  1887,
    1888,   342,  1267,   342,  1243,  1267,  1267,   343,  1581,   343,
     869,  1251,  2368,  1582,  2370,  2371,   753,  2314,  1554,  1555,
    -897,  2263,   546,  -897,  1711,  2344,  1255,  1688,   793,  3136,
     754,  2855,  1256,  2858,  2481,  2345,  2346,  2347,  1259,  2348,
    2349,  2350,  2351,  2352,  2353,  2087,  2096,   755,  1688,  1688,
    1260,  1002,  2750,  2751,  1261,   972,  2732,  2925,  2926,   793,
    2457,  2458,  1280,  1282,   793,   973,   974,   975,  1262,   976,
     977,   978,   979,   980,   981,   756,  1067,   793,  1263,   757,
    1003,  1264,  1271,  1274,  1276,  2983,  2405,  2406,  1279,  1287,
    1304,   758,  1004,  1305,  1307,   546,  1317, -1521,  1005,  3067,
   -1522, -1519,  2685, -1518,  1330,  1297,  1329,    71,  1335,    71,
    1583,  1337,  1006,  1354,  1584,  1338,  1355,  2795,  1361,  2984,
     670,  1362,  1365,   718,  2771,  1370,  1372,  1377,  1379,  1007,
    1381,  1383,  1585,  1586,  2796,  1420,  1421,  1423,  2985,  2442,
    1427,  1430,  1437,  1441,  1587,  1453,  1455,  3025,  1818,  1459,
    1460,  2986,  1461,  1462,  2686,  1508,  1569,  1008,   759,  1511,
     793,  1512,  1513,  1514,  1522,  2987,  1525,  1630,  1588,  2010,
    1526,  1589,  1527,  1009,  2687,  1529,  1531,   760,  1536,   223,
    1538,  1545,  1636,  1548,  1590,  1549,   722,  1550,  2399,  2688,
    1551,  2178,  1656,  1553,  1560,  1010,  2689,  2408,   761,   762,
    -533,  2797,  1561,  1612,   763,  1657,  1664,   546,  1245,  1686,
    1693,   546,  1709,  1701,  2690,   546,  1707,  1700,  1713,  1296,
    1716,  1722,  2662,  2214,  1763,  2798,   764,   765,  1723,  1725,
   -1466,   724,  1727,  1736,  1764,  1737,  2961,  1738,  1592,   766,
    1011,  1767,  1739,  2988,   767,   983,  1783,  1753,  1787,  2241,
    2989,  2799,  1765,  1766,   768,  1772,  1773,  1796,  1788,   760,
    2415,  1791,   769,   546,  2415,  1817,  1797,  1798,  2415,   726,
    1800,  1801,  1819,  1827,  2691,  2990,  1824,  1829,  1830,  1909,
    1012,  1013,   793,  1837,  1266,  2526,  1014,  1533,   576,  1518,
    1539,  1546,  1839,  1849,  1267,   720,  1867,  1881,  1882,  1895,
    1873,  1593,  1884,  1885,  1890,  3151,  1893,  1906,  1015,  1913,
    1922,  1594,  1595,  1596,  1907,  1597,  1598,  1599,  1600,  1601,
    1602,  1016,  1923,  1943,  1912,  1934,  1017,  1984,  1924,  1504,
    1985,  2800,   670,   670,  1950,  2962,  3007,   729,  1942,   730,
     659,  2801,  1578,   707,  1018,  1998,  2592,  2006,   731,  1999,
    3030,  2009,  2692,  2025,   663,  2802,  2027,   734,   340,  2050,
    3030,  2060,  2803,  2543,   745,  2066,   660,  2063,  1266,  2061,
    2934,  -546,  2068,   877,  1266,  1266,   667,  2081,  1267,  2082,
     815,  2077,  2086,  1841,  1267,  1267,   666,  2094,   823,  2095,
    2116,  2117,  2099,  2109,  2120,  2114,  2122,  2955,  2135,   869,
    2118,  2621,  2804,  2136,  2149,  2944,  2144,  2624,   869,  2162,
    2143,  2174,  2145,   799, -1700,  2177,  2180,   298,    49,  2590,
     298,   862,  2591,  1266,  2183,  3074,   995,  2415,   793,  2187,
     793,  2190,  2415,  1267,  2205,   800,  2415,  2188,  2189,  2197,
    2538,  2672,  2673,  2674,  2675,   298,  2210,  2608,  1297,  2217,
    2218, -1700,  2221,   801,   963,   576,   967,  2231,   554,   670,
     985,   670,  1428, -1700,   670,   670,   963,   554, -1700,  2242,
    2243,  2262,  2270, -1700, -1700,  2265, -1700,  3012,  2271,  2272,
    2273,  2274,  1622,  1917,   670,  2277,  2307,   576,  2288,   963,
    2308,   554,   802,  2323,  2324,  1037,   670, -1700,  2327,   670,
    2328,   963,  2329,   554,  2333,  2336,  2356,  2383,  2362,  2363,
     670,   670,  2310,  2364, -1700,   342,  2365,  2366,  2655,   670,
    2373,   343,   576,  2377,  2379,   554,  2378,  2395,  2389,   670,
    2398,  2571,  2419,   670,   670,  2453,   554,  2460,  2446,   963,
    2464,  2415,  2462,  2499,   793,  1569,  2500,  2466, -1700,  1295,
     793,  2468,  2486,  2467,  2678,  2474, -1700,   670,  2475,   670,
    2503,  2508,  2502,  2509,  3066,   670,  2510,  2525,  2524,  1703,
     546,   546,  2535,  2563,  2536,  2572,  1578,   803,  2574,   546,
    2575,  2583,  2578,  2579,  2594,  2584,  2587,  1297,  2598,  2599,
    2610,  2934,   804,   670,  2214,  2611,  1581,   805,  1515,  2749,
    2615,  1582,  2618,  2359,  2539,   546,  2340,  2358,  1573,   576,
     670,   670,   851,  2661,   851,  2649,  2881,  2650,  2714,  2651,
    2699,   819,   806,  2886,   807,  2888,  2669,  2684,  2700,  2705,
    2704,  2708,  2712,   808,  2706,  2717,  2718,  2724,  2723,  1413,
    2725,  2726, -1700,  2735,  2742,  2752,   809,   810,  2736,  2737,
     983,  2738,   972,  2762,  3118,  1049,  2769,  2773,  2775,  2781,
   -1700,  2786,   973,   974,   975,  2787,   976,   977,   978,   979,
     980,   981,  1413,  2789,  2794,  2817,  2820,  2829,    69,  2830,
    2823,  2824,  2825,  2827,  2832,  2831,   554,   554,    70,  2847,
    1286,  2851,  3135,  2860, -1700, -1700, -1700,  2849,  1583,  2852,
    2867,  2889,  1584,  2868,  2890,  2885,  2863,  2877,  2893,  2896,
    2903,   670,  2744,  2906,   670,  2907,  2908,   670,  2909,  2915,
    1585,  1586,  2919,  2792,  2917,  2921,  3161,   298,  2922,  2788,
    2923,  2924,  1587,  2929,  2938,  1705,  2939,  2941,  2947,   963,
    2949,   798,   793,  2948,  2952,  1706,  2958,   793,   793,   793,
     793,   793,  2965,  2968,  2980,  2979,  2993,  2768,  2998,  1589,
     546,  3005,  3008,  3009,  3019,  3021,  3020,  1367,  3010,  3024,
    3033,  3049,  1590,  3040,  3050,  3057,  3061,  3053,  3069,  3070,
     670,  3080,  3084,  3087,   670,  3089,  3096,  3105,   670,  2589,
     799,  3104,  3109,   670,  3086,  3085,  3119,  3124,  3131,  3125,
    1578,   963,  3132,  3150,  3165,  2891,  3166,   871,  3152,  1858,
    2564,  1655,   800,   963,  1444,  2185,   670,  2444,  2171,  2496,
    1581,  2565,  2777,  2783,  2158,  1582,  1592,  2913,  2727,   963,
     801,  2408,  2473,  3107,  1640,  2408,  3130,  3090,  2812,  2408,
    3088,  3115,    71,  3006,  3059,  2784,  2876,  1876,  2220,  3168,
    3155,   670,  2905,  2904,  2515,  3137,  1862,  3169,   821,  2818,
    1578,  1936,  1104,  2612,   670,  3065,  1497,  2566,  2478,   802,
    3048,  2586,  2945,  1579,  1510,  3143,  3167,  1227,  2184,  2227,
    1581,  2074,  2900,   775,  2609,  1582,  1476,  2814,  2280,  1593,
    2452,   546,   546,  2381,  1683,  2459,  1681,  2072,  2857,   987,
   -1703, -1703,  3035,  1597,  1598,  1599,  1600,  1601,  1602,  2680,
    2776,  2214,  2214,  2214,  2214,  2214,  1838,  2654,  2521,  1021,
    2834,  1611, -1703,  1909,  2878,  2393,  1584,  3076,  2049,  2928,
    2317,  2448,  1413,  2872,  2950,  2937,  1289,  2819,  2098,  1634,
    1718,  2097,   309,   884,  1585,  1586,  2088,  1443,   793,  1692,
    1312,  1283,  1413,  1507,   803,   934, -1703,  2101,  2870,  2815,
    2286,  2816,  2287,  2707,  2439,   546,  2131,  1689,  2282,   804,
    2105,   576,   576,   906,   805,  1908,    76,  1291,     0,  1619,
       0,     0,  1583,  1589,  1635,  1413,  1584,     0,     0,  1653,
    1654,  1653,     0,     0,     0,     0,  1590,     0,  2408,   806,
    1662,   807,     0,  2408,  1585,  1586,     0,  2408,     0,     0,
     808,     0,  1413,     0,     0,     0,  1587,     0,     0,  1093,
       0,     0,     0,   809,   810,  1095,     0,     0,     0,     0,
       0,     0,     0,  1099,     0,     0,     0,  1413,     0,     0,
    1588,     0,   576,  1589,   554,     0,     0,     0,     0,     0,
   -1703,     0,     0,     0,     0,     0,  1590,     0,  1591,     0,
       0,     0,     0,  1228,     0,     0,     0,     0,  1231,     0,
    1413,     0,     0,     0,  1413,   670,     0,     0,     0,     0,
    1239,     0,  1367,     0,     0,     0,     0,  2873,   546,  2974,
       0,   851,     0,     0,     0,   298,     0,  2591,     0,  2975,
       0,     0,     0,     0,     0,     0,   985,     0,     0,     0,
    1592,     0,  2408,  1593,     0,     0,     0,   546,     0,   546,
     546,     0,     0,     0,   546,   851,     0,  1597,  1598,  1599,
    1600,  1601,  1602,     0,     0,     0,     0,     0,     0,  1578,
       0,   963,  3160,     0,     0,   963,     0,     0,     0,     0,
       0,     0,  1579,     0,     0,     0,     0,     0,     0,  1581,
    3068,     0,     0, -1702,  1582,     0,  3116,  3117,     0,     0,
       0,   546,     0,  1593,     0,     0,     0,   546,     0,     0,
       0,   546,  3078,  1594,  1595,  1596,  3082,  1597,  1598,  1599,
    1600,  1601,  1602,  1413,     0,   554,   670,     0,   670,     0,
   -1702,     0,  2330,     0,     0,     0,  1368,     0,     0,  1635,
       0,     0, -1702,     0,     0,     0,     0, -1702,     0,     0,
       0,     0, -1702, -1702,     0, -1702,     0,     0,     0,     0,
     554,     0,     0,     0,   963,     0,     0,     0,     0,   670,
       0,     0,   685,     0,     0,     0, -1702,  1439,  1440,     0,
       0,     0,     0,     0,  1447,     0,     0,   670,     0,   670,
     670,  1583,   670, -1702,     0,  1584,   561,     0,  1927,     0,
       0,     0,     0,   577,     0,     0,   298,     0,   546,     0,
       0,     0,     0,  1585,  1586,     0,     0,     0,  3159,   686,
       0,     0,     0,  1578,     0,  1587,  1095, -1702,     0,     0,
       0,     0,     0,   687,     0, -1702,  1579,     0,     0,   793,
     793,   298,   577,  1581,     0,     0,   985,     0,  1582,  1588,
     688,     0,  1589,     0,     0,     0,     0,     0,     0,     0,
     577,   577,     0,     0,     0,  1590,     0,  1591,   577,     0,
       0,     0,   561,     0,     0,     0,     0,     0,   689,     0,
       0,     0,   690,     0,     0,     0,     0,     0,     0,     0,
     561,     0,   561,     0,     0,     0,     0,     0,     0,     0,
     819,     0,     0,     0,     0,  1413,     0,   577,     0,     0,
       0,   670,     0,     0,     0,   691,     0,     0,     0,  1592,
       0, -1702,     0,  1578,     0,     0,     0,     0,   670,     0,
       0,     0,   546,     0,     0,     0,     0,     0,     0, -1702,
       0,     0,     0,  1581,     0,  1583,     0,     0,  1582,  1584,
       0,     0,     0,     0,   546,  3079,     0,  2070,   546,  3083,
       0,   692,   670,     0,  1413,  1658,     0,  1585,  1586,  1413,
       0,     0,     0, -1702, -1702, -1702,     0,     0,     0,  1587,
       0,     0,  1593,     0,  1413,     0,     0,     0,     0,     0,
       0,     0,  1594,  1595,  1596,     0,  1597,  1598,  1599,  1600,
    1601,  1602,   693,  1588,  2107,     0,  1589,   694,     0,     0,
       0,   554,     0,  2108,  1286,     0,  2390,     0,     0,  1590,
     670,  1591,     0,     0,     0,     0,     0,     0,     0,   695,
     696,     0,     0,     0,   554,   670,   554,   576,  1413,     0,
     670,     0,   697,     0,     0, -1703,   670,   698,     0,  1584,
       0,   554,     0,     0,     0,     0,     0,   699,     0,     0,
       0,   554,   554,   554,   670,  2142,   577,  1585,  1586,     0,
     554,   670,     0,  1592,  1404,     0,     0,  1578,     0, -1703,
       0,     0,     0,  2159,  2160,   670,     0,   670,  2164,   554,
     670,   670,   670,     0,     0,   554,   670,  1581,   554,   554,
       0,     0,  1582,     0,     0,     0,  1589,  1404,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1590,
       0,     0,     0,     0,   963,   963,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1593,     0,     0,  2216,
       0,     0,     0,     0,     0,     0,  1594,  1595,  1596,     0,
    1597,  1598,  1599,  1600,  1601,  1602,     0,     0,   554,     0,
       0,     0,     0,     0,     0,  3039,     0,     0,     0,     0,
    2666,  2246,     0, -1703,     0,     0,  2257,     0,     0,     0,
       0,     0,     0,  2269,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2142,     0,  1897,  1898,     0,     0, -1703,
       0,     0,     0,  1584,   670,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2293,  1585,  1586,     0,     0,     0,     0,     0,  1095,     0,
       0,     0,     0, -1703,   577,     0,  1593,  1405,     0,  1933,
       0,     0,     0,     0,     0,     0,     0,     0,  1095,     0,
    1597,  1598,  1599,  1600,  1601,  1602,     0,     0,     0,     0,
    1589,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1405,  1413,     0,  1590,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1413,     0,
    1413,     0,   926,     0,     0,     0,     0,  2376,     0,     0,
       0,     0,     0,     0,  1413,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   985,     0,     0,     0, -1703,     0,     0,
       0,     0,  1413,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2048,     0,     0,     0,     0,     0,     0,     0,
    1413,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1653,     0,     0,  1404,     0,  1662,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     670,     0,     0,     0,     0,     0,     0,  1404,     0,     0,
    1593,  1413,     0,     0,     0,     0,     0,   576,  2075,     0,
       0,     0,  1413,     0,  1597,  1598,  1599,  1600,  1601,  1602,
    1413,     0,     0,     0,     0,     0,  2269,     0,     0,     0,
    1404,     0,     0,     0,     0,  1578,     0,     0,     0,     0,
       0,     0,     0,   554,   670,     0,     0,     0,  1579,     0,
       0,     0,     0,     0,     0,  1581,     0,  1404,     0,     0,
    1582,     0,     0,     0,     0,     0,   577,   577,     0,     0,
       0,     0,     0,     0,  1413,     0,     0,     0,     0,     0,
       0,     0,  1404,     0,     0,   554,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1413,     0,   577,  2142,     0,
       0,   561,     0,   561,     0,   561,     0,     0,     0,     0,
       0,   561,   561,     0,     0,  1404,     0,     0,     0,  1404,
    2216,   577,  1413,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   670,   670,   670,     0,     0,     0,     0,     0,
    1405,     0,     0,  1407,  1413,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1583,     0,     0,
    1405,  1584,     0,     0,     0,   577,   577,     0,     0,   561,
     670,     0,     0,     0,     0,     0,  1407,     0,     0,  1585,
    1586,   670,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1587,     0,  1405,     0,     0,     0,     0,  2601,     0,
       0,     0,     0,     0,     0,     0,     0,  1927,     0,     0,
       0,     0,     0,     0,     0,  1588,  2293,     0,  1589,     0,
    1405,     0,  2247,     0,     0,     0,   561,  2264,     0,   963,
       0,  1590,     0,  1591,     0,     0,     0,     0,  1404,     0,
       0,     0,   561,   561,     0,  1405,     0,     0,     0,     0,
    1413,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1405,     0,
       0,     0,  1405,     0,     0,  1592,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2683,     0,  1413,     0,
    2683,  2697,     0,     0,     0,  1578,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1579,     0,
       0,     0,     0,     0,     0,  1581,     0,     0,  1593,     0,
    1582,     0,     0,     0,     0,     0,     0,     0,  1594,  1595,
    1596,     0,  1597,  1598,  1599,  1600,  1601,  1602,     0,     0,
       0,     0,  1997,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2269,  2269,     0,     0,     0,     0,     0,  2404,
       0,     0,   561,     0,     0,     0,     0,     0,     0,     0,
       0,  1405,     0,     0,     0,     0,     0,   670,   670,     0,
    1484,     0,     0,  1488,     0,     0,  1413,     0,     0,     0,
    1404,   577,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1407,  2216,  2216,  2216,
    2216,  2216,     0,     0,     0,     0,     0,  1583,     0,     0,
       0,  1584,     0,     0,     0,     0,  1407,     0,     0,   670,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1585,
    1586,     0,     0,     0,     0,     0,     0,     0,  2246,  1404,
    2159,  1587,     0,  2159,  1404,  2785,     0,   561,     0,  1407,
       0,     0,  2142,     0,     0,     0,     0,  2269,   561,  1404,
       0,     0,     0,     0,     0,  1588,     0,     0,  1589,     0,
       0,  2293,     0,     0,     0,     0,  1407,     0,     0,     0,
       0,  1590,     0,  1615,     0,     0,     0,   577,   577,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     561,  1407,     0,   561,     0,   561,     0,   561,     0,     0,
       0,     0,     0,  1404,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1578,     0,     0,     0,     0,
       0,     0,     0,     0,  1407,  1592,     0,     0,  1407,     0,
       0,     0,     0,  1405,     0,  1581,  2683,  2567,     0,  2848,
    1582,  1413,     0,  2573,     0,     0,     0,     0,   577,     0,
     561,     0,     0,  2862,     0,     0,  1367,     0,     0,     0,
       0,   561,     0,     0,     0,     0,     0,  2070,     0,     0,
     985,     0,  2880,     0,     0,   554,   670,     0,     0,     0,
       0,     0,   554,   670,   554,     0,     0,     0,  1593,  2892,
       0,  1408,  1405,     0,     0,     0,     0,  1405,  1594,  1595,
    1596,     0,  1597,  1598,  1599,  1600,  1601,  1602,     0,     0,
       0,     0,  1405,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1408,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1583,     0,     0,
       0,  1584,     0,     0,     0,     0,   561,  1407,     0,     0,
       0,     0,  2935,     0,     0,     0,     0,  1635,     0,  1585,
    1586,     0,     0,     0,     0,     0,  1405,     0,     0,     0,
     344,  1587,     0,   344,     0,  1413,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   578,   344,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1589,     0,
    2676,  2677,     0,     0,     0,  2683,     0,   670,     0,   344,
       0,  1590,     0,     0,     0,   561,     0,     0,     0,  2246,
       0,  2970,     0,     0,   578,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1404,     0,     0,     0,
       0,     0,   578,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1404,     0,  1404,     0,     0,  1615,  1911,
       0,     0,  1410,     0,     0,  1592,     0,     0,     0,  1404,
       0,     0,     0,  2142,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   963,     0,     0,
       0,   963,     0,     0,     0,  1410,     0,  1404,  1413,     0,
       0,   561,     0,   561,     0,     0,     0,   561,     0,     0,
       0,   344,   561,   561,     0,  1404,   670,     0,     0,     0,
     561,     0,     0,     0,     0,     0,  2970,     0,  1593,  1407,
     561,  2761,   561,     0,     0,     0,     0,     0,  1594,  1595,
    1596,     0,  1597,  1598,  1599,  1600,  1601,  1602,   561,     0,
     561,     0,     0,  2770,     0,     0,  1404,     0,  1413,  2159,
       0,     0,     0,   670,     0,     0,     0,  1404,     0,     0,
       0,     0,     0,  2935,   963,  1404,     0,     0,     0,     0,
       0,  1484,     0,     0,  1408,     0,     0,  2058,  1407,     0,
       0,   670,     0,  1407,     0,     0,     0,  1911,     0,  1405,
       0,     0,  1578,  2269,  1408,   344,     0,     0,  1407,     0,
       0,     0,     0,     0,   561,  1579,  1405,     0,  1405,     0,
       0,   963,  1581,     0,     0,     0,     0,  1582,     0,  1404,
       0,     0,  1405,     0,     0,     0,     0,  1408,  2269,     0,
       0,     0,   344,     0,     0,   344,     0,     0,     0,     0,
    1404,     0,     0,     0,  3123,     0,     0,     0,     0,     0,
    1405,   963,  1407,     0,  1408,     0,     0,  2843,  2844,  2845,
    2846,     0,     0,     0,     0,   985,     0,  1404,  1405,     0,
       0,   561,     0,     0,     0,     0,     0,   561,     0,  1408,
       0,     0,     0,     0,     0,     0,   577,  3123,     0,  1404,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1405,
       0,     0,  1408,  3123,  1583,     0,  1408,     0,  1584,     0,
    1405,     0,     0,     0,     0,     0,     0,     0,  1405,     0,
       0,     0,     0,     0,     0,     0,  1585,  1586,   561,     0,
       0,   561,   561,     0,     0,  1410,     0,     0,  1587,     0,
       0,     0,     0,     0,     0,     0,     0,  2916,     0,     0,
       0,     0,     0,     0,     0,  1410,     0,     0,     0,     0,
       0,     0,  1588,     0,   561,  1589,     0,     0,     0,     0,
       0,     0,  1405,     0,     0,     0,     0,     0,  1590,   561,
    1591,     0,     0,   561,     0,  1404,     0,   561,  1410,     0,
       0,     0,     0,  1405,     0,   561,   578,     0,     0,     0,
     561,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   561,     0,  1410,     0,     0,     0,     0,
    1405,     0,     0,     0,     0,  1408,     0,     0,     0,     0,
       0,     0,  1592,     0,     0,   561,     0,     0,     0,     0,
    1410,     0,  1405,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1404,     0,     0,  1578,     0,     0,     0,
     577,  1484,     0,     0,  2285,     0,  1488,     0,     0,     0,
       0,     0,     0,  1410,     0,  1407,  1581,  1410,     0,     0,
       0,  1582,     0,     0,  2995,     0,     0,     0,     0,     0,
       0,     0,  1407,     0,  1407,  1593,   561,     0,     0,  1095,
       0,     0,     0,     0,     0,  1594,  1595,  1596,  1407,  1597,
    1598,  1599,  1600,  1601,  1602,     0,     0,     0,     0,  2523,
       0,     0,  3026,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1407,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1405,  2667,
       0,  1404,     0,   344,  1407,  3041,     0,   344,     0,     0,
       0,   961,     0,     0,     0,   961,     0,     0,     0,     0,
       0,     0,     0,     0,  1578,     0,     0,     0, -1703,     0,
       0,     0,  1584,     0,     0,     0,     0,  1579,     0,     0,
       0,   961,     0,     0,  1581,  1407,  1410,     0,     0,  1582,
    1585,  1586,     0,     0,     0,     0,  1407,  1408,     0,     0,
       0,  1578, -1703,     0,  1407,  1911,  1405,     0,   561,     0,
     561,     0,     0,  1052,  1579,     0,   961,     0,     0,     0,
       0,  1581,   961,     0,     0,     0,  1582,     0,     0,  1589,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1590,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1408,     0,  1407,     0,
       0,  1408,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1408,     0,     0,  1407,
       0,     0,     0,     0,     0,     0,  1583,     0,     0,     0,
    1584,     0,     0,     0,   561,     0, -1703,     0,     0,     0,
     561,   561,     0,     0,  1405,  1200,  1407,   578,  1585,  1586,
       0,     0,     0,     0,     0,     0,  1404,     0,     0,     0,
    1587,     0,     0,  1583,     0,   344,     0,  1584,  1407,     0,
    1408,     0,   561,   561,     0,     0,     0,     0,     0,     0,
       0,   561,     0,     0,  1588,  1585,  1586,  1589,     0,   561,
    1411,     0,     0,     0,   561,     0,   561,  1587,     0,  1593,
    1590,     0,  1591,     0,     0,     0,   561,   561,  1410,     0,
       0,     0,     0,  1597,  1598,  1599,  1600,  1601,  1602,     0,
       0,  1588,     0,  1411,  1589,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1590,     0,  1591,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1592,     0,     0,   577,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1410,     0,     0,
       0,     0,  1410,     0,  1407,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1410,     0,     0,
    1404,  1592,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   961,     0,
     561,     0,     0,     0,   961,     0,   561,  1593,     0,  1405,
       0,     0,     0,     0,     0,     0,     0,  1594,  1595,  1596,
    1418,  1597,  1598,  1599,  1600,  1601,  1602,     0,     0,  2716,
       0,  1410,  1407,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   961,  1593,     0,     0,     0,     0,     0,
       0,     0,   561,  1418,  1594,  1595,  1596,     0,  1597,  1598,
    1599,  1600,  1601,  1602,     0,     0,     0,     0,  2653,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1408,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1404,     0,     0,  1200,     0,     0,     0,
    1408,     0,  1408,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1408,     0,  1200,     0,
    1407,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1405,     0,     0,     0,     0,     0,     0,
       0,     0,  1200,  1200,  1408,  1200,  1200,  1200,     0,     0,
       0,     0,     0,  1404,     0,     0,     0,     0,     0,     0,
       0,     0,  1408,  1411,  1200,     0,     0,     0,     0,     0,
       0,     0,     0,   561,   561,     0,     0,     0,     0,     0,
       0,     0,     0,  1411,     0,     0,     0,     0,   561,   578,
     578,     0,     0,   561,   561,   561,   561,   561,     0,     0,
       0,     0,     0,  1408,     0,  1642,     0,     0,     0,     0,
       0,     0,     0,     0,  1408,     0,  1411,     0,     0,     0,
       0,     0,  1408,     0,     0,     0,     0,     0,     0,  1200,
       0,     0,  1200,  1200,     0,     0,     0,     0,     0,     0,
     344,   344,   344,  1411,     0,     0,     0,   561,     0,     0,
       0,     0,     0,     0,  1410,     0,  1405,     0,     0,     0,
     578,     0,  2285,     0,     0,     0,     0,     0,  1411,     0,
       0,  1410,     0,  1410,     0,     0,  1408,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1410,     0,     0,
       0,   344,     0,     0,     0,  1407,     0,  1408,   344,  1200,
       0,  1411,     0,  1418,     0,  1411,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1410,  1405,     0,     0,     0,
       0,     0,     0,  1418,  1408,     0,     0,     0,     0,     0,
       0,     0,     0,  1410,     0,     0,   706,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1408,     0,     0,     0,
       0,     0,     0,  1412,     0,     0,  1418,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   344,     0,  1911,
     561,     0,     0,   706,  1410,     0,     0,     0,     0,     0,
       0,   706,     0,  1418,     0,  1410,  1412,     0,     0,     0,
       0,     0,     0,  1410,   561,     0,     0,     0,     0,   561,
       0,   561,   561,     0,     0,     0,   561,     0,  1418,     0,
       0,     0,     0,     0,   706,   706,     0,     0,     0,     0,
       0,     0,     0,     0,  1411,     0,     0,     0,     0,  1407,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1200,
       0,  1418,     0,     0,     0,  1418,     0,  1410,     0,     0,
       0,     0,  1408,   561,     0,     0,     0,     0,     0,   561,
       0,     0,     0,   561,     0,     0,     0,     0,  1410,     0,
     665,     0,     0,     0,     0,     0,   961,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   665,     0,  1410,     0,     0,     0,     0,
    1200,  1200,     0,     0,     0,     0,     0,     0,  1200,     0,
       0,  1200,  1200,  1578,     0,     0,     0,  1410,     0,     0,
    1408,     0,     0,     0,  1963,     0,  1579,     0,     0,     0,
       0,  1200,     0,  1581,     0,  1200,  1200,  1200,  1582,  1200,
       0,     0,  1578,     0,     0,     0,  1200,  1200,     0,     0,
       0,     0,  1407,     0,     0,  1579,     0,     0,     0,  2078,
     561,     0,  1581,     0,  1418,  1200,   344,  1582,  1200,  1200,
       0,     0,     0,  1200,     0,     0,     0,  1200,     0,     0,
    1200,  1200,  1200,  1200,  1200,  1200,  1200,  1200,  1200,     0,
    1200,     0,     0,     0,  1200,   665,     0,     0,  1200,     0,
       0,     0,     0,     0,     0,     0,  1411,     0,  1578,     0,
       0,     0,  1407,     0,     0,     0,     0,     0,  1408,     0,
       0,     0,     0,  1410,  2079,     0,     0,     0,  1581,     0,
       0,     0,     0,  1582,     0,  1583,     0,     0,     0,  1584,
       0,     0,     0,   344,     0,     0,  1412,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1585,  1586,     0,
       0,     0,     0,     0,  1583,  1411,  1412,     0,  1584,  1587,
    1411,     0,     0,     0,     0,     0,   344,     0,   344,     0,
       0,     0,     0,     0,   561,  1411,  1585,  1586,     0,     0,
       0,  1410,     0,  1588,     0,     0,  1589,     0,  1587,  1412,
       0,  2670,     0,     0,     0,     0,   561,     0,     0,  1590,
     561,  1591,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1588,     0,     0,  1589,  1412,     0,     0,     0,
   -1703,     0,     0,     0,  1584,     0,     0,  1200,  1590,  1411,
    1591,     0,     0,     0,     0,     0,  2134,     0,     0,     0,
       0,  1412,  1585,  1586,     0,   561,   561,     0,     0,     0,
     561,     0,     0,  1592, -1703,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1412,     0,     0,     0,  1412,  1410,
       0,  1589,  1592,  1408,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   561,  1590,  1418,     0,     0,     0,     0,
    1418,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1200,     0,  1418,  1593,     0,     0,   561,
       0,     0,     0,     0,     0,  2080,  1594,  1595,  1596,     0,
    1597,  1598,  1599,  1600,  1601,  1602,     0,     0,     0,     0,
    2719,     0,     0,     0,     0,  1593,     0,     0, -1703,     0,
       0,     0,     0,     0,     0,  1594,  1595,  1596,     0,  1597,
    1598,  1599,  1600,  1601,  1602,     0,     0,     0,     0,  1418,
       0,     0,     0,   954,     0,     0,     0,   954,     0,     0,
       0,     0,   706,   706,     0,     0,     0,  1578,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1412,     0,     0,
    1200,     0,   706,   954,     0,     0,     0,  1581,     0,     0,
       0,  1593,  1582,     0,     0,     0,     0,  1408,     0,  1200,
       0,     0,     0,     0,     0,  1597,  1598,  1599,  1600,  1601,
    1602,     0,     0,     0,     0,     0,     0,   706,   954,     0,
       0,     0,     0,     0,   954,     0,     0,     0,  1200,  1200,
    1200,     0,     0,  1200,  1410,     0,     0,     0,     0,     0,
       0,     0,  1411,     0,     0,  1200,  1200,  1200,  1200,     0,
       0,     0,     0,     0,  1200,     0,     0,     0,     0,  1411,
    2840,  1411,     0,     0,     0,  1200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1411,  1200,  1200,     0,  1200,
       0,     0,   706,  1200,     0,     0,     0,     0,   706, -1703,
       0,     0,     0,  1584,     0,     0,   706,     0,     0,     0,
       0,     0,     0,  1411,     0,     0,   961,     0,  1200,  1200,
       0,  1585,  1586,     0,     0,     0,     0,     0,     0,     0,
    1408,  1411,     0, -1703,     0,     0,   706,   665,     0,     0,
       0,   706,     0,  1200,     0,   958,     0,     0,     0,   958,
    1200,  1200,  1200,   706,     0,     0,     0,     0,     0,     0,
    1589,     0,     0,     0,     0,     0,     0,     0,     0,  1412,
       0,     0,  1411,  1590,  1200,   958,     0,     0,  1410,     0,
    1200,     0,     0,  1411,     0,     0,     0,     0,     0,     0,
    1408,  1411,  1418,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1418,
     958,  1418,     0,     0,     0,     0,   958,     0,     0,     0,
       0,     0,     0,     0,     0,  1418,     0, -1703,  1412,     0,
       0,     0,     0,  1412,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1411,     0,     0,  1412,     0,
       0,     0,     0,  1418,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1411,     0,     0,     0,
     344,  1418,     0,     0,     0,     0,     0,     0,     0,   706,
     954,     0,     0,     0,     0,     0,   954,     0,     0,     0,
    1593,     0,     0,  1411,     0,     0,     0,     0,     0,  1195,
       0,  1410,  1412,     0,  1597,  1598,  1599,  1600,  1601,  1602,
       0,     0,  1418,     0,     0,  1411,     0,     0,     0,     0,
     706,   706,     0,  1418,     0,   954,     0,   706,     0,     0,
       0,  1418,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   961,     0,     0,     0,     0,     0,
       0,  1410,     0,     0,     0,     0,     0,     0,     0,   706,
       0,     0,     0,     0,     0,     0,  1200,     0,     0,     0,
       0,     0,  1200,     0,     0,  1418,     0,     0,     0,     0,
       0,     0,     0,     0,  1200,     0,  1200,     0,     0,     0,
    1200,     0,     0,     0,     0,     0,  1418,  1200,     0,     0,
    1200,  1200,  1200,  1200,  1200,  1200,  1200,  1200,  1200,  1200,
       0,  1411,     0,     0,  1200,  1200,     0,     0,     0,     0,
       0,     0,     0,  1418,     0,     0,     0,     0,  1200,     0,
       0,     0,     0,     0,     0,  1200,  1200,  1200,     0,  1200,
       0,     0,     0,     0,     0,  1418,  1200,     0,     0,     0,
       0,  1200,   958,     0,  1200,     0,     0,     0,   958,     0,
       0,     0,     0,   961,     0,     0,     0,     0,     0,  1578,
       0,     0,     0,     0,  1416,     0,     0,     0,     0,  1411,
       0,     0,  1579,     0,     0,     0,     0,     0,     0,  1581,
       0,     0,     0,     0,  1582,     0,     0,   958,   706,     0,
       0,     0,     0,     0,     0,     0,  1200,  1416,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1412,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1412,     0,  1412,     0,     0,     0,     0,     0,
       0,  1418,     0,     0,     0,     0,     0,     0,  1412,     0,
    1195,     0,     0,     0,     0,   560,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1411,     0,     0,
       0,     0,  1195,     0,     0,     0,  1412,     0,     0,     0,
       0,  1583,     0,     0,     0,  1584,     0,     0,     0,     0,
       0,     0,     0,     0,  1412,     0,  1195,  1195,  1200,  1195,
    1195,  1195,     0,  1585,  1586,     0,     0,     0,     0,  1418,
       0,     0,   706,     0,     0,  1587,     0,     0,  1195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   796,     0,     0,     0,  1412,     0,     0,     0,  1588,
       0,     0,  1589,     0,     0,     0,  1412,     0,     0,   560,
       0,   796,  1200,     0,  1412,  1590,     0,  1591,     0,   715,
       0,     0,  1200,     0,     0,     0,     0,     0,     0,     0,
     716,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1195,     0,     0,  1195,  1195,   717,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   718,     0,  -424,  1418,  1412,  1592,
       0,  1200,  1200,  1200,     0,     0,  1200,     0,   706,   706,
     719,     0,     0,     0,     0,     0,   720,     0,     0,  1412,
     961,     0,     0,     0,   961,     0,     0,   721,   961,     0,
       0,     0,  1411,     0,     0,  1200,     0,     0,   954,     0,
       0,   706,     0,  1195,     0,     0,  1412,  1416,     0,     0,
       0,     0,   706,     0,     0,     0,     0,   722,     0,   723,
       0,   706,  1593,     0,     0,     0,     0,  1416,  1412,     0,
       0,  -533,  1594,  1595,  1596,     0,  1597,  1598,  1599,  1600,
    1601,  1602,     0,     0,     0,     0,  2826,     0,     0,     0,
       0,     0,  -357,  1415,     0,     0,     0,     0,  1200,     0,
    1416,     0,   724,     0,     0,     0,     0,     0,     0,     0,
       0,   665,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1415,  1416,     0,     0,
     961,     0,     0,     0,     0,     0,     0,     0,   725,     0,
     726,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1416,     0,     0,   706,  1200,  -357,     0,     0,
       0,     0,     0,     0,     0,  1200,  1411,  1200,     0,     0,
       0,     0,  1418,     0,  1412,     0,  1200,     0,     0,   727,
       0,     0,     0,  1195,  -263,  1416,     0,   961,     0,  1416,
       0,     0,   961,     0,     0,     0,   961,     0,     0,     0,
       0,     0,     0,  1200,  1200,     0,  -263,   728,   729,     0,
     730,   706,     0,  1200,     0,     0,     0,     0,     0,   731,
     958,     0,     0,   732,   733,     0,     0,     0,   734,  1200,
       0,     0,     0,     0,   735,     0,     0,     0,     0,     0,
       0,     0,  1412,   961,  1195,  1195,     0,     0,  1578,     0,
       0,     0,  1195,     0,     0,  1195,  1195,     0,     0,     0,
       0,  1579,     0,     0,     0,     0,  1200,     0,  1581,     0,
       0,     0,     0,  1582,     0,  1195,     0,     0,     0,  1195,
    1195,  1195,     0,  1195,     0,     0,     0,     0,  1200,  1411,
    1195,  1195,     0,     0,     0,     0,     0,  1200,     0,     0,
       0,   961,     0,     0,     0,     0,  1418,     0,  1416,  1195,
     665,     0,  1195,  1195,     0,     0,     0,  1195,     0,     0,
       0,  1195,     0,     0,  1195,  1195,  1195,  1195,  1195,  1195,
    1195,  1195,  1195,     0,  1195,     0,     0,     0,  1195,  1578,
    1412,     0,  1195,     0,     0,     0,     0,     0,     0,  1411,
       0,   961,  1579,     0,     0,  1200,     0,     0,     0,  1581,
       0,     0,     0,     0,  1582,     0,     0,     0,     0,     0,
    1583,     0,     0,     0,  1584,  1200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1415,     0,     0,     0,
       0,     0,  1585,  1586,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1587,     0,  1415,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   706,     0,     0,  1588,  1418,
     706,  1589,     0,     0,     0,     0,     0,     0,     0,  1415,
       0,     0,     0,     0,  1590,     0,  1591,     0,     0,     0,
       0,     0,   961,     0,     0,     0,     0,     0,     0,     0,
       0,  1583,     0,     0,     0,  1584,  1415,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1195,     0,  1585,  1586,     0,   961,     0,     0,  1418,
    2132,  1415,     0,     0,     0,  1587,     0,     0,  1592,     0,
     669,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     671,     0,     0,     0,     0,  1412,     0,     0,     0,  1588,
       0,     0,  1589,     0,  1415,     0,     0,     0,  1415,     0,
       0,     0,     0,     0,     0,  1590,     0,  1591,     0,     0,
     796,     0,   796,     0,   796,   703,     0,     0,     0,  1416,
     796,   796,     0,     0,  1416,   744,     0,     0,   748,     0,
       0,  1593,   744,     0,     0,     0,   792,  1195,     0,  1416,
       0,  1594,  1595,  1596,     0,  1597,  1598,  1599,  1600,  1601,
    1602,     0,     0,     0,     0,  2842,   822,     0,     0,  1592,
       0,  1578,   706,     0,     0,     0,     0,     0,  2414,     0,
       0,   744,     0,     0,  1579,     0,     0,     0,   560,     0,
       0,  1581,     0,     0,     0,     0,  1582,     0,     0,     0,
       0,     0,     0,  1416,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1415,     0,  1412,
       0,     0,  1593,     0,  1195,     0,     0,     0,     0,     0,
       0,     0,  1594,  1595,  1596,  1270,  1597,  1598,  1599,  1600,
    1601,  1602,     0,  1195,     0,     0,  2997,     0,     0,     0,
       0,   560,   560,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1270,     0,
       0,     0,  1195,  1195,  1195,     0,     0,  1195,     0,     0,
       0,     0,     0,  1583,     0,     0,     0,  1584,     0,  1195,
    1195,  1195,  1195,     0,     0,     0,     0,     0,  1195,     0,
       0,     0,     0,     0,     0,  1585,  1586,     0,     0,  1195,
       0,     0,     0,     0,     0,     0,     0,  1587,     0,     0,
    1195,  1195,     0,  1195,     0,     0,     0,  1195,     0,     0,
     912,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1588,  1412,     0,  1589,     0,     0,     0,     0,     0,
     958,     0,  1195,  1195,     0,     0,     0,  1590,     0,  1591,
     706,     0,     0,     0,     0,     0,   706,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1195,     0,     0,
       0,     0,     0,     0,  1195,  1195,  1195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2130,
       0,   560,  1412,     0,     0,     0,   954,     0,  1195,     0,
       0,  1592,     0,     0,  1195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1416,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1416,     0,  1416,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1415,  1416,
       0,     0,     0,  1415,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1593,     0,     0,     0,  1415,     0,
       0,     0,     0,     0,  1594,  1595,  1596,  1416,  1597,  1598,
    1599,  1600,  1601,  1602,     0,     0,   560,     0,  3063,     0,
       0,     0,     0,     0,   665,  1416,     0,   560,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   706,   706,  2414,     0,     0,     0,     0,
       0,     0,  1415,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   920,   921,     0,     0,  1416,     0,     0,   560,
       0,     0,  1270,     0,  1270,     0,  1270,  1416,     0,     0,
       0,     0,     0,     0,     0,  1416,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   958,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   560,
    1195,     0,     0,     0,     0,     0,  1195,     0,     0,  1416,
     796,     0,     0,     0,     0,     0,     0,     0,  1195,     0,
    1195,     0,     0,     0,  1195,     0,     0,     0,     0,     0,
    1416,  1195,     0,     0,  1195,  1195,  1195,  1195,  1195,  1195,
    1195,  1195,  1195,  1195,   706,     0,     0,     0,  1195,  1195,
       0,     0,     0,     0,     0,     0,     0,  1416,     0,   970,
       0,   986,  1195,     0,   989,   990,   706,     0,     0,  1195,
    1195,  1195,     0,  1195,     0,     0,     0,     0,     0,  1416,
    1195,     0,     0,     0,  1023,  1195,     0,     0,  1195,     0,
       0,     0,     0,     0,     0,  1270,  1038,   958,     0,  1039,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     912,   744,     0,     0,     0,     0,     0,     0,     0,  1056,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1063,
       0,     0,     0,  1064,  1065,     0,     0,     0,     0,     0,
    1195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2130,     0,  1084,     0,  1085,
       0,     0,     0,     0,   560,   912,     0,     0,     0,     0,
       0,     0,  1415,     0,  1415,     0,     0,     0,     0,     0,
     706,   706,   706,   706,     0,  1416,     0,     0,  1415,     0,
       0,     0,  2414,  1098,     0,     0,  2414,     0,     0,     0,
    2414,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     912,     0,     0,     0,     0,     0,  1415,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2130,     0,     0,     0,     0,     0,
       0,     0,  1195,     0,     0,     0,     0,     0,     0,     0,
     796,     0,   796,  1416,     0,     0,   796,     0,     0,     0,
       0,   560,   796,     0,     0,     0,     0,     0,     0,   796,
       0,     0,     0,     0,     0,  1415,     0,     0,     0,   796,
     706,   796,     0,     0,     0,     0,  1415,     0,     0,     0,
       0,     0,     0,     0,  2130,     0,  1195,   796,     0,   796,
       0,     0,   954,     0,     0,     0,  1195,     0,     0,     0,
       0,  1306,     0,     0,  1308,     0,  1578,  1310,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1579,
       0,     0,     0,     0,     0,     0,  1581,     0,     0,     0,
       0,  1582,     0,     0,     0,     0,     0,     0,  1415,     0,
       0,  1416,     0,     0,     0,  1195,  1195,  1195,     0,  2414,
    1195,     0,     0,   560,  2414,     0,     0,     0,  2414,  1415,
       0,     0,     0,     0,   958,     0,     0,     0,   958,     0,
    1375,     0,   958,     0,  1376,     0,     0,     0,  1378,  1195,
       0,     0,     0,  1419,     0,     0,  1415,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   954,  1446,   706,  1415,     0,
       0,     0,  2358,     0,     0,     0,     0,  2359,     0,     0,
    1270,     0,   706,     0,     0,     0,   560,     0,  1583,     0,
       0,     0,  1584,     0,     0,     0,  1270,     0,     0,     0,
       0,  1478,  1195,     0,     0,   706,     0,     0,     0,     0,
    1585,  1586,     0,     0,  1506,     0,     0,     0,     0,     0,
       0,     0,  1587,  2414,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   958,     0,     0,     0,   706,     0,
       0,     0,     0,     0,     0,     0,  1588,  1270,     0,  1589,
    1270,  1270,     0,     0,     0,     0,     0,     0,     0,     0,
    1195,     0,  1590,     0,  1591,     0,     0,     0,     0,  1195,
       0,  1195,     0,   954,  1415,     0,  1416,     0,     0,     0,
    1195,     0,     0,   796,     0,     0,     0,     0,     0,     0,
       0,   958,     0,     0,     0,     0,   958,     0,   560,     0,
     958,     0,   560,     0,     0,     0,   560,  1195,  1195,  1578,
       0,     0,     0,     0,   796,     0,  1592,  1195,     0,   796,
       0,     0,  1579,     0,     0,  1580,     0,     0,     0,  1581,
       0,     0,   796,  1195,  1582,     0,     0,     0,     0,     0,
       0,     0,  1415,     0,     0,     0,     0,   958,     0,     0,
       0,     0,     0,     0,   560,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1195,     0,     0,     0,   954,     0,     0,     0,     0,  1593,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1594,
    1595,  1596,  1195,  1597,  1598,  1599,  1600,  1601,  1602,   956,
       0,  1195,     0,   956,     0,   958,     0,     0,   954,     0,
    1416,     0,     0,     0,     0,   796,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1726,     0,     0,     0,   956,
       0,  1583,     0,     0,     0,  1584,     0,     0,     0,     0,
    1415,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1585,  1586,   958,     0,     0,     0,  1195,
       0,     0,  1578,     0,   956,  1587,     0,     0,     0,     0,
     956,     0,     0,     0,     0,  1579,     0,     0,  2319,  1195,
       0,     0,  1581,     0,     0,     0,     0,  1582,     0,  1588,
       0,     0,  1589,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1590,     0,  1591,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1416,     0,     0,     0,   796,     0,  1270,
       0,     0,     0,     0,     0,     0,  1864,     0,  1866,     0,
       0,     0,     0,  1192,     0,     0,   958,     0,     0,  1592,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1583,     0,     0,     0,  1584,  1904,
     958,     0,     0,  1416,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1585,  1586,     0,     0,
       0,     0,     0,     0,     0,  1415,     0,     0,  1587,     0,
       0,     0,  1593,  1270,     0,     0,     0,     0,     0,  1270,
    1270,     0,  1594,  1595,  1596,     0,  1597,  1598,  1599,  1600,
    1601,  1602,  1588,     0,     0,  1589,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1590,     0,
    1591,   560,   560,     0,     0,     0,     0,     0,     0,     0,
     560,     0,     0,     0,     0,     0,     0,     0,  1270,     0,
       0,     0,     0,   796,     0,   796,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2541,   560,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1592,     0,     0,     0,   956,     0,     0,     0,
       0,     0,   956,     0,     0,     0,     0,     0,     0,     0,
       0,  2057,     0,     0,     0,     0,     0,     0,  1414,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2062,  1415,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   956,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1414,     0,     0,     0,  1593,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1594,  1595,  1596,     0,  1597,
    1598,  1599,  1600,  1601,  1602,     0,     0,  1578,     0,   796,
       0,     0,     0,     0,     0,   796,     0,     0,     0,     0,
    1579,     0,     0,     0,     0,     0,     0,  1581,     0,     0,
       0,     0,  1582,     0,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     912,     0,     0,     0,     0,     0,  1192,     0,     0,     0,
       0,   560,     0,     0,     0,  2111,     0,     0,     0,     0,
    2115,     0,     0,     0,     0,     0,  2119,     0,     0,     0,
    1192,  1192,  1415,  1192,  1192,  1192,     0,     0,     0,     0,
       0,     0,     0,     0,  2140,     0,     0,     0,     0,     0,
       0,  2147,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2161,     0,  2163,     0,     0,
    2166,  2167,  2168,     0,     0,     0,  2173,     0,     0,  1583,
       0,     0,     0,  1584,     0,     0,     0,     0,     0,     0,
       0,     0,  1415,     0,     0,     0,     0,     0,     0,     0,
       0,  1585,  1586,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1587,     0,     0,     0,  1192,     0,     0,
    1192,  1192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1588,     0,     0,
    1589,     0,   560,   560,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1590,     0,  1591,     0,   796,     0,     0,
       0,     0,   796,   796,   796,   796,   796,     0,     4,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,   912,     0,     0,  1192,     0,     0,
       0,  1414,     6,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     7,     8,     0,  1592,     0,     0,
       9,  1414,    10,    11,     0,     0,   560,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     0,  1414,     0,     0,     0,     0,     0,
    2321,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1593,  1414,     0,     0,     0,     0,     0,     0,     0,    36,
    1594,  1595,  1596,     0,  1597,  1598,  1599,  1600,  1601,  1602,
       0,     0,     0,     0,     0,     0,  1414,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,     0,  1414,
       0,     0,     0,  1414,     0,     0,     0,     0,     0,   560,
       0,     0,     0,     0,     0,     0,    37,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    38,   796,   956,     0,     0,     0,   560,     0,
     560,   560,     0,     0,     0,   560,     0,     0,     0,    39,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,  1192,
       0,     0,     0,     0,     0,     0,  1192,     0,     0,  1192,
    1192,     0,     0,     0,     0,     0,    40,     0,     0,    41,
       0,     0,     0,     0,  2482,     0,     0,     0,     0,  1192,
       0,     0,   560,  1192,  1192,  1192,    42,  1192,   560,     0,
       0,     0,   560,     0,  1192,  1192,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1414,  1192,     0,     0,  1192,  1192,     0,     0,
       0,  1192,     0,     0,     0,  1192,     0,     0,  1192,  1192,
    1192,  1192,  1192,  1192,  1192,  1192,  1192,     0,  1192,     0,
      43,     0,  1192,     0,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2545,  2547,  2549,     0,     0,  1578,     0,     0,
       0,     0,     0,    44,     0,     0,     0,     0,     0,     0,
    1579,     0,     0,     0,     0,     0,    45,  1581,     0,   560,
       0,     0,  1582,     0,     0,     0,     0,     0,    46,     0,
    2582,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,   744,    48,    49,     0,    50,     0,    51,     0,     0,
       0,    52,     0,    53,    54,     0,     0,     0,    55,    56,
      57,    58,    59,     0,     0,    60,    61,    62,    63,     0,
      64,    65,    66,    67,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,  1583,
       0,     0,     0,  1584,  2129,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1585,  1586,   560,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1587,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   560,     0,     0,     0,   560,
       0,     0,     4,     0,     0,     0,     0,  1588,     0,     0,
    1589,     0,     0,  1414,     0,     0,     0,     5,  1414,     0,
       0,     0,     0,  1590,     0,  1591,     6,     0,     0,     0,
       0,  1192,     0,  1414,  2334,     0,     0,     0,     7,     8,
       0,     0,     0,     0,   796,   796,    10,    11,     0,     0,
       0,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,  1592,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1414,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2733,  2734,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    36,     0,     0,     0,     0,  1192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,     0,     0,
    1593,     0,     0,     0,     0,     0,     0,     0,     0,  2763,
    1594,  1595,  1596,     0,  1597,  1598,  1599,  1600,  1601,  1602,
       0,     0,     0,     0,     0,     0,  1192,  1192,  1192,     0,
       0,  1192,     0,     0,     0,     0,     0,     0,     0,     0,
      37,     0,     0,  1192,  1192,  1192,  1192,     0,     0,     0,
       0,     0,  1192,     0,     0,     0,    38,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    39,  1192,  1192,     0,  1192,     0,     0,
       0,  1192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      40,     0,     0,    41,   956,     0,  1192,  1192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      42,     0,     0,   959,     0,     0,     0,   959,     0,     0,
       0,  1192,     0,     0,     0,     0,     0,     0,  1192,  1192,
    1192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   959,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,     0,     0,    43,     0,  2882,     0,     0,     0,
    1414,     0,     0,  2887,     0,     0,     0,     0,   959,     0,
       0,     0,     0,     0,   959,     0,     0,  1414,     0,  1414,
       0,     0,     0,     0,     0,     0,     0,    44,     0,     0,
       0,     0,     0,  1414,     0,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1578,    46,     0,     0,     0,     0,     0,     0,     0,
       0,  1414,     0,    47,  1579,     0,    48,    49,     0,    50,
       0,  1581,     0,     0,     0,    52,  1582,    53,    54,  1414,
       0,     0,    55,    56,    57,    58,    59,     0,     0,    60,
      61,   927,     0,     0,     0,   928,     0,  1196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1414,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1414,     0,     0,     0,     0,     0,     0,     0,  1414,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   956,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1583,     0,     0,     0,  1584,     0,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
    1192,     0,     0,  1414,     0,  1585,  1586,     0,     0,     0,
       0,     0,  1192,     0,  1192,     0,     0,  1587,  1192,     0,
       0,     0,     0,     0,  1414,  1192,     0,     0,  1192,  1192,
    1192,  1192,  1192,  1192,  1192,  1192,  1192,  1192,     0,     0,
       0,  1588,  1192,  1192,  1589,     0,     0,     0,     0,     0,
       0,  1414,     0,     0,     0,     0,  1192,  1590,     0,  1591,
       0,     0,     0,  1192,  1192,  1192,     0,  1192,     0,     0,
     959,     0,     0,  1414,  1192,     0,   959,     0,     0,  1192,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,   956,  1417,  3058,     0,     0,  1578,     0,     0,     4,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1579,
       0,  1592,  2367,     0,     5,   959,  1581,     0,     0,     0,
       0,  1582,     0,     6,     0,  1417,     0,     0,     0,     0,
    2616,     0,     0,     0,  1192,     7,     8,     0,     0,     0,
       0,     0,     0,    10,    11,     0,     0,     0,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,     0,  1593,     0,     0,     0,  1196,  1414,
       0,     0,     0,     0,  1594,  1595,  1596,     0,  1597,  1598,
    1599,  1600,  1601,  1602,     0,     0,     0,     0,     0,     0,
    1196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      36,     0,     0,     0,     0,     0,     0,     0,  1583,     0,
       0,     0,  1584,     0,  1196,  1196,     0,  1196,  1196,  1196,
       0,     0,     0,     0,     0,     0,  1192,     0,     0,     0,
    1585,  1586,     0,     0,     0,     0,  1196,  1414,     0,     0,
       0,     0,  1587,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1588,    37,     0,  1589,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1192,     0,  1590,    38,  1591,     0,     0,     0,     0,     0,
    1192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      39,  1196,     0,     0,  1196,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    40,     0,     0,
      41,     0,     0,     0,     0,  1414,  1592,     0,     0,  1192,
    1192,  1192,     0,     0,  1192,     0,     0,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   956,     0,
       0,     0,   956,     0,     0,     0,   956,     0,     0,     0,
       0,  1196,     0,  1192,     0,  1417,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1417,     0,     0,     0,  1593,
       0,    43,     0,     0,     0,     0,     0,     0,     0,  1594,
    1595,  1596,     0,  1597,  1598,  1599,  1600,  1601,  1602,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1417,     0,
       0,     0,     0,  1578,    44,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1579,    45,     0,     0,
       0,     0,     0,  1581,     0,  1417,     0,     0,  1582,    46,
       0,     0,     0,     0,     0,     0,     0,     0,   956,     0,
      47,     0,     0,    48,    49,     0,    50,     0,     0,     0,
    1417,     0,    52,     0,    53,    54,     0,     0,     0,    55,
      56,    57,    58,    59,  1192,     0,    60,    61,   927,  1290,
       0,     0,     0,  1192,     0,  1192,     0,     0,     0,     0,
    1414,  1196,     0,  1417,  1192,     0,     0,  1417,     0,     0,
    1578,     0,     0,     0,     0,   956,     0,     0,     0,     0,
     956,     0,     0,  1579,   956,     0,     0,     0,     0,     0,
    1581,  1192,  1192,     0,  2372,  1582,     0,     0,   959,     0,
       0,  1192,     0,     0,     0,  1583,     0,     0,     0,  1584,
       0,     0,     0,     0,     0,     0,     0,  1192,     0,     0,
       0,     0,  1196,  1196,     0,     0,     0,  1585,  1586,     0,
    1196,   956,     0,  1196,  1196,     0,     0,     0,     0,  1587,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1196,  1192,     0,     0,  1196,  1196,  1196,
       0,  1196,     0,  1588,     0,     0,  1589,     0,  1196,  1196,
       0,     0,     0,     0,     0,     0,  1192,     0,     0,  1590,
       0,  1591,     0,     0,     0,  1192,  1417,  1196,     0,   956,
    1196,  1196,  1583,     0,  1414,  1196,  1584,     0,     0,  1196,
       0,     0,  1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,
    1196,     0,  1196,     0,  1585,  1586,  1196,     0,     0,     0,
    1196,     0,     0,     0,     0,     0,  1587,     0,     0,     0,
       0,     0,     0,  1592,     0,     0,     0,     0,     0,   956,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,     0,
    1588,     0,     0,  1589,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,  1590,     0,  1591,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    78,     0,     0,     0,
       0,     0,    82,     0,     0,     0,  1593,     0,     0,     0,
      88,     0,    89,     0,     0,    92,  1594,  1595,  1596,     0,
    1597,  1598,  1599,  1600,  1601,  1602,   102,  1414,     0,     0,
    1592,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   115,   116,     0,     0,     0,
     956,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1196,
       0,     0,   124,     0,     0,     0,     0,     0,  2133,  1175,
       0,   125,   126,   127,   956,     0,     0,  1414,     0,     0,
       0,     0,     0,  1593,     0,   870,     0,     0,     0,     0,
       0,     0,     0,  1594,  1595,  1596,     0,  1597,  1598,  1599,
    1600,  1601,  1602,   136,     0,   137,   138,     0,     0,     0,
     140,   141,     0,     0,     0,     0,     0,   143,   144,     0,
       0,     0,     0,     0,     0,     0,     0,  1417,     0,   146,
       0,   147,  1417,     0,   150,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,  1196,     0,  1417,   152,     0,
       0,     0,     0,   153,     0,     0,     0,     0,   154,     0,
     156,     0,     0,     0,   158,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,   163,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   167,     0,     0,
       0,  1417,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   175,
     176,     0,     0,   177,     0,     0,     0,     0,     0,     0,
     178,     0,  1196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   183,     0,     0,     0,     0,     0,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   193,     0,     0,     0,     0,     0,     0,     0,
    1196,  1196,  1196,   195,     0,  1196,     0,     0,   196,     0,
       0,     0,   197,     0,   199,     0,     0,  1196,  1196,  1196,
    1196,     0,   201,     0,     0,     0,  1196,   202,     0,     0,
     204,     0,     0,     0,     0,     0,   207,  1196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1196,  1196,
       0,  1196,     0,     0,     0,  1196,     0,     0,     0,     0,
    1520,   213,     0,   214,     0,     0,     0,     0,     0,   216,
       0,   217,     0,     0,     0,   218,     0,     0,   959,     0,
    1196,  1196,  1544,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1196,  1565,  1566,     0,  1567,
    1568,  1570,  1196,  1196,  1196,     0,     0,   223,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1606,     0,
       0,     0,     0,     0,     0,     0,  1196,     0,     0,     0,
       0,     0,  1196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1417,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1417,     0,  1417,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1417,     0,     0,
       0,     0,     0,  1672,     0,     0,  1678,  1680,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1417,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1417,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1729,     0,     0,     0,     0,     0,     0,
       0,  1604,     0,     0,  1417,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1417,     0,     0,     0,     0,
       0,     0,     0,  1417,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   959,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1196,     0,
       0,     0,     0,     0,  1196,     0,     0,  1417,     0,     0,
       0,     0,     0,     0,     0,     0,  1196,     0,  1196,     0,
       0,     0,  1196,     0,     0,     0,     0,     0,  1417,  1196,
       0,     0,  1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,
    1196,  1196,     0,     0,     0,     0,  1196,  1196,     0,     0,
       0,     0,     0,     0,     0,  1417,     0,     0,     0,     0,
    1196,     0,     0,  1891,     0,     0,     0,  1196,  1196,  1196,
       0,  1196,     0,     0,     0,     0,     0,  1417,  1196,     0,
       0,     0,     0,  1196,     0,     0,  1196,     0,     0,     0,
       0,     0,     0,     0,     0,   959,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1946,     0,     0,     0,  1948,     0,  1196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1967,     0,     0,     0,  1970,
       0,     0,     0,  1981,     0,     0,     0,     0,     0,     0,
    1988,  1993,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1417,     0,     0,     0,     0,     0,  2004,
       0,     0,     0,  2008,     0,     0,     0,  2019,     0,     0,
       0,  2026,     0,     0,  2028,  2029,  2030,  2031,  2032,  2033,
    2034,  2035,  2036,     0,  2037,     0,     0,     0,  1175,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1417,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1604,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,     0,     0,     0,
    1604,     0,     0,     0,  1196,     0,  1977,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1604,  1604,  1604,  1604,     0,  1604,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1977,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1417,
       0,     0,     0,  1196,  1196,  1196,     0,     0,  1196,     0,
       0,  2121,  1604,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   959,     0,     0,     0,   959,     0,     0,     0,
     959,     0,     0,     0,     0,     0,     0,  1196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1604,     0,
       0,     0,     0,     0,  1604,     0,  1604,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2206,     0,     0,
    1196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   959,     0,     0,  1604,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1196,     0,
       0,     0,     0,     0,     0,     0,     0,  1196,     0,  1196,
       0,     0,     0,     0,  1417,     0,     0,     0,  1196,     0,
       0,     0,     0,     0,  2295,     0,     0,     0,     0,   959,
       0,     0,     0,     0,   959,     0,     0,     0,   959,     0,
       0,     0,     0,  2315,     0,  1196,  1196,     0,     0,     0,
       0,     0,     0,     0,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   959,     0,     0,     0,  1993,
       0,  1993,  1993,     0,     0,     0,     0,     0,  2375,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2392,     0,  2394,     0,     0,     0,  2397,     0,     0,
    1196,     0,     0,     0,     0,     0,     0,  1604,     0,  1196,
       0,     0,     0,   959,     0,     0,     0,     0,  1417,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1672,     0,     0,
       0,     0,     0,  1604,  1680,  1680,  1678,     0,     0,     0,
       0,     0,  1604,   959,  1604,     0,     0,  1196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2469,     0,
       0,     0,     0,  1604,  2472,     0,  1604,  1196,  1977,  1977,
    1977,  2354,     0,  1977,     0,     0,     0,  1604,     0,     0,
       0,     0,     0,     0,  1604,     0,     0,     0,     0,  1604,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1604,     0,     0,  2354,  1604,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1604,  1977,     0,     0,     0,
       0,  1417,  1604,     0,  1604,  1604,  1604,  1604,  1604,  1604,
    1604,  1604,  1604,  1604,     0,     0,     0,     0,     4,     0,
       0,     0,     0,     0,   959,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     7,     8,     0,     0,   959,     0,
       0,  1417,    10,    11,     0,     0,     0,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     0,     0,     0,     0,  1604,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2613,     0,     0,     0,     0,     0,  2617,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2622,     0,
    2623,     0,     0,     0,  2625,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1604,     0,     0,     0,     0,     0,  2642,  2643,
       0,     0,     0,     0,     0,     0,    37,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2658,    38,  2660,     0,     0,     0,     0,     0,     0,
    2664,     0,     0,     0,     0,  2668,     0,     0,  2671,    39,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    40,     0,     0,    41,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1604,     0,     0,     0,     0,    42,     0,     0,     0,
    2711,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1604,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2354,  2354,  2354,     0,  1977,     0,     0,
    1977,  1977,  1977,  1977,  1977,  1977,  1977,  1977,  1977,  1977,
      43,  2354,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1604,     0,     0,     0,     0,  1977,     0,     0,     0,
       0,     0,     0,    44,     0,     0,     0,  2354,  1604,     0,
    1604,     0,     0,  1604,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,    48,    49,     0,    50,     0,     0,     0,     0,
       0,    52,     0,    53,    54,     0,     0,     0,    55,    56,
      57,    58,    59,     0,     0,    60,    61,   927,  1719,     0,
       0,     0,     0,     0,     0,     0,  2295,     0,     0,     0,
       0,     0,     0,     0,     0,  1604,  2822,     0,  1604,     0,
       0,     0,     0,     0,     4,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       7,     8,     0,     0,     0,     0,  2838,  2839,    10,    11,
    2841,     0,     0,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,  1977,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1604,
       0,     0,  2911,  1604,     0,     0,     0,     0,  1604,  1604,
       0,  1604,     0,     0,  2354,     0,     0,     0,  2354,  2354,
    2354,  2354,  2354,  2354,  2354,  2354,  2354,  2354,  1604,  1604,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,  2354,  1604,     0,  1604,     0,     0,     0,
    1604,  1977,     0,     0,  1604,     0,     0,  1604,    38,     0,
    2295,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,     0,
    2956,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1604,     0,     0,
       0,     0,    40,     0,     0,    41,     0,     0,  2973,     0,
       0,     0,     0,     0,     0,     0,     0,  2977,     0,     0,
       0,     0,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2981,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2354,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3013,     0,     0,     0,     0,     0,    43,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3032,     0,     0,     0,     0,     0,     0,  1604,    44,
       0,     0,     0,     0,     0,  1977,     0,  1977,     0,     0,
       0,     0,    45,  2354,  1604,  1604,     0,  1604,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,    48,    49,
       0,    50,     0,     0,     0,     0,     0,    52,     0,    53,
      54,     0,     0,     0,    55,    56,    57,    58,    59,     0,
       0,    60,    61,   927,     0,     0,     0,     0,     0,  2977,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1604,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2354,  1977,  2354,
       0,     0,  1604,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1604,
       0,     0,     0,  1604,     0,     0,     0,  1604,   579,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,     0,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   580,    99,   100,   101,   356,   581,   103,  1604,
     104,   105,   106,   107,   582,   583,     0,   109,   110,   111,
       0,   112,   584,   585,  2354,   357,   358,     0,  1604,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,   586,
     373,   374,   587,   588,   589,   590,   591,   592,   593,   375,
     376,   377,   129,   378,   379,   380,   131,   132,   133,   134,
       0,   594,   381,   382,     0,   383,   595,   596,   384,   597,
     135,   386,   598,   387,   388,   389,   390,   139,   599,   600,
     391,   392,   393,   601,   394,   395,   142,   396,   602,   397,
     398,   145,   399,   603,   604,   605,   606,   400,   401,   402,
     403,   404,   148,   149,   405,   607,   406,   608,   407,     0,
     408,   409,   410,   609,   610,   611,   411,   412,   413,   414,
     612,   415,   416,   613,   417,   614,   418,   419,   420,   155,
     421,     0,   157,   615,   422,   423,   159,   616,   424,   617,
     425,   160,   618,   161,   426,     0,   427,   619,   620,   428,
     621,   429,   430,   164,   431,   432,   433,   622,   434,   435,
     436,   437,   623,   165,   166,   624,   438,   439,   440,   625,
     168,   626,   169,   627,     0,   170,   171,   441,   172,   442,
     443,   444,   445,   446,   628,   173,   447,   174,   629,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   179,   180,   181,   630,   461,   462,   463,   464,
     182,   631,   465,   466,   184,   632,   633,   185,   186,   467,
     468,   634,   635,   469,   636,   637,   638,   470,   471,   639,
     640,   187,   188,   189,   190,   472,   473,   474,     0,   191,
     192,   475,   476,   641,   477,   478,   479,   480,   481,   482,
     194,   483,   642,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   198,   494,   200,   495,   496,   497,   498,
     499,     0,   643,   500,   501,   502,   644,   503,   203,   504,
     505,   205,   506,   206,   645,   507,   508,   509,   510,   511,
     512,   513,   514,   208,   515,   646,   516,   517,   518,   519,
     647,   209,   210,   648,   521,   649,   522,   211,   523,   212,
     650,   524,   525,   526,   527,   528,   651,   652,   529,   530,
     531,   532,   533,   653,   654,   534,   535,   536,   219,   537,
     220,   538,     0,   655,   656,   539,   540,   541,   542,   543,
     544,     0,   221,     0,     0,   222,     0,     0,    79,    80,
      81,     0,     0,    83,    84,     0,    85,    86,    87,     0,
       0,     0,    90,    91,     0,    93,    94,    95,    96,    97,
      98,   657,    99,   100,   101,     0,     0,   103,     0,   104,
     105,   106,   107,     0,   108,     0,   109,   110,   111,     0,
     112,   113,   114,     0,     0,     0,     0,     0,     0,   117,
     118,     0,     0,     0,     0,   119,     0,     0,     0,     0,
       0,     0,     0,     0,   120,     0,   121,     0,   122,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   129,     0,     0,     0,   131,   132,   133,   134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,     0,     0,     0,     0,     0,   139,     0,     0,     0,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   148,   149,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,     0,
       0,   157,     0,     0,     0,   159,     0,     0,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   164,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   165,   166,     0,     0,     0,     0,     0,   168,
       0,   169,     0,     0,   170,   171,     0,   172,     0,     0,
       0,     0,     0,     0,   173,     0,   174,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,     0,     0,   182,
       0,     0,     0,   184,     0,     0,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     187,   188,   189,   190,     0,     0,     0,     0,   191,   192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   198,     0,   200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,     0,     0,
     205,     0,   206,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   208,     0,     0,     0,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,     0,     0,     0,   215,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,    79,    80,
      81,     0,     0,    83,    84,     0,    85,    86,    87,     0,
       0,     0,    90,    91,     0,    93,    94,    95,    96,    97,
      98,  2090,    99,   100,   101,     0,     0,   103,     0,   104,
     105,   106,   107,     0,   108,     0,   109,   110,   111,     0,
     112,   113,   114,     0,     0,     0,     0,     0,     0,   117,
     118,     0,     0,     0,     0,   119,     0,     0,     0,     0,
       0,     0,     0,     0,   120,     0,   121,     0,   122,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   129,     0,     0,     0,   131,   132,   133,   134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,     0,     0,     0,     0,     0,   139,     0,     0,     0,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   148,   149,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,     0,
       0,   157,     0,     0,     0,   159,     0,     0,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   164,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   165,   166,     0,     0,     0,     0,     0,   168,
       0,   169,     0,     0,   170,   171,     0,   172,     0,     0,
       0,     0,     0,     0,   173,     0,   174,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,     0,     0,   182,
       0,     0,     0,   184,     0,     0,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     187,   188,   189,   190,     0,     0,     0,     0,   191,   192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   198,     0,   200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,     0,     0,
     205,     0,   206,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   208,     0,     0,     0,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,     0,     0,     0,   215,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   221,     0,     0,   222,    78,     0,     0,    79,    80,
      81,    82,     0,    83,    84,     0,    85,    86,    87,    88,
       0,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,  2092,    99,   100,   101,   102,     0,   103,     0,   104,
     105,   106,   107,     0,   108,     0,   109,   110,   111,     0,
     112,   113,   114,     0,   115,   116,     0,     0,     0,   117,
     118,     0,     0,     0,     0,   119,     0,     0,     0,     0,
       0,     0,     0,     0,   120,     0,   121,     0,   122,   123,
       0,   124,     0,     0,     0,     0,     0,     0,     0,     0,
     125,   126,   127,     0,     0,     0,     0,     0,     0,     0,
     128,   129,     0,     0,   130,   131,   132,   133,   134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,     0,   136,     0,   137,   138,   139,     0,     0,   140,
     141,     0,     0,     0,     0,   142,   143,   144,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,   146,     0,
     147,   148,   149,   150,     0,     0,     0,     0,     0,   151,
       0,     0,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,   153,     0,     0,     0,     0,   154,   155,   156,
       0,   157,     0,   158,     0,   159,     0,     0,     0,     0,
     160,     0,   161,     0,   162,     0,   163,     0,     0,     0,
       0,     0,   164,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   165,   166,     0,     0,   167,     0,     0,   168,
       0,   169,     0,     0,   170,   171,     0,   172,     0,     0,
       0,     0,     0,     0,   173,     0,   174,     0,   175,   176,
       0,     0,   177,     0,     0,     0,     0,     0,     0,   178,
       0,   179,   180,   181,     0,     0,     0,     0,     0,   182,
       0,     0,   183,   184,     0,     0,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     187,   188,   189,   190,     0,     0,     0,     0,   191,   192,
       0,   193,     0,     0,     0,     0,     0,     0,     0,   194,
       0,     0,   195,     0,     0,     0,     0,   196,     0,     0,
       0,   197,   198,   199,   200,     0,     0,     0,     0,     0,
       0,   201,     0,     0,     0,     0,   202,   203,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,     0,
       0,     0,   208,     0,     0,     0,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
     213,     0,   214,     0,     0,   215,     0,     0,   216,     0,
     217,     0,     0,     0,   218,     0,     0,   219,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,   579,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,   223,    93,    94,    95,
      96,    97,    98,   580,    99,   100,   101,   356,   581,   103,
       0,   104,   105,   106,   107,   582,   583,     0,   109,   110,
     111,     0,   112,   584,   585,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
    2052,   373,   374,     0,     0,     0,     0,  1106,     0,     0,
     375,   376,   377,   129,   378,   379,   380,   131,  1107,   133,
    1108,  1109,     0,   381,   382,     0,   383,  1110,  1111,   384,
    1112,  1113,   386,     0,   387,   388,   389,   390,  1114,     0,
       0,   391,   392,   393,     0,   394,   395,  1115,   396,     0,
     397,   398,   145,   399,  1116,  1117,  1118,  1119,   400,   401,
     402,   403,   404,  1120,  1121,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,  2053,     0,   411,  1122,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
    1123,   421,     0,  1124,  1125,   422,   423,  1126,     0,   424,
       0,   425,   160,     0,   161,   426,     0,   427,     0,     0,
     428,     0,   429,   430,   164,   431,   432,   433,     0,   434,
     435,   436,   437,     0,   165,   166,     0,   438,   439,   440,
    1127,  1128,     0,  1129,     0,     0,   170,   171,   441,   172,
     442,   443,   444,   445,   446,     0,   173,   447,   174,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,  1130,   180,  1131,   704,   461,   462,   463,
     464,   182,  1132,   465,   466,   184,     0,  1133,  1134,  1135,
     467,   468,     0,     0,   469,   705,     0,     0,  1136,   471,
       0,     0,   187,   188,   189,  1137,   472,   473,   474,     0,
    1138,   192,   475,   476,     0,   477,   478,   479,   480,   481,
     482,  1139,   483,     0,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   198,   494,  1140,   495,   496,   497,
     498,   499,     0,     0,   500,   501,   502,  1141,   503,   203,
     504,   505,   205,   506,  1142,     0,   507,   508,   509,   510,
     511,   512,   513,   514,  1143,   515,     0,   516,   517,   518,
     519,     0,  1144,  1145,     0,   521,     0,   522,  1146,   523,
    1147,  1148,   524,   525,   526,   527,   528,     0,  1149,   529,
     530,   531,   532,   533,  1150,     0,   534,   535,   536,  1151,
     537,   220,   538,     0,     0,     0,   539,   540,   541,   542,
     543,   544,     0,   221,    49,  1152,   222,   545,     0,     0,
    1153,  1154,    52,  1155,    53,     0,     0,     0,     0,  1156,
    1157,  2054,     0,  1159,  1160,     0,     0,     0,  1161,  2055,
     579,    79,    80,    81,   353,     0,    83,    84,     0,    85,
      86,    87,   354,     0,   355,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   580,    99,   100,   101,   356,   581,
     103,     0,   104,   105,   106,   107,   582,   583,     0,   109,
     110,   111,     0,   112,   584,   585,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,  1106,     0,
       0,   375,   376,   377,   129,   378,   379,   380,   131,  1107,
     133,  1108,  1109,     0,   381,   382,     0,   383,  1110,  1111,
     384,  1112,  1113,   386,     0,   387,   388,   389,   390,  1114,
       0,     0,   391,   392,   393,     0,   394,   395,  1115,   396,
       0,   397,   398,   145,   399,  1116,  1117,  1118,  1119,   400,
     401,   402,   403,   404,  1120,  1121,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,  1122,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,  1123,   421,     0,  1124,  1125,   422,   423,  1126,     0,
     424,     0,   425,   160,     0,   161,   426,     0,   427,     0,
       0,   428,     0,   429,   430,   164,   431,   432,   433,     0,
     434,   435,   436,   437,     0,   165,   166,     0,   438,   439,
     440,  1127,  1128,     0,  1129,     0,     0,   170,   171,   441,
     172,   442,   443,   444,   445,   446,     0,   173,   447,   174,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,  1130,   180,  1131,   704,   461,   462,
     463,   464,   182,  1132,   465,   466,   184,     0,  1133,  1134,
    1135,   467,   468,     0,     0,   469,   705,     0,     0,  1136,
     471,     0,     0,   187,   188,   189,  1137,   472,   473,   474,
       0,  1138,   192,   475,   476,     0,   477,   478,   479,   480,
     481,   482,  1139,   483,     0,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   198,   494,  1140,   495,   496,
     497,   498,   499,     0,     0,   500,   501,   502,  1141,   503,
     203,   504,   505,   205,   506,  1142,     0,   507,   508,   509,
     510,   511,   512,   513,   514,  1143,   515,     0,   516,   517,
     518,   519,     0,  1144,  1145,     0,   521,     0,   522,  1146,
     523,  1147,  1148,   524,   525,   526,   527,   528,     0,  1149,
     529,   530,   531,   532,   533,  1150,     0,   534,   535,   536,
    1151,   537,   220,   538,     0,     0,     0,   539,   540,   541,
     542,   543,   544,     0,   221,    49,  1152,   222,   545,     0,
       0,  1153,  1154,    52,  1155,    53,     0,     0,     0,     0,
    1156,  1157,     0,     0,  1159,  1160,     0,     0,     0,  1161,
    1979,   579,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   580,    99,   100,   101,   356,
     581,   103,     0,   104,   105,   106,   107,   582,   583,     0,
     109,   110,   111,     0,   112,   584,   585,     0,   357,   358,
       0,     0,     0,   359,   360,     0,     0,     0,     0,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     363,     0,   364,   365,     0,   366,   367,   368,   369,   370,
     371,   372,     0,   373,   374,     0,     0,     0,     0,  1106,
       0,     0,   375,   376,   377,   129,   378,   379,   380,   131,
    1107,   133,  1108,  1109,     0,   381,   382,     0,   383,  1110,
    1111,   384,  1112,  1113,   386,     0,   387,   388,   389,   390,
    1114,     0,     0,   391,   392,   393,     0,   394,   395,  1115,
     396,     0,   397,   398,   145,   399,  1116,  1117,  1118,  1119,
     400,   401,   402,   403,   404,  1120,  1121,   405,     0,   406,
       0,   407,     0,   408,   409,   410,     0,     0,     0,   411,
    1122,   413,   414,     0,   415,   416,     0,   417,     0,   418,
     419,   420,  1123,   421,     0,  1124,  1125,   422,   423,  1126,
       0,   424,     0,   425,   160,     0,   161,   426,     0,   427,
       0,     0,   428,     0,   429,   430,   164,   431,   432,   433,
       0,   434,   435,   436,   437,     0,   165,   166,     0,   438,
     439,   440,  1127,  1128,     0,  1129,     0,     0,   170,   171,
     441,   172,   442,   443,   444,   445,   446,     0,   173,   447,
     174,     0,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,  1130,   180,  1131,   704,   461,
     462,   463,   464,   182,  1132,   465,   466,   184,     0,  1133,
    1134,  1135,   467,   468,     0,     0,   469,   705,     0,     0,
    1136,   471,     0,     0,   187,   188,   189,  1137,   472,   473,
     474,     0,  1138,   192,   475,   476,     0,   477,   478,   479,
     480,   481,   482,  1139,   483,     0,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   198,   494,  1140,   495,
     496,   497,   498,   499,     0,     0,   500,   501,   502,  1141,
     503,   203,   504,   505,   205,   506,  1142,     0,   507,   508,
     509,   510,   511,   512,   513,   514,  1143,   515,     0,   516,
     517,   518,   519,     0,  1144,  1145,     0,   521,     0,   522,
    1146,   523,  1147,  1148,   524,   525,   526,   527,   528,     0,
    1149,   529,   530,   531,   532,   533,  1150,     0,   534,   535,
     536,  1151,   537,   220,   538,     0,     0,     0,   539,   540,
     541,   542,   543,   544,     0,   221,    49,  1152,   222,   545,
       0,     0,  1153,  1154,    52,  1155,    53,     0,     0,     0,
       0,  1156,  1157,     0,     0,  1159,  1160,     0,     0,     0,
    1161,  2865,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
    1106,     0,     0,   375,   376,   377,   129,   378,   379,   380,
     131,  1107,   133,  1108,  1109,  1989,   381,   382,     0,   383,
    1110,  1111,   384,  1112,  1113,   386,     0,   387,   388,   389,
     390,  1114,     0,     0,   391,   392,   393,     0,   394,   395,
    1115,   396,     0,   397,   398,   145,   399,  1116,  1117,  1118,
    1119,   400,   401,   402,   403,   404,  1120,  1121,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,  1123,   421,     0,  1124,  1125,   422,   423,
    1126,     0,   424,     0,   425,   160,  1990,   161,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   164,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   165,   166,     0,
     438,   439,   440,  1127,  1128,     0,  1129,     0,     0,   170,
     171,   441,   172,   442,   443,   444,   445,   446,  1991,   173,
     447,   174,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1130,   180,  1131,   704,
     461,   462,   463,   464,   182,  1132,   465,   466,   184,     0,
    1133,  1134,  1135,   467,   468,     0,     0,   469,   705,     0,
       0,  1136,   471,     0,     0,   187,   188,   189,  1137,   472,
     473,   474,     0,  1138,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1139,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   198,   494,  1140,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
    1141,   503,   203,   504,   505,   205,   506,  1142,     0,   507,
     508,   509,   510,   511,   512,   513,   514,  1143,   515,     0,
     516,   517,   518,   519,     0,  1144,  1145,     0,   521,  1992,
     522,  1146,   523,  1147,  1148,   524,   525,   526,   527,   528,
       0,  1149,   529,   530,   531,   532,   533,  1150,     0,   534,
     535,   536,  1151,   537,   220,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,    49,  1152,   222,
     545,     0,     0,  1153,  1154,    52,  1155,    53,     0,     0,
       0,     0,  1156,  1157,     0,     0,  1159,  1160,     0,     0,
       0,  1161,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
    1106,     0,     0,   375,   376,   377,   129,   378,   379,   380,
     131,  1107,   133,  1108,  1109,     0,   381,   382,     0,   383,
    1110,  1111,   384,  1112,  1113,   386,     0,   387,   388,   389,
     390,  1114,     0,     0,   391,   392,   393,     0,   394,   395,
    1115,   396,     0,   397,   398,   145,   399,  1116,  1117,  1118,
    1119,   400,   401,   402,   403,   404,  1120,  1121,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,  1123,   421,     0,  1124,  1125,   422,   423,
    1126,     0,   424,     0,   425,   160,     0,   161,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   164,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   165,   166,     0,
     438,   439,   440,  1127,  1128,     0,  1129,     0,     0,   170,
     171,   441,   172,   442,   443,   444,   445,   446,     0,   173,
     447,   174,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1130,   180,  1131,   704,
     461,   462,   463,   464,   182,  1132,   465,   466,   184,     0,
    1133,  1134,  1135,   467,   468,     0,     0,   469,   705,     0,
       0,  1136,   471,     0,     0,   187,   188,   189,  1137,   472,
     473,   474,     0,  1138,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1139,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   198,   494,  1140,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
    1141,   503,   203,   504,   505,   205,   506,  1142,     0,   507,
     508,   509,   510,   511,   512,   513,   514,  1143,   515,     0,
     516,   517,   518,   519,     0,  1144,  1145,     0,   521,     0,
     522,  1146,   523,  1147,  1148,   524,   525,   526,   527,   528,
       0,  1149,   529,   530,   531,   532,   533,  1150,     0,   534,
     535,   536,  1151,   537,   220,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,    49,  1152,   222,
     545,     0,     0,  1153,  1154,    52,  1155,    53,     0,     0,
       0,     0,  1156,  1157,  1158,     0,  1159,  1160,     0,     0,
       0,  1161,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
    1106,     0,     0,   375,   376,   377,   129,   378,   379,   380,
     131,  1107,   133,  1108,  1109,     0,   381,   382,     0,   383,
    1110,  1111,   384,  1112,  1113,   386,     0,   387,   388,   389,
     390,  1114,     0,     0,   391,   392,   393,     0,   394,   395,
    1115,   396,     0,   397,   398,   145,   399,  1116,  1117,  1118,
    1119,   400,   401,   402,   403,   404,  1120,  1121,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,  1123,   421,     0,  1124,  1125,   422,   423,
    1126,     0,   424,     0,   425,   160,     0,   161,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   164,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   165,   166,     0,
     438,   439,   440,  1127,  1128,     0,  1129,     0,     0,   170,
     171,   441,   172,   442,   443,   444,   445,   446,     0,   173,
     447,   174,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1130,   180,  1131,   704,
     461,   462,   463,   464,   182,  1132,   465,   466,   184,     0,
    1133,  1134,  1135,   467,   468,     0,     0,   469,   705,     0,
       0,  1136,   471,     0,     0,   187,   188,   189,  1137,   472,
     473,   474,     0,  1138,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1139,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   198,   494,  1140,
     495,   496,   497,   498,   499,     0,   201,   500,   501,   502,
    1141,   503,   203,   504,   505,   205,   506,  1142,     0,   507,
     508,   509,   510,   511,   512,   513,   514,  1143,   515,     0,
     516,   517,   518,   519,     0,  1144,  1145,     0,   521,     0,
     522,  1146,   523,  1147,  1148,   524,   525,   526,   527,   528,
       0,  1149,   529,   530,   531,   532,   533,  1150,     0,   534,
     535,   536,  1151,   537,   220,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,    49,  1152,   222,
     545,     0,     0,  1153,  1154,    52,  1155,    53,     0,     0,
       0,     0,  1156,  1157,     0,     0,  1159,  1160,     0,     0,
       0,  1161,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,  1676,   373,   374,     0,     0,     0,     0,
    1106,     0,     0,   375,   376,   377,   129,   378,   379,   380,
     131,  1107,   133,  1108,  1109,     0,   381,   382,     0,   383,
    1110,  1111,   384,  1112,  1113,   386,     0,   387,   388,   389,
     390,  1114,     0,     0,   391,   392,   393,     0,   394,   395,
    1115,   396,     0,   397,   398,   145,   399,  1116,  1117,  1118,
    1119,   400,   401,   402,   403,   404,  1120,  1121,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,  1123,   421,     0,  1124,  1125,   422,   423,
    1126,     0,   424,     0,   425,   160,     0,   161,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   164,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   165,   166,     0,
     438,   439,   440,  1127,  1128,     0,  1129,     0,     0,   170,
     171,   441,   172,   442,   443,   444,   445,   446,     0,   173,
     447,   174,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1130,   180,  1131,   704,
     461,   462,   463,   464,   182,  1132,   465,   466,   184,     0,
    1133,  1134,  1135,   467,   468,     0,     0,   469,   705,     0,
       0,  1136,   471,     0,     0,   187,   188,   189,  1137,   472,
     473,   474,     0,  1138,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1139,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   198,   494,  1140,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
    1141,   503,   203,   504,   505,   205,   506,  1142,     0,   507,
     508,   509,   510,   511,   512,   513,   514,  1143,   515,     0,
     516,   517,   518,   519,     0,  1144,  1145,     0,   521,     0,
     522,  1146,   523,  1147,  1148,   524,   525,   526,   527,   528,
       0,  1149,   529,   530,   531,   532,   533,  1150,     0,   534,
     535,   536,  1151,   537,   220,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,    49,  1152,   222,
     545,     0,     0,  1153,  1154,    52,  1155,    53,     0,     0,
       0,     0,  1156,  1157,     0,     0,  1159,  1160,     0,     0,
       0,  1161,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
    1106,     0,     0,   375,   376,   377,   129,   378,   379,   380,
     131,  1107,   133,  1108,  1109,     0,   381,   382,     0,   383,
    1110,  1111,   384,  1112,  1113,   386,     0,   387,   388,   389,
     390,  1114,     0,     0,   391,   392,   393,     0,   394,   395,
    1115,   396,     0,   397,   398,   145,   399,  1116,  1117,  1118,
    1119,   400,   401,   402,   403,   404,  1120,  1121,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,  1123,   421,     0,  1124,  1125,   422,   423,
    1126,     0,   424,     0,   425,   160,     0,   161,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   164,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   165,   166,     0,
     438,   439,   440,  1127,  1128,     0,  1129,     0,     0,   170,
     171,   441,   172,   442,   443,   444,   445,   446,     0,   173,
     447,   174,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1130,   180,  1131,   704,
     461,   462,   463,   464,   182,  1132,   465,   466,   184,     0,
    1133,  1134,  1135,   467,   468,     0,     0,   469,   705,     0,
       0,  1136,   471,     0,     0,   187,   188,   189,  1137,   472,
     473,   474,     0,  1138,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1139,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   198,   494,  1140,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
    1141,   503,   203,   504,   505,   205,   506,  1142,     0,   507,
     508,   509,   510,   511,   512,   513,   514,  1143,   515,     0,
     516,   517,   518,   519,     0,  1144,  1145,     0,   521,     0,
     522,  1146,   523,  1147,  1148,   524,   525,   526,   527,   528,
       0,  1149,   529,   530,   531,   532,   533,  1150,     0,   534,
     535,   536,  1151,   537,   220,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,    49,  1152,   222,
     545,     0,     0,  1153,  1154,    52,  1155,    53,     0,     0,
       0,     0,  1156,  1157,     0,     0,  1159,  1160,     0,  1515,
       0,  1161,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
    1106,     0,     0,   375,   376,   377,   129,   378,   379,   380,
     131,  1107,   133,  1108,  1109,     0,   381,   382,     0,   383,
    1110,  1111,   384,  1112,  1113,   386,     0,   387,   388,   389,
     390,  1114,     0,     0,   391,   392,   393,     0,   394,   395,
    1115,   396,     0,   397,   398,   145,   399,  1116,  1117,  1118,
    1119,   400,   401,   402,   403,   404,  1120,  1121,   405,  2294,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,  1123,   421,     0,  1124,  1125,   422,   423,
    1126,     0,   424,     0,   425,   160,     0,   161,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   164,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   165,   166,     0,
     438,   439,   440,  1127,  1128,     0,  1129,     0,     0,   170,
     171,   441,   172,   442,   443,   444,   445,   446,     0,   173,
     447,   174,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1130,   180,  1131,   704,
     461,   462,   463,   464,   182,  1132,   465,   466,   184,     0,
    1133,  1134,  1135,   467,   468,     0,     0,   469,   705,     0,
       0,  1136,   471,     0,     0,   187,   188,   189,  1137,   472,
     473,   474,     0,  1138,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1139,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   198,   494,  1140,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
    1141,   503,   203,   504,   505,   205,   506,  1142,     0,   507,
     508,   509,   510,   511,   512,   513,   514,  1143,   515,     0,
     516,   517,   518,   519,     0,  1144,  1145,     0,   521,     0,
     522,  1146,   523,  1147,  1148,   524,   525,   526,   527,   528,
       0,  1149,   529,   530,   531,   532,   533,  1150,     0,   534,
     535,   536,  1151,   537,   220,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,    49,  1152,   222,
     545,     0,     0,  1153,  1154,    52,  1155,    53,     0,     0,
       0,     0,  1156,  1157,     0,     0,  1159,  1160,     0,     0,
       0,  1161,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
    1106,     0,     0,   375,   376,   377,   129,   378,   379,   380,
     131,  1107,   133,  1108,  1109,     0,   381,   382,     0,   383,
    1110,  1111,   384,  1112,  1113,   386,     0,   387,   388,   389,
     390,  1114,     0,     0,   391,   392,   393,     0,   394,   395,
    1115,   396,     0,   397,   398,   145,   399,  1116,  1117,  1118,
    1119,   400,   401,   402,   403,   404,  1120,  1121,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,  1123,   421,     0,  1124,  1125,   422,   423,
    1126,     0,   424,     0,   425,   160,  1990,   161,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   164,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   165,   166,     0,
     438,   439,   440,  1127,  1128,     0,  1129,     0,     0,   170,
     171,   441,   172,   442,   443,   444,   445,   446,     0,   173,
     447,   174,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1130,   180,  1131,   704,
     461,   462,   463,   464,   182,  1132,   465,   466,   184,     0,
    1133,  1134,  1135,   467,   468,     0,     0,   469,   705,     0,
       0,  1136,   471,     0,     0,   187,   188,   189,  1137,   472,
     473,   474,     0,  1138,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1139,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   198,   494,  1140,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
    1141,   503,   203,   504,   505,   205,   506,  1142,     0,   507,
     508,   509,   510,   511,   512,   513,   514,  1143,   515,     0,
     516,   517,   518,   519,     0,  1144,  1145,     0,   521,     0,
     522,  1146,   523,  1147,  1148,   524,   525,   526,   527,   528,
       0,  1149,   529,   530,   531,   532,   533,  1150,     0,   534,
     535,   536,  1151,   537,   220,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,    49,  1152,   222,
     545,     0,     0,  1153,  1154,    52,  1155,    53,     0,     0,
       0,     0,  1156,  1157,     0,     0,  1159,  1160,     0,     0,
       0,  1161,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
    1106,     0,     0,   375,   376,   377,   129,   378,   379,   380,
     131,  1107,   133,  1108,  1109,     0,   381,   382,     0,   383,
    1110,  1111,   384,  1112,  1113,   386,     0,   387,   388,   389,
     390,  1114,     0,     0,   391,   392,   393,     0,   394,   395,
    1115,   396,     0,   397,   398,   145,   399,  1116,  1117,  1118,
    1119,   400,   401,   402,   403,   404,  1120,  1121,   405,  2710,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,  1123,   421,     0,  1124,  1125,   422,   423,
    1126,     0,   424,     0,   425,   160,     0,   161,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   164,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   165,   166,     0,
     438,   439,   440,  1127,  1128,     0,  1129,     0,     0,   170,
     171,   441,   172,   442,   443,   444,   445,   446,     0,   173,
     447,   174,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1130,   180,  1131,   704,
     461,   462,   463,   464,   182,  1132,   465,   466,   184,     0,
    1133,  1134,  1135,   467,   468,     0,     0,   469,   705,     0,
       0,  1136,   471,     0,     0,   187,   188,   189,  1137,   472,
     473,   474,     0,  1138,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1139,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   198,   494,  1140,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
    1141,   503,   203,   504,   505,   205,   506,  1142,     0,   507,
     508,   509,   510,   511,   512,   513,   514,  1143,   515,     0,
     516,   517,   518,   519,     0,  1144,  1145,     0,   521,     0,
     522,  1146,   523,  1147,  1148,   524,   525,   526,   527,   528,
       0,  1149,   529,   530,   531,   532,   533,  1150,     0,   534,
     535,   536,  1151,   537,   220,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,    49,  1152,   222,
     545,     0,     0,  1153,  1154,    52,  1155,    53,     0,     0,
       0,     0,  1156,  1157,     0,     0,  1159,  1160,     0,     0,
       0,  1161,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
    1106,     0,     0,   375,   376,   377,   129,   378,   379,   380,
     131,  1107,   133,  1108,  1109,     0,   381,   382,     0,   383,
    1110,  1111,   384,  1112,  1113,   386,     0,   387,   388,   389,
     390,  1114,     0,     0,   391,   392,   393,     0,   394,   395,
    1115,   396,     0,   397,   398,   145,   399,  1116,  1117,  1118,
    1119,   400,   401,   402,   403,   404,  1120,  1121,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,  1123,   421,     0,  1124,  1125,   422,   423,
    1126,     0,   424,     0,   425,   160,     0,   161,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   164,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   165,   166,     0,
     438,   439,   440,  1127,  1128,     0,  1129,     0,     0,   170,
     171,   441,   172,   442,   443,   444,   445,   446,     0,   173,
     447,   174,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1130,   180,  1131,   704,
     461,   462,   463,   464,   182,  1132,   465,   466,   184,     0,
    1133,  1134,  1135,   467,   468,     0,     0,   469,   705,     0,
       0,  1136,   471,     0,     0,   187,   188,   189,  1137,   472,
     473,   474,     0,  1138,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1139,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   198,   494,  1140,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
    1141,   503,   203,   504,   505,   205,   506,  1142,     0,   507,
     508,   509,   510,   511,   512,   513,   514,  1143,   515,     0,
     516,   517,   518,   519,     0,  1144,  1145,     0,   521,     0,
     522,  1146,   523,  1147,  1148,   524,   525,   526,   527,   528,
       0,  1149,   529,   530,   531,   532,   533,  1150,     0,   534,
     535,   536,  1151,   537,   220,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,    49,  1152,   222,
     545,     0,     0,  1153,  1154,    52,  1155,    53,     0,     0,
       0,     0,  1156,  1157,     0,     0,  1159,  1160,     0,     0,
       0,  1161,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
    1106,     0,     0,   375,   376,   377,   129,   378,   379,   380,
     131,  1107,   133,  1108,  1109,     0,   381,   382,     0,   383,
    1110,  1111,   384,  1112,  1113,   386,     0,   387,   388,   389,
     390,  1114,     0,     0,   391,   392,   393,     0,   394,   395,
    1115,   396,     0,   397,   398,   145,   399,  1116,  1117,  1118,
    1119,   400,   401,   402,   403,   404,  1120,  1121,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,  1123,   421,     0,  1124,  1125,   422,   423,
    1126,     0,   424,     0,   425,   160,     0,   161,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   164,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   165,   166,     0,
     438,   439,   440,  1127,  1128,     0,  1129,     0,     0,   170,
     171,   441,   172,   442,   443,   444,   445,   446,     0,   173,
     447,   174,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1130,   180,  1131,   704,
     461,   462,   463,   464,   182,     0,   465,   466,   184,     0,
    1133,  1134,  1135,   467,   468,     0,     0,   469,   705,     0,
       0,  1136,   471,     0,     0,   187,   188,   189,  1137,   472,
     473,   474,     0,  1138,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1139,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   198,   494,  1140,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
    1141,   503,   203,   504,   505,   205,   506,  1142,     0,   507,
     508,   509,   510,   511,   512,   513,   514,  1143,   515,     0,
     516,   517,   518,   519,     0,  1144,  1145,     0,   521,     0,
     522,  1146,   523,  1147,  1148,   524,   525,   526,   527,   528,
       0,     0,   529,   530,   531,   532,   533,  1150,     0,   534,
     535,   536,  1151,   537,   220,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,    49,  1152,   222,
     545,     0,     0,  1153,  1154,    52,  1155,    53,     0,     0,
       0,     0,     0,  1972,     0,     0,  1973,  1974,     0,     0,
       0,  1161,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
    1106,     0,     0,   375,   376,   377,   129,   378,   379,   380,
       0,  1107,   133,  1108,  1109,     0,   381,   382,     0,   383,
    1110,  1111,   384,  1112,  1113,   386,     0,   387,   388,   389,
     390,  1114,     0,     0,   391,   392,   393,     0,   394,   395,
    1115,   396,     0,   397,   398,   145,   399,  1116,  1117,  1118,
    1119,   400,   401,   402,   403,   404,  1120,  1121,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,     0,     0,
     418,   419,   420,  1123,   421,     0,  1124,  1125,   422,   423,
    1126,     0,   424,     0,   425,   160,     0,   161,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   165,   166,     0,
     438,   439,   440,  1127,  1128,     0,  1129,     0,     0,   170,
     171,   441,   172,   442,   443,   444,   445,   446,     0,   173,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1130,   180,  1131,   704,
     461,   462,   463,   464,   182,     0,   465,   466,   184,     0,
    1133,  1134,  1135,   467,   468,     0,     0,   469,   705,     0,
       0,  1136,   471,     0,     0,   187,   188,   189,  1137,   472,
     473,   474,     0,  1138,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1139,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   198,   494,  1140,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
    1141,   503,   203,   504,   505,     0,   506,  1142,     0,   507,
     508,   509,   510,   511,   512,   513,   514,  1143,   515,     0,
     516,   517,   518,   519,     0,  1144,  1145,     0,   521,     0,
     522,  1146,   523,  1147,  1148,   524,   525,   526,   527,   528,
       0,  1149,   529,   530,   531,   532,   533,  1150,     0,   534,
     535,   536,  1151,   537,   220,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,    49,  1152,   222,
     545,     0,     0,  1153,  1154,    52,  1155,    53,     0,     0,
       0,     0,  1156,  1157,     0,     0,  1159,  1160,     0,     0,
       0,  1161,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
    1106,     0,     0,   375,   376,   377,   129,   378,   379,   380,
     131,  1107,   133,  1108,  1109,     0,   381,   382,     0,   383,
    1110,  1111,   384,  1112,  1113,   386,     0,   387,   388,   389,
     390,  1114,     0,     0,   391,   392,   393,     0,   394,   395,
    1115,   396,     0,   397,   398,   145,   399,  1116,  1117,  1118,
    1119,   400,   401,   402,   403,   404,  1120,  1121,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,  1123,   421,     0,  1124,  1125,   422,   423,
    1126,     0,   424,     0,   425,   160,     0,   161,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   164,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   165,   166,     0,
     438,   439,   440,  1127,  1128,     0,  1129,     0,     0,   170,
     171,   441,   172,   442,   443,   444,   445,   446,     0,   173,
     447,   174,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1130,   180,  1131,   704,
     461,   462,   463,   464,   182,     0,   465,   466,   184,     0,
    1133,  1134,  1135,   467,   468,     0,     0,   469,   705,     0,
       0,   470,   471,     0,     0,   187,   188,   189,  1137,   472,
     473,   474,     0,  1138,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1139,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   198,   494,  1140,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
    1141,   503,   203,   504,   505,   205,   506,  1142,     0,   507,
     508,   509,   510,   511,   512,   513,   514,  1143,   515,     0,
     516,   517,   518,   519,     0,  1144,  1145,     0,   521,     0,
     522,  1146,   523,  1147,  1148,   524,   525,   526,   527,   528,
       0,     0,   529,   530,   531,   532,   533,  1150,     0,   534,
     535,   536,  1151,   537,   220,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,    49,     0,   222,
     545,     0,     0,  1153,  1154,    52,  1155,    53,   579,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,  1161,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   580,    99,   100,   101,   356,   581,   103,     0,
     104,   105,   106,   107,   582,   583,     0,   109,   110,   111,
       0,   112,   584,   585,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,  1106,     0,     0,   375,
     376,   377,   129,   378,   379,   380,     0,  1107,   133,  1108,
    1109,     0,   381,   382,     0,   383,  1110,  1111,   384,  1112,
    1113,   386,     0,   387,   388,   389,   390,  1114,     0,     0,
     391,   392,   393,     0,   394,   395,  1115,   396,     0,   397,
     398,   145,   399,  1116,  1117,  1118,  1119,   400,   401,   402,
     403,   404,  1120,  1121,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,  1122,   413,   414,
       0,   415,   416,     0,     0,     0,   418,   419,   420,  1123,
     421,     0,  1124,  1125,   422,   423,  1126,     0,   424,     0,
     425,   160,     0,   161,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,   165,   166,     0,   438,   439,   440,  1127,
    1128,     0,  1129,     0,     0,   170,   171,   441,   172,   442,
     443,   444,   445,   446,     0,   173,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,  1130,   180,  1131,   704,   461,   462,   463,   464,
     182,     0,   465,   466,   184,     0,  1133,  1134,  1135,   467,
     468,     0,     0,   469,   705,     0,     0,     0,   471,     0,
       0,   187,   188,   189,  1137,   472,   473,   474,     0,  1138,
     192,   475,   476,     0,   477,   478,   479,   480,   481,   482,
    1139,   483,     0,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   198,   494,  1140,   495,   496,   497,   498,
     499,     0,     0,   500,   501,   502,  1141,   503,   203,   504,
     505,     0,   506,  1142,     0,   507,   508,   509,   510,   511,
     512,   513,   514,  1143,   515,     0,   516,   517,   518,   519,
       0,  1144,  1145,     0,   521,     0,   522,  1146,   523,  1147,
    1148,   524,   525,   526,   527,   528,     0,     0,   529,   530,
     531,   532,   533,  1150,     0,   534,   535,   536,  1151,   537,
     220,   538,     0,     0,     0,   539,   540,   541,   542,   543,
     544,     0,   221,    49,     0,   222,   545,     0,     0,  1153,
    1154,    52,  1155,    53,     0,     0,     0,     0,     0,  1972,
       0,     0,  1973,  1974,     0,     0,     0,  1161,   579,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,     0,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   580,    99,   100,   101,   356,   581,   103,     0,
     104,   105,   106,   107,   582,   583,     0,   109,   110,   111,
       0,   112,   584,   585,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372, -1082,
     373,   374,     0,     0,     0, -1082,  1106,     0,     0,   375,
     376,   377,   129,   378,   379,   380,     0,  1107,   133,  1108,
    1109,     0,   381,   382,     0,   383,  1110,  1111,   384,  1112,
    1113,   386,     0,   387,   388,   389,   390,  1114,     0,     0,
     391,   392,   393,     0,   394,   395,  1115,   396,     0,   397,
     398,   145,   399,  1116,  1117,  1118,  1119,   400,   401,   402,
     403,   404,  1120,  1121,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,  1122,   413,   414,
       0,   415,   416,     0,     0,     0,   418,   419,   420,  1123,
     421,     0,  1124,  1125,   422,   423,  1126,     0,   424,     0,
     425,   160,     0,   161,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,   165,   166,     0,   438,   439,   440,  1127,
    1128,     0,  1129,     0,     0,     0,     0,   441,   172,   442,
     443,   444,   445,   446,     0,   173,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,  1130,   180,  1131,   704,   461,   462,   463,   464,
     182,     0,   465,   466,     0,     0,  1133,  1134,  1135,   467,
     468,     0,     0,   469,   705,     0,     0,     0,   471,     0,
       0,   187,   188,   189,  1137,   472,   473,   474,     0,  1138,
     192,   475,   476,     0,   477,   478,   479,   480,   481,   482,
    1139,   483,     0,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   198,   494,  1140,   495,   496,   497,   498,
     499,     0,     0,   500,   501,   502,  1141,   503,   203,   504,
     505,     0,   506,  1142, -1082,   507,   508,   509,   510,   511,
     512,   513,   514,  1143,   515,     0,   516,   517,   518,   519,
       0,  1144,  1145,     0,   521,     0,   522,  1146,   523,  1147,
    1148,   524,   525,   526,   527,   528,     0,  1149,   529,   530,
     531,   532,   533,  1150,     0,   534,   535,   536,  1151,   537,
     220,   538,     0,     0,     0,   539,   540,   541,   542,   543,
     544,     0,   221,    49,     0,   222,   545,     0,     0,  1153,
    1154,    52,  1155,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1160,     0,     0,     0,  1161,   579,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,     0,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   580,    99,   100,   101,   356,   581,   103,     0,
     104,   105,   106,   107,   582,   583,     0,   109,   110,   111,
       0,   112,   584,   585,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372, -1083,
     373,   374,     0,     0,     0, -1083,  1106,     0,     0,   375,
     376,   377,   129,   378,   379,   380,     0,  1107,   133,  1108,
    1109,     0,   381,   382,     0,   383,  1110,  1111,   384,  1112,
    1113,   386,     0,   387,   388,   389,   390,  1114,     0,     0,
     391,   392,   393,     0,   394,   395,  1115,   396,     0,   397,
     398,   145,   399,  1116,  1117,  1118,  1119,   400,   401,   402,
     403,   404,  1120,  1121,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,  1122,   413,   414,
       0,   415,   416,     0,     0,     0,   418,   419,   420,  1123,
     421,     0,  1124,  1125,   422,   423,  1126,     0,   424,     0,
     425,   160,     0,   161,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,   165,   166,     0,   438,   439,   440,  1127,
    1128,     0,  1129,     0,     0,     0,     0,   441,   172,   442,
     443,   444,   445,   446,     0,   173,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,  1130,   180,  1131,   704,   461,   462,   463,   464,
     182,     0,   465,   466,     0,     0,  1133,  1134,  1135,   467,
     468,     0,     0,   469,   705,     0,     0,     0,   471,     0,
       0,   187,   188,   189,  1137,   472,   473,   474,     0,  1138,
     192,   475,   476,     0,   477,   478,   479,   480,   481,   482,
    1139,   483,     0,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   198,   494,  1140,   495,   496,   497,   498,
     499,     0,     0,   500,   501,   502,  1141,   503,   203,   504,
     505,     0,   506,  1142, -1083,   507,   508,   509,   510,   511,
     512,   513,   514,  1143,   515,     0,   516,   517,   518,   519,
       0,  1144,  1145,     0,   521,     0,   522,  1146,   523,  1147,
    1148,   524,   525,   526,   527,   528,     0,  1149,   529,   530,
     531,   532,   533,  1150,     0,   534,   535,   536,  1151,   537,
     220,   538,     0,     0,     0,   539,   540,   541,   542,   543,
     544,     0,   221,    49,     0,   222,   545,     0,     0,  1153,
    1154,    52,  1155,    53,   579,    79,    80,    81,   353,     0,
      83,    84,     0,    85,    86,    87,   354,  1161,   355,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   580,    99,
     100,   101,   356,   581,   103,     0,   104,   105,   106,   107,
     582,   583,     0,   109,   110,   111,     0,   112,   584,   585,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,  1106,     0,     0,   375,   376,   377,   129,   378,
     379,   380,     0,  1107,   133,  1108,  1109,     0,   381,   382,
       0,   383,  1110,  1111,   384,  1112,  1113,   386,     0,   387,
     388,   389,   390,  1114,     0,     0,   391,   392,   393,     0,
     394,   395,  1115,   396,     0,   397,   398,   145,   399,  1116,
    1117,  1118,  1119,   400,   401,   402,   403,   404,  1120,  1121,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,  1122,   413,   414,     0,   415,   416,     0,
       0,     0,   418,   419,   420,  1123,   421,     0,  1124,  1125,
     422,   423,  1126,     0,   424,     0,   425,   160,     0,   161,
     426,     0,   427,     0,     0,   428,     0,   429,   430,     0,
     431,   432,   433,     0,   434,   435,   436,   437,     0,   165,
     166,     0,   438,   439,   440,  1127,  1128,     0,  1129,     0,
       0,     0,     0,   441,   172,   442,   443,   444,   445,   446,
       0,   173,   447,     0,     0,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,  1130,   180,
    1131,   704,   461,   462,   463,   464,   182,     0,   465,   466,
       0,     0,     0,  1134,  1135,   467,   468,     0,     0,   469,
     705,     0,     0,     0,   471,     0,     0,   187,   188,   189,
    1137,   472,   473,   474,     0,  1138,   192,   475,   476,     0,
     477,   478,   479,   480,   481,   482,  1139,   483,     0,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   198,
     494,  1140,   495,   496,   497,   498,   499,     0,     0,   500,
     501,   502,  1141,   503,   203,   504,   505,     0,   506,  1142,
       0,   507,   508,   509,   510,   511,   512,   513,   514,  1143,
     515,     0,   516,   517,   518,   519,     0,  1144,  1145,     0,
     521,     0,   522,  1146,   523,  1147,  1148,   524,   525,   526,
     527,   528,     0,     0,   529,   530,   531,   532,   533,  1150,
       0,   534,   535,   536,  1151,   537,   220,   538,     0,     0,
       0,   539,   540,   541,   542,   543,   544,     0,   221,    49,
       0,   222,   545,     0,     0,  1153,  1154,    52,  1155,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1974,
       0,     0,     0,  1161,   579,    79,    80,    81,   353,     0,
      83,    84,     0,    85,    86,    87,   354,     0,   355,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   580,    99,
     100,   101,   356,   581,   103,     0,   104,   105,   106,   107,
     582,   583,     0,   109,   110,   111,     0,   112,   584,   585,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,  1106,     0,     0,   375,   376,   377,   129,   378,
     379,   380,     0,  1107,   133,  1108,  1109,     0,   381,   382,
       0,   383,  1110,  1111,   384,  1112,  1113,   386,     0,   387,
     388,   389,   390,  1114,     0,     0,   391,   392,   393,     0,
     394,   395,  1115,   396,     0,   397,   398,   145,   399,  1116,
    1117,  1118,  1119,   400,   401,   402,   403,   404,  1120,  1121,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,  1122,   413,   414,     0,   415,   416,     0,
       0,     0,   418,   419,   420,  1123,   421,     0,  1124,  1125,
     422,   423,  1126,     0,   424,     0,   425,   160,     0,   161,
     426,     0,   427,     0,     0,   428,     0,   429,   430,     0,
     431,   432,   433,     0,   434,   435,   436,   437,     0,   165,
     166,     0,   438,   439,   440,  1127,  1128,     0,  1129,     0,
       0,     0,     0,   441,   172,   442,   443,   444,   445,   446,
       0,   173,   447,     0,     0,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,  1130,   180,
    1131,   704,   461,   462,   463,   464,   182,     0,   465,   466,
       0,     0,     0,  1134,  1135,   467,   468,     0,     0,   469,
     705,     0,     0,     0,   471,     0,     0,   187,   188,   189,
    1137,   472,   473,   474,     0,  1138,   192,   475,   476,     0,
     477,   478,   479,   480,   481,   482,  1139,   483,     0,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   198,
     494,  1140,   495,   496,   497,   498,   499,     0,     0,   500,
     501,   502,  1141,   503,   203,   504,   505,     0,   506,  1142,
       0,   507,   508,   509,   510,   511,   512,   513,   514,  1143,
     515,     0,   516,   517,   518,   519,     0,  1144,  1145,     0,
     521,     0,   522,  1146,   523,  1147,  1148,   524,   525,   526,
     527,   528,     0,     0,   529,   530,   531,   532,   533,  1150,
       0,   534,   535,   536,  1151,   537,   220,   538,     0,     0,
       0,   539,   540,   541,   542,   543,   544,     0,   221,    49,
       0,   222,   545,     0,     0,  1153,  1154,    52,  1155,    53,
       0,    79,    80,    81,   353,     0,    83,    84,     0,    85,
      86,    87,   354,  1161,   355,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   356,     0,
     103,     0,   104,   105,   106,   107,     0,     0,     0,   109,
     110,   111,     0,   112,     0,     0,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,     0,  2681,
       0,   375,   376,   377,     0,   378,   379,   380,     0,   132,
       0,   134,     0,     0,   381,   382,     0,   383,     0,     0,
     384,   385,   135,   386,     0,   387,   388,   389,   390,   139,
       0,     0,   391,   392,   393,     0,   394,   395,   142,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,   148,   149,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,   415,   416,     0,   417,  -767,   418,   419,
     420,   155,   421,     0,   157,     0,   422,   423,   159,  -767,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,   166,     0,   438,   439,
     440,     0,   168,  -767,   169,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
    -767,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   179,     0,   181,     0,   461,   462,
     463,   464,   182,     0,   465,   466,     0,     0,     0,   185,
     186,   467,   468,     0,  -767,   469,     0,     0,     0,   470,
     471,     0,  -767,   187,     0,     0,   190,   472,   473,   474,
       0,   191,   192,   475,   476,     0,   477,   478,   479,   480,
     481,   482,   194,   483,     0,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,     0,   494,   200,   495,   496,
     497,   498,   499,     0,     0,   500,   501,   502,     0,   503,
     203,   504,   505,     0,   506,   206,     0,   507,   508,   509,
     510,   511,   512,   513,   514,   208,   515,     0,   516,   517,
     518,   519,     0,   209,   210,     0,   521,     0,   522,   211,
     523,   212,     0,   524,   525,   526,   527,   528,  -767,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     219,   537,     0,   538,     0,     0,     0,   539,   540,   541,
     542,   543,   544,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,     0,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
    1236,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   356,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     357,   358,     0,     0,     0,   359,   360,     0,     0,     0,
       0,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,     0,   363,     0,   364,   365,     0,   366,   367,   368,
     369,   370,   371,   372,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   375,   376,   377,   129,   378,   379,
     380,   131,   132,   133,   134,     0,     0,   381,   382,     0,
     383,     0,     0,   384,   385,   135,   386,     0,   387,   388,
     389,   390,   139,     0,     0,   391,   392,   393,     0,   394,
     395,   142,   396,     0,   397,   398,   145,   399,     0,     0,
       0,     0,   400,   401,   402,   403,   404,   148,   149,   405,
       0,   406,     0,   407,     0,   408,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,   415,   416,     0,   417,
       0,   418,   419,   420,   155,   421,     0,   157,     0,   422,
     423,   159,     0,   424,     0,   425,   160,     0,   161,   426,
       0,   427,     0,     0,   428,     0,   429,   430,   164,   431,
     432,   433,     0,   434,   435,   436,   437,     0,   165,   166,
       0,   438,   439,   440,     0,   168,     0,   169,     0,     0,
     170,   171,   441,   172,   442,   443,   444,   445,   446,     0,
     173,   447,   174,     0,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   179,   180,   181,
     704,   461,   462,   463,   464,   182,     0,   465,   466,   184,
       0,     0,   185,   186,   467,   468,     0,     0,   469,   705,
       0,   863,   470,   471,     0,     0,   187,   188,   189,   190,
     472,   473,   474,     0,   191,   192,   475,   476,     0,   477,
     478,   479,   480,   481,   482,   194,   483,     0,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   198,   494,
     200,   495,   496,   497,   498,   499,     0,   201,   500,   501,
     502,     0,   503,   203,   504,   505,   205,   506,   206,     0,
     507,   508,   509,   510,   511,   512,   513,   514,   208,   515,
       0,   516,   517,   518,   519,     0,   209,   210,     0,   521,
       0,   522,   211,   523,   212,     0,   524,   525,   526,   527,
     528,     0,     0,   529,   530,   531,   532,   533,     0,     0,
     534,   535,   536,   219,   537,   220,   538,     0,     0,     0,
     539,   540,   541,   542,   543,   544,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,  2407,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   357,   358,     0,     0,     0,   359,   360,     0,
       0,     0,     0,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,   363,     0,   364,   365,     0,   366,
     367,   368,   369,   370,   371,   372,     0,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   375,   376,   377,   129,
     378,   379,   380,   131,   132,   133,   134,     0,     0,   381,
     382,     0,   383,     0,     0,   384,   385,   135,   386,     0,
     387,   388,   389,   390,   139,     0,     0,   391,   392,   393,
       0,   394,   395,   142,   396,     0,   397,   398,   145,   399,
       0,     0,     0,     0,   400,   401,   402,   403,   404,   148,
     149,   405,     0,   406,     0,   407,     0,   408,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,   415,   416,
       0,   417,     0,   418,   419,   420,   155,   421,     0,   157,
       0,   422,   423,   159,     0,   424,     0,   425,   160,     0,
     161,   426,     0,   427,     0,     0,   428,     0,   429,   430,
     164,   431,   432,   433,     0,   434,   435,   436,   437,     0,
     165,   166,     0,   438,   439,   440,     0,   168,     0,   169,
       0,     0,   170,   171,   441,   172,   442,   443,   444,   445,
     446,     0,   173,   447,   174,     0,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   179,
     180,   181,   704,   461,   462,   463,   464,   182,     0,   465,
     466,   184,     0,     0,   185,   186,   467,   468,     0,     0,
     469,   705,     0,   863,   470,   471,     0,     0,   187,   188,
     189,   190,   472,   473,   474,     0,   191,   192,   475,   476,
       0,   477,   478,   479,   480,   481,   482,   194,   483,     0,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     198,   494,   200,   495,   496,   497,   498,   499,     0,     0,
     500,   501,   502,     0,   503,   203,   504,   505,   205,   506,
     206,     0,   507,   508,   509,   510,   511,   512,   513,   514,
     208,   515,     0,   516,   517,   518,   519,     0,   209,   210,
       0,   521,     0,   522,   211,   523,   212,     0,   524,   525,
     526,   527,   528,     0,     0,   529,   530,   531,   532,   533,
       0,     0,   534,   535,   536,   219,   537,   220,   538,     0,
       0,     0,   539,   540,   541,   542,   543,   544,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,     0,    91,  2407,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,     0,   357,   358,     0,     0,     0,   359,
     360,     0,     0,     0,     0,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,   363,     0,   364,   365,
       0,   366,   367,   368,   369,   370,   371,   372,     0,   373,
     374,     0,     0,     0,     0,     0,     0,     0,   375,   376,
     377,   129,   378,   379,   380,   131,   132,   133,   134,     0,
       0,   381,   382,     0,   383,     0,     0,   384,   385,   135,
     386,     0,   387,   388,   389,   390,   139,     0,     0,   391,
     392,   393,     0,   394,   395,   142,   396,     0,   397,   398,
     145,   399,     0,     0,     0,     0,   400,   401,   402,   403,
     404,   148,   149,   405,     0,   406,     0,   407,     0,   408,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
     415,   416,     0,   417,     0,   418,   419,   420,   155,   421,
       0,   157,     0,   422,   423,   159,     0,   424,     0,   425,
     160,     0,   161,   426,     0,   427,     0,     0,   428,     0,
     429,   430,   164,   431,   432,   433,     0,   434,   435,   436,
     437,     0,   165,   166,     0,   438,   439,   440,     0,   168,
       0,   169,     0,     0,   170,   171,   441,   172,   442,   443,
     444,   445,   446,     0,   173,   447,   174,     0,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   179,   180,   181,   704,   461,   462,   463,   464,   182,
       0,   465,   466,   184,     0,     0,   185,   186,   467,   468,
       0,     0,   469,   705,     0,     0,   470,   471,     0,     0,
     187,   188,   189,   190,   472,   473,   474,     0,   191,   192,
     475,   476,     0,   477,   478,   479,   480,   481,   482,   194,
     483,     0,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   198,   494,   200,   495,   496,   497,   498,   499,
       0,     0,   500,   501,   502,     0,   503,   203,   504,   505,
     205,   506,   206,     0,   507,   508,   509,   510,   511,   512,
     513,   514,   208,   515,     0,   516,   517,   518,   519,     0,
     209,   210,     0,   521,     0,   522,   211,   523,   212,     0,
     524,   525,   526,   527,   528,     0,     0,   529,   530,   531,
     532,   533,     0,     0,   534,   535,   536,   219,   537,   220,
     538,     0,     0,     0,   539,   540,   541,   542,   543,   544,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,  2930,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
       0,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     375,   376,   377,     0,   378,   379,   380,     0,   132,     0,
     134,     0,     0,   381,   382,     0,   383,     0,     0,   384,
     385,   135,   386,     0,   387,   388,   389,   390,   139,     0,
       0,   391,   392,   393,     0,   394,   395,   142,   396,     0,
     397,   398,     0,   399,     0,     0,     0,     0,   400,   401,
     402,   403,   404,   148,   149,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
     155,   421,     0,   157,     0,   422,   423,   159,     0,   424,
       0,   425,     0,     0,     0,   426,     0,   427,     0,     0,
     428,     0,   429,   430,     0,   431,   432,   433,     0,   434,
     435,   436,   437,     0,     0,   166,     0,   438,   439,   440,
       0,   168,     0,   169,     0,     0,     0,     0,   441,     0,
     442,   443,   444,   445,   446,     0,     0,   447,     0,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   179,     0,   181,     0,   461,   462,   463,
     464,   182,     0,   465,   466,     0,     0,     0,   185,   186,
     467,   468,     0,     0,   469,     0,     0,     0,   470,   471,
       0,     0,   187,     0,     0,   190,   472,   473,   474,     0,
     191,   192,   475,   476,     0,   477,   478,   479,   480,   481,
     482,   194,   483,     0,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,     0,   494,   200,   495,   496,   497,
     498,   499,     0,     0,   500,   501,   502,     0,   503,   203,
     504,   505,     0,   506,   206,     0,   507,   508,   509,   510,
     511,   512,   513,   514,   208,   515,     0,   516,   517,   518,
     519,     0,   209,   210,     0,   521,     0,   522,   211,   523,
     212,     0,   524,   525,   526,   527,   528,     0,     0,   529,
     530,   531,   532,   533,     0,     0,   534,   535,   536,   219,
     537,     0,   538,     0,     0,     0,   539,   540,   541,   542,
     543,   544,     0,   221,    49,     0,   222,   545,     0,     0,
       0,     0,    52,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2211,  2212,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,     0,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   356,     0,   103,     0,
     104,   105,   106,   107,     0,     0,     0,   109,   110,   111,
       0,   112,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,   132,     0,   134,
       0,     0,   381,   382,     0,   383,     0,     0,   384,   385,
     135,   386,     0,   387,   388,   389,   390,   139,     0,     0,
     391,   392,   393,     0,   394,   395,   142,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,   148,   149,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   155,
     421,     0,   157,     0,   422,   423,   159,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,   166,     0,   438,   439,   440,     0,
     168,     0,   169,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   179,     0,   181,     0,   461,   462,   463,   464,
     182,     0,   465,   466,     0,     0,     0,   185,   186,   467,
     468,     0,     0,   469,     0,     0,     0,   470,   471,     0,
       0,   187,     0,     0,   190,   472,   473,   474,     0,   191,
     192,   475,   476,     0,   477,   478,   479,   480,   481,   482,
     194,   483,     0,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,     0,   494,   200,   495,   496,   497,   498,
     499,     0,     0,   500,   501,   502,     0,   503,   203,   504,
     505,     0,   506,   206,     0,   507,   508,   509,   510,   511,
     512,   513,   514,   208,   515,     0,   516,   517,   518,   519,
       0,   209,   210,     0,   521,     0,   522,   211,   523,   212,
       0,   524,   525,   526,   527,   528,     0,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   219,   537,
       0,   538,     0,     0,     0,   539,   540,   541,   542,   543,
     544,     0,   221,    49,     0,   222,   545,     0,     0,     0,
       0,    52,     0,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,  2212,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     356,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,     0,   378,   379,   380,
       0,   132,     0,   134,     0,     0,   381,   382,     0,   383,
       0,     0,   384,   385,   135,   386,     0,   387,   388,   389,
     390,   139,     0,     0,   391,   392,   393,     0,   394,   395,
     142,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   148,   149,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   155,   421,     0,   157,     0,   422,   423,
     159,     0,   424,     0,   425,     0,     0,     0,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   431,   432,
     433,     0,   434,   435,   436,   437,     0,     0,   166,     0,
     438,   439,   440,     0,   168,     0,   169,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   179,     0,   181,   704,
     461,   462,   463,   464,   182,     0,   465,   466,     0,     0,
       0,   185,   186,   467,   468,     0,     0,   469,   705,     0,
       0,   470,   471,     0,     0,   187,     0,     0,   190,   472,
     473,   474,     0,   191,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,   194,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,     0,   494,   200,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
       0,   503,   203,   504,   505,     0,   506,   206,     0,   507,
     508,   509,   510,   511,   512,   513,   514,   208,   515,     0,
     516,   517,   518,   519,     0,   209,   210,     0,   521,     0,
     522,   211,   523,   212,     0,   524,   525,   526,   527,   528,
       0,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   219,   537,     0,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,    79,    80,    81,   353,     0,
      83,    84,     0,    85,    86,    87,   354,     0,   355,     0,
      91,  1230,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   356,     0,   103,     0,   104,   105,   106,   107,
       0,     0,     0,   109,   110,   111,     0,   112,     0,     0,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,     0,     0,     0,   375,   376,   377,     0,   378,
     379,   380,     0,   132,     0,   134,     0,     0,   381,   382,
       0,   383,     0,     0,   384,   385,   135,   386,     0,   387,
     388,   389,   390,   139,     0,     0,   391,   392,   393,     0,
     394,   395,   142,   396,     0,   397,   398,     0,   399,     0,
       0,     0,     0,   400,   401,   402,   403,   404,   148,   149,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,   415,   416,     0,
     417,     0,   418,   419,   420,   155,   421,     0,   157,     0,
     422,   423,   159,     0,   424,     0,   425,     0,     0,     0,
     426,     0,   427,     0,     0,   428,     0,   429,   430,     0,
     431,   432,   433,     0,   434,   435,   436,   437,     0,     0,
     166,     0,   438,   439,   440,     0,   168,     0,   169,     0,
       0,     0,     0,   441,     0,   442,   443,   444,   445,   446,
       0,     0,   447,     0,     0,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   179,     0,
     181,     0,   461,   462,   463,   464,   182,     0,   465,   466,
       0,     0,     0,   185,   186,   467,   468,     0,     0,   469,
       0,     0,     0,   470,   471,     0,     0,   187,     0,     0,
     190,   472,   473,   474,     0,   191,   192,   475,   476,     0,
     477,   478,   479,   480,   481,   482,   194,   483,     0,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,     0,
     494,   200,   495,   496,   497,   498,   499,     0,   201,   500,
     501,   502,     0,   503,   203,   504,   505,     0,   506,   206,
       0,   507,   508,   509,   510,   511,   512,   513,   514,   208,
     515,     0,   516,   517,   518,   519,     0,   209,   210,     0,
     521,     0,   522,   211,   523,   212,     0,   524,   525,   526,
     527,   528,     0,     0,   529,   530,   531,   532,   533,     0,
       0,   534,   535,   536,   219,   537,     0,   538,     0,     0,
       0,   539,   540,   541,   542,   543,   544,     0,   221,     0,
       0,   222,   545,     0,     0,     0,     0,    79,    80,    81,
     353,     0,    83,    84,     0,    85,    86,    87,   354,     0,
     355,     0,    91,   223,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   356,     0,   103,     0,   104,   105,
     106,   107,     0,     0,     0,   109,   110,   111,     0,   112,
       0,     0,     0,   357,   358,     0,     0,     0,   359,   360,
       0,     0,     0,     0,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,     0,   363,     0,   364,   365,     0,
     366,   367,   368,   369,   370,   371,   372,     0,   373,   374,
       0,     0,     0,     0,     0,     0,     0,   375,   376,   377,
       0,   378,   379,   380,     0,   132,     0,   134,     0,     0,
     381,   382,     0,   383,     0,     0,   384,   385,   135,   386,
       0,   387,   388,   389,   390,   139,     0,     0,   391,   392,
     393,     0,   394,   395,   142,   396,     0,   397,   398,     0,
     399,     0,     0,     0,     0,   400,   401,   402,   403,   404,
     148,   149,   405,     0,   406,     0,   407,     0,   408,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,   415,
     416,     0,   417,     0,   418,   419,   420,   155,   421,     0,
     157,     0,   422,   423,   159,     0,   424,     0,   425,     0,
       0,     0,   426,     0,   427,     0,     0,   428,     0,   429,
     430,     0,   431,   432,   433,     0,   434,   435,   436,   437,
       0,     0,   166,     0,   438,   439,   440,     0,   168,     0,
     169,     0,     0,     0,     0,   441,     0,   442,   443,   444,
     445,   446,     0,     0,   447,     0,     0,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     179,     0,   181,     0,   461,   462,   463,   464,   182,     0,
     465,   466,     0,     0,     0,   185,   186,   467,   468,     0,
       0,   469,     0,     0,     0,   470,   471,     0,     0,   187,
       0,     0,   190,   472,   473,   474,     0,   191,   192,   475,
     476,     0,   477,   478,   479,   480,   481,   482,   194,   483,
       0,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,     0,   494,   200,   495,   496,   497,   498,   499,     0,
     201,   500,   501,   502,     0,   503,   203,   504,   505,     0,
     506,   206,     0,   507,   508,   509,   510,   511,   512,   513,
     514,   208,   515,     0,   516,   517,   518,   519,     0,   209,
     210,     0,   521,     0,   522,   211,   523,   212,     0,   524,
     525,   526,   527,   528,     0,     0,   529,   530,   531,   532,
     533,     0,     0,   534,   535,   536,   219,   537,     0,   538,
       0,     0,     0,   539,   540,   541,   542,   543,   544,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,     0,   355,     0,    91,   223,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   356,     0,   103,     0,
     104,   105,   106,   107,     0,     0,     0,   109,   110,   111,
       0,   112,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,   132,     0,   134,
       0,     0,   381,   382,     0,   383,     0,     0,   384,   385,
     135,   386,     0,   387,   388,   389,   390,   139,     0,     0,
     391,   392,   393,     0,   394,   395,   142,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,   148,   149,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   155,
     421,     0,   157,     0,   422,   423,   159,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,   166,     0,   438,   439,   440,     0,
     168,     0,   169,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   179,     0,   181,     0,   461,   462,   463,   464,
     182,     0,   465,   466,     0,     0,     0,   185,   186,   467,
     468,     0,     0,   469,     0,     0,     0,   470,   471,     0,
       0,   187,     0,     0,   190,   472,   473,   474,     0,   191,
     192,   475,   476,     0,   477,   478,   479,   480,   481,   482,
     194,   483,     0,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,     0,   494,   200,   495,   496,   497,   498,
     499,     0,     0,   500,   501,   502,     0,   503,   203,   504,
     505,     0,   506,   206,     0,   507,   508,   509,   510,   511,
     512,   513,   514,   208,   515,     0,   516,   517,   518,   519,
       0,   209,   210,     0,   521,     0,   522,   211,   523,   212,
       0,   524,   525,   526,   527,   528,     0,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   219,   537,
       0,   538,     0,     0,     0,   539,   540,   541,   542,   543,
     544,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,    79,    80,    81,   353,     0,    83,    84,     0,    85,
      86,    87,   354,     0,   355,     0,    91,  1659,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   356,     0,
     103,     0,   104,   105,   106,   107,     0,     0,     0,   109,
     110,   111,     0,   112,     0,     0,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,   132,
       0,   134,     0,     0,   381,   382,     0,   383,     0,     0,
     384,   385,   135,   386,     0,   387,   388,   389,   390,   139,
       0,     0,   391,   392,   393,     0,   394,   395,   142,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,   148,   149,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,   155,   421,     0,   157,     0,   422,   423,   159,     0,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,   166,     0,   438,   439,
     440,     0,   168,     0,   169,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   179,     0,   181,     0,   461,   462,
     463,   464,   182,     0,   465,   466,     0,     0,     0,   185,
     186,   467,   468,     0,     0,   469,     0,     0,     0,   470,
     471,     0,     0,   187,     0,     0,   190,   472,   473,   474,
       0,   191,   192,   475,   476,     0,   477,   478,   479,   480,
     481,   482,   194,   483,     0,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,     0,   494,   200,   495,   496,
     497,   498,   499,     0,     0,   500,   501,   502,     0,   503,
     203,   504,   505,     0,   506,   206,     0,   507,   508,   509,
     510,   511,   512,   513,   514,   208,   515,     0,   516,   517,
     518,   519,     0,   209,   210,     0,   521,     0,   522,   211,
     523,   212,     0,   524,   525,   526,   527,   528,     0,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     219,   537,     0,   538,     0,     0,     0,   539,   540,   541,
     542,   543,   544,     0,   221,     0,     0,   222,     0,     0,
       0,     0,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,  2861,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,     0,   378,   379,   380,
       0,  1384,     0,  1385,  1109,     0,   381,   382,     0,   383,
       0,     0,   384,  1386,  1387,   386,     0,   387,   388,   389,
     390,     0,     0,     0,   391,   392,   393,     0,   394,   395,
       0,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,  1388,  1389,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,     0,   421,     0,     0,     0,   422,   423,
    1390,     0,   424,     0,   425,     0,     0,     0,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   431,   432,
     433,     0,   434,   435,   436,   437,     0,     0,     0,     0,
     438,   439,   440,  1127,  1391,     0,  1392,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1393,     0,  1394,     0,
     461,   462,   463,   464,     0,     0,   465,   466,     0,     0,
       0,     0,  1395,   467,   468,     0,     0,   469,     0,     0,
       0,  2516,   471,     0,     0,     0,     0,     0,     0,   472,
     473,   474,     0,     0,     0,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1396,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,     0,   494,     0,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
       0,   503,  1397,   504,   505,     0,   506,  1398,     0,   507,
     508,   509,   510,   511,   512,   513,   514,     0,   515,     0,
     516,   517,   518,   519,     0,  1399,  1400,     0,   521,     0,
     522,     0,   523,     0,     0,   524,   525,   526,   527,   528,
       0,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,  1401,   537,     0,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,    49,   972,   222,
     545,     0,     0,     0,     0,    52,     0,    53,   973,   974,
     975,     0,   976,  2517,   978,   979,   980,   981,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,     0,   357,   358,     0,     0,     0,   359,
     360,     0,     0,     0,     0,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,   363,     0,   364,   365,
       0,   366,   367,   368,   369,   370,   371,   372,     0,   373,
     374,     0,     0,     0,     0,     0,     0,     0,   375,   376,
     377,     0,   378,   379,   380,     0,   132,     0,   134,     0,
       0,   381,   382,     0,   383,     0,     0,   384,   385,   135,
     386,     0,   387,   971,   389,   390,   139,     0,     0,   391,
     392,   393,     0,   394,   395,   142,   396,     0,   397,   398,
       0,   399,     0,     0,     0,     0,   400,   401,   402,   403,
     404,   148,   149,   405,     0,   406,     0,   407,     0,   408,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
     415,   416,     0,   417,     0,   418,   419,   420,   155,   421,
       0,   157,     0,   422,   423,   159,     0,   424,     0,   425,
       0,     0,     0,   426,     0,   427,     0,     0,   428,     0,
     429,   430,     0,   431,   432,   433,     0,   434,   435,   436,
     437,     0,     0,   166,     0,   438,   439,   440,     0,   168,
       0,   169,     0,     0,     0,     0,   441,     0,   442,   443,
     444,   445,   446,     0,     0,   447,     0,     0,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   179,     0,   181,     0,   461,   462,   463,   464,   182,
       0,   465,   466,     0,     0,     0,   185,   186,   467,   468,
       0,     0,   469,     0,     0,     0,   470,   471,     0,     0,
     187,     0,     0,   190,   472,   473,   474,     0,   191,   192,
     475,   476,     0,   477,   478,   479,   480,   481,   482,   194,
     483,     0,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,     0,   494,   200,   495,   496,   497,   498,   499,
       0,     0,   500,   501,   502,     0,   503,   203,   504,   505,
       0,   506,   206,     0,   507,   508,   509,   510,   511,   512,
     513,   514,   208,   515,     0,   516,   517,   518,   519,     0,
     209,   210,     0,   521,     0,   522,   211,   523,   212,     0,
     524,   525,   526,   527,   528,     0,     0,   529,   530,   531,
     532,   533,     0,     0,   534,   535,   536,   219,   537,     0,
     538,     0,     0,     0,   539,   540,   541,   542,   543,   544,
       0,   221,     0,   972,   222,     0,     0,     0,     0,     0,
       0,     0,     0,   973,   974,   975,     0,   976,   977,   978,
     979,   980,   981,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     356,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,     0,   378,   379,   380,
       0,   132,     0,   134,     0,     0,   381,   382,     0,   383,
       0,     0,   384,   385,   135,   386,     0,   387,   388,   389,
     390,   139,     0,     0,   391,   392,   393,     0,   394,   395,
     142,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   148,   149,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   155,   421,     0,   157,     0,   422,   423,
     159,     0,   424,     0,   425,     0,     0,     0,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   431,   432,
     433,     0,   434,   435,   436,   437,     0,     0,   166,     0,
     438,   439,   440,     0,   168,     0,   169,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   179,     0,   181,     0,
     461,   462,   463,   464,   182,     0,   465,   466,     0,     0,
       0,   185,   186,   467,   468,     0,     0,   469,     0,     0,
       0,   470,   471,     0,     0,   187,     0,     0,   190,   472,
     473,   474,     0,   191,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,   194,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,     0,   494,   200,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
       0,   503,   203,   504,   505,     0,   506,   206,     0,   507,
     508,   509,   510,   511,   512,   513,   514,   208,   515,     0,
     516,   517,   518,   519,     0,   209,   210,     0,   521,     0,
     522,   211,   523,   212,     0,   524,   525,   526,   527,   528,
       0,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   219,   537,     0,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,     0,   972,   222,
       0,     0,     0,     0,     0,     0,     0,     0,   973,   974,
     975,     0,   976,   977,   978,   979,   980,   981,   579,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,     0,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   580,    99,   100,   101,   356,   581,   103,     0,
     104,   105,   106,   107,   582,   583,     0,   109,   110,   111,
       0,   112,   584,   585,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,  1384,     0,  1385,
    1109,     0,   381,   382,     0,   383,     0,     0,   384,  1386,
    1387,   386,     0,   387,   388,   389,   390,     0,     0,     0,
     391,   392,   393,     0,   394,   395,     0,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,  1388,  1389,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,  1122,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,     0,
     421,     0,     0,     0,   422,   423,  1390,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,     0,     0,   438,   439,   440,  1127,
    1391,     0,  1392,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,  1393,     0,  1394,     0,   461,   462,   463,   464,
       0,     0,   465,   466,     0,     0,     0,     0,  1395,   467,
     468,     0,     0,   469,     0,     0,     0,   470,   471,     0,
       0,     0,     0,     0,     0,   472,   473,   474,     0,     0,
       0,   475,   476,     0,   477,   478,   479,   480,   481,   482,
    1396,   483,     0,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,     0,   494,     0,   495,   496,   497,   498,
     499,     0,     0,   500,   501,   502,     0,   503,  1397,   504,
     505,     0,   506,  1398,     0,   507,   508,   509,   510,   511,
     512,   513,   514,     0,   515,     0,   516,   517,   518,   519,
       0,  1399,  1400,     0,   521,     0,   522,     0,   523,     0,
       0,   524,   525,   526,   527,   528,     0,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,  1401,   537,
       0,   538,     0,     0,     0,   539,   540,   541,   542,   543,
     544,     0,   221,     0,     0,   222,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
    1733,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   357,   358,     0,     0,     0,   359,   360,     0,
       0,     0,     0,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,   363,     0,   364,   365,     0,   366,
     367,   368,   369,   370,   371,   372,     0,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   375,   376,   377,     0,
     378,   379,   380,     0,   132,     0,   134,     0,     0,   381,
     382,     0,   383,     0,     0,   384,   385,   135,   386,     0,
     387,   388,   389,   390,   139,     0,     0,   391,   392,   393,
       0,   394,   395,   142,   396,     0,   397,   398,     0,   399,
       0,     0,     0,     0,   400,   401,   402,   403,   404,   148,
     149,   405,     0,   406,     0,   407,     0,   408,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,   415,   416,
       0,   417,     0,   418,   419,   420,   155,   421,     0,   157,
       0,   422,   423,   159,     0,   424,     0,   425,     0,     0,
       0,   426,     0,   427,     0,     0,   428,     0,   429,   430,
       0,   431,   432,   433,     0,   434,   435,   436,   437,     0,
       0,   166,     0,   438,   439,   440,     0,   168,     0,   169,
       0,     0,     0,     0,   441,     0,   442,   443,   444,   445,
     446,     0,     0,   447,     0,     0,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   179,
       0,   181,   704,   461,   462,   463,   464,   182,     0,   465,
     466,     0,     0,     0,   185,   186,   467,   468,     0,     0,
     469,   705,     0,     0,   470,   471,     0,     0,   187,     0,
       0,   190,   472,   473,   474,     0,   191,   192,   475,   476,
       0,   477,   478,   479,   480,   481,   482,   194,   483,     0,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
       0,   494,   200,   495,   496,   497,   498,   499,     0,     0,
     500,   501,   502,     0,   503,   203,   504,   505,     0,   506,
     206,     0,   507,   508,   509,   510,   511,   512,   513,   514,
     208,   515,     0,   516,   517,   518,   519,     0,   209,   210,
       0,   521,     0,   522,   211,   523,   212,     0,   524,   525,
     526,   527,   528,     0,     0,   529,   530,   531,   532,   533,
       0,     0,   534,   535,   536,   219,   537,     0,   538,     0,
       0,     0,   539,   540,   541,   542,   543,   544,     0,   221,
       0,     0,   222,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,   861,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     356,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,     0,   378,   379,   380,
       0,   132,     0,   134,     0,     0,   381,   382,     0,   383,
       0,     0,   384,   385,   135,   386,     0,   387,   388,   389,
     390,   139,     0,     0,   391,   392,   393,     0,   394,   395,
     142,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   148,   149,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   155,   421,     0,   157,     0,   422,   423,
     159,     0,   424,     0,   425,     0,     0,     0,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   431,   432,
     433,     0,   434,   435,   436,   437,     0,     0,   166,     0,
     438,   439,   440,     0,   168,     0,   169,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   179,     0,   181,     0,
     461,   462,   463,   464,   182,     0,   465,   466,     0,     0,
       0,   185,   186,   467,   468,     0,     0,   469,     0,     0,
       0,   470,   471,     0,     0,   187,     0,     0,   190,   472,
     473,   474,     0,   191,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,   194,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,     0,   494,   200,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
       0,   503,   203,   504,   505,     0,   506,   206,     0,   507,
     508,   509,   510,   511,   512,   513,   514,   208,   515,     0,
     516,   517,   518,   519,     0,   209,   210,     0,   521,     0,
     522,   211,   523,   212,     0,   524,   525,   526,   527,   528,
       0,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   219,   537,     0,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,     0,     0,   222,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,  1730,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
       0,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     375,   376,   377,     0,   378,   379,   380,     0,   132,     0,
     134,     0,     0,   381,   382,     0,   383,     0,     0,   384,
     385,   135,   386,     0,   387,   388,   389,   390,   139,     0,
       0,   391,   392,   393,     0,   394,   395,   142,   396,     0,
     397,   398,     0,   399,     0,     0,     0,     0,   400,   401,
     402,   403,   404,   148,   149,   405,  1643,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
     155,   421,     0,   157,  1644,   422,   423,   159,     0,   424,
       0,   425,     0,     0,     0,   426,     0,   427,     0,     0,
     428,     0,   429,   430,     0,   431,   432,   433,     0,   434,
     435,   436,   437,     0,     0,   166,     0,   438,   439,   440,
       0,   168,     0,   169,     0,     0,     0,     0,   441,     0,
     442,   443,   444,   445,   446,     0,     0,   447,     0,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   179,     0,   181,     0,   461,   462,   463,
     464,   182,     0,   465,   466,     0,     0,     0,   185,   186,
     467,   468,  1645,     0,   469,     0,  1646,     0,   470,   471,
       0,     0,   187,     0,     0,   190,   472,   473,   474,     0,
     191,   192,   475,   476,     0,   477,   478,   479,   480,   481,
     482,   194,   483,     0,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,     0,   494,   200,   495,   496,   497,
     498,   499,     0,     0,   500,   501,   502,     0,   503,   203,
     504,   505,     0,   506,   206,     0,   507,   508,   509,   510,
     511,   512,   513,   514,   208,   515,     0,   516,   517,   518,
     519,     0,   209,   210,     0,   521,     0,   522,   211,   523,
     212,  1647,   524,   525,   526,   527,   528,     0,     0,   529,
     530,   531,   532,   533,     0,     0,   534,   535,   536,   219,
     537,     0,   538,     0,     0,     0,   539,   540,   541,   542,
     543,   544,     0,   221,    49,     0,   222,   545,     0,     0,
       0,     0,    52,     0,    53,     0,    79,    80,    81,   353,
    1265,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   357,   358,     0,     0,     0,   359,   360,     0,
       0,     0,     0,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,   363,     0,   364,   365,     0,   366,
     367,   368,   369,   370,   371,   372,     0,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   375,   376,   377,     0,
     378,   379,   380,     0,   132,     0,   134,     0,     0,   381,
     382,     0,   383,     0,     0,   384,   385,   135,   386,     0,
     387,   388,   389,   390,   139,     0,     0,   391,   392,   393,
       0,   394,   395,   142,   396,     0,   397,   398,     0,   399,
       0,     0,     0,     0,   400,   401,   402,   403,   404,   148,
     149,   405,     0,   406,     0,   407,     0,   408,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,   415,   416,
       0,   417,     0,   418,   419,   420,   155,   421,     0,   157,
    1644,   422,   423,   159,     0,   424,     0,   425,     0,     0,
       0,   426,     0,   427,     0,     0,   428,     0,   429,   430,
       0,   431,   432,   433,     0,   434,   435,   436,   437,     0,
       0,   166,     0,   438,   439,   440,     0,   168,     0,   169,
       0,     0,     0,     0,   441,     0,   442,   443,   444,   445,
     446,     0,     0,   447,     0,     0,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   179,
       0,   181,     0,   461,   462,   463,   464,   182,     0,   465,
     466,     0,     0,     0,   185,   186,   467,   468,  1645,     0,
     469,     0,  1646,     0,   470,   471,     0,     0,   187,     0,
       0,   190,   472,   473,   474,     0,   191,   192,   475,   476,
       0,   477,   478,   479,   480,   481,   482,   194,   483,     0,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
       0,   494,   200,   495,   496,   497,   498,   499,     0,     0,
     500,   501,   502,     0,   503,   203,   504,   505,     0,   506,
     206,     0,   507,   508,   509,   510,   511,   512,   513,   514,
     208,   515,     0,   516,   517,   518,   519,     0,   209,   210,
       0,   521,     0,   522,   211,   523,   212,  1647,   524,   525,
     526,   527,   528,     0,     0,   529,   530,   531,   532,   533,
       0,     0,   534,   535,   536,   219,   537,     0,   538,     0,
       0,     0,   539,   540,   541,   542,   543,   544,     0,   221,
      49,     0,   222,   545,     0,     0,     0,     0,    52,     0,
      53,     0,    79,    80,    81,   353,  1265,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   356,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,     0,   357,   358,
       0,     0,     0,   359,   360,     0,     0,     0,     0,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     363,     0,   364,   365,     0,   366,   777,   368,   369,   370,
     371,   372,   778,   373,   374,     0,     0,     0,     0,     0,
       0,     0,   375,   376,   377,     0,   779,   379,   380,     0,
     132,     0,   134,     0,     0,   381,   382,     0,   383,     0,
       0,   384,   385,   135,   386,     0,   387,   388,   389,   390,
     139,     0,     0,   391,   392,   393,     0,   394,   395,   142,
     396,     0,   397,   398,     0,   399,     0,     0,     0,     0,
     400,   401,   402,   403,   404,   148,   149,   405,     0,   406,
       0,   407,     0,   408,   409,   410,     0,     0,     0,   411,
     412,   413,   414,     0,   415,   416,     0,   417,     0,   418,
     419,   420,   155,   421,     0,   157,     0,   422,   780,   159,
       0,   424,     0,   781,     0,   782,     0,   426,     0,   427,
       0,     0,   428,     0,   429,   430,     0,   431,   432,   433,
     783,   434,   435,   436,   437,     0,     0,   166,     0,   438,
     439,   440,     0,   168,     0,   169,     0,     0,     0,     0,
     441,     0,   442,   443,   444,   445,   784,     0,     0,   447,
       0,     0,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   179,     0,   181,     0,   785,
     462,   463,   464,   182,     0,   465,   466,     0,     0,     0,
     185,   186,   467,   468,     0,     0,   469,     0,     0,     0,
     470,   471,     0,     0,   187,     0,     0,   190,   472,   473,
     474,     0,   191,   192,   475,   476,     0,   786,   478,   479,
     480,   481,   482,   194,   483,     0,   484,   787,   486,   487,
     488,   489,   490,   491,   492,   493,     0,   494,   200,   495,
     496,   497,   498,   499,     0,     0,   500,   501,   502,     0,
     503,   203,   504,   505,     0,   506,   206,     0,   507,   508,
     509,   510,   511,   512,   513,   514,   208,   515,     0,   516,
     517,   518,   519,     0,   209,   210,     0,   521,     0,   522,
     211,   523,   212,     0,   524,   525,   526,   527,   528,     0,
       0,   529,   530,   531,   532,   533,     0,     0,   534,   535,
     536,   219,   537,     0,   538,     0,     0,     0,   539,   540,
     541,   542,   543,   544,     0,   221,     0,     0,   222,   545,
      79,    80,    81,   353,    52,    83,    84,     0,    85,    86,
      87,   354,   788,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   777,   368,   369,   370,   371,   372,
     778,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     375,   376,   377,     0,   779,   379,   380,     0,   132,     0,
     134,     0,     0,   381,   382,     0,   383,     0,     0,   384,
     385,   135,   386,     0,   387,   388,   389,   390,   139,     0,
       0,   391,   392,   393,     0,   394,   395,   142,   396,     0,
     397,   398,     0,   399,     0,     0,     0,     0,   400,   401,
     402,   403,   404,   148,   149,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
     155,   421,     0,   157,     0,   422,   780,   159,     0,   424,
       0,   781,     0,     0,     0,   426,     0,   427,     0,     0,
     428,     0,   429,   430,     0,   431,   432,   433,     0,   434,
     435,   436,   437,     0,     0,   166,     0,   438,   439,   440,
       0,   168,     0,   169,     0,     0,     0,     0,   441,     0,
     442,   443,   444,   445,   784,     0,     0,   447,     0,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   179,     0,   181,     0,   785,   462,   463,
     464,   182,     0,   465,   466,     0,     0,     0,   185,   186,
     467,   468,     0,     0,   469,     0,     0,     0,   470,   471,
       0,     0,   187,     0,     0,   190,   472,   473,   474,     0,
     191,   192,   475,   476,     0,   786,   478,   479,   480,   481,
     482,   194,   483,     0,   484,   787,   486,   487,   488,   489,
     490,   491,   492,   493,     0,   494,   200,   495,   496,   497,
     498,   499,     0,     0,   500,   501,   502,     0,   503,   203,
     504,   505,     0,   506,   206,     0,   507,   508,   509,   510,
     511,   512,   513,   514,   208,   515,     0,   516,   517,   518,
     519,     0,   209,   210,     0,   521,     0,   522,   211,   523,
     212,     0,   524,   525,   526,   527,   528,     0,     0,   529,
     530,   531,   532,   533,     0,     0,   534,   535,   536,   219,
     537,     0,   538,     0,     0,     0,   539,   540,   541,   542,
     543,   544,     0,   221,     0,     0,   222,   545,    79,    80,
      81,   353,    52,    83,    84,     0,    85,    86,    87,   354,
     788,   355,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,     0,   357,   358,     0,     0,     0,   359,
     360,     0,     0,     0,     0,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,   363,     0,   364,   365,
       0,   366,   367,   368,   369,   370,   371,   372,     0,   373,
     374,     0,     0,     0,     0,     0,     0,     0,   375,   376,
     377,     0,   378,   379,   380,     0,   132,     0,   134,     0,
       0,   381,   382,     0,   383,     0,     0,   384,   385,   135,
     386,     0,   387,   388,   389,   390,   139,     0,     0,   391,
     392,   393,     0,   394,   395,   142,   396,     0,   397,   398,
       0,   399,     0,     0,     0,     0,   400,   401,   402,   403,
     404,   148,   149,   405,   568,   406,     0,   407,     0,   408,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
     415,   416,     0,   417,     0,   418,   419,   420,   155,   421,
       0,   157,     0,   422,   423,   159,     0,   424,     0,   425,
       0,     0,     0,   426,     0,   427,     0,     0,   428,     0,
     429,   430,     0,   431,   432,   433,     0,   434,   435,   436,
     437,     0,     0,   166,     0,   438,   439,   440,     0,   168,
       0,   169,     0,     0,     0,     0,   441,     0,   442,   443,
     444,   445,   446,     0,     0,   447,     0,     0,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   179,     0,   181,     0,   461,   462,   463,   464,   182,
       0,   465,   466,     0,     0,     0,   185,   186,   467,   468,
       0,     0,   469,     0,     0,     0,   470,   471,     0,     0,
     187,     0,     0,   190,   472,   473,   474,     0,   191,   192,
     475,   476,     0,   477,   478,   479,   480,   481,   482,   194,
     483,     0,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,     0,   494,   200,   495,   496,   497,   498,   499,
       0,     0,   500,   501,   502,     0,   503,   203,   504,   505,
       0,   506,   206,     0,   507,   508,   509,   510,   511,   512,
     513,   514,   208,   515,     0,   516,   517,   518,   519,     0,
     209,   210,  1203,   521,     0,   522,   211,   523,   212,     0,
     524,   525,   526,   527,   528,     0,     0,   529,   530,   531,
     532,   533,     0,     0,   534,   535,   536,   219,   537,     0,
     538,     0,     0,     0,   539,   540,   541,   542,   543,   544,
       0,   221,    49,     0,   222,   545,    79,    80,    81,   353,
       0,    83,    84,  1204,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   357,   358,     0,     0,     0,   359,   360,     0,
       0,     0,     0,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,   363,     0,   364,   365,     0,   366,
     367,   368,   369,   370,   371,   372,     0,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   375,   376,   377,     0,
     378,   379,   380,     0,   132,     0,   134,     0,     0,   381,
     382,     0,   383,     0,     0,   384,   385,   135,   386,     0,
     387,   388,   389,   390,   139,     0,     0,   391,   392,   393,
       0,   394,   395,   142,   396,     0,   397,   398,     0,   399,
       0,     0,     0,     0,   400,   401,   402,   403,   404,   148,
     149,   405,     0,   406,     0,   407,     0,   408,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,   415,   416,
       0,   417,     0,   418,   419,   420,   155,   421,     0,   157,
       0,   422,   423,   159,     0,   424,     0,   425,     0,     0,
       0,   426,     0,   427,     0,     0,   428,     0,   429,   430,
       0,   431,   432,   433,     0,   434,   435,   436,   437,     0,
       0,   166,     0,   438,   439,   440,     0,   168,     0,   169,
       0,     0,     0,     0,   441,     0,   442,   443,   444,   445,
     446,     0,     0,   447,     0,     0,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   179,
       0,   181,     0,   461,   462,   463,   464,   182,     0,   465,
     466,     0,     0,     0,   185,   186,   467,   468,     0,     0,
     469,     0,     0,     0,   470,   471,     0,     0,   187,     0,
       0,   190,   472,   473,   474,     0,   191,   192,   475,   476,
       0,   477,   478,   479,   480,   481,   482,   194,   483,     0,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
       0,   494,   200,   495,   496,   497,   498,   499,     0,     0,
     500,   501,   502,     0,   503,   203,   504,   505,     0,   506,
     206,     0,   507,   508,   509,   510,   511,   512,   513,   514,
     208,   515,     0,   516,   517,   518,   519,     0,   209,   210,
       0,   521,     0,   522,   211,   523,   212,     0,   524,   525,
     526,   527,   528,     0,     0,   529,   530,   531,   532,   533,
       0,     0,   534,   535,   536,   219,   537,     0,   538,     0,
       0,     0,   539,   540,   541,   542,   543,   544,     0,   221,
      49,     0,   222,   545,     0,     0,  1153,  1154,    52,     0,
      53,    79,    80,    81,   353,     0,    83,    84,     0,    85,
      86,    87,   354,     0,   355,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   356,     0,
     103,     0,   104,   105,   106,   107,     0,     0,     0,   109,
     110,   111,     0,   112,     0,     0,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,   132,
       0,   134,     0,     0,   381,   382,     0,   383,     0,     0,
     384,   385,   135,   386,     0,   387,   388,   389,   390,   139,
       0,     0,   391,   392,   393,     0,   394,   395,   142,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,   148,   149,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,   155,   421,     0,   157,     0,   422,   423,   159,     0,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,   166,     0,   438,   439,
     440,     0,   168,     0,   169,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   179,     0,   181,     0,   461,   462,
     463,   464,   182,     0,   465,   466,     0,     0,     0,   185,
     186,   467,   468,     0,     0,   469,     0,     0,     0,   470,
     471,     0,     0,   187,     0,     0,   190,   472,   473,   474,
       0,   191,   192,   475,   476,     0,   477,   478,   479,   480,
     481,   482,   194,   483,     0,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,     0,   494,   200,   495,   496,
     497,   498,   499,     0,     0,   500,   501,   502,     0,   503,
     203,   504,   505,     0,   506,   206,     0,   507,   508,   509,
     510,   511,   512,   513,   514,   208,   515,     0,   516,   517,
     518,   519,     0,   209,   210,     0,   521,     0,   522,   211,
     523,   212,     0,   524,   525,   526,   527,   528,     0,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     219,   537,     0,   538,     0,     0,     0,   539,   540,   541,
     542,   543,   544,     0,   221,     0,     0,   222,     0,   840,
    1284,    79,    80,    81,   353,   841,    83,    84,     0,    85,
      86,    87,   354,   842,   355,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   356,     0,
     103,     0,   104,   105,   106,   107,     0,     0,     0,   109,
     110,   111,     0,   112,     0,     0,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,   132,
       0,   134,     0,     0,   381,   382,     0,   383,     0,     0,
     384,   385,   135,   386,     0,   387,   388,   389,   390,   139,
       0,     0,   391,   392,   393,     0,   843,   395,   142,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,   148,   149,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,   155,   421,     0,   157,     0,   422,   423,   159,     0,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,   166,     0,   438,   439,
     440,     0,   168,     0,   169,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   844,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   845,   179,     0,   181,     0,   461,   462,
     463,   464,   182,     0,   465,   466,     0,     0,     0,   185,
     186,   467,   468,     0,     0,   469,     0,     0,     0,   470,
     471,     0,     0,   187,     0,     0,   190,   472,   473,   474,
       0,   191,   192,   475,   476,     0,   477,   478,   479,   480,
     481,   482,   194,   483,     0,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,     0,   494,   200,   495,   496,
     497,   498,   499,     0,     0,   500,   501,   846,     0,   503,
     203,   504,   505,     0,   506,   206,     0,   507,   508,   509,
     510,   511,   512,   513,   514,   208,   515,     0,   516,   517,
     518,   519,     0,   847,   210,     0,   521,     0,   848,   211,
     523,   212,     0,   524,   525,   526,   527,   528,     0,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     219,   537,     0,   538,     0,     0,     0,   539,   540,   541,
     542,   543,   544,     0,   221,     0,     0,   222,   579,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,     0,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   580,    99,   100,   101,   356,   581,   103,     0,
     104,   105,   106,   107,   582,   583,     0,   109,   110,   111,
       0,   112,   584,   585,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,   586,
     373,   374,   587,   588,   589,   590,   591,   592,   593,   375,
     376,   377,   129,   378,   379,   380,   131,   132,   133,   134,
       0,   594,   381,   382,     0,   383,   595,   596,   384,   597,
     135,   386,   598,   387,   388,   389,   390,   139,   599,   600,
     391,   392,   393,   601,   394,   395,   142,   396,   602,   397,
     398,   145,   399,   603,   604,   605,   606,   400,   401,   402,
     403,   404,   148,   149,   405,   607,   406,   608,   407,     0,
     408,   409,   410,   609,   610,   611,   411,   412,   413,   414,
     612,   415,   416,   613,   417,   614,   418,   419,   420,   155,
     421,     0,   157,   615,   422,   423,   159,   616,   424,   617,
     425,   160,   618,   161,   426,     0,   427,   619,   620,   428,
     621,   429,   430,   164,   431,   432,   433,   622,   434,   435,
     436,   437,   623,   165,   166,   624,   438,   439,   440,   625,
     168,   626,   169,   627,     0,   170,   171,   441,   172,   442,
     443,   444,   445,   446,   628,   173,   447,   174,   629,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   179,   180,   181,   630,   461,   462,   463,   464,
     182,   631,   465,   466,   184,   632,   633,   185,   186,   467,
     468,   634,   635,   469,   636,   637,   638,   470,   471,   639,
     640,   187,   188,   189,   190,   472,   473,   474,     0,   191,
     192,   475,   476,   641,   477,   478,   479,   480,   481,   482,
     194,   483,   642,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   198,   494,   200,   495,   496,   497,   498,
     499,     0,   643,   500,   501,   502,   644,   503,   203,   504,
     505,   205,   506,   206,   645,   507,   508,   509,   510,   511,
     512,   513,   514,   208,   515,   646,   516,   517,   518,   519,
     647,   209,   210,   648,   521,   649,   522,   211,   523,   212,
     650,   524,   525,   526,   527,   528,   651,   652,   529,   530,
     531,   532,   533,   653,   654,   534,   535,   536,   219,   537,
     220,   538,     0,   655,   656,   539,   540,   541,   542,   543,
     544,     0,   221,     0,     0,   222,   579,    79,    80,    81,
     353,     0,    83,    84,     0,    85,    86,    87,   354,     0,
     355,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     580,    99,   100,   101,   356,   581,   103,     0,   104,   105,
     106,   107,   582,   583,     0,   109,   110,   111,     0,   112,
     584,   585,     0,   357,   358,     0,     0,     0,   359,   360,
       0,     0,     0,     0,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,     0,   363,     0,   364,   365,     0,
     366,   367,   368,   369,   370,   371,   372,     0,   373,   374,
       0,     0,     0,     0,     0,     0,     0,   375,   376,   377,
     129,   378,   379,   380,   131,  1384,   133,  1385,  1109,     0,
     381,   382,     0,   383,     0,     0,   384,  1386,  1387,   386,
       0,   387,   388,   389,   390,     0,     0,     0,   391,   392,
     393,     0,   394,   395,     0,   396,     0,   397,   398,   145,
     399,     0,     0,     0,     0,   400,   401,   402,   403,   404,
    1388,  1389,   405,     0,   406,     0,   407,     0,   408,   409,
     410,     0,     0,     0,   411,  1122,   413,   414,     0,   415,
     416,     0,   417,     0,   418,   419,   420,     0,   421,     0,
       0,     0,   422,   423,  1390,     0,   424,     0,   425,   160,
       0,   161,   426,     0,   427,     0,     0,   428,     0,   429,
     430,   164,   431,   432,   433,     0,   434,   435,   436,   437,
       0,   165,     0,     0,   438,   439,   440,  1127,  1391,     0,
    1392,     0,     0,   170,   171,   441,   172,   442,   443,   444,
     445,   446,     0,   173,   447,   174,     0,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
    1393,   180,  1394,     0,   461,   462,   463,   464,     0,     0,
     465,   466,   184,     0,     0,     0,  1395,   467,   468,     0,
       0,   469,     0,     0,     0,   470,   471,     0,     0,     0,
     188,   189,     0,   472,   473,   474,     0,     0,     0,   475,
     476,     0,   477,   478,   479,   480,   481,   482,  1396,   483,
       0,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   198,   494,     0,   495,   496,   497,   498,   499,     0,
       0,   500,   501,   502,     0,   503,  1397,   504,   505,   205,
     506,  1398,     0,   507,   508,   509,   510,   511,   512,   513,
     514,     0,   515,     0,   516,   517,   518,   519,     0,  1399,
    1400,     0,   521,     0,   522,     0,   523,     0,     0,   524,
     525,   526,   527,   528,     0,     0,   529,   530,   531,   532,
     533,     0,     0,   534,   535,   536,  1401,   537,   220,   538,
       0,     0,     0,   539,   540,   541,   542,   543,   544,     0,
     221,     0,     0,   222,    79,    80,    81,   353,     0,    83,
      84,   566,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   356,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     357,   358,     0,     0,     0,   359,   360,     0,     0,     0,
       0,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,     0,   363,     0,   364,   365,     0,   366,   367,   368,
     369,   370,   371,   372,   567,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   375,   376,   377,     0,   378,   379,
     380,     0,   132,     0,   134,     0,     0,   381,   382,     0,
     383,     0,     0,   384,   385,   135,   386,     0,   387,   388,
     389,   390,   139,     0,     0,   391,   392,   393,     0,   394,
     395,   142,   396,     0,   397,   398,     0,   399,     0,     0,
       0,     0,   400,   401,   402,   403,   404,   148,   149,   405,
     568,   406,     0,   407,     0,   408,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,   415,   416,     0,   417,
       0,   418,   419,   420,   155,   421,     0,   157,     0,   422,
     423,   159,     0,   424,     0,   425,     0,     0,     0,   426,
       0,   427,     0,     0,   428,     0,   429,   430,     0,   431,
     432,   433,     0,   434,   435,   436,   437,     0,     0,   166,
       0,   438,   439,   440,     0,   168,     0,   169,     0,     0,
       0,     0,   441,     0,   442,   443,   444,   445,   446,     0,
       0,   447,     0,     0,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   179,     0,   181,
       0,   461,   462,   463,   464,   182,     0,   465,   466,     0,
       0,     0,   185,   186,   467,   468,     0,     0,   469,     0,
       0,     0,   470,   471,     0,     0,   187,     0,     0,   190,
     472,   473,   474,     0,   191,   192,   475,   476,     0,   477,
     478,   479,   480,   481,   482,   194,   483,     0,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,     0,   494,
     200,   495,   496,   497,   498,   499,     0,     0,   500,   501,
     502,     0,   503,   203,   504,   505,     0,   506,   206,     0,
     507,   508,   509,   510,   511,   512,   513,   514,   208,   515,
       0,   516,   517,   518,   519,     0,   209,   210,     0,   521,
       0,   522,   211,   523,   212,     0,   524,   525,   526,   527,
     528,     0,     0,   529,   530,   531,   532,   533,     0,     0,
     534,   535,   536,   219,   537,     0,   538,     0,     0,     0,
     539,   540,   541,   542,   543,   544,     0,   221,    49,     0,
     222,   545,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   356,
       0,   103,     0,   104,   105,   106,   107,     0,     0,  1296,
     109,   110,   111,     0,   112,     0,     0,     0,   357,   358,
       0,     0,     0,   359,   360,     0,     0,     0,     0,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     363,     0,   364,   365,     0,   366,   367,   368,   369,   370,
     371,   372,     0,   373,   374,     0,     0,     0,     0,     0,
       0,     0,   375,   376,   377,     0,   378,   379,   380,     0,
     132,     0,   134,     0,     0,   381,   382,     0,   383,     0,
       0,   384,   385,   135,   386,     0,   387,   388,   389,   390,
     139,     0,     0,   391,   392,   393,     0,   394,   395,   142,
     396,     0,   397,   398,     0,   399,     0,     0,     0,     0,
     400,   401,   402,   403,   404,   148,   149,   405,     0,   406,
       0,   407,     0,   408,   409,   410,     0,     0,     0,   411,
     412,   413,   414,     0,   415,   416,     0,   417,     0,   418,
     419,   420,   155,   421,     0,   157,     0,   422,   423,   159,
       0,   424,     0,   425,     0,     0,     0,   426,     0,  2042,
       0,     0,   428,     0,   429,   430,     0,   431,   432,   433,
       0,   434,   435,   436,   437,     0,     0,   166,     0,   438,
     439,   440,     0,   168,     0,   169,     0,     0,     0,     0,
     441,     0,   442,   443,   444,   445,   446,     0,     0,   447,
       0,     0,   448,   449,  2043,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   179,     0,   181,   704,   461,
     462,   463,   464,   182,     0,   465,   466,     0,     0,     0,
     185,   186,   467,   468,     0,     0,   469,   705,     0,     0,
     470,   471,     0,     0,   187,     0,     0,   190,   472,   473,
     474,     0,   191,   192,   475,   476,     0,   477,   478,   479,
     480,   481,   482,   194,   483,     0,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,     0,   494,   200,   495,
     496,   497,   498,   499,     0,     0,   500,   501,   502,     0,
     503,   203,   504,   505,     0,   506,   206,     0,   507,   508,
     509,   510,   511,   512,   513,   514,   208,   515,  2044,   516,
    2045,   518,  2046,     0,   209,   210,     0,   521,     0,   522,
     211,   523,   212,     0,   524,   525,   526,   527,   528,     0,
       0,   529,   530,   531,   532,   533,     0,     0,   534,   535,
     536,   219,   537,     0,   538,     0,     0,     0,   539,   540,
     541,   542,   543,   544,     0,   221,     0,     0,   222,   545,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
       0,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     375,   376,   377,     0,   378,   379,   380,     0,   132,     0,
     134,     0,     0,   381,   382,     0,   383,     0,     0,   384,
     385,   135,   386,     0,   387,   388,   389,   390,   139,     0,
       0,   391,   392,   393,     0,   394,   395,   142,   396,     0,
     397,   398,     0,   399,     0,     0,     0,     0,   400,   401,
     402,   403,   404,   148,   149,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
     155,   421,     0,   157,     0,   422,   423,   159,     0,   424,
       0,   425,     0,     0,     0,   426,     0,   427,     0,     0,
     428,     0,   429,   430,     0,   431,   432,   433,     0,   434,
     435,   436,   437,     0,     0,   166,     0,   438,   439,   440,
       0,   168,     0,   169,     0,     0,     0,     0,   441,     0,
     442,   443,   444,   445,   446,     0,     0,   447,     0,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   179,     0,   181,     0,   461,   462,   463,
     464,   182,     0,   465,   466,     0,     0,     0,   185,   186,
     467,   468,     0,     0,   469,     0,     0,     0,   470,   471,
       0,     0,   187,     0,     0,   190,   472,   473,   474,     0,
     191,   192,   475,   476,     0,   477,   478,   479,   480,   481,
     482,   194,   483,     0,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,     0,   494,   200,   495,   496,   497,
     498,   499,     0,     0,   500,   501,   502,     0,   503,   203,
     504,   505,     0,   506,   206,     0,   507,   508,   509,   510,
     511,   512,   513,   514,   208,   515,     0,   516,   517,   518,
     519,     0,   209,   210,   520,   521,     0,   522,   211,   523,
     212,     0,   524,   525,   526,   527,   528,     0,     0,   529,
     530,   531,   532,   533,     0,     0,   534,   535,   536,   219,
     537,     0,   538,     0,     0,     0,   539,   540,   541,   542,
     543,   544,     0,   221,    49,     0,   222,   545,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,     0,   357,   358,     0,     0,     0,   359,
     360,     0,     0,     0,     0,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,   363,     0,   364,   365,
       0,   366,   367,   368,   369,   370,   371,   372,     0,   373,
     374,     0,     0,     0,     0,     0,     0,     0,   375,   376,
     377,     0,   378,   379,   380,     0,   132,     0,   134,     0,
       0,   381,   382,     0,   383,     0,     0,   384,   385,   135,
     386,     0,   387,   388,   389,   390,   139,     0,     0,   391,
     392,   393,     0,   394,   395,   142,   396,     0,   397,   398,
       0,   399,     0,     0,     0,     0,   400,   401,   402,   403,
     404,   148,   149,   405,   915,   406,     0,   407,     0,   408,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
     415,   416,     0,   417,     0,   418,   419,   420,   155,   421,
       0,   157,     0,   422,   423,   159,     0,   424,     0,   425,
       0,     0,     0,   426,     0,   427,     0,     0,   428,     0,
     429,   430,     0,   431,   432,   433,     0,   434,   435,   436,
     437,     0,     0,   166,     0,   438,   439,   440,     0,   168,
       0,   169,     0,     0,     0,     0,   441,     0,   442,   443,
     444,   445,   446,     0,     0,   447,     0,     0,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   179,     0,   181,     0,   461,   462,   463,   464,   182,
       0,   465,   466,     0,     0,     0,   185,   186,   467,   468,
       0,     0,   469,     0,     0,     0,   470,   471,     0,     0,
     187,     0,     0,   190,   472,   473,   474,     0,   191,   192,
     475,   476,     0,   477,   478,   479,   480,   481,   482,   194,
     483,     0,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,     0,   494,   200,   495,   496,   497,   498,   499,
       0,     0,   500,   501,   502,     0,   503,   203,   504,   505,
       0,   506,   206,     0,   507,   508,   509,   510,   511,   512,
     513,   514,   208,   515,     0,   516,   517,   518,   519,     0,
     209,   210,     0,   521,     0,   522,   211,   523,   212,     0,
     524,   525,   526,   527,   528,     0,     0,   529,   530,   531,
     532,   533,     0,     0,   534,   535,   536,   219,   537,     0,
     538,     0,     0,     0,   539,   540,   541,   542,   543,   544,
       0,   221,    49,     0,   222,   545,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   357,   358,     0,     0,     0,   359,   360,     0,
       0,     0,     0,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,   363,     0,   364,   365,     0,   366,
     367,   368,   369,   370,   371,   372,     0,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   375,   376,   377,     0,
     378,   379,   380,     0,   132,     0,   134,     0,     0,   381,
     382,     0,   383,     0,     0,   384,   385,   135,   386,     0,
     387,   388,   389,   390,   139,     0,     0,   391,   392,   393,
       0,   394,   395,   142,   396,     0,   397,   398,     0,   399,
       0,     0,     0,     0,   400,   401,   402,   403,   404,   148,
     149,   405,   568,   406,     0,   407,     0,   408,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,   415,   416,
       0,   417,     0,   418,   419,   420,   155,   421,     0,   157,
       0,   422,   423,   159,     0,   424,     0,   425,     0,     0,
       0,   426,     0,   427,     0,     0,   428,     0,   429,   430,
       0,   431,   432,   433,     0,   434,   435,   436,   437,     0,
       0,   166,     0,   438,   439,   440,     0,   168,     0,   169,
       0,     0,     0,     0,   441,     0,   442,   443,   444,   445,
     446,     0,     0,   447,     0,     0,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   179,
       0,   181,     0,   461,   462,   463,   464,   182,     0,   465,
     466,     0,     0,     0,   185,   186,   467,   468,     0,     0,
     469,     0,     0,     0,   470,   471,     0,     0,   187,     0,
       0,   190,   472,   473,   474,     0,   191,   192,   475,   476,
       0,   477,   478,   479,   480,   481,   482,   194,   483,     0,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
       0,   494,   200,   495,   496,   497,   498,   499,     0,     0,
     500,   501,   502,     0,   503,   203,   504,   505,     0,   506,
     206,     0,   507,   508,   509,   510,   511,   512,   513,   514,
     208,   515,     0,   516,   517,   518,   519,     0,   209,   210,
       0,   521,     0,   522,   211,   523,   212,     0,   524,   525,
     526,   527,   528,     0,     0,   529,   530,   531,   532,   533,
       0,     0,   534,   535,   536,   219,   537,     0,   538,     0,
       0,     0,   539,   540,   541,   542,   543,   544,     0,   221,
      49,     0,   222,   545,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   356,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     357,   358,     0,     0,     0,   359,   360,     0,     0,     0,
       0,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,     0,   363,     0,   364,   365,     0,   366,   367,   368,
     369,   370,   371,   372,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   375,   376,   377,     0,   378,   379,
     380,     0,   132,     0,   134,     0,     0,   381,   382,     0,
     383,     0,     0,   384,   385,   135,   386,     0,   387,   388,
     389,   390,   139,     0,     0,   391,   392,   393,     0,   394,
     395,   142,   396,     0,   397,   398,     0,   399,     0,     0,
       0,     0,   400,   401,   402,   403,   404,   148,   149,   405,
    1632,   406,     0,   407,     0,   408,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,   415,   416,     0,   417,
       0,   418,   419,   420,   155,   421,     0,   157,     0,   422,
     423,   159,     0,   424,     0,   425,     0,     0,     0,   426,
       0,   427,     0,     0,   428,     0,   429,   430,     0,   431,
     432,   433,     0,   434,   435,   436,   437,     0,     0,   166,
       0,   438,   439,   440,     0,   168,     0,   169,     0,     0,
       0,     0,   441,     0,   442,   443,   444,   445,   446,     0,
       0,   447,     0,     0,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   179,     0,   181,
       0,   461,   462,   463,   464,   182,     0,   465,   466,     0,
       0,     0,   185,   186,   467,   468,     0,     0,   469,     0,
       0,     0,   470,   471,     0,     0,   187,     0,     0,   190,
     472,   473,   474,     0,   191,   192,   475,   476,     0,   477,
     478,   479,   480,   481,   482,   194,   483,     0,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,     0,   494,
     200,   495,   496,   497,   498,   499,     0,     0,   500,   501,
     502,     0,   503,   203,   504,   505,     0,   506,   206,     0,
     507,   508,   509,   510,   511,   512,   513,   514,   208,   515,
       0,   516,   517,   518,   519,     0,   209,   210,     0,   521,
       0,   522,   211,   523,   212,     0,   524,   525,   526,   527,
     528,     0,     0,   529,   530,   531,   532,   533,     0,     0,
     534,   535,   536,   219,   537,     0,   538,     0,     0,     0,
     539,   540,   541,   542,   543,   544,     0,   221,    49,     0,
     222,   545,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   356,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,     0,   357,   358,
       0,     0,     0,   359,   360,     0,     0,     0,     0,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     363,     0,   364,   365,     0,   366,   367,   368,   369,   370,
     371,   372,     0,   373,   374,     0,     0,     0,     0,     0,
       0,     0,   375,   376,   377,     0,   378,   379,   380,     0,
     132,     0,   134,     0,     0,   381,   382,     0,   383,     0,
       0,   384,   385,   135,   386,     0,   387,   388,   389,   390,
     139,     0,     0,   391,   392,   393,     0,   394,   395,   142,
     396,     0,   397,   398,     0,   399,     0,     0,     0,     0,
     400,   401,   402,   403,   404,   148,   149,   405,     0,   406,
       0,   407,     0,   408,   409,   410,     0,     0,     0,   411,
     412,   413,   414,     0,   415,   416,     0,   417,     0,   418,
     419,   420,   155,   421,     0,   157,     0,   422,   423,   159,
       0,   424,     0,   425,     0,     0,     0,   426,     0,   427,
       0,     0,   428,     0,   429,   430,     0,   431,   432,   433,
       0,   434,   435,   436,   437,     0,     0,   166,     0,   438,
     439,   440,     0,   168,     0,   169,     0,     0,     0,     0,
     441,     0,   442,   443,   444,   445,   446,     0,     0,   447,
       0,     0,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   179,     0,   181,     0,   461,
     462,   463,   464,   182,     0,   465,   466,     0,     0,     0,
     185,   186,   467,   468,     0,     0,   469,     0,     0,     0,
     470,   471,     0,     0,   187,     0,     0,   190,   472,   473,
     474,     0,   191,   192,   475,   476,     0,   477,   478,   479,
     480,   481,   482,   194,   483,     0,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,     0,   494,   200,   495,
     496,   497,   498,   499,     0,     0,   500,   501,   502,     0,
     503,   203,   504,   505,     0,   506,   206,     0,   507,   508,
     509,   510,   511,   512,   513,   514,   208,   515,     0,   516,
     517,   518,   519,     0,   209,   210,     0,   521,     0,   522,
     211,   523,   212,     0,   524,   525,   526,   527,   528,     0,
       0,   529,   530,   531,   532,   533,     0,     0,   534,   535,
     536,   219,   537,     0,   538,     0,     0,     0,   539,   540,
     541,   542,   543,   544,     0,   221,    49,     0,   222,   545,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,   742,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
       0,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     375,   376,   377,     0,   378,   379,   380,     0,   132,     0,
     134,     0,     0,   381,   382,     0,   383,     0,     0,   384,
     385,   135,   386,     0,   387,   388,   389,   390,   139,     0,
       0,   391,   392,   393,     0,   394,   395,   142,   396,     0,
     397,   398,     0,   399,     0,     0,     0,     0,   400,   401,
     402,   403,   404,   148,   149,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
     155,   421,     0,   157,     0,   422,   423,   159,     0,   424,
       0,   425,     0,     0,     0,   426,     0,   427,     0,     0,
     428,     0,   429,   430,     0,   431,   432,   433,     0,   434,
     435,   436,   437,     0,     0,   166,     0,   438,   439,   440,
       0,   168,     0,   169,     0,     0,     0,     0,   441,     0,
     442,   443,   444,   445,   446,     0,     0,   447,     0,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   179,     0,   181,     0,   461,   462,   463,
     464,   182,     0,   465,   466,     0,     0,     0,   185,   186,
     467,   468,     0,     0,   469,     0,     0,     0,   470,   471,
       0,     0,   187,     0,     0,   190,   472,   473,   474,     0,
     191,   192,   475,   743,     0,   477,   478,   479,   480,   481,
     482,   194,   483,     0,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,     0,   494,   200,   495,   496,   497,
     498,   499,     0,     0,   500,   501,   502,     0,   503,   203,
     504,   505,     0,   506,   206,     0,   507,   508,   509,   510,
     511,   512,   513,   514,   208,   515,     0,   516,   517,   518,
     519,     0,   209,   210,     0,   521,     0,   522,   211,   523,
     212,     0,   524,   525,   526,   527,   528,     0,     0,   529,
     530,   531,   532,   533,     0,     0,   534,   535,   536,   219,
     537,     0,   538,     0,     0,     0,   539,   540,   541,   542,
     543,   544,     0,   221,     0,     0,   222,   545,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,     0,   357,   358,     0,     0,     0,   359,
     360,     0,     0,     0,     0,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,   363,     0,   364,   365,
       0,   366,   367,   368,   369,   370,   371,   372,     0,   373,
     374,     0,     0,     0,     0,     0,     0,     0,   375,   376,
     377,     0,   378,   379,   380,     0,   132,     0,   134,     0,
       0,   381,   382,     0,   383,     0,     0,   384,   385,   135,
     386,     0,   387,   388,   389,   390,   139,     0,     0,   391,
     392,   393,     0,   394,   395,   142,   396,     0,   397,   398,
       0,   399,     0,     0,     0,     0,   400,   401,   402,   403,
     404,   148,   149,   405,     0,   406,     0,   407,     0,   408,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
     415,   416,     0,   417,     0,   418,   419,   420,   155,   421,
       0,   157,     0,   422,   423,   159,     0,   424,     0,   425,
       0,     0,     0,   426,     0,   427,     0,     0,   428,     0,
     429,   430,     0,   773,   432,   433,     0,   434,   435,   436,
     437,     0,     0,   166,     0,   438,   439,   440,     0,   168,
       0,   169,     0,     0,     0,     0,   441,     0,   442,   443,
     444,   445,   446,     0,     0,   447,     0,     0,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   179,     0,   181,     0,   461,   462,   463,   464,   182,
       0,   465,   466,     0,     0,     0,   185,   186,   467,   468,
       0,     0,   469,     0,     0,     0,   470,   471,     0,     0,
     187,     0,     0,   190,   472,   473,   474,     0,   191,   192,
     475,   476,     0,   477,   478,   479,   480,   481,   482,   194,
     483,     0,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,     0,   494,   200,   495,   496,   497,   498,   499,
       0,     0,   500,   501,   502,     0,   503,   203,   504,   505,
       0,   506,   206,     0,   507,   508,   509,   510,   511,   512,
     513,   514,   208,   515,     0,   516,   517,   518,   519,     0,
     209,   210,     0,   521,     0,   522,   211,   523,   212,     0,
     524,   525,   526,   527,   528,     0,     0,   529,   530,   531,
     532,   533,     0,     0,   534,   535,   536,   219,   537,     0,
     538,     0,     0,     0,   539,   540,   541,   542,   543,   544,
       0,   221,     0,     0,   222,   545,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   357,   358,     0,     0,     0,   359,   360,     0,
       0,     0,     0,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,   363,     0,   364,   365,     0,   366,
     367,   368,   369,   370,   371,   372,     0,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   375,   376,   377,     0,
     378,   379,   380,     0,   132,     0,   134,     0,     0,   381,
     382,     0,   383,     0,     0,   384,   385,   135,   386,     0,
     387,   388,   389,   390,   139,     0,     0,   391,   392,   393,
       0,   394,   395,   142,   396,     0,   397,   398,     0,   399,
       0,     0,     0,     0,   400,   401,   402,   403,   404,   148,
     149,   405,     0,   406,     0,   407,     0,   408,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,   415,   416,
       0,   417,     0,   418,   419,   420,   155,   421,     0,   157,
       0,   422,   423,   159,     0,   424,     0,   425,     0,     0,
       0,   426,     0,   427,     0,     0,   428,     0,   429,   430,
       0,   431,   432,   433,     0,   434,   435,   436,   437,     0,
       0,   166,     0,   438,   439,   440,     0,   168,     0,   169,
       0,     0,     0,     0,   441,     0,   442,   443,   444,   445,
     446,     0,     0,   447,     0,     0,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   179,
       0,   181,     0,   461,   462,   463,   464,   182,     0,   465,
     466,     0,     0,     0,   185,   186,   467,   468,     0,     0,
     469,     0,     0,     0,   470,   471,     0,     0,   187,     0,
       0,   190,   472,   473,   474,     0,   191,   192,   475,   476,
       0,   477,   478,   479,   480,   481,   482,   194,   483,     0,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
       0,   494,   200,   495,   496,   497,   498,   499,     0,     0,
     500,   501,   502,     0,   503,   203,   504,   505,     0,   506,
     206,     0,   507,   508,   509,   510,   511,   512,   513,   514,
     208,   515,     0,   516,   517,   518,   519,     0,   209,   210,
       0,   521,     0,   522,   211,   523,   212,     0,   524,   525,
     526,   527,   528,     0,     0,   529,   530,   531,   532,   533,
       0,     0,   534,   535,   536,   219,   537,     0,   538,     0,
       0,     0,   539,   540,   541,   542,   543,   544,     0,   221,
       0,     0,   222,   545,   579,    79,    80,    81,   353,     0,
      83,    84,     0,    85,    86,    87,   354,     0,   355,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   580,    99,
     100,   101,   356,   581,   103,     0,   104,   105,   106,   107,
     582,   583,     0,   109,   110,   111,     0,   112,   584,   585,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,     0,     0,     0,   375,   376,   377,     0,   378,
     379,   380,     0,  1384,     0,  1385,  1109,     0,   381,   382,
       0,   383,     0,     0,   384,  1386,  1387,   386,     0,   387,
     388,   389,   390,     0,     0,     0,   391,   392,   393,     0,
     394,   395,     0,   396,     0,   397,   398,     0,   399,     0,
       0,     0,     0,   400,   401,   402,   403,   404,  1388,  1389,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,  1122,   413,   414,     0,   415,   416,     0,
     417,     0,   418,   419,   420,     0,   421,     0,     0,     0,
     422,   423,  1390,     0,   424,     0,   425,     0,     0,     0,
     426,     0,   427,     0,     0,   428,     0,   429,   430,     0,
     431,   432,   433,     0,   434,   435,   436,   437,     0,     0,
       0,     0,   438,   439,   440,  1127,  1391,     0,  1392,     0,
       0,     0,     0,   441,     0,   442,   443,   444,   445,   446,
       0,     0,   447,     0,     0,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,  1393,     0,
    1394,     0,   461,   462,   463,   464,  1768,     0,   465,   466,
       0,     0,     0,     0,  1395,   467,   468,     0,     0,   469,
       0,     0,     0,   470,   471,     0,     0,     0,     0,     0,
       0,   472,   473,   474,     0,     0,     0,   475,   476,     0,
     477,   478,   479,   480,   481,   482,  1396,   483,     0,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,     0,
     494,     0,   495,   496,   497,   498,   499,     0,     0,   500,
     501,   502,     0,   503,  1397,   504,   505,     0,   506,  1398,
       0,   507,   508,   509,   510,   511,   512,   513,   514,     0,
     515,     0,   516,   517,   518,   519,     0,  1399,  1400,     0,
     521,     0,   522,     0,   523,     0,     0,   524,   525,   526,
     527,   528,     0,     0,   529,   530,   531,   532,   533,     0,
       0,   534,   535,   536,  1401,   537,     0,   538,     0,     0,
       0,   539,   540,   541,   542,   543,   544,     0,   221,     0,
       0,   222,   579,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   580,    99,   100,   101,
     356,   581,   103,     0,   104,   105,   106,   107,   582,   583,
       0,   109,   110,   111,     0,   112,   584,   585,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,     0,   378,   379,   380,
       0,  1384,     0,  1385,  1109,     0,   381,   382,     0,   383,
       0,     0,   384,  1386,  1387,   386,     0,   387,   388,   389,
     390,     0,     0,     0,   391,   392,   393,     0,   394,   395,
       0,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,  1388,  1389,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1122,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,     0,   421,     0,     0,     0,   422,   423,
    1390,     0,   424,     0,   425,     0,     0,     0,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   431,   432,
     433,     0,   434,   435,   436,   437,     0,     0,     0,     0,
     438,   439,   440,  1127,  1391,     0,  1392,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1393,     0,  1394,     0,
     461,   462,   463,   464,  2487,     0,   465,   466,     0,     0,
       0,     0,  1395,   467,   468,     0,     0,   469,     0,     0,
       0,   470,   471,     0,     0,     0,     0,     0,     0,   472,
     473,   474,     0,     0,     0,   475,   476,     0,   477,   478,
     479,   480,   481,   482,  1396,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,     0,   494,     0,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
       0,   503,  1397,   504,   505,     0,   506,  1398,     0,   507,
     508,   509,   510,   511,   512,   513,   514,     0,   515,     0,
     516,   517,   518,   519,     0,  1399,  1400,     0,   521,     0,
     522,     0,   523,     0,     0,   524,   525,   526,   527,   528,
       0,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,  1401,   537,     0,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,     0,     0,   222,
     579,    79,    80,    81,   353,     0,    83,    84,     0,    85,
      86,    87,   354,     0,   355,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   580,    99,   100,   101,   356,   581,
     103,     0,   104,   105,   106,   107,   582,   583,     0,   109,
     110,   111,     0,   112,   584,   585,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,  1384,
       0,  1385,  1109,     0,   381,   382,     0,   383,     0,     0,
     384,  1386,  1387,   386,     0,   387,   388,   389,   390,     0,
       0,     0,   391,   392,   393,     0,   394,   395,     0,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,  1388,  1389,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,  1122,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,     0,   421,     0,     0,     0,   422,   423,  1390,     0,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,     0,     0,   438,   439,
     440,  1127,  1391,     0,  1392,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,  1393,     0,  1394,     0,   461,   462,
     463,   464,     0,     0,   465,   466,     0,     0,     0,     0,
    1395,   467,   468,     0,     0,   469,     0,     0,     0,   470,
     471,     0,     0,     0,     0,     0,     0,   472,   473,   474,
       0,     0,     0,   475,   476,     0,   477,   478,   479,   480,
     481,   482,  1396,   483,     0,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,     0,   494,     0,   495,   496,
     497,   498,   499,     0,     0,   500,   501,   502,     0,   503,
    1397,   504,   505,     0,   506,  1398,     0,   507,   508,   509,
     510,   511,   512,   513,   514,     0,   515,     0,   516,   517,
     518,   519,     0,  1399,  1400,     0,   521,     0,   522,     0,
     523,     0,     0,   524,   525,   526,   527,   528,     0,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
    1401,   537,     0,   538,     0,     0,     0,   539,   540,   541,
     542,   543,   544,     0,   221,     0,     0,   222,   579,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,     0,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   580,    99,   100,   101,   356,   581,   103,     0,
     104,   105,   106,   107,   582,   583,     0,   109,   110,   111,
       0,   112,   584,   585,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,  1384,     0,  1385,
    1109,     0,   381,   382,     0,   383,     0,     0,   384,  1386,
    1387,   386,     0,   387,   388,   389,   390,     0,     0,     0,
     391,   392,   393,     0,   394,   395,     0,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,  1388,  1389,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,  1122,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,     0,
     421,     0,     0,     0,   422,   423,  1390,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,     0,     0,   438,   439,   440,  1127,
    1391,     0,  1392,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,  1393,     0,  1394,     0,   461,   462,   463,   464,
       0,     0,   465,   466,     0,     0,     0,     0,  1395,   467,
     468,     0,     0,   469,     0,     0,     0,   470,   471,     0,
       0,     0,     0,     0,     0,   472,   473,   474,     0,     0,
       0,   475,   476,     0,   477,   478,   479,   480,   481,   482,
    1396,   483,     0,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,     0,   494,     0,   495,   496,   497,   498,
     499,     0,     0,   500,   501,   502,     0,   503,     0,   504,
     505,     0,   506,  1398,     0,   507,   508,   509,   510,   511,
     512,   513,   514,     0,   515,     0,   516,   517,   518,   519,
       0,  1399,  1400,     0,   521,     0,   522,     0,   523,     0,
       0,   524,   525,   526,   527,   528,     0,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,  1401,   537,
       0,   538,     0,     0,     0,   539,   540,   541,   542,   543,
     544,     0,   221,     0,     0,   222,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   357,   358,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   366,
     367,   368,   369,   370,   371,   372,   586,   373,   374,   587,
     588,   589,   590,   591,   592,   593,   375,   376,   377,   129,
     378,   379,   380,   131,   132,   133,   134,     0,   594,   381,
     382,     0,   383,   595,   596,   384,     0,   135,   386,   598,
     387,   388,   389,   390,   139,   599,   600,   391,   392,   393,
     601,   394,   395,   142,   396,   602,   397,   398,   145,   399,
     603,   604,   605,   606,   400,   401,   402,     0,   404,   148,
     149,   405,   607,   406,   608,   407,     0,   408,   409,   410,
     609,   610,   611,   411,   412,   413,   414,   612,   415,   416,
     613,   417,   614,   418,   419,   420,   155,   421,     0,   157,
     615,   422,   423,   159,   616,   424,   617,   425,   160,   618,
     161,   426,     0,   427,   619,   620,   428,   621,   429,     0,
     164,   431,   432,   433,   622,   434,   435,   436,   437,   623,
     165,   166,     0,   438,   439,   440,     0,   168,   626,   169,
     627,     0,   170,   171,   441,   172,   442,   443,   444,   445,
     446,   628,   173,   447,   174,   629,   448,   449,   450,   451,
     452,   453,   454,     0,   456,   457,     0,   459,   460,   179,
     180,   181,   630,   461,   462,   463,   464,   182,   631,   465,
     466,   184,   632,   633,   185,   186,   467,   468,   634,   635,
     469,   636,   637,   638,   470,   471,   639,   640,   187,   188,
     189,   190,   472,   473,   474,     0,   191,   192,   475,   476,
     641,   477,   478,   479,   480,   481,   482,   194,   483,   642,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     198,   494,   200,   495,   496,   497,   498,     0,     0,   643,
     500,   501,   502,   644,   503,   203,   504,   505,   205,   506,
     206,   645,   507,   508,   509,   510,   511,   512,   513,   514,
     208,   515,   646,   516,   517,   518,   519,   647,   209,   210,
       0,   521,   649,   522,   211,   523,   212,   650,   524,   525,
     526,   527,   528,     0,   652,   529,   530,   531,   532,   533,
     653,   654,   534,   535,   536,   219,   537,   220,   538,     0,
     655,   656,   539,   540,   541,   542,     0,   544,     0,   221,
       0,     0,   222,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     356,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,   129,   378,   379,   380,
     131,   132,   133,   134,     0,     0,   381,   382,     0,   383,
       0,     0,   384,   385,   135,   386,     0,   387,   388,   389,
     390,   139,     0,     0,   391,   392,   393,     0,   394,   395,
     142,   396,     0,   397,   398,   145,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   148,   149,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   155,   421,     0,   157,     0,   422,   423,
     159,     0,   424,     0,   425,   160,     0,   161,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   164,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   165,   166,     0,
     438,   439,   440,     0,   168,     0,   169,     0,     0,   170,
     171,   441,   172,   442,   443,   444,   445,   446,     0,   173,
     447,   174,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   179,   180,   181,   704,
     461,   462,   463,   464,   182,     0,   465,   466,   184,     0,
       0,   185,   186,   467,   468,     0,     0,   469,   705,     0,
       0,   470,   471,     0,     0,   187,   188,   189,   190,   472,
     473,   474,     0,   191,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,   194,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   198,   494,   200,
     495,   496,   497,   498,   499,     0,     0,   500,   501,   502,
       0,   503,   203,   504,   505,   205,   506,   206,     0,   507,
     508,   509,   510,   511,   512,   513,   514,   208,   515,     0,
     516,   517,   518,   519,     0,   209,   210,     0,   521,     0,
     522,   211,   523,   212,     0,   524,   525,   526,   527,   528,
       0,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   219,   537,   220,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,     0,     0,   222,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
       0,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     375,   376,   377,     0,   378,   379,   380,     0,   132,     0,
     134,     0,     0,   381,   382,     0,   383,     0,     0,   384,
     385,   135,   386,  1741,   387,   388,   389,   390,   139,     0,
       0,   391,   392,   393,  1742,   394,   395,   142,   396,     0,
     397,   398,     0,   399,     0,     0,     0,     0,   400,   401,
     402,   403,   404,   148,   149,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
     155,   421,     0,   157,     0,   422,   423,   159,     0,   424,
    1743,   425,     0,     0,     0,   426,     0,   427,     0,     0,
     428,     0,   429,   430,     0,   431,   432,   433,     0,   434,
     435,   436,   437,     0,     0,   166,     0,   438,   439,   440,
       0,   168,     0,   169,     0,     0,     0,     0,   441,     0,
     442,   443,   444,   445,   446,     0,     0,   447,  2248,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   179,     0,   181,     0,   461,   462,   463,
     464,   182,     0,   465,   466,     0,     0,     0,   185,   186,
     467,   468,     0,     0,   469,     0,     0,     0,   470,   471,
       0,     0,   187,     0,     0,   190,   472,   473,   474,     0,
     191,   192,   475,   476,  1744,   477,   478,   479,   480,   481,
     482,   194,   483,     0,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,     0,   494,   200,   495,   496,   497,
     498,   499,     0,     0,   500,   501,   502,     0,   503,   203,
     504,   505,     0,   506,   206,     0,   507,   508,   509,   510,
     511,   512,   513,   514,   208,   515,     0,   516,   517,   518,
     519,     0,   209,   210,     0,   521,     0,   522,   211,   523,
     212,     0,   524,   525,   526,   527,   528,     0,  1745,   529,
     530,   531,   532,   533,     0,     0,   534,   535,   536,   219,
     537,     0,   538,     0,     0,     0,   539,   540,   541,   542,
     543,   544,     0,   221,     0,     0,   222,    79,    80,    81,
     353,     0,    83,    84,     0,    85,    86,    87,   354,     0,
     355,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   356,     0,   103,     0,   104,   105,
     106,   107,     0,     0,     0,   109,   110,   111,     0,   112,
       0,     0,     0,   357,   358,     0,     0,     0,   359,   360,
       0,     0,     0,     0,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,     0,   363,     0,   364,   365,     0,
     366,   367,   368,   369,   370,   371,   372,     0,   373,   374,
     126,   127,     0,     0,     0,     0,     0,   375,   376,   377,
       0,   378,   379,   380,     0,   132,     0,   134,     0,     0,
     381,   382,     0,   383,     0,     0,   384,   385,   135,   386,
       0,   387,   388,   389,   390,   139,     0,     0,   391,   392,
     393,     0,   394,   395,   142,   396,     0,   397,   398,     0,
     399,     0,     0,     0,     0,   400,   401,   402,   403,   404,
     148,   149,   405,     0,   406,     0,   407,     0,   408,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,   415,
     416,     0,   417,     0,   418,   419,   420,   155,   421,     0,
     157,     0,   422,   423,   159,     0,   424,     0,   425,     0,
       0,     0,   426,     0,   427,     0,     0,   428,     0,   429,
     430,     0,   431,   432,   433,     0,   434,   435,   436,   437,
       0,     0,   166,     0,   438,   439,   440,     0,   168,     0,
     169,     0,     0,     0,     0,   441,     0,   442,   443,   444,
     445,   446,     0,     0,   447,     0,     0,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     179,     0,   181,   704,   461,   462,   463,   464,   182,     0,
     465,   466,     0,     0,     0,   185,   186,   467,   468,     0,
       0,   469,   705,     0,     0,   470,   471,     0,     0,   187,
       0,     0,   190,   472,   473,   474,     0,   191,   192,   475,
     476,     0,   477,   478,   479,   480,   481,   482,   194,   483,
       0,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,     0,   494,   200,   495,   496,   497,   498,   499,     0,
       0,   500,   501,   502,     0,   503,   203,   504,   505,     0,
     506,   206,     0,   507,   508,   509,   510,   511,   512,   513,
     514,   208,   515,     0,   516,   517,   518,   519,     0,   209,
     210,     0,   521,     0,   522,   211,   523,   212,     0,   524,
     525,   526,   527,   528,     0,     0,   529,   530,   531,   532,
     533,     0,     0,   534,   535,   536,   219,   537,     0,   538,
       0,     0,     0,   539,   540,   541,   542,   543,   544,     0,
     221,     0,     0,   222,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   356,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     357,   358,     0,     0,     0,   359,   360,     0,     0,     0,
       0,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,     0,   363,     0,   364,   365,     0,   366,   367,   368,
     369,   370,   371,   372,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   375,   376,   377,     0,   378,   379,
     380,     0,   132,     0,   134,     0,     0,   381,   382,     0,
     383,     0,     0,   384,   385,   135,   386,     0,   387,   388,
     389,   390,   139,     0,     0,   391,   392,   393,     0,   394,
     395,   142,   396,     0,   397,   398,     0,   399,     0,     0,
       0,     0,   400,   401,   402,   403,   404,   148,   149,   405,
       0,   406,     0,   407,     0,   408,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,   415,   416,     0,   417,
       0,   418,   419,   420,   155,   421,     0,   157,     0,   422,
     423,   159,     0,   424,     0,   425,     0,     0,     0,   426,
       0,   427,     0,     0,   428,     0,   429,   430,     0,   431,
     432,   433,     0,   434,   435,   436,   437,     0,     0,   166,
       0,   438,   439,   440,     0,   168,     0,   169,     0,     0,
       0,     0,   441,     0,   442,   443,   444,   445,   446,     0,
       0,   447,     0,     0,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   179,     0,   181,
     704,   461,   462,   463,   464,   182,     0,   465,   466,     0,
       0,     0,   185,   186,   467,   468,     0,     0,   469,   705,
       0,   863,   470,   471,     0,     0,   187,     0,     0,   190,
     472,   473,   474,     0,   191,   192,   475,   476,     0,   477,
     478,   479,   480,   481,   482,   194,   483,     0,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,     0,   494,
     200,   495,   496,   497,   498,   499,     0,     0,   500,   501,
     502,     0,   503,   203,   504,   505,     0,   506,   206,     0,
     507,   508,   509,   510,   511,   512,   513,   514,   208,   515,
       0,   516,   517,   518,   519,     0,   209,   210,     0,   521,
       0,   522,   211,   523,   212,     0,   524,   525,   526,   527,
     528,     0,     0,   529,   530,   531,   532,   533,     0,     0,
     534,   535,   536,   219,   537,     0,   538,     0,     0,     0,
     539,   540,   541,   542,   543,   544,     0,   221,     0,     0,
     222,    79,    80,    81,   353,     0,    83,    84,     0,    85,
      86,    87,   354,     0,   355,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   356,     0,
     103,     0,   104,   105,   106,   107,     0,     0,     0,   109,
     110,   111,     0,   112,     0,     0,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,   132,
       0,   134,     0,     0,   381,   382,     0,   383,     0,     0,
     384,   385,   135,   386,     0,   387,   388,   389,   390,   139,
       0,     0,   391,   392,   393,     0,   394,   395,   142,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,  1489,   403,   404,   148,   149,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,   155,   421,     0,   157,     0,   422,   423,   159,     0,
     424,     0,   425,     0,     0,     0,  1490,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,   166,     0,   438,   439,
     440,     0,   168,     0,   169,     0,     0,     0,     0,   441,
       0,   442,   443,  1491,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   179,     0,   181,   704,   461,   462,
     463,   464,   182,     0,   465,   466,     0,     0,     0,   185,
     186,   467,   468,     0,     0,   469,   705,     0,     0,   470,
     471,     0,     0,   187,     0,     0,   190,   472,   473,   474,
       0,   191,   192,   475,   476,     0,   477,   478,   479,   480,
     481,   482,   194,   483,     0,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,     0,   494,   200,   495,   496,
    1492,   498,   499,     0,     0,   500,   501,   502,     0,   503,
     203,   504,   505,     0,   506,   206,     0,   507,   508,   509,
     510,   511,   512,   513,   514,   208,   515,  1493,  1494,   517,
     518,   519,     0,   209,   210,     0,   521,     0,   522,   211,
     523,   212,     0,   524,   525,   526,   527,   528,     0,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     219,   537,     0,   538,     0,     0,     0,   539,   540,   541,
     542,   543,   544,     0,   221,     0,     0,   222,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,     0,   357,   358,     0,     0,     0,   359,
     360,     0,     0,     0,     0,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,   363,     0,   364,   365,
       0,   366,   367,   368,   369,   370,   371,   372,     0,   373,
     374,     0,     0,     0,     0,     0,     0,     0,   375,   376,
     377,     0,   378,   379,   380,     0,   132,     0,   134,     0,
       0,   381,   382,     0,   383,     0,     0,   384,   385,   135,
     386,     0,   387,   388,   389,   390,   139,     0,     0,   391,
     392,   393,     0,   394,   395,   142,   396,     0,   397,   398,
       0,   399,     0,     0,     0,     0,   400,   401,   402,   403,
     404,   148,   149,   405,     0,   406,     0,   407,     0,   408,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
     415,   416,     0,   417,     0,   418,   419,   420,   155,   421,
       0,   157,     0,   422,   423,   159,     0,   424,     0,   425,
       0,     0,     0,   426,     0,   427,     0,     0,   428,     0,
     429,   430,     0,   431,   432,   433,     0,   434,   435,   436,
     437,     0,     0,   166,     0,   438,   439,   440,     0,   168,
       0,   169,     0,     0,     0,     0,   441,     0,   442,   443,
     444,   445,   446,     0,     0,   447,     0,     0,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   179,     0,   181,   704,   461,   462,   463,   464,   182,
       0,   465,   466,     0,     0,     0,   185,   186,   467,   468,
       0,     0,   469,   705,     0,     0,   470,   471,     0,     0,
     187,     0,     0,   190,   472,   473,   474,     0,   191,   192,
     475,   476,     0,   477,   478,   479,   480,   481,   482,   194,
     483,     0,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,     0,   494,   200,   495,   496,   497,   498,   499,
       0,     0,   500,   501,   502,     0,   503,   203,   504,   505,
       0,   506,   206,     0,   507,   508,   509,   510,   511,   512,
     513,   514,   208,   515,     0,   516,   517,   518,   519,     0,
     209,   210,     0,   521,     0,   522,   211,   523,   212,     0,
     524,   525,   526,   527,   528,     0,     0,   529,   530,   531,
     532,   533,     0,     0,   534,   535,   536,   219,   537,     0,
     538,     0,     0,     0,   539,   540,   541,   542,   543,   544,
       0,   221,     0,     0,   222,    79,    80,    81,   353,     0,
      83,    84,     0,    85,    86,    87,   354,     0,   355,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   356,     0,   103,     0,   104,   105,   106,   107,
       0,     0,     0,   109,   110,   111,     0,   112,     0,     0,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,     0,     0,     0,   375,   376,   377,     0,   378,
     379,   380,     0,   132,     0,   134,     0,     0,   381,   382,
       0,   383,     0,     0,   384,   385,   135,   386,     0,   387,
     388,   389,   390,   139,     0,     0,   391,   392,   393,     0,
     394,   395,   142,   396,     0,   397,   398,     0,   399,     0,
       0,     0,     0,   400,   401,   402,   403,   404,   148,   149,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,   415,   416,     0,
     417,     0,   418,   419,   420,   155,   421,     0,   157,     0,
     422,   423,   159,     0,   424,     0,   425,     0,   782,     0,
     426,     0,   427,     0,     0,   428,     0,   429,   430,     0,
     431,   432,   433,   783,   434,   435,   436,   437,     0,     0,
     166,     0,   438,   439,   440,     0,   168,     0,   169,     0,
       0,     0,     0,   441,     0,   442,   443,   444,   445,   446,
       0,     0,   447,     0,     0,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   179,     0,
     181,     0,   461,   462,   463,   464,   182,     0,   465,   466,
       0,     0,     0,   185,   186,   467,   468,     0,     0,   469,
       0,     0,     0,   470,   471,     0,     0,   187,     0,     0,
     190,   472,   473,   474,     0,   191,   192,   475,   476,     0,
     477,   478,   479,   480,   481,   482,   194,   483,     0,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,     0,
     494,   200,   495,   496,   497,   498,   499,     0,     0,   500,
     501,   502,     0,   503,   203,   504,   505,     0,   506,   206,
       0,   507,   508,   509,   510,   511,   512,   513,   514,   208,
     515,     0,   516,   517,   518,   519,     0,   209,   210,     0,
     521,     0,   522,   211,   523,   212,     0,   524,   525,   526,
     527,   528,     0,     0,   529,   530,   531,   532,   533,     0,
       0,   534,   535,   536,   219,   537,     0,   538,     0,     0,
       0,   539,   540,   541,   542,   543,   544,     0,   221,     0,
       0,   222,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   356,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,     0,   357,   358,
       0,     0,     0,   359,   360,     0,     0,     0,     0,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     363,     0,   364,   365,     0,   366,   367,   368,   369,   370,
     371,   372,   829,   373,   374,     0,     0,     0,     0,     0,
       0,     0,   375,   376,   377,     0,   378,   379,   380,     0,
     132,     0,   134,     0,     0,   381,   382,     0,   383,     0,
       0,   384,   385,   135,   386,     0,   387,   388,   389,   390,
     139,     0,     0,   391,   392,   393,     0,   394,   395,   142,
     396,     0,   397,   398,     0,   399,     0,     0,     0,     0,
     400,   401,   402,   403,   404,   148,   149,   405,     0,   406,
       0,   407,     0,   408,   409,   410,     0,     0,     0,   411,
     412,   413,   414,     0,   415,   416,     0,   417,     0,   418,
     419,   420,   155,   421,     0,   157,     0,   422,   423,   159,
       0,   424,     0,   425,     0,     0,     0,   426,     0,   427,
       0,     0,   428,     0,   429,   430,     0,   431,   432,   433,
       0,   434,   435,   436,   437,     0,     0,   166,     0,   438,
     439,   440,     0,   168,     0,   169,     0,     0,     0,     0,
     441,     0,   442,   443,   444,   445,   446,     0,     0,   447,
       0,     0,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   179,     0,   181,     0,   461,
     462,   463,   464,   182,     0,   465,   466,     0,     0,     0,
     185,   186,   467,   468,     0,     0,   469,     0,     0,     0,
     470,   471,     0,     0,   187,     0,     0,   190,   472,   473,
     474,     0,   191,   192,   475,   476,     0,   477,   478,   479,
     480,   481,   482,   194,   483,     0,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,     0,   494,   200,   495,
     496,   497,   498,   499,     0,     0,   500,   501,   830,     0,
     503,   203,   504,   505,     0,   506,   206,     0,   507,   508,
     509,   510,   511,   512,   513,   514,   208,   515,     0,   516,
     517,   518,   519,     0,   831,   210,     0,   521,     0,   832,
     211,   523,   212,     0,   524,   525,   526,   527,   528,     0,
       0,   529,   530,   531,   532,   533,     0,     0,   534,   535,
     536,   219,   537,     0,   538,     0,     0,     0,   539,   540,
     541,   542,   543,   544,     0,   221,     0,     0,   222,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,     0,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   356,     0,   103,     0,
     104,   105,   106,   107,     0,     0,     0,   109,   110,   111,
       0,   112,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,   852,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,   132,     0,   134,
       0,     0,   381,   382,     0,   383,     0,     0,   384,   385,
     135,   386,     0,   387,   388,   389,   390,   139,     0,     0,
     391,   392,   393,     0,   394,   395,   142,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,   148,   149,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   155,
     421,     0,   157,     0,   422,   423,   159,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,   166,     0,   438,   439,   440,     0,
     168,     0,   169,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   179,     0,   181,     0,   461,   462,   463,   464,
     182,     0,   465,   466,     0,     0,     0,   185,   186,   467,
     468,     0,     0,   469,     0,     0,     0,   470,   471,     0,
       0,   187,     0,     0,   190,   472,   473,   474,     0,   191,
     192,   475,   476,     0,   477,   478,   479,   480,   481,   482,
     194,   483,     0,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,     0,   494,   200,   495,   496,   497,   498,
     499,     0,     0,   500,   501,   853,     0,   503,   203,   504,
     505,     0,   506,   206,     0,   507,   508,   509,   510,   511,
     512,   513,   514,   208,   515,     0,   516,   517,   518,   519,
       0,   854,   210,     0,   521,     0,   855,   211,   523,   212,
       0,   524,   525,   526,   527,   528,     0,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   219,   537,
       0,   538,     0,     0,     0,   539,   540,   541,   542,   543,
     544,     0,   221,     0,     0,   222,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   357,   358,     0,     0,     0,   359,   360,     0,
       0,     0,     0,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,   363,     0,   364,   365,     0,   366,
     367,   368,   369,   370,   371,   372,  1207,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   375,   376,   377,     0,
     378,   379,   380,     0,   132,     0,   134,     0,     0,   381,
     382,     0,   383,     0,     0,   384,   385,   135,   386,     0,
     387,   388,   389,   390,   139,     0,     0,   391,   392,   393,
       0,   394,   395,   142,   396,     0,   397,   398,     0,   399,
       0,     0,     0,     0,   400,   401,   402,   403,   404,   148,
     149,   405,     0,   406,     0,   407,     0,   408,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,   415,   416,
       0,   417,     0,   418,   419,   420,   155,   421,     0,   157,
       0,   422,   423,   159,     0,   424,     0,   425,     0,     0,
       0,   426,     0,   427,     0,     0,   428,     0,   429,   430,
       0,   431,   432,   433,     0,   434,   435,   436,   437,     0,
       0,   166,     0,   438,   439,   440,     0,   168,     0,   169,
       0,     0,     0,     0,   441,     0,   442,   443,   444,   445,
     446,     0,     0,   447,     0,     0,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   179,
       0,   181,     0,   461,   462,   463,   464,   182,     0,   465,
     466,     0,     0,     0,   185,   186,   467,   468,     0,     0,
     469,     0,     0,     0,   470,   471,     0,     0,   187,     0,
       0,   190,   472,   473,   474,     0,   191,   192,   475,   476,
       0,   477,   478,   479,   480,   481,   482,   194,   483,     0,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
       0,   494,   200,   495,   496,   497,   498,   499,     0,     0,
     500,   501,   502,     0,   503,   203,   504,   505,     0,   506,
     206,     0,   507,   508,   509,   510,   511,   512,   513,   514,
     208,   515,     0,   516,   517,   518,   519,     0,   209,   210,
       0,   521,     0,   522,   211,   523,   212,     0,   524,   525,
     526,   527,   528,     0,     0,   529,   530,   531,   532,   533,
       0,     0,   534,   535,   536,   219,   537,     0,   538,     0,
       0,     0,   539,   540,   541,   542,   543,   544,     0,   221,
       0,     0,   222,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     356,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,  1216,   378,   379,   380,
       0,   132,     0,   134,     0,     0,   381,   382,     0,   383,
       0,     0,   384,   385,   135,  1217,     0,   387,   388,   389,
     390,   139,     0,     0,   391,   392,   393,     0,   394,   395,
     142,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   148,   149,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   155,   421,     0,   157,     0,   422,   423,
     159,     0,   424,     0,   425,     0,     0,     0,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   431,   432,
     433,     0,   434,   435,   436,   437,     0,     0,   166,     0,
     438,   439,   440,     0,   168,     0,   169,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   845,   179,     0,   181,     0,
     461,   462,   463,   464,   182,     0,   465,   466,     0,     0,
       0,   185,   186,   467,   468,     0,     0,   469,     0,     0,
       0,   470,   471,     0,     0,   187,     0,     0,   190,   472,
     473,   474,     0,   191,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,   194,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,     0,   494,   200,
     495,   496,   497,   498,   499,     0,     0,   500,   501,  1211,
       0,   503,   203,   504,   505,     0,   506,   206,     0,   507,
     508,   509,   510,   511,   512,   513,   514,   208,   515,     0,
     516,   517,   518,   519,     0,   847,   210,     0,   521,     0,
     848,   211,   523,   212,     0,   524,   525,   526,   527,   528,
       0,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   219,   537,     0,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,     0,     0,   222,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
       0,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     375,   376,   377,     0,   378,   379,   380,     0,   132,     0,
     134,     0,     0,   381,   382,     0,   383,     0,     0,   384,
     385,   135,   386,     0,   387,   388,   389,   390,   139,     0,
       0,   391,   392,   393,     0,   394,   395,   142,   396,     0,
     397,   398,     0,   399,     0,     0,     0,     0,   400,   401,
     402,   403,   404,   148,   149,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
     155,   421,     0,   157,     0,   422,   423,   159,     0,   424,
       0,   425,     0,     0,     0,   426,     0,   427,     0,  2290,
     428,     0,   429,   430,     0,   431,   432,   433,     0,   434,
     435,   436,   437,     0,     0,   166,     0,   438,   439,   440,
       0,   168,     0,   169,     0,     0,     0,     0,   441,     0,
     442,   443,   444,   445,   446,     0,     0,   447,     0,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   179,     0,   181,     0,   461,   462,   463,
     464,   182,     0,   465,   466,     0,     0,     0,   185,   186,
     467,   468,     0,     0,   469,     0,     0,     0,   470,   471,
       0,     0,   187,     0,     0,   190,   472,   473,   474,     0,
     191,   192,   475,   476,     0,   477,   478,   479,   480,   481,
     482,   194,   483,     0,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,     0,   494,   200,   495,   496,   497,
     498,   499,     0,     0,   500,   501,   502,     0,   503,   203,
     504,   505,     0,   506,   206,     0,   507,   508,   509,   510,
     511,   512,   513,   514,   208,   515,     0,   516,   517,   518,
     519,     0,   209,   210,     0,   521,     0,   522,   211,   523,
     212,     0,   524,   525,   526,   527,   528,     0,     0,   529,
     530,   531,   532,   533,     0,     0,   534,   535,   536,   219,
     537,     0,   538,     0,     0,     0,   539,   540,   541,   542,
     543,   544,     0,   221,     0,     0,   222,    79,    80,    81,
     353,     0,    83,    84,     0,    85,    86,    87,   354,     0,
     355,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   356,     0,   103,     0,   104,   105,
     106,   107,     0,     0,     0,   109,   110,   111,     0,   112,
       0,     0,     0,   357,   358,     0,     0,     0,   359,   360,
       0,     0,     0,     0,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,     0,   363,     0,   364,   365,     0,
     366,   367,   368,   369,   370,   371,   372,     0,   373,   374,
       0,     0,     0,     0,     0,     0,     0,   375,   376,   377,
       0,   378,   379,   380,     0,   132,     0,   134,     0,     0,
     381,   382,     0,   383,     0,     0,   384,   385,   135,   386,
       0,   387,   388,   389,   390,   139,     0,     0,   391,   392,
     393,     0,   394,   395,   142,   396,     0,   397,   398,     0,
     399,     0,     0,     0,     0,   400,   401,   402,   403,   404,
     148,   149,   405,  2544,   406,     0,   407,     0,   408,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,   415,
     416,     0,   417,     0,   418,   419,   420,   155,   421,     0,
     157,     0,   422,   423,   159,     0,   424,     0,   425,     0,
       0,     0,   426,     0,   427,     0,     0,   428,     0,   429,
     430,     0,   431,   432,   433,     0,   434,   435,   436,   437,
       0,     0,   166,     0,   438,   439,   440,     0,   168,     0,
     169,     0,     0,     0,     0,   441,     0,   442,   443,   444,
     445,   446,     0,     0,   447,     0,     0,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     179,     0,   181,     0,   461,   462,   463,   464,   182,     0,
     465,   466,     0,     0,     0,   185,   186,   467,   468,     0,
       0,   469,     0,     0,     0,   470,   471,     0,     0,   187,
       0,     0,   190,   472,   473,   474,     0,   191,   192,   475,
     476,     0,   477,   478,   479,   480,   481,   482,   194,   483,
       0,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,     0,   494,   200,   495,   496,   497,   498,   499,     0,
       0,   500,   501,   502,     0,   503,   203,   504,   505,     0,
     506,   206,     0,   507,   508,   509,   510,   511,   512,   513,
     514,   208,   515,     0,   516,   517,   518,   519,     0,   209,
     210,     0,   521,     0,   522,   211,   523,   212,     0,   524,
     525,   526,   527,   528,     0,     0,   529,   530,   531,   532,
     533,     0,     0,   534,   535,   536,   219,   537,     0,   538,
       0,     0,     0,   539,   540,   541,   542,   543,   544,     0,
     221,     0,     0,   222,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   356,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     357,   358,     0,     0,     0,   359,   360,     0,     0,     0,
       0,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,     0,   363,     0,   364,   365,     0,   366,   367,   368,
     369,   370,   371,   372,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   375,   376,   377,     0,   378,   379,
     380,     0,   132,     0,   134,     0,     0,   381,   382,     0,
     383,     0,     0,   384,   385,   135,   386,     0,   387,   388,
     389,   390,   139,     0,     0,   391,   392,   393,     0,   394,
     395,   142,   396,     0,   397,   398,     0,   399,     0,     0,
       0,     0,   400,   401,   402,   403,   404,   148,   149,   405,
    2546,   406,     0,   407,     0,   408,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,   415,   416,     0,   417,
       0,   418,   419,   420,   155,   421,     0,   157,     0,   422,
     423,   159,     0,   424,     0,   425,     0,     0,     0,   426,
       0,   427,     0,     0,   428,     0,   429,   430,     0,   431,
     432,   433,     0,   434,   435,   436,   437,     0,     0,   166,
       0,   438,   439,   440,     0,   168,     0,   169,     0,     0,
       0,     0,   441,     0,   442,   443,   444,   445,   446,     0,
       0,   447,     0,     0,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   179,     0,   181,
       0,   461,   462,   463,   464,   182,     0,   465,   466,     0,
       0,     0,   185,   186,   467,   468,     0,     0,   469,     0,
       0,     0,   470,   471,     0,     0,   187,     0,     0,   190,
     472,   473,   474,     0,   191,   192,   475,   476,     0,   477,
     478,   479,   480,   481,   482,   194,   483,     0,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,     0,   494,
     200,   495,   496,   497,   498,   499,     0,     0,   500,   501,
     502,     0,   503,   203,   504,   505,     0,   506,   206,     0,
     507,   508,   509,   510,   511,   512,   513,   514,   208,   515,
       0,   516,   517,   518,   519,     0,   209,   210,     0,   521,
       0,   522,   211,   523,   212,     0,   524,   525,   526,   527,
     528,     0,     0,   529,   530,   531,   532,   533,     0,     0,
     534,   535,   536,   219,   537,     0,   538,     0,     0,     0,
     539,   540,   541,   542,   543,   544,     0,   221,     0,     0,
     222,    79,    80,    81,   353,     0,    83,    84,     0,    85,
      86,    87,   354,     0,   355,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   356,     0,
     103,     0,   104,   105,   106,   107,     0,     0,     0,   109,
     110,   111,     0,   112,     0,     0,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,   132,
       0,   134,     0,     0,   381,   382,     0,   383,     0,     0,
     384,   385,   135,   386,     0,   387,   388,   389,   390,   139,
       0,     0,   391,   392,   393,     0,   394,   395,   142,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,   148,   149,   405,  2548,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,   155,   421,     0,   157,     0,   422,   423,   159,     0,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,   166,     0,   438,   439,
     440,     0,   168,     0,   169,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   179,     0,   181,     0,   461,   462,
     463,   464,   182,     0,   465,   466,     0,     0,     0,   185,
     186,   467,   468,     0,     0,   469,     0,     0,     0,   470,
     471,     0,     0,   187,     0,     0,   190,   472,   473,   474,
       0,   191,   192,   475,   476,     0,   477,   478,   479,   480,
     481,   482,   194,   483,     0,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,     0,   494,   200,   495,   496,
     497,   498,   499,     0,     0,   500,   501,   502,     0,   503,
     203,   504,   505,     0,   506,   206,     0,   507,   508,   509,
     510,   511,   512,   513,   514,   208,   515,     0,   516,   517,
     518,   519,     0,   209,   210,     0,   521,     0,   522,   211,
     523,   212,     0,   524,   525,   526,   527,   528,     0,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     219,   537,     0,   538,     0,     0,     0,   539,   540,   541,
     542,   543,   544,     0,   221,     0,     0,   222,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,     0,   357,   358,     0,     0,     0,   359,
     360,     0,     0,     0,     0,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,   363,     0,   364,   365,
       0,   366,   367,   368,   369,   370,   371,   372,     0,   373,
     374,     0,     0,     0,     0,     0,  2681,     0,   375,   376,
     377,     0,   378,   379,   380,     0,   132,     0,   134,     0,
       0,   381,   382,     0,   383,     0,     0,   384,   385,   135,
     386,     0,   387,   388,   389,   390,   139,     0,     0,   391,
     392,   393,     0,   394,   395,   142,   396,     0,   397,   398,
       0,   399,     0,     0,     0,     0,   400,   401,   402,   403,
     404,   148,   149,   405,     0,   406,     0,   407,     0,   408,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
     415,   416,     0,   417,     0,   418,   419,   420,   155,   421,
       0,   157,     0,   422,   423,   159,     0,   424,     0,   425,
       0,     0,     0,   426,     0,   427,     0,     0,   428,     0,
     429,   430,     0,   431,   432,   433,     0,   434,   435,   436,
     437,     0,     0,   166,     0,   438,   439,   440,     0,   168,
       0,   169,     0,     0,     0,     0,   441,     0,   442,   443,
     444,   445,   446,     0,     0,   447,     0,     0,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   179,     0,   181,     0,   461,   462,   463,   464,   182,
       0,   465,   466,     0,     0,     0,   185,   186,   467,   468,
       0,     0,   469,     0,     0,     0,   470,   471,     0,     0,
     187,     0,     0,   190,   472,   473,   474,     0,   191,   192,
     475,   476,     0,   477,   478,   479,   480,   481,   482,   194,
     483,     0,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,     0,   494,   200,   495,   496,   497,   498,   499,
       0,     0,   500,   501,   502,     0,   503,   203,   504,   505,
       0,   506,   206,     0,   507,   508,   509,   510,   511,   512,
     513,   514,   208,   515,     0,   516,   517,   518,   519,     0,
     209,   210,     0,   521,     0,   522,   211,   523,   212,     0,
     524,   525,   526,   527,   528,     0,     0,   529,   530,   531,
     532,   533,     0,     0,   534,   535,   536,   219,   537,     0,
     538,     0,     0,     0,   539,   540,   541,   542,   543,   544,
       0,   221,     0,     0,   222,    79,    80,    81,   353,     0,
      83,    84,     0,    85,    86,    87,   354,     0,   355,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   356,     0,   103,     0,   104,   105,   106,   107,
       0,     0,     0,   109,   110,   111,     0,   112,     0,     0,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,     0,  2695,     0,   375,   376,   377,     0,   378,
     379,   380,     0,   132,     0,   134,     0,     0,   381,   382,
       0,   383,     0,     0,   384,   385,   135,   386,     0,   387,
     388,   389,   390,   139,     0,     0,   391,   392,   393,     0,
     394,   395,   142,   396,     0,   397,   398,     0,   399,     0,
       0,     0,     0,   400,   401,   402,   403,   404,   148,   149,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,   415,   416,     0,
     417,     0,   418,   419,   420,   155,   421,     0,   157,     0,
     422,   423,   159,     0,   424,     0,   425,     0,     0,     0,
     426,     0,   427,     0,     0,   428,     0,   429,   430,     0,
     431,   432,   433,     0,   434,   435,   436,   437,     0,     0,
     166,     0,   438,   439,   440,     0,   168,     0,   169,     0,
       0,     0,     0,   441,     0,   442,   443,   444,   445,   446,
       0,     0,   447,     0,     0,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   179,     0,
     181,     0,   461,   462,   463,   464,   182,     0,   465,   466,
       0,     0,     0,   185,   186,   467,   468,     0,     0,   469,
       0,     0,     0,   470,   471,     0,     0,   187,     0,     0,
     190,   472,   473,   474,     0,   191,   192,   475,   476,     0,
     477,   478,   479,   480,   481,   482,   194,   483,     0,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,     0,
     494,   200,   495,   496,   497,   498,   499,     0,     0,   500,
     501,   502,     0,   503,   203,   504,   505,     0,   506,   206,
       0,   507,   508,   509,   510,   511,   512,   513,   514,   208,
     515,     0,   516,   517,   518,   519,     0,   209,   210,     0,
     521,     0,   522,   211,   523,   212,     0,   524,   525,   526,
     527,   528,     0,     0,   529,   530,   531,   532,   533,     0,
       0,   534,   535,   536,   219,   537,     0,   538,     0,     0,
       0,   539,   540,   541,   542,   543,   544,     0,   221,     0,
       0,   222,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   356,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,     0,   357,   358,
       0,     0,     0,   359,   360,     0,     0,     0,     0,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     363,     0,   364,   365,     0,   366,   367,   368,   369,   370,
     371,   372,     0,   373,   374,     0,     0,     0,     0,     0,
       0,     0,   375,   376,   377,     0,   378,   379,   380,     0,
     132,     0,   134,     0,     0,   381,   382,     0,   383,     0,
       0,   384,   385,   135,   386,     0,   387,   388,   389,   390,
     139,     0,     0,   391,   392,   393,     0,   394,   395,   142,
     396,     0,   397,   398,     0,   399,     0,     0,     0,     0,
     400,   401,   402,   403,   404,   148,   149,   405,     0,   406,
       0,   407,     0,   408,   409,   410,     0,     0,     0,   411,
     412,   413,   414,     0,   415,   416,     0,   417,     0,   418,
     419,   420,   155,   421,     0,   157,     0,   422,   423,   159,
       0,   424,     0,   425,     0,     0,     0,   426,     0,   427,
       0,     0,   428,     0,   429,   430,     0,   431,   432,   433,
       0,   434,   435,   436,   437,     0,     0,   166,     0,   438,
     439,   440,     0,   168,     0,   169,     0,     0,     0,     0,
     441,     0,   442,   443,   444,   445,   446,     0,     0,   447,
       0,     0,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   179,     0,   181,     0,   461,
     462,   463,   464,   182,     0,   465,   466,     0,     0,     0,
     185,   186,   467,   468,     0,     0,   469,     0,     0,     0,
     470,   471,     0,     0,   187,     0,     0,   190,   472,   473,
     474,     0,   191,   192,   475,   476,     0,   477,   478,   479,
     480,   481,   482,   194,   483,     0,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,     0,   494,   200,   495,
     496,   497,   498,   499,     0,     0,   500,   501,   502,     0,
     503,   203,   504,   505,     0,   506,   206,     0,   507,   508,
     509,   510,   511,   512,   513,   514,   208,   515,     0,   516,
     517,   518,   519,     0,   209,   210,     0,   521,     0,   522,
     211,   523,   212,     0,   524,   525,   526,   527,   528,     0,
       0,   529,   530,   531,   532,   533,     0,  3016,   534,   535,
     536,   219,   537,     0,   538,     0,     0,     0,   539,   540,
     541,   542,   543,   544,     0,   221,     0,     0,   222,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,     0,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   356,     0,   103,     0,
     104,   105,   106,   107,     0,     0,     0,   109,   110,   111,
       0,   112,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,   132,     0,   134,
       0,     0,   381,   382,     0,   383,     0,     0,   384,   385,
     135,   386,     0,   387,   388,   389,   390,   139,     0,     0,
     391,   392,   393,     0,   394,   395,   142,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,   148,   149,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   155,
     421,     0,   157,     0,   422,   423,   159,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,   166,     0,   438,   439,   440,     0,
     168,     0,   169,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   179,     0,   181,     0,   461,   462,   463,   464,
     182,     0,   465,   466,     0,     0,     0,   185,   186,   467,
     468,     0,     0,   469,     0,     0,     0,   470,   471,     0,
       0,   187,     0,     0,   190,   472,   473,   474,     0,   191,
     192,   475,   476,     0,   477,   478,   479,   480,   481,   482,
     194,   483,     0,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,     0,   494,   200,   495,   496,   497,   498,
     499,     0,     0,   500,   501,   502,     0,   503,   203,   504,
     505,     0,   506,   206,     0,   507,   508,   509,   510,   511,
     512,   513,   514,   208,   515,     0,   516,   517,   518,   519,
       0,   209,   210,     0,   521,     0,   522,   211,   523,   212,
       0,   524,   525,   526,   527,   528,     0,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   219,   537,
       0,   538,     0,     0,     0,   539,   540,   541,   542,   543,
     544,     0,   221,     0,     0,   222,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   357,   358,     0,     0,     0,   359,   360,     0,
       0,     0,     0,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,   363,     0,   364,   365,     0,   366,
     367,   368,   369,   370,   371,   372,     0,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   375,   376,   377,     0,
     378,   379,   380,     0,   132,     0,   134,     0,     0,   381,
     382,     0,   383,     0,     0,   384,   385,   135,   386,     0,
     387,   388,   389,   390,   139,     0,     0,   391,   392,   393,
       0,   394,   395,   142,   396,     0,   397,   398,     0,   399,
       0,     0,     0,     0,   400,   401,   402,   403,   404,   148,
     149,   405,     0,   406,     0,   407,     0,   408,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,   415,   416,
       0,   417,     0,   418,   419,   420,   155,   421,     0,   157,
       0,   422,   423,   159,     0,   424,     0,   425,     0,     0,
       0,   426,     0,   427,     0,     0,   428,     0,   429,   430,
       0,   431,   432,   433,     0,   434,   435,   436,   437,     0,
       0,   166,     0,   438,   439,   440,     0,   168,     0,   169,
       0,     0,     0,     0,   441,     0,   442,   443,   444,   445,
     446,     0,     0,   447,     0,     0,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   179,
       0,   181,     0,   461,   462,   463,   464,   182,     0,   465,
     466,     0,     0,     0,   185,   186,   467,   468,     0,     0,
     469,     0,     0,     0,   470,   471,     0,     0,   187,     0,
       0,   190,   472,   473,   474,     0,   191,   192,   475,   476,
       0,   477,   478,   479,   480,   481,   482,   194,   483,     0,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
       0,   494,   200,   495,   496,   497,   498,   499,     0,     0,
     500,   501,   502,     0,   503,   203,   504,   505,     0,   506,
     206,     0,   507,   508,   747,   510,   511,   512,   513,   514,
     208,   515,     0,   516,   517,   518,   519,     0,   209,   210,
       0,   521,     0,   522,   211,   523,   212,     0,   524,   525,
     526,   527,   528,     0,     0,   529,   530,   531,   532,   533,
       0,     0,   534,   535,   536,   219,   537,     0,   538,     0,
       0,     0,   539,   540,   541,   542,   543,   544,     0,   221,
       0,     0,   222,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     356,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,     0,   378,   379,   380,
       0,   132,     0,   134,     0,     0,   381,   382,     0,   383,
       0,     0,   384,   385,   135,   386,     0,   387,   388,   389,
     390,   139,     0,     0,   391,   392,   393,     0,   394,   395,
     142,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   148,   149,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   155,   421,     0,   157,     0,   422,   423,
     159,     0,   424,     0,   425,     0,     0,     0,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   431,   432,
     433,     0,   434,   435,   436,   437,     0,     0,   166,     0,
     438,   439,   440,     0,   168,     0,   169,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   845,   179,     0,   181,     0,
     461,   462,   463,   464,   182,     0,   465,   466,     0,     0,
       0,   185,   186,   467,   468,     0,     0,   469,     0,     0,
       0,   470,   471,     0,     0,   187,     0,     0,   190,   472,
     473,   474,     0,   191,   192,   475,   476,     0,   477,   478,
     479,   480,   481,   482,   194,   483,     0,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,     0,   494,   200,
     495,   496,   497,   498,   499,     0,     0,   500,   501,  1211,
       0,   503,   203,   504,   505,     0,   506,   206,     0,   507,
     508,   509,   510,   511,   512,   513,   514,   208,   515,     0,
     516,   517,   518,   519,     0,   847,   210,     0,   521,     0,
     848,   211,   523,   212,     0,   524,   525,   526,   527,   528,
       0,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   219,   537,     0,   538,     0,     0,     0,   539,
     540,   541,   542,   543,   544,     0,   221,     0,     0,   222,
    1309,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
       0,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     375,   376,   377,     0,   378,   379,   380,     0,   132,     0,
     134,     0,     0,   381,   382,     0,   383,     0,     0,   384,
     385,   135,   386,     0,   387,   388,   389,   390,   139,     0,
       0,   391,   392,   393,     0,   394,   395,   142,   396,     0,
     397,   398,     0,   399,     0,     0,     0,     0,   400,   401,
     402,   403,   404,   148,   149,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
     155,   421,     0,   157,     0,   422,   423,   159,     0,   424,
       0,   425,     0,     0,     0,   426,     0,   427,     0,     0,
     428,     0,   429,   430,     0,   431,   432,   433,     0,   434,
     435,   436,   437,     0,     0,   166,     0,   438,   439,   440,
       0,   168,     0,   169,     0,     0,     0,     0,   441,     0,
     442,   443,   444,   445,   446,     0,     0,   447,     0,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   179,     0,   181,     0,   461,   462,   463,
     464,   182,     0,   465,   466,     0,     0,     0,   185,   186,
     467,   468,     0,     0,   469,     0,     0,     0,   470,   471,
       0,     0,   187,     0,     0,   190,   472,   473,   474,     0,
     191,   192,   475,   476,     0,   477,   478,   479,   480,   481,
     482,   194,   483,     0,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,     0,   494,   200,   495,   496,   497,
     498,   499,     0,     0,   500,   501,   502,     0,   503,   203,
     504,   505,     0,   506,   206,     0,   507,   508,   509,   510,
     511,   512,   513,   514,   208,   515,     0,   516,   517,   518,
     519,     0,   209,   210,     0,   521,     0,   522,   211,   523,
     212,     0,   524,   525,   526,   527,   528,     0,     0,   529,
     530,   531,   532,   533,     0,     0,   534,   535,   536,   219,
     537,     0,   538,     0,     0,     0,   539,   540,   541,   542,
     543,   544,     0,   221,     0,     0,   222,    79,    80,    81,
       0,     0,    83,    84,     0,    85,    86,    87,     0,     0,
       0,    90,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,     0,     0,   103,     0,   104,   105,
     106,   107,     0,   108,     0,   109,   110,   111, -1288,   112,
     113,   114,     0,     0,     0,     0,     0,     0,   117,   118,
       0,     0,     0,     0,   119,     0,     0,     0,     0,     0,
       0,     0,     0,   120,     0,   121,     0,   122,   123,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     129,     0,     0,     0,   131,   132,   133,   134,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   135,     0,
       0,     0,     0,     0,     0,   139,     0,     0,     0,     0,
       0,     0,     0,     0,   142,     0,     0,     0,     0,   145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     148,   149,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   155,     0,     0,
     157,     0,     0,     0,   159,     0,     0,     0,     0,   160,
       0,   161,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   164,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   165,   166,     0,     0,     0,     0,     0,   168,     0,
     169,     0,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,     0,   173,     0,   174,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,     0,     0,   182,     0,
       0,     0,   184,     0,     0,   185,   186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   187,
     188,   189,   190,     0,     0,     0,     0,   191,   192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   194,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   198,     0,   200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   203,     0,     0,   205,
       0,   206,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   208,     0,     0,     0,     0,     0,     0,     0,   209,
     210,     0,     0,     0,     0,   211,     0,   212,     0,     0,
       0,     0,     0,     0,   215,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,     0,     0,     0,     0,    79,    80,    81,     0,
     221,    83,    84,   222,    85,    86,    87,     0,     0,     0,
      90,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,     0,     0,   103,     0,   104,   105,   106,
     107,     0,   108,     0,   109,   110,   111, -1289,   112,   113,
     114,     0,     0,     0,     0,     0,     0,   117,   118,     0,
       0,     0,     0,   119,     0,     0,     0,     0,     0,     0,
       0,     0,   120,     0,   121,     0,   122,   123,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   129,
       0,     0,     0,   131,   132,   133,   134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   135,     0,     0,
       0,     0,     0,     0,   139,     0,     0,     0,     0,     0,
       0,     0,     0,   142,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   148,
     149,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,     0,     0,   157,
       0,     0,     0,   159,     0,     0,     0,     0,   160,     0,
     161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     165,   166,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,     0,   173,     0,   174,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,     0,     0,   182,     0,     0,
       0,   184,     0,     0,   185,   186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   187,   188,
     189,   190,     0,     0,     0,     0,   191,   192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     198,     0,   200,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   203,     0,     0,   205,     0,
     206,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     208,     0,     0,     0,     0,     0,     0,     0,   209,   210,
       0,     0,     0,     0,   211,     0,   212,     0,     0,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,     0,    79,    80,    81,     0,   221,
      83,    84,   222,    85,    86,    87,     0,     0,     0,    90,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,     0,     0,   103,     0,   104,   105,   106,   107,
       0,   108,     0,   109,   110,   111,     0,   112,   113,   114,
       0,     0,     0,     0,     0,     0,   117,   118,     0,     0,
       0,     0,   119,     0,     0,     0,     0,     0,     0,     0,
       0,   120,     0,   121,     0,   122,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   129,     0,
       0,     0,   131,   132,   133,   134,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   135,     0,     0,     0,
       0,     0,     0,   139,     0,     0,     0,     0,     0,     0,
       0,     0,   142,     0,     0,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   148,   149,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   155,     0,     0,   157,     0,
       0,     0,   159,     0,     0,     0,     0,   160,     0,   161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   164,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   165,
     166,     0,     0,     0,     0,     0,   168,     0,   169,     0,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
       0,   173,     0,   174,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   179,   180,
     181,     0,     0,     0,     0,     0,   182,     0,     0,     0,
     184,     0,     0,   185,   186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   187,   188,   189,
     190,     0,     0,     0,     0,   191,   192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   198,
       0,   200,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   203,     0,     0,   205,     0,   206,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   208,
       0,     0,     0,     0,     0,     0,     0,   209,   210,     0,
       0,     0,     0,   211,     0,   212,     0,     0,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
       0,     0,     0,     0,    79,    80,    81,     0,   221,    83,
      84,   222,    85,    86,    87,     0,     0,     0,    90,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,     0,     0,   103,     0,   104,   105,   106,   107,     0,
     108,     0,   109,   110,   111,     0,   112,   113,   114,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   129,     0,     0,
       0,   131,   132,   133,   134,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   135,     0,     0,     0,     0,
       0,     0,   139,     0,     0,     0,     0,     0,     0,     0,
       0,   142,     0,     0,     0,     0,   145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   148,   149,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,     0,     0,   157,     0,     0,
       0,   159,     0,     0,     0,     0,   160,     0,   161,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   164,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   165,   166,
       0,     0,     0,     0,     0,   168,     0,   169,     0,     0,
     170,   171,     0,   172,     0,     0,     0,     0,     0,     0,
     173,     0,   174,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   179,   180,   181,
       0,     0,     0,     0,     0,   182,     0,     0,     0,   184,
       0,     0,   185,   186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   187,   188,   189,   190,
       0,     0,     0,     0,   191,   192,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   194,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   198,     0,
     200,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   203,     0,     0,   205,     0,   206,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   208,     0,
       0,     0,     0,     0,     0,     0,   209,   210,     0,     0,
       0,     0,   211,     0,   212,     0,     0,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   219,     0,   220,    79,    80,    81,     0,
       0,    83,    84,     0,    85,    86,    87,   221,     0,     0,
     222,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,     0,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   129,
       0,     0,     0,   131,   132,   133,   134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   135,     0,     0,
       0,     0,     0,     0,   139,     0,     0,     0,     0,     0,
       0,     0,     0,   142,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   148,
     149,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,     0,     0,   157,
       0,     0,     0,   159,     0,     0,     0,     0,   160,     0,
     161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     165,   166,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,     0,   173,     0,   174,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,     0,     0,   182,     0,     0,
       0,   184,     0,     0,   185,   186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   187,   188,
     189,   190,     0,     0,     0,     0,   191,   192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     198,     0,   200,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   203,     0,     0,   205,     0,
     206,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     208,     0,     0,     0,     0,     0,     0,     0,   209,   210,
       0,     0,     0,     0,   211,     0,   212,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   221,
       0,     0,   222
};

static const short yycheck[] =
{
       2,    74,    82,    74,   223,   692,    90,   154,    74,  1059,
       2,    77,   820,   158,   686,   843,   688,  1034,   147,   999,
      90,  1161,  1459,  1040,    90,   154,   698,   963,    77,   113,
    1338,   967,    90,   178,   213,  1413,   677,   954,   725,    74,
      74,   685,    90,   113,   935,   689,   193,   113,  1145,   721,
     687,   688,    90,  1863,  1441,   113,   128,   848,  1295,  1895,
     742,   733,   217,  1457,   193,   113,    74,  1623,    74,  1463,
      74,   715,   759,   902,   146,   113,  1515,   935,  2288,  1689,
    2051,  1662,   719,  1780,  1781,  2118,  2243,   776,  1865,  1865,
    1074,  1865,  1865,  1550,    26,  2407,   176,  1760,  1865,   771,
    1829,  2072,  1865,   844,    25,   846,   750,  2412,  2413,  1763,
    1764,  1455,   756,    51,  1724,   797,   910,   754,  1728,    43,
     930,   841,  1112,  1113,  1074,  1582,   935,    43,   117,    94,
      78,   215,   918,   919,  1084,  1085,   112,   112,    94,    78,
    1121,  1131,   679,    77,  2360,   215,    93,  2770,    93,   215,
     223,   224,   657,   224,   167,   152,   158,   215,   126,    98,
     842,   151,   119,  2910,     2,    74,   220,   215,    77,   126,
      78,    74,     8,   130,    77,    29,   178,   215,    14,    15,
      16,    90,    78,   282,    99,   204,   189,    90,   189,   129,
      26,    27,    28,   152,    30,    31,    32,    83,   267,  1577,
     173,    37,    38,    39,   113,   220,  1860,  1582,    81,    86,
     113,    93,   191,   130,   113,    92,   224,   269,   224,   119,
     224,   157,  1358,   352,   157,   154,    78,    87,  1838,   186,
     130,  1181,   123,   220,   298,   152,  2861,    78,  2863,   224,
    1548,    78,   319,   309,    82,   135,    98,     0,    78,   119,
     152,    89,    86,    86,   135,   302,   350,    12,   305,    92,
     130,    98,    93,    86,   190,   343,  1183,   312,    98,    92,
     296,    44,   258,    46,   309,   309,    84,   324,   214,   165,
     346,    93,   152,   349,   154,   112,   186,   156,   152,   174,
     128,   964,   382,   101,   159,   274,    51,   346,   220,   971,
     173,    18,  1438,  1400,   194,   383,   215,   401,   146,   295,
     220,   296,   215,   194,   349,   349,   215,   416,    86,   992,
     205,  1371,   319,   368,  1011,   220,   222,   161,  1219,   258,
     420,   307,   307,   290,  1314,   382,   117,   414,   176,   209,
      83,   258,   368,  2968,   220,   414,  1927,   350,    93,    78,
     414,   117,   221,   326,  2190,   215,   371,   283,  1002,   338,
      29,  1033,   216,   353,  1008,  1024,   420,   380,   420,   690,
     222,   223,  2684,  1045,  1514,  1515,  2688,   374,   699,   270,
    2692,   222,   350,  3130,   371,  1525,  1526,  1824,   258,  1061,
     290,    78,   222,   263,   384,  1445,  1386,  1387,  1057,  1316,
     309,   420,   723,  1047,  1394,    78,   309,   364,  1389,   261,
    2626,  1551,   346,  1553,   735,   952,  1997,   414,  3041,   420,
     290,   361,   165,   928,  2212,   414,   382,   383,   343,   299,
    1366,   390,   368,   274,   393,   368,   757,   346,   324,   312,
     349,  2474,  2475,   346,   420,   420,   349,   768,   520,   414,
     371,   287,   220,   326,   331,   393,  1250,  2067,   417,  2188,
    2189,   393,   410,  2126,   364,   412,   390,   412,  2197,   393,
    1279,   410,  1612,   135,   398,  1819,   400,   393,  1272,  1415,
     307,  1291,   406,  1203,  1204,   258,  1470,   408,   390,  2070,
    1276,   393,    86,   222,   364,   417,   398,    78,   331,   407,
     408,   409,   410,  1897,  1898,  2061,   371,   417,   331,   405,
     406,   407,   408,   409,   410,  1972,  1973,  1974,   272,  1469,
    1977,   119,   417,  2177,   360,   415,   390,   417,  1478,   393,
     412,   146,   194,   415,   416,   222,   173,   191,   420,  2851,
     695,   417,  2847,  1372,  2856,   274,  1235,   216,  2860,   222,
     391,  1541,  1542,   405,   406,   407,   408,   409,   410,   302,
     401,   402,   403,  2020,   405,   406,   407,   408,   409,   410,
     407,   408,   409,   410,   415,   405,   406,   407,   408,   409,
     410,   412,  1323,    34,   415,   416,   190,   274,   186,   420,
     152,   267,   207,   677,   749,   376,   743,  1972,  1973,  1974,
     412,  2211,  1977,   415,   416,   189,   210,   677,   420,   390,
      74,   677,   393,   742,   743,   681,  1357,   273,  2775,   677,
      78,   225,   112,   204,   390,   393,   220,   393,   232,   677,
     398,   145,   777,   414,   779,   235,   781,   156,   406,   677,
      98,   222,   787,   788,   773,  2020,   681,   681,   414,   417,
     412,  1338,   152,  2965,   416,   657,   165,   222,  1317,   105,
     314,  1489,   391,  1491,  1492,   657,  1494,   412,   797,   269,
     415,   416,   401,   402,   403,   420,   405,   406,   407,   408,
     409,   410,   520,   282,   151,  1493,   415,  2065,   413,   326,
     157,   105,   290,   274,  1611,   420,   258,  2907,   144,   152,
     157,  1373,   221,   302,   391,  1377,   310,   272,   243,   243,
     105,  1370,   246,   842,   401,   402,   403,  2025,   405,   406,
     407,   408,   409,   410,   378,  2119,     5,   342,   242,   385,
     244,    78,   405,   406,   407,   408,   409,   410,   414,   789,
    1381,  2529,  2530,  2531,  2532,  2533,   147,   214,  2584,   144,
      29,    98,   152,   415,    18,   417,   103,   214,   258,   147,
     224,   212,    41,  1422,   254,   845,   364,   213,   677,  2163,
    2164,   821,   681,   335,   677,   777,   338,   779,   681,   781,
    2509,  2510,   317,   317,   157,   787,   788,  2564,  2564,   859,
    2564,  2564,   138,   859,  1466,  3063,  1455,  2564,   199,   393,
      78,  2564,   259,   260,   398,   258,   168,   204,   254,   161,
     391,   199,   406,    91,   211,   324,  2513,   307,   213,   657,
     401,   402,   403,   417,   405,   406,   407,   408,   409,   410,
     121,   263,  1723,   282,   324,  3103,  1664,   116,   918,   919,
     282,   214,   243,   154,   190,   246,  1490,   184,   157,   220,
    1990,   360,   319,   302,    29,   243,   165,   204,   246,   254,
     302,  1548,   319,   263,   210,  1723,    41,  1917,   180,  2009,
     316,   155,   353,   341,  2313,   222,   223,   239,  1707,   225,
    2274,   278,  2276,  2277,  2341,   164,   232,  2344,  2345,  2346,
    2347,  2348,  2349,  2350,  2351,  2352,  2353,   342,   235,   319,
     902,   368,   370,   384,   250,   711,   258,   119,   184,   199,
     902,   368,  2052,  2053,   261,   267,   317,   201,   103,  1578,
     282,   316,  2379,  2380,  2534,   927,   928,   274,   930,   317,
      78,   737,   269,   935,   157,   927,   928,   216,   930,  1580,
     152,   116,  1161,   935,   222,  1774,   319,   414,  1777,  1778,
     859,   263,   263,   243,   374,   267,   859,   414,   390,   235,
     204,   393,    89,    90,   310,   172,  2341,   211,  1097,  2344,
    2345,  2346,  2347,  2348,  2349,  2350,  2351,  2352,  2353,   288,
     154,   343,   155,   345,    83,   386,   194,  3096,  1068,    88,
    2335,   214,   155,   269,   414,   368,   274,  1325,   386,   320,
     124,   320,  1075,   841,  1075,  2380,  2735,   845,  2737,  2738,
     189,   218,  3045,   414,  1342,   200,  2361,   141,   415,   204,
    1093,   342,  1093,   342,   123,   204,   414,   317,   201,   153,
    3139,   353,   350,  1106,   278,   209,   135,   260,   201,   147,
    1722,   216,   388,   393,   391,   357,   258,  3080,   398,   234,
    1123,   263,   147,   365,   152,  3026,  3165,   296,   405,   406,
     407,   408,   409,   410,   303,   415,   165,  1075,    83,  1075,
     277,  1075,   190,    88,   222,   199,  1149,   312,   290,  2915,
     918,   919,   321,  1163,   258,   282,   417,   299,  1161,   927,
     928,   199,   930,  3064,  1174,  2552,   319,   935,   416,   334,
     391,  1760,  1739,   421,   199,   302,  1427,   344,   123,   346,
     401,   402,   403,   391,   405,   406,   407,   408,   409,   410,
     135,   219,    35,   401,   402,   403,   274,   405,   406,   407,
     408,   409,   410,   382,   383,   243,  1216,   377,   246,   282,
     238,  1462,  1287,   328,    58,   368,   417,   376,   243,  2705,
     165,   413,   364,   282,  1826,  1827,   363,  2535,   420,   302,
    1819,   390,    76,   390,   393,   414,   393,  2896,  1241,  1242,
    1254,  1244,   282,   302,    99,   418,   305,  2552,   382,   383,
    1839,   336,   337,   282,  1254,   414,    47,   414,  1254,  1255,
    1256,   414,   302,   118,  2130,   324,  1276,   392,   393,  1354,
    2594,  3011,  1274,   302,  3014,   422,  1254,   393,  2665,   317,
     414,   412,   398,   414,   400,   136,   137,  1219,  2612,  1221,
     406,  1223,   317,  2460,  1906,   324,   417,  1219,   393,  1221,
    1068,  1223,  2372,   398,  1893,   390,   268,   393,   393,  1305,
     272,   406,  1312,   391,   382,   383,  1312,   389,   393,  3059,
     392,    78,   390,   398,  2082,   393,   391,   405,   406,   407,
     408,   409,   410,  1265,   401,   419,   420,   282,  2365,  2366,
    1305,  1305,  2063,  1265,   172,   412,   414,  2655,   386,   416,
     412,  1500,   415,   204,   416,  1287,   184,   420,   420,  1291,
    2665,   389,   390,  1295,   392,   393,   418,  1381,   390,  1291,
     398,   393,   400,  1295,   407,   408,   409,   390,   406,   324,
     393,  1381,   371,   415,  2205,  1381,  1118,  1119,   420,   415,
     218,  2150,   414,  1381,   420,  1163,   126,  2156,  2157,   121,
     130,   414,   216,  1381,   255,   256,  1174,   235,  2025,  1141,
     777,    21,   779,  1381,   781,  1254,  1255,  1256,  1150,    40,
     787,  1254,  1255,  1256,   405,   406,   407,   408,   409,   390,
     416,  1441,   393,   284,   415,  1203,  1204,   398,   272,   400,
    1372,   269,  2829,   390,  2831,   406,   393,   272,  1216,   277,
    1372,  1219,  1527,  1221,  1529,  1223,   415,   415,  1533,   110,
     414,   420,   420,  2080,  1539,   222,  1305,   414,   344,   304,
     346,  1546,  1305,  1312,  2712,   415,  2050,   116,   117,  1312,
     420,  1556,  2799,  1558,   415,  1736,   147,  1738,    94,   420,
     341,   355,   390,  1343,   145,   393,  1346,  1500,  1348,  1574,
     293,  1576,  1753,     7,   415,   111,  1274,    11,  1276,   420,
     419,   420,  1763,  1764,  1765,   390,   414,   274,   393,    23,
      24,  1772,   373,  1291,  2829,   415,  2831,  1295,  1538,   415,
     420,   132,  2099,   390,   420,   363,   393,  2126,   199,   414,
    1791,    45,  1381,   344,    48,   346,  1797,   415,  1381,  1800,
    1801,   207,   420,  1485,  2143,   206,  2145,   414,   398,   412,
     400,   390,    78,   416,   393,  2952,  1580,  2414,  2876,   398,
    2159,   400,   178,  1241,  1242,    91,  1244,   406,   382,   383,
    1580,  1584,   243,   414,  1580,   246,   390,   415,  2205,   393,
     292,   242,  1580,   244,   415,  1527,   202,  1529,  2187,   420,
     415,  1533,  1580,   254,   344,   420,   346,  1539,   390,  1860,
     414,   393,  1580,   228,  1546,   390,  2205,   390,   393,   189,
     393,   161,   228,   415,  1556,   415,  1558,   417,   420,  2699,
    1640,   415,   414,  2204,   391,   121,   420,   220,   415,   414,
     180,   414,  1574,   420,  1576,   402,   403,  2952,   405,   406,
     407,   408,   409,   410,   272,   306,   317,  2246,   162,  2985,
    2986,  1657,  2988,  1722,  2990,   415,   415,   415,  2257,   391,
     420,   420,   420,  1441,   412,   877,  2265,   879,   416,   401,
     402,   403,   333,   405,   406,   407,   408,   409,   410,   420,
     415,  1623,  1657,  1657,  1690,   420,  1692,    99,   390,   415,
      82,   393,   308,  1713,   420,   390,   222,    89,   393,   387,
      92,  1690,   318,  1692,  2288,   224,  2582,   415,   258,  2321,
     102,   417,   420,   263,   420,   386,   332,   267,   389,   390,
    2319,   392,   393,   339,   275,  1810,   405,   406,   407,   408,
     409,  1580,   272,   415,   413,   415,   128,  1580,   420,   415,
     420,  2340,   415,   387,   420,   137,   138,   420,   274,    99,
     390,   415,   415,   393,   146,   147,   420,   420,   150,   415,
    1538,  1846,   154,   379,   420,  1707,   158,   415,  2367,   412,
     224,   414,   420,   416,  1859,  1707,  3153,   415,  2698,   415,
     387,  1723,   420,  1725,   420,  1727,   178,  2867,   324,   415,
    2389,  1723,   415,  1725,   420,  1727,   390,   420,   415,   393,
     415,   193,   407,   420,   196,   420,   188,   357,  1657,    85,
     202,   415,   204,  1833,  1657,   365,   415,   412,   417,   414,
      96,   416,    86,  2407,  1851,  1852,  1853,  1854,    78,   415,
    1241,  1242,  1774,  1244,   417,  1777,  1778,  1906,   114,   382,
     383,  1690,  1774,  1692,   109,  1777,  1778,  1690,    98,  1692,
    2009,   407,  1989,   103,  1991,  1992,   132,  1942,   382,   383,
     390,  1881,  1640,   393,   417,   391,   418,   420,  1810,  3117,
     146,  2689,   418,  2691,  2135,   401,   402,   403,   216,   405,
     406,   407,   408,   409,   410,   417,   417,   163,   420,   420,
     350,    85,   382,   383,   350,   391,  2495,   382,   383,  1841,
    2084,  2085,   920,   921,  1846,   401,   402,   403,   350,   405,
     406,   407,   408,   409,   410,   191,  2177,  1859,   350,   195,
     114,   350,   170,    94,   109,   105,  2045,  2046,   371,   422,
     216,   207,   126,   222,   350,  1713,   414,   414,   132,  3019,
     414,   414,   138,   414,   414,  1723,   282,  1725,   302,  1727,
     200,   414,   146,   272,   204,   416,   282,    94,   417,   139,
     352,   233,   224,   130,  2563,   414,   266,   228,   382,   163,
     414,   119,   222,   223,   111,   382,    94,   382,   158,  2064,
      99,   282,   382,   228,   234,   381,   414,  2944,  2864,   414,
     272,   171,   272,   420,   190,   185,  2009,   191,   274,   233,
    1942,   184,   272,   414,   414,   185,   414,   420,   258,  2022,
     414,   261,   414,   207,   210,   414,   414,   293,   287,   414,
     414,   414,    94,   414,   274,   414,   193,   414,  2041,   225,
     414,  1809,   233,   414,   414,   229,   232,  2050,   314,   315,
     207,   178,   414,   414,   320,   222,   414,  1825,   184,   407,
     216,  1829,   151,   246,   250,  1833,   420,   317,   370,    43,
     416,    18,  2661,  1841,   370,   202,   342,   343,   420,   414,
     414,   238,   414,   350,   370,   350,   272,   350,   328,   355,
     274,   371,   350,   263,   360,  2712,   126,   350,   272,  1867,
     270,   228,   350,   350,   370,   350,   350,   420,   351,   293,
    2684,   350,   378,  1881,  2688,   233,   350,   350,  2692,   276,
     350,   350,   414,   272,   310,   295,   414,   222,   270,  2061,
     314,   315,  2064,   414,  2066,  2210,   320,   414,   520,   376,
     414,   414,    94,    84,  2066,   152,   239,   184,   272,   371,
     414,   391,    94,   414,   316,  3135,    94,    18,   342,   401,
     350,   401,   402,   403,   420,   405,   406,   407,   408,   409,
     410,   355,   374,   380,   420,   262,   360,   348,   414,   420,
     348,   308,   564,   565,   415,   371,  2924,   344,   414,   346,
    2204,   318,    78,   138,   378,   420,  2273,   348,   355,   324,
    2958,   414,   388,   414,  2204,   332,   350,   364,  2204,   189,
    2968,   420,   339,  2223,  2273,   420,  2204,   353,  2150,   401,
    2794,   378,   415,   218,  2156,  2157,  2204,   273,  2150,   267,
     175,   420,   235,   412,  2156,  2157,  2204,   415,   183,    40,
     226,   226,   408,   415,   263,   414,   263,  2836,   350,  2398,
     414,  2326,   379,   350,   109,   382,   415,  2332,  2407,   342,
     420,   302,   420,   135,   135,   195,   367,  2270,   390,  2270,
    2273,   216,  2273,  2205,   296,  3033,   296,  2851,  2210,    94,
    2212,   371,  2856,  2205,   401,   157,  2860,   222,   222,   222,
    2222,  2400,  2401,  2402,  2403,  2298,   412,  2298,  2066,   350,
     350,   172,   401,   175,   686,   687,   688,   184,   690,   691,
     692,   693,   343,   184,   696,   697,   698,   699,   189,   272,
     276,   196,    94,   194,   195,   308,   197,  2929,   198,   198,
     184,   415,    12,  2907,   716,   415,   245,   719,   420,   721,
     189,   723,   214,   415,   415,   727,   728,   218,   415,   731,
     189,   733,   415,   735,   415,   415,   415,   189,   415,   387,
     742,   743,   420,   387,   235,  2204,   415,   415,  2378,   751,
     415,  2204,   754,   415,   387,   757,   415,   350,   414,   761,
     414,  2970,   415,   765,   766,   274,   768,   401,   415,   771,
      36,  2965,   417,   350,  2326,  2398,   350,   415,   269,   420,
    2332,   417,   282,   415,  2407,   414,   277,   789,   414,   791,
     415,   415,  2180,   222,  3016,   797,   222,   415,   412,   246,
    2188,  2189,   415,   360,   272,   414,    78,   299,   415,  2197,
     420,   350,   270,   270,   415,   371,   272,  2205,   420,   401,
     173,  3015,   314,   825,  2212,   173,    98,   319,   412,  2524,
     415,   103,   170,   189,  2222,  2223,    78,   184,   117,   841,
     842,   843,   844,   414,   846,   415,  2717,   415,   391,   415,
     414,   342,   344,  2724,   346,  2726,   415,   420,   195,   401,
     420,   401,   414,   355,   415,   350,   350,   350,   409,  1024,
     350,   350,   363,   222,   159,   413,   368,   369,   415,   222,
    3117,   222,   391,   414,  3093,   378,   226,   184,   276,   208,
     381,    94,   401,   402,   403,    94,   405,   406,   407,   408,
     409,   410,  1057,   227,   414,   194,   414,   189,  2460,   267,
     415,   415,   415,   415,   415,   414,   918,   919,  2460,   415,
     922,   225,  3116,   225,   415,   416,   417,   414,   200,   279,
     109,   263,   204,   197,   263,   360,   414,   414,   371,   222,
     154,   943,   209,   413,   946,   191,   191,   949,   189,   371,
     222,   223,   175,  2583,   166,   415,  3150,  2580,   153,  2580,
     153,   414,   234,   189,   272,  2517,   318,   263,   350,   971,
     275,    86,  2524,   184,   414,  2517,   414,  2529,  2530,  2531,
    2532,  2533,   225,   414,   299,   415,    94,   263,   241,   261,
    2378,   294,   270,   270,   414,   263,   420,   999,   272,   272,
     414,    97,   274,   415,   184,    94,   128,   272,   212,   263,
    1012,   263,   166,   272,  1016,   272,   414,   162,  1020,   420,
     135,   212,   312,  1025,   368,   157,   420,   313,   175,   313,
      78,  1033,    82,   294,   414,  2730,   415,   224,   298,  1423,
    2232,  1223,   157,  1045,  1046,  1817,  1048,  2066,  1796,  2160,
      98,  2233,  2572,  2575,  1785,   103,   328,  2763,  2492,  1061,
     175,  2684,  2115,  3077,  1219,  2688,  3107,  3056,  2589,  2692,
    3055,  3086,  2460,  2921,  3006,  2577,  2706,  1439,  1849,  3165,
    3139,  1083,  2748,  2747,  2204,  3119,  1425,  3166,   178,  2603,
      78,  1513,   835,  2308,  1096,  3015,  1092,  2233,  2125,   214,
    2992,  2265,  2805,    91,  1099,  3129,  3164,   857,  1816,  1855,
      98,  1663,  2742,   156,  2299,   103,  1075,  2597,  1904,   391,
    2077,  2509,  2510,   171,  1249,  2086,  1248,  1660,  2690,   694,
     402,   403,  2966,   405,   406,   407,   408,   409,   410,  2407,
    2570,  2529,  2530,  2531,  2532,  2533,  1397,  2377,  2205,   714,
    2661,  1183,   200,  2705,  2709,  2022,   204,  3039,  1608,  2789,
    1944,  2071,  1317,  2705,  2820,  2795,   925,  2606,  1716,  2799,
    1289,  1713,    74,   310,   222,   223,  1688,  1046,  2730,  1256,
     953,   921,  1337,  1097,   299,   661,   234,  1723,  2704,  2598,
    1912,  2599,  1913,  2445,  2060,  2583,  1760,  1254,  1907,   314,
    1727,  1203,  1204,   345,   319,  1484,     2,   927,    -1,  1202,
      -1,    -1,   200,   261,  1216,  1370,   204,    -1,    -1,  1221,
    1222,  1223,    -1,    -1,    -1,    -1,   274,    -1,  2851,   344,
    1232,   346,    -1,  2856,   222,   223,    -1,  2860,    -1,    -1,
     355,    -1,  1397,    -1,    -1,    -1,   234,    -1,    -1,   814,
      -1,    -1,    -1,   368,   369,   820,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   828,    -1,    -1,    -1,  1422,    -1,    -1,
     258,    -1,  1274,   261,  1276,    -1,    -1,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,    -1,   274,    -1,   276,    -1,
      -1,    -1,    -1,   858,    -1,    -1,    -1,    -1,   863,    -1,
    1455,    -1,    -1,    -1,  1459,  1307,    -1,    -1,    -1,    -1,
     875,    -1,  1314,    -1,    -1,    -1,    -1,  2705,  2706,  2871,
      -1,  1323,    -1,    -1,    -1,  2948,    -1,  2948,    -1,  2871,
      -1,    -1,    -1,    -1,    -1,    -1,  1338,    -1,    -1,    -1,
     328,    -1,  2965,   391,    -1,    -1,    -1,  2735,    -1,  2737,
    2738,    -1,    -1,    -1,  2742,  1357,    -1,   405,   406,   407,
     408,   409,   410,    -1,    -1,    -1,    -1,    -1,    -1,    78,
      -1,  1373,  3141,    -1,    -1,  1377,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,
    3020,    -1,    -1,   135,   103,    -1,  3091,  3092,    -1,    -1,
      -1,  2789,    -1,   391,    -1,    -1,    -1,  2795,    -1,    -1,
      -1,  2799,  3042,   401,   402,   403,  3046,   405,   406,   407,
     408,   409,   410,  1578,    -1,  1427,  1428,    -1,  1430,    -1,
     172,    -1,   420,    -1,    -1,    -1,  1001,    -1,    -1,  1441,
      -1,    -1,   184,    -1,    -1,    -1,    -1,   189,    -1,    -1,
      -1,    -1,   194,   195,    -1,   197,    -1,    -1,    -1,    -1,
    1462,    -1,    -1,    -1,  1466,    -1,    -1,    -1,    -1,  1471,
      -1,    -1,    85,    -1,    -1,    -1,   218,  1042,  1043,    -1,
      -1,    -1,    -1,    -1,  1049,    -1,    -1,  1489,    -1,  1491,
    1492,   200,  1494,   235,    -1,   204,    82,    -1,  1500,    -1,
      -1,    -1,    -1,    89,    -1,    -1,  3129,    -1,  2896,    -1,
      -1,    -1,    -1,   222,   223,    -1,    -1,    -1,  3141,   132,
      -1,    -1,    -1,    78,    -1,   234,  1091,   269,    -1,    -1,
      -1,    -1,    -1,   146,    -1,   277,    91,    -1,    -1,  3091,
    3092,  3164,   128,    98,    -1,    -1,  1548,    -1,   103,   258,
     163,    -1,   261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     146,   147,    -1,    -1,    -1,   274,    -1,   276,   154,    -1,
      -1,    -1,   158,    -1,    -1,    -1,    -1,    -1,   191,    -1,
      -1,    -1,   195,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     176,    -1,   178,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     342,    -1,    -1,    -1,    -1,  1760,    -1,   193,    -1,    -1,
      -1,  1613,    -1,    -1,    -1,   228,    -1,    -1,    -1,   328,
      -1,   363,    -1,    78,    -1,    -1,    -1,    -1,  1630,    -1,
      -1,    -1,  3020,    -1,    -1,    -1,    -1,    -1,    -1,   381,
      -1,    -1,    -1,    98,    -1,   200,    -1,    -1,   103,   204,
      -1,    -1,    -1,    -1,  3042,  3043,    -1,  1659,  3046,  3047,
      -1,   274,  1664,    -1,  1819,  1230,    -1,   222,   223,  1824,
      -1,    -1,    -1,   415,   416,   417,    -1,    -1,    -1,   234,
      -1,    -1,   391,    -1,  1839,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   401,   402,   403,    -1,   405,   406,   407,   408,
     409,   410,   315,   258,   413,    -1,   261,   320,    -1,    -1,
      -1,  1713,    -1,   422,  1716,    -1,   171,    -1,    -1,   274,
    1722,   276,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   342,
     343,    -1,    -1,    -1,  1736,  1737,  1738,  1739,  1893,    -1,
    1742,    -1,   355,    -1,    -1,   200,  1748,   360,    -1,   204,
      -1,  1753,    -1,    -1,    -1,    -1,    -1,   370,    -1,    -1,
      -1,  1763,  1764,  1765,  1766,  1767,   352,   222,   223,    -1,
    1772,  1773,    -1,   328,  1024,    -1,    -1,    78,    -1,   234,
      -1,    -1,    -1,  1785,  1786,  1787,    -1,  1789,  1790,  1791,
    1792,  1793,  1794,    -1,    -1,  1797,  1798,    98,  1800,  1801,
      -1,    -1,   103,    -1,    -1,    -1,   261,  1057,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   274,
      -1,    -1,    -1,    -1,  1826,  1827,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,  1841,
      -1,    -1,    -1,    -1,    -1,    -1,   401,   402,   403,    -1,
     405,   406,   407,   408,   409,   410,    -1,    -1,  1860,    -1,
      -1,    -1,    -1,    -1,    -1,   420,    -1,    -1,    -1,    -1,
     171,  1873,    -1,   328,    -1,    -1,  1878,    -1,    -1,    -1,
      -1,    -1,    -1,  1885,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1895,    -1,  1460,  1461,    -1,    -1,   200,
      -1,    -1,    -1,   204,  1906,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1922,   222,   223,    -1,    -1,    -1,    -1,    -1,  1493,    -1,
      -1,    -1,    -1,   234,   520,    -1,   391,  1024,    -1,  1504,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1513,    -1,
     405,   406,   407,   408,   409,   410,    -1,    -1,    -1,    -1,
     261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1057,  2126,    -1,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2143,    -1,
    2145,    -1,   578,    -1,    -1,    -1,    -1,  1999,    -1,    -1,
      -1,    -1,    -1,    -1,  2159,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2025,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,  2187,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1607,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2205,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2066,    -1,    -1,  1317,    -1,  2071,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2082,    -1,    -1,    -1,    -1,    -1,    -1,  1337,    -1,    -1,
     391,  2246,    -1,    -1,    -1,    -1,    -1,  2099,  1663,    -1,
      -1,    -1,  2257,    -1,   405,   406,   407,   408,   409,   410,
    2265,    -1,    -1,    -1,    -1,    -1,  2118,    -1,    -1,    -1,
    1370,    -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2135,  2136,    -1,    -1,    -1,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,  1397,    -1,    -1,
     103,    -1,    -1,    -1,    -1,    -1,   742,   743,    -1,    -1,
      -1,    -1,    -1,    -1,  2319,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1422,    -1,    -1,  2177,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2340,    -1,   773,  2190,    -1,
      -1,   777,    -1,   779,    -1,   781,    -1,    -1,    -1,    -1,
      -1,   787,   788,    -1,    -1,  1455,    -1,    -1,    -1,  1459,
    2212,   797,  2367,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2224,  2225,  2226,    -1,    -1,    -1,    -1,    -1,
    1317,    -1,    -1,  1024,  2389,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,
    1337,   204,    -1,    -1,    -1,   841,   842,    -1,    -1,   845,
    2262,    -1,    -1,    -1,    -1,    -1,  1057,    -1,    -1,   222,
     223,  2273,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   234,    -1,  1370,    -1,    -1,    -1,    -1,  2290,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2299,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   258,  2308,    -1,   261,    -1,
    1397,    -1,  1877,    -1,    -1,    -1,   902,  1882,    -1,  2321,
      -1,   274,    -1,   276,    -1,    -1,    -1,    -1,  1578,    -1,
      -1,    -1,   918,   919,    -1,  1422,    -1,    -1,    -1,    -1,
    2495,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1455,    -1,
      -1,    -1,  1459,    -1,    -1,   328,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2408,    -1,  2563,    -1,
    2412,  2413,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   391,    -1,
     103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   401,   402,
     403,    -1,   405,   406,   407,   408,   409,   410,    -1,    -1,
      -1,    -1,   415,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2474,  2475,    -1,    -1,    -1,    -1,    -1,  2044,
      -1,    -1,  1068,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1578,    -1,    -1,    -1,    -1,    -1,  2499,  2500,    -1,
    1086,    -1,    -1,  1089,    -1,    -1,  2661,    -1,    -1,    -1,
    1760,  1097,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1317,  2529,  2530,  2531,
    2532,  2533,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,
      -1,   204,    -1,    -1,    -1,    -1,  1337,    -1,    -1,  2551,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   222,
     223,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2570,  1819,
    2572,   234,    -1,  2575,  1824,  2577,    -1,  1163,    -1,  1370,
      -1,    -1,  2584,    -1,    -1,    -1,    -1,  2589,  1174,  1839,
      -1,    -1,    -1,    -1,    -1,   258,    -1,    -1,   261,    -1,
      -1,  2603,    -1,    -1,    -1,    -1,  1397,    -1,    -1,    -1,
      -1,   274,    -1,  1199,    -1,    -1,    -1,  1203,  1204,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1216,  1422,    -1,  1219,    -1,  1221,    -1,  1223,    -1,    -1,
      -1,    -1,    -1,  1893,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1455,   328,    -1,    -1,  1459,    -1,
      -1,    -1,    -1,  1760,    -1,    98,  2678,  2242,    -1,  2681,
     103,  2836,    -1,  2248,    -1,    -1,    -1,    -1,  1274,    -1,
    1276,    -1,    -1,  2695,    -1,    -1,  2698,    -1,    -1,    -1,
      -1,  1287,    -1,    -1,    -1,    -1,    -1,  2709,    -1,    -1,
    2712,    -1,  2714,    -1,    -1,  2717,  2718,    -1,    -1,    -1,
      -1,    -1,  2724,  2725,  2726,    -1,    -1,    -1,   391,  2731,
      -1,  1024,  1819,    -1,    -1,    -1,    -1,  1824,   401,   402,
     403,    -1,   405,   406,   407,   408,   409,   410,    -1,    -1,
      -1,    -1,  1839,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1057,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,
      -1,   204,    -1,    -1,    -1,    -1,  1372,  1578,    -1,    -1,
      -1,    -1,  2794,    -1,    -1,    -1,    -1,  2799,    -1,   222,
     223,    -1,    -1,    -1,    -1,    -1,  1893,    -1,    -1,    -1,
      74,   234,    -1,    77,    -1,  2970,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    89,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   261,    -1,
    2405,  2406,    -1,    -1,    -1,  2847,    -1,  2849,    -1,   113,
      -1,   274,    -1,    -1,    -1,  1441,    -1,    -1,    -1,  2861,
      -1,  2863,    -1,    -1,   128,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2126,    -1,    -1,    -1,
      -1,    -1,   146,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2143,    -1,  2145,    -1,    -1,  1484,  1485,
      -1,    -1,  1024,    -1,    -1,   328,    -1,    -1,    -1,  2159,
      -1,    -1,    -1,  2915,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2929,    -1,    -1,
      -1,  2933,    -1,    -1,    -1,  1057,    -1,  2187,  3093,    -1,
      -1,  1527,    -1,  1529,    -1,    -1,    -1,  1533,    -1,    -1,
      -1,   215,  1538,  1539,    -1,  2205,  2958,    -1,    -1,    -1,
    1546,    -1,    -1,    -1,    -1,    -1,  2968,    -1,   391,  1760,
    1556,  2536,  1558,    -1,    -1,    -1,    -1,    -1,   401,   402,
     403,    -1,   405,   406,   407,   408,   409,   410,  1574,    -1,
    1576,    -1,    -1,  2558,    -1,    -1,  2246,    -1,  3153,  3001,
      -1,    -1,    -1,  3005,    -1,    -1,    -1,  2257,    -1,    -1,
      -1,    -1,    -1,  3015,  3016,  2265,    -1,    -1,    -1,    -1,
      -1,  1607,    -1,    -1,  1317,    -1,    -1,  1613,  1819,    -1,
      -1,  3033,    -1,  1824,    -1,    -1,    -1,  1623,    -1,  2126,
      -1,    -1,    78,  3045,  1337,   309,    -1,    -1,  1839,    -1,
      -1,    -1,    -1,    -1,  1640,    91,  2143,    -1,  2145,    -1,
      -1,  3063,    98,    -1,    -1,    -1,    -1,   103,    -1,  2319,
      -1,    -1,  2159,    -1,    -1,    -1,    -1,  1370,  3080,    -1,
      -1,    -1,   346,    -1,    -1,   349,    -1,    -1,    -1,    -1,
    2340,    -1,    -1,    -1,  3096,    -1,    -1,    -1,    -1,    -1,
    2187,  3103,  1893,    -1,  1397,    -1,    -1,  2672,  2673,  2674,
    2675,    -1,    -1,    -1,    -1,  3117,    -1,  2367,  2205,    -1,
      -1,  1707,    -1,    -1,    -1,    -1,    -1,  1713,    -1,  1422,
      -1,    -1,    -1,    -1,    -1,    -1,  1722,  3139,    -1,  2389,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2246,
      -1,    -1,  1455,  3165,   200,    -1,  1459,    -1,   204,    -1,
    2257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2265,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   222,   223,  1774,    -1,
      -1,  1777,  1778,    -1,    -1,  1317,    -1,    -1,   234,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2772,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1337,    -1,    -1,    -1,    -1,
      -1,    -1,   258,    -1,  1810,   261,    -1,    -1,    -1,    -1,
      -1,    -1,  2319,    -1,    -1,    -1,    -1,    -1,   274,  1825,
     276,    -1,    -1,  1829,    -1,  2495,    -1,  1833,  1370,    -1,
      -1,    -1,    -1,  2340,    -1,  1841,   520,    -1,    -1,    -1,
    1846,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1859,    -1,  1397,    -1,    -1,    -1,    -1,
    2367,    -1,    -1,    -1,    -1,  1578,    -1,    -1,    -1,    -1,
      -1,    -1,   328,    -1,    -1,  1881,    -1,    -1,    -1,    -1,
    1422,    -1,  2389,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2563,    -1,    -1,    78,    -1,    -1,    -1,
    1906,  1907,    -1,    -1,  1910,    -1,  1912,    -1,    -1,    -1,
      -1,    -1,    -1,  1455,    -1,  2126,    98,  1459,    -1,    -1,
      -1,   103,    -1,    -1,  2909,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2143,    -1,  2145,   391,  1942,    -1,    -1,  2924,
      -1,    -1,    -1,    -1,    -1,   401,   402,   403,  2159,   405,
     406,   407,   408,   409,   410,    -1,    -1,    -1,    -1,   415,
      -1,    -1,  2947,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2187,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2495,   171,
      -1,  2661,    -1,   677,  2205,  2980,    -1,   681,    -1,    -1,
      -1,   685,    -1,    -1,    -1,   689,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,   200,    -1,
      -1,    -1,   204,    -1,    -1,    -1,    -1,    91,    -1,    -1,
      -1,   715,    -1,    -1,    98,  2246,  1578,    -1,    -1,   103,
     222,   223,    -1,    -1,    -1,    -1,  2257,  1760,    -1,    -1,
      -1,    78,   234,    -1,  2265,  2061,  2563,    -1,  2064,    -1,
    2066,    -1,    -1,   747,    91,    -1,   750,    -1,    -1,    -1,
      -1,    98,   756,    -1,    -1,    -1,   103,    -1,    -1,   261,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1819,    -1,  2319,    -1,
      -1,  1824,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1839,    -1,    -1,  2340,
      -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,
     204,    -1,    -1,    -1,  2150,    -1,   328,    -1,    -1,    -1,
    2156,  2157,    -1,    -1,  2661,   839,  2367,   841,   222,   223,
      -1,    -1,    -1,    -1,    -1,    -1,  2836,    -1,    -1,    -1,
     234,    -1,    -1,   200,    -1,   859,    -1,   204,  2389,    -1,
    1893,    -1,  2188,  2189,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2197,    -1,    -1,   258,   222,   223,   261,    -1,  2205,
    1024,    -1,    -1,    -1,  2210,    -1,  2212,   234,    -1,   391,
     274,    -1,   276,    -1,    -1,    -1,  2222,  2223,  1760,    -1,
      -1,    -1,    -1,   405,   406,   407,   408,   409,   410,    -1,
      -1,   258,    -1,  1057,   261,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   274,    -1,   276,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   328,    -1,    -1,  2273,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1819,    -1,    -1,
      -1,    -1,  1824,    -1,  2495,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1839,    -1,    -1,
    2970,   328,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1002,    -1,
    2326,    -1,    -1,    -1,  1008,    -1,  2332,   391,    -1,  2836,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   401,   402,   403,
    1024,   405,   406,   407,   408,   409,   410,    -1,    -1,   413,
      -1,  1893,  2563,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1047,   391,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2378,  1057,   401,   402,   403,    -1,   405,   406,
     407,   408,   409,   410,    -1,    -1,    -1,    -1,   415,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2126,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3093,    -1,    -1,  1110,    -1,    -1,    -1,
    2143,    -1,  2145,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2159,    -1,  1132,    -1,
    2661,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2970,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1156,  1157,  2187,  1159,  1160,  1161,    -1,    -1,
      -1,    -1,    -1,  3153,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2205,  1317,  1178,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2509,  2510,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1337,    -1,    -1,    -1,    -1,  2524,  1203,
    1204,    -1,    -1,  2529,  2530,  2531,  2532,  2533,    -1,    -1,
      -1,    -1,    -1,  2246,    -1,  1219,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2257,    -1,  1370,    -1,    -1,    -1,
      -1,    -1,  2265,    -1,    -1,    -1,    -1,    -1,    -1,  1243,
      -1,    -1,  1246,  1247,    -1,    -1,    -1,    -1,    -1,    -1,
    1254,  1255,  1256,  1397,    -1,    -1,    -1,  2583,    -1,    -1,
      -1,    -1,    -1,    -1,  2126,    -1,  3093,    -1,    -1,    -1,
    1274,    -1,  2598,    -1,    -1,    -1,    -1,    -1,  1422,    -1,
      -1,  2143,    -1,  2145,    -1,    -1,  2319,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2159,    -1,    -1,
      -1,  1305,    -1,    -1,    -1,  2836,    -1,  2340,  1312,  1313,
      -1,  1455,    -1,  1317,    -1,  1459,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2187,  3153,    -1,    -1,    -1,
      -1,    -1,    -1,  1337,  2367,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2205,    -1,    -1,   138,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2389,    -1,    -1,    -1,
      -1,    -1,    -1,  1024,    -1,    -1,  1370,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1381,    -1,  2705,
    2706,    -1,    -1,   175,  2246,    -1,    -1,    -1,    -1,    -1,
      -1,   183,    -1,  1397,    -1,  2257,  1057,    -1,    -1,    -1,
      -1,    -1,    -1,  2265,  2730,    -1,    -1,    -1,    -1,  2735,
      -1,  2737,  2738,    -1,    -1,    -1,  2742,    -1,  1422,    -1,
      -1,    -1,    -1,    -1,   216,   217,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1578,    -1,    -1,    -1,    -1,  2970,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1453,
      -1,  1455,    -1,    -1,    -1,  1459,    -1,  2319,    -1,    -1,
      -1,    -1,  2495,  2789,    -1,    -1,    -1,    -1,    -1,  2795,
      -1,    -1,    -1,  2799,    -1,    -1,    -1,    -1,  2340,    -1,
      90,    -1,    -1,    -1,    -1,    -1,  1490,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   113,    -1,  2367,    -1,    -1,    -1,    -1,
    1514,  1515,    -1,    -1,    -1,    -1,    -1,    -1,  1522,    -1,
      -1,  1525,  1526,    78,    -1,    -1,    -1,  2389,    -1,    -1,
    2563,    -1,    -1,    -1,  1538,    -1,    91,    -1,    -1,    -1,
      -1,  1545,    -1,    98,    -1,  1549,  1550,  1551,   103,  1553,
      -1,    -1,    78,    -1,    -1,    -1,  1560,  1561,    -1,    -1,
      -1,    -1,  3093,    -1,    -1,    91,    -1,    -1,    -1,    95,
    2896,    -1,    98,    -1,  1578,  1579,  1580,   103,  1582,  1583,
      -1,    -1,    -1,  1587,    -1,    -1,    -1,  1591,    -1,    -1,
    1594,  1595,  1596,  1597,  1598,  1599,  1600,  1601,  1602,    -1,
    1604,    -1,    -1,    -1,  1608,   215,    -1,    -1,  1612,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1760,    -1,    78,    -1,
      -1,    -1,  3153,    -1,    -1,    -1,    -1,    -1,  2661,    -1,
      -1,    -1,    -1,  2495,   160,    -1,    -1,    -1,    98,    -1,
      -1,    -1,    -1,   103,    -1,   200,    -1,    -1,    -1,   204,
      -1,    -1,    -1,  1657,    -1,    -1,  1317,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   222,   223,    -1,
      -1,    -1,    -1,    -1,   200,  1819,  1337,    -1,   204,   234,
    1824,    -1,    -1,    -1,    -1,    -1,  1690,    -1,  1692,    -1,
      -1,    -1,    -1,    -1,  3020,  1839,   222,   223,    -1,    -1,
      -1,  2563,    -1,   258,    -1,    -1,   261,    -1,   234,  1370,
      -1,   171,    -1,    -1,    -1,    -1,  3042,    -1,    -1,   274,
    3046,   276,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   258,    -1,    -1,   261,  1397,    -1,    -1,    -1,
     200,    -1,    -1,    -1,   204,    -1,    -1,  1751,   274,  1893,
     276,    -1,    -1,    -1,    -1,    -1,  1760,    -1,    -1,    -1,
      -1,  1422,   222,   223,    -1,  3091,  3092,    -1,    -1,    -1,
    3096,    -1,    -1,   328,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1455,    -1,    -1,    -1,  1459,  2661,
      -1,   261,   328,  2836,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3139,   274,  1819,    -1,    -1,    -1,    -1,
    1824,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1837,    -1,  1839,   391,    -1,    -1,  3165,
      -1,    -1,    -1,    -1,    -1,   371,   401,   402,   403,    -1,
     405,   406,   407,   408,   409,   410,    -1,    -1,    -1,    -1,
     415,    -1,    -1,    -1,    -1,   391,    -1,    -1,   328,    -1,
      -1,    -1,    -1,    -1,    -1,   401,   402,   403,    -1,   405,
     406,   407,   408,   409,   410,    -1,    -1,    -1,    -1,  1893,
      -1,    -1,    -1,   685,    -1,    -1,    -1,   689,    -1,    -1,
      -1,    -1,   694,   695,    -1,    -1,    -1,    78,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1578,    -1,    -1,
    1924,    -1,   714,   715,    -1,    -1,    -1,    98,    -1,    -1,
      -1,   391,   103,    -1,    -1,    -1,    -1,  2970,    -1,  1943,
      -1,    -1,    -1,    -1,    -1,   405,   406,   407,   408,   409,
     410,    -1,    -1,    -1,    -1,    -1,    -1,   749,   750,    -1,
      -1,    -1,    -1,    -1,   756,    -1,    -1,    -1,  1972,  1973,
    1974,    -1,    -1,  1977,  2836,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2126,    -1,    -1,  1989,  1990,  1991,  1992,    -1,
      -1,    -1,    -1,    -1,  1998,    -1,    -1,    -1,    -1,  2143,
     171,  2145,    -1,    -1,    -1,  2009,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2159,  2020,  2021,    -1,  2023,
      -1,    -1,   814,  2027,    -1,    -1,    -1,    -1,   820,   200,
      -1,    -1,    -1,   204,    -1,    -1,   828,    -1,    -1,    -1,
      -1,    -1,    -1,  2187,    -1,    -1,  2050,    -1,  2052,  2053,
      -1,   222,   223,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3093,  2205,    -1,   234,    -1,    -1,   858,   677,    -1,    -1,
      -1,   863,    -1,  2077,    -1,   685,    -1,    -1,    -1,   689,
    2084,  2085,  2086,   875,    -1,    -1,    -1,    -1,    -1,    -1,
     261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1760,
      -1,    -1,  2246,   274,  2108,   715,    -1,    -1,  2970,    -1,
    2114,    -1,    -1,  2257,    -1,    -1,    -1,    -1,    -1,    -1,
    3153,  2265,  2126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2143,
     750,  2145,    -1,    -1,    -1,    -1,   756,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2159,    -1,   328,  1819,    -1,
      -1,    -1,    -1,  1824,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2319,    -1,    -1,  1839,    -1,
      -1,    -1,    -1,  2187,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2340,    -1,    -1,    -1,
    2204,  2205,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1001,
    1002,    -1,    -1,    -1,    -1,    -1,  1008,    -1,    -1,    -1,
     391,    -1,    -1,  2367,    -1,    -1,    -1,    -1,    -1,   839,
      -1,  3093,  1893,    -1,   405,   406,   407,   408,   409,   410,
      -1,    -1,  2246,    -1,    -1,  2389,    -1,    -1,    -1,    -1,
    1042,  1043,    -1,  2257,    -1,  1047,    -1,  1049,    -1,    -1,
      -1,  2265,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2288,    -1,    -1,    -1,    -1,    -1,
      -1,  3153,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1091,
      -1,    -1,    -1,    -1,    -1,    -1,  2310,    -1,    -1,    -1,
      -1,    -1,  2316,    -1,    -1,  2319,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2328,    -1,  2330,    -1,    -1,    -1,
    2334,    -1,    -1,    -1,    -1,    -1,  2340,  2341,    -1,    -1,
    2344,  2345,  2346,  2347,  2348,  2349,  2350,  2351,  2352,  2353,
      -1,  2495,    -1,    -1,  2358,  2359,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2367,    -1,    -1,    -1,    -1,  2372,    -1,
      -1,    -1,    -1,    -1,    -1,  2379,  2380,  2381,    -1,  2383,
      -1,    -1,    -1,    -1,    -1,  2389,  2390,    -1,    -1,    -1,
      -1,  2395,  1002,    -1,  2398,    -1,    -1,    -1,  1008,    -1,
      -1,    -1,    -1,  2407,    -1,    -1,    -1,    -1,    -1,    78,
      -1,    -1,    -1,    -1,  1024,    -1,    -1,    -1,    -1,  2563,
      -1,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,    -1,   103,    -1,    -1,  1047,  1230,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2450,  1057,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2126,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2143,    -1,  2145,    -1,    -1,    -1,    -1,    -1,
      -1,  2495,    -1,    -1,    -1,    -1,    -1,    -1,  2159,    -1,
    1110,    -1,    -1,    -1,    -1,    82,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2661,    -1,    -1,
      -1,    -1,  1132,    -1,    -1,    -1,  2187,    -1,    -1,    -1,
      -1,   200,    -1,    -1,    -1,   204,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2205,    -1,  1156,  1157,  2552,  1159,
    1160,  1161,    -1,   222,   223,    -1,    -1,    -1,    -1,  2563,
      -1,    -1,  1354,    -1,    -1,   234,    -1,    -1,  1178,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   158,    -1,    -1,    -1,  2246,    -1,    -1,    -1,   258,
      -1,    -1,   261,    -1,    -1,    -1,  2257,    -1,    -1,   176,
      -1,   178,  2606,    -1,  2265,   274,    -1,   276,    -1,    85,
      -1,    -1,  2616,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1243,    -1,    -1,  1246,  1247,   114,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   130,    -1,   132,  2661,  2319,   328,
      -1,  2665,  2666,  2667,    -1,    -1,  2670,    -1,  1460,  1461,
     146,    -1,    -1,    -1,    -1,    -1,   152,    -1,    -1,  2340,
    2684,    -1,    -1,    -1,  2688,    -1,    -1,   163,  2692,    -1,
      -1,    -1,  2836,    -1,    -1,  2699,    -1,    -1,  1490,    -1,
      -1,  1493,    -1,  1313,    -1,    -1,  2367,  1317,    -1,    -1,
      -1,    -1,  1504,    -1,    -1,    -1,    -1,   193,    -1,   195,
      -1,  1513,   391,    -1,    -1,    -1,    -1,  1337,  2389,    -1,
      -1,   207,   401,   402,   403,    -1,   405,   406,   407,   408,
     409,   410,    -1,    -1,    -1,    -1,   415,    -1,    -1,    -1,
      -1,    -1,   228,  1024,    -1,    -1,    -1,    -1,  2762,    -1,
    1370,    -1,   238,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1057,  1397,    -1,    -1,
    2794,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   274,    -1,
     276,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1422,    -1,    -1,  1607,  2820,   293,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2829,  2970,  2831,    -1,    -1,
      -1,    -1,  2836,    -1,  2495,    -1,  2840,    -1,    -1,   315,
      -1,    -1,    -1,  1453,   320,  1455,    -1,  2851,    -1,  1459,
      -1,    -1,  2856,    -1,    -1,    -1,  2860,    -1,    -1,    -1,
      -1,    -1,    -1,  2867,  2868,    -1,   342,   343,   344,    -1,
     346,  1663,    -1,  2877,    -1,    -1,    -1,    -1,    -1,   355,
    1490,    -1,    -1,   359,   360,    -1,    -1,    -1,   364,  2893,
      -1,    -1,    -1,    -1,   370,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2563,  2907,  1514,  1515,    -1,    -1,    78,    -1,
      -1,    -1,  1522,    -1,    -1,  1525,  1526,    -1,    -1,    -1,
      -1,    91,    -1,    -1,    -1,    -1,  2930,    -1,    98,    -1,
      -1,    -1,    -1,   103,    -1,  1545,    -1,    -1,    -1,  1549,
    1550,  1551,    -1,  1553,    -1,    -1,    -1,    -1,  2952,  3093,
    1560,  1561,    -1,    -1,    -1,    -1,    -1,  2961,    -1,    -1,
      -1,  2965,    -1,    -1,    -1,    -1,  2970,    -1,  1578,  1579,
    1580,    -1,  1582,  1583,    -1,    -1,    -1,  1587,    -1,    -1,
      -1,  1591,    -1,    -1,  1594,  1595,  1596,  1597,  1598,  1599,
    1600,  1601,  1602,    -1,  1604,    -1,    -1,    -1,  1608,    78,
    2661,    -1,  1612,    -1,    -1,    -1,    -1,    -1,    -1,  3153,
      -1,  3015,    91,    -1,    -1,  3019,    -1,    -1,    -1,    98,
      -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,   204,  3039,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1317,    -1,    -1,    -1,
      -1,    -1,   222,   223,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   234,    -1,  1337,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1877,    -1,    -1,   258,  3093,
    1882,   261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1370,
      -1,    -1,    -1,    -1,   274,    -1,   276,    -1,    -1,    -1,
      -1,    -1,  3116,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   200,    -1,    -1,    -1,   204,  1397,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1751,    -1,   222,   223,    -1,  3150,    -1,    -1,  3153,
    1760,  1422,    -1,    -1,    -1,   234,    -1,    -1,   328,    -1,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     102,    -1,    -1,    -1,    -1,  2836,    -1,    -1,    -1,   258,
      -1,    -1,   261,    -1,  1455,    -1,    -1,    -1,  1459,    -1,
      -1,    -1,    -1,    -1,    -1,   274,    -1,   276,    -1,    -1,
     777,    -1,   779,    -1,   781,   137,    -1,    -1,    -1,  1819,
     787,   788,    -1,    -1,  1824,   147,    -1,    -1,   150,    -1,
      -1,   391,   154,    -1,    -1,    -1,   158,  1837,    -1,  1839,
      -1,   401,   402,   403,    -1,   405,   406,   407,   408,   409,
     410,    -1,    -1,    -1,    -1,   415,   178,    -1,    -1,   328,
      -1,    78,  2044,    -1,    -1,    -1,    -1,    -1,  2050,    -1,
      -1,   193,    -1,    -1,    91,    -1,    -1,    -1,   845,    -1,
      -1,    98,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,
      -1,    -1,    -1,  1893,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1578,    -1,  2970,
      -1,    -1,   391,    -1,  1924,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   401,   402,   403,   902,   405,   406,   407,   408,
     409,   410,    -1,  1943,    -1,    -1,   415,    -1,    -1,    -1,
      -1,   918,   919,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   935,    -1,
      -1,    -1,  1972,  1973,  1974,    -1,    -1,  1977,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,   204,    -1,  1989,
    1990,  1991,  1992,    -1,    -1,    -1,    -1,    -1,  1998,    -1,
      -1,    -1,    -1,    -1,    -1,   222,   223,    -1,    -1,  2009,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   234,    -1,    -1,
    2020,  2021,    -1,  2023,    -1,    -1,    -1,  2027,    -1,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   258,  3093,    -1,   261,    -1,    -1,    -1,    -1,    -1,
    2050,    -1,  2052,  2053,    -1,    -1,    -1,   274,    -1,   276,
    2242,    -1,    -1,    -1,    -1,    -1,  2248,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2077,    -1,    -1,
      -1,    -1,    -1,    -1,  2084,  2085,  2086,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1760,
      -1,  1068,  3153,    -1,    -1,    -1,  2288,    -1,  2108,    -1,
      -1,   328,    -1,    -1,  2114,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2126,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2143,    -1,  2145,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1819,  2159,
      -1,    -1,    -1,  1824,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,  1839,    -1,
      -1,    -1,    -1,    -1,   401,   402,   403,  2187,   405,   406,
     407,   408,   409,   410,    -1,    -1,  1163,    -1,   415,    -1,
      -1,    -1,    -1,    -1,  2204,  2205,    -1,  1174,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2405,  2406,  2407,    -1,    -1,    -1,    -1,
      -1,    -1,  1893,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   564,   565,    -1,    -1,  2246,    -1,    -1,  1216,
      -1,    -1,  1219,    -1,  1221,    -1,  1223,  2257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2265,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2288,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1276,
    2310,    -1,    -1,    -1,    -1,    -1,  2316,    -1,    -1,  2319,
    1287,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2328,    -1,
    2330,    -1,    -1,    -1,  2334,    -1,    -1,    -1,    -1,    -1,
    2340,  2341,    -1,    -1,  2344,  2345,  2346,  2347,  2348,  2349,
    2350,  2351,  2352,  2353,  2536,    -1,    -1,    -1,  2358,  2359,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2367,    -1,   691,
      -1,   693,  2372,    -1,   696,   697,  2558,    -1,    -1,  2379,
    2380,  2381,    -1,  2383,    -1,    -1,    -1,    -1,    -1,  2389,
    2390,    -1,    -1,    -1,   716,  2395,    -1,    -1,  2398,    -1,
      -1,    -1,    -1,    -1,    -1,  1372,   728,  2407,    -1,   731,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     742,   743,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   751,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   761,
      -1,    -1,    -1,   765,   766,    -1,    -1,    -1,    -1,    -1,
    2450,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2126,    -1,   789,    -1,   791,
      -1,    -1,    -1,    -1,  1441,   797,    -1,    -1,    -1,    -1,
      -1,    -1,  2143,    -1,  2145,    -1,    -1,    -1,    -1,    -1,
    2672,  2673,  2674,  2675,    -1,  2495,    -1,    -1,  2159,    -1,
      -1,    -1,  2684,   825,    -1,    -1,  2688,    -1,    -1,    -1,
    2692,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     842,    -1,    -1,    -1,    -1,    -1,  2187,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2205,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2552,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1527,    -1,  1529,  2563,    -1,    -1,  1533,    -1,    -1,    -1,
      -1,  1538,  1539,    -1,    -1,    -1,    -1,    -1,    -1,  1546,
      -1,    -1,    -1,    -1,    -1,  2246,    -1,    -1,    -1,  1556,
    2772,  1558,    -1,    -1,    -1,    -1,  2257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2265,    -1,  2606,  1574,    -1,  1576,
      -1,    -1,  2794,    -1,    -1,    -1,  2616,    -1,    -1,    -1,
      -1,   943,    -1,    -1,   946,    -1,    78,   949,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,
      -1,   103,    -1,    -1,    -1,    -1,    -1,    -1,  2319,    -1,
      -1,  2661,    -1,    -1,    -1,  2665,  2666,  2667,    -1,  2851,
    2670,    -1,    -1,  1640,  2856,    -1,    -1,    -1,  2860,  2340,
      -1,    -1,    -1,    -1,  2684,    -1,    -1,    -1,  2688,    -1,
    1012,    -1,  2692,    -1,  1016,    -1,    -1,    -1,  1020,  2699,
      -1,    -1,    -1,  1025,    -1,    -1,  2367,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2907,  1048,  2909,  2389,    -1,
      -1,    -1,   184,    -1,    -1,    -1,    -1,   189,    -1,    -1,
    1707,    -1,  2924,    -1,    -1,    -1,  1713,    -1,   200,    -1,
      -1,    -1,   204,    -1,    -1,    -1,  1723,    -1,    -1,    -1,
      -1,  1083,  2762,    -1,    -1,  2947,    -1,    -1,    -1,    -1,
     222,   223,    -1,    -1,  1096,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   234,  2965,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2794,    -1,    -1,    -1,  2980,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   258,  1774,    -1,   261,
    1777,  1778,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2820,    -1,   274,    -1,   276,    -1,    -1,    -1,    -1,  2829,
      -1,  2831,    -1,  3015,  2495,    -1,  2836,    -1,    -1,    -1,
    2840,    -1,    -1,  1810,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2851,    -1,    -1,    -1,    -1,  2856,    -1,  1825,    -1,
    2860,    -1,  1829,    -1,    -1,    -1,  1833,  2867,  2868,    78,
      -1,    -1,    -1,    -1,  1841,    -1,   328,  2877,    -1,  1846,
      -1,    -1,    91,    -1,    -1,    94,    -1,    -1,    -1,    98,
      -1,    -1,  1859,  2893,   103,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2563,    -1,    -1,    -1,    -1,  2907,    -1,    -1,
      -1,    -1,    -1,    -1,  1881,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2930,    -1,    -1,    -1,  3116,    -1,    -1,    -1,    -1,   391,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   401,
     402,   403,  2952,   405,   406,   407,   408,   409,   410,   685,
      -1,  2961,    -1,   689,    -1,  2965,    -1,    -1,  3150,    -1,
    2970,    -1,    -1,    -1,    -1,  1942,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1307,    -1,    -1,    -1,   715,
      -1,   200,    -1,    -1,    -1,   204,    -1,    -1,    -1,    -1,
    2661,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   222,   223,  3015,    -1,    -1,    -1,  3019,
      -1,    -1,    78,    -1,   750,   234,    -1,    -1,    -1,    -1,
     756,    -1,    -1,    -1,    -1,    91,    -1,    -1,    94,  3039,
      -1,    -1,    98,    -1,    -1,    -1,    -1,   103,    -1,   258,
      -1,    -1,   261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   274,    -1,   276,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3093,    -1,    -1,    -1,  2064,    -1,  2066,
      -1,    -1,    -1,    -1,    -1,    -1,  1428,    -1,  1430,    -1,
      -1,    -1,    -1,   839,    -1,    -1,  3116,    -1,    -1,   328,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,   204,  1471,
    3150,    -1,    -1,  3153,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   222,   223,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2836,    -1,    -1,   234,    -1,
      -1,    -1,   391,  2150,    -1,    -1,    -1,    -1,    -1,  2156,
    2157,    -1,   401,   402,   403,    -1,   405,   406,   407,   408,
     409,   410,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   274,    -1,
     276,  2188,  2189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2197,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2205,    -1,
      -1,    -1,    -1,  2210,    -1,  2212,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2222,  2223,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   328,    -1,    -1,    -1,  1002,    -1,    -1,    -1,
      -1,    -1,  1008,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1613,    -1,    -1,    -1,    -1,    -1,    -1,  1024,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1630,  2970,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1047,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1057,    -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   401,   402,   403,    -1,   405,
     406,   407,   408,   409,   410,    -1,    -1,    78,    -1,  2326,
      -1,    -1,    -1,    -1,    -1,  2332,    -1,    -1,    -1,    -1,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,    -1,   103,    -1,  1110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1722,    -1,    -1,    -1,    -1,    -1,  1132,    -1,    -1,    -1,
      -1,  2378,    -1,    -1,    -1,  1737,    -1,    -1,    -1,    -1,
    1742,    -1,    -1,    -1,    -1,    -1,  1748,    -1,    -1,    -1,
    1156,  1157,  3093,  1159,  1160,  1161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1766,    -1,    -1,    -1,    -1,    -1,
      -1,  1773,  1178,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1787,    -1,  1789,    -1,    -1,
    1792,  1793,  1794,    -1,    -1,    -1,  1798,    -1,    -1,   200,
      -1,    -1,    -1,   204,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3153,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   222,   223,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   234,    -1,    -1,    -1,  1243,    -1,    -1,
    1246,  1247,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   258,    -1,    -1,
     261,    -1,  2509,  2510,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   274,    -1,   276,    -1,  2524,    -1,    -1,
      -1,    -1,  2529,  2530,  2531,  2532,  2533,    -1,     5,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    20,  1906,    -1,    -1,  1313,    -1,    -1,
      -1,  1317,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    41,    42,    -1,   328,    -1,    -1,
      47,  1337,    49,    50,    -1,    -1,  2583,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    -1,    -1,    -1,  1370,    -1,    -1,    -1,    -1,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,  1397,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,
     401,   402,   403,    -1,   405,   406,   407,   408,   409,   410,
      -1,    -1,    -1,    -1,    -1,    -1,  1422,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1453,    -1,  1455,
      -1,    -1,    -1,  1459,    -1,    -1,    -1,    -1,    -1,  2706,
      -1,    -1,    -1,    -1,    -1,    -1,   183,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   199,  2730,  1490,    -1,    -1,    -1,  2735,    -1,
    2737,  2738,    -1,    -1,    -1,  2742,    -1,    -1,    -1,   216,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1514,  1515,
      -1,    -1,    -1,    -1,    -1,    -1,  1522,    -1,    -1,  1525,
    1526,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,   246,
      -1,    -1,    -1,    -1,  2136,    -1,    -1,    -1,    -1,  1545,
      -1,    -1,  2789,  1549,  1550,  1551,   263,  1553,  2795,    -1,
      -1,    -1,  2799,    -1,  1560,  1561,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1578,  1579,    -1,    -1,  1582,  1583,    -1,    -1,
      -1,  1587,    -1,    -1,    -1,  1591,    -1,    -1,  1594,  1595,
    1596,  1597,  1598,  1599,  1600,  1601,  1602,    -1,  1604,    -1,
     317,    -1,  1608,    -1,    -1,    -1,  1612,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2224,  2225,  2226,    -1,    -1,    78,    -1,    -1,
      -1,    -1,    -1,   350,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    -1,    -1,    -1,    -1,    -1,   363,    98,    -1,  2896,
      -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,   375,    -1,
    2262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   386,
      -1,  2273,   389,   390,    -1,   392,    -1,   394,    -1,    -1,
      -1,   398,    -1,   400,   401,    -1,    -1,    -1,   405,   406,
     407,   408,   409,    -1,    -1,   412,   413,   414,   415,    -1,
     417,   418,   419,   420,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1751,    -1,    -1,    -1,   200,
      -1,    -1,    -1,   204,  1760,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   222,   223,  3020,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3042,    -1,    -1,    -1,  3046,
      -1,    -1,     5,    -1,    -1,    -1,    -1,   258,    -1,    -1,
     261,    -1,    -1,  1819,    -1,    -1,    -1,    20,  1824,    -1,
      -1,    -1,    -1,   274,    -1,   276,    29,    -1,    -1,    -1,
      -1,  1837,    -1,  1839,   285,    -1,    -1,    -1,    41,    42,
      -1,    -1,    -1,    -1,  3091,  3092,    49,    50,    -1,    -1,
      -1,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    -1,    -1,   328,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1893,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2499,  2500,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,  1924,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1943,    -1,    -1,
     391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2551,
     401,   402,   403,    -1,   405,   406,   407,   408,   409,   410,
      -1,    -1,    -1,    -1,    -1,    -1,  1972,  1973,  1974,    -1,
      -1,  1977,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     183,    -1,    -1,  1989,  1990,  1991,  1992,    -1,    -1,    -1,
      -1,    -1,  1998,    -1,    -1,    -1,   199,    -1,    -1,    -1,
      -1,    -1,    -1,  2009,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   216,  2020,  2021,    -1,  2023,    -1,    -1,
      -1,  2027,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     243,    -1,    -1,   246,  2050,    -1,  2052,  2053,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     263,    -1,    -1,   685,    -1,    -1,    -1,   689,    -1,    -1,
      -1,  2077,    -1,    -1,    -1,    -1,    -1,    -1,  2084,  2085,
    2086,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   715,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2108,    -1,    -1,    -1,    -1,    -1,  2114,    -1,
      -1,    -1,    -1,    -1,   317,    -1,  2718,    -1,    -1,    -1,
    2126,    -1,    -1,  2725,    -1,    -1,    -1,    -1,   750,    -1,
      -1,    -1,    -1,    -1,   756,    -1,    -1,  2143,    -1,  2145,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   350,    -1,    -1,
      -1,    -1,    -1,  2159,    -1,    -1,    -1,    -1,    -1,    -1,
     363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    78,   375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2187,    -1,   386,    91,    -1,   389,   390,    -1,   392,
      -1,    98,    -1,    -1,    -1,   398,   103,   400,   401,  2205,
      -1,    -1,   405,   406,   407,   408,   409,    -1,    -1,   412,
     413,   414,    -1,    -1,    -1,   418,    -1,   839,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2246,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2265,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,   204,    -1,    -1,
      -1,    -1,    -1,    -1,  2310,    -1,    -1,    -1,    -1,    -1,
    2316,    -1,    -1,  2319,    -1,   222,   223,    -1,    -1,    -1,
      -1,    -1,  2328,    -1,  2330,    -1,    -1,   234,  2334,    -1,
      -1,    -1,    -1,    -1,  2340,  2341,    -1,    -1,  2344,  2345,
    2346,  2347,  2348,  2349,  2350,  2351,  2352,  2353,    -1,    -1,
      -1,   258,  2358,  2359,   261,    -1,    -1,    -1,    -1,    -1,
      -1,  2367,    -1,    -1,    -1,    -1,  2372,   274,    -1,   276,
      -1,    -1,    -1,  2379,  2380,  2381,    -1,  2383,    -1,    -1,
    1002,    -1,    -1,  2389,  2390,    -1,  1008,    -1,    -1,  2395,
      -1,    -1,  2398,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2407,  1024,  3005,    -1,    -1,    78,    -1,    -1,     5,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,
      -1,   328,    94,    -1,    20,  1047,    98,    -1,    -1,    -1,
      -1,   103,    -1,    29,    -1,  1057,    -1,    -1,    -1,    -1,
     347,    -1,    -1,    -1,  2450,    41,    42,    -1,    -1,    -1,
      -1,    -1,    -1,    49,    50,    -1,    -1,    -1,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    -1,    -1,   391,    -1,    -1,    -1,  1110,  2495,
      -1,    -1,    -1,    -1,   401,   402,   403,    -1,   405,   406,
     407,   408,   409,   410,    -1,    -1,    -1,    -1,    -1,    -1,
    1132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     116,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,   204,    -1,  1156,  1157,    -1,  1159,  1160,  1161,
      -1,    -1,    -1,    -1,    -1,    -1,  2552,    -1,    -1,    -1,
     222,   223,    -1,    -1,    -1,    -1,  1178,  2563,    -1,    -1,
      -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   258,   183,    -1,   261,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2606,    -1,   274,   199,   276,    -1,    -1,    -1,    -1,    -1,
    2616,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     216,  1243,    -1,    -1,  1246,  1247,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
     246,    -1,    -1,    -1,    -1,  2661,   328,    -1,    -1,  2665,
    2666,  2667,    -1,    -1,  2670,    -1,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2684,    -1,
      -1,    -1,  2688,    -1,    -1,    -1,  2692,    -1,    -1,    -1,
      -1,  1313,    -1,  2699,    -1,  1317,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1337,    -1,    -1,    -1,   391,
      -1,   317,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   401,
     402,   403,    -1,   405,   406,   407,   408,   409,   410,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1370,    -1,
      -1,    -1,    -1,    78,   350,    -1,  2762,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    91,   363,    -1,    -1,
      -1,    -1,    -1,    98,    -1,  1397,    -1,    -1,   103,   375,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2794,    -1,
     386,    -1,    -1,   389,   390,    -1,   392,    -1,    -1,    -1,
    1422,    -1,   398,    -1,   400,   401,    -1,    -1,    -1,   405,
     406,   407,   408,   409,  2820,    -1,   412,   413,   414,   415,
      -1,    -1,    -1,  2829,    -1,  2831,    -1,    -1,    -1,    -1,
    2836,  1453,    -1,  1455,  2840,    -1,    -1,  1459,    -1,    -1,
      78,    -1,    -1,    -1,    -1,  2851,    -1,    -1,    -1,    -1,
    2856,    -1,    -1,    91,  2860,    -1,    -1,    -1,    -1,    -1,
      98,  2867,  2868,    -1,   189,   103,    -1,    -1,  1490,    -1,
      -1,  2877,    -1,    -1,    -1,   200,    -1,    -1,    -1,   204,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2893,    -1,    -1,
      -1,    -1,  1514,  1515,    -1,    -1,    -1,   222,   223,    -1,
    1522,  2907,    -1,  1525,  1526,    -1,    -1,    -1,    -1,   234,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1545,  2930,    -1,    -1,  1549,  1550,  1551,
      -1,  1553,    -1,   258,    -1,    -1,   261,    -1,  1560,  1561,
      -1,    -1,    -1,    -1,    -1,    -1,  2952,    -1,    -1,   274,
      -1,   276,    -1,    -1,    -1,  2961,  1578,  1579,    -1,  2965,
    1582,  1583,   200,    -1,  2970,  1587,   204,    -1,    -1,  1591,
      -1,    -1,  1594,  1595,  1596,  1597,  1598,  1599,  1600,  1601,
    1602,    -1,  1604,    -1,   222,   223,  1608,    -1,    -1,    -1,
    1612,    -1,    -1,    -1,    -1,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,    -1,  3015,
      -1,    -1,    -1,  3019,    -1,    -1,    -1,    -1,    -1,    -1,
     258,    -1,    -1,   261,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3039,    -1,    -1,   274,    -1,   276,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     3,    -1,    -1,    -1,
      -1,    -1,     9,    -1,    -1,    -1,   391,    -1,    -1,    -1,
      17,    -1,    19,    -1,    -1,    22,   401,   402,   403,    -1,
     405,   406,   407,   408,   409,   410,    33,  3093,    -1,    -1,
     328,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
    3116,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1751,
      -1,    -1,    79,    -1,    -1,    -1,    -1,    -1,  1760,   839,
      -1,    88,    89,    90,  3150,    -1,    -1,  3153,    -1,    -1,
      -1,    -1,    -1,   391,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   401,   402,   403,    -1,   405,   406,   407,
     408,   409,   410,   120,    -1,   122,   123,    -1,    -1,    -1,
     127,   128,    -1,    -1,    -1,    -1,    -1,   134,   135,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1819,    -1,   146,
      -1,   148,  1824,    -1,   151,    -1,    -1,    -1,    -1,    -1,
     157,    -1,    -1,    -1,    -1,  1837,    -1,  1839,   165,    -1,
      -1,    -1,    -1,   170,    -1,    -1,    -1,    -1,   175,    -1,
     177,    -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   192,    -1,   194,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   214,    -1,    -1,
      -1,  1893,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   236,
     237,    -1,    -1,   240,    -1,    -1,    -1,    -1,    -1,    -1,
     247,    -1,  1924,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   260,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1943,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   289,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1972,  1973,  1974,   300,    -1,  1977,    -1,    -1,   305,    -1,
      -1,    -1,   309,    -1,   311,    -1,    -1,  1989,  1990,  1991,
    1992,    -1,   319,    -1,    -1,    -1,  1998,   324,    -1,    -1,
     327,    -1,    -1,    -1,    -1,    -1,   333,  2009,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2020,  2021,
      -1,  2023,    -1,    -1,    -1,  2027,    -1,    -1,    -1,    -1,
    1110,   358,    -1,   360,    -1,    -1,    -1,    -1,    -1,   366,
      -1,   368,    -1,    -1,    -1,   372,    -1,    -1,  2050,    -1,
    2052,  2053,  1132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2077,  1156,  1157,    -1,  1159,
    1160,  1161,  2084,  2085,  2086,    -1,    -1,   414,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1178,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2108,    -1,    -1,    -1,
      -1,    -1,  2114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2126,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2143,    -1,  2145,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2159,    -1,    -1,
      -1,    -1,    -1,  1243,    -1,    -1,  1246,  1247,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2187,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2205,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1313,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1175,    -1,    -1,  2246,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2265,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2288,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2310,    -1,
      -1,    -1,    -1,    -1,  2316,    -1,    -1,  2319,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2328,    -1,  2330,    -1,
      -1,    -1,  2334,    -1,    -1,    -1,    -1,    -1,  2340,  2341,
      -1,    -1,  2344,  2345,  2346,  2347,  2348,  2349,  2350,  2351,
    2352,  2353,    -1,    -1,    -1,    -1,  2358,  2359,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2367,    -1,    -1,    -1,    -1,
    2372,    -1,    -1,  1453,    -1,    -1,    -1,  2379,  2380,  2381,
      -1,  2383,    -1,    -1,    -1,    -1,    -1,  2389,  2390,    -1,
      -1,    -1,    -1,  2395,    -1,    -1,  2398,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2407,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1522,    -1,    -1,    -1,  1526,    -1,  2450,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1545,    -1,    -1,    -1,  1549,
      -1,    -1,    -1,  1553,    -1,    -1,    -1,    -1,    -1,    -1,
    1560,  1561,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2495,    -1,    -1,    -1,    -1,    -1,  1579,
      -1,    -1,    -1,  1583,    -1,    -1,    -1,  1587,    -1,    -1,
      -1,  1591,    -1,    -1,  1594,  1595,  1596,  1597,  1598,  1599,
    1600,  1601,  1602,    -1,  1604,    -1,    -1,    -1,  1608,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2552,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2563,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1520,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2606,    -1,    -1,    -1,    -1,    -1,
    1544,    -1,    -1,    -1,  2616,    -1,  1550,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1565,  1566,  1567,  1568,    -1,  1570,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1582,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2661,
      -1,    -1,    -1,  2665,  2666,  2667,    -1,    -1,  2670,    -1,
      -1,  1751,  1606,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2684,    -1,    -1,    -1,  2688,    -1,    -1,    -1,
    2692,    -1,    -1,    -1,    -1,    -1,    -1,  2699,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1672,    -1,
      -1,    -1,    -1,    -1,  1678,    -1,  1680,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1837,    -1,    -1,
    2762,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2794,    -1,    -1,  1729,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2820,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2829,    -1,  2831,
      -1,    -1,    -1,    -1,  2836,    -1,    -1,    -1,  2840,    -1,
      -1,    -1,    -1,    -1,  1924,    -1,    -1,    -1,    -1,  2851,
      -1,    -1,    -1,    -1,  2856,    -1,    -1,    -1,  2860,    -1,
      -1,    -1,    -1,  1943,    -1,  2867,  2868,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2877,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2893,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2907,    -1,    -1,    -1,  1989,
      -1,  1991,  1992,    -1,    -1,    -1,    -1,    -1,  1998,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2930,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2021,    -1,  2023,    -1,    -1,    -1,  2027,    -1,    -1,
    2952,    -1,    -1,    -1,    -1,    -1,    -1,  1891,    -1,  2961,
      -1,    -1,    -1,  2965,    -1,    -1,    -1,    -1,  2970,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2077,    -1,    -1,
      -1,    -1,    -1,  1937,  2084,  2085,  2086,    -1,    -1,    -1,
      -1,    -1,  1946,  3015,  1948,    -1,    -1,  3019,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2108,    -1,
      -1,    -1,    -1,  1967,  2114,    -1,  1970,  3039,  1972,  1973,
    1974,  1975,    -1,  1977,    -1,    -1,    -1,  1981,    -1,    -1,
      -1,    -1,    -1,    -1,  1988,    -1,    -1,    -1,    -1,  1993,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2004,    -1,    -1,  2007,  2008,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2019,  2020,    -1,    -1,    -1,
      -1,  3093,  2026,    -1,  2028,  2029,  2030,  2031,  2032,  2033,
    2034,  2035,  2036,  2037,    -1,    -1,    -1,    -1,     5,    -1,
      -1,    -1,    -1,    -1,  3116,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    20,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    41,    42,    -1,    -1,  3150,    -1,
      -1,  3153,    49,    50,    -1,    -1,    -1,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,  2121,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2310,    -1,    -1,    -1,    -1,    -1,  2316,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2328,    -1,
    2330,    -1,    -1,    -1,  2334,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2206,    -1,    -1,    -1,    -1,    -1,  2358,  2359,
      -1,    -1,    -1,    -1,    -1,    -1,   183,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2381,   199,  2383,    -1,    -1,    -1,    -1,    -1,    -1,
    2390,    -1,    -1,    -1,    -1,  2395,    -1,    -1,  2398,   216,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,   246,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2295,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,
    2450,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2337,  2338,  2339,    -1,  2341,    -1,    -1,
    2344,  2345,  2346,  2347,  2348,  2349,  2350,  2351,  2352,  2353,
     317,  2355,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2375,    -1,    -1,    -1,    -1,  2380,    -1,    -1,    -1,
      -1,    -1,    -1,   350,    -1,    -1,    -1,  2391,  2392,    -1,
    2394,    -1,    -1,  2397,    -1,    -1,   363,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   375,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   386,
      -1,    -1,   389,   390,    -1,   392,    -1,    -1,    -1,    -1,
      -1,   398,    -1,   400,   401,    -1,    -1,    -1,   405,   406,
     407,   408,   409,    -1,    -1,   412,   413,   414,   415,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2606,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2469,  2616,    -1,  2472,    -1,
      -1,    -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    20,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      41,    42,    -1,    -1,    -1,    -1,  2666,  2667,    49,    50,
    2670,    -1,    -1,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    -1,  2552,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2613,
      -1,    -1,  2762,  2617,    -1,    -1,    -1,    -1,  2622,  2623,
      -1,  2625,    -1,    -1,  2628,    -1,    -1,    -1,  2632,  2633,
    2634,  2635,  2636,  2637,  2638,  2639,  2640,  2641,  2642,  2643,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   183,  2657,  2658,    -1,  2660,    -1,    -1,    -1,
    2664,  2665,    -1,    -1,  2668,    -1,    -1,  2671,   199,    -1,
    2820,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,    -1,    -1,
    2840,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2711,    -1,    -1,
      -1,    -1,   243,    -1,    -1,   246,    -1,    -1,  2868,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2877,    -1,    -1,
      -1,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2893,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2764,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2930,    -1,    -1,    -1,    -1,    -1,   317,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2961,    -1,    -1,    -1,    -1,    -1,    -1,  2822,   350,
      -1,    -1,    -1,    -1,    -1,  2829,    -1,  2831,    -1,    -1,
      -1,    -1,   363,  2837,  2838,  2839,    -1,  2841,    -1,    -1,
      -1,    -1,    -1,    -1,   375,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   386,    -1,    -1,   389,   390,
      -1,   392,    -1,    -1,    -1,    -1,    -1,   398,    -1,   400,
     401,    -1,    -1,    -1,   405,   406,   407,   408,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,    -1,    -1,  3039,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2911,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2951,  2952,  2953,
      -1,    -1,  2956,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2973,
      -1,    -1,    -1,  2977,    -1,    -1,    -1,  2981,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,  3013,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,  3028,    52,    53,    -1,  3032,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,   110,    -1,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,    -1,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   175,   176,
     177,    -1,   179,   180,   181,   182,   183,   184,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,   195,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   219,   220,    -1,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,    -1,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,   389,    -1,    -1,   392,    -1,    -1,     6,     7,
       8,    -1,    -1,    11,    12,    -1,    14,    15,    16,    -1,
      -1,    -1,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,   418,    30,    31,    32,    -1,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    42,    -1,    44,    45,    46,    -1,
      48,    49,    50,    -1,    -1,    -1,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    99,    -1,    -1,    -1,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   133,    -1,    -1,    -1,    -1,
     138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   176,    -1,
      -1,   179,    -1,    -1,    -1,   183,    -1,    -1,    -1,    -1,
     188,    -1,   190,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   200,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   210,   211,    -1,    -1,    -1,    -1,    -1,   217,
      -1,   219,    -1,    -1,   222,   223,    -1,   225,    -1,    -1,
      -1,    -1,    -1,    -1,   232,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   249,   250,   251,    -1,    -1,    -1,    -1,    -1,   257,
      -1,    -1,    -1,   261,    -1,    -1,   264,   265,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     278,   279,   280,   281,    -1,    -1,    -1,    -1,   286,   287,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   297,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   310,    -1,   312,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   325,    -1,    -1,
     328,    -1,   330,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     348,   349,    -1,    -1,    -1,    -1,   354,    -1,   356,    -1,
      -1,    -1,    -1,    -1,    -1,   363,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   375,    -1,   377,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   389,    -1,    -1,   392,    -1,    -1,    -1,     6,     7,
       8,    -1,    -1,    11,    12,    -1,    14,    15,    16,    -1,
      -1,    -1,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,   419,    30,    31,    32,    -1,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    42,    -1,    44,    45,    46,    -1,
      48,    49,    50,    -1,    -1,    -1,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    99,    -1,    -1,    -1,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   133,    -1,    -1,    -1,    -1,
     138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   176,    -1,
      -1,   179,    -1,    -1,    -1,   183,    -1,    -1,    -1,    -1,
     188,    -1,   190,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   200,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   210,   211,    -1,    -1,    -1,    -1,    -1,   217,
      -1,   219,    -1,    -1,   222,   223,    -1,   225,    -1,    -1,
      -1,    -1,    -1,    -1,   232,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   249,   250,   251,    -1,    -1,    -1,    -1,    -1,   257,
      -1,    -1,    -1,   261,    -1,    -1,   264,   265,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     278,   279,   280,   281,    -1,    -1,    -1,    -1,   286,   287,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   297,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   310,    -1,   312,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   325,    -1,    -1,
     328,    -1,   330,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     348,   349,    -1,    -1,    -1,    -1,   354,    -1,   356,    -1,
      -1,    -1,    -1,    -1,    -1,   363,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   375,    -1,   377,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   389,    -1,    -1,   392,     3,    -1,    -1,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,   419,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    42,    -1,    44,    45,    46,    -1,
      48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    89,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,   127,
     128,    -1,    -1,    -1,    -1,   133,   134,   135,    -1,    -1,
     138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   146,    -1,
     148,   149,   150,   151,    -1,    -1,    -1,    -1,    -1,   157,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   165,    -1,    -1,
      -1,    -1,   170,    -1,    -1,    -1,    -1,   175,   176,   177,
      -1,   179,    -1,   181,    -1,   183,    -1,    -1,    -1,    -1,
     188,    -1,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
      -1,    -1,   200,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   210,   211,    -1,    -1,   214,    -1,    -1,   217,
      -1,   219,    -1,    -1,   222,   223,    -1,   225,    -1,    -1,
      -1,    -1,    -1,    -1,   232,    -1,   234,    -1,   236,   237,
      -1,    -1,   240,    -1,    -1,    -1,    -1,    -1,    -1,   247,
      -1,   249,   250,   251,    -1,    -1,    -1,    -1,    -1,   257,
      -1,    -1,   260,   261,    -1,    -1,   264,   265,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     278,   279,   280,   281,    -1,    -1,    -1,    -1,   286,   287,
      -1,   289,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   297,
      -1,    -1,   300,    -1,    -1,    -1,    -1,   305,    -1,    -1,
      -1,   309,   310,   311,   312,    -1,    -1,    -1,    -1,    -1,
      -1,   319,    -1,    -1,    -1,    -1,   324,   325,    -1,   327,
     328,    -1,   330,    -1,    -1,   333,    -1,    -1,    -1,    -1,
      -1,    -1,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     348,   349,    -1,    -1,    -1,    -1,   354,    -1,   356,    -1,
     358,    -1,   360,    -1,    -1,   363,    -1,    -1,   366,    -1,
     368,    -1,    -1,    -1,   372,    -1,    -1,   375,    -1,   377,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   389,    -1,    -1,   392,    -1,    -1,    -1,    -1,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,   414,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      -1,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    -1,    -1,    -1,    93,    -1,    -1,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,    -1,   109,   110,    -1,   112,   113,   114,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,    -1,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,    -1,   153,    -1,   155,
      -1,   157,   158,   159,    -1,   161,    -1,   163,   164,   165,
     166,    -1,   168,   169,    -1,   171,    -1,   173,   174,   175,
     176,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
      -1,   187,   188,    -1,   190,   191,    -1,   193,    -1,    -1,
     196,    -1,   198,   199,   200,   201,   202,   203,    -1,   205,
     206,   207,   208,    -1,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,   219,    -1,    -1,   222,   223,   224,   225,
     226,   227,   228,   229,   230,    -1,   232,   233,   234,    -1,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,    -1,   263,   264,   265,
     266,   267,    -1,    -1,   270,   271,    -1,    -1,   274,   275,
      -1,    -1,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,    -1,   291,   292,   293,   294,   295,
     296,   297,   298,    -1,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,    -1,    -1,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,    -1,   343,   344,   345,
     346,    -1,   348,   349,    -1,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,    -1,    -1,    -1,   382,   383,   384,   385,
     386,   387,    -1,   389,   390,   391,   392,   393,    -1,    -1,
     396,   397,   398,   399,   400,    -1,    -1,    -1,    -1,   405,
     406,   407,    -1,   409,   410,    -1,    -1,    -1,   414,   415,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    93,    -1,
      -1,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,    -1,   131,   132,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,    -1,   153,    -1,
     155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,
     165,   166,    -1,   168,   169,    -1,   171,    -1,   173,   174,
     175,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,    -1,   187,   188,    -1,   190,   191,    -1,   193,    -1,
      -1,   196,    -1,   198,   199,   200,   201,   202,   203,    -1,
     205,   206,   207,   208,    -1,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,   219,    -1,    -1,   222,   223,   224,
     225,   226,   227,   228,   229,   230,    -1,   232,   233,   234,
      -1,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,    -1,   263,   264,
     265,   266,   267,    -1,    -1,   270,   271,    -1,    -1,   274,
     275,    -1,    -1,   278,   279,   280,   281,   282,   283,   284,
      -1,   286,   287,   288,   289,    -1,   291,   292,   293,   294,
     295,   296,   297,   298,    -1,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,    -1,    -1,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,    -1,   343,   344,
     345,   346,    -1,   348,   349,    -1,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,   366,   367,   368,   369,   370,    -1,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,   384,
     385,   386,   387,    -1,   389,   390,   391,   392,   393,    -1,
      -1,   396,   397,   398,   399,   400,    -1,    -1,    -1,    -1,
     405,   406,    -1,    -1,   409,   410,    -1,    -1,    -1,   414,
     415,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    -1,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    49,    50,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,    93,
      -1,    -1,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,    -1,   109,   110,    -1,   112,   113,
     114,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,    -1,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,    -1,   153,
      -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,
     164,   165,   166,    -1,   168,   169,    -1,   171,    -1,   173,
     174,   175,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,    -1,   187,   188,    -1,   190,   191,    -1,   193,
      -1,    -1,   196,    -1,   198,   199,   200,   201,   202,   203,
      -1,   205,   206,   207,   208,    -1,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,   219,    -1,    -1,   222,   223,
     224,   225,   226,   227,   228,   229,   230,    -1,   232,   233,
     234,    -1,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,    -1,   263,
     264,   265,   266,   267,    -1,    -1,   270,   271,    -1,    -1,
     274,   275,    -1,    -1,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,    -1,   291,   292,   293,
     294,   295,   296,   297,   298,    -1,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,    -1,    -1,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,    -1,   343,
     344,   345,   346,    -1,   348,   349,    -1,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,   366,   367,   368,   369,   370,    -1,   372,   373,
     374,   375,   376,   377,   378,    -1,    -1,    -1,   382,   383,
     384,   385,   386,   387,    -1,   389,   390,   391,   392,   393,
      -1,    -1,   396,   397,   398,   399,   400,    -1,    -1,    -1,
      -1,   405,   406,    -1,    -1,   409,   410,    -1,    -1,    -1,
     414,   415,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,   189,   190,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,   200,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,    -1,
     263,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,    -1,   396,   397,   398,   399,   400,    -1,    -1,
      -1,    -1,   405,   406,    -1,    -1,   409,   410,    -1,    -1,
      -1,   414,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,    -1,   190,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,   200,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,   222,
     223,   224,   225,   226,   227,   228,   229,   230,    -1,   232,
     233,   234,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,    -1,
     263,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,    -1,   396,   397,   398,   399,   400,    -1,    -1,
      -1,    -1,   405,   406,   407,    -1,   409,   410,    -1,    -1,
      -1,   414,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,    -1,   190,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,   200,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,   222,
     223,   224,   225,   226,   227,   228,   229,   230,    -1,   232,
     233,   234,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,    -1,
     263,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,    -1,   396,   397,   398,   399,   400,    -1,    -1,
      -1,    -1,   405,   406,    -1,    -1,   409,   410,    -1,    -1,
      -1,   414,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,    -1,   190,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,   200,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,   222,
     223,   224,   225,   226,   227,   228,   229,   230,    -1,   232,
     233,   234,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,    -1,
     263,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,    -1,   396,   397,   398,   399,   400,    -1,    -1,
      -1,    -1,   405,   406,    -1,    -1,   409,   410,    -1,    -1,
      -1,   414,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,    -1,   190,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,   200,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,   222,
     223,   224,   225,   226,   227,   228,   229,   230,    -1,   232,
     233,   234,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,    -1,
     263,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,    -1,   396,   397,   398,   399,   400,    -1,    -1,
      -1,    -1,   405,   406,    -1,    -1,   409,   410,    -1,   412,
      -1,   414,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,    -1,   190,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,   200,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,   222,
     223,   224,   225,   226,   227,   228,   229,   230,    -1,   232,
     233,   234,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,    -1,
     263,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,    -1,   396,   397,   398,   399,   400,    -1,    -1,
      -1,    -1,   405,   406,    -1,    -1,   409,   410,    -1,    -1,
      -1,   414,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,   189,   190,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,   200,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,   222,
     223,   224,   225,   226,   227,   228,   229,   230,    -1,   232,
     233,   234,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,    -1,
     263,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,    -1,   396,   397,   398,   399,   400,    -1,    -1,
      -1,    -1,   405,   406,    -1,    -1,   409,   410,    -1,    -1,
      -1,   414,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,    -1,   190,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,   200,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,   222,
     223,   224,   225,   226,   227,   228,   229,   230,    -1,   232,
     233,   234,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,    -1,
     263,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,    -1,   396,   397,   398,   399,   400,    -1,    -1,
      -1,    -1,   405,   406,    -1,    -1,   409,   410,    -1,    -1,
      -1,   414,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,    -1,   190,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,   200,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,   222,
     223,   224,   225,   226,   227,   228,   229,   230,    -1,   232,
     233,   234,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,    -1,
     263,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,    -1,   396,   397,   398,   399,   400,    -1,    -1,
      -1,    -1,   405,   406,    -1,    -1,   409,   410,    -1,    -1,
      -1,   414,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,    -1,   190,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,   200,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,   222,
     223,   224,   225,   226,   227,   228,   229,   230,    -1,   232,
     233,   234,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,    -1,   259,   260,   261,    -1,
     263,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,    -1,   396,   397,   398,   399,   400,    -1,    -1,
      -1,    -1,    -1,   406,    -1,    -1,   409,   410,    -1,    -1,
      -1,   414,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
      -1,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,    -1,    -1,
     173,   174,   175,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,    -1,   190,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,   222,
     223,   224,   225,   226,   227,   228,   229,   230,    -1,   232,
     233,    -1,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,    -1,   259,   260,   261,    -1,
     263,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,    -1,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,    -1,   396,   397,   398,   399,   400,    -1,    -1,
      -1,    -1,   405,   406,    -1,    -1,   409,   410,    -1,    -1,
      -1,   414,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,    -1,   187,   188,    -1,   190,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,   200,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,   222,
     223,   224,   225,   226,   227,   228,   229,   230,    -1,   232,
     233,   234,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,    -1,   259,   260,   261,    -1,
     263,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,    -1,   392,
     393,    -1,    -1,   396,   397,   398,   399,   400,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,   414,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    88,    -1,    -1,    -1,    -1,    93,    -1,    -1,    96,
      97,    98,    99,   100,   101,   102,    -1,   104,   105,   106,
     107,    -1,   109,   110,    -1,   112,   113,   114,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,    -1,   131,   132,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,    -1,   153,    -1,   155,    -1,
     157,   158,   159,    -1,    -1,    -1,   163,   164,   165,   166,
      -1,   168,   169,    -1,    -1,    -1,   173,   174,   175,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,    -1,
     187,   188,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
      -1,   198,   199,    -1,   201,   202,   203,    -1,   205,   206,
     207,   208,    -1,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,   219,    -1,    -1,   222,   223,   224,   225,   226,
     227,   228,   229,   230,    -1,   232,   233,    -1,    -1,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,    -1,   259,   260,   261,    -1,   263,   264,   265,   266,
     267,    -1,    -1,   270,   271,    -1,    -1,    -1,   275,    -1,
      -1,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,   289,    -1,   291,   292,   293,   294,   295,   296,
     297,   298,    -1,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,    -1,    -1,   320,   321,   322,   323,   324,   325,   326,
     327,    -1,   329,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,    -1,   343,   344,   345,   346,
      -1,   348,   349,    -1,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,   370,    -1,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,   384,   385,   386,
     387,    -1,   389,   390,    -1,   392,   393,    -1,    -1,   396,
     397,   398,   399,   400,    -1,    -1,    -1,    -1,    -1,   406,
      -1,    -1,   409,   410,    -1,    -1,    -1,   414,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    -1,    -1,    92,    93,    -1,    -1,    96,
      97,    98,    99,   100,   101,   102,    -1,   104,   105,   106,
     107,    -1,   109,   110,    -1,   112,   113,   114,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,    -1,   131,   132,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,    -1,   153,    -1,   155,    -1,
     157,   158,   159,    -1,    -1,    -1,   163,   164,   165,   166,
      -1,   168,   169,    -1,    -1,    -1,   173,   174,   175,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,    -1,
     187,   188,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
      -1,   198,   199,    -1,   201,   202,   203,    -1,   205,   206,
     207,   208,    -1,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,   226,
     227,   228,   229,   230,    -1,   232,   233,    -1,    -1,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,    -1,   259,   260,    -1,    -1,   263,   264,   265,   266,
     267,    -1,    -1,   270,   271,    -1,    -1,    -1,   275,    -1,
      -1,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,   289,    -1,   291,   292,   293,   294,   295,   296,
     297,   298,    -1,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,    -1,    -1,   320,   321,   322,   323,   324,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,    -1,   343,   344,   345,   346,
      -1,   348,   349,    -1,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,   366,
     367,   368,   369,   370,    -1,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,   384,   385,   386,
     387,    -1,   389,   390,    -1,   392,   393,    -1,    -1,   396,
     397,   398,   399,   400,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   410,    -1,    -1,    -1,   414,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    -1,    -1,    92,    93,    -1,    -1,    96,
      97,    98,    99,   100,   101,   102,    -1,   104,   105,   106,
     107,    -1,   109,   110,    -1,   112,   113,   114,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,    -1,   131,   132,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,    -1,   153,    -1,   155,    -1,
     157,   158,   159,    -1,    -1,    -1,   163,   164,   165,   166,
      -1,   168,   169,    -1,    -1,    -1,   173,   174,   175,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,    -1,
     187,   188,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
      -1,   198,   199,    -1,   201,   202,   203,    -1,   205,   206,
     207,   208,    -1,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,   226,
     227,   228,   229,   230,    -1,   232,   233,    -1,    -1,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,    -1,   259,   260,    -1,    -1,   263,   264,   265,   266,
     267,    -1,    -1,   270,   271,    -1,    -1,    -1,   275,    -1,
      -1,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,   289,    -1,   291,   292,   293,   294,   295,   296,
     297,   298,    -1,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,    -1,    -1,   320,   321,   322,   323,   324,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,    -1,   343,   344,   345,   346,
      -1,   348,   349,    -1,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,   366,
     367,   368,   369,   370,    -1,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,   384,   385,   386,
     387,    -1,   389,   390,    -1,   392,   393,    -1,    -1,   396,
     397,   398,   399,   400,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,   414,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    88,    -1,    -1,
      -1,    -1,    93,    -1,    -1,    96,    97,    98,    99,   100,
     101,   102,    -1,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,    -1,   153,    -1,   155,    -1,   157,   158,   159,    -1,
      -1,    -1,   163,   164,   165,   166,    -1,   168,   169,    -1,
      -1,    -1,   173,   174,   175,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,    -1,   187,   188,    -1,   190,
     191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,    -1,
     201,   202,   203,    -1,   205,   206,   207,   208,    -1,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,   219,    -1,
      -1,    -1,    -1,   224,   225,   226,   227,   228,   229,   230,
      -1,   232,   233,    -1,    -1,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,    -1,   259,   260,
      -1,    -1,    -1,   264,   265,   266,   267,    -1,    -1,   270,
     271,    -1,    -1,    -1,   275,    -1,    -1,   278,   279,   280,
     281,   282,   283,   284,    -1,   286,   287,   288,   289,    -1,
     291,   292,   293,   294,   295,   296,   297,   298,    -1,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,    -1,    -1,   320,
     321,   322,   323,   324,   325,   326,   327,    -1,   329,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,    -1,   343,   344,   345,   346,    -1,   348,   349,    -1,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,   384,   385,   386,   387,    -1,   389,   390,
      -1,   392,   393,    -1,    -1,   396,   397,   398,   399,   400,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   410,
      -1,    -1,    -1,   414,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    88,    -1,    -1,
      -1,    -1,    93,    -1,    -1,    96,    97,    98,    99,   100,
     101,   102,    -1,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,    -1,   153,    -1,   155,    -1,   157,   158,   159,    -1,
      -1,    -1,   163,   164,   165,   166,    -1,   168,   169,    -1,
      -1,    -1,   173,   174,   175,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,    -1,   187,   188,    -1,   190,
     191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,    -1,
     201,   202,   203,    -1,   205,   206,   207,   208,    -1,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,   219,    -1,
      -1,    -1,    -1,   224,   225,   226,   227,   228,   229,   230,
      -1,   232,   233,    -1,    -1,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,    -1,   259,   260,
      -1,    -1,    -1,   264,   265,   266,   267,    -1,    -1,   270,
     271,    -1,    -1,    -1,   275,    -1,    -1,   278,   279,   280,
     281,   282,   283,   284,    -1,   286,   287,   288,   289,    -1,
     291,   292,   293,   294,   295,   296,   297,   298,    -1,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,    -1,    -1,   320,
     321,   322,   323,   324,   325,   326,   327,    -1,   329,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,    -1,   343,   344,   345,   346,    -1,   348,   349,    -1,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,   384,   385,   386,   387,    -1,   389,   390,
      -1,   392,   393,    -1,    -1,   396,   397,   398,   399,   400,
      -1,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,   414,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    94,
      -1,    96,    97,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,    -1,   131,   132,   133,   134,
      -1,   136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,    -1,   153,    -1,
     155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,
     165,   166,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,    -1,   179,    -1,   181,   182,   183,   184,
     185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
      -1,   196,    -1,   198,   199,    -1,   201,   202,   203,    -1,
     205,   206,   207,   208,    -1,    -1,   211,    -1,   213,   214,
     215,    -1,   217,   218,   219,    -1,    -1,    -1,    -1,   224,
      -1,   226,   227,   228,   229,   230,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,    -1,   251,    -1,   253,   254,
     255,   256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,
     265,   266,   267,    -1,   269,   270,    -1,    -1,    -1,   274,
     275,    -1,   277,   278,    -1,    -1,   281,   282,   283,   284,
      -1,   286,   287,   288,   289,    -1,   291,   292,   293,   294,
     295,   296,   297,   298,    -1,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,    -1,    -1,   320,   321,   322,    -1,   324,
     325,   326,   327,    -1,   329,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,    -1,   343,   344,
     345,   346,    -1,   348,   349,    -1,   351,    -1,   353,   354,
     355,   356,    -1,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,    -1,    -1,   372,   373,   374,
     375,   376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,
     385,   386,   387,    -1,   389,    -1,    -1,   392,    -1,    -1,
      -1,    -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
     415,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,    -1,   136,   137,   138,   139,    -1,    -1,
      -1,    -1,   144,   145,   146,   147,   148,   149,   150,   151,
      -1,   153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,
      -1,   163,   164,   165,   166,    -1,   168,   169,    -1,   171,
      -1,   173,   174,   175,   176,   177,    -1,   179,    -1,   181,
     182,   183,    -1,   185,    -1,   187,   188,    -1,   190,   191,
      -1,   193,    -1,    -1,   196,    -1,   198,   199,   200,   201,
     202,   203,    -1,   205,   206,   207,   208,    -1,   210,   211,
      -1,   213,   214,   215,    -1,   217,    -1,   219,    -1,    -1,
     222,   223,   224,   225,   226,   227,   228,   229,   230,    -1,
     232,   233,   234,    -1,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,    -1,   259,   260,   261,
      -1,    -1,   264,   265,   266,   267,    -1,    -1,   270,   271,
      -1,   273,   274,   275,    -1,    -1,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,    -1,   291,
     292,   293,   294,   295,   296,   297,   298,    -1,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
      -1,   343,   344,   345,   346,    -1,   348,   349,    -1,   351,
      -1,   353,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,   375,   376,   377,   378,    -1,    -1,    -1,
     382,   383,   384,   385,   386,   387,    -1,   389,    -1,    -1,
     392,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,   414,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,    -1,   136,   137,   138,   139,
      -1,    -1,    -1,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,    -1,   153,    -1,   155,    -1,   157,   158,   159,
      -1,    -1,    -1,   163,   164,   165,   166,    -1,   168,   169,
      -1,   171,    -1,   173,   174,   175,   176,   177,    -1,   179,
      -1,   181,   182,   183,    -1,   185,    -1,   187,   188,    -1,
     190,   191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,
     200,   201,   202,   203,    -1,   205,   206,   207,   208,    -1,
     210,   211,    -1,   213,   214,   215,    -1,   217,    -1,   219,
      -1,    -1,   222,   223,   224,   225,   226,   227,   228,   229,
     230,    -1,   232,   233,   234,    -1,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,    -1,   259,
     260,   261,    -1,    -1,   264,   265,   266,   267,    -1,    -1,
     270,   271,    -1,   273,   274,   275,    -1,    -1,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
      -1,   291,   292,   293,   294,   295,   296,   297,   298,    -1,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,    -1,    -1,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,    -1,   343,   344,   345,   346,    -1,   348,   349,
      -1,   351,    -1,   353,   354,   355,   356,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,    -1,   372,   373,   374,   375,   376,   377,   378,    -1,
      -1,    -1,   382,   383,   384,   385,   386,   387,    -1,   389,
      -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,   414,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,    -1,   136,   137,
     138,   139,    -1,    -1,    -1,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,    -1,   153,    -1,   155,    -1,   157,
     158,   159,    -1,    -1,    -1,   163,   164,   165,   166,    -1,
     168,   169,    -1,   171,    -1,   173,   174,   175,   176,   177,
      -1,   179,    -1,   181,   182,   183,    -1,   185,    -1,   187,
     188,    -1,   190,   191,    -1,   193,    -1,    -1,   196,    -1,
     198,   199,   200,   201,   202,   203,    -1,   205,   206,   207,
     208,    -1,   210,   211,    -1,   213,   214,   215,    -1,   217,
      -1,   219,    -1,    -1,   222,   223,   224,   225,   226,   227,
     228,   229,   230,    -1,   232,   233,   234,    -1,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
      -1,   259,   260,   261,    -1,    -1,   264,   265,   266,   267,
      -1,    -1,   270,   271,    -1,    -1,   274,   275,    -1,    -1,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,    -1,   291,   292,   293,   294,   295,   296,   297,
     298,    -1,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
      -1,    -1,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,    -1,   343,   344,   345,   346,    -1,
     348,   349,    -1,   351,    -1,   353,   354,   355,   356,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,    -1,   372,   373,   374,   375,   376,   377,
     378,    -1,    -1,    -1,   382,   383,   384,   385,   386,   387,
      -1,   389,    -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,   414,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,    -1,   153,    -1,   155,
      -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,   165,
     166,    -1,   168,   169,    -1,   171,    -1,   173,   174,   175,
     176,   177,    -1,   179,    -1,   181,   182,   183,    -1,   185,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,
     196,    -1,   198,   199,    -1,   201,   202,   203,    -1,   205,
     206,   207,   208,    -1,    -1,   211,    -1,   213,   214,   215,
      -1,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,
     226,   227,   228,   229,   230,    -1,    -1,   233,    -1,    -1,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,    -1,   251,    -1,   253,   254,   255,
     256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,    -1,   274,   275,
      -1,    -1,   278,    -1,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,    -1,   291,   292,   293,   294,   295,
     296,   297,   298,    -1,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,    -1,    -1,   320,   321,   322,    -1,   324,   325,
     326,   327,    -1,   329,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,    -1,   343,   344,   345,
     346,    -1,   348,   349,    -1,   351,    -1,   353,   354,   355,
     356,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,    -1,   372,   373,   374,   375,
     376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,
     386,   387,    -1,   389,   390,    -1,   392,   393,    -1,    -1,
      -1,    -1,   398,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   413,   414,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,    -1,   131,   132,   133,   134,    -1,   136,
     137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,   146,
     147,   148,   149,   150,   151,    -1,   153,    -1,   155,    -1,
     157,   158,   159,    -1,    -1,    -1,   163,   164,   165,   166,
      -1,   168,   169,    -1,   171,    -1,   173,   174,   175,   176,
     177,    -1,   179,    -1,   181,   182,   183,    -1,   185,    -1,
     187,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,   196,
      -1,   198,   199,    -1,   201,   202,   203,    -1,   205,   206,
     207,   208,    -1,    -1,   211,    -1,   213,   214,   215,    -1,
     217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,   226,
     227,   228,   229,   230,    -1,    -1,   233,    -1,    -1,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,    -1,   251,    -1,   253,   254,   255,   256,
     257,    -1,   259,   260,    -1,    -1,    -1,   264,   265,   266,
     267,    -1,    -1,   270,    -1,    -1,    -1,   274,   275,    -1,
      -1,   278,    -1,    -1,   281,   282,   283,   284,    -1,   286,
     287,   288,   289,    -1,   291,   292,   293,   294,   295,   296,
     297,   298,    -1,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,    -1,    -1,   320,   321,   322,    -1,   324,   325,   326,
     327,    -1,   329,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,    -1,   343,   344,   345,   346,
      -1,   348,   349,    -1,   351,    -1,   353,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,   375,   376,
      -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,   386,
     387,    -1,   389,   390,    -1,   392,   393,    -1,    -1,    -1,
      -1,   398,    -1,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,   414,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,    -1,   181,   182,
     183,    -1,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,    -1,   211,    -1,
     213,   214,   215,    -1,   217,    -1,   219,    -1,    -1,    -1,
      -1,   224,    -1,   226,   227,   228,   229,   230,    -1,    -1,
     233,    -1,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,    -1,   251,   252,
     253,   254,   255,   256,   257,    -1,   259,   260,    -1,    -1,
      -1,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,    -1,    -1,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
      -1,   324,   325,   326,   327,    -1,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,    -1,   372,
     373,   374,   375,   376,    -1,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,    -1,    -1,   392,
      -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,   414,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,    -1,   136,   137,    -1,   139,    -1,
      -1,    -1,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,    -1,   153,    -1,   155,    -1,   157,   158,   159,    -1,
      -1,    -1,   163,   164,   165,   166,    -1,   168,   169,    -1,
     171,    -1,   173,   174,   175,   176,   177,    -1,   179,    -1,
     181,   182,   183,    -1,   185,    -1,   187,    -1,    -1,    -1,
     191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,    -1,
     201,   202,   203,    -1,   205,   206,   207,   208,    -1,    -1,
     211,    -1,   213,   214,   215,    -1,   217,    -1,   219,    -1,
      -1,    -1,    -1,   224,    -1,   226,   227,   228,   229,   230,
      -1,    -1,   233,    -1,    -1,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,    -1,
     251,    -1,   253,   254,   255,   256,   257,    -1,   259,   260,
      -1,    -1,    -1,   264,   265,   266,   267,    -1,    -1,   270,
      -1,    -1,    -1,   274,   275,    -1,    -1,   278,    -1,    -1,
     281,   282,   283,   284,    -1,   286,   287,   288,   289,    -1,
     291,   292,   293,   294,   295,   296,   297,   298,    -1,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,    -1,   329,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,    -1,   343,   344,   345,   346,    -1,   348,   349,    -1,
     351,    -1,   353,   354,   355,   356,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
      -1,   372,   373,   374,   375,   376,    -1,   378,    -1,    -1,
      -1,   382,   383,   384,   385,   386,   387,    -1,   389,    -1,
      -1,   392,   393,    -1,    -1,    -1,    -1,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,   414,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    88,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,    -1,   131,   132,   133,   134,    -1,   136,   137,    -1,
     139,    -1,    -1,    -1,    -1,   144,   145,   146,   147,   148,
     149,   150,   151,    -1,   153,    -1,   155,    -1,   157,   158,
     159,    -1,    -1,    -1,   163,   164,   165,   166,    -1,   168,
     169,    -1,   171,    -1,   173,   174,   175,   176,   177,    -1,
     179,    -1,   181,   182,   183,    -1,   185,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,    -1,    -1,   196,    -1,   198,
     199,    -1,   201,   202,   203,    -1,   205,   206,   207,   208,
      -1,    -1,   211,    -1,   213,   214,   215,    -1,   217,    -1,
     219,    -1,    -1,    -1,    -1,   224,    -1,   226,   227,   228,
     229,   230,    -1,    -1,   233,    -1,    -1,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,    -1,   251,    -1,   253,   254,   255,   256,   257,    -1,
     259,   260,    -1,    -1,    -1,   264,   265,   266,   267,    -1,
      -1,   270,    -1,    -1,    -1,   274,   275,    -1,    -1,   278,
      -1,    -1,   281,   282,   283,   284,    -1,   286,   287,   288,
     289,    -1,   291,   292,   293,   294,   295,   296,   297,   298,
      -1,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,    -1,
     329,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,    -1,   343,   344,   345,   346,    -1,   348,
     349,    -1,   351,    -1,   353,   354,   355,   356,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,    -1,   372,   373,   374,   375,   376,    -1,   378,
      -1,    -1,    -1,   382,   383,   384,   385,   386,   387,    -1,
     389,    -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,   414,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,    -1,   131,   132,   133,   134,    -1,   136,
     137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,   146,
     147,   148,   149,   150,   151,    -1,   153,    -1,   155,    -1,
     157,   158,   159,    -1,    -1,    -1,   163,   164,   165,   166,
      -1,   168,   169,    -1,   171,    -1,   173,   174,   175,   176,
     177,    -1,   179,    -1,   181,   182,   183,    -1,   185,    -1,
     187,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,   196,
      -1,   198,   199,    -1,   201,   202,   203,    -1,   205,   206,
     207,   208,    -1,    -1,   211,    -1,   213,   214,   215,    -1,
     217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,   226,
     227,   228,   229,   230,    -1,    -1,   233,    -1,    -1,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,    -1,   251,    -1,   253,   254,   255,   256,
     257,    -1,   259,   260,    -1,    -1,    -1,   264,   265,   266,
     267,    -1,    -1,   270,    -1,    -1,    -1,   274,   275,    -1,
      -1,   278,    -1,    -1,   281,   282,   283,   284,    -1,   286,
     287,   288,   289,    -1,   291,   292,   293,   294,   295,   296,
     297,   298,    -1,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,    -1,    -1,   320,   321,   322,    -1,   324,   325,   326,
     327,    -1,   329,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,    -1,   343,   344,   345,   346,
      -1,   348,   349,    -1,   351,    -1,   353,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,   375,   376,
      -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,   386,
     387,    -1,   389,    -1,    -1,   392,    -1,    -1,    -1,    -1,
      -1,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,   414,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,    -1,   131,   132,   133,   134,
      -1,   136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,    -1,   153,    -1,
     155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,
     165,   166,    -1,   168,   169,    -1,   171,    -1,   173,   174,
     175,   176,   177,    -1,   179,    -1,   181,   182,   183,    -1,
     185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
      -1,   196,    -1,   198,   199,    -1,   201,   202,   203,    -1,
     205,   206,   207,   208,    -1,    -1,   211,    -1,   213,   214,
     215,    -1,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,
      -1,   226,   227,   228,   229,   230,    -1,    -1,   233,    -1,
      -1,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,    -1,   251,    -1,   253,   254,
     255,   256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,
     265,   266,   267,    -1,    -1,   270,    -1,    -1,    -1,   274,
     275,    -1,    -1,   278,    -1,    -1,   281,   282,   283,   284,
      -1,   286,   287,   288,   289,    -1,   291,   292,   293,   294,
     295,   296,   297,   298,    -1,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,    -1,    -1,   320,   321,   322,    -1,   324,
     325,   326,   327,    -1,   329,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,    -1,   343,   344,
     345,   346,    -1,   348,   349,    -1,   351,    -1,   353,   354,
     355,   356,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,    -1,   372,   373,   374,
     375,   376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,
     385,   386,   387,    -1,   389,    -1,    -1,   392,    -1,    -1,
      -1,    -1,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,   414,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,   107,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,    -1,    -1,    -1,   127,   128,   129,    -1,   131,   132,
      -1,   134,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,    -1,   177,    -1,    -1,    -1,   181,   182,
     183,    -1,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,    -1,    -1,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,    -1,
      -1,   224,    -1,   226,   227,   228,   229,   230,    -1,    -1,
     233,    -1,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,    -1,   251,    -1,
     253,   254,   255,   256,    -1,    -1,   259,   260,    -1,    -1,
      -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,    -1,
      -1,   274,   275,    -1,    -1,    -1,    -1,    -1,    -1,   282,
     283,   284,    -1,    -1,    -1,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,    -1,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
      -1,   324,   325,   326,   327,    -1,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,    -1,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,    -1,   372,
     373,   374,   375,   376,    -1,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,    -1,    -1,    -1,   398,    -1,   400,   401,   402,
     403,    -1,   405,   406,   407,   408,   409,   410,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,    -1,   136,   137,
      -1,   139,    -1,    -1,    -1,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,    -1,   153,    -1,   155,    -1,   157,
     158,   159,    -1,    -1,    -1,   163,   164,   165,   166,    -1,
     168,   169,    -1,   171,    -1,   173,   174,   175,   176,   177,
      -1,   179,    -1,   181,   182,   183,    -1,   185,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,    -1,    -1,   196,    -1,
     198,   199,    -1,   201,   202,   203,    -1,   205,   206,   207,
     208,    -1,    -1,   211,    -1,   213,   214,   215,    -1,   217,
      -1,   219,    -1,    -1,    -1,    -1,   224,    -1,   226,   227,
     228,   229,   230,    -1,    -1,   233,    -1,    -1,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,    -1,   251,    -1,   253,   254,   255,   256,   257,
      -1,   259,   260,    -1,    -1,    -1,   264,   265,   266,   267,
      -1,    -1,   270,    -1,    -1,    -1,   274,   275,    -1,    -1,
     278,    -1,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,    -1,   291,   292,   293,   294,   295,   296,   297,
     298,    -1,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
      -1,    -1,   320,   321,   322,    -1,   324,   325,   326,   327,
      -1,   329,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,    -1,   343,   344,   345,   346,    -1,
     348,   349,    -1,   351,    -1,   353,   354,   355,   356,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,    -1,   372,   373,   374,   375,   376,    -1,
     378,    -1,    -1,    -1,   382,   383,   384,   385,   386,   387,
      -1,   389,    -1,   391,   392,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   401,   402,   403,    -1,   405,   406,   407,
     408,   409,   410,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,    -1,   181,   182,
     183,    -1,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,    -1,   211,    -1,
     213,   214,   215,    -1,   217,    -1,   219,    -1,    -1,    -1,
      -1,   224,    -1,   226,   227,   228,   229,   230,    -1,    -1,
     233,    -1,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,    -1,   251,    -1,
     253,   254,   255,   256,   257,    -1,   259,   260,    -1,    -1,
      -1,   264,   265,   266,   267,    -1,    -1,   270,    -1,    -1,
      -1,   274,   275,    -1,    -1,   278,    -1,    -1,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
      -1,   324,   325,   326,   327,    -1,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,    -1,   372,
     373,   374,   375,   376,    -1,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,    -1,   391,   392,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   401,   402,
     403,    -1,   405,   406,   407,   408,   409,   410,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
     107,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,    -1,    -1,    -1,
     127,   128,   129,    -1,   131,   132,    -1,   134,    -1,   136,
     137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,   146,
     147,   148,   149,   150,   151,    -1,   153,    -1,   155,    -1,
     157,   158,   159,    -1,    -1,    -1,   163,   164,   165,   166,
      -1,   168,   169,    -1,   171,    -1,   173,   174,   175,    -1,
     177,    -1,    -1,    -1,   181,   182,   183,    -1,   185,    -1,
     187,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,   196,
      -1,   198,   199,    -1,   201,   202,   203,    -1,   205,   206,
     207,   208,    -1,    -1,    -1,    -1,   213,   214,   215,   216,
     217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,   226,
     227,   228,   229,   230,    -1,    -1,   233,    -1,    -1,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,    -1,   251,    -1,   253,   254,   255,   256,
      -1,    -1,   259,   260,    -1,    -1,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,    -1,    -1,   274,   275,    -1,
      -1,    -1,    -1,    -1,    -1,   282,   283,   284,    -1,    -1,
      -1,   288,   289,    -1,   291,   292,   293,   294,   295,   296,
     297,   298,    -1,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,    -1,   313,   314,   315,   316,
     317,    -1,    -1,   320,   321,   322,    -1,   324,   325,   326,
     327,    -1,   329,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,    -1,   341,    -1,   343,   344,   345,   346,
      -1,   348,   349,    -1,   351,    -1,   353,    -1,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,   375,   376,
      -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,   386,
     387,    -1,   389,    -1,    -1,   392,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
     407,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,    -1,   136,   137,    -1,   139,
      -1,    -1,    -1,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,    -1,   153,    -1,   155,    -1,   157,   158,   159,
      -1,    -1,    -1,   163,   164,   165,   166,    -1,   168,   169,
      -1,   171,    -1,   173,   174,   175,   176,   177,    -1,   179,
      -1,   181,   182,   183,    -1,   185,    -1,   187,    -1,    -1,
      -1,   191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,
      -1,   201,   202,   203,    -1,   205,   206,   207,   208,    -1,
      -1,   211,    -1,   213,   214,   215,    -1,   217,    -1,   219,
      -1,    -1,    -1,    -1,   224,    -1,   226,   227,   228,   229,
     230,    -1,    -1,   233,    -1,    -1,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
      -1,   251,   252,   253,   254,   255,   256,   257,    -1,   259,
     260,    -1,    -1,    -1,   264,   265,   266,   267,    -1,    -1,
     270,   271,    -1,    -1,   274,   275,    -1,    -1,   278,    -1,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
      -1,   291,   292,   293,   294,   295,   296,   297,   298,    -1,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,    -1,    -1,
     320,   321,   322,    -1,   324,   325,   326,   327,    -1,   329,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,    -1,   343,   344,   345,   346,    -1,   348,   349,
      -1,   351,    -1,   353,   354,   355,   356,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,    -1,   372,   373,   374,   375,   376,    -1,   378,    -1,
      -1,    -1,   382,   383,   384,   385,   386,   387,    -1,   389,
      -1,    -1,   392,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,   407,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,    -1,   181,   182,
     183,    -1,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,    -1,   211,    -1,
     213,   214,   215,    -1,   217,    -1,   219,    -1,    -1,    -1,
      -1,   224,    -1,   226,   227,   228,   229,   230,    -1,    -1,
     233,    -1,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,    -1,   251,    -1,
     253,   254,   255,   256,   257,    -1,   259,   260,    -1,    -1,
      -1,   264,   265,   266,   267,    -1,    -1,   270,    -1,    -1,
      -1,   274,   275,    -1,    -1,   278,    -1,    -1,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
      -1,   324,   325,   326,   327,    -1,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,    -1,   372,
     373,   374,   375,   376,    -1,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,    -1,    -1,   392,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,   407,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,    -1,   155,
      -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,   165,
     166,    -1,   168,   169,    -1,   171,    -1,   173,   174,   175,
     176,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,
     196,    -1,   198,   199,    -1,   201,   202,   203,    -1,   205,
     206,   207,   208,    -1,    -1,   211,    -1,   213,   214,   215,
      -1,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,
     226,   227,   228,   229,   230,    -1,    -1,   233,    -1,    -1,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,    -1,   251,    -1,   253,   254,   255,
     256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,   265,
     266,   267,   268,    -1,   270,    -1,   272,    -1,   274,   275,
      -1,    -1,   278,    -1,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,    -1,   291,   292,   293,   294,   295,
     296,   297,   298,    -1,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,    -1,    -1,   320,   321,   322,    -1,   324,   325,
     326,   327,    -1,   329,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,    -1,   343,   344,   345,
     346,    -1,   348,   349,    -1,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,    -1,   372,   373,   374,   375,
     376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,
     386,   387,    -1,   389,   390,    -1,   392,   393,    -1,    -1,
      -1,    -1,   398,    -1,   400,    -1,     6,     7,     8,     9,
     406,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,    -1,   136,   137,    -1,   139,
      -1,    -1,    -1,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,    -1,   153,    -1,   155,    -1,   157,   158,   159,
      -1,    -1,    -1,   163,   164,   165,   166,    -1,   168,   169,
      -1,   171,    -1,   173,   174,   175,   176,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,    -1,   187,    -1,    -1,
      -1,   191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,
      -1,   201,   202,   203,    -1,   205,   206,   207,   208,    -1,
      -1,   211,    -1,   213,   214,   215,    -1,   217,    -1,   219,
      -1,    -1,    -1,    -1,   224,    -1,   226,   227,   228,   229,
     230,    -1,    -1,   233,    -1,    -1,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
      -1,   251,    -1,   253,   254,   255,   256,   257,    -1,   259,
     260,    -1,    -1,    -1,   264,   265,   266,   267,   268,    -1,
     270,    -1,   272,    -1,   274,   275,    -1,    -1,   278,    -1,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
      -1,   291,   292,   293,   294,   295,   296,   297,   298,    -1,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,    -1,    -1,
     320,   321,   322,    -1,   324,   325,   326,   327,    -1,   329,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,    -1,   343,   344,   345,   346,    -1,   348,   349,
      -1,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,    -1,   372,   373,   374,   375,   376,    -1,   378,    -1,
      -1,    -1,   382,   383,   384,   385,   386,   387,    -1,   389,
     390,    -1,   392,   393,    -1,    -1,    -1,    -1,   398,    -1,
     400,    -1,     6,     7,     8,     9,   406,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,    -1,
     144,   145,   146,   147,   148,   149,   150,   151,    -1,   153,
      -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,
     164,   165,   166,    -1,   168,   169,    -1,   171,    -1,   173,
     174,   175,   176,   177,    -1,   179,    -1,   181,   182,   183,
      -1,   185,    -1,   187,    -1,   189,    -1,   191,    -1,   193,
      -1,    -1,   196,    -1,   198,   199,    -1,   201,   202,   203,
     204,   205,   206,   207,   208,    -1,    -1,   211,    -1,   213,
     214,   215,    -1,   217,    -1,   219,    -1,    -1,    -1,    -1,
     224,    -1,   226,   227,   228,   229,   230,    -1,    -1,   233,
      -1,    -1,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,    -1,   251,    -1,   253,
     254,   255,   256,   257,    -1,   259,   260,    -1,    -1,    -1,
     264,   265,   266,   267,    -1,    -1,   270,    -1,    -1,    -1,
     274,   275,    -1,    -1,   278,    -1,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,    -1,   291,   292,   293,
     294,   295,   296,   297,   298,    -1,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,    -1,    -1,   320,   321,   322,    -1,
     324,   325,   326,   327,    -1,   329,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,    -1,   343,
     344,   345,   346,    -1,   348,   349,    -1,   351,    -1,   353,
     354,   355,   356,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,    -1,   372,   373,
     374,   375,   376,    -1,   378,    -1,    -1,    -1,   382,   383,
     384,   385,   386,   387,    -1,   389,    -1,    -1,   392,   393,
       6,     7,     8,     9,   398,    11,    12,    -1,    14,    15,
      16,    17,   406,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,    -1,   153,    -1,   155,
      -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,   165,
     166,    -1,   168,   169,    -1,   171,    -1,   173,   174,   175,
     176,   177,    -1,   179,    -1,   181,   182,   183,    -1,   185,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,
     196,    -1,   198,   199,    -1,   201,   202,   203,    -1,   205,
     206,   207,   208,    -1,    -1,   211,    -1,   213,   214,   215,
      -1,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,
     226,   227,   228,   229,   230,    -1,    -1,   233,    -1,    -1,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,    -1,   251,    -1,   253,   254,   255,
     256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,    -1,   274,   275,
      -1,    -1,   278,    -1,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,    -1,   291,   292,   293,   294,   295,
     296,   297,   298,    -1,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,    -1,    -1,   320,   321,   322,    -1,   324,   325,
     326,   327,    -1,   329,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,    -1,   343,   344,   345,
     346,    -1,   348,   349,    -1,   351,    -1,   353,   354,   355,
     356,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,    -1,   372,   373,   374,   375,
     376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,
     386,   387,    -1,   389,    -1,    -1,   392,   393,     6,     7,
       8,     9,   398,    11,    12,    -1,    14,    15,    16,    17,
     406,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,    -1,   136,   137,
      -1,   139,    -1,    -1,    -1,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,    -1,   155,    -1,   157,
     158,   159,    -1,    -1,    -1,   163,   164,   165,   166,    -1,
     168,   169,    -1,   171,    -1,   173,   174,   175,   176,   177,
      -1,   179,    -1,   181,   182,   183,    -1,   185,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,    -1,    -1,   196,    -1,
     198,   199,    -1,   201,   202,   203,    -1,   205,   206,   207,
     208,    -1,    -1,   211,    -1,   213,   214,   215,    -1,   217,
      -1,   219,    -1,    -1,    -1,    -1,   224,    -1,   226,   227,
     228,   229,   230,    -1,    -1,   233,    -1,    -1,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,    -1,   251,    -1,   253,   254,   255,   256,   257,
      -1,   259,   260,    -1,    -1,    -1,   264,   265,   266,   267,
      -1,    -1,   270,    -1,    -1,    -1,   274,   275,    -1,    -1,
     278,    -1,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,    -1,   291,   292,   293,   294,   295,   296,   297,
     298,    -1,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
      -1,    -1,   320,   321,   322,    -1,   324,   325,   326,   327,
      -1,   329,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,    -1,   343,   344,   345,   346,    -1,
     348,   349,   350,   351,    -1,   353,   354,   355,   356,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,    -1,   372,   373,   374,   375,   376,    -1,
     378,    -1,    -1,    -1,   382,   383,   384,   385,   386,   387,
      -1,   389,   390,    -1,   392,   393,     6,     7,     8,     9,
      -1,    11,    12,   401,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,    -1,   136,   137,    -1,   139,
      -1,    -1,    -1,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,    -1,   153,    -1,   155,    -1,   157,   158,   159,
      -1,    -1,    -1,   163,   164,   165,   166,    -1,   168,   169,
      -1,   171,    -1,   173,   174,   175,   176,   177,    -1,   179,
      -1,   181,   182,   183,    -1,   185,    -1,   187,    -1,    -1,
      -1,   191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,
      -1,   201,   202,   203,    -1,   205,   206,   207,   208,    -1,
      -1,   211,    -1,   213,   214,   215,    -1,   217,    -1,   219,
      -1,    -1,    -1,    -1,   224,    -1,   226,   227,   228,   229,
     230,    -1,    -1,   233,    -1,    -1,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
      -1,   251,    -1,   253,   254,   255,   256,   257,    -1,   259,
     260,    -1,    -1,    -1,   264,   265,   266,   267,    -1,    -1,
     270,    -1,    -1,    -1,   274,   275,    -1,    -1,   278,    -1,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
      -1,   291,   292,   293,   294,   295,   296,   297,   298,    -1,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,    -1,    -1,
     320,   321,   322,    -1,   324,   325,   326,   327,    -1,   329,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,    -1,   343,   344,   345,   346,    -1,   348,   349,
      -1,   351,    -1,   353,   354,   355,   356,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,    -1,   372,   373,   374,   375,   376,    -1,   378,    -1,
      -1,    -1,   382,   383,   384,   385,   386,   387,    -1,   389,
     390,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,    -1,   131,   132,   133,   134,
      -1,   136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,    -1,   153,    -1,
     155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,
     165,   166,    -1,   168,   169,    -1,   171,    -1,   173,   174,
     175,   176,   177,    -1,   179,    -1,   181,   182,   183,    -1,
     185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
      -1,   196,    -1,   198,   199,    -1,   201,   202,   203,    -1,
     205,   206,   207,   208,    -1,    -1,   211,    -1,   213,   214,
     215,    -1,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,
      -1,   226,   227,   228,   229,   230,    -1,    -1,   233,    -1,
      -1,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,    -1,   251,    -1,   253,   254,
     255,   256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,
     265,   266,   267,    -1,    -1,   270,    -1,    -1,    -1,   274,
     275,    -1,    -1,   278,    -1,    -1,   281,   282,   283,   284,
      -1,   286,   287,   288,   289,    -1,   291,   292,   293,   294,
     295,   296,   297,   298,    -1,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,    -1,    -1,   320,   321,   322,    -1,   324,
     325,   326,   327,    -1,   329,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,    -1,   343,   344,
     345,   346,    -1,   348,   349,    -1,   351,    -1,   353,   354,
     355,   356,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,    -1,   372,   373,   374,
     375,   376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,
     385,   386,   387,    -1,   389,    -1,    -1,   392,    -1,     4,
     395,     6,     7,     8,     9,    10,    11,    12,    -1,    14,
      15,    16,    17,    18,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,    -1,   131,   132,   133,   134,
      -1,   136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,    -1,   153,    -1,
     155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,
     165,   166,    -1,   168,   169,    -1,   171,    -1,   173,   174,
     175,   176,   177,    -1,   179,    -1,   181,   182,   183,    -1,
     185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
      -1,   196,    -1,   198,   199,    -1,   201,   202,   203,    -1,
     205,   206,   207,   208,    -1,    -1,   211,    -1,   213,   214,
     215,    -1,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,
      -1,   226,   227,   228,   229,   230,    -1,    -1,   233,    -1,
      -1,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,    -1,   251,    -1,   253,   254,
     255,   256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,
     265,   266,   267,    -1,    -1,   270,    -1,    -1,    -1,   274,
     275,    -1,    -1,   278,    -1,    -1,   281,   282,   283,   284,
      -1,   286,   287,   288,   289,    -1,   291,   292,   293,   294,
     295,   296,   297,   298,    -1,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,    -1,    -1,   320,   321,   322,    -1,   324,
     325,   326,   327,    -1,   329,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,    -1,   343,   344,
     345,   346,    -1,   348,   349,    -1,   351,    -1,   353,   354,
     355,   356,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,    -1,   372,   373,   374,
     375,   376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,
     385,   386,   387,    -1,   389,    -1,    -1,   392,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,   110,    -1,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,    -1,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   175,   176,
     177,    -1,   179,   180,   181,   182,   183,   184,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,   195,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   219,   220,    -1,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,    -1,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,   389,    -1,    -1,   392,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    -1,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    88,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,    -1,    -1,    -1,   127,   128,
     129,    -1,   131,   132,    -1,   134,    -1,   136,   137,   138,
     139,    -1,    -1,    -1,    -1,   144,   145,   146,   147,   148,
     149,   150,   151,    -1,   153,    -1,   155,    -1,   157,   158,
     159,    -1,    -1,    -1,   163,   164,   165,   166,    -1,   168,
     169,    -1,   171,    -1,   173,   174,   175,    -1,   177,    -1,
      -1,    -1,   181,   182,   183,    -1,   185,    -1,   187,   188,
      -1,   190,   191,    -1,   193,    -1,    -1,   196,    -1,   198,
     199,   200,   201,   202,   203,    -1,   205,   206,   207,   208,
      -1,   210,    -1,    -1,   213,   214,   215,   216,   217,    -1,
     219,    -1,    -1,   222,   223,   224,   225,   226,   227,   228,
     229,   230,    -1,   232,   233,   234,    -1,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,    -1,   253,   254,   255,   256,    -1,    -1,
     259,   260,   261,    -1,    -1,    -1,   265,   266,   267,    -1,
      -1,   270,    -1,    -1,    -1,   274,   275,    -1,    -1,    -1,
     279,   280,    -1,   282,   283,   284,    -1,    -1,    -1,   288,
     289,    -1,   291,   292,   293,   294,   295,   296,   297,   298,
      -1,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,   313,   314,   315,   316,   317,    -1,
      -1,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,    -1,   341,    -1,   343,   344,   345,   346,    -1,   348,
     349,    -1,   351,    -1,   353,    -1,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,    -1,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,    -1,   382,   383,   384,   385,   386,   387,    -1,
     389,    -1,    -1,   392,     6,     7,     8,     9,    -1,    11,
      12,    13,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,    -1,   136,   137,    -1,   139,    -1,    -1,
      -1,    -1,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,
      -1,   163,   164,   165,   166,    -1,   168,   169,    -1,   171,
      -1,   173,   174,   175,   176,   177,    -1,   179,    -1,   181,
     182,   183,    -1,   185,    -1,   187,    -1,    -1,    -1,   191,
      -1,   193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,
     202,   203,    -1,   205,   206,   207,   208,    -1,    -1,   211,
      -1,   213,   214,   215,    -1,   217,    -1,   219,    -1,    -1,
      -1,    -1,   224,    -1,   226,   227,   228,   229,   230,    -1,
      -1,   233,    -1,    -1,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,    -1,   251,
      -1,   253,   254,   255,   256,   257,    -1,   259,   260,    -1,
      -1,    -1,   264,   265,   266,   267,    -1,    -1,   270,    -1,
      -1,    -1,   274,   275,    -1,    -1,   278,    -1,    -1,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,    -1,   291,
     292,   293,   294,   295,   296,   297,   298,    -1,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,    -1,    -1,   320,   321,
     322,    -1,   324,   325,   326,   327,    -1,   329,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
      -1,   343,   344,   345,   346,    -1,   348,   349,    -1,   351,
      -1,   353,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,   375,   376,    -1,   378,    -1,    -1,    -1,
     382,   383,   384,   385,   386,   387,    -1,   389,   390,    -1,
     392,   393,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    43,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,    -1,
     144,   145,   146,   147,   148,   149,   150,   151,    -1,   153,
      -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,
     164,   165,   166,    -1,   168,   169,    -1,   171,    -1,   173,
     174,   175,   176,   177,    -1,   179,    -1,   181,   182,   183,
      -1,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,
      -1,    -1,   196,    -1,   198,   199,    -1,   201,   202,   203,
      -1,   205,   206,   207,   208,    -1,    -1,   211,    -1,   213,
     214,   215,    -1,   217,    -1,   219,    -1,    -1,    -1,    -1,
     224,    -1,   226,   227,   228,   229,   230,    -1,    -1,   233,
      -1,    -1,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,    -1,   251,   252,   253,
     254,   255,   256,   257,    -1,   259,   260,    -1,    -1,    -1,
     264,   265,   266,   267,    -1,    -1,   270,   271,    -1,    -1,
     274,   275,    -1,    -1,   278,    -1,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,    -1,   291,   292,   293,
     294,   295,   296,   297,   298,    -1,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,    -1,    -1,   320,   321,   322,    -1,
     324,   325,   326,   327,    -1,   329,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,    -1,   348,   349,    -1,   351,    -1,   353,
     354,   355,   356,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,    -1,   372,   373,
     374,   375,   376,    -1,   378,    -1,    -1,    -1,   382,   383,
     384,   385,   386,   387,    -1,   389,    -1,    -1,   392,   393,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,    -1,   153,    -1,   155,
      -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,   165,
     166,    -1,   168,   169,    -1,   171,    -1,   173,   174,   175,
     176,   177,    -1,   179,    -1,   181,   182,   183,    -1,   185,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,
     196,    -1,   198,   199,    -1,   201,   202,   203,    -1,   205,
     206,   207,   208,    -1,    -1,   211,    -1,   213,   214,   215,
      -1,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,
     226,   227,   228,   229,   230,    -1,    -1,   233,    -1,    -1,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,    -1,   251,    -1,   253,   254,   255,
     256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,    -1,   274,   275,
      -1,    -1,   278,    -1,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,    -1,   291,   292,   293,   294,   295,
     296,   297,   298,    -1,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,    -1,    -1,   320,   321,   322,    -1,   324,   325,
     326,   327,    -1,   329,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,    -1,   343,   344,   345,
     346,    -1,   348,   349,   350,   351,    -1,   353,   354,   355,
     356,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,    -1,   372,   373,   374,   375,
     376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,
     386,   387,    -1,   389,   390,    -1,   392,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,    -1,   136,   137,
      -1,   139,    -1,    -1,    -1,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,    -1,   155,    -1,   157,
     158,   159,    -1,    -1,    -1,   163,   164,   165,   166,    -1,
     168,   169,    -1,   171,    -1,   173,   174,   175,   176,   177,
      -1,   179,    -1,   181,   182,   183,    -1,   185,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,    -1,    -1,   196,    -1,
     198,   199,    -1,   201,   202,   203,    -1,   205,   206,   207,
     208,    -1,    -1,   211,    -1,   213,   214,   215,    -1,   217,
      -1,   219,    -1,    -1,    -1,    -1,   224,    -1,   226,   227,
     228,   229,   230,    -1,    -1,   233,    -1,    -1,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,    -1,   251,    -1,   253,   254,   255,   256,   257,
      -1,   259,   260,    -1,    -1,    -1,   264,   265,   266,   267,
      -1,    -1,   270,    -1,    -1,    -1,   274,   275,    -1,    -1,
     278,    -1,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,    -1,   291,   292,   293,   294,   295,   296,   297,
     298,    -1,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
      -1,    -1,   320,   321,   322,    -1,   324,   325,   326,   327,
      -1,   329,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,    -1,   343,   344,   345,   346,    -1,
     348,   349,    -1,   351,    -1,   353,   354,   355,   356,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,    -1,   372,   373,   374,   375,   376,    -1,
     378,    -1,    -1,    -1,   382,   383,   384,   385,   386,   387,
      -1,   389,   390,    -1,   392,   393,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,    -1,   136,   137,    -1,   139,
      -1,    -1,    -1,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,   155,    -1,   157,   158,   159,
      -1,    -1,    -1,   163,   164,   165,   166,    -1,   168,   169,
      -1,   171,    -1,   173,   174,   175,   176,   177,    -1,   179,
      -1,   181,   182,   183,    -1,   185,    -1,   187,    -1,    -1,
      -1,   191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,
      -1,   201,   202,   203,    -1,   205,   206,   207,   208,    -1,
      -1,   211,    -1,   213,   214,   215,    -1,   217,    -1,   219,
      -1,    -1,    -1,    -1,   224,    -1,   226,   227,   228,   229,
     230,    -1,    -1,   233,    -1,    -1,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
      -1,   251,    -1,   253,   254,   255,   256,   257,    -1,   259,
     260,    -1,    -1,    -1,   264,   265,   266,   267,    -1,    -1,
     270,    -1,    -1,    -1,   274,   275,    -1,    -1,   278,    -1,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
      -1,   291,   292,   293,   294,   295,   296,   297,   298,    -1,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,    -1,    -1,
     320,   321,   322,    -1,   324,   325,   326,   327,    -1,   329,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,    -1,   343,   344,   345,   346,    -1,   348,   349,
      -1,   351,    -1,   353,   354,   355,   356,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,    -1,   372,   373,   374,   375,   376,    -1,   378,    -1,
      -1,    -1,   382,   383,   384,   385,   386,   387,    -1,   389,
     390,    -1,   392,   393,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,    -1,   136,   137,    -1,   139,    -1,    -1,
      -1,    -1,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,
      -1,   163,   164,   165,   166,    -1,   168,   169,    -1,   171,
      -1,   173,   174,   175,   176,   177,    -1,   179,    -1,   181,
     182,   183,    -1,   185,    -1,   187,    -1,    -1,    -1,   191,
      -1,   193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,
     202,   203,    -1,   205,   206,   207,   208,    -1,    -1,   211,
      -1,   213,   214,   215,    -1,   217,    -1,   219,    -1,    -1,
      -1,    -1,   224,    -1,   226,   227,   228,   229,   230,    -1,
      -1,   233,    -1,    -1,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,    -1,   251,
      -1,   253,   254,   255,   256,   257,    -1,   259,   260,    -1,
      -1,    -1,   264,   265,   266,   267,    -1,    -1,   270,    -1,
      -1,    -1,   274,   275,    -1,    -1,   278,    -1,    -1,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,    -1,   291,
     292,   293,   294,   295,   296,   297,   298,    -1,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,    -1,    -1,   320,   321,
     322,    -1,   324,   325,   326,   327,    -1,   329,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
      -1,   343,   344,   345,   346,    -1,   348,   349,    -1,   351,
      -1,   353,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,   375,   376,    -1,   378,    -1,    -1,    -1,
     382,   383,   384,   385,   386,   387,    -1,   389,   390,    -1,
     392,   393,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,    -1,
     144,   145,   146,   147,   148,   149,   150,   151,    -1,   153,
      -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,
     164,   165,   166,    -1,   168,   169,    -1,   171,    -1,   173,
     174,   175,   176,   177,    -1,   179,    -1,   181,   182,   183,
      -1,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,
      -1,    -1,   196,    -1,   198,   199,    -1,   201,   202,   203,
      -1,   205,   206,   207,   208,    -1,    -1,   211,    -1,   213,
     214,   215,    -1,   217,    -1,   219,    -1,    -1,    -1,    -1,
     224,    -1,   226,   227,   228,   229,   230,    -1,    -1,   233,
      -1,    -1,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,    -1,   251,    -1,   253,
     254,   255,   256,   257,    -1,   259,   260,    -1,    -1,    -1,
     264,   265,   266,   267,    -1,    -1,   270,    -1,    -1,    -1,
     274,   275,    -1,    -1,   278,    -1,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,    -1,   291,   292,   293,
     294,   295,   296,   297,   298,    -1,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,    -1,    -1,   320,   321,   322,    -1,
     324,   325,   326,   327,    -1,   329,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,    -1,   343,
     344,   345,   346,    -1,   348,   349,    -1,   351,    -1,   353,
     354,   355,   356,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,    -1,   372,   373,
     374,   375,   376,    -1,   378,    -1,    -1,    -1,   382,   383,
     384,   385,   386,   387,    -1,   389,   390,    -1,   392,   393,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    18,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,    -1,   153,    -1,   155,
      -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,   165,
     166,    -1,   168,   169,    -1,   171,    -1,   173,   174,   175,
     176,   177,    -1,   179,    -1,   181,   182,   183,    -1,   185,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,
     196,    -1,   198,   199,    -1,   201,   202,   203,    -1,   205,
     206,   207,   208,    -1,    -1,   211,    -1,   213,   214,   215,
      -1,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,
     226,   227,   228,   229,   230,    -1,    -1,   233,    -1,    -1,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,    -1,   251,    -1,   253,   254,   255,
     256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,    -1,   274,   275,
      -1,    -1,   278,    -1,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,    -1,   291,   292,   293,   294,   295,
     296,   297,   298,    -1,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,    -1,    -1,   320,   321,   322,    -1,   324,   325,
     326,   327,    -1,   329,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,    -1,   343,   344,   345,
     346,    -1,   348,   349,    -1,   351,    -1,   353,   354,   355,
     356,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,    -1,   372,   373,   374,   375,
     376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,
     386,   387,    -1,   389,    -1,    -1,   392,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,    -1,   136,   137,
      -1,   139,    -1,    -1,    -1,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,    -1,   153,    -1,   155,    -1,   157,
     158,   159,    -1,    -1,    -1,   163,   164,   165,   166,    -1,
     168,   169,    -1,   171,    -1,   173,   174,   175,   176,   177,
      -1,   179,    -1,   181,   182,   183,    -1,   185,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,    -1,    -1,   196,    -1,
     198,   199,    -1,   201,   202,   203,    -1,   205,   206,   207,
     208,    -1,    -1,   211,    -1,   213,   214,   215,    -1,   217,
      -1,   219,    -1,    -1,    -1,    -1,   224,    -1,   226,   227,
     228,   229,   230,    -1,    -1,   233,    -1,    -1,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,    -1,   251,    -1,   253,   254,   255,   256,   257,
      -1,   259,   260,    -1,    -1,    -1,   264,   265,   266,   267,
      -1,    -1,   270,    -1,    -1,    -1,   274,   275,    -1,    -1,
     278,    -1,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,    -1,   291,   292,   293,   294,   295,   296,   297,
     298,    -1,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
      -1,    -1,   320,   321,   322,    -1,   324,   325,   326,   327,
      -1,   329,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,    -1,   343,   344,   345,   346,    -1,
     348,   349,    -1,   351,    -1,   353,   354,   355,   356,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,    -1,   372,   373,   374,   375,   376,    -1,
     378,    -1,    -1,    -1,   382,   383,   384,   385,   386,   387,
      -1,   389,    -1,    -1,   392,   393,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,    -1,   136,   137,    -1,   139,
      -1,    -1,    -1,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,    -1,   153,    -1,   155,    -1,   157,   158,   159,
      -1,    -1,    -1,   163,   164,   165,   166,    -1,   168,   169,
      -1,   171,    -1,   173,   174,   175,   176,   177,    -1,   179,
      -1,   181,   182,   183,    -1,   185,    -1,   187,    -1,    -1,
      -1,   191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,
      -1,   201,   202,   203,    -1,   205,   206,   207,   208,    -1,
      -1,   211,    -1,   213,   214,   215,    -1,   217,    -1,   219,
      -1,    -1,    -1,    -1,   224,    -1,   226,   227,   228,   229,
     230,    -1,    -1,   233,    -1,    -1,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
      -1,   251,    -1,   253,   254,   255,   256,   257,    -1,   259,
     260,    -1,    -1,    -1,   264,   265,   266,   267,    -1,    -1,
     270,    -1,    -1,    -1,   274,   275,    -1,    -1,   278,    -1,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
      -1,   291,   292,   293,   294,   295,   296,   297,   298,    -1,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,    -1,    -1,
     320,   321,   322,    -1,   324,   325,   326,   327,    -1,   329,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,    -1,   343,   344,   345,   346,    -1,   348,   349,
      -1,   351,    -1,   353,   354,   355,   356,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,    -1,   372,   373,   374,   375,   376,    -1,   378,    -1,
      -1,    -1,   382,   383,   384,   385,   386,   387,    -1,   389,
      -1,    -1,   392,   393,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,   107,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,    -1,    -1,    -1,   127,   128,   129,    -1,
     131,   132,    -1,   134,    -1,   136,   137,    -1,   139,    -1,
      -1,    -1,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,    -1,   153,    -1,   155,    -1,   157,   158,   159,    -1,
      -1,    -1,   163,   164,   165,   166,    -1,   168,   169,    -1,
     171,    -1,   173,   174,   175,    -1,   177,    -1,    -1,    -1,
     181,   182,   183,    -1,   185,    -1,   187,    -1,    -1,    -1,
     191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,    -1,
     201,   202,   203,    -1,   205,   206,   207,   208,    -1,    -1,
      -1,    -1,   213,   214,   215,   216,   217,    -1,   219,    -1,
      -1,    -1,    -1,   224,    -1,   226,   227,   228,   229,   230,
      -1,    -1,   233,    -1,    -1,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,    -1,
     251,    -1,   253,   254,   255,   256,   257,    -1,   259,   260,
      -1,    -1,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,    -1,    -1,   274,   275,    -1,    -1,    -1,    -1,    -1,
      -1,   282,   283,   284,    -1,    -1,    -1,   288,   289,    -1,
     291,   292,   293,   294,   295,   296,   297,   298,    -1,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,    -1,   313,   314,   315,   316,   317,    -1,    -1,   320,
     321,   322,    -1,   324,   325,   326,   327,    -1,   329,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,    -1,
     341,    -1,   343,   344,   345,   346,    -1,   348,   349,    -1,
     351,    -1,   353,    -1,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
      -1,   372,   373,   374,   375,   376,    -1,   378,    -1,    -1,
      -1,   382,   383,   384,   385,   386,   387,    -1,   389,    -1,
      -1,   392,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,   107,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,    -1,    -1,    -1,   127,   128,   129,    -1,   131,   132,
      -1,   134,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,    -1,   177,    -1,    -1,    -1,   181,   182,
     183,    -1,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,    -1,    -1,    -1,
     213,   214,   215,   216,   217,    -1,   219,    -1,    -1,    -1,
      -1,   224,    -1,   226,   227,   228,   229,   230,    -1,    -1,
     233,    -1,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,    -1,   251,    -1,
     253,   254,   255,   256,   257,    -1,   259,   260,    -1,    -1,
      -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,    -1,
      -1,   274,   275,    -1,    -1,    -1,    -1,    -1,    -1,   282,
     283,   284,    -1,    -1,    -1,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,    -1,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
      -1,   324,   325,   326,   327,    -1,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,    -1,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,    -1,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,    -1,   372,
     373,   374,   375,   376,    -1,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,    -1,    -1,   392,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,   107,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,    -1,
      -1,    -1,   127,   128,   129,    -1,   131,   132,    -1,   134,
      -1,   136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,    -1,   153,    -1,
     155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,
     165,   166,    -1,   168,   169,    -1,   171,    -1,   173,   174,
     175,    -1,   177,    -1,    -1,    -1,   181,   182,   183,    -1,
     185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
      -1,   196,    -1,   198,   199,    -1,   201,   202,   203,    -1,
     205,   206,   207,   208,    -1,    -1,    -1,    -1,   213,   214,
     215,   216,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,
      -1,   226,   227,   228,   229,   230,    -1,    -1,   233,    -1,
      -1,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,    -1,   251,    -1,   253,   254,
     255,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,    -1,    -1,   274,
     275,    -1,    -1,    -1,    -1,    -1,    -1,   282,   283,   284,
      -1,    -1,    -1,   288,   289,    -1,   291,   292,   293,   294,
     295,   296,   297,   298,    -1,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,    -1,   313,   314,
     315,   316,   317,    -1,    -1,   320,   321,   322,    -1,   324,
     325,   326,   327,    -1,   329,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,    -1,   341,    -1,   343,   344,
     345,   346,    -1,   348,   349,    -1,   351,    -1,   353,    -1,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,    -1,   372,   373,   374,
     375,   376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,
     385,   386,   387,    -1,   389,    -1,    -1,   392,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
     107,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,    -1,    -1,    -1,
     127,   128,   129,    -1,   131,   132,    -1,   134,    -1,   136,
     137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,   146,
     147,   148,   149,   150,   151,    -1,   153,    -1,   155,    -1,
     157,   158,   159,    -1,    -1,    -1,   163,   164,   165,   166,
      -1,   168,   169,    -1,   171,    -1,   173,   174,   175,    -1,
     177,    -1,    -1,    -1,   181,   182,   183,    -1,   185,    -1,
     187,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,   196,
      -1,   198,   199,    -1,   201,   202,   203,    -1,   205,   206,
     207,   208,    -1,    -1,    -1,    -1,   213,   214,   215,   216,
     217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,   226,
     227,   228,   229,   230,    -1,    -1,   233,    -1,    -1,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,    -1,   251,    -1,   253,   254,   255,   256,
      -1,    -1,   259,   260,    -1,    -1,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,    -1,    -1,   274,   275,    -1,
      -1,    -1,    -1,    -1,    -1,   282,   283,   284,    -1,    -1,
      -1,   288,   289,    -1,   291,   292,   293,   294,   295,   296,
     297,   298,    -1,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,    -1,   313,   314,   315,   316,
     317,    -1,    -1,   320,   321,   322,    -1,   324,    -1,   326,
     327,    -1,   329,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,    -1,   341,    -1,   343,   344,   345,   346,
      -1,   348,   349,    -1,   351,    -1,   353,    -1,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,   375,   376,
      -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,   386,
     387,    -1,   389,    -1,    -1,   392,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,   108,   109,
     110,    -1,   112,   113,   114,   115,    -1,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,    -1,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,    -1,   179,
     180,   181,   182,   183,   184,   185,   186,   187,   188,   189,
     190,   191,    -1,   193,   194,   195,   196,   197,   198,    -1,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,    -1,   213,   214,   215,    -1,   217,   218,   219,
     220,    -1,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,    -1,   244,   245,    -1,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,   347,   348,   349,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,    -1,   387,    -1,   389,
      -1,    -1,   392,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,   138,   139,    -1,    -1,    -1,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,    -1,   181,   182,
     183,    -1,   185,    -1,   187,   188,    -1,   190,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,   200,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,   210,   211,    -1,
     213,   214,   215,    -1,   217,    -1,   219,    -1,    -1,   222,
     223,   224,   225,   226,   227,   228,   229,   230,    -1,   232,
     233,   234,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,    -1,   259,   260,   261,    -1,
      -1,   264,   265,   266,   267,    -1,    -1,   270,   271,    -1,
      -1,   274,   275,    -1,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,    -1,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,    -1,    -1,   392,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,   131,   132,   133,   134,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,    -1,   153,    -1,   155,
      -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,   165,
     166,    -1,   168,   169,    -1,   171,    -1,   173,   174,   175,
     176,   177,    -1,   179,    -1,   181,   182,   183,    -1,   185,
     186,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,
     196,    -1,   198,   199,    -1,   201,   202,   203,    -1,   205,
     206,   207,   208,    -1,    -1,   211,    -1,   213,   214,   215,
      -1,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,
     226,   227,   228,   229,   230,    -1,    -1,   233,   234,    -1,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,    -1,   251,    -1,   253,   254,   255,
     256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,    -1,   274,   275,
      -1,    -1,   278,    -1,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,    -1,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,    -1,    -1,   320,   321,   322,    -1,   324,   325,
     326,   327,    -1,   329,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,    -1,   343,   344,   345,
     346,    -1,   348,   349,    -1,   351,    -1,   353,   354,   355,
     356,    -1,   358,   359,   360,   361,   362,    -1,   364,   365,
     366,   367,   368,   369,    -1,    -1,   372,   373,   374,   375,
     376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,
     386,   387,    -1,   389,    -1,    -1,   392,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    88,
      89,    90,    -1,    -1,    -1,    -1,    -1,    96,    97,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,    -1,   131,   132,   133,   134,    -1,   136,   137,    -1,
     139,    -1,    -1,    -1,    -1,   144,   145,   146,   147,   148,
     149,   150,   151,    -1,   153,    -1,   155,    -1,   157,   158,
     159,    -1,    -1,    -1,   163,   164,   165,   166,    -1,   168,
     169,    -1,   171,    -1,   173,   174,   175,   176,   177,    -1,
     179,    -1,   181,   182,   183,    -1,   185,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,    -1,    -1,   196,    -1,   198,
     199,    -1,   201,   202,   203,    -1,   205,   206,   207,   208,
      -1,    -1,   211,    -1,   213,   214,   215,    -1,   217,    -1,
     219,    -1,    -1,    -1,    -1,   224,    -1,   226,   227,   228,
     229,   230,    -1,    -1,   233,    -1,    -1,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,    -1,   251,   252,   253,   254,   255,   256,   257,    -1,
     259,   260,    -1,    -1,    -1,   264,   265,   266,   267,    -1,
      -1,   270,   271,    -1,    -1,   274,   275,    -1,    -1,   278,
      -1,    -1,   281,   282,   283,   284,    -1,   286,   287,   288,
     289,    -1,   291,   292,   293,   294,   295,   296,   297,   298,
      -1,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,    -1,
      -1,   320,   321,   322,    -1,   324,   325,   326,   327,    -1,
     329,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,    -1,   343,   344,   345,   346,    -1,   348,
     349,    -1,   351,    -1,   353,   354,   355,   356,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,    -1,   372,   373,   374,   375,   376,    -1,   378,
      -1,    -1,    -1,   382,   383,   384,   385,   386,   387,    -1,
     389,    -1,    -1,   392,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,    -1,   136,   137,    -1,   139,    -1,    -1,
      -1,    -1,   144,   145,   146,   147,   148,   149,   150,   151,
      -1,   153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,
      -1,   163,   164,   165,   166,    -1,   168,   169,    -1,   171,
      -1,   173,   174,   175,   176,   177,    -1,   179,    -1,   181,
     182,   183,    -1,   185,    -1,   187,    -1,    -1,    -1,   191,
      -1,   193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,
     202,   203,    -1,   205,   206,   207,   208,    -1,    -1,   211,
      -1,   213,   214,   215,    -1,   217,    -1,   219,    -1,    -1,
      -1,    -1,   224,    -1,   226,   227,   228,   229,   230,    -1,
      -1,   233,    -1,    -1,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,    -1,   251,
     252,   253,   254,   255,   256,   257,    -1,   259,   260,    -1,
      -1,    -1,   264,   265,   266,   267,    -1,    -1,   270,   271,
      -1,   273,   274,   275,    -1,    -1,   278,    -1,    -1,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,    -1,   291,
     292,   293,   294,   295,   296,   297,   298,    -1,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,    -1,    -1,   320,   321,
     322,    -1,   324,   325,   326,   327,    -1,   329,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
      -1,   343,   344,   345,   346,    -1,   348,   349,    -1,   351,
      -1,   353,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,   375,   376,    -1,   378,    -1,    -1,    -1,
     382,   383,   384,   385,   386,   387,    -1,   389,    -1,    -1,
     392,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,    -1,   131,   132,   133,   134,
      -1,   136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,    -1,   153,    -1,
     155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,
     165,   166,    -1,   168,   169,    -1,   171,    -1,   173,   174,
     175,   176,   177,    -1,   179,    -1,   181,   182,   183,    -1,
     185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
      -1,   196,    -1,   198,   199,    -1,   201,   202,   203,    -1,
     205,   206,   207,   208,    -1,    -1,   211,    -1,   213,   214,
     215,    -1,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,
      -1,   226,   227,   228,   229,   230,    -1,    -1,   233,    -1,
      -1,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,    -1,   251,   252,   253,   254,
     255,   256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,
     265,   266,   267,    -1,    -1,   270,   271,    -1,    -1,   274,
     275,    -1,    -1,   278,    -1,    -1,   281,   282,   283,   284,
      -1,   286,   287,   288,   289,    -1,   291,   292,   293,   294,
     295,   296,   297,   298,    -1,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,    -1,    -1,   320,   321,   322,    -1,   324,
     325,   326,   327,    -1,   329,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,    -1,   348,   349,    -1,   351,    -1,   353,   354,
     355,   356,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,    -1,   372,   373,   374,
     375,   376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,
     385,   386,   387,    -1,   389,    -1,    -1,   392,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,    -1,   136,   137,
      -1,   139,    -1,    -1,    -1,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,    -1,   153,    -1,   155,    -1,   157,
     158,   159,    -1,    -1,    -1,   163,   164,   165,   166,    -1,
     168,   169,    -1,   171,    -1,   173,   174,   175,   176,   177,
      -1,   179,    -1,   181,   182,   183,    -1,   185,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,    -1,    -1,   196,    -1,
     198,   199,    -1,   201,   202,   203,    -1,   205,   206,   207,
     208,    -1,    -1,   211,    -1,   213,   214,   215,    -1,   217,
      -1,   219,    -1,    -1,    -1,    -1,   224,    -1,   226,   227,
     228,   229,   230,    -1,    -1,   233,    -1,    -1,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,    -1,   251,   252,   253,   254,   255,   256,   257,
      -1,   259,   260,    -1,    -1,    -1,   264,   265,   266,   267,
      -1,    -1,   270,   271,    -1,    -1,   274,   275,    -1,    -1,
     278,    -1,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,    -1,   291,   292,   293,   294,   295,   296,   297,
     298,    -1,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
      -1,    -1,   320,   321,   322,    -1,   324,   325,   326,   327,
      -1,   329,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,    -1,   343,   344,   345,   346,    -1,
     348,   349,    -1,   351,    -1,   353,   354,   355,   356,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,    -1,   372,   373,   374,   375,   376,    -1,
     378,    -1,    -1,    -1,   382,   383,   384,   385,   386,   387,
      -1,   389,    -1,    -1,   392,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,    -1,   136,   137,    -1,   139,    -1,
      -1,    -1,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,    -1,   153,    -1,   155,    -1,   157,   158,   159,    -1,
      -1,    -1,   163,   164,   165,   166,    -1,   168,   169,    -1,
     171,    -1,   173,   174,   175,   176,   177,    -1,   179,    -1,
     181,   182,   183,    -1,   185,    -1,   187,    -1,   189,    -1,
     191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,    -1,
     201,   202,   203,   204,   205,   206,   207,   208,    -1,    -1,
     211,    -1,   213,   214,   215,    -1,   217,    -1,   219,    -1,
      -1,    -1,    -1,   224,    -1,   226,   227,   228,   229,   230,
      -1,    -1,   233,    -1,    -1,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,    -1,
     251,    -1,   253,   254,   255,   256,   257,    -1,   259,   260,
      -1,    -1,    -1,   264,   265,   266,   267,    -1,    -1,   270,
      -1,    -1,    -1,   274,   275,    -1,    -1,   278,    -1,    -1,
     281,   282,   283,   284,    -1,   286,   287,   288,   289,    -1,
     291,   292,   293,   294,   295,   296,   297,   298,    -1,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,    -1,    -1,   320,
     321,   322,    -1,   324,   325,   326,   327,    -1,   329,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,    -1,   343,   344,   345,   346,    -1,   348,   349,    -1,
     351,    -1,   353,   354,   355,   356,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
      -1,   372,   373,   374,   375,   376,    -1,   378,    -1,    -1,
      -1,   382,   383,   384,   385,   386,   387,    -1,   389,    -1,
      -1,   392,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,    -1,
     144,   145,   146,   147,   148,   149,   150,   151,    -1,   153,
      -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,
     164,   165,   166,    -1,   168,   169,    -1,   171,    -1,   173,
     174,   175,   176,   177,    -1,   179,    -1,   181,   182,   183,
      -1,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,
      -1,    -1,   196,    -1,   198,   199,    -1,   201,   202,   203,
      -1,   205,   206,   207,   208,    -1,    -1,   211,    -1,   213,
     214,   215,    -1,   217,    -1,   219,    -1,    -1,    -1,    -1,
     224,    -1,   226,   227,   228,   229,   230,    -1,    -1,   233,
      -1,    -1,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,    -1,   251,    -1,   253,
     254,   255,   256,   257,    -1,   259,   260,    -1,    -1,    -1,
     264,   265,   266,   267,    -1,    -1,   270,    -1,    -1,    -1,
     274,   275,    -1,    -1,   278,    -1,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,    -1,   291,   292,   293,
     294,   295,   296,   297,   298,    -1,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,    -1,    -1,   320,   321,   322,    -1,
     324,   325,   326,   327,    -1,   329,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,    -1,   343,
     344,   345,   346,    -1,   348,   349,    -1,   351,    -1,   353,
     354,   355,   356,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,    -1,   372,   373,
     374,   375,   376,    -1,   378,    -1,    -1,    -1,   382,   383,
     384,   385,   386,   387,    -1,   389,    -1,    -1,   392,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,    -1,   131,   132,   133,   134,    -1,   136,
     137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,   146,
     147,   148,   149,   150,   151,    -1,   153,    -1,   155,    -1,
     157,   158,   159,    -1,    -1,    -1,   163,   164,   165,   166,
      -1,   168,   169,    -1,   171,    -1,   173,   174,   175,   176,
     177,    -1,   179,    -1,   181,   182,   183,    -1,   185,    -1,
     187,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,   196,
      -1,   198,   199,    -1,   201,   202,   203,    -1,   205,   206,
     207,   208,    -1,    -1,   211,    -1,   213,   214,   215,    -1,
     217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,   226,
     227,   228,   229,   230,    -1,    -1,   233,    -1,    -1,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,    -1,   251,    -1,   253,   254,   255,   256,
     257,    -1,   259,   260,    -1,    -1,    -1,   264,   265,   266,
     267,    -1,    -1,   270,    -1,    -1,    -1,   274,   275,    -1,
      -1,   278,    -1,    -1,   281,   282,   283,   284,    -1,   286,
     287,   288,   289,    -1,   291,   292,   293,   294,   295,   296,
     297,   298,    -1,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,    -1,    -1,   320,   321,   322,    -1,   324,   325,   326,
     327,    -1,   329,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,    -1,   343,   344,   345,   346,
      -1,   348,   349,    -1,   351,    -1,   353,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,   375,   376,
      -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,   386,
     387,    -1,   389,    -1,    -1,   392,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,    -1,   136,   137,    -1,   139,
      -1,    -1,    -1,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,    -1,   153,    -1,   155,    -1,   157,   158,   159,
      -1,    -1,    -1,   163,   164,   165,   166,    -1,   168,   169,
      -1,   171,    -1,   173,   174,   175,   176,   177,    -1,   179,
      -1,   181,   182,   183,    -1,   185,    -1,   187,    -1,    -1,
      -1,   191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,
      -1,   201,   202,   203,    -1,   205,   206,   207,   208,    -1,
      -1,   211,    -1,   213,   214,   215,    -1,   217,    -1,   219,
      -1,    -1,    -1,    -1,   224,    -1,   226,   227,   228,   229,
     230,    -1,    -1,   233,    -1,    -1,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
      -1,   251,    -1,   253,   254,   255,   256,   257,    -1,   259,
     260,    -1,    -1,    -1,   264,   265,   266,   267,    -1,    -1,
     270,    -1,    -1,    -1,   274,   275,    -1,    -1,   278,    -1,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
      -1,   291,   292,   293,   294,   295,   296,   297,   298,    -1,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,    -1,    -1,
     320,   321,   322,    -1,   324,   325,   326,   327,    -1,   329,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,    -1,   343,   344,   345,   346,    -1,   348,   349,
      -1,   351,    -1,   353,   354,   355,   356,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,    -1,   372,   373,   374,   375,   376,    -1,   378,    -1,
      -1,    -1,   382,   383,   384,   385,   386,   387,    -1,   389,
      -1,    -1,   392,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    98,    99,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,    -1,   181,   182,
     183,    -1,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,    -1,   211,    -1,
     213,   214,   215,    -1,   217,    -1,   219,    -1,    -1,    -1,
      -1,   224,    -1,   226,   227,   228,   229,   230,    -1,    -1,
     233,    -1,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,    -1,   251,    -1,
     253,   254,   255,   256,   257,    -1,   259,   260,    -1,    -1,
      -1,   264,   265,   266,   267,    -1,    -1,   270,    -1,    -1,
      -1,   274,   275,    -1,    -1,   278,    -1,    -1,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
      -1,   324,   325,   326,   327,    -1,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,    -1,   372,
     373,   374,   375,   376,    -1,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,    -1,    -1,   392,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,    -1,   153,    -1,   155,
      -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,   165,
     166,    -1,   168,   169,    -1,   171,    -1,   173,   174,   175,
     176,   177,    -1,   179,    -1,   181,   182,   183,    -1,   185,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,
     196,    -1,   198,   199,    -1,   201,   202,   203,    -1,   205,
     206,   207,   208,    -1,    -1,   211,    -1,   213,   214,   215,
      -1,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,
     226,   227,   228,   229,   230,    -1,    -1,   233,    -1,    -1,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,    -1,   251,    -1,   253,   254,   255,
     256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,    -1,   274,   275,
      -1,    -1,   278,    -1,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,    -1,   291,   292,   293,   294,   295,
     296,   297,   298,    -1,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,    -1,    -1,   320,   321,   322,    -1,   324,   325,
     326,   327,    -1,   329,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,    -1,   343,   344,   345,
     346,    -1,   348,   349,    -1,   351,    -1,   353,   354,   355,
     356,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,    -1,   372,   373,   374,   375,
     376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,
     386,   387,    -1,   389,    -1,    -1,   392,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    88,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,    -1,   131,   132,   133,   134,    -1,   136,   137,    -1,
     139,    -1,    -1,    -1,    -1,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,    -1,   155,    -1,   157,   158,
     159,    -1,    -1,    -1,   163,   164,   165,   166,    -1,   168,
     169,    -1,   171,    -1,   173,   174,   175,   176,   177,    -1,
     179,    -1,   181,   182,   183,    -1,   185,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,    -1,    -1,   196,    -1,   198,
     199,    -1,   201,   202,   203,    -1,   205,   206,   207,   208,
      -1,    -1,   211,    -1,   213,   214,   215,    -1,   217,    -1,
     219,    -1,    -1,    -1,    -1,   224,    -1,   226,   227,   228,
     229,   230,    -1,    -1,   233,    -1,    -1,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,    -1,   251,    -1,   253,   254,   255,   256,   257,    -1,
     259,   260,    -1,    -1,    -1,   264,   265,   266,   267,    -1,
      -1,   270,    -1,    -1,    -1,   274,   275,    -1,    -1,   278,
      -1,    -1,   281,   282,   283,   284,    -1,   286,   287,   288,
     289,    -1,   291,   292,   293,   294,   295,   296,   297,   298,
      -1,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,    -1,
      -1,   320,   321,   322,    -1,   324,   325,   326,   327,    -1,
     329,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,    -1,   343,   344,   345,   346,    -1,   348,
     349,    -1,   351,    -1,   353,   354,   355,   356,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,    -1,   372,   373,   374,   375,   376,    -1,   378,
      -1,    -1,    -1,   382,   383,   384,   385,   386,   387,    -1,
     389,    -1,    -1,   392,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,    -1,   136,   137,    -1,   139,    -1,    -1,
      -1,    -1,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,
      -1,   163,   164,   165,   166,    -1,   168,   169,    -1,   171,
      -1,   173,   174,   175,   176,   177,    -1,   179,    -1,   181,
     182,   183,    -1,   185,    -1,   187,    -1,    -1,    -1,   191,
      -1,   193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,
     202,   203,    -1,   205,   206,   207,   208,    -1,    -1,   211,
      -1,   213,   214,   215,    -1,   217,    -1,   219,    -1,    -1,
      -1,    -1,   224,    -1,   226,   227,   228,   229,   230,    -1,
      -1,   233,    -1,    -1,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,    -1,   251,
      -1,   253,   254,   255,   256,   257,    -1,   259,   260,    -1,
      -1,    -1,   264,   265,   266,   267,    -1,    -1,   270,    -1,
      -1,    -1,   274,   275,    -1,    -1,   278,    -1,    -1,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,    -1,   291,
     292,   293,   294,   295,   296,   297,   298,    -1,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,    -1,    -1,   320,   321,
     322,    -1,   324,   325,   326,   327,    -1,   329,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
      -1,   343,   344,   345,   346,    -1,   348,   349,    -1,   351,
      -1,   353,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,   375,   376,    -1,   378,    -1,    -1,    -1,
     382,   383,   384,   385,   386,   387,    -1,   389,    -1,    -1,
     392,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,    -1,   131,   132,   133,   134,
      -1,   136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,    -1,
     155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,
     165,   166,    -1,   168,   169,    -1,   171,    -1,   173,   174,
     175,   176,   177,    -1,   179,    -1,   181,   182,   183,    -1,
     185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
      -1,   196,    -1,   198,   199,    -1,   201,   202,   203,    -1,
     205,   206,   207,   208,    -1,    -1,   211,    -1,   213,   214,
     215,    -1,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,
      -1,   226,   227,   228,   229,   230,    -1,    -1,   233,    -1,
      -1,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,    -1,   251,    -1,   253,   254,
     255,   256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,
     265,   266,   267,    -1,    -1,   270,    -1,    -1,    -1,   274,
     275,    -1,    -1,   278,    -1,    -1,   281,   282,   283,   284,
      -1,   286,   287,   288,   289,    -1,   291,   292,   293,   294,
     295,   296,   297,   298,    -1,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,    -1,    -1,   320,   321,   322,    -1,   324,
     325,   326,   327,    -1,   329,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,    -1,   343,   344,
     345,   346,    -1,   348,   349,    -1,   351,    -1,   353,   354,
     355,   356,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,    -1,   372,   373,   374,
     375,   376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,
     385,   386,   387,    -1,   389,    -1,    -1,   392,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,    -1,    -1,    -1,    -1,    -1,    94,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,    -1,   136,   137,
      -1,   139,    -1,    -1,    -1,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,    -1,   153,    -1,   155,    -1,   157,
     158,   159,    -1,    -1,    -1,   163,   164,   165,   166,    -1,
     168,   169,    -1,   171,    -1,   173,   174,   175,   176,   177,
      -1,   179,    -1,   181,   182,   183,    -1,   185,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,    -1,    -1,   196,    -1,
     198,   199,    -1,   201,   202,   203,    -1,   205,   206,   207,
     208,    -1,    -1,   211,    -1,   213,   214,   215,    -1,   217,
      -1,   219,    -1,    -1,    -1,    -1,   224,    -1,   226,   227,
     228,   229,   230,    -1,    -1,   233,    -1,    -1,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,    -1,   251,    -1,   253,   254,   255,   256,   257,
      -1,   259,   260,    -1,    -1,    -1,   264,   265,   266,   267,
      -1,    -1,   270,    -1,    -1,    -1,   274,   275,    -1,    -1,
     278,    -1,    -1,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,    -1,   291,   292,   293,   294,   295,   296,   297,
     298,    -1,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
      -1,    -1,   320,   321,   322,    -1,   324,   325,   326,   327,
      -1,   329,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,    -1,   343,   344,   345,   346,    -1,
     348,   349,    -1,   351,    -1,   353,   354,   355,   356,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,    -1,   372,   373,   374,   375,   376,    -1,
     378,    -1,    -1,    -1,   382,   383,   384,   385,   386,   387,
      -1,   389,    -1,    -1,   392,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    88,    -1,    -1,
      -1,    -1,    -1,    94,    -1,    96,    97,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,    -1,   136,   137,    -1,   139,    -1,
      -1,    -1,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,    -1,   153,    -1,   155,    -1,   157,   158,   159,    -1,
      -1,    -1,   163,   164,   165,   166,    -1,   168,   169,    -1,
     171,    -1,   173,   174,   175,   176,   177,    -1,   179,    -1,
     181,   182,   183,    -1,   185,    -1,   187,    -1,    -1,    -1,
     191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,    -1,
     201,   202,   203,    -1,   205,   206,   207,   208,    -1,    -1,
     211,    -1,   213,   214,   215,    -1,   217,    -1,   219,    -1,
      -1,    -1,    -1,   224,    -1,   226,   227,   228,   229,   230,
      -1,    -1,   233,    -1,    -1,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,    -1,
     251,    -1,   253,   254,   255,   256,   257,    -1,   259,   260,
      -1,    -1,    -1,   264,   265,   266,   267,    -1,    -1,   270,
      -1,    -1,    -1,   274,   275,    -1,    -1,   278,    -1,    -1,
     281,   282,   283,   284,    -1,   286,   287,   288,   289,    -1,
     291,   292,   293,   294,   295,   296,   297,   298,    -1,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,    -1,    -1,   320,
     321,   322,    -1,   324,   325,   326,   327,    -1,   329,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,    -1,   343,   344,   345,   346,    -1,   348,   349,    -1,
     351,    -1,   353,   354,   355,   356,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
      -1,   372,   373,   374,   375,   376,    -1,   378,    -1,    -1,
      -1,   382,   383,   384,   385,   386,   387,    -1,   389,    -1,
      -1,   392,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,    -1,
     144,   145,   146,   147,   148,   149,   150,   151,    -1,   153,
      -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,   163,
     164,   165,   166,    -1,   168,   169,    -1,   171,    -1,   173,
     174,   175,   176,   177,    -1,   179,    -1,   181,   182,   183,
      -1,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,
      -1,    -1,   196,    -1,   198,   199,    -1,   201,   202,   203,
      -1,   205,   206,   207,   208,    -1,    -1,   211,    -1,   213,
     214,   215,    -1,   217,    -1,   219,    -1,    -1,    -1,    -1,
     224,    -1,   226,   227,   228,   229,   230,    -1,    -1,   233,
      -1,    -1,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,    -1,   251,    -1,   253,
     254,   255,   256,   257,    -1,   259,   260,    -1,    -1,    -1,
     264,   265,   266,   267,    -1,    -1,   270,    -1,    -1,    -1,
     274,   275,    -1,    -1,   278,    -1,    -1,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,    -1,   291,   292,   293,
     294,   295,   296,   297,   298,    -1,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,    -1,    -1,   320,   321,   322,    -1,
     324,   325,   326,   327,    -1,   329,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,    -1,   343,
     344,   345,   346,    -1,   348,   349,    -1,   351,    -1,   353,
     354,   355,   356,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,   373,
     374,   375,   376,    -1,   378,    -1,    -1,    -1,   382,   383,
     384,   385,   386,   387,    -1,   389,    -1,    -1,   392,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,    -1,   131,   132,   133,   134,    -1,   136,
     137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,   146,
     147,   148,   149,   150,   151,    -1,   153,    -1,   155,    -1,
     157,   158,   159,    -1,    -1,    -1,   163,   164,   165,   166,
      -1,   168,   169,    -1,   171,    -1,   173,   174,   175,   176,
     177,    -1,   179,    -1,   181,   182,   183,    -1,   185,    -1,
     187,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,   196,
      -1,   198,   199,    -1,   201,   202,   203,    -1,   205,   206,
     207,   208,    -1,    -1,   211,    -1,   213,   214,   215,    -1,
     217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,   226,
     227,   228,   229,   230,    -1,    -1,   233,    -1,    -1,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,    -1,   251,    -1,   253,   254,   255,   256,
     257,    -1,   259,   260,    -1,    -1,    -1,   264,   265,   266,
     267,    -1,    -1,   270,    -1,    -1,    -1,   274,   275,    -1,
      -1,   278,    -1,    -1,   281,   282,   283,   284,    -1,   286,
     287,   288,   289,    -1,   291,   292,   293,   294,   295,   296,
     297,   298,    -1,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,    -1,    -1,   320,   321,   322,    -1,   324,   325,   326,
     327,    -1,   329,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,    -1,   343,   344,   345,   346,
      -1,   348,   349,    -1,   351,    -1,   353,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,   375,   376,
      -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,   386,
     387,    -1,   389,    -1,    -1,   392,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,    -1,   136,   137,    -1,   139,
      -1,    -1,    -1,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,    -1,   153,    -1,   155,    -1,   157,   158,   159,
      -1,    -1,    -1,   163,   164,   165,   166,    -1,   168,   169,
      -1,   171,    -1,   173,   174,   175,   176,   177,    -1,   179,
      -1,   181,   182,   183,    -1,   185,    -1,   187,    -1,    -1,
      -1,   191,    -1,   193,    -1,    -1,   196,    -1,   198,   199,
      -1,   201,   202,   203,    -1,   205,   206,   207,   208,    -1,
      -1,   211,    -1,   213,   214,   215,    -1,   217,    -1,   219,
      -1,    -1,    -1,    -1,   224,    -1,   226,   227,   228,   229,
     230,    -1,    -1,   233,    -1,    -1,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
      -1,   251,    -1,   253,   254,   255,   256,   257,    -1,   259,
     260,    -1,    -1,    -1,   264,   265,   266,   267,    -1,    -1,
     270,    -1,    -1,    -1,   274,   275,    -1,    -1,   278,    -1,
      -1,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
      -1,   291,   292,   293,   294,   295,   296,   297,   298,    -1,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,    -1,    -1,
     320,   321,   322,    -1,   324,   325,   326,   327,    -1,   329,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,    -1,   343,   344,   345,   346,    -1,   348,   349,
      -1,   351,    -1,   353,   354,   355,   356,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,    -1,   372,   373,   374,   375,   376,    -1,   378,    -1,
      -1,    -1,   382,   383,   384,   385,   386,   387,    -1,   389,
      -1,    -1,   392,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,    -1,   131,   132,
     133,   134,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,    -1,   157,   158,   159,    -1,    -1,    -1,
     163,   164,   165,   166,    -1,   168,   169,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,    -1,   181,   182,
     183,    -1,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,   202,
     203,    -1,   205,   206,   207,   208,    -1,    -1,   211,    -1,
     213,   214,   215,    -1,   217,    -1,   219,    -1,    -1,    -1,
      -1,   224,    -1,   226,   227,   228,   229,   230,    -1,    -1,
     233,    -1,    -1,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,    -1,   251,    -1,
     253,   254,   255,   256,   257,    -1,   259,   260,    -1,    -1,
      -1,   264,   265,   266,   267,    -1,    -1,   270,    -1,    -1,
      -1,   274,   275,    -1,    -1,   278,    -1,    -1,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,    -1,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
      -1,   324,   325,   326,   327,    -1,   329,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,    -1,
     343,   344,   345,   346,    -1,   348,   349,    -1,   351,    -1,
     353,   354,   355,   356,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,    -1,   372,
     373,   374,   375,   376,    -1,   378,    -1,    -1,    -1,   382,
     383,   384,   385,   386,   387,    -1,   389,    -1,    -1,   392,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,    -1,   153,    -1,   155,
      -1,   157,   158,   159,    -1,    -1,    -1,   163,   164,   165,
     166,    -1,   168,   169,    -1,   171,    -1,   173,   174,   175,
     176,   177,    -1,   179,    -1,   181,   182,   183,    -1,   185,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,
     196,    -1,   198,   199,    -1,   201,   202,   203,    -1,   205,
     206,   207,   208,    -1,    -1,   211,    -1,   213,   214,   215,
      -1,   217,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,
     226,   227,   228,   229,   230,    -1,    -1,   233,    -1,    -1,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,    -1,   251,    -1,   253,   254,   255,
     256,   257,    -1,   259,   260,    -1,    -1,    -1,   264,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,    -1,   274,   275,
      -1,    -1,   278,    -1,    -1,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,    -1,   291,   292,   293,   294,   295,
     296,   297,   298,    -1,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,    -1,    -1,   320,   321,   322,    -1,   324,   325,
     326,   327,    -1,   329,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,    -1,   343,   344,   345,
     346,    -1,   348,   349,    -1,   351,    -1,   353,   354,   355,
     356,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,    -1,   372,   373,   374,   375,
     376,    -1,   378,    -1,    -1,    -1,   382,   383,   384,   385,
     386,   387,    -1,   389,    -1,    -1,   392,     6,     7,     8,
      -1,    -1,    11,    12,    -1,    14,    15,    16,    -1,    -1,
      -1,    20,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    -1,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    42,    -1,    44,    45,    46,    47,    48,
      49,    50,    -1,    -1,    -1,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,    -1,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,
      -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   133,    -1,    -1,    -1,    -1,   138,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   176,    -1,    -1,
     179,    -1,    -1,    -1,   183,    -1,    -1,    -1,    -1,   188,
      -1,   190,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   200,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   210,   211,    -1,    -1,    -1,    -1,    -1,   217,    -1,
     219,    -1,    -1,   222,   223,    -1,   225,    -1,    -1,    -1,
      -1,    -1,    -1,   232,    -1,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     249,   250,   251,    -1,    -1,    -1,    -1,    -1,   257,    -1,
      -1,    -1,   261,    -1,    -1,   264,   265,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   278,
     279,   280,   281,    -1,    -1,    -1,    -1,   286,   287,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   297,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   310,    -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   325,    -1,    -1,   328,
      -1,   330,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   348,
     349,    -1,    -1,    -1,    -1,   354,    -1,   356,    -1,    -1,
      -1,    -1,    -1,    -1,   363,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   375,    -1,   377,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,    -1,
     389,    11,    12,   392,    14,    15,    16,    -1,    -1,    -1,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    -1,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    42,    -1,    44,    45,    46,    47,    48,    49,
      50,    -1,    -1,    -1,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,
      -1,    -1,    -1,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   133,    -1,    -1,    -1,    -1,   138,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,
     150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   176,    -1,    -1,   179,
      -1,    -1,    -1,   183,    -1,    -1,    -1,    -1,   188,    -1,
     190,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     210,   211,    -1,    -1,    -1,    -1,    -1,   217,    -1,   219,
      -1,    -1,   222,   223,    -1,   225,    -1,    -1,    -1,    -1,
      -1,    -1,   232,    -1,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   249,
     250,   251,    -1,    -1,    -1,    -1,    -1,   257,    -1,    -1,
      -1,   261,    -1,    -1,   264,   265,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   278,   279,
     280,   281,    -1,    -1,    -1,    -1,   286,   287,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   297,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     310,    -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   325,    -1,    -1,   328,    -1,
     330,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   348,   349,
      -1,    -1,    -1,    -1,   354,    -1,   356,    -1,    -1,    -1,
      -1,    -1,    -1,   363,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   375,    -1,   377,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     6,     7,     8,    -1,   389,
      11,    12,   392,    14,    15,    16,    -1,    -1,    -1,    20,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    -1,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      -1,    -1,    -1,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,    -1,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   133,    -1,    -1,    -1,    -1,   138,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   176,    -1,    -1,   179,    -1,
      -1,    -1,   183,    -1,    -1,    -1,    -1,   188,    -1,   190,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   210,
     211,    -1,    -1,    -1,    -1,    -1,   217,    -1,   219,    -1,
      -1,   222,   223,    -1,   225,    -1,    -1,    -1,    -1,    -1,
      -1,   232,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   249,   250,
     251,    -1,    -1,    -1,    -1,    -1,   257,    -1,    -1,    -1,
     261,    -1,    -1,   264,   265,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   278,   279,   280,
     281,    -1,    -1,    -1,    -1,   286,   287,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   297,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   310,
      -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   325,    -1,    -1,   328,    -1,   330,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   348,   349,    -1,
      -1,    -1,    -1,   354,    -1,   356,    -1,    -1,    -1,    -1,
      -1,    -1,   363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   375,    -1,   377,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     6,     7,     8,    -1,   389,    11,
      12,   392,    14,    15,    16,    -1,    -1,    -1,    20,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    -1,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      42,    -1,    44,    45,    46,    -1,    48,    49,    50,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,
      -1,   103,   104,   105,   106,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   133,    -1,    -1,    -1,    -1,   138,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   176,    -1,    -1,   179,    -1,    -1,
      -1,   183,    -1,    -1,    -1,    -1,   188,    -1,   190,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   210,   211,
      -1,    -1,    -1,    -1,    -1,   217,    -1,   219,    -1,    -1,
     222,   223,    -1,   225,    -1,    -1,    -1,    -1,    -1,    -1,
     232,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   249,   250,   251,
      -1,    -1,    -1,    -1,    -1,   257,    -1,    -1,    -1,   261,
      -1,    -1,   264,   265,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   278,   279,   280,   281,
      -1,    -1,    -1,    -1,   286,   287,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   297,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   310,    -1,
     312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   325,    -1,    -1,   328,    -1,   330,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   348,   349,    -1,    -1,
      -1,    -1,   354,    -1,   356,    -1,    -1,    -1,    -1,    -1,
      -1,   363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   375,    -1,   377,     6,     7,     8,    -1,
      -1,    11,    12,    -1,    14,    15,    16,   389,    -1,    -1,
     392,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    -1,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,
      -1,    -1,    -1,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   133,    -1,    -1,    -1,    -1,   138,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,
     150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   176,    -1,    -1,   179,
      -1,    -1,    -1,   183,    -1,    -1,    -1,    -1,   188,    -1,
     190,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     210,   211,    -1,    -1,    -1,    -1,    -1,   217,    -1,   219,
      -1,    -1,   222,   223,    -1,   225,    -1,    -1,    -1,    -1,
      -1,    -1,   232,    -1,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   249,
     250,   251,    -1,    -1,    -1,    -1,    -1,   257,    -1,    -1,
      -1,   261,    -1,    -1,   264,   265,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   278,   279,
     280,   281,    -1,    -1,    -1,    -1,   286,   287,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   297,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     310,    -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   325,    -1,    -1,   328,    -1,
     330,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   348,   349,
      -1,    -1,    -1,    -1,   354,    -1,   356,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   375,    -1,   377,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   389,
      -1,    -1,   392
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,   424,   425,     0,     5,    20,    29,    41,    42,    47,
      49,    50,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,   116,   183,   199,   216,
     243,   246,   263,   317,   350,   363,   375,   386,   389,   390,
     392,   394,   398,   400,   401,   405,   406,   407,   408,   409,
     412,   413,   414,   415,   417,   418,   419,   420,   426,   780,
     781,   784,   819,   821,   919,   932,   933,   820,     3,     6,
       7,     8,     9,    11,    12,    14,    15,    16,    17,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    30,
      31,    32,    33,    35,    37,    38,    39,    40,    42,    44,
      45,    46,    48,    49,    50,    52,    53,    57,    58,    63,
      72,    74,    76,    77,    79,    88,    89,    90,    98,    99,
     102,   103,   104,   105,   106,   117,   120,   122,   123,   124,
     127,   128,   133,   134,   135,   138,   146,   148,   149,   150,
     151,   157,   165,   170,   175,   176,   177,   179,   181,   183,
     188,   190,   192,   194,   200,   210,   211,   214,   217,   219,
     222,   223,   225,   232,   234,   236,   237,   240,   247,   249,
     250,   251,   257,   260,   261,   264,   265,   278,   279,   280,
     281,   286,   287,   289,   297,   300,   305,   309,   310,   311,
     312,   319,   324,   325,   327,   328,   330,   333,   340,   348,
     349,   354,   356,   358,   360,   363,   366,   368,   372,   375,
     377,   389,   392,   414,   427,   428,   429,   431,   432,   433,
     437,   440,   441,   442,   446,   457,   458,   459,   462,   463,
     469,   470,   479,   505,   511,   512,   516,   520,   522,   524,
     525,   538,   539,   540,   541,   547,   552,   553,   558,   559,
     563,   566,   567,   578,   584,   597,   598,   600,   603,   605,
     606,   609,   611,   612,   620,   621,   622,   623,   624,   629,
     630,   631,   635,   636,   637,   638,   640,   641,   642,   643,
     644,   649,   652,   656,   657,   661,   662,   665,   666,   667,
     668,   669,   796,   809,   810,   811,   812,   813,   826,   831,
     832,   833,   834,   835,   837,   839,   841,   842,   843,   844,
     846,   851,   852,   855,   860,   861,   870,   871,   873,   874,
     875,   878,   882,   885,   889,   890,   892,   893,   896,   898,
     901,   909,   915,   916,   926,   823,   824,   826,   828,   831,
     834,   837,    18,     9,    17,    19,    33,    52,    53,    57,
      58,    63,    72,    74,    76,    77,    79,    80,    81,    82,
      83,    84,    85,    87,    88,    96,    97,    98,   100,   101,
     102,   109,   110,   112,   115,   116,   118,   120,   121,   122,
     123,   127,   128,   129,   131,   132,   134,   136,   137,   139,
     144,   145,   146,   147,   148,   151,   153,   155,   157,   158,
     159,   163,   164,   165,   166,   168,   169,   171,   173,   174,
     175,   177,   181,   182,   185,   187,   191,   193,   196,   198,
     199,   201,   202,   203,   205,   206,   207,   208,   213,   214,
     215,   224,   226,   227,   228,   229,   230,   233,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   253,   254,   255,   256,   259,   260,   266,   267,   270,
     274,   275,   282,   283,   284,   288,   289,   291,   292,   293,
     294,   295,   296,   298,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   311,   313,   314,   315,   316,   317,
     320,   321,   322,   324,   326,   327,   329,   332,   333,   334,
     335,   336,   337,   338,   339,   341,   343,   344,   345,   346,
     350,   351,   353,   355,   358,   359,   360,   361,   362,   365,
     366,   367,   368,   369,   372,   373,   374,   376,   378,   382,
     383,   384,   385,   386,   387,   393,   784,   789,   794,   805,
     806,   900,   901,   902,   905,   911,   912,   913,   914,   915,
     923,   925,   926,    34,   212,   872,    13,    86,   152,   773,
     784,   797,   798,   807,   853,   854,   905,   925,   926,     5,
      29,    34,    41,    42,    49,    50,    86,    89,    90,    91,
      92,    93,    94,    95,   108,   113,   114,   116,   119,   125,
     126,   130,   135,   140,   141,   142,   143,   152,   154,   160,
     161,   162,   167,   170,   172,   180,   184,   186,   189,   194,
     195,   197,   204,   209,   212,   216,   218,   220,   231,   235,
     252,   258,   262,   263,   268,   269,   271,   272,   273,   276,
     277,   290,   299,   319,   323,   331,   342,   347,   350,   352,
     357,   363,   364,   370,   371,   380,   381,   418,   836,   902,
     903,   904,   908,   909,   910,   911,   913,   914,   917,   772,
     905,   772,   904,    29,    41,   116,   216,   897,    44,    46,
     258,   827,   353,   384,   625,    85,   132,   146,   163,   191,
     195,   228,   274,   315,   320,   342,   343,   355,   360,   370,
     797,   151,   625,   772,   252,   271,   768,   770,   776,   795,
     905,   272,   625,   105,   475,    85,    96,   114,   130,   146,
     152,   163,   193,   195,   238,   274,   276,   315,   343,   344,
     346,   355,   359,   360,   364,   370,   480,   517,   550,   579,
     585,   797,    18,   289,   772,   807,   859,   334,   772,   189,
      85,    96,   114,   132,   146,   163,   191,   195,   207,   274,
     293,   314,   315,   320,   342,   343,   355,   360,   370,   378,
     521,   554,   625,   201,   859,   644,   651,    80,    86,   100,
     182,   187,   189,   204,   230,   253,   291,   301,   406,   560,
     561,   562,   772,   780,   785,   786,   923,    18,    86,   135,
     157,   175,   214,   299,   314,   319,   344,   346,   355,   368,
     369,   568,   569,   570,   220,   770,   905,   777,   789,   342,
     672,   560,   772,   770,   859,   146,   207,   342,   607,    86,
     322,   348,   353,   905,   194,   575,   625,    86,   161,   674,
       4,    10,    18,   131,   238,   248,   322,   348,   353,   447,
     448,   905,    86,   322,   348,   353,   905,   353,   672,   894,
     904,   407,   770,   273,   696,   770,   190,   646,   666,   667,
     102,   428,   417,    35,   377,   645,   172,   218,   277,   363,
     675,   676,   834,   837,   833,   815,   417,   838,   840,     5,
      29,    41,   116,   164,   216,   845,   147,   199,   243,   246,
     317,   386,   414,   725,   818,   822,   919,   826,   828,   834,
     830,   417,   772,   807,   927,   152,   797,    25,   371,   408,
     772,   772,   391,   799,   800,   422,   925,   414,   418,   928,
     929,   930,   931,   933,   836,   371,   862,   863,   864,    29,
     216,   216,   908,     7,    11,    23,    24,    45,    48,   162,
     899,   899,    21,   834,   768,   778,   900,   907,   911,   912,
     916,   926,   556,   905,   773,   556,   773,   905,   778,   794,
     772,   121,   391,   401,   402,   403,   405,   406,   407,   408,
     409,   410,   602,   731,   732,   905,   772,   770,   696,   772,
     772,   556,   794,    40,   224,   296,   626,   627,   628,   416,
     557,   272,    85,   114,   126,   132,   146,   163,   191,   207,
     229,   274,   314,   315,   320,   342,   355,   360,   378,   521,
     564,   770,   778,   772,   414,   355,   773,   556,   344,   346,
     794,   344,   346,   121,   731,   304,   443,   905,   772,   772,
     556,   794,   320,   342,   521,   132,   207,   191,   314,   378,
     927,   859,   926,   663,   696,   778,   772,   414,   773,   778,
     794,   121,   731,   772,   772,   772,   436,   794,   228,   555,
     556,   392,   807,   858,   856,   645,   561,    86,   561,    86,
     561,   561,   785,   562,   772,   772,   220,   865,   867,   927,
     292,   272,   420,   770,   769,   770,   562,   189,   772,   770,
      99,   387,   224,   275,   568,   272,    93,   104,   106,   107,
     113,   114,   116,   117,   124,   133,   140,   141,   142,   143,
     149,   150,   164,   176,   179,   180,   183,   216,   217,   219,
     249,   251,   258,   263,   264,   265,   274,   281,   286,   297,
     312,   323,   330,   340,   348,   349,   354,   356,   357,   364,
     370,   375,   391,   396,   397,   399,   405,   406,   407,   409,
     410,   414,   666,   705,   706,   707,   712,   713,   714,   716,
     717,   718,   719,   722,   723,   726,   728,   729,   733,   750,
     755,   760,   761,   768,   778,   779,   780,   781,   782,   783,
     784,   793,   900,   903,   906,   911,   912,   922,   923,   925,
     926,   350,   401,   350,   401,   854,   927,    86,   460,   771,
     772,   322,   447,   152,   455,   789,    99,   118,   447,   387,
     626,   350,   416,   421,    99,   387,   224,   627,   770,   909,
     414,   770,   324,   407,   188,   647,   415,   415,   417,   770,
      86,   673,   673,   109,   673,   184,   235,   269,   679,   685,
     814,   407,   847,   848,   850,   418,   418,    29,   216,   216,
     350,   350,   350,   350,   350,   406,   780,   781,   791,   816,
     923,   170,   829,   847,    94,   803,   109,   806,   806,   371,
     864,   220,   864,   865,   395,   801,   905,   422,   802,   799,
     415,   929,   930,   928,   419,   420,    43,   784,   791,   792,
     866,   868,   869,   922,   216,   222,   772,   350,   772,     6,
     772,   899,   850,   412,   416,   756,   757,   414,   282,   302,
     557,   282,   302,   324,   458,    83,   165,   324,   466,   282,
     414,   586,    83,   165,   302,   302,   556,   414,   416,   282,
     302,   513,    83,    88,   123,   135,   165,   282,   302,   324,
     464,   465,   282,   302,   272,   282,   302,   324,   382,   434,
     458,   417,   233,   273,   385,   224,   775,   905,   770,   778,
     414,   778,   266,   121,   731,   772,   772,   228,   772,   382,
     476,   414,   543,   119,   104,   106,   116,   117,   149,   150,
     183,   217,   219,   249,   251,   265,   297,   325,   330,   348,
     349,   375,   701,   704,   706,   707,   711,   713,   714,   715,
     717,   718,   722,   723,   900,   906,   911,   912,   926,   772,
     382,    94,   639,   382,   438,   556,   543,    99,   343,   504,
     282,   523,    84,   101,   526,    94,   543,   382,   430,   770,
     770,   228,   556,   776,   905,   778,   772,   770,   105,   144,
     213,   254,   316,   381,   698,   414,   701,   586,   556,   414,
     272,   272,   420,   789,   112,   307,   420,   467,   857,   863,
     867,   151,   650,   652,   656,   661,   662,   665,   772,   867,
     867,   866,   918,   921,   925,    51,   876,   877,   925,   146,
     191,   228,   315,   342,   343,   571,   769,   570,   152,   374,
     414,   653,   665,   204,   420,   658,   772,   858,   185,   608,
     608,   233,   184,   272,   414,   412,   666,   740,   376,   720,
     726,   754,   414,   720,   720,   414,   414,   414,   759,   414,
     759,   414,   759,   414,   710,   710,   287,   666,   414,   414,
     708,   116,   117,   720,   726,   414,   414,   709,   414,   414,
     414,   414,   759,   414,   382,   383,   414,   724,   414,   724,
     414,   414,   666,   759,   758,   726,   726,   726,   726,   666,
     726,   736,   789,   117,   414,   721,   414,   789,    78,    91,
      94,    98,   103,   200,   204,   222,   223,   234,   258,   261,
     274,   276,   328,   391,   401,   402,   403,   405,   406,   407,
     408,   409,   410,   731,   733,   735,   726,   220,   420,   670,
     867,   757,   414,    26,   924,   925,   268,   272,   891,   891,
     854,   854,    12,    51,   879,   880,   881,   155,   201,   461,
     420,   118,   152,   456,   789,   905,    94,   152,   238,   454,
     723,   792,   926,   152,   180,   268,   272,   357,   449,   450,
     452,   453,   792,   905,   905,   449,   233,   222,   770,   414,
     762,   765,   905,   645,   414,   648,   666,   668,   669,   668,
     677,   678,   726,   668,   296,   368,    86,   681,   726,   682,
     726,   685,   686,   679,   680,   847,   407,   417,   420,   910,
     825,   828,   825,   216,   147,   199,   243,   317,   243,   317,
     317,   246,   243,   246,   317,   780,   781,   420,   817,   151,
     847,   417,   797,   370,   804,   806,   416,   785,   802,   415,
     419,   931,    18,   420,   834,   414,   772,   414,   909,   726,
     407,   775,   756,   407,   599,   701,   350,   350,   350,   350,
     447,   119,   130,   186,   290,   364,   491,   492,   130,   152,
     258,   152,   258,   350,   204,   211,   278,   415,   587,   588,
     589,   282,   302,   370,   370,   350,   350,   371,   257,   601,
     701,   602,   350,   350,   110,   145,   206,   242,   244,   254,
     306,   333,   514,   126,   491,   610,   610,   272,   351,   130,
     610,   350,   350,   610,   343,   383,   420,   350,   350,   696,
     350,   350,   447,   434,   136,   137,   204,   255,   256,   284,
     341,   373,   435,   296,   303,   321,   451,   233,   557,   414,
     701,   586,   791,   556,   414,   222,   272,   272,   556,   222,
     270,   189,   350,   471,   544,   545,   908,   414,   704,    94,
      93,   412,   702,   147,   246,   386,   414,   725,   557,    84,
     168,   239,   282,   343,   345,   632,   633,   701,   438,   341,
     370,   439,   550,   794,   772,   444,   772,   239,   157,   214,
     368,   527,   528,   414,   542,   434,   513,   267,   414,   508,
     456,   184,   272,   586,    94,   414,   493,   382,   383,   664,
     316,   726,   599,    94,   467,   371,   601,   770,   770,   794,
     467,   556,   867,   863,   772,   867,    18,   420,   924,   780,
     787,   925,   420,   401,   771,   576,   577,   778,   771,   771,
     769,   771,   350,   374,   414,   654,   655,   905,    81,   173,
     312,   326,   659,   770,   262,   660,   571,   726,   736,   736,
     739,   740,   414,   380,   751,   752,   726,   736,   726,   736,
     415,   785,   785,   785,   147,   199,   243,   246,   317,   386,
     737,   741,   789,   926,   785,   720,   720,   726,   785,   602,
     726,   742,   406,   409,   410,   727,   728,   733,   744,   415,
     736,   726,   736,   745,   348,   348,   785,   785,   726,   108,
     189,   231,   352,   726,   736,   748,   756,   415,   420,   324,
     785,   785,   725,   701,   726,   908,   348,   727,   726,   414,
     666,   749,   161,   180,   258,   263,   267,   357,   365,   726,
     103,   200,   204,   234,   328,   414,   726,   350,   726,   726,
     726,   726,   726,   726,   726,   726,   726,   726,    86,    92,
     331,   730,   193,   238,   342,   344,   346,   671,   770,   761,
     189,   688,    86,   161,   407,   415,   736,   772,   925,   787,
     420,   401,   772,   353,   414,   789,   420,   834,   415,   763,
     905,   420,   688,   758,   643,   770,   771,   420,    95,   160,
     371,   273,   267,   687,   269,   420,   235,   417,   848,   702,
     419,   828,   419,   791,   415,    40,   417,   805,   801,   408,
     927,   868,   702,   920,   930,   920,   702,   413,   422,   415,
     794,   772,   794,   773,   414,   772,   226,   226,   414,   772,
     263,   726,   263,   794,   415,   420,   591,   593,   701,   900,
     906,   907,   911,   912,   926,   350,   350,   436,   436,   794,
     772,   774,   905,   420,   415,   420,   794,   772,   791,   109,
     515,   791,   791,   145,   242,   244,   430,   430,   484,   905,
     905,   772,   342,   772,   905,   794,   772,   772,   772,   123,
     270,   465,   794,   772,   302,   794,   794,   195,   784,   785,
     367,   129,   361,   296,   628,   451,   599,    94,   222,   222,
     371,   601,   263,   565,   789,   556,   556,   222,   565,   336,
     337,   472,   789,   415,   420,   401,   726,    93,   702,   701,
     412,   413,   414,   703,   784,   785,   905,   350,   350,   785,
     527,   401,   634,   634,   634,   634,   634,   633,   485,   785,
     436,   184,   504,   135,   445,   479,   511,   525,   566,   578,
     629,   784,   272,   276,   699,   700,   905,   770,   234,   481,
     482,   483,   484,   489,   491,   509,   510,   905,    94,   382,
     383,   507,   196,   789,   770,   308,   613,   494,   495,   905,
      94,   198,   198,   184,   415,   701,   774,   415,   467,   467,
     663,   927,   921,   883,   884,   925,   877,   881,   420,   586,
     195,   572,   573,   905,   152,   726,   766,   767,   415,   420,
     758,   173,   326,   173,   326,   312,   368,   245,   189,   415,
     420,   413,   413,   420,   785,   726,   167,   752,   753,    94,
     415,   371,   415,   415,   415,   415,   420,   415,   189,   415,
     420,   415,   420,   415,   285,   743,   415,   727,   727,   727,
      78,   204,   222,   274,   391,   401,   402,   403,   405,   406,
     407,   408,   409,   410,   733,   727,   415,   415,   184,   189,
     746,   747,   415,   387,   387,   415,   415,    94,   748,   736,
     748,   748,   189,   415,   758,   726,   905,   415,   415,   387,
      91,   171,   736,   189,   180,   263,   267,   357,   365,   414,
     171,   727,   726,   749,   726,   350,   602,   726,   414,   666,
     344,   346,   344,   346,   770,   672,   672,   414,   666,   689,
     690,   691,   696,   697,   768,   778,   698,   736,   736,   415,
     415,     8,    14,    15,    16,    26,    27,    28,    30,    31,
      32,    37,    38,    39,   287,   360,   886,   887,   888,   880,
     787,   626,   785,   725,   452,   702,   415,   758,   765,   698,
     401,   415,   678,   274,   731,   734,   771,   682,   682,   681,
     401,   849,   417,   773,    36,   895,   415,   415,   417,   726,
     282,   302,   726,   492,   414,   414,   494,   467,   588,   593,
     557,   794,   772,   282,   302,   701,   282,   257,   701,   791,
     791,   791,   701,   165,   324,   360,   466,   467,   467,   350,
     350,   436,   784,   415,   701,   565,   565,   774,   415,   222,
     222,   565,   371,   477,   478,   545,   274,   406,   546,   592,
     593,   734,   792,   415,   412,   415,   785,   702,   703,   405,
     406,   407,   408,   409,   413,   415,   272,   152,   780,   784,
     790,   923,   152,   789,   152,   772,   152,   772,   152,   772,
     119,   130,   152,   154,   209,   258,   263,   290,   299,   364,
     486,   487,   488,   360,   444,   480,   585,   770,   528,   415,
     420,   701,   414,   770,   415,   420,   415,   420,   270,   270,
     506,   518,   772,   350,   371,   580,   592,   272,   415,   420,
     665,   665,   859,   467,   415,   467,   467,   144,   420,   401,
     577,   905,   382,   420,   574,   415,   420,   374,   665,   655,
     173,   173,   572,   726,   740,   415,   347,   726,   170,   701,
     556,   785,   726,   726,   785,   726,   746,   701,   727,   161,
     258,   267,   727,   727,   727,   727,   727,   727,   727,   727,
     727,   727,   726,   726,   747,   746,   724,   724,   701,   415,
     415,   415,   736,   415,   721,   789,   728,   727,   726,   415,
     726,   414,   701,   738,   726,    91,   171,   171,   726,   415,
     171,   726,   672,   672,   672,   672,   770,   770,   666,   690,
     691,    94,   692,   905,   420,   138,   190,   210,   225,   232,
     250,   310,   388,   693,   692,    94,   692,   905,   416,   414,
     195,   683,   415,   415,   420,   401,   415,   895,   401,   420,
     152,   726,   414,   931,   391,   808,   413,   350,   350,   415,
     494,   494,   415,   409,   350,   350,   350,   485,   258,   258,
     335,   338,   701,   772,   772,   222,   415,   222,   222,   565,
     565,   430,   159,   154,   209,   258,   535,   536,   537,   785,
     382,   383,   413,   415,   703,   703,   703,   703,   703,   702,
     725,   770,   414,   772,   727,   155,   201,   154,   263,   226,
     770,   701,   342,   184,   529,   276,   700,   481,   174,   205,
     490,   208,   501,   483,   510,   905,    94,    94,   665,   227,
     519,   557,   789,   774,   414,    94,   111,   178,   202,   228,
     308,   318,   332,   339,   379,   594,   595,   157,   214,   319,
     368,   618,   495,   467,   664,   884,   888,   194,   573,   767,
     414,   467,   726,   415,   415,   415,   415,   415,   747,   189,
     267,   414,   415,   725,   738,   415,   420,   727,   726,   726,
     171,   726,   415,   770,   770,   770,   770,   415,   905,   414,
     690,   225,   279,   694,   690,   694,   225,   693,   694,   690,
     225,   414,   905,   414,   775,   415,   736,   109,   197,   684,
     887,   406,   781,   784,   787,   788,   789,   414,   763,   602,
     905,   794,   772,   415,   415,   360,   794,   772,   794,   263,
     263,   785,   905,   371,   468,   565,   222,   565,   565,   473,
     789,   155,   201,   154,   537,   536,   413,   191,   191,   189,
     534,   726,   258,   487,   493,   371,   770,   166,   530,   175,
     528,   415,   153,   153,   414,   382,   383,   502,   789,   189,
     414,   581,   582,   775,   778,   905,   590,   789,   272,   318,
     456,   263,   156,   221,   382,   595,   596,   350,   184,   275,
     766,   727,   414,   727,   415,   701,   726,   692,   414,   771,
     690,   272,   371,   695,   690,   225,   690,   699,   414,   699,
     905,   415,   736,   726,   780,   781,   725,   726,   764,   415,
     299,   726,   565,   105,   139,   158,   171,   185,   263,   270,
     295,   474,   577,    94,   604,   770,   535,   415,   241,   496,
     774,   414,   312,   334,   531,   294,   502,   769,   270,   270,
     272,   503,   556,   726,   415,   420,   371,   556,   583,   414,
     420,   263,   156,   221,   272,   543,   770,   415,   727,   415,
     771,   415,   726,   414,   690,   695,   415,   699,   415,   420,
     415,   770,   639,   639,   258,   295,   639,   639,   604,    97,
     184,   190,   283,   272,   497,   498,   499,    94,   772,   503,
     415,   128,   504,   415,   504,   582,   556,   736,   789,   212,
     263,   698,   415,   415,   771,   415,   764,   493,   789,   784,
     263,   494,   789,   784,   166,   157,   368,   272,   499,   272,
     498,   191,   274,   338,   548,   549,   414,   504,   157,   165,
     288,   583,   698,   415,   212,   162,   415,   496,   494,   312,
     112,   254,   307,   324,   500,   500,   785,   785,   701,   420,
     532,   533,   793,   905,   313,   313,   583,    87,   215,   619,
     497,   175,    82,   152,   263,   778,   602,   549,   415,   420,
     259,   414,   614,   616,   621,   652,   656,   661,   665,   535,
     294,   586,   298,   414,   551,   533,   615,   616,   617,   666,
     667,   778,   601,   415,   417,   414,   415,   617,   532,   551,
     415
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:
#line 585 "preproc.y"
    { connection = NULL; }
    break;

  case 7:
#line 588 "preproc.y"
    {
			fprintf(yyout, "%s", yyvsp[0].str);
                        free(yyvsp[0].str);
			output_line_number();
		}
    break;

  case 9:
#line 594 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 10:
#line 595 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 11:
#line 596 "preproc.y"
    { braces_open++; fputs("{", yyout); }
    break;

  case 12:
#line 597 "preproc.y"
    { remove_typedefs(braces_open); remove_variables(braces_open--); fputs("}", yyout); }
    break;

  case 13:
#line 601 "preproc.y"
    {
			connection = yyvsp[0].str;
			/*
			 *	Do we have a variable as connection target?
			 *	Remove the variable from the variable
			 *	list or else it will be used twice
			 */
			if (argsinsert != NULL)
				argsinsert = NULL;
		}
    break;

  case 14:
#line 612 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 15:
#line 613 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 16:
#line 614 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 17:
#line 615 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 18:
#line 616 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 19:
#line 617 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 20:
#line 618 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 21:
#line 619 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 22:
#line 620 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 23:
#line 621 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 24:
#line 623 "preproc.y"
    {
			if (INFORMIX_MODE)
			{
				/* Informix also has a CLOSE DATABASE command that
				   essantially works like a DISCONNECT CURRENT 
				   as far as I know. */
				if (pg_strcasecmp(yyvsp[0].str+strlen("close "), "database") == 0)
				{
					if (connection)
		                                mmerror(PARSE_ERROR, ET_ERROR, "no at option for close database statement.\n");
								
					fprintf(yyout, "{ ECPGdisconnect(__LINE__, \"CURRENT\");");
		                        whenever_action(2);
		                        free(yyvsp[0].str);
				}
				else
					output_statement(yyvsp[0].str, 0, connection);
			}
			else
				output_statement(yyvsp[0].str, 0, connection);
		}
    break;

  case 25:
#line 644 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 26:
#line 645 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 27:
#line 646 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 28:
#line 647 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 29:
#line 648 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 30:
#line 649 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 31:
#line 650 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 32:
#line 651 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 33:
#line 652 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 34:
#line 653 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 35:
#line 654 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 36:
#line 655 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 37:
#line 656 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 38:
#line 657 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 39:
#line 658 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 40:
#line 659 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 41:
#line 660 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 42:
#line 661 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 43:
#line 662 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 44:
#line 663 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 45:
#line 665 "preproc.y"
    { output_simple_statement(yyvsp[0].str); }
    break;

  case 46:
#line 666 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 47:
#line 667 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 48:
#line 668 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 49:
#line 669 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 50:
#line 670 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 51:
#line 671 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 52:
#line 672 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 53:
#line 673 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 54:
#line 674 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 55:
#line 675 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 56:
#line 676 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 57:
#line 677 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 58:
#line 678 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 59:
#line 679 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 60:
#line 681 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 61:
#line 682 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 62:
#line 683 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 63:
#line 684 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 64:
#line 685 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 65:
#line 686 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 66:
#line 687 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 67:
#line 688 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 68:
#line 690 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 69:
#line 691 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 70:
#line 692 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 71:
#line 693 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 72:
#line 694 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 73:
#line 695 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 74:
#line 696 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 75:
#line 697 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 76:
#line 699 "preproc.y"
    {
			fprintf(yyout, "{ ECPGtrans(__LINE__, %s, \"%s\");", connection ? connection : "NULL", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 77:
#line 704 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 78:
#line 705 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 79:
#line 706 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 80:
#line 707 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 81:
#line 708 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 82:
#line 709 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 83:
#line 710 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 84:
#line 711 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 85:
#line 713 "preproc.y"
    {
			fprintf(yyout,"ECPGallocate_desc(__LINE__, %s);",yyvsp[0].str);
			whenever_action(0);
			free(yyvsp[0].str);
		}
    break;

  case 86:
#line 719 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for connect statement.\n");

			fprintf(yyout, "{ ECPGconnect(__LINE__, %d, %s, %d); ", compat, yyvsp[0].str, autocommit);
			reset_variables();
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 87:
#line 729 "preproc.y"
    {
			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 88:
#line 733 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for deallocate statement.\n");
			fprintf(yyout, "{ ECPGdeallocate(__LINE__, %d, %s);", compat, yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 89:
#line 741 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for deallocate statement.\n");
			fprintf(yyout,"ECPGdeallocate_desc(__LINE__, %s);",yyvsp[0].str);
			whenever_action(0);
			free(yyvsp[0].str);
		}
    break;

  case 90:
#line 749 "preproc.y"
    {
			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 91:
#line 753 "preproc.y"
    {
			fprintf(yyout, "{ ECPGdescribe(__LINE__, %s,", yyvsp[0].str);
			dump_variables(argsresult, 1);
			fputs("ECPGt_EORT);", yyout);
			fprintf(yyout, "}");
			output_line_number();
				
			/* whenever_action(2); */
			free(yyvsp[0].str);
		}
    break;

  case 92:
#line 764 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for disconnect statement.\n");

			fprintf(yyout, "{ ECPGdisconnect(__LINE__, %s);",
					yyvsp[0].str ? yyvsp[0].str : "\"CURRENT\"");
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 93:
#line 774 "preproc.y"
    {
			output_statement(yyvsp[0].str, 0, connection);
		}
    break;

  case 94:
#line 778 "preproc.y"
    {
			fprintf(yyout, "{ ECPGdeallocate(__LINE__, %d, \"%s\");", compat, yyvsp[0].str);

			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 95:
#line 785 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].descriptor.name, connection);
			output_get_descr(yyvsp[0].descriptor.name, yyvsp[0].descriptor.str);
			free(yyvsp[0].descriptor.name);
			free(yyvsp[0].descriptor.str);
		}
    break;

  case 96:
#line 792 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].str, connection);
			output_get_descr_header(yyvsp[0].str);
			free(yyvsp[0].str);
		}
    break;

  case 97:
#line 798 "preproc.y"
    {
			struct cursor *ptr;

			if ((ptr = add_additional_variables(yyvsp[0].str, true)) != NULL)
				output_statement(mm_strdup(ptr->command), 0, ptr->connection ? mm_strdup(ptr->connection) : NULL);
			ptr->opened = true;
		}
    break;

  case 98:
#line 806 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for prepare statement.\n");

			fprintf(yyout, "{ ECPGprepare(__LINE__, %s);", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 99:
#line 814 "preproc.y"
    { /* output already done */ }
    break;

  case 100:
#line 816 "preproc.y"
    {
			fprintf(yyout, "{ ECPGsetcommit(__LINE__, \"%s\", %s);", yyvsp[0].str, connection ? connection : "NULL");
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 101:
#line 822 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for set connection statement.\n");

			fprintf(yyout, "{ ECPGsetconn(__LINE__, %s);", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 102:
#line 831 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].descriptor.name, connection);
			output_set_descr(yyvsp[0].descriptor.name, yyvsp[0].descriptor.str);
			free(yyvsp[0].descriptor.name);
			free(yyvsp[0].descriptor.str);
		}
    break;

  case 103:
#line 838 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].str, connection);
			output_set_descr_header(yyvsp[0].str);
			free(yyvsp[0].str);
		}
    break;

  case 104:
#line 844 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for typedef statement.\n");

			fprintf(yyout, "%s", yyvsp[0].str);
			free(yyvsp[0].str);
			output_line_number();
		}
    break;

  case 105:
#line 853 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for var statement.\n");

			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 106:
#line 860 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for whenever statement.\n");

			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 107:
#line 881 "preproc.y"
    { yyval.str = cat_str(4, make_str("create user"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 108:
#line 884 "preproc.y"
    { yyval.str = make_str("with"); }
    break;

  case 109:
#line 885 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 110:
#line 897 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter user"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 111:
#line 899 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter user"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 112:
#line 903 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter user"), yyvsp[-2].str, make_str("set"), yyvsp[0].str); }
    break;

  case 113:
#line 905 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter user"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 114:
#line 915 "preproc.y"
    { yyval.str = cat2_str(make_str("drop user"), yyvsp[0].str);}
    break;

  case 115:
#line 921 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 116:
#line 922 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 117:
#line 926 "preproc.y"
    { yyval.str = cat2_str(make_str("password"), yyvsp[0].str); }
    break;

  case 118:
#line 928 "preproc.y"
    { yyval.str = cat2_str(make_str("sysid"), yyvsp[0].str); }
    break;

  case 119:
#line 930 "preproc.y"
    { yyval.str = make_str("createdb"); }
    break;

  case 120:
#line 932 "preproc.y"
    { yyval.str = make_str("nocreatedb"); }
    break;

  case 121:
#line 934 "preproc.y"
    { yyval.str = make_str("createuser"); }
    break;

  case 122:
#line 936 "preproc.y"
    { yyval.str = make_str("nocreateuser"); }
    break;

  case 123:
#line 938 "preproc.y"
    { yyval.str = cat2_str(make_str("in group"), yyvsp[0].str); }
    break;

  case 124:
#line 940 "preproc.y"
    { yyval.str = cat2_str(make_str("valid until"), yyvsp[0].str); }
    break;

  case 125:
#line 944 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 126:
#line 946 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 127:
#line 956 "preproc.y"
    { yyval.str = cat_str(3, make_str("create group"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 128:
#line 958 "preproc.y"
    { yyval.str = cat_str(4, make_str("create group"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 129:
#line 964 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 130:
#line 965 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 131:
#line 969 "preproc.y"
    { yyval.str = cat2_str(make_str("user"), yyvsp[0].str); }
    break;

  case 132:
#line 971 "preproc.y"
    { yyval.str = cat2_str(make_str("sysid"), yyvsp[0].str); }
    break;

  case 133:
#line 982 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter group"), yyvsp[-3].str, make_str("add user"), yyvsp[0].str); }
    break;

  case 134:
#line 984 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter group"), yyvsp[-3].str, make_str("drop user"), yyvsp[0].str); }
    break;

  case 135:
#line 994 "preproc.y"
    { yyval.str = cat2_str(make_str("drop group"), yyvsp[0].str); }
    break;

  case 136:
#line 1005 "preproc.y"
    { yyval.str = cat_str(6, make_str("create schema"), yyvsp[-4].str, make_str("authorization"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 137:
#line 1007 "preproc.y"
    { yyval.str = cat_str(4, make_str("create schema"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 138:
#line 1010 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 139:
#line 1011 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 140:
#line 1014 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 141:
#line 1015 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 142:
#line 1022 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 143:
#line 1023 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 144:
#line 1024 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 145:
#line 1025 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 146:
#line 1026 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 147:
#line 1027 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 148:
#line 1041 "preproc.y"
    { yyval.str = cat2_str(make_str("set"), yyvsp[0].str ); }
    break;

  case 149:
#line 1043 "preproc.y"
    { yyval.str = cat2_str(make_str("set local"), yyvsp[0].str ); }
    break;

  case 150:
#line 1045 "preproc.y"
    { yyval.str = cat2_str(make_str("set session"), yyvsp[0].str ); }
    break;

  case 151:
#line 1049 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("to"), yyvsp[0].str); }
    break;

  case 152:
#line 1051 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("="), yyvsp[0].str); }
    break;

  case 153:
#line 1053 "preproc.y"
    { yyval.str = cat2_str(make_str("time zone"), yyvsp[0].str); }
    break;

  case 154:
#line 1055 "preproc.y"
    { yyval.str = cat2_str(make_str("transaction"), yyvsp[0].str); }
    break;

  case 155:
#line 1057 "preproc.y"
    { yyval.str = cat2_str(make_str("session characteristics as transaction"), yyvsp[0].str); }
    break;

  case 156:
#line 1059 "preproc.y"
    { yyval.str = cat2_str(make_str("names"), yyvsp[0].str); }
    break;

  case 157:
#line 1061 "preproc.y"
    { yyval.str = cat2_str(make_str("session authorization"), yyvsp[0].str); }
    break;

  case 158:
#line 1063 "preproc.y"
    { yyval.str = make_str("session authorization default"); }
    break;

  case 159:
#line 1066 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 160:
#line 1067 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("."), yyvsp[0].str); }
    break;

  case 161:
#line 1072 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 162:
#line 1074 "preproc.y"
    { yyval.str = make_str("default"); }
    break;

  case 163:
#line 1078 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 164:
#line 1080 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 165:
#line 1083 "preproc.y"
    { yyval.str = make_str("read uncommitted"); }
    break;

  case 166:
#line 1084 "preproc.y"
    { yyval.str = make_str("read committed"); }
    break;

  case 167:
#line 1085 "preproc.y"
    { yyval.str = make_str("repeatable read"); }
    break;

  case 168:
#line 1086 "preproc.y"
    { yyval.str = make_str("serializable"); }
    break;

  case 169:
#line 1089 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 170:
#line 1090 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 171:
#line 1091 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 172:
#line 1094 "preproc.y"
    { yyval.str = make_str("true"); }
    break;

  case 173:
#line 1095 "preproc.y"
    { yyval.str = make_str("false"); }
    break;

  case 174:
#line 1096 "preproc.y"
    { yyval.str = make_str("on"); }
    break;

  case 175:
#line 1097 "preproc.y"
    { yyval.str = make_str("off"); }
    break;

  case 176:
#line 1107 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 177:
#line 1108 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 178:
#line 1110 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 179:
#line 1112 "preproc.y"
    { yyval.str = cat_str(6, yyvsp[-5].str, make_str("("), yyvsp[-3].str, make_str(")"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 180:
#line 1114 "preproc.y"
    { yyval.str = make_str("default"); }
    break;

  case 181:
#line 1116 "preproc.y"
    { yyval.str = make_str("local"); }
    break;

  case 182:
#line 1119 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 183:
#line 1120 "preproc.y"
    { yyval.str = make_str("default"); }
    break;

  case 184:
#line 1121 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 185:
#line 1124 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 186:
#line 1125 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 187:
#line 1129 "preproc.y"
    { yyval.str = cat2_str(make_str("show"), yyvsp[0].str); }
    break;

  case 188:
#line 1131 "preproc.y"
    { yyval.str = make_str("show time zone"); }
    break;

  case 189:
#line 1133 "preproc.y"
    { yyval.str = make_str("show transaction isolation level"); }
    break;

  case 190:
#line 1135 "preproc.y"
    { yyval.str = make_str("show session authorization"); }
    break;

  case 191:
#line 1137 "preproc.y"
    { yyval.str = make_str("show all"); }
    break;

  case 192:
#line 1141 "preproc.y"
    { yyval.str = cat2_str(make_str("reset"), yyvsp[0].str); }
    break;

  case 193:
#line 1143 "preproc.y"
    { yyval.str = make_str("reset time zone"); }
    break;

  case 194:
#line 1145 "preproc.y"
    { yyval.str = make_str("reset transaction isolation level"); }
    break;

  case 195:
#line 1147 "preproc.y"
    { yyval.str = make_str("reset session authorization"); }
    break;

  case 196:
#line 1149 "preproc.y"
    { yyval.str = make_str("reset all"); }
    break;

  case 197:
#line 1153 "preproc.y"
    { yyval.str = cat_str(3, make_str("set constraints"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 198:
#line 1157 "preproc.y"
    { yyval.str = make_str("all"); }
    break;

  case 199:
#line 1159 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 200:
#line 1162 "preproc.y"
    { yyval.str = make_str("deferred"); }
    break;

  case 201:
#line 1163 "preproc.y"
    { yyval.str = make_str("immediate"); }
    break;

  case 202:
#line 1169 "preproc.y"
    { yyval.str= make_str("checkpoint"); }
    break;

  case 203:
#line 1181 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter table"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 204:
#line 1185 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 205:
#line 1186 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 206:
#line 1192 "preproc.y"
    { yyval.str = cat_str(3, make_str("add"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 207:
#line 1195 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 208:
#line 1198 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("drop not null")); }
    break;

  case 209:
#line 1201 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("set not null")); }
    break;

  case 210:
#line 1204 "preproc.y"
    { yyval.str = cat_str(5, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("set statistics"), yyvsp[0].str); }
    break;

  case 211:
#line 1207 "preproc.y"
    { yyval.str = cat_str(5, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("set storage"), yyvsp[0].str); }
    break;

  case 212:
#line 1210 "preproc.y"
    { yyval.str = cat_str(4, make_str("drop"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 213:
#line 1213 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("type"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 214:
#line 1216 "preproc.y"
    { yyval.str = cat_str(2, make_str("add"), yyvsp[0].str); }
    break;

  case 215:
#line 1219 "preproc.y"
    { yyval.str = cat_str(3, make_str("drop constraint"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 216:
#line 1222 "preproc.y"
    { yyval.str = make_str("set without oids"); }
    break;

  case 217:
#line 1225 "preproc.y"
    { yyval.str = make_str("create toast table"); }
    break;

  case 218:
#line 1228 "preproc.y"
    { yyval.str = cat_str(2, make_str("owner to"), yyvsp[0].str); }
    break;

  case 219:
#line 1231 "preproc.y"
    { yyval.str = cat_str(2, make_str("cluster on"), yyvsp[0].str); }
    break;

  case 220:
#line 1234 "preproc.y"
    { yyval.str = make_str("set without cluster"); }
    break;

  case 221:
#line 1237 "preproc.y"
    { yyval.str = cat_str(2, make_str("set tablespace"), yyvsp[0].str); }
    break;

  case 222:
#line 1241 "preproc.y"
    { yyval.str = cat2_str(make_str("set default"), yyvsp[0].str); }
    break;

  case 223:
#line 1242 "preproc.y"
    { yyval.str = make_str("drop default"); }
    break;

  case 224:
#line 1245 "preproc.y"
    { yyval.str = make_str("cascade"); }
    break;

  case 225:
#line 1246 "preproc.y"
    { yyval.str = make_str("restrict"); }
    break;

  case 226:
#line 1247 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 227:
#line 1250 "preproc.y"
    { yyval.str = cat2_str(make_str("using"), yyvsp[0].str); }
    break;

  case 228:
#line 1251 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 229:
#line 1262 "preproc.y"
    {
			yyval.str = cat2_str(make_str("close"), yyvsp[0].str);
		}
    break;

  case 230:
#line 1277 "preproc.y"
    { yyval.str = cat_str(9, make_str("copy"), yyvsp[-7].str, yyvsp[-6].str, yyvsp[-5].str, yyvsp[-4].str, yyvsp[-3].str, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 231:
#line 1280 "preproc.y"
    { yyval.str = make_str("to"); }
    break;

  case 232:
#line 1281 "preproc.y"
    { yyval.str = make_str("from"); }
    break;

  case 233:
#line 1289 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 234:
#line 1290 "preproc.y"
    { yyval.str = make_str("stdin"); }
    break;

  case 235:
#line 1291 "preproc.y"
    { yyval.str = make_str("stdout"); }
    break;

  case 236:
#line 1294 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 237:
#line 1295 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 238:
#line 1298 "preproc.y"
    { yyval.str = make_str("binary"); }
    break;

  case 239:
#line 1299 "preproc.y"
    { yyval.str = make_str("oids"); }
    break;

  case 240:
#line 1301 "preproc.y"
    { yyval.str = cat_str(3, make_str("delimiter"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 241:
#li