.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE FUNCTION" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE FUNCTION \- define a new function
.SH SYNOPSIS
.sp
.nf
CREATE [ OR REPLACE ] FUNCTION \fIname\fR ( [ \fIargtype\fR [, ...] ] )
    RETURNS \fIrettype\fR
  { LANGUAGE \fIlangname\fR
    | IMMUTABLE | STABLE | VOLATILE
    | CALLED ON NULL INPUT | RETURNS NULL ON NULL INPUT | STRICT
    | [EXTERNAL] SECURITY INVOKER | [EXTERNAL] SECURITY DEFINER
    | AS '\fIdefinition\fR'
    | AS '\fIobj_file\fR', '\fIlink_symbol\fR'
  } ...
    [ WITH ( \fIattribute\fR [, ...] ) ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE FUNCTION\fR defines a new function.
\fBCREATE OR REPLACE FUNCTION\fR will either create a
new function, or replace an existing definition.
.PP
The user that creates the function becomes the owner of the function.
"PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of a function to create. If a schema name is included,
then the function is created in the
specified schema. Otherwise it is created in the current schema (the
one at the front of the search path; see CURRENT_SCHEMA()).
The name of the new function must not match any existing function
with the same argument types in the same schema. However, functions of
different argument types may share a name (this is called
\fIoverloading\fR).
.TP
\fB\fIargtype\fB\fR
The data type(s) of the function's arguments, if any. The
input types may be base, complex, or domain types,
or the same as the type of an existing column.
The type of a column is referenced by writing \fItablename\fR.\fIcolumnname\fR%TYPE;
using this can sometimes help make a function independent from
changes to the definition of a table.
Depending on the implementation language it may also be allowed
to specify ``pseudo-types'' such as \fBcstring\fR.
Pseudo-types indicate that the actual argument type is either
incompletely specified, or outside the set of ordinary SQL data types.
.TP
\fB\fIrettype\fB\fR
The return data type. The return type may be specified as a
base, complex, or domain type, or the same as the type of an
existing column.
Depending on the implementation language it may also be allowed
to specify ``pseudo-types'' such as \fBcstring\fR.
The setof
modifier indicates that the function will return a set of
items, rather than a single item.
.TP
\fB\fIlangname\fB\fR
The name of the language that the function is implemented in.
May be SQL, C,
internal, or the name of a user-defined
procedural language. (See also createlang [\fBcreatelang\fR(1)].) For backward compatibility,
the name may be enclosed by single quotes.
.TP
\fBIMMUTABLE\fR
.TP
\fBSTABLE\fR
.TP
\fBVOLATILE\fR
These attributes inform the system whether it is safe to
replace multiple evaluations of the function with a single
evaluation, for run-time optimization. At most one choice
should be specified. If none of these appear,
VOLATILE is the default assumption.

IMMUTABLE indicates that the function always
returns the same result when given the same argument values; that
is, it does not do database lookups or otherwise use information not
directly present in its parameter list. If this option is given,
any call of the function with all-constant arguments can be
immediately replaced with the function value.

STABLE indicates that within a single table scan
the function will consistently
return the same result for the same argument values, but that its
result could change across SQL statements. This is the appropriate
selection for functions whose results depend on database lookups,
parameter variables (such as the current time zone), etc. Also note
that the CURRENT_TIMESTAMP family of functions qualify
as stable, since their values do not change within a transaction.

VOLATILE indicates that the function value can
change even within a single table scan, so no optimizations can be
made. Relatively few database functions are volatile in this sense;
some examples are random(), currval(),
timeofday(). Note that any function that has side-effects
must be classified volatile, even if its result is quite predictable,
to prevent calls from being optimized away; an example is
setval().
.TP
\fBCALLED ON NULL INPUT\fR
.TP
\fBRETURNS NULL ON NULL INPUT\fR
.TP
\fBSTRICT\fR
CALLED ON NULL INPUT (the default) indicates
that the function will be called normally when some of its
arguments are null. It is then the function author's
responsibility to check for null values if necessary and respond
appropriately.

RETURNS NULL ON NULL INPUT or
STRICT indicates that the function always
returns NULL whenever any of its arguments are NULL. If this
parameter is specified, the function is not executed when there
are NULL arguments; instead a NULL result is assumed
automatically.
.TP
\fB[EXTERNAL] SECURITY INVOKER\fR
.TP
\fB[EXTERNAL] SECURITY DEFINER\fR
SECURITY INVOKER indicates that the function
is to be executed with the privileges of the user that calls it.
That is the default. SECURITY DEFINER
specifies that the function is to be executed with the
privileges of the user that created it.

The key word EXTERNAL is present for SQL
compatibility but is optional since, unlike in SQL, this feature
does not only apply to external functions.
.TP
\fB\fIdefinition\fB\fR
A string defining the function; the meaning depends on the
language. It may be an internal function name, the path to an
object file, an SQL query, or text in a procedural language.
.TP
\fB\fIobj_file\fB, \fIlink_symbol\fB\fR
This form of the AS clause is used for
dynamically linked C language functions when the function name
in the C language source code is not the same as the name of
the SQL function. The string \fIobj_file\fR is the name of the
file containing the dynamically loadable object, and
\fIlink_symbol\fR is the
object's link symbol, that is, the name of the function in the C
language source code.
.TP
\fB\fIattribute\fB\fR
The historical way to specify optional pieces of information
about the function. The following attributes may appear here:
.RS
.TP
\fBisStrict\fR
Equivalent to STRICT or RETURNS NULL ON NULL INPUT
.TP
\fBisCachable\fR
isCachable is an obsolete equivalent of
IMMUTABLE; it's still accepted for
backwards-compatibility reasons.
.RE
.PP
Attribute names are not case-sensitive.
.SH "NOTES"
.PP
Refer to the chapter in the
\fIPostgreSQL Programmer's Guide\fR
on the topic of extending
PostgreSQL via functions 
for further information on writing external functions.
.PP
The full SQL type syntax is allowed for
input arguments and return value. However, some details of the
type specification (e.g., the precision field for
\fBnumeric\fR types) are the responsibility of the
underlying function implementation and are silently swallowed
(i.e., not recognized or
enforced) by the \fBCREATE FUNCTION\fR command.
.PP
PostgreSQL allows function \fIoverloading\fR;
that is, the same name can be used for several different functions
so long as they have distinct argument types. This facility must
be used with caution for internal and C-language functions, however. 
.PP
Two internal
functions cannot have the same C name without causing
errors at link time. To get around that, give them different C names
(for example, use the argument types as part of the C names), then
specify those names in the AS clause of \fBCREATE FUNCTION\fR.
If the AS clause is left empty, then \fBCREATE FUNCTION\fR
assumes the C name of the function is the same as the SQL name.
.PP
Similarly, when overloading SQL function names with multiple C-language
functions, give
each C-language instance of the function a distinct name, then use
the alternative form of the \fBAS\fR clause in the
\fBCREATE FUNCTION\fR syntax to select the appropriate
C-language implementation of each overloaded SQL function.
.PP
When repeated \fBCREATE FUNCTION\fR calls refer to
the same object file, the file is only loaded once. To unload and
reload the file (perhaps during development), use the LOAD [\fBload\fR(l)] command.
.PP
Use \fBDROP FUNCTION\fR
to remove user-defined functions.
.PP
To update the definition of an existing function, use
\fBCREATE OR REPLACE FUNCTION\fR. Note that it is
not possible to change the name or argument types of a function
this way (if you tried, you'd just be creating a new, distinct
function). Also, \fBCREATE OR REPLACE FUNCTION\fR
will not let you change the return type of an existing function.
To do that, you must drop and re-create the function.
.PP
If you drop and then re-create a function, the new function is not
the same entity as the old; you will break existing rules, views,
triggers, etc that referred to the old function. Use 
\fBCREATE OR REPLACE FUNCTION\fR to change a function
definition without breaking objects that refer to the function.
.PP
To be able to define a function, the user must have the
USAGE privilege on the language.
.PP
By default, only the owner (creator) of the function has the right
to execute it. Other users must be granted the
EXECUTE privilege on the function to be able to
use it.
.SH "EXAMPLES"
.PP
To create a simple SQL function:
.sp
.nf
CREATE FUNCTION one() RETURNS integer
    AS 'SELECT 1 AS RESULT;'
    LANGUAGE SQL;

SELECT one() AS answer;
 answer 
--------
      1
.sp
.fi
.PP
The next example creates a C function by calling a routine from a
user-created shared library named \fIfuncs.so\fR (the extension
may vary across platforms). The shared library file is sought in the
server's dynamic library search path. This particular routine calculates
a check digit and returns true if the check digit in the function
parameters is correct. It is intended for use in a CHECK
constraint.
.sp
.nf
CREATE FUNCTION ean_checkdigit(char, char) RETURNS boolean
    AS 'funcs' LANGUAGE C;
    
CREATE TABLE product (
    id        char(8) PRIMARY KEY,
    eanprefix char(8) CHECK (eanprefix ~ '[0-9]{2}-[0-9]{5}')
                      REFERENCES brandname(ean_prefix),
    eancode   char(6) CHECK (eancode ~ '[0-9]{6}'),
    CONSTRAINT ean    CHECK (ean_checkdigit(eanprefix, eancode))
);
.sp
.fi
.PP
The next example creates a function that does type conversion from the
user-defined type complex to the built-in type point. The
function is implemented by a dynamically loaded object that was
compiled from C source (we illustrate the now-deprecated alternative
of specifying the absolute file name to the shared object file).
For PostgreSQL to
find a type conversion function automatically, the SQL function has
to have the same name as the return type, and so overloading is
unavoidable. The function name is overloaded by using the second
form of the \fBAS\fR clause in the SQL definition:
.sp
.nf
CREATE FUNCTION point(complex) RETURNS point
    AS '/home/bernie/pgsql/lib/complex.so', 'complex_to_point'
    LANGUAGE C STRICT;
.sp
.fi
The C declaration of the function could be:
.sp
.nf
Point * complex_to_point (Complex *z)
{
	Point *p;

	p = (Point *) palloc(sizeof(Point));
	p->x = z->x;
	p->y = z->y;
		
	return p;
}
.sp
.fi
Note that the function is marked ``strict''; this allows us
to skip checking for NULL input in the function body.
.SH "COMPATIBILITY"
.PP
A \fBCREATE FUNCTION\fR command is defined in SQL99.
The \fBPostgreSQL\fR version is similar but
not fully compatible. The attributes are not portable, neither are the
different available languages.
.SH "SEE ALSO"
.PP
DROP FUNCTION [\fBdrop_function\fR(l)],
GRANT [\fBgrant\fR(l)],
LOAD [\fBload\fR(l)],
REVOKE [\fBrevoke\fR(l)],
\fBcreatelang\fR(1),
\fIPostgreSQL Programmer's Guide\fR
