.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "SET" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
SET \- change a run-time parameter
.SH SYNOPSIS
.sp
.nf
SET [ SESSION | LOCAL ] \fIvariable\fR { TO | = } { \fIvalue\fR | '\fIvalue\fR' | DEFAULT }
SET [ SESSION | LOCAL ] TIME ZONE { \fItimezone\fR | LOCAL | DEFAULT }
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBSESSION\fR
Specifies that the command takes effect for the current session.
(This is the default if neither \fBSESSION\fR nor
\fBLOCAL\fR appears.)
.TP
\fBLOCAL\fR
Specifies that the command takes effect for only the current
transaction. After \fBCOMMIT\fR or \fBROLLBACK\fR,
the session-level setting takes effect again. Note that
\fBSET LOCAL\fR will appear to have no effect if it's
executed outside a \fBBEGIN\fR block, since the transaction
will end immediately.
.TP
\fB\fIvariable\fB\fR
A settable run-time parameter.
.TP
\fB\fIvalue\fB\fR
New value of parameter. \fBDEFAULT\fR can be
used to specify resetting the parameter to its default
value. Lists of strings are allowed, but more complex
constructs may need to be single or double quoted.
.PP
.SH "DESCRIPTION"
.PP
The \fBSET\fR command changes run-time configuration
parameters. Many of the run-time parameters listed in the
\fIAdministrator's Guide\fR can be changed on-the-fly
with \fBSET\fR. (But some require superuser privileges
to change, and others cannot be changed after server or session start.)
Note that \fBSET\fR only affects the value used by the
current session.
.PP
If \fBSET\fR or \fBSET SESSION\fR is issued
within a transaction that is later aborted, the effects of the
\fBSET\fR command disappear when the transaction is rolled
back. (This behavior represents a change from
PostgreSQL versions prior to 7.3, where
the effects of \fBSET\fR would not roll back after a later
error.) Once the surrounding transaction is committed, the effects
will persist until the end of the session, unless overridden by another
\fBSET\fR.
.PP
The effects of \fBSET LOCAL\fR last only till the end of
the current transaction, whether committed or not. A special case is
\fBSET\fR followed by \fBSET LOCAL\fR within
a single transaction: the \fBSET LOCAL\fR value will be
seen until the end of the transaction, but afterwards (if the transaction
is committed) the \fBSET\fR value will take effect.
.PP
Even with autocommit set to off, \fBSET\fR
does not start a new transaction block. See the
autocommit section of the \fIAdministrator's
Guide\fR for details.
.PP
Here are additional details about a few of the parameters that can be set:
.TP
\fBDATESTYLE\fR
Choose the date/time representation style. Two separate
settings are involved: the default date/time output and the
interpretation of ambiguous input.

The following are date/time output styles:
.RS
.TP
\fBISO\fR
Use ISO 8601-style dates and times (YYYY-MM-DD
HH:MM:SS). This is the default.
.TP
\fBSQL\fR
Use Oracle/Ingres-style dates and times. Note that this
style has nothing to do with SQL (which mandates ISO 8601
style), the naming of this option is a historical accident.
.TP
\fBPostgreSQL\fR
Use traditional PostgreSQL format.
.TP
\fBGerman\fR
Use dd.mm.yyyy for numeric date representations.
.RE
.PP

The following two options determine both a substyle of the
``SQL'' and ``PostgreSQL'' output formats
and the preferred interpretation of ambiguous date input.
.RS
.TP
\fBEuropean\fR
Use dd/mm/yyyy for numeric date representations.
.TP
\fBNonEuropean\fR
.TP
\fBUS\fR
Use mm/dd/yyyy for numeric date representations.
.RE
.PP

A value for \fBSET DATESTYLE\fR can be one from
the first list (output styles), or one from the second list
(substyles), or one from each separated by a comma.

\fBSET DATESTYLE\fR affects interpretation of
input and provides several standard output formats. For
applications needing different variations or tighter control
over input or output, consider using
the \fBto_char\fR family of
functions.

There are several now-deprecated means for setting the date style
in addition to the normal methods of setting it via \fBSET\fR or
a configuration-file entry:

Setting the postmaster's \fBPGDATESTYLE\fR environment
variable. (This will be overridden by any of the other methods.)

Running postmaster using the option \fB-o -e\fR to
set dates to the European convention.
(This overrides environment variables and configuration-file
entries.)

Setting the client's \fBPGDATESTYLE\fR environment variable.
If \fBPGDATESTYLE\fR is set in the frontend environment of a client
based on \fBlibpq\fR, \fBlibpq\fR will automatically set DATESTYLE to the
value of \fBPGDATESTYLE\fR during connection start-up. This is
equivalent to a manually issued \fBSET DATESTYLE\fR.

.TP
\fBNAMES\fR
\fBSET NAMES\fR is an alias for \fBSET CLIENT_ENCODING\fR.
.TP
\fBSEED\fR
Sets the internal seed for the random number generator.
.RS
.TP
\fB\fIvalue\fB\fR
The value for the seed to be used by the
\fBrandom\fR function. Allowed
values are floating-point numbers between 0 and 1, which
are then multiplied by 231-1.
.RE
.PP

The seed can also be set by invoking the
\fBsetseed\fR SQL function:
.sp
.nf
SELECT setseed(\fIvalue\fR);
       
.sp
.fi
.TP
\fBSERVER_ENCODING\fR
Shows the server-side multibyte encoding. (At present, this
parameter can be shown but not set, because the encoding is
determined at \fBinitdb\fR time.)
.TP
\fBTIME ZONE\fR
.TP
\fBTIMEZONE\fR
Sets the default time zone for your session. Arguments can be
an SQL time interval constant, an integer or double precision
constant, or a string representing a time zone name recognized
by the host operating system.

Here are some typical values for time zone settings:
.RS
.TP
\fB\&'PST8PDT'\fR
Set the time zone for Berkeley, California.
.TP
\fB\&'Portugal'\fR
Set the time zone for Portugal.
.TP
\fB\&'Europe/Rome'\fR
Set the time zone for Italy.
.TP
\fB7\fR
Set the time zone to 7 hours offset west from GMT (equivalent
to PDT).
.TP
\fBINTERVAL '08:00' HOUR TO MINUTE\fR
Set the time zone to 8 hours offset west from GMT (equivalent
to PST).
.TP
\fBLOCAL\fR
.TP
\fBDEFAULT\fR
Set the time zone to your local time zone (the one that
your operating system defaults to).
.RE
.PP

The available time zone names depend on your operating
system. For example, on Linux
\fI/usr/share/zoneinfo\fR contains the database
of time zones; the names of the files in that directory can be
used as parameters to this command.

If an invalid time zone is specified, the time zone
becomes GMT (on most systems anyway).

If the \fBPGTZ\fR environment variable is set in the frontend
environment of a client based on \fBlibpq\fR, \fBlibpq\fR will automatically
\fBSET TIMEZONE\fR to the value of
\fBPGTZ\fR during connection start-up. 
.PP
.PP
Use SHOW [\fBshow\fR(l)] to show the
current setting of a parameter.
.SH "DIAGNOSTICS"
.PP
.TP
\fBSET\fR
Message returned if successful.
.TP
\fBERROR: '\fIname\fB is not a\fR
The parameter you tried to set does not exist.
.TP
\fBERROR: '\fIname\fB':\fR
You must be a superuser to alter certain settings.
.TP
\fBERROR: '\fIname\fB' cannot\fR
Some parameters are fixed once the server is started.
.PP
.SH "EXAMPLES"
.PP
Set the style of date to traditional
PostgreSQL with European conventions:
.sp
.nf
SET DATESTYLE TO PostgreSQL,European;
   
.sp
.fi
.PP
Set the time zone for Berkeley, California, using quotes to
preserve the uppercase spelling of the time zone name (note
that the date style is PostgreSQL for this
example): 
.sp
.nf
SET TIME ZONE 'PST8PDT';
SELECT CURRENT_TIMESTAMP AS today;
               today                
------------------------------------
 Tue Feb 26 07:32:21.42834 2002 PST
   
.sp
.fi
.PP
Set the time zone for Italy (note the required single quotes to handle 
the special characters):
.sp
.nf
SET TIME ZONE 'Europe/Rome';
SELECT CURRENT_TIMESTAMP AS today;

             today             
-------------------------------
 2002-10-08 05:39:35.008271+02
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
SET TIME ZONE
extends syntax defined in
SQL9x. SQL9x allows
only numeric time zone offsets while
PostgreSQL allows full time zone
specifier strings as well. All other SET
features are
PostgreSQL extensions.
.SH "SEE ALSO"
.PP
The function \fBset_config\fR provides the equivalent
capability. See \fIMiscellaneous Functions\fR in the
\fIPostgreSQL User's Guide\fR.
