.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP USER" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP USER \- remove a database user account
.SH SYNOPSIS
.sp
.nf
DROP USER \fIname\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP USER\fR removes the specified user from the database.
It does not remove tables, views, or other objects owned by the user. If the
user owns any database, an error is raised.
.SS "PARAMETERS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing user.
.PP
.SH "DIAGNOSTICS"
.PP
.TP
\fBDROP USER\fR
The message returned if the user is successfully deleted.
.TP
\fBERROR: DROP USER: user "\fIname\fB" does not exist\fR
This message occurs if the user name is not found.
.TP
\fBDROP USER: user "\fIname\fB" owns database "\fIname\fB", cannot be removed\fR
You must drop the database first or change its ownership.
.PP
.SH "NOTES"
.PP
Use CREATE USER [\fBcreate_user\fR(l)]
to add new users, and ALTER USER [\fBalter_user\fR(l)] to change a user's attributes.
PostgreSQL includes a program dropuser [\fBdropuser\fR(1)] that has the
same functionality as this command (in fact, it calls this command)
but can be run from the command shell.
.SH "EXAMPLES"
.PP
To drop a user account:
.sp
.nf
DROP USER jonathan;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBDROP USER\fR statement is a
PostgreSQL extension. The SQL standard
leaves the definition of users to the implementation.
.SH "SEE ALSO"
CREATE USER [\fBcreate_user\fR(l)], ALTER USER [\fBalter_user\fR(l)], \fBdropuser\fR(1)

