.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP SCHEMA" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP SCHEMA \- remove a schema
.SH SYNOPSIS
.sp
.nf
DROP SCHEMA \fIname\fR [, ...] [ CASCADE | RESTRICT ]

  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of a schema.
.TP
\fBCASCADE\fR
Automatically drop objects (tables, functions, etc) that are contained
in the schema.
.TP
\fBRESTRICT\fR
Refuse to drop the schema if it contains any objects.
This is the default.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP SCHEMA\fR
The message returned if the schema is successfully dropped.
.TP
\fBERROR: Schema "\fIname\fB" does not exist\fR
This message occurs if the specified schema does not exist.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP SCHEMA\fR removes schemas from the data base.
.PP
A schema can only be dropped by its owner or a superuser. Note that
the owner can drop the schema (and thereby all contained objects)
even if he does not own some of the objects within the schema.
.SS "NOTES"
.PP
Refer to the \fBCREATE SCHEMA\fR statement for
information on how to create a schema.
.SH "USAGE"
.PP
To remove schema mystuff from the database,
along with everything it contains:
.sp
.nf
DROP SCHEMA mystuff CASCADE;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBDROP SCHEMA\fR is fully compatible with
SQL92, except that the standard only allows
one schema to be dropped per command.
