.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE TRIGGER" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TRIGGER \- define a new trigger
.SH SYNOPSIS
.sp
.nf
CREATE TRIGGER \fIname\fR { BEFORE | AFTER } { \fIevent\fR [OR ...] }
    ON \fItable\fR FOR EACH { ROW | STATEMENT }
    EXECUTE PROCEDURE \fIfunc\fR ( \fIarguments\fR )
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name to give the new trigger. This must be distinct from the name
of any other trigger for the same table.
.TP
\fB\fIevent\fB\fR
One of INSERT, DELETE or UPDATE.
.TP
\fB\fItable\fB\fR
The name (optionally schema-qualified) of the table the trigger is for.
.TP
\fB\fIfunc\fB\fR
A user-supplied function that is declared as taking no arguments
and returning type trigger.
.TP
\fB\fIarguments\fB\fR
An optional comma-separated list of arguments to be provided to the
function when the trigger is executed, along with the standard trigger
data such as old and new tuple contents. The arguments are literal
string constants. Simple names and numeric constants may be written
here too, but they will all be converted to strings.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE TRIGGER\fR
This message is returned if the trigger is successfully created.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE TRIGGER\fR will enter a new trigger into the current
data base. The trigger will be associated with the relation
\fItable\fR and will execute
the specified function \fIfunc\fR.
.PP
The trigger can be specified to fire either before BEFORE the
operation is attempted on a tuple (before constraints are checked and
the \fBINSERT\fR, \fBUPDATE\fR or
\fBDELETE\fR is attempted) or AFTER the operation has
been attempted (e.g., after constraints are checked and the
\fBINSERT\fR, \fBUPDATE\fR or
\fBDELETE\fR has completed). If the trigger fires before
the event, the trigger may skip the operation for the current tuple,
or change the tuple being inserted (for \fBINSERT\fR and
\fBUPDATE\fR operations only). If the trigger fires
after the event, all changes, including the last insertion, update,
or deletion, are ``visible'' to the trigger.
.PP
If multiple triggers of the same kind are defined for the same event,
they will be fired in alphabetical order by name.
.PP
\fBSELECT\fR does not modify any rows so you can not
create \fBSELECT\fR triggers. Rules and views are more
appropriate in such cases.
.PP
Refer to the chapters on SPI and Triggers in the
\fIPostgreSQL Programmer's Guide\fR for more
information.
.SH "NOTES"
.PP
To create a trigger on a table, the user must have the
TRIGGER privilege on the table.
.PP
In PostgreSQL versions before 7.3, it was
necessary to declare trigger functions as returning the placeholder
type \fBopaque\fR, rather than \fBtrigger\fR. To support loading
of old dump files, \fBCREATE TRIGGER\fR will accept a function
declared as returning \fBopaque\fR, but it will issue a NOTICE and
change the function's declared return type to \fBtrigger\fR.
.PP
As of the current release, STATEMENT triggers are not implemented.
.PP
Refer to the \fBdrop_trigger\fR(l) command for
information on how to remove triggers.
.SH "EXAMPLES"
.PP
Check if the specified distributor code exists in the distributors
table before appending or updating a row in the table films:
.sp
.nf
CREATE TRIGGER if_dist_exists
    BEFORE INSERT OR UPDATE ON films FOR EACH ROW
    EXECUTE PROCEDURE check_primary_key ('did', 'distributors', 'did');
.sp
.fi
.PP
Before cancelling a distributor or updating its code, remove every
reference to the table films:
.sp
.nf
CREATE TRIGGER if_film_exists 
    BEFORE DELETE OR UPDATE ON distributors FOR EACH ROW
    EXECUTE PROCEDURE check_foreign_key (1, 'CASCADE', 'did', 'films', 'did');
.sp
.fi
.PP
The second example can also be done by using a foreign key,
constraint as in:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3),
    name     VARCHAR(40),
    CONSTRAINT if_film_exists
    FOREIGN KEY(did) REFERENCES films
    ON UPDATE CASCADE ON DELETE CASCADE  
);
.sp
.fi
.SH "COMPATIBILITY"
.TP
\fBSQL92\fR
There is no \fBCREATE TRIGGER\fR statement in SQL92.
.TP
\fBSQL99\fR
The \fBCREATE TRIGGER\fR statement in
PostgreSQL implements a subset of the
SQL99 standard. The following functionality is missing:
.RS
.TP 0.2i
\(bu
SQL99 allows triggers to fire on updates to specific columns
(e.g., AFTER UPDATE OF col1, col2).
.TP 0.2i
\(bu
SQL99 allows you to define aliases for the ``old''
and ``new'' rows or tables for use in the definition
of the triggered action (e.g., CREATE TRIGGER ... ON
tablename REFERENCING OLD ROW AS somename NEW ROW AS
othername ...). Since
PostgreSQL allows trigger
procedures to be written in any number of user-defined
languages, access to the data is handled in a
language-specific way.
.TP 0.2i
\(bu
PostgreSQL only has row-level
triggers, no statement-level triggers.
.TP 0.2i
\(bu
PostgreSQL only allows the
execution of a stored procedure for the triggered action.
SQL99 allows the execution of a number of other SQL commands,
such as \fBCREATE TABLE\fR as triggered action.
This limitation is not hard to work around by creating a
stored procedure that executes these commands.
.RE
.PP

SQL99 specifies that multiple triggers should be fired in
time-of-creation order. PostgreSQL
uses name order, which was judged more convenient to work with.
.SH "SEE ALSO"
\fBcreate_function\fR(l), \fBalter_trigger\fR(l), \fBdrop_trigger\fR(l), \fIPostgreSQL Programmer's Guide\fR

