.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE CONVERSION" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE CONVERSION \- define a user-defined conversion
.SH SYNOPSIS
.sp
.nf
CREATE [DEFAULT] CONVERSION \fIconversion_name\fR
    FOR \fIsource_encoding\fR TO \fIdest_encoding\fR FROM \fIfuncname\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE CONVERSION\fR defines a new encoding
conversion. Conversion names may be used in the CONVERT() function
to specify a particular encoding conversion. Also, conversions that
are marked DEFAULT can be used for automatic encoding conversion between
frontend and backend. For this purpose, two conversions, from encoding A to
B AND from encoding B to A, must be defined.
.PP
To be able to create a conversion, you must have the execute right
on the function and the create right on the destination schema.
"PARAMETERS"
.TP
\fBDEFAULT\fR
The DEFAULT clause indicates that this conversion
is the default for this particular source to destination
encoding. There should be only one default encoding in a schema
for the encoding pair.
.TP
\fB\fIconversion_name\fB\fR
The name of the conversion. The conversion name may be
schema-qualified. If it is not, the conversion is defined in the
current schema. The conversion name must be unique within a
schema.
.TP
\fB\fIsource_encoding\fB\fR
The source encoding name.
.TP
\fB\fIsource_encoding\fB\fR
The destination encoding name.
.TP
\fB\fIfuncname\fB\fR
The function used to perform the conversion. The function name may
be schema-qualified. If it is not, the function will be looked
up in the path.

The function must have the following signature:
.sp
.nf
	conv_proc(
	INTEGER,	-- source encoding id
	INTEGER,	-- destination encoding id
	CSTRING,	-- source string (null terminated C string)
	CSTRING,	-- destination string (null terminated C string)
	INTEGER		-- source string length
	) returns VOID;
       
.sp
.fi
.SH "NOTES"
.PP
Use \fBDROP CONVERSION\fR to remove user-defined conversions.
.PP
The privileges required to create a conversion may be changed in a future
release.
.SH "EXAMPLES"
.PP
To create a conversion from encoding UNICODE to LATIN1 using \fBmyfunc\fR:
.sp
.nf
CREATE CONVERSION myconv FOR 'UNICODE' TO 'LATIN1' FROM myfunc;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBCREATE CONVERSION\fR
is a PostgreSQL extension.
There is no \fBCREATE CONVERSION\fR
statement in SQL99.
.SH "SEE ALSO"
.PP
CREATE FUNCTION [\fBcreate_function\fR(l)],
DROP CONVERSION [\fBdrop_conversion\fR(l)],
\fIPostgreSQL Programmer's Guide\fR
