.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CLUSTER" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
CLUSTER \- cluster a table according to an index
.SH SYNOPSIS
.sp
.nf
CLUSTER \fIindexname\fR ON \fItablename\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIindexname\fB\fR
The name of an index.
.TP
\fB\fItable\fB\fR
The name (possibly schema-qualified) of a table.
.SS "OUTPUTS"
.PP
.TP
\fBCLUSTER\fR
The clustering was done successfully.
.PP
.SH "DESCRIPTION"
.PP
\fBCLUSTER\fR instructs PostgreSQL 
to cluster the table specified
by \fItable\fR
based on the index specified by
\fIindexname\fR. The index must
already have been defined on 
\fItablename\fR.
.PP
When a table is clustered, it is physically reordered
based on the index information. Clustering is a one-time operation:
when the table is subsequently updated, the changes are
not clustered. That is, no attempt is made to store new or
updated tuples according to their index order. If one wishes, one can
periodically re-cluster by issuing the command again.
.SS "NOTES"
.PP
In cases where you are accessing single rows randomly
within a table, the actual order of the data in the heap
table is unimportant. However, if you tend to access some
data more than others, and there is an index that groups
them together, you will benefit from using \fBCLUSTER\fR.
.PP
Another place where \fBCLUSTER\fR is helpful is in
cases where you use an
index to pull out several rows from a table. If you are
requesting a range of indexed values from a table, or a
single indexed value that has multiple rows that match,
\fBCLUSTER\fR will help because once the index identifies the
heap page for the first row that matches, all other rows
that match are probably already on the same heap page,
saving disk accesses and speeding up the query.
.PP
During the cluster operation, a temporary copy of the table is created
that contains the table data in the index order. Temporary copies of
each index on the table are created as well. Therefore, you need free
space on disk at least equal to the sum of the table size and the index
sizes.
.PP
CLUSTER preserves GRANT, inheritance, index, foreign key, and other
ancillary information about the table.
.PP
Because the optimizer records statistics about the ordering of tables, it
is advisable to run \fBANALYZE\fR on the newly clustered
table. Otherwise, the optimizer may make poor choices of query plans.
.PP
There is another way to cluster data. The
\fBCLUSTER\fR command reorders the original table using
the ordering of the index you specify. This can be slow
on large tables because the rows are fetched from the heap
in index order, and if the heap table is unordered, the
entries are on random pages, so there is one disk page
retrieved for every row moved. (PostgreSQL has a cache,
but the majority of a big table will not fit in the cache.)
The other way to cluster a table is to use
.sp
.nf
SELECT \fIcolumnlist\fR INTO TABLE \fInewtable\fR
     FROM \fItable\fR ORDER BY \fIcolumnlist\fR
    
.sp
.fi
which uses the PostgreSQL sorting code in 
the ORDER BY clause to create the desired order; this is usually much
faster than an index scan for
unordered data. You then drop the old table, use
\fBALTER TABLE...RENAME\fR
to rename \fInewtable\fR to the old name, and
recreate the table's indexes. However, this approach does not preserve
OIDs, constraints, foreign key relationships, granted privileges, and
other ancillary properties of the table --- all such items must be
manually recreated.
.SH "USAGE"
.PP
Cluster the employees relation on the basis of its ID attribute:
.sp
.nf
CLUSTER emp_ind ON emp;
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBCLUSTER\fR statement in SQL92.
