.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "ALTER TRIGGER" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER TRIGGER \- change the definition of a trigger
.SH SYNOPSIS
.sp
.nf
ALTER TRIGGER \fItrigger\fR ON \fItable\fR
    RENAME TO \fInewname\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fItrigger \fB\fR
The name of an existing trigger to alter.
.TP
\fB\fItable \fB\fR
The name of the table on which this trigger acts.
.TP
\fB\fInewname \fB\fR
New name for the existing trigger.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBALTER TRIGGER\fR
Message returned from trigger renaming.
.TP
\fBERROR\fR
Message returned if trigger is not available, or new name is a duplicate of another existing trigger on the table.
.PP
.SH "DESCRIPTION"
.PP
\fBALTER TRIGGER\fR changes the definition of an existing trigger.
The RENAME clause causes the name of a trigger on the given table
to change without otherwise changing the trigger definition.
.PP
You must own the table on which the trigger acts in order to change its properties.
.SS "NOTES"
.PP
Refer to \fBCREATE TRIGGER\fR for a further description
of valid arguments.
.SH "USAGE"
.PP
To rename an existing trigger:
.sp
.nf
ALTER TRIGGER emp_stamp ON emp RENAME TO emp_track_chgs;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
The clause to rename triggers is a
PostgreSQL extension from SQL92.
