.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "ALTER USER" "l" "2001-12-28" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER USER \- change a database user account
.SH SYNOPSIS
.sp
.nf
ALTER USER \fIusername\fR [ [ WITH ] \fIoption\fR [ ... ] ]

where \fIoption\fR can be:

	  [ ENCRYPTED | UNENCRYPTED ] PASSWORD '\fIpassword\fR' 
        | CREATEDB | NOCREATEDB
        | CREATEUSER | NOCREATEUSER 
        | VALID UNTIL '\fIabstime\fR'
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIusername\fB\fR
The name of the user whose details are to be altered.
.TP
\fB\fIpassword\fB\fR
The new password to be used for this account.
.TP
\fBENCRYPTED\fR
.TP
\fBUNENCRYPTED\fR
These keywords control whether the
password is stored encrypted in pg_shadow. (See
CREATE USER [\fBcreate_user\fR(l)]
for more information about this choice.)
.TP
\fBCREATEDB\fR
.TP
\fBNOCREATEDB\fR
These clauses define a user's ability to create databases.
If CREATEDB is specified, the user being defined will
be allowed to create his own databases. Using NOCREATEDB
will deny a user the ability to create databases.
.TP
\fBCREATEUSER\fR
.TP
\fBNOCREATEUSER\fR
These clauses determine whether a user will be permitted to
create new users himself. This option will also make the user
a superuser who can override all access restrictions.
.TP
\fB\fIabstime\fB\fR
The date (and, optionally, the time)
at which this user's password is to expire.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBALTER USER\fR
Message returned if the alteration was successful.
.TP
\fBERROR: ALTER USER: user "username" does not exist\fR
Error message returned if the specified user is not known to
the database.
.PP
.SH "DESCRIPTION"
.PP
\fBALTER USER\fR is used to change the attributes of a user's
PostgreSQL account. Attributes not mentioned
in the command retain their previous settings.
.PP
Only a database superuser
can change privileges and password expiration with this command. Ordinary
users can only change their own password.
.PP
\fBALTER USER\fR cannot change a user's group memberships.
Use ALTER GROUP [\fBalter_group\fR(l)]
to do that.
.PP
Use CREATE USER [\fBcreate_user\fR(l)]
to create a new user and DROP USER [\fBdrop_user\fR(l)] to remove a user.
.SH "USAGE"
.PP
Change a user password:
.sp
.nf
ALTER USER davide WITH PASSWORD 'hu8jmn3';
.sp
.fi
Change a user's valid until date:
.sp
.nf
ALTER USER manuel VALID UNTIL 'Jan 31 2030';
.sp
.fi
Change a user's valid until date, specifying that his
authorization should expire at midday on 4th May 1998 using
the time zone which is one hour ahead of UTC:
.sp
.nf
ALTER USER chris VALID UNTIL 'May 4 12:00:00 1998 +1';
.sp
.fi
Give a user the ability to create other users and new databases:
.sp
.nf
ALTER USER miriam CREATEUSER CREATEDB;
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBALTER USER\fR statement in
SQL92.
The standard leaves
the definition of users to the implementation.
