.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE TYPE" "l" "2001-11-29" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TYPE \- define a new data type
.SH SYNOPSIS
.sp
.nf
CREATE TYPE \fItypename\fR ( INPUT = \fIinput_function\fR, OUTPUT = \fIoutput_function\fR
      , INTERNALLENGTH = { \fIinternallength\fR | VARIABLE }
    [ , EXTERNALLENGTH = { \fIexternallength\fR | VARIABLE } ]
    [ , DEFAULT = \fIdefault\fR ]
    [ , ELEMENT = \fIelement\fR ] [ , DELIMITER = \fIdelimiter\fR ]
    [ , SEND = \fIsend_function\fR ] [ , RECEIVE = \fIreceive_function\fR ]
    [ , PASSEDBYVALUE ]
    [ , ALIGNMENT = \fIalignment\fR ]
    [ , STORAGE = \fIstorage\fR ]
)
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fItypename\fB\fR
The name of a type to be created.
.TP
\fB\fIinternallength\fB\fR
A literal value, which specifies the internal length of
the new type.
.TP
\fB\fIexternallength\fB\fR
A literal value, which specifies the external (displayed) length of
the new type.
.TP
\fB\fIinput_function\fB\fR
The name of a function, created by
\fBCREATE FUNCTION\fR, which
converts data from its external form to the type's
internal form.
.TP
\fB\fIoutput_function\fB\fR
The name of a function, created by
\fBCREATE FUNCTION\fR, which
converts data from its internal form to a form suitable
for display.
.TP
\fB\fIelement\fB\fR
The type being created is an array; this specifies
the type of the array elements.
.TP
\fB\fIdelimiter\fB\fR
The delimiter character to be used between values in arrays made
of this type.
.TP
\fB\fIdefault\fB\fR
The default value for the data type. Usually this is omitted,
so that the default is NULL.
.TP
\fB\fIsend_function\fB\fR
The name of a function, created by \fBCREATE FUNCTION\fR, which
converts data of this type into a form suitable for
transmission to another machine.
.TP
\fB\fIreceive_function\fB\fR
The name of a function, created by \fBCREATE FUNCTION\fR, which
converts data of this type from a form suitable for
transmission from another machine to internal form.
.TP
\fB\fIalignment\fB\fR
Storage alignment requirement of the data type. If specified, must
be char, int2,
int4, or double;
the default is int4.
.TP
\fB\fIstorage\fB\fR
Storage technique for the data type. If specified, must
be plain, external,
extended, or main;
the default is plain.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
Message returned if the type is successfully created.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE TYPE\fR allows the user to register a new user data
type with PostgreSQL for use in the current data base. The
user who defines a type becomes its owner.
\fItypename\fR is
the name of the new type and must be unique within the
types defined for this database.
.PP
\fBCREATE TYPE\fR requires the registration of two functions
(using CREATE FUNCTION) before defining the type. The
representation of a new base type is determined by
\fIinput_function\fR, which
converts the type's external representation to an internal
representation usable by the
operators and functions defined for the type. Naturally,
\fIoutput_function\fR
performs the reverse transformation. The input function may be
declared as taking one argument of type \fBopaque\fR,
or as taking three arguments of types
\fBopaque\fR, \fBOID\fR, \fBint4\fR.
(The first argument is the input text as a C string, the second
argument is the element type in case this is an array type,
and the third is the typmod of the destination column, if known.)
The output function may be
declared as taking one argument of type \fBopaque\fR,
or as taking two arguments of types
\fBopaque\fR, \fBOID\fR.
(The first argument is actually of the datatype itself, but since the
output function must be declared first, it's easier to declare it as
accepting type \fBopaque\fR. The second argument is again
the array element type for array types.)
.PP
New base data types can be fixed length, in which case
\fIinternallength\fR is a
positive integer, or variable length, indicated by setting
\fIinternallength\fR
to \fBVARIABLE\fR. (Internally, this is represented
by setting typlen to -1.) The internal representation of all
variable-length types must start with an integer giving the total
length of this value of the type.
.PP
The external representation length is similarly specified using the
\fIexternallength\fR
keyword. (This value is not presently used, and is typically omitted,
letting it default to \fBVARIABLE\fR.)
.PP
To indicate that a type is an array,
specify the type of the array
elements using the \fBELEMENT\fR keyword. For example, to define
an array of 4-byte integers ("int4"), specify
.sp
.nf
ELEMENT = int4
.sp
.fi
More details about array types appear below.
.PP
To indicate the delimiter to be used between values in the external
representation of arrays of this type, \fIdelimiter\fR can be
set to a specific character. The default delimiter is the comma
(','). Note that the delimiter is associated
with the array element type, not the array type itself.
.PP
A default value may be specified, in case a user wants columns of the
datatype to default to something other than NULL.
Specify the default with the \fBDEFAULT\fR keyword.
(Such a default may be overridden by an explicit \fBDEFAULT\fR
clause attached to a particular column.)
.PP
The optional arguments
\fIsend_function\fR and
\fIreceive_function\fR
are not currently used, and are usually omitted (allowing them
to default to the 
\fIoutput_function\fR and
\fIinput_function\fR
respectively). These functions may someday be resurrected for use
in specifying machine-independent binary representations.
.PP
The optional flag, \fBPASSEDBYVALUE\fR, indicates that
values of this data type are passed
by value rather than by reference. Note that you
may not pass by value types whose internal representation is 
longer than the width of the \fBDatum\fR type (four bytes on
most machines, eight bytes on a few).
.PP
The \fIalignment\fR keyword
specifies the storage alignment required for the datatype. The
allowed values equate to alignment on 1, 2, 4, or 8 byte boundaries.
Note that variable-length types must have an alignment of at least
4, since they necessarily contain an \fBint4\fR as their first component.
.PP
The \fIstorage\fR keyword
allows selection of storage strategies for variable-length data types
(only plain is allowed for fixed-length types).
plain disables TOAST for the data type: it will always
be stored in-line and not compressed.
extended gives full TOAST capability: the system will
first try to compress a long data value, and will move the value out of
the main table row if it's still too long.
external allows the value to be moved out of the main
table, but the system will not try to compress it.
main allows compression, but discourages moving the
value out of the main table. (Data items with this storage method may
still be moved out of the main table if there is no other way to make
a row fit, but they will be kept in the main table preferentially over
extended and external items.)
.SS "ARRAY TYPES"
.PP
Whenever a user-defined datatype is created, 
PostgreSQL automatically creates an
associated array type, whose name consists of the base type's
name prepended with an underscore. The parser understands this
naming convention, and translates requests for columns of type
foo[] into requests for type _foo.
The implicitly-created array type is variable length and uses the
built-in input and output functions array_in and
array_out.
.PP
You might reasonably ask ``why is there an \fBELEMENT\fR
option, if the system makes the correct array type automatically?''
The only case where it's useful to use \fBELEMENT\fR is when you are
making a fixed-length type that happens to be internally an array of N
identical things, and you want to allow the N things to be accessed
directly by subscripting, in addition to whatever operations you plan
to provide for the type as a whole. For example, type \fBname\fR
allows its constitutent \fBchar\fRs to be accessed this way.
A 2-D \fBpoint\fR type could allow its two component floats to be
accessed like point[0] and point[1].
Note that
this facility only works for fixed-length types whose internal form
is exactly a sequence of N identical fields. A subscriptable
variable-length type must have the generalized internal representation
used by array_in and array_out.
For historical reasons (i.e., this is clearly wrong but it's far too
late to change it), subscripting of fixed-length array types starts from
zero, rather than from one as for variable-length arrays.
.SH "NOTES"
.PP
User-defined type names cannot begin with the underscore character
(``_'') and can only be 30
characters long (or in general NAMEDATALEN-2, rather than
the NAMEDATALEN-1 characters allowed for other names).
Type names beginning with underscore are
reserved for internally-created array type names.
.SH "EXAMPLES"
.PP
This example creates the \fBbox\fR data type and then uses the
type in a table definition:
.sp
.nf
CREATE TYPE box (INTERNALLENGTH = 16,
    INPUT = my_procedure_1, OUTPUT = my_procedure_2);
CREATE TABLE myboxes (id INT4, description box);
.sp
.fi
.PP
If \fBbox\fR's internal structure were an array of four
\fBfloat4\fRs, we might instead say
.sp
.nf
CREATE TYPE box (INTERNALLENGTH = 16,
    INPUT = my_procedure_1, OUTPUT = my_procedure_2,
    ELEMENT = float4);
.sp
.fi
which would allow a box value's component floats to be accessed
by subscripting. Otherwise the type behaves the same as before.
.PP
This example creates a large object type and uses it in
a table definition:
.sp
.nf
CREATE TYPE bigobj (INPUT = lo_filein, OUTPUT = lo_fileout,
    INTERNALLENGTH = VARIABLE);
CREATE TABLE big_objs (id int4, obj bigobj);
.sp
.fi
.SH "COMPATIBILITY"
.PP
This \fBCREATE TYPE\fR command is a
PostgreSQL extension. There is a
\fBCREATE TYPE\fR statement in SQL99 that is rather
different in detail.
.SH "SEE ALSO"
\fBcreate_function\fR(l), \fBdrop_type\fR(l), \fIPostgreSQL Programmer's Guide\fR

