.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE SEQUENCE" "l" "2001-11-29" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE SEQUENCE \- define a new sequence generator
.SH SYNOPSIS
.sp
.nf
CREATE [ TEMPORARY | TEMP ] SEQUENCE \fIseqname\fR [ INCREMENT \fIincrement\fR ]
    [ MINVALUE \fIminvalue\fR ] [ MAXVALUE \fImaxvalue\fR ]
    [ START \fIstart\fR ] [ CACHE \fIcache\fR ] [ CYCLE ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBTEMPORARY or TEMP\fR
If specified, the sequence object is created only for this session,
and is automatically dropped on session exit.
Existing permanent sequences with the same name are not visible
(in this session) while the temporary sequence exists.
.TP
\fB\fIseqname\fB\fR
The name of a sequence to be created.
.TP
\fB\fIincrement\fB\fR
The
\fBINCREMENT \fIincrement\fB\fR
clause is optional. A positive value will make an
ascending sequence, a negative one a descending sequence.
The default value is one (1).
.TP
\fB\fIminvalue\fB\fR
The optional clause \fBMINVALUE
\fIminvalue\fB\fR
determines the minimum value
a sequence can generate. The defaults are 1 and -2^63-1 for
ascending and descending sequences, respectively.
.TP
\fB\fImaxvalue\fB\fR
The optional clause \fBMAXVALUE
\fImaxvalue\fB\fR
determines the maximum
value for the sequence. The defaults are 2^63-1 and -1 for
ascending and descending sequences, respectively.
.TP
\fB\fIstart\fB\fR
The optional \fBSTART
\fIstart\fB
clause\fR enables the sequence to begin anywhere.
The default starting value is
\fIminvalue\fR
for ascending sequences and
\fImaxvalue\fR
for descending ones.
.TP
\fB\fIcache\fB\fR
The \fBCACHE \fIcache\fB\fR option
enables sequence numbers to be preallocated
and stored in memory for faster access. The minimum
value is 1 (only one value can be generated at a time, i.e., no cache)
and this is also the default.
.TP
\fBCYCLE\fR
The optional CYCLE keyword may be used to enable the sequence
to wrap around when the
\fImaxvalue\fR or
\fIminvalue\fR has been
reached by
an ascending or descending sequence respectively. If the limit is
reached, the next number generated will be the
\fIminvalue\fR or
\fImaxvalue\fR,
respectively.
Without CYCLE, after the limit is reached \fBnextval\fR calls
will return an error.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
Message returned if the command is successful.
.TP
\fBERROR: Relation '\fIseqname\fB' already exists\fR
If the sequence specified already exists.
.TP
\fBERROR: DefineSequence: MINVALUE (\fIstart\fB) can't be >= MAXVALUE (\fImax\fB)\fR
If the specified starting value is out of range.
.TP
\fBERROR: DefineSequence: START value (\fIstart\fB) can't be < MINVALUE (\fImin\fB)\fR
If the specified starting value is out of range.
.TP
\fBERROR: DefineSequence: MINVALUE (\fImin\fB) can't be >= MAXVALUE (\fImax\fB)\fR
If the minimum and maximum values are inconsistent.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE SEQUENCE\fR will enter a new sequence number generator
into the current database. This involves creating and initializing a
new single-row
table with the name \fIseqname\fR.
The generator will be owned by the user issuing the command.
.PP
After a sequence is created, you use the functions
\fBnextval\fR,
\fBcurrval\fR and
\fBsetval\fR
to operate on the sequence. These functions are documented in
the \fIUser's Guide\fR.
.PP
Although you cannot update a sequence directly, you can use a query like
.sp
.nf
SELECT * FROM \fIseqname\fR;
   
.sp
.fi
to examine the parameters and current state of a sequence. In particular,
the last_value field of the sequence shows the last value
allocated by any backend process. (Of course, this value may be obsolete
by the time it's printed, if other processes are actively doing
\fBnextval\fR calls.)
.sp
.RS
.B "Caution:"
Unexpected results may be obtained if a \fIcache\fR setting greater than one
is used for a sequence object that will be used concurrently by multiple
backends. Each backend will allocate and cache successive sequence values
during one access to the sequence object and increase the sequence
object's last_value accordingly. Then, the next \fIcache\fR-1 uses of \fBnextval\fR
within that backend simply return the preallocated values without touching
the shared object. So, any numbers allocated but not used within a session
will be lost when that session ends. Furthermore, although multiple backends are guaranteed to
allocate distinct sequence values, the values may be generated out of
sequence when all the backends are considered. (For example, with a \fIcache\fR
setting of 10, backend A might reserve values 1..10 and return nextval=1, 
then
backend B might reserve values 11..20 and return nextval=11 before backend
A has generated nextval=2.) Thus, with a \fIcache\fR setting of one it is safe
to assume that \fBnextval\fR values are generated sequentially; with a \fIcache\fR
setting greater than one you should only assume that the \fBnextval\fR values
are all distinct, not that they are generated purely sequentially.
Also, last_value will reflect the latest value reserved by any backend,
whether or not it has yet been returned by \fBnextval\fR.
Another consideration is that a \fBsetval\fR executed on such a sequence
will not be noticed by other backends until they have used up any
preallocated values they have cached.
.RE
.sp
.SS "NOTES"
.PP
Use \fBDROP SEQUENCE\fR to remove a sequence.
.PP
Sequences are based on \fBbigint\fR arithmetic, so the range cannot
exceed the range of an eight-byte integer
(-9223372036854775808 to 9223372036854775807). On some older platforms,
there may be no compiler support for eight-byte integers, in which case
sequences use regular \fBinteger\fR arithmetic (range
-2147483648 to +2147483647).
.PP
When \fIcache\fR is greater than
one, each backend uses its own cache to store preallocated numbers.
Numbers that are cached but not used in the current session will be
lost, resulting in ``holes'' in the sequence.
.SH "USAGE"
.PP
Create an ascending sequence called serial, starting at 101:
.sp
.nf
CREATE SEQUENCE serial START 101;
  
.sp
.fi
.PP
Select the next number from this sequence:
.sp
.nf
SELECT nextval('serial');
    
nextval
-------
    114
   
.sp
.fi
.PP
Use this sequence in an INSERT:
.sp
.nf
INSERT INTO distributors VALUES (nextval('serial'), 'nothing');
   
.sp
.fi
.PP
Update the sequence value after a COPY FROM:
.sp
.nf
BEGIN;
    COPY distributors FROM 'input_file';
    SELECT setval('serial', max(id)) FROM distributors;
END;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBCREATE SEQUENCE\fR is a Postgres
language extension.
There is no \fBCREATE SEQUENCE\fR statement
in SQL92.
