.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "SET" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
SET \- Set run-time parameters for session
.SH SYNOPSIS
.sp
.nf
SET \fIvariable\fR { TO | = } { \fIvalue\fR | '\fIvalue\fR' | DEFAULT }
SET CONSTRAINTS {ALL | \fIconstraintlist\fR} \fImode\fR
SET TIME ZONE { '\fItimezone\fR' | LOCAL | DEFAULT }
SET TRANSACTION ISOLATION LEVEL { READ COMMITTED | SERIALIZABLE }
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIvariable\fB\fR
Settable global parameter.
.TP
\fB\fIvalue\fB\fR
New value of parameter. \fBDEFAULT\fR can be
used to specify resetting the parameter to its default
value. Lists of strings are allowed, but more complex
constructs may need to be single or double quoted.
.PP
.PP
The possible variables and allowed values are:
.TP
\fBCLIENT_ENCODING | NAMES\fR
Sets the multi-byte client encoding. Parameters are:
.RS
.TP
\fB\fIvalue\fB\fR
Sets the multi-byte client encoding to
\fIvalue\fR.
The specified encoding must be supported by the backend.
.RE
.PP

This option is only available if MULTIBYTE support was enabled
during the configure step of building Postgres.
.TP
\fBDATESTYLE\fR
Set the date/time representation style. Affects the output format,
and in some cases it can affect the interpretation of input.
.RS
.TP
\fBISO\fR
use ISO 8601-style dates and times
.TP
\fBSQL\fR
use Oracle/Ingres-style dates and times
.TP
\fBPostgres\fR
use traditional Postgres format
.TP
\fBEuropean\fR
use dd/mm/yyyy for numeric date representations.
.TP
\fBNonEuropean\fR
use mm/dd/yyyy for numeric date representations.
.TP
\fBGerman\fR
use dd.mm.yyyy for numeric date representations.
.TP
\fBUS\fR
same as NonEuropean
.TP
\fBDEFAULT\fR
restores the default values (ISO)
.RE
.PP

Date format initialization may be done by:

Setting the \fBPGDATESTYLE\fR environment variable.
If PGDATESTYLE is set in the frontend environment of a client
based on libpq, libpq will automatically set DATESTYLE to the
value of PGDATESTYLE during connection startup.

Running postmaster using the option \fB-o -e\fR to set
dates to the European convention.
Note that this affects only some combinations of date styles; for example
the ISO style is not affected by this parameter.

Changing variables in 
\fIsrc/backend/utils/init/globals.c\fR.

The variables in \fIglobals.c\fR which can be changed are:

bool EuroDates = false | true

int DateStyle = USE_ISO_DATES | USE_POSTGRES_DATES | USE_SQL_DATES | USE_GERMAN_DATES
.TP
\fBSEED\fR
Sets the internal seed for the random number generator.
.RS
.TP
\fB\fIvalue\fB\fR
The value for the seed to be used by the
\fBrandom\fR catalog function. Significant
values are floating point numbers between 0 and 1, which
are then multiplied by RAND_MAX. This product will
silently overflow if a number outside the range is used.

The seed can also be set by invoking the
\fBsetseed\fR SQL function:
.sp
.nf
SELECT setseed(\fIvalue\fR);
	    
.sp
.fi
.RE
.PP

This option is only available if MULTIBYTE support was enabled
during the configure step of building Postgres.
.TP
\fBSERVER_ENCODING\fR
Sets the multi-byte server encoding to:
.RS
.TP
\fB\fIvalue\fB\fR
The identifying value for the server encoding.
.RE
.PP

This option is only available if MULTIBYTE support was enabled
during the configure step of building Postgres.
.TP
\fBCONSTRAINTS\fR
SET CONSTRAINTS affects the behavior of constraint evaluation
in the current transaction.
SET CONSTRAINTS, specified
in SQL3, has these allowed parameters:
.RS
.TP
\fB\fIconstraintlist\fB\fR
Comma separated list of deferrable constraint names.
.TP
\fB\fImode\fB\fR
The constraint mode. Allowed values are
\fBDEFERRED\fR and \fBIMMEDIATE\fR.
.RE
.PP

In \fBIMMEDIATE\fR mode, foreign key constraints
are checked at the end of each query.

In \fBDEFERRED\fR mode, foreign key constraints
marked as \fBDEFERRABLE\fR are checked only at
transaction commit or until its mode is explicitly set to 
\fBIMMEDIATE\fR.
This is actually only done for foreign key
constraints, so it does not apply to UNIQUE or other
constraints.
.TP
\fBTIME ZONE\fR
.TP
\fBTIMEZONE\fR
The possible values for timezone depends on your operating
system. For example on Linux /usr/lib/zoneinfo contains the
database of timezones.

Here are some valid values for timezone:
.RS
.TP
\fBPST8PDT\fR
set the timezone for California
.TP
\fBPortugal\fR
set time zone for Portugal.
.TP
\fB\&'Europe/Rome'\fR
set time zone for Italy.
.TP
\fBDEFAULT\fR
set time zone to your local timezone
(value of the TZ environment variable).
.RE
.PP

If an invalid time zone is specified, the time zone
becomes GMT (on most systems anyway).

The second syntax shown above, allows one to set the timezone
with a syntax similar to SQL92 \fBSET TIME ZONE\fR.
The LOCAL keyword is just an alternate form
of DEFAULT for SQL92 compatibility.

If the PGTZ environment variable is set in the frontend
environment of a client based on libpq, libpq will automatically
set TIMEZONE to the value of PGTZ during connection startup.
.TP
\fBTRANSACTION ISOLATION LEVEL\fR
Sets the isolation level for the current transaction.
.RS
.TP
\fBREAD COMMITTED\fR
The current transaction queries read only rows committed
before a query began. READ COMMITTED is the default.
.sp
.RS
.B "Note:"
SQL92 standard requires 
SERIALIZABLE to be the default isolation level.
.RE
.sp
.TP
\fBSERIALIZABLE\fR
The current transaction queries read only rows committed
before first DML statement 
(\fBSELECT/INSERT/DELETE/UPDATE/FETCH/COPY_TO\fR)
was executed in this transaction. 
.RE
.PP
.PP
.PP
There are also several internal or optimization
parameters which can be specified
by the \fBSET\fR command:
.TP
\fBPG_OPTIONS\fR
Sets various backend parameters.
.TP
\fBRANDOM_PAGE_COST\fR
Sets the optimizer's estimate of the cost of a nonsequentially
fetched disk page. This is measured as a multiple of the cost
of a sequential page fetch.
.RS
.TP
\fB\fIfloat8\fB\fR
Set the cost of a random page access
to the specified floating-point value.
.RE
.PP
.TP
\fBCPU_TUPLE_COST\fR
Sets the optimizer's estimate of the cost of processing each
tuple during a query. This is measured as a fraction of the cost
of a sequential page fetch.
.RS
.TP
\fB\fIfloat8\fB\fR
Set the cost of per-tuple CPU processing
to the specified floating-point value.
.RE
.PP
.TP
\fBCPU_INDEX_TUPLE_COST\fR
Sets the optimizer's estimate of the cost of processing each
index tuple during an index scan. This is measured as a fraction
of the cost of a sequential page fetch.
.RS
.TP
\fB\fIfloat8\fB\fR
Set the cost of per-index-tuple CPU processing
to the specified floating-point value.
.RE
.PP
.TP
\fBCPU_OPERATOR_COST\fR
Sets the optimizer's estimate of the cost of processing each
operator in a WHERE clause. This is measured as a fraction
of the cost of a sequential page fetch.
.RS
.TP
\fB\fIfloat8\fB\fR
Set the cost of per-operator CPU processing
to the specified floating-point value.
.RE
.PP
.TP
\fBEFFECTIVE_CACHE_SIZE\fR
Sets the optimizer's assumption about the effective size of the
disk cache (that is, the portion of the kernel's disk cache that
will be used for Postgres data files). This is measured in disk
pages, which are normally 8Kb apiece.
.RS
.TP
\fB\fIfloat8\fB\fR
Set the assumed cache size
to the specified floating-point value.
.RE
.PP
.TP
\fBENABLE_SEQSCAN\fR
Enables or disables the planner's use of sequential scan plan types.
(It's not possible to suppress sequential scans entirely, but turning
this variable OFF discourages the planner from using one if there is
any other method available.)
.RS
.TP
\fBON\fR
enables use of sequential scans (default setting).
.TP
\fBOFF\fR
disables use of sequential scans.
.RE
.PP
.TP
\fBENABLE_INDEXSCAN\fR
Enables or disables the planner's use of index scan plan types.
.RS
.TP
\fBON\fR
enables use of index scans (default setting).
.TP
\fBOFF\fR
disables use of index scans.
.RE
.PP
.TP
\fBENABLE_TIDSCAN\fR
Enables or disables the planner's use of TID scan plan types.
.RS
.TP
\fBON\fR
enables use of TID scans (default setting).
.TP
\fBOFF\fR
disables use of TID scans.
.RE
.PP
.TP
\fBENABLE_SORT\fR
Enables or disables the planner's use of explicit sort steps.
(It's not possible to suppress explicit sorts entirely, but turning
this variable OFF discourages the planner from using one if there is
any other method available.)
.RS
.TP
\fBON\fR
enables use of sorts (default setting).
.TP
\fBOFF\fR
disables use of sorts.
.RE
.PP
.TP
\fBENABLE_NESTLOOP\fR
Enables or disables the planner's use of nested-loop join plans.
(It's not possible to suppress nested-loop joins entirely, but turning
this variable OFF discourages the planner from using one if there is
any other method available.)
.RS
.TP
\fBON\fR
enables use of nested-loop joins (default setting).
.TP
\fBOFF\fR
disables use of nested-loop joins.
.RE
.PP
.TP
\fBENABLE_MERGEJOIN\fR
Enables or disables the planner's use of mergejoin plans.
.RS
.TP
\fBON\fR
enables use of merge joins (default setting).
.TP
\fBOFF\fR
disables use of merge joins.
.RE
.PP
.TP
\fBENABLE_HASHJOIN\fR
Enables or disables the planner's use of hashjoin plans.
.RS
.TP
\fBON\fR
enables use of hash joins (default setting).
.TP
\fBOFF\fR
disables use of hash joins.
.RE
.PP
.TP
\fBGEQO\fR
Sets the threshold for using the genetic optimizer algorithm.
.RS
.TP
\fBON\fR
enables the genetic optimizer algorithm
for statements with 11 or more tables.
(This is also the DEFAULT setting.)
.TP
\fBON=\fI#\fB\fR
Takes an integer argument to enable the genetic optimizer algorithm
for statements with \fI#\fR
or more tables in the query.
.TP
\fBOFF\fR
disables the genetic optimizer algorithm.
.RE
.PP

See the chapter on GEQO in the Programmer's Guide
for more information about query optimization.

If the PGGEQO environment variable is set in the frontend
environment of a client based on libpq, libpq will automatically
set GEQO to the value of PGGEQO during connection startup.
.TP
\fBKSQO\fR
\fIKey Set Query Optimizer\fR causes the query
planner to convert queries whose WHERE clause contains many
OR'ed AND clauses (such as "WHERE (a=1 AND b=2) OR (a=2 AND b=3) ...")
into a UNION query. This method can be faster than the default
implementation, but it doesn't necessarily give exactly the same
results, since UNION implicitly adds a SELECT DISTINCT clause to
eliminate identical output rows. KSQO is commonly used when
working with products like MicroSoft
Access, which tend to generate queries of this form.
.RS
.TP
\fBON\fR
enables this optimization.
.TP
\fBOFF\fR
disables this optimization (default setting).
.TP
\fBDEFAULT\fR
Equivalent to specifying \fBSET KSQO=OFF\fR.
.RE
.PP

The KSQO algorithm used to be absolutely essential for queries
with many OR'ed AND clauses, but in Postgres 7.0 and later
the standard planner handles these queries fairly successfully.
.TP
\fBMAX_EXPR_DEPTH\fR
Sets the maximum expression nesting depth that the parser will
accept. The default value is high enough for any normal query,
but you can raise it if you need to. (But if you raise it too high,
you run the risk of backend crashes due to stack overflow.)
.RS
.TP
\fB\fIinteger\fB\fR
Maximum depth.
.RE
.PP
.PP
.SS "OUTPUTS"
.PP
.TP
\fBSET VARIABLE\fR
Message returned if successful.
.TP
\fBWARN: Bad value for \fIvariable\fB (\fIvalue\fB)\fR
If the command fails to set the specified variable.
.PP
.SH "DESCRIPTION"
.PP
\fBSET\fR will modify configuration parameters for variable during
a session.
.PP
Current values can be obtained using \fBSHOW\fR, and values
can be restored to the defaults using \fBRESET\fR.
Parameters and values are case-insensitive. Note that the value
field is always specified as a string, so is enclosed in
single-quotes.
.PP
\fBSET TIME ZONE\fR changes the session's
default time zone offset.
An SQL-session always begins with an initial default time zone
offset.
The \fBSET TIME ZONE\fR statement is used to change the default
time zone offset for the current SQL session.
.SS "NOTES"
.PP
The \fBSET \fIvariable\fB\fR
statement is a Postgres language extension.
.PP
Refer to \fBSHOW\fR and \fBRESET\fR to 
display or reset the current values.
.SH "USAGE"
.PP
Set the style of date to ISO (no quotes on the argument is required):
.sp
.nf
SET DATESTYLE TO ISO;
   
.sp
.fi
Enable GEQO for queries with 4 or more tables (note the use of
single quotes to handle the equal sign inside the value argument):
.sp
.nf
 
SET GEQO = 'ON=4';
   
.sp
.fi
Set GEQO to default:
.sp
.nf
 
SET GEQO = DEFAULT;
   
.sp
.fi
Set the timezone for Berkeley, California, using double quotes to
preserve the uppercase
attributes of the time zone specifier:
.sp
.nf
 
SET TIME ZONE "PST8PDT";
SELECT CURRENT_TIMESTAMP AS today;
   
         today
------------------------
 1998-03-31 07:41:21-08
.sp
.fi
Set the timezone for Italy (note the required single or double quotes to handle 
the special characters):
.sp
.nf
 
SET TIME ZONE 'Europe/Rome';
SELECT CURRENT_TIMESTAMP AS today;
   
         today
------------------------
 1998-03-31 17:41:31+02
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no general
\fBSET \fIvariable\fB\fR
in SQL92 (with the exception of
\fBSET TRANSACTION ISOLATION LEVEL\fR).
The SQL92 syntax for \fBSET TIME ZONE\fR
is slightly different,
allowing only a single integer value for time zone specification:
.sp
.nf
SET TIME ZONE { interval_value_expression | LOCAL }
    
.sp
.fi
