/*
 * Decompiled with CFR 0.152.
 */
package postgresql.largeobject;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import postgresql.Driver;
import postgresql.fastpath.Fastpath;
import postgresql.fastpath.FastpathArg;

public class LargeObject {
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    private Fastpath fp;
    private int oid;
    private int fd;

    protected LargeObject(Fastpath fastpath, int n, int n2) throws SQLException {
        this.fp = fastpath;
        this.oid = n;
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(n), new FastpathArg(n2)};
        this.fd = fastpath.getInteger("lo_open", fastpathArgArray);
    }

    public int getOID() {
        return this.oid;
    }

    public void close() throws SQLException {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd)};
        this.fp.fastpath("lo_close", false, fastpathArgArray);
    }

    public byte[] read(int n) throws SQLException {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(n)};
        return this.fp.getData("loread", fastpathArgArray);
    }

    public void read(byte[] byArray, int n, int n2) throws SQLException {
        System.arraycopy(this.read(n2), 0, byArray, n, n2);
    }

    public void write(byte[] byArray) throws SQLException {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(byArray)};
        this.fp.fastpath("lowrite", false, fastpathArgArray);
    }

    public void write(byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.write(byArray2);
    }

    public void seek(int n, int n2) throws SQLException {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(n), new FastpathArg(n2)};
        this.fp.fastpath("lo_lseek", false, fastpathArgArray);
    }

    public void seek(int n) throws SQLException {
        this.seek(n, 0);
    }

    public int tell() throws SQLException {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd)};
        return this.fp.getInteger("lo_tell", fastpathArgArray);
    }

    public int size() throws SQLException {
        int n = this.tell();
        this.seek(0, 2);
        int n2 = this.tell();
        this.seek(n, 0);
        return n2;
    }

    public InputStream getInputStream() throws SQLException {
        throw Driver.notImplemented();
    }

    public OutputStream getOutputStream() throws SQLException {
        throw Driver.notImplemented();
    }
}

