/*
 * Decompiled with CFR 0.152.
 */
package postgresql.jdbc1;

import java.sql.SQLException;
import java.sql.SQLWarning;
import postgresql.ResultSet;
import postgresql.jdbc1.Connection;
import postgresql.util.PSQLException;

public class Statement
implements java.sql.Statement {
    Connection connection;
    java.sql.ResultSet result;
    SQLWarning warnings;
    int timeout;
    boolean escapeProcessing = true;

    public Statement(Connection connection) {
        this.connection = connection;
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        this.execute(string);
        while (this.result != null && !((ResultSet)((Object)this.result)).reallyResultSet()) {
            this.result = ((ResultSet)((Object)this.result)).getNext();
        }
        if (this.result == null) {
            throw new PSQLException("postgresql.stat.noresult");
        }
        return this.result;
    }

    public int executeUpdate(String string) throws SQLException {
        this.execute(string);
        if (((ResultSet)((Object)this.result)).reallyResultSet()) {
            throw new PSQLException("postgresql.stat.result");
        }
        return this.getUpdateCount();
    }

    public void close() throws SQLException {
        this.result = null;
    }

    public int getMaxFieldSize() throws SQLException {
        return 8192;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        throw new PSQLException("postgresql.stat.maxfieldsize");
    }

    public int getMaxRows() throws SQLException {
        return this.connection.maxrows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.connection.maxrows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.timeout = n;
    }

    public void cancel() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void setCursorName(String string) throws SQLException {
        this.connection.setCursorName(string);
    }

    public boolean execute(String string) throws SQLException {
        this.result = this.connection.ExecSQL(string);
        return this.result != null && ((ResultSet)((Object)this.result)).reallyResultSet();
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        return this.result;
    }

    public int getUpdateCount() throws SQLException {
        if (this.result == null) {
            return -1;
        }
        if (((ResultSet)((Object)this.result)).reallyResultSet()) {
            return -1;
        }
        return ((ResultSet)((Object)this.result)).getResultCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.result = ((ResultSet)((Object)this.result)).getNext();
        return this.result != null && ((ResultSet)((Object)this.result)).reallyResultSet();
    }

    public String getResultStatusString() {
        if (this.result == null) {
            return null;
        }
        return ((ResultSet)((Object)this.result)).getStatusString();
    }
}

