/*
 * Decompiled with CFR 0.152.
 */
package postgresql.jdbc1;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;
import postgresql.Field;
import postgresql.jdbc1.Connection;
import postgresql.jdbc1.ResultSet;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    Connection connection;
    static final int iVarcharOid = 1043;
    static final int iBoolOid = 16;
    static final int iInt2Oid = 21;
    static final int iInt4Oid = 23;
    static final int VARHDRSZ = 4;
    private static final byte[] defaultRemarks = "no remarks".getBytes();
    private static final String[][] getTableTypes = new String[][]{{"TABLE", "(relkind='r' and relname !~ '^pg_' and relname !~ '^xinv')"}, {"INDEX", "(relkind='i' and relname !~ '^pg_' and relname !~ '^xinx')"}, {"LARGE OBJECT", "(relkind='r' and relname ~ '^xinv')"}, {"SEQUENCE", "(relkind='S' and relname !~ '^pg_')"}, {"SYSTEM TABLE", "(relkind='r' and relname ~ '^pg_')"}, {"SYSTEM INDEX", "(relkind='i' and relname ~ '^pg_')"}};
    private static final String[] defaultTableTypes = new String[]{"TABLE", "INDEX", "SEQUENCE"};

    public DatabaseMetaData(Connection connection) {
        this.connection = connection;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    public String getDatabaseProductName() throws SQLException {
        return new String("PostgreSQL");
    }

    public String getDatabaseProductVersion() throws SQLException {
        return "6.4";
    }

    public String getDriverName() throws SQLException {
        return new String("PostgreSQL Native Driver");
    }

    public String getDriverVersion() throws SQLException {
        return new String(String.valueOf(Integer.toString(this.connection.this_driver.getMajorVersion())) + "." + Integer.toString(this.connection.this_driver.getMinorVersion()));
    }

    public int getDriverMajorVersion() {
        return this.connection.this_driver.getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return this.connection.this_driver.getMinorVersion();
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return null;
    }

    public String getSQLKeywords() throws SQLException {
        return new String("abort,acl,add,aggregate,append,archive,arch_store,backward,binary,change,cluster,copy,database,delimiters,do,extend,explain,forward,heavy,index,inherits,isnull,light,listen,load,merge,nothing,notify,notnull,oids,purge,rename,replace,retrieve,returns,rule,recipe,setof,stdin,stdout,store,vacuum,verbose,version");
    }

    public String getNumericFunctions() throws SQLException {
        return "";
    }

    public String getStringFunctions() throws SQLException {
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        return "";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    public String getSearchStringEscape() throws SQLException {
        return new String("\\");
    }

    public String getExtraNameCharacters() throws SQLException {
        return new String("");
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    public String getSchemaTerm() throws SQLException {
        return new String("Schema");
    }

    public String getProcedureTerm() throws SQLException {
        return new String("Procedure");
    }

    public String getCatalogTerm() throws SQLException {
        return new String("Catalog");
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        return new String("");
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    public boolean supportsUnion() throws SQLException {
        return false;
    }

    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 8190;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 32;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getMaxColumnsInTable();
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMaxColumnsInTable();
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getMaxColumnsInTable();
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return this.getMaxColumnsInTable();
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    public int getMaxConnections() throws SQLException {
        return 8192;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 32;
    }

    public int getMaxIndexLength() throws SQLException {
        return 8192;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 32;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 8192;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return 8192;
    }

    public int getMaxStatements() throws SQLException {
        return 1;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 32;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 1024;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 32;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 8;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return n == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return true;
    }

    public java.sql.ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[8];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        byte[] byArray = defaultRemarks;
        fieldArray[0] = new Field(this.connection, "PROCEDURE_CAT", 1043, 32);
        fieldArray[1] = new Field(this.connection, "PROCEDURE_SCHEM", 1043, 32);
        fieldArray[2] = new Field(this.connection, "PROCEDURE_NAME", 1043, 32);
        fieldArray[5] = null;
        fieldArray[4] = null;
        fieldArray[3] = null;
        fieldArray[6] = new Field(this.connection, "REMARKS", 1043, 8192);
        fieldArray[7] = new Field(this.connection, "PROCEDURE_TYPE", 21, 2);
        if (string3 == null) {
            string3 = "%";
        }
        java.sql.ResultSet resultSet = this.connection.ExecSQL("select proname, proretset from pg_proc where proname like '" + string3.toLowerCase() + "' order by proname");
        while (resultSet.next()) {
            byte[][] byArray2 = new byte[8][0];
            byArray2[0] = null;
            byArray2[1] = null;
            byArray2[2] = resultSet.getBytes(1);
            byArray2[5] = null;
            byArray2[4] = null;
            byArray2[3] = null;
            byArray2[6] = byArray;
            byArray2[7] = resultSet.getBoolean(2) ? Integer.toString(2).getBytes() : Integer.toString(1).getBytes();
            vector.addElement(byArray2);
        }
        return new ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (string3 == null) {
            string3 = "%";
        }
        if (string4 == null) {
            string4 = "%";
        }
        Field[] fieldArray = new Field[13];
        Vector vector = new Vector();
        fieldArray[0] = new Field(this.connection, new String("PROCEDURE_CAT"), 1043, 32);
        fieldArray[1] = new Field(this.connection, new String("PROCEDURE_SCHEM"), 1043, 32);
        fieldArray[2] = new Field(this.connection, new String("PROCEDURE_NAME"), 1043, 32);
        fieldArray[3] = new Field(this.connection, new String("COLUMN_NAME"), 1043, 32);
        fieldArray[4] = new Field(this.connection, new String("COLUMN_TYPE"), 21, 2);
        fieldArray[5] = new Field(this.connection, new String("DATA_TYPE"), 21, 2);
        fieldArray[6] = new Field(this.connection, new String("TYPE_NAME"), 1043, 32);
        fieldArray[7] = new Field(this.connection, new String("PRECISION"), 23, 4);
        fieldArray[8] = new Field(this.connection, new String("LENGTH"), 23, 4);
        fieldArray[9] = new Field(this.connection, new String("SCALE"), 21, 2);
        fieldArray[10] = new Field(this.connection, new String("RADIX"), 21, 2);
        fieldArray[11] = new Field(this.connection, new String("NULLABLE"), 21, 2);
        fieldArray[12] = new Field(this.connection, new String("REMARKS"), 1043, 32);
        return new ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        if (stringArray == null) {
            stringArray = defaultTableTypes;
        }
        if (string3 == null) {
            string3 = "%";
        }
        Field[] fieldArray = new Field[5];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        fieldArray[0] = new Field(this.connection, new String("TABLE_CAT"), 1043, 32);
        fieldArray[1] = new Field(this.connection, new String("TABLE_SCHEM"), 1043, 32);
        fieldArray[2] = new Field(this.connection, new String("TABLE_NAME"), 1043, 32);
        fieldArray[3] = new Field(this.connection, new String("TABLE_TYPE"), 1043, 32);
        fieldArray[4] = new Field(this.connection, new String("REMARKS"), 1043, 32);
        StringBuffer stringBuffer = new StringBuffer("select relname,oid from pg_class where (");
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (bl) {
                stringBuffer.append(" or ");
            }
            int n2 = 0;
            while (n2 < getTableTypes.length) {
                if (getTableTypes[n2][0].equals(stringArray[n])) {
                    stringBuffer.append(getTableTypes[n2][1]);
                    bl = true;
                }
                ++n2;
            }
            ++n;
        }
        stringBuffer.append(") and relname like '");
        stringBuffer.append(string3.toLowerCase());
        stringBuffer.append("'");
        java.sql.ResultSet resultSet = this.connection.ExecSQL(stringBuffer.toString());
        while (resultSet.next()) {
            byte[] byArray;
            byte[][] byArray2 = new byte[5][0];
            java.sql.ResultSet resultSet2 = this.connection.ExecSQL("select description from pg_description where objoid=" + resultSet.getInt(2));
            if (((postgresql.ResultSet)((Object)resultSet2)).getTupleCount() == 1) {
                resultSet2.next();
                byArray = resultSet2.getBytes(1);
            } else {
                byArray = defaultRemarks;
            }
            resultSet2.close();
            byArray2[0] = null;
            byArray2[1] = null;
            byArray2[2] = resultSet.getBytes(1);
            byArray2[3] = null;
            byArray2[4] = byArray;
            vector.addElement(byArray2);
        }
        resultSet.close();
        return new ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getSchemas() throws SQLException {
        Field[] fieldArray = new Field[1];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        byte[][] byArray = new byte[1][0];
        fieldArray[0] = new Field(this.connection, new String("TABLE_SCHEM"), 1043, 32);
        byArray[0] = "".getBytes();
        vector.addElement(byArray);
        return new ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getCatalogs() throws SQLException {
        Field[] fieldArray = new Field[1];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        byte[][] byArray = new byte[1][0];
        fieldArray[0] = new Field(this.connection, new String("TABLE_CAT"), 1043, 32);
        byArray[0] = "".getBytes();
        vector.addElement(byArray);
        return new ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getTableTypes() throws SQLException {
        Field[] fieldArray = new Field[1];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        byte[][] byArray = new byte[1][0];
        fieldArray[0] = new Field(this.connection, new String("TABLE_TYPE"), 1043, 32);
        int n = 0;
        while (n < getTableTypes.length) {
            byArray[0] = getTableTypes[n][0].getBytes();
            vector.addElement(byArray);
            ++n;
        }
        return new ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        Field[] fieldArray = new Field[18];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        fieldArray[0] = new Field(this.connection, new String("TABLE_CAT"), 1043, 32);
        fieldArray[1] = new Field(this.connection, new String("TABLE_SCHEM"), 1043, 32);
        fieldArray[2] = new Field(this.connection, new String("TABLE_NAME"), 1043, 32);
        fieldArray[3] = new Field(this.connection, new String("COLUMN_NAME"), 1043, 32);
        fieldArray[4] = new Field(this.connection, new String("DATA_TYPE"), 21, 2);
        fieldArray[5] = new Field(this.connection, new String("TYPE_NAME"), 1043, 32);
        fieldArray[6] = new Field(this.connection, new String("COLUMN_SIZE"), 23, 4);
        fieldArray[7] = new Field(this.connection, new String("BUFFER_LENGTH"), 1043, 32);
        fieldArray[8] = new Field(this.connection, new String("DECIMAL_DIGITS"), 23, 4);
        fieldArray[9] = new Field(this.connection, new String("NUM_PREC_RADIX"), 23, 4);
        fieldArray[10] = new Field(this.connection, new String("NULLABLE"), 23, 4);
        fieldArray[11] = new Field(this.connection, new String("REMARKS"), 1043, 32);
        fieldArray[12] = new Field(this.connection, new String("COLUMN_DEF"), 1043, 32);
        fieldArray[13] = new Field(this.connection, new String("SQL_DATA_TYPE"), 23, 4);
        fieldArray[14] = new Field(this.connection, new String("SQL_DATETIME_SUB"), 23, 4);
        fieldArray[15] = new Field(this.connection, new String("CHAR_OCTET_LENGTH"), 1043, 32);
        fieldArray[16] = new Field(this.connection, new String("ORDINAL_POSITION"), 23, 4);
        fieldArray[17] = new Field(this.connection, new String("IS_NULLABLE"), 1043, 32);
        if (string3 == null) {
            string3 = "%";
        }
        if (string4 == null) {
            string4 = "%";
        }
        java.sql.ResultSet resultSet = this.connection.ExecSQL("select a.oid,c.relname,a.attname,a.atttypid,a.attnum,a.attnotnull,a.attlen,a.atttypmod from pg_class c, pg_attribute a where a.attrelid=c.oid and c.relname like '" + string3.toLowerCase() + "' and a.attname like '" + string4.toLowerCase() + "' and a.attnum>0 order by c.relname,a.attnum");
        while (resultSet.next()) {
            int n;
            byte[][] byArray = new byte[18][0];
            java.sql.ResultSet resultSet2 = this.connection.ExecSQL("select description from pg_description where objoid=" + resultSet.getInt(1));
            if (((postgresql.ResultSet)((Object)resultSet2)).getTupleCount() == 1) {
                resultSet2.next();
                byArray[11] = resultSet2.getBytes(1);
            } else {
                byArray[11] = defaultRemarks;
            }
            resultSet2.close();
            byArray[0] = "".getBytes();
            byArray[1] = "".getBytes();
            byArray[2] = resultSet.getBytes(2);
            byArray[3] = resultSet.getBytes(3);
            resultSet2 = this.connection.ExecSQL("select typname from pg_type where oid = " + resultSet.getString(4));
            resultSet2.next();
            String string5 = resultSet2.getString(1);
            resultSet2.close();
            byArray[4] = Integer.toString(Field.getSQLType(string5)).getBytes();
            byArray[5] = string5.getBytes();
            byArray[6] = string5.equals("bpchar") || string5.equals("varchar") ? Integer.toString((n = resultSet.getInt(8)) != -1 ? n - 4 : 0).getBytes() : resultSet.getBytes(7);
            byArray[7] = null;
            byArray[8] = "0".getBytes();
            byArray[9] = "10".getBytes();
            byArray[12] = null;
            byArray[13] = null;
            byArray[14] = null;
            byArray[15] = byArray[6];
            byArray[16] = resultSet.getBytes(5);
            String string6 = resultSet.getString(6);
            byArray[10] = Integer.toString(string6.equals("f") ? 1 : 0).getBytes();
            byArray[17] = (string6.equals("f") ? "YES" : "NO").getBytes();
            vector.addElement(byArray);
        }
        resultSet.close();
        return new ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        Field[] fieldArray = new Field[8];
        Vector vector = new Vector();
        if (string3 == null) {
            string3 = "%";
        }
        string4 = string4 == null ? "%" : string4.toLowerCase();
        fieldArray[0] = new Field(this.connection, new String("TABLE_CAT"), 1043, 32);
        fieldArray[1] = new Field(this.connection, new String("TABLE_SCHEM"), 1043, 32);
        fieldArray[2] = new Field(this.connection, new String("TABLE_NAME"), 1043, 32);
        fieldArray[3] = new Field(this.connection, new String("COLUMN_NAME"), 1043, 32);
        fieldArray[4] = new Field(this.connection, new String("GRANTOR"), 1043, 32);
        fieldArray[5] = new Field(this.connection, new String("GRANTEE"), 1043, 32);
        fieldArray[6] = new Field(this.connection, new String("PRIVILEGE"), 1043, 32);
        fieldArray[7] = new Field(this.connection, new String("IS_GRANTABLE"), 1043, 32);
        java.sql.ResultSet resultSet = this.connection.ExecSQL("SELECT relname, relacl FROM pg_class, pg_user WHERE ( relkind = 'r' OR relkind = 'i') and relname !~ '^pg_' and relname !~ '^xin[vx][0-9]+' and usesysid = relowner and relname like '" + string3.toLowerCase() + "' ORDER BY relname");
        while (resultSet.next()) {
            byte[][] byArray = new byte[8][0];
            byArray[1] = "".getBytes();
            byArray[0] = byArray[1];
            DriverManager.println("relname=\"" + resultSet.getString(1) + "\" relacl=\"" + resultSet.getString(2) + "\"");
        }
        return new ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        return null;
    }

    public java.sql.ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[8];
        Vector vector = new Vector();
        fieldArray[0] = new Field(this.connection, new String("SCOPE"), 21, 2);
        fieldArray[1] = new Field(this.connection, new String("COLUMN_NAME"), 1043, 32);
        fieldArray[2] = new Field(this.connection, new String("DATA_TYPE"), 21, 2);
        fieldArray[3] = new Field(this.connection, new String("TYPE_NAME"), 1043, 32);
        fieldArray[4] = new Field(this.connection, new String("COLUMN_SIZE"), 23, 4);
        fieldArray[5] = new Field(this.connection, new String("BUFFER_LENGTH"), 23, 4);
        fieldArray[6] = new Field(this.connection, new String("DECIMAL_DIGITS"), 21, 2);
        fieldArray[7] = new Field(this.connection, new String("PSEUDO_COLUMN"), 21, 2);
        return new ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        return null;
    }

    public java.sql.ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        return this.connection.createStatement().executeQuery("SELECT '' as TABLE_CAT,'' AS TABLE_SCHEM,bc.relname AS TABLE_NAME,ic.relname AS COLUMN_NAME,'1' as KEY_SEQ,t.typname as PK_NAME  FROM pg_class bc, pg_class ic, pg_index i, pg_attribute a, pg_type t  WHERE bc.relkind = 'r'   and bc.relname ~ '" + string3 + "'" + "  and i.indrelid = bc.oid" + "  and i.indexrelid = ic.oid" + "  and i.indkey[0] = a.attnum" + "  and i.indproc = '0'::oid" + "  and a.attrelid = bc.oid" + " ORDER BY TABLE_NAME, COLUMN_NAME;");
    }

    public java.sql.ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return null;
    }

    public java.sql.ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return null;
    }

    public java.sql.ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        return null;
    }

    public java.sql.ResultSet getTypeInfo() throws SQLException {
        java.sql.ResultSet resultSet = this.connection.ExecSQL("select typname from pg_type");
        if (resultSet != null) {
            Field[] fieldArray = new Field[18];
            Vector<byte[][]> vector = new Vector<byte[][]>();
            fieldArray[0] = new Field(this.connection, new String("TYPE_NAME"), 1043, 32);
            fieldArray[1] = new Field(this.connection, new String("DATA_TYPE"), 21, 2);
            fieldArray[2] = new Field(this.connection, new String("PRECISION"), 23, 4);
            fieldArray[3] = new Field(this.connection, new String("LITERAL_PREFIX"), 1043, 32);
            fieldArray[4] = new Field(this.connection, new String("LITERAL_SUFFIX"), 1043, 32);
            fieldArray[5] = new Field(this.connection, new String("CREATE_PARAMS"), 1043, 32);
            fieldArray[6] = new Field(this.connection, new String("NULLABLE"), 21, 2);
            fieldArray[7] = new Field(this.connection, new String("CASE_SENSITIVE"), 16, 1);
            fieldArray[8] = new Field(this.connection, new String("SEARCHABLE"), 21, 2);
            fieldArray[9] = new Field(this.connection, new String("UNSIGNED_ATTRIBUTE"), 16, 1);
            fieldArray[10] = new Field(this.connection, new String("FIXED_PREC_SCALE"), 16, 1);
            fieldArray[11] = new Field(this.connection, new String("AUTO_INCREMENT"), 16, 1);
            fieldArray[12] = new Field(this.connection, new String("LOCAL_TYPE_NAME"), 1043, 32);
            fieldArray[13] = new Field(this.connection, new String("MINIMUM_SCALE"), 21, 2);
            fieldArray[14] = new Field(this.connection, new String("MAXIMUM_SCALE"), 21, 2);
            fieldArray[15] = new Field(this.connection, new String("SQL_DATA_TYPE"), 23, 4);
            fieldArray[16] = new Field(this.connection, new String("SQL_DATETIME_SUB"), 23, 4);
            fieldArray[17] = new Field(this.connection, new String("NUM_PREC_RADIX"), 23, 4);
            byte[] byArray = "9".getBytes();
            byte[] byArray2 = "10".getBytes();
            byte[] byArray3 = "f".getBytes();
            byte[] byArray4 = Integer.toString(0).getBytes();
            byte[] byArray5 = Integer.toString(3).getBytes();
            while (resultSet.next()) {
                byte[][] byArray6 = new byte[18][];
                String string = resultSet.getString(1);
                byArray6[0] = string.getBytes();
                byArray6[1] = Integer.toString(Field.getSQLType(string)).getBytes();
                byArray6[2] = byArray;
                byArray6[6] = byArray4;
                byArray6[7] = byArray3;
                byArray6[8] = byArray5;
                byArray6[9] = byArray3;
                byArray6[10] = byArray3;
                byArray6[11] = byArray3;
                byArray6[17] = byArray2;
                vector.addElement(byArray6);
            }
            resultSet.close();
            return new ResultSet(this.connection, fieldArray, vector, "OK", 1);
        }
        return null;
    }

    public java.sql.ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        Field[] fieldArray = new Field[13];
        Vector vector = new Vector();
        fieldArray[0] = new Field(this.connection, new String("TABLE_CAT"), 1043, 32);
        fieldArray[1] = new Field(this.connection, new String("TABLE_SCHEM"), 1043, 32);
        fieldArray[2] = new Field(this.connection, new String("TABLE_NAME"), 1043, 32);
        fieldArray[3] = new Field(this.connection, new String("NON_UNIQUE"), 16, 1);
        fieldArray[4] = new Field(this.connection, new String("INDEX_QUALIFIER"), 1043, 32);
        fieldArray[5] = new Field(this.connection, new String("INDEX_NAME"), 1043, 32);
        fieldArray[6] = new Field(this.connection, new String("TYPE"), 21, 2);
        fieldArray[7] = new Field(this.connection, new String("ORDINAL_POSITION"), 21, 2);
        fieldArray[8] = new Field(this.connection, new String("COLUMN_NAME"), 1043, 32);
        fieldArray[9] = new Field(this.connection, new String("ASC_OR_DESC"), 1043, 32);
        fieldArray[10] = new Field(this.connection, new String("CARDINALITY"), 23, 4);
        fieldArray[11] = new Field(this.connection, new String("PAGES"), 23, 4);
        fieldArray[12] = new Field(this.connection, new String("FILTER_CONDITION"), 1043, 32);
        return new ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }
}

