/*
 * Decompiled with CFR 0.152.
 */
package postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import postgresql.geometric.PGpoint;
import postgresql.util.PGobject;
import postgresql.util.PGtokenizer;
import postgresql.util.PSQLException;

public class PGpath
extends PGobject
implements Serializable,
Cloneable {
    public boolean open;
    public PGpoint[] points;

    public PGpath(PGpoint[] pGpointArray, boolean bl) {
        this();
        this.points = pGpointArray;
        this.open = bl;
    }

    public PGpath() {
        this.setType("path");
    }

    public PGpath(String string) throws SQLException {
        this();
        this.setValue(string);
    }

    public void setValue(String string) throws SQLException {
        if (string.startsWith("[") && string.endsWith("]")) {
            this.open = true;
            string = PGtokenizer.removeBox(string);
        } else if (string.startsWith("(") && string.endsWith(")")) {
            this.open = false;
            string = PGtokenizer.removePara(string);
        } else {
            throw new PSQLException("postgresql.geo.path");
        }
        PGtokenizer pGtokenizer = new PGtokenizer(string, ',');
        int n = pGtokenizer.getSize();
        this.points = new PGpoint[n];
        int n2 = 0;
        while (n2 < n) {
            this.points[n2] = new PGpoint(pGtokenizer.getToken(n2));
            ++n2;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof PGpath) {
            PGpath pGpath = (PGpath)object;
            if (pGpath.points.length != this.points.length) {
                return false;
            }
            if (pGpath.open != this.open) {
                return false;
            }
            int n = 0;
            while (n < this.points.length) {
                if (!this.points[n].equals(pGpath.points[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        PGpoint[] pGpointArray = new PGpoint[this.points.length];
        int n = 0;
        while (n < this.points.length) {
            pGpointArray[n] = (PGpoint)this.points[n].clone();
            ++n;
        }
        return new PGpath(pGpointArray, this.open);
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer(this.open ? "[" : "(");
        int n = 0;
        while (n < this.points.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.points[n].toString());
            ++n;
        }
        stringBuffer.append(this.open ? "]" : ")");
        return stringBuffer.toString();
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

