/*
 *   IPC package for CygWin32
 *
 *   Copyright (C) 1997 Philippe CHAPUY
 *   Copyright (C) 1998 Ludovic LANGE
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *   HISTORY:
 *   --------
 *
 *   13/05/1998 : Version 1.00 released
 *                First public release
 *                adress any comments to llange@capgemini.fr
 *
 */




/************************************************************************/
/*									*/
/************************************************************************/

#define EXTERN
#include "IpcNtExt.h"
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/strace.h>

char	verbose=1;

static void msg_init (CYGWIN32_IPCNT_MSGSTR *ShareAdr)
{
	int id, msg;

	for (id = 0; id < MSGMNI; id++)
	{
	 ShareAdr->msgque[id] = (struct msqid_ds *) IPC_UNUSED;
	 for (msg = 0; msg < MSGMAXMESS; msg++)
	 {
	  ShareAdr->msg[id].msg[msg].msg_spot =
	  	&(ShareAdr->msg[id].data[msg][0]) - (int) ShareAdr ;
	 }
	}
	ShareAdr->msgbytes = ShareAdr->msghdrs = ShareAdr->msg_seq =
	ShareAdr->used_queues = 0;

	return;
}

static void shm_init (CYGWIN32_IPCNT_SHMSTR *ShareAdr)
{
	int id, i;

	for (id = 0; id < SHMMNI; id++)
	{
	 ShareAdr->shm_segs[id] = (struct shmid_ds *) IPC_UNUSED;
	 for (i = 0; i < SHMMNI; i++)
	 {
	  ShareAdr->shm[id].attaches[i].pid = 0 ;
	  ShareAdr->shm[id].attaches[i].fd  = 0 ;
	  ShareAdr->shm[id].attaches[i].adr = 0 ;
	 }
	}
	ShareAdr->shm_rss = ShareAdr->shm_seq =
	ShareAdr->max_shmid = 0;
	return;
}

static void sem_init (CYGWIN32_IPCNT_SEMSTR *ShareAdr)
{
	int i;

	ShareAdr->used_sems = ShareAdr->used_semids =
	ShareAdr->max_semid = ShareAdr->sem_seq = 0;
	for (i = 0; i < SEMMNI; i++)
	{
		ShareAdr->state[i] = 0 ;
		ShareAdr->semary[i] = (struct semid_ds *) IPC_UNUSED;
	}
	return;
}

#ifdef _WIN32
#define printf(msg) \
	{						\
	    char LBuf[512];				\
	    char *CPR_STRG="IPC DAEMON %.02f";		\
	    if (verbose)				\
	    {						\
		    sprintf(LBuf,CPR_STRG,VERSION_NUM);	\
		    MessageBox(NULL,msg,LBuf,MB_OK);	\
	    }						\
	}
#endif

int main(int Argc, char **Argv)
{
 HANDLE LSemControl ;
 int LFdSem, LFdShm, LFdMsg ;
 CYGWIN32_IPCNT_SEMSTR *LAdrSem ;
 CYGWIN32_IPCNT_SHMSTR *LAdrShm ;
 CYGWIN32_IPCNT_MSGSTR *LAdrMsg ;

 HANDLE LHandle ;
 char LBuff[100] ;
 int id, Index ;
 struct semid_ds *sma ;
 long LPrevious ;
 int LComptShm = 0 ;
 int LRet ;
 
 if (Argc>1)
 {
 	for (id=1;id<Argc;id++)
 	{
 		if ( strcmp(Argv[id],"-q")==0 )
 		{
 			verbose=0;
 		}
 	}
 }
 
 
 LSemControl = OpenSemaphore(SEMAPHORE_ALL_ACCESS, FALSE, CYGWIN32_IPCNT_SEMCTL) ;

 if( LSemControl == NULL )
 {
  LSemControl = CreateSemaphore(NULL, 0, 1, CYGWIN32_IPCNT_SEMCTL) ;
  if( LSemControl == NULL )
  {
   printf( "Unable to create semaphore\n" ) ;
  }
  else
  {
   /*********************************************************************/
   /* Creation des semaphore de gestion des memoires partagees		*/
   /* Si il existe dans le systeme, On les vire				*/
   /*********************************************************************/
   GSemSem = OpenSemaphore(SEMAPHORE_ALL_ACCESS, FALSE, CYGWIN32_IPCNT_SEMSEM) ;
   if( GSemSem != NULL )
   {
    CloseHandle ( GSemSem ) ;
   }

   GSemSem = CreateSemaphore(NULL, 1, 1, CYGWIN32_IPCNT_SEMSEM) ;

   if( GSemSem == NULL )
   {
    printf( "Unable to create \"Sem\" semaphore\n" ) ;
    goto endko ;
   }

   GSemShm = OpenSemaphore(SEMAPHORE_ALL_ACCESS, FALSE, CYGWIN32_IPCNT_SEMSHM) ;
   if( GSemShm != NULL )
   {
    CloseHandle ( GSemShm ) ;
   }
   GSemShm = CreateSemaphore(NULL, 1, 1, CYGWIN32_IPCNT_SEMSHM) ;
   if( GSemSem == NULL )
   {
    printf( "Unable to create \"Shm\" semaphore\n" ) ;
    goto endko ;
   }
   GSemMsg = OpenSemaphore(SEMAPHORE_ALL_ACCESS, FALSE, CYGWIN32_IPCNT_SEMMSG) ;
   if( GSemMsg != NULL )
   {
    CloseHandle ( GSemMsg ) ;
   }
   GSemMsg = CreateSemaphore(NULL, 1, 1, CYGWIN32_IPCNT_SEMMSG) ; ;
   if( GSemSem == NULL )
   {
    printf( "Unable to create \"Msg\" semaphore\n" ) ;
    goto endko ;
   }

   /*********************************************************************/
   /* Creation des memoires partagees					*/
   /*********************************************************************/

   /*********************************************************************/
   /* On commence par le semaphore					*/
   /*********************************************************************/
   LFdSem = open(CYGWIN32_IPCNT_FILESEM, O_CREAT|O_TRUNC|O_WRONLY) ;
   GStrSem = (CYGWIN32_IPCNT_SEMSTR *) malloc (sizeof(CYGWIN32_IPCNT_SEMSTR)) ;
   memset (GStrSem, 0x00, sizeof(CYGWIN32_IPCNT_SEMSTR)) ;
   write(LFdSem, GStrSem, sizeof(CYGWIN32_IPCNT_SEMSTR)) ;
   free(GStrSem) ;
   close(LFdSem) ;

   LFdSem  = open(CYGWIN32_IPCNT_FILESEM, O_RDWR) ;
   LAdrSem = (CYGWIN32_IPCNT_SEMSTR *)
   		mmap(0, sizeof(CYGWIN32_IPCNT_SEMSTR), PROT_READ|PROT_WRITE,
		MAP_SHARED, LFdSem, 0) ;
   sem_init(LAdrSem) ;

   /*********************************************************************/
   /* On continue par la memoire partagee				*/
   /*********************************************************************/
   LFdShm = open(CYGWIN32_IPCNT_FILESHM, O_CREAT|O_TRUNC|O_WRONLY) ;
   GStrShm = (CYGWIN32_IPCNT_SHMSTR *) malloc (sizeof(CYGWIN32_IPCNT_SHMSTR)) ;
   memset (GStrShm, 0x00, sizeof(CYGWIN32_IPCNT_SHMSTR)) ;
   write(LFdShm, GStrShm, sizeof(CYGWIN32_IPCNT_SHMSTR)) ;
   free (GStrShm) ;
   close(LFdShm) ;

   LFdShm  = open(CYGWIN32_IPCNT_FILESHM, O_RDWR) ;
   LAdrShm = (CYGWIN32_IPCNT_SHMSTR *)
   		mmap(0, sizeof(CYGWIN32_IPCNT_SHMSTR), PROT_READ|PROT_WRITE,
		MAP_SHARED, LFdShm, 0) ;
   shm_init(LAdrShm) ;

   /*********************************************************************/
   /* On finit par les messages queues					*/
   /*********************************************************************/
   LFdMsg = open(CYGWIN32_IPCNT_FILEMSG, O_CREAT|O_TRUNC|O_WRONLY) ;
   GStrMsg = (CYGWIN32_IPCNT_MSGSTR *) malloc (sizeof(CYGWIN32_IPCNT_MSGSTR)) ;
   memset (GStrMsg, 0x00, sizeof(CYGWIN32_IPCNT_MSGSTR)) ;
   write(LFdMsg, GStrMsg, sizeof(CYGWIN32_IPCNT_MSGSTR)) ;
   free(GStrMsg) ;
   close(LFdMsg) ;

   LFdMsg  = open(CYGWIN32_IPCNT_FILEMSG, O_RDWR) ;
   LAdrMsg = (CYGWIN32_IPCNT_MSGSTR *)
   		mmap(0, sizeof(CYGWIN32_IPCNT_MSGSTR), PROT_READ|PROT_WRITE,
		MAP_SHARED, LFdMsg, 0) ;
   msg_init(LAdrMsg) ;

   printf( "IPC-deamon is now running...\n" ) ;

   /*********************************************************************/
   /* On boucle afin de recuperer les Handle des objets crees		*/
   /* par les fonctions IPC						*/
   /*********************************************************************/
   while(1)
   {
    usleep(300000) ;

    /********************************************************************/
    /* Semaphores							*/
    /********************************************************************/

    WaitForSingleObject(GSemSem, INFINITE) ;

    for (id = 0; id < SEMMNI; id++)
    {
     if (LAdrSem->semary[id] != IPC_UNUSED)
     {
      sma = (struct semid_ds *) ((char *) LAdrSem->semary[id] +
      						(int) LAdrSem) ;
      if (LAdrSem->state[id] == 1)
      {
       for (Index = 0; Index < sma->sem_nsems; Index++)
       {
        itoa(100*id+Index, LBuff) ;
        LHandle = OpenSemaphore(SEMAPHORE_ALL_ACCESS, FALSE, LBuff) ;
	while (LAdrSem->current_nb[id].current_nb[Index] > 0 )
	{
    	 WaitForSingleObject(LHandle, 0) ;
	 LAdrSem->current_nb[id].current_nb[Index]-- ;
	}
	CloseHandle(LHandle) ;
       }
       LAdrSem->semary[id] = IPC_UNUSED ;
       LAdrSem->state[id]  = 0 ;
      }
      else
      {
       for (Index = 0; Index < sma->sem_nsems; Index++)
       {
        itoa(100*id+Index, LBuff) ;
        LHandle = OpenSemaphore(SEMAPHORE_ALL_ACCESS, FALSE, LBuff) ;
       }
      }
     }
    }

    ReleaseSemaphore(GSemSem, (LONG) 1, &LPrevious) ;

    /********************************************************************/
    /* Memoires partagees						*/
    /* On vire les memoires partagees non referencees			*/
    /* de temps en temps, on vire les shm dont les pid n'existent plus	*/
    /********************************************************************/

      if( LComptShm == 10 )
      {
       LComptShm = 0 ;
       WaitForSingleObject(GSemShm, INFINITE) ;

       for (id = 0; id < SHMMNI; id++)
       {
	if( LAdrShm->shm_segs[id] != (struct shmid_ds *) IPC_UNUSED )
	{
	 for (Index=0; Index<SHMMNI; Index++)
	 {
	  if (LAdrShm->shm[id].attaches[Index].pid != 0)
	  {
	   LRet = kill(LAdrShm->shm[id].attaches[Index].pid, 0) ;
	   if( LRet == 0 )
	   {
	    break ;
	   }
	   else
	   {
	    munmap(LAdrShm->shm[id].attaches[Index].adr , LAdrShm->shm[id].shm_segsz ) ;
	    LAdrShm->shm[id].shm_nattch--;            /* for destruction */
	    close (LAdrShm->shm[id].attaches[Index].fd) ;
	    LAdrShm->shm[id].attaches[Index].pid = 0 ;
	    LAdrShm->shm[id].attaches[Index].adr = 0 ;
	    LAdrShm->shm[id].attaches[Index].fd  = 0 ;
	   }
	  }
	 }
	 /*
	 if( Index == SHMMNI )
	 {
	  LAdrShm->shm[id].shm_perm.seq++;

	  LAdrShm->shm_seq = (LAdrShm->shm_seq+1) % ((unsigned)(1<<31)/SHMMNI);
	  LAdrShm->shm_segs[id] = (struct shmid_ds *) IPC_UNUSED;
	 }
	 */
        }
      }

      ReleaseSemaphore(GSemShm, (LONG) 1, &LPrevious) ;
     }
     else
     {
      LComptShm++ ;
     }

   }
   /* Plus besoin
   WaitForSingleObject(LSemControl, INFINITE) ;
   */
  }
 }
 else
 {
  printf( "IPC-daemon is already started !!\n") ;
  exit(2);
 }

 goto end ;

endko: ;
 printf ("\n\nUnable to start IPC-daemon !\n") ;
 exit(1) ;

end: ;
 exit(0) ;
}

extern void mainCRTStartup();

void WinMainCRTStartup()
{
	mainCRTStartup();
}