
/* poner select color y select font dentro de este archivo. */


/*   xfdiff_misc.c */

/*  xfdiff (a gtk frontend for diff)
 *  Copyright (C)  Edscott Wilson Garcia under GNU GPL
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/



/******************** CB section ************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <tubo.h>
#include <glob.h>

#include "xfdiff.h"
#include "xfdiff_misc.h"

#include "xfdiff_dlg.h"


/*****************************************************/
/* private dialog functions: */

#define NOEXPAND FALSE
#define EXPAND TRUE
#define NOFILL FALSE
#define FILL TRUE

#define FILE_SELECTION 0
#define FONT_SELECTION 1
#define COLOR_SELECTION 2

extern void *tubo_object;
static gboolean xf_result;
static void
xf_button (GtkWidget * widget, gpointer data)
{
  int caso;
  caso = (int) ((long) data);
  if (caso)
    xf_result = TRUE;
  gtk_main_quit ();
  return;
}

static GtkWidget *
xf_selection (char *title, int caso, GdkColor *color)
{
  static GtkWidget *dialogo;
  GtkObject *ok_object = NULL, *ko_object = NULL;
  switch (caso)
  {
  case FONT_SELECTION:
    dialogo = gtk_font_selection_dialog_new (title);
    ok_object = GTK_OBJECT (GTK_FONT_SELECTION_DIALOG (dialogo)->ok_button);
    ko_object = GTK_OBJECT (GTK_FONT_SELECTION_DIALOG (dialogo)->cancel_button);

    gtk_font_selection_dialog_set_preview_text (GTK_FONT_SELECTION_DIALOG (dialogo), "Xfce is at http://www.xfce.org/");
    if (!gtk_font_selection_dialog_set_font_name (GTK_FONT_SELECTION_DIALOG (dialogo),(char *)color))
    {
      xf_dlg_warning (diff,_("Could not set selected font"));
    }
    break;
  case COLOR_SELECTION:
    dialogo = gtk_color_selection_dialog_new (title);
    ok_object = GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (dialogo)->ok_button);
    ko_object = GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (dialogo)->cancel_button);
    gtk_color_selection_set_current_color(GTK_COLOR_SELECTION (GTK_COLOR_SELECTION_DIALOG (dialogo)->colorsel),color);
    /*
    gtk_color_selection_set_color (GTK_COLOR_SELECTION (GTK_COLOR_SELECTION_DIALOG (dialogo)->colorsel), (gdouble *) aux);*/
    break;
  default:			/* FILE_SELECTION */
    dialogo = gtk_file_selection_new (title);
    ok_object = GTK_OBJECT (GTK_FILE_SELECTION (dialogo)->ok_button);
    ko_object = GTK_OBJECT (GTK_FILE_SELECTION (dialogo)->cancel_button);
    break;
  }
  g_signal_connect (G_OBJECT(ok_object), "clicked", G_CALLBACK (xf_button), (gpointer) ((long) 1));
  g_signal_connect (G_OBJECT(ko_object), "clicked", G_CALLBACK (xf_button), (gpointer) ((long) 0));

  gtk_window_set_position (GTK_WINDOW (dialogo), GTK_WIN_POS_CENTER);
  gtk_container_set_border_width (GTK_CONTAINER (dialogo), 5);
  gtk_window_set_modal (GTK_WINDOW (dialogo), TRUE);
  gtk_widget_realize (dialogo);


  gtk_widget_show (dialogo);
  return dialogo;
}


char *
xf_selector (char *title, int caso, GdkColor *color)
{
  static char *name = NULL;
  GtkWidget *widget;

  xf_result = FALSE;
  if (name)free (name);
  widget = xf_selection (title, caso, color);
  gtk_window_set_transient_for (GTK_WINDOW (widget), GTK_WINDOW (diff));
  gtk_main ();
  name = NULL;
  if (xf_result)
  {
    switch (caso)
    {
    case FONT_SELECTION:
      name = (char *) malloc (strlen (gtk_font_selection_dialog_get_font_name (GTK_FONT_SELECTION_DIALOG (widget))) + 1);
      strcpy (name, gtk_font_selection_dialog_get_font_name (GTK_FONT_SELECTION_DIALOG (widget)));
      printf ("out=%s\n", name);
      break;
    case COLOR_SELECTION:
      gtk_color_selection_get_current_color(GTK_COLOR_SELECTION (GTK_COLOR_SELECTION_DIALOG (widget)->colorsel),color);
      /*gtk_color_selection_get_color (GTK_COLOR_SELECTION (GTK_COLOR_SELECTION_DIALOG (widget)->colorsel), &selcolor);*/
      gtk_widget_destroy (widget);
      return "";
      break;
    default:			/* FILE_SELECTION */
      name = (char *) malloc (strlen (gtk_file_selection_get_filename (GTK_FILE_SELECTION (widget))) + 1);
      strcpy (name, gtk_file_selection_get_filename (GTK_FILE_SELECTION (widget)));
    }
  }
  gtk_widget_destroy (widget);
  return name;
}

/* public dialog functions: */
char *
xf_fontselect (char *title, char *aux)
{
  char *fuente;
  fuente=aux;
  while ((fuente[0]==' ') && (fuente[0]!=0)) fuente++;
printf("TRACE:in=%s\n",fuente);
  return xf_selector(title,FONT_SELECTION,(GdkColor *)fuente);
}

char *
xf_colorselect (char *title, GdkColor *color)
{
  return  (xf_selector (title, COLOR_SELECTION,  color));
}

char *
xf_fileselect (char *title)
{
  return xf_selector (title, FILE_SELECTION, NULL);
}


/*****************************************************/



char *
drawA_width (void)
{
  if ((rightC < 1000) && (leftC < 1000))
    return "88800888";
  if ((rightC < 10000) && (leftC < 10000))
    return "8888008888";
  if ((rightC < 100000) && (leftC < 100000))
    return "888880088888";
  return "88888800888888";
}

/* in order to support boxes where GLOB_NOMATCH is not
 * defined, all return error codes will be interpreted
 * as GLOB_NOMATCH */
/* in gnu-c, GLOB_NOMATCH is 3 */


/*static gboolean inverted=FALSE;*/

static int
go_figure_strip (void)
{
  patched_file *thisF;
  int i, j, *hits, Mstrip = 0, Mlength = 0, ch = 1;
  char *filename;
  glob_t pglob;
chance2:
  thisF = headF;
  while (thisF)
  {
    int j;
    if (thisF->file && thisF->newfile)
    {
      j = max_strip ((ch) ? thisF->file : thisF->newfile);
      if (strlen ((ch) ? thisF->file : thisF->newfile) > Mlength)
	Mlength = strlen ((ch) ? thisF->file : thisF->newfile);
      if (j > Mstrip)
	Mstrip = j;
    }
    else
    {
      /*printf("oops.\n"); */
    }
    thisF = thisF->next;
  }
  hits = (int *) malloc ((Mstrip + 1) * sizeof (int));
  if (!hits)
    xfdiff_abort (E_MALLOC);
  filename = (char *) malloc (Mlength + strlen (fileD) + 2);
  if (!filename)
    xfdiff_abort (E_MALLOC);
  for (i = 0; i <= Mstrip; i++)
  {
    *(hits + i) = 0;
    thisF = headF;
    while (thisF)
    {
      if (thisF->file && thisF->newfile)
      {
	sprintf (filename, "%s/%s", fileD, strip_it ((ch) ? thisF->file : thisF->newfile, i));
	if (glob (filename, GLOB_ERR, NULL, &pglob) == 0)
	  (*(hits + i))++;
	globfree (&pglob);
      }
      thisF = thisF->next;
    }
  }
  Mlength = j = 0;
  for (i = 0; i <= Mstrip; i++)
  {
    /*printf("strip=%d, hits=%d\n",i, *(hits+i)); */
    if (*(hits + i) <= Mlength)
      continue;
    Mlength = *(hits + i);
    j = i;
  }

  if (Mlength == 0)
    free (filename);
  free (hits);
  if ((ch) && (Mlength == 0))
  {				/* second chance */
    ch = 0;
    goto chance2;
  }
  return j;
}


void
xfdiff_abort (int why)
{
  gtk_widget_hide(diff); 
  if (tubo_object) TuboCancel(tubo_object, NULL, NULL);
  /* clean up: */
#ifdef AUTOSAVE
  cb_save_defaults (NULL, NULL);
#endif

  if (fileRR)
    remove (fileRR);
  if (fileO)
    remove (fileO);
  if (fileI)
    remove (fileI);
  gtk_main_quit ();
  exit (1);			/* should not get here */
}

void
finish (int sig)
{
  if (sig == SIGSEGV)
    xfdiff_abort (E_SEGV);
  xfdiff_abort (E_CLEANUP);
}

void
cleanF (void)
{
  patched_file *thisF;
  if (!headF) return;
  while (headF != NULL) {
    thisF = headF;
    headF = thisF->next;
    if (thisF->file) free (thisF->file);
    if (thisF->newfile) free (thisF->newfile);
    free (thisF);
  }
  headF = currentF = NULL;
  return;
}

polygon *
pushP (int *top, int *bottom, int *current_line)
{
  int d;
  polygon *tmp;
  if (!head)
  {
    head = (polygon *) malloc (sizeof (polygon));
    if (!head)
      xfdiff_abort (E_MALLOC);
    tmp = head;
    tmp->previous = NULL;
  }
  else
  {
    for (tmp=head; tmp->next; tmp=tmp->next);
    
    tmp->next = (polygon *) malloc (sizeof (polygon));
    if (!tmp->next) g_assert_not_reached();
    (tmp->next)->previous = tmp;
    tmp = tmp->next;
  }
  tmp->next = NULL;
  tmp->topR = top[1] * lineH;
  tmp->botR = bottom[1] * lineH;
  tmp->topL = top[0] * lineH;
  tmp->botL = bottom[0] * lineH;

  d=bottom[1]-top[1];
  tmp->topLR = current_line[1]-d+1;
  tmp->botLR = current_line[1];
 
  d=bottom[0]-top[0];
  tmp->topLL = current_line[0]-d+1;
  tmp->botLL = current_line[0];
  polygon_ids++;
  tmp->id=polygon_ids; 
  return tmp;
}

void
cleanP (void)
{
  polygon *thisP;
  polygon_ids=0;
  if (!head) return;
  
  while (head != NULL)
  {
    thisP = head;
    head = thisP->next;
    free (thisP);
  }
  current = NULL;
  
  return;
}

void
cleanA (void)
{
  GdkRectangle update_rect;
  if (!drawA)
    return;
  if (!drawP)
    return;

  update_rect.x = 0;
  update_rect.y = GTK_ADJUSTMENT (adj)->value;
  update_rect.width = drawA->allocation.width;
  update_rect.height = drawA->allocation.height;

  gdk_draw_rectangle (drawP, drawA->style->bg_gc[GTK_WIDGET_STATE (drawA)], TRUE, 0, 0, drawA->allocation.width, 3 * drawA->allocation.height);
  gtk_widget_queue_draw_area (drawA, update_rect.x, update_rect.y, update_rect.width, update_rect.height);
  gdk_draw_drawable (drawA->window, drawA->style->bg_gc[GTK_WIDGET_STATE (drawA)], drawP, 0, 0, 0, 0, drawA->allocation.width, drawA->allocation.height);
}

void
cleanT (void)
{
  clear_text_buffer (text_buffer[0]);
  clear_text_buffer (text_buffer[1]);
}

int
max_strip (char *file)
{
  int max_s = 0;
  char *place = NULL;
  if (!file)
    return max_s;
  /*printf("figuring striplevel:%s\n",file); */
  place = strstr (file, "/");
  if (place)
  {
    max_s++;
    place++;
    while (place)
    {
      /*printf("figuring striplevel %d:%s\n",max_s,place); */
      place = strstr (place, "/");
      if (place)
      {
	max_s++;
	place++;
      }
    }
  }
  return max_s;
}

char *
strip_it (char *file, int strip_level)
{
  int i;
  char *strip_file, *strip_try;
  strip_file = file;
  if (!strip_level) { goto strip_error;}
  strip_try = strstr (file, "/");
  if (!strip_try)
  {
  strip_error:			/* on strip exceeding maximum strip, strip all slashes */
    return strip_file;
  }
  strip_file = ++strip_try;
  for (i = 1; i < strip_level; i++)
  {
    strip_try = strstr (strip_file, "/");
    if (!strip_try)
      goto strip_error;
    strip_file = ++strip_try;
  }
  return strip_file;
}

/* find at least one file to patch */
int
check_patch_dir (void)
{
  patched_file *thisF;
  int i = 0, fileH;
  static char *file = NULL;
  char *strip_file;

  if (autostrip)
  {
    gchar *g;
    strip = go_figure_strip ();    
    
    g=g_strdup_printf(_("Strip level now set to %d (-p%d)"), strip, strip);
    show_diag (g);
    g_free(g);
    show_diag ("\n");
    /*printf("using strip level=%d\n",strip); */
  }


  good_dir = 0;
  thisF = headF;
  while (thisF)
  {
    strip_file = strip_it (thisF->file, strip);
  other:i++;
    if (!strip_file)
      break;
    if (file)
      free (file);
    file = (char *) malloc (strlen (fileD) + strlen (strip_file) + 2);
    if (!file)
      xfdiff_abort (E_MALLOC);
    sprintf (file, "%s/%s", fileD, strip_file);
    fileH = open (file, O_RDONLY);
    if (fileH != -1)
    {
      close (fileH);
      good_dir = 1;
      break;
    }
    if (i % 2)
    {
      strip_file = strip_it (thisF->newfile, strip);
      goto other;
    }
    thisF = thisF->next;
  }
  if (good_dir)
    return TRUE;
  {
    char *no_good_dir;
    no_good_dir = _("No file was found for patching\nEither the directory to apply patch is not correctly selected\nor an incorrect strip level was used.\n");
    xf_dlg_warning (diff,no_good_dir);
    show_diag (no_good_dir);
  }
  return FALSE;

}


int
check_reject (void)
{
  FILE *failed = NULL;
  failed = fopen (fileRR, "r");
  if (failed)
  {
    fclose (failed);
    xf_dlg_warning(diff,(_("Patch command has produced reject output.\nSee diagnostics window.")));
    return TRUE;
  }
  return FALSE;
}

int
checkdir (char *file)
{
  struct stat st;
  stat (file, &st);
  if (st.st_mode & S_IFDIR) 
  {
    return TRUE;
  }
  return FALSE;
}

int
checknotdir (char *file)
{
  struct stat st;
  stat (file, &st);
  if (st.st_mode & S_IFDIR);
  else
  {
    xf_dlg_warning(diff,(_("No directory was selected!")));
    return TRUE;
  }
  return FALSE;
}


char *
get_the_file (char *file)
{
  char *fileS;
  /*  */
  /*  */
  fileS = xf_fileselect (_("Directory or file selection"));
  if (fileS)
  {
    if ((file) && (strcmp (file, fileS) == 0))
      return file;
    /* ok, the file selection has changed */
    file = assign (file, fileS);
  }
  return file;
}

char *
assign (char *dst, char *src)
{
  if (dst) free (dst);
  if (!src) {
    dst = NULL;
    return NULL;
  }
  dst = (char *) malloc (strlen (src) + 1);
  if (!dst) xfdiff_abort (E_MALLOC);
  strcpy (dst, src);
  return dst;
}

char *
prompt_path (char *message, char *file)
{
  char *texto;
  texto = (char *) malloc (strlen (message) + strlen (_("Please select it in the next dialog.")) + 3);
  if (!texto)
    xfdiff_abort (E_MALLOC);
  sprintf (texto, "%s\n%s", message, _("Please select it in the next dialog."));
  /*  */
  if (xf_dlg_ask (diff,texto)==DLG_RC_CANCEL)
    return NULL;

  file = get_the_file (file);
  if (!file)
  {
    sprintf (texto, "%s", message);
    xf_dlg_warning(diff,texto);
    free (texto);
    return NULL;
  }
  free (texto);
  return file;
}

char *
prompt_outfile (char *message, char *file)
{
  if (xf_dlg_ask (diff,message)==DLG_RC_CANCEL)
    return NULL;
  file = get_the_file (file);

  if (file)
  {
    FILE *fileX = NULL;
    if ((fileX = fopen (file, "r")) != NULL)
    {
      fclose (fileX);
      if (xf_dlg_ask(diff,_("File exists, overwrite?"))==DLG_RC_OK)
      {
	if ((fileX = fopen (file, "w")) == NULL)
	{
	  xf_dlg_warning(diff,(_("Cannot open file for write\n")));
	  goto outfile_error;
	}
	else
	  fclose (fileX);
      }
      else
	goto outfile_error;
    }
  }
  else
    goto outfile_error;
  return file;
outfile_error:
  if (file)
    free (file);
  return NULL;
}


int
first_diff (void)
{
  int value;
  if (head == NULL)
    value = 0;
  else
  {
    value = (head->topR < head->topL) ? head->topR : head->topL;
    if (value >= lineH)
      value -= lineH;
    else
      value = 0;
  }
  gtk_adjustment_set_value (GTK_ADJUSTMENT (adj), value);
  configure_event (drawA, NULL);
  cb_adjust ((GtkAdjustment *) adj, NULL);
  if (head)
    return TRUE;
  else
    return FALSE;
}

void
get_defaults (void)
{
  FILE *defaults;
  gchar *rcfile=get_rcfile();

  defaults = fopen (rcfile, "r");
  g_free(rcfile);

  filledP = TRUE;
  show_lineN = TRUE;
  synchronize = FALSE;

#ifdef GN_PATCH
  verbose = 0;
#endif

  if (!defaults)
  {
    colorfg.red = 0xffff;
    colorfg.green = 0xffff;
    colorfg.blue = 0;
    colorbg.red = 0xffff;
    colorbg.green = 0;
    colorbg.blue = 0;
    silent = 0;
  }
  else
  {
    char line[256], *word, *value;
    while ((!feof (defaults)) && (fgets (line, 255, defaults)))
    {
      line[255] = 0;
      if (line[0] == '#')
	continue;
      word = strtok (line, ":");
      value = word + strlen (word) + 1;
      /*printf("word=%s value=%s\n",word,value); */

      if (!word)
	continue;
      if (strstr (word, "colorfg.red"))
	colorfg.red = atoi (value);
      if (strstr (word, "colorfg.green"))
	colorfg.green = atoi (value);
      if (strstr (word, "colorfg.blue"))
	colorfg.blue = atoi (value);
      if (strstr (word, "colorbg.red"))
	colorbg.red = atoi (value);
      if (strstr (word, "colorbg.green"))
	colorbg.green = atoi (value);
      if (strstr (word, "colorbg.blue"))
	colorbg.blue = atoi (value);
      /*if (strstr(word,"silent"))  silent  = atoi(value); */
      if (strstr (word, "filledP"))
	filledP = atoi (value);
      if (strstr (word, "show_lineN"))
	show_lineN = atoi (value);
      if (strstr (word, "synchronize"))
	synchronize = atoi (value);
#ifdef GN_PATCH
      if (strstr (word, "verbose"))
	verbose = atoi (value);
#endif
    }
    fclose(defaults);
  }

}


/* set colors in GC to be used for drawing polygons */
void
set_highlight (void)
{
  static GdkColormap *cmap=NULL;
  GtkTextTag *tag;
  static gboolean first=TRUE;
  static GdkVisual *visual=NULL; 
  GdkColor black;

 /* else {
      g_object_unref((gpointer)cmap);
      g_object_unref((gpointer)drawGC);
      g_object_unref((gpointer)fileGC);
  }*/

  if (!visual) {
	 visual = (GdkVisual *)g_object_ref((gpointer)gdk_visual_get_best());	 
  }
  black.red=black.green=black.blue=0;
  
  if (first) 
  {
    first=FALSE;
    cmap = (GdkColormap *)g_object_ref((gpointer)gdk_colormap_new (visual,TRUE));
    if (!gdk_colormap_alloc_color(cmap,&black,TRUE,TRUE)) g_error (_("couldn't allocate color"));
    if (!gdk_colormap_alloc_color(cmap,&colorfg,TRUE,TRUE)) g_error (_("couldn't allocate color"));
    if (!gdk_colormap_alloc_color(cmap,&colorbg,TRUE,TRUE)) g_error (_("couldn't allocate color"));
    drawGC = g_object_ref((gpointer)gdk_gc_new (drawA->window));
    fileGC = g_object_ref(gdk_gc_new (drawA->window));  
    gdk_gc_set_colormap (drawGC,cmap);
    gdk_gc_set_colormap (fileGC,cmap);
    gdk_gc_set_foreground (drawGC, &colorbg);	/* bg is actually fg for draw */
    gdk_gc_set_foreground (fileGC, &black);	
    gdk_gc_set_background (fileGC, &colorbg);	
  } else { /*FIXME: use X11 to do a simple colormap change */
    g_object_unref((gpointer)cmap);
    g_object_unref((gpointer)drawGC);
    g_object_unref((gpointer)fileGC);
    cmap = (GdkColormap *)g_object_ref((gpointer)gdk_colormap_new (visual,TRUE));
    if (!gdk_colormap_alloc_color(cmap,&black,TRUE,TRUE)) g_error (_("couldn't allocate color"));
    if (!gdk_colormap_alloc_color(cmap,&colorfg,TRUE,TRUE))  g_error (_("couldn't allocate color"));
    if (!gdk_colormap_alloc_color(cmap,&colorbg,TRUE,TRUE))  g_error (_("couldn't allocate color"));
    drawGC = g_object_ref((gpointer)gdk_gc_new (drawA->window));
    fileGC = g_object_ref(gdk_gc_new (drawA->window));  
    gdk_gc_set_colormap (drawGC,cmap);
    gdk_gc_set_colormap (fileGC,cmap);
    gdk_gc_set_foreground (drawGC, &colorbg);	/* bg is actually fg for draw */
    gdk_gc_set_foreground (fileGC, &black);	
    gdk_gc_set_background (fileGC, &colorbg);
    configure_event (drawA, NULL);
  } 
  
  tag=gtk_text_tag_table_lookup(gtk_text_buffer_get_tag_table(text_buffer[1]),"bg_red");
  if (tag)  g_object_set (G_OBJECT (tag),
                "background_gdk", &colorbg,
                "foreground_gdk", &colorfg,
                NULL);
  tag=gtk_text_tag_table_lookup(gtk_text_buffer_get_tag_table(text_buffer[0]),"bg_red");
  if (tag)  g_object_set (G_OBJECT (tag),
                "background_gdk", &colorbg,
                "foreground_gdk", &colorfg,
                NULL);
 
  
}




static GList *items = NULL;
void
update_titlesP (void)
{
  char *texto;
  patched_file *thisF;
  thisF = currentF;
  if (patching)
  {
    if (what_dir)
    {
      clear_text_buffer (what_dir);
      if (!fileP)
      {
	utf8_insert_tag (what_dir, _(no_patch), "bg_red");
      }
      else
      {
	utf8_insert_tag  (what_dir, _("Patch: "),"bg_bluewhite");
	utf8_file_insert (what_dir,fileP);
      }
      if (!fileD)
      {
	utf8_insert_tag (what_dir, _(no_patch_dir), "bg_red");
      }
      else
      {
        utf8_insert_tag (what_dir, _(" applied at: "), "bg_bluewhite");
	utf8_file_insert (what_dir, fileD);
	utf8_insert (what_dir, "\n");
      }
    }

    if (!fileP)
      texto = no_patch;
    else
    {
      if (!fileD)
	texto = no_patch_dir;
      else
	texto = (N_("Press OK to see patch diffs"));
    }
  }
  else
  {				/* !patching */
    if (!filename[1])
      texto = no_right_path;
    else
      texto = filename[1];
  }
  if (thisF)
    texto = thisF->newfile;

  if (titleP)
  {
    clear_text_buffer (titleP);
    utf8_file_insert (titleP, _(texto));
    utf8_insert (what_dir, "\n");
  }

  if (items != NULL)
  {
    g_list_free (items);
    items = NULL;
  }
  if (thisF)
  {
    while (thisF)
    {
      items = g_list_append (items, thisF->file);
      thisF = thisF->next;
    }
    thisF = headF;
    while (thisF != currentF)
    {
      items = g_list_append (items, thisF->file);
      thisF = thisF->next;
    }
    if (titleD)
      gtk_combo_set_popdown_strings (GTK_COMBO (titleD), items);
  }
  else
  {
    if (!patching)
    {
      if (filename[0])
	texto = filename[0];
      else
	texto = no_left_path;
    }
    items = g_list_append (items, _(texto));
    if (titleP)
      gtk_combo_set_popdown_strings (GTK_COMBO (titleD), items);
  }
}
