
/* TreeSize for Unix  http://treesize.sf.net/
 * Copyright (c) 2006-2007 Marcos Diez <marcos_AT_unitron.com.br>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "ui-util.h"
#include "FAfolderAnalyzer.h"
extern  GtkWidget *mainWindow;

gpointer getTVSelectedValue( int element ){

  GtkTreeIter iter;
  gpointer *answear;

  GtkTreeView *treeView   = (GtkTreeView  *)  lookup_widget( mainWindow , "TVtreeView" );
  GtkTreeStore *treeStore = (GtkTreeStore *)  gtk_tree_view_get_model( treeView );
  
  gboolean selectionExists = gtk_tree_selection_get_selected ( gtk_tree_view_get_selection (treeView), NULL, &iter);
  if( !selectionExists ) return (gpointer ) selectionExists;
  gtk_tree_model_get ( (GtkTreeModel *) treeStore , &iter, element, &answear, -1);

  return answear;
}

			 
void statusBar_write( char *msg ){
  
  gchar *gmsg = g_filename_display_name( msg );
  GtkStatusbar *statusBar = (GtkStatusbar *) lookup_widget( (GtkWidget *) mainWindow , "statusbar1" );

  gtk_statusbar_pop (  statusBar , 1);
  gtk_statusbar_push ( statusBar , 1, gmsg );

  g_free( gmsg );

}

void runCommand( char *command , char *folderName ){
  char cmdline[ MAX_FOLDER_NAME + 20 ];
  snprintf( cmdline , MAX_FOLDER_NAME + 19 ,
	    "%s \"%s\" &" ,
	    command , folderName );
  system( cmdline );
}

void openXterm( char *folderName );
