
/* TreeSize for Unix  http://treesize.sf.net/
 * Copyright (c) 2006-2007 Marcos Diez <marcos_AT_unitron.com.br>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _LLLINKEDLIST_H_
#define _LLLINKEDLIST_H_

#include <stdlib.h>

#define LL_INITIAL_ELEMENTS 10

typedef struct {
  void **data;
  int elements;
  int maxElements;
} *list;


list LLnewList();
#define LLlistSize(  theList )   theList->elements
#define LLlist2Array( theList )   ( (void *) theList->data )
#define LLdelList( theList )  { LLschrinkList(theList); free( theList ); }
#define LLpurgeList( theList )  { free( theList->data ) ; free( theList ); }
void LLaddElement( list theList , void *element );
void LLschrinkList( list theList );
void LLdelWholeList( list theList , void (*eraser)(void *element ) );
void LLcopyAllElements( const list source , list destiny );
/* void LLdelElement( list L , element E ); */  /* not implemented */




#endif
