
/* TreeSize for Unix  http://treesize.sf.net/
 * Copyright (c) 2006-2007 Marcos Diez <marcos_AT_unitron.com.br>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BINARY_TREE_H
#define BINARY_TREE_H

#define BT_NO_NODE                 0

#define BT_REALLOCATE_KEY          1
#define BT_DONT_REALLOCATE_KEY     0

#define BT_KEY_ADDED_SUCESSFUL     1
#define BT_KEY_ALREADY_EXISTS      0
#define BT_KEY_DOESNT_EXIST          -1

#include "bigFiles.h"
typedef fileSizeUnit    BTkey;
typedef struct strNode *node;
typedef struct strTree *BTree;


struct strTree{
  node treeRoot;
  BTkey (*BTkeyDup)( const BTkey sourceKey );
  int   (*BTkeyCmp)( const BTkey key1 , const BTkey key2 );
  void  (*BTfreeKey)( BTkey key );
  void  (*BTfreeData)( void *data );
};

BTree BTnewTree( BTkey BTkeyDup( const BTkey sourceKey ) ,
		 int   BTkeyCmp( const BTkey key1 , const BTkey key2 ) ,
		 void  BTfreeKey( BTkey key ) ,
		 void  BTfreeData( void *data ) );


int BTtreeAdder( BTkey key , void *data , node *myRoot , node left , node right , const int realocateKey , BTree myTree );
void BTdel( BTree myTree , const BTkey key );
void *BTget( BTree myTree , const BTkey key );

#define BTadd( theTree , key  ,  data  )   BTtreeAdder( key , (void *) data , &(theTree->treeRoot) , (struct strNode *) BT_NO_NODE , (struct strNode *) BT_NO_NODE , BT_DONT_REALLOCATE_KEY , theTree  )

void  BTdelTree( BTree theTree );  /* erase the tree and all of its branches  */
void  BTwipeTree( BTree theTree ); /* erase the tree, its branches and call treeDataFree and treeKeyFree for all branches  */




#endif 


/* 
   this is a normal binary tree 
   first you have to choose 
   - the treeCMP function
   - the treeKeyDup function
   - the KeyFree function
   - the treeDataFree function
   - the key data type

   in the above example, all of them are char *


   you init it with treeInit();
   you add a key with treeAdd()
   you get a tree with treeGet()
   you erase a key with treeDel()

   simple !

*/
