#!/bin/bash
set -ex
NEW_FONTNAME=Takao
NEW_VERSION=003.01.20100214.1
ADD_COPYRIGHT="Copyright (c) Takao Fonts Maintainers Team, 2010."
URL="https://launchpad.net/takao-fonts"
for in_otf; do
    out_otf=$(echo -n "$in_otf" | sed -e 's/ipa/'"$NEW_FONTNAME"'/' \
                                      -e 's/g\./Gothic\./' -e 's/gp\./PGothic\./' \
                                      -e 's/m\./Mincho\./' -e 's/mp\./PMincho\./')
    tmp_ttx=$(echo -n "$in_otf" | sed -e 's/\..*$/.ttx/')
    new_ttx=$(echo -n "$out_otf" | sed -e 's/\..*$/.ttx/')
    tmp_ttf=$(echo -n "$new_ttx" | sed -e 's/\..*$/.ttf/')
    rm -fv "$tmp_ttf" "$tmp_ttx"
    ttx -t hmtx -t head -t name -t post "$in_otf"
    cp $tmp_ttx $new_ttx
    LANG=C perl -pi -e "
      s/width=\"1000\"/width=\"500\"/ if /name=\"\.notdef\"/; # hmtx
      s/\s*<namerecord nameID=\"13\" platformID=\"([0-9]+)\" platEncID=\"([0-9]+)\" langID=\"0x([0-9a-f]+)\">/    <namerecord nameID=\"11\" platformID=\"\$1\" platEncID=\"\$2\" langID=\"0x\$3\">
      $(echo -n $URL|sed -e 's/\//\\\//g')
    <\/namerecord>\n$&/g; # name
      s/Copyright.*/$&&#10;${ADD_COPYRIGHT}/; # name
      s/\bIPA(?![()])/${NEW_FONTNAME}/; # name
      s/Version 003\.01/Version $(echo -n $NEW_VERSION|sed -e 's/\./\\./g')/; # name
      s/value=\"1\"/value=\"0\"/ if /<isFixedPitch/; # post
      s/value=\"-[0-9]+\"/value=\"-20\"/ if /<underlinePosition/; # post (see meguri-fonts-20090604/README)
    " "$new_ttx"
    ttx -m "$in_otf" "$new_ttx"
    #rm -fv "$tmp_ttx" "$new_ttx"
    mv "$tmp_ttf" "$out_otf"
done
