/* ============================================================
 * File  : rttp.c
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2005-09-01
 * Description : check rtsp
 *
 * Copyright 2005 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <stdio.h>
#include <sys/types.h>

// rtsp
struct proto_rtsp
{
  char payload[5];
} __attribute__ ((packed));

      
struct streamurl *check_rtsp(char *ptr, unsigned int size, int headerindex)
{
    static struct streamurl m_url;
    struct proto_rtsp *prot_rtsp;       
    struct streamurl *url;
    //char *curchar;
        
    struct http_parameters *http_par;
    
    url = &m_url;
    url->type = none;
    
    url->prot[0] = 0;
    url->host[0] = 0;
    url->path[0] = 0;
    url->plst[0] = 0;
    
    if ( size < sizeof(struct proto_rtsp) ) 
      return url;

    prot_rtsp = (struct proto_rtsp*)(ptr);
            
    // check for rtsp PLAY command
    if ( strncmp(prot_rtsp->payload, "PLAY ", 5) == 0 )
    {
       http_par = splitHttp(prot_rtsp->payload, headerindex);
       
       if (http_par->command[0] != 0)
       {
          url->type = rtsp;
          strcpy(url->path, http_par->path);
          
          if ( (http_par = url_traceback(headerindex, url->path)) && http_par && 
               http_par->command[0] != 0 )
            sprintf(url->plst, "http://%s%s", http_par->host, http_par->path); // what? http ??
       }
    }
    
    return url;
} 


