/* ============================================================
 * File  : mms.c
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2005-09-01
 * Description : check mms
 *
 * Copyright 2005 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <stdio.h>
#include <sys/types.h>

       
//mms
struct proto_mms
{
   long sep1;
   long commsig;
   long sep2;
   char proto[4];
   char sep3[20];
   short command;
   short direction;  // 0x03 to server, 0x04 to client
   char sep4[16];
   char payload[0]; 
} __attribute__ ((packed));
    
struct streamurl *check_mms(char *ptr, unsigned int size, int headerindex, struct connection *conn)
{
    static struct streamurl m_url;
    
    // hack to keep host from command 0x01 packet in static var
    // todo: use general (not http only) packet buffer and do backtrace.
    static char host[200];
    static struct connection hostconn;
    
    struct proto_mms *prot_mms;       
    struct streamurl *url;
    char *curchar;
    
    struct http_parameters *http_par;
    
    url = &m_url;
    url->type = none;
    
    url->prot[0] = 0;
    url->host[0] = 0;
    url->path[0] = 0;
    url->plst[0] = 0;
    
    if ( size < sizeof(struct proto_mms) ) 
      return url;

    prot_mms = (struct proto_mms*)(ptr);
            
    // mms get host
    if ( prot_mms->commsig == 0xb00bface && strcmp(prot_mms->proto,"MMS ") &&
         prot_mms->command == 0x01 && prot_mms->direction == 0x03 )
    {
        convert16(prot_mms->payload, size - 56);
        
        if ( (curchar = strstr(prot_mms->payload, "Host: ")) )
        {
            curchar = curchar + 6;
            
            if (strlen(curchar) > 199)
              host[0] = 0;
            else
            {
              sprintf(host, "%s", curchar); 
              strcpy(hostconn.saddr, conn->saddr);
              hostconn.sport = conn->sport;              
            }
            //printf("host: %s\n", host);
        }        
    } 
        // mms get file
    else if ( prot_mms->commsig == 0xb00bface && strcmp(prot_mms->proto,"MMS ") &&
              prot_mms->command == 0x05 && prot_mms->direction == 0x03 )
    {
        url->type = mms; 
        strcpy(url->prot, "mms://");
        convert16(prot_mms->payload, size - 56);
        strcpy(url->path, prot_mms->payload);
        if ( host[0] == 0 || conn->sport != hostconn.sport || strcmp(conn->saddr, hostconn.saddr) != 0 )
           sprintf(url->host, "%s/", conn->daddr);
        else 
           sprintf(url->host, "%s/", host);
           
        // frut die url dan maar even in plst, we hebben haast...
        sprintf(url->plst, "%s%s%s", url->prot, url->host, url->path);
        if ( (http_par = url_traceback(headerindex, url->plst)) && http_par && http_par->command[0] != 0 )
           sprintf(url->plst, "http://%s%s", http_par->host, http_par->path);
        else url->plst[0] = 0;

    }
    return url;
} 
