/* ============================================================
* File  : icy.c
* Author: Eric Giesselbach <ericgies@kabelfoon.nl>
* Date  : 2005-09-01
* Description : check icy
*
* Copyright 2005 by Eric Giesselbach

* This program is free software; you can redistribute it
* and/or modify it under the terms of the GNU General
* Public License as published bythe Free Software Foundation;
* either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* ============================================================ */

#include <stdio.h>
#include <sys/types.h>

// icy
struct proto_icy
{
	char payload[10];
} __attribute__ ((packed));



int icy_traceback(int header, struct connection *conn, struct streamurl *url)
{
	//char *curchar;
	struct http_parameters *http_par;
		
	// trace back to the request that triggered the server a ICY 200 OK
	http_par = request_traceback(header, conn);
	
	if (http_par && http_par->command[0] != 0)
	{
		strcpy(url->prot, "http://");
		strcpy(url->host, http_par->host);
		strcpy(url->path, http_par->path);
		
		return http_par->index;
	}
		else
		return -1;
}


struct streamurl *check_icy(char *ptr, unsigned int size, int headerindex, struct connection *conn)
{
	static struct streamurl m_url;
	struct proto_icy *prot_icy;
	struct streamurl *url;
	//char *curchar;
		
	struct http_parameters *http_par;
	
	url = &m_url;
	url->type = none;
	
	url->prot[0] = 0;
	url->host[0] = 0;
	url->path[0] = 0;
	url->plst[0] = 0;
	
	if ( size < sizeof(struct proto_icy) )
		return url;

	prot_icy = (struct proto_icy*)(ptr);
				
	// check for ICY 200 OK from server
	if ( strncmp(prot_icy->payload, "ICY 200 OK", 10) == 0 )
	{
		headerindex = icy_traceback(headerindex, conn, url);
		
		if (url->path[0] != 0)
		{
			url->type = icy;
			
			// frut die url dan maar even in plst, we hebben haast...
			sprintf(url->plst, "%s%s%s", url->prot, url->host, url->path);
			if ( (http_par = url_traceback(headerindex, url->plst)) &&
					http_par &&
					http_par->command[0] != 0                        &&
					http_par->index != headerindex ) // trace looped to own request
				sprintf(url->plst, "http://%s%s", http_par->host, http_par->path);
			else
				url->plst[0] = 0;
		}

	}
	return url;
} 
