/* ============================================================
* File  : http.c
* Author: Eric Giesselbach <ericgies@kabelfoon.nl>
* Date  : 2008-05-12
* Description : check http streaming
*
* Copyright 2005-2008 by Eric Giesselbach

* This program is free software; you can redistribute it
* and/or modify it under the terms of the GNU General
* Public License as published bythe Free Software Foundation;
* either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* ============================================================ */

#include <stdio.h>
#include <sys/types.h>

/*
	TODO: research mime type usage
*/

const uint dump_http = 0; // set to 1 to dump all http gets

// http
struct proto_http_stream
{
char payload[17];
} __attribute__ ((packed));

		

struct streamurl *check_http(char *ptr, unsigned int size, int headerindex, struct connection *conn)
{
	static struct streamurl m_url;
	struct proto_http_stream *prot_http_stream;
	struct streamurl *url;
	char *curchar;
		
	struct http_parameters *http_par;
	
	url = &m_url;
	url->type = none;
	
	url->prot[0] = 0;
	url->host[0] = 0;
	url->path[0] = 0;
	url->plst[0] = 0;
	
	if ( size < sizeof(struct proto_http_stream) )
		return url;

	prot_http_stream = (struct proto_http_stream*)(ptr);
	
	// check for HTTP/x.x 200 OK with specific Content-Type
	curchar = prot_http_stream->payload + 9;
	if ( strncmp(prot_http_stream->payload, "HTTP/", 5)     == 0 &&
			strncmp(curchar, "200 OK", 6) == 0   )
	{
		// check for media content types
		http_par = findHttp(prot_http_stream->payload, headerindex, "\r\nContent-Type: ");
		int res = findPayload(prot_http_stream->payload, "\r\n\r\nFLV");
		
		if (    http_par->host[0] != 0 &&
					(
					strncmp(http_par->host, "audio", 5) == 0
					|| strncmp(http_par->host, "video", 5) == 0
					|| strstr (http_par->host, "wms-hdr")
					|| strstr (http_par->host, "x-flv") // Michel Verbraak
					|| strstr (http_par->host, "x-shockwave-flash")
					|| dump_http == 1
					//|| strstr (http_par->host, "ms-asf")
					)
					|| (res == 1)
			)
		{
			// traceback to request that got the 200 OK
			http_par = request_traceback(headerindex, conn);
			{
				if ( http_par && http_par->command[0] != 0  &&
						check_http_duplicate(http_par->index) == 0 )
				{
					//printf("traceback valid, got %s\n\n", http_par->path);
					curchar = strrchr(http_par->path, '.');
					if (curchar) curchar++;
					
					if ( ! (curchar && strstr("ram asx", curchar) != 0 ) )  // not a stream metafile
					{
						url->type = http;
						strcpy(url->prot, "http://");
						strcpy(url->host, http_par->host);
						strcpy(url->path, http_par->path);
					}
				}
			}
		}

		
	}
	
	return url;
} 


