
#include <stdio.h>
#include <sys/types.h>
#include "memmem.c"  //included for WIN32

#define BUFLEN 1600
	
void convert16(char *str, int len)
{
	int i = 0;
	while (2*i < len)
	{
	str[i] = str[2*i];
	i++;
	}
	str[i] = 0;
}

enum url_type
{
	none = 0,
	http,
	rtsp,
	mms,
	icy
};

// typedef char *namelist;
char * names[5] = {"NONE", "HTTP", "RTSP", "MMS ", "ICY "};

struct streamurl
{
	enum url_type type;
	char prot[10];
	char host[200];
	char path[200];
	char plst[250];
};

struct connection
{
char saddr[16];
char daddr[16];
unsigned short dport;
unsigned short sport;
};

struct http_header
{
	struct connection conn;
	time_t timestamp;
	unsigned int headerlen;
	char header[1550];  // BUFLEN - 52
} 
	headers[100];


struct http_parameters
{
int index;
char command[50];
char path[900];
char host[200];
char param[200];
char param2[200];
};

// fix for x86_64 systems: override system inet_ntoa
char * inet_ntoa(struct in_addr ina)
{
	static char buf[4*sizeof "123"];
	unsigned char *ucp = (unsigned char *)&ina;

	sprintf(buf, "%d.%d.%d.%d",
		ucp[0] & 0xff,
		ucp[1] & 0xff,
		ucp[2] & 0xff,
		ucp[3] & 0xff);
	return buf;
}


// split http like header
// command[0] != 0 : found " "
// host[0]    != 0 : found "\r\nHost: ....... \r\n"
struct http_parameters *splitHttp(char *header, int headerindex)
{
	static struct http_parameters my_parms;
	struct http_parameters *parms = &my_parms;
	char   *c_start, *c_stop;

	parms->command[0] = 0;
	parms->host[0]    = 0;
	parms->index      = headerindex;
		
	if ( (c_stop = strstr(header, " ")) )
	{
		strncpy(parms->command, header, c_stop - header);
		c_start = c_stop + 1;
		parms->command[c_stop - header] = 0;
		
		if ( (c_stop = strstr(c_start, " ")) )
		{
		strncpy(parms->path, c_start, c_stop - c_start);
		parms->path[c_stop - c_start] = 0;
	
	// TODO: I vaguely remember a HTTP RFC babbling about something being insensitive...
		if ( (c_start = strstr(c_stop, "\r\nHost: ")) )
		{
			c_start += 8;
			if ( (c_stop = strstr(c_start, "\r")) )
			{
				// come on, abuse host for this?
				strncpy(parms->host, c_start, c_stop - c_start);
				parms->host[c_stop - c_start] = 0;
			}
		}
		}
	}
	
	return parms;
}


// split http like header, find name-value (\r\nHost: , \r\nContent-type: , ...)
// command[0] != 0 : found " "
// host[0]    != 0 : found "\r\nHost: ....... \r\n"
struct http_parameters *findHttp(char *header, int headerindex, char *name)
{
	static struct http_parameters my_parms;
	struct http_parameters *parms = &my_parms;
	char   *c_start, *c_stop;
	
	parms->command[0] = 0;
	parms->host[0]    = 0;
	parms->index      = headerindex;
	
	if ( (c_stop = strstr(header, " ")) )
	{
		strncpy(parms->command, header, c_stop - header);
		c_start = c_stop + 1;
		parms->command[c_stop - header] = 0;
		
		if ( (c_stop = strstr(c_start, " ")) )
		{
		strncpy(parms->path, c_start, c_stop - c_start);
		parms->path[c_stop - c_start] = 0;
					
		if ( (c_start = strstr(c_stop, name)) )
		{
			c_start += strlen(name);
			if ( (c_stop = strstr(c_start, "\r")) )
			{
				strncpy(parms->host, c_start, c_stop - c_start);
				parms->host[c_stop - c_start] = 0;
			}
		}
		}
	}
	
	return parms;
}

// find payload (should limit range)
int findPayload(char *header, char *name)
{
	char   *c_stop;
	
	if ( (c_stop = strstr(header, name)) )
		return 1;
	else
		return -1;
}


// find http packet with same GET, daddr, dport, saddr
// headerindex is first packet index
int check_http_duplicate(int headerindex)
{
	char *curchar;
	struct connection *conn;
	int getlen = 0;
		
	//printf("find...\n");
	time_t curtime = headers[headerindex].timestamp;
	conn = &headers[headerindex].conn;
	curchar = strstr(headers[headerindex].header, " HTTP"); // do no include protocol version
	if (curchar)
	{
		getlen = curchar - headers[headerindex].header;
		//printf("find duplicate at %i len %i of %s\n", headerindex, getlen, headers[headerindex].header );
		// go to previous packet
		int i = (headerindex == 0) ? 99 : headerindex - 1;
		// find previous message from same connection
		do
		{
		//printf("   checking at %i\n", i);
		if ( strcmp(headers[i].conn.saddr, conn->saddr) == 0 &&
				strcmp(headers[i].conn.daddr, conn->daddr) == 0 &&
				headers[i].conn.dport == conn->dport            &&
				strncmp(headers[headerindex].header, headers[i].header, getlen) == 0 )
		{
			//printf("--> found duplicate at %i\n\n", i);
			return 1;
		}
		i = i == 0 ? 99 : i - 1;
		}
		while (i != headerindex && headers[i].timestamp > curtime - 2 );  // go back up to 2s
	}
	//printf("--> not found duplicate\n\n");
	return 0;
}

// find previous http packet from other side of conn
// headerindex is index of last stored *http* packet
struct http_parameters * request_traceback(int headerindex, struct connection *conn)
{
	//char *curchar;
	struct http_parameters *http_par = 0;
		
	//time_t curtime = time(0);
	
	int i = headerindex;
	
	// find previous message from same connection
	do
	{
		if ( (strcmp(headers[i].conn.saddr, conn->daddr)) == 0 &&
			(strcmp(headers[i].conn.daddr, conn->saddr)) == 0 &&
			(headers[i].conn.sport = conn->dport) &&
			(headers[i].conn.dport = conn->sport)                 )
		{
			http_par = splitHttp(headers[i].header, i);
			return http_par;
		}
		i = i == 0 ? 99 : i - 1;
	}
		while (i != headerindex);
	
	return http_par;
}


// find previous http packet with url in it: (part of) stream metafile
struct http_parameters * url_traceback(int headerindex, char *url)
{
	char *curchar;
	int urlsize = 0;
	struct http_parameters *http_par = 0;
		
	//time_t curtime = time(0);
	
	int i = headerindex;
	
	// find previous message from same connection
	do
	{
		// hack: only check for rtsp://host if default port 554 is included.
		urlsize = strlen(url);
		if ( (curchar = strchr(url, ':')) ) { curchar++; curchar = strchr(curchar, ':'); }
		if (curchar)
		{
		urlsize = curchar - url;
		//printf("Limiting search to %i chars of %s\n", urlsize, url);
		}
		//else printf("Searching for %s\n", url);
		
		if ( memmem(headers[i].header, headers[i].headerlen, url, urlsize ) != 0 )
		{
			//printf("found %s\n", url);
			http_par = request_traceback(i, &headers[i].conn);
			return http_par;
		}
		i = i == 0 ? 99 : i - 1;
	}
		while (i != headerindex);
		
	
	return http_par;
}





