#!/bin/sh
#for puppy 2.12+
#this script is run from createpuppy script.
#the passed-in parameter is the chosen kernel.
#2007 updated for 2.15
#v3.98 for new zdrv format, do not screen out modules with firmware.
#v4.01 new 2nd param 'zdrvinitcut', cutdown mods in initrd.

#v2.16 use this script to generate a list for a cutdown zdrv sfs file...
#a second param, 'zdrvcutdown'.

[ ! $1 ] && exit #precaution.
KERNVER="$1"
CURRDIR="`pwd`"
[ ! -d ./rootfs-complete ] && exit #precaution.

ZDRVCUT="$2" #v2.16

if [ "$ZDRVCUT" = "unipup" ];then
 SOURCEDIR="$CURRDIR/modules-complete/lib/modules/$KERNVER"
 FIRMWAREDIR="$CURRDIR/modules-complete/lib/modules/all-firmware"
else
 SOURCEDIR="$CURRDIR/kernels/$KERNVER/all-modules/lib/modules/$KERNVER"
 FIRMWAREDIR="$CURRDIR/kernels/$KERNVER/all-firmware"
fi
DESTDIR="$CURRDIR/rootfs-complete/lib/modules/$KERNVER"
INITRDDIR="$CURRDIR/boot/initrd-tree/lib/modules/$KERNVER"

if [ "$ZDRVCUT" = "" ];then
#wipe the default skeleton set...
#rm -rf $DESTDIR/*   no, do it in full, i'm paranoid...
rm -rf $CURRDIR/rootfs-complete/lib/modules/$KERNVER/*
sync
fi

EXCLMODS=""
if [ "$ZDRVCUT" != "zdrvinitcut" -a "$ZDRVCUT" != "unipup" ];then #v4.01
 #note that the modules in the initial ramdisk are copied into
 #rootfs-complete when puppy first boots, so need to exclude those.
 echo "Creating initrd exclusion list..."
 echo -n "" >/tmp/exclmods.txt
 find $INITRDDIR -type f -name *.ko* |
 while read ONEINITMOD
 do
  BASEMOD="`basename $ONEINITMOD .gz`"
  echo -n " $BASEMOD" >> /tmp/exclmods.txt
 done
 EXCLMODS="`cat /tmp/exclmods.txt`"
fi

cd $SOURCEDIR #makes it easier to handle 'find' results

#create a list of essential modules...
echo "Creating must-have-all lists..."
#want all the alsa sound mods...
SOUNDMODS="`find ./kernel/sound/ -type f | sed -e 's/^\.\///g'`"
#want all the firewall mods...
IPV4MODS="`find ./kernel/net/ipv4 -type f | sed -e 's/^\.\///g'`"
NETFILTERMODS="`find ./kernel/net/netfilter -type f | sed -e 's/^\.\///g'`"
#v3.93 want all the ieee80211 mods...
IEEE80211MODS="`find ./kernel/net/ieee80211 -type f | sed -e 's/^\.\///g'`"
#want all the network interface drivers...
NETWORKMODS="`find ./kernel/drivers/net -type f | sed -e 's/^\.\///g'`"
sync

#v2.16 include these...
[ -d ./extra ] && XTRAMODS1="`find ./extra -type f | sed -e 's/^\.\///g'`"
[ -d ./linux-wlan-ng ] && XTRAMODS2="`find ./linux-wlan-ng -type f | sed -e 's/^\.\///g'`"
[ -d ./ltmodem ] && XTRAMODS3="`find ./ltmodem -type f | sed -e 's/^\.\///g'`"
[ -d ./misc ] && XTRAMODS4="`find ./misc -type f | sed -e 's/^\.\///g'`"
#v3.02...
[ -d ./net ] && XTRAMODS5="`find ./net -type f | sed -e 's/^\.\///g'`"
[ -d ./r8180 ] && XTRAMODS6="`find ./r8180 -type f | sed -e 's/^\.\///g'`"
#v3.94...
[ -d ./slmodem ] && XTRAMODS7="`find ./slmodem -type f | sed -e 's/^\.\///g'`"
[ -d ./ralink ] && XTRAMODS8="`find ./ralink -type f | sed -e 's/^\.\///g'`"
[ -d ./pctel ] && XTRAMODS9="`find ./pctel -type f | sed -e 's/^\.\///g'`"
[ -d ./madwifi ] && XTRAMODS10="`find ./madwifi -type f | sed -e 's/^\.\///g'`"

#v3.90 include mmc/sd host drivers...
MMCMODS="`find ./kernel/drivers/mmc -type f | sed -e 's/^\.\///g'`"
#and this...
[ -d ./kernel/drivers/misc ] && MISCMODS="`find ./kernel/drivers/misc -type f | sed -e 's/^\.\///g'`"

#v404 add...
ACPIMODS="`find ./kernel/drivers/acpi -type f | sed -e 's/^\.\///g'`"
AGPMODS="`find ./kernel/drivers/char/agp -type f | sed -e 's/^\.\///g'`"

#exclude some entries from network list...
echo -n "" > /tmp/networkmods.txt
echo "$NETWORKMODS" |
while read ONENET
do
 #v4.01 removed kernel/drivers/net/irda|
 [ "`echo "$ONENET" | grep --extended-regexp  'kernel/drivers/net/wan'`" = "" ] && echo "$ONENET" >> /tmp/networkmods.txt
done
NETWORKMODS="`cat /tmp/networkmods.txt`"

#exclude some entries from sound list...
echo -n "" > /tmp/soundmods.txt
echo "$SOUNDMODS" |
while read ONESND
do
 #v3.93, a bit too much removing isa...
 #[ "`echo "$ONESND" | grep --extended-regexp  'kernel/sound/oss|kernel/sound/isa'`" = "" ] && echo "$ONESND" >> /tmp/soundmods.txt
 [ "`echo "$ONESND" | grep 'kernel/sound/oss'`" = "" ] && echo "$ONESND" >> /tmp/soundmods.txt
done
SOUNDMODS="`cat /tmp/soundmods.txt`"


#create a list of extra modules... v3.93 added cifs.ko... v404: ssb.ko, pl2303.ko, aufs.ko, serio_raw, output.ko
# ecb
echo "Creating extra list..."
EXTRALIST="blkcipher.ko cbc.ko apm.ko cdrom.ko mwave.ko synclink_cs.ko serial_cs.ko lp.ko n_hdlc.ko nvram.ko sonypi.ko generic_serial.ko agpgart.ko ali-agp.ko amd-k7-agp.ko amd64-agp.ko ati-agp.ko intel-agp.ko nvidia-agp.ko sis-agp.ko sworks-agp.ko via-agp.ko blowfish.ko aes.ko arc4.ko crc32c.ko deflate.ko des.ko md5.ko sha1.ko cramfs.ko ext3.ko fat.ko fuse.ko isofs.ko jbd.ko lockd.ko minix.ko msdos.ko nfs.ko nls_cp437.ko nls_iso8859-1.ko nls_iso8859-13.ko nls_iso8859-14.ko nls_iso8859-15.ko nls_iso8859-2.ko nls_iso8859-3.ko nls_iso8859-4.ko nls_iso8859-5.ko nls_iso8859-6.ko nls_iso8859-7.ko nls_iso8859-8.ko nls_iso8859-9.ko nls_utf8.ko ntfs.ko reiserfs.ko smbfs.ko squashfs.ko udf.ko unionfs.ko vfat.ko i2c-core.ko i2c-algo-bit.ko ide-cs.ko ide-tape.ko ide-cd.ko ide-floppy.ko gameport.ko analog.ko pcigame.ko pcspkr.ko psmouse.ko sermouse.ko serport.ko serio.ko evdev.ko joydev.ko input.ko keybdev.ko mousedev.ko crc32.ko crc-ccitt.ko libcrc32c.ko zlib_deflate.ko firmware_class.ko parport_pc.ko parport_serial.ko parport.ko parport_cs.ko i82365.ko pd6729.ko tcic.ko yenta_socket.ko i82092.ko rsrc_nonstatic.ko pcmcia_core.ko ds.ko imm.ko scsi_mod.ko scsi_transport_spi.ko sd_mod.ko sg.ko sr_mod.ko ide-scsi.ko scsi_debug.ko scsi_transport_fc.ko cdc-acm.ko usb-midi.ko usblp.ko audio.ko bluetty.ko usbcore.ko sl811-hcd.ko uhci-hcd.ko ehci-hcd.ko ohci-hcd.ko uhci.ko usb-ohci.ko usb-uhci.ko usbkbd.ko usbhid.ko hid.ko usbmouse.ko usbnet.ko ir-usb.ko usbserial.ko usb-storage.ko scanner.ko printer.ko fan.ko ibm_acpi.ko ac.ko battery.ko processor.ko thermal.ko paride.ko cryptoloop.ko pktcdvd.ko floppy.ko loop.ko 8250_pnp.ko serial_core.ko 8250.ko 8250_pci.ko intelfb.ko rivafb.ko sisfb.ko fbcon-vga-planes.ko fbcon-mfb.ko fbgen.ko mdacon.ko neofb.ko tridentfb.ko vgastate.ko vga16fb.ko ndiswrapper.ko ungrab-winmodem.ko cifs.ko ssb.ko pl2303.ko aufs.ko serio_raw.ko ecb.ko output.ko"
EXTRAMODS=""
for ONEMOD in $EXTRALIST
do
 ONEFND="`find ./ -type f -name $ONEMOD | sed -e 's/^\.\///g'`"
 if [ ! "$ONEFND" = "" ];then
  if [ "$EXTRAMODS" = "" ];then
   EXTRAMODS="$ONEFND"
  else
   EXTRAMODS="$EXTRAMODS
$ONEFND"
  fi
 fi
done

cd $CURRDIR #finished all the 'find' source operations.

#the total selection...
CHOSENMODS="$SOUNDMODS
$IPV4MODS
$NETFILTERMODS
$IEEE80211MODS
$NETWORKMODS
$XTRAMODS1
$XTRAMODS2
$XTRAMODS3
$XTRAMODS4
$XTRAMODS5
$XTRAMODS6
$XTRAMODS7
$XTRAMODS8
$XTRAMODS9
$XTRAMODS10
$EXTRAMODS
$MMCMODS
$ACPIMODS
$AGPMODS
$MISCMODS"

#v404 remove many firewall mods... nah, these are so small!...
#REMFIREWALL=" iptable_raw.ko  ipt_addrtype.ko ipt_ah.ko ipt_CLUSTERIP.ko ipt_ecn.ko ipt_ECN.ko ipt_MASQUERADE.ko ipt_NETMAP.ko ipt_recent.ko ipt_REDIRECT.ko ipt_ttl.ko ipt_TTL.ko ipt_ULOG.ko ipt_LOG.ko  nf_nat_amanda.ko nf_nat_ftp.ko nf_nat_h323.ko nf_nat_irc.ko nf_nat_pptp.ko nf_nat_proto_gre.ko nf_nat_sip.ko nf_nat_snmp_basic.ko nf_nat_tftp.ko nf_conntrack_netbios_ns.ko nf_conntrack_netlink.ko nf_conntrack_pptp.ko nf_conntrack_proto_gre.ko nf_conntrack_proto_udplite.ko nf_conntrack_sane.ko nf_conntrack_sip.ko nf_conntrack_tftp.ko nf_conntrack_amanda.ko nf_conntrack_h323.ko nf_conntrack_proto_sctp.ko  xt_CLASSIFY.ko xt_comment.ko xt_connbytes.ko xt_connlimit.ko xt_connmark.ko xt_CONNMARK.ko xt_conntrack.ko xt_dccp.ko xt_DSCP.ko xt_esp.ko xt_hashlimit.ko xt_helper.ko xt_iprange.ko xt_length.ko xt_limit.ko xt_mac.ko xt_MARK.ko xt_multiport.ko xt_NFLOG.ko xt_NFQUEUE.ko xt_NOTRACK.ko xt_owner.ko xt_physdev.ko xt_pkttype.ko xt_policy.ko xt_rateest.ko xt_RATEEST.ko xt_realm.ko xt_sctp.ko xt_statistic.ko xt_string.ko xt_TCPMSS.ko xt_time.ko xt_TRACE.ko xt_u32.ko xt_dscp.ko xt_mark.ko xt_quota.ko xt_tcpmss.ko  ip_gre.ko ip_queue.ko"
#echo -n "" > /tmp/chosenmods.txt
#echo "$CHOSENMODS" |
#while read ONEMOD
#do
# [ "$ONEMOD" = "" ] && continue #empty line.
# ONEBASE="`basename $ONEMOD`"
# aPATTERN=" $ONEBASE"
# if [ "`echo "$REMFIREWALL" | grep "$aPATTERN"`" = "" ];then
#  echo "$ONEMOD" >> /tmp/chosenmods.txt
# fi
#done
#sync
#CHOSENMODS="`cat /tmp/chosenmods.txt`"

#v3.98 with new zdrv format, don't think need to screen out firmware...
#if [ "$ZDRVCUT" = "" ];then
# #remove modules that require firmware (users will need zdrv file to access
# #these modules and firmware)...
# echo "Removing modules that require firmware..."
# OUTMODS="`cat $FIRMWAREDIR/../firmware.dep.$KERNVER | cut -f 2 -d ':' | tr ',' ' ' | tr '\n' ' '`"
# echo -n "" > /tmp/chosenmods.txt
# echo "$CHOSENMODS" |
# while read ONEMOD
# do
#  [ "$ONEMOD" = "" ] && continue #empty line.
#  ONEBASE="`basename $ONEMOD`"
#  if [ "`echo "$OUTMODS" | grep " $ONEBASE "`" = "" ];then
#   echo "$ONEMOD" >> /tmp/chosenmods.txt
#  else
#   echo "Removing $ONEBASE"
#  fi
# done
# sync
# CHOSENMODS="`cat /tmp/chosenmods.txt`"
#else
 echo "$CHOSENMODS" | tr -s '\n' > /tmp/chosenmods.txt
#fi

#make sure have all dependent modules...
echo "Finding all dependent modules..."
echo -n "" > /tmp/alldeps.txt
echo "$CHOSENMODS" |
while read ONEMOD
do
 [ "$ONEMOD" = "" ] && continue #precaution
 ONEBASE="`basename $ONEMOD`"
 DPATTERN="/${ONEBASE}:"
 PPATTERN="s/^\/lib\/modules\/${KERNVER}\///g"
 ONEDEPS="`cat $SOURCEDIR/modules.dep | grep "$DPATTERN" | cut -f 2 -d ':' | tr ' ' '\n' | sed -e "$PPATTERN"`"
 if [ ! "$ONEDEPS" = "" ];then
  echo "$ONEDEPS" >> /tmp/alldeps.txt
 fi
done
sync
sort -u /tmp/alldeps.txt > /tmp/alldepssorted.txt #remove duplicate lines.
sync

cat /tmp/alldepssorted.txt >> /tmp/chosenmods.txt
sync
sort -u /tmp/chosenmods.txt > /tmp/allmodssorted.txt
sync

if [ "$ZDRVCUT" = "unipup" ];then
 cat /tmp/allmodssorted.txt |
 while read ONEMOD
 do
  [ "$ONEMOD" = "" ] && continue #precaution
  ONEDIR="`dirname $ONEMOD`"
  mkdir -p $DESTDIR/$ONEDIR
  cp -a -f $SOURCEDIR/$ONEMOD $DESTDIR/$ONEDIR/
 done
 exit #NOTE, EXITING HERE!
fi
##################

if [ "$ZDRVCUT" != "" ];then
 #make up the final list...
 echo -n "" > /tmp/zdrvcutdown.list
 cat /tmp/allmodssorted.txt |
 while read ONEMOD
 do
  [ "$ONEMOD" = "" ] && continue #precaution
  ONEBASE="`basename $ONEMOD`"
  ONEDIR="`dirname $ONEMOD`"
  if [ "`echo "$EXCLMODS" | grep " $ONEBASE"`" = "" ];then
   echo "$ONEMOD" >> /tmp/zdrvcutdown.list
  fi
 done
 exit #NOTE, EXITING HERE!
fi
###################

#copy them to the DESTDIR, but exclude EXCLMODS...
echo "Copying modules to rootfs-complete..."
cat /tmp/allmodssorted.txt |
while read ONEMOD
do
 [ "$ONEMOD" = "" ] && continue #precaution
 ONEBASE="`basename $ONEMOD`"
 ONEDIR="`dirname $ONEMOD`"
 if [ "`echo "$EXCLMODS" | grep " $ONEBASE"`" = "" ];then
  mkdir -p $DESTDIR/$ONEDIR
  cp -a -f $SOURCEDIR/$ONEMOD $DESTDIR/$ONEDIR/
 fi
done


#netprotocol/802/p8022.ko
#netprotocol/802/psnap.ko
#netprotocol/8021q/8021q.ko
#netprotocol/sunrpc/sunrpc.ko
#netprotocol/ieee80211/ieee80211.ko
#netprotocol/ieee80211/ieee80211_crypt.ko
#netprotocol/ieee80211/ieee80211_crypt_ccmp.ko
#netprotocol/ieee80211/ieee80211_crypt_tkip.ko
#netprotocol/ieee80211/ieee80211_crypt_wep.ko
#netprotocol/llc/llc.ko


echo
echo "The module config files in rootfs-complete/ need to be updated..."
#we need to copy across the initrd modules then remove them...
cp -a $INITRDDIR $DESTDIR/initrd
gunzip $DESTDIR/initrd/*.gz
gunzip $DESTDIR/initrd/*/*.gz
#note, depmod ignores folders that are symlinks.
depmod -b $CURRDIR/rootfs-complete -a -e -F $CURRDIR/kernels/$KERNVER/System.map $KERNVER
rm -rf $DESTDIR/initrd
echo "...done"


#what about firmware and post-install scripts...
#TODO


#END#
